from trl import SFTConfig

def get_training_args(
        output_dir: str,
        train_batch_size: int = 16,
        eval_batch_size: int = 16,
        gradient_checkpointing: bool = True,
        gradient_accumulation_steps: int = 4,
        bf16: bool = True,
        learning_rate: float = 5e-5,
        optim: str = 'paged_adamw_32bit',
        lr_scheduler_type: str = 'cosine',
        max_grad_norm: float = 0.3,
        max_steps: int = 100,
        warmup_steps: int = 20,
        eval_steps: int = 1,
        save_strategy: str = 'steps',
        eval_strategy: str = 'steps',
        save_steps: int = 1,
        logging_steps: int = 1,
        save_total_limit: int = 3, 
        load_best_model_at_end: bool = True, 
        overwrite_output_dir: bool = True,
        report_to: str = 'none',
        seed: int = 3407,
        data_seed: int = 3407,
        max_seq_length: int = 512,
        dataset_text_field: str = "text",
        dataloader_num_workers: int = 16,
        packing: bool = True, 
        remove_unused_columns: bool = False,
        neftune_noise_alpha: int = 5,
        use_liger: bool = True,
    ):

    return SFTConfig(
            per_device_train_batch_size=train_batch_size,
            per_device_eval_batch_size=eval_batch_size,
            gradient_checkpointing=gradient_checkpointing, 
            gradient_accumulation_steps=gradient_accumulation_steps,
            remove_unused_columns=remove_unused_columns,
            learning_rate=learning_rate,
            lr_scheduler_type=lr_scheduler_type,
            max_steps=max_steps, 
            save_strategy=save_strategy,
            eval_strategy=eval_strategy,
            eval_steps=eval_steps,
            logging_steps=logging_steps,
            output_dir=output_dir,
            save_steps=save_steps,
            overwrite_output_dir=overwrite_output_dir,
            optim=optim,
            max_grad_norm=max_grad_norm,
            bf16=bf16,
            warmup_steps=warmup_steps,
            report_to=report_to,
            max_seq_length=max_seq_length,
            dataloader_num_workers=dataloader_num_workers,
            load_best_model_at_end=load_best_model_at_end,
            save_total_limit=save_total_limit,
            seed=seed,
            data_seed=data_seed,
            neftune_noise_alpha=neftune_noise_alpha,
            use_liger=use_liger,
            packing=packing, 
            dataset_text_field=dataset_text_field,
            metric_for_best_model="eval_loss"
        )