# RDM Testbench

This testbench is designed for RDM + Mapping + Buddy integration testing.
The packet format is described at `app/rdma/README.md`.

This RDM supports:
- Alloc
- Read
- Write

## For MAC

About `input.txt`:

Alloc packet with the opcode=3
```
16
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
1000000000000000 FF
0000000000100003 FF (last byte, opcode=3, alloc)
0000000000002000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
```

Read packet with the opcode=0
```
16
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
1000000000000000 FF
0000000000100000 FF (last byte, opcode=0, read)
0000000000010000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
0000000000000000 FF
```

## For PCIe

PCIe controller's AXI-Stream is 256bits wide.
So each single line in the `input_pcie.txt` will have 64B, or 256b.


Alloc: opcode = 3, length=0x2000
```
4
0000000000000000000000000000000000000000112233445566aabbccddeeff
00000000000000000000000000000000000000000000000000000000000000ff
0000000000000000000000000000000000000000002000000000000000000003 // opcode 3, alloc
0000000000000000000000000000000000000000000000000000000000000000
```

Read: opcode=0, VA=0x1000, length = 0x40
```
4
0000000000000000000000000000000000000000112233445566aabbccddeeff
00000000000000000000000000000000000000000000000000000000000000ff
0000000000000000000000000000000000000000000040000000000000100000 // opcode 0, read
0000000000000000000000000000000000000000000000000000000000000000
```

Write: opcode=1, VA=0x1000, length = 0x40
```
6
0000000000000000000000000000000000000000112233445566aabbccddeeff
00000000000000000000000000000000000000000000000000000000000000ff
0000000000000000000000000000000000000000000040000000000000100001
0000000000000000000000000000000000000000000000000000000000000000
1231111111111111111111111111122222222222222222211111111111111111
aaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbcc1122aaadddddeee
```
