//-----------------------------------------------------------------------------
//
// (c) Copyright 2012-2012 Xilinx, Inc. All rights reserved.
//
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
//
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
//
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
//
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES.
//
//-----------------------------------------------------------------------------
//
// Project    : The Xilinx PCI Express DMA 
// File       : pcie3_uscale_rp_core_top.v
// Version    : 4.1
//-----------------------------------------------------------------------------

/////////////////////////////////////////////////////////////////////////////

`timescale 1ps/1ps

`define rp_gt_MAX_NUM_CHANNELS 192
`define rp_gt_MAX_NUM_COMMONS 48
`define rp_gt_N_CM C_TOTAL_NUM_COMMONS
`define rp_gt_N_CH C_TOTAL_NUM_CHANNELS
`define rp_gt_SF_CM C_COMMON_SCALING_FACTOR
`define rp_gt_FORCE_COMMONS__DO_NOT_FORCE 0
`define rp_gt_FORCE_COMMONS__FORCE 1
`define rp_gt_GT_TYPE__GTHE3 0
`define rp_gt_GT_TYPE__GTYE3 1
`define rp_gt_GT_TYPE__GTHE4 2
`define rp_gt_GT_TYPE__GTYE4 3
`define rp_gt_INCLUDE_CPLL_CAL__EXCLUDE 0
`define rp_gt_INCLUDE_CPLL_CAL__INCLUDE 1
`define rp_gt_INCLUDE_CPLL_CAL__DEPENDENT 2
`define rp_gt_LOCATE_COMMON__CORE 0
`define rp_gt_LOCATE_COMMON__EXAMPLE_DESIGN 1
`define rp_gt_LOCATE_RESET_CONTROLLER__CORE 0
`define rp_gt_LOCATE_RESET_CONTROLLER__EXAMPLE_DESIGN 1
`define rp_gt_LOCATE_USER_DATA_WIDTH_SIZING__CORE 0
`define rp_gt_LOCATE_USER_DATA_WIDTH_SIZING__EXAMPLE_DESIGN 1
`define rp_gt_LOCATE_RX_BUFFER_BYPASS_CONTROLLER__CORE 0
`define rp_gt_LOCATE_RX_BUFFER_BYPASS_CONTROLLER__EXAMPLE_DESIGN 1
`define rp_gt_LOCATE_IN_SYSTEM_IBERT_CORE__EXAMPLE_DESIGN 1
`define rp_gt_LOCATE_IN_SYSTEM_IBERT_CORE__NONE 2
`define rp_gt_LOCATE_RX_USER_CLOCKING__CORE 0
`define rp_gt_LOCATE_RX_USER_CLOCKING__EXAMPLE_DESIGN 1
`define rp_gt_LOCATE_TX_BUFFER_BYPASS_CONTROLLER__CORE 0
`define rp_gt_LOCATE_TX_BUFFER_BYPASS_CONTROLLER__EXAMPLE_DESIGN 1
`define rp_gt_LOCATE_TX_USER_CLOCKING__CORE 0
`define rp_gt_LOCATE_TX_USER_CLOCKING__EXAMPLE_DESIGN 1
`define rp_gt_RESET_CONTROLLER_INSTANCE_CTRL__SINGLE_INSTANCE 0
`define rp_gt_RESET_CONTROLLER_INSTANCE_CTRL__PER_CHANNEL 0
`define rp_gt_RX_BUFFBYPASS_MODE__AUTO 0
`define rp_gt_RX_BUFFBYPASS_MODE__MANUAL 1
`define rp_gt_RX_BUFFER_BYPASS_INSTANCE_CTRL__SINGLE_INSTANCE 0
`define rp_gt_RX_BUFFER_BYPASS_INSTANCE_CTRL__PER_CHANNEL 1
`define rp_gt_RX_BUFFER_MODE__BYPASS 0
`define rp_gt_RX_BUFFER_MODE__USE 1
`define rp_gt_RX_CC_ENABLE__DISABLED 0
`define rp_gt_RX_CC_ENABLE__ENABLED 1
`define rp_gt_RX_COMMA_M_ENABLE__DISABLED 0
`define rp_gt_RX_COMMA_M_ENABLE__ENABLED 1
`define rp_gt_RX_COMMA_P_ENABLE__DISABLED 0
`define rp_gt_RX_COMMA_P_ENABLE__ENABLED 1
`define rp_gt_RX_DATA_DECODING__RAW 0
`define rp_gt_RX_DATA_DECODING__8B10B 1
`define rp_gt_RX_DATA_DECODING__64B66B 2
`define rp_gt_RX_DATA_DECODING__64B66B_CAUI 3
`define rp_gt_RX_DATA_DECODING__64B66B_ASYNC 4
`define rp_gt_RX_DATA_DECODING__64B66B_ASYNC_CAUI 5
`define rp_gt_RX_DATA_DECODING__64B67B 6
`define rp_gt_RX_DATA_DECODING__64B67B_CAUI 7
`define rp_gt_RX_DATA_DECODING__128B130B 10
`define rp_gt_RX_ENABLE__DISABLED 0
`define rp_gt_RX_ENABLE__ENABLED 1
`define rp_gt_RX_OUTCLK_SOURCE__RXOUTCLKPCS 0
`define rp_gt_RX_OUTCLK_SOURCE__RXOUTCLKPMA 1
`define rp_gt_RX_OUTCLK_SOURCE__RXPLLREFCLK_DIV1 2
`define rp_gt_RX_OUTCLK_SOURCE__RXPLLREFCLK_DIV2 3
`define rp_gt_RX_OUTCLK_SOURCE__RXPROGDIVCLK 4
`define rp_gt_RX_PLL_TYPE__QPLL0 0
`define rp_gt_RX_PLL_TYPE__QPLL1 1
`define rp_gt_RX_PLL_TYPE__CPLL 2
`define rp_gt_RX_SLIDE_MODE__OFF 0
`define rp_gt_RX_SLIDE_MODE__PCS 1
`define rp_gt_RX_SLIDE_MODE__PMA 2
`define rp_gt_RX_SLIDE_MODE__AUTO 3
`define rp_gt_RX_USER_CLOCKING_CONTENTS__BUFG_GT 0
`define rp_gt_RX_USER_CLOCKING_CONTENTS__BUFG 1
`define rp_gt_RX_USER_CLOCKING_CONTENTS__MMCM 2
`define rp_gt_RX_USER_CLOCKING_INSTANCE_CTRL__SINGLE_INSTANCE 0
`define rp_gt_RX_USER_CLOCKING_INSTANCE_CTRL__PER_CHANNEL 1
`define rp_gt_RX_USER_CLOCKING_SOURCE__RXOUTCLK 0
`define rp_gt_RX_USER_CLOCKING_SOURCE__IBUFDS 1
`define rp_gt_RX_USER_CLOCKING_SOURCE__TXOUTCLK 2
`define rp_gt_SECONDARY_QPLL_ENABLE__DISABLED 0
`define rp_gt_SECONDARY_QPLL_ENABLE__ENABLED 1
`define rp_gt_TXPROGDIV_FREQ_ENABLE__DISABLED 0
`define rp_gt_TXPROGDIV_FREQ_ENABLE__ENABLED 1
`define rp_gt_TXPROGDIV_FREQ_SOURCE__QPLL0 0
`define rp_gt_TXPROGDIV_FREQ_SOURCE__QPLL1 1
`define rp_gt_TXPROGDIV_FREQ_SOURCE__CPLL 2
`define rp_gt_TX_BUFFBYPASS_MODE__AUTO 0
`define rp_gt_TX_BUFFBYPASS_MODE__MANUAL 1
`define rp_gt_TX_BUFFER_BYPASS_INSTANCE_CTRL__SINGLE_INSTANCE 0
`define rp_gt_TX_BUFFER_BYPASS_INSTANCE_CTRL__PER_CHANNEL 1
`define rp_gt_TX_BUFFER_MODE__BYPASS 0
`define rp_gt_TX_BUFFER_MODE__USE 1
`define rp_gt_TX_DATA_ENCODING__RAW 0
`define rp_gt_TX_DATA_ENCODING__8B10B 1
`define rp_gt_TX_DATA_ENCODING__64B66B 2
`define rp_gt_TX_DATA_ENCODING__64B66B_CAUI 3
`define rp_gt_TX_DATA_ENCODING__64B66B_ASYNC 4
`define rp_gt_TX_DATA_ENCODING__64B66B_ASYNC_CAUI 5
`define rp_gt_TX_DATA_ENCODING__64B67B 6
`define rp_gt_TX_DATA_ENCODING__64B67B_CAUI 7
`define rp_gt_TX_DATA_ENCODING__128B130B 10
`define rp_gt_TX_ENABLE__DISABLED 0
`define rp_gt_TX_ENABLE__ENABLED 1
`define rp_gt_TX_OUTCLK_SOURCE__TXOUTCLKPCS 0
`define rp_gt_TX_OUTCLK_SOURCE__TXOUTCLKPMA 1
`define rp_gt_TX_OUTCLK_SOURCE__TXPLLREFCLK_DIV1 2
`define rp_gt_TX_OUTCLK_SOURCE__TXPLLREFCLK_DIV2 3
`define rp_gt_TX_OUTCLK_SOURCE__TXPROGDIVCLK 4
`define rp_gt_TX_PLL_TYPE__QPLL0 0
`define rp_gt_TX_PLL_TYPE__QPLL1 1
`define rp_gt_TX_PLL_TYPE__CPLL 2
`define rp_gt_TX_USER_CLOCKING_CONTENTS__BUFG_GT 0
`define rp_gt_TX_USER_CLOCKING_CONTENTS__BUFG 1
`define rp_gt_TX_USER_CLOCKING_CONTENTS__MMCM 2
`define rp_gt_TX_USER_CLOCKING_INSTANCE_CTRL__SINGLE_INSTANCE 0
`define rp_gt_TX_USER_CLOCKING_INSTANCE_CTRL__PER_CHANNEL 1
`define rp_gt_TX_USER_CLOCKING_SOURCE__TXOUTCLK 0
`define rp_gt_TX_USER_CLOCKING_SOURCE__IBUFDS 1

`define rp_gt_gtwizard_gthe3_MAX_NUM_CHANNELS 192
`define rp_gt_gtwizard_gthe3_MAX_NUM_COMMONS 48
`define rp_gt_gtwizard_gthe3_N_CM C_TOTAL_NUM_COMMONS
`define rp_gt_gtwizard_gthe3_N_CH C_TOTAL_NUM_CHANNELS
`define rp_gt_gtwizard_gthe3_SF_CM C_COMMON_SCALING_FACTOR
`define rp_gt_gtwizard_gthe3_INCLUDE_CPLL_CAL__EXCLUDE 0
`define rp_gt_gtwizard_gthe3_INCLUDE_CPLL_CAL__INCLUDE 1
`define rp_gt_gtwizard_gthe3_INCLUDE_CPLL_CAL__DEPENDENT 2
`define rp_gt_gtwizard_gthe3_LOCATE_RESET_CONTROLLER__CORE 0
`define rp_gt_gtwizard_gthe3_LOCATE_RESET_CONTROLLER__EXAMPLE_DESIGN 1
`define rp_gt_gtwizard_gthe3_LOCATE_USER_DATA_WIDTH_SIZING__CORE 0
`define rp_gt_gtwizard_gthe3_LOCATE_USER_DATA_WIDTH_SIZING__EXAMPLE_DESIGN 1
`define rp_gt_gtwizard_gthe3_LOCATE_RX_BUFFER_BYPASS_CONTROLLER__CORE 0
`define rp_gt_gtwizard_gthe3_LOCATE_RX_BUFFER_BYPASS_CONTROLLER__EXAMPLE_DESIGN 1
`define rp_gt_gtwizard_gthe3_LOCATE_RX_USER_CLOCKING__CORE 0
`define rp_gt_gtwizard_gthe3_LOCATE_RX_USER_CLOCKING__EXAMPLE_DESIGN 1
`define rp_gt_gtwizard_gthe3_LOCATE_TX_BUFFER_BYPASS_CONTROLLER__CORE 0
`define rp_gt_gtwizard_gthe3_LOCATE_TX_BUFFER_BYPASS_CONTROLLER__EXAMPLE_DESIGN 1
`define rp_gt_gtwizard_gthe3_LOCATE_TX_USER_CLOCKING__CORE 0
`define rp_gt_gtwizard_gthe3_LOCATE_TX_USER_CLOCKING__EXAMPLE_DESIGN 1
`define rp_gt_gtwizard_gthe3_RESET_CONTROLLER_INSTANCE_CTRL__SINGLE_INSTANCE 0
`define rp_gt_gtwizard_gthe3_RESET_CONTROLLER_INSTANCE_CTRL__PER_CHANNEL 0
`define rp_gt_gtwizard_gthe3_RX_BUFFBYPASS_MODE__AUTO 0
`define rp_gt_gtwizard_gthe3_RX_BUFFBYPASS_MODE__MANUAL 1
`define rp_gt_gtwizard_gthe3_RX_BUFFER_BYPASS_INSTANCE_CTRL__SINGLE_INSTANCE 0
`define rp_gt_gtwizard_gthe3_RX_BUFFER_BYPASS_INSTANCE_CTRL__PER_CHANNEL 1
`define rp_gt_gtwizard_gthe3_RX_BUFFER_MODE__BYPASS 0
`define rp_gt_gtwizard_gthe3_RX_BUFFER_MODE__USE 1
`define rp_gt_gtwizard_gthe3_RX_DATA_DECODING__RAW 0
`define rp_gt_gtwizard_gthe3_RX_DATA_DECODING__8B10B 1
`define rp_gt_gtwizard_gthe3_RX_DATA_DECODING__64B66B 2
`define rp_gt_gtwizard_gthe3_RX_DATA_DECODING__64B66B_CAUI 3
`define rp_gt_gtwizard_gthe3_RX_DATA_DECODING__64B66B_ASYNC 4
`define rp_gt_gtwizard_gthe3_RX_DATA_DECODING__64B66B_ASYNC_CAUI 5
`define rp_gt_gtwizard_gthe3_RX_DATA_DECODING__64B67B 6
`define rp_gt_gtwizard_gthe3_RX_DATA_DECODING__64B67B_CAUI 7
`define rp_gt_gtwizard_gthe3_RX_DATA_DECODING__128B130B 10
`define rp_gt_gtwizard_gthe3_RX_ENABLE__DISABLED 0
`define rp_gt_gtwizard_gthe3_RX_ENABLE__ENABLED 1
`define rp_gt_gtwizard_gthe3_RX_PLL_TYPE__QPLL0 0
`define rp_gt_gtwizard_gthe3_RX_PLL_TYPE__QPLL1 1
`define rp_gt_gtwizard_gthe3_RX_PLL_TYPE__CPLL 2
`define rp_gt_gtwizard_gthe3_RX_USER_CLOCKING_CONTENTS__BUFG_GT 0
`define rp_gt_gtwizard_gthe3_RX_USER_CLOCKING_CONTENTS__BUFG 1
`define rp_gt_gtwizard_gthe3_RX_USER_CLOCKING_CONTENTS__MMCM 2
`define rp_gt_gtwizard_gthe3_RX_USER_CLOCKING_INSTANCE_CTRL__SINGLE_INSTANCE 0
`define rp_gt_gtwizard_gthe3_RX_USER_CLOCKING_INSTANCE_CTRL__PER_CHANNEL 1
`define rp_gt_gtwizard_gthe3_RX_USER_CLOCKING_SOURCE__RXOUTCLK 0
`define rp_gt_gtwizard_gthe3_RX_USER_CLOCKING_SOURCE__IBUFDS 1
`define rp_gt_gtwizard_gthe3_RX_USER_CLOCKING_SOURCE__TXOUTCLK 2
`define rp_gt_gtwizard_gthe3_TXPROGDIV_FREQ_ENABLE__DISABLED 0
`define rp_gt_gtwizard_gthe3_TXPROGDIV_FREQ_ENABLE__ENABLED 1
`define rp_gt_gtwizard_gthe3_TXPROGDIV_FREQ_SOURCE__QPLL0 0
`define rp_gt_gtwizard_gthe3_TXPROGDIV_FREQ_SOURCE__QPLL1 1
`define rp_gt_gtwizard_gthe3_TXPROGDIV_FREQ_SOURCE__CPLL 2
`define rp_gt_gtwizard_gthe3_TX_BUFFBYPASS_MODE__AUTO 0
`define rp_gt_gtwizard_gthe3_TX_BUFFBYPASS_MODE__MANUAL 1
`define rp_gt_gtwizard_gthe3_TX_BUFFER_BYPASS_INSTANCE_CTRL__SINGLE_INSTANCE 0
`define rp_gt_gtwizard_gthe3_TX_BUFFER_BYPASS_INSTANCE_CTRL__PER_CHANNEL 1
`define rp_gt_gtwizard_gthe3_TX_BUFFER_MODE__BYPASS 0
`define rp_gt_gtwizard_gthe3_TX_BUFFER_MODE__USE 1
`define rp_gt_gtwizard_gthe3_TX_DATA_ENCODING__RAW 0
`define rp_gt_gtwizard_gthe3_TX_DATA_ENCODING__8B10B 1
`define rp_gt_gtwizard_gthe3_TX_DATA_ENCODING__64B66B 2
`define rp_gt_gtwizard_gthe3_TX_DATA_ENCODING__64B66B_CAUI 3
`define rp_gt_gtwizard_gthe3_TX_DATA_ENCODING__64B66B_ASYNC 4
`define rp_gt_gtwizard_gthe3_TX_DATA_ENCODING__64B66B_ASYNC_CAUI 5
`define rp_gt_gtwizard_gthe3_TX_DATA_ENCODING__64B67B 6
`define rp_gt_gtwizard_gthe3_TX_DATA_ENCODING__64B67B_CAUI 7
`define rp_gt_gtwizard_gthe3_TX_DATA_ENCODING__128B130B 10
`define rp_gt_gtwizard_gthe3_TX_ENABLE__DISABLED 0
`define rp_gt_gtwizard_gthe3_TX_ENABLE__ENABLED 1
`define rp_gt_gtwizard_gthe3_TX_PLL_TYPE__QPLL0 0
`define rp_gt_gtwizard_gthe3_TX_PLL_TYPE__QPLL1 1
`define rp_gt_gtwizard_gthe3_TX_PLL_TYPE__CPLL 2
`define rp_gt_gtwizard_gthe3_TX_USER_CLOCKING_CONTENTS__BUFG_GT 0
`define rp_gt_gtwizard_gthe3_TX_USER_CLOCKING_CONTENTS__BUFG 1
`define rp_gt_gtwizard_gthe3_TX_USER_CLOCKING_CONTENTS__MMCM 2
`define rp_gt_gtwizard_gthe3_TX_USER_CLOCKING_INSTANCE_CTRL__SINGLE_INSTANCE 0
`define rp_gt_gtwizard_gthe3_TX_USER_CLOCKING_INSTANCE_CTRL__PER_CHANNEL 1
`define rp_gt_gtwizard_gthe3_TX_USER_CLOCKING_SOURCE__TXOUTCLK 0
`define rp_gt_gtwizard_gthe3_TX_USER_CLOCKING_SOURCE__IBUFDS 1


(* DowngradeIPIdentifiedWarnings = "yes" *)

module rp_pcie3_uscale_core_top 
#(
  parameter  PL_LINK_CAP_MAX_LINK_SPEED = 3'h4,
  parameter  PL_LINK_CAP_MAX_LINK_WIDTH = 4'h8,
  parameter  USER_CLK_FREQ = 3,
  parameter  CORE_CLK_FREQ = 2,
  parameter  integer PF0_LINK_CAP_ASPM_SUPPORT = 0,
  parameter  C_DATA_WIDTH = 256,
  parameter  REF_CLK_FREQ = 0,
  parameter  PCIE_LINK_SPEED = 3,
  parameter  KEEP_WIDTH = 8,
  parameter  ARI_CAP_ENABLE = "FALSE",
  parameter  PF0_ARI_CAP_NEXT_FUNC = 8'h00,
  parameter  AXISTEN_IF_CC_ALIGNMENT_MODE = "FALSE",
  parameter  AXISTEN_IF_CQ_ALIGNMENT_MODE = "FALSE",
  parameter  AXISTEN_IF_RC_ALIGNMENT_MODE = "FALSE",
  parameter  AXISTEN_IF_RC_STRADDLE = "FALSE",
  parameter  AXISTEN_IF_RQ_ALIGNMENT_MODE = "FALSE",
  parameter  PF0_AER_CAP_ECRC_CHECK_CAPABLE = "FALSE",
  parameter  PF0_AER_CAP_ECRC_GEN_CAPABLE = "FALSE",
  parameter  PF0_AER_CAP_NEXTPTR = 12'h000,
  parameter  PF0_ARI_CAP_NEXTPTR = 12'h000,
  parameter  VF0_ARI_CAP_NEXTPTR = 12'h000,
  parameter  VF1_ARI_CAP_NEXTPTR = 12'h000,
  parameter  VF2_ARI_CAP_NEXTPTR = 12'h000,
  parameter  VF3_ARI_CAP_NEXTPTR = 12'h000,
  parameter  VF4_ARI_CAP_NEXTPTR = 12'h000,
  parameter  VF5_ARI_CAP_NEXTPTR = 12'h000,
  parameter  PF0_BAR0_APERTURE_SIZE = 5'h03,
  parameter  PF0_BAR0_CONTROL = 3'h4,
  parameter  PF0_BAR1_APERTURE_SIZE = 5'h00,
  parameter  PF0_BAR1_CONTROL = 3'h0,
  parameter  PF0_BAR2_APERTURE_SIZE = 5'h03,
  parameter  PF0_BAR2_CONTROL = 3'h4,
  parameter  PF0_BAR3_APERTURE_SIZE = 5'h03,
  parameter  PF0_BAR3_CONTROL = 3'h0,
  parameter  PF0_BAR4_APERTURE_SIZE = 5'h03,
  parameter  PF0_BAR4_CONTROL = 3'h4,
  parameter  PF0_BAR5_APERTURE_SIZE = 5'h03,
  parameter  PF0_BAR5_CONTROL = 3'h0,
  parameter  PF0_CAPABILITY_POINTER = 8'h50,
  parameter  PF0_CLASS_CODE = 24'h000000,
  parameter  PF0_VENDOR_ID = 16'h0000,
  parameter  PF0_DEVICE_ID = 16'h0000,
  parameter  PF0_DEV_CAP2_128B_CAS_ATOMIC_COMPLETER_SUPPORT = "TRUE",
  parameter  PF0_DEV_CAP2_32B_ATOMIC_COMPLETER_SUPPORT = "TRUE",
  parameter  PF0_DEV_CAP2_64B_ATOMIC_COMPLETER_SUPPORT = "TRUE",
  parameter  PF0_DEV_CAP2_LTR_SUPPORT = "TRUE",
  parameter  PF0_DEV_CAP2_OBFF_SUPPORT = 2'h0,
  parameter  PF0_DEV_CAP2_TPH_COMPLETER_SUPPORT = "FALSE",
  parameter  PF0_DEV_CAP_EXT_TAG_SUPPORTED = "TRUE",
  parameter  PF0_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE = "TRUE",
  parameter  PF0_DEV_CAP_MAX_PAYLOAD_SIZE = 3'h3,
  parameter  PF0_DPA_CAP_NEXTPTR = 12'h000,
  parameter  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 = 8'h00,
  parameter  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 = 8'h00,
  parameter  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 = 8'h00,
  parameter  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 = 8'h00,
  parameter  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 = 8'h00,
  parameter  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 = 8'h00,
  parameter  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 = 8'h00,
  parameter  PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 = 8'h00,
  parameter  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 = 8'h00,
  parameter  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 = 8'h00,
  parameter  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 = 8'h00,
  parameter  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 = 8'h00,
  parameter  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 = 8'h00,
  parameter  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 = 8'h00,
  parameter  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 = 8'h00,
  parameter  PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 = 8'h00,
  parameter  PF0_DSN_CAP_NEXTPTR = 12'h10c,
  parameter  PF0_EXPANSION_ROM_APERTURE_SIZE = 5'h03,
  parameter  PF0_EXPANSION_ROM_ENABLE = "FALSE",
  parameter  PF0_INTERRUPT_PIN = 3'h1,
  parameter  PF0_LINK_STATUS_SLOT_CLOCK_CONFIG = "TRUE",
  parameter  PF0_LTR_CAP_NEXTPTR = 12'h000,
  parameter  PF0_MSIX_CAP_NEXTPTR = 8'h00,
  parameter  integer PF0_MSIX_CAP_PBA_BIR = 0,
  parameter  PF0_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter  integer PF0_MSIX_CAP_TABLE_BIR = 0,
  parameter  PF0_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter  PF0_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter  integer PF0_MSI_CAP_MULTIMSGCAP = 0,
  parameter  PF0_MSI_CAP_NEXTPTR = 8'h00,
  parameter  PF0_PB_CAP_NEXTPTR = 12'h000,
  parameter  PF0_PM_CAP_NEXTPTR = 8'h00,
  parameter  PF0_PM_CAP_PMESUPPORT_D0 = "TRUE",
  parameter  PF0_PM_CAP_PMESUPPORT_D1 = "TRUE",
  parameter  PF0_PM_CAP_PMESUPPORT_D3HOT = "TRUE",
  parameter  PF0_PM_CAP_SUPP_D1_STATE = "TRUE",
  parameter  PF0_RBAR_CAP_ENABLE = "FALSE",
  parameter  PF0_RBAR_CAP_NEXTPTR = 12'h000,
  parameter  PF0_RBAR_CAP_SIZE0 = 20'h00000,
  parameter  PF0_RBAR_CAP_SIZE1 = 20'h00000,
  parameter  PF0_RBAR_CAP_SIZE2 = 20'h00000,
  parameter  PF1_RBAR_CAP_SIZE0 = 20'h00000,
  parameter  PF1_RBAR_CAP_SIZE1 = 20'h00000,
  parameter  PF1_RBAR_CAP_SIZE2 = 20'h00000,
  parameter  PF0_REVISION_ID = 8'h00,
  parameter  PF0_SRIOV_BAR0_APERTURE_SIZE = 5'h03,
  parameter  PF0_SRIOV_BAR0_CONTROL = 3'h4,
  parameter  PF0_SRIOV_BAR1_APERTURE_SIZE = 5'h00,
  parameter  PF0_SRIOV_BAR1_CONTROL = 3'h0,
  parameter  PF0_SRIOV_BAR2_APERTURE_SIZE = 5'h03,
  parameter  PF0_SRIOV_BAR2_CONTROL = 3'h4,
  parameter  PF0_SRIOV_BAR3_APERTURE_SIZE = 5'h03,
  parameter  PF0_SRIOV_BAR3_CONTROL = 3'h0,
  parameter  PF0_SRIOV_BAR4_APERTURE_SIZE = 5'h03,
  parameter  PF0_SRIOV_BAR4_CONTROL = 3'h4,
  parameter  PF0_SRIOV_BAR5_APERTURE_SIZE = 5'h03,
  parameter  PF0_SRIOV_BAR5_CONTROL = 3'h0,
  parameter  PF0_SRIOV_CAP_INITIAL_VF = 16'h0000,
  parameter  PF0_SRIOV_CAP_NEXTPTR = 12'h000,
  parameter  PF0_SRIOV_CAP_TOTAL_VF = 16'h0000,
  parameter  PF0_SRIOV_CAP_VER = 4'h1,
  parameter  PF0_SRIOV_FIRST_VF_OFFSET = 16'h0000,
  parameter  PF0_SRIOV_FUNC_DEP_LINK = 16'h0000,
  parameter  PF0_SRIOV_SUPPORTED_PAGE_SIZE = 32'h00000000,
  parameter  PF0_SRIOV_VF_DEVICE_ID = 16'h0000,
  parameter  PF0_SUBSYSTEM_VENDOR_ID = 16'h0000,
  parameter  PF0_SUBSYSTEM_ID = 16'h0000,
  parameter  PF0_TPHR_CAP_ENABLE = "FALSE",
  parameter  PF0_TPHR_CAP_NEXTPTR = 12'h000,
  parameter  VF0_TPHR_CAP_NEXTPTR = 12'h000,
  parameter  VF1_TPHR_CAP_NEXTPTR = 12'h000,
  parameter  VF2_TPHR_CAP_NEXTPTR = 12'h000,
  parameter  VF3_TPHR_CAP_NEXTPTR = 12'h000,
  parameter  VF4_TPHR_CAP_NEXTPTR = 12'h000,
  parameter  VF5_TPHR_CAP_NEXTPTR = 12'h000,
  parameter  PF0_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter  PF0_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter  PF0_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter  PF0_TPHR_CAP_VER = 4'h1,
  parameter  PF1_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter  PF1_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter  PF1_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter  PF1_TPHR_CAP_VER = 4'h1,
  parameter  VF0_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter  VF0_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter  VF0_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter  VF0_TPHR_CAP_VER = 4'h1,
  parameter  VF1_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter  VF1_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter  VF1_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter  VF1_TPHR_CAP_VER = 4'h1,
  parameter  VF2_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter  VF2_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter  VF2_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter  VF2_TPHR_CAP_VER = 4'h1,
  parameter  VF3_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter  VF3_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter  VF3_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter  VF3_TPHR_CAP_VER = 4'h1,
  parameter  VF4_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter  VF4_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter  VF4_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter  VF4_TPHR_CAP_VER = 4'h1,
  parameter  VF5_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter  VF5_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter  VF5_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter  VF5_TPHR_CAP_VER = 4'h1,
  parameter  PF0_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter  PF0_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter  PF1_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter  PF1_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter  VF0_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter  VF0_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter  VF1_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter  VF1_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter  VF2_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter  VF2_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter  VF3_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter  VF3_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter  VF4_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter  VF4_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter  VF5_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter  VF5_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter  PF0_SECONDARY_PCIE_CAP_NEXTPTR = 12'h000,
  parameter  MCAP_CAP_NEXTPTR = 12'h000,
  parameter  PF0_VC_CAP_NEXTPTR = 12'h000,
  parameter  SPARE_WORD1 = 32'h00000000,
  parameter  PF1_AER_CAP_ECRC_CHECK_CAPABLE = "FALSE",
  parameter  PF1_AER_CAP_ECRC_GEN_CAPABLE = "FALSE",
  parameter  PF1_AER_CAP_NEXTPTR = 12'h000,
  parameter  PF1_ARI_CAP_NEXTPTR = 12'h000,
  parameter  PF1_BAR0_APERTURE_SIZE = 6'h03,
  parameter  PF1_BAR0_CONTROL = 3'h4,
  parameter  PF1_BAR1_APERTURE_SIZE = 6'h00,
  parameter  PF1_BAR1_CONTROL = 3'h0,
  parameter  PF1_BAR2_APERTURE_SIZE = 5'h03,
  parameter  PF1_BAR2_CONTROL = 3'h4,
  parameter  PF1_BAR3_APERTURE_SIZE = 5'h03,
  parameter  PF1_BAR3_CONTROL = 3'h0,
  parameter  PF1_BAR4_APERTURE_SIZE = 5'h03,
  parameter  PF1_BAR4_CONTROL = 3'h4,
  parameter  PF1_BAR5_APERTURE_SIZE = 5'h03,
  parameter  PF1_BAR5_CONTROL = 3'h0,
  parameter  PF1_CAPABILITY_POINTER = 8'h50,
  parameter  PF1_CLASS_CODE = 24'h000000,
  parameter  PF1_DEVICE_ID = 16'h0000,
  parameter  PF1_DEV_CAP_MAX_PAYLOAD_SIZE = 3'h3,
  parameter  PF1_DPA_CAP_NEXTPTR = 12'h000,
  parameter  PF1_DSN_CAP_NEXTPTR = 12'h10c,
  parameter  PF1_EXPANSION_ROM_APERTURE_SIZE = 5'h03,
  parameter  PF1_EXPANSION_ROM_ENABLE = "FALSE",
  parameter  PF1_INTERRUPT_PIN = 3'h1,
  parameter  PF1_MSIX_CAP_NEXTPTR = 8'h00,
  parameter  integer PF1_MSIX_CAP_PBA_BIR = 0,
  parameter  PF1_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter  integer PF1_MSIX_CAP_TABLE_BIR = 0,
  parameter  PF1_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter  PF1_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter  integer PF1_MSI_CAP_MULTIMSGCAP = 0,
  parameter  PF1_MSI_CAP_NEXTPTR = 8'h00,
  parameter  PF1_PB_CAP_NEXTPTR = 12'h000,
  parameter  PF1_PM_CAP_NEXTPTR = 8'h00,
  parameter  PF1_RBAR_CAP_ENABLE = "FALSE",
  parameter  PF1_RBAR_CAP_NEXTPTR = 12'h000,
  parameter  PF1_REVISION_ID = 8'h00,
  parameter  PF1_SRIOV_BAR0_APERTURE_SIZE = 5'h03,
  parameter  PF1_SRIOV_BAR0_CONTROL = 3'h4,
  parameter  PF1_SRIOV_BAR1_APERTURE_SIZE = 5'h00,
  parameter  PF1_SRIOV_BAR1_CONTROL = 3'h0,
  parameter  PF1_SRIOV_BAR2_APERTURE_SIZE = 5'h03,
  parameter  PF1_SRIOV_BAR2_CONTROL = 3'h4,
  parameter  PF1_SRIOV_BAR3_APERTURE_SIZE = 5'h03,
  parameter  PF1_SRIOV_BAR3_CONTROL = 3'h0,
  parameter  PF1_SRIOV_BAR4_APERTURE_SIZE = 5'h03,
  parameter  PF1_SRIOV_BAR4_CONTROL = 3'h4,
  parameter  PF1_SRIOV_BAR5_APERTURE_SIZE = 5'h03,
  parameter  PF1_SRIOV_BAR5_CONTROL = 3'h0,
  parameter  PF1_SRIOV_CAP_INITIAL_VF = 16'h0000,
  parameter  PF1_SRIOV_CAP_NEXTPTR = 12'h000,
  parameter  PF1_SRIOV_CAP_TOTAL_VF = 16'h0000,
  parameter  PF1_SRIOV_CAP_VER = 4'h1,
  parameter  PF1_SRIOV_FIRST_VF_OFFSET = 16'h0000,
  parameter  PF1_SRIOV_FUNC_DEP_LINK = 16'h0000,
  parameter  PF1_SRIOV_SUPPORTED_PAGE_SIZE = 32'h00000000,
  parameter  PF1_SRIOV_VF_DEVICE_ID = 16'h0000,
  parameter  PF1_SUBSYSTEM_ID = 16'h0000,
  parameter  PF1_TPHR_CAP_ENABLE = "FALSE",
  parameter  PF1_TPHR_CAP_NEXTPTR = 12'h000,
  parameter  PL_UPSTREAM_FACING = "TRUE",
  parameter  en_msi_per_vec_masking = "FALSE",
  parameter  SRIOV_CAP_ENABLE = "FALSE",
  parameter  TL_CREDITS_CD = 12'h3e0,
  parameter  TL_CREDITS_CH = 8'h20,
  parameter  TL_CREDITS_NPD = 12'h028,
  parameter  TL_CREDITS_NPH = 8'h20,
  parameter  TL_CREDITS_PD = 12'h198,
  parameter  TL_CREDITS_PH = 8'h20,
  parameter  TL_EXTENDED_CFG_EXTEND_INTERFACE_ENABLE = "FALSE",
  parameter  TL_LEGACY_MODE_ENABLE = "FALSE",
  parameter  TL_PF_ENABLE_REG = 2'h0,
  parameter  VF0_CAPABILITY_POINTER = 8'h50,
  parameter  integer VF0_MSIX_CAP_PBA_BIR = 0,
  parameter  VF0_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter  integer VF0_MSIX_CAP_TABLE_BIR = 0,
  parameter  VF0_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter  VF0_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter  integer VF0_MSI_CAP_MULTIMSGCAP = 0,
  parameter  VF0_PM_CAP_NEXTPTR = 8'h00,
  parameter  integer VF1_MSIX_CAP_PBA_BIR = 0,
  parameter  VF1_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter  integer VF1_MSIX_CAP_TABLE_BIR = 0,
  parameter  VF1_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter  VF1_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter  integer VF1_MSI_CAP_MULTIMSGCAP = 0,
  parameter  VF1_PM_CAP_NEXTPTR = 8'h00,
  parameter  integer VF2_MSIX_CAP_PBA_BIR = 0,
  parameter  VF2_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter  integer VF2_MSIX_CAP_TABLE_BIR = 0,
  parameter  VF2_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter  VF2_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter  integer VF2_MSI_CAP_MULTIMSGCAP = 0,
  parameter  VF2_PM_CAP_NEXTPTR = 8'h00,
  parameter  integer VF3_MSIX_CAP_PBA_BIR = 0,
  parameter  VF3_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter  integer VF3_MSIX_CAP_TABLE_BIR = 0,
  parameter  VF3_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter  VF3_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter  integer VF3_MSI_CAP_MULTIMSGCAP = 0,
  parameter  VF3_PM_CAP_NEXTPTR = 8'h00,
  parameter  integer VF4_MSIX_CAP_PBA_BIR = 0,
  parameter  VF4_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter  integer VF4_MSIX_CAP_TABLE_BIR = 0,
  parameter  VF4_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter  VF4_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter  integer VF4_MSI_CAP_MULTIMSGCAP = 0,
  parameter  VF4_PM_CAP_NEXTPTR = 8'h00,
  parameter  integer VF5_MSIX_CAP_PBA_BIR = 0,
  parameter  VF5_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter  integer VF5_MSIX_CAP_TABLE_BIR = 0,
  parameter  VF5_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter  VF5_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter  integer VF5_MSI_CAP_MULTIMSGCAP = 0,
  parameter  VF5_PM_CAP_NEXTPTR = 8'h00,
  parameter  COMPLETION_SPACE = "16KB",
  parameter  gen_x0y0_xdc = 1,
  parameter  gen_x0y1_xdc = 0, 
  parameter  gen_x0y2_xdc = 0,
  parameter  gen_x0y3_xdc = 0,
  parameter  gen_x0y4_xdc = 0,
  parameter  gen_x0y5_xdc = 0,
  parameter  xlnx_ref_board = 0,
  parameter  pcie_blk_locn = 0,
  parameter  PIPE_SIM = "FALSE",      // This Parameter has no effect in RTL. Instead use the below parameter (EXT_PIPE_SIM), defined below and is controlled from board.v(simulation).
  parameter  AXISTEN_IF_ENABLE_CLIENT_TAG = "FALSE",
  parameter  PCIE_USE_MODE = "2.1" ,
  parameter  MCAP_ENABLEMENT = "NONE", 
  parameter  EXT_STARTUP_PRIMITIVE = "FALSE",
  parameter  PL_INTERFACE = "FALSE",
  parameter  PCIE_CONFIGURATION = "FALSE",
  parameter  CFG_STATUS_IF = "FALSE",
  parameter  TX_FC_IF = "FALSE",
  parameter  CFG_EXT_IF = "FALSE",
  parameter  CFG_FC_IF = "FALSE",
  parameter  PER_FUNC_STATUS_IF = "FALSE",
  parameter  CFG_MGMT_IF = "FALSE",
  parameter  RCV_MSG_IF = "FALSE",
  parameter  CFG_TX_MSG_IF = "FALSE",
  parameter  CFG_CTL_IF = "FALSE",
  parameter  MSI_EN = "TRUE",
  parameter  MSIX_EN = "FALSE",
  parameter  PCIE3_DRP = "TRUE",
  parameter  DIS_GT_WIZARD = "TRUE",
  parameter  TRANSCEIVER_CTRL_STATUS_PORTS = "FALSE",
  parameter  integer SHARED_LOGIC = 1,
  parameter  DEDICATE_PERST = "TRUE",
  parameter  SYS_RESET_POLARITY = 1'b0, 
  parameter  EXT_CH_GT_DRP      = "FALSE",  
  parameter  EN_GT_SELECTION = "FALSE",
  parameter  SELECT_QUAD = "Quad_1",
  parameter PIPE_PIPELINE_STAGES = 1,
  parameter MCAP_CONFIGURE_OVERRIDE = "FALSE",
  parameter MCAP_ENABLE = "FALSE",
  parameter MCAP_EOS_DESIGN_SWITCH = "FALSE",
  parameter [31:0] MCAP_FPGA_BITSTREAM_VERSION = 32'h00000000,
  parameter MCAP_GATE_IO_ENABLE_DESIGN_SWITCH = "FALSE",
  parameter MCAP_GATE_MEM_ENABLE_DESIGN_SWITCH = "FALSE",
  parameter MCAP_INPUT_GATE_DESIGN_SWITCH = "FALSE",
  parameter MCAP_INTERRUPT_ON_MCAP_ERROR = "FALSE",
  parameter MCAP_INTERRUPT_ON_MCAP_EOS = "FALSE",
  parameter AXISTEN_IF_CC_PARITY_CHK = "FALSE",
  parameter [17:0] AXISTEN_IF_ENABLE_MSG_ROUTE = 18'h00000,
  parameter AXISTEN_IF_ENABLE_RX_MSG_INTFC = "FALSE",
  parameter AXISTEN_IF_RQ_PARITY_CHK = "FALSE",
  parameter DEBUG_CFG_LOCAL_MGMT_REG_ACCESS_OVERRIDE = "FALSE",
  parameter DEBUG_PL_DISABLE_EI_INFER_IN_L0 = "FALSE",
  parameter DEBUG_TL_DISABLE_RX_TLP_ORDER_CHECKS = "FALSE",
  parameter [7:0] DNSTREAM_LINK_NUM = 8'h00,
  parameter [8:0] LL_ACK_TIMEOUT = 9'h000,
  parameter LL_ACK_TIMEOUT_EN = "FALSE",
  parameter integer LL_ACK_TIMEOUT_FUNC = 0,
  parameter [15:0] LL_CPL_FC_UPDATE_TIMER = 16'h0000,
  parameter LL_CPL_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter [15:0] LL_FC_UPDATE_TIMER = 16'h0000,
  parameter LL_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter [15:0] LL_NP_FC_UPDATE_TIMER = 16'h0000,
  parameter LL_NP_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter [15:0] LL_P_FC_UPDATE_TIMER = 16'h0000,
  parameter LL_P_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter [8:0] LL_REPLAY_TIMEOUT = 9'h000,
  parameter LL_REPLAY_TIMEOUT_EN = "FALSE",
  parameter integer LL_REPLAY_TIMEOUT_FUNC = 0,
  parameter [9:0] LTR_TX_MESSAGE_MINIMUM_INTERVAL = 10'h0fa,
  parameter LTR_TX_MESSAGE_ON_FUNC_POWER_STATE_CHANGE = "FALSE",
  parameter LTR_TX_MESSAGE_ON_LTR_ENABLE = "FALSE",
  parameter [15:0] MCAP_VSEC_ID = 16'h0000,
  parameter [11:0] MCAP_VSEC_LEN = 12'h02c,
  parameter [3:0] MCAP_VSEC_REV = 4'h0,
  parameter [3:0] PF0_ARI_CAP_VER = 4'h1,
  parameter [7:0] PF0_BIST_REGISTER = 8'h00,
  parameter integer PF0_DEV_CAP_ENDPOINT_L0S_LATENCY = 0,
  parameter integer PF0_DEV_CAP_ENDPOINT_L1_LATENCY = 0,
  parameter PF0_DEV_CAP2_ARI_FORWARD_ENABLE = "FALSE",
  parameter PF0_DEV_CAP2_CPL_TIMEOUT_DISABLE = "TRUE",
  parameter [4:0] PF0_DPA_CAP_SUB_STATE_CONTROL = 5'h00,
  parameter PF0_DPA_CAP_SUB_STATE_CONTROL_EN = "TRUE",
  parameter [3:0] PF0_DPA_CAP_VER = 4'h1,
  parameter [7:0] PF0_INTERRUPT_LINE = 8'h00,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN3 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN3 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN3 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_GEN3 = 7,
  parameter [9:0] PF0_LTR_CAP_MAX_NOSNOOP_LAT = 10'h000,
  parameter [9:0] PF0_LTR_CAP_MAX_SNOOP_LAT = 10'h000,
  parameter [3:0] PF0_LTR_CAP_VER = 4'h1,
  parameter PF0_MSI_CAP_PERVECMASKCAP = "FALSE",
  parameter [31:0] PF0_PB_CAP_DATA_REG_D0 = 32'h00000000,
  parameter [31:0] PF0_PB_CAP_DATA_REG_D0_SUSTAINED = 32'h00000000,
  parameter [31:0] PF0_PB_CAP_DATA_REG_D1 = 32'h00000000,
  parameter [31:0] PF0_PB_CAP_DATA_REG_D3HOT = 32'h00000000,
  parameter PF0_PB_CAP_SYSTEM_ALLOCATED = "FALSE",
  parameter [3:0] PF0_PB_CAP_VER = 4'h1,
  parameter [7:0] PF0_PM_CAP_ID = 8'h01,
  parameter [2:0] PF0_PM_CAP_VER_ID = 3'h3,
  parameter PF0_PM_CSR_NOSOFTRESET = "TRUE",
  parameter [3:0] PF0_RBAR_CAP_VER = 4'h1,
  parameter [2:0] PF0_RBAR_CONTROL_INDEX0 = 3'h0,
  parameter [2:0] PF0_RBAR_CONTROL_INDEX1 = 3'h0,
  parameter [2:0] PF0_RBAR_CONTROL_INDEX2 = 3'h0,
  parameter [4:0] PF0_RBAR_CONTROL_SIZE0 = 5'h00,
  parameter [4:0] PF0_RBAR_CONTROL_SIZE1 = 5'h00,
  parameter [4:0] PF0_RBAR_CONTROL_SIZE2 = 5'h00,
  parameter [2:0] PF0_RBAR_NUM = 3'h1,
  parameter PF0_VC_CAP_ENABLE = "FALSE",
  parameter [3:0] PF0_VC_CAP_VER = 4'h1,
  parameter [7:0] PF1_ARI_CAP_NEXT_FUNC = 8'h00,
  parameter [7:0] PF1_BIST_REGISTER = 8'h00,
  parameter [4:0] PF1_DPA_CAP_SUB_STATE_CONTROL = 5'h00,
  parameter PF1_DPA_CAP_SUB_STATE_CONTROL_EN = "TRUE",
  parameter [3:0] PF1_DPA_CAP_VER = 4'h1,
  parameter [7:0] PF1_INTERRUPT_LINE = 8'h00,
  parameter PF1_MSI_CAP_PERVECMASKCAP = "FALSE",
  parameter [31:0] PF1_PB_CAP_DATA_REG_D0 = 32'h00000000,
  parameter [31:0] PF1_PB_CAP_DATA_REG_D0_SUSTAINED = 32'h00000000,
  parameter [31:0] PF1_PB_CAP_DATA_REG_D1 = 32'h00000000,
  parameter [31:0] PF1_PB_CAP_DATA_REG_D3HOT = 32'h00000000,
  parameter PF1_PB_CAP_SYSTEM_ALLOCATED = "FALSE",
  parameter [3:0] PF1_PB_CAP_VER = 4'h1,
  parameter [7:0] PF1_PM_CAP_ID = 8'h01,
  parameter [2:0] PF1_PM_CAP_VER_ID = 3'h3,
  parameter [3:0] PF1_RBAR_CAP_VER = 4'h1,
  parameter [2:0] PF1_RBAR_CONTROL_INDEX0 = 3'h0,
  parameter [2:0] PF1_RBAR_CONTROL_INDEX1 = 3'h0,
  parameter [2:0] PF1_RBAR_CONTROL_INDEX2 = 3'h0,
  parameter [4:0] PF1_RBAR_CONTROL_SIZE0 = 5'h00,
  parameter [4:0] PF1_RBAR_CONTROL_SIZE1 = 5'h00,
  parameter [4:0] PF1_RBAR_CONTROL_SIZE2 = 5'h00,
  parameter [2:0] PF1_RBAR_NUM = 3'h1,
  parameter PF2_AER_CAP_ECRC_CHECK_CAPABLE = "FALSE",
  parameter PF2_AER_CAP_ECRC_GEN_CAPABLE = "FALSE",
  parameter [11:0] PF2_AER_CAP_NEXTPTR = 12'h000,
  parameter [7:0] PF2_ARI_CAP_NEXT_FUNC = 8'h00,
  parameter [11:0] PF2_ARI_CAP_NEXTPTR = 12'h000,
  parameter [5:0] PF2_BAR0_APERTURE_SIZE = 6'h03,
  parameter [2:0] PF2_BAR0_CONTROL = 3'h4,
  parameter [5:0] PF2_BAR1_APERTURE_SIZE = 6'h00,
  parameter [2:0] PF2_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF2_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF2_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF2_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF2_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_BAR5_CONTROL = 3'h0,
  parameter [7:0] PF2_BIST_REGISTER = 8'h00,
  parameter [7:0] PF2_CAPABILITY_POINTER = 8'h50,
  parameter [23:0] PF2_CLASS_CODE = 24'h000000,
  parameter [2:0] PF2_DEV_CAP_MAX_PAYLOAD_SIZE = 3'h3,
  parameter [15:0] PF2_DEVICE_ID = 16'h0000,
  parameter [11:0] PF2_DPA_CAP_NEXTPTR = 12'h000,
  parameter [4:0] PF2_DPA_CAP_SUB_STATE_CONTROL = 5'h00,
  parameter PF2_DPA_CAP_SUB_STATE_CONTROL_EN = "TRUE",
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 = 8'h00,
  parameter [3:0] PF2_DPA_CAP_VER = 4'h1,
  parameter [11:0] PF2_DSN_CAP_NEXTPTR = 12'h10c,
  parameter [4:0] PF2_EXPANSION_ROM_APERTURE_SIZE = 5'h03,
  parameter PF2_EXPANSION_ROM_ENABLE = "FALSE",
  parameter [7:0] PF2_INTERRUPT_LINE = 8'h00,
  parameter [2:0] PF2_INTERRUPT_PIN = 3'h1,
  parameter integer PF2_MSI_CAP_MULTIMSGCAP = 0,
  parameter [7:0] PF2_MSI_CAP_NEXTPTR = 8'h00,
  parameter PF2_MSI_CAP_PERVECMASKCAP = "FALSE",
  parameter [7:0] PF2_MSIX_CAP_NEXTPTR = 8'h00,
  parameter integer PF2_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] PF2_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer PF2_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] PF2_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] PF2_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [31:0] PF2_PB_CAP_DATA_REG_D0 = 32'h00000000,
  parameter [31:0] PF2_PB_CAP_DATA_REG_D0_SUSTAINED = 32'h00000000,
  parameter [31:0] PF2_PB_CAP_DATA_REG_D1 = 32'h00000000,
  parameter [31:0] PF2_PB_CAP_DATA_REG_D3HOT = 32'h00000000,
  parameter [11:0] PF2_PB_CAP_NEXTPTR = 12'h000,
  parameter PF2_PB_CAP_SYSTEM_ALLOCATED = "FALSE",
  parameter [3:0] PF2_PB_CAP_VER = 4'h1,
  parameter [7:0] PF2_PM_CAP_ID = 8'h01,
  parameter [7:0] PF2_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] PF2_PM_CAP_VER_ID = 3'h3,
  parameter PF2_RBAR_CAP_ENABLE = "FALSE",
  parameter [11:0] PF2_RBAR_CAP_NEXTPTR = 12'h000,
  parameter [19:0] PF2_RBAR_CAP_SIZE0 = 20'h00000,
  parameter [19:0] PF2_RBAR_CAP_SIZE1 = 20'h00000,
  parameter [19:0] PF2_RBAR_CAP_SIZE2 = 20'h00000,
  parameter [3:0] PF2_RBAR_CAP_VER = 4'h1,
  parameter [2:0] PF2_RBAR_CONTROL_INDEX0 = 3'h0,
  parameter [2:0] PF2_RBAR_CONTROL_INDEX1 = 3'h0,
  parameter [2:0] PF2_RBAR_CONTROL_INDEX2 = 3'h0,
  parameter [4:0] PF2_RBAR_CONTROL_SIZE0 = 5'h00,
  parameter [4:0] PF2_RBAR_CONTROL_SIZE1 = 5'h00,
  parameter [4:0] PF2_RBAR_CONTROL_SIZE2 = 5'h00,
  parameter [2:0] PF2_RBAR_NUM = 3'h1,
  parameter [7:0] PF2_REVISION_ID = 8'h00,
  parameter [4:0] PF2_SRIOV_BAR0_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_SRIOV_BAR0_CONTROL = 3'h4,
  parameter [4:0] PF2_SRIOV_BAR1_APERTURE_SIZE = 5'h00,
  parameter [2:0] PF2_SRIOV_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF2_SRIOV_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_SRIOV_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF2_SRIOV_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_SRIOV_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF2_SRIOV_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_SRIOV_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF2_SRIOV_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_SRIOV_BAR5_CONTROL = 3'h0,
  parameter [15:0] PF2_SRIOV_CAP_INITIAL_VF = 16'h0000,
  parameter [11:0] PF2_SRIOV_CAP_NEXTPTR = 12'h000,
  parameter [15:0] PF2_SRIOV_CAP_TOTAL_VF = 16'h0000,
  parameter [3:0] PF2_SRIOV_CAP_VER = 4'h1,
  parameter [15:0] PF2_SRIOV_FIRST_VF_OFFSET = 16'h0000,
  parameter [15:0] PF2_SRIOV_FUNC_DEP_LINK = 16'h0000,
  parameter [31:0] PF2_SRIOV_SUPPORTED_PAGE_SIZE = 32'h00000000,
  parameter [15:0] PF2_SRIOV_VF_DEVICE_ID = 16'h0000,
  parameter [15:0] PF2_SUBSYSTEM_ID = 16'h0000,
  parameter PF2_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter PF2_TPHR_CAP_ENABLE = "FALSE",
  parameter PF2_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] PF2_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] PF2_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] PF2_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] PF2_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] PF2_TPHR_CAP_VER = 4'h1,
  parameter PF3_AER_CAP_ECRC_CHECK_CAPABLE = "FALSE",
  parameter PF3_AER_CAP_ECRC_GEN_CAPABLE = "FALSE",
  parameter [11:0] PF3_AER_CAP_NEXTPTR = 12'h000,
  parameter [7:0] PF3_ARI_CAP_NEXT_FUNC = 8'h00,
  parameter [11:0] PF3_ARI_CAP_NEXTPTR = 12'h000,
  parameter [5:0] PF3_BAR0_APERTURE_SIZE = 6'h03,
  parameter [2:0] PF3_BAR0_CONTROL = 3'h4,
  parameter [5:0] PF3_BAR1_APERTURE_SIZE = 6'h00,
  parameter [2:0] PF3_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF3_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF3_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF3_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF3_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_BAR5_CONTROL = 3'h0,
  parameter [7:0] PF3_BIST_REGISTER = 8'h00,
  parameter [7:0] PF3_CAPABILITY_POINTER = 8'h50,
  parameter [23:0] PF3_CLASS_CODE = 24'h000000,
  parameter [2:0] PF3_DEV_CAP_MAX_PAYLOAD_SIZE = 3'h3,
  parameter [15:0] PF3_DEVICE_ID = 16'h0000,
  parameter [11:0] PF3_DPA_CAP_NEXTPTR = 12'h000,
  parameter [4:0] PF3_DPA_CAP_SUB_STATE_CONTROL = 5'h00,
  parameter PF3_DPA_CAP_SUB_STATE_CONTROL_EN = "TRUE",
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 = 8'h00,
  parameter [3:0] PF3_DPA_CAP_VER = 4'h1,
  parameter [11:0] PF3_DSN_CAP_NEXTPTR = 12'h10c,
  parameter [4:0] PF3_EXPANSION_ROM_APERTURE_SIZE = 5'h03,
  parameter PF3_EXPANSION_ROM_ENABLE = "FALSE",
  parameter [7:0] PF3_INTERRUPT_LINE = 8'h00,
  parameter [2:0] PF3_INTERRUPT_PIN = 3'h1,
  parameter integer PF3_MSI_CAP_MULTIMSGCAP = 0,
  parameter [7:0] PF3_MSI_CAP_NEXTPTR = 8'h00,
  parameter PF3_MSI_CAP_PERVECMASKCAP = "FALSE",
  parameter [7:0] PF3_MSIX_CAP_NEXTPTR = 8'h00,
  parameter integer PF3_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] PF3_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer PF3_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] PF3_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] PF3_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [31:0] PF3_PB_CAP_DATA_REG_D0 = 32'h00000000,
  parameter [31:0] PF3_PB_CAP_DATA_REG_D0_SUSTAINED = 32'h00000000,
  parameter [31:0] PF3_PB_CAP_DATA_REG_D1 = 32'h00000000,
  parameter [31:0] PF3_PB_CAP_DATA_REG_D3HOT = 32'h00000000,
  parameter [11:0] PF3_PB_CAP_NEXTPTR = 12'h000,
  parameter PF3_PB_CAP_SYSTEM_ALLOCATED = "FALSE",
  parameter [3:0] PF3_PB_CAP_VER = 4'h1,
  parameter [7:0] PF3_PM_CAP_ID = 8'h01,
  parameter [7:0] PF3_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] PF3_PM_CAP_VER_ID = 3'h3,
  parameter PF3_RBAR_CAP_ENABLE = "FALSE",
  parameter [11:0] PF3_RBAR_CAP_NEXTPTR = 12'h000,
  parameter [19:0] PF3_RBAR_CAP_SIZE0 = 20'h00000,
  parameter [19:0] PF3_RBAR_CAP_SIZE1 = 20'h00000,
  parameter [19:0] PF3_RBAR_CAP_SIZE2 = 20'h00000,
  parameter [3:0] PF3_RBAR_CAP_VER = 4'h1,
  parameter [2:0] PF3_RBAR_CONTROL_INDEX0 = 3'h0,
  parameter [2:0] PF3_RBAR_CONTROL_INDEX1 = 3'h0,
  parameter [2:0] PF3_RBAR_CONTROL_INDEX2 = 3'h0,
  parameter [4:0] PF3_RBAR_CONTROL_SIZE0 = 5'h00,
  parameter [4:0] PF3_RBAR_CONTROL_SIZE1 = 5'h00,
  parameter [4:0] PF3_RBAR_CONTROL_SIZE2 = 5'h00,
  parameter [2:0] PF3_RBAR_NUM = 3'h1,
  parameter [7:0] PF3_REVISION_ID = 8'h00,
  parameter [4:0] PF3_SRIOV_BAR0_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_SRIOV_BAR0_CONTROL = 3'h4,
  parameter [4:0] PF3_SRIOV_BAR1_APERTURE_SIZE = 5'h00,
  parameter [2:0] PF3_SRIOV_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF3_SRIOV_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_SRIOV_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF3_SRIOV_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_SRIOV_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF3_SRIOV_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_SRIOV_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF3_SRIOV_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_SRIOV_BAR5_CONTROL = 3'h0,
  parameter [15:0] PF3_SRIOV_CAP_INITIAL_VF = 16'h0000,
  parameter [11:0] PF3_SRIOV_CAP_NEXTPTR = 12'h000,
  parameter [15:0] PF3_SRIOV_CAP_TOTAL_VF = 16'h0000,
  parameter [3:0] PF3_SRIOV_CAP_VER = 4'h1,
  parameter [15:0] PF3_SRIOV_FIRST_VF_OFFSET = 16'h0000,
  parameter [15:0] PF3_SRIOV_FUNC_DEP_LINK = 16'h0000,
  parameter [31:0] PF3_SRIOV_SUPPORTED_PAGE_SIZE = 32'h00000000,
  parameter [15:0] PF3_SRIOV_VF_DEVICE_ID = 16'h0000,
  parameter [15:0] PF3_SUBSYSTEM_ID = 16'h0000,
  parameter PF3_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter PF3_TPHR_CAP_ENABLE = "FALSE",
  parameter PF3_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] PF3_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] PF3_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] PF3_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] PF3_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] PF3_TPHR_CAP_VER = 4'h1,
  parameter PL_DISABLE_AUTO_EQ_SPEED_CHANGE_TO_GEN3 = "FALSE",
  parameter PL_DISABLE_AUTO_SPEED_CHANGE_TO_GEN2 = "FALSE",
  parameter PL_DISABLE_EI_INFER_IN_L0 = "FALSE",
  parameter PL_DISABLE_GEN3_DC_BALANCE = "FALSE",
  parameter PL_DISABLE_GEN3_LFSR_UPDATE_ON_SKP = "TRUE",
  parameter PL_DISABLE_RETRAIN_ON_FRAMING_ERROR = "FALSE",
  parameter PL_DISABLE_SCRAMBLING = "FALSE",
  parameter PL_DISABLE_SYNC_HEADER_FRAMING_ERROR = "FALSE",
  parameter PL_DISABLE_UPCONFIG_CAPABLE = "FALSE",
  parameter PL_EQ_ADAPT_DISABLE_COEFF_CHECK = "FALSE",
  parameter PL_EQ_ADAPT_DISABLE_PRESET_CHECK = "FALSE",
  parameter [4:0] PL_EQ_ADAPT_ITER_COUNT = 5'h02,
  parameter [1:0] PL_EQ_ADAPT_REJECT_RETRY_COUNT = 2'h1,
  parameter PL_EQ_BYPASS_PHASE23 = "FALSE",
  parameter [2:0] PL_EQ_DEFAULT_GEN3_RX_PRESET_HINT = 3'h3,
  parameter [3:0] PL_EQ_DEFAULT_GEN3_TX_PRESET = 4'h4,
  parameter PL_EQ_PHASE01_RX_ADAPT = "FALSE",
  parameter PL_EQ_SHORT_ADAPT_PHASE = "FALSE",
  parameter [15:0] PL_LANE0_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE1_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE2_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE3_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE4_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE5_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE6_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE7_EQ_CONTROL = 16'h3400,
  parameter integer PL_N_FTS_COMCLK_GEN1 = 255,
  parameter integer PL_N_FTS_COMCLK_GEN2 = 255,
  parameter integer PL_N_FTS_COMCLK_GEN3 = 255,
  parameter integer PL_N_FTS_GEN1 = 255,
  parameter integer PL_N_FTS_GEN2 = 255,
  parameter integer PL_N_FTS_GEN3 = 255,
  parameter PL_REPORT_ALL_PHY_ERRORS = "TRUE",
  parameter PL_SIM_FAST_LINK_TRAINING = "TRUE",
  parameter [15:0] PM_ASPML0S_TIMEOUT = 16'h05dc,
  parameter [19:0] PM_ASPML1_ENTRY_DELAY = 20'h00ABE,
  parameter PM_ENABLE_L23_ENTRY = "FALSE",
  parameter PM_ENABLE_SLOT_POWER_CAPTURE = "TRUE",
  parameter [31:0] PM_L1_REENTRY_DELAY = 32'h000061A8,
  parameter [19:0] PM_PME_SERVICE_TIMEOUT_DELAY = 20'h186a0,
  parameter [15:0] PM_PME_TURNOFF_ACK_DELAY = 16'h0064,
  parameter SIM_JTAG_IDCODE = 32'h00000000,
  parameter SIM_VERSION = "1.0",
  parameter integer SPARE_BIT0 = 0,
  parameter integer SPARE_BIT1 = 0,
  parameter integer SPARE_BIT2 = 0,
  parameter integer SPARE_BIT3 = 0,
  parameter integer SPARE_BIT4 = 0,
  parameter integer SPARE_BIT5 = 0,
  parameter integer SPARE_BIT6 = 0,
  parameter integer SPARE_BIT7 = 0,
  parameter integer SPARE_BIT8 = 0,
  parameter [7:0] SPARE_BYTE0 = 8'h00,
  parameter [7:0] SPARE_BYTE1 = 8'h00,
  parameter [7:0] SPARE_BYTE2 = 8'h00,
  parameter [7:0] SPARE_BYTE3 = 8'h00,
  parameter [31:0] SPARE_WORD0 = 32'h00000000,
  parameter [31:0] SPARE_WORD2 = 32'h00000000,
  parameter [31:0] SPARE_WORD3 = 32'h00000000,
  parameter [23:0] TL_COMPL_TIMEOUT_REG0 = 24'hbebc20,
  parameter [27:0] TL_COMPL_TIMEOUT_REG1 = 28'h2faf080,
  parameter TL_ENABLE_MESSAGE_RID_CHECK_ENABLE = "TRUE",
  parameter TL_LEGACY_CFG_EXTEND_INTERFACE_ENABLE = "FALSE",
  parameter TL_TX_MUX_STRICT_PRIORITY = "TRUE",
  parameter TWO_LAYER_MODE_DLCMSM_ENABLE = "TRUE",
  parameter TWO_LAYER_MODE_ENABLE = "FALSE",
  parameter TWO_LAYER_MODE_WIDTH_256 = "TRUE",
  parameter [7:0] VF0_PM_CAP_ID = 8'h01,
  parameter [2:0] VF0_PM_CAP_VER_ID = 3'h3,
  parameter VF0_TPHR_CAP_ENABLE = "FALSE",
  parameter [7:0] VF1_PM_CAP_ID = 8'h01,
  parameter [2:0] VF1_PM_CAP_VER_ID = 3'h3,
  parameter VF1_TPHR_CAP_ENABLE = "FALSE",
  parameter [7:0] VF2_PM_CAP_ID = 8'h01,
  parameter [2:0] VF2_PM_CAP_VER_ID = 3'h3,
  parameter VF2_TPHR_CAP_ENABLE = "FALSE",
  parameter [7:0] VF3_PM_CAP_ID = 8'h01,
  parameter [2:0] VF3_PM_CAP_VER_ID = 3'h3,
  parameter VF3_TPHR_CAP_ENABLE = "FALSE",
  parameter [7:0] VF4_PM_CAP_ID = 8'h01,
  parameter [2:0] VF4_PM_CAP_VER_ID = 3'h3,
  parameter VF4_TPHR_CAP_ENABLE = "FALSE",
  parameter [7:0] VF5_PM_CAP_ID = 8'h01,
  parameter [2:0] VF5_PM_CAP_VER_ID = 3'h3,
  parameter VF5_TPHR_CAP_ENABLE = "FALSE",
  parameter [11:0] VF6_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF6_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF6_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF6_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF6_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF6_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF6_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF6_PM_CAP_ID = 8'h01,
  parameter [7:0] VF6_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF6_PM_CAP_VER_ID = 3'h3,
  parameter VF6_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF6_TPHR_CAP_ENABLE = "FALSE",
  parameter VF6_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF6_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF6_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF6_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF6_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF6_TPHR_CAP_VER = 4'h1,
  parameter [11:0] VF7_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF7_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF7_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF7_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF7_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF7_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF7_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF7_PM_CAP_ID = 8'h01,
  parameter [7:0] VF7_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF7_PM_CAP_VER_ID = 3'h3,
  parameter VF7_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF7_TPHR_CAP_ENABLE = "FALSE",
  parameter VF7_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF7_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF7_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF7_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF7_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF7_TPHR_CAP_VER = 4'h1,
  parameter silicon_revision = "GES",
  parameter EXT_PIPE_SIM = "FALSE",  // This Parameter has effect on running PIPE simulation by dis-connecting GTs and synthesis by connecting GTs.
  parameter PCIE_EXT_CLK = "FALSE",
  parameter PCIE_TXBUF_EN = "FALSE",
  parameter PCIE_GT_DEVICE = "GTH",
  parameter PCIE_CHAN_BOND = 0,
  parameter PCIE_CHAN_BOND_EN = "FALSE",
  parameter PCIE_LPM_DFE = "LPM",
  parameter TCQ = 100,
  parameter NO_DECODE_LOGIC  = "FALSE",
  parameter INTERFACE_SPEED  = "500MHZ"
  ) (
  output wire [7:0] pci_exp_txn,
  output wire [7:0] pci_exp_txp,
  input  wire [7:0] pci_exp_rxn,
  input  wire [7:0] pci_exp_rxp,
  output wire         user_clk,
  output wire         user_reset,
  output wire         user_lnk_up,
  input  wire [C_DATA_WIDTH-1:0] s_axis_rq_tdata,
  input  wire [KEEP_WIDTH-1:0] s_axis_rq_tkeep,
  input  wire         s_axis_rq_tlast,
  output wire   [3:0] s_axis_rq_tready,
  input  wire  [59:0] s_axis_rq_tuser,
  input  wire         s_axis_rq_tvalid,
  output wire [C_DATA_WIDTH-1:0] m_axis_rc_tdata,
  output wire [KEEP_WIDTH-1:0] m_axis_rc_tkeep,
  output wire         m_axis_rc_tlast,
  input  wire  [21:0] m_axis_rc_tready,
  output wire  [74:0] m_axis_rc_tuser,
  output wire         m_axis_rc_tvalid,
  output wire [C_DATA_WIDTH-1:0] m_axis_cq_tdata,
  output wire [KEEP_WIDTH-1:0] m_axis_cq_tkeep,
  output wire         m_axis_cq_tlast,
  input  wire  [21:0] m_axis_cq_tready,
  output wire  [84:0] m_axis_cq_tuser,
  output wire         m_axis_cq_tvalid,
  input  wire [C_DATA_WIDTH-1:0] s_axis_cc_tdata,
  input  wire [KEEP_WIDTH-1:0] s_axis_cc_tkeep,
  input  wire         s_axis_cc_tlast,
  output wire   [3:0] s_axis_cc_tready,
  input  wire  [32:0] s_axis_cc_tuser,
  input  wire         s_axis_cc_tvalid,
  output wire   [3:0] pcie_rq_seq_num,
  output wire         pcie_rq_seq_num_vld,
  output wire   [5:0] pcie_rq_tag,
  output wire   [1:0] pcie_rq_tag_av,
  output wire         pcie_rq_tag_vld,
  output wire   [1:0] pcie_tfc_nph_av,
  output wire   [1:0] pcie_tfc_npd_av,
  input  wire         pcie_cq_np_req,
  output wire   [5:0] pcie_cq_np_req_count,
  output wire         cfg_phy_link_down,
  output wire   [1:0] cfg_phy_link_status,
  output wire   [3:0] cfg_negotiated_width,
  output wire   [2:0] cfg_current_speed,
  output wire   [2:0] cfg_max_payload,
  output wire   [2:0] cfg_max_read_req,
  output wire  [15:0] cfg_function_status,
  output wire  [11:0] cfg_function_power_state,
  output wire  [15:0] cfg_vf_status,
  output wire  [23:0] cfg_vf_power_state,
  output wire   [1:0] cfg_link_power_state,
  input  wire  [18:0] cfg_mgmt_addr,
  input  wire         cfg_mgmt_write,
  input  wire  [31:0] cfg_mgmt_write_data,
  input  wire   [3:0] cfg_mgmt_byte_enable,
  input  wire         cfg_mgmt_read,
  output wire  [31:0] cfg_mgmt_read_data,
  output wire         cfg_mgmt_read_write_done,
  input  wire         cfg_mgmt_type1_cfg_reg_access,
  output wire         cfg_err_cor_out,
  output wire         cfg_err_nonfatal_out,
  output wire         cfg_err_fatal_out,
  output wire         cfg_local_error,
  output wire         cfg_ltr_enable,
  output wire   [5:0] cfg_ltssm_state,
  output wire   [3:0] cfg_rcb_status,
  output wire   [3:0] cfg_dpa_substate_change,
  output wire   [1:0] cfg_obff_enable,
  output wire         cfg_pl_status_change,
  output wire   [3:0] cfg_tph_requester_enable,
  output wire  [11:0] cfg_tph_st_mode,
  output wire   [7:0] cfg_vf_tph_requester_enable,
  output wire  [23:0] cfg_vf_tph_st_mode,
  output wire         cfg_msg_received,
  output wire   [7:0] cfg_msg_received_data,
  output wire   [4:0] cfg_msg_received_type,
  input  wire         cfg_msg_transmit,
  input  wire   [2:0] cfg_msg_transmit_type,
  input  wire  [31:0] cfg_msg_transmit_data,
  output wire         cfg_msg_transmit_done,
  output wire   [7:0] cfg_fc_ph,
  output wire  [11:0] cfg_fc_pd,
  output wire   [7:0] cfg_fc_nph,
  output wire  [11:0] cfg_fc_npd,
  output wire   [7:0] cfg_fc_cplh,
  output wire  [11:0] cfg_fc_cpld,
  input  wire   [2:0] cfg_fc_sel,
  input  wire   [2:0] cfg_per_func_status_control,
  output wire  [15:0] cfg_per_func_status_data,
  input  wire   [3:0] cfg_per_function_number,
  input  wire         cfg_per_function_output_request,
  output wire         cfg_per_function_update_done,
  input  wire  [63:0] cfg_dsn,
  input  wire         cfg_power_state_change_ack,
  output wire         cfg_power_state_change_interrupt,
  input  wire         cfg_err_cor_in,
  input  wire         cfg_err_uncor_in,
  output wire   [3:0] cfg_flr_in_process,
  input  wire   [3:0] cfg_flr_done,
  output wire   [7:0] cfg_vf_flr_in_process,
  input  wire   [7:0] cfg_vf_flr_done,
  input  wire         cfg_link_training_enable,
  output wire         cfg_ext_read_received,
  output wire         cfg_ext_write_received,
  output wire   [9:0] cfg_ext_register_number,
  output wire   [7:0] cfg_ext_function_number,
  output wire  [31:0] cfg_ext_write_data,
  output wire   [3:0] cfg_ext_write_byte_enable,
  input  wire  [31:0] cfg_ext_read_data,
  input  wire         cfg_ext_read_data_valid,
  input  wire   [3:0] cfg_interrupt_int,
  input  wire   [3:0] cfg_interrupt_pending,
  output wire         cfg_interrupt_sent,
  output wire   [3:0] cfg_interrupt_msi_enable,
  output wire   [7:0] cfg_interrupt_msi_vf_enable,
  output wire  [11:0] cfg_interrupt_msi_mmenable,
  output wire         cfg_interrupt_msi_mask_update,
  output wire  [31:0] cfg_interrupt_msi_data,
  input  wire   [3:0] cfg_interrupt_msi_select,
  input  wire  [31:0] cfg_interrupt_msi_int,
  input  wire  [31:0] cfg_interrupt_msi_pending_status,
  input  wire         cfg_interrupt_msi_pending_status_data_enable,
  input  wire   [3:0] cfg_interrupt_msi_pending_status_function_num,
  output wire         cfg_interrupt_msi_sent,
  output wire         cfg_interrupt_msi_fail,
  output wire   [3:0] cfg_interrupt_msix_enable,
  output wire   [3:0] cfg_interrupt_msix_mask,
  output wire   [7:0] cfg_interrupt_msix_vf_enable,
  output wire   [7:0] cfg_interrupt_msix_vf_mask,
  input  wire  [31:0] cfg_interrupt_msix_data,
  input  wire  [63:0] cfg_interrupt_msix_address,
  input  wire         cfg_interrupt_msix_int,
  output wire         cfg_interrupt_msix_sent,
  output wire         cfg_interrupt_msix_fail,
  input  wire   [2:0] cfg_interrupt_msi_attr,
  input  wire         cfg_interrupt_msi_tph_present,
  input  wire   [1:0] cfg_interrupt_msi_tph_type,
  input  wire   [8:0] cfg_interrupt_msi_tph_st_tag,
  input  wire   [3:0] cfg_interrupt_msi_function_number,
  output wire         cfg_hot_reset_out,
  input  wire         cfg_config_space_enable,
  input  wire         cfg_req_pm_transition_l23_ready,
  input  wire         cfg_hot_reset_in,
  input  wire   [7:0] cfg_ds_port_number,
  input  wire   [7:0] cfg_ds_bus_number,
  input  wire   [4:0] cfg_ds_device_number,
  input  wire   [2:0] cfg_ds_function_number,
  input  wire  [15:0] cfg_vend_id,
  input  wire  [15:0] cfg_dev_id,
  input  wire   [7:0] cfg_rev_id,
  input  wire  [15:0] cfg_subsys_vend_id,
  input  wire  [15:0] cfg_subsys_id,
  output wire         drp_rdy,
  output wire  [15:0] drp_do,
  input  wire         drp_clk,
  input  wire         drp_en,
  input  wire         drp_we,
  input  wire   [9:0] drp_addr,
  input  wire  [15:0] drp_di,
  input  wire   [4:0] user_tph_stt_address,
  input  wire   [3:0] user_tph_function_num,
  output wire  [31:0] user_tph_stt_read_data,
  output wire         user_tph_stt_read_data_valid,
  input  wire         user_tph_stt_read_enable,
  input  wire         sys_clk,
  input  wire         sys_clk_gt,
  input  wire         sys_reset,
//---- PIPE Ports to Core Top Level for PIPE Mode Simulation with 3rd Party IP/BFM/Xilinx BFM ------------------------
  input  wire  [25:0] common_commands_in,
  input  wire [83:0]  pipe_rx_0_sigs,
  input  wire [83:0]  pipe_rx_1_sigs,
  input  wire [83:0]  pipe_rx_2_sigs,
  input  wire [83:0]  pipe_rx_3_sigs,
  input  wire [83:0]  pipe_rx_4_sigs,
  input  wire [83:0]  pipe_rx_5_sigs,
  input  wire [83:0]  pipe_rx_6_sigs,
  input  wire [83:0]  pipe_rx_7_sigs,
                      
  output wire [25:0]  common_commands_out,
  output wire [83:0]  pipe_tx_0_sigs,
  output wire [83:0]  pipe_tx_1_sigs,
  output wire [83:0]  pipe_tx_2_sigs,
  output wire [83:0]  pipe_tx_3_sigs,
  output wire [83:0]  pipe_tx_4_sigs,
  output wire [83:0]  pipe_tx_5_sigs,
  output wire [83:0]  pipe_tx_6_sigs,
  output wire [83:0]  pipe_tx_7_sigs,

   //---------- Shared Logic Internal -------------------------
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH-1)>>2):0] int_qpll1lock_out,   
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH-1)>>2):0] int_qpll1outrefclk_out,
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH-1)>>2):0] int_qpll1outclk_out,
    //---------- External GT COMMON Ports ----------------------
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH-1)>>2):0] ext_qpll1refclk,
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH-1)>>2):0] ext_qpll1pd,
  output wire [((((PL_LINK_CAP_MAX_LINK_WIDTH-1)>>2)+1)*3)-1:0] ext_qpll1rate,
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH-1)>>2):0] ext_qpll1reset,

  input wire  [((PL_LINK_CAP_MAX_LINK_WIDTH-1)>>2):0] ext_qpll1lock_out,
  input wire  [((PL_LINK_CAP_MAX_LINK_WIDTH-1)>>2):0] ext_qpll1outclk_out,
  input wire  [((PL_LINK_CAP_MAX_LINK_WIDTH-1)>>2):0] ext_qpll1outrefclk_out,
  //--------------------------------------------------------------------------
  //  GT Debug Ports
  //--------------------------------------------------------------------------
  output wire                                           ext_ch_gt_drpclk,
  input  wire [((PL_LINK_CAP_MAX_LINK_WIDTH *  9)-1):0] ext_ch_gt_drpaddr,
  input  wire [((PL_LINK_CAP_MAX_LINK_WIDTH *  1)-1):0] ext_ch_gt_drpen,
  input  wire [((PL_LINK_CAP_MAX_LINK_WIDTH *  1)-1):0] ext_ch_gt_drpwe,
  input  wire [((PL_LINK_CAP_MAX_LINK_WIDTH * 16)-1):0] ext_ch_gt_drpdi,
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH *  1)-1):0] ext_ch_gt_drprdy,
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH * 16)-1):0] ext_ch_gt_drpdo,
 //--------------------------------------------------------------------------
 //  Transceiver Debug And Status Ports
 //--------------------------------------------------------------------------
  input wire  [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_pcieuserratedone ,// ({PHY_LANE{1'd0}}),
  input wire  [((PL_LINK_CAP_MAX_LINK_WIDTH*3)-1):0] gt_loopback         ,// ({PHY_LANE{3'd0}}),             
  input wire  [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_txprbsforceerr   ,// ({PHY_LANE{1'd0}}),            
  input wire  [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_txinhibit        ,// ({PHY_LANE{1'd0}}),            
  input wire  [((PL_LINK_CAP_MAX_LINK_WIDTH*4)-1):0] gt_txprbssel        ,// ({PHY_LANE{4'd0}}),            
  input wire  [((PL_LINK_CAP_MAX_LINK_WIDTH*4)-1):0] gt_rxprbssel        ,// ({PHY_LANE{4'd0}}),          
  input wire  [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_rxprbscntreset   ,// ({PHY_LANE{1'd0}}),             

  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_txelecidle       ,//              
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_txresetdone      ,//     
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_rxresetdone      ,//         
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_rxpmaresetdone   ,//       
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_txphaligndone    ,//             
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_txphinitdone     ,//          
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_txdlysresetdone  ,//          
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_rxphaligndone    ,//         
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_rxdlysresetdone  ,//           
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_rxsyncdone       ,//         
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_eyescandataerror ,//                
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_rxprbserr        ,//            
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*17)-1):0] gt_dmonitorout      ,//            
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_rxcommadet       ,//                    
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_phystatus        ,//                    
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_rxvalid          ,//               
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_rxcdrlock        ,//          
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_pcierateidle     ,// 
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_pcieuserratestart,// 
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_gtpowergood      ,//   
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_cplllock         ,//               
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_rxoutclk         ,//  
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_rxrecclkout      ,// // 
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH-1)>>2):0] gt_qpll1lock        ,//             
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*3)-1):0] gt_rxstatus         ,//             
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*3)-1):0] gt_rxbufstatus      ,//             
  output wire [8:0]                                  gt_bufgtdiv         ,//                  
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*2)-1):0] phy_txeq_ctrl       ,//                   
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*4)-1):0] phy_txeq_preset     ,//                    
  output wire [3:0]                                  phy_rst_fsm         ,//                  
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*3)-1):0] phy_txeq_fsm        ,//                   
  output wire [((PL_LINK_CAP_MAX_LINK_WIDTH*3)-1):0] phy_rxeq_fsm        ,//                  
  output wire                                        phy_rst_idle        ,//                               
  output wire                                        phy_rrst_n          ,// 
  output wire                                        phy_prst_n          ,// 

  input  wire   [1:0] conf_req_type,
  input  wire   [3:0] conf_req_reg_num,
  input  wire  [31:0] conf_req_data,
  input  wire         conf_req_valid,
  output wire         conf_req_ready,
  output wire  [31:0] conf_resp_rdata,
  output wire         conf_resp_valid,
  output wire         mcap_design_switch,
  output wire         mcap_eos_out,
  input  wire         mcap_eos_in,
  // These inputs and outputs may be use when the startup block is generated internal to the PCI Express Core.
  output wire         startup_cfgclk,     // 1-bit output: Configuration main clock output
  output wire         startup_cfgmclk,    // 1-bit output: Configuration internal oscillator clock output
  output wire   [4:0] startup_di,
  output wire         startup_eos,        // 1-bit output: Active high output signal indicating the End Of Startup
  output wire         startup_preq,       // 1-bit output: PROGRAM request to fabric output
  input  wire   [4:0] startup_do,
  input  wire   [4:0] startup_dts,
  input  wire         startup_fcsbo,
  input  wire         startup_fcsbts,
  input  wire         startup_gsr,        // 1-bit input: Global Set/Reset input (GSR cannot be used for the port name)
  input  wire         startup_gts,        // 1-bit input: Global 3-state input (GTS cannot be used for the port name)
  input  wire         startup_keyclearb,  // 1-bit input: Clear AES Decrypter Key input from Battery-Backed RAM (BBRAM)
  input  wire         startup_pack,       // 1-bit input: PROGRAM acknowledge input
  input  wire         startup_usrcclko,   // 1-bit input: User CCLK input
  input  wire         startup_usrcclkts,  // 1-bit input: User CCLK 3-state enable input
  input  wire         startup_usrdoneo,   // 1-bit input: User DONE pin output control
  input  wire         startup_usrdonets,  // 1-bit input: User DONE 3-state enable output
  output wire         cap_req,
  input  wire         cap_gnt,
  input  wire         cap_rel,
  input  wire         pl_eq_reset_eieos_count,
  input  wire         pl_gen2_upstream_prefer_deemph,
  output wire         pl_eq_in_progress,
  output wire   [1:0] pl_eq_phase,
  input  wire         pcie_perstn1_in, 
  output wire         pcie_perstn0_out,
  output wire         pcie_perstn1_out
  );
  localparam  [1:0]  AXISTEN_IF_WIDTH           = ((C_DATA_WIDTH == 256) ? 2'b10: ((C_DATA_WIDTH == 128) ? 2'b01 : 2'b00));
  localparam  [1:0]  CRM_USER_CLK_FREQ          = ((USER_CLK_FREQ == 3) ? 2'b10: ((USER_CLK_FREQ == 2) ? 2'b01 : 2'b00));

  localparam        CRM_CORE_CLK_FREQ_500      = ((PL_LINK_CAP_MAX_LINK_SPEED == 3'h4) ? "TRUE" : "FALSE");

  wire                rec_clk;
  wire                pipe_clk;
  wire                core_clk;
  wire                gt_txoutclk;
  wire                sys_rst_n;
  wire                sys_reset_pt;
  wire                phy_rdy;
  wire                phy_rdy_phystatus;
  wire                pipe_tx0_reset;
  wire                pipe_tx0_deemph;
  wire                pipe_tx0_rcvr_det;
  wire          [1:0] pipe_tx0_rate;
  wire          [2:0] pipe_tx0_margin;
  wire                pipe_tx0_swing;
  wire          [5:0] pipe_tx_eqfs;
  wire          [5:0] pipe_tx_eqlf;
  wire                pipe_rx0_polarity;
  wire                pipe_rx1_polarity;
  wire                pipe_rx2_polarity;
  wire                pipe_rx3_polarity;
  wire                pipe_rx4_polarity;
  wire                pipe_rx5_polarity;
  wire                pipe_rx6_polarity;
  wire                pipe_rx7_polarity;
  wire                pipe_tx0_compliance;
  wire                pipe_tx1_compliance;
  wire                pipe_tx2_compliance;
  wire                pipe_tx3_compliance;
  wire                pipe_tx4_compliance;
  wire                pipe_tx5_compliance;
  wire                pipe_tx6_compliance;
  wire                pipe_tx7_compliance;
  wire                pipe_tx0_data_valid;
  wire                pipe_tx1_data_valid;
  wire                pipe_tx2_data_valid;
  wire                pipe_tx3_data_valid;
  wire                pipe_tx4_data_valid;
  wire                pipe_tx5_data_valid;
  wire                pipe_tx6_data_valid;
  wire                pipe_tx7_data_valid;
  wire                pipe_tx0_elec_idle;
  wire                pipe_tx1_elec_idle;
  wire                pipe_tx2_elec_idle;
  wire                pipe_tx3_elec_idle;
  wire                pipe_tx4_elec_idle;
  wire                pipe_tx5_elec_idle;
  wire                pipe_tx6_elec_idle;
  wire                pipe_tx7_elec_idle;
  wire                pipe_tx0_start_block;
  wire                pipe_tx1_start_block;
  wire                pipe_tx2_start_block;
  wire                pipe_tx3_start_block;
  wire                pipe_tx4_start_block;
  wire                pipe_tx5_start_block;
  wire                pipe_tx6_start_block;
  wire                pipe_tx7_start_block;
  wire          [1:0] pipe_rx0_eqcontrol;
  wire          [1:0] pipe_rx1_eqcontrol;
  wire          [1:0] pipe_rx2_eqcontrol;
  wire          [1:0] pipe_rx3_eqcontrol;
  wire          [1:0] pipe_rx4_eqcontrol;
  wire          [1:0] pipe_rx5_eqcontrol;
  wire          [1:0] pipe_rx6_eqcontrol;
  wire          [1:0] pipe_rx7_eqcontrol;
  wire          [1:0] pipe_tx0_char_is_k;
  wire          [1:0] pipe_tx1_char_is_k;
  wire          [1:0] pipe_tx2_char_is_k;
  wire          [1:0] pipe_tx3_char_is_k;
  wire          [1:0] pipe_tx4_char_is_k;
  wire          [1:0] pipe_tx5_char_is_k;
  wire          [1:0] pipe_tx6_char_is_k;
  wire          [1:0] pipe_tx7_char_is_k;
  wire          [1:0] pipe_tx0_eqcontrol;
  wire          [1:0] pipe_tx1_eqcontrol;
  wire          [1:0] pipe_tx2_eqcontrol;
  wire          [1:0] pipe_tx3_eqcontrol;
  wire          [1:0] pipe_tx4_eqcontrol;
  wire          [1:0] pipe_tx5_eqcontrol;
  wire          [1:0] pipe_tx6_eqcontrol;
  wire          [1:0] pipe_tx7_eqcontrol;
  wire          [1:0] pipe_tx0_powerdown;
  wire          [1:0] pipe_tx1_powerdown;
  wire          [1:0] pipe_tx2_powerdown;
  wire          [1:0] pipe_tx3_powerdown;
  wire          [1:0] pipe_tx4_powerdown;
  wire          [1:0] pipe_tx5_powerdown;
  wire          [1:0] pipe_tx6_powerdown;
  wire          [1:0] pipe_tx7_powerdown;
  wire          [1:0] pipe_tx0_syncheader;
  wire          [1:0] pipe_tx1_syncheader;
  wire          [1:0] pipe_tx2_syncheader;
  wire          [1:0] pipe_tx3_syncheader;
  wire          [1:0] pipe_tx4_syncheader;
  wire          [1:0] pipe_tx5_syncheader;
  wire          [1:0] pipe_tx6_syncheader;
  wire          [1:0] pipe_tx7_syncheader;
  wire          [2:0] pipe_rx0_eqpreset;
  wire          [2:0] pipe_rx1_eqpreset;
  wire          [2:0] pipe_rx2_eqpreset;
  wire          [2:0] pipe_rx3_eqpreset;
  wire          [2:0] pipe_rx4_eqpreset;
  wire          [2:0] pipe_rx5_eqpreset;
  wire          [2:0] pipe_rx6_eqpreset;
  wire          [2:0] pipe_rx7_eqpreset;
  wire         [31:0] pipe_tx0_data;
  wire         [31:0] pipe_tx1_data;
  wire         [31:0] pipe_tx2_data;
  wire         [31:0] pipe_tx3_data;
  wire         [31:0] pipe_tx4_data;
  wire         [31:0] pipe_tx5_data;
  wire         [31:0] pipe_tx6_data;
  wire         [31:0] pipe_tx7_data;  
  wire          [3:0] pipe_rx0_eq_txpreset;
  wire          [3:0] pipe_rx1_eq_txpreset;
  wire          [3:0] pipe_rx2_eq_txpreset;
  wire          [3:0] pipe_rx3_eq_txpreset;
  wire          [3:0] pipe_rx4_eq_txpreset;
  wire          [3:0] pipe_rx5_eq_txpreset;
  wire          [3:0] pipe_rx6_eq_txpreset;
  wire          [3:0] pipe_rx7_eq_txpreset;
  wire          [3:0] pipe_tx0_eqpreset;
  wire          [3:0] pipe_tx1_eqpreset;
  wire          [3:0] pipe_tx2_eqpreset;
  wire          [3:0] pipe_tx3_eqpreset;
  wire          [3:0] pipe_tx4_eqpreset;
  wire          [3:0] pipe_tx5_eqpreset;
  wire          [3:0] pipe_tx6_eqpreset;
  wire          [3:0] pipe_tx7_eqpreset;
  wire          [5:0] pipe_rx0_eq_lffs;
  wire          [5:0] pipe_rx1_eq_lffs;
  wire          [5:0] pipe_rx2_eq_lffs;
  wire          [5:0] pipe_rx3_eq_lffs;
  wire          [5:0] pipe_rx4_eq_lffs;
  wire          [5:0] pipe_rx5_eq_lffs;
  wire          [5:0] pipe_rx6_eq_lffs;
  wire          [5:0] pipe_rx7_eq_lffs;
  wire          [5:0] pipe_tx0_eqdeemph;
  wire          [5:0] pipe_tx1_eqdeemph;
  wire          [5:0] pipe_tx2_eqdeemph;
  wire          [5:0] pipe_tx3_eqdeemph;
  wire          [5:0] pipe_tx4_eqdeemph;
  wire          [5:0] pipe_tx5_eqdeemph;
  wire          [5:0] pipe_tx6_eqdeemph;
  wire          [5:0] pipe_tx7_eqdeemph;
  wire          pipe_rx0_eqdone;
  wire          pipe_rx1_eqdone;
  wire          pipe_rx2_eqdone;
  wire          pipe_rx3_eqdone;
  wire          pipe_rx4_eqdone;
  wire          pipe_rx5_eqdone;
  wire          pipe_rx6_eqdone;
  wire          pipe_rx7_eqdone;
  wire         pipe_rx0_eq_adapt_done;
  wire         pipe_rx1_eq_adapt_done;
  wire         pipe_rx2_eq_adapt_done;
  wire         pipe_rx3_eq_adapt_done;
  wire         pipe_rx4_eq_adapt_done;
  wire         pipe_rx5_eq_adapt_done;
  wire         pipe_rx6_eq_adapt_done;
  wire         pipe_rx7_eq_adapt_done;
  wire         pipe_rx0_eq_lffs_sel;
  wire         pipe_rx1_eq_lffs_sel;
  wire         pipe_rx2_eq_lffs_sel;
  wire         pipe_rx3_eq_lffs_sel;
  wire         pipe_rx4_eq_lffs_sel;
  wire         pipe_rx5_eq_lffs_sel;
  wire         pipe_rx6_eq_lffs_sel;
  wire         pipe_rx7_eq_lffs_sel;
  wire         pipe_rx0_phy_status;
  wire         pipe_rx1_phy_status;
  wire         pipe_rx2_phy_status;
  wire         pipe_rx3_phy_status;
  wire         pipe_rx4_phy_status;
  wire         pipe_rx5_phy_status;
  wire         pipe_rx6_phy_status;
  wire         pipe_rx7_phy_status;
  wire         pipe_rx0_valid;
  wire         pipe_rx1_valid;
  wire         pipe_rx2_valid;
  wire         pipe_rx3_valid;
  wire         pipe_rx4_valid;
  wire         pipe_rx5_valid;
  wire         pipe_rx6_valid;
  wire         pipe_rx7_valid;
  wire         pipe_tx0_eqdone;
  wire         pipe_tx1_eqdone;
  wire         pipe_tx2_eqdone;
  wire         pipe_tx3_eqdone;
  wire         pipe_tx4_eqdone;
  wire         pipe_tx5_eqdone;
  wire         pipe_tx6_eqdone;
  wire         pipe_tx7_eqdone;
  wire         [17:0] pipe_rx0_eq_new_txcoeff;
  wire         [17:0] pipe_rx1_eq_new_txcoeff;
  wire         [17:0] pipe_rx2_eq_new_txcoeff;
  wire         [17:0] pipe_rx3_eq_new_txcoeff;
  wire         [17:0] pipe_rx4_eq_new_txcoeff;
  wire         [17:0] pipe_rx5_eq_new_txcoeff;
  wire         [17:0] pipe_rx6_eq_new_txcoeff;
  wire         [17:0] pipe_rx7_eq_new_txcoeff;
  wire         [17:0] pipe_tx0_eqcoeff;
  wire         [17:0] pipe_tx1_eqcoeff;
  wire         [17:0] pipe_tx2_eqcoeff;
  wire         [17:0] pipe_tx3_eqcoeff;
  wire         [17:0] pipe_tx4_eqcoeff;
  wire         [17:0] pipe_tx5_eqcoeff;
  wire         [17:0] pipe_tx6_eqcoeff;
  wire         [17:0] pipe_tx7_eqcoeff;
  wire          [1:0] pipe_rx0_char_is_k;
  wire          [1:0] pipe_rx1_char_is_k;
  wire          [1:0] pipe_rx2_char_is_k;
  wire          [1:0] pipe_rx3_char_is_k;
  wire          [1:0] pipe_rx4_char_is_k;
  wire          [1:0] pipe_rx5_char_is_k;
  wire          [1:0] pipe_rx6_char_is_k;
  wire          [1:0] pipe_rx7_char_is_k;
  wire         [2:0] pipe_rx0_status;
  wire         [2:0] pipe_rx1_status;
  wire         [2:0] pipe_rx2_status;
  wire         [2:0] pipe_rx3_status;
  wire         [2:0] pipe_rx4_status;
  wire         [2:0] pipe_rx5_status;
  wire         [2:0] pipe_rx6_status;
  wire         [2:0] pipe_rx7_status;
  wire         [31:0] pipe_rx0_data;
  wire         [31:0] pipe_rx1_data;
  wire         [31:0] pipe_rx2_data;
  wire         [31:0] pipe_rx3_data;
  wire         [31:0] pipe_rx4_data;
  wire         [31:0] pipe_rx5_data;
  wire         [31:0] pipe_rx6_data;
  wire         [31:0] pipe_rx7_data;
  wire         pipe_rx0_data_valid;  
  wire         pipe_rx1_data_valid;  
  wire         pipe_rx2_data_valid;  
  wire         pipe_rx3_data_valid;  
  wire         pipe_rx4_data_valid;  
  wire         pipe_rx5_data_valid;  
  wire         pipe_rx6_data_valid;  
  wire         pipe_rx7_data_valid;  
  wire         pipe_rx0_elec_idle;
  wire         pipe_rx1_elec_idle;
  wire         pipe_rx2_elec_idle;
  wire         pipe_rx3_elec_idle;
  wire         pipe_rx4_elec_idle;
  wire         pipe_rx5_elec_idle;
  wire         pipe_rx6_elec_idle;
  wire         pipe_rx7_elec_idle;
  wire         pipe_rx0_start_block;
  wire         pipe_rx1_start_block;
  wire         pipe_rx2_start_block;
  wire         pipe_rx3_start_block;
  wire         pipe_rx4_start_block;
  wire         pipe_rx5_start_block;
  wire         pipe_rx6_start_block;
  wire         pipe_rx7_start_block;
  wire         [1:0] pipe_rx0_syncheader;
  wire         [1:0] pipe_rx1_syncheader;
  wire         [1:0] pipe_rx2_syncheader;
  wire         [1:0] pipe_rx3_syncheader;
  wire         [1:0] pipe_rx4_syncheader;
  wire         [1:0] pipe_rx5_syncheader;
  wire         [1:0] pipe_rx6_syncheader;
  wire         [1:0] pipe_rx7_syncheader;
  wire                sys_or_hot_rst;
  wire                sys_clk_bufg;
  wire                user_lnk_up_int;
  wire                mcap_pcie_request;
  wire                mcap_external_request;
  wire         [15:0] cfg_dev_id_mux;
  wire         [63:0] cfg_dsn_mux;
  wire          [7:0] cfg_rev_id_mux;
  wire         [15:0] cfg_subsys_id_mux;
  wire         [15:0] cfg_subsys_vend_id_mux;
  wire         [15:0] cfg_vend_id_mux;
  wire                cfg_config_space_enable_mux;
  wire                cfg_link_training_enable_mux;
  wire                cfg_interrupt_msix_int_mux;
  wire                conf_req_valid_mux;
  wire                drp_en_mux;
  wire [((PL_LINK_CAP_MAX_LINK_WIDTH*3)-1):0] gt_loopback_mux;
  wire [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] gt_pcieuserratedone_mux;
  wire [((PL_LINK_CAP_MAX_LINK_WIDTH*4)-1):0] gt_rxprbssel_mux;
  wire [((PL_LINK_CAP_MAX_LINK_WIDTH*4)-1):0] gt_txprbssel_mux;
  wire                pl_eq_reset_eieos_count_mux;
  wire                pl_gen2_upstream_prefer_deemph_mux;
  wire                cfg_err_cor_in_mux;
  wire                cfg_err_uncor_in_mux;
  wire                cfg_hot_reset_in_mux;
  wire          [3:0] cfg_flr_done_mux;
  wire          [3:0] cfg_interrupt_int_mux;
  wire         [31:0] cfg_interrupt_msi_int_mux;
  wire                cfg_interrupt_msi_pending_status_data_enable_mux;
  wire                cfg_mgmt_write_mux;
  wire                cfg_msg_transmit_mux;
  wire                cfg_power_state_change_ack_mux;
  wire                cfg_req_pm_transition_l23_ready_mux;
  wire          [7:0] cfg_vf_flr_done_mux;
  wire [((PL_LINK_CAP_MAX_LINK_WIDTH *  1)-1):0] ext_ch_gt_drpen_mux;
  wire                pcie_cq_np_req_mux;
  wire         [21:0] m_axis_rc_tready_mux;
  wire         [21:0] m_axis_cq_tready_mux;
  wire                s_axis_rq_tvalid_mux;
  wire                s_axis_cc_tvalid_mux;
  wire                m_axis_rc_tvalid_wire;
  wire                m_axis_cq_tvalid_wire;
  wire          [3:0] s_axis_rq_tready_wire;
  wire          [3:0] s_axis_cc_tready_wire;
  wire                conf_req_ready_wire;
  wire                design_switch_net;
  reg                 reg_user_lnk_up;
  reg                 user_reset_int;
  reg                 reg_user_reset;


  assign sys_rst_n = sys_reset_pt;
  assign pcie_perstn0_out = sys_reset_pt;
  assign sys_or_hot_rst = ~sys_rst_n || cfg_hot_reset_out;
  assign user_lnk_up_int = (cfg_phy_link_status == 2'b11) ? 1'b1 : 1'b0;
 
  wire sync_sc_ce;
  wire sync_sc_clr; 
//  BUFG_GT bufg_gt_sysclk (.CE (1'd1), .CEMASK (1'd0), .CLR (1'd0), .CLRMASK (1'd0), .DIV (3'd0), .I (sys_clk), .O (sys_clk_bufg));
  BUFG_GT bufg_gt_sysclk (.CE (sync_sc_ce), .CEMASK (1'd0), .CLR (sync_sc_clr), .CLRMASK (1'd0), .DIV (3'd0), .I (sys_clk), .O (sys_clk_bufg));
  BUFG_GT_SYNC sync_sys_clk (.CESYNC(sync_sc_ce), .CLRSYNC(sync_sc_clr), .CE(1'b1), .CLK(sys_clk), .CLR(1'b0));


  always @(posedge user_clk)
  begin
    if (!sys_rst_n)
    begin
      reg_user_lnk_up <= #TCQ 1'b0;
    end
    else
    begin
      reg_user_lnk_up <= #TCQ user_lnk_up_int;
    end
  end

  assign user_lnk_up = reg_user_lnk_up;

  always @(posedge user_clk or posedge sys_or_hot_rst)
  begin
    if (sys_or_hot_rst)
    begin
      user_reset_int <= #TCQ 1'b1;
    end
    else
    if (cfg_phy_link_status[1] && !cfg_phy_link_down)
    begin
      user_reset_int <= #TCQ 1'b0;
    end
  end

  always @(posedge user_clk or posedge sys_or_hot_rst)
  begin
    if (sys_or_hot_rst)
    begin
      reg_user_reset <= #TCQ 1'b1;
    end
    else
    begin
      reg_user_reset <= #TCQ user_reset_int;
    end
  end

  assign user_reset = reg_user_reset;
  assign cap_req = mcap_pcie_request;
  assign mcap_external_request = (~cap_gnt) | cap_rel;


initial begin
  $printtimescale;
  $display("Ref Clk Freq: %0d \t User Clk Freq: %0d \t PCIE Link Speed: %0d", REF_CLK_FREQ, USER_CLK_FREQ, PCIE_LINK_SPEED);
end

generate if (EXT_PIPE_SIM == "TRUE") 
begin

  /////////////// phy_rdy, rcvr det , seepd_change & gt_powerdown /////////////////////////////
  
  reg [31:0] phy_rdy_reg = 32'b0;
  reg [31:0] rcvr_det_reg     = 32'b0;
  reg  [7:0] pipe_rate_reg    = 8'b0;
  reg  [7:0] gt_powerdown_reg = {4{2'b10}};
  
  wire      rcvr_det;
  wire      speed_change;
  wire      gt_powerdown;
    
  always @ (posedge pipe_clk)
  begin
   phy_rdy_reg      <= {phy_rdy_reg[30:0], sys_rst_n};
   rcvr_det_reg     <= {rcvr_det_reg[30:0], pipe_tx0_rcvr_det};
   pipe_rate_reg    <= {pipe_rate_reg[5:0], common_commands_out[2:1]};
   gt_powerdown_reg <= {gt_powerdown_reg[5:0],pipe_tx_0_sigs[41:40]};
  end 
  
  assign phy_rdy      =  phy_rdy_reg[31];
  assign rcvr_det     = ~rcvr_det_reg[30] && rcvr_det_reg[29];
  assign speed_change = (pipe_rate_reg[7:6] != pipe_rate_reg[5:4])? 1'b1 : 1'b0;
  assign gt_powerdown = (gt_powerdown_reg[7:6] == 2'b10 && gt_powerdown_reg[5:4] == 2'b0)? 1'b1 : 1'b0;
  
  
  
  //////// generate Rx status and Phy status ////////////// 
  
  wire [2:0] rx_status;
  wire       phy_status;
  
  assign  rx_status  = (pipe_tx0_rcvr_det && rcvr_det) ? 3'b011 : 3'b0;
  assign  phy_status = (pipe_tx0_rcvr_det && rcvr_det) || speed_change || gt_powerdown ;

   
  //////// generate clocks for pipe mode //////////////
 
  wire clk_500;
  wire clk_250;
  wire clk_125;
  wire clk_62_5;
 
  sys_clk_gen 	#(.offset(7000),.halfcycle(1000)) clk_gen_500  (.sys_clk(clk_500));
  sys_clk_gen 	#(.offset(6000),.halfcycle(2000)) clk_gen_250  (.sys_clk(clk_250));
  sys_clk_gen 	#(.offset(4000),.halfcycle(4000)) clk_gen_125  (.sys_clk(clk_125));
  sys_clk_gen 	#(.offset(0000),.halfcycle(8000)) clk_gen_62_5 (.sys_clk(clk_62_5));
 
  assign mcap_clk = (USER_CLK_FREQ == 3) ? clk_125 : user_clk;
  assign pipe_clk = common_commands_in[0];
  assign core_clk = (CRM_CORE_CLK_FREQ_500 == "TRUE") ? clk_500 : clk_250 ;
  assign user_clk = (USER_CLK_FREQ == 3) ? clk_250: ((USER_CLK_FREQ == 2) ? clk_125 : clk_62_5);

  rp_pcie3_uscale_top 
 #(
    .TCQ (TCQ),
    .NO_DECODE_LOGIC (NO_DECODE_LOGIC),
    .INTERFACE_SPEED (INTERFACE_SPEED),
    .COMPLETION_SPACE (COMPLETION_SPACE),
    .KEEP_WIDTH (KEEP_WIDTH),
    .C_DATA_WIDTH (C_DATA_WIDTH),
    .PIPE_PIPELINE_STAGES (PIPE_PIPELINE_STAGES),
    .ARI_CAP_ENABLE (ARI_CAP_ENABLE),
    .AXISTEN_IF_CC_ALIGNMENT_MODE (AXISTEN_IF_CC_ALIGNMENT_MODE),
    .AXISTEN_IF_CC_PARITY_CHK (AXISTEN_IF_CC_PARITY_CHK),
    .AXISTEN_IF_CQ_ALIGNMENT_MODE (AXISTEN_IF_CQ_ALIGNMENT_MODE),
    .AXISTEN_IF_ENABLE_CLIENT_TAG (AXISTEN_IF_ENABLE_CLIENT_TAG),
    .AXISTEN_IF_ENABLE_MSG_ROUTE (AXISTEN_IF_ENABLE_MSG_ROUTE),
    .AXISTEN_IF_ENABLE_RX_MSG_INTFC (AXISTEN_IF_ENABLE_RX_MSG_INTFC),
    .AXISTEN_IF_RC_ALIGNMENT_MODE (AXISTEN_IF_RC_ALIGNMENT_MODE),
    .AXISTEN_IF_RC_STRADDLE (AXISTEN_IF_RC_STRADDLE),
    .AXISTEN_IF_RQ_ALIGNMENT_MODE (AXISTEN_IF_RQ_ALIGNMENT_MODE),
    .AXISTEN_IF_RQ_PARITY_CHK (AXISTEN_IF_RQ_PARITY_CHK),
    .AXISTEN_IF_WIDTH (AXISTEN_IF_WIDTH),
    .CRM_CORE_CLK_FREQ_500 (CRM_CORE_CLK_FREQ_500),
    .CRM_USER_CLK_FREQ (CRM_USER_CLK_FREQ),
    .DEBUG_CFG_LOCAL_MGMT_REG_ACCESS_OVERRIDE (DEBUG_CFG_LOCAL_MGMT_REG_ACCESS_OVERRIDE),
    .DEBUG_PL_DISABLE_EI_INFER_IN_L0 (DEBUG_PL_DISABLE_EI_INFER_IN_L0),
    .DEBUG_TL_DISABLE_RX_TLP_ORDER_CHECKS (DEBUG_TL_DISABLE_RX_TLP_ORDER_CHECKS),
    .DNSTREAM_LINK_NUM (DNSTREAM_LINK_NUM),
    .LL_ACK_TIMEOUT (LL_ACK_TIMEOUT),
    .LL_ACK_TIMEOUT_EN (LL_ACK_TIMEOUT_EN),
    .LL_ACK_TIMEOUT_FUNC (LL_ACK_TIMEOUT_FUNC),
    .LL_CPL_FC_UPDATE_TIMER (LL_CPL_FC_UPDATE_TIMER),
    .LL_CPL_FC_UPDATE_TIMER_OVERRIDE (LL_CPL_FC_UPDATE_TIMER_OVERRIDE),
    .LL_FC_UPDATE_TIMER (LL_FC_UPDATE_TIMER),
    .LL_FC_UPDATE_TIMER_OVERRIDE (LL_FC_UPDATE_TIMER_OVERRIDE),
    .LL_NP_FC_UPDATE_TIMER (LL_NP_FC_UPDATE_TIMER),
    .LL_NP_FC_UPDATE_TIMER_OVERRIDE (LL_NP_FC_UPDATE_TIMER_OVERRIDE),
    .LL_P_FC_UPDATE_TIMER (LL_P_FC_UPDATE_TIMER),
    .LL_P_FC_UPDATE_TIMER_OVERRIDE (LL_P_FC_UPDATE_TIMER_OVERRIDE),
    .LL_REPLAY_TIMEOUT (LL_REPLAY_TIMEOUT),
    .LL_REPLAY_TIMEOUT_EN (LL_REPLAY_TIMEOUT_EN),
    .LL_REPLAY_TIMEOUT_FUNC (LL_REPLAY_TIMEOUT_FUNC),
    .LTR_TX_MESSAGE_MINIMUM_INTERVAL (LTR_TX_MESSAGE_MINIMUM_INTERVAL),
    .LTR_TX_MESSAGE_ON_FUNC_POWER_STATE_CHANGE (LTR_TX_MESSAGE_ON_FUNC_POWER_STATE_CHANGE),
    .LTR_TX_MESSAGE_ON_LTR_ENABLE (LTR_TX_MESSAGE_ON_LTR_ENABLE),
    .MCAP_CAP_NEXTPTR (MCAP_CAP_NEXTPTR),
    .MCAP_CONFIGURE_OVERRIDE (MCAP_CONFIGURE_OVERRIDE),
    .MCAP_ENABLE (MCAP_ENABLE),
    .MCAP_EOS_DESIGN_SWITCH (MCAP_EOS_DESIGN_SWITCH),
    .MCAP_FPGA_BITSTREAM_VERSION (MCAP_FPGA_BITSTREAM_VERSION),
    .MCAP_GATE_IO_ENABLE_DESIGN_SWITCH (MCAP_GATE_IO_ENABLE_DESIGN_SWITCH),
    .MCAP_GATE_MEM_ENABLE_DESIGN_SWITCH (MCAP_GATE_MEM_ENABLE_DESIGN_SWITCH),
    .MCAP_INPUT_GATE_DESIGN_SWITCH (MCAP_INPUT_GATE_DESIGN_SWITCH),
    .MCAP_INTERRUPT_ON_MCAP_EOS (MCAP_INTERRUPT_ON_MCAP_EOS),
    .MCAP_INTERRUPT_ON_MCAP_ERROR (MCAP_INTERRUPT_ON_MCAP_ERROR),
    .MCAP_VSEC_ID (MCAP_VSEC_ID),
    .MCAP_VSEC_LEN (MCAP_VSEC_LEN),
    .MCAP_VSEC_REV (MCAP_VSEC_REV),
    .PF0_AER_CAP_ECRC_CHECK_CAPABLE (PF0_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF0_AER_CAP_ECRC_GEN_CAPABLE (PF0_AER_CAP_ECRC_GEN_CAPABLE),
    .PF0_AER_CAP_NEXTPTR (PF0_AER_CAP_NEXTPTR),
    .PF0_ARI_CAP_NEXT_FUNC (PF0_ARI_CAP_NEXT_FUNC),
    .PF0_ARI_CAP_NEXTPTR (PF0_ARI_CAP_NEXTPTR),
    .PF0_ARI_CAP_VER (PF0_ARI_CAP_VER),
    .PF0_BAR0_APERTURE_SIZE (PF0_BAR0_APERTURE_SIZE),
    .PF0_BAR0_CONTROL (PF0_BAR0_CONTROL),
    .PF0_BAR1_APERTURE_SIZE (PF0_BAR1_APERTURE_SIZE),
    .PF0_BAR1_CONTROL (PF0_BAR1_CONTROL),
    .PF0_BAR2_APERTURE_SIZE (PF0_BAR2_APERTURE_SIZE),
    .PF0_BAR2_CONTROL (PF0_BAR2_CONTROL),
    .PF0_BAR3_APERTURE_SIZE (PF0_BAR3_APERTURE_SIZE),
    .PF0_BAR3_CONTROL (PF0_BAR3_CONTROL),
    .PF0_BAR4_APERTURE_SIZE (PF0_BAR4_APERTURE_SIZE),
    .PF0_BAR4_CONTROL (PF0_BAR4_CONTROL),
    .PF0_BAR5_APERTURE_SIZE (PF0_BAR5_APERTURE_SIZE),
    .PF0_BAR5_CONTROL (PF0_BAR5_CONTROL),
    .PF0_BIST_REGISTER (PF0_BIST_REGISTER),
    .PF0_CAPABILITY_POINTER (PF0_CAPABILITY_POINTER),
    .PF0_CLASS_CODE (PF0_CLASS_CODE),
    .PF0_DEV_CAP_ENDPOINT_L0S_LATENCY (PF0_DEV_CAP_ENDPOINT_L0S_LATENCY),
    .PF0_DEV_CAP_ENDPOINT_L1_LATENCY (PF0_DEV_CAP_ENDPOINT_L1_LATENCY),
    .PF0_DEV_CAP_EXT_TAG_SUPPORTED (PF0_DEV_CAP_EXT_TAG_SUPPORTED),
    .PF0_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE (PF0_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE),
    .PF0_DEV_CAP_MAX_PAYLOAD_SIZE (PF0_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF0_DEV_CAP2_ARI_FORWARD_ENABLE (PF0_DEV_CAP2_ARI_FORWARD_ENABLE),
    .PF0_DEV_CAP2_CPL_TIMEOUT_DISABLE (PF0_DEV_CAP2_CPL_TIMEOUT_DISABLE),
    .PF0_DEV_CAP2_LTR_SUPPORT (PF0_DEV_CAP2_LTR_SUPPORT),
    .PF0_DEV_CAP2_OBFF_SUPPORT (PF0_DEV_CAP2_OBFF_SUPPORT),
    .PF0_DEV_CAP2_TPH_COMPLETER_SUPPORT (PF0_DEV_CAP2_TPH_COMPLETER_SUPPORT),
    .PF0_DEV_CAP2_32B_ATOMIC_COMPLETER_SUPPORT (PF0_DEV_CAP2_32B_ATOMIC_COMPLETER_SUPPORT),
    .PF0_DEV_CAP2_64B_ATOMIC_COMPLETER_SUPPORT (PF0_DEV_CAP2_64B_ATOMIC_COMPLETER_SUPPORT),
    .PF0_DEV_CAP2_128B_CAS_ATOMIC_COMPLETER_SUPPORT (PF0_DEV_CAP2_128B_CAS_ATOMIC_COMPLETER_SUPPORT),
    .PF0_DEVICE_ID (PF0_DEVICE_ID),
    .PF0_DPA_CAP_NEXTPTR (PF0_DPA_CAP_NEXTPTR),
    .PF0_DPA_CAP_SUB_STATE_CONTROL (PF0_DPA_CAP_SUB_STATE_CONTROL),
    .PF0_DPA_CAP_SUB_STATE_CONTROL_EN (PF0_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF0_DPA_CAP_VER (PF0_DPA_CAP_VER),
    .PF0_DSN_CAP_NEXTPTR (PF0_DSN_CAP_NEXTPTR),
    .PF0_EXPANSION_ROM_APERTURE_SIZE (PF0_EXPANSION_ROM_APERTURE_SIZE),
    .PF0_EXPANSION_ROM_ENABLE (PF0_EXPANSION_ROM_ENABLE),
    .PF0_INTERRUPT_LINE (PF0_INTERRUPT_LINE),
    .PF0_INTERRUPT_PIN (PF0_INTERRUPT_PIN),
    .PF0_LINK_CAP_ASPM_SUPPORT (PF0_LINK_CAP_ASPM_SUPPORT),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 (PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 (PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN3 (PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN3),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN1 (PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN1),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN2 (PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN2),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN3 (PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN3),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 (PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 (PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN3 (PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN3),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_GEN1 (PF0_LINK_CAP_L1_EXIT_LATENCY_GEN1),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_GEN2 (PF0_LINK_CAP_L1_EXIT_LATENCY_GEN2),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_GEN3 (PF0_LINK_CAP_L1_EXIT_LATENCY_GEN3),
    .PF0_LINK_STATUS_SLOT_CLOCK_CONFIG (PF0_LINK_STATUS_SLOT_CLOCK_CONFIG),
    .PF0_LTR_CAP_MAX_NOSNOOP_LAT (PF0_LTR_CAP_MAX_NOSNOOP_LAT),
    .PF0_LTR_CAP_MAX_SNOOP_LAT (PF0_LTR_CAP_MAX_SNOOP_LAT),
    .PF0_LTR_CAP_NEXTPTR (PF0_LTR_CAP_NEXTPTR),
    .PF0_LTR_CAP_VER (PF0_LTR_CAP_VER),
    .PF0_MSI_CAP_MULTIMSGCAP (PF0_MSI_CAP_MULTIMSGCAP),
    .PF0_MSI_CAP_NEXTPTR (PF0_MSI_CAP_NEXTPTR),
    .PF0_MSI_CAP_PERVECMASKCAP (PF0_MSI_CAP_PERVECMASKCAP),
    .PF0_MSIX_CAP_NEXTPTR (PF0_MSIX_CAP_NEXTPTR),
    .PF0_MSIX_CAP_PBA_BIR (PF0_MSIX_CAP_PBA_BIR),
    .PF0_MSIX_CAP_PBA_OFFSET (PF0_MSIX_CAP_PBA_OFFSET),
    .PF0_MSIX_CAP_TABLE_BIR (PF0_MSIX_CAP_TABLE_BIR),
    .PF0_MSIX_CAP_TABLE_OFFSET (PF0_MSIX_CAP_TABLE_OFFSET),
    .PF0_MSIX_CAP_TABLE_SIZE (PF0_MSIX_CAP_TABLE_SIZE),
    .PF0_PB_CAP_DATA_REG_D0 (PF0_PB_CAP_DATA_REG_D0),
    .PF0_PB_CAP_DATA_REG_D0_SUSTAINED (PF0_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF0_PB_CAP_DATA_REG_D1 (PF0_PB_CAP_DATA_REG_D1),
    .PF0_PB_CAP_DATA_REG_D3HOT (PF0_PB_CAP_DATA_REG_D3HOT),
    .PF0_PB_CAP_NEXTPTR (PF0_PB_CAP_NEXTPTR),
    .PF0_PB_CAP_SYSTEM_ALLOCATED (PF0_PB_CAP_SYSTEM_ALLOCATED),
    .PF0_PB_CAP_VER (PF0_PB_CAP_VER),
    .PF0_PM_CAP_ID (PF0_PM_CAP_ID),
    .PF0_PM_CAP_NEXTPTR (PF0_PM_CAP_NEXTPTR),
    .PF0_PM_CAP_PMESUPPORT_D0 (PF0_PM_CAP_PMESUPPORT_D0),
    .PF0_PM_CAP_PMESUPPORT_D1 (PF0_PM_CAP_PMESUPPORT_D1),
    .PF0_PM_CAP_PMESUPPORT_D3HOT (PF0_PM_CAP_PMESUPPORT_D3HOT),
    .PF0_PM_CAP_SUPP_D1_STATE (PF0_PM_CAP_SUPP_D1_STATE),
    .PF0_PM_CAP_VER_ID (PF0_PM_CAP_VER_ID),
    .PF0_PM_CSR_NOSOFTRESET (PF0_PM_CSR_NOSOFTRESET),
    .PF0_RBAR_CAP_ENABLE (PF0_RBAR_CAP_ENABLE),
    .PF0_RBAR_CAP_NEXTPTR (PF0_RBAR_CAP_NEXTPTR),
    .PF0_RBAR_CAP_SIZE0 (PF0_RBAR_CAP_SIZE0),
    .PF0_RBAR_CAP_SIZE1 (PF0_RBAR_CAP_SIZE1),
    .PF0_RBAR_CAP_SIZE2 (PF0_RBAR_CAP_SIZE2),
    .PF0_RBAR_CAP_VER (PF0_RBAR_CAP_VER),
    .PF0_RBAR_CONTROL_INDEX0 (PF0_RBAR_CONTROL_INDEX0),
    .PF0_RBAR_CONTROL_INDEX1 (PF0_RBAR_CONTROL_INDEX1),
    .PF0_RBAR_CONTROL_INDEX2 (PF0_RBAR_CONTROL_INDEX2),
    .PF0_RBAR_CONTROL_SIZE0 (PF0_RBAR_CONTROL_SIZE0),
    .PF0_RBAR_CONTROL_SIZE1 (PF0_RBAR_CONTROL_SIZE1),
    .PF0_RBAR_CONTROL_SIZE2 (PF0_RBAR_CONTROL_SIZE2),
    .PF0_RBAR_NUM (PF0_RBAR_NUM),
    .PF0_REVISION_ID (PF0_REVISION_ID),
    .PF0_SECONDARY_PCIE_CAP_NEXTPTR (PF0_SECONDARY_PCIE_CAP_NEXTPTR),
    .PF0_SRIOV_BAR0_APERTURE_SIZE (PF0_SRIOV_BAR0_APERTURE_SIZE),
    .PF0_SRIOV_BAR0_CONTROL (PF0_SRIOV_BAR0_CONTROL),
    .PF0_SRIOV_BAR1_APERTURE_SIZE (PF0_SRIOV_BAR1_APERTURE_SIZE),
    .PF0_SRIOV_BAR1_CONTROL (PF0_SRIOV_BAR1_CONTROL),
    .PF0_SRIOV_BAR2_APERTURE_SIZE (PF0_SRIOV_BAR2_APERTURE_SIZE),
    .PF0_SRIOV_BAR2_CONTROL (PF0_SRIOV_BAR2_CONTROL),
    .PF0_SRIOV_BAR3_APERTURE_SIZE (PF0_SRIOV_BAR3_APERTURE_SIZE),
    .PF0_SRIOV_BAR3_CONTROL (PF0_SRIOV_BAR3_CONTROL),
    .PF0_SRIOV_BAR4_APERTURE_SIZE (PF0_SRIOV_BAR4_APERTURE_SIZE),
    .PF0_SRIOV_BAR4_CONTROL (PF0_SRIOV_BAR4_CONTROL),
    .PF0_SRIOV_BAR5_APERTURE_SIZE (PF0_SRIOV_BAR5_APERTURE_SIZE),
    .PF0_SRIOV_BAR5_CONTROL (PF0_SRIOV_BAR5_CONTROL),
    .PF0_SRIOV_CAP_INITIAL_VF (PF0_SRIOV_CAP_INITIAL_VF),
    .PF0_SRIOV_CAP_NEXTPTR (PF0_SRIOV_CAP_NEXTPTR),
    .PF0_SRIOV_CAP_TOTAL_VF (PF0_SRIOV_CAP_TOTAL_VF),
    .PF0_SRIOV_CAP_VER (PF0_SRIOV_CAP_VER),
    .PF0_SRIOV_FIRST_VF_OFFSET (PF0_SRIOV_FIRST_VF_OFFSET),
    .PF0_SRIOV_FUNC_DEP_LINK (PF0_SRIOV_FUNC_DEP_LINK),
    .PF0_SRIOV_SUPPORTED_PAGE_SIZE (PF0_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF0_SRIOV_VF_DEVICE_ID (PF0_SRIOV_VF_DEVICE_ID),
    .PF0_SUBSYSTEM_ID (PF0_SUBSYSTEM_ID),
    .PF0_TPHR_CAP_DEV_SPECIFIC_MODE (PF0_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF0_TPHR_CAP_ENABLE (PF0_TPHR_CAP_ENABLE),
    .PF0_TPHR_CAP_INT_VEC_MODE (PF0_TPHR_CAP_INT_VEC_MODE),
    .PF0_TPHR_CAP_NEXTPTR (PF0_TPHR_CAP_NEXTPTR),
    .PF0_TPHR_CAP_ST_MODE_SEL (PF0_TPHR_CAP_ST_MODE_SEL),
    .PF0_TPHR_CAP_ST_TABLE_LOC (PF0_TPHR_CAP_ST_TABLE_LOC),
    .PF0_TPHR_CAP_ST_TABLE_SIZE (PF0_TPHR_CAP_ST_TABLE_SIZE),
    .PF0_TPHR_CAP_VER (PF0_TPHR_CAP_VER),
    .PF0_VC_CAP_ENABLE (PF0_VC_CAP_ENABLE),
    .PF0_VC_CAP_NEXTPTR (PF0_VC_CAP_NEXTPTR),
    .PF0_VC_CAP_VER (PF0_VC_CAP_VER),
    .PF1_AER_CAP_ECRC_CHECK_CAPABLE (PF1_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF1_AER_CAP_ECRC_GEN_CAPABLE (PF1_AER_CAP_ECRC_GEN_CAPABLE),
    .PF1_AER_CAP_NEXTPTR (PF1_AER_CAP_NEXTPTR),
    .PF1_ARI_CAP_NEXT_FUNC (PF1_ARI_CAP_NEXT_FUNC),
    .PF1_ARI_CAP_NEXTPTR (PF1_ARI_CAP_NEXTPTR),
    .PF1_BAR0_APERTURE_SIZE (PF1_BAR0_APERTURE_SIZE),
    .PF1_BAR0_CONTROL (PF1_BAR0_CONTROL),
    .PF1_BAR1_APERTURE_SIZE (PF1_BAR1_APERTURE_SIZE),
    .PF1_BAR1_CONTROL (PF1_BAR1_CONTROL),
    .PF1_BAR2_APERTURE_SIZE (PF1_BAR2_APERTURE_SIZE),
    .PF1_BAR2_CONTROL (PF1_BAR2_CONTROL),
    .PF1_BAR3_APERTURE_SIZE (PF1_BAR3_APERTURE_SIZE),
    .PF1_BAR3_CONTROL (PF1_BAR3_CONTROL),
    .PF1_BAR4_APERTURE_SIZE (PF1_BAR4_APERTURE_SIZE),
    .PF1_BAR4_CONTROL (PF1_BAR4_CONTROL),
    .PF1_BAR5_APERTURE_SIZE (PF1_BAR5_APERTURE_SIZE),
    .PF1_BAR5_CONTROL (PF1_BAR5_CONTROL),
    .PF1_BIST_REGISTER (PF1_BIST_REGISTER),
    .PF1_CAPABILITY_POINTER (PF1_CAPABILITY_POINTER),
    .PF1_CLASS_CODE (PF1_CLASS_CODE),
    .PF1_DEV_CAP_MAX_PAYLOAD_SIZE (PF1_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF1_DEVICE_ID (PF1_DEVICE_ID),
    .PF1_DPA_CAP_NEXTPTR (PF1_DPA_CAP_NEXTPTR),
    .PF1_DPA_CAP_SUB_STATE_CONTROL (PF1_DPA_CAP_SUB_STATE_CONTROL),
    .PF1_DPA_CAP_SUB_STATE_CONTROL_EN (PF1_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF1_DPA_CAP_VER (PF1_DPA_CAP_VER),
    .PF1_DSN_CAP_NEXTPTR (PF1_DSN_CAP_NEXTPTR),
    .PF1_EXPANSION_ROM_APERTURE_SIZE (PF1_EXPANSION_ROM_APERTURE_SIZE),
    .PF1_EXPANSION_ROM_ENABLE (PF1_EXPANSION_ROM_ENABLE),
    .PF1_INTERRUPT_LINE (PF1_INTERRUPT_LINE),
    .PF1_INTERRUPT_PIN (PF1_INTERRUPT_PIN),
    .PF1_MSI_CAP_MULTIMSGCAP (PF1_MSI_CAP_MULTIMSGCAP),
    .PF1_MSI_CAP_NEXTPTR (PF1_MSI_CAP_NEXTPTR),
    .PF1_MSI_CAP_PERVECMASKCAP (PF1_MSI_CAP_PERVECMASKCAP),
    .PF1_MSIX_CAP_NEXTPTR (PF1_MSIX_CAP_NEXTPTR),
    .PF1_MSIX_CAP_PBA_BIR (PF1_MSIX_CAP_PBA_BIR),
    .PF1_MSIX_CAP_PBA_OFFSET (PF1_MSIX_CAP_PBA_OFFSET),
    .PF1_MSIX_CAP_TABLE_BIR (PF1_MSIX_CAP_TABLE_BIR),
    .PF1_MSIX_CAP_TABLE_OFFSET (PF1_MSIX_CAP_TABLE_OFFSET),
    .PF1_MSIX_CAP_TABLE_SIZE (PF1_MSIX_CAP_TABLE_SIZE),
    .PF1_PB_CAP_DATA_REG_D0 (PF1_PB_CAP_DATA_REG_D0),
    .PF1_PB_CAP_DATA_REG_D0_SUSTAINED (PF1_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF1_PB_CAP_DATA_REG_D1 (PF1_PB_CAP_DATA_REG_D1),
    .PF1_PB_CAP_DATA_REG_D3HOT (PF1_PB_CAP_DATA_REG_D3HOT),
    .PF1_PB_CAP_NEXTPTR (PF1_PB_CAP_NEXTPTR),
    .PF1_PB_CAP_SYSTEM_ALLOCATED (PF1_PB_CAP_SYSTEM_ALLOCATED),
    .PF1_PB_CAP_VER (PF1_PB_CAP_VER),
    .PF1_PM_CAP_ID (PF1_PM_CAP_ID),
    .PF1_PM_CAP_NEXTPTR (PF1_PM_CAP_NEXTPTR),
    .PF1_PM_CAP_VER_ID (PF1_PM_CAP_VER_ID),
    .PF1_RBAR_CAP_ENABLE (PF1_RBAR_CAP_ENABLE),
    .PF1_RBAR_CAP_NEXTPTR (PF1_RBAR_CAP_NEXTPTR),
    .PF1_RBAR_CAP_SIZE0 (PF1_RBAR_CAP_SIZE0),
    .PF1_RBAR_CAP_SIZE1 (PF1_RBAR_CAP_SIZE1),
    .PF1_RBAR_CAP_SIZE2 (PF1_RBAR_CAP_SIZE2),
    .PF1_RBAR_CAP_VER (PF1_RBAR_CAP_VER),
    .PF1_RBAR_CONTROL_INDEX0 (PF1_RBAR_CONTROL_INDEX0),
    .PF1_RBAR_CONTROL_INDEX1 (PF1_RBAR_CONTROL_INDEX1),
    .PF1_RBAR_CONTROL_INDEX2 (PF1_RBAR_CONTROL_INDEX2),
    .PF1_RBAR_CONTROL_SIZE0 (PF1_RBAR_CONTROL_SIZE0),
    .PF1_RBAR_CONTROL_SIZE1 (PF1_RBAR_CONTROL_SIZE1),
    .PF1_RBAR_CONTROL_SIZE2 (PF1_RBAR_CONTROL_SIZE2),
    .PF1_RBAR_NUM (PF1_RBAR_NUM),
    .PF1_REVISION_ID (PF1_REVISION_ID),
    .PF1_SRIOV_BAR0_APERTURE_SIZE (PF1_SRIOV_BAR0_APERTURE_SIZE),
    .PF1_SRIOV_BAR0_CONTROL (PF1_SRIOV_BAR0_CONTROL),
    .PF1_SRIOV_BAR1_APERTURE_SIZE (PF1_SRIOV_BAR1_APERTURE_SIZE),
    .PF1_SRIOV_BAR1_CONTROL (PF1_SRIOV_BAR1_CONTROL),
    .PF1_SRIOV_BAR2_APERTURE_SIZE (PF1_SRIOV_BAR2_APERTURE_SIZE),
    .PF1_SRIOV_BAR2_CONTROL (PF1_SRIOV_BAR2_CONTROL),
    .PF1_SRIOV_BAR3_APERTURE_SIZE (PF1_SRIOV_BAR3_APERTURE_SIZE),
    .PF1_SRIOV_BAR3_CONTROL (PF1_SRIOV_BAR3_CONTROL),
    .PF1_SRIOV_BAR4_APERTURE_SIZE (PF1_SRIOV_BAR4_APERTURE_SIZE),
    .PF1_SRIOV_BAR4_CONTROL (PF1_SRIOV_BAR4_CONTROL),
    .PF1_SRIOV_BAR5_APERTURE_SIZE (PF1_SRIOV_BAR5_APERTURE_SIZE),
    .PF1_SRIOV_BAR5_CONTROL (PF1_SRIOV_BAR5_CONTROL),
    .PF1_SRIOV_CAP_INITIAL_VF (PF1_SRIOV_CAP_INITIAL_VF),
    .PF1_SRIOV_CAP_NEXTPTR (PF1_SRIOV_CAP_NEXTPTR),
    .PF1_SRIOV_CAP_TOTAL_VF (PF1_SRIOV_CAP_TOTAL_VF),
    .PF1_SRIOV_CAP_VER (PF1_SRIOV_CAP_VER),
    .PF1_SRIOV_FIRST_VF_OFFSET (PF1_SRIOV_FIRST_VF_OFFSET),
    .PF1_SRIOV_FUNC_DEP_LINK (PF1_SRIOV_FUNC_DEP_LINK),
    .PF1_SRIOV_SUPPORTED_PAGE_SIZE (PF1_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF1_SRIOV_VF_DEVICE_ID (PF1_SRIOV_VF_DEVICE_ID),
    .PF1_SUBSYSTEM_ID (PF1_SUBSYSTEM_ID),
    .PF1_TPHR_CAP_DEV_SPECIFIC_MODE (PF1_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF1_TPHR_CAP_ENABLE (PF1_TPHR_CAP_ENABLE),
    .PF1_TPHR_CAP_INT_VEC_MODE (PF1_TPHR_CAP_INT_VEC_MODE),
    .PF1_TPHR_CAP_NEXTPTR (PF1_TPHR_CAP_NEXTPTR),
    .PF1_TPHR_CAP_ST_MODE_SEL (PF1_TPHR_CAP_ST_MODE_SEL),
    .PF1_TPHR_CAP_ST_TABLE_LOC (PF1_TPHR_CAP_ST_TABLE_LOC),
    .PF1_TPHR_CAP_ST_TABLE_SIZE (PF1_TPHR_CAP_ST_TABLE_SIZE),
    .PF1_TPHR_CAP_VER (PF1_TPHR_CAP_VER),
    .PF2_AER_CAP_ECRC_CHECK_CAPABLE (PF2_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF2_AER_CAP_ECRC_GEN_CAPABLE (PF2_AER_CAP_ECRC_GEN_CAPABLE),
    .PF2_AER_CAP_NEXTPTR (PF2_AER_CAP_NEXTPTR),
    .PF2_ARI_CAP_NEXT_FUNC (PF2_ARI_CAP_NEXT_FUNC),
    .PF2_ARI_CAP_NEXTPTR (PF2_ARI_CAP_NEXTPTR),
    .PF2_BAR0_APERTURE_SIZE (PF2_BAR0_APERTURE_SIZE),
    .PF2_BAR0_CONTROL (PF2_BAR0_CONTROL),
    .PF2_BAR1_APERTURE_SIZE (PF2_BAR1_APERTURE_SIZE),
    .PF2_BAR1_CONTROL (PF2_BAR1_CONTROL),
    .PF2_BAR2_APERTURE_SIZE (PF2_BAR2_APERTURE_SIZE),
    .PF2_BAR2_CONTROL (PF2_BAR2_CONTROL),
    .PF2_BAR3_APERTURE_SIZE (PF2_BAR3_APERTURE_SIZE),
    .PF2_BAR3_CONTROL (PF2_BAR3_CONTROL),
    .PF2_BAR4_APERTURE_SIZE (PF2_BAR4_APERTURE_SIZE),
    .PF2_BAR4_CONTROL (PF2_BAR4_CONTROL),
    .PF2_BAR5_APERTURE_SIZE (PF2_BAR5_APERTURE_SIZE),
    .PF2_BAR5_CONTROL (PF2_BAR5_CONTROL),
    .PF2_BIST_REGISTER (PF2_BIST_REGISTER),
    .PF2_CAPABILITY_POINTER (PF2_CAPABILITY_POINTER),
    .PF2_CLASS_CODE (PF2_CLASS_CODE),
    .PF2_DEV_CAP_MAX_PAYLOAD_SIZE (PF2_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF2_DEVICE_ID (PF2_DEVICE_ID),
    .PF2_DPA_CAP_NEXTPTR (PF2_DPA_CAP_NEXTPTR),
    .PF2_DPA_CAP_SUB_STATE_CONTROL (PF2_DPA_CAP_SUB_STATE_CONTROL),
    .PF2_DPA_CAP_SUB_STATE_CONTROL_EN (PF2_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF2_DPA_CAP_VER (PF2_DPA_CAP_VER),
    .PF2_DSN_CAP_NEXTPTR (PF2_DSN_CAP_NEXTPTR),
    .PF2_EXPANSION_ROM_APERTURE_SIZE (PF2_EXPANSION_ROM_APERTURE_SIZE),
    .PF2_EXPANSION_ROM_ENABLE (PF2_EXPANSION_ROM_ENABLE),
    .PF2_INTERRUPT_LINE (PF2_INTERRUPT_LINE),
    .PF2_INTERRUPT_PIN (PF2_INTERRUPT_PIN),
    .PF2_MSI_CAP_MULTIMSGCAP (PF2_MSI_CAP_MULTIMSGCAP),
    .PF2_MSI_CAP_NEXTPTR (PF2_MSI_CAP_NEXTPTR),
    .PF2_MSI_CAP_PERVECMASKCAP (PF2_MSI_CAP_PERVECMASKCAP),
    .PF2_MSIX_CAP_NEXTPTR (PF2_MSIX_CAP_NEXTPTR),
    .PF2_MSIX_CAP_PBA_BIR (PF2_MSIX_CAP_PBA_BIR),
    .PF2_MSIX_CAP_PBA_OFFSET (PF2_MSIX_CAP_PBA_OFFSET),
    .PF2_MSIX_CAP_TABLE_BIR (PF2_MSIX_CAP_TABLE_BIR),
    .PF2_MSIX_CAP_TABLE_OFFSET (PF2_MSIX_CAP_TABLE_OFFSET),
    .PF2_MSIX_CAP_TABLE_SIZE (PF2_MSIX_CAP_TABLE_SIZE),
    .PF2_PB_CAP_DATA_REG_D0 (PF2_PB_CAP_DATA_REG_D0),
    .PF2_PB_CAP_DATA_REG_D0_SUSTAINED (PF2_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF2_PB_CAP_DATA_REG_D1 (PF2_PB_CAP_DATA_REG_D1),
    .PF2_PB_CAP_DATA_REG_D3HOT (PF2_PB_CAP_DATA_REG_D3HOT),
    .PF2_PB_CAP_NEXTPTR (PF2_PB_CAP_NEXTPTR),
    .PF2_PB_CAP_SYSTEM_ALLOCATED (PF2_PB_CAP_SYSTEM_ALLOCATED),
    .PF2_PB_CAP_VER (PF2_PB_CAP_VER),
    .PF2_PM_CAP_ID (PF2_PM_CAP_ID),
    .PF2_PM_CAP_NEXTPTR (PF2_PM_CAP_NEXTPTR),
    .PF2_PM_CAP_VER_ID (PF2_PM_CAP_VER_ID),
    .PF2_RBAR_CAP_ENABLE (PF2_RBAR_CAP_ENABLE),
    .PF2_RBAR_CAP_NEXTPTR (PF2_RBAR_CAP_NEXTPTR),
    .PF2_RBAR_CAP_SIZE0 (PF2_RBAR_CAP_SIZE0),
    .PF2_RBAR_CAP_SIZE1 (PF2_RBAR_CAP_SIZE1),
    .PF2_RBAR_CAP_SIZE2 (PF2_RBAR_CAP_SIZE2),
    .PF2_RBAR_CAP_VER (PF2_RBAR_CAP_VER),
    .PF2_RBAR_CONTROL_INDEX0 (PF2_RBAR_CONTROL_INDEX0),
    .PF2_RBAR_CONTROL_INDEX1 (PF2_RBAR_CONTROL_INDEX1),
    .PF2_RBAR_CONTROL_INDEX2 (PF2_RBAR_CONTROL_INDEX2),
    .PF2_RBAR_CONTROL_SIZE0 (PF2_RBAR_CONTROL_SIZE0),
    .PF2_RBAR_CONTROL_SIZE1 (PF2_RBAR_CONTROL_SIZE1),
    .PF2_RBAR_CONTROL_SIZE2 (PF2_RBAR_CONTROL_SIZE2),
    .PF2_RBAR_NUM (PF2_RBAR_NUM),
    .PF2_REVISION_ID (PF2_REVISION_ID),
    .PF2_SRIOV_BAR0_APERTURE_SIZE (PF2_SRIOV_BAR0_APERTURE_SIZE),
    .PF2_SRIOV_BAR0_CONTROL (PF2_SRIOV_BAR0_CONTROL),
    .PF2_SRIOV_BAR1_APERTURE_SIZE (PF2_SRIOV_BAR1_APERTURE_SIZE),
    .PF2_SRIOV_BAR1_CONTROL (PF2_SRIOV_BAR1_CONTROL),
    .PF2_SRIOV_BAR2_APERTURE_SIZE (PF2_SRIOV_BAR2_APERTURE_SIZE),
    .PF2_SRIOV_BAR2_CONTROL (PF2_SRIOV_BAR2_CONTROL),
    .PF2_SRIOV_BAR3_APERTURE_SIZE (PF2_SRIOV_BAR3_APERTURE_SIZE),
    .PF2_SRIOV_BAR3_CONTROL (PF2_SRIOV_BAR3_CONTROL),
    .PF2_SRIOV_BAR4_APERTURE_SIZE (PF2_SRIOV_BAR4_APERTURE_SIZE),
    .PF2_SRIOV_BAR4_CONTROL (PF2_SRIOV_BAR4_CONTROL),
    .PF2_SRIOV_BAR5_APERTURE_SIZE (PF2_SRIOV_BAR5_APERTURE_SIZE),
    .PF2_SRIOV_BAR5_CONTROL (PF2_SRIOV_BAR5_CONTROL),
    .PF2_SRIOV_CAP_INITIAL_VF (PF2_SRIOV_CAP_INITIAL_VF),
    .PF2_SRIOV_CAP_NEXTPTR (PF2_SRIOV_CAP_NEXTPTR),
    .PF2_SRIOV_CAP_TOTAL_VF (PF2_SRIOV_CAP_TOTAL_VF),
    .PF2_SRIOV_CAP_VER (PF2_SRIOV_CAP_VER),
    .PF2_SRIOV_FIRST_VF_OFFSET (PF2_SRIOV_FIRST_VF_OFFSET),
    .PF2_SRIOV_FUNC_DEP_LINK (PF2_SRIOV_FUNC_DEP_LINK),
    .PF2_SRIOV_SUPPORTED_PAGE_SIZE (PF2_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF2_SRIOV_VF_DEVICE_ID (PF2_SRIOV_VF_DEVICE_ID),
    .PF2_SUBSYSTEM_ID (PF2_SUBSYSTEM_ID),
    .PF2_TPHR_CAP_DEV_SPECIFIC_MODE (PF2_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF2_TPHR_CAP_ENABLE (PF2_TPHR_CAP_ENABLE),
    .PF2_TPHR_CAP_INT_VEC_MODE (PF2_TPHR_CAP_INT_VEC_MODE),
    .PF2_TPHR_CAP_NEXTPTR (PF2_TPHR_CAP_NEXTPTR),
    .PF2_TPHR_CAP_ST_MODE_SEL (PF2_TPHR_CAP_ST_MODE_SEL),
    .PF2_TPHR_CAP_ST_TABLE_LOC (PF2_TPHR_CAP_ST_TABLE_LOC),
    .PF2_TPHR_CAP_ST_TABLE_SIZE (PF2_TPHR_CAP_ST_TABLE_SIZE),
    .PF2_TPHR_CAP_VER (PF2_TPHR_CAP_VER),
    .PF3_AER_CAP_ECRC_CHECK_CAPABLE (PF3_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF3_AER_CAP_ECRC_GEN_CAPABLE (PF3_AER_CAP_ECRC_GEN_CAPABLE),
    .PF3_AER_CAP_NEXTPTR (PF3_AER_CAP_NEXTPTR),
    .PF3_ARI_CAP_NEXT_FUNC (PF3_ARI_CAP_NEXT_FUNC),
    .PF3_ARI_CAP_NEXTPTR (PF3_ARI_CAP_NEXTPTR),
    .PF3_BAR0_APERTURE_SIZE (PF3_BAR0_APERTURE_SIZE),
    .PF3_BAR0_CONTROL (PF3_BAR0_CONTROL),
    .PF3_BAR1_APERTURE_SIZE (PF3_BAR1_APERTURE_SIZE),
    .PF3_BAR1_CONTROL (PF3_BAR1_CONTROL),
    .PF3_BAR2_APERTURE_SIZE (PF3_BAR2_APERTURE_SIZE),
    .PF3_BAR2_CONTROL (PF3_BAR2_CONTROL),
    .PF3_BAR3_APERTURE_SIZE (PF3_BAR3_APERTURE_SIZE),
    .PF3_BAR3_CONTROL (PF3_BAR3_CONTROL),
    .PF3_BAR4_APERTURE_SIZE (PF3_BAR4_APERTURE_SIZE),
    .PF3_BAR4_CONTROL (PF3_BAR4_CONTROL),
    .PF3_BAR5_APERTURE_SIZE (PF3_BAR5_APERTURE_SIZE),
    .PF3_BAR5_CONTROL (PF3_BAR5_CONTROL),
    .PF3_BIST_REGISTER (PF3_BIST_REGISTER),
    .PF3_CAPABILITY_POINTER (PF3_CAPABILITY_POINTER),
    .PF3_CLASS_CODE (PF3_CLASS_CODE),
    .PF3_DEV_CAP_MAX_PAYLOAD_SIZE (PF3_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF3_DEVICE_ID (PF3_DEVICE_ID),
    .PF3_DPA_CAP_NEXTPTR (PF3_DPA_CAP_NEXTPTR),
    .PF3_DPA_CAP_SUB_STATE_CONTROL (PF3_DPA_CAP_SUB_STATE_CONTROL),
    .PF3_DPA_CAP_SUB_STATE_CONTROL_EN (PF3_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF3_DPA_CAP_VER (PF3_DPA_CAP_VER),
    .PF3_DSN_CAP_NEXTPTR (PF3_DSN_CAP_NEXTPTR),
    .PF3_EXPANSION_ROM_APERTURE_SIZE (PF3_EXPANSION_ROM_APERTURE_SIZE),
    .PF3_EXPANSION_ROM_ENABLE (PF3_EXPANSION_ROM_ENABLE),
    .PF3_INTERRUPT_LINE (PF3_INTERRUPT_LINE),
    .PF3_INTERRUPT_PIN (PF3_INTERRUPT_PIN),
    .PF3_MSI_CAP_MULTIMSGCAP (PF3_MSI_CAP_MULTIMSGCAP),
    .PF3_MSI_CAP_NEXTPTR (PF3_MSI_CAP_NEXTPTR),
    .PF3_MSI_CAP_PERVECMASKCAP (PF3_MSI_CAP_PERVECMASKCAP),
    .PF3_MSIX_CAP_NEXTPTR (PF3_MSIX_CAP_NEXTPTR),
    .PF3_MSIX_CAP_PBA_BIR (PF3_MSIX_CAP_PBA_BIR),
    .PF3_MSIX_CAP_PBA_OFFSET (PF3_MSIX_CAP_PBA_OFFSET),
    .PF3_MSIX_CAP_TABLE_BIR (PF3_MSIX_CAP_TABLE_BIR),
    .PF3_MSIX_CAP_TABLE_OFFSET (PF3_MSIX_CAP_TABLE_OFFSET),
    .PF3_MSIX_CAP_TABLE_SIZE (PF3_MSIX_CAP_TABLE_SIZE),
    .PF3_PB_CAP_DATA_REG_D0 (PF3_PB_CAP_DATA_REG_D0),
    .PF3_PB_CAP_DATA_REG_D0_SUSTAINED (PF3_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF3_PB_CAP_DATA_REG_D1 (PF3_PB_CAP_DATA_REG_D1),
    .PF3_PB_CAP_DATA_REG_D3HOT (PF3_PB_CAP_DATA_REG_D3HOT),
    .PF3_PB_CAP_NEXTPTR (PF3_PB_CAP_NEXTPTR),
    .PF3_PB_CAP_SYSTEM_ALLOCATED (PF3_PB_CAP_SYSTEM_ALLOCATED),
    .PF3_PB_CAP_VER (PF3_PB_CAP_VER),
    .PF3_PM_CAP_ID (PF3_PM_CAP_ID),
    .PF3_PM_CAP_NEXTPTR (PF3_PM_CAP_NEXTPTR),
    .PF3_PM_CAP_VER_ID (PF3_PM_CAP_VER_ID),
    .PF3_RBAR_CAP_ENABLE (PF3_RBAR_CAP_ENABLE),
    .PF3_RBAR_CAP_NEXTPTR (PF3_RBAR_CAP_NEXTPTR),
    .PF3_RBAR_CAP_SIZE0 (PF3_RBAR_CAP_SIZE0),
    .PF3_RBAR_CAP_SIZE1 (PF3_RBAR_CAP_SIZE1),
    .PF3_RBAR_CAP_SIZE2 (PF3_RBAR_CAP_SIZE2),
    .PF3_RBAR_CAP_VER (PF3_RBAR_CAP_VER),
    .PF3_RBAR_CONTROL_INDEX0 (PF3_RBAR_CONTROL_INDEX0),
    .PF3_RBAR_CONTROL_INDEX1 (PF3_RBAR_CONTROL_INDEX1),
    .PF3_RBAR_CONTROL_INDEX2 (PF3_RBAR_CONTROL_INDEX2),
    .PF3_RBAR_CONTROL_SIZE0 (PF3_RBAR_CONTROL_SIZE0),
    .PF3_RBAR_CONTROL_SIZE1 (PF3_RBAR_CONTROL_SIZE1),
    .PF3_RBAR_CONTROL_SIZE2 (PF3_RBAR_CONTROL_SIZE2),
    .PF3_RBAR_NUM (PF3_RBAR_NUM),
    .PF3_REVISION_ID (PF3_REVISION_ID),
    .PF3_SRIOV_BAR0_APERTURE_SIZE (PF3_SRIOV_BAR0_APERTURE_SIZE),
    .PF3_SRIOV_BAR0_CONTROL (PF3_SRIOV_BAR0_CONTROL),
    .PF3_SRIOV_BAR1_APERTURE_SIZE (PF3_SRIOV_BAR1_APERTURE_SIZE),
    .PF3_SRIOV_BAR1_CONTROL (PF3_SRIOV_BAR1_CONTROL),
    .PF3_SRIOV_BAR2_APERTURE_SIZE (PF3_SRIOV_BAR2_APERTURE_SIZE),
    .PF3_SRIOV_BAR2_CONTROL (PF3_SRIOV_BAR2_CONTROL),
    .PF3_SRIOV_BAR3_APERTURE_SIZE (PF3_SRIOV_BAR3_APERTURE_SIZE),
    .PF3_SRIOV_BAR3_CONTROL (PF3_SRIOV_BAR3_CONTROL),
    .PF3_SRIOV_BAR4_APERTURE_SIZE (PF3_SRIOV_BAR4_APERTURE_SIZE),
    .PF3_SRIOV_BAR4_CONTROL (PF3_SRIOV_BAR4_CONTROL),
    .PF3_SRIOV_BAR5_APERTURE_SIZE (PF3_SRIOV_BAR5_APERTURE_SIZE),
    .PF3_SRIOV_BAR5_CONTROL (PF3_SRIOV_BAR5_CONTROL),
    .PF3_SRIOV_CAP_INITIAL_VF (PF3_SRIOV_CAP_INITIAL_VF),
    .PF3_SRIOV_CAP_NEXTPTR (PF3_SRIOV_CAP_NEXTPTR),
    .PF3_SRIOV_CAP_TOTAL_VF (PF3_SRIOV_CAP_TOTAL_VF),
    .PF3_SRIOV_CAP_VER (PF3_SRIOV_CAP_VER),
    .PF3_SRIOV_FIRST_VF_OFFSET (PF3_SRIOV_FIRST_VF_OFFSET),
    .PF3_SRIOV_FUNC_DEP_LINK (PF3_SRIOV_FUNC_DEP_LINK),
    .PF3_SRIOV_SUPPORTED_PAGE_SIZE (PF3_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF3_SRIOV_VF_DEVICE_ID (PF3_SRIOV_VF_DEVICE_ID),
    .PF3_SUBSYSTEM_ID (PF3_SUBSYSTEM_ID),
    .PF3_TPHR_CAP_DEV_SPECIFIC_MODE (PF3_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF3_TPHR_CAP_ENABLE (PF3_TPHR_CAP_ENABLE),
    .PF3_TPHR_CAP_INT_VEC_MODE (PF3_TPHR_CAP_INT_VEC_MODE),
    .PF3_TPHR_CAP_NEXTPTR (PF3_TPHR_CAP_NEXTPTR),
    .PF3_TPHR_CAP_ST_MODE_SEL (PF3_TPHR_CAP_ST_MODE_SEL),
    .PF3_TPHR_CAP_ST_TABLE_LOC (PF3_TPHR_CAP_ST_TABLE_LOC),
    .PF3_TPHR_CAP_ST_TABLE_SIZE (PF3_TPHR_CAP_ST_TABLE_SIZE),
    .PF3_TPHR_CAP_VER (PF3_TPHR_CAP_VER),
    .PL_DISABLE_AUTO_EQ_SPEED_CHANGE_TO_GEN3 (PL_DISABLE_AUTO_EQ_SPEED_CHANGE_TO_GEN3),
    .PL_DISABLE_AUTO_SPEED_CHANGE_TO_GEN2 (PL_DISABLE_AUTO_SPEED_CHANGE_TO_GEN2),
    .PL_DISABLE_EI_INFER_IN_L0 (PL_DISABLE_EI_INFER_IN_L0),
    .PL_DISABLE_GEN3_DC_BALANCE (PL_DISABLE_GEN3_DC_BALANCE),
    .PL_DISABLE_GEN3_LFSR_UPDATE_ON_SKP (PL_DISABLE_GEN3_LFSR_UPDATE_ON_SKP),
    .PL_DISABLE_RETRAIN_ON_FRAMING_ERROR (PL_DISABLE_RETRAIN_ON_FRAMING_ERROR),
    .PL_DISABLE_SCRAMBLING (PL_DISABLE_SCRAMBLING),
    .PL_DISABLE_SYNC_HEADER_FRAMING_ERROR (PL_DISABLE_SYNC_HEADER_FRAMING_ERROR),
    .PL_DISABLE_UPCONFIG_CAPABLE (PL_DISABLE_UPCONFIG_CAPABLE),
    .PL_EQ_ADAPT_DISABLE_COEFF_CHECK (PL_EQ_ADAPT_DISABLE_COEFF_CHECK),
    .PL_EQ_ADAPT_DISABLE_PRESET_CHECK (PL_EQ_ADAPT_DISABLE_PRESET_CHECK),
    .PL_EQ_ADAPT_ITER_COUNT (PL_EQ_ADAPT_ITER_COUNT),
    .PL_EQ_ADAPT_REJECT_RETRY_COUNT (PL_EQ_ADAPT_REJECT_RETRY_COUNT),
    .PL_EQ_BYPASS_PHASE23 (PL_EQ_BYPASS_PHASE23),
    .PL_EQ_DEFAULT_GEN3_RX_PRESET_HINT (PL_EQ_DEFAULT_GEN3_RX_PRESET_HINT),
    .PL_EQ_DEFAULT_GEN3_TX_PRESET (PL_EQ_DEFAULT_GEN3_TX_PRESET),
    .PL_EQ_PHASE01_RX_ADAPT (PL_EQ_PHASE01_RX_ADAPT),
    .PL_EQ_SHORT_ADAPT_PHASE (PL_EQ_SHORT_ADAPT_PHASE),
    .PL_LANE0_EQ_CONTROL (PL_LANE0_EQ_CONTROL),
    .PL_LANE1_EQ_CONTROL (PL_LANE1_EQ_CONTROL),
    .PL_LANE2_EQ_CONTROL (PL_LANE2_EQ_CONTROL),
    .PL_LANE3_EQ_CONTROL (PL_LANE3_EQ_CONTROL),
    .PL_LANE4_EQ_CONTROL (PL_LANE4_EQ_CONTROL),
    .PL_LANE5_EQ_CONTROL (PL_LANE5_EQ_CONTROL),
    .PL_LANE6_EQ_CONTROL (PL_LANE6_EQ_CONTROL),
    .PL_LANE7_EQ_CONTROL (PL_LANE7_EQ_CONTROL),
    .PL_LINK_CAP_MAX_LINK_SPEED (PL_LINK_CAP_MAX_LINK_SPEED),
    .PL_LINK_CAP_MAX_LINK_WIDTH (PL_LINK_CAP_MAX_LINK_WIDTH),
    .PL_N_FTS_COMCLK_GEN1 (PL_N_FTS_COMCLK_GEN1),
    .PL_N_FTS_COMCLK_GEN2 (PL_N_FTS_COMCLK_GEN2),
    .PL_N_FTS_COMCLK_GEN3 (PL_N_FTS_COMCLK_GEN3),
    .PL_N_FTS_GEN1 (PL_N_FTS_GEN1),
    .PL_N_FTS_GEN2 (PL_N_FTS_GEN2),
    .PL_N_FTS_GEN3 (PL_N_FTS_GEN3),
    .PL_REPORT_ALL_PHY_ERRORS (PL_REPORT_ALL_PHY_ERRORS),
  // synthesis translate_off
    .PL_SIM_FAST_LINK_TRAINING (PL_SIM_FAST_LINK_TRAINING),
  // synthesis translate_on
    .PL_UPSTREAM_FACING (PL_UPSTREAM_FACING),
    .PM_ASPML0S_TIMEOUT (PM_ASPML0S_TIMEOUT),
    .PM_ASPML1_ENTRY_DELAY (PM_ASPML1_ENTRY_DELAY),
    .PM_ENABLE_L23_ENTRY (PM_ENABLE_L23_ENTRY),
    .PM_ENABLE_SLOT_POWER_CAPTURE (PM_ENABLE_SLOT_POWER_CAPTURE),
    .PM_L1_REENTRY_DELAY (PM_L1_REENTRY_DELAY),
    .PM_PME_SERVICE_TIMEOUT_DELAY (PM_PME_SERVICE_TIMEOUT_DELAY),
    .PM_PME_TURNOFF_ACK_DELAY (PM_PME_TURNOFF_ACK_DELAY),
    .SIM_JTAG_IDCODE (SIM_JTAG_IDCODE),
    .SIM_VERSION (SIM_VERSION),
    .SPARE_BIT0 (SPARE_BIT0),
    .SPARE_BIT1 (SPARE_BIT1),
    .SPARE_BIT2 (SPARE_BIT2),
    .SPARE_BIT3 (SPARE_BIT3),
    .SPARE_BIT4 (SPARE_BIT4),
    .SPARE_BIT5 (SPARE_BIT5),
    .SPARE_BIT6 (SPARE_BIT6),
    .SPARE_BIT7 (SPARE_BIT7),
    .SPARE_BIT8 (SPARE_BIT8),
    .SPARE_BYTE0 (SPARE_BYTE0),
    .SPARE_BYTE1 (SPARE_BYTE1),
    .SPARE_BYTE2 (SPARE_BYTE2),
    .SPARE_BYTE3 (SPARE_BYTE3),
    .SPARE_WORD0 (SPARE_WORD0),
    .SPARE_WORD1 (SPARE_WORD1),
    .SPARE_WORD2 (SPARE_WORD2),
    .SPARE_WORD3 (SPARE_WORD3),
    .SRIOV_CAP_ENABLE (SRIOV_CAP_ENABLE),
    .TL_COMPL_TIMEOUT_REG0 (TL_COMPL_TIMEOUT_REG0),
    .TL_COMPL_TIMEOUT_REG1 (TL_COMPL_TIMEOUT_REG1),
    .TL_CREDITS_CD (TL_CREDITS_CD),
    .TL_CREDITS_CH (TL_CREDITS_CH),
    .TL_CREDITS_NPD (TL_CREDITS_NPD),
    .TL_CREDITS_NPH (TL_CREDITS_NPH),
    .TL_CREDITS_PD (TL_CREDITS_PD),
    .TL_CREDITS_PH (TL_CREDITS_PH),
    .TL_ENABLE_MESSAGE_RID_CHECK_ENABLE (TL_ENABLE_MESSAGE_RID_CHECK_ENABLE),
    .TL_EXTENDED_CFG_EXTEND_INTERFACE_ENABLE (TL_EXTENDED_CFG_EXTEND_INTERFACE_ENABLE),
    .TL_LEGACY_CFG_EXTEND_INTERFACE_ENABLE (TL_LEGACY_CFG_EXTEND_INTERFACE_ENABLE),
    .TL_LEGACY_MODE_ENABLE (TL_LEGACY_MODE_ENABLE),
    .TL_PF_ENABLE_REG (TL_PF_ENABLE_REG),
    .TL_TX_MUX_STRICT_PRIORITY (TL_TX_MUX_STRICT_PRIORITY),
    .TWO_LAYER_MODE_DLCMSM_ENABLE (TWO_LAYER_MODE_DLCMSM_ENABLE),
    .TWO_LAYER_MODE_ENABLE (TWO_LAYER_MODE_ENABLE),
    .TWO_LAYER_MODE_WIDTH_256 (TWO_LAYER_MODE_WIDTH_256),
    .VF0_ARI_CAP_NEXTPTR (VF0_ARI_CAP_NEXTPTR),
    .VF0_CAPABILITY_POINTER (VF0_CAPABILITY_POINTER),
    .VF0_MSI_CAP_MULTIMSGCAP (VF0_MSI_CAP_MULTIMSGCAP),
    .VF0_MSIX_CAP_PBA_BIR (VF0_MSIX_CAP_PBA_BIR),
    .VF0_MSIX_CAP_PBA_OFFSET (VF0_MSIX_CAP_PBA_OFFSET),
    .VF0_MSIX_CAP_TABLE_BIR (VF0_MSIX_CAP_TABLE_BIR),
    .VF0_MSIX_CAP_TABLE_OFFSET (VF0_MSIX_CAP_TABLE_OFFSET),
    .VF0_MSIX_CAP_TABLE_SIZE (VF0_MSIX_CAP_TABLE_SIZE),
    .VF0_PM_CAP_ID (VF0_PM_CAP_ID),
    .VF0_PM_CAP_NEXTPTR (VF0_PM_CAP_NEXTPTR),
    .VF0_PM_CAP_VER_ID (VF0_PM_CAP_VER_ID),
    .VF0_TPHR_CAP_DEV_SPECIFIC_MODE (VF0_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF0_TPHR_CAP_ENABLE (VF0_TPHR_CAP_ENABLE),
    .VF0_TPHR_CAP_INT_VEC_MODE (VF0_TPHR_CAP_INT_VEC_MODE),
    .VF0_TPHR_CAP_NEXTPTR (VF0_TPHR_CAP_NEXTPTR),
    .VF0_TPHR_CAP_ST_MODE_SEL (VF0_TPHR_CAP_ST_MODE_SEL),
    .VF0_TPHR_CAP_ST_TABLE_LOC (VF0_TPHR_CAP_ST_TABLE_LOC),
    .VF0_TPHR_CAP_ST_TABLE_SIZE (VF0_TPHR_CAP_ST_TABLE_SIZE),
    .VF0_TPHR_CAP_VER (VF0_TPHR_CAP_VER),
    .VF1_ARI_CAP_NEXTPTR (VF1_ARI_CAP_NEXTPTR),
    .VF1_MSI_CAP_MULTIMSGCAP (VF1_MSI_CAP_MULTIMSGCAP),
    .VF1_MSIX_CAP_PBA_BIR (VF1_MSIX_CAP_PBA_BIR),
    .VF1_MSIX_CAP_PBA_OFFSET (VF1_MSIX_CAP_PBA_OFFSET),
    .VF1_MSIX_CAP_TABLE_BIR (VF1_MSIX_CAP_TABLE_BIR),
    .VF1_MSIX_CAP_TABLE_OFFSET (VF1_MSIX_CAP_TABLE_OFFSET),
    .VF1_MSIX_CAP_TABLE_SIZE (VF1_MSIX_CAP_TABLE_SIZE),
    .VF1_PM_CAP_ID (VF1_PM_CAP_ID),
    .VF1_PM_CAP_NEXTPTR (VF1_PM_CAP_NEXTPTR),
    .VF1_PM_CAP_VER_ID (VF1_PM_CAP_VER_ID),
    .VF1_TPHR_CAP_DEV_SPECIFIC_MODE (VF1_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF1_TPHR_CAP_ENABLE (VF1_TPHR_CAP_ENABLE),
    .VF1_TPHR_CAP_INT_VEC_MODE (VF1_TPHR_CAP_INT_VEC_MODE),
    .VF1_TPHR_CAP_NEXTPTR (VF1_TPHR_CAP_NEXTPTR),
    .VF1_TPHR_CAP_ST_MODE_SEL (VF1_TPHR_CAP_ST_MODE_SEL),
    .VF1_TPHR_CAP_ST_TABLE_LOC (VF1_TPHR_CAP_ST_TABLE_LOC),
    .VF1_TPHR_CAP_ST_TABLE_SIZE (VF1_TPHR_CAP_ST_TABLE_SIZE),
    .VF1_TPHR_CAP_VER (VF1_TPHR_CAP_VER),
    .VF2_ARI_CAP_NEXTPTR (VF2_ARI_CAP_NEXTPTR),
    .VF2_MSI_CAP_MULTIMSGCAP (VF2_MSI_CAP_MULTIMSGCAP),
    .VF2_MSIX_CAP_PBA_BIR (VF2_MSIX_CAP_PBA_BIR),
    .VF2_MSIX_CAP_PBA_OFFSET (VF2_MSIX_CAP_PBA_OFFSET),
    .VF2_MSIX_CAP_TABLE_BIR (VF2_MSIX_CAP_TABLE_BIR),
    .VF2_MSIX_CAP_TABLE_OFFSET (VF2_MSIX_CAP_TABLE_OFFSET),
    .VF2_MSIX_CAP_TABLE_SIZE (VF2_MSIX_CAP_TABLE_SIZE),
    .VF2_PM_CAP_ID (VF2_PM_CAP_ID),
    .VF2_PM_CAP_NEXTPTR (VF2_PM_CAP_NEXTPTR),
    .VF2_PM_CAP_VER_ID (VF2_PM_CAP_VER_ID),
    .VF2_TPHR_CAP_DEV_SPECIFIC_MODE (VF2_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF2_TPHR_CAP_ENABLE (VF2_TPHR_CAP_ENABLE),
    .VF2_TPHR_CAP_INT_VEC_MODE (VF2_TPHR_CAP_INT_VEC_MODE),
    .VF2_TPHR_CAP_NEXTPTR (VF2_TPHR_CAP_NEXTPTR),
    .VF2_TPHR_CAP_ST_MODE_SEL (VF2_TPHR_CAP_ST_MODE_SEL),
    .VF2_TPHR_CAP_ST_TABLE_LOC (VF2_TPHR_CAP_ST_TABLE_LOC),
    .VF2_TPHR_CAP_ST_TABLE_SIZE (VF2_TPHR_CAP_ST_TABLE_SIZE),
    .VF2_TPHR_CAP_VER (VF2_TPHR_CAP_VER),
    .VF3_ARI_CAP_NEXTPTR (VF3_ARI_CAP_NEXTPTR),
    .VF3_MSI_CAP_MULTIMSGCAP (VF3_MSI_CAP_MULTIMSGCAP),
    .VF3_MSIX_CAP_PBA_BIR (VF3_MSIX_CAP_PBA_BIR),
    .VF3_MSIX_CAP_PBA_OFFSET (VF3_MSIX_CAP_PBA_OFFSET),
    .VF3_MSIX_CAP_TABLE_BIR (VF3_MSIX_CAP_TABLE_BIR),
    .VF3_MSIX_CAP_TABLE_OFFSET (VF3_MSIX_CAP_TABLE_OFFSET),
    .VF3_MSIX_CAP_TABLE_SIZE (VF3_MSIX_CAP_TABLE_SIZE),
    .VF3_PM_CAP_ID (VF3_PM_CAP_ID),
    .VF3_PM_CAP_NEXTPTR (VF3_PM_CAP_NEXTPTR),
    .VF3_PM_CAP_VER_ID (VF3_PM_CAP_VER_ID),
    .VF3_TPHR_CAP_DEV_SPECIFIC_MODE (VF3_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF3_TPHR_CAP_ENABLE (VF3_TPHR_CAP_ENABLE),
    .VF3_TPHR_CAP_INT_VEC_MODE (VF3_TPHR_CAP_INT_VEC_MODE),
    .VF3_TPHR_CAP_NEXTPTR (VF3_TPHR_CAP_NEXTPTR),
    .VF3_TPHR_CAP_ST_MODE_SEL (VF3_TPHR_CAP_ST_MODE_SEL),
    .VF3_TPHR_CAP_ST_TABLE_LOC (VF3_TPHR_CAP_ST_TABLE_LOC),
    .VF3_TPHR_CAP_ST_TABLE_SIZE (VF3_TPHR_CAP_ST_TABLE_SIZE),
    .VF3_TPHR_CAP_VER (VF3_TPHR_CAP_VER),
    .VF4_ARI_CAP_NEXTPTR (VF4_ARI_CAP_NEXTPTR),
    .VF4_MSI_CAP_MULTIMSGCAP (VF4_MSI_CAP_MULTIMSGCAP),
    .VF4_MSIX_CAP_PBA_BIR (VF4_MSIX_CAP_PBA_BIR),
    .VF4_MSIX_CAP_PBA_OFFSET (VF4_MSIX_CAP_PBA_OFFSET),
    .VF4_MSIX_CAP_TABLE_BIR (VF4_MSIX_CAP_TABLE_BIR),
    .VF4_MSIX_CAP_TABLE_OFFSET (VF4_MSIX_CAP_TABLE_OFFSET),
    .VF4_MSIX_CAP_TABLE_SIZE (VF4_MSIX_CAP_TABLE_SIZE),
    .VF4_PM_CAP_ID (VF4_PM_CAP_ID),
    .VF4_PM_CAP_NEXTPTR (VF4_PM_CAP_NEXTPTR),
    .VF4_PM_CAP_VER_ID (VF4_PM_CAP_VER_ID),
    .VF4_TPHR_CAP_DEV_SPECIFIC_MODE (VF4_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF4_TPHR_CAP_ENABLE (VF4_TPHR_CAP_ENABLE),
    .VF4_TPHR_CAP_INT_VEC_MODE (VF4_TPHR_CAP_INT_VEC_MODE),
    .VF4_TPHR_CAP_NEXTPTR (VF4_TPHR_CAP_NEXTPTR),
    .VF4_TPHR_CAP_ST_MODE_SEL (VF4_TPHR_CAP_ST_MODE_SEL),
    .VF4_TPHR_CAP_ST_TABLE_LOC (VF4_TPHR_CAP_ST_TABLE_LOC),
    .VF4_TPHR_CAP_ST_TABLE_SIZE (VF4_TPHR_CAP_ST_TABLE_SIZE),
    .VF4_TPHR_CAP_VER (VF4_TPHR_CAP_VER),
    .VF5_ARI_CAP_NEXTPTR (VF5_ARI_CAP_NEXTPTR),
    .VF5_MSI_CAP_MULTIMSGCAP (VF5_MSI_CAP_MULTIMSGCAP),
    .VF5_MSIX_CAP_PBA_BIR (VF5_MSIX_CAP_PBA_BIR),
    .VF5_MSIX_CAP_PBA_OFFSET (VF5_MSIX_CAP_PBA_OFFSET),
    .VF5_MSIX_CAP_TABLE_BIR (VF5_MSIX_CAP_TABLE_BIR),
    .VF5_MSIX_CAP_TABLE_OFFSET (VF5_MSIX_CAP_TABLE_OFFSET),
    .VF5_MSIX_CAP_TABLE_SIZE (VF5_MSIX_CAP_TABLE_SIZE),
    .VF5_PM_CAP_ID (VF5_PM_CAP_ID),
    .VF5_PM_CAP_NEXTPTR (VF5_PM_CAP_NEXTPTR),
    .VF5_PM_CAP_VER_ID (VF5_PM_CAP_VER_ID),
    .VF5_TPHR_CAP_DEV_SPECIFIC_MODE (VF5_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF5_TPHR_CAP_ENABLE (VF5_TPHR_CAP_ENABLE),
    .VF5_TPHR_CAP_INT_VEC_MODE (VF5_TPHR_CAP_INT_VEC_MODE),
    .VF5_TPHR_CAP_NEXTPTR (VF5_TPHR_CAP_NEXTPTR),
    .VF5_TPHR_CAP_ST_MODE_SEL (VF5_TPHR_CAP_ST_MODE_SEL),
    .VF5_TPHR_CAP_ST_TABLE_LOC (VF5_TPHR_CAP_ST_TABLE_LOC),
    .VF5_TPHR_CAP_ST_TABLE_SIZE (VF5_TPHR_CAP_ST_TABLE_SIZE),
    .VF5_TPHR_CAP_VER (VF5_TPHR_CAP_VER),
    .VF6_ARI_CAP_NEXTPTR (VF6_ARI_CAP_NEXTPTR),
    .VF6_MSI_CAP_MULTIMSGCAP (VF6_MSI_CAP_MULTIMSGCAP),
    .VF6_MSIX_CAP_PBA_BIR (VF6_MSIX_CAP_PBA_BIR),
    .VF6_MSIX_CAP_PBA_OFFSET (VF6_MSIX_CAP_PBA_OFFSET),
    .VF6_MSIX_CAP_TABLE_BIR (VF6_MSIX_CAP_TABLE_BIR),
    .VF6_MSIX_CAP_TABLE_OFFSET (VF6_MSIX_CAP_TABLE_OFFSET),
    .VF6_MSIX_CAP_TABLE_SIZE (VF6_MSIX_CAP_TABLE_SIZE),
    .VF6_PM_CAP_ID (VF6_PM_CAP_ID),
    .VF6_PM_CAP_NEXTPTR (VF6_PM_CAP_NEXTPTR),
    .VF6_PM_CAP_VER_ID (VF6_PM_CAP_VER_ID),
    .VF6_TPHR_CAP_DEV_SPECIFIC_MODE (VF6_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF6_TPHR_CAP_ENABLE (VF6_TPHR_CAP_ENABLE),
    .VF6_TPHR_CAP_INT_VEC_MODE (VF6_TPHR_CAP_INT_VEC_MODE),
    .VF6_TPHR_CAP_NEXTPTR (VF6_TPHR_CAP_NEXTPTR),
    .VF6_TPHR_CAP_ST_MODE_SEL (VF6_TPHR_CAP_ST_MODE_SEL),
    .VF6_TPHR_CAP_ST_TABLE_LOC (VF6_TPHR_CAP_ST_TABLE_LOC),
    .VF6_TPHR_CAP_ST_TABLE_SIZE (VF6_TPHR_CAP_ST_TABLE_SIZE),
    .VF6_TPHR_CAP_VER (VF6_TPHR_CAP_VER),
    .VF7_ARI_CAP_NEXTPTR (VF7_ARI_CAP_NEXTPTR),
    .VF7_MSI_CAP_MULTIMSGCAP (VF7_MSI_CAP_MULTIMSGCAP),
    .VF7_MSIX_CAP_PBA_BIR (VF7_MSIX_CAP_PBA_BIR),
    .VF7_MSIX_CAP_PBA_OFFSET (VF7_MSIX_CAP_PBA_OFFSET),
    .VF7_MSIX_CAP_TABLE_BIR (VF7_MSIX_CAP_TABLE_BIR),
    .VF7_MSIX_CAP_TABLE_OFFSET (VF7_MSIX_CAP_TABLE_OFFSET),
    .VF7_MSIX_CAP_TABLE_SIZE (VF7_MSIX_CAP_TABLE_SIZE),
    .VF7_PM_CAP_ID (VF7_PM_CAP_ID),
    .VF7_PM_CAP_NEXTPTR (VF7_PM_CAP_NEXTPTR),
    .VF7_PM_CAP_VER_ID (VF7_PM_CAP_VER_ID),
    .VF7_TPHR_CAP_DEV_SPECIFIC_MODE (VF7_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF7_TPHR_CAP_ENABLE (VF7_TPHR_CAP_ENABLE),
    .VF7_TPHR_CAP_INT_VEC_MODE (VF7_TPHR_CAP_INT_VEC_MODE),
    .VF7_TPHR_CAP_NEXTPTR (VF7_TPHR_CAP_NEXTPTR),
    .VF7_TPHR_CAP_ST_MODE_SEL (VF7_TPHR_CAP_ST_MODE_SEL),
    .VF7_TPHR_CAP_ST_TABLE_LOC (VF7_TPHR_CAP_ST_TABLE_LOC),
    .VF7_TPHR_CAP_ST_TABLE_SIZE (VF7_TPHR_CAP_ST_TABLE_SIZE),
    .VF7_TPHR_CAP_VER (VF7_TPHR_CAP_VER))
  pcie3_uscale_top_inst (
    .s_axis_rq_tdata (s_axis_rq_tdata),
    .s_axis_rq_tkeep (s_axis_rq_tkeep),
    .s_axis_rq_tlast (s_axis_rq_tlast),
    .s_axis_rq_tready (s_axis_rq_tready_wire),
    .s_axis_rq_tuser (s_axis_rq_tuser),
    .s_axis_rq_tvalid (s_axis_rq_tvalid_mux),
    .m_axis_rc_tdata (m_axis_rc_tdata),
    .m_axis_rc_tkeep (m_axis_rc_tkeep),
    .m_axis_rc_tlast (m_axis_rc_tlast),
    .m_axis_rc_tready (m_axis_rc_tready_mux),
    .m_axis_rc_tuser (m_axis_rc_tuser),
    .m_axis_rc_tvalid (m_axis_rc_tvalid_wire),
    .m_axis_cq_tdata (m_axis_cq_tdata),
    .m_axis_cq_tkeep (m_axis_cq_tkeep),
    .m_axis_cq_tlast (m_axis_cq_tlast),
    .m_axis_cq_tready (m_axis_cq_tready_mux),
    .m_axis_cq_tuser (m_axis_cq_tuser),
    .m_axis_cq_tvalid (m_axis_cq_tvalid_wire),
    .s_axis_cc_tdata (s_axis_cc_tdata),
    .s_axis_cc_tkeep (s_axis_cc_tkeep),
    .s_axis_cc_tlast (s_axis_cc_tlast),
    .s_axis_cc_tready (s_axis_cc_tready_wire),
    .s_axis_cc_tuser (s_axis_cc_tuser),
    .s_axis_cc_tvalid (s_axis_cc_tvalid_mux),
    .pcie_rq_seq_num (pcie_rq_seq_num),
    .pcie_rq_seq_num_vld (pcie_rq_seq_num_vld),
    .pcie_rq_tag (pcie_rq_tag),
    .pcie_rq_tag_av (pcie_rq_tag_av),
    .pcie_rq_tag_vld (pcie_rq_tag_vld),
    .pcie_tfc_npd_av (pcie_tfc_npd_av),
    .pcie_tfc_nph_av (pcie_tfc_nph_av),
    .pcie_cq_np_req (pcie_cq_np_req_mux),
    .pcie_cq_np_req_count (pcie_cq_np_req_count),
    .cfg_mgmt_addr (cfg_mgmt_addr),
    .cfg_mgmt_byte_enable (cfg_mgmt_byte_enable),
    .cfg_mgmt_read (cfg_mgmt_read),
    .cfg_mgmt_read_data (cfg_mgmt_read_data),
    .cfg_mgmt_read_write_done (cfg_mgmt_read_write_done),
    .cfg_mgmt_type1_cfg_reg_access (cfg_mgmt_type1_cfg_reg_access),
    .cfg_mgmt_write (cfg_mgmt_write_mux),
    .cfg_mgmt_write_data (cfg_mgmt_write_data),
    .cfg_phy_link_down (cfg_phy_link_down),
    .cfg_phy_link_status (cfg_phy_link_status),
    .cfg_negotiated_width (cfg_negotiated_width),
    .cfg_current_speed (cfg_current_speed),
    .cfg_max_payload (cfg_max_payload),
    .cfg_max_read_req (cfg_max_read_req),
    .cfg_function_status (cfg_function_status),
    .cfg_function_power_state (cfg_function_power_state),
    .cfg_vf_status (cfg_vf_status),
    .cfg_vf_power_state (cfg_vf_power_state),
    .cfg_link_power_state (cfg_link_power_state),
    .cfg_err_cor_out (cfg_err_cor_out),
    .cfg_err_nonfatal_out (cfg_err_nonfatal_out),
    .cfg_err_fatal_out (cfg_err_fatal_out),
    .cfg_local_error (cfg_local_error),
    .cfg_ltr_enable (cfg_ltr_enable),
    .cfg_ltssm_state (cfg_ltssm_state),
    .cfg_rcb_status (cfg_rcb_status),
    .cfg_dpa_substate_change (cfg_dpa_substate_change),
    .cfg_obff_enable (cfg_obff_enable),
    .cfg_pl_status_change (cfg_pl_status_change),
    .cfg_tph_requester_enable (cfg_tph_requester_enable),
    .cfg_tph_st_mode (cfg_tph_st_mode),
    .cfg_vf_tph_requester_enable (cfg_vf_tph_requester_enable),
    .cfg_vf_tph_st_mode (cfg_vf_tph_st_mode),
    .cfg_msg_received (cfg_msg_received),
    .cfg_msg_received_data (cfg_msg_received_data),
    .cfg_msg_received_type (cfg_msg_received_type),
    .cfg_msg_transmit (cfg_msg_transmit_mux),
    .cfg_msg_transmit_type (cfg_msg_transmit_type),
    .cfg_msg_transmit_data (cfg_msg_transmit_data),
    .cfg_msg_transmit_done (cfg_msg_transmit_done),
    .cfg_fc_ph (cfg_fc_ph),
    .cfg_fc_pd (cfg_fc_pd),
    .cfg_fc_nph (cfg_fc_nph),
    .cfg_fc_npd (cfg_fc_npd),
    .cfg_fc_cplh (cfg_fc_cplh),
    .cfg_fc_cpld (cfg_fc_cpld),
    .cfg_fc_sel (cfg_fc_sel),
    .cfg_per_func_status_control (cfg_per_func_status_control),
    .cfg_per_func_status_data (cfg_per_func_status_data),
    .cfg_per_function_number (cfg_per_function_number),
    .cfg_per_function_output_request (cfg_per_function_output_request),
    .cfg_per_function_update_done (cfg_per_function_update_done),
    .cfg_power_state_change_ack (cfg_power_state_change_ack_mux),
    .cfg_power_state_change_interrupt (cfg_power_state_change_interrupt),
    .cfg_err_cor_in (cfg_err_cor_in_mux),
    .cfg_err_uncor_in (cfg_err_uncor_in_mux),
    .cfg_flr_in_process (cfg_flr_in_process),
    .cfg_flr_done (cfg_flr_done_mux),
    .cfg_vf_flr_in_process (cfg_vf_flr_in_process),
    .cfg_vf_flr_done (cfg_vf_flr_done_mux),
    .cfg_link_training_enable (cfg_link_training_enable_mux),
    .cfg_interrupt_int (cfg_interrupt_int_mux),
    .cfg_interrupt_pending (cfg_interrupt_pending),
    .cfg_interrupt_sent (cfg_interrupt_sent),
    .cfg_interrupt_msi_enable (cfg_interrupt_msi_enable),
    .cfg_interrupt_msi_vf_enable (cfg_interrupt_msi_vf_enable),
    .cfg_interrupt_msi_mmenable (cfg_interrupt_msi_mmenable),
    .cfg_interrupt_msi_mask_update (cfg_interrupt_msi_mask_update),
    .cfg_interrupt_msi_data (cfg_interrupt_msi_data),
    .cfg_interrupt_msi_select (cfg_interrupt_msi_select),
    .cfg_interrupt_msi_int (cfg_interrupt_msi_int_mux),
    .cfg_interrupt_msi_pending_status (cfg_interrupt_msi_pending_status),
    .cfg_interrupt_msi_pending_status_data_enable (cfg_interrupt_msi_pending_status_data_enable_mux),
    .cfg_interrupt_msi_pending_status_function_num (cfg_interrupt_msi_pending_status_function_num),
    .cfg_interrupt_msi_sent (cfg_interrupt_msi_sent),
    .cfg_interrupt_msi_fail (cfg_interrupt_msi_fail),
    .cfg_interrupt_msix_enable (cfg_interrupt_msix_enable),
    .cfg_interrupt_msix_mask (cfg_interrupt_msix_mask),
    .cfg_interrupt_msix_vf_enable (cfg_interrupt_msix_vf_enable),
    .cfg_interrupt_msix_vf_mask (cfg_interrupt_msix_vf_mask),
    .cfg_interrupt_msix_data (cfg_interrupt_msix_data),
    .cfg_interrupt_msix_address (cfg_interrupt_msix_address),
    .cfg_interrupt_msix_int (cfg_interrupt_msix_int_mux),
    .cfg_interrupt_msix_sent (cfg_interrupt_msix_sent),
    .cfg_interrupt_msix_fail (cfg_interrupt_msix_fail),
    .cfg_interrupt_msi_attr (cfg_interrupt_msi_attr),
    .cfg_interrupt_msi_tph_present (cfg_interrupt_msi_tph_present),
    .cfg_interrupt_msi_tph_type (cfg_interrupt_msi_tph_type),
    .cfg_interrupt_msi_tph_st_tag (cfg_interrupt_msi_tph_st_tag),
    .cfg_interrupt_msi_function_number (cfg_interrupt_msi_function_number),
    .cfg_ext_read_received (cfg_ext_read_received),
    .cfg_ext_write_received (cfg_ext_write_received),
    .cfg_ext_register_number (cfg_ext_register_number),
    .cfg_ext_function_number (cfg_ext_function_number),
    .cfg_ext_write_data (cfg_ext_write_data),
    .cfg_ext_write_byte_enable (cfg_ext_write_byte_enable),
    .cfg_ext_read_data (cfg_ext_read_data),
    .cfg_ext_read_data_valid (cfg_ext_read_data_valid),
    .cfg_dev_id (cfg_dev_id_mux),
    .cfg_vend_id (cfg_vend_id),
    .cfg_rev_id (cfg_rev_id),
    .cfg_subsys_id (cfg_subsys_id),
    .cfg_subsys_vend_id (cfg_subsys_vend_id),
    .cfg_ds_port_number (cfg_ds_port_number),
    .cfg_hot_reset_out (cfg_hot_reset_out),
    .cfg_config_space_enable (cfg_config_space_enable_mux),
    .cfg_req_pm_transition_l23_ready (cfg_req_pm_transition_l23_ready_mux),
    .cfg_hot_reset_in (cfg_hot_reset_in_mux),
    .cfg_ds_bus_number (cfg_ds_bus_number),
    .cfg_ds_device_number (cfg_ds_device_number),
    .cfg_ds_function_number (cfg_ds_function_number),
    .cfg_dsn (cfg_dsn_mux),
    .drp_rdy (drp_rdy),
    .drp_do (drp_do),
    .drp_clk( drp_clk),
    .drp_en (drp_en_mux),
    .drp_we (drp_we),
    .drp_addr (drp_addr[9:0]),
    .drp_di (drp_di),
    .user_tph_stt_address (user_tph_stt_address),
    .user_tph_function_num (user_tph_function_num),
    .user_tph_stt_read_data (user_tph_stt_read_data),
    .user_tph_stt_read_data_valid (user_tph_stt_read_data_valid),
    .user_tph_stt_read_enable (user_tph_stt_read_enable),
    .conf_req_type (conf_req_type),
    .conf_req_reg_num (conf_req_reg_num),
    .conf_req_data (conf_req_data),
    .conf_req_valid (conf_req_valid_mux),
    .conf_mcap_request_by_conf (mcap_external_request),
    .conf_req_ready (conf_req_ready_wire),
    .conf_resp_rdata (conf_resp_rdata),
    .conf_resp_valid (conf_resp_valid),
    .conf_mcap_design_switch (),
    .conf_mcap_eos (),
    .conf_mcap_in_use_by_pcie (mcap_pcie_request),
    .dbg_mcap_cs_b (),
    .dbg_mcap_data (),
    .dbg_mcap_eos (),
    .dbg_mcap_errror (),
    .dbg_mcap_mode (),
    .dbg_mcap_rdata_valid (),
    .dbg_mcap_rdwr_b (),
    .dbg_mcap_reset (),
    .pl_eq_in_progress (pl_eq_in_progress),
    .pl_eq_phase (pl_eq_phase),
    .pcie_perstn0_in (sys_reset),
    .pcie_perstn0_out (sys_reset_pt),
    .pcie_perstn1_in (pcie_perstn1_in),
    .pcie_perstn1_out (pcie_perstn1_out),
    .pl_eq_reset_eieos_count (pl_eq_reset_eieos_count_mux),
    .pl_gen2_upstream_prefer_deemph (pl_gen2_upstream_prefer_deemph_mux),
  //
  // Pipe Interface
  //-----------------------------
  // PIPE common_commands_in[25:0] BUS Signals
  //-----------------------------
    .pipe_clk                                           ( pipe_clk     ),  
    .core_clk                                           ( core_clk     ),  
    .user_clk                                           ( user_clk     ),  
    .mcap_clk                                           ( mcap_clk     ),  
    .phy_rdy                                            ( phy_rdy     ),  
    .pipe_tx_eqfs_gt                                    ( 6'd40 ),  
    .pipe_tx_eqlf_gt                                    ( 6'd12 ),  

  //-----------------------------
  // PIPE common_commands_out[25:0] BUS Signals
  //-----------------------------
    .pipe_tx0_rcvr_det_gt                               ( pipe_tx0_rcvr_det          ), 
    .pipe_tx0_rate_gt                                   ( common_commands_out[2:1]   ), 
    .pipe_tx0_deemph_gt                                 ( common_commands_out[9]     ), 
    .pipe_tx0_margin_gt                                 ( common_commands_out[6:4]   ), 
    .pipe_tx0_swing_gt                                  ( common_commands_out[7]     ), 
    .pipe_tx0_reset_gt                                  ( common_commands_out[8]     ), 

  //-----------------------------
  // PIPE TX BUS Signals[83:0]
  //-----------------------------

  // pipe_tx_0_sigs[83:0]
  .pipe_tx0_data_gt                                     ( pipe_tx_0_sigs[31: 0] ),     
  .pipe_tx0_char_is_k_gt                                ( pipe_tx_0_sigs[33:32] ),     
  .pipe_tx0_elec_idle_gt                                ( pipe_tx_0_sigs[34]    ),     
  .pipe_tx0_data_valid_gt                               ( pipe_tx_0_sigs[35]    ),     
  .pipe_tx0_start_block_gt                              ( pipe_tx_0_sigs[36]    ),     
  .pipe_tx0_syncheader_gt                               ( pipe_tx_0_sigs[38:37] ),     
  .pipe_rx0_polarity_gt                                 ( pipe_tx_0_sigs[39]    ),     
  .pipe_tx0_powerdown_gt                                ( pipe_tx_0_sigs[41:40] ),     
  .pipe_tx0_eqcontrol_gt                                ( pipe_tx0_eqcontrol    ),     
  .pipe_tx0_eqpreset_gt                                 ( ),     
  .pipe_tx0_eqdeemph_gt                                 ( ),     
  .pipe_rx0_eqcontrol_gt                                ( pipe_rx0_eqcontrol    ),     
  .pipe_rx0_eqpreset_gt                                 ( ),     
  .pipe_rx0_eqlp_lffs_gt                                ( ),     
  .pipe_rx0_eqlp_txpreset_gt                            ( ),   
  .pipe_tx0_compliance_gt                               ( ),    

  // pipe_tx_1_sigs[83:0]
  .pipe_tx1_data_gt                                     ( pipe_tx_1_sigs[31: 0] ),   
  .pipe_tx1_char_is_k_gt                                ( pipe_tx_1_sigs[33:32] ),   
  .pipe_tx1_elec_idle_gt                                ( pipe_tx_1_sigs[34]    ),   
  .pipe_tx1_data_valid_gt                               ( pipe_tx_1_sigs[35]    ),   
  .pipe_tx1_start_block_gt                              ( pipe_tx_1_sigs[36]    ),   
  .pipe_tx1_syncheader_gt                               ( pipe_tx_1_sigs[38:37] ),   
  .pipe_rx1_polarity_gt                                 ( pipe_tx_1_sigs[39]    ),   
  .pipe_tx1_powerdown_gt                                ( pipe_tx_1_sigs[41:40] ),   
  .pipe_tx1_eqcontrol_gt                                ( pipe_tx1_eqcontrol    ),   
  .pipe_tx1_eqpreset_gt                                 (  ),   
  .pipe_tx1_eqdeemph_gt                                 (  ),   
  .pipe_rx1_eqcontrol_gt                                ( pipe_rx1_eqcontrol    ),   
  .pipe_rx1_eqpreset_gt                                 (  ),   
  .pipe_rx1_eqlp_lffs_gt                                (  ),   
  .pipe_rx1_eqlp_txpreset_gt                            (  ),   
  .pipe_tx1_compliance_gt                               (  ),   

  // pipe_tx_2_sigs[83:0]
  .pipe_tx2_data_gt                                     ( pipe_tx_2_sigs[31: 0] ),   
  .pipe_tx2_char_is_k_gt                                ( pipe_tx_2_sigs[33:32] ),   
  .pipe_tx2_elec_idle_gt                                ( pipe_tx_2_sigs[34]    ),   
  .pipe_tx2_data_valid_gt                               ( pipe_tx_2_sigs[35]    ),   
  .pipe_tx2_start_block_gt                              ( pipe_tx_2_sigs[36]    ),   
  .pipe_tx2_syncheader_gt                               ( pipe_tx_2_sigs[38:37] ),   
  .pipe_rx2_polarity_gt                                 ( pipe_tx_2_sigs[39]    ),   
  .pipe_tx2_powerdown_gt                                ( pipe_tx_2_sigs[41:40] ),   
  .pipe_tx2_eqcontrol_gt                                ( pipe_tx2_eqcontrol    ),   
  .pipe_tx2_eqpreset_gt                                 (  ),   
  .pipe_tx2_eqdeemph_gt                                 (  ),   
  .pipe_rx2_eqcontrol_gt                                ( pipe_rx2_eqcontrol    ),   
  .pipe_rx2_eqpreset_gt                                 (  ),   
  .pipe_rx2_eqlp_lffs_gt                                (  ),   
  .pipe_rx2_eqlp_txpreset_gt                            (  ),   
  .pipe_tx2_compliance_gt                               (  ),   

  // pipe_tx_3_sigs[83:0]
  .pipe_tx3_data_gt                                     ( pipe_tx_3_sigs[31: 0] ),   
  .pipe_tx3_char_is_k_gt                                ( pipe_tx_3_sigs[33:32] ),   
  .pipe_tx3_elec_idle_gt                                ( pipe_tx_3_sigs[34]    ),   
  .pipe_tx3_data_valid_gt                               ( pipe_tx_3_sigs[35]    ),   
  .pipe_tx3_start_block_gt                              ( pipe_tx_3_sigs[36]    ),   
  .pipe_tx3_syncheader_gt                               ( pipe_tx_3_sigs[38:37] ),   
  .pipe_rx3_polarity_gt                                 ( pipe_tx_3_sigs[39]    ),   
  .pipe_tx3_powerdown_gt                                ( pipe_tx_3_sigs[41:40] ),   
  .pipe_tx3_eqcontrol_gt                                ( pipe_tx3_eqcontrol    ),   
  .pipe_tx3_eqpreset_gt                                 (  ),    
  .pipe_tx3_eqdeemph_gt                                 (  ),    
  .pipe_rx3_eqcontrol_gt                                ( pipe_rx3_eqcontrol    ),    
  .pipe_rx3_eqpreset_gt                                 (  ),   
  .pipe_rx3_eqlp_lffs_gt                                (  ),   
  .pipe_rx3_eqlp_txpreset_gt                            (  ),   
  .pipe_tx3_compliance_gt                               (  ),   

  // pipe_tx_4_sigs[83:0]
  .pipe_tx4_data_gt                                     ( pipe_tx_4_sigs[31: 0] ),   
  .pipe_tx4_char_is_k_gt                                ( pipe_tx_4_sigs[33:32] ),   
  .pipe_tx4_elec_idle_gt                                ( pipe_tx_4_sigs[34]    ),   
  .pipe_tx4_data_valid_gt                               ( pipe_tx_4_sigs[35]    ),   
  .pipe_tx4_start_block_gt                              ( pipe_tx_4_sigs[36]    ),   
  .pipe_tx4_syncheader_gt                               ( pipe_tx_4_sigs[38:37] ),   
  .pipe_rx4_polarity_gt                                 ( pipe_tx_4_sigs[39]    ),   
  .pipe_tx4_powerdown_gt                                ( pipe_tx_4_sigs[41:40] ),   
  .pipe_tx4_eqcontrol_gt                                ( pipe_tx4_eqcontrol    ),    
  .pipe_tx4_eqpreset_gt                                 (  ),   
  .pipe_tx4_eqdeemph_gt                                 (  ),   
  .pipe_rx4_eqcontrol_gt                                ( pipe_rx4_eqcontrol    ),    
  .pipe_rx4_eqpreset_gt                                 (  ),    
  .pipe_rx4_eqlp_lffs_gt                                (  ),    
  .pipe_rx4_eqlp_txpreset_gt                            (  ),    
  .pipe_tx4_compliance_gt                               (  ),   

  // pipe_tx_5_sigs[83:0]
  .pipe_tx5_data_gt                                     ( pipe_tx_5_sigs[31: 0] ),   
  .pipe_tx5_char_is_k_gt                                ( pipe_tx_5_sigs[33:32] ),   
  .pipe_tx5_elec_idle_gt                                ( pipe_tx_5_sigs[34]    ),   
  .pipe_tx5_data_valid_gt                               ( pipe_tx_5_sigs[35]    ),   
  .pipe_tx5_start_block_gt                              ( pipe_tx_5_sigs[36]    ),   
  .pipe_tx5_syncheader_gt                               ( pipe_tx_5_sigs[38:37] ),   
  .pipe_rx5_polarity_gt                                 ( pipe_tx_5_sigs[39]    ),   
  .pipe_tx5_powerdown_gt                                ( pipe_tx_5_sigs[41:40] ),   
  .pipe_tx5_eqcontrol_gt                                ( pipe_tx5_eqcontrol    ),   
  .pipe_tx5_eqpreset_gt                                 (  ),   
  .pipe_tx5_eqdeemph_gt                                 (  ),   
  .pipe_rx5_eqcontrol_gt                                ( pipe_rx5_eqcontrol    ),   
  .pipe_rx5_eqpreset_gt                                 (  ),   
  .pipe_rx5_eqlp_lffs_gt                                (  ),   
  .pipe_rx5_eqlp_txpreset_gt                            (  ),   
  .pipe_tx5_compliance_gt                               (  ),   

  // pipe_tx_6_sigs[83:0]
  .pipe_tx6_data_gt                                     ( pipe_tx_6_sigs[31: 0] ),   
  .pipe_tx6_char_is_k_gt                                ( pipe_tx_6_sigs[33:32] ),   
  .pipe_tx6_elec_idle_gt                                ( pipe_tx_6_sigs[34]    ),   
  .pipe_tx6_data_valid_gt                               ( pipe_tx_6_sigs[35]    ),   
  .pipe_tx6_start_block_gt                              ( pipe_tx_6_sigs[36]    ),   
  .pipe_tx6_syncheader_gt                               ( pipe_tx_6_sigs[38:37] ),   
  .pipe_rx6_polarity_gt                                 ( pipe_tx_6_sigs[39]    ),   
  .pipe_tx6_powerdown_gt                                ( pipe_tx_6_sigs[41:40] ),   
  .pipe_tx6_eqcontrol_gt                                ( pipe_tx6_eqcontrol    ),   
  .pipe_tx6_eqpreset_gt                                 (  ),   
  .pipe_tx6_eqdeemph_gt                                 (  ),   
  .pipe_rx6_eqcontrol_gt                                ( pipe_rx6_eqcontrol    ),   
  .pipe_rx6_eqpreset_gt                                 (  ),   
  .pipe_rx6_eqlp_lffs_gt                                (  ),   
  .pipe_rx6_eqlp_txpreset_gt                            (  ),   
  .pipe_tx6_compliance_gt                               (  ),   

  // pipe_tx_7_sigs[83:0]
  .pipe_tx7_data_gt                                     ( pipe_tx_7_sigs[31: 0] ),   
  .pipe_tx7_char_is_k_gt                                ( pipe_tx_7_sigs[33:32] ),   
  .pipe_tx7_elec_idle_gt                                ( pipe_tx_7_sigs[34]    ),   
  .pipe_tx7_data_valid_gt                               ( pipe_tx_7_sigs[35]    ),   
  .pipe_tx7_start_block_gt                              ( pipe_tx_7_sigs[36]    ),   
  .pipe_tx7_syncheader_gt                               ( pipe_tx_7_sigs[38:37] ),   
  .pipe_rx7_polarity_gt                                 ( pipe_tx_7_sigs[39]    ),   
  .pipe_tx7_powerdown_gt                                ( pipe_tx_7_sigs[41:40] ),   
  .pipe_tx7_eqcontrol_gt                                ( pipe_tx7_eqcontrol    ),   
  .pipe_tx7_eqpreset_gt                                 (  ),   
  .pipe_tx7_eqdeemph_gt                                 (  ),   
  .pipe_rx7_eqcontrol_gt                                ( pipe_rx7_eqcontrol    ),   
  .pipe_rx7_eqpreset_gt                                 (  ),   
  .pipe_rx7_eqlp_lffs_gt                                (  ),   
  .pipe_rx7_eqlp_txpreset_gt                            (  ),   
  .pipe_tx7_compliance_gt                               (  ), 
  //-----------------------------
  // PIPE RX BUS Signals[83:0]
  //-----------------------------

  // pipe_rx_0_sigs[83:0]
  .pipe_rx0_data_gt                                     ( pipe_rx_0_sigs[31: 0] ),   
  .pipe_rx0_char_is_k_gt                                ( pipe_rx_0_sigs[33:32] ),   
  .pipe_rx0_data_valid_gt                               ( pipe_rx_0_sigs[35]    ),   
  .pipe_rx0_elec_idle_gt                                ( pipe_rx_0_sigs[34]    ),   
  .pipe_rx0_start_block_gt                              ( pipe_rx_0_sigs[36]    ),   
  .pipe_rx0_syncheader_gt                               ( pipe_rx_0_sigs[38:37] ),   
  .pipe_rx0_status_gt                                   ( rx_status ),   
  .pipe_rx0_valid_gt                                    ( ~pipe_rx_0_sigs[34]    ),   
  .pipe_rx0_phy_status_gt                               ( phy_status    ),   
  .pipe_tx0_eqdone_gt                                   ( pipe_tx0_eqdone       ),   
  .pipe_tx0_eqcoeff_gt                                  ( 18'h00904             ),   
  .pipe_rx0_eqlp_new_txcoef_forpreset_gt                ( 18'h05                ),   
  .pipe_rx0_eqlp_lffs_sel_gt                            ( 1'b0                  ),   
  .pipe_rx0_eqlp_adaptdone_gt                           ( 1'b0                  ),   
  .pipe_rx0_eqdone_gt                                   ( pipe_rx0_eqdone       ),   

  // pipe_rx_1_sigs[83:0]
  .pipe_rx1_data_gt                                     ( pipe_rx_1_sigs[31: 0] ),   
  .pipe_rx1_char_is_k_gt                                ( pipe_rx_1_sigs[33:32] ),   
  .pipe_rx1_data_valid_gt                               ( pipe_rx_1_sigs[35]    ),   
  .pipe_rx1_elec_idle_gt                                ( pipe_rx_1_sigs[34]    ),   
  .pipe_rx1_start_block_gt                              ( pipe_rx_1_sigs[36]    ),   
  .pipe_rx1_syncheader_gt                               ( pipe_rx_1_sigs[38:37] ),   
  .pipe_rx1_status_gt                                   ( (PL_LINK_CAP_MAX_LINK_WIDTH >= 2 )? rx_status : 3'b0 ),   
  .pipe_rx1_valid_gt                                    ( ~pipe_rx_1_sigs[34]    ),   
  .pipe_rx1_phy_status_gt                               ( (PL_LINK_CAP_MAX_LINK_WIDTH >= 2 )? phy_status : 1'b0 ),   
  .pipe_tx1_eqdone_gt                                   ( pipe_tx1_eqdone       ),   
  .pipe_tx1_eqcoeff_gt                                  ( 18'h00904             ),   
  .pipe_rx1_eqlp_new_txcoef_forpreset_gt                ( 18'h05                ),   
  .pipe_rx1_eqlp_lffs_sel_gt                            ( 1'b0                  ),   
  .pipe_rx1_eqlp_adaptdone_gt                           ( 1'b0                  ),   
  .pipe_rx1_eqdone_gt                                   ( pipe_rx1_eqdone       ),    

  // pipe_rx_2_sigs[83:0]
  .pipe_rx2_data_gt                                     ( pipe_rx_2_sigs[31: 0] ),   
  .pipe_rx2_char_is_k_gt                                ( pipe_rx_2_sigs[33:32] ),   
  .pipe_rx2_data_valid_gt                               ( pipe_rx_2_sigs[35]    ),   
  .pipe_rx2_elec_idle_gt                                ( pipe_rx_2_sigs[34]    ),   
  .pipe_rx2_start_block_gt                              ( pipe_rx_2_sigs[36]    ),   
  .pipe_rx2_syncheader_gt                               ( pipe_rx_2_sigs[38:37] ),   
  .pipe_rx2_status_gt                                   ( (PL_LINK_CAP_MAX_LINK_WIDTH >= 4 )? rx_status : 3'b0 ),   
  .pipe_rx2_valid_gt                                    ( ~pipe_rx_2_sigs[34]    ),   
  .pipe_rx2_phy_status_gt                               ( (PL_LINK_CAP_MAX_LINK_WIDTH >= 4 )? phy_status : 1'b0 ),   
  .pipe_tx2_eqdone_gt                                   ( pipe_tx2_eqdone       ),   
  .pipe_tx2_eqcoeff_gt                                  ( 18'h00904             ),   
  .pipe_rx2_eqlp_new_txcoef_forpreset_gt                ( 18'h05                ),   
  .pipe_rx2_eqlp_lffs_sel_gt                            ( 1'b0                  ),   
  .pipe_rx2_eqlp_adaptdone_gt                           ( 1'b0                  ),   
  .pipe_rx2_eqdone_gt                                   ( pipe_rx2_eqdone       ),   

  // pipe_rx_3_sigs[83:0]
  .pipe_rx3_data_gt                                     ( pipe_rx_3_sigs[31: 0] ),   
  .pipe_rx3_char_is_k_gt                                ( pipe_rx_3_sigs[33:32] ),   
  .pipe_rx3_data_valid_gt                               ( pipe_rx_3_sigs[35]    ),   
  .pipe_rx3_elec_idle_gt                                ( pipe_rx_3_sigs[34]    ),   
  .pipe_rx3_start_block_gt                              ( pipe_rx_3_sigs[36]    ),   
  .pipe_rx3_syncheader_gt                               ( pipe_rx_3_sigs[38:37] ),   
  .pipe_rx3_status_gt                                   ( (PL_LINK_CAP_MAX_LINK_WIDTH >= 4 )? rx_status : 3'b0 ),   
  .pipe_rx3_valid_gt                                    ( ~pipe_rx_3_sigs[34]    ),   
  .pipe_rx3_phy_status_gt                               ((PL_LINK_CAP_MAX_LINK_WIDTH >= 4 )? phy_status : 1'b0 ),   
  .pipe_tx3_eqdone_gt                                   ( pipe_tx3_eqdone       ),   
  .pipe_tx3_eqcoeff_gt                                  ( 18'h00904             ),   
  .pipe_rx3_eqlp_new_txcoef_forpreset_gt                ( 18'h05                ),   
  .pipe_rx3_eqlp_lffs_sel_gt                            ( 1'b0                  ),   
  .pipe_rx3_eqlp_adaptdone_gt                           ( 1'b0                  ),   
  .pipe_rx3_eqdone_gt                                   ( pipe_rx3_eqdone       ), 

  // pipe_rx_4_sigs[83:0]
  .pipe_rx4_data_gt                                     ( pipe_rx_4_sigs[31: 0] ),   
  .pipe_rx4_char_is_k_gt                                ( pipe_rx_4_sigs[33:32] ),   
  .pipe_rx4_data_valid_gt                               ( pipe_rx_4_sigs[35]    ),   
  .pipe_rx4_elec_idle_gt                                ( pipe_rx_4_sigs[34]    ),   
  .pipe_rx4_start_block_gt                              ( pipe_rx_4_sigs[36]    ),   
  .pipe_rx4_syncheader_gt                               ( pipe_rx_4_sigs[38:37] ),   
  .pipe_rx4_status_gt                                   ( (PL_LINK_CAP_MAX_LINK_WIDTH == 8 )? rx_status : 3'b0 ),   
  .pipe_rx4_valid_gt                                    ( ~pipe_rx_4_sigs[34]    ),   
  .pipe_rx4_phy_status_gt                               ((PL_LINK_CAP_MAX_LINK_WIDTH == 8 )? phy_status : 1'b0 ),   
  .pipe_tx4_eqdone_gt                                   ( pipe_tx4_eqdone       ),   
  .pipe_tx4_eqcoeff_gt                                  ( 18'h00904             ),   
  .pipe_rx4_eqlp_new_txcoef_forpreset_gt                ( 18'h05                ),   
  .pipe_rx4_eqlp_lffs_sel_gt                            ( 1'b0                  ),   
  .pipe_rx4_eqlp_adaptdone_gt                           ( 1'b0                  ),   
  .pipe_rx4_eqdone_gt                                   ( pipe_rx4_eqdone       ),   

  // pipe_rx_5_sigs[83:0]
  .pipe_rx5_data_gt                                     ( pipe_rx_5_sigs[31: 0] ),   
  .pipe_rx5_char_is_k_gt                                ( pipe_rx_5_sigs[33:32] ),   
  .pipe_rx5_data_valid_gt                               ( pipe_rx_5_sigs[35]    ),   
  .pipe_rx5_elec_idle_gt                                ( pipe_rx_5_sigs[34]    ),   
  .pipe_rx5_start_block_gt                              ( pipe_rx_5_sigs[36]    ),   
  .pipe_rx5_syncheader_gt                               ( pipe_rx_5_sigs[38:37] ),   
  .pipe_rx5_status_gt                                   ( (PL_LINK_CAP_MAX_LINK_WIDTH == 8 )? rx_status : 3'b0  ),   
  .pipe_rx5_valid_gt                                    ( ~pipe_rx_5_sigs[34]    ),   
  .pipe_rx5_phy_status_gt                               ((PL_LINK_CAP_MAX_LINK_WIDTH == 8 )? phy_status : 1'b0 ),   
  .pipe_tx5_eqdone_gt                                   ( pipe_tx5_eqdone       ),   
  .pipe_tx5_eqcoeff_gt                                  ( 18'h00904             ),   
  .pipe_rx5_eqlp_new_txcoef_forpreset_gt                ( 18'h05                ),   
  .pipe_rx5_eqlp_lffs_sel_gt                            ( 1'b0                  ),   
  .pipe_rx5_eqlp_adaptdone_gt                           ( 1'b0                  ),   
  .pipe_rx5_eqdone_gt                                   ( pipe_rx5_eqdone       ),    

  // pipe_rx_6_sigs[83:0]
  .pipe_rx6_data_gt                                     ( pipe_rx_6_sigs[31: 0] ),   
  .pipe_rx6_char_is_k_gt                                ( pipe_rx_6_sigs[33:32] ),   
  .pipe_rx6_data_valid_gt                               ( pipe_rx_6_sigs[35]    ),   
  .pipe_rx6_elec_idle_gt                                ( pipe_rx_6_sigs[34]    ),   
  .pipe_rx6_start_block_gt                              ( pipe_rx_6_sigs[36]    ),   
  .pipe_rx6_syncheader_gt                               ( pipe_rx_6_sigs[38:37] ),   
  .pipe_rx6_status_gt                                   ( (PL_LINK_CAP_MAX_LINK_WIDTH == 8 )? rx_status : 3'b0  ),   
  .pipe_rx6_valid_gt                                    ( ~pipe_rx_6_sigs[34]    ),   
  .pipe_rx6_phy_status_gt                               ((PL_LINK_CAP_MAX_LINK_WIDTH == 8 )? phy_status : 1'b0 ),   
  .pipe_tx6_eqdone_gt                                   ( pipe_tx6_eqdone       ),   
  .pipe_tx6_eqcoeff_gt                                  ( 18'h00904             ),   
  .pipe_rx6_eqlp_new_txcoef_forpreset_gt                ( 18'h05                ),   
  .pipe_rx6_eqlp_lffs_sel_gt                            ( 1'b0                  ),   
  .pipe_rx6_eqlp_adaptdone_gt                           ( 1'b0                  ),   
  .pipe_rx6_eqdone_gt                                   ( pipe_rx6_eqdone       ),    

  // pipe_rx_7_sigs[83:0]
  .pipe_rx7_data_gt                                     ( pipe_rx_7_sigs[31: 0] ),   
  .pipe_rx7_char_is_k_gt                                ( pipe_rx_7_sigs[33:32] ),   
  .pipe_rx7_data_valid_gt                               ( pipe_rx_7_sigs[35]    ),   
  .pipe_rx7_elec_idle_gt                                ( pipe_rx_7_sigs[34]    ),   
  .pipe_rx7_start_block_gt                              ( pipe_rx_7_sigs[36]    ),   
  .pipe_rx7_syncheader_gt                               ( pipe_rx_7_sigs[38:37] ),   
  .pipe_rx7_status_gt                                   ( (PL_LINK_CAP_MAX_LINK_WIDTH == 8 )? rx_status : 3'b0  ),   
  .pipe_rx7_valid_gt                                    ( ~pipe_rx_7_sigs[34]    ),   
  .pipe_rx7_phy_status_gt                               ((PL_LINK_CAP_MAX_LINK_WIDTH == 8 )? phy_status : 1'b0 ),   
  .pipe_tx7_eqdone_gt                                   ( pipe_tx7_eqdone       ),   
  .pipe_tx7_eqcoeff_gt                                  ( 18'h00904             ),   
  .pipe_rx7_eqlp_new_txcoef_forpreset_gt                ( 18'h05                ),   
  .pipe_rx7_eqlp_lffs_sel_gt                            ( 1'b0                  ),   
  .pipe_rx7_eqlp_adaptdone_gt                           ( 1'b0                  ),   
  .pipe_rx7_eqdone_gt                                   ( pipe_rx7_eqdone       )    
  );


  reg [3:0] pipe_rx0_eqcontrol_reg = 4'b0;
  reg [3:0] pipe_rx1_eqcontrol_reg = 4'b0;
  reg [3:0] pipe_rx2_eqcontrol_reg = 4'b0;
  reg [3:0] pipe_rx3_eqcontrol_reg = 4'b0;
  reg [3:0] pipe_rx4_eqcontrol_reg = 4'b0;
  reg [3:0] pipe_rx5_eqcontrol_reg = 4'b0;
  reg [3:0] pipe_rx6_eqcontrol_reg = 4'b0;
  reg [3:0] pipe_rx7_eqcontrol_reg = 4'b0;
  reg [3:0] pipe_tx0_eqcontrol_reg = 4'b0;
  reg [3:0] pipe_tx1_eqcontrol_reg = 4'b0;
  reg [3:0] pipe_tx2_eqcontrol_reg = 4'b0;
  reg [3:0] pipe_tx3_eqcontrol_reg = 4'b0;
  reg [3:0] pipe_tx4_eqcontrol_reg = 4'b0;
  reg [3:0] pipe_tx5_eqcontrol_reg = 4'b0;
  reg [3:0] pipe_tx6_eqcontrol_reg = 4'b0;
  reg [3:0] pipe_tx7_eqcontrol_reg = 4'b0;
  
  always @ (posedge pipe_clk)
  begin
   pipe_rx0_eqcontrol_reg     <= {pipe_rx0_eqcontrol_reg[1:0], pipe_rx0_eqcontrol};
   pipe_rx1_eqcontrol_reg     <= {pipe_rx1_eqcontrol_reg[1:0], pipe_rx1_eqcontrol};
   pipe_rx2_eqcontrol_reg     <= {pipe_rx2_eqcontrol_reg[1:0], pipe_rx2_eqcontrol};
   pipe_rx3_eqcontrol_reg     <= {pipe_rx3_eqcontrol_reg[1:0], pipe_rx3_eqcontrol};
   pipe_rx4_eqcontrol_reg     <= {pipe_rx4_eqcontrol_reg[1:0], pipe_rx4_eqcontrol};
   pipe_rx5_eqcontrol_reg     <= {pipe_rx5_eqcontrol_reg[1:0], pipe_rx5_eqcontrol};
   pipe_rx6_eqcontrol_reg     <= {pipe_rx6_eqcontrol_reg[1:0], pipe_rx6_eqcontrol};
   pipe_rx7_eqcontrol_reg     <= {pipe_rx7_eqcontrol_reg[1:0], pipe_rx7_eqcontrol};
   pipe_tx0_eqcontrol_reg     <= {pipe_tx0_eqcontrol_reg[1:0], pipe_tx0_eqcontrol};
   pipe_tx1_eqcontrol_reg     <= {pipe_tx1_eqcontrol_reg[1:0], pipe_tx1_eqcontrol};
   pipe_tx2_eqcontrol_reg     <= {pipe_tx2_eqcontrol_reg[1:0], pipe_tx2_eqcontrol};
   pipe_tx3_eqcontrol_reg     <= {pipe_tx3_eqcontrol_reg[1:0], pipe_tx3_eqcontrol};
   pipe_tx4_eqcontrol_reg     <= {pipe_tx4_eqcontrol_reg[1:0], pipe_tx4_eqcontrol};
   pipe_tx5_eqcontrol_reg     <= {pipe_tx5_eqcontrol_reg[1:0], pipe_tx5_eqcontrol};
   pipe_tx6_eqcontrol_reg     <= {pipe_tx6_eqcontrol_reg[1:0], pipe_tx6_eqcontrol};
   pipe_tx7_eqcontrol_reg     <= {pipe_tx7_eqcontrol_reg[1:0], pipe_tx7_eqcontrol};
  end
  
  // generate rx*_eqdone
  assign pipe_rx0_eqdone = (pipe_rx0_eqcontrol_reg[3:2] != pipe_rx0_eqcontrol)? 1'b1 : 1'b0;
  assign pipe_rx1_eqdone = (pipe_rx1_eqcontrol_reg[3:2] != pipe_rx1_eqcontrol)? 1'b1 : 1'b0;
  assign pipe_rx2_eqdone = (pipe_rx2_eqcontrol_reg[3:2] != pipe_rx2_eqcontrol)? 1'b1 : 1'b0;
  assign pipe_rx3_eqdone = (pipe_rx3_eqcontrol_reg[3:2] != pipe_rx3_eqcontrol)? 1'b1 : 1'b0;
  assign pipe_rx4_eqdone = (pipe_rx4_eqcontrol_reg[3:2] != pipe_rx4_eqcontrol)? 1'b1 : 1'b0;
  assign pipe_rx5_eqdone = (pipe_rx5_eqcontrol_reg[3:2] != pipe_rx5_eqcontrol)? 1'b1 : 1'b0;
  assign pipe_rx6_eqdone = (pipe_rx6_eqcontrol_reg[3:2] != pipe_rx6_eqcontrol)? 1'b1 : 1'b0;
  assign pipe_rx7_eqdone = (pipe_rx7_eqcontrol_reg[3:2] != pipe_rx7_eqcontrol)? 1'b1 : 1'b0; 
  // generate tx*_eqdone
  assign pipe_tx0_eqdone = (pipe_tx0_eqcontrol_reg[3:2] != pipe_tx0_eqcontrol)? 1'b1 : 1'b0;
  assign pipe_tx1_eqdone = (pipe_tx1_eqcontrol_reg[3:2] != pipe_tx1_eqcontrol)? 1'b1 : 1'b0;
  assign pipe_tx2_eqdone = (pipe_tx2_eqcontrol_reg[3:2] != pipe_tx2_eqcontrol)? 1'b1 : 1'b0;
  assign pipe_tx3_eqdone = (pipe_tx3_eqcontrol_reg[3:2] != pipe_tx3_eqcontrol)? 1'b1 : 1'b0;
  assign pipe_tx4_eqdone = (pipe_tx4_eqcontrol_reg[3:2] != pipe_tx4_eqcontrol)? 1'b1 : 1'b0;
  assign pipe_tx5_eqdone = (pipe_tx5_eqcontrol_reg[3:2] != pipe_tx5_eqcontrol)? 1'b1 : 1'b0;
  assign pipe_tx6_eqdone = (pipe_tx6_eqcontrol_reg[3:2] != pipe_tx6_eqcontrol)? 1'b1 : 1'b0;
  assign pipe_tx7_eqdone = (pipe_tx7_eqcontrol_reg[3:2] != pipe_tx7_eqcontrol)? 1'b1 : 1'b0; 
  
 
 // Pipe mode tie-offs
 assign  common_commands_out[0]     = pipe_clk;
 assign  common_commands_out[3]     = pipe_tx0_rcvr_det; 
 assign  common_commands_out[25:10] = 16'b0;
 assign  pipe_tx_0_sigs[83:42]      = 42'b0;
 assign  pipe_tx_1_sigs[83:42]      = 42'b0;
 assign  pipe_tx_2_sigs[83:42]      = 42'b0;
 assign  pipe_tx_3_sigs[83:42]      = 42'b0;
 assign  pipe_tx_4_sigs[83:42]      = 42'b0;
 assign  pipe_tx_5_sigs[83:42]      = 42'b0;
 assign  pipe_tx_6_sigs[83:42]      = 42'b0;
 assign  pipe_tx_7_sigs[83:42]      = 42'b0;
 
 end
endgenerate

  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*32)-1):0] pipe_txdata;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*2)-1):0] pipe_tx_char_is_k;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] pipe_tx_data_valid;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] pipe_tx_start_block;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*2)-1):0] pipe_tx_syncheader;

  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*32)-1):0] pipe_rx_data;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*2)-1):0] pipe_rx_char_is_k;

  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] pipe_tx_elec_idle;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] pipe_tx_compliance;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] pipe_rx_polarity;

  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*2)-1):0] pipe_tx_eqcontrol;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*4)-1):0] pipe_tx_eqpreset;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*6)-1):0] pipe_tx_eqdeemph;

  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] pipe_rx_eqdone;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] pipe_rx_eq_adapt_done;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] pipe_rx_phy_status;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] pipe_rx_eq_lffs_sel;

  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*2)-1):0] pipe_rx_eqcontrol;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*3)-1):0] pipe_rx_eqpreset;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*6)-1):0] pipe_rx_eq_lffs;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*4)-1):0] pipe_rx_eq_txpreset;

  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*18)-1):0] pipe_rx_eq_new_txcoeff;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*18)-1):0] pipe_tx_eqcoeff;
  
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*3)-1):0] pipe_rx_status;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] pipe_rx_data_valid;    
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] pipe_rx_elec_idle;  
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] pipe_rx_start_block;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*2)-1):0] pipe_rx_syncheader;

  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] pipe_tx_eqdone;
  wire         [((PL_LINK_CAP_MAX_LINK_WIDTH*1)-1):0] pipe_rx_valid;

//----------------------------------------DEEMPH FIX--------------------------------------------------//
wire  phy_txdeemph_out;

rp_deemph deemph_i
(
    .pipe_clk                          (pipe_clk),
    .user_clk                          (user_clk),
    .sys_or_hot_rst                    (sys_or_hot_rst),
    .pipe_rx_data                      (pipe_rx0_data[15:0]),
    .pipe_tx0_rate                     (pipe_tx0_rate), 
    .pipe_rx_char_is_k                 (pipe_rx0_char_is_k),
    .cfg_ltssm_state                   (cfg_ltssm_state),
    .pipe_tx0_deemph                   (pipe_tx0_deemph),
    .phy_txdeemph_out                  (phy_txdeemph_out)
);
//----------------------------------------RXCDR HOLD---------------------------------------------------//
wire phy_rxcdrhold;

rp_rxcdrhold rxcdrhold_i
(
    .pipe_clk                          (pipe_clk),
    .user_clk                          (user_clk),
    .cfg_ltssm_state                   (cfg_ltssm_state),
    .pipe_rx0_elec_idle                (pipe_rx0_elec_idle),
    .rxcdrhold_out                     (phy_rxcdrhold)
);


generate if (EXT_PIPE_SIM == "FALSE") 
begin

rp_phy_wrapper #
(
    //--------------------------------------------------------------------------
    //  Parameters
    //--------------------------------------------------------------------------
    .PL_UPSTREAM_FACING (PL_UPSTREAM_FACING),
    .SHARED_LOGIC     ( SHARED_LOGIC ),
    .DIS_GT_WIZARD    ( DIS_GT_WIZARD ),
    // synthesis translate_off
    .PHY_SIM_EN       ( "TRUE" ),  
    // synthesis translate_on   
    .PHY_LANE         ( PL_LINK_CAP_MAX_LINK_WIDTH ),   
    .PHY_MAX_SPEED    ( PCIE_LINK_SPEED ),                       
    .PHY_REFCLK_FREQ  ( REF_CLK_FREQ ),           
    .PHY_USERCLK_FREQ ( USER_CLK_FREQ ),           
    .PHY_CORECLK_FREQ ( ((CRM_CORE_CLK_FREQ_500 == "TRUE") ? 2 : 1)  )                      
)                                                            
 gt_top_i 
(                                         
    //--------------------------------------------------------------------------
    //  Clock & Reset Ports
    //--------------------------------------------------------------------------
    .PHY_REFCLK                        ( sys_clk_bufg ),               
    .PHY_GTREFCLK                      ( sys_clk_gt ),               
    .PHY_RST_N                         ( sys_rst_n ),           
   
    .PHY_PCLK                          ( pipe_clk ),  
    .PHY_CORECLK                       ( core_clk ), 
    .PHY_USERCLK                       ( user_clk ),                          
    .mcap_clk			       ( mcap_clk ),

    //--------------------------------------------------------------------------
    //  Serial Line Ports
    //--------------------------------------------------------------------------
    .PHY_RXP                           ( pci_exp_rxp ),               
    .PHY_RXN                           ( pci_exp_rxn ),               
                                             
    .PHY_TXP                           ( pci_exp_txp ),               
    .PHY_TXN                           ( pci_exp_txn ),   
                                                                       
    //--------------------------------------------------------------------------
    //  TX Data Ports 
    //--------------------------------------------------------------------------
    .PHY_TXDATA                        ( pipe_txdata ),            
    .PHY_TXDATAK                       ( pipe_tx_char_is_k ),                
    .PHY_TXDATA_VALID                  ( pipe_tx_data_valid ),                
    .PHY_TXSTART_BLOCK                 ( pipe_tx_start_block ),                      
    .PHY_TXSYNC_HEADER                 ( pipe_tx_syncheader ),                                          

    //--------------------------------------------------------------------------
    //  RX Data Ports 
    //--------------------------------------------------------------------------
    //--------------------------------------------------------------------------
    .PHY_RXDATA                        ( pipe_rx_data ),            
    .PHY_RXDATAK                       ( pipe_rx_char_is_k ),                
    .PHY_RXDATA_VALID                  ( pipe_rx_data_valid ),                
    .PHY_RXSTART_BLOCK                 ( pipe_rx_start_block ),                      
    .PHY_RXSYNC_HEADER                 ( pipe_rx_syncheader ),                                          

    
    //--------------------------------------------------------------------------
    //  PHY Command Port
    //--------------------------------------------------------------------------
    .PHY_TXDETECTRX                    ( pipe_tx0_rcvr_det ),        
    .PHY_TXELECIDLE                    ( pipe_tx_elec_idle ),                    
    .PHY_TXCOMPLIANCE                  ( pipe_tx_compliance ),                          
    .PHY_RXPOLARITY                    ( pipe_rx_polarity),           
    .PHY_POWERDOWN                     ( pipe_tx0_powerdown ),                          
    .PHY_RATE                          ( pipe_tx0_rate ),              
    
    //--------------------------------------------------------------------------   
    //  PHY Status Ports
    //-------------------------------------------------------------------------- 
    .PHY_RXVALID                       ( pipe_rx_valid ),            
    .PHY_PHYSTATUS                     ( pipe_rx_phy_status ),            
    .PHY_PHYSTATUS_RST                 ( phy_rdy_phystatus ),          
    .PHY_RXELECIDLE                    ( pipe_rx_elec_idle ),      
    .PHY_RXSTATUS                      ( pipe_rx_status ),                                            
    
    //--------------------------------------------------------------------------   
    //  TX Equalization Ports for Gen3
    //--------------------------------------------------------------------------  
    .PHY_TXEQ_CTRL                     ( pipe_tx_eqcontrol ),
    .PHY_TXEQ_PRESET                   ( pipe_tx_eqpreset  ),
    .PHY_TXEQ_COEFF                    ( pipe_tx_eqdeemph ),
                                                            
    .PHY_TXEQ_FS                       ( pipe_tx_eqfs ),           
    .PHY_TXEQ_LF                       ( pipe_tx_eqlf ),           
    .PHY_TXEQ_NEW_COEFF                ( pipe_tx_eqcoeff ),
    .PHY_TXEQ_DONE                     ( pipe_tx_eqdone ),
                                                                 
    //--------------------------------------------------------------------------
    //  RX Equalization Ports for Gen3
    //--------------------------------------------------------------------------                                               
    .PHY_RXEQ_CTRL                     ( pipe_rx_eqcontrol  ), 
    .PHY_RXEQ_PRESET                   ( pipe_rx_eqpreset ), 
    .PHY_RXEQ_LFFS                     ( pipe_rx_eq_lffs  ),         
    .PHY_RXEQ_TXPRESET                 ( pipe_rx_eq_txpreset  ),
	
    .PHY_RXEQ_LFFS_SEL                 ( pipe_rx_eq_lffs_sel ),      
    .PHY_RXEQ_NEW_TXCOEFF              ( pipe_rx_eq_new_txcoeff ),   
    .PHY_RXEQ_DONE                     ( pipe_rx_eqdone ),         
    .PHY_RXEQ_ADAPT_DONE               ( pipe_rx_eq_adapt_done ),         
    
   //---------- Shared Logic Internal -------------------------
    .INT_QPLL1LOCK_OUT                 ( int_qpll1lock_out ),   
    .INT_QPLL1OUTREFCLK_OUT            ( int_qpll1outrefclk_out ),
    .INT_QPLL1OUTCLK_OUT               ( int_qpll1outclk_out ),
    //---------- External GT COMMON Ports ----------------------
    .EXT_QPLL1REFCLK                   ( ext_qpll1refclk ),
    .EXT_QPLL1PD                       ( ext_qpll1pd ),
    .EXT_QPLL1RATE                     ( ext_qpll1rate ),
    .EXT_QPLL1RESET                    ( ext_qpll1reset ),

    .EXT_QPLL1LOCK_OUT                 ( ext_qpll1lock_out ),
    .EXT_QPLL1OUTCLK_OUT               ( ext_qpll1outclk_out ),
    .EXT_QPLL1OUTREFCLK_OUT            ( ext_qpll1outrefclk_out ),
    //--------------------------------------------------------------------------
    //  GT Debug Ports
    //--------------------------------------------------------------------------
    .GTW_DRPCLK                        ( ext_ch_gt_drpclk ),
    .GTW_DRPADDR                       ( ext_ch_gt_drpaddr ),  
    .GTW_DRPEN                         ( ext_ch_gt_drpen_mux ),                
    .GTW_DRPWE                         ( ext_ch_gt_drpwe ),                
    .GTW_DRPDI                         ( ext_ch_gt_drpdi ), 
    .GTW_DRPRDY                        ( ext_ch_gt_drprdy ),               
    .GTW_DRPDO                         ( ext_ch_gt_drpdo ), 
    //------------------------------------------------------------------
    .GT_PCIEUSERRATEDONE              (gt_pcieuserratedone_mux ),
    .GT_LOOPBACK                      (gt_loopback_mux     ),            
    .GT_TXPRBSFORCEERR                (gt_txprbsforceerr   ),           
    .GT_TXINHIBIT                     (gt_txinhibit        ),           
    .GT_TXPRBSSEL                     (gt_txprbssel_mux    ),           
    .GT_RXPRBSSEL                     (gt_rxprbssel_mux    ),         
    .GT_RXPRBSCNTRESET                (gt_rxprbscntreset   ),            
    .GT_RXCDRLOCK                     (gt_rxcdrlock        ),
    .GT_PCIERATEIDLE                  (gt_pcierateidle     ),
    .GT_PCIEUSERRATESTART             (gt_pcieuserratestart),
    .GT_GTPOWERGOOD                   (gt_gtpowergood      ),
    .GT_RXOUTCLK                      (gt_rxoutclk         ),
    .GT_RXRECCLKOUT                   (gt_rxrecclkout      ),
    .GT_TXRESETDONE                   (gt_txresetdone      ),
    .GT_RXPMARESETDONE                (gt_rxpmaresetdone   ),
    .GT_RXRESETDONE                   (gt_rxresetdone      ),
    .GT_RXBUFSTATUS                   (gt_rxbufstatus      ),
    .GT_TXPHALIGNDONE                 (gt_txphaligndone    ),
    .GT_TXPHINITDONE                  (gt_txphinitdone     ),
    .GT_TXDLYSRESETDONE               (gt_txdlysresetdone  ),
    .GT_RXPHALIGNDONE                 (gt_rxphaligndone    ),
    .GT_RXDLYSRESETDONE               (gt_rxdlysresetdone  ),
    .GT_RXSYNCDONE                    (gt_rxsyncdone       ),
    .GT_CPLLLOCK                      (gt_cplllock         ),
    .GT_QPLL1LOCK                     (gt_qpll1lock        ),
    .GT_EYESCANDATAERROR              (gt_eyescandataerror ),
    .GT_RXPRBSERR                     (gt_rxprbserr        ),
    .GT_DMONITOROUT                   (gt_dmonitorout      ),
    .GT_RXCOMMADET                    (gt_rxcommadet       ),  
    .GT_RXSTATUS                      (gt_rxstatus         ),
    .GT_TXELECIDLE                    (gt_txelecidle       ),
    .GT_PHYSTATUS                     (gt_phystatus        ),  
    .GT_RXVALID                       (gt_rxvalid          ),
    .GT_BUFGTDIV                      (gt_bufgtdiv         ),
    .PHY_RRST_N                       (phy_rrst_n          ),
    .PHY_PRST_N                       (phy_prst_n          ),
    .TXEQ_CTRL                        (phy_txeq_ctrl       ), 
    .TXEQ_PRESET                      (phy_txeq_preset     ),  
    .PHY_RST_FSM                      (phy_rst_fsm         ),
    .PHY_TXEQ_FSM                     (phy_txeq_fsm        ), 
    .PHY_RXEQ_FSM                     (phy_rxeq_fsm        ),
    .PHY_RST_IDLE                     (phy_rst_idle        ),            
    //--------------------------------------------------------------------------
    //  TX Driver Ports
    //--------------------------------------------------------------------------
    .PHY_TXMARGIN                      ( pipe_tx0_margin ),          
    .PHY_TXSWING                       ( pipe_tx0_swing  ),           
    .PHY_RXCDRHOLD                     ( phy_rxcdrhold),    
    .PHY_TXDEEMPH                      ( phy_txdeemph_out)    
    
);

  rp_pcie3_uscale_top 
 #(
    .TCQ (TCQ),
    .NO_DECODE_LOGIC (NO_DECODE_LOGIC),
    .INTERFACE_SPEED (INTERFACE_SPEED),
    .COMPLETION_SPACE (COMPLETION_SPACE),
    .KEEP_WIDTH (KEEP_WIDTH),
    .C_DATA_WIDTH (C_DATA_WIDTH),
    .PIPE_PIPELINE_STAGES (PIPE_PIPELINE_STAGES),
    .ARI_CAP_ENABLE (ARI_CAP_ENABLE),
    .AXISTEN_IF_CC_ALIGNMENT_MODE (AXISTEN_IF_CC_ALIGNMENT_MODE),
    .AXISTEN_IF_CC_PARITY_CHK (AXISTEN_IF_CC_PARITY_CHK),
    .AXISTEN_IF_CQ_ALIGNMENT_MODE (AXISTEN_IF_CQ_ALIGNMENT_MODE),
    .AXISTEN_IF_ENABLE_CLIENT_TAG (AXISTEN_IF_ENABLE_CLIENT_TAG),
    .AXISTEN_IF_ENABLE_MSG_ROUTE (AXISTEN_IF_ENABLE_MSG_ROUTE),
    .AXISTEN_IF_ENABLE_RX_MSG_INTFC (AXISTEN_IF_ENABLE_RX_MSG_INTFC),
    .AXISTEN_IF_RC_ALIGNMENT_MODE (AXISTEN_IF_RC_ALIGNMENT_MODE),
    .AXISTEN_IF_RC_STRADDLE (AXISTEN_IF_RC_STRADDLE),
    .AXISTEN_IF_RQ_ALIGNMENT_MODE (AXISTEN_IF_RQ_ALIGNMENT_MODE),
    .AXISTEN_IF_RQ_PARITY_CHK (AXISTEN_IF_RQ_PARITY_CHK),
    .AXISTEN_IF_WIDTH (AXISTEN_IF_WIDTH),
    .CRM_CORE_CLK_FREQ_500 (CRM_CORE_CLK_FREQ_500),
    .CRM_USER_CLK_FREQ (CRM_USER_CLK_FREQ),
    .DEBUG_CFG_LOCAL_MGMT_REG_ACCESS_OVERRIDE (DEBUG_CFG_LOCAL_MGMT_REG_ACCESS_OVERRIDE),
    .DEBUG_PL_DISABLE_EI_INFER_IN_L0 (DEBUG_PL_DISABLE_EI_INFER_IN_L0),
    .DEBUG_TL_DISABLE_RX_TLP_ORDER_CHECKS (DEBUG_TL_DISABLE_RX_TLP_ORDER_CHECKS),
    .DNSTREAM_LINK_NUM (DNSTREAM_LINK_NUM),
    .LL_ACK_TIMEOUT (LL_ACK_TIMEOUT),
    .LL_ACK_TIMEOUT_EN (LL_ACK_TIMEOUT_EN),
    .LL_ACK_TIMEOUT_FUNC (LL_ACK_TIMEOUT_FUNC),
    .LL_CPL_FC_UPDATE_TIMER (LL_CPL_FC_UPDATE_TIMER),
    .LL_CPL_FC_UPDATE_TIMER_OVERRIDE (LL_CPL_FC_UPDATE_TIMER_OVERRIDE),
    .LL_FC_UPDATE_TIMER (LL_FC_UPDATE_TIMER),
    .LL_FC_UPDATE_TIMER_OVERRIDE (LL_FC_UPDATE_TIMER_OVERRIDE),
    .LL_NP_FC_UPDATE_TIMER (LL_NP_FC_UPDATE_TIMER),
    .LL_NP_FC_UPDATE_TIMER_OVERRIDE (LL_NP_FC_UPDATE_TIMER_OVERRIDE),
    .LL_P_FC_UPDATE_TIMER (LL_P_FC_UPDATE_TIMER),
    .LL_P_FC_UPDATE_TIMER_OVERRIDE (LL_P_FC_UPDATE_TIMER_OVERRIDE),
    .LL_REPLAY_TIMEOUT (LL_REPLAY_TIMEOUT),
    .LL_REPLAY_TIMEOUT_EN (LL_REPLAY_TIMEOUT_EN),
    .LL_REPLAY_TIMEOUT_FUNC (LL_REPLAY_TIMEOUT_FUNC),
    .LTR_TX_MESSAGE_MINIMUM_INTERVAL (LTR_TX_MESSAGE_MINIMUM_INTERVAL),
    .LTR_TX_MESSAGE_ON_FUNC_POWER_STATE_CHANGE (LTR_TX_MESSAGE_ON_FUNC_POWER_STATE_CHANGE),
    .LTR_TX_MESSAGE_ON_LTR_ENABLE (LTR_TX_MESSAGE_ON_LTR_ENABLE),
    .MCAP_CAP_NEXTPTR (MCAP_CAP_NEXTPTR),
    .MCAP_CONFIGURE_OVERRIDE (MCAP_CONFIGURE_OVERRIDE),
    .MCAP_ENABLE (MCAP_ENABLE),
    .MCAP_EOS_DESIGN_SWITCH (MCAP_EOS_DESIGN_SWITCH),
    .MCAP_FPGA_BITSTREAM_VERSION (MCAP_FPGA_BITSTREAM_VERSION),
    .MCAP_GATE_IO_ENABLE_DESIGN_SWITCH (MCAP_GATE_IO_ENABLE_DESIGN_SWITCH),
    .MCAP_GATE_MEM_ENABLE_DESIGN_SWITCH (MCAP_GATE_MEM_ENABLE_DESIGN_SWITCH),
    .MCAP_INPUT_GATE_DESIGN_SWITCH (MCAP_INPUT_GATE_DESIGN_SWITCH),
    .MCAP_INTERRUPT_ON_MCAP_EOS (MCAP_INTERRUPT_ON_MCAP_EOS),
    .MCAP_INTERRUPT_ON_MCAP_ERROR (MCAP_INTERRUPT_ON_MCAP_ERROR),
    .MCAP_VSEC_ID (MCAP_VSEC_ID),
    .MCAP_VSEC_LEN (MCAP_VSEC_LEN),
    .MCAP_VSEC_REV (MCAP_VSEC_REV),
    .PF0_AER_CAP_ECRC_CHECK_CAPABLE (PF0_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF0_AER_CAP_ECRC_GEN_CAPABLE (PF0_AER_CAP_ECRC_GEN_CAPABLE),
    .PF0_AER_CAP_NEXTPTR (PF0_AER_CAP_NEXTPTR),
    .PF0_ARI_CAP_NEXT_FUNC (PF0_ARI_CAP_NEXT_FUNC),
    .PF0_ARI_CAP_NEXTPTR (PF0_ARI_CAP_NEXTPTR),
    .PF0_ARI_CAP_VER (PF0_ARI_CAP_VER),
    .PF0_BAR0_APERTURE_SIZE (PF0_BAR0_APERTURE_SIZE),
    .PF0_BAR0_CONTROL (PF0_BAR0_CONTROL),
    .PF0_BAR1_APERTURE_SIZE (PF0_BAR1_APERTURE_SIZE),
    .PF0_BAR1_CONTROL (PF0_BAR1_CONTROL),
    .PF0_BAR2_APERTURE_SIZE (PF0_BAR2_APERTURE_SIZE),
    .PF0_BAR2_CONTROL (PF0_BAR2_CONTROL),
    .PF0_BAR3_APERTURE_SIZE (PF0_BAR3_APERTURE_SIZE),
    .PF0_BAR3_CONTROL (PF0_BAR3_CONTROL),
    .PF0_BAR4_APERTURE_SIZE (PF0_BAR4_APERTURE_SIZE),
    .PF0_BAR4_CONTROL (PF0_BAR4_CONTROL),
    .PF0_BAR5_APERTURE_SIZE (PF0_BAR5_APERTURE_SIZE),
    .PF0_BAR5_CONTROL (PF0_BAR5_CONTROL),
    .PF0_BIST_REGISTER (PF0_BIST_REGISTER),
    .PF0_CAPABILITY_POINTER (PF0_CAPABILITY_POINTER),
    .PF0_CLASS_CODE (PF0_CLASS_CODE),
    .PF0_DEV_CAP_ENDPOINT_L0S_LATENCY (PF0_DEV_CAP_ENDPOINT_L0S_LATENCY),
    .PF0_DEV_CAP_ENDPOINT_L1_LATENCY (PF0_DEV_CAP_ENDPOINT_L1_LATENCY),
    .PF0_DEV_CAP_EXT_TAG_SUPPORTED (PF0_DEV_CAP_EXT_TAG_SUPPORTED),
    .PF0_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE (PF0_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE),
    .PF0_DEV_CAP_MAX_PAYLOAD_SIZE (PF0_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF0_DEV_CAP2_ARI_FORWARD_ENABLE (PF0_DEV_CAP2_ARI_FORWARD_ENABLE),
    .PF0_DEV_CAP2_CPL_TIMEOUT_DISABLE (PF0_DEV_CAP2_CPL_TIMEOUT_DISABLE),
    .PF0_DEV_CAP2_LTR_SUPPORT (PF0_DEV_CAP2_LTR_SUPPORT),
    .PF0_DEV_CAP2_OBFF_SUPPORT (PF0_DEV_CAP2_OBFF_SUPPORT),
    .PF0_DEV_CAP2_TPH_COMPLETER_SUPPORT (PF0_DEV_CAP2_TPH_COMPLETER_SUPPORT),
    .PF0_DEV_CAP2_32B_ATOMIC_COMPLETER_SUPPORT (PF0_DEV_CAP2_32B_ATOMIC_COMPLETER_SUPPORT),
    .PF0_DEV_CAP2_64B_ATOMIC_COMPLETER_SUPPORT (PF0_DEV_CAP2_64B_ATOMIC_COMPLETER_SUPPORT),
    .PF0_DEV_CAP2_128B_CAS_ATOMIC_COMPLETER_SUPPORT (PF0_DEV_CAP2_128B_CAS_ATOMIC_COMPLETER_SUPPORT),
    .PF0_DEVICE_ID (PF0_DEVICE_ID),
    .PF0_DPA_CAP_NEXTPTR (PF0_DPA_CAP_NEXTPTR),
    .PF0_DPA_CAP_SUB_STATE_CONTROL (PF0_DPA_CAP_SUB_STATE_CONTROL),
    .PF0_DPA_CAP_SUB_STATE_CONTROL_EN (PF0_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF0_DPA_CAP_VER (PF0_DPA_CAP_VER),
    .PF0_DSN_CAP_NEXTPTR (PF0_DSN_CAP_NEXTPTR),
    .PF0_EXPANSION_ROM_APERTURE_SIZE (PF0_EXPANSION_ROM_APERTURE_SIZE),
    .PF0_EXPANSION_ROM_ENABLE (PF0_EXPANSION_ROM_ENABLE),
    .PF0_INTERRUPT_LINE (PF0_INTERRUPT_LINE),
    .PF0_INTERRUPT_PIN (PF0_INTERRUPT_PIN),
    .PF0_LINK_CAP_ASPM_SUPPORT (PF0_LINK_CAP_ASPM_SUPPORT),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 (PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 (PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN3 (PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN3),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN1 (PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN1),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN2 (PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN2),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN3 (PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN3),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 (PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 (PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN3 (PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN3),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_GEN1 (PF0_LINK_CAP_L1_EXIT_LATENCY_GEN1),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_GEN2 (PF0_LINK_CAP_L1_EXIT_LATENCY_GEN2),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_GEN3 (PF0_LINK_CAP_L1_EXIT_LATENCY_GEN3),
    .PF0_LINK_STATUS_SLOT_CLOCK_CONFIG (PF0_LINK_STATUS_SLOT_CLOCK_CONFIG),
    .PF0_LTR_CAP_MAX_NOSNOOP_LAT (PF0_LTR_CAP_MAX_NOSNOOP_LAT),
    .PF0_LTR_CAP_MAX_SNOOP_LAT (PF0_LTR_CAP_MAX_SNOOP_LAT),
    .PF0_LTR_CAP_NEXTPTR (PF0_LTR_CAP_NEXTPTR),
    .PF0_LTR_CAP_VER (PF0_LTR_CAP_VER),
    .PF0_MSI_CAP_MULTIMSGCAP (PF0_MSI_CAP_MULTIMSGCAP),
    .PF0_MSI_CAP_NEXTPTR (PF0_MSI_CAP_NEXTPTR),
    .PF0_MSI_CAP_PERVECMASKCAP (PF0_MSI_CAP_PERVECMASKCAP),
    .PF0_MSIX_CAP_NEXTPTR (PF0_MSIX_CAP_NEXTPTR),
    .PF0_MSIX_CAP_PBA_BIR (PF0_MSIX_CAP_PBA_BIR),
    .PF0_MSIX_CAP_PBA_OFFSET (PF0_MSIX_CAP_PBA_OFFSET),
    .PF0_MSIX_CAP_TABLE_BIR (PF0_MSIX_CAP_TABLE_BIR),
    .PF0_MSIX_CAP_TABLE_OFFSET (PF0_MSIX_CAP_TABLE_OFFSET),
    .PF0_MSIX_CAP_TABLE_SIZE (PF0_MSIX_CAP_TABLE_SIZE),
    .PF0_PB_CAP_DATA_REG_D0 (PF0_PB_CAP_DATA_REG_D0),
    .PF0_PB_CAP_DATA_REG_D0_SUSTAINED (PF0_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF0_PB_CAP_DATA_REG_D1 (PF0_PB_CAP_DATA_REG_D1),
    .PF0_PB_CAP_DATA_REG_D3HOT (PF0_PB_CAP_DATA_REG_D3HOT),
    .PF0_PB_CAP_NEXTPTR (PF0_PB_CAP_NEXTPTR),
    .PF0_PB_CAP_SYSTEM_ALLOCATED (PF0_PB_CAP_SYSTEM_ALLOCATED),
    .PF0_PB_CAP_VER (PF0_PB_CAP_VER),
    .PF0_PM_CAP_ID (PF0_PM_CAP_ID),
    .PF0_PM_CAP_NEXTPTR (PF0_PM_CAP_NEXTPTR),
    .PF0_PM_CAP_PMESUPPORT_D0 (PF0_PM_CAP_PMESUPPORT_D0),
    .PF0_PM_CAP_PMESUPPORT_D1 (PF0_PM_CAP_PMESUPPORT_D1),
    .PF0_PM_CAP_PMESUPPORT_D3HOT (PF0_PM_CAP_PMESUPPORT_D3HOT),
    .PF0_PM_CAP_SUPP_D1_STATE (PF0_PM_CAP_SUPP_D1_STATE),
    .PF0_PM_CAP_VER_ID (PF0_PM_CAP_VER_ID),
    .PF0_PM_CSR_NOSOFTRESET (PF0_PM_CSR_NOSOFTRESET),
    .PF0_RBAR_CAP_ENABLE (PF0_RBAR_CAP_ENABLE),
    .PF0_RBAR_CAP_NEXTPTR (PF0_RBAR_CAP_NEXTPTR),
    .PF0_RBAR_CAP_SIZE0 (PF0_RBAR_CAP_SIZE0),
    .PF0_RBAR_CAP_SIZE1 (PF0_RBAR_CAP_SIZE1),
    .PF0_RBAR_CAP_SIZE2 (PF0_RBAR_CAP_SIZE2),
    .PF0_RBAR_CAP_VER (PF0_RBAR_CAP_VER),
    .PF0_RBAR_CONTROL_INDEX0 (PF0_RBAR_CONTROL_INDEX0),
    .PF0_RBAR_CONTROL_INDEX1 (PF0_RBAR_CONTROL_INDEX1),
    .PF0_RBAR_CONTROL_INDEX2 (PF0_RBAR_CONTROL_INDEX2),
    .PF0_RBAR_CONTROL_SIZE0 (PF0_RBAR_CONTROL_SIZE0),
    .PF0_RBAR_CONTROL_SIZE1 (PF0_RBAR_CONTROL_SIZE1),
    .PF0_RBAR_CONTROL_SIZE2 (PF0_RBAR_CONTROL_SIZE2),
    .PF0_RBAR_NUM (PF0_RBAR_NUM),
    .PF0_REVISION_ID (PF0_REVISION_ID),
    .PF0_SECONDARY_PCIE_CAP_NEXTPTR (PF0_SECONDARY_PCIE_CAP_NEXTPTR),
    .PF0_SRIOV_BAR0_APERTURE_SIZE (PF0_SRIOV_BAR0_APERTURE_SIZE),
    .PF0_SRIOV_BAR0_CONTROL (PF0_SRIOV_BAR0_CONTROL),
    .PF0_SRIOV_BAR1_APERTURE_SIZE (PF0_SRIOV_BAR1_APERTURE_SIZE),
    .PF0_SRIOV_BAR1_CONTROL (PF0_SRIOV_BAR1_CONTROL),
    .PF0_SRIOV_BAR2_APERTURE_SIZE (PF0_SRIOV_BAR2_APERTURE_SIZE),
    .PF0_SRIOV_BAR2_CONTROL (PF0_SRIOV_BAR2_CONTROL),
    .PF0_SRIOV_BAR3_APERTURE_SIZE (PF0_SRIOV_BAR3_APERTURE_SIZE),
    .PF0_SRIOV_BAR3_CONTROL (PF0_SRIOV_BAR3_CONTROL),
    .PF0_SRIOV_BAR4_APERTURE_SIZE (PF0_SRIOV_BAR4_APERTURE_SIZE),
    .PF0_SRIOV_BAR4_CONTROL (PF0_SRIOV_BAR4_CONTROL),
    .PF0_SRIOV_BAR5_APERTURE_SIZE (PF0_SRIOV_BAR5_APERTURE_SIZE),
    .PF0_SRIOV_BAR5_CONTROL (PF0_SRIOV_BAR5_CONTROL),
    .PF0_SRIOV_CAP_INITIAL_VF (PF0_SRIOV_CAP_INITIAL_VF),
    .PF0_SRIOV_CAP_NEXTPTR (PF0_SRIOV_CAP_NEXTPTR),
    .PF0_SRIOV_CAP_TOTAL_VF (PF0_SRIOV_CAP_TOTAL_VF),
    .PF0_SRIOV_CAP_VER (PF0_SRIOV_CAP_VER),
    .PF0_SRIOV_FIRST_VF_OFFSET (PF0_SRIOV_FIRST_VF_OFFSET),
    .PF0_SRIOV_FUNC_DEP_LINK (PF0_SRIOV_FUNC_DEP_LINK),
    .PF0_SRIOV_SUPPORTED_PAGE_SIZE (PF0_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF0_SRIOV_VF_DEVICE_ID (PF0_SRIOV_VF_DEVICE_ID),
    .PF0_SUBSYSTEM_ID (PF0_SUBSYSTEM_ID),
    .PF0_TPHR_CAP_DEV_SPECIFIC_MODE (PF0_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF0_TPHR_CAP_ENABLE (PF0_TPHR_CAP_ENABLE),
    .PF0_TPHR_CAP_INT_VEC_MODE (PF0_TPHR_CAP_INT_VEC_MODE),
    .PF0_TPHR_CAP_NEXTPTR (PF0_TPHR_CAP_NEXTPTR),
    .PF0_TPHR_CAP_ST_MODE_SEL (PF0_TPHR_CAP_ST_MODE_SEL),
    .PF0_TPHR_CAP_ST_TABLE_LOC (PF0_TPHR_CAP_ST_TABLE_LOC),
    .PF0_TPHR_CAP_ST_TABLE_SIZE (PF0_TPHR_CAP_ST_TABLE_SIZE),
    .PF0_TPHR_CAP_VER (PF0_TPHR_CAP_VER),
    .PF0_VC_CAP_ENABLE (PF0_VC_CAP_ENABLE),
    .PF0_VC_CAP_NEXTPTR (PF0_VC_CAP_NEXTPTR),
    .PF0_VC_CAP_VER (PF0_VC_CAP_VER),
    .PF1_AER_CAP_ECRC_CHECK_CAPABLE (PF1_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF1_AER_CAP_ECRC_GEN_CAPABLE (PF1_AER_CAP_ECRC_GEN_CAPABLE),
    .PF1_AER_CAP_NEXTPTR (PF1_AER_CAP_NEXTPTR),
    .PF1_ARI_CAP_NEXT_FUNC (PF1_ARI_CAP_NEXT_FUNC),
    .PF1_ARI_CAP_NEXTPTR (PF1_ARI_CAP_NEXTPTR),
    .PF1_BAR0_APERTURE_SIZE (PF1_BAR0_APERTURE_SIZE),
    .PF1_BAR0_CONTROL (PF1_BAR0_CONTROL),
    .PF1_BAR1_APERTURE_SIZE (PF1_BAR1_APERTURE_SIZE),
    .PF1_BAR1_CONTROL (PF1_BAR1_CONTROL),
    .PF1_BAR2_APERTURE_SIZE (PF1_BAR2_APERTURE_SIZE),
    .PF1_BAR2_CONTROL (PF1_BAR2_CONTROL),
    .PF1_BAR3_APERTURE_SIZE (PF1_BAR3_APERTURE_SIZE),
    .PF1_BAR3_CONTROL (PF1_BAR3_CONTROL),
    .PF1_BAR4_APERTURE_SIZE (PF1_BAR4_APERTURE_SIZE),
    .PF1_BAR4_CONTROL (PF1_BAR4_CONTROL),
    .PF1_BAR5_APERTURE_SIZE (PF1_BAR5_APERTURE_SIZE),
    .PF1_BAR5_CONTROL (PF1_BAR5_CONTROL),
    .PF1_BIST_REGISTER (PF1_BIST_REGISTER),
    .PF1_CAPABILITY_POINTER (PF1_CAPABILITY_POINTER),
    .PF1_CLASS_CODE (PF1_CLASS_CODE),
    .PF1_DEV_CAP_MAX_PAYLOAD_SIZE (PF1_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF1_DEVICE_ID (PF1_DEVICE_ID),
    .PF1_DPA_CAP_NEXTPTR (PF1_DPA_CAP_NEXTPTR),
    .PF1_DPA_CAP_SUB_STATE_CONTROL (PF1_DPA_CAP_SUB_STATE_CONTROL),
    .PF1_DPA_CAP_SUB_STATE_CONTROL_EN (PF1_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF1_DPA_CAP_VER (PF1_DPA_CAP_VER),
    .PF1_DSN_CAP_NEXTPTR (PF1_DSN_CAP_NEXTPTR),
    .PF1_EXPANSION_ROM_APERTURE_SIZE (PF1_EXPANSION_ROM_APERTURE_SIZE),
    .PF1_EXPANSION_ROM_ENABLE (PF1_EXPANSION_ROM_ENABLE),
    .PF1_INTERRUPT_LINE (PF1_INTERRUPT_LINE),
    .PF1_INTERRUPT_PIN (PF1_INTERRUPT_PIN),
    .PF1_MSI_CAP_MULTIMSGCAP (PF1_MSI_CAP_MULTIMSGCAP),
    .PF1_MSI_CAP_NEXTPTR (PF1_MSI_CAP_NEXTPTR),
    .PF1_MSI_CAP_PERVECMASKCAP (PF1_MSI_CAP_PERVECMASKCAP),
    .PF1_MSIX_CAP_NEXTPTR (PF1_MSIX_CAP_NEXTPTR),
    .PF1_MSIX_CAP_PBA_BIR (PF1_MSIX_CAP_PBA_BIR),
    .PF1_MSIX_CAP_PBA_OFFSET (PF1_MSIX_CAP_PBA_OFFSET),
    .PF1_MSIX_CAP_TABLE_BIR (PF1_MSIX_CAP_TABLE_BIR),
    .PF1_MSIX_CAP_TABLE_OFFSET (PF1_MSIX_CAP_TABLE_OFFSET),
    .PF1_MSIX_CAP_TABLE_SIZE (PF1_MSIX_CAP_TABLE_SIZE),
    .PF1_PB_CAP_DATA_REG_D0 (PF1_PB_CAP_DATA_REG_D0),
    .PF1_PB_CAP_DATA_REG_D0_SUSTAINED (PF1_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF1_PB_CAP_DATA_REG_D1 (PF1_PB_CAP_DATA_REG_D1),
    .PF1_PB_CAP_DATA_REG_D3HOT (PF1_PB_CAP_DATA_REG_D3HOT),
    .PF1_PB_CAP_NEXTPTR (PF1_PB_CAP_NEXTPTR),
    .PF1_PB_CAP_SYSTEM_ALLOCATED (PF1_PB_CAP_SYSTEM_ALLOCATED),
    .PF1_PB_CAP_VER (PF1_PB_CAP_VER),
    .PF1_PM_CAP_ID (PF1_PM_CAP_ID),
    .PF1_PM_CAP_NEXTPTR (PF1_PM_CAP_NEXTPTR),
    .PF1_PM_CAP_VER_ID (PF1_PM_CAP_VER_ID),
    .PF1_RBAR_CAP_ENABLE (PF1_RBAR_CAP_ENABLE),
    .PF1_RBAR_CAP_NEXTPTR (PF1_RBAR_CAP_NEXTPTR),
    .PF1_RBAR_CAP_SIZE0 (PF1_RBAR_CAP_SIZE0),
    .PF1_RBAR_CAP_SIZE1 (PF1_RBAR_CAP_SIZE1),
    .PF1_RBAR_CAP_SIZE2 (PF1_RBAR_CAP_SIZE2),
    .PF1_RBAR_CAP_VER (PF1_RBAR_CAP_VER),
    .PF1_RBAR_CONTROL_INDEX0 (PF1_RBAR_CONTROL_INDEX0),
    .PF1_RBAR_CONTROL_INDEX1 (PF1_RBAR_CONTROL_INDEX1),
    .PF1_RBAR_CONTROL_INDEX2 (PF1_RBAR_CONTROL_INDEX2),
    .PF1_RBAR_CONTROL_SIZE0 (PF1_RBAR_CONTROL_SIZE0),
    .PF1_RBAR_CONTROL_SIZE1 (PF1_RBAR_CONTROL_SIZE1),
    .PF1_RBAR_CONTROL_SIZE2 (PF1_RBAR_CONTROL_SIZE2),
    .PF1_RBAR_NUM (PF1_RBAR_NUM),
    .PF1_REVISION_ID (PF1_REVISION_ID),
    .PF1_SRIOV_BAR0_APERTURE_SIZE (PF1_SRIOV_BAR0_APERTURE_SIZE),
    .PF1_SRIOV_BAR0_CONTROL (PF1_SRIOV_BAR0_CONTROL),
    .PF1_SRIOV_BAR1_APERTURE_SIZE (PF1_SRIOV_BAR1_APERTURE_SIZE),
    .PF1_SRIOV_BAR1_CONTROL (PF1_SRIOV_BAR1_CONTROL),
    .PF1_SRIOV_BAR2_APERTURE_SIZE (PF1_SRIOV_BAR2_APERTURE_SIZE),
    .PF1_SRIOV_BAR2_CONTROL (PF1_SRIOV_BAR2_CONTROL),
    .PF1_SRIOV_BAR3_APERTURE_SIZE (PF1_SRIOV_BAR3_APERTURE_SIZE),
    .PF1_SRIOV_BAR3_CONTROL (PF1_SRIOV_BAR3_CONTROL),
    .PF1_SRIOV_BAR4_APERTURE_SIZE (PF1_SRIOV_BAR4_APERTURE_SIZE),
    .PF1_SRIOV_BAR4_CONTROL (PF1_SRIOV_BAR4_CONTROL),
    .PF1_SRIOV_BAR5_APERTURE_SIZE (PF1_SRIOV_BAR5_APERTURE_SIZE),
    .PF1_SRIOV_BAR5_CONTROL (PF1_SRIOV_BAR5_CONTROL),
    .PF1_SRIOV_CAP_INITIAL_VF (PF1_SRIOV_CAP_INITIAL_VF),
    .PF1_SRIOV_CAP_NEXTPTR (PF1_SRIOV_CAP_NEXTPTR),
    .PF1_SRIOV_CAP_TOTAL_VF (PF1_SRIOV_CAP_TOTAL_VF),
    .PF1_SRIOV_CAP_VER (PF1_SRIOV_CAP_VER),
    .PF1_SRIOV_FIRST_VF_OFFSET (PF1_SRIOV_FIRST_VF_OFFSET),
    .PF1_SRIOV_FUNC_DEP_LINK (PF1_SRIOV_FUNC_DEP_LINK),
    .PF1_SRIOV_SUPPORTED_PAGE_SIZE (PF1_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF1_SRIOV_VF_DEVICE_ID (PF1_SRIOV_VF_DEVICE_ID),
    .PF1_SUBSYSTEM_ID (PF1_SUBSYSTEM_ID),
    .PF1_TPHR_CAP_DEV_SPECIFIC_MODE (PF1_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF1_TPHR_CAP_ENABLE (PF1_TPHR_CAP_ENABLE),
    .PF1_TPHR_CAP_INT_VEC_MODE (PF1_TPHR_CAP_INT_VEC_MODE),
    .PF1_TPHR_CAP_NEXTPTR (PF1_TPHR_CAP_NEXTPTR),
    .PF1_TPHR_CAP_ST_MODE_SEL (PF1_TPHR_CAP_ST_MODE_SEL),
    .PF1_TPHR_CAP_ST_TABLE_LOC (PF1_TPHR_CAP_ST_TABLE_LOC),
    .PF1_TPHR_CAP_ST_TABLE_SIZE (PF1_TPHR_CAP_ST_TABLE_SIZE),
    .PF1_TPHR_CAP_VER (PF1_TPHR_CAP_VER),
    .PF2_AER_CAP_ECRC_CHECK_CAPABLE (PF2_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF2_AER_CAP_ECRC_GEN_CAPABLE (PF2_AER_CAP_ECRC_GEN_CAPABLE),
    .PF2_AER_CAP_NEXTPTR (PF2_AER_CAP_NEXTPTR),
    .PF2_ARI_CAP_NEXT_FUNC (PF2_ARI_CAP_NEXT_FUNC),
    .PF2_ARI_CAP_NEXTPTR (PF2_ARI_CAP_NEXTPTR),
    .PF2_BAR0_APERTURE_SIZE (PF2_BAR0_APERTURE_SIZE),
    .PF2_BAR0_CONTROL (PF2_BAR0_CONTROL),
    .PF2_BAR1_APERTURE_SIZE (PF2_BAR1_APERTURE_SIZE),
    .PF2_BAR1_CONTROL (PF2_BAR1_CONTROL),
    .PF2_BAR2_APERTURE_SIZE (PF2_BAR2_APERTURE_SIZE),
    .PF2_BAR2_CONTROL (PF2_BAR2_CONTROL),
    .PF2_BAR3_APERTURE_SIZE (PF2_BAR3_APERTURE_SIZE),
    .PF2_BAR3_CONTROL (PF2_BAR3_CONTROL),
    .PF2_BAR4_APERTURE_SIZE (PF2_BAR4_APERTURE_SIZE),
    .PF2_BAR4_CONTROL (PF2_BAR4_CONTROL),
    .PF2_BAR5_APERTURE_SIZE (PF2_BAR5_APERTURE_SIZE),
    .PF2_BAR5_CONTROL (PF2_BAR5_CONTROL),
    .PF2_BIST_REGISTER (PF2_BIST_REGISTER),
    .PF2_CAPABILITY_POINTER (PF2_CAPABILITY_POINTER),
    .PF2_CLASS_CODE (PF2_CLASS_CODE),
    .PF2_DEV_CAP_MAX_PAYLOAD_SIZE (PF2_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF2_DEVICE_ID (PF2_DEVICE_ID),
    .PF2_DPA_CAP_NEXTPTR (PF2_DPA_CAP_NEXTPTR),
    .PF2_DPA_CAP_SUB_STATE_CONTROL (PF2_DPA_CAP_SUB_STATE_CONTROL),
    .PF2_DPA_CAP_SUB_STATE_CONTROL_EN (PF2_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF2_DPA_CAP_VER (PF2_DPA_CAP_VER),
    .PF2_DSN_CAP_NEXTPTR (PF2_DSN_CAP_NEXTPTR),
    .PF2_EXPANSION_ROM_APERTURE_SIZE (PF2_EXPANSION_ROM_APERTURE_SIZE),
    .PF2_EXPANSION_ROM_ENABLE (PF2_EXPANSION_ROM_ENABLE),
    .PF2_INTERRUPT_LINE (PF2_INTERRUPT_LINE),
    .PF2_INTERRUPT_PIN (PF2_INTERRUPT_PIN),
    .PF2_MSI_CAP_MULTIMSGCAP (PF2_MSI_CAP_MULTIMSGCAP),
    .PF2_MSI_CAP_NEXTPTR (PF2_MSI_CAP_NEXTPTR),
    .PF2_MSI_CAP_PERVECMASKCAP (PF2_MSI_CAP_PERVECMASKCAP),
    .PF2_MSIX_CAP_NEXTPTR (PF2_MSIX_CAP_NEXTPTR),
    .PF2_MSIX_CAP_PBA_BIR (PF2_MSIX_CAP_PBA_BIR),
    .PF2_MSIX_CAP_PBA_OFFSET (PF2_MSIX_CAP_PBA_OFFSET),
    .PF2_MSIX_CAP_TABLE_BIR (PF2_MSIX_CAP_TABLE_BIR),
    .PF2_MSIX_CAP_TABLE_OFFSET (PF2_MSIX_CAP_TABLE_OFFSET),
    .PF2_MSIX_CAP_TABLE_SIZE (PF2_MSIX_CAP_TABLE_SIZE),
    .PF2_PB_CAP_DATA_REG_D0 (PF2_PB_CAP_DATA_REG_D0),
    .PF2_PB_CAP_DATA_REG_D0_SUSTAINED (PF2_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF2_PB_CAP_DATA_REG_D1 (PF2_PB_CAP_DATA_REG_D1),
    .PF2_PB_CAP_DATA_REG_D3HOT (PF2_PB_CAP_DATA_REG_D3HOT),
    .PF2_PB_CAP_NEXTPTR (PF2_PB_CAP_NEXTPTR),
    .PF2_PB_CAP_SYSTEM_ALLOCATED (PF2_PB_CAP_SYSTEM_ALLOCATED),
    .PF2_PB_CAP_VER (PF2_PB_CAP_VER),
    .PF2_PM_CAP_ID (PF2_PM_CAP_ID),
    .PF2_PM_CAP_NEXTPTR (PF2_PM_CAP_NEXTPTR),
    .PF2_PM_CAP_VER_ID (PF2_PM_CAP_VER_ID),
    .PF2_RBAR_CAP_ENABLE (PF2_RBAR_CAP_ENABLE),
    .PF2_RBAR_CAP_NEXTPTR (PF2_RBAR_CAP_NEXTPTR),
    .PF2_RBAR_CAP_SIZE0 (PF2_RBAR_CAP_SIZE0),
    .PF2_RBAR_CAP_SIZE1 (PF2_RBAR_CAP_SIZE1),
    .PF2_RBAR_CAP_SIZE2 (PF2_RBAR_CAP_SIZE2),
    .PF2_RBAR_CAP_VER (PF2_RBAR_CAP_VER),
    .PF2_RBAR_CONTROL_INDEX0 (PF2_RBAR_CONTROL_INDEX0),
    .PF2_RBAR_CONTROL_INDEX1 (PF2_RBAR_CONTROL_INDEX1),
    .PF2_RBAR_CONTROL_INDEX2 (PF2_RBAR_CONTROL_INDEX2),
    .PF2_RBAR_CONTROL_SIZE0 (PF2_RBAR_CONTROL_SIZE0),
    .PF2_RBAR_CONTROL_SIZE1 (PF2_RBAR_CONTROL_SIZE1),
    .PF2_RBAR_CONTROL_SIZE2 (PF2_RBAR_CONTROL_SIZE2),
    .PF2_RBAR_NUM (PF2_RBAR_NUM),
    .PF2_REVISION_ID (PF2_REVISION_ID),
    .PF2_SRIOV_BAR0_APERTURE_SIZE (PF2_SRIOV_BAR0_APERTURE_SIZE),
    .PF2_SRIOV_BAR0_CONTROL (PF2_SRIOV_BAR0_CONTROL),
    .PF2_SRIOV_BAR1_APERTURE_SIZE (PF2_SRIOV_BAR1_APERTURE_SIZE),
    .PF2_SRIOV_BAR1_CONTROL (PF2_SRIOV_BAR1_CONTROL),
    .PF2_SRIOV_BAR2_APERTURE_SIZE (PF2_SRIOV_BAR2_APERTURE_SIZE),
    .PF2_SRIOV_BAR2_CONTROL (PF2_SRIOV_BAR2_CONTROL),
    .PF2_SRIOV_BAR3_APERTURE_SIZE (PF2_SRIOV_BAR3_APERTURE_SIZE),
    .PF2_SRIOV_BAR3_CONTROL (PF2_SRIOV_BAR3_CONTROL),
    .PF2_SRIOV_BAR4_APERTURE_SIZE (PF2_SRIOV_BAR4_APERTURE_SIZE),
    .PF2_SRIOV_BAR4_CONTROL (PF2_SRIOV_BAR4_CONTROL),
    .PF2_SRIOV_BAR5_APERTURE_SIZE (PF2_SRIOV_BAR5_APERTURE_SIZE),
    .PF2_SRIOV_BAR5_CONTROL (PF2_SRIOV_BAR5_CONTROL),
    .PF2_SRIOV_CAP_INITIAL_VF (PF2_SRIOV_CAP_INITIAL_VF),
    .PF2_SRIOV_CAP_NEXTPTR (PF2_SRIOV_CAP_NEXTPTR),
    .PF2_SRIOV_CAP_TOTAL_VF (PF2_SRIOV_CAP_TOTAL_VF),
    .PF2_SRIOV_CAP_VER (PF2_SRIOV_CAP_VER),
    .PF2_SRIOV_FIRST_VF_OFFSET (PF2_SRIOV_FIRST_VF_OFFSET),
    .PF2_SRIOV_FUNC_DEP_LINK (PF2_SRIOV_FUNC_DEP_LINK),
    .PF2_SRIOV_SUPPORTED_PAGE_SIZE (PF2_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF2_SRIOV_VF_DEVICE_ID (PF2_SRIOV_VF_DEVICE_ID),
    .PF2_SUBSYSTEM_ID (PF2_SUBSYSTEM_ID),
    .PF2_TPHR_CAP_DEV_SPECIFIC_MODE (PF2_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF2_TPHR_CAP_ENABLE (PF2_TPHR_CAP_ENABLE),
    .PF2_TPHR_CAP_INT_VEC_MODE (PF2_TPHR_CAP_INT_VEC_MODE),
    .PF2_TPHR_CAP_NEXTPTR (PF2_TPHR_CAP_NEXTPTR),
    .PF2_TPHR_CAP_ST_MODE_SEL (PF2_TPHR_CAP_ST_MODE_SEL),
    .PF2_TPHR_CAP_ST_TABLE_LOC (PF2_TPHR_CAP_ST_TABLE_LOC),
    .PF2_TPHR_CAP_ST_TABLE_SIZE (PF2_TPHR_CAP_ST_TABLE_SIZE),
    .PF2_TPHR_CAP_VER (PF2_TPHR_CAP_VER),
    .PF3_AER_CAP_ECRC_CHECK_CAPABLE (PF3_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF3_AER_CAP_ECRC_GEN_CAPABLE (PF3_AER_CAP_ECRC_GEN_CAPABLE),
    .PF3_AER_CAP_NEXTPTR (PF3_AER_CAP_NEXTPTR),
    .PF3_ARI_CAP_NEXT_FUNC (PF3_ARI_CAP_NEXT_FUNC),
    .PF3_ARI_CAP_NEXTPTR (PF3_ARI_CAP_NEXTPTR),
    .PF3_BAR0_APERTURE_SIZE (PF3_BAR0_APERTURE_SIZE),
    .PF3_BAR0_CONTROL (PF3_BAR0_CONTROL),
    .PF3_BAR1_APERTURE_SIZE (PF3_BAR1_APERTURE_SIZE),
    .PF3_BAR1_CONTROL (PF3_BAR1_CONTROL),
    .PF3_BAR2_APERTURE_SIZE (PF3_BAR2_APERTURE_SIZE),
    .PF3_BAR2_CONTROL (PF3_BAR2_CONTROL),
    .PF3_BAR3_APERTURE_SIZE (PF3_BAR3_APERTURE_SIZE),
    .PF3_BAR3_CONTROL (PF3_BAR3_CONTROL),
    .PF3_BAR4_APERTURE_SIZE (PF3_BAR4_APERTURE_SIZE),
    .PF3_BAR4_CONTROL (PF3_BAR4_CONTROL),
    .PF3_BAR5_APERTURE_SIZE (PF3_BAR5_APERTURE_SIZE),
    .PF3_BAR5_CONTROL (PF3_BAR5_CONTROL),
    .PF3_BIST_REGISTER (PF3_BIST_REGISTER),
    .PF3_CAPABILITY_POINTER (PF3_CAPABILITY_POINTER),
    .PF3_CLASS_CODE (PF3_CLASS_CODE),
    .PF3_DEV_CAP_MAX_PAYLOAD_SIZE (PF3_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF3_DEVICE_ID (PF3_DEVICE_ID),
    .PF3_DPA_CAP_NEXTPTR (PF3_DPA_CAP_NEXTPTR),
    .PF3_DPA_CAP_SUB_STATE_CONTROL (PF3_DPA_CAP_SUB_STATE_CONTROL),
    .PF3_DPA_CAP_SUB_STATE_CONTROL_EN (PF3_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF3_DPA_CAP_VER (PF3_DPA_CAP_VER),
    .PF3_DSN_CAP_NEXTPTR (PF3_DSN_CAP_NEXTPTR),
    .PF3_EXPANSION_ROM_APERTURE_SIZE (PF3_EXPANSION_ROM_APERTURE_SIZE),
    .PF3_EXPANSION_ROM_ENABLE (PF3_EXPANSION_ROM_ENABLE),
    .PF3_INTERRUPT_LINE (PF3_INTERRUPT_LINE),
    .PF3_INTERRUPT_PIN (PF3_INTERRUPT_PIN),
    .PF3_MSI_CAP_MULTIMSGCAP (PF3_MSI_CAP_MULTIMSGCAP),
    .PF3_MSI_CAP_NEXTPTR (PF3_MSI_CAP_NEXTPTR),
    .PF3_MSI_CAP_PERVECMASKCAP (PF3_MSI_CAP_PERVECMASKCAP),
    .PF3_MSIX_CAP_NEXTPTR (PF3_MSIX_CAP_NEXTPTR),
    .PF3_MSIX_CAP_PBA_BIR (PF3_MSIX_CAP_PBA_BIR),
    .PF3_MSIX_CAP_PBA_OFFSET (PF3_MSIX_CAP_PBA_OFFSET),
    .PF3_MSIX_CAP_TABLE_BIR (PF3_MSIX_CAP_TABLE_BIR),
    .PF3_MSIX_CAP_TABLE_OFFSET (PF3_MSIX_CAP_TABLE_OFFSET),
    .PF3_MSIX_CAP_TABLE_SIZE (PF3_MSIX_CAP_TABLE_SIZE),
    .PF3_PB_CAP_DATA_REG_D0 (PF3_PB_CAP_DATA_REG_D0),
    .PF3_PB_CAP_DATA_REG_D0_SUSTAINED (PF3_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF3_PB_CAP_DATA_REG_D1 (PF3_PB_CAP_DATA_REG_D1),
    .PF3_PB_CAP_DATA_REG_D3HOT (PF3_PB_CAP_DATA_REG_D3HOT),
    .PF3_PB_CAP_NEXTPTR (PF3_PB_CAP_NEXTPTR),
    .PF3_PB_CAP_SYSTEM_ALLOCATED (PF3_PB_CAP_SYSTEM_ALLOCATED),
    .PF3_PB_CAP_VER (PF3_PB_CAP_VER),
    .PF3_PM_CAP_ID (PF3_PM_CAP_ID),
    .PF3_PM_CAP_NEXTPTR (PF3_PM_CAP_NEXTPTR),
    .PF3_PM_CAP_VER_ID (PF3_PM_CAP_VER_ID),
    .PF3_RBAR_CAP_ENABLE (PF3_RBAR_CAP_ENABLE),
    .PF3_RBAR_CAP_NEXTPTR (PF3_RBAR_CAP_NEXTPTR),
    .PF3_RBAR_CAP_SIZE0 (PF3_RBAR_CAP_SIZE0),
    .PF3_RBAR_CAP_SIZE1 (PF3_RBAR_CAP_SIZE1),
    .PF3_RBAR_CAP_SIZE2 (PF3_RBAR_CAP_SIZE2),
    .PF3_RBAR_CAP_VER (PF3_RBAR_CAP_VER),
    .PF3_RBAR_CONTROL_INDEX0 (PF3_RBAR_CONTROL_INDEX0),
    .PF3_RBAR_CONTROL_INDEX1 (PF3_RBAR_CONTROL_INDEX1),
    .PF3_RBAR_CONTROL_INDEX2 (PF3_RBAR_CONTROL_INDEX2),
    .PF3_RBAR_CONTROL_SIZE0 (PF3_RBAR_CONTROL_SIZE0),
    .PF3_RBAR_CONTROL_SIZE1 (PF3_RBAR_CONTROL_SIZE1),
    .PF3_RBAR_CONTROL_SIZE2 (PF3_RBAR_CONTROL_SIZE2),
    .PF3_RBAR_NUM (PF3_RBAR_NUM),
    .PF3_REVISION_ID (PF3_REVISION_ID),
    .PF3_SRIOV_BAR0_APERTURE_SIZE (PF3_SRIOV_BAR0_APERTURE_SIZE),
    .PF3_SRIOV_BAR0_CONTROL (PF3_SRIOV_BAR0_CONTROL),
    .PF3_SRIOV_BAR1_APERTURE_SIZE (PF3_SRIOV_BAR1_APERTURE_SIZE),
    .PF3_SRIOV_BAR1_CONTROL (PF3_SRIOV_BAR1_CONTROL),
    .PF3_SRIOV_BAR2_APERTURE_SIZE (PF3_SRIOV_BAR2_APERTURE_SIZE),
    .PF3_SRIOV_BAR2_CONTROL (PF3_SRIOV_BAR2_CONTROL),
    .PF3_SRIOV_BAR3_APERTURE_SIZE (PF3_SRIOV_BAR3_APERTURE_SIZE),
    .PF3_SRIOV_BAR3_CONTROL (PF3_SRIOV_BAR3_CONTROL),
    .PF3_SRIOV_BAR4_APERTURE_SIZE (PF3_SRIOV_BAR4_APERTURE_SIZE),
    .PF3_SRIOV_BAR4_CONTROL (PF3_SRIOV_BAR4_CONTROL),
    .PF3_SRIOV_BAR5_APERTURE_SIZE (PF3_SRIOV_BAR5_APERTURE_SIZE),
    .PF3_SRIOV_BAR5_CONTROL (PF3_SRIOV_BAR5_CONTROL),
    .PF3_SRIOV_CAP_INITIAL_VF (PF3_SRIOV_CAP_INITIAL_VF),
    .PF3_SRIOV_CAP_NEXTPTR (PF3_SRIOV_CAP_NEXTPTR),
    .PF3_SRIOV_CAP_TOTAL_VF (PF3_SRIOV_CAP_TOTAL_VF),
    .PF3_SRIOV_CAP_VER (PF3_SRIOV_CAP_VER),
    .PF3_SRIOV_FIRST_VF_OFFSET (PF3_SRIOV_FIRST_VF_OFFSET),
    .PF3_SRIOV_FUNC_DEP_LINK (PF3_SRIOV_FUNC_DEP_LINK),
    .PF3_SRIOV_SUPPORTED_PAGE_SIZE (PF3_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF3_SRIOV_VF_DEVICE_ID (PF3_SRIOV_VF_DEVICE_ID),
    .PF3_SUBSYSTEM_ID (PF3_SUBSYSTEM_ID),
    .PF3_TPHR_CAP_DEV_SPECIFIC_MODE (PF3_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF3_TPHR_CAP_ENABLE (PF3_TPHR_CAP_ENABLE),
    .PF3_TPHR_CAP_INT_VEC_MODE (PF3_TPHR_CAP_INT_VEC_MODE),
    .PF3_TPHR_CAP_NEXTPTR (PF3_TPHR_CAP_NEXTPTR),
    .PF3_TPHR_CAP_ST_MODE_SEL (PF3_TPHR_CAP_ST_MODE_SEL),
    .PF3_TPHR_CAP_ST_TABLE_LOC (PF3_TPHR_CAP_ST_TABLE_LOC),
    .PF3_TPHR_CAP_ST_TABLE_SIZE (PF3_TPHR_CAP_ST_TABLE_SIZE),
    .PF3_TPHR_CAP_VER (PF3_TPHR_CAP_VER),
    .PL_DISABLE_AUTO_EQ_SPEED_CHANGE_TO_GEN3 (PL_DISABLE_AUTO_EQ_SPEED_CHANGE_TO_GEN3),
    .PL_DISABLE_AUTO_SPEED_CHANGE_TO_GEN2 (PL_DISABLE_AUTO_SPEED_CHANGE_TO_GEN2),
    .PL_DISABLE_EI_INFER_IN_L0 (PL_DISABLE_EI_INFER_IN_L0),
    .PL_DISABLE_GEN3_DC_BALANCE (PL_DISABLE_GEN3_DC_BALANCE),
    .PL_DISABLE_GEN3_LFSR_UPDATE_ON_SKP (PL_DISABLE_GEN3_LFSR_UPDATE_ON_SKP),
    .PL_DISABLE_RETRAIN_ON_FRAMING_ERROR (PL_DISABLE_RETRAIN_ON_FRAMING_ERROR),
    .PL_DISABLE_SCRAMBLING (PL_DISABLE_SCRAMBLING),
    .PL_DISABLE_SYNC_HEADER_FRAMING_ERROR (PL_DISABLE_SYNC_HEADER_FRAMING_ERROR),
    .PL_DISABLE_UPCONFIG_CAPABLE (PL_DISABLE_UPCONFIG_CAPABLE),
    .PL_EQ_ADAPT_DISABLE_COEFF_CHECK (PL_EQ_ADAPT_DISABLE_COEFF_CHECK),
    .PL_EQ_ADAPT_DISABLE_PRESET_CHECK (PL_EQ_ADAPT_DISABLE_PRESET_CHECK),
    .PL_EQ_ADAPT_ITER_COUNT (PL_EQ_ADAPT_ITER_COUNT),
    .PL_EQ_ADAPT_REJECT_RETRY_COUNT (PL_EQ_ADAPT_REJECT_RETRY_COUNT),
    .PL_EQ_BYPASS_PHASE23 (PL_EQ_BYPASS_PHASE23),
    .PL_EQ_DEFAULT_GEN3_RX_PRESET_HINT (PL_EQ_DEFAULT_GEN3_RX_PRESET_HINT),
    .PL_EQ_DEFAULT_GEN3_TX_PRESET (PL_EQ_DEFAULT_GEN3_TX_PRESET),
    .PL_EQ_PHASE01_RX_ADAPT (PL_EQ_PHASE01_RX_ADAPT),
    .PL_EQ_SHORT_ADAPT_PHASE (PL_EQ_SHORT_ADAPT_PHASE),
    .PL_LANE0_EQ_CONTROL (PL_LANE0_EQ_CONTROL),
    .PL_LANE1_EQ_CONTROL (PL_LANE1_EQ_CONTROL),
    .PL_LANE2_EQ_CONTROL (PL_LANE2_EQ_CONTROL),
    .PL_LANE3_EQ_CONTROL (PL_LANE3_EQ_CONTROL),
    .PL_LANE4_EQ_CONTROL (PL_LANE4_EQ_CONTROL),
    .PL_LANE5_EQ_CONTROL (PL_LANE5_EQ_CONTROL),
    .PL_LANE6_EQ_CONTROL (PL_LANE6_EQ_CONTROL),
    .PL_LANE7_EQ_CONTROL (PL_LANE7_EQ_CONTROL),
    .PL_LINK_CAP_MAX_LINK_SPEED (PL_LINK_CAP_MAX_LINK_SPEED),
    .PL_LINK_CAP_MAX_LINK_WIDTH (PL_LINK_CAP_MAX_LINK_WIDTH),
    .PL_N_FTS_COMCLK_GEN1 (PL_N_FTS_COMCLK_GEN1),
    .PL_N_FTS_COMCLK_GEN2 (PL_N_FTS_COMCLK_GEN2),
    .PL_N_FTS_COMCLK_GEN3 (PL_N_FTS_COMCLK_GEN3),
    .PL_N_FTS_GEN1 (PL_N_FTS_GEN1),
    .PL_N_FTS_GEN2 (PL_N_FTS_GEN2),
    .PL_N_FTS_GEN3 (PL_N_FTS_GEN3),
    .PL_REPORT_ALL_PHY_ERRORS (PL_REPORT_ALL_PHY_ERRORS),
  // synthesis translate_off
    .PL_SIM_FAST_LINK_TRAINING (PL_SIM_FAST_LINK_TRAINING),
  // synthesis translate_on
    .PL_UPSTREAM_FACING (PL_UPSTREAM_FACING),
    .PM_ASPML0S_TIMEOUT (PM_ASPML0S_TIMEOUT),
    .PM_ASPML1_ENTRY_DELAY (PM_ASPML1_ENTRY_DELAY),
    .PM_ENABLE_L23_ENTRY (PM_ENABLE_L23_ENTRY),
    .PM_ENABLE_SLOT_POWER_CAPTURE (PM_ENABLE_SLOT_POWER_CAPTURE),
    .PM_L1_REENTRY_DELAY (PM_L1_REENTRY_DELAY),
    .PM_PME_SERVICE_TIMEOUT_DELAY (PM_PME_SERVICE_TIMEOUT_DELAY),
    .PM_PME_TURNOFF_ACK_DELAY (PM_PME_TURNOFF_ACK_DELAY),
    .SIM_JTAG_IDCODE (SIM_JTAG_IDCODE),
    .SIM_VERSION (SIM_VERSION),
    .SPARE_BIT0 (SPARE_BIT0),
    .SPARE_BIT1 (SPARE_BIT1),
    .SPARE_BIT2 (SPARE_BIT2),
    .SPARE_BIT3 (SPARE_BIT3),
    .SPARE_BIT4 (SPARE_BIT4),
    .SPARE_BIT5 (SPARE_BIT5),
    .SPARE_BIT6 (SPARE_BIT6),
    .SPARE_BIT7 (SPARE_BIT7),
    .SPARE_BIT8 (SPARE_BIT8),
    .SPARE_BYTE0 (SPARE_BYTE0),
    .SPARE_BYTE1 (SPARE_BYTE1),
    .SPARE_BYTE2 (SPARE_BYTE2),
    .SPARE_BYTE3 (SPARE_BYTE3),
    .SPARE_WORD0 (SPARE_WORD0),
    .SPARE_WORD1 (SPARE_WORD1),
    .SPARE_WORD2 (SPARE_WORD2),
    .SPARE_WORD3 (SPARE_WORD3),
    .SRIOV_CAP_ENABLE (SRIOV_CAP_ENABLE),
    .TL_COMPL_TIMEOUT_REG0 (TL_COMPL_TIMEOUT_REG0),
    .TL_COMPL_TIMEOUT_REG1 (TL_COMPL_TIMEOUT_REG1),
    .TL_CREDITS_CD (TL_CREDITS_CD),
    .TL_CREDITS_CH (TL_CREDITS_CH),
    .TL_CREDITS_NPD (TL_CREDITS_NPD),
    .TL_CREDITS_NPH (TL_CREDITS_NPH),
    .TL_CREDITS_PD (TL_CREDITS_PD),
    .TL_CREDITS_PH (TL_CREDITS_PH),
    .TL_ENABLE_MESSAGE_RID_CHECK_ENABLE (TL_ENABLE_MESSAGE_RID_CHECK_ENABLE),
    .TL_EXTENDED_CFG_EXTEND_INTERFACE_ENABLE (TL_EXTENDED_CFG_EXTEND_INTERFACE_ENABLE),
    .TL_LEGACY_CFG_EXTEND_INTERFACE_ENABLE (TL_LEGACY_CFG_EXTEND_INTERFACE_ENABLE),
    .TL_LEGACY_MODE_ENABLE (TL_LEGACY_MODE_ENABLE),
    .TL_PF_ENABLE_REG (TL_PF_ENABLE_REG),
    .TL_TX_MUX_STRICT_PRIORITY (TL_TX_MUX_STRICT_PRIORITY),
    .TWO_LAYER_MODE_DLCMSM_ENABLE (TWO_LAYER_MODE_DLCMSM_ENABLE),
    .TWO_LAYER_MODE_ENABLE (TWO_LAYER_MODE_ENABLE),
    .TWO_LAYER_MODE_WIDTH_256 (TWO_LAYER_MODE_WIDTH_256),
    .VF0_ARI_CAP_NEXTPTR (VF0_ARI_CAP_NEXTPTR),
    .VF0_CAPABILITY_POINTER (VF0_CAPABILITY_POINTER),
    .VF0_MSI_CAP_MULTIMSGCAP (VF0_MSI_CAP_MULTIMSGCAP),
    .VF0_MSIX_CAP_PBA_BIR (VF0_MSIX_CAP_PBA_BIR),
    .VF0_MSIX_CAP_PBA_OFFSET (VF0_MSIX_CAP_PBA_OFFSET),
    .VF0_MSIX_CAP_TABLE_BIR (VF0_MSIX_CAP_TABLE_BIR),
    .VF0_MSIX_CAP_TABLE_OFFSET (VF0_MSIX_CAP_TABLE_OFFSET),
    .VF0_MSIX_CAP_TABLE_SIZE (VF0_MSIX_CAP_TABLE_SIZE),
    .VF0_PM_CAP_ID (VF0_PM_CAP_ID),
    .VF0_PM_CAP_NEXTPTR (VF0_PM_CAP_NEXTPTR),
    .VF0_PM_CAP_VER_ID (VF0_PM_CAP_VER_ID),
    .VF0_TPHR_CAP_DEV_SPECIFIC_MODE (VF0_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF0_TPHR_CAP_ENABLE (VF0_TPHR_CAP_ENABLE),
    .VF0_TPHR_CAP_INT_VEC_MODE (VF0_TPHR_CAP_INT_VEC_MODE),
    .VF0_TPHR_CAP_NEXTPTR (VF0_TPHR_CAP_NEXTPTR),
    .VF0_TPHR_CAP_ST_MODE_SEL (VF0_TPHR_CAP_ST_MODE_SEL),
    .VF0_TPHR_CAP_ST_TABLE_LOC (VF0_TPHR_CAP_ST_TABLE_LOC),
    .VF0_TPHR_CAP_ST_TABLE_SIZE (VF0_TPHR_CAP_ST_TABLE_SIZE),
    .VF0_TPHR_CAP_VER (VF0_TPHR_CAP_VER),
    .VF1_ARI_CAP_NEXTPTR (VF1_ARI_CAP_NEXTPTR),
    .VF1_MSI_CAP_MULTIMSGCAP (VF1_MSI_CAP_MULTIMSGCAP),
    .VF1_MSIX_CAP_PBA_BIR (VF1_MSIX_CAP_PBA_BIR),
    .VF1_MSIX_CAP_PBA_OFFSET (VF1_MSIX_CAP_PBA_OFFSET),
    .VF1_MSIX_CAP_TABLE_BIR (VF1_MSIX_CAP_TABLE_BIR),
    .VF1_MSIX_CAP_TABLE_OFFSET (VF1_MSIX_CAP_TABLE_OFFSET),
    .VF1_MSIX_CAP_TABLE_SIZE (VF1_MSIX_CAP_TABLE_SIZE),
    .VF1_PM_CAP_ID (VF1_PM_CAP_ID),
    .VF1_PM_CAP_NEXTPTR (VF1_PM_CAP_NEXTPTR),
    .VF1_PM_CAP_VER_ID (VF1_PM_CAP_VER_ID),
    .VF1_TPHR_CAP_DEV_SPECIFIC_MODE (VF1_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF1_TPHR_CAP_ENABLE (VF1_TPHR_CAP_ENABLE),
    .VF1_TPHR_CAP_INT_VEC_MODE (VF1_TPHR_CAP_INT_VEC_MODE),
    .VF1_TPHR_CAP_NEXTPTR (VF1_TPHR_CAP_NEXTPTR),
    .VF1_TPHR_CAP_ST_MODE_SEL (VF1_TPHR_CAP_ST_MODE_SEL),
    .VF1_TPHR_CAP_ST_TABLE_LOC (VF1_TPHR_CAP_ST_TABLE_LOC),
    .VF1_TPHR_CAP_ST_TABLE_SIZE (VF1_TPHR_CAP_ST_TABLE_SIZE),
    .VF1_TPHR_CAP_VER (VF1_TPHR_CAP_VER),
    .VF2_ARI_CAP_NEXTPTR (VF2_ARI_CAP_NEXTPTR),
    .VF2_MSI_CAP_MULTIMSGCAP (VF2_MSI_CAP_MULTIMSGCAP),
    .VF2_MSIX_CAP_PBA_BIR (VF2_MSIX_CAP_PBA_BIR),
    .VF2_MSIX_CAP_PBA_OFFSET (VF2_MSIX_CAP_PBA_OFFSET),
    .VF2_MSIX_CAP_TABLE_BIR (VF2_MSIX_CAP_TABLE_BIR),
    .VF2_MSIX_CAP_TABLE_OFFSET (VF2_MSIX_CAP_TABLE_OFFSET),
    .VF2_MSIX_CAP_TABLE_SIZE (VF2_MSIX_CAP_TABLE_SIZE),
    .VF2_PM_CAP_ID (VF2_PM_CAP_ID),
    .VF2_PM_CAP_NEXTPTR (VF2_PM_CAP_NEXTPTR),
    .VF2_PM_CAP_VER_ID (VF2_PM_CAP_VER_ID),
    .VF2_TPHR_CAP_DEV_SPECIFIC_MODE (VF2_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF2_TPHR_CAP_ENABLE (VF2_TPHR_CAP_ENABLE),
    .VF2_TPHR_CAP_INT_VEC_MODE (VF2_TPHR_CAP_INT_VEC_MODE),
    .VF2_TPHR_CAP_NEXTPTR (VF2_TPHR_CAP_NEXTPTR),
    .VF2_TPHR_CAP_ST_MODE_SEL (VF2_TPHR_CAP_ST_MODE_SEL),
    .VF2_TPHR_CAP_ST_TABLE_LOC (VF2_TPHR_CAP_ST_TABLE_LOC),
    .VF2_TPHR_CAP_ST_TABLE_SIZE (VF2_TPHR_CAP_ST_TABLE_SIZE),
    .VF2_TPHR_CAP_VER (VF2_TPHR_CAP_VER),
    .VF3_ARI_CAP_NEXTPTR (VF3_ARI_CAP_NEXTPTR),
    .VF3_MSI_CAP_MULTIMSGCAP (VF3_MSI_CAP_MULTIMSGCAP),
    .VF3_MSIX_CAP_PBA_BIR (VF3_MSIX_CAP_PBA_BIR),
    .VF3_MSIX_CAP_PBA_OFFSET (VF3_MSIX_CAP_PBA_OFFSET),
    .VF3_MSIX_CAP_TABLE_BIR (VF3_MSIX_CAP_TABLE_BIR),
    .VF3_MSIX_CAP_TABLE_OFFSET (VF3_MSIX_CAP_TABLE_OFFSET),
    .VF3_MSIX_CAP_TABLE_SIZE (VF3_MSIX_CAP_TABLE_SIZE),
    .VF3_PM_CAP_ID (VF3_PM_CAP_ID),
    .VF3_PM_CAP_NEXTPTR (VF3_PM_CAP_NEXTPTR),
    .VF3_PM_CAP_VER_ID (VF3_PM_CAP_VER_ID),
    .VF3_TPHR_CAP_DEV_SPECIFIC_MODE (VF3_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF3_TPHR_CAP_ENABLE (VF3_TPHR_CAP_ENABLE),
    .VF3_TPHR_CAP_INT_VEC_MODE (VF3_TPHR_CAP_INT_VEC_MODE),
    .VF3_TPHR_CAP_NEXTPTR (VF3_TPHR_CAP_NEXTPTR),
    .VF3_TPHR_CAP_ST_MODE_SEL (VF3_TPHR_CAP_ST_MODE_SEL),
    .VF3_TPHR_CAP_ST_TABLE_LOC (VF3_TPHR_CAP_ST_TABLE_LOC),
    .VF3_TPHR_CAP_ST_TABLE_SIZE (VF3_TPHR_CAP_ST_TABLE_SIZE),
    .VF3_TPHR_CAP_VER (VF3_TPHR_CAP_VER),
    .VF4_ARI_CAP_NEXTPTR (VF4_ARI_CAP_NEXTPTR),
    .VF4_MSI_CAP_MULTIMSGCAP (VF4_MSI_CAP_MULTIMSGCAP),
    .VF4_MSIX_CAP_PBA_BIR (VF4_MSIX_CAP_PBA_BIR),
    .VF4_MSIX_CAP_PBA_OFFSET (VF4_MSIX_CAP_PBA_OFFSET),
    .VF4_MSIX_CAP_TABLE_BIR (VF4_MSIX_CAP_TABLE_BIR),
    .VF4_MSIX_CAP_TABLE_OFFSET (VF4_MSIX_CAP_TABLE_OFFSET),
    .VF4_MSIX_CAP_TABLE_SIZE (VF4_MSIX_CAP_TABLE_SIZE),
    .VF4_PM_CAP_ID (VF4_PM_CAP_ID),
    .VF4_PM_CAP_NEXTPTR (VF4_PM_CAP_NEXTPTR),
    .VF4_PM_CAP_VER_ID (VF4_PM_CAP_VER_ID),
    .VF4_TPHR_CAP_DEV_SPECIFIC_MODE (VF4_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF4_TPHR_CAP_ENABLE (VF4_TPHR_CAP_ENABLE),
    .VF4_TPHR_CAP_INT_VEC_MODE (VF4_TPHR_CAP_INT_VEC_MODE),
    .VF4_TPHR_CAP_NEXTPTR (VF4_TPHR_CAP_NEXTPTR),
    .VF4_TPHR_CAP_ST_MODE_SEL (VF4_TPHR_CAP_ST_MODE_SEL),
    .VF4_TPHR_CAP_ST_TABLE_LOC (VF4_TPHR_CAP_ST_TABLE_LOC),
    .VF4_TPHR_CAP_ST_TABLE_SIZE (VF4_TPHR_CAP_ST_TABLE_SIZE),
    .VF4_TPHR_CAP_VER (VF4_TPHR_CAP_VER),
    .VF5_ARI_CAP_NEXTPTR (VF5_ARI_CAP_NEXTPTR),
    .VF5_MSI_CAP_MULTIMSGCAP (VF5_MSI_CAP_MULTIMSGCAP),
    .VF5_MSIX_CAP_PBA_BIR (VF5_MSIX_CAP_PBA_BIR),
    .VF5_MSIX_CAP_PBA_OFFSET (VF5_MSIX_CAP_PBA_OFFSET),
    .VF5_MSIX_CAP_TABLE_BIR (VF5_MSIX_CAP_TABLE_BIR),
    .VF5_MSIX_CAP_TABLE_OFFSET (VF5_MSIX_CAP_TABLE_OFFSET),
    .VF5_MSIX_CAP_TABLE_SIZE (VF5_MSIX_CAP_TABLE_SIZE),
    .VF5_PM_CAP_ID (VF5_PM_CAP_ID),
    .VF5_PM_CAP_NEXTPTR (VF5_PM_CAP_NEXTPTR),
    .VF5_PM_CAP_VER_ID (VF5_PM_CAP_VER_ID),
    .VF5_TPHR_CAP_DEV_SPECIFIC_MODE (VF5_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF5_TPHR_CAP_ENABLE (VF5_TPHR_CAP_ENABLE),
    .VF5_TPHR_CAP_INT_VEC_MODE (VF5_TPHR_CAP_INT_VEC_MODE),
    .VF5_TPHR_CAP_NEXTPTR (VF5_TPHR_CAP_NEXTPTR),
    .VF5_TPHR_CAP_ST_MODE_SEL (VF5_TPHR_CAP_ST_MODE_SEL),
    .VF5_TPHR_CAP_ST_TABLE_LOC (VF5_TPHR_CAP_ST_TABLE_LOC),
    .VF5_TPHR_CAP_ST_TABLE_SIZE (VF5_TPHR_CAP_ST_TABLE_SIZE),
    .VF5_TPHR_CAP_VER (VF5_TPHR_CAP_VER),
    .VF6_ARI_CAP_NEXTPTR (VF6_ARI_CAP_NEXTPTR),
    .VF6_MSI_CAP_MULTIMSGCAP (VF6_MSI_CAP_MULTIMSGCAP),
    .VF6_MSIX_CAP_PBA_BIR (VF6_MSIX_CAP_PBA_BIR),
    .VF6_MSIX_CAP_PBA_OFFSET (VF6_MSIX_CAP_PBA_OFFSET),
    .VF6_MSIX_CAP_TABLE_BIR (VF6_MSIX_CAP_TABLE_BIR),
    .VF6_MSIX_CAP_TABLE_OFFSET (VF6_MSIX_CAP_TABLE_OFFSET),
    .VF6_MSIX_CAP_TABLE_SIZE (VF6_MSIX_CAP_TABLE_SIZE),
    .VF6_PM_CAP_ID (VF6_PM_CAP_ID),
    .VF6_PM_CAP_NEXTPTR (VF6_PM_CAP_NEXTPTR),
    .VF6_PM_CAP_VER_ID (VF6_PM_CAP_VER_ID),
    .VF6_TPHR_CAP_DEV_SPECIFIC_MODE (VF6_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF6_TPHR_CAP_ENABLE (VF6_TPHR_CAP_ENABLE),
    .VF6_TPHR_CAP_INT_VEC_MODE (VF6_TPHR_CAP_INT_VEC_MODE),
    .VF6_TPHR_CAP_NEXTPTR (VF6_TPHR_CAP_NEXTPTR),
    .VF6_TPHR_CAP_ST_MODE_SEL (VF6_TPHR_CAP_ST_MODE_SEL),
    .VF6_TPHR_CAP_ST_TABLE_LOC (VF6_TPHR_CAP_ST_TABLE_LOC),
    .VF6_TPHR_CAP_ST_TABLE_SIZE (VF6_TPHR_CAP_ST_TABLE_SIZE),
    .VF6_TPHR_CAP_VER (VF6_TPHR_CAP_VER),
    .VF7_ARI_CAP_NEXTPTR (VF7_ARI_CAP_NEXTPTR),
    .VF7_MSI_CAP_MULTIMSGCAP (VF7_MSI_CAP_MULTIMSGCAP),
    .VF7_MSIX_CAP_PBA_BIR (VF7_MSIX_CAP_PBA_BIR),
    .VF7_MSIX_CAP_PBA_OFFSET (VF7_MSIX_CAP_PBA_OFFSET),
    .VF7_MSIX_CAP_TABLE_BIR (VF7_MSIX_CAP_TABLE_BIR),
    .VF7_MSIX_CAP_TABLE_OFFSET (VF7_MSIX_CAP_TABLE_OFFSET),
    .VF7_MSIX_CAP_TABLE_SIZE (VF7_MSIX_CAP_TABLE_SIZE),
    .VF7_PM_CAP_ID (VF7_PM_CAP_ID),
    .VF7_PM_CAP_NEXTPTR (VF7_PM_CAP_NEXTPTR),
    .VF7_PM_CAP_VER_ID (VF7_PM_CAP_VER_ID),
    .VF7_TPHR_CAP_DEV_SPECIFIC_MODE (VF7_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF7_TPHR_CAP_ENABLE (VF7_TPHR_CAP_ENABLE),
    .VF7_TPHR_CAP_INT_VEC_MODE (VF7_TPHR_CAP_INT_VEC_MODE),
    .VF7_TPHR_CAP_NEXTPTR (VF7_TPHR_CAP_NEXTPTR),
    .VF7_TPHR_CAP_ST_MODE_SEL (VF7_TPHR_CAP_ST_MODE_SEL),
    .VF7_TPHR_CAP_ST_TABLE_LOC (VF7_TPHR_CAP_ST_TABLE_LOC),
    .VF7_TPHR_CAP_ST_TABLE_SIZE (VF7_TPHR_CAP_ST_TABLE_SIZE),
    .VF7_TPHR_CAP_VER (VF7_TPHR_CAP_VER))
  pcie3_uscale_top_inst (
    .s_axis_rq_tdata (s_axis_rq_tdata),
    .s_axis_rq_tkeep (s_axis_rq_tkeep),
    .s_axis_rq_tlast (s_axis_rq_tlast),
    .s_axis_rq_tready (s_axis_rq_tready_wire),
    .s_axis_rq_tuser (s_axis_rq_tuser),
    .s_axis_rq_tvalid (s_axis_rq_tvalid_mux),
    .m_axis_rc_tdata (m_axis_rc_tdata),
    .m_axis_rc_tkeep (m_axis_rc_tkeep),
    .m_axis_rc_tlast (m_axis_rc_tlast),
    .m_axis_rc_tready (m_axis_rc_tready_mux),
    .m_axis_rc_tuser (m_axis_rc_tuser),
    .m_axis_rc_tvalid (m_axis_rc_tvalid_wire),
    .m_axis_cq_tdata (m_axis_cq_tdata),
    .m_axis_cq_tkeep (m_axis_cq_tkeep),
    .m_axis_cq_tlast (m_axis_cq_tlast),
    .m_axis_cq_tready (m_axis_cq_tready_mux),
    .m_axis_cq_tuser (m_axis_cq_tuser),
    .m_axis_cq_tvalid (m_axis_cq_tvalid_wire),
    .s_axis_cc_tdata (s_axis_cc_tdata),
    .s_axis_cc_tkeep (s_axis_cc_tkeep),
    .s_axis_cc_tlast (s_axis_cc_tlast),
    .s_axis_cc_tready (s_axis_cc_tready_wire),
    .s_axis_cc_tuser (s_axis_cc_tuser),
    .s_axis_cc_tvalid (s_axis_cc_tvalid_mux),
    .pcie_rq_seq_num (pcie_rq_seq_num),
    .pcie_rq_seq_num_vld (pcie_rq_seq_num_vld),
    .pcie_rq_tag (pcie_rq_tag),
    .pcie_rq_tag_av (pcie_rq_tag_av),
    .pcie_rq_tag_vld (pcie_rq_tag_vld),
    .pcie_tfc_npd_av (pcie_tfc_npd_av),
    .pcie_tfc_nph_av (pcie_tfc_nph_av),
    .pcie_cq_np_req (pcie_cq_np_req_mux),
    .pcie_cq_np_req_count (pcie_cq_np_req_count),
    .cfg_mgmt_addr (cfg_mgmt_addr),
    .cfg_mgmt_byte_enable (cfg_mgmt_byte_enable),
    .cfg_mgmt_read (cfg_mgmt_read),
    .cfg_mgmt_read_data (cfg_mgmt_read_data),
    .cfg_mgmt_read_write_done (cfg_mgmt_read_write_done),
    .cfg_mgmt_type1_cfg_reg_access (cfg_mgmt_type1_cfg_reg_access),
    .cfg_mgmt_write (cfg_mgmt_write_mux),
    .cfg_mgmt_write_data (cfg_mgmt_write_data),
    .cfg_phy_link_down (cfg_phy_link_down),
    .cfg_phy_link_status (cfg_phy_link_status),
    .cfg_negotiated_width (cfg_negotiated_width),
    .cfg_current_speed (cfg_current_speed),
    .cfg_max_payload (cfg_max_payload),
    .cfg_max_read_req (cfg_max_read_req),
    .cfg_function_status (cfg_function_status),
    .cfg_function_power_state (cfg_function_power_state),
    .cfg_vf_status (cfg_vf_status),
    .cfg_vf_power_state (cfg_vf_power_state),
    .cfg_link_power_state (cfg_link_power_state),
    .cfg_err_cor_out (cfg_err_cor_out),
    .cfg_err_nonfatal_out (cfg_err_nonfatal_out),
    .cfg_err_fatal_out (cfg_err_fatal_out),
    .cfg_local_error (cfg_local_error),
    .cfg_ltr_enable (cfg_ltr_enable),
    .cfg_ltssm_state (cfg_ltssm_state),
    .cfg_rcb_status (cfg_rcb_status),
    .cfg_dpa_substate_change (cfg_dpa_substate_change),
    .cfg_obff_enable (cfg_obff_enable),
    .cfg_pl_status_change (cfg_pl_status_change),
    .cfg_tph_requester_enable (cfg_tph_requester_enable),
    .cfg_tph_st_mode (cfg_tph_st_mode),
    .cfg_vf_tph_requester_enable (cfg_vf_tph_requester_enable),
    .cfg_vf_tph_st_mode (cfg_vf_tph_st_mode),
    .cfg_msg_received (cfg_msg_received),
    .cfg_msg_received_data (cfg_msg_received_data),
    .cfg_msg_received_type (cfg_msg_received_type),
    .cfg_msg_transmit (cfg_msg_transmit_mux),
    .cfg_msg_transmit_type (cfg_msg_transmit_type),
    .cfg_msg_transmit_data (cfg_msg_transmit_data),
    .cfg_msg_transmit_done (cfg_msg_transmit_done),
    .cfg_fc_ph (cfg_fc_ph),
    .cfg_fc_pd (cfg_fc_pd),
    .cfg_fc_nph (cfg_fc_nph),
    .cfg_fc_npd (cfg_fc_npd),
    .cfg_fc_cplh (cfg_fc_cplh),
    .cfg_fc_cpld (cfg_fc_cpld),
    .cfg_fc_sel (cfg_fc_sel),
    .cfg_per_func_status_control (cfg_per_func_status_control),
    .cfg_per_func_status_data (cfg_per_func_status_data),
    .cfg_per_function_number (cfg_per_function_number),
    .cfg_per_function_output_request (cfg_per_function_output_request),
    .cfg_per_function_update_done (cfg_per_function_update_done),
    .cfg_power_state_change_ack (cfg_power_state_change_ack_mux),
    .cfg_power_state_change_interrupt (cfg_power_state_change_interrupt),
    .cfg_err_cor_in (cfg_err_cor_in_mux),
    .cfg_err_uncor_in (cfg_err_uncor_in_mux),
    .cfg_flr_in_process (cfg_flr_in_process),
    .cfg_flr_done (cfg_flr_done_mux),
    .cfg_vf_flr_in_process (cfg_vf_flr_in_process),
    .cfg_vf_flr_done (cfg_vf_flr_done_mux),
    .cfg_link_training_enable (cfg_link_training_enable_mux),
    .cfg_interrupt_int (cfg_interrupt_int_mux),
    .cfg_interrupt_pending (cfg_interrupt_pending),
    .cfg_interrupt_sent (cfg_interrupt_sent),
    .cfg_interrupt_msi_enable (cfg_interrupt_msi_enable),
    .cfg_interrupt_msi_vf_enable (cfg_interrupt_msi_vf_enable),
    .cfg_interrupt_msi_mmenable (cfg_interrupt_msi_mmenable),
    .cfg_interrupt_msi_mask_update (cfg_interrupt_msi_mask_update),
    .cfg_interrupt_msi_data (cfg_interrupt_msi_data),
    .cfg_interrupt_msi_select (cfg_interrupt_msi_select),
    .cfg_interrupt_msi_int (cfg_interrupt_msi_int_mux),
    .cfg_interrupt_msi_pending_status (cfg_interrupt_msi_pending_status),
    .cfg_interrupt_msi_pending_status_data_enable (cfg_interrupt_msi_pending_status_data_enable_mux),
    .cfg_interrupt_msi_pending_status_function_num (cfg_interrupt_msi_pending_status_function_num),
    .cfg_interrupt_msi_sent (cfg_interrupt_msi_sent),
    .cfg_interrupt_msi_fail (cfg_interrupt_msi_fail),
    .cfg_interrupt_msix_enable (cfg_interrupt_msix_enable),
    .cfg_interrupt_msix_mask (cfg_interrupt_msix_mask),
    .cfg_interrupt_msix_vf_enable (cfg_interrupt_msix_vf_enable),
    .cfg_interrupt_msix_vf_mask (cfg_interrupt_msix_vf_mask),
    .cfg_interrupt_msix_data (cfg_interrupt_msix_data),
    .cfg_interrupt_msix_address (cfg_interrupt_msix_address),
    .cfg_interrupt_msix_int (cfg_interrupt_msix_int_mux),
    .cfg_interrupt_msix_sent (cfg_interrupt_msix_sent),
    .cfg_interrupt_msix_fail (cfg_interrupt_msix_fail),
    .cfg_interrupt_msi_attr (cfg_interrupt_msi_attr),
    .cfg_interrupt_msi_tph_present (cfg_interrupt_msi_tph_present),
    .cfg_interrupt_msi_tph_type (cfg_interrupt_msi_tph_type),
    .cfg_interrupt_msi_tph_st_tag (cfg_interrupt_msi_tph_st_tag),
    .cfg_interrupt_msi_function_number (cfg_interrupt_msi_function_number),
    .cfg_ext_read_received (cfg_ext_read_received),
    .cfg_ext_write_received (cfg_ext_write_received),
    .cfg_ext_register_number (cfg_ext_register_number),
    .cfg_ext_function_number (cfg_ext_function_number),
    .cfg_ext_write_data (cfg_ext_write_data),
    .cfg_ext_write_byte_enable (cfg_ext_write_byte_enable),
    .cfg_ext_read_data (cfg_ext_read_data),
    .cfg_ext_read_data_valid (cfg_ext_read_data_valid),
    .cfg_dev_id (cfg_dev_id_mux),
    .cfg_vend_id (cfg_vend_id),
    .cfg_rev_id (cfg_rev_id),
    .cfg_subsys_id (cfg_subsys_id),
    .cfg_subsys_vend_id (cfg_subsys_vend_id),
    .cfg_ds_port_number (cfg_ds_port_number),
    .cfg_hot_reset_out (cfg_hot_reset_out),
    .cfg_config_space_enable (cfg_config_space_enable_mux),
    .cfg_req_pm_transition_l23_ready (cfg_req_pm_transition_l23_ready_mux),
    .cfg_hot_reset_in (cfg_hot_reset_in_mux),
    .cfg_ds_bus_number (cfg_ds_bus_number),
    .cfg_ds_device_number (cfg_ds_device_number),
    .cfg_ds_function_number (cfg_ds_function_number),
    .cfg_dsn (cfg_dsn_mux),
    .drp_rdy (drp_rdy),
    .drp_do (drp_do),
    .drp_clk( drp_clk),
    .drp_en (drp_en_mux),
    .drp_we (drp_we),
    .drp_addr (drp_addr[9:0]),
    .drp_di (drp_di),
    .user_tph_stt_address (user_tph_stt_address),
    .user_tph_function_num (user_tph_function_num),
    .user_tph_stt_read_data (user_tph_stt_read_data),
    .user_tph_stt_read_data_valid (user_tph_stt_read_data_valid),
    .user_tph_stt_read_enable (user_tph_stt_read_enable),
    .conf_req_type (conf_req_type),
    .conf_req_reg_num (conf_req_reg_num),
    .conf_req_data (conf_req_data),
    .conf_req_valid (conf_req_valid_mux),
    .conf_mcap_request_by_conf (mcap_external_request),
    .conf_req_ready (conf_req_ready_wire),
    .conf_resp_rdata (conf_resp_rdata),
    .conf_resp_valid (conf_resp_valid),
    .conf_mcap_design_switch (),
    .conf_mcap_eos (),
    .conf_mcap_in_use_by_pcie (mcap_pcie_request),
    .pl_eq_in_progress (pl_eq_in_progress),
    .dbg_mcap_cs_b (),
    .dbg_mcap_data (),
    .dbg_mcap_eos (),
    .dbg_mcap_errror (),
    .dbg_mcap_mode (),
    .dbg_mcap_rdata_valid (),
    .dbg_mcap_rdwr_b (),
    .dbg_mcap_reset (),
    .pl_eq_phase (pl_eq_phase),
    .pcie_perstn0_in (sys_reset),
    .pcie_perstn0_out (sys_reset_pt),
    .pcie_perstn1_in (pcie_perstn1_in),
    .pcie_perstn1_out (pcie_perstn1_out),
    .pl_eq_reset_eieos_count (pl_eq_reset_eieos_count_mux),
    .pl_gen2_upstream_prefer_deemph (pl_gen2_upstream_prefer_deemph_mux),

    .pipe_clk (pipe_clk),
    .core_clk (core_clk),
    .user_clk (user_clk),
    .mcap_clk (mcap_clk),
    .phy_rdy (phy_rdy),
    .pipe_tx_eqfs_gt (pipe_tx_eqfs), 
    .pipe_tx_eqlf_gt (pipe_tx_eqlf), 
    .pipe_tx0_rcvr_det_gt (pipe_tx0_rcvr_det), 
    .pipe_tx0_rate_gt (pipe_tx0_rate), 
    .pipe_tx0_deemph_gt (pipe_tx0_deemph), 
    .pipe_tx0_margin_gt (pipe_tx0_margin), 
    .pipe_tx0_swing_gt (pipe_tx0_swing), 
    .pipe_tx0_reset_gt (pipe_tx0_reset), 
    .pipe_tx0_compliance_gt (pipe_tx0_compliance),
    .pipe_tx1_compliance_gt (pipe_tx1_compliance),
    .pipe_tx2_compliance_gt (pipe_tx2_compliance),
    .pipe_tx3_compliance_gt (pipe_tx3_compliance),
    .pipe_tx4_compliance_gt (pipe_tx4_compliance),
    .pipe_tx5_compliance_gt (pipe_tx5_compliance),
    .pipe_tx6_compliance_gt (pipe_tx6_compliance),
    .pipe_tx7_compliance_gt (pipe_tx7_compliance),
    .pipe_tx0_data_valid_gt (pipe_tx0_data_valid),
    .pipe_tx1_data_valid_gt (pipe_tx1_data_valid),
    .pipe_tx2_data_valid_gt (pipe_tx2_data_valid),
    .pipe_tx3_data_valid_gt (pipe_tx3_data_valid),
    .pipe_tx4_data_valid_gt (pipe_tx4_data_valid),
    .pipe_tx5_data_valid_gt (pipe_tx5_data_valid),
    .pipe_tx6_data_valid_gt (pipe_tx6_data_valid),
    .pipe_tx7_data_valid_gt (pipe_tx7_data_valid),
    .pipe_tx0_elec_idle_gt (pipe_tx0_elec_idle),
    .pipe_tx1_elec_idle_gt (pipe_tx1_elec_idle),
    .pipe_tx2_elec_idle_gt (pipe_tx2_elec_idle),
    .pipe_tx3_elec_idle_gt (pipe_tx3_elec_idle),
    .pipe_tx4_elec_idle_gt (pipe_tx4_elec_idle),
    .pipe_tx5_elec_idle_gt (pipe_tx5_elec_idle),
    .pipe_tx6_elec_idle_gt (pipe_tx6_elec_idle),
    .pipe_tx7_elec_idle_gt (pipe_tx7_elec_idle),
    .pipe_tx0_start_block_gt (pipe_tx0_start_block),
    .pipe_tx1_start_block_gt (pipe_tx1_start_block),
    .pipe_tx2_start_block_gt (pipe_tx2_start_block),
    .pipe_tx3_start_block_gt (pipe_tx3_start_block),
    .pipe_tx4_start_block_gt (pipe_tx4_start_block),
    .pipe_tx5_start_block_gt (pipe_tx5_start_block),
    .pipe_tx6_start_block_gt (pipe_tx6_start_block),
    .pipe_tx7_start_block_gt (pipe_tx7_start_block),
    .pipe_rx0_polarity_gt (pipe_rx0_polarity),
    .pipe_rx1_polarity_gt (pipe_rx1_polarity),
    .pipe_rx2_polarity_gt (pipe_rx2_polarity),
    .pipe_rx3_polarity_gt (pipe_rx3_polarity),
    .pipe_rx4_polarity_gt (pipe_rx4_polarity),
    .pipe_rx5_polarity_gt (pipe_rx5_polarity),
    .pipe_rx6_polarity_gt (pipe_rx6_polarity),
    .pipe_rx7_polarity_gt (pipe_rx7_polarity),
    .pipe_rx0_eqcontrol_gt (pipe_rx0_eqcontrol),
    .pipe_rx1_eqcontrol_gt (pipe_rx1_eqcontrol),
    .pipe_rx2_eqcontrol_gt (pipe_rx2_eqcontrol),
    .pipe_rx3_eqcontrol_gt (pipe_rx3_eqcontrol),
    .pipe_rx4_eqcontrol_gt (pipe_rx4_eqcontrol),
    .pipe_rx5_eqcontrol_gt (pipe_rx5_eqcontrol),
    .pipe_rx6_eqcontrol_gt (pipe_rx6_eqcontrol),
    .pipe_rx7_eqcontrol_gt (pipe_rx7_eqcontrol),
    .pipe_tx0_char_is_k_gt (pipe_tx0_char_is_k),
    .pipe_tx1_char_is_k_gt (pipe_tx1_char_is_k),
    .pipe_tx2_char_is_k_gt (pipe_tx2_char_is_k),
    .pipe_tx3_char_is_k_gt (pipe_tx3_char_is_k),
    .pipe_tx4_char_is_k_gt (pipe_tx4_char_is_k),
    .pipe_tx5_char_is_k_gt (pipe_tx5_char_is_k),
    .pipe_tx6_char_is_k_gt (pipe_tx6_char_is_k),
    .pipe_tx7_char_is_k_gt (pipe_tx7_char_is_k),
    .pipe_tx0_eqcontrol_gt (pipe_tx0_eqcontrol),
    .pipe_tx1_eqcontrol_gt (pipe_tx1_eqcontrol),
    .pipe_tx2_eqcontrol_gt (pipe_tx2_eqcontrol),
    .pipe_tx3_eqcontrol_gt (pipe_tx3_eqcontrol),
    .pipe_tx4_eqcontrol_gt (pipe_tx4_eqcontrol),
    .pipe_tx5_eqcontrol_gt (pipe_tx5_eqcontrol),
    .pipe_tx6_eqcontrol_gt (pipe_tx6_eqcontrol),
    .pipe_tx7_eqcontrol_gt (pipe_tx7_eqcontrol),
    .pipe_tx0_powerdown_gt (pipe_tx0_powerdown),
    .pipe_tx1_powerdown_gt (pipe_tx1_powerdown),
    .pipe_tx2_powerdown_gt (pipe_tx2_powerdown),
    .pipe_tx3_powerdown_gt (pipe_tx3_powerdown),
    .pipe_tx4_powerdown_gt (pipe_tx4_powerdown),
    .pipe_tx5_powerdown_gt (pipe_tx5_powerdown),
    .pipe_tx6_powerdown_gt (pipe_tx6_powerdown),
    .pipe_tx7_powerdown_gt (pipe_tx7_powerdown),
    .pipe_tx0_syncheader_gt (pipe_tx0_syncheader),
    .pipe_tx1_syncheader_gt (pipe_tx1_syncheader),
    .pipe_tx2_syncheader_gt (pipe_tx2_syncheader),
    .pipe_tx3_syncheader_gt (pipe_tx3_syncheader),
    .pipe_tx4_syncheader_gt (pipe_tx4_syncheader),
    .pipe_tx5_syncheader_gt (pipe_tx5_syncheader),
    .pipe_tx6_syncheader_gt (pipe_tx6_syncheader),
    .pipe_tx7_syncheader_gt (pipe_tx7_syncheader),
    .pipe_rx0_eqpreset_gt (pipe_rx0_eqpreset),
    .pipe_rx1_eqpreset_gt (pipe_rx1_eqpreset),
    .pipe_rx2_eqpreset_gt (pipe_rx2_eqpreset),
    .pipe_rx3_eqpreset_gt (pipe_rx3_eqpreset),
    .pipe_rx4_eqpreset_gt (pipe_rx4_eqpreset),
    .pipe_rx5_eqpreset_gt (pipe_rx5_eqpreset),
    .pipe_rx6_eqpreset_gt (pipe_rx6_eqpreset),
    .pipe_rx7_eqpreset_gt (pipe_rx7_eqpreset),
    .pipe_tx0_data_gt (pipe_tx0_data),
    .pipe_tx1_data_gt (pipe_tx1_data),
    .pipe_tx2_data_gt (pipe_tx2_data),
    .pipe_tx3_data_gt (pipe_tx3_data),
    .pipe_tx4_data_gt (pipe_tx4_data),
    .pipe_tx5_data_gt (pipe_tx5_data),
    .pipe_tx6_data_gt (pipe_tx6_data),
    .pipe_tx7_data_gt (pipe_tx7_data),
    .pipe_rx0_eqlp_txpreset_gt (pipe_rx0_eq_txpreset),
    .pipe_rx1_eqlp_txpreset_gt (pipe_rx1_eq_txpreset),
    .pipe_rx2_eqlp_txpreset_gt (pipe_rx2_eq_txpreset),
    .pipe_rx3_eqlp_txpreset_gt (pipe_rx3_eq_txpreset),
    .pipe_rx4_eqlp_txpreset_gt (pipe_rx4_eq_txpreset),
    .pipe_rx5_eqlp_txpreset_gt (pipe_rx5_eq_txpreset),
    .pipe_rx6_eqlp_txpreset_gt (pipe_rx6_eq_txpreset),
    .pipe_rx7_eqlp_txpreset_gt (pipe_rx7_eq_txpreset),
    .pipe_tx0_eqpreset_gt (pipe_tx0_eqpreset),
    .pipe_tx1_eqpreset_gt (pipe_tx1_eqpreset),
    .pipe_tx2_eqpreset_gt (pipe_tx2_eqpreset),
    .pipe_tx3_eqpreset_gt (pipe_tx3_eqpreset),
    .pipe_tx4_eqpreset_gt (pipe_tx4_eqpreset),
    .pipe_tx5_eqpreset_gt (pipe_tx5_eqpreset),
    .pipe_tx6_eqpreset_gt (pipe_tx6_eqpreset),
    .pipe_tx7_eqpreset_gt (pipe_tx7_eqpreset),
    .pipe_rx0_eqlp_lffs_gt (pipe_rx0_eq_lffs),
    .pipe_rx1_eqlp_lffs_gt (pipe_rx1_eq_lffs),
    .pipe_rx2_eqlp_lffs_gt (pipe_rx2_eq_lffs),
    .pipe_rx3_eqlp_lffs_gt (pipe_rx3_eq_lffs),
    .pipe_rx4_eqlp_lffs_gt (pipe_rx4_eq_lffs),
    .pipe_rx5_eqlp_lffs_gt (pipe_rx5_eq_lffs),
    .pipe_rx6_eqlp_lffs_gt (pipe_rx6_eq_lffs),
    .pipe_rx7_eqlp_lffs_gt (pipe_rx7_eq_lffs),
    .pipe_tx0_eqdeemph_gt (pipe_tx0_eqdeemph),
    .pipe_tx1_eqdeemph_gt (pipe_tx1_eqdeemph),
    .pipe_tx2_eqdeemph_gt (pipe_tx2_eqdeemph),
    .pipe_tx3_eqdeemph_gt (pipe_tx3_eqdeemph),
    .pipe_tx4_eqdeemph_gt (pipe_tx4_eqdeemph),
    .pipe_tx5_eqdeemph_gt (pipe_tx5_eqdeemph),
    .pipe_tx6_eqdeemph_gt (pipe_tx6_eqdeemph),
    .pipe_tx7_eqdeemph_gt (pipe_tx7_eqdeemph),
    .pipe_rx0_data_valid_gt (pipe_rx0_data_valid),
    .pipe_rx1_data_valid_gt (pipe_rx1_data_valid),
    .pipe_rx2_data_valid_gt (pipe_rx2_data_valid),
    .pipe_rx3_data_valid_gt (pipe_rx3_data_valid),
    .pipe_rx4_data_valid_gt (pipe_rx4_data_valid),
    .pipe_rx5_data_valid_gt (pipe_rx5_data_valid),
    .pipe_rx6_data_valid_gt (pipe_rx6_data_valid),
    .pipe_rx7_data_valid_gt (pipe_rx7_data_valid),
    .pipe_rx0_elec_idle_gt (pipe_rx0_elec_idle),
    .pipe_rx1_elec_idle_gt (pipe_rx1_elec_idle),
    .pipe_rx2_elec_idle_gt (pipe_rx2_elec_idle),
    .pipe_rx3_elec_idle_gt (pipe_rx3_elec_idle),
    .pipe_rx4_elec_idle_gt (pipe_rx4_elec_idle),
    .pipe_rx5_elec_idle_gt (pipe_rx5_elec_idle),
    .pipe_rx6_elec_idle_gt (pipe_rx6_elec_idle),
    .pipe_rx7_elec_idle_gt (pipe_rx7_elec_idle),
    .pipe_rx0_eqdone_gt (pipe_rx0_eqdone),
    .pipe_rx1_eqdone_gt (pipe_rx1_eqdone),
    .pipe_rx2_eqdone_gt (pipe_rx2_eqdone),
    .pipe_rx3_eqdone_gt (pipe_rx3_eqdone),
    .pipe_rx4_eqdone_gt (pipe_rx4_eqdone),
    .pipe_rx5_eqdone_gt (pipe_rx5_eqdone),
    .pipe_rx6_eqdone_gt (pipe_rx6_eqdone),
    .pipe_rx7_eqdone_gt (pipe_rx7_eqdone),
    .pipe_rx0_eqlp_adaptdone_gt (pipe_rx0_eq_adapt_done),
    .pipe_rx1_eqlp_adaptdone_gt (pipe_rx1_eq_adapt_done),
    .pipe_rx2_eqlp_adaptdone_gt (pipe_rx2_eq_adapt_done),
    .pipe_rx3_eqlp_adaptdone_gt (pipe_rx3_eq_adapt_done),
    .pipe_rx4_eqlp_adaptdone_gt (pipe_rx4_eq_adapt_done),
    .pipe_rx5_eqlp_adaptdone_gt (pipe_rx5_eq_adapt_done),
    .pipe_rx6_eqlp_adaptdone_gt (pipe_rx6_eq_adapt_done),
    .pipe_rx7_eqlp_adaptdone_gt (pipe_rx7_eq_adapt_done),
    .pipe_rx0_eqlp_lffs_sel_gt (pipe_rx0_eq_lffs_sel),
    .pipe_rx1_eqlp_lffs_sel_gt (pipe_rx1_eq_lffs_sel),
    .pipe_rx2_eqlp_lffs_sel_gt (pipe_rx2_eq_lffs_sel),
    .pipe_rx3_eqlp_lffs_sel_gt (pipe_rx3_eq_lffs_sel),
    .pipe_rx4_eqlp_lffs_sel_gt (pipe_rx4_eq_lffs_sel),
    .pipe_rx5_eqlp_lffs_sel_gt (pipe_rx5_eq_lffs_sel),
    .pipe_rx6_eqlp_lffs_sel_gt (pipe_rx6_eq_lffs_sel),
    .pipe_rx7_eqlp_lffs_sel_gt (pipe_rx7_eq_lffs_sel),
    .pipe_rx0_phy_status_gt (pipe_rx0_phy_status),
    .pipe_rx1_phy_status_gt (pipe_rx1_phy_status),
    .pipe_rx2_phy_status_gt (pipe_rx2_phy_status),
    .pipe_rx3_phy_status_gt (pipe_rx3_phy_status),
    .pipe_rx4_phy_status_gt (pipe_rx4_phy_status),
    .pipe_rx5_phy_status_gt (pipe_rx5_phy_status),
    .pipe_rx6_phy_status_gt (pipe_rx6_phy_status),
    .pipe_rx7_phy_status_gt (pipe_rx7_phy_status),
    .pipe_rx0_start_block_gt (pipe_rx0_start_block),
    .pipe_rx1_start_block_gt (pipe_rx1_start_block),
    .pipe_rx2_start_block_gt (pipe_rx2_start_block),
    .pipe_rx3_start_block_gt (pipe_rx3_start_block),
    .pipe_rx4_start_block_gt (pipe_rx4_start_block),
    .pipe_rx5_start_block_gt (pipe_rx5_start_block),
    .pipe_rx6_start_block_gt (pipe_rx6_start_block),
    .pipe_rx7_start_block_gt (pipe_rx7_start_block),
    .pipe_rx0_valid_gt (pipe_rx0_valid),
    .pipe_rx1_valid_gt (pipe_rx1_valid),
    .pipe_rx2_valid_gt (pipe_rx2_valid),
    .pipe_rx3_valid_gt (pipe_rx3_valid),
    .pipe_rx4_valid_gt (pipe_rx4_valid),
    .pipe_rx5_valid_gt (pipe_rx5_valid),
    .pipe_rx6_valid_gt (pipe_rx6_valid),
    .pipe_rx7_valid_gt (pipe_rx7_valid),
    .pipe_tx0_eqdone_gt (pipe_tx0_eqdone),
    .pipe_tx1_eqdone_gt (pipe_tx1_eqdone),
    .pipe_tx2_eqdone_gt (pipe_tx2_eqdone),
    .pipe_tx3_eqdone_gt (pipe_tx3_eqdone),
    .pipe_tx4_eqdone_gt (pipe_tx4_eqdone),
    .pipe_tx5_eqdone_gt (pipe_tx5_eqdone),
    .pipe_tx6_eqdone_gt (pipe_tx6_eqdone),
    .pipe_tx7_eqdone_gt (pipe_tx7_eqdone),
    .pipe_rx0_eqlp_new_txcoef_forpreset_gt (pipe_rx0_eq_new_txcoeff),
    .pipe_rx1_eqlp_new_txcoef_forpreset_gt (pipe_rx1_eq_new_txcoeff),
    .pipe_rx2_eqlp_new_txcoef_forpreset_gt (pipe_rx2_eq_new_txcoeff),
    .pipe_rx3_eqlp_new_txcoef_forpreset_gt (pipe_rx3_eq_new_txcoeff),
    .pipe_rx4_eqlp_new_txcoef_forpreset_gt (pipe_rx4_eq_new_txcoeff),
    .pipe_rx5_eqlp_new_txcoef_forpreset_gt (pipe_rx5_eq_new_txcoeff),
    .pipe_rx6_eqlp_new_txcoef_forpreset_gt (pipe_rx6_eq_new_txcoeff),
    .pipe_rx7_eqlp_new_txcoef_forpreset_gt (pipe_rx7_eq_new_txcoeff),
    .pipe_tx0_eqcoeff_gt (pipe_tx0_eqcoeff),
    .pipe_tx1_eqcoeff_gt (pipe_tx1_eqcoeff),
    .pipe_tx2_eqcoeff_gt (pipe_tx2_eqcoeff),
    .pipe_tx3_eqcoeff_gt (pipe_tx3_eqcoeff),
    .pipe_tx4_eqcoeff_gt (pipe_tx4_eqcoeff),
    .pipe_tx5_eqcoeff_gt (pipe_tx5_eqcoeff),
    .pipe_tx6_eqcoeff_gt (pipe_tx6_eqcoeff),
    .pipe_tx7_eqcoeff_gt (pipe_tx7_eqcoeff),
    .pipe_rx0_char_is_k_gt (pipe_rx0_char_is_k),
    .pipe_rx1_char_is_k_gt (pipe_rx1_char_is_k),
    .pipe_rx2_char_is_k_gt (pipe_rx2_char_is_k),
    .pipe_rx3_char_is_k_gt (pipe_rx3_char_is_k),
    .pipe_rx4_char_is_k_gt (pipe_rx4_char_is_k),
    .pipe_rx5_char_is_k_gt (pipe_rx5_char_is_k),
    .pipe_rx6_char_is_k_gt (pipe_rx6_char_is_k),
    .pipe_rx7_char_is_k_gt (pipe_rx7_char_is_k),
    .pipe_rx0_syncheader_gt (pipe_rx0_syncheader),
    .pipe_rx1_syncheader_gt (pipe_rx1_syncheader),
    .pipe_rx2_syncheader_gt (pipe_rx2_syncheader),
    .pipe_rx3_syncheader_gt (pipe_rx3_syncheader),
    .pipe_rx4_syncheader_gt (pipe_rx4_syncheader),
    .pipe_rx5_syncheader_gt (pipe_rx5_syncheader),
    .pipe_rx6_syncheader_gt (pipe_rx6_syncheader),
    .pipe_rx7_syncheader_gt (pipe_rx7_syncheader),
    .pipe_rx0_status_gt (pipe_rx0_status),
    .pipe_rx1_status_gt (pipe_rx1_status),
    .pipe_rx2_status_gt (pipe_rx2_status),
    .pipe_rx3_status_gt (pipe_rx3_status),
    .pipe_rx4_status_gt (pipe_rx4_status),
    .pipe_rx5_status_gt (pipe_rx5_status),
    .pipe_rx6_status_gt (pipe_rx6_status),
    .pipe_rx7_status_gt (pipe_rx7_status),
    .pipe_rx0_data_gt (pipe_rx0_data),
    .pipe_rx1_data_gt (pipe_rx1_data),
    .pipe_rx2_data_gt (pipe_rx2_data),
    .pipe_rx3_data_gt (pipe_rx3_data),
    .pipe_rx4_data_gt (pipe_rx4_data),
    .pipe_rx5_data_gt (pipe_rx5_data),
    .pipe_rx6_data_gt (pipe_rx6_data),
    .pipe_rx7_data_gt (pipe_rx7_data)
  );

 assign  common_commands_out = 25'd0;
 assign  pipe_tx_0_sigs      = 84'd0; 
 assign  pipe_tx_1_sigs      = 84'd0;
 assign  pipe_tx_2_sigs      = 84'd0;
 assign  pipe_tx_3_sigs      = 84'd0;
 assign  pipe_tx_4_sigs      = 84'd0;
 assign  pipe_tx_5_sigs      = 84'd0;
 assign  pipe_tx_6_sigs      = 84'd0;
 assign  pipe_tx_7_sigs      = 84'd0;
 assign  phy_rdy = ~phy_rdy_phystatus;
end
endgenerate


generate if (EXT_PIPE_SIM == "FALSE" && PL_LINK_CAP_MAX_LINK_WIDTH == 8) 
begin
 assign pipe_txdata = {pipe_tx7_data, pipe_tx6_data, pipe_tx5_data, pipe_tx4_data, pipe_tx3_data, pipe_tx2_data, pipe_tx1_data, pipe_tx0_data};
 assign pipe_tx_char_is_k = {pipe_tx7_char_is_k, pipe_tx6_char_is_k, pipe_tx5_char_is_k, pipe_tx4_char_is_k, pipe_tx3_char_is_k, pipe_tx2_char_is_k, pipe_tx1_char_is_k, pipe_tx0_char_is_k};
 assign pipe_tx_data_valid = {pipe_tx7_data_valid, pipe_tx6_data_valid, pipe_tx5_data_valid, pipe_tx4_data_valid, pipe_tx3_data_valid, pipe_tx2_data_valid, pipe_tx1_data_valid, pipe_tx0_data_valid};
 assign pipe_tx_start_block = {pipe_tx7_start_block, pipe_tx6_start_block, pipe_tx5_start_block, pipe_tx4_start_block, pipe_tx3_start_block, pipe_tx2_start_block, pipe_tx1_start_block, pipe_tx0_start_block};
 assign pipe_tx_syncheader = {pipe_tx7_syncheader, pipe_tx6_syncheader, pipe_tx5_syncheader, pipe_tx4_syncheader, pipe_tx3_syncheader, pipe_tx2_syncheader, pipe_tx1_syncheader, pipe_tx0_syncheader};
 
 assign pipe_rx7_data = {pipe_rx_data[255:224]};
 assign pipe_rx6_data = {pipe_rx_data[223:192]};
 assign pipe_rx5_data = {pipe_rx_data[191:160]};
 assign pipe_rx4_data = {pipe_rx_data[159:128]};
 assign pipe_rx3_data = {pipe_rx_data[127:96]};
 assign pipe_rx2_data = {pipe_rx_data[95:64]};
 assign pipe_rx1_data = {pipe_rx_data[63:32]};
 assign pipe_rx0_data = {pipe_rx_data[31:0]};
 
 assign pipe_rx7_char_is_k = {pipe_rx_char_is_k[15:14]};
 assign pipe_rx6_char_is_k = {pipe_rx_char_is_k[13:12]};
 assign pipe_rx5_char_is_k = {pipe_rx_char_is_k[11:10]};
 assign pipe_rx4_char_is_k = {pipe_rx_char_is_k[9:8]};
 assign pipe_rx3_char_is_k = {pipe_rx_char_is_k[7:6]};
 assign pipe_rx2_char_is_k = {pipe_rx_char_is_k[5:4]};
 assign pipe_rx1_char_is_k = {pipe_rx_char_is_k[3:2]};
 assign pipe_rx0_char_is_k = {pipe_rx_char_is_k[1:0]};

 assign pipe_rx7_eq_new_txcoeff = {pipe_rx_eq_new_txcoeff[143:126]};
 assign pipe_rx6_eq_new_txcoeff = {pipe_rx_eq_new_txcoeff[125:108]};
 assign pipe_rx5_eq_new_txcoeff = {pipe_rx_eq_new_txcoeff[107:90]};
 assign pipe_rx4_eq_new_txcoeff = {pipe_rx_eq_new_txcoeff[89:72]};
 assign pipe_rx3_eq_new_txcoeff = {pipe_rx_eq_new_txcoeff[71:54]};
 assign pipe_rx2_eq_new_txcoeff = {pipe_rx_eq_new_txcoeff[53:36]};
 assign pipe_rx1_eq_new_txcoeff = {pipe_rx_eq_new_txcoeff[35:18]};
 assign pipe_rx0_eq_new_txcoeff = {pipe_rx_eq_new_txcoeff[17:0]}; 

 assign pipe_tx7_eqcoeff = {pipe_tx_eqcoeff[143:126]};
 assign pipe_tx6_eqcoeff = {pipe_tx_eqcoeff[125:108]};
 assign pipe_tx5_eqcoeff = {pipe_tx_eqcoeff[107:90]};
 assign pipe_tx4_eqcoeff = {pipe_tx_eqcoeff[89:72]};
 assign pipe_tx3_eqcoeff = {pipe_tx_eqcoeff[71:54]};
 assign pipe_tx2_eqcoeff = {pipe_tx_eqcoeff[53:36]};
 assign pipe_tx1_eqcoeff = {pipe_tx_eqcoeff[35:18]};
 assign pipe_tx0_eqcoeff = {pipe_tx_eqcoeff[17:0]}; 
 
 assign pipe_rx7_status = {pipe_rx_status[23:21]};
 assign pipe_rx6_status = {pipe_rx_status[20:18]};
 assign pipe_rx5_status = {pipe_rx_status[17:15]};
 assign pipe_rx4_status = {pipe_rx_status[14:12]};
 assign pipe_rx3_status = {pipe_rx_status[11:9]};
 assign pipe_rx2_status = {pipe_rx_status[8:6]};
 assign pipe_rx1_status = {pipe_rx_status[5:3]};
 assign pipe_rx0_status = {pipe_rx_status[2:0]};
 
 assign pipe_rx7_syncheader = {pipe_rx_syncheader[15:14]};
 assign pipe_rx6_syncheader = {pipe_rx_syncheader[13:12]};
 assign pipe_rx5_syncheader = {pipe_rx_syncheader[11:10]};
 assign pipe_rx4_syncheader = {pipe_rx_syncheader[9:8]};
 assign pipe_rx3_syncheader = {pipe_rx_syncheader[7:6]};
 assign pipe_rx2_syncheader = {pipe_rx_syncheader[5:4]};
 assign pipe_rx1_syncheader = {pipe_rx_syncheader[3:2]};
 assign pipe_rx0_syncheader = {pipe_rx_syncheader[1:0]};
 
 assign pipe_rx7_data_valid = {pipe_rx_data_valid[7]};
 assign pipe_rx6_data_valid = {pipe_rx_data_valid[6]};
 assign pipe_rx5_data_valid = {pipe_rx_data_valid[5]};
 assign pipe_rx4_data_valid = {pipe_rx_data_valid[4]};
 assign pipe_rx3_data_valid = {pipe_rx_data_valid[3]};
 assign pipe_rx2_data_valid = {pipe_rx_data_valid[2]};
 assign pipe_rx1_data_valid = {pipe_rx_data_valid[1]};
 assign pipe_rx0_data_valid = {pipe_rx_data_valid[0]};
 
 assign pipe_rx7_elec_idle = {pipe_rx_elec_idle[7]};
 assign pipe_rx6_elec_idle = {pipe_rx_elec_idle[6]};
 assign pipe_rx5_elec_idle = {pipe_rx_elec_idle[5]};
 assign pipe_rx4_elec_idle = {pipe_rx_elec_idle[4]};
 assign pipe_rx3_elec_idle = {pipe_rx_elec_idle[3]};
 assign pipe_rx2_elec_idle = {pipe_rx_elec_idle[2]};
 assign pipe_rx1_elec_idle = {pipe_rx_elec_idle[1]};
 assign pipe_rx0_elec_idle = {pipe_rx_elec_idle[0]};
 
 assign pipe_rx7_start_block = {pipe_rx_start_block[7]};
 assign pipe_rx6_start_block = {pipe_rx_start_block[6]};
 assign pipe_rx5_start_block = {pipe_rx_start_block[5]};
 assign pipe_rx4_start_block = {pipe_rx_start_block[4]};
 assign pipe_rx3_start_block = {pipe_rx_start_block[3]};
 assign pipe_rx2_start_block = {pipe_rx_start_block[2]};
 assign pipe_rx1_start_block = {pipe_rx_start_block[1]}; 
 assign pipe_rx0_start_block = {pipe_rx_start_block[0]};

 assign pipe_tx7_eqdone = {pipe_tx_eqdone[7]};
 assign pipe_tx6_eqdone = {pipe_tx_eqdone[6]};
 assign pipe_tx5_eqdone = {pipe_tx_eqdone[5]};
 assign pipe_tx4_eqdone = {pipe_tx_eqdone[4]};
 assign pipe_tx3_eqdone = {pipe_tx_eqdone[3]};
 assign pipe_tx2_eqdone = {pipe_tx_eqdone[2]};
 assign pipe_tx1_eqdone = {pipe_tx_eqdone[1]};
 assign pipe_tx0_eqdone = {pipe_tx_eqdone[0]};
 
 assign pipe_rx7_valid = {pipe_rx_valid[7]};
 assign pipe_rx6_valid = {pipe_rx_valid[6]};
 assign pipe_rx5_valid = {pipe_rx_valid[5]};
 assign pipe_rx4_valid = {pipe_rx_valid[4]};
 assign pipe_rx3_valid = {pipe_rx_valid[3]};
 assign pipe_rx2_valid = {pipe_rx_valid[2]};
 assign pipe_rx1_valid = {pipe_rx_valid[1]};
 assign pipe_rx0_valid = {pipe_rx_valid[0]};
 
 assign pipe_tx_elec_idle = {pipe_tx7_elec_idle, pipe_tx6_elec_idle, pipe_tx5_elec_idle, pipe_tx4_elec_idle, pipe_tx3_elec_idle, pipe_tx2_elec_idle, pipe_tx1_elec_idle, pipe_tx0_elec_idle};
 assign pipe_tx_compliance = {pipe_tx7_compliance, pipe_tx6_compliance, pipe_tx5_compliance, pipe_tx4_compliance, pipe_tx3_compliance, pipe_tx2_compliance, pipe_tx1_compliance, pipe_tx0_compliance};
 assign pipe_rx_polarity = {pipe_rx7_polarity, pipe_rx6_polarity, pipe_rx5_polarity, pipe_rx4_polarity, pipe_rx3_polarity, pipe_rx2_polarity, pipe_rx1_polarity, pipe_rx0_polarity};
 
 assign pipe_tx_eqcontrol = {pipe_tx7_eqcontrol, pipe_tx6_eqcontrol, pipe_tx5_eqcontrol, pipe_tx4_eqcontrol, pipe_tx3_eqcontrol, pipe_tx2_eqcontrol, pipe_tx1_eqcontrol, pipe_tx0_eqcontrol};
 assign pipe_tx_eqpreset = {pipe_tx7_eqpreset, pipe_tx6_eqpreset, pipe_tx5_eqpreset, pipe_tx4_eqpreset, pipe_tx3_eqpreset, pipe_tx2_eqpreset, pipe_tx1_eqpreset, pipe_tx0_eqpreset};
 assign pipe_tx_eqdeemph = {pipe_tx7_eqdeemph, pipe_tx6_eqdeemph, pipe_tx5_eqdeemph, pipe_tx4_eqdeemph, pipe_tx3_eqdeemph, pipe_tx2_eqdeemph, pipe_tx1_eqdeemph, pipe_tx0_eqdeemph};
 
 assign pipe_rx7_eqdone = {pipe_rx_eqdone[7]};
 assign pipe_rx6_eqdone = {pipe_rx_eqdone[6]};
 assign pipe_rx5_eqdone = {pipe_rx_eqdone[5]};
 assign pipe_rx4_eqdone = {pipe_rx_eqdone[4]};
 assign pipe_rx3_eqdone = {pipe_rx_eqdone[3]};
 assign pipe_rx2_eqdone = {pipe_rx_eqdone[2]};
 assign pipe_rx1_eqdone = {pipe_rx_eqdone[1]};
 assign pipe_rx0_eqdone = {pipe_rx_eqdone[0]};
 
 assign pipe_rx7_eq_adapt_done = {pipe_rx_eq_adapt_done[7]};
 assign pipe_rx6_eq_adapt_done = {pipe_rx_eq_adapt_done[6]};
 assign pipe_rx5_eq_adapt_done = {pipe_rx_eq_adapt_done[5]};
 assign pipe_rx4_eq_adapt_done = {pipe_rx_eq_adapt_done[4]};
 assign pipe_rx3_eq_adapt_done = {pipe_rx_eq_adapt_done[3]};
 assign pipe_rx2_eq_adapt_done = {pipe_rx_eq_adapt_done[2]};
 assign pipe_rx1_eq_adapt_done = {pipe_rx_eq_adapt_done[1]};
 assign pipe_rx0_eq_adapt_done = {pipe_rx_eq_adapt_done[0]};
 
 assign pipe_rx7_phy_status = {pipe_rx_phy_status[7]};
 assign pipe_rx6_phy_status = {pipe_rx_phy_status[6]};
 assign pipe_rx5_phy_status = {pipe_rx_phy_status[5]};
 assign pipe_rx4_phy_status = {pipe_rx_phy_status[4]};
 assign pipe_rx3_phy_status = {pipe_rx_phy_status[3]};
 assign pipe_rx2_phy_status = {pipe_rx_phy_status[2]};
 assign pipe_rx1_phy_status = {pipe_rx_phy_status[1]};
 assign pipe_rx0_phy_status = {pipe_rx_phy_status[0]};
 
 assign pipe_rx7_eq_lffs_sel = {pipe_rx_eq_lffs_sel[7]};
 assign pipe_rx6_eq_lffs_sel = {pipe_rx_eq_lffs_sel[6]};
 assign pipe_rx5_eq_lffs_sel = {pipe_rx_eq_lffs_sel[5]};
 assign pipe_rx4_eq_lffs_sel = {pipe_rx_eq_lffs_sel[4]};
 assign pipe_rx3_eq_lffs_sel = {pipe_rx_eq_lffs_sel[3]};
 assign pipe_rx2_eq_lffs_sel = {pipe_rx_eq_lffs_sel[2]};
 assign pipe_rx1_eq_lffs_sel = {pipe_rx_eq_lffs_sel[1]};
 assign pipe_rx0_eq_lffs_sel = {pipe_rx_eq_lffs_sel[0]};
 
 assign pipe_rx_eqcontrol = {pipe_rx7_eqcontrol, pipe_rx6_eqcontrol, pipe_rx5_eqcontrol, pipe_rx4_eqcontrol, pipe_rx3_eqcontrol, pipe_rx2_eqcontrol, pipe_rx1_eqcontrol, pipe_rx0_eqcontrol};
 assign pipe_rx_eqpreset = {pipe_rx7_eqpreset, pipe_rx6_eqpreset, pipe_rx5_eqpreset, pipe_rx4_eqpreset, pipe_rx3_eqpreset, pipe_rx2_eqpreset, pipe_rx1_eqpreset, pipe_rx0_eqpreset};
 assign pipe_rx_eq_lffs = {pipe_rx7_eq_lffs, pipe_rx6_eq_lffs, pipe_rx5_eq_lffs, pipe_rx4_eq_lffs, pipe_rx3_eq_lffs, pipe_rx2_eq_lffs, pipe_rx1_eq_lffs, pipe_rx0_eq_lffs};
 assign pipe_rx_eq_txpreset = {pipe_rx7_eq_txpreset, pipe_rx6_eq_txpreset, pipe_rx5_eq_txpreset, pipe_rx4_eq_txpreset, pipe_rx3_eq_txpreset, pipe_rx2_eq_txpreset, pipe_rx1_eq_txpreset, pipe_rx0_eq_txpreset};

end
else if (EXT_PIPE_SIM == "FALSE" && PL_LINK_CAP_MAX_LINK_WIDTH == 4)
begin
 assign pipe_txdata = { pipe_tx3_data, pipe_tx2_data, pipe_tx1_data, pipe_tx0_data};
 assign pipe_tx_char_is_k = {pipe_tx3_char_is_k, pipe_tx2_char_is_k, pipe_tx1_char_is_k, pipe_tx0_char_is_k};
 assign pipe_tx_data_valid = {pipe_tx3_data_valid, pipe_tx2_data_valid, pipe_tx1_data_valid, pipe_tx0_data_valid};
 assign pipe_tx_start_block = {pipe_tx3_start_block, pipe_tx2_start_block, pipe_tx1_start_block, pipe_tx0_start_block};
 assign pipe_tx_syncheader = {pipe_tx3_syncheader, pipe_tx2_syncheader, pipe_tx1_syncheader, pipe_tx0_syncheader};
 
 assign pipe_rx7_data = 32'b0;
 assign pipe_rx6_data = 32'b0;
 assign pipe_rx5_data = 32'b0;
 assign pipe_rx4_data = 32'b0;
 assign pipe_rx3_data = {pipe_rx_data[127:96]};
 assign pipe_rx2_data = {pipe_rx_data[95:64]};
 assign pipe_rx1_data = {pipe_rx_data[63:32]};
 assign pipe_rx0_data = {pipe_rx_data[31:0]};

 assign pipe_rx7_char_is_k = 2'b0;
 assign pipe_rx6_char_is_k = 2'b0;
 assign pipe_rx5_char_is_k = 2'b0;
 assign pipe_rx4_char_is_k = 2'b0;
 assign pipe_rx3_char_is_k = {pipe_rx_char_is_k[7:6]};
 assign pipe_rx2_char_is_k = {pipe_rx_char_is_k[5:4]};
 assign pipe_rx1_char_is_k = {pipe_rx_char_is_k[3:2]};
 assign pipe_rx0_char_is_k = {pipe_rx_char_is_k[1:0]};
 
 assign pipe_rx7_eq_new_txcoeff = 18'b0;
 assign pipe_rx6_eq_new_txcoeff = 18'b0;
 assign pipe_rx5_eq_new_txcoeff = 18'b0;
 assign pipe_rx4_eq_new_txcoeff = 18'b0;  
 assign pipe_rx3_eq_new_txcoeff = {pipe_rx_eq_new_txcoeff[71:54]};
 assign pipe_rx2_eq_new_txcoeff = {pipe_rx_eq_new_txcoeff[53:36]};
 assign pipe_rx1_eq_new_txcoeff = {pipe_rx_eq_new_txcoeff[35:18]};
 assign pipe_rx0_eq_new_txcoeff = {pipe_rx_eq_new_txcoeff[17:0]};

 assign pipe_tx7_eqcoeff = 18'b0;
 assign pipe_tx6_eqcoeff = 18'b0;
 assign pipe_tx5_eqcoeff = 18'b0;
 assign pipe_tx4_eqcoeff = 18'b0;
 assign pipe_tx3_eqcoeff = {pipe_tx_eqcoeff[71:54]};
 assign pipe_tx2_eqcoeff = {pipe_tx_eqcoeff[53:36]};
 assign pipe_tx1_eqcoeff = {pipe_tx_eqcoeff[35:18]};
 assign pipe_tx0_eqcoeff = {pipe_tx_eqcoeff[17:0]}; 

 assign pipe_rx7_status = 3'b0;
 assign pipe_rx6_status = 3'b0;
 assign pipe_rx5_status = 3'b0;
 assign pipe_rx4_status = 3'b0; 
 assign pipe_rx3_status = {pipe_rx_status[11:9]};
 assign pipe_rx2_status = {pipe_rx_status[8:6]};
 assign pipe_rx1_status = {pipe_rx_status[5:3]};
 assign pipe_rx0_status = {pipe_rx_status[2:0]};

 assign pipe_rx7_data_valid = 1'b0;  
 assign pipe_rx6_data_valid = 1'b0;  
 assign pipe_rx5_data_valid = 1'b0;  
 assign pipe_rx4_data_valid = 1'b0;
 assign pipe_rx3_data_valid = {pipe_rx_data_valid[3]};
 assign pipe_rx2_data_valid = {pipe_rx_data_valid[2]};
 assign pipe_rx1_data_valid = {pipe_rx_data_valid[1]};
 assign pipe_rx0_data_valid = {pipe_rx_data_valid[0]}; 

 assign pipe_rx7_elec_idle = 1'b0; 
 assign pipe_rx6_elec_idle = 1'b0; 
 assign pipe_rx5_elec_idle = 1'b0; 
 assign pipe_rx4_elec_idle = 1'b0; 
 assign pipe_rx3_elec_idle = {pipe_rx_elec_idle[3]};
 assign pipe_rx2_elec_idle = {pipe_rx_elec_idle[2]};
 assign pipe_rx1_elec_idle = {pipe_rx_elec_idle[1]};
 assign pipe_rx0_elec_idle = {pipe_rx_elec_idle[0]}; 

 assign pipe_rx7_start_block = 1'b0;  
 assign pipe_rx6_start_block = 1'b0;  
 assign pipe_rx5_start_block = 1'b0;  
 assign pipe_rx4_start_block = 1'b0;  
 assign pipe_rx3_start_block = {pipe_rx_start_block[3]};
 assign pipe_rx2_start_block = {pipe_rx_start_block[2]};
 assign pipe_rx1_start_block = {pipe_rx_start_block[1]}; 
 assign pipe_rx0_start_block = {pipe_rx_start_block[0]};  

 assign pipe_rx7_syncheader = 2'b0;
 assign pipe_rx6_syncheader = 2'b0;
 assign pipe_rx5_syncheader = 2'b0;
 assign pipe_rx4_syncheader = 2'b0;
 assign pipe_rx3_syncheader = {pipe_rx_syncheader[7:6]};
 assign pipe_rx2_syncheader = {pipe_rx_syncheader[5:4]};
 assign pipe_rx1_syncheader = {pipe_rx_syncheader[3:2]};
 assign pipe_rx0_syncheader = {pipe_rx_syncheader[1:0]};
 
 assign pipe_tx7_eqdone = 1'b0;
 assign pipe_tx6_eqdone = 1'b0;
 assign pipe_tx5_eqdone = 1'b0;
 assign pipe_tx4_eqdone = 1'b0;
 assign pipe_tx3_eqdone = {pipe_tx_eqdone[3]};
 assign pipe_tx2_eqdone = {pipe_tx_eqdone[2]};
 assign pipe_tx1_eqdone = {pipe_tx_eqdone[1]};
 assign pipe_tx0_eqdone = {pipe_tx_eqdone[0]};

 assign pipe_rx7_valid = 1'b0; 
 assign pipe_rx6_valid = 1'b0; 
 assign pipe_rx5_valid = 1'b0; 
 assign pipe_rx4_valid = 1'b0; 
 assign pipe_rx3_valid = {pipe_rx_valid[3]};
 assign pipe_rx2_valid = {pipe_rx_valid[2]};
 assign pipe_rx1_valid = {pipe_rx_valid[1]};
 assign pipe_rx0_valid = {pipe_rx_valid[0]};
 
 assign pipe_tx_elec_idle = {pipe_tx3_elec_idle, pipe_tx2_elec_idle, pipe_tx1_elec_idle, pipe_tx0_elec_idle};
 assign pipe_tx_compliance = {pipe_tx3_compliance, pipe_tx2_compliance, pipe_tx1_compliance, pipe_tx0_compliance};
 assign pipe_rx_polarity = {pipe_rx3_polarity, pipe_rx2_polarity, pipe_rx1_polarity, pipe_rx0_polarity};
 
 assign pipe_tx_eqcontrol = {pipe_tx3_eqcontrol, pipe_tx2_eqcontrol, pipe_tx1_eqcontrol, pipe_tx0_eqcontrol};
 assign pipe_tx_eqpreset = {pipe_tx3_eqpreset, pipe_tx2_eqpreset, pipe_tx1_eqpreset, pipe_tx0_eqpreset};
 assign pipe_tx_eqdeemph = {pipe_tx3_eqdeemph, pipe_tx2_eqdeemph, pipe_tx1_eqdeemph, pipe_tx0_eqdeemph};

 assign pipe_rx7_eqdone = 1'b0;
 assign pipe_rx6_eqdone = 1'b0;
 assign pipe_rx5_eqdone = 1'b0;
 assign pipe_rx4_eqdone = 1'b0;
 assign pipe_rx3_eqdone = {pipe_rx_eqdone[3]};
 assign pipe_rx2_eqdone = {pipe_rx_eqdone[2]};
 assign pipe_rx1_eqdone = {pipe_rx_eqdone[1]};
 assign pipe_rx0_eqdone = {pipe_rx_eqdone[0]};

 assign pipe_rx7_eq_adapt_done = 1'b0; 
 assign pipe_rx6_eq_adapt_done = 1'b0; 
 assign pipe_rx5_eq_adapt_done = 1'b0; 
 assign pipe_rx4_eq_adapt_done = 1'b0;  
 assign pipe_rx3_eq_adapt_done = {pipe_rx_eq_adapt_done[3]};
 assign pipe_rx2_eq_adapt_done = {pipe_rx_eq_adapt_done[2]};
 assign pipe_rx1_eq_adapt_done = {pipe_rx_eq_adapt_done[1]};
 assign pipe_rx0_eq_adapt_done = {pipe_rx_eq_adapt_done[0]}; 

 assign pipe_rx7_phy_status = 1'b0;
 assign pipe_rx6_phy_status = 1'b0;
 assign pipe_rx5_phy_status = 1'b0;
 assign pipe_rx4_phy_status = 1'b0; 
 assign pipe_rx3_phy_status = {pipe_rx_phy_status[3]};
 assign pipe_rx2_phy_status = {pipe_rx_phy_status[2]};
 assign pipe_rx1_phy_status = {pipe_rx_phy_status[1]};
 assign pipe_rx0_phy_status = {pipe_rx_phy_status[0]};

 assign pipe_rx7_eq_lffs_sel = 1'b0;
 assign pipe_rx6_eq_lffs_sel = 1'b0;
 assign pipe_rx5_eq_lffs_sel = 1'b0;
 assign pipe_rx4_eq_lffs_sel = 1'b0; 
 assign pipe_rx3_eq_lffs_sel = {pipe_rx_eq_lffs_sel[3]};
 assign pipe_rx2_eq_lffs_sel = {pipe_rx_eq_lffs_sel[2]};
 assign pipe_rx1_eq_lffs_sel = {pipe_rx_eq_lffs_sel[1]};
 assign pipe_rx0_eq_lffs_sel = {pipe_rx_eq_lffs_sel[0]};
 
 assign pipe_rx_eqcontrol = {pipe_rx3_eqcontrol, pipe_rx2_eqcontrol, pipe_rx1_eqcontrol, pipe_rx0_eqcontrol};
 assign pipe_rx_eqpreset = {pipe_rx3_eqpreset, pipe_rx2_eqpreset, pipe_rx1_eqpreset, pipe_rx0_eqpreset};
 assign pipe_rx_eq_lffs = {pipe_rx3_eq_lffs, pipe_rx2_eq_lffs, pipe_rx1_eq_lffs, pipe_rx0_eq_lffs};
 assign pipe_rx_eq_txpreset = {pipe_rx3_eq_txpreset, pipe_rx2_eq_txpreset, pipe_rx1_eq_txpreset, pipe_rx0_eq_txpreset};

end
else if (EXT_PIPE_SIM == "FALSE" && PL_LINK_CAP_MAX_LINK_WIDTH == 2)
begin
 assign pipe_txdata = {pipe_tx1_data, pipe_tx0_data};
 assign pipe_tx_char_is_k = {pipe_tx1_char_is_k, pipe_tx0_char_is_k};
 assign pipe_tx_data_valid = {pipe_tx1_data_valid, pipe_tx0_data_valid};
 assign pipe_tx_start_block = {pipe_tx1_start_block, pipe_tx0_start_block};
 assign pipe_tx_syncheader = {pipe_tx1_syncheader, pipe_tx0_syncheader};
 
 assign pipe_rx7_data = 32'b0;
 assign pipe_rx6_data = 32'b0;
 assign pipe_rx5_data = 32'b0;
 assign pipe_rx4_data = 32'b0;
 assign pipe_rx3_data = 32'b0;
 assign pipe_rx2_data = 32'b0;
 assign pipe_rx1_data = {pipe_rx_data[63:32]};
 assign pipe_rx0_data = {pipe_rx_data[31:0]};

 assign pipe_rx7_char_is_k = 2'b0;
 assign pipe_rx6_char_is_k = 2'b0;
 assign pipe_rx5_char_is_k = 2'b0;
 assign pipe_rx4_char_is_k = 2'b0;
 assign pipe_rx3_char_is_k = 2'b0;
 assign pipe_rx2_char_is_k = 2'b0; 
 assign pipe_rx1_char_is_k = {pipe_rx_char_is_k[3:2]};
 assign pipe_rx0_char_is_k = {pipe_rx_char_is_k[1:0]};
 
 assign pipe_rx7_eq_new_txcoeff = 18'b0;
 assign pipe_rx6_eq_new_txcoeff = 18'b0;
 assign pipe_rx5_eq_new_txcoeff = 18'b0;
 assign pipe_rx4_eq_new_txcoeff = 18'b0; 
 assign pipe_rx3_eq_new_txcoeff = 18'b0;  
 assign pipe_rx2_eq_new_txcoeff = 18'b0;  
 assign pipe_rx1_eq_new_txcoeff = {pipe_rx_eq_new_txcoeff[35:18]};
 assign pipe_rx0_eq_new_txcoeff = {pipe_rx_eq_new_txcoeff[17:0]}; 

 assign pipe_tx7_eqcoeff = 18'b0;
 assign pipe_tx6_eqcoeff = 18'b0;
 assign pipe_tx5_eqcoeff = 18'b0;
 assign pipe_tx4_eqcoeff = 18'b0; 
 assign pipe_tx3_eqcoeff = 18'b0; 
 assign pipe_tx2_eqcoeff = 18'b0; 
 assign pipe_tx1_eqcoeff = {pipe_tx_eqcoeff[35:18]};
 assign pipe_tx0_eqcoeff = {pipe_tx_eqcoeff[17:0]}; 

 assign pipe_rx7_status = 3'b0;
 assign pipe_rx6_status = 3'b0;
 assign pipe_rx5_status = 3'b0;
 assign pipe_rx4_status = 3'b0;
 assign pipe_rx3_status = 3'b0;
 assign pipe_rx2_status = 3'b0; 
 assign pipe_rx1_status = {pipe_rx_status[5:3]};
 assign pipe_rx0_status = {pipe_rx_status[2:0]};
 
 assign pipe_rx7_data_valid = 1'b0;  
 assign pipe_rx6_data_valid = 1'b0;  
 assign pipe_rx5_data_valid = 1'b0;  
 assign pipe_rx4_data_valid = 1'b0;  
 assign pipe_rx3_data_valid = 1'b0;  
 assign pipe_rx2_data_valid = 1'b0; 
 assign pipe_rx1_data_valid = {pipe_rx_data_valid[1]};
 assign pipe_rx0_data_valid = {pipe_rx_data_valid[0]};  

 assign pipe_rx7_elec_idle = 1'b0; 
 assign pipe_rx6_elec_idle = 1'b0; 
 assign pipe_rx5_elec_idle = 1'b0; 
 assign pipe_rx4_elec_idle = 1'b0; 
 assign pipe_rx3_elec_idle = 1'b0; 
 assign pipe_rx2_elec_idle = 1'b0;  
 assign pipe_rx1_elec_idle = {pipe_rx_elec_idle[1]};
 assign pipe_rx0_elec_idle = {pipe_rx_elec_idle[0]};  

 assign pipe_rx7_start_block = 1'b0;  
 assign pipe_rx6_start_block = 1'b0;  
 assign pipe_rx5_start_block = 1'b0;  
 assign pipe_rx4_start_block = 1'b0;  
 assign pipe_rx3_start_block = 1'b0;  
 assign pipe_rx2_start_block = 1'b0; 
 assign pipe_rx1_start_block = {pipe_rx_start_block[1]}; 
 assign pipe_rx0_start_block = {pipe_rx_start_block[0]};  

 assign pipe_rx7_syncheader = 2'b0;
 assign pipe_rx6_syncheader = 2'b0;
 assign pipe_rx5_syncheader = 2'b0;
 assign pipe_rx4_syncheader = 2'b0;
 assign pipe_rx3_syncheader = 2'b0;
 assign pipe_rx2_syncheader = 2'b0;
 assign pipe_rx1_syncheader = {pipe_rx_syncheader[3:2]};
 assign pipe_rx0_syncheader = {pipe_rx_syncheader[1:0]};
 
 assign pipe_tx7_eqdone = 1'b0;
 assign pipe_tx6_eqdone = 1'b0;
 assign pipe_tx5_eqdone = 1'b0;
 assign pipe_tx4_eqdone = 1'b0; 
 assign pipe_tx3_eqdone = 1'b0; 
 assign pipe_tx2_eqdone = 1'b0; 
 assign pipe_tx1_eqdone = {pipe_tx_eqdone[1]};
 assign pipe_tx0_eqdone = {pipe_tx_eqdone[0]};

 assign pipe_rx7_valid = 1'b0; 
 assign pipe_rx6_valid = 1'b0; 
 assign pipe_rx5_valid = 1'b0; 
 assign pipe_rx4_valid = 1'b0; 
 assign pipe_rx3_valid = 1'b0; 
 assign pipe_rx2_valid = 1'b0; 
 assign pipe_rx1_valid = {pipe_rx_valid[1]};
 assign pipe_rx0_valid = {pipe_rx_valid[0]}; 
 
 assign pipe_tx_elec_idle = {pipe_tx1_elec_idle, pipe_tx0_elec_idle};
 assign pipe_tx_compliance = {pipe_tx1_compliance, pipe_tx0_compliance};
 assign pipe_rx_polarity = {pipe_rx1_polarity, pipe_rx0_polarity};
 
 assign pipe_tx_eqcontrol = {pipe_tx1_eqcontrol, pipe_tx0_eqcontrol};
 assign pipe_tx_eqpreset = {pipe_tx1_eqpreset, pipe_tx0_eqpreset};
 assign pipe_tx_eqdeemph = { pipe_tx1_eqdeemph, pipe_tx0_eqdeemph};

 assign pipe_rx7_eqdone = 1'b0;
 assign pipe_rx6_eqdone = 1'b0;
 assign pipe_rx5_eqdone = 1'b0;
 assign pipe_rx4_eqdone = 1'b0;
 assign pipe_rx3_eqdone = 1'b0;
 assign pipe_rx2_eqdone = 1'b0;
 assign pipe_rx1_eqdone = {pipe_rx_eqdone[1]};
 assign pipe_rx0_eqdone = {pipe_rx_eqdone[0]};

 assign pipe_rx7_eq_adapt_done = 1'b0; 
 assign pipe_rx6_eq_adapt_done = 1'b0; 
 assign pipe_rx5_eq_adapt_done = 1'b0; 
 assign pipe_rx4_eq_adapt_done = 1'b0; 
 assign pipe_rx3_eq_adapt_done = 1'b0; 
 assign pipe_rx2_eq_adapt_done = 1'b0;  
 assign pipe_rx1_eq_adapt_done = {pipe_rx_eq_adapt_done[1]};
 assign pipe_rx0_eq_adapt_done = {pipe_rx_eq_adapt_done[0]}; 

 assign pipe_rx7_phy_status = 1'b0;
 assign pipe_rx6_phy_status = 1'b0;
 assign pipe_rx5_phy_status = 1'b0;
 assign pipe_rx4_phy_status = 1'b0;
 assign pipe_rx3_phy_status = 1'b0;
 assign pipe_rx2_phy_status = 1'b0; 
 assign pipe_rx1_phy_status = {pipe_rx_phy_status[1]};
 assign pipe_rx0_phy_status = {pipe_rx_phy_status[0]};

 assign pipe_rx7_eq_lffs_sel = 1'b0;
 assign pipe_rx6_eq_lffs_sel = 1'b0;
 assign pipe_rx5_eq_lffs_sel = 1'b0;
 assign pipe_rx4_eq_lffs_sel = 1'b0;
 assign pipe_rx3_eq_lffs_sel = 1'b0;
 assign pipe_rx2_eq_lffs_sel = 1'b0; 
 assign pipe_rx1_eq_lffs_sel = {pipe_rx_eq_lffs_sel[1]};
 assign pipe_rx0_eq_lffs_sel = {pipe_rx_eq_lffs_sel[0]};
 
 assign pipe_rx_eqcontrol = {pipe_rx1_eqcontrol, pipe_rx0_eqcontrol};
 assign pipe_rx_eqpreset = {pipe_rx1_eqpreset, pipe_rx0_eqpreset};
 assign pipe_rx_eq_lffs = {pipe_rx1_eq_lffs, pipe_rx0_eq_lffs};
 assign pipe_rx_eq_txpreset = {pipe_rx1_eq_txpreset, pipe_rx0_eq_txpreset}; 

 end
 else if (EXT_PIPE_SIM == "FALSE" && PL_LINK_CAP_MAX_LINK_WIDTH == 1)
 begin
 assign pipe_txdata = {pipe_tx0_data};
 assign pipe_tx_char_is_k = {pipe_tx0_char_is_k};
 assign pipe_tx_data_valid = {pipe_tx0_data_valid};
 assign pipe_tx_start_block = {pipe_tx0_start_block};
 assign pipe_tx_syncheader = {pipe_tx0_syncheader};
 
 assign pipe_rx7_data = 32'b0;
 assign pipe_rx6_data = 32'b0;
 assign pipe_rx5_data = 32'b0;
 assign pipe_rx4_data = 32'b0;
 assign pipe_rx3_data = 32'b0;
 assign pipe_rx2_data = 32'b0;
 assign pipe_rx1_data = 32'b0;
 assign pipe_rx0_data = {pipe_rx_data[31:0]};
 
 assign pipe_rx7_char_is_k = 2'b0;
 assign pipe_rx6_char_is_k = 2'b0;
 assign pipe_rx5_char_is_k = 2'b0;
 assign pipe_rx4_char_is_k = 2'b0;
 assign pipe_rx3_char_is_k = 2'b0;
 assign pipe_rx2_char_is_k = 2'b0;
 assign pipe_rx1_char_is_k = 2'b0;
 assign pipe_rx0_char_is_k = {pipe_rx_char_is_k[1:0]};
 
 assign pipe_rx7_eq_new_txcoeff = 18'b0;
 assign pipe_rx6_eq_new_txcoeff = 18'b0;
 assign pipe_rx5_eq_new_txcoeff = 18'b0;
 assign pipe_rx4_eq_new_txcoeff = 18'b0; 
 assign pipe_rx3_eq_new_txcoeff = 18'b0; 
 assign pipe_rx2_eq_new_txcoeff = 18'b0;  
 assign pipe_rx1_eq_new_txcoeff = 18'b0;  
 assign pipe_rx0_eq_new_txcoeff = {pipe_rx_eq_new_txcoeff[17:0]};  

 assign pipe_tx7_eqcoeff = 18'b0;
 assign pipe_tx6_eqcoeff = 18'b0;
 assign pipe_tx5_eqcoeff = 18'b0;
 assign pipe_tx4_eqcoeff = 18'b0; 
 assign pipe_tx3_eqcoeff = 18'b0; 
 assign pipe_tx2_eqcoeff = 18'b0;  
 assign pipe_tx1_eqcoeff = 18'b0;  
 assign pipe_tx0_eqcoeff = {pipe_tx_eqcoeff[17:0]}; 
 
 assign pipe_rx7_status = 3'b0;
 assign pipe_rx6_status = 3'b0;
 assign pipe_rx5_status = 3'b0;
 assign pipe_rx4_status = 3'b0;
 assign pipe_rx3_status = 3'b0;
 assign pipe_rx2_status = 3'b0;
 assign pipe_rx1_status = 3'b0;
 assign pipe_rx0_status = {pipe_rx_status[2:0]};
 
 assign pipe_rx7_data_valid = 1'b0;  
 assign pipe_rx6_data_valid = 1'b0;  
 assign pipe_rx5_data_valid = 1'b0;  
 assign pipe_rx4_data_valid = 1'b0;  
 assign pipe_rx3_data_valid = 1'b0;  
 assign pipe_rx2_data_valid = 1'b0;  
 assign pipe_rx1_data_valid = 1'b0;  
 assign pipe_rx0_data_valid = {pipe_rx_data_valid[0]};  
 
 assign pipe_rx7_elec_idle = 1'b0; 
 assign pipe_rx6_elec_idle = 1'b0; 
 assign pipe_rx5_elec_idle = 1'b0; 
 assign pipe_rx4_elec_idle = 1'b0; 
 assign pipe_rx3_elec_idle = 1'b0; 
 assign pipe_rx2_elec_idle = 1'b0; 
 assign pipe_rx1_elec_idle = 1'b0; 
 assign pipe_rx0_elec_idle = {pipe_rx_elec_idle[0]}; 
 
 assign pipe_rx7_start_block = 1'b0;  
 assign pipe_rx6_start_block = 1'b0;  
 assign pipe_rx5_start_block = 1'b0;  
 assign pipe_rx4_start_block = 1'b0;  
 assign pipe_rx3_start_block = 1'b0;  
 assign pipe_rx2_start_block = 1'b0;  
 assign pipe_rx1_start_block = 1'b0;  
 assign pipe_rx0_start_block = {pipe_rx_start_block[0]};  
 
 assign pipe_rx7_syncheader = 2'b0;
 assign pipe_rx6_syncheader = 2'b0;
 assign pipe_rx5_syncheader = 2'b0;
 assign pipe_rx4_syncheader = 2'b0;
 assign pipe_rx3_syncheader = 2'b0;
 assign pipe_rx2_syncheader = 2'b0;
 assign pipe_rx1_syncheader = 2'b0;
 assign pipe_rx0_syncheader = {pipe_rx_syncheader[1:0]};
 
 assign pipe_tx7_eqdone = 1'b0;
 assign pipe_tx6_eqdone = 1'b0;
 assign pipe_tx5_eqdone = 1'b0;
 assign pipe_tx4_eqdone = 1'b0; 
 assign pipe_tx3_eqdone = 1'b0; 
 assign pipe_tx2_eqdone = 1'b0;  
 assign pipe_tx1_eqdone = 1'b0;  
 assign pipe_tx0_eqdone = {pipe_tx_eqdone[0]};
 
 assign pipe_rx7_valid = 1'b0; 
 assign pipe_rx6_valid = 1'b0; 
 assign pipe_rx5_valid = 1'b0; 
 assign pipe_rx4_valid = 1'b0; 
 assign pipe_rx3_valid = 1'b0; 
 assign pipe_rx2_valid = 1'b0; 
 assign pipe_rx1_valid = 1'b0; 
 assign pipe_rx0_valid = {pipe_rx_valid[0]}; 
 
 assign pipe_tx_elec_idle = {pipe_tx0_elec_idle};
 assign pipe_tx_compliance = {pipe_tx0_compliance};
 assign pipe_rx_polarity = {pipe_rx0_polarity};
 
 assign pipe_tx_eqcontrol = {pipe_tx0_eqcontrol};
 assign pipe_tx_eqpreset = {pipe_tx0_eqpreset};
 assign pipe_tx_eqdeemph = {pipe_tx0_eqdeemph};

 assign pipe_rx7_eqdone = 1'b0;
 assign pipe_rx6_eqdone = 1'b0;
 assign pipe_rx5_eqdone = 1'b0;
 assign pipe_rx4_eqdone = 1'b0;
 assign pipe_rx3_eqdone = 1'b0;
 assign pipe_rx2_eqdone = 1'b0;
 assign pipe_rx1_eqdone = 1'b0;
 assign pipe_rx0_eqdone = {pipe_rx_eqdone[0]};
 
 assign pipe_rx7_eq_adapt_done = 1'b0; 
 assign pipe_rx6_eq_adapt_done = 1'b0; 
 assign pipe_rx5_eq_adapt_done = 1'b0; 
 assign pipe_rx4_eq_adapt_done = 1'b0; 
 assign pipe_rx3_eq_adapt_done = 1'b0; 
 assign pipe_rx2_eq_adapt_done = 1'b0; 
 assign pipe_rx1_eq_adapt_done = 1'b0; 
 assign pipe_rx0_eq_adapt_done = {pipe_rx_eq_adapt_done[0]}; 
 
 assign pipe_rx7_phy_status = 1'b0;
 assign pipe_rx6_phy_status = 1'b0;
 assign pipe_rx5_phy_status = 1'b0;
 assign pipe_rx4_phy_status = 1'b0;
 assign pipe_rx3_phy_status = 1'b0;
 assign pipe_rx2_phy_status = 1'b0;
 assign pipe_rx1_phy_status = 1'b0;
 assign pipe_rx0_phy_status = {pipe_rx_phy_status[0]};
 
 assign pipe_rx7_eq_lffs_sel = 1'b0;
 assign pipe_rx6_eq_lffs_sel = 1'b0;
 assign pipe_rx5_eq_lffs_sel = 1'b0;
 assign pipe_rx4_eq_lffs_sel = 1'b0;
 assign pipe_rx3_eq_lffs_sel = 1'b0;
 assign pipe_rx2_eq_lffs_sel = 1'b0;
 assign pipe_rx1_eq_lffs_sel = 1'b0;
 assign pipe_rx0_eq_lffs_sel = {pipe_rx_eq_lffs_sel[0]};
 
 assign pipe_rx_eqcontrol = {pipe_rx0_eqcontrol};
 assign pipe_rx_eqpreset = {pipe_rx0_eqpreset};
 assign pipe_rx_eq_lffs = {pipe_rx0_eq_lffs};
 assign pipe_rx_eq_txpreset = {pipe_rx0_eq_txpreset};
 end
 endgenerate

  // Tie-off unused outputs
  assign mcap_design_switch = 1'b0;
  assign mcap_eos_out = 1'b0;
  assign design_switch_net = 1'b1;

  // Mux critical inputs so they remain constant during bitstream loading.
  // This is important for Tandem and PR configurations. For all other 
  // configurations the mux logic will be optimized and removed.
  assign cfg_dev_id_mux =               design_switch_net ? cfg_dev_id : PF0_DEVICE_ID;
  assign cfg_dsn_mux =                  design_switch_net ? cfg_dsn : {32'h00000001, 8'h01, 24'h000001}; // FIXME: Pass in as Parameter
  assign cfg_rev_id_mux =               design_switch_net ? cfg_rev_id : PF0_REVISION_ID;
  assign cfg_subsys_id_mux =            design_switch_net ? cfg_subsys_id : PF0_SUBSYSTEM_ID;
  assign cfg_subsys_vend_id_mux =       design_switch_net ? cfg_subsys_vend_id : PF0_SUBSYSTEM_VENDOR_ID;
  assign cfg_vend_id_mux =              design_switch_net ? cfg_vend_id : PF0_VENDOR_ID;
  assign cfg_config_space_enable_mux =  design_switch_net ? cfg_config_space_enable : 1'b1;
  assign cfg_link_training_enable_mux = design_switch_net ? cfg_link_training_enable : 1'b1;
  assign cfg_interrupt_msix_int_mux =   design_switch_net ? cfg_interrupt_msix_int : 1'b0;
  assign conf_req_valid_mux =           design_switch_net ? conf_req_valid : 1'b0;
  assign drp_en_mux =                   design_switch_net ? drp_en : 1'b0;
  assign gt_loopback_mux =              design_switch_net ? gt_loopback : {(PL_LINK_CAP_MAX_LINK_WIDTH*3){1'b0}};
  assign gt_pcieuserratedone_mux =      design_switch_net ? gt_pcieuserratedone : {(PL_LINK_CAP_MAX_LINK_WIDTH*1){1'b0}};
  assign gt_rxprbssel_mux =             design_switch_net ? gt_rxprbssel : {(PL_LINK_CAP_MAX_LINK_WIDTH*4){1'b0}};
  assign gt_txprbssel_mux =             design_switch_net ? gt_txprbssel : {(PL_LINK_CAP_MAX_LINK_WIDTH*4){1'b0}};
  assign pl_eq_reset_eieos_count_mux =  design_switch_net ? pl_eq_reset_eieos_count : 1'b0;
  assign pl_gen2_upstream_prefer_deemph_mux = design_switch_net ? pl_gen2_upstream_prefer_deemph : 1'b0;
  assign cfg_err_cor_in_mux =           design_switch_net ? cfg_err_cor_in : 1'b0;
  assign cfg_err_uncor_in_mux =         design_switch_net ? cfg_err_uncor_in : 1'b0;
  assign cfg_hot_reset_in_mux =         design_switch_net ? cfg_hot_reset_in : 1'b0;
  assign cfg_flr_done_mux =             design_switch_net ? cfg_flr_done : 4'hf;
  assign cfg_interrupt_int_mux =        design_switch_net ? cfg_interrupt_int : 4'h0;
  assign cfg_interrupt_msi_int_mux =    design_switch_net ? cfg_interrupt_msi_int : 32'h00000000;
  assign cfg_interrupt_msi_pending_status_data_enable_mux = design_switch_net ? cfg_interrupt_msi_pending_status_data_enable : 1'b0;
  assign cfg_mgmt_write_mux =           design_switch_net ? cfg_mgmt_write : 1'b0;
  assign cfg_msg_transmit_mux =         design_switch_net ? cfg_msg_transmit : 1'b0;
  assign cfg_power_state_change_ack_mux = design_switch_net ? cfg_power_state_change_ack : 1'b1;
  assign cfg_req_pm_transition_l23_ready_mux = design_switch_net ? cfg_req_pm_transition_l23_ready : 1'b0;
  assign cfg_vf_flr_done_mux =          design_switch_net ? cfg_vf_flr_done : 1'b1;
  assign ext_ch_gt_drpen_mux =          design_switch_net ? ext_ch_gt_drpen : {(PL_LINK_CAP_MAX_LINK_WIDTH * 1){1'b0}};
  assign pcie_cq_np_req_mux =           design_switch_net ? pcie_cq_np_req : 1'b1;
  assign m_axis_rc_tready_mux =         design_switch_net ? {22{m_axis_rc_tready}} : 22'h000000;
  assign m_axis_cq_tready_mux =         design_switch_net ? {22{m_axis_cq_tready}} : 22'h000000;
  assign s_axis_rq_tvalid_mux =         design_switch_net ? s_axis_rq_tvalid : 1'b0;
  assign s_axis_cc_tvalid_mux =         design_switch_net ? s_axis_cc_tvalid : 1'b0;
 
  // Mux critical output so they remain constant during bitstream loading.
  // This is important for Tandem and PR configurations. For all other 
  // configurations the mux logic will be optimized and removed.
  assign m_axis_rc_tvalid = design_switch_net ? m_axis_rc_tvalid_wire : 1'b0;
  assign m_axis_cq_tvalid = design_switch_net ? m_axis_cq_tvalid_wire : 1'b0;
  assign s_axis_rq_tready = design_switch_net ? s_axis_rq_tready_wire[0] : 1'b0;
  assign s_axis_cc_tready = design_switch_net ? s_axis_cc_tready_wire[0] : 1'b0;
  assign conf_req_ready = design_switch_net ? conf_req_ready_wire :1'b0;

endmodule

module rp_pcie3_uscale_top 
 #(
  parameter TCQ = 100,
  parameter NO_DECODE_LOGIC  = "TRUE",
  parameter INTERFACE_SPEED  = "500MHZ",
  parameter COMPLETION_SPACE = "16KB",
  parameter KEEP_WIDTH = 8,
  parameter C_DATA_WIDTH = 256,
  parameter PIPE_PIPELINE_STAGES = 0,
  parameter ARI_CAP_ENABLE = "FALSE",
  parameter AXISTEN_IF_CC_ALIGNMENT_MODE = "FALSE",
  parameter AXISTEN_IF_CC_PARITY_CHK = "TRUE",
  parameter AXISTEN_IF_CQ_ALIGNMENT_MODE = "FALSE",
  parameter AXISTEN_IF_ENABLE_CLIENT_TAG = "FALSE",
  parameter [17:0] AXISTEN_IF_ENABLE_MSG_ROUTE = 18'h00000,
  parameter AXISTEN_IF_ENABLE_RX_MSG_INTFC = "FALSE",
  parameter AXISTEN_IF_RC_ALIGNMENT_MODE = "FALSE",
  parameter AXISTEN_IF_RC_STRADDLE = "FALSE",
  parameter AXISTEN_IF_RQ_ALIGNMENT_MODE = "FALSE",
  parameter AXISTEN_IF_RQ_PARITY_CHK = "TRUE",
  parameter [1:0] AXISTEN_IF_WIDTH = 2'h2,
  parameter CRM_CORE_CLK_FREQ_500 = "TRUE",
  parameter [1:0] CRM_USER_CLK_FREQ = 2'h2,
  parameter DEBUG_CFG_LOCAL_MGMT_REG_ACCESS_OVERRIDE = "FALSE",
  parameter DEBUG_PL_DISABLE_EI_INFER_IN_L0 = "FALSE",
  parameter DEBUG_TL_DISABLE_RX_TLP_ORDER_CHECKS = "FALSE",
  parameter [7:0] DNSTREAM_LINK_NUM = 8'h00,
  parameter [8:0] LL_ACK_TIMEOUT = 9'h000,
  parameter LL_ACK_TIMEOUT_EN = "FALSE",
  parameter integer LL_ACK_TIMEOUT_FUNC = 0,
  parameter [15:0] LL_CPL_FC_UPDATE_TIMER = 16'h0000,
  parameter LL_CPL_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter [15:0] LL_FC_UPDATE_TIMER = 16'h0000,
  parameter LL_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter [15:0] LL_NP_FC_UPDATE_TIMER = 16'h0000,
  parameter LL_NP_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter [15:0] LL_P_FC_UPDATE_TIMER = 16'h0000,
  parameter LL_P_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter [8:0] LL_REPLAY_TIMEOUT = 9'h000,
  parameter LL_REPLAY_TIMEOUT_EN = "FALSE",
  parameter integer LL_REPLAY_TIMEOUT_FUNC = 0,
  parameter [9:0] LTR_TX_MESSAGE_MINIMUM_INTERVAL = 10'h0fa,
  parameter LTR_TX_MESSAGE_ON_FUNC_POWER_STATE_CHANGE = "FALSE",
  parameter LTR_TX_MESSAGE_ON_LTR_ENABLE = "FALSE",
  parameter [11:0] MCAP_CAP_NEXTPTR = 12'h000,
  parameter MCAP_CONFIGURE_OVERRIDE = "FALSE",
  parameter MCAP_ENABLE = "FALSE",
  parameter MCAP_EOS_DESIGN_SWITCH = "TRUE",
  parameter [31:0] MCAP_FPGA_BITSTREAM_VERSION = 32'h00000000,
  parameter MCAP_GATE_IO_ENABLE_DESIGN_SWITCH = "TRUE",
  parameter MCAP_GATE_MEM_ENABLE_DESIGN_SWITCH = "TRUE",
  parameter MCAP_INPUT_GATE_DESIGN_SWITCH = "FALSE",
  parameter MCAP_INTERRUPT_ON_MCAP_EOS = "FALSE",
  parameter MCAP_INTERRUPT_ON_MCAP_ERROR = "FALSE",
  parameter [15:0] MCAP_VSEC_ID = 16'h0000,
  parameter [11:0] MCAP_VSEC_LEN = 12'h02c,
  parameter [3:0] MCAP_VSEC_REV = 4'h0,
  parameter PF0_AER_CAP_ECRC_CHECK_CAPABLE = "FALSE",
  parameter PF0_AER_CAP_ECRC_GEN_CAPABLE = "FALSE",
  parameter [11:0] PF0_AER_CAP_NEXTPTR = 12'h000,
  parameter [7:0] PF0_ARI_CAP_NEXT_FUNC = 8'h00,
  parameter [11:0] PF0_ARI_CAP_NEXTPTR = 12'h000,
  parameter [3:0] PF0_ARI_CAP_VER = 4'h1,
  parameter [5:0] PF0_BAR0_APERTURE_SIZE = 6'h03,
  parameter [2:0] PF0_BAR0_CONTROL = 3'h4,
  parameter [5:0] PF0_BAR1_APERTURE_SIZE = 6'h00,
  parameter [2:0] PF0_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF0_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF0_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF0_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF0_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_BAR5_CONTROL = 3'h0,
  parameter [7:0] PF0_BIST_REGISTER = 8'h00,
  parameter [7:0] PF0_CAPABILITY_POINTER = 8'h50,
  parameter [23:0] PF0_CLASS_CODE = 24'h000000,
  parameter integer PF0_DEV_CAP_ENDPOINT_L0S_LATENCY = 0,
  parameter integer PF0_DEV_CAP_ENDPOINT_L1_LATENCY = 0,
  parameter PF0_DEV_CAP_EXT_TAG_SUPPORTED = "TRUE",
  parameter PF0_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE = "TRUE",
  parameter [2:0] PF0_DEV_CAP_MAX_PAYLOAD_SIZE = 3'h3,
  parameter PF0_DEV_CAP2_ARI_FORWARD_ENABLE = "FALSE",
  parameter PF0_DEV_CAP2_CPL_TIMEOUT_DISABLE = "TRUE",
  parameter PF0_DEV_CAP2_LTR_SUPPORT = "TRUE",
  parameter [1:0] PF0_DEV_CAP2_OBFF_SUPPORT = 2'h0,
  parameter PF0_DEV_CAP2_TPH_COMPLETER_SUPPORT = "FALSE",
  parameter PF0_DEV_CAP2_32B_ATOMIC_COMPLETER_SUPPORT = "TRUE",
  parameter PF0_DEV_CAP2_64B_ATOMIC_COMPLETER_SUPPORT = "TRUE",
  parameter PF0_DEV_CAP2_128B_CAS_ATOMIC_COMPLETER_SUPPORT = "TRUE",
  parameter [15:0] PF0_DEVICE_ID = 16'h0000,
  parameter [11:0] PF0_DPA_CAP_NEXTPTR = 12'h000,
  parameter [4:0] PF0_DPA_CAP_SUB_STATE_CONTROL = 5'h00,
  parameter PF0_DPA_CAP_SUB_STATE_CONTROL_EN = "TRUE",
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 = 8'h00,
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 = 8'h00,
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 = 8'h00,
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 = 8'h00,
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 = 8'h00,
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 = 8'h00,
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 = 8'h00,
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 = 8'h00,
  parameter [3:0] PF0_DPA_CAP_VER = 4'h1,
  parameter [11:0] PF0_DSN_CAP_NEXTPTR = 12'h10c,
  parameter [4:0] PF0_EXPANSION_ROM_APERTURE_SIZE = 5'h03,
  parameter PF0_EXPANSION_ROM_ENABLE = "FALSE",
  parameter [7:0] PF0_INTERRUPT_LINE = 8'h00,
  parameter [2:0] PF0_INTERRUPT_PIN = 3'h1,
  parameter integer PF0_LINK_CAP_ASPM_SUPPORT = 0,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN3 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN3 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN3 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_GEN3 = 7,
  parameter PF0_LINK_STATUS_SLOT_CLOCK_CONFIG = "TRUE",
  parameter [9:0] PF0_LTR_CAP_MAX_NOSNOOP_LAT = 10'h000,
  parameter [9:0] PF0_LTR_CAP_MAX_SNOOP_LAT = 10'h000,
  parameter [11:0] PF0_LTR_CAP_NEXTPTR = 12'h000,
  parameter [3:0] PF0_LTR_CAP_VER = 4'h1,
  parameter integer PF0_MSI_CAP_MULTIMSGCAP = 0,
  parameter [7:0] PF0_MSI_CAP_NEXTPTR = 8'h00,
  parameter PF0_MSI_CAP_PERVECMASKCAP = "FALSE",
  parameter [7:0] PF0_MSIX_CAP_NEXTPTR = 8'h00,
  parameter integer PF0_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] PF0_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer PF0_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] PF0_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] PF0_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [31:0] PF0_PB_CAP_DATA_REG_D0 = 32'h00000000,
  parameter [31:0] PF0_PB_CAP_DATA_REG_D0_SUSTAINED = 32'h00000000,
  parameter [31:0] PF0_PB_CAP_DATA_REG_D1 = 32'h00000000,
  parameter [31:0] PF0_PB_CAP_DATA_REG_D3HOT = 32'h00000000,
  parameter [11:0] PF0_PB_CAP_NEXTPTR = 12'h000,
  parameter PF0_PB_CAP_SYSTEM_ALLOCATED = "FALSE",
  parameter [3:0] PF0_PB_CAP_VER = 4'h1,
  parameter [7:0] PF0_PM_CAP_ID = 8'h01,
  parameter [7:0] PF0_PM_CAP_NEXTPTR = 8'h00,
  parameter PF0_PM_CAP_PMESUPPORT_D0 = "TRUE",
  parameter PF0_PM_CAP_PMESUPPORT_D1 = "TRUE",
  parameter PF0_PM_CAP_PMESUPPORT_D3HOT = "TRUE",
  parameter PF0_PM_CAP_SUPP_D1_STATE = "TRUE",
  parameter [2:0] PF0_PM_CAP_VER_ID = 3'h3,
  parameter PF0_PM_CSR_NOSOFTRESET = "TRUE",
  parameter PF0_RBAR_CAP_ENABLE = "FALSE",
  parameter [11:0] PF0_RBAR_CAP_NEXTPTR = 12'h000,
  parameter [19:0] PF0_RBAR_CAP_SIZE0 = 20'h00000,
  parameter [19:0] PF0_RBAR_CAP_SIZE1 = 20'h00000,
  parameter [19:0] PF0_RBAR_CAP_SIZE2 = 20'h00000,
  parameter [3:0] PF0_RBAR_CAP_VER = 4'h1,
  parameter [2:0] PF0_RBAR_CONTROL_INDEX0 = 3'h0,
  parameter [2:0] PF0_RBAR_CONTROL_INDEX1 = 3'h0,
  parameter [2:0] PF0_RBAR_CONTROL_INDEX2 = 3'h0,
  parameter [4:0] PF0_RBAR_CONTROL_SIZE0 = 5'h00,
  parameter [4:0] PF0_RBAR_CONTROL_SIZE1 = 5'h00,
  parameter [4:0] PF0_RBAR_CONTROL_SIZE2 = 5'h00,
  parameter [2:0] PF0_RBAR_NUM = 3'h1,
  parameter [7:0] PF0_REVISION_ID = 8'h00,
  parameter [11:0] PF0_SECONDARY_PCIE_CAP_NEXTPTR = 12'h000,
  parameter [4:0] PF0_SRIOV_BAR0_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_SRIOV_BAR0_CONTROL = 3'h4,
  parameter [4:0] PF0_SRIOV_BAR1_APERTURE_SIZE = 5'h00,
  parameter [2:0] PF0_SRIOV_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF0_SRIOV_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_SRIOV_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF0_SRIOV_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_SRIOV_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF0_SRIOV_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_SRIOV_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF0_SRIOV_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_SRIOV_BAR5_CONTROL = 3'h0,
  parameter [15:0] PF0_SRIOV_CAP_INITIAL_VF = 16'h0000,
  parameter [11:0] PF0_SRIOV_CAP_NEXTPTR = 12'h000,
  parameter [15:0] PF0_SRIOV_CAP_TOTAL_VF = 16'h0000,
  parameter [3:0] PF0_SRIOV_CAP_VER = 4'h1,
  parameter [15:0] PF0_SRIOV_FIRST_VF_OFFSET = 16'h0000,
  parameter [15:0] PF0_SRIOV_FUNC_DEP_LINK = 16'h0000,
  parameter [31:0] PF0_SRIOV_SUPPORTED_PAGE_SIZE = 32'h00000000,
  parameter [15:0] PF0_SRIOV_VF_DEVICE_ID = 16'h0000,
  parameter [15:0] PF0_SUBSYSTEM_ID = 16'h0000,
  parameter PF0_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter PF0_TPHR_CAP_ENABLE = "FALSE",
  parameter PF0_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] PF0_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] PF0_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] PF0_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] PF0_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] PF0_TPHR_CAP_VER = 4'h1,
  parameter PF0_VC_CAP_ENABLE = "FALSE",
  parameter [11:0] PF0_VC_CAP_NEXTPTR = 12'h000,
  parameter [3:0] PF0_VC_CAP_VER = 4'h1,
  parameter PF1_AER_CAP_ECRC_CHECK_CAPABLE = "FALSE",
  parameter PF1_AER_CAP_ECRC_GEN_CAPABLE = "FALSE",
  parameter [11:0] PF1_AER_CAP_NEXTPTR = 12'h000,
  parameter [7:0] PF1_ARI_CAP_NEXT_FUNC = 8'h00,
  parameter [11:0] PF1_ARI_CAP_NEXTPTR = 12'h000,
  parameter [5:0] PF1_BAR0_APERTURE_SIZE = 6'h03,
  parameter [2:0] PF1_BAR0_CONTROL = 3'h4,
  parameter [5:0] PF1_BAR1_APERTURE_SIZE = 6'h00,
  parameter [2:0] PF1_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF1_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF1_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF1_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF1_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_BAR5_CONTROL = 3'h0,
  parameter [7:0] PF1_BIST_REGISTER = 8'h00,
  parameter [7:0] PF1_CAPABILITY_POINTER = 8'h50,
  parameter [23:0] PF1_CLASS_CODE = 24'h000000,
  parameter [2:0] PF1_DEV_CAP_MAX_PAYLOAD_SIZE = 3'h3,
  parameter [15:0] PF1_DEVICE_ID = 16'h0000,
  parameter [11:0] PF1_DPA_CAP_NEXTPTR = 12'h000,
  parameter [4:0] PF1_DPA_CAP_SUB_STATE_CONTROL = 5'h00,
  parameter PF1_DPA_CAP_SUB_STATE_CONTROL_EN = "TRUE",
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 = 8'h00,
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 = 8'h00,
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 = 8'h00,
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 = 8'h00,
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 = 8'h00,
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 = 8'h00,
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 = 8'h00,
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 = 8'h00,
  parameter [3:0] PF1_DPA_CAP_VER = 4'h1,
  parameter [11:0] PF1_DSN_CAP_NEXTPTR = 12'h10c,
  parameter [4:0] PF1_EXPANSION_ROM_APERTURE_SIZE = 5'h03,
  parameter PF1_EXPANSION_ROM_ENABLE = "FALSE",
  parameter [7:0] PF1_INTERRUPT_LINE = 8'h00,
  parameter [2:0] PF1_INTERRUPT_PIN = 3'h1,
  parameter integer PF1_MSI_CAP_MULTIMSGCAP = 0,
  parameter [7:0] PF1_MSI_CAP_NEXTPTR = 8'h00,
  parameter PF1_MSI_CAP_PERVECMASKCAP = "FALSE",
  parameter [7:0] PF1_MSIX_CAP_NEXTPTR = 8'h00,
  parameter integer PF1_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] PF1_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer PF1_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] PF1_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] PF1_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [31:0] PF1_PB_CAP_DATA_REG_D0 = 32'h00000000,
  parameter [31:0] PF1_PB_CAP_DATA_REG_D0_SUSTAINED = 32'h00000000,
  parameter [31:0] PF1_PB_CAP_DATA_REG_D1 = 32'h00000000,
  parameter [31:0] PF1_PB_CAP_DATA_REG_D3HOT = 32'h00000000,
  parameter [11:0] PF1_PB_CAP_NEXTPTR = 12'h000,
  parameter PF1_PB_CAP_SYSTEM_ALLOCATED = "FALSE",
  parameter [3:0] PF1_PB_CAP_VER = 4'h1,
  parameter [7:0] PF1_PM_CAP_ID = 8'h01,
  parameter [7:0] PF1_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] PF1_PM_CAP_VER_ID = 3'h3,
  parameter PF1_RBAR_CAP_ENABLE = "FALSE",
  parameter [11:0] PF1_RBAR_CAP_NEXTPTR = 12'h000,
  parameter [19:0] PF1_RBAR_CAP_SIZE0 = 20'h00000,
  parameter [19:0] PF1_RBAR_CAP_SIZE1 = 20'h00000,
  parameter [19:0] PF1_RBAR_CAP_SIZE2 = 20'h00000,
  parameter [3:0] PF1_RBAR_CAP_VER = 4'h1,
  parameter [2:0] PF1_RBAR_CONTROL_INDEX0 = 3'h0,
  parameter [2:0] PF1_RBAR_CONTROL_INDEX1 = 3'h0,
  parameter [2:0] PF1_RBAR_CONTROL_INDEX2 = 3'h0,
  parameter [4:0] PF1_RBAR_CONTROL_SIZE0 = 5'h00,
  parameter [4:0] PF1_RBAR_CONTROL_SIZE1 = 5'h00,
  parameter [4:0] PF1_RBAR_CONTROL_SIZE2 = 5'h00,
  parameter [2:0] PF1_RBAR_NUM = 3'h1,
  parameter [7:0] PF1_REVISION_ID = 8'h00,
  parameter [4:0] PF1_SRIOV_BAR0_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_SRIOV_BAR0_CONTROL = 3'h4,
  parameter [4:0] PF1_SRIOV_BAR1_APERTURE_SIZE = 5'h00,
  parameter [2:0] PF1_SRIOV_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF1_SRIOV_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_SRIOV_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF1_SRIOV_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_SRIOV_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF1_SRIOV_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_SRIOV_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF1_SRIOV_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_SRIOV_BAR5_CONTROL = 3'h0,
  parameter [15:0] PF1_SRIOV_CAP_INITIAL_VF = 16'h0000,
  parameter [11:0] PF1_SRIOV_CAP_NEXTPTR = 12'h000,
  parameter [15:0] PF1_SRIOV_CAP_TOTAL_VF = 16'h0000,
  parameter [3:0] PF1_SRIOV_CAP_VER = 4'h1,
  parameter [15:0] PF1_SRIOV_FIRST_VF_OFFSET = 16'h0000,
  parameter [15:0] PF1_SRIOV_FUNC_DEP_LINK = 16'h0000,
  parameter [31:0] PF1_SRIOV_SUPPORTED_PAGE_SIZE = 32'h00000000,
  parameter [15:0] PF1_SRIOV_VF_DEVICE_ID = 16'h0000,
  parameter [15:0] PF1_SUBSYSTEM_ID = 16'h0000,
  parameter PF1_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter PF1_TPHR_CAP_ENABLE = "FALSE",
  parameter PF1_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] PF1_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] PF1_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] PF1_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] PF1_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] PF1_TPHR_CAP_VER = 4'h1,
  parameter PF2_AER_CAP_ECRC_CHECK_CAPABLE = "FALSE",
  parameter PF2_AER_CAP_ECRC_GEN_CAPABLE = "FALSE",
  parameter [11:0] PF2_AER_CAP_NEXTPTR = 12'h000,
  parameter [7:0] PF2_ARI_CAP_NEXT_FUNC = 8'h00,
  parameter [11:0] PF2_ARI_CAP_NEXTPTR = 12'h000,
  parameter [5:0] PF2_BAR0_APERTURE_SIZE = 6'h03,
  parameter [2:0] PF2_BAR0_CONTROL = 3'h4,
  parameter [5:0] PF2_BAR1_APERTURE_SIZE = 6'h00,
  parameter [2:0] PF2_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF2_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF2_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF2_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF2_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_BAR5_CONTROL = 3'h0,
  parameter [7:0] PF2_BIST_REGISTER = 8'h00,
  parameter [7:0] PF2_CAPABILITY_POINTER = 8'h50,
  parameter [23:0] PF2_CLASS_CODE = 24'h000000,
  parameter [2:0] PF2_DEV_CAP_MAX_PAYLOAD_SIZE = 3'h3,
  parameter [15:0] PF2_DEVICE_ID = 16'h0000,
  parameter [11:0] PF2_DPA_CAP_NEXTPTR = 12'h000,
  parameter [4:0] PF2_DPA_CAP_SUB_STATE_CONTROL = 5'h00,
  parameter PF2_DPA_CAP_SUB_STATE_CONTROL_EN = "TRUE",
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 = 8'h00,
  parameter [3:0] PF2_DPA_CAP_VER = 4'h1,
  parameter [11:0] PF2_DSN_CAP_NEXTPTR = 12'h10c,
  parameter [4:0] PF2_EXPANSION_ROM_APERTURE_SIZE = 5'h03,
  parameter PF2_EXPANSION_ROM_ENABLE = "FALSE",
  parameter [7:0] PF2_INTERRUPT_LINE = 8'h00,
  parameter [2:0] PF2_INTERRUPT_PIN = 3'h1,
  parameter integer PF2_MSI_CAP_MULTIMSGCAP = 0,
  parameter [7:0] PF2_MSI_CAP_NEXTPTR = 8'h00,
  parameter PF2_MSI_CAP_PERVECMASKCAP = "FALSE",
  parameter [7:0] PF2_MSIX_CAP_NEXTPTR = 8'h00,
  parameter integer PF2_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] PF2_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer PF2_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] PF2_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] PF2_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [31:0] PF2_PB_CAP_DATA_REG_D0 = 32'h00000000,
  parameter [31:0] PF2_PB_CAP_DATA_REG_D0_SUSTAINED = 32'h00000000,
  parameter [31:0] PF2_PB_CAP_DATA_REG_D1 = 32'h00000000,
  parameter [31:0] PF2_PB_CAP_DATA_REG_D3HOT = 32'h00000000,
  parameter [11:0] PF2_PB_CAP_NEXTPTR = 12'h000,
  parameter PF2_PB_CAP_SYSTEM_ALLOCATED = "FALSE",
  parameter [3:0] PF2_PB_CAP_VER = 4'h1,
  parameter [7:0] PF2_PM_CAP_ID = 8'h01,
  parameter [7:0] PF2_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] PF2_PM_CAP_VER_ID = 3'h3,
  parameter PF2_RBAR_CAP_ENABLE = "FALSE",
  parameter [11:0] PF2_RBAR_CAP_NEXTPTR = 12'h000,
  parameter [19:0] PF2_RBAR_CAP_SIZE0 = 20'h00000,
  parameter [19:0] PF2_RBAR_CAP_SIZE1 = 20'h00000,
  parameter [19:0] PF2_RBAR_CAP_SIZE2 = 20'h00000,
  parameter [3:0] PF2_RBAR_CAP_VER = 4'h1,
  parameter [2:0] PF2_RBAR_CONTROL_INDEX0 = 3'h0,
  parameter [2:0] PF2_RBAR_CONTROL_INDEX1 = 3'h0,
  parameter [2:0] PF2_RBAR_CONTROL_INDEX2 = 3'h0,
  parameter [4:0] PF2_RBAR_CONTROL_SIZE0 = 5'h00,
  parameter [4:0] PF2_RBAR_CONTROL_SIZE1 = 5'h00,
  parameter [4:0] PF2_RBAR_CONTROL_SIZE2 = 5'h00,
  parameter [2:0] PF2_RBAR_NUM = 3'h1,
  parameter [7:0] PF2_REVISION_ID = 8'h00,
  parameter [4:0] PF2_SRIOV_BAR0_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_SRIOV_BAR0_CONTROL = 3'h4,
  parameter [4:0] PF2_SRIOV_BAR1_APERTURE_SIZE = 5'h00,
  parameter [2:0] PF2_SRIOV_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF2_SRIOV_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_SRIOV_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF2_SRIOV_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_SRIOV_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF2_SRIOV_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_SRIOV_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF2_SRIOV_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_SRIOV_BAR5_CONTROL = 3'h0,
  parameter [15:0] PF2_SRIOV_CAP_INITIAL_VF = 16'h0000,
  parameter [11:0] PF2_SRIOV_CAP_NEXTPTR = 12'h000,
  parameter [15:0] PF2_SRIOV_CAP_TOTAL_VF = 16'h0000,
  parameter [3:0] PF2_SRIOV_CAP_VER = 4'h1,
  parameter [15:0] PF2_SRIOV_FIRST_VF_OFFSET = 16'h0000,
  parameter [15:0] PF2_SRIOV_FUNC_DEP_LINK = 16'h0000,
  parameter [31:0] PF2_SRIOV_SUPPORTED_PAGE_SIZE = 32'h00000000,
  parameter [15:0] PF2_SRIOV_VF_DEVICE_ID = 16'h0000,
  parameter [15:0] PF2_SUBSYSTEM_ID = 16'h0000,
  parameter PF2_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter PF2_TPHR_CAP_ENABLE = "FALSE",
  parameter PF2_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] PF2_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] PF2_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] PF2_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] PF2_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] PF2_TPHR_CAP_VER = 4'h1,
  parameter PF3_AER_CAP_ECRC_CHECK_CAPABLE = "FALSE",
  parameter PF3_AER_CAP_ECRC_GEN_CAPABLE = "FALSE",
  parameter [11:0] PF3_AER_CAP_NEXTPTR = 12'h000,
  parameter [7:0] PF3_ARI_CAP_NEXT_FUNC = 8'h00,
  parameter [11:0] PF3_ARI_CAP_NEXTPTR = 12'h000,
  parameter [5:0] PF3_BAR0_APERTURE_SIZE = 6'h03,
  parameter [2:0] PF3_BAR0_CONTROL = 3'h4,
  parameter [5:0] PF3_BAR1_APERTURE_SIZE = 6'h00,
  parameter [2:0] PF3_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF3_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF3_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF3_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF3_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_BAR5_CONTROL = 3'h0,
  parameter [7:0] PF3_BIST_REGISTER = 8'h00,
  parameter [7:0] PF3_CAPABILITY_POINTER = 8'h50,
  parameter [23:0] PF3_CLASS_CODE = 24'h000000,
  parameter [2:0] PF3_DEV_CAP_MAX_PAYLOAD_SIZE = 3'h3,
  parameter [15:0] PF3_DEVICE_ID = 16'h0000,
  parameter [11:0] PF3_DPA_CAP_NEXTPTR = 12'h000,
  parameter [4:0] PF3_DPA_CAP_SUB_STATE_CONTROL = 5'h00,
  parameter PF3_DPA_CAP_SUB_STATE_CONTROL_EN = "TRUE",
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 = 8'h00,
  parameter [3:0] PF3_DPA_CAP_VER = 4'h1,
  parameter [11:0] PF3_DSN_CAP_NEXTPTR = 12'h10c,
  parameter [4:0] PF3_EXPANSION_ROM_APERTURE_SIZE = 5'h03,
  parameter PF3_EXPANSION_ROM_ENABLE = "FALSE",
  parameter [7:0] PF3_INTERRUPT_LINE = 8'h00,
  parameter [2:0] PF3_INTERRUPT_PIN = 3'h1,
  parameter integer PF3_MSI_CAP_MULTIMSGCAP = 0,
  parameter [7:0] PF3_MSI_CAP_NEXTPTR = 8'h00,
  parameter PF3_MSI_CAP_PERVECMASKCAP = "FALSE",
  parameter [7:0] PF3_MSIX_CAP_NEXTPTR = 8'h00,
  parameter integer PF3_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] PF3_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer PF3_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] PF3_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] PF3_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [31:0] PF3_PB_CAP_DATA_REG_D0 = 32'h00000000,
  parameter [31:0] PF3_PB_CAP_DATA_REG_D0_SUSTAINED = 32'h00000000,
  parameter [31:0] PF3_PB_CAP_DATA_REG_D1 = 32'h00000000,
  parameter [31:0] PF3_PB_CAP_DATA_REG_D3HOT = 32'h00000000,
  parameter [11:0] PF3_PB_CAP_NEXTPTR = 12'h000,
  parameter PF3_PB_CAP_SYSTEM_ALLOCATED = "FALSE",
  parameter [3:0] PF3_PB_CAP_VER = 4'h1,
  parameter [7:0] PF3_PM_CAP_ID = 8'h01,
  parameter [7:0] PF3_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] PF3_PM_CAP_VER_ID = 3'h3,
  parameter PF3_RBAR_CAP_ENABLE = "FALSE",
  parameter [11:0] PF3_RBAR_CAP_NEXTPTR = 12'h000,
  parameter [19:0] PF3_RBAR_CAP_SIZE0 = 20'h00000,
  parameter [19:0] PF3_RBAR_CAP_SIZE1 = 20'h00000,
  parameter [19:0] PF3_RBAR_CAP_SIZE2 = 20'h00000,
  parameter [3:0] PF3_RBAR_CAP_VER = 4'h1,
  parameter [2:0] PF3_RBAR_CONTROL_INDEX0 = 3'h0,
  parameter [2:0] PF3_RBAR_CONTROL_INDEX1 = 3'h0,
  parameter [2:0] PF3_RBAR_CONTROL_INDEX2 = 3'h0,
  parameter [4:0] PF3_RBAR_CONTROL_SIZE0 = 5'h00,
  parameter [4:0] PF3_RBAR_CONTROL_SIZE1 = 5'h00,
  parameter [4:0] PF3_RBAR_CONTROL_SIZE2 = 5'h00,
  parameter [2:0] PF3_RBAR_NUM = 3'h1,
  parameter [7:0] PF3_REVISION_ID = 8'h00,
  parameter [4:0] PF3_SRIOV_BAR0_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_SRIOV_BAR0_CONTROL = 3'h4,
  parameter [4:0] PF3_SRIOV_BAR1_APERTURE_SIZE = 5'h00,
  parameter [2:0] PF3_SRIOV_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF3_SRIOV_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_SRIOV_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF3_SRIOV_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_SRIOV_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF3_SRIOV_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_SRIOV_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF3_SRIOV_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_SRIOV_BAR5_CONTROL = 3'h0,
  parameter [15:0] PF3_SRIOV_CAP_INITIAL_VF = 16'h0000,
  parameter [11:0] PF3_SRIOV_CAP_NEXTPTR = 12'h000,
  parameter [15:0] PF3_SRIOV_CAP_TOTAL_VF = 16'h0000,
  parameter [3:0] PF3_SRIOV_CAP_VER = 4'h1,
  parameter [15:0] PF3_SRIOV_FIRST_VF_OFFSET = 16'h0000,
  parameter [15:0] PF3_SRIOV_FUNC_DEP_LINK = 16'h0000,
  parameter [31:0] PF3_SRIOV_SUPPORTED_PAGE_SIZE = 32'h00000000,
  parameter [15:0] PF3_SRIOV_VF_DEVICE_ID = 16'h0000,
  parameter [15:0] PF3_SUBSYSTEM_ID = 16'h0000,
  parameter PF3_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter PF3_TPHR_CAP_ENABLE = "FALSE",
  parameter PF3_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] PF3_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] PF3_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] PF3_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] PF3_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] PF3_TPHR_CAP_VER = 4'h1,
  parameter PL_DISABLE_AUTO_EQ_SPEED_CHANGE_TO_GEN3 = "FALSE",
  parameter PL_DISABLE_AUTO_SPEED_CHANGE_TO_GEN2 = "FALSE",
  parameter PL_DISABLE_EI_INFER_IN_L0 = "FALSE",
  parameter PL_DISABLE_GEN3_DC_BALANCE = "FALSE",
  parameter PL_DISABLE_GEN3_LFSR_UPDATE_ON_SKP = "FALSE",
  parameter PL_DISABLE_RETRAIN_ON_FRAMING_ERROR = "FALSE",
  parameter PL_DISABLE_SCRAMBLING = "FALSE",
  parameter PL_DISABLE_SYNC_HEADER_FRAMING_ERROR = "FALSE",
  parameter PL_DISABLE_UPCONFIG_CAPABLE = "FALSE",
  parameter PL_EQ_ADAPT_DISABLE_COEFF_CHECK = "FALSE",
  parameter PL_EQ_ADAPT_DISABLE_PRESET_CHECK = "FALSE",
  parameter [4:0] PL_EQ_ADAPT_ITER_COUNT = 5'h02,
  parameter [1:0] PL_EQ_ADAPT_REJECT_RETRY_COUNT = 2'h1,
  parameter PL_EQ_BYPASS_PHASE23 = "FALSE",
  parameter [2:0] PL_EQ_DEFAULT_GEN3_RX_PRESET_HINT = 3'h3,
  parameter [3:0] PL_EQ_DEFAULT_GEN3_TX_PRESET = 4'h4,
  parameter PL_EQ_PHASE01_RX_ADAPT = "FALSE",
  parameter PL_EQ_SHORT_ADAPT_PHASE = "FALSE",
  parameter [15:0] PL_LANE0_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE1_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE2_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE3_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE4_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE5_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE6_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE7_EQ_CONTROL = 16'h3400,
  parameter [2:0] PL_LINK_CAP_MAX_LINK_SPEED = 3'h4,
  parameter [3:0] PL_LINK_CAP_MAX_LINK_WIDTH = 4'h8,
  parameter integer PL_N_FTS_COMCLK_GEN1 = 255,
  parameter integer PL_N_FTS_COMCLK_GEN2 = 255,
  parameter integer PL_N_FTS_COMCLK_GEN3 = 255,
  parameter integer PL_N_FTS_GEN1 = 255,
  parameter integer PL_N_FTS_GEN2 = 255,
  parameter integer PL_N_FTS_GEN3 = 255,
  parameter PL_REPORT_ALL_PHY_ERRORS = "TRUE",
  parameter PL_SIM_FAST_LINK_TRAINING = "TRUE",
  parameter PL_UPSTREAM_FACING = "TRUE",
  parameter [15:0] PM_ASPML0S_TIMEOUT = 16'h05dc,
  parameter [19:0] PM_ASPML1_ENTRY_DELAY = 20'h00000,
  parameter PM_ENABLE_L23_ENTRY = "FALSE",
  parameter PM_ENABLE_SLOT_POWER_CAPTURE = "TRUE",
  parameter [31:0] PM_L1_REENTRY_DELAY = 32'h00000000,
  parameter [19:0] PM_PME_SERVICE_TIMEOUT_DELAY = 20'h186a0,
  parameter [15:0] PM_PME_TURNOFF_ACK_DELAY = 16'h0064,
  parameter SIM_JTAG_IDCODE = 32'h00000000,
  parameter SIM_VERSION = "1.0",
  parameter integer SPARE_BIT0 = 0,
  parameter integer SPARE_BIT1 = 0,
  parameter integer SPARE_BIT2 = 0,
  parameter integer SPARE_BIT3 = 0,
  parameter integer SPARE_BIT4 = 0,
  parameter integer SPARE_BIT5 = 0,
  parameter integer SPARE_BIT6 = 0,
  parameter integer SPARE_BIT7 = 0,
  parameter integer SPARE_BIT8 = 0,
  parameter [7:0] SPARE_BYTE0 = 8'h00,
  parameter [7:0] SPARE_BYTE1 = 8'h00,
  parameter [7:0] SPARE_BYTE2 = 8'h00,
  parameter [7:0] SPARE_BYTE3 = 8'h00,
  parameter [31:0] SPARE_WORD0 = 32'h00000000,
  parameter [31:0] SPARE_WORD1 = 32'h00000000,
  parameter [31:0] SPARE_WORD2 = 32'h00000000,
  parameter [31:0] SPARE_WORD3 = 32'h00000000,
  parameter SRIOV_CAP_ENABLE = "FALSE",
  parameter [23:0] TL_COMPL_TIMEOUT_REG0 = 24'hbebc20,
  parameter [27:0] TL_COMPL_TIMEOUT_REG1 = 28'h2faf080,
  parameter [11:0] TL_CREDITS_CD = 12'h3e0,
  parameter [7:0] TL_CREDITS_CH = 8'h20,
  parameter [11:0] TL_CREDITS_NPD = 12'h028,
  parameter [7:0] TL_CREDITS_NPH = 8'h20,
  parameter [11:0] TL_CREDITS_PD = 12'h198,
  parameter [7:0] TL_CREDITS_PH = 8'h20,
  parameter TL_ENABLE_MESSAGE_RID_CHECK_ENABLE = "TRUE",
  parameter TL_EXTENDED_CFG_EXTEND_INTERFACE_ENABLE = "FALSE",
  parameter TL_LEGACY_CFG_EXTEND_INTERFACE_ENABLE = "FALSE",
  parameter TL_LEGACY_MODE_ENABLE = "FALSE",
  parameter [1:0] TL_PF_ENABLE_REG = 2'h0,
  parameter TL_TX_MUX_STRICT_PRIORITY = "TRUE",
  parameter TWO_LAYER_MODE_DLCMSM_ENABLE = "TRUE",
  parameter TWO_LAYER_MODE_ENABLE = "FALSE",
  parameter TWO_LAYER_MODE_WIDTH_256 = "TRUE",
  parameter [11:0] VF0_ARI_CAP_NEXTPTR = 12'h000,
  parameter [7:0] VF0_CAPABILITY_POINTER = 8'h50,
  parameter integer VF0_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF0_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF0_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF0_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF0_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF0_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF0_PM_CAP_ID = 8'h01,
  parameter [7:0] VF0_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF0_PM_CAP_VER_ID = 3'h3,
  parameter VF0_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF0_TPHR_CAP_ENABLE = "FALSE",
  parameter VF0_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF0_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF0_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF0_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF0_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF0_TPHR_CAP_VER = 4'h1,
  parameter [11:0] VF1_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF1_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF1_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF1_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF1_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF1_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF1_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF1_PM_CAP_ID = 8'h01,
  parameter [7:0] VF1_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF1_PM_CAP_VER_ID = 3'h3,
  parameter VF1_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF1_TPHR_CAP_ENABLE = "FALSE",
  parameter VF1_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF1_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF1_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF1_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF1_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF1_TPHR_CAP_VER = 4'h1,
  parameter [11:0] VF2_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF2_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF2_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF2_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF2_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF2_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF2_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF2_PM_CAP_ID = 8'h01,
  parameter [7:0] VF2_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF2_PM_CAP_VER_ID = 3'h3,
  parameter VF2_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF2_TPHR_CAP_ENABLE = "FALSE",
  parameter VF2_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF2_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF2_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF2_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF2_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF2_TPHR_CAP_VER = 4'h1,
  parameter [11:0] VF3_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF3_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF3_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF3_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF3_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF3_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF3_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF3_PM_CAP_ID = 8'h01,
  parameter [7:0] VF3_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF3_PM_CAP_VER_ID = 3'h3,
  parameter VF3_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF3_TPHR_CAP_ENABLE = "FALSE",
  parameter VF3_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF3_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF3_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF3_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF3_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF3_TPHR_CAP_VER = 4'h1,
  parameter [11:0] VF4_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF4_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF4_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF4_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF4_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF4_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF4_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF4_PM_CAP_ID = 8'h01,
  parameter [7:0] VF4_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF4_PM_CAP_VER_ID = 3'h3,
  parameter VF4_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF4_TPHR_CAP_ENABLE = "FALSE",
  parameter VF4_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF4_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF4_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF4_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF4_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF4_TPHR_CAP_VER = 4'h1,
  parameter [11:0] VF5_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF5_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF5_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF5_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF5_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF5_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF5_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF5_PM_CAP_ID = 8'h01,
  parameter [7:0] VF5_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF5_PM_CAP_VER_ID = 3'h3,
  parameter VF5_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF5_TPHR_CAP_ENABLE = "FALSE",
  parameter VF5_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF5_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF5_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF5_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF5_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF5_TPHR_CAP_VER = 4'h1,
  parameter [11:0] VF6_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF6_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF6_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF6_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF6_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF6_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF6_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF6_PM_CAP_ID = 8'h01,
  parameter [7:0] VF6_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF6_PM_CAP_VER_ID = 3'h3,
  parameter VF6_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF6_TPHR_CAP_ENABLE = "FALSE",
  parameter VF6_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF6_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF6_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF6_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF6_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF6_TPHR_CAP_VER = 4'h1,
  parameter [11:0] VF7_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF7_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF7_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF7_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF7_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF7_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF7_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF7_PM_CAP_ID = 8'h01,
  parameter [7:0] VF7_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF7_PM_CAP_VER_ID = 3'h3,
  parameter VF7_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF7_TPHR_CAP_ENABLE = "FALSE",
  parameter VF7_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF7_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF7_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF7_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF7_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF7_TPHR_CAP_VER = 4'h1
  ) (
  input  wire         core_clk,
  input  wire         user_clk,
  input  wire         pipe_clk,
  input  wire         phy_rdy,
  input  wire [C_DATA_WIDTH-1:0] s_axis_rq_tdata,
  input  wire [KEEP_WIDTH-1:0] s_axis_rq_tkeep,
  input  wire         s_axis_rq_tlast,
  output wire   [3:0] s_axis_rq_tready,
  input  wire  [59:0] s_axis_rq_tuser,
  input  wire         s_axis_rq_tvalid,
  output wire [C_DATA_WIDTH-1:0] m_axis_rc_tdata,
  output wire [KEEP_WIDTH-1:0] m_axis_rc_tkeep,
  output wire         m_axis_rc_tlast,
  input  wire  [21:0] m_axis_rc_tready,
  output wire  [74:0] m_axis_rc_tuser,
  output wire         m_axis_rc_tvalid,
  output wire [C_DATA_WIDTH-1:0] m_axis_cq_tdata,
  output wire [KEEP_WIDTH-1:0] m_axis_cq_tkeep,
  output wire         m_axis_cq_tlast,
  input  wire  [21:0] m_axis_cq_tready,
  output wire  [84:0] m_axis_cq_tuser,
  output wire         m_axis_cq_tvalid,
  input  wire [C_DATA_WIDTH-1:0] s_axis_cc_tdata,
  input  wire [KEEP_WIDTH-1:0] s_axis_cc_tkeep,
  input  wire         s_axis_cc_tlast,
  output wire   [3:0] s_axis_cc_tready,
  input  wire  [32:0] s_axis_cc_tuser,
  input  wire         s_axis_cc_tvalid,
  output wire   [3:0] pcie_rq_seq_num,
  output wire         pcie_rq_seq_num_vld,
  output wire   [5:0] pcie_rq_tag,
  output wire   [1:0] pcie_rq_tag_av,
  output wire         pcie_rq_tag_vld,
  output wire   [1:0] pcie_tfc_npd_av,
  output wire   [1:0] pcie_tfc_nph_av,
  input  wire         pcie_cq_np_req,
  output wire   [5:0] pcie_cq_np_req_count,
  input  wire  [18:0] cfg_mgmt_addr,
  input  wire   [3:0] cfg_mgmt_byte_enable,
  input  wire         cfg_mgmt_read,
  output wire  [31:0] cfg_mgmt_read_data,
  output wire         cfg_mgmt_read_write_done,
  input  wire         cfg_mgmt_type1_cfg_reg_access,
  input  wire         cfg_mgmt_write,
  input  wire  [31:0] cfg_mgmt_write_data,
  output wire         cfg_phy_link_down,
  output wire   [1:0] cfg_phy_link_status,
  output wire   [3:0] cfg_negotiated_width,
  output wire   [2:0] cfg_current_speed,
  output wire   [2:0] cfg_max_payload,
  output wire   [2:0] cfg_max_read_req,
  output wire  [15:0] cfg_function_status,
  output wire  [11:0] cfg_function_power_state,
  output wire  [15:0] cfg_vf_status,
  output wire  [23:0] cfg_vf_power_state,
  output wire   [1:0] cfg_link_power_state,
  output wire         cfg_err_cor_out,
  output wire         cfg_err_nonfatal_out,
  output wire         cfg_err_fatal_out,
  output wire         cfg_local_error,
  output wire         cfg_ltr_enable,
  output wire   [5:0] cfg_ltssm_state,
  output wire   [3:0] cfg_rcb_status,
  output wire   [3:0] cfg_dpa_substate_change,
  output wire   [1:0] cfg_obff_enable,
  output wire         cfg_pl_status_change,
  output wire   [3:0] cfg_tph_requester_enable,
  output wire  [11:0] cfg_tph_st_mode,
  output wire   [7:0] cfg_vf_tph_requester_enable,
  output wire  [23:0] cfg_vf_tph_st_mode,
  output wire         cfg_msg_received,
  output wire   [7:0] cfg_msg_received_data,
  output wire   [4:0] cfg_msg_received_type,
  input  wire         cfg_msg_transmit,
  input  wire   [2:0] cfg_msg_transmit_type,
  input  wire  [31:0] cfg_msg_transmit_data,
  output wire         cfg_msg_transmit_done,
  output wire   [7:0] cfg_fc_ph,
  output wire  [11:0] cfg_fc_pd,
  output wire   [7:0] cfg_fc_nph,
  output wire  [11:0] cfg_fc_npd,
  output wire   [7:0] cfg_fc_cplh,
  output wire  [11:0] cfg_fc_cpld,
  input  wire   [2:0] cfg_fc_sel,
  input  wire   [2:0] cfg_per_func_status_control,
  output wire  [15:0] cfg_per_func_status_data,
  input  wire   [3:0] cfg_per_function_number,
  input  wire         cfg_per_function_output_request,
  output wire         cfg_per_function_update_done,
  input  wire         cfg_power_state_change_ack,
  output wire         cfg_power_state_change_interrupt,
  input  wire         cfg_err_cor_in,
  input  wire         cfg_err_uncor_in,
  output wire   [3:0] cfg_flr_in_process,
  input  wire   [3:0] cfg_flr_done,
  output wire   [7:0] cfg_vf_flr_in_process,
  input  wire   [7:0] cfg_vf_flr_done,
  input  wire         cfg_link_training_enable,
  input  wire   [3:0] cfg_interrupt_int,
  input  wire   [3:0] cfg_interrupt_pending,
  output wire         cfg_interrupt_sent,
  output wire   [3:0] cfg_interrupt_msi_enable,
  output wire   [7:0] cfg_interrupt_msi_vf_enable,
  output wire  [11:0] cfg_interrupt_msi_mmenable,
  output wire         cfg_interrupt_msi_mask_update,
  output wire  [31:0] cfg_interrupt_msi_data,
  input  wire   [3:0] cfg_interrupt_msi_select,
  input  wire  [31:0] cfg_interrupt_msi_int,
  input  wire  [31:0] cfg_interrupt_msi_pending_status,
  input  wire         cfg_interrupt_msi_pending_status_data_enable,
  input  wire   [3:0] cfg_interrupt_msi_pending_status_function_num,
  output wire         cfg_interrupt_msi_sent,
  output wire         cfg_interrupt_msi_fail,
  output wire   [3:0] cfg_interrupt_msix_enable,
  output wire   [3:0] cfg_interrupt_msix_mask,
  output wire   [7:0] cfg_interrupt_msix_vf_enable,
  output wire   [7:0] cfg_interrupt_msix_vf_mask,
  input  wire  [31:0] cfg_interrupt_msix_data,
  input  wire  [63:0] cfg_interrupt_msix_address,
  input  wire         cfg_interrupt_msix_int,
  output wire         cfg_interrupt_msix_sent,
  output wire         cfg_interrupt_msix_fail,
  input  wire   [2:0] cfg_interrupt_msi_attr,
  input  wire         cfg_interrupt_msi_tph_present,
  input  wire   [1:0] cfg_interrupt_msi_tph_type,
  input  wire   [8:0] cfg_interrupt_msi_tph_st_tag,
  input  wire   [3:0] cfg_interrupt_msi_function_number,
  output wire         cfg_ext_read_received,
  output wire         cfg_ext_write_received,
  output wire   [9:0] cfg_ext_register_number,
  output wire   [7:0] cfg_ext_function_number,
  output wire  [31:0] cfg_ext_write_data,
  output wire   [3:0] cfg_ext_write_byte_enable,
  input  wire  [31:0] cfg_ext_read_data,
  input  wire         cfg_ext_read_data_valid,
  input  wire  [15:0] cfg_dev_id,
  input  wire  [15:0] cfg_vend_id,
  input  wire   [7:0] cfg_rev_id,
  input  wire  [15:0] cfg_subsys_id,
  input  wire  [15:0] cfg_subsys_vend_id,
  input  wire   [7:0] cfg_ds_port_number,
  output wire         cfg_hot_reset_out,
  input  wire         cfg_config_space_enable,
  input  wire         cfg_req_pm_transition_l23_ready,
  input  wire         cfg_hot_reset_in,
  input  wire   [7:0] cfg_ds_bus_number,
  input  wire   [4:0] cfg_ds_device_number,
  input  wire   [2:0] cfg_ds_function_number,
  input  wire  [63:0] cfg_dsn,
  output wire         drp_rdy,
  output wire  [15:0] drp_do,
  input  wire         drp_clk,
  input  wire         drp_en,
  input  wire         drp_we,
  input  wire   [9:0] drp_addr,
  input  wire  [15:0] drp_di,
  input  wire   [4:0] user_tph_stt_address,
  input  wire   [3:0] user_tph_function_num,
  output wire  [31:0] user_tph_stt_read_data,
  output wire         user_tph_stt_read_data_valid,
  input  wire         user_tph_stt_read_enable,
  input  wire   [1:0] conf_req_type,
  input  wire   [3:0] conf_req_reg_num,
  input  wire  [31:0] conf_req_data,
  input  wire         conf_req_valid,
  input  wire         conf_mcap_request_by_conf,
  output wire         conf_req_ready,
  output wire  [31:0] conf_resp_rdata,
  output wire         conf_resp_valid,
  output wire         conf_mcap_design_switch,
  output wire         conf_mcap_eos,
  output wire         conf_mcap_in_use_by_pcie,
  output wire         dbg_mcap_cs_b,
  output wire  [31:0] dbg_mcap_data,
  output wire         dbg_mcap_eos,
  output wire         dbg_mcap_errror,
  output wire         dbg_mcap_mode,
  output wire         dbg_mcap_rdata_valid,
  output wire         dbg_mcap_rdwr_b,
  output wire         dbg_mcap_reset,
  input  wire         mcap_clk,
  output wire         pl_eq_in_progress,
  output wire   [1:0] pl_eq_phase,
  input  wire         pcie_perstn0_in,
  output wire         pcie_perstn0_out,
  input  wire         pcie_perstn1_in,
  output wire         pcie_perstn1_out,
  input  wire         pl_eq_reset_eieos_count,
  input  wire         pl_gen2_upstream_prefer_deemph,
  output wire         pipe_tx0_deemph_gt,
  output wire         pipe_tx0_rcvr_det_gt,
  output wire   [1:0] pipe_tx0_rate_gt,
  output wire   [2:0] pipe_tx0_margin_gt,
  output wire         pipe_tx0_swing_gt,
  input  wire   [5:0] pipe_tx_eqfs_gt,
  input  wire   [5:0] pipe_tx_eqlf_gt,
  output wire         pipe_tx0_reset_gt,
  output wire         pipe_tx0_compliance_gt,
  output wire         pipe_tx1_compliance_gt,
  output wire         pipe_tx2_compliance_gt,
  output wire         pipe_tx3_compliance_gt,
  output wire         pipe_tx4_compliance_gt,
  output wire         pipe_tx5_compliance_gt,
  output wire         pipe_tx6_compliance_gt,
  output wire         pipe_tx7_compliance_gt,
  output wire         pipe_tx0_data_valid_gt,
  output wire         pipe_tx1_data_valid_gt,
  output wire         pipe_tx2_data_valid_gt,
  output wire         pipe_tx3_data_valid_gt,
  output wire         pipe_tx4_data_valid_gt,
  output wire         pipe_tx5_data_valid_gt,
  output wire         pipe_tx6_data_valid_gt,
  output wire         pipe_tx7_data_valid_gt,
  output wire         pipe_tx0_elec_idle_gt,
  output wire         pipe_tx1_elec_idle_gt,
  output wire         pipe_tx2_elec_idle_gt,
  output wire         pipe_tx3_elec_idle_gt,
  output wire         pipe_tx4_elec_idle_gt,
  output wire         pipe_tx5_elec_idle_gt,
  output wire         pipe_tx6_elec_idle_gt,
  output wire         pipe_tx7_elec_idle_gt,
  output wire         pipe_tx0_start_block_gt,
  output wire         pipe_tx1_start_block_gt,
  output wire         pipe_tx2_start_block_gt,
  output wire         pipe_tx3_start_block_gt,
  output wire         pipe_tx4_start_block_gt,
  output wire         pipe_tx5_start_block_gt,
  output wire         pipe_tx6_start_block_gt,
  output wire         pipe_tx7_start_block_gt,
  output wire         pipe_rx0_polarity_gt,
  output wire         pipe_rx1_polarity_gt,
  output wire         pipe_rx2_polarity_gt,
  output wire         pipe_rx3_polarity_gt,
  output wire         pipe_rx4_polarity_gt,
  output wire         pipe_rx5_polarity_gt,
  output wire         pipe_rx6_polarity_gt,
  output wire         pipe_rx7_polarity_gt,
  output wire   [1:0] pipe_rx0_eqcontrol_gt,
  output wire   [1:0] pipe_rx1_eqcontrol_gt,
  output wire   [1:0] pipe_rx2_eqcontrol_gt,
  output wire   [1:0] pipe_rx3_eqcontrol_gt,
  output wire   [1:0] pipe_rx4_eqcontrol_gt,
  output wire   [1:0] pipe_rx5_eqcontrol_gt,
  output wire   [1:0] pipe_rx6_eqcontrol_gt,
  output wire   [1:0] pipe_rx7_eqcontrol_gt,
  output wire   [1:0] pipe_tx0_char_is_k_gt,
  output wire   [1:0] pipe_tx1_char_is_k_gt,
  output wire   [1:0] pipe_tx2_char_is_k_gt,
  output wire   [1:0] pipe_tx3_char_is_k_gt,
  output wire   [1:0] pipe_tx4_char_is_k_gt,
  output wire   [1:0] pipe_tx5_char_is_k_gt,
  output wire   [1:0] pipe_tx6_char_is_k_gt,
  output wire   [1:0] pipe_tx7_char_is_k_gt,
  output wire   [1:0] pipe_tx0_eqcontrol_gt,
  output wire   [1:0] pipe_tx1_eqcontrol_gt,
  output wire   [1:0] pipe_tx2_eqcontrol_gt,
  output wire   [1:0] pipe_tx3_eqcontrol_gt,
  output wire   [1:0] pipe_tx4_eqcontrol_gt,
  output wire   [1:0] pipe_tx5_eqcontrol_gt,
  output wire   [1:0] pipe_tx6_eqcontrol_gt,
  output wire   [1:0] pipe_tx7_eqcontrol_gt,
  output wire   [1:0] pipe_tx0_powerdown_gt,
  output wire   [1:0] pipe_tx1_powerdown_gt,
  output wire   [1:0] pipe_tx2_powerdown_gt,
  output wire   [1:0] pipe_tx3_powerdown_gt,
  output wire   [1:0] pipe_tx4_powerdown_gt,
  output wire   [1:0] pipe_tx5_powerdown_gt,
  output wire   [1:0] pipe_tx6_powerdown_gt,
  output wire   [1:0] pipe_tx7_powerdown_gt,
  output wire   [1:0] pipe_tx0_syncheader_gt,
  output wire   [1:0] pipe_tx1_syncheader_gt,
  output wire   [1:0] pipe_tx2_syncheader_gt,
  output wire   [1:0] pipe_tx3_syncheader_gt,
  output wire   [1:0] pipe_tx4_syncheader_gt,
  output wire   [1:0] pipe_tx5_syncheader_gt,
  output wire   [1:0] pipe_tx6_syncheader_gt,
  output wire   [1:0] pipe_tx7_syncheader_gt,
  output wire   [2:0] pipe_rx0_eqpreset_gt,
  output wire   [2:0] pipe_rx1_eqpreset_gt,
  output wire   [2:0] pipe_rx2_eqpreset_gt,
  output wire   [2:0] pipe_rx3_eqpreset_gt,
  output wire   [2:0] pipe_rx4_eqpreset_gt,
  output wire   [2:0] pipe_rx5_eqpreset_gt,
  output wire   [2:0] pipe_rx6_eqpreset_gt,
  output wire   [2:0] pipe_rx7_eqpreset_gt,
  output wire  [31:0] pipe_tx0_data_gt,
  output wire  [31:0] pipe_tx1_data_gt,
  output wire  [31:0] pipe_tx2_data_gt,
  output wire  [31:0] pipe_tx3_data_gt,
  output wire  [31:0] pipe_tx4_data_gt,
  output wire  [31:0] pipe_tx5_data_gt,
  output wire  [31:0] pipe_tx6_data_gt,
  output wire  [31:0] pipe_tx7_data_gt,
  output wire   [3:0] pipe_rx0_eqlp_txpreset_gt,
  output wire   [3:0] pipe_rx1_eqlp_txpreset_gt,
  output wire   [3:0] pipe_rx2_eqlp_txpreset_gt,
  output wire   [3:0] pipe_rx3_eqlp_txpreset_gt,
  output wire   [3:0] pipe_rx4_eqlp_txpreset_gt,
  output wire   [3:0] pipe_rx5_eqlp_txpreset_gt,
  output wire   [3:0] pipe_rx6_eqlp_txpreset_gt,
  output wire   [3:0] pipe_rx7_eqlp_txpreset_gt,
  output wire   [3:0] pipe_tx0_eqpreset_gt,
  output wire   [3:0] pipe_tx1_eqpreset_gt,
  output wire   [3:0] pipe_tx2_eqpreset_gt,
  output wire   [3:0] pipe_tx3_eqpreset_gt,
  output wire   [3:0] pipe_tx4_eqpreset_gt,
  output wire   [3:0] pipe_tx5_eqpreset_gt,
  output wire   [3:0] pipe_tx6_eqpreset_gt,
  output wire   [3:0] pipe_tx7_eqpreset_gt,
  output wire   [5:0] pipe_rx0_eqlp_lffs_gt,
  output wire   [5:0] pipe_rx1_eqlp_lffs_gt,
  output wire   [5:0] pipe_rx2_eqlp_lffs_gt,
  output wire   [5:0] pipe_rx3_eqlp_lffs_gt,
  output wire   [5:0] pipe_rx4_eqlp_lffs_gt,
  output wire   [5:0] pipe_rx5_eqlp_lffs_gt,
  output wire   [5:0] pipe_rx6_eqlp_lffs_gt,
  output wire   [5:0] pipe_rx7_eqlp_lffs_gt,
  output wire   [5:0] pipe_tx0_eqdeemph_gt,
  output wire   [5:0] pipe_tx1_eqdeemph_gt,
  output wire   [5:0] pipe_tx2_eqdeemph_gt,
  output wire   [5:0] pipe_tx3_eqdeemph_gt,
  output wire   [5:0] pipe_tx4_eqdeemph_gt,
  output wire   [5:0] pipe_tx5_eqdeemph_gt,
  output wire   [5:0] pipe_tx6_eqdeemph_gt,
  output wire   [5:0] pipe_tx7_eqdeemph_gt,
  input  wire         pipe_rx0_data_valid_gt,
  input  wire         pipe_rx1_data_valid_gt,
  input  wire         pipe_rx2_data_valid_gt,
  input  wire         pipe_rx3_data_valid_gt,
  input  wire         pipe_rx4_data_valid_gt,
  input  wire         pipe_rx5_data_valid_gt,
  input  wire         pipe_rx6_data_valid_gt,
  input  wire         pipe_rx7_data_valid_gt,
  input  wire         pipe_rx0_elec_idle_gt,
  input  wire         pipe_rx1_elec_idle_gt,
  input  wire         pipe_rx2_elec_idle_gt,
  input  wire         pipe_rx3_elec_idle_gt,
  input  wire         pipe_rx4_elec_idle_gt,
  input  wire         pipe_rx5_elec_idle_gt,
  input  wire         pipe_rx6_elec_idle_gt,
  input  wire         pipe_rx7_elec_idle_gt,
  input  wire         pipe_rx0_eqdone_gt,
  input  wire         pipe_rx1_eqdone_gt,
  input  wire         pipe_rx2_eqdone_gt,
  input  wire         pipe_rx3_eqdone_gt,
  input  wire         pipe_rx4_eqdone_gt,
  input  wire         pipe_rx5_eqdone_gt,
  input  wire         pipe_rx6_eqdone_gt,
  input  wire         pipe_rx7_eqdone_gt,
  input  wire         pipe_rx0_eqlp_adaptdone_gt,
  input  wire         pipe_rx1_eqlp_adaptdone_gt,
  input  wire         pipe_rx2_eqlp_adaptdone_gt,
  input  wire         pipe_rx3_eqlp_adaptdone_gt,
  input  wire         pipe_rx4_eqlp_adaptdone_gt,
  input  wire         pipe_rx5_eqlp_adaptdone_gt,
  input  wire         pipe_rx6_eqlp_adaptdone_gt,
  input  wire         pipe_rx7_eqlp_adaptdone_gt,
  input  wire         pipe_rx0_eqlp_lffs_sel_gt,
  input  wire         pipe_rx1_eqlp_lffs_sel_gt,
  input  wire         pipe_rx2_eqlp_lffs_sel_gt,
  input  wire         pipe_rx3_eqlp_lffs_sel_gt,
  input  wire         pipe_rx4_eqlp_lffs_sel_gt,
  input  wire         pipe_rx5_eqlp_lffs_sel_gt,
  input  wire         pipe_rx6_eqlp_lffs_sel_gt,
  input  wire         pipe_rx7_eqlp_lffs_sel_gt,
  input  wire         pipe_rx0_phy_status_gt,
  input  wire         pipe_rx1_phy_status_gt,
  input  wire         pipe_rx2_phy_status_gt,
  input  wire         pipe_rx3_phy_status_gt,
  input  wire         pipe_rx4_phy_status_gt,
  input  wire         pipe_rx5_phy_status_gt,
  input  wire         pipe_rx6_phy_status_gt,
  input  wire         pipe_rx7_phy_status_gt,
  input  wire         pipe_rx0_start_block_gt,
  input  wire         pipe_rx1_start_block_gt,
  input  wire         pipe_rx2_start_block_gt,
  input  wire         pipe_rx3_start_block_gt,
  input  wire         pipe_rx4_start_block_gt,
  input  wire         pipe_rx5_start_block_gt,
  input  wire         pipe_rx6_start_block_gt,
  input  wire         pipe_rx7_start_block_gt,
  input  wire         pipe_rx0_valid_gt,
  input  wire         pipe_rx1_valid_gt,
  input  wire         pipe_rx2_valid_gt,
  input  wire         pipe_rx3_valid_gt,
  input  wire         pipe_rx4_valid_gt,
  input  wire         pipe_rx5_valid_gt,
  input  wire         pipe_rx6_valid_gt,
  input  wire         pipe_rx7_valid_gt,
  input  wire         pipe_tx0_eqdone_gt,
  input  wire         pipe_tx1_eqdone_gt,
  input  wire         pipe_tx2_eqdone_gt,
  input  wire         pipe_tx3_eqdone_gt,
  input  wire         pipe_tx4_eqdone_gt,
  input  wire         pipe_tx5_eqdone_gt,
  input  wire         pipe_tx6_eqdone_gt,
  input  wire         pipe_tx7_eqdone_gt,
  input  wire  [17:0] pipe_rx0_eqlp_new_txcoef_forpreset_gt,
  input  wire  [17:0] pipe_rx1_eqlp_new_txcoef_forpreset_gt,
  input  wire  [17:0] pipe_rx2_eqlp_new_txcoef_forpreset_gt,
  input  wire  [17:0] pipe_rx3_eqlp_new_txcoef_forpreset_gt,
  input  wire  [17:0] pipe_rx4_eqlp_new_txcoef_forpreset_gt,
  input  wire  [17:0] pipe_rx5_eqlp_new_txcoef_forpreset_gt,
  input  wire  [17:0] pipe_rx6_eqlp_new_txcoef_forpreset_gt,
  input  wire  [17:0] pipe_rx7_eqlp_new_txcoef_forpreset_gt,
  input  wire  [17:0] pipe_tx0_eqcoeff_gt,
  input  wire  [17:0] pipe_tx1_eqcoeff_gt,
  input  wire  [17:0] pipe_tx2_eqcoeff_gt,
  input  wire  [17:0] pipe_tx3_eqcoeff_gt,
  input  wire  [17:0] pipe_tx4_eqcoeff_gt,
  input  wire  [17:0] pipe_tx5_eqcoeff_gt,
  input  wire  [17:0] pipe_tx6_eqcoeff_gt,
  input  wire  [17:0] pipe_tx7_eqcoeff_gt,
  input  wire   [1:0] pipe_rx0_char_is_k_gt,
  input  wire   [1:0] pipe_rx1_char_is_k_gt,
  input  wire   [1:0] pipe_rx2_char_is_k_gt,
  input  wire   [1:0] pipe_rx3_char_is_k_gt,
  input  wire   [1:0] pipe_rx4_char_is_k_gt,
  input  wire   [1:0] pipe_rx5_char_is_k_gt,
  input  wire   [1:0] pipe_rx6_char_is_k_gt,
  input  wire   [1:0] pipe_rx7_char_is_k_gt,
  input  wire   [1:0] pipe_rx0_syncheader_gt,
  input  wire   [1:0] pipe_rx1_syncheader_gt,
  input  wire   [1:0] pipe_rx2_syncheader_gt,
  input  wire   [1:0] pipe_rx3_syncheader_gt,
  input  wire   [1:0] pipe_rx4_syncheader_gt,
  input  wire   [1:0] pipe_rx5_syncheader_gt,
  input  wire   [1:0] pipe_rx6_syncheader_gt,
  input  wire   [1:0] pipe_rx7_syncheader_gt,
  input  wire   [2:0] pipe_rx0_status_gt,
  input  wire   [2:0] pipe_rx1_status_gt,
  input  wire   [2:0] pipe_rx2_status_gt,
  input  wire   [2:0] pipe_rx3_status_gt,
  input  wire   [2:0] pipe_rx4_status_gt,
  input  wire   [2:0] pipe_rx5_status_gt,
  input  wire   [2:0] pipe_rx6_status_gt,
  input  wire   [2:0] pipe_rx7_status_gt,
  input  wire  [31:0] pipe_rx0_data_gt,
  input  wire  [31:0] pipe_rx1_data_gt,
  input  wire  [31:0] pipe_rx2_data_gt,
  input  wire  [31:0] pipe_rx3_data_gt,
  input  wire  [31:0] pipe_rx4_data_gt,
  input  wire  [31:0] pipe_rx5_data_gt,
  input  wire  [31:0] pipe_rx6_data_gt,
  input  wire  [31:0] pipe_rx7_data_gt
  );

  wire                pipe_tx0_rcvr_det;
  wire                pipe_tx0_reset;
  wire          [1:0] pipe_tx0_rate;
  wire                pipe_tx0_deemph;
  wire          [2:0] pipe_tx0_margin;
  wire                pipe_tx0_swing;
  wire          [5:0] pipe_tx_eqfs;
  wire          [5:0] pipe_tx_eqlf;
  wire          [1:0] pipe_rx0_char_is_k;
  wire         [31:0] pipe_rx0_data;
  wire                pipe_rx0_valid;
  wire                pipe_rx0_data_valid;
  wire          [2:0] pipe_rx0_status;
  wire                pipe_rx0_phy_status;
  wire                pipe_rx0_elec_idle;
  wire                pipe_rx0_eqdone;
  wire                pipe_rx0_eqlp_adaptdone;
  wire                pipe_rx0_eqlp_lffs_sel;
  wire          [3:0] pipe_rx0_eqlp_txpreset;
  wire         [17:0] pipe_rx0_eqlp_new_txcoef_forpreset;
  wire                pipe_rx0_start_block;
  wire          [1:0] pipe_rx0_syncheader;
  wire                pipe_rx0_polarity;
  wire          [1:0] pipe_rx0_eqcontrol;
  wire          [5:0] pipe_rx0_eqlp_lffs;
  wire          [2:0] pipe_rx0_eqpreset;
  wire         [17:0] pipe_tx0_eqcoeff;
  wire                pipe_tx0_eqdone;
  wire                pipe_tx0_compliance;
  wire          [1:0] pipe_tx0_char_is_k;
  wire         [31:0] pipe_tx0_data;
  wire                pipe_tx0_elec_idle;
  wire          [1:0] pipe_tx0_powerdown;
  wire                pipe_tx0_data_valid;
  wire                pipe_tx0_start_block;
  wire          [1:0] pipe_tx0_syncheader;
  wire          [1:0] pipe_tx0_eqcontrol;
  wire          [5:0] pipe_tx0_eqdeemph;
  wire          [3:0] pipe_tx0_eqpreset;
  wire          [1:0] pipe_rx1_char_is_k;
  wire         [31:0] pipe_rx1_data;
  wire                pipe_rx1_valid;
  wire                pipe_rx1_data_valid;
  wire          [2:0] pipe_rx1_status;
  wire                pipe_rx1_phy_status;
  wire                pipe_rx1_elec_idle;
  wire                pipe_rx1_eqdone;
  wire                pipe_rx1_eqlp_adaptdone;
  wire                pipe_rx1_eqlp_lffs_sel;
  wire          [3:0] pipe_rx1_eqlp_txpreset;
  wire         [17:0] pipe_rx1_eqlp_new_txcoef_forpreset;
  wire                pipe_rx1_start_block;
  wire          [1:0] pipe_rx1_syncheader;
  wire                pipe_rx1_polarity;
  wire          [1:0] pipe_rx1_eqcontrol;
  wire          [5:0] pipe_rx1_eqlp_lffs;
  wire          [2:0] pipe_rx1_eqpreset;
  wire         [17:0] pipe_tx1_eqcoeff;
  wire                pipe_tx1_eqdone;
  wire                pipe_tx1_compliance;
  wire          [1:0] pipe_tx1_char_is_k;
  wire         [31:0] pipe_tx1_data;
  wire                pipe_tx1_elec_idle;
  wire          [1:0] pipe_tx1_powerdown;
  wire                pipe_tx1_data_valid;
  wire                pipe_tx1_start_block;
  wire          [1:0] pipe_tx1_syncheader;
  wire          [1:0] pipe_tx1_eqcontrol;
  wire          [5:0] pipe_tx1_eqdeemph;
  wire          [3:0] pipe_tx1_eqpreset;
  wire          [1:0] pipe_rx2_char_is_k;
  wire         [31:0] pipe_rx2_data;
  wire                pipe_rx2_valid;
  wire                pipe_rx2_data_valid;
  wire          [2:0] pipe_rx2_status;
  wire                pipe_rx2_phy_status;
  wire                pipe_rx2_elec_idle;
  wire                pipe_rx2_eqdone;
  wire                pipe_rx2_eqlp_adaptdone;
  wire                pipe_rx2_eqlp_lffs_sel;
  wire          [3:0] pipe_rx2_eqlp_txpreset;
  wire         [17:0] pipe_rx2_eqlp_new_txcoef_forpreset;
  wire                pipe_rx2_start_block;
  wire          [1:0] pipe_rx2_syncheader;
  wire                pipe_rx2_polarity;
  wire          [1:0] pipe_rx2_eqcontrol;
  wire          [5:0] pipe_rx2_eqlp_lffs;
  wire          [2:0] pipe_rx2_eqpreset;
  wire         [17:0] pipe_tx2_eqcoeff;
  wire                pipe_tx2_eqdone;
  wire                pipe_tx2_compliance;
  wire          [1:0] pipe_tx2_char_is_k;
  wire         [31:0] pipe_tx2_data;
  wire                pipe_tx2_elec_idle;
  wire          [1:0] pipe_tx2_powerdown;
  wire                pipe_tx2_data_valid;
  wire                pipe_tx2_start_block;
  wire          [1:0] pipe_tx2_syncheader;
  wire          [1:0] pipe_tx2_eqcontrol;
  wire          [5:0] pipe_tx2_eqdeemph;
  wire          [3:0] pipe_tx2_eqpreset;
  wire          [1:0] pipe_rx3_char_is_k;
  wire         [31:0] pipe_rx3_data;
  wire                pipe_rx3_valid;
  wire                pipe_rx3_data_valid;
  wire          [2:0] pipe_rx3_status;
  wire                pipe_rx3_phy_status;
  wire                pipe_rx3_elec_idle;
  wire                pipe_rx3_eqdone;
  wire                pipe_rx3_eqlp_adaptdone;
  wire                pipe_rx3_eqlp_lffs_sel;
  wire          [3:0] pipe_rx3_eqlp_txpreset;
  wire         [17:0] pipe_rx3_eqlp_new_txcoef_forpreset;
  wire                pipe_rx3_start_block;
  wire          [1:0] pipe_rx3_syncheader;
  wire                pipe_rx3_polarity;
  wire          [1:0] pipe_rx3_eqcontrol;
  wire          [5:0] pipe_rx3_eqlp_lffs;
  wire          [2:0] pipe_rx3_eqpreset;
  wire         [17:0] pipe_tx3_eqcoeff;
  wire                pipe_tx3_eqdone;
  wire                pipe_tx3_compliance;
  wire          [1:0] pipe_tx3_char_is_k;
  wire         [31:0] pipe_tx3_data;
  wire                pipe_tx3_elec_idle;
  wire          [1:0] pipe_tx3_powerdown;
  wire                pipe_tx3_data_valid;
  wire                pipe_tx3_start_block;
  wire          [1:0] pipe_tx3_syncheader;
  wire          [1:0] pipe_tx3_eqcontrol;
  wire          [5:0] pipe_tx3_eqdeemph;
  wire          [3:0] pipe_tx3_eqpreset;
  wire          [1:0] pipe_rx4_char_is_k;
  wire         [31:0] pipe_rx4_data;
  wire                pipe_rx4_valid;
  wire                pipe_rx4_data_valid;
  wire          [2:0] pipe_rx4_status;
  wire                pipe_rx4_phy_status;
  wire                pipe_rx4_elec_idle;
  wire                pipe_rx4_eqdone;
  wire                pipe_rx4_eqlp_adaptdone;
  wire                pipe_rx4_eqlp_lffs_sel;
  wire          [3:0] pipe_rx4_eqlp_txpreset;
  wire         [17:0] pipe_rx4_eqlp_new_txcoef_forpreset;
  wire                pipe_rx4_start_block;
  wire          [1:0] pipe_rx4_syncheader;
  wire                pipe_rx4_polarity;
  wire          [1:0] pipe_rx4_eqcontrol;
  wire          [5:0] pipe_rx4_eqlp_lffs;
  wire          [2:0] pipe_rx4_eqpreset;
  wire         [17:0] pipe_tx4_eqcoeff;
  wire                pipe_tx4_eqdone;
  wire                pipe_tx4_compliance;
  wire          [1:0] pipe_tx4_char_is_k;
  wire         [31:0] pipe_tx4_data;
  wire                pipe_tx4_elec_idle;
  wire          [1:0] pipe_tx4_powerdown;
  wire                pipe_tx4_data_valid;
  wire                pipe_tx4_start_block;
  wire          [1:0] pipe_tx4_syncheader;
  wire          [1:0] pipe_tx4_eqcontrol;
  wire          [5:0] pipe_tx4_eqdeemph;
  wire          [3:0] pipe_tx4_eqpreset;
  wire          [1:0] pipe_rx5_char_is_k;
  wire         [31:0] pipe_rx5_data;
  wire                pipe_rx5_valid;
  wire                pipe_rx5_data_valid;
  wire          [2:0] pipe_rx5_status;
  wire                pipe_rx5_phy_status;
  wire                pipe_rx5_elec_idle;
  wire                pipe_rx5_eqdone;
  wire                pipe_rx5_eqlp_adaptdone;
  wire                pipe_rx5_eqlp_lffs_sel;
  wire          [3:0] pipe_rx5_eqlp_txpreset;
  wire         [17:0] pipe_rx5_eqlp_new_txcoef_forpreset;
  wire                pipe_rx5_start_block;
  wire          [1:0] pipe_rx5_syncheader;
  wire                pipe_rx5_polarity;
  wire          [1:0] pipe_rx5_eqcontrol;
  wire          [5:0] pipe_rx5_eqlp_lffs;
  wire          [2:0] pipe_rx5_eqpreset;
  wire         [17:0] pipe_tx5_eqcoeff;
  wire                pipe_tx5_eqdone;
  wire                pipe_tx5_compliance;
  wire          [1:0] pipe_tx5_char_is_k;
  wire         [31:0] pipe_tx5_data;
  wire                pipe_tx5_elec_idle;
  wire          [1:0] pipe_tx5_powerdown;
  wire                pipe_tx5_data_valid;
  wire                pipe_tx5_start_block;
  wire          [1:0] pipe_tx5_syncheader;
  wire          [1:0] pipe_tx5_eqcontrol;
  wire          [5:0] pipe_tx5_eqdeemph;
  wire          [3:0] pipe_tx5_eqpreset;
  wire          [1:0] pipe_rx6_char_is_k;
  wire         [31:0] pipe_rx6_data;
  wire                pipe_rx6_valid;
  wire                pipe_rx6_data_valid;
  wire          [2:0] pipe_rx6_status;
  wire                pipe_rx6_phy_status;
  wire                pipe_rx6_elec_idle;
  wire                pipe_rx6_eqdone;
  wire                pipe_rx6_eqlp_adaptdone;
  wire                pipe_rx6_eqlp_lffs_sel;
  wire          [3:0] pipe_rx6_eqlp_txpreset;
  wire         [17:0] pipe_rx6_eqlp_new_txcoef_forpreset;
  wire                pipe_rx6_start_block;
  wire          [1:0] pipe_rx6_syncheader;
  wire                pipe_rx6_polarity;
  wire          [1:0] pipe_rx6_eqcontrol;
  wire          [5:0] pipe_rx6_eqlp_lffs;
  wire          [2:0] pipe_rx6_eqpreset;
  wire         [17:0] pipe_tx6_eqcoeff;
  wire                pipe_tx6_eqdone;
  wire                pipe_tx6_compliance;
  wire          [1:0] pipe_tx6_char_is_k;
  wire         [31:0] pipe_tx6_data;
  wire                pipe_tx6_elec_idle;
  wire          [1:0] pipe_tx6_powerdown;
  wire                pipe_tx6_data_valid;
  wire                pipe_tx6_start_block;
  wire          [1:0] pipe_tx6_syncheader;
  wire          [1:0] pipe_tx6_eqcontrol;
  wire          [5:0] pipe_tx6_eqdeemph;
  wire          [3:0] pipe_tx6_eqpreset;
  wire          [1:0] pipe_rx7_char_is_k;
  wire         [31:0] pipe_rx7_data;
  wire                pipe_rx7_valid;
  wire                pipe_rx7_data_valid;
  wire          [2:0] pipe_rx7_status;
  wire                pipe_rx7_phy_status;
  wire                pipe_rx7_elec_idle;
  wire                pipe_rx7_eqdone;
  wire                pipe_rx7_eqlp_adaptdone;
  wire                pipe_rx7_eqlp_lffs_sel;
  wire          [3:0] pipe_rx7_eqlp_txpreset;
  wire         [17:0] pipe_rx7_eqlp_new_txcoef_forpreset;
  wire                pipe_rx7_start_block;
  wire          [1:0] pipe_rx7_syncheader;
  wire                pipe_rx7_polarity;
  wire          [1:0] pipe_rx7_eqcontrol;
  wire          [5:0] pipe_rx7_eqlp_lffs;
  wire          [2:0] pipe_rx7_eqpreset;
  wire         [17:0] pipe_tx7_eqcoeff;
  wire                pipe_tx7_eqdone;
  wire                pipe_tx7_compliance;
  wire          [1:0] pipe_tx7_char_is_k;
  wire         [31:0] pipe_tx7_data;
  wire                pipe_tx7_elec_idle;
  wire          [1:0] pipe_tx7_powerdown;
  wire                pipe_tx7_data_valid;
  wire                pipe_tx7_start_block;
  wire          [1:0] pipe_tx7_syncheader;
  wire          [1:0] pipe_tx7_eqcontrol;
  wire          [5:0] pipe_tx7_eqdeemph;
  wire          [3:0] pipe_tx7_eqpreset;
  wire                reset_n;
  wire                pipe_reset_n;
  wire                mgmt_reset_n;
  wire                mgmt_sticky_reset_n;
  wire          [4:0] cfg_tph_stt_address;
  wire          [3:0] cfg_tph_function_num;
  wire         [31:0] cfg_tph_stt_write_data;
  wire                cfg_tph_stt_write_enable;
  wire          [3:0] cfg_tph_stt_write_byte_valid;
  wire         [31:0] cfg_tph_stt_read_data;
  wire                cfg_tph_stt_read_enable;
  wire                cfg_tph_stt_read_data_valid;

  wire  [255:0] s_axis_cc_tdata_i; 
  wire  [255:0] s_axis_rq_tdata_i;
  wire  [255:0] m_axis_cq_tdata_i;
  wire  [255:0] m_axis_rc_tdata_i;
  wire  [7:0]   s_axis_cc_tkeep_i;
  wire  [7:0]   s_axis_rq_tkeep_i;
  wire  [7:0]   m_axis_cq_tkeep_i;
  wire  [7:0]   m_axis_rc_tkeep_i;

  generate
if (PL_UPSTREAM_FACING == "TRUE") begin : axis_mapping_ep
assign s_axis_cc_tdata_i = s_axis_cc_tdata; // I
assign s_axis_rq_tdata_i = s_axis_rq_tdata; // I
assign s_axis_cc_tkeep_i = s_axis_cc_tkeep; // I
assign s_axis_rq_tkeep_i = s_axis_rq_tkeep; // I
assign m_axis_cq_tdata = m_axis_cq_tdata_i; // O
assign m_axis_rc_tdata = m_axis_rc_tdata_i; // O
assign m_axis_cq_tkeep = m_axis_cq_tkeep_i; // O
assign m_axis_rc_tkeep = m_axis_rc_tkeep_i; // O
end // axis_mapping_ep
  endgenerate

  generate
if (PL_UPSTREAM_FACING == "FALSE") begin : axis_mapping_rp
assign s_axis_cc_tdata_i = s_axis_cc_tdata; // I
assign s_axis_rq_tdata_i = s_axis_rq_tdata; // I
assign s_axis_cc_tkeep_i = s_axis_cc_tkeep; // I
assign s_axis_rq_tkeep_i = s_axis_rq_tkeep; // I
assign m_axis_cq_tdata = m_axis_cq_tdata_i; // O
assign m_axis_rc_tdata = m_axis_rc_tdata_i; // O
assign m_axis_cq_tkeep = m_axis_cq_tkeep_i; // O
assign m_axis_rc_tkeep = m_axis_rc_tkeep_i; // O
end // axis_mapping_rp
  endgenerate

  rp_init_ctrl #(
    .TCQ (TCQ),
    .PL_UPSTREAM_FACING(PL_UPSTREAM_FACING))
  init_ctrl_inst (
    .clk_i                 (user_clk),
    .reset_n_o             (reset_n),
    .pipe_reset_n_o        (pipe_reset_n),
    .mgmt_reset_n_o        (mgmt_reset_n),
    .mgmt_sticky_reset_n_o (mgmt_sticky_reset_n),
    .phy_rdy_i             (phy_rdy),
    .state_o               ()
  );

  rp_tph_tbl #(
    .TCQ (TCQ))
  tph_tbl_inst (
    .user_clk (user_clk),
    .reset_n (reset_n),
    .cfg_tph_stt_address_i (cfg_tph_stt_address),
    .cfg_tph_function_num_i (cfg_tph_function_num),
    .cfg_tph_stt_write_data_i (cfg_tph_stt_write_data),
    .cfg_tph_stt_write_enable_i (cfg_tph_stt_write_enable),
    .cfg_tph_stt_write_byte_valid_i (cfg_tph_stt_write_byte_valid),
    .cfg_tph_stt_read_data_o (cfg_tph_stt_read_data),
    .cfg_tph_stt_read_enable_i (cfg_tph_stt_read_enable),
    .cfg_tph_stt_read_data_valid_o (cfg_tph_stt_read_data_valid),
    .user_tph_stt_address_i (user_tph_stt_address),
    .user_tph_function_num_i (user_tph_function_num),
    .user_tph_stt_read_data_o (user_tph_stt_read_data),
    .user_tph_stt_read_data_valid_o (user_tph_stt_read_data_valid),
    .user_tph_stt_read_enable_i (user_tph_stt_read_enable)
  );

  rp_pipe_pipeline 
 #(
    .TCQ (TCQ),
    .PL_LINK_CAP_MAX_LINK_WIDTH (PL_LINK_CAP_MAX_LINK_WIDTH),
    .PIPE_PIPELINE_STAGES (PIPE_PIPELINE_STAGES))
  pipe_pipeline_inst (
    .rst_n                               (reset_n),
    .pipe_clk                            (pipe_clk),
    .pipe_tx_rcvr_det_i                  (pipe_tx0_rcvr_det),
    .pipe_tx_reset_i                     (pipe_tx0_reset),
    .pipe_tx_rate_i                      (pipe_tx0_rate),
    .pipe_tx_deemph_i                    (pipe_tx0_deemph),
    .pipe_tx_margin_i                    (pipe_tx0_margin),
    .pipe_tx_swing_i                     (pipe_tx0_swing),
    .pipe_tx_eqfs_i (pipe_tx_eqfs_gt),
    .pipe_tx_eqlf_i (pipe_tx_eqlf_gt),
    .pipe_tx_rcvr_det_o                  (pipe_tx0_rcvr_det_gt),
    .pipe_tx_reset_o                     (pipe_tx0_reset_gt),
    .pipe_tx_rate_o                      (pipe_tx0_rate_gt),
    .pipe_tx_deemph_o                    (pipe_tx0_deemph_gt),
    .pipe_tx_margin_o                    (pipe_tx0_margin_gt),
    .pipe_tx_swing_o                     (pipe_tx0_swing_gt),
    .pipe_tx_eqfs_o (pipe_tx_eqfs),
    .pipe_tx_eqlf_o (pipe_tx_eqlf),
    .pipe_rx0_char_is_k_o (pipe_rx0_char_is_k),
    .pipe_rx0_data_o (pipe_rx0_data),
    .pipe_rx0_valid_o (pipe_rx0_valid),
    .pipe_rx0_data_valid_o (pipe_rx0_data_valid),
    .pipe_rx0_status_o (pipe_rx0_status),
    .pipe_rx0_phy_status_o (pipe_rx0_phy_status),
    .pipe_rx0_elec_idle_o (pipe_rx0_elec_idle),
    .pipe_rx0_eqdone_o (pipe_rx0_eqdone),
    .pipe_rx0_eqlpadaptdone_o (pipe_rx0_eqlp_adaptdone),
    .pipe_rx0_eqlplffssel_o (pipe_rx0_eqlp_lffs_sel),
    .pipe_rx0_eqlpnewtxcoefforpreset_o (pipe_rx0_eqlp_new_txcoef_forpreset),
    .pipe_rx0_startblock_o (pipe_rx0_start_block),
    .pipe_rx0_syncheader_o (pipe_rx0_syncheader),
    .pipe_rx0_polarity_i (pipe_rx0_polarity),
    .pipe_rx0_eqcontrol_i (pipe_rx0_eqcontrol),
    .pipe_rx0_eqlplffs_i (pipe_rx0_eqlp_lffs),
    .pipe_rx0_eqlptxpreset_i (pipe_rx0_eqlp_txpreset),
    .pipe_rx0_eqpreset_i (pipe_rx0_eqpreset),
    .pipe_tx0_eqcoeff_o (pipe_tx0_eqcoeff),
    .pipe_tx0_eqdone_o (pipe_tx0_eqdone),
    .pipe_tx0_compliance_i (pipe_tx0_compliance),
    .pipe_tx0_char_is_k_i (pipe_tx0_char_is_k),
    .pipe_tx0_data_i (pipe_tx0_data),
    .pipe_tx0_elec_idle_i (pipe_tx0_elec_idle),
    .pipe_tx0_powerdown_i (pipe_tx0_powerdown),
    .pipe_tx0_datavalid_i (pipe_tx0_data_valid),
    .pipe_tx0_startblock_i (pipe_tx0_start_block),
    .pipe_tx0_syncheader_i (pipe_tx0_syncheader),
    .pipe_tx0_eqcontrol_i (pipe_tx0_eqcontrol),
    .pipe_tx0_eqdeemph_i (pipe_tx0_eqdeemph),
    .pipe_tx0_eqpreset_i (pipe_tx0_eqpreset),
    .pipe_rx0_char_is_k_i (pipe_rx0_char_is_k_gt),
    .pipe_rx0_data_i (pipe_rx0_data_gt),
    .pipe_rx0_valid_i (pipe_rx0_valid_gt),
    .pipe_rx0_data_valid_i (pipe_rx0_data_valid_gt),
    .pipe_rx0_status_i (pipe_rx0_status_gt),
    .pipe_rx0_phy_status_i (pipe_rx0_phy_status_gt),
    .pipe_rx0_elec_idle_i (pipe_rx0_elec_idle_gt),
    .pipe_rx0_eqdone_i (pipe_rx0_eqdone_gt),
    .pipe_rx0_eqlpadaptdone_i (pipe_rx0_eqlp_adaptdone_gt),
    .pipe_rx0_eqlplffssel_i (pipe_rx0_eqlp_lffs_sel_gt),
    .pipe_rx0_eqlpnewtxcoefforpreset_i (pipe_rx0_eqlp_new_txcoef_forpreset_gt),
    .pipe_rx0_startblock_i (pipe_rx0_start_block_gt),
    .pipe_rx0_syncheader_i (pipe_rx0_syncheader_gt),
    .pipe_rx0_polarity_o (pipe_rx0_polarity_gt),
    .pipe_rx0_eqcontrol_o (pipe_rx0_eqcontrol_gt),
    .pipe_rx0_eqlplffs_o (pipe_rx0_eqlp_lffs_gt),
    .pipe_rx0_eqlptxpreset_o (pipe_rx0_eqlp_txpreset_gt),
    .pipe_rx0_eqpreset_o (pipe_rx0_eqpreset_gt),
    .pipe_tx0_eqcoeff_i (pipe_tx0_eqcoeff_gt),
    .pipe_tx0_eqdone_i (pipe_tx0_eqdone_gt),
    .pipe_tx0_compliance_o (pipe_tx0_compliance_gt),
    .pipe_tx0_char_is_k_o (pipe_tx0_char_is_k_gt),
    .pipe_tx0_data_o (pipe_tx0_data_gt),
    .pipe_tx0_elec_idle_o (pipe_tx0_elec_idle_gt),
    .pipe_tx0_powerdown_o (pipe_tx0_powerdown_gt),
    .pipe_tx0_datavalid_o (pipe_tx0_data_valid_gt),
    .pipe_tx0_startblock_o (pipe_tx0_start_block_gt),
    .pipe_tx0_syncheader_o (pipe_tx0_syncheader_gt),
    .pipe_tx0_eqcontrol_o (pipe_tx0_eqcontrol_gt),
    .pipe_tx0_eqdeemph_o (pipe_tx0_eqdeemph_gt),
    .pipe_tx0_eqpreset_o (pipe_tx0_eqpreset_gt),
    .pipe_rx1_char_is_k_o (pipe_rx1_char_is_k),
    .pipe_rx1_data_o (pipe_rx1_data),
    .pipe_rx1_valid_o (pipe_rx1_valid),
    .pipe_rx1_data_valid_o (pipe_rx1_data_valid),
    .pipe_rx1_status_o (pipe_rx1_status),
    .pipe_rx1_phy_status_o (pipe_rx1_phy_status),
    .pipe_rx1_elec_idle_o (pipe_rx1_elec_idle),
    .pipe_rx1_eqdone_o (pipe_rx1_eqdone),
    .pipe_rx1_eqlpadaptdone_o (pipe_rx1_eqlp_adaptdone),
    .pipe_rx1_eqlplffssel_o (pipe_rx1_eqlp_lffs_sel),
    .pipe_rx1_eqlpnewtxcoefforpreset_o (pipe_rx1_eqlp_new_txcoef_forpreset),
    .pipe_rx1_startblock_o (pipe_rx1_start_block),
    .pipe_rx1_syncheader_o (pipe_rx1_syncheader),
    .pipe_rx1_polarity_i (pipe_rx1_polarity),
    .pipe_rx1_eqcontrol_i (pipe_rx1_eqcontrol),
    .pipe_rx1_eqlplffs_i (pipe_rx1_eqlp_lffs),
    .pipe_rx1_eqlptxpreset_i (pipe_rx1_eqlp_txpreset),
    .pipe_rx1_eqpreset_i (pipe_rx1_eqpreset),
    .pipe_tx1_eqcoeff_o (pipe_tx1_eqcoeff),
    .pipe_tx1_eqdone_o (pipe_tx1_eqdone),
    .pipe_tx1_compliance_i (pipe_tx1_compliance),
    .pipe_tx1_char_is_k_i (pipe_tx1_char_is_k),
    .pipe_tx1_data_i (pipe_tx1_data),
    .pipe_tx1_elec_idle_i (pipe_tx1_elec_idle),
    .pipe_tx1_powerdown_i (pipe_tx1_powerdown),
    .pipe_tx1_datavalid_i (pipe_tx1_data_valid),
    .pipe_tx1_startblock_i (pipe_tx1_start_block),
    .pipe_tx1_syncheader_i (pipe_tx1_syncheader),
    .pipe_tx1_eqcontrol_i (pipe_tx1_eqcontrol),
    .pipe_tx1_eqdeemph_i (pipe_tx1_eqdeemph),
    .pipe_tx1_eqpreset_i (pipe_tx1_eqpreset),
    .pipe_rx1_char_is_k_i (pipe_rx1_char_is_k_gt),
    .pipe_rx1_data_i (pipe_rx1_data_gt),
    .pipe_rx1_valid_i (pipe_rx1_valid_gt),
    .pipe_rx1_data_valid_i (pipe_rx1_data_valid_gt),
    .pipe_rx1_status_i (pipe_rx1_status_gt),
    .pipe_rx1_phy_status_i (pipe_rx1_phy_status_gt),
    .pipe_rx1_elec_idle_i (pipe_rx1_elec_idle_gt),
    .pipe_rx1_eqdone_i (pipe_rx1_eqdone_gt),
    .pipe_rx1_eqlpadaptdone_i (pipe_rx1_eqlp_adaptdone_gt),
    .pipe_rx1_eqlplffssel_i (pipe_rx1_eqlp_lffs_sel_gt),
    .pipe_rx1_eqlpnewtxcoefforpreset_i (pipe_rx1_eqlp_new_txcoef_forpreset_gt),
    .pipe_rx1_startblock_i (pipe_rx1_start_block_gt),
    .pipe_rx1_syncheader_i (pipe_rx1_syncheader_gt),
    .pipe_rx1_polarity_o (pipe_rx1_polarity_gt),
    .pipe_rx1_eqcontrol_o (pipe_rx1_eqcontrol_gt),
    .pipe_rx1_eqlplffs_o (pipe_rx1_eqlp_lffs_gt),
    .pipe_rx1_eqlptxpreset_o (pipe_rx1_eqlp_txpreset_gt),
    .pipe_rx1_eqpreset_o (pipe_rx1_eqpreset_gt),
    .pipe_tx1_eqcoeff_i (pipe_tx1_eqcoeff_gt),
    .pipe_tx1_eqdone_i (pipe_tx1_eqdone_gt),
    .pipe_tx1_compliance_o (pipe_tx1_compliance_gt),
    .pipe_tx1_char_is_k_o (pipe_tx1_char_is_k_gt),
    .pipe_tx1_data_o (pipe_tx1_data_gt),
    .pipe_tx1_elec_idle_o (pipe_tx1_elec_idle_gt),
    .pipe_tx1_powerdown_o (pipe_tx1_powerdown_gt),
    .pipe_tx1_datavalid_o (pipe_tx1_data_valid_gt),
    .pipe_tx1_startblock_o (pipe_tx1_start_block_gt),
    .pipe_tx1_syncheader_o (pipe_tx1_syncheader_gt),
    .pipe_tx1_eqcontrol_o (pipe_tx1_eqcontrol_gt),
    .pipe_tx1_eqdeemph_o (pipe_tx1_eqdeemph_gt),
    .pipe_tx1_eqpreset_o (pipe_tx1_eqpreset_gt),
    .pipe_rx2_char_is_k_o (pipe_rx2_char_is_k),
    .pipe_rx2_data_o (pipe_rx2_data),
    .pipe_rx2_valid_o (pipe_rx2_valid),
    .pipe_rx2_data_valid_o (pipe_rx2_data_valid),
    .pipe_rx2_status_o (pipe_rx2_status),
    .pipe_rx2_phy_status_o (pipe_rx2_phy_status),
    .pipe_rx2_elec_idle_o (pipe_rx2_elec_idle),
    .pipe_rx2_eqdone_o (pipe_rx2_eqdone),
    .pipe_rx2_eqlpadaptdone_o (pipe_rx2_eqlp_adaptdone),
    .pipe_rx2_eqlplffssel_o (pipe_rx2_eqlp_lffs_sel),
    .pipe_rx2_eqlpnewtxcoefforpreset_o (pipe_rx2_eqlp_new_txcoef_forpreset),
    .pipe_rx2_startblock_o (pipe_rx2_start_block),
    .pipe_rx2_syncheader_o (pipe_rx2_syncheader),
    .pipe_rx2_polarity_i (pipe_rx2_polarity),
    .pipe_rx2_eqcontrol_i (pipe_rx2_eqcontrol),
    .pipe_rx2_eqlplffs_i (pipe_rx2_eqlp_lffs),
    .pipe_rx2_eqlptxpreset_i (pipe_rx2_eqlp_txpreset),
    .pipe_rx2_eqpreset_i (pipe_rx2_eqpreset),
    .pipe_tx2_eqcoeff_o (pipe_tx2_eqcoeff),
    .pipe_tx2_eqdone_o (pipe_tx2_eqdone),
    .pipe_tx2_compliance_i (pipe_tx2_compliance),
    .pipe_tx2_char_is_k_i (pipe_tx2_char_is_k),
    .pipe_tx2_data_i (pipe_tx2_data),
    .pipe_tx2_elec_idle_i (pipe_tx2_elec_idle),
    .pipe_tx2_powerdown_i (pipe_tx2_powerdown),
    .pipe_tx2_datavalid_i (pipe_tx2_data_valid),
    .pipe_tx2_startblock_i (pipe_tx2_start_block),
    .pipe_tx2_syncheader_i (pipe_tx2_syncheader),
    .pipe_tx2_eqcontrol_i (pipe_tx2_eqcontrol),
    .pipe_tx2_eqdeemph_i (pipe_tx2_eqdeemph),
    .pipe_tx2_eqpreset_i (pipe_tx2_eqpreset),
    .pipe_rx2_char_is_k_i (pipe_rx2_char_is_k_gt),
    .pipe_rx2_data_i (pipe_rx2_data_gt),
    .pipe_rx2_valid_i (pipe_rx2_valid_gt),
    .pipe_rx2_data_valid_i (pipe_rx2_data_valid_gt),
    .pipe_rx2_status_i (pipe_rx2_status_gt),
    .pipe_rx2_phy_status_i (pipe_rx2_phy_status_gt),
    .pipe_rx2_elec_idle_i (pipe_rx2_elec_idle_gt),
    .pipe_rx2_eqdone_i (pipe_rx2_eqdone_gt),
    .pipe_rx2_eqlpadaptdone_i (pipe_rx2_eqlp_adaptdone_gt),
    .pipe_rx2_eqlplffssel_i (pipe_rx2_eqlp_lffs_sel_gt),
    .pipe_rx2_eqlpnewtxcoefforpreset_i (pipe_rx2_eqlp_new_txcoef_forpreset_gt),
    .pipe_rx2_startblock_i (pipe_rx2_start_block_gt),
    .pipe_rx2_syncheader_i (pipe_rx2_syncheader_gt),
    .pipe_rx2_polarity_o (pipe_rx2_polarity_gt),
    .pipe_rx2_eqcontrol_o (pipe_rx2_eqcontrol_gt),
    .pipe_rx2_eqlplffs_o (pipe_rx2_eqlp_lffs_gt),
    .pipe_rx2_eqlptxpreset_o (pipe_rx2_eqlp_txpreset_gt),
    .pipe_rx2_eqpreset_o (pipe_rx2_eqpreset_gt),
    .pipe_tx2_eqcoeff_i (pipe_tx2_eqcoeff_gt),
    .pipe_tx2_eqdone_i (pipe_tx2_eqdone_gt),
    .pipe_tx2_compliance_o (pipe_tx2_compliance_gt),
    .pipe_tx2_char_is_k_o (pipe_tx2_char_is_k_gt),
    .pipe_tx2_data_o (pipe_tx2_data_gt),
    .pipe_tx2_elec_idle_o (pipe_tx2_elec_idle_gt),
    .pipe_tx2_powerdown_o (pipe_tx2_powerdown_gt),
    .pipe_tx2_datavalid_o (pipe_tx2_data_valid_gt),
    .pipe_tx2_startblock_o (pipe_tx2_start_block_gt),
    .pipe_tx2_syncheader_o (pipe_tx2_syncheader_gt),
    .pipe_tx2_eqcontrol_o (pipe_tx2_eqcontrol_gt),
    .pipe_tx2_eqdeemph_o (pipe_tx2_eqdeemph_gt),
    .pipe_tx2_eqpreset_o (pipe_tx2_eqpreset_gt),
    .pipe_rx3_char_is_k_o (pipe_rx3_char_is_k),
    .pipe_rx3_data_o (pipe_rx3_data),
    .pipe_rx3_valid_o (pipe_rx3_valid),
    .pipe_rx3_data_valid_o (pipe_rx3_data_valid),
    .pipe_rx3_status_o (pipe_rx3_status),
    .pipe_rx3_phy_status_o (pipe_rx3_phy_status),
    .pipe_rx3_elec_idle_o (pipe_rx3_elec_idle),
    .pipe_rx3_eqdone_o (pipe_rx3_eqdone),
    .pipe_rx3_eqlpadaptdone_o (pipe_rx3_eqlp_adaptdone),
    .pipe_rx3_eqlplffssel_o (pipe_rx3_eqlp_lffs_sel),
    .pipe_rx3_eqlpnewtxcoefforpreset_o (pipe_rx3_eqlp_new_txcoef_forpreset),
    .pipe_rx3_startblock_o (pipe_rx3_start_block),
    .pipe_rx3_syncheader_o (pipe_rx3_syncheader),
    .pipe_rx3_polarity_i (pipe_rx3_polarity),
    .pipe_rx3_eqcontrol_i (pipe_rx3_eqcontrol),
    .pipe_rx3_eqlplffs_i (pipe_rx3_eqlp_lffs),
    .pipe_rx3_eqlptxpreset_i (pipe_rx3_eqlp_txpreset),
    .pipe_rx3_eqpreset_i (pipe_rx3_eqpreset),
    .pipe_tx3_eqcoeff_o (pipe_tx3_eqcoeff),
    .pipe_tx3_eqdone_o (pipe_tx3_eqdone),
    .pipe_tx3_compliance_i (pipe_tx3_compliance),
    .pipe_tx3_char_is_k_i (pipe_tx3_char_is_k),
    .pipe_tx3_data_i (pipe_tx3_data),
    .pipe_tx3_elec_idle_i (pipe_tx3_elec_idle),
    .pipe_tx3_powerdown_i (pipe_tx3_powerdown),
    .pipe_tx3_datavalid_i (pipe_tx3_data_valid),
    .pipe_tx3_startblock_i (pipe_tx3_start_block),
    .pipe_tx3_syncheader_i (pipe_tx3_syncheader),
    .pipe_tx3_eqcontrol_i (pipe_tx3_eqcontrol),
    .pipe_tx3_eqdeemph_i (pipe_tx3_eqdeemph),
    .pipe_tx3_eqpreset_i (pipe_tx3_eqpreset),
    .pipe_rx3_char_is_k_i (pipe_rx3_char_is_k_gt),
    .pipe_rx3_data_i (pipe_rx3_data_gt),
    .pipe_rx3_valid_i (pipe_rx3_valid_gt),
    .pipe_rx3_data_valid_i (pipe_rx3_data_valid_gt),
    .pipe_rx3_status_i (pipe_rx3_status_gt),
    .pipe_rx3_phy_status_i (pipe_rx3_phy_status_gt),
    .pipe_rx3_elec_idle_i (pipe_rx3_elec_idle_gt),
    .pipe_rx3_eqdone_i (pipe_rx3_eqdone_gt),
    .pipe_rx3_eqlpadaptdone_i (pipe_rx3_eqlp_adaptdone_gt),
    .pipe_rx3_eqlplffssel_i (pipe_rx3_eqlp_lffs_sel_gt),
    .pipe_rx3_eqlpnewtxcoefforpreset_i (pipe_rx3_eqlp_new_txcoef_forpreset_gt),
    .pipe_rx3_startblock_i (pipe_rx3_start_block_gt),
    .pipe_rx3_syncheader_i (pipe_rx3_syncheader_gt),
    .pipe_rx3_polarity_o (pipe_rx3_polarity_gt),
    .pipe_rx3_eqcontrol_o (pipe_rx3_eqcontrol_gt),
    .pipe_rx3_eqlplffs_o (pipe_rx3_eqlp_lffs_gt),
    .pipe_rx3_eqlptxpreset_o (pipe_rx3_eqlp_txpreset_gt),
    .pipe_rx3_eqpreset_o (pipe_rx3_eqpreset_gt),
    .pipe_tx3_eqcoeff_i (pipe_tx3_eqcoeff_gt),
    .pipe_tx3_eqdone_i (pipe_tx3_eqdone_gt),
    .pipe_tx3_compliance_o (pipe_tx3_compliance_gt),
    .pipe_tx3_char_is_k_o (pipe_tx3_char_is_k_gt),
    .pipe_tx3_data_o (pipe_tx3_data_gt),
    .pipe_tx3_elec_idle_o (pipe_tx3_elec_idle_gt),
    .pipe_tx3_powerdown_o (pipe_tx3_powerdown_gt),
    .pipe_tx3_datavalid_o (pipe_tx3_data_valid_gt),
    .pipe_tx3_startblock_o (pipe_tx3_start_block_gt),
    .pipe_tx3_syncheader_o (pipe_tx3_syncheader_gt),
    .pipe_tx3_eqcontrol_o (pipe_tx3_eqcontrol_gt),
    .pipe_tx3_eqdeemph_o (pipe_tx3_eqdeemph_gt),
    .pipe_tx3_eqpreset_o (pipe_tx3_eqpreset_gt),
    .pipe_rx4_char_is_k_o (pipe_rx4_char_is_k),
    .pipe_rx4_data_o (pipe_rx4_data),
    .pipe_rx4_valid_o (pipe_rx4_valid),
    .pipe_rx4_data_valid_o (pipe_rx4_data_valid),
    .pipe_rx4_status_o (pipe_rx4_status),
    .pipe_rx4_phy_status_o (pipe_rx4_phy_status),
    .pipe_rx4_elec_idle_o (pipe_rx4_elec_idle),
    .pipe_rx4_eqdone_o (pipe_rx4_eqdone),
    .pipe_rx4_eqlpadaptdone_o (pipe_rx4_eqlp_adaptdone),
    .pipe_rx4_eqlplffssel_o (pipe_rx4_eqlp_lffs_sel),
    .pipe_rx4_eqlpnewtxcoefforpreset_o (pipe_rx4_eqlp_new_txcoef_forpreset),
    .pipe_rx4_startblock_o (pipe_rx4_start_block),
    .pipe_rx4_syncheader_o (pipe_rx4_syncheader),
    .pipe_rx4_polarity_i (pipe_rx4_polarity),
    .pipe_rx4_eqcontrol_i (pipe_rx4_eqcontrol),
    .pipe_rx4_eqlplffs_i (pipe_rx4_eqlp_lffs),
    .pipe_rx4_eqlptxpreset_i (pipe_rx4_eqlp_txpreset),
    .pipe_rx4_eqpreset_i (pipe_rx4_eqpreset),
    .pipe_tx4_eqcoeff_o (pipe_tx4_eqcoeff),
    .pipe_tx4_eqdone_o (pipe_tx4_eqdone),
    .pipe_tx4_compliance_i (pipe_tx4_compliance),
    .pipe_tx4_char_is_k_i (pipe_tx4_char_is_k),
    .pipe_tx4_data_i (pipe_tx4_data),
    .pipe_tx4_elec_idle_i (pipe_tx4_elec_idle),
    .pipe_tx4_powerdown_i (pipe_tx4_powerdown),
    .pipe_tx4_datavalid_i (pipe_tx4_data_valid),
    .pipe_tx4_startblock_i (pipe_tx4_start_block),
    .pipe_tx4_syncheader_i (pipe_tx4_syncheader),
    .pipe_tx4_eqcontrol_i (pipe_tx4_eqcontrol),
    .pipe_tx4_eqdeemph_i (pipe_tx4_eqdeemph),
    .pipe_tx4_eqpreset_i (pipe_tx4_eqpreset),
    .pipe_rx4_char_is_k_i (pipe_rx4_char_is_k_gt),
    .pipe_rx4_data_i (pipe_rx4_data_gt),
    .pipe_rx4_valid_i (pipe_rx4_valid_gt),
    .pipe_rx4_data_valid_i (pipe_rx4_data_valid_gt),
    .pipe_rx4_status_i (pipe_rx4_status_gt),
    .pipe_rx4_phy_status_i (pipe_rx4_phy_status_gt),
    .pipe_rx4_elec_idle_i (pipe_rx4_elec_idle_gt),
    .pipe_rx4_eqdone_i (pipe_rx4_eqdone_gt),
    .pipe_rx4_eqlpadaptdone_i (pipe_rx4_eqlp_adaptdone_gt),
    .pipe_rx4_eqlplffssel_i (pipe_rx4_eqlp_lffs_sel_gt),
    .pipe_rx4_eqlpnewtxcoefforpreset_i (pipe_rx4_eqlp_new_txcoef_forpreset_gt),
    .pipe_rx4_startblock_i (pipe_rx4_start_block_gt),
    .pipe_rx4_syncheader_i (pipe_rx4_syncheader_gt),
    .pipe_rx4_polarity_o (pipe_rx4_polarity_gt),
    .pipe_rx4_eqcontrol_o (pipe_rx4_eqcontrol_gt),
    .pipe_rx4_eqlplffs_o (pipe_rx4_eqlp_lffs_gt),
    .pipe_rx4_eqlptxpreset_o (pipe_rx4_eqlp_txpreset_gt),
    .pipe_rx4_eqpreset_o (pipe_rx4_eqpreset_gt),
    .pipe_tx4_eqcoeff_i (pipe_tx4_eqcoeff_gt),
    .pipe_tx4_eqdone_i (pipe_tx4_eqdone_gt),
    .pipe_tx4_compliance_o (pipe_tx4_compliance_gt),
    .pipe_tx4_char_is_k_o (pipe_tx4_char_is_k_gt),
    .pipe_tx4_data_o (pipe_tx4_data_gt),
    .pipe_tx4_elec_idle_o (pipe_tx4_elec_idle_gt),
    .pipe_tx4_powerdown_o (pipe_tx4_powerdown_gt),
    .pipe_tx4_datavalid_o (pipe_tx4_data_valid_gt),
    .pipe_tx4_startblock_o (pipe_tx4_start_block_gt),
    .pipe_tx4_syncheader_o (pipe_tx4_syncheader_gt),
    .pipe_tx4_eqcontrol_o (pipe_tx4_eqcontrol_gt),
    .pipe_tx4_eqdeemph_o (pipe_tx4_eqdeemph_gt),
    .pipe_tx4_eqpreset_o (pipe_tx4_eqpreset_gt),
    .pipe_rx5_char_is_k_o (pipe_rx5_char_is_k),
    .pipe_rx5_data_o (pipe_rx5_data),
    .pipe_rx5_valid_o (pipe_rx5_valid),
    .pipe_rx5_data_valid_o (pipe_rx5_data_valid),
    .pipe_rx5_status_o (pipe_rx5_status),
    .pipe_rx5_phy_status_o (pipe_rx5_phy_status),
    .pipe_rx5_elec_idle_o (pipe_rx5_elec_idle),
    .pipe_rx5_eqdone_o (pipe_rx5_eqdone),
    .pipe_rx5_eqlpadaptdone_o (pipe_rx5_eqlp_adaptdone),
    .pipe_rx5_eqlplffssel_o (pipe_rx5_eqlp_lffs_sel),
    .pipe_rx5_eqlpnewtxcoefforpreset_o (pipe_rx5_eqlp_new_txcoef_forpreset),
    .pipe_rx5_startblock_o (pipe_rx5_start_block),
    .pipe_rx5_syncheader_o (pipe_rx5_syncheader),
    .pipe_rx5_polarity_i (pipe_rx5_polarity),
    .pipe_rx5_eqcontrol_i (pipe_rx5_eqcontrol),
    .pipe_rx5_eqlplffs_i (pipe_rx5_eqlp_lffs),
    .pipe_rx5_eqlptxpreset_i (pipe_rx5_eqlp_txpreset),
    .pipe_rx5_eqpreset_i (pipe_rx5_eqpreset),
    .pipe_tx5_eqcoeff_o (pipe_tx5_eqcoeff),
    .pipe_tx5_eqdone_o (pipe_tx5_eqdone),
    .pipe_tx5_compliance_i (pipe_tx5_compliance),
    .pipe_tx5_char_is_k_i (pipe_tx5_char_is_k),
    .pipe_tx5_data_i (pipe_tx5_data),
    .pipe_tx5_elec_idle_i (pipe_tx5_elec_idle),
    .pipe_tx5_powerdown_i (pipe_tx5_powerdown),
    .pipe_tx5_datavalid_i (pipe_tx5_data_valid),
    .pipe_tx5_startblock_i (pipe_tx5_start_block),
    .pipe_tx5_syncheader_i (pipe_tx5_syncheader),
    .pipe_tx5_eqcontrol_i (pipe_tx5_eqcontrol),
    .pipe_tx5_eqdeemph_i (pipe_tx5_eqdeemph),
    .pipe_tx5_eqpreset_i (pipe_tx5_eqpreset),
    .pipe_rx5_char_is_k_i (pipe_rx5_char_is_k_gt),
    .pipe_rx5_data_i (pipe_rx5_data_gt),
    .pipe_rx5_valid_i (pipe_rx5_valid_gt),
    .pipe_rx5_data_valid_i (pipe_rx5_data_valid_gt),
    .pipe_rx5_status_i (pipe_rx5_status_gt),
    .pipe_rx5_phy_status_i (pipe_rx5_phy_status_gt),
    .pipe_rx5_elec_idle_i (pipe_rx5_elec_idle_gt),
    .pipe_rx5_eqdone_i (pipe_rx5_eqdone_gt),
    .pipe_rx5_eqlpadaptdone_i (pipe_rx5_eqlp_adaptdone_gt),
    .pipe_rx5_eqlplffssel_i (pipe_rx5_eqlp_lffs_sel_gt),
    .pipe_rx5_eqlpnewtxcoefforpreset_i (pipe_rx5_eqlp_new_txcoef_forpreset_gt),
    .pipe_rx5_startblock_i (pipe_rx5_start_block_gt),
    .pipe_rx5_syncheader_i (pipe_rx5_syncheader_gt),
    .pipe_rx5_polarity_o (pipe_rx5_polarity_gt),
    .pipe_rx5_eqcontrol_o (pipe_rx5_eqcontrol_gt),
    .pipe_rx5_eqlplffs_o (pipe_rx5_eqlp_lffs_gt),
    .pipe_rx5_eqlptxpreset_o (pipe_rx5_eqlp_txpreset_gt),
    .pipe_rx5_eqpreset_o (pipe_rx5_eqpreset_gt),
    .pipe_tx5_eqcoeff_i (pipe_tx5_eqcoeff_gt),
    .pipe_tx5_eqdone_i (pipe_tx5_eqdone_gt),
    .pipe_tx5_compliance_o (pipe_tx5_compliance_gt),
    .pipe_tx5_char_is_k_o (pipe_tx5_char_is_k_gt),
    .pipe_tx5_data_o (pipe_tx5_data_gt),
    .pipe_tx5_elec_idle_o (pipe_tx5_elec_idle_gt),
    .pipe_tx5_powerdown_o (pipe_tx5_powerdown_gt),
    .pipe_tx5_datavalid_o (pipe_tx5_data_valid_gt),
    .pipe_tx5_startblock_o (pipe_tx5_start_block_gt),
    .pipe_tx5_syncheader_o (pipe_tx5_syncheader_gt),
    .pipe_tx5_eqcontrol_o (pipe_tx5_eqcontrol_gt),
    .pipe_tx5_eqdeemph_o (pipe_tx5_eqdeemph_gt),
    .pipe_tx5_eqpreset_o (pipe_tx5_eqpreset_gt),
    .pipe_rx6_char_is_k_o (pipe_rx6_char_is_k),
    .pipe_rx6_data_o (pipe_rx6_data),
    .pipe_rx6_valid_o (pipe_rx6_valid),
    .pipe_rx6_data_valid_o (pipe_rx6_data_valid),
    .pipe_rx6_status_o (pipe_rx6_status),
    .pipe_rx6_phy_status_o (pipe_rx6_phy_status),
    .pipe_rx6_elec_idle_o (pipe_rx6_elec_idle),
    .pipe_rx6_eqdone_o (pipe_rx6_eqdone),
    .pipe_rx6_eqlpadaptdone_o (pipe_rx6_eqlp_adaptdone),
    .pipe_rx6_eqlplffssel_o (pipe_rx6_eqlp_lffs_sel),
    .pipe_rx6_eqlpnewtxcoefforpreset_o (pipe_rx6_eqlp_new_txcoef_forpreset),
    .pipe_rx6_startblock_o (pipe_rx6_start_block),
    .pipe_rx6_syncheader_o (pipe_rx6_syncheader),
    .pipe_rx6_polarity_i (pipe_rx6_polarity),
    .pipe_rx6_eqcontrol_i (pipe_rx6_eqcontrol),
    .pipe_rx6_eqlplffs_i (pipe_rx6_eqlp_lffs),
    .pipe_rx6_eqlptxpreset_i (pipe_rx6_eqlp_txpreset),
    .pipe_rx6_eqpreset_i (pipe_rx6_eqpreset),
    .pipe_tx6_eqcoeff_o (pipe_tx6_eqcoeff),
    .pipe_tx6_eqdone_o (pipe_tx6_eqdone),
    .pipe_tx6_compliance_i (pipe_tx6_compliance),
    .pipe_tx6_char_is_k_i (pipe_tx6_char_is_k),
    .pipe_tx6_data_i (pipe_tx6_data),
    .pipe_tx6_elec_idle_i (pipe_tx6_elec_idle),
    .pipe_tx6_powerdown_i (pipe_tx6_powerdown),
    .pipe_tx6_datavalid_i (pipe_tx6_data_valid),
    .pipe_tx6_startblock_i (pipe_tx6_start_block),
    .pipe_tx6_syncheader_i (pipe_tx6_syncheader),
    .pipe_tx6_eqcontrol_i (pipe_tx6_eqcontrol),
    .pipe_tx6_eqdeemph_i (pipe_tx6_eqdeemph),
    .pipe_tx6_eqpreset_i (pipe_tx6_eqpreset),
    .pipe_rx6_char_is_k_i (pipe_rx6_char_is_k_gt),
    .pipe_rx6_data_i (pipe_rx6_data_gt),
    .pipe_rx6_valid_i (pipe_rx6_valid_gt),
    .pipe_rx6_data_valid_i (pipe_rx6_data_valid_gt),
    .pipe_rx6_status_i (pipe_rx6_status_gt),
    .pipe_rx6_phy_status_i (pipe_rx6_phy_status_gt),
    .pipe_rx6_elec_idle_i (pipe_rx6_elec_idle_gt),
    .pipe_rx6_eqdone_i (pipe_rx6_eqdone_gt),
    .pipe_rx6_eqlpadaptdone_i (pipe_rx6_eqlp_adaptdone_gt),
    .pipe_rx6_eqlplffssel_i (pipe_rx6_eqlp_lffs_sel_gt),
    .pipe_rx6_eqlpnewtxcoefforpreset_i (pipe_rx6_eqlp_new_txcoef_forpreset_gt),
    .pipe_rx6_startblock_i (pipe_rx6_start_block_gt),
    .pipe_rx6_syncheader_i (pipe_rx6_syncheader_gt),
    .pipe_rx6_polarity_o (pipe_rx6_polarity_gt),
    .pipe_rx6_eqcontrol_o (pipe_rx6_eqcontrol_gt),
    .pipe_rx6_eqlplffs_o (pipe_rx6_eqlp_lffs_gt),
    .pipe_rx6_eqlptxpreset_o (pipe_rx6_eqlp_txpreset_gt),
    .pipe_rx6_eqpreset_o (pipe_rx6_eqpreset_gt),
    .pipe_tx6_eqcoeff_i (pipe_tx6_eqcoeff_gt),
    .pipe_tx6_eqdone_i (pipe_tx6_eqdone_gt),
    .pipe_tx6_compliance_o (pipe_tx6_compliance_gt),
    .pipe_tx6_char_is_k_o (pipe_tx6_char_is_k_gt),
    .pipe_tx6_data_o (pipe_tx6_data_gt),
    .pipe_tx6_elec_idle_o (pipe_tx6_elec_idle_gt),
    .pipe_tx6_powerdown_o (pipe_tx6_powerdown_gt),
    .pipe_tx6_datavalid_o (pipe_tx6_data_valid_gt),
    .pipe_tx6_startblock_o (pipe_tx6_start_block_gt),
    .pipe_tx6_syncheader_o (pipe_tx6_syncheader_gt),
    .pipe_tx6_eqcontrol_o (pipe_tx6_eqcontrol_gt),
    .pipe_tx6_eqdeemph_o (pipe_tx6_eqdeemph_gt),
    .pipe_tx6_eqpreset_o (pipe_tx6_eqpreset_gt),
    .pipe_rx7_char_is_k_o (pipe_rx7_char_is_k),
    .pipe_rx7_data_o (pipe_rx7_data),
    .pipe_rx7_valid_o (pipe_rx7_valid),
    .pipe_rx7_data_valid_o (pipe_rx7_data_valid),
    .pipe_rx7_status_o (pipe_rx7_status),
    .pipe_rx7_phy_status_o (pipe_rx7_phy_status),
    .pipe_rx7_elec_idle_o (pipe_rx7_elec_idle),
    .pipe_rx7_eqdone_o (pipe_rx7_eqdone),
    .pipe_rx7_eqlpadaptdone_o (pipe_rx7_eqlp_adaptdone),
    .pipe_rx7_eqlplffssel_o (pipe_rx7_eqlp_lffs_sel),
    .pipe_rx7_eqlpnewtxcoefforpreset_o (pipe_rx7_eqlp_new_txcoef_forpreset),
    .pipe_rx7_startblock_o (pipe_rx7_start_block),
    .pipe_rx7_syncheader_o (pipe_rx7_syncheader),
    .pipe_rx7_polarity_i (pipe_rx7_polarity),
    .pipe_rx7_eqcontrol_i (pipe_rx7_eqcontrol),
    .pipe_rx7_eqlplffs_i (pipe_rx7_eqlp_lffs),
    .pipe_rx7_eqlptxpreset_i (pipe_rx7_eqlp_txpreset),
    .pipe_rx7_eqpreset_i (pipe_rx7_eqpreset),
    .pipe_tx7_eqcoeff_o (pipe_tx7_eqcoeff),
    .pipe_tx7_eqdone_o (pipe_tx7_eqdone),
    .pipe_tx7_compliance_i (pipe_tx7_compliance),
    .pipe_tx7_char_is_k_i (pipe_tx7_char_is_k),
    .pipe_tx7_data_i (pipe_tx7_data),
    .pipe_tx7_elec_idle_i (pipe_tx7_elec_idle),
    .pipe_tx7_powerdown_i (pipe_tx7_powerdown),
    .pipe_tx7_datavalid_i (pipe_tx7_data_valid),
    .pipe_tx7_startblock_i (pipe_tx7_start_block),
    .pipe_tx7_syncheader_i (pipe_tx7_syncheader),
    .pipe_tx7_eqcontrol_i (pipe_tx7_eqcontrol),
    .pipe_tx7_eqdeemph_i (pipe_tx7_eqdeemph),
    .pipe_tx7_eqpreset_i (pipe_tx7_eqpreset),
    .pipe_rx7_char_is_k_i (pipe_rx7_char_is_k_gt),
    .pipe_rx7_data_i (pipe_rx7_data_gt),
    .pipe_rx7_valid_i (pipe_rx7_valid_gt),
    .pipe_rx7_data_valid_i (pipe_rx7_data_valid_gt),
    .pipe_rx7_status_i (pipe_rx7_status_gt),
    .pipe_rx7_phy_status_i (pipe_rx7_phy_status_gt),
    .pipe_rx7_elec_idle_i (pipe_rx7_elec_idle_gt),
    .pipe_rx7_eqdone_i (pipe_rx7_eqdone_gt),
    .pipe_rx7_eqlpadaptdone_i (pipe_rx7_eqlp_adaptdone_gt),
    .pipe_rx7_eqlplffssel_i (pipe_rx7_eqlp_lffs_sel_gt),
    .pipe_rx7_eqlpnewtxcoefforpreset_i (pipe_rx7_eqlp_new_txcoef_forpreset_gt),
    .pipe_rx7_startblock_i (pipe_rx7_start_block_gt),
    .pipe_rx7_syncheader_i (pipe_rx7_syncheader_gt),
    .pipe_rx7_polarity_o (pipe_rx7_polarity_gt),
    .pipe_rx7_eqcontrol_o (pipe_rx7_eqcontrol_gt),
    .pipe_rx7_eqlplffs_o (pipe_rx7_eqlp_lffs_gt),
    .pipe_rx7_eqlptxpreset_o (pipe_rx7_eqlp_txpreset_gt),
    .pipe_rx7_eqpreset_o (pipe_rx7_eqpreset_gt),
    .pipe_tx7_eqcoeff_i (pipe_tx7_eqcoeff_gt),
    .pipe_tx7_eqdone_i (pipe_tx7_eqdone_gt),
    .pipe_tx7_compliance_o (pipe_tx7_compliance_gt),
    .pipe_tx7_char_is_k_o (pipe_tx7_char_is_k_gt),
    .pipe_tx7_data_o (pipe_tx7_data_gt),
    .pipe_tx7_elec_idle_o (pipe_tx7_elec_idle_gt),
    .pipe_tx7_powerdown_o (pipe_tx7_powerdown_gt),
    .pipe_tx7_datavalid_o (pipe_tx7_data_valid_gt),
    .pipe_tx7_startblock_o (pipe_tx7_start_block_gt),
    .pipe_tx7_syncheader_o (pipe_tx7_syncheader_gt),
    .pipe_tx7_eqcontrol_o (pipe_tx7_eqcontrol_gt),
    .pipe_tx7_eqdeemph_o (pipe_tx7_eqdeemph_gt),
    .pipe_tx7_eqpreset_o (pipe_tx7_eqpreset_gt)
  );
`ifdef XILINX_OLYMPUS_SERIAL_SIM
 
  reg             dbg_cfg_local_mgmt_reg_override;
  int             core_clk_cnt;
  always @(posedge core_clk or negedge mgmt_reset_n) 
  begin
  	if (!mgmt_reset_n)
 	 begin
        	core_clk_cnt <= 0;
		dbg_cfg_local_mgmt_reg_override <= 1'b0;
	  end
	  else
	  begin
	  	if (core_clk_cnt == 10)
		begin
			core_clk_cnt <= core_clk_cnt;
			dbg_cfg_local_mgmt_reg_override <= 1'b1;
		end
		else
		begin
			core_clk_cnt <= core_clk_cnt + 1;
			dbg_cfg_local_mgmt_reg_override <= 1'b0;
		end
	  end	
  end		  

    //=======================================================================================================//	
`else

wire dbg_cfg_local_mgmt_reg_override = 1'b0;

`endif

  rp_pcie3_uscale_wrapper 
 #(
    .TCQ (TCQ),
    .NO_DECODE_LOGIC (NO_DECODE_LOGIC),
    .INTERFACE_SPEED (INTERFACE_SPEED),
    .COMPLETION_SPACE (COMPLETION_SPACE),
    .ARI_CAP_ENABLE (ARI_CAP_ENABLE),
    .AXISTEN_IF_CC_ALIGNMENT_MODE (AXISTEN_IF_CC_ALIGNMENT_MODE),
    .AXISTEN_IF_CC_PARITY_CHK (AXISTEN_IF_CC_PARITY_CHK),
    .AXISTEN_IF_CQ_ALIGNMENT_MODE (AXISTEN_IF_CQ_ALIGNMENT_MODE),
    .AXISTEN_IF_ENABLE_CLIENT_TAG (AXISTEN_IF_ENABLE_CLIENT_TAG),
    .AXISTEN_IF_ENABLE_MSG_ROUTE (AXISTEN_IF_ENABLE_MSG_ROUTE),
    .AXISTEN_IF_ENABLE_RX_MSG_INTFC (AXISTEN_IF_ENABLE_RX_MSG_INTFC),
    .AXISTEN_IF_RC_ALIGNMENT_MODE (AXISTEN_IF_RC_ALIGNMENT_MODE),
    .AXISTEN_IF_RC_STRADDLE (AXISTEN_IF_RC_STRADDLE),
    .AXISTEN_IF_RQ_ALIGNMENT_MODE (AXISTEN_IF_RQ_ALIGNMENT_MODE),
    .AXISTEN_IF_RQ_PARITY_CHK (AXISTEN_IF_RQ_PARITY_CHK),
    .AXISTEN_IF_WIDTH (AXISTEN_IF_WIDTH),
    .CRM_CORE_CLK_FREQ_500 (CRM_CORE_CLK_FREQ_500),
    .CRM_USER_CLK_FREQ (CRM_USER_CLK_FREQ),
    .DEBUG_CFG_LOCAL_MGMT_REG_ACCESS_OVERRIDE (DEBUG_CFG_LOCAL_MGMT_REG_ACCESS_OVERRIDE),
    .DEBUG_PL_DISABLE_EI_INFER_IN_L0 (DEBUG_PL_DISABLE_EI_INFER_IN_L0),
    .DEBUG_TL_DISABLE_RX_TLP_ORDER_CHECKS (DEBUG_TL_DISABLE_RX_TLP_ORDER_CHECKS),
    .DNSTREAM_LINK_NUM (DNSTREAM_LINK_NUM),
    .LL_ACK_TIMEOUT (LL_ACK_TIMEOUT),
    .LL_ACK_TIMEOUT_EN (LL_ACK_TIMEOUT_EN),
    .LL_ACK_TIMEOUT_FUNC (LL_ACK_TIMEOUT_FUNC),
    .LL_CPL_FC_UPDATE_TIMER (LL_CPL_FC_UPDATE_TIMER),
    .LL_CPL_FC_UPDATE_TIMER_OVERRIDE (LL_CPL_FC_UPDATE_TIMER_OVERRIDE),
    .LL_FC_UPDATE_TIMER (LL_FC_UPDATE_TIMER),
    .LL_FC_UPDATE_TIMER_OVERRIDE (LL_FC_UPDATE_TIMER_OVERRIDE),
    .LL_NP_FC_UPDATE_TIMER (LL_NP_FC_UPDATE_TIMER),
    .LL_NP_FC_UPDATE_TIMER_OVERRIDE (LL_NP_FC_UPDATE_TIMER_OVERRIDE),
    .LL_P_FC_UPDATE_TIMER (LL_P_FC_UPDATE_TIMER),
    .LL_P_FC_UPDATE_TIMER_OVERRIDE (LL_P_FC_UPDATE_TIMER_OVERRIDE),
    .LL_REPLAY_TIMEOUT (LL_REPLAY_TIMEOUT),
    .LL_REPLAY_TIMEOUT_EN (LL_REPLAY_TIMEOUT_EN),
    .LL_REPLAY_TIMEOUT_FUNC (LL_REPLAY_TIMEOUT_FUNC),
    .LTR_TX_MESSAGE_MINIMUM_INTERVAL (LTR_TX_MESSAGE_MINIMUM_INTERVAL),
    .LTR_TX_MESSAGE_ON_FUNC_POWER_STATE_CHANGE (LTR_TX_MESSAGE_ON_FUNC_POWER_STATE_CHANGE),
    .LTR_TX_MESSAGE_ON_LTR_ENABLE (LTR_TX_MESSAGE_ON_LTR_ENABLE),
    .MCAP_CAP_NEXTPTR (MCAP_CAP_NEXTPTR),
    .MCAP_CONFIGURE_OVERRIDE (MCAP_CONFIGURE_OVERRIDE),
    .MCAP_ENABLE (MCAP_ENABLE),
    .MCAP_EOS_DESIGN_SWITCH (MCAP_EOS_DESIGN_SWITCH),
    .MCAP_FPGA_BITSTREAM_VERSION (MCAP_FPGA_BITSTREAM_VERSION),
    .MCAP_GATE_IO_ENABLE_DESIGN_SWITCH (MCAP_GATE_IO_ENABLE_DESIGN_SWITCH),
    .MCAP_GATE_MEM_ENABLE_DESIGN_SWITCH (MCAP_GATE_MEM_ENABLE_DESIGN_SWITCH),
    .MCAP_INPUT_GATE_DESIGN_SWITCH (MCAP_INPUT_GATE_DESIGN_SWITCH),
    .MCAP_INTERRUPT_ON_MCAP_EOS (MCAP_INTERRUPT_ON_MCAP_EOS),
    .MCAP_INTERRUPT_ON_MCAP_ERROR (MCAP_INTERRUPT_ON_MCAP_ERROR),
    .MCAP_VSEC_ID (MCAP_VSEC_ID),
    .MCAP_VSEC_LEN (MCAP_VSEC_LEN),
    .MCAP_VSEC_REV (MCAP_VSEC_REV),
    .PF0_AER_CAP_ECRC_CHECK_CAPABLE (PF0_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF0_AER_CAP_ECRC_GEN_CAPABLE (PF0_AER_CAP_ECRC_GEN_CAPABLE),
    .PF0_AER_CAP_NEXTPTR (PF0_AER_CAP_NEXTPTR),
    .PF0_ARI_CAP_NEXT_FUNC (PF0_ARI_CAP_NEXT_FUNC),
    .PF0_ARI_CAP_NEXTPTR (PF0_ARI_CAP_NEXTPTR),
    .PF0_ARI_CAP_VER (PF0_ARI_CAP_VER),
    .PF0_BAR0_APERTURE_SIZE (PF0_BAR0_APERTURE_SIZE),
    .PF0_BAR0_CONTROL (PF0_BAR0_CONTROL),
    .PF0_BAR1_APERTURE_SIZE (PF0_BAR1_APERTURE_SIZE),
    .PF0_BAR1_CONTROL (PF0_BAR1_CONTROL),
    .PF0_BAR2_APERTURE_SIZE (PF0_BAR2_APERTURE_SIZE),
    .PF0_BAR2_CONTROL (PF0_BAR2_CONTROL),
    .PF0_BAR3_APERTURE_SIZE (PF0_BAR3_APERTURE_SIZE),
    .PF0_BAR3_CONTROL (PF0_BAR3_CONTROL),
    .PF0_BAR4_APERTURE_SIZE (PF0_BAR4_APERTURE_SIZE),
    .PF0_BAR4_CONTROL (PF0_BAR4_CONTROL),
    .PF0_BAR5_APERTURE_SIZE (PF0_BAR5_APERTURE_SIZE),
    .PF0_BAR5_CONTROL (PF0_BAR5_CONTROL),
    .PF0_BIST_REGISTER (PF0_BIST_REGISTER),
    .PF0_CAPABILITY_POINTER (PF0_CAPABILITY_POINTER),
    .PF0_CLASS_CODE (PF0_CLASS_CODE),
    .PF0_DEV_CAP_ENDPOINT_L0S_LATENCY (PF0_DEV_CAP_ENDPOINT_L0S_LATENCY),
    .PF0_DEV_CAP_ENDPOINT_L1_LATENCY (PF0_DEV_CAP_ENDPOINT_L1_LATENCY),
    .PF0_DEV_CAP_EXT_TAG_SUPPORTED (PF0_DEV_CAP_EXT_TAG_SUPPORTED),
    .PF0_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE (PF0_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE),
    .PF0_DEV_CAP_MAX_PAYLOAD_SIZE (PF0_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF0_DEV_CAP2_ARI_FORWARD_ENABLE (PF0_DEV_CAP2_ARI_FORWARD_ENABLE),
    .PF0_DEV_CAP2_CPL_TIMEOUT_DISABLE (PF0_DEV_CAP2_CPL_TIMEOUT_DISABLE),
    .PF0_DEV_CAP2_LTR_SUPPORT (PF0_DEV_CAP2_LTR_SUPPORT),
    .PF0_DEV_CAP2_OBFF_SUPPORT (PF0_DEV_CAP2_OBFF_SUPPORT),
    .PF0_DEV_CAP2_TPH_COMPLETER_SUPPORT (PF0_DEV_CAP2_TPH_COMPLETER_SUPPORT),
    .PF0_DEV_CAP2_32B_ATOMIC_COMPLETER_SUPPORT (PF0_DEV_CAP2_32B_ATOMIC_COMPLETER_SUPPORT),
    .PF0_DEV_CAP2_64B_ATOMIC_COMPLETER_SUPPORT (PF0_DEV_CAP2_64B_ATOMIC_COMPLETER_SUPPORT),
    .PF0_DEV_CAP2_128B_CAS_ATOMIC_COMPLETER_SUPPORT (PF0_DEV_CAP2_128B_CAS_ATOMIC_COMPLETER_SUPPORT),
    .PF0_DEVICE_ID (PF0_DEVICE_ID),
    .PF0_DPA_CAP_NEXTPTR (PF0_DPA_CAP_NEXTPTR),
    .PF0_DPA_CAP_SUB_STATE_CONTROL (PF0_DPA_CAP_SUB_STATE_CONTROL),
    .PF0_DPA_CAP_SUB_STATE_CONTROL_EN (PF0_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF0_DPA_CAP_VER (PF0_DPA_CAP_VER),
    .PF0_DSN_CAP_NEXTPTR (PF0_DSN_CAP_NEXTPTR),
    .PF0_EXPANSION_ROM_APERTURE_SIZE (PF0_EXPANSION_ROM_APERTURE_SIZE),
    .PF0_EXPANSION_ROM_ENABLE (PF0_EXPANSION_ROM_ENABLE),
    .PF0_INTERRUPT_LINE (PF0_INTERRUPT_LINE),
    .PF0_INTERRUPT_PIN (PF0_INTERRUPT_PIN),
    .PF0_LINK_CAP_ASPM_SUPPORT (PF0_LINK_CAP_ASPM_SUPPORT),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 (PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 (PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN3 (PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN3),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN1 (PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN1),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN2 (PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN2),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN3 (PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN3),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 (PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 (PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN3 (PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN3),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_GEN1 (PF0_LINK_CAP_L1_EXIT_LATENCY_GEN1),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_GEN2 (PF0_LINK_CAP_L1_EXIT_LATENCY_GEN2),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_GEN3 (PF0_LINK_CAP_L1_EXIT_LATENCY_GEN3),
    .PF0_LINK_STATUS_SLOT_CLOCK_CONFIG (PF0_LINK_STATUS_SLOT_CLOCK_CONFIG),
    .PF0_LTR_CAP_MAX_NOSNOOP_LAT (PF0_LTR_CAP_MAX_NOSNOOP_LAT),
    .PF0_LTR_CAP_MAX_SNOOP_LAT (PF0_LTR_CAP_MAX_SNOOP_LAT),
    .PF0_LTR_CAP_NEXTPTR (PF0_LTR_CAP_NEXTPTR),
    .PF0_LTR_CAP_VER (PF0_LTR_CAP_VER),
    .PF0_MSI_CAP_MULTIMSGCAP (PF0_MSI_CAP_MULTIMSGCAP),
    .PF0_MSI_CAP_NEXTPTR (PF0_MSI_CAP_NEXTPTR),
    .PF0_MSI_CAP_PERVECMASKCAP (PF0_MSI_CAP_PERVECMASKCAP),
    .PF0_MSIX_CAP_NEXTPTR (PF0_MSIX_CAP_NEXTPTR),
    .PF0_MSIX_CAP_PBA_BIR (PF0_MSIX_CAP_PBA_BIR),
    .PF0_MSIX_CAP_PBA_OFFSET (PF0_MSIX_CAP_PBA_OFFSET),
    .PF0_MSIX_CAP_TABLE_BIR (PF0_MSIX_CAP_TABLE_BIR),
    .PF0_MSIX_CAP_TABLE_OFFSET (PF0_MSIX_CAP_TABLE_OFFSET),
    .PF0_MSIX_CAP_TABLE_SIZE (PF0_MSIX_CAP_TABLE_SIZE),
    .PF0_PB_CAP_DATA_REG_D0 (PF0_PB_CAP_DATA_REG_D0),
    .PF0_PB_CAP_DATA_REG_D0_SUSTAINED (PF0_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF0_PB_CAP_DATA_REG_D1 (PF0_PB_CAP_DATA_REG_D1),
    .PF0_PB_CAP_DATA_REG_D3HOT (PF0_PB_CAP_DATA_REG_D3HOT),
    .PF0_PB_CAP_NEXTPTR (PF0_PB_CAP_NEXTPTR),
    .PF0_PB_CAP_SYSTEM_ALLOCATED (PF0_PB_CAP_SYSTEM_ALLOCATED),
    .PF0_PB_CAP_VER (PF0_PB_CAP_VER),
    .PF0_PM_CAP_ID (PF0_PM_CAP_ID),
    .PF0_PM_CAP_NEXTPTR (PF0_PM_CAP_NEXTPTR),
    .PF0_PM_CAP_PMESUPPORT_D0 (PF0_PM_CAP_PMESUPPORT_D0),
    .PF0_PM_CAP_PMESUPPORT_D1 (PF0_PM_CAP_PMESUPPORT_D1),
    .PF0_PM_CAP_PMESUPPORT_D3HOT (PF0_PM_CAP_PMESUPPORT_D3HOT),
    .PF0_PM_CAP_SUPP_D1_STATE (PF0_PM_CAP_SUPP_D1_STATE),
    .PF0_PM_CAP_VER_ID (PF0_PM_CAP_VER_ID),
    .PF0_PM_CSR_NOSOFTRESET (PF0_PM_CSR_NOSOFTRESET),
    .PF0_RBAR_CAP_ENABLE (PF0_RBAR_CAP_ENABLE),
    .PF0_RBAR_CAP_NEXTPTR (PF0_RBAR_CAP_NEXTPTR),
    .PF0_RBAR_CAP_SIZE0 (PF0_RBAR_CAP_SIZE0),
    .PF0_RBAR_CAP_SIZE1 (PF0_RBAR_CAP_SIZE1),
    .PF0_RBAR_CAP_SIZE2 (PF0_RBAR_CAP_SIZE2),
    .PF0_RBAR_CAP_VER (PF0_RBAR_CAP_VER),
    .PF0_RBAR_CONTROL_INDEX0 (PF0_RBAR_CONTROL_INDEX0),
    .PF0_RBAR_CONTROL_INDEX1 (PF0_RBAR_CONTROL_INDEX1),
    .PF0_RBAR_CONTROL_INDEX2 (PF0_RBAR_CONTROL_INDEX2),
    .PF0_RBAR_CONTROL_SIZE0 (PF0_RBAR_CONTROL_SIZE0),
    .PF0_RBAR_CONTROL_SIZE1 (PF0_RBAR_CONTROL_SIZE1),
    .PF0_RBAR_CONTROL_SIZE2 (PF0_RBAR_CONTROL_SIZE2),
    .PF0_RBAR_NUM (PF0_RBAR_NUM),
    .PF0_REVISION_ID (PF0_REVISION_ID),
    .PF0_SECONDARY_PCIE_CAP_NEXTPTR (PF0_SECONDARY_PCIE_CAP_NEXTPTR),
    .PF0_SRIOV_BAR0_APERTURE_SIZE (PF0_SRIOV_BAR0_APERTURE_SIZE),
    .PF0_SRIOV_BAR0_CONTROL (PF0_SRIOV_BAR0_CONTROL),
    .PF0_SRIOV_BAR1_APERTURE_SIZE (PF0_SRIOV_BAR1_APERTURE_SIZE),
    .PF0_SRIOV_BAR1_CONTROL (PF0_SRIOV_BAR1_CONTROL),
    .PF0_SRIOV_BAR2_APERTURE_SIZE (PF0_SRIOV_BAR2_APERTURE_SIZE),
    .PF0_SRIOV_BAR2_CONTROL (PF0_SRIOV_BAR2_CONTROL),
    .PF0_SRIOV_BAR3_APERTURE_SIZE (PF0_SRIOV_BAR3_APERTURE_SIZE),
    .PF0_SRIOV_BAR3_CONTROL (PF0_SRIOV_BAR3_CONTROL),
    .PF0_SRIOV_BAR4_APERTURE_SIZE (PF0_SRIOV_BAR4_APERTURE_SIZE),
    .PF0_SRIOV_BAR4_CONTROL (PF0_SRIOV_BAR4_CONTROL),
    .PF0_SRIOV_BAR5_APERTURE_SIZE (PF0_SRIOV_BAR5_APERTURE_SIZE),
    .PF0_SRIOV_BAR5_CONTROL (PF0_SRIOV_BAR5_CONTROL),
    .PF0_SRIOV_CAP_INITIAL_VF (PF0_SRIOV_CAP_INITIAL_VF),
    .PF0_SRIOV_CAP_NEXTPTR (PF0_SRIOV_CAP_NEXTPTR),
    .PF0_SRIOV_CAP_TOTAL_VF (PF0_SRIOV_CAP_TOTAL_VF),
    .PF0_SRIOV_CAP_VER (PF0_SRIOV_CAP_VER),
    .PF0_SRIOV_FIRST_VF_OFFSET (PF0_SRIOV_FIRST_VF_OFFSET),
    .PF0_SRIOV_FUNC_DEP_LINK (PF0_SRIOV_FUNC_DEP_LINK),
    .PF0_SRIOV_SUPPORTED_PAGE_SIZE (PF0_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF0_SRIOV_VF_DEVICE_ID (PF0_SRIOV_VF_DEVICE_ID),
    .PF0_SUBSYSTEM_ID (PF0_SUBSYSTEM_ID),
    .PF0_TPHR_CAP_DEV_SPECIFIC_MODE (PF0_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF0_TPHR_CAP_ENABLE (PF0_TPHR_CAP_ENABLE),
    .PF0_TPHR_CAP_INT_VEC_MODE (PF0_TPHR_CAP_INT_VEC_MODE),
    .PF0_TPHR_CAP_NEXTPTR (PF0_TPHR_CAP_NEXTPTR),
    .PF0_TPHR_CAP_ST_MODE_SEL (PF0_TPHR_CAP_ST_MODE_SEL),
    .PF0_TPHR_CAP_ST_TABLE_LOC (PF0_TPHR_CAP_ST_TABLE_LOC),
    .PF0_TPHR_CAP_ST_TABLE_SIZE (PF0_TPHR_CAP_ST_TABLE_SIZE),
    .PF0_TPHR_CAP_VER (PF0_TPHR_CAP_VER),
    .PF0_VC_CAP_ENABLE (PF0_VC_CAP_ENABLE),
    .PF0_VC_CAP_NEXTPTR (PF0_VC_CAP_NEXTPTR),
    .PF0_VC_CAP_VER (PF0_VC_CAP_VER),
    .PF1_AER_CAP_ECRC_CHECK_CAPABLE (PF1_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF1_AER_CAP_ECRC_GEN_CAPABLE (PF1_AER_CAP_ECRC_GEN_CAPABLE),
    .PF1_AER_CAP_NEXTPTR (PF1_AER_CAP_NEXTPTR),
    .PF1_ARI_CAP_NEXT_FUNC (PF1_ARI_CAP_NEXT_FUNC),
    .PF1_ARI_CAP_NEXTPTR (PF1_ARI_CAP_NEXTPTR),
    .PF1_BAR0_APERTURE_SIZE (PF1_BAR0_APERTURE_SIZE),
    .PF1_BAR0_CONTROL (PF1_BAR0_CONTROL),
    .PF1_BAR1_APERTURE_SIZE (PF1_BAR1_APERTURE_SIZE),
    .PF1_BAR1_CONTROL (PF1_BAR1_CONTROL),
    .PF1_BAR2_APERTURE_SIZE (PF1_BAR2_APERTURE_SIZE),
    .PF1_BAR2_CONTROL (PF1_BAR2_CONTROL),
    .PF1_BAR3_APERTURE_SIZE (PF1_BAR3_APERTURE_SIZE),
    .PF1_BAR3_CONTROL (PF1_BAR3_CONTROL),
    .PF1_BAR4_APERTURE_SIZE (PF1_BAR4_APERTURE_SIZE),
    .PF1_BAR4_CONTROL (PF1_BAR4_CONTROL),
    .PF1_BAR5_APERTURE_SIZE (PF1_BAR5_APERTURE_SIZE),
    .PF1_BAR5_CONTROL (PF1_BAR5_CONTROL),
    .PF1_BIST_REGISTER (PF1_BIST_REGISTER),
    .PF1_CAPABILITY_POINTER (PF1_CAPABILITY_POINTER),
    .PF1_CLASS_CODE (PF1_CLASS_CODE),
    .PF1_DEV_CAP_MAX_PAYLOAD_SIZE (PF1_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF1_DEVICE_ID (PF1_DEVICE_ID),
    .PF1_DPA_CAP_NEXTPTR (PF1_DPA_CAP_NEXTPTR),
    .PF1_DPA_CAP_SUB_STATE_CONTROL (PF1_DPA_CAP_SUB_STATE_CONTROL),
    .PF1_DPA_CAP_SUB_STATE_CONTROL_EN (PF1_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF1_DPA_CAP_VER (PF1_DPA_CAP_VER),
    .PF1_DSN_CAP_NEXTPTR (PF1_DSN_CAP_NEXTPTR),
    .PF1_EXPANSION_ROM_APERTURE_SIZE (PF1_EXPANSION_ROM_APERTURE_SIZE),
    .PF1_EXPANSION_ROM_ENABLE (PF1_EXPANSION_ROM_ENABLE),
    .PF1_INTERRUPT_LINE (PF1_INTERRUPT_LINE),
    .PF1_INTERRUPT_PIN (PF1_INTERRUPT_PIN),
    .PF1_MSI_CAP_MULTIMSGCAP (PF1_MSI_CAP_MULTIMSGCAP),
    .PF1_MSI_CAP_NEXTPTR (PF1_MSI_CAP_NEXTPTR),
    .PF1_MSI_CAP_PERVECMASKCAP (PF1_MSI_CAP_PERVECMASKCAP),
    .PF1_MSIX_CAP_NEXTPTR (PF1_MSIX_CAP_NEXTPTR),
    .PF1_MSIX_CAP_PBA_BIR (PF1_MSIX_CAP_PBA_BIR),
    .PF1_MSIX_CAP_PBA_OFFSET (PF1_MSIX_CAP_PBA_OFFSET),
    .PF1_MSIX_CAP_TABLE_BIR (PF1_MSIX_CAP_TABLE_BIR),
    .PF1_MSIX_CAP_TABLE_OFFSET (PF1_MSIX_CAP_TABLE_OFFSET),
    .PF1_MSIX_CAP_TABLE_SIZE (PF1_MSIX_CAP_TABLE_SIZE),
    .PF1_PB_CAP_DATA_REG_D0 (PF1_PB_CAP_DATA_REG_D0),
    .PF1_PB_CAP_DATA_REG_D0_SUSTAINED (PF1_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF1_PB_CAP_DATA_REG_D1 (PF1_PB_CAP_DATA_REG_D1),
    .PF1_PB_CAP_DATA_REG_D3HOT (PF1_PB_CAP_DATA_REG_D3HOT),
    .PF1_PB_CAP_NEXTPTR (PF1_PB_CAP_NEXTPTR),
    .PF1_PB_CAP_SYSTEM_ALLOCATED (PF1_PB_CAP_SYSTEM_ALLOCATED),
    .PF1_PB_CAP_VER (PF1_PB_CAP_VER),
    .PF1_PM_CAP_ID (PF1_PM_CAP_ID),
    .PF1_PM_CAP_NEXTPTR (PF1_PM_CAP_NEXTPTR),
    .PF1_PM_CAP_VER_ID (PF1_PM_CAP_VER_ID),
    .PF1_RBAR_CAP_ENABLE (PF1_RBAR_CAP_ENABLE),
    .PF1_RBAR_CAP_NEXTPTR (PF1_RBAR_CAP_NEXTPTR),
    .PF1_RBAR_CAP_SIZE0 (PF1_RBAR_CAP_SIZE0),
    .PF1_RBAR_CAP_SIZE1 (PF1_RBAR_CAP_SIZE1),
    .PF1_RBAR_CAP_SIZE2 (PF1_RBAR_CAP_SIZE2),
    .PF1_RBAR_CAP_VER (PF1_RBAR_CAP_VER),
    .PF1_RBAR_CONTROL_INDEX0 (PF1_RBAR_CONTROL_INDEX0),
    .PF1_RBAR_CONTROL_INDEX1 (PF1_RBAR_CONTROL_INDEX1),
    .PF1_RBAR_CONTROL_INDEX2 (PF1_RBAR_CONTROL_INDEX2),
    .PF1_RBAR_CONTROL_SIZE0 (PF1_RBAR_CONTROL_SIZE0),
    .PF1_RBAR_CONTROL_SIZE1 (PF1_RBAR_CONTROL_SIZE1),
    .PF1_RBAR_CONTROL_SIZE2 (PF1_RBAR_CONTROL_SIZE2),
    .PF1_RBAR_NUM (PF1_RBAR_NUM),
    .PF1_REVISION_ID (PF1_REVISION_ID),
    .PF1_SRIOV_BAR0_APERTURE_SIZE (PF1_SRIOV_BAR0_APERTURE_SIZE),
    .PF1_SRIOV_BAR0_CONTROL (PF1_SRIOV_BAR0_CONTROL),
    .PF1_SRIOV_BAR1_APERTURE_SIZE (PF1_SRIOV_BAR1_APERTURE_SIZE),
    .PF1_SRIOV_BAR1_CONTROL (PF1_SRIOV_BAR1_CONTROL),
    .PF1_SRIOV_BAR2_APERTURE_SIZE (PF1_SRIOV_BAR2_APERTURE_SIZE),
    .PF1_SRIOV_BAR2_CONTROL (PF1_SRIOV_BAR2_CONTROL),
    .PF1_SRIOV_BAR3_APERTURE_SIZE (PF1_SRIOV_BAR3_APERTURE_SIZE),
    .PF1_SRIOV_BAR3_CONTROL (PF1_SRIOV_BAR3_CONTROL),
    .PF1_SRIOV_BAR4_APERTURE_SIZE (PF1_SRIOV_BAR4_APERTURE_SIZE),
    .PF1_SRIOV_BAR4_CONTROL (PF1_SRIOV_BAR4_CONTROL),
    .PF1_SRIOV_BAR5_APERTURE_SIZE (PF1_SRIOV_BAR5_APERTURE_SIZE),
    .PF1_SRIOV_BAR5_CONTROL (PF1_SRIOV_BAR5_CONTROL),
    .PF1_SRIOV_CAP_INITIAL_VF (PF1_SRIOV_CAP_INITIAL_VF),
    .PF1_SRIOV_CAP_NEXTPTR (PF1_SRIOV_CAP_NEXTPTR),
    .PF1_SRIOV_CAP_TOTAL_VF (PF1_SRIOV_CAP_TOTAL_VF),
    .PF1_SRIOV_CAP_VER (PF1_SRIOV_CAP_VER),
    .PF1_SRIOV_FIRST_VF_OFFSET (PF1_SRIOV_FIRST_VF_OFFSET),
    .PF1_SRIOV_FUNC_DEP_LINK (PF1_SRIOV_FUNC_DEP_LINK),
    .PF1_SRIOV_SUPPORTED_PAGE_SIZE (PF1_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF1_SRIOV_VF_DEVICE_ID (PF1_SRIOV_VF_DEVICE_ID),
    .PF1_SUBSYSTEM_ID (PF1_SUBSYSTEM_ID),
    .PF1_TPHR_CAP_DEV_SPECIFIC_MODE (PF1_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF1_TPHR_CAP_ENABLE (PF1_TPHR_CAP_ENABLE),
    .PF1_TPHR_CAP_INT_VEC_MODE (PF1_TPHR_CAP_INT_VEC_MODE),
    .PF1_TPHR_CAP_NEXTPTR (PF1_TPHR_CAP_NEXTPTR),
    .PF1_TPHR_CAP_ST_MODE_SEL (PF1_TPHR_CAP_ST_MODE_SEL),
    .PF1_TPHR_CAP_ST_TABLE_LOC (PF1_TPHR_CAP_ST_TABLE_LOC),
    .PF1_TPHR_CAP_ST_TABLE_SIZE (PF1_TPHR_CAP_ST_TABLE_SIZE),
    .PF1_TPHR_CAP_VER (PF1_TPHR_CAP_VER),
    .PF2_AER_CAP_ECRC_CHECK_CAPABLE (PF2_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF2_AER_CAP_ECRC_GEN_CAPABLE (PF2_AER_CAP_ECRC_GEN_CAPABLE),
    .PF2_AER_CAP_NEXTPTR (PF2_AER_CAP_NEXTPTR),
    .PF2_ARI_CAP_NEXT_FUNC (PF2_ARI_CAP_NEXT_FUNC),
    .PF2_ARI_CAP_NEXTPTR (PF2_ARI_CAP_NEXTPTR),
    .PF2_BAR0_APERTURE_SIZE (PF2_BAR0_APERTURE_SIZE),
    .PF2_BAR0_CONTROL (PF2_BAR0_CONTROL),
    .PF2_BAR1_APERTURE_SIZE (PF2_BAR1_APERTURE_SIZE),
    .PF2_BAR1_CONTROL (PF2_BAR1_CONTROL),
    .PF2_BAR2_APERTURE_SIZE (PF2_BAR2_APERTURE_SIZE),
    .PF2_BAR2_CONTROL (PF2_BAR2_CONTROL),
    .PF2_BAR3_APERTURE_SIZE (PF2_BAR3_APERTURE_SIZE),
    .PF2_BAR3_CONTROL (PF2_BAR3_CONTROL),
    .PF2_BAR4_APERTURE_SIZE (PF2_BAR4_APERTURE_SIZE),
    .PF2_BAR4_CONTROL (PF2_BAR4_CONTROL),
    .PF2_BAR5_APERTURE_SIZE (PF2_BAR5_APERTURE_SIZE),
    .PF2_BAR5_CONTROL (PF2_BAR5_CONTROL),
    .PF2_BIST_REGISTER (PF2_BIST_REGISTER),
    .PF2_CAPABILITY_POINTER (PF2_CAPABILITY_POINTER),
    .PF2_CLASS_CODE (PF2_CLASS_CODE),
    .PF2_DEV_CAP_MAX_PAYLOAD_SIZE (PF2_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF2_DEVICE_ID (PF2_DEVICE_ID),
    .PF2_DPA_CAP_NEXTPTR (PF2_DPA_CAP_NEXTPTR),
    .PF2_DPA_CAP_SUB_STATE_CONTROL (PF2_DPA_CAP_SUB_STATE_CONTROL),
    .PF2_DPA_CAP_SUB_STATE_CONTROL_EN (PF2_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF2_DPA_CAP_VER (PF2_DPA_CAP_VER),
    .PF2_DSN_CAP_NEXTPTR (PF2_DSN_CAP_NEXTPTR),
    .PF2_EXPANSION_ROM_APERTURE_SIZE (PF2_EXPANSION_ROM_APERTURE_SIZE),
    .PF2_EXPANSION_ROM_ENABLE (PF2_EXPANSION_ROM_ENABLE),
    .PF2_INTERRUPT_LINE (PF2_INTERRUPT_LINE),
    .PF2_INTERRUPT_PIN (PF2_INTERRUPT_PIN),
    .PF2_MSI_CAP_MULTIMSGCAP (PF2_MSI_CAP_MULTIMSGCAP),
    .PF2_MSI_CAP_NEXTPTR (PF2_MSI_CAP_NEXTPTR),
    .PF2_MSI_CAP_PERVECMASKCAP (PF2_MSI_CAP_PERVECMASKCAP),
    .PF2_MSIX_CAP_NEXTPTR (PF2_MSIX_CAP_NEXTPTR),
    .PF2_MSIX_CAP_PBA_BIR (PF2_MSIX_CAP_PBA_BIR),
    .PF2_MSIX_CAP_PBA_OFFSET (PF2_MSIX_CAP_PBA_OFFSET),
    .PF2_MSIX_CAP_TABLE_BIR (PF2_MSIX_CAP_TABLE_BIR),
    .PF2_MSIX_CAP_TABLE_OFFSET (PF2_MSIX_CAP_TABLE_OFFSET),
    .PF2_MSIX_CAP_TABLE_SIZE (PF2_MSIX_CAP_TABLE_SIZE),
    .PF2_PB_CAP_DATA_REG_D0 (PF2_PB_CAP_DATA_REG_D0),
    .PF2_PB_CAP_DATA_REG_D0_SUSTAINED (PF2_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF2_PB_CAP_DATA_REG_D1 (PF2_PB_CAP_DATA_REG_D1),
    .PF2_PB_CAP_DATA_REG_D3HOT (PF2_PB_CAP_DATA_REG_D3HOT),
    .PF2_PB_CAP_NEXTPTR (PF2_PB_CAP_NEXTPTR),
    .PF2_PB_CAP_SYSTEM_ALLOCATED (PF2_PB_CAP_SYSTEM_ALLOCATED),
    .PF2_PB_CAP_VER (PF2_PB_CAP_VER),
    .PF2_PM_CAP_ID (PF2_PM_CAP_ID),
    .PF2_PM_CAP_NEXTPTR (PF2_PM_CAP_NEXTPTR),
    .PF2_PM_CAP_VER_ID (PF2_PM_CAP_VER_ID),
    .PF2_RBAR_CAP_ENABLE (PF2_RBAR_CAP_ENABLE),
    .PF2_RBAR_CAP_NEXTPTR (PF2_RBAR_CAP_NEXTPTR),
    .PF2_RBAR_CAP_SIZE0 (PF2_RBAR_CAP_SIZE0),
    .PF2_RBAR_CAP_SIZE1 (PF2_RBAR_CAP_SIZE1),
    .PF2_RBAR_CAP_SIZE2 (PF2_RBAR_CAP_SIZE2),
    .PF2_RBAR_CAP_VER (PF2_RBAR_CAP_VER),
    .PF2_RBAR_CONTROL_INDEX0 (PF2_RBAR_CONTROL_INDEX0),
    .PF2_RBAR_CONTROL_INDEX1 (PF2_RBAR_CONTROL_INDEX1),
    .PF2_RBAR_CONTROL_INDEX2 (PF2_RBAR_CONTROL_INDEX2),
    .PF2_RBAR_CONTROL_SIZE0 (PF2_RBAR_CONTROL_SIZE0),
    .PF2_RBAR_CONTROL_SIZE1 (PF2_RBAR_CONTROL_SIZE1),
    .PF2_RBAR_CONTROL_SIZE2 (PF2_RBAR_CONTROL_SIZE2),
    .PF2_RBAR_NUM (PF2_RBAR_NUM),
    .PF2_REVISION_ID (PF2_REVISION_ID),
    .PF2_SRIOV_BAR0_APERTURE_SIZE (PF2_SRIOV_BAR0_APERTURE_SIZE),
    .PF2_SRIOV_BAR0_CONTROL (PF2_SRIOV_BAR0_CONTROL),
    .PF2_SRIOV_BAR1_APERTURE_SIZE (PF2_SRIOV_BAR1_APERTURE_SIZE),
    .PF2_SRIOV_BAR1_CONTROL (PF2_SRIOV_BAR1_CONTROL),
    .PF2_SRIOV_BAR2_APERTURE_SIZE (PF2_SRIOV_BAR2_APERTURE_SIZE),
    .PF2_SRIOV_BAR2_CONTROL (PF2_SRIOV_BAR2_CONTROL),
    .PF2_SRIOV_BAR3_APERTURE_SIZE (PF2_SRIOV_BAR3_APERTURE_SIZE),
    .PF2_SRIOV_BAR3_CONTROL (PF2_SRIOV_BAR3_CONTROL),
    .PF2_SRIOV_BAR4_APERTURE_SIZE (PF2_SRIOV_BAR4_APERTURE_SIZE),
    .PF2_SRIOV_BAR4_CONTROL (PF2_SRIOV_BAR4_CONTROL),
    .PF2_SRIOV_BAR5_APERTURE_SIZE (PF2_SRIOV_BAR5_APERTURE_SIZE),
    .PF2_SRIOV_BAR5_CONTROL (PF2_SRIOV_BAR5_CONTROL),
    .PF2_SRIOV_CAP_INITIAL_VF (PF2_SRIOV_CAP_INITIAL_VF),
    .PF2_SRIOV_CAP_NEXTPTR (PF2_SRIOV_CAP_NEXTPTR),
    .PF2_SRIOV_CAP_TOTAL_VF (PF2_SRIOV_CAP_TOTAL_VF),
    .PF2_SRIOV_CAP_VER (PF2_SRIOV_CAP_VER),
    .PF2_SRIOV_FIRST_VF_OFFSET (PF2_SRIOV_FIRST_VF_OFFSET),
    .PF2_SRIOV_FUNC_DEP_LINK (PF2_SRIOV_FUNC_DEP_LINK),
    .PF2_SRIOV_SUPPORTED_PAGE_SIZE (PF2_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF2_SRIOV_VF_DEVICE_ID (PF2_SRIOV_VF_DEVICE_ID),
    .PF2_SUBSYSTEM_ID (PF2_SUBSYSTEM_ID),
    .PF2_TPHR_CAP_DEV_SPECIFIC_MODE (PF2_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF2_TPHR_CAP_ENABLE (PF2_TPHR_CAP_ENABLE),
    .PF2_TPHR_CAP_INT_VEC_MODE (PF2_TPHR_CAP_INT_VEC_MODE),
    .PF2_TPHR_CAP_NEXTPTR (PF2_TPHR_CAP_NEXTPTR),
    .PF2_TPHR_CAP_ST_MODE_SEL (PF2_TPHR_CAP_ST_MODE_SEL),
    .PF2_TPHR_CAP_ST_TABLE_LOC (PF2_TPHR_CAP_ST_TABLE_LOC),
    .PF2_TPHR_CAP_ST_TABLE_SIZE (PF2_TPHR_CAP_ST_TABLE_SIZE),
    .PF2_TPHR_CAP_VER (PF2_TPHR_CAP_VER),
    .PF3_AER_CAP_ECRC_CHECK_CAPABLE (PF3_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF3_AER_CAP_ECRC_GEN_CAPABLE (PF3_AER_CAP_ECRC_GEN_CAPABLE),
    .PF3_AER_CAP_NEXTPTR (PF3_AER_CAP_NEXTPTR),
    .PF3_ARI_CAP_NEXT_FUNC (PF3_ARI_CAP_NEXT_FUNC),
    .PF3_ARI_CAP_NEXTPTR (PF3_ARI_CAP_NEXTPTR),
    .PF3_BAR0_APERTURE_SIZE (PF3_BAR0_APERTURE_SIZE),
    .PF3_BAR0_CONTROL (PF3_BAR0_CONTROL),
    .PF3_BAR1_APERTURE_SIZE (PF3_BAR1_APERTURE_SIZE),
    .PF3_BAR1_CONTROL (PF3_BAR1_CONTROL),
    .PF3_BAR2_APERTURE_SIZE (PF3_BAR2_APERTURE_SIZE),
    .PF3_BAR2_CONTROL (PF3_BAR2_CONTROL),
    .PF3_BAR3_APERTURE_SIZE (PF3_BAR3_APERTURE_SIZE),
    .PF3_BAR3_CONTROL (PF3_BAR3_CONTROL),
    .PF3_BAR4_APERTURE_SIZE (PF3_BAR4_APERTURE_SIZE),
    .PF3_BAR4_CONTROL (PF3_BAR4_CONTROL),
    .PF3_BAR5_APERTURE_SIZE (PF3_BAR5_APERTURE_SIZE),
    .PF3_BAR5_CONTROL (PF3_BAR5_CONTROL),
    .PF3_BIST_REGISTER (PF3_BIST_REGISTER),
    .PF3_CAPABILITY_POINTER (PF3_CAPABILITY_POINTER),
    .PF3_CLASS_CODE (PF3_CLASS_CODE),
    .PF3_DEV_CAP_MAX_PAYLOAD_SIZE (PF3_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF3_DEVICE_ID (PF3_DEVICE_ID),
    .PF3_DPA_CAP_NEXTPTR (PF3_DPA_CAP_NEXTPTR),
    .PF3_DPA_CAP_SUB_STATE_CONTROL (PF3_DPA_CAP_SUB_STATE_CONTROL),
    .PF3_DPA_CAP_SUB_STATE_CONTROL_EN (PF3_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF3_DPA_CAP_VER (PF3_DPA_CAP_VER),
    .PF3_DSN_CAP_NEXTPTR (PF3_DSN_CAP_NEXTPTR),
    .PF3_EXPANSION_ROM_APERTURE_SIZE (PF3_EXPANSION_ROM_APERTURE_SIZE),
    .PF3_EXPANSION_ROM_ENABLE (PF3_EXPANSION_ROM_ENABLE),
    .PF3_INTERRUPT_LINE (PF3_INTERRUPT_LINE),
    .PF3_INTERRUPT_PIN (PF3_INTERRUPT_PIN),
    .PF3_MSI_CAP_MULTIMSGCAP (PF3_MSI_CAP_MULTIMSGCAP),
    .PF3_MSI_CAP_NEXTPTR (PF3_MSI_CAP_NEXTPTR),
    .PF3_MSI_CAP_PERVECMASKCAP (PF3_MSI_CAP_PERVECMASKCAP),
    .PF3_MSIX_CAP_NEXTPTR (PF3_MSIX_CAP_NEXTPTR),
    .PF3_MSIX_CAP_PBA_BIR (PF3_MSIX_CAP_PBA_BIR),
    .PF3_MSIX_CAP_PBA_OFFSET (PF3_MSIX_CAP_PBA_OFFSET),
    .PF3_MSIX_CAP_TABLE_BIR (PF3_MSIX_CAP_TABLE_BIR),
    .PF3_MSIX_CAP_TABLE_OFFSET (PF3_MSIX_CAP_TABLE_OFFSET),
    .PF3_MSIX_CAP_TABLE_SIZE (PF3_MSIX_CAP_TABLE_SIZE),
    .PF3_PB_CAP_DATA_REG_D0 (PF3_PB_CAP_DATA_REG_D0),
    .PF3_PB_CAP_DATA_REG_D0_SUSTAINED (PF3_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF3_PB_CAP_DATA_REG_D1 (PF3_PB_CAP_DATA_REG_D1),
    .PF3_PB_CAP_DATA_REG_D3HOT (PF3_PB_CAP_DATA_REG_D3HOT),
    .PF3_PB_CAP_NEXTPTR (PF3_PB_CAP_NEXTPTR),
    .PF3_PB_CAP_SYSTEM_ALLOCATED (PF3_PB_CAP_SYSTEM_ALLOCATED),
    .PF3_PB_CAP_VER (PF3_PB_CAP_VER),
    .PF3_PM_CAP_ID (PF3_PM_CAP_ID),
    .PF3_PM_CAP_NEXTPTR (PF3_PM_CAP_NEXTPTR),
    .PF3_PM_CAP_VER_ID (PF3_PM_CAP_VER_ID),
    .PF3_RBAR_CAP_ENABLE (PF3_RBAR_CAP_ENABLE),
    .PF3_RBAR_CAP_NEXTPTR (PF3_RBAR_CAP_NEXTPTR),
    .PF3_RBAR_CAP_SIZE0 (PF3_RBAR_CAP_SIZE0),
    .PF3_RBAR_CAP_SIZE1 (PF3_RBAR_CAP_SIZE1),
    .PF3_RBAR_CAP_SIZE2 (PF3_RBAR_CAP_SIZE2),
    .PF3_RBAR_CAP_VER (PF3_RBAR_CAP_VER),
    .PF3_RBAR_CONTROL_INDEX0 (PF3_RBAR_CONTROL_INDEX0),
    .PF3_RBAR_CONTROL_INDEX1 (PF3_RBAR_CONTROL_INDEX1),
    .PF3_RBAR_CONTROL_INDEX2 (PF3_RBAR_CONTROL_INDEX2),
    .PF3_RBAR_CONTROL_SIZE0 (PF3_RBAR_CONTROL_SIZE0),
    .PF3_RBAR_CONTROL_SIZE1 (PF3_RBAR_CONTROL_SIZE1),
    .PF3_RBAR_CONTROL_SIZE2 (PF3_RBAR_CONTROL_SIZE2),
    .PF3_RBAR_NUM (PF3_RBAR_NUM),
    .PF3_REVISION_ID (PF3_REVISION_ID),
    .PF3_SRIOV_BAR0_APERTURE_SIZE (PF3_SRIOV_BAR0_APERTURE_SIZE),
    .PF3_SRIOV_BAR0_CONTROL (PF3_SRIOV_BAR0_CONTROL),
    .PF3_SRIOV_BAR1_APERTURE_SIZE (PF3_SRIOV_BAR1_APERTURE_SIZE),
    .PF3_SRIOV_BAR1_CONTROL (PF3_SRIOV_BAR1_CONTROL),
    .PF3_SRIOV_BAR2_APERTURE_SIZE (PF3_SRIOV_BAR2_APERTURE_SIZE),
    .PF3_SRIOV_BAR2_CONTROL (PF3_SRIOV_BAR2_CONTROL),
    .PF3_SRIOV_BAR3_APERTURE_SIZE (PF3_SRIOV_BAR3_APERTURE_SIZE),
    .PF3_SRIOV_BAR3_CONTROL (PF3_SRIOV_BAR3_CONTROL),
    .PF3_SRIOV_BAR4_APERTURE_SIZE (PF3_SRIOV_BAR4_APERTURE_SIZE),
    .PF3_SRIOV_BAR4_CONTROL (PF3_SRIOV_BAR4_CONTROL),
    .PF3_SRIOV_BAR5_APERTURE_SIZE (PF3_SRIOV_BAR5_APERTURE_SIZE),
    .PF3_SRIOV_BAR5_CONTROL (PF3_SRIOV_BAR5_CONTROL),
    .PF3_SRIOV_CAP_INITIAL_VF (PF3_SRIOV_CAP_INITIAL_VF),
    .PF3_SRIOV_CAP_NEXTPTR (PF3_SRIOV_CAP_NEXTPTR),
    .PF3_SRIOV_CAP_TOTAL_VF (PF3_SRIOV_CAP_TOTAL_VF),
    .PF3_SRIOV_CAP_VER (PF3_SRIOV_CAP_VER),
    .PF3_SRIOV_FIRST_VF_OFFSET (PF3_SRIOV_FIRST_VF_OFFSET),
    .PF3_SRIOV_FUNC_DEP_LINK (PF3_SRIOV_FUNC_DEP_LINK),
    .PF3_SRIOV_SUPPORTED_PAGE_SIZE (PF3_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF3_SRIOV_VF_DEVICE_ID (PF3_SRIOV_VF_DEVICE_ID),
    .PF3_SUBSYSTEM_ID (PF3_SUBSYSTEM_ID),
    .PF3_TPHR_CAP_DEV_SPECIFIC_MODE (PF3_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF3_TPHR_CAP_ENABLE (PF3_TPHR_CAP_ENABLE),
    .PF3_TPHR_CAP_INT_VEC_MODE (PF3_TPHR_CAP_INT_VEC_MODE),
    .PF3_TPHR_CAP_NEXTPTR (PF3_TPHR_CAP_NEXTPTR),
    .PF3_TPHR_CAP_ST_MODE_SEL (PF3_TPHR_CAP_ST_MODE_SEL),
    .PF3_TPHR_CAP_ST_TABLE_LOC (PF3_TPHR_CAP_ST_TABLE_LOC),
    .PF3_TPHR_CAP_ST_TABLE_SIZE (PF3_TPHR_CAP_ST_TABLE_SIZE),
    .PF3_TPHR_CAP_VER (PF3_TPHR_CAP_VER),
    .PL_DISABLE_AUTO_EQ_SPEED_CHANGE_TO_GEN3 (PL_DISABLE_AUTO_EQ_SPEED_CHANGE_TO_GEN3),
    .PL_DISABLE_AUTO_SPEED_CHANGE_TO_GEN2 (PL_DISABLE_AUTO_SPEED_CHANGE_TO_GEN2),
    .PL_DISABLE_EI_INFER_IN_L0 (PL_DISABLE_EI_INFER_IN_L0),
    .PL_DISABLE_GEN3_DC_BALANCE (PL_DISABLE_GEN3_DC_BALANCE),
    .PL_DISABLE_GEN3_LFSR_UPDATE_ON_SKP (PL_DISABLE_GEN3_LFSR_UPDATE_ON_SKP),
    .PL_DISABLE_RETRAIN_ON_FRAMING_ERROR (PL_DISABLE_RETRAIN_ON_FRAMING_ERROR),
    .PL_DISABLE_SCRAMBLING (PL_DISABLE_SCRAMBLING),
    .PL_DISABLE_SYNC_HEADER_FRAMING_ERROR (PL_DISABLE_SYNC_HEADER_FRAMING_ERROR),
    .PL_DISABLE_UPCONFIG_CAPABLE (PL_DISABLE_UPCONFIG_CAPABLE),
    .PL_EQ_ADAPT_DISABLE_COEFF_CHECK (PL_EQ_ADAPT_DISABLE_COEFF_CHECK),
    .PL_EQ_ADAPT_DISABLE_PRESET_CHECK (PL_EQ_ADAPT_DISABLE_PRESET_CHECK),
    .PL_EQ_ADAPT_ITER_COUNT (PL_EQ_ADAPT_ITER_COUNT),
    .PL_EQ_ADAPT_REJECT_RETRY_COUNT (PL_EQ_ADAPT_REJECT_RETRY_COUNT),
    .PL_EQ_BYPASS_PHASE23 (PL_EQ_BYPASS_PHASE23),
    .PL_EQ_DEFAULT_GEN3_RX_PRESET_HINT (PL_EQ_DEFAULT_GEN3_RX_PRESET_HINT),
    .PL_EQ_DEFAULT_GEN3_TX_PRESET (PL_EQ_DEFAULT_GEN3_TX_PRESET),
    .PL_EQ_PHASE01_RX_ADAPT (PL_EQ_PHASE01_RX_ADAPT),
    .PL_EQ_SHORT_ADAPT_PHASE (PL_EQ_SHORT_ADAPT_PHASE),
    .PL_LANE0_EQ_CONTROL (PL_LANE0_EQ_CONTROL),
    .PL_LANE1_EQ_CONTROL (PL_LANE1_EQ_CONTROL),
    .PL_LANE2_EQ_CONTROL (PL_LANE2_EQ_CONTROL),
    .PL_LANE3_EQ_CONTROL (PL_LANE3_EQ_CONTROL),
    .PL_LANE4_EQ_CONTROL (PL_LANE4_EQ_CONTROL),
    .PL_LANE5_EQ_CONTROL (PL_LANE5_EQ_CONTROL),
    .PL_LANE6_EQ_CONTROL (PL_LANE6_EQ_CONTROL),
    .PL_LANE7_EQ_CONTROL (PL_LANE7_EQ_CONTROL),
    .PL_LINK_CAP_MAX_LINK_SPEED (PL_LINK_CAP_MAX_LINK_SPEED),
    .PL_LINK_CAP_MAX_LINK_WIDTH (PL_LINK_CAP_MAX_LINK_WIDTH),
    .PL_N_FTS_COMCLK_GEN1 (PL_N_FTS_COMCLK_GEN1),
    .PL_N_FTS_COMCLK_GEN2 (PL_N_FTS_COMCLK_GEN2),
    .PL_N_FTS_COMCLK_GEN3 (PL_N_FTS_COMCLK_GEN3),
    .PL_N_FTS_GEN1 (PL_N_FTS_GEN1),
    .PL_N_FTS_GEN2 (PL_N_FTS_GEN2),
    .PL_N_FTS_GEN3 (PL_N_FTS_GEN3),
    .PL_REPORT_ALL_PHY_ERRORS (PL_REPORT_ALL_PHY_ERRORS),
  // synthesis translate_off
    .PL_SIM_FAST_LINK_TRAINING (PL_SIM_FAST_LINK_TRAINING),
  // synthesis translate_on
    .PL_UPSTREAM_FACING (PL_UPSTREAM_FACING),
    .PM_ASPML0S_TIMEOUT (PM_ASPML0S_TIMEOUT),
    .PM_ASPML1_ENTRY_DELAY (PM_ASPML1_ENTRY_DELAY),
    .PM_ENABLE_L23_ENTRY (PM_ENABLE_L23_ENTRY),
    .PM_ENABLE_SLOT_POWER_CAPTURE (PM_ENABLE_SLOT_POWER_CAPTURE),
    .PM_L1_REENTRY_DELAY (PM_L1_REENTRY_DELAY),
    .PM_PME_SERVICE_TIMEOUT_DELAY (PM_PME_SERVICE_TIMEOUT_DELAY),
    .PM_PME_TURNOFF_ACK_DELAY (PM_PME_TURNOFF_ACK_DELAY),
    .SIM_JTAG_IDCODE (SIM_JTAG_IDCODE),
    .SIM_VERSION (SIM_VERSION),
    .SPARE_BIT0 (SPARE_BIT0),
    .SPARE_BIT1 (SPARE_BIT1),
    .SPARE_BIT2 (SPARE_BIT2),
    .SPARE_BIT3 (SPARE_BIT3),
    .SPARE_BIT4 (SPARE_BIT4),
    .SPARE_BIT5 (SPARE_BIT5),
    .SPARE_BIT6 (SPARE_BIT6),
    .SPARE_BIT7 (SPARE_BIT7),
    .SPARE_BIT8 (SPARE_BIT8),
    .SPARE_BYTE0 (SPARE_BYTE0),
    .SPARE_BYTE1 (SPARE_BYTE1),
    .SPARE_BYTE2 (SPARE_BYTE2),
    .SPARE_BYTE3 (SPARE_BYTE3),
    .SPARE_WORD0 (SPARE_WORD0),
    .SPARE_WORD1 (SPARE_WORD1),
    .SPARE_WORD2 (SPARE_WORD2),
    .SPARE_WORD3 (SPARE_WORD3),
    .SRIOV_CAP_ENABLE (SRIOV_CAP_ENABLE),
    .TL_COMPL_TIMEOUT_REG0 (TL_COMPL_TIMEOUT_REG0),
    .TL_COMPL_TIMEOUT_REG1 (TL_COMPL_TIMEOUT_REG1),
    .TL_CREDITS_CD (TL_CREDITS_CD),
    .TL_CREDITS_CH (TL_CREDITS_CH),
    .TL_CREDITS_NPD (TL_CREDITS_NPD),
    .TL_CREDITS_NPH (TL_CREDITS_NPH),
    .TL_CREDITS_PD (TL_CREDITS_PD),
    .TL_CREDITS_PH (TL_CREDITS_PH),
    .TL_ENABLE_MESSAGE_RID_CHECK_ENABLE (TL_ENABLE_MESSAGE_RID_CHECK_ENABLE),
    .TL_EXTENDED_CFG_EXTEND_INTERFACE_ENABLE (TL_EXTENDED_CFG_EXTEND_INTERFACE_ENABLE),
    .TL_LEGACY_CFG_EXTEND_INTERFACE_ENABLE (TL_LEGACY_CFG_EXTEND_INTERFACE_ENABLE),
    .TL_LEGACY_MODE_ENABLE (TL_LEGACY_MODE_ENABLE),
    .TL_PF_ENABLE_REG (TL_PF_ENABLE_REG),
    .TL_TX_MUX_STRICT_PRIORITY (TL_TX_MUX_STRICT_PRIORITY),
    .TWO_LAYER_MODE_DLCMSM_ENABLE (TWO_LAYER_MODE_DLCMSM_ENABLE),
    .TWO_LAYER_MODE_ENABLE (TWO_LAYER_MODE_ENABLE),
    .TWO_LAYER_MODE_WIDTH_256 (TWO_LAYER_MODE_WIDTH_256),
    .VF0_ARI_CAP_NEXTPTR (VF0_ARI_CAP_NEXTPTR),
    .VF0_CAPABILITY_POINTER (VF0_CAPABILITY_POINTER),
    .VF0_MSI_CAP_MULTIMSGCAP (VF0_MSI_CAP_MULTIMSGCAP),
    .VF0_MSIX_CAP_PBA_BIR (VF0_MSIX_CAP_PBA_BIR),
    .VF0_MSIX_CAP_PBA_OFFSET (VF0_MSIX_CAP_PBA_OFFSET),
    .VF0_MSIX_CAP_TABLE_BIR (VF0_MSIX_CAP_TABLE_BIR),
    .VF0_MSIX_CAP_TABLE_OFFSET (VF0_MSIX_CAP_TABLE_OFFSET),
    .VF0_MSIX_CAP_TABLE_SIZE (VF0_MSIX_CAP_TABLE_SIZE),
    .VF0_PM_CAP_ID (VF0_PM_CAP_ID),
    .VF0_PM_CAP_NEXTPTR (VF0_PM_CAP_NEXTPTR),
    .VF0_PM_CAP_VER_ID (VF0_PM_CAP_VER_ID),
    .VF0_TPHR_CAP_DEV_SPECIFIC_MODE (VF0_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF0_TPHR_CAP_ENABLE (VF0_TPHR_CAP_ENABLE),
    .VF0_TPHR_CAP_INT_VEC_MODE (VF0_TPHR_CAP_INT_VEC_MODE),
    .VF0_TPHR_CAP_NEXTPTR (VF0_TPHR_CAP_NEXTPTR),
    .VF0_TPHR_CAP_ST_MODE_SEL (VF0_TPHR_CAP_ST_MODE_SEL),
    .VF0_TPHR_CAP_ST_TABLE_LOC (VF0_TPHR_CAP_ST_TABLE_LOC),
    .VF0_TPHR_CAP_ST_TABLE_SIZE (VF0_TPHR_CAP_ST_TABLE_SIZE),
    .VF0_TPHR_CAP_VER (VF0_TPHR_CAP_VER),
    .VF1_ARI_CAP_NEXTPTR (VF1_ARI_CAP_NEXTPTR),
    .VF1_MSI_CAP_MULTIMSGCAP (VF1_MSI_CAP_MULTIMSGCAP),
    .VF1_MSIX_CAP_PBA_BIR (VF1_MSIX_CAP_PBA_BIR),
    .VF1_MSIX_CAP_PBA_OFFSET (VF1_MSIX_CAP_PBA_OFFSET),
    .VF1_MSIX_CAP_TABLE_BIR (VF1_MSIX_CAP_TABLE_BIR),
    .VF1_MSIX_CAP_TABLE_OFFSET (VF1_MSIX_CAP_TABLE_OFFSET),
    .VF1_MSIX_CAP_TABLE_SIZE (VF1_MSIX_CAP_TABLE_SIZE),
    .VF1_PM_CAP_ID (VF1_PM_CAP_ID),
    .VF1_PM_CAP_NEXTPTR (VF1_PM_CAP_NEXTPTR),
    .VF1_PM_CAP_VER_ID (VF1_PM_CAP_VER_ID),
    .VF1_TPHR_CAP_DEV_SPECIFIC_MODE (VF1_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF1_TPHR_CAP_ENABLE (VF1_TPHR_CAP_ENABLE),
    .VF1_TPHR_CAP_INT_VEC_MODE (VF1_TPHR_CAP_INT_VEC_MODE),
    .VF1_TPHR_CAP_NEXTPTR (VF1_TPHR_CAP_NEXTPTR),
    .VF1_TPHR_CAP_ST_MODE_SEL (VF1_TPHR_CAP_ST_MODE_SEL),
    .VF1_TPHR_CAP_ST_TABLE_LOC (VF1_TPHR_CAP_ST_TABLE_LOC),
    .VF1_TPHR_CAP_ST_TABLE_SIZE (VF1_TPHR_CAP_ST_TABLE_SIZE),
    .VF1_TPHR_CAP_VER (VF1_TPHR_CAP_VER),
    .VF2_ARI_CAP_NEXTPTR (VF2_ARI_CAP_NEXTPTR),
    .VF2_MSI_CAP_MULTIMSGCAP (VF2_MSI_CAP_MULTIMSGCAP),
    .VF2_MSIX_CAP_PBA_BIR (VF2_MSIX_CAP_PBA_BIR),
    .VF2_MSIX_CAP_PBA_OFFSET (VF2_MSIX_CAP_PBA_OFFSET),
    .VF2_MSIX_CAP_TABLE_BIR (VF2_MSIX_CAP_TABLE_BIR),
    .VF2_MSIX_CAP_TABLE_OFFSET (VF2_MSIX_CAP_TABLE_OFFSET),
    .VF2_MSIX_CAP_TABLE_SIZE (VF2_MSIX_CAP_TABLE_SIZE),
    .VF2_PM_CAP_ID (VF2_PM_CAP_ID),
    .VF2_PM_CAP_NEXTPTR (VF2_PM_CAP_NEXTPTR),
    .VF2_PM_CAP_VER_ID (VF2_PM_CAP_VER_ID),
    .VF2_TPHR_CAP_DEV_SPECIFIC_MODE (VF2_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF2_TPHR_CAP_ENABLE (VF2_TPHR_CAP_ENABLE),
    .VF2_TPHR_CAP_INT_VEC_MODE (VF2_TPHR_CAP_INT_VEC_MODE),
    .VF2_TPHR_CAP_NEXTPTR (VF2_TPHR_CAP_NEXTPTR),
    .VF2_TPHR_CAP_ST_MODE_SEL (VF2_TPHR_CAP_ST_MODE_SEL),
    .VF2_TPHR_CAP_ST_TABLE_LOC (VF2_TPHR_CAP_ST_TABLE_LOC),
    .VF2_TPHR_CAP_ST_TABLE_SIZE (VF2_TPHR_CAP_ST_TABLE_SIZE),
    .VF2_TPHR_CAP_VER (VF2_TPHR_CAP_VER),
    .VF3_ARI_CAP_NEXTPTR (VF3_ARI_CAP_NEXTPTR),
    .VF3_MSI_CAP_MULTIMSGCAP (VF3_MSI_CAP_MULTIMSGCAP),
    .VF3_MSIX_CAP_PBA_BIR (VF3_MSIX_CAP_PBA_BIR),
    .VF3_MSIX_CAP_PBA_OFFSET (VF3_MSIX_CAP_PBA_OFFSET),
    .VF3_MSIX_CAP_TABLE_BIR (VF3_MSIX_CAP_TABLE_BIR),
    .VF3_MSIX_CAP_TABLE_OFFSET (VF3_MSIX_CAP_TABLE_OFFSET),
    .VF3_MSIX_CAP_TABLE_SIZE (VF3_MSIX_CAP_TABLE_SIZE),
    .VF3_PM_CAP_ID (VF3_PM_CAP_ID),
    .VF3_PM_CAP_NEXTPTR (VF3_PM_CAP_NEXTPTR),
    .VF3_PM_CAP_VER_ID (VF3_PM_CAP_VER_ID),
    .VF3_TPHR_CAP_DEV_SPECIFIC_MODE (VF3_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF3_TPHR_CAP_ENABLE (VF3_TPHR_CAP_ENABLE),
    .VF3_TPHR_CAP_INT_VEC_MODE (VF3_TPHR_CAP_INT_VEC_MODE),
    .VF3_TPHR_CAP_NEXTPTR (VF3_TPHR_CAP_NEXTPTR),
    .VF3_TPHR_CAP_ST_MODE_SEL (VF3_TPHR_CAP_ST_MODE_SEL),
    .VF3_TPHR_CAP_ST_TABLE_LOC (VF3_TPHR_CAP_ST_TABLE_LOC),
    .VF3_TPHR_CAP_ST_TABLE_SIZE (VF3_TPHR_CAP_ST_TABLE_SIZE),
    .VF3_TPHR_CAP_VER (VF3_TPHR_CAP_VER),
    .VF4_ARI_CAP_NEXTPTR (VF4_ARI_CAP_NEXTPTR),
    .VF4_MSI_CAP_MULTIMSGCAP (VF4_MSI_CAP_MULTIMSGCAP),
    .VF4_MSIX_CAP_PBA_BIR (VF4_MSIX_CAP_PBA_BIR),
    .VF4_MSIX_CAP_PBA_OFFSET (VF4_MSIX_CAP_PBA_OFFSET),
    .VF4_MSIX_CAP_TABLE_BIR (VF4_MSIX_CAP_TABLE_BIR),
    .VF4_MSIX_CAP_TABLE_OFFSET (VF4_MSIX_CAP_TABLE_OFFSET),
    .VF4_MSIX_CAP_TABLE_SIZE (VF4_MSIX_CAP_TABLE_SIZE),
    .VF4_PM_CAP_ID (VF4_PM_CAP_ID),
    .VF4_PM_CAP_NEXTPTR (VF4_PM_CAP_NEXTPTR),
    .VF4_PM_CAP_VER_ID (VF4_PM_CAP_VER_ID),
    .VF4_TPHR_CAP_DEV_SPECIFIC_MODE (VF4_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF4_TPHR_CAP_ENABLE (VF4_TPHR_CAP_ENABLE),
    .VF4_TPHR_CAP_INT_VEC_MODE (VF4_TPHR_CAP_INT_VEC_MODE),
    .VF4_TPHR_CAP_NEXTPTR (VF4_TPHR_CAP_NEXTPTR),
    .VF4_TPHR_CAP_ST_MODE_SEL (VF4_TPHR_CAP_ST_MODE_SEL),
    .VF4_TPHR_CAP_ST_TABLE_LOC (VF4_TPHR_CAP_ST_TABLE_LOC),
    .VF4_TPHR_CAP_ST_TABLE_SIZE (VF4_TPHR_CAP_ST_TABLE_SIZE),
    .VF4_TPHR_CAP_VER (VF4_TPHR_CAP_VER),
    .VF5_ARI_CAP_NEXTPTR (VF5_ARI_CAP_NEXTPTR),
    .VF5_MSI_CAP_MULTIMSGCAP (VF5_MSI_CAP_MULTIMSGCAP),
    .VF5_MSIX_CAP_PBA_BIR (VF5_MSIX_CAP_PBA_BIR),
    .VF5_MSIX_CAP_PBA_OFFSET (VF5_MSIX_CAP_PBA_OFFSET),
    .VF5_MSIX_CAP_TABLE_BIR (VF5_MSIX_CAP_TABLE_BIR),
    .VF5_MSIX_CAP_TABLE_OFFSET (VF5_MSIX_CAP_TABLE_OFFSET),
    .VF5_MSIX_CAP_TABLE_SIZE (VF5_MSIX_CAP_TABLE_SIZE),
    .VF5_PM_CAP_ID (VF5_PM_CAP_ID),
    .VF5_PM_CAP_NEXTPTR (VF5_PM_CAP_NEXTPTR),
    .VF5_PM_CAP_VER_ID (VF5_PM_CAP_VER_ID),
    .VF5_TPHR_CAP_DEV_SPECIFIC_MODE (VF5_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF5_TPHR_CAP_ENABLE (VF5_TPHR_CAP_ENABLE),
    .VF5_TPHR_CAP_INT_VEC_MODE (VF5_TPHR_CAP_INT_VEC_MODE),
    .VF5_TPHR_CAP_NEXTPTR (VF5_TPHR_CAP_NEXTPTR),
    .VF5_TPHR_CAP_ST_MODE_SEL (VF5_TPHR_CAP_ST_MODE_SEL),
    .VF5_TPHR_CAP_ST_TABLE_LOC (VF5_TPHR_CAP_ST_TABLE_LOC),
    .VF5_TPHR_CAP_ST_TABLE_SIZE (VF5_TPHR_CAP_ST_TABLE_SIZE),
    .VF5_TPHR_CAP_VER (VF5_TPHR_CAP_VER),
    .VF6_ARI_CAP_NEXTPTR (VF6_ARI_CAP_NEXTPTR),
    .VF6_MSI_CAP_MULTIMSGCAP (VF6_MSI_CAP_MULTIMSGCAP),
    .VF6_MSIX_CAP_PBA_BIR (VF6_MSIX_CAP_PBA_BIR),
    .VF6_MSIX_CAP_PBA_OFFSET (VF6_MSIX_CAP_PBA_OFFSET),
    .VF6_MSIX_CAP_TABLE_BIR (VF6_MSIX_CAP_TABLE_BIR),
    .VF6_MSIX_CAP_TABLE_OFFSET (VF6_MSIX_CAP_TABLE_OFFSET),
    .VF6_MSIX_CAP_TABLE_SIZE (VF6_MSIX_CAP_TABLE_SIZE),
    .VF6_PM_CAP_ID (VF6_PM_CAP_ID),
    .VF6_PM_CAP_NEXTPTR (VF6_PM_CAP_NEXTPTR),
    .VF6_PM_CAP_VER_ID (VF6_PM_CAP_VER_ID),
    .VF6_TPHR_CAP_DEV_SPECIFIC_MODE (VF6_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF6_TPHR_CAP_ENABLE (VF6_TPHR_CAP_ENABLE),
    .VF6_TPHR_CAP_INT_VEC_MODE (VF6_TPHR_CAP_INT_VEC_MODE),
    .VF6_TPHR_CAP_NEXTPTR (VF6_TPHR_CAP_NEXTPTR),
    .VF6_TPHR_CAP_ST_MODE_SEL (VF6_TPHR_CAP_ST_MODE_SEL),
    .VF6_TPHR_CAP_ST_TABLE_LOC (VF6_TPHR_CAP_ST_TABLE_LOC),
    .VF6_TPHR_CAP_ST_TABLE_SIZE (VF6_TPHR_CAP_ST_TABLE_SIZE),
    .VF6_TPHR_CAP_VER (VF6_TPHR_CAP_VER),
    .VF7_ARI_CAP_NEXTPTR (VF7_ARI_CAP_NEXTPTR),
    .VF7_MSI_CAP_MULTIMSGCAP (VF7_MSI_CAP_MULTIMSGCAP),
    .VF7_MSIX_CAP_PBA_BIR (VF7_MSIX_CAP_PBA_BIR),
    .VF7_MSIX_CAP_PBA_OFFSET (VF7_MSIX_CAP_PBA_OFFSET),
    .VF7_MSIX_CAP_TABLE_BIR (VF7_MSIX_CAP_TABLE_BIR),
    .VF7_MSIX_CAP_TABLE_OFFSET (VF7_MSIX_CAP_TABLE_OFFSET),
    .VF7_MSIX_CAP_TABLE_SIZE (VF7_MSIX_CAP_TABLE_SIZE),
    .VF7_PM_CAP_ID (VF7_PM_CAP_ID),
    .VF7_PM_CAP_NEXTPTR (VF7_PM_CAP_NEXTPTR),
    .VF7_PM_CAP_VER_ID (VF7_PM_CAP_VER_ID),
    .VF7_TPHR_CAP_DEV_SPECIFIC_MODE (VF7_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF7_TPHR_CAP_ENABLE (VF7_TPHR_CAP_ENABLE),
    .VF7_TPHR_CAP_INT_VEC_MODE (VF7_TPHR_CAP_INT_VEC_MODE),
    .VF7_TPHR_CAP_NEXTPTR (VF7_TPHR_CAP_NEXTPTR),
    .VF7_TPHR_CAP_ST_MODE_SEL (VF7_TPHR_CAP_ST_MODE_SEL),
    .VF7_TPHR_CAP_ST_TABLE_LOC (VF7_TPHR_CAP_ST_TABLE_LOC),
    .VF7_TPHR_CAP_ST_TABLE_SIZE (VF7_TPHR_CAP_ST_TABLE_SIZE),
    .VF7_TPHR_CAP_VER (VF7_TPHR_CAP_VER))
  pcie3_uscale_wrapper_inst (
    .CFGCONFIGSPACEENABLE (cfg_config_space_enable),
    .CFGDEVID (cfg_dev_id),
    .CFGDSBUSNUMBER (cfg_ds_bus_number),
    .CFGDSDEVICENUMBER (cfg_ds_device_number),
    .CFGDSFUNCTIONNUMBER (cfg_ds_function_number),
    .CFGDSN (cfg_dsn),
    .CFGDSPORTNUMBER (cfg_ds_port_number),
    .CFGERRCORIN (cfg_err_cor_in),
    .CFGERRUNCORIN (cfg_err_uncor_in),
    .CFGEXTREADDATA (cfg_ext_read_data),
    .CFGEXTREADDATAVALID (cfg_ext_read_data_valid),
    .CFGFCSEL (cfg_fc_sel),
    .CFGFLRDONE (cfg_flr_done),
    .CFGHOTRESETIN (cfg_hot_reset_in),
    .CFGINTERRUPTINT (cfg_interrupt_int),
    .CFGINTERRUPTMSIATTR (cfg_interrupt_msi_attr),
    .CFGINTERRUPTMSIFUNCTIONNUMBER (cfg_interrupt_msi_function_number),
    .CFGINTERRUPTMSIINT (cfg_interrupt_msi_int),
    .CFGINTERRUPTMSIPENDINGSTATUS (cfg_interrupt_msi_pending_status),
    .CFGINTERRUPTMSIPENDINGSTATUSDATAENABLE (cfg_interrupt_msi_pending_status_data_enable),
    .CFGINTERRUPTMSIPENDINGSTATUSFUNCTIONNUM (cfg_interrupt_msi_pending_status_function_num),
    .CFGINTERRUPTMSISELECT (cfg_interrupt_msi_select),
    .CFGINTERRUPTMSITPHPRESENT (cfg_interrupt_msi_tph_present),
    .CFGINTERRUPTMSITPHSTTAG (cfg_interrupt_msi_tph_st_tag),
    .CFGINTERRUPTMSITPHTYPE (cfg_interrupt_msi_tph_type),
    .CFGINTERRUPTMSIXADDRESS (cfg_interrupt_msix_address),
    .CFGINTERRUPTMSIXDATA (cfg_interrupt_msix_data),
    .CFGINTERRUPTMSIXINT (cfg_interrupt_msix_int),
    .CFGINTERRUPTPENDING (cfg_interrupt_pending),
    .CFGLINKTRAININGENABLE (cfg_link_training_enable),
    .CFGMGMTADDR (cfg_mgmt_addr),
    .CFGMGMTBYTEENABLE (cfg_mgmt_byte_enable),
    .CFGMGMTREAD (cfg_mgmt_read),
    .CFGMGMTTYPE1CFGREGACCESS (cfg_mgmt_type1_cfg_reg_access),
    .CFGMGMTWRITE (cfg_mgmt_write),
    .CFGMGMTWRITEDATA (cfg_mgmt_write_data),
    .CFGMSGTRANSMIT (cfg_msg_transmit),
    .CFGMSGTRANSMITDATA (cfg_msg_transmit_data),
    .CFGMSGTRANSMITTYPE (cfg_msg_transmit_type),
    .CFGPERFUNCSTATUSCONTROL (cfg_per_func_status_control),
    .CFGPERFUNCTIONNUMBER (cfg_per_function_number),
    .CFGPERFUNCTIONOUTPUTREQUEST (cfg_per_function_output_request),
    .CFGPOWERSTATECHANGEACK (cfg_power_state_change_ack),
    .CFGREQPMTRANSITIONL23READY (cfg_req_pm_transition_l23_ready),
    .CFGREVID (cfg_rev_id),
    .CFGSUBSYSID (cfg_subsys_id),
    .CFGSUBSYSVENDID (cfg_subsys_vend_id),
    .CFGTPHSTTREADDATA (cfg_tph_stt_read_data),
    .CFGTPHSTTREADDATAVALID (cfg_tph_stt_read_data_valid),
    .CFGVENDID (cfg_vend_id),
    .CFGVFFLRDONE (cfg_vf_flr_done),
    .CONFMCAPREQUESTBYCONF (conf_mcap_request_by_conf),
    .CONFREQDATA (conf_req_data),
    .CONFREQREGNUM (conf_req_reg_num),
    .CONFREQTYPE (conf_req_type),
    .CONFREQVALID (conf_req_valid),
    .CORECLK (core_clk),
    .CORECLKMICOMPLETIONRAML (core_clk),
    .CORECLKMICOMPLETIONRAMU (core_clk),
    .CORECLKMIREPLAYRAM (core_clk),
    .CORECLKMIREQUESTRAM (core_clk),
    .DBGCFGLOCALMGMTREGOVERRIDE (dbg_cfg_local_mgmt_reg_override),
    .DBGDATASEL (4'b0),
    .DRPADDR (drp_addr),
    .DRPCLK (drp_clk),
    .DRPDI (drp_di),
    .DRPEN (drp_en),
    .DRPWE (drp_we),
    .LL2LMSAXISTXTUSER (14'b0),  
    .LL2LMSAXISTXTVALID (1'b0),  
    .LL2LMTXTLPID0 (4'b0),  
    .LL2LMTXTLPID1 (4'b0),  
    .MAXISCQTREADY (m_axis_cq_tready),
    .MAXISRCTREADY (m_axis_rc_tready),
    .MCAPCLK (mcap_clk),
    .MCAPPERST0B (pcie_perstn0_in),
    .MCAPPERST1B (pcie_perstn1_in),
    .MGMTRESETN (mgmt_reset_n),
    .MGMTSTICKYRESETN (mgmt_sticky_reset_n),
    .PCIECQNPREQ (pcie_cq_np_req),
    .PIPECLK (pipe_clk),
    .PIPEEQFS (pipe_tx_eqfs),
    .PIPEEQLF (pipe_tx_eqlf),
    .PIPERESETN (pipe_reset_n),
    .PIPERX0CHARISK (pipe_rx0_char_is_k),
    .PIPERX0DATA (pipe_rx0_data),
    .PIPERX0DATAVALID (pipe_rx0_data_valid),
    .PIPERX0ELECIDLE (pipe_rx0_elec_idle),
    .PIPERX0EQDONE (pipe_rx0_eqdone),
    .PIPERX0EQLPADAPTDONE (pipe_rx0_eqlp_adaptdone),
    .PIPERX0EQLPLFFSSEL (pipe_rx0_eqlp_lffs_sel),
    .PIPERX0EQLPNEWTXCOEFFORPRESET (pipe_rx0_eqlp_new_txcoef_forpreset),
    .PIPERX0PHYSTATUS (pipe_rx0_phy_status),
    .PIPERX0STARTBLOCK (pipe_rx0_start_block),
    .PIPERX0STATUS (pipe_rx0_status),
    .PIPERX0SYNCHEADER (pipe_rx0_syncheader),
    .PIPERX0VALID (pipe_rx0_valid),
    .PIPERX1CHARISK (pipe_rx1_char_is_k),
    .PIPERX1DATA (pipe_rx1_data),
    .PIPERX1DATAVALID (pipe_rx1_data_valid),
    .PIPERX1ELECIDLE (pipe_rx1_elec_idle),
    .PIPERX1EQDONE (pipe_rx1_eqdone),
    .PIPERX1EQLPADAPTDONE (pipe_rx1_eqlp_adaptdone),
    .PIPERX1EQLPLFFSSEL (pipe_rx1_eqlp_lffs_sel),
    .PIPERX1EQLPNEWTXCOEFFORPRESET (pipe_rx1_eqlp_new_txcoef_forpreset),
    .PIPERX1PHYSTATUS (pipe_rx1_phy_status),
    .PIPERX1STARTBLOCK (pipe_rx1_start_block),
    .PIPERX1STATUS (pipe_rx1_status),
    .PIPERX1SYNCHEADER (pipe_rx1_syncheader),
    .PIPERX1VALID (pipe_rx1_valid),
    .PIPERX2CHARISK (pipe_rx2_char_is_k),
    .PIPERX2DATA (pipe_rx2_data),
    .PIPERX2DATAVALID (pipe_rx2_data_valid),
    .PIPERX2ELECIDLE (pipe_rx2_elec_idle),
    .PIPERX2EQDONE (pipe_rx2_eqdone),
    .PIPERX2EQLPADAPTDONE (pipe_rx2_eqlp_adaptdone),
    .PIPERX2EQLPLFFSSEL (pipe_rx2_eqlp_lffs_sel),
    .PIPERX2EQLPNEWTXCOEFFORPRESET (pipe_rx2_eqlp_new_txcoef_forpreset),
    .PIPERX2PHYSTATUS (pipe_rx2_phy_status),
    .PIPERX2STARTBLOCK (pipe_rx2_start_block),
    .PIPERX2STATUS (pipe_rx2_status),
    .PIPERX2SYNCHEADER (pipe_rx2_syncheader),
    .PIPERX2VALID (pipe_rx2_valid),
    .PIPERX3CHARISK (pipe_rx3_char_is_k),
    .PIPERX3DATA (pipe_rx3_data),
    .PIPERX3DATAVALID (pipe_rx3_data_valid),
    .PIPERX3ELECIDLE (pipe_rx3_elec_idle),
    .PIPERX3EQDONE (pipe_rx3_eqdone),
    .PIPERX3EQLPADAPTDONE (pipe_rx3_eqlp_adaptdone),
    .PIPERX3EQLPLFFSSEL (pipe_rx3_eqlp_lffs_sel),
    .PIPERX3EQLPNEWTXCOEFFORPRESET (pipe_rx3_eqlp_new_txcoef_forpreset),
    .PIPERX3PHYSTATUS (pipe_rx3_phy_status),
    .PIPERX3STARTBLOCK (pipe_rx3_start_block),
    .PIPERX3STATUS (pipe_rx3_status),
    .PIPERX3SYNCHEADER (pipe_rx3_syncheader),
    .PIPERX3VALID (pipe_rx3_valid),
    .PIPERX4CHARISK (pipe_rx4_char_is_k),
    .PIPERX4DATA (pipe_rx4_data),
    .PIPERX4DATAVALID (pipe_rx4_data_valid),
    .PIPERX4ELECIDLE (pipe_rx4_elec_idle),
    .PIPERX4EQDONE (pipe_rx4_eqdone),
    .PIPERX4EQLPADAPTDONE (pipe_rx4_eqlp_adaptdone),
    .PIPERX4EQLPLFFSSEL (pipe_rx4_eqlp_lffs_sel),
    .PIPERX4EQLPNEWTXCOEFFORPRESET (pipe_rx4_eqlp_new_txcoef_forpreset),
    .PIPERX4PHYSTATUS (pipe_rx4_phy_status),
    .PIPERX4STARTBLOCK (pipe_rx4_start_block),
    .PIPERX4STATUS (pipe_rx4_status),
    .PIPERX4SYNCHEADER (pipe_rx4_syncheader),
    .PIPERX4VALID (pipe_rx4_valid),
    .PIPERX5CHARISK (pipe_rx5_char_is_k),
    .PIPERX5DATA (pipe_rx5_data),
    .PIPERX5DATAVALID (pipe_rx5_data_valid),
    .PIPERX5ELECIDLE (pipe_rx5_elec_idle),
    .PIPERX5EQDONE (pipe_rx5_eqdone),
    .PIPERX5EQLPADAPTDONE (pipe_rx5_eqlp_adaptdone),
    .PIPERX5EQLPLFFSSEL (pipe_rx5_eqlp_lffs_sel),
    .PIPERX5EQLPNEWTXCOEFFORPRESET (pipe_rx5_eqlp_new_txcoef_forpreset),
    .PIPERX5PHYSTATUS (pipe_rx5_phy_status),
    .PIPERX5STARTBLOCK (pipe_rx5_start_block),
    .PIPERX5STATUS (pipe_rx5_status),
    .PIPERX5SYNCHEADER (pipe_rx5_syncheader),
    .PIPERX5VALID (pipe_rx5_valid),
    .PIPERX6CHARISK (pipe_rx6_char_is_k),
    .PIPERX6DATA (pipe_rx6_data),
    .PIPERX6DATAVALID (pipe_rx6_data_valid),
    .PIPERX6ELECIDLE (pipe_rx6_elec_idle),
    .PIPERX6EQDONE (pipe_rx6_eqdone),
    .PIPERX6EQLPADAPTDONE (pipe_rx6_eqlp_adaptdone),
    .PIPERX6EQLPLFFSSEL (pipe_rx6_eqlp_lffs_sel),
    .PIPERX6EQLPNEWTXCOEFFORPRESET (pipe_rx6_eqlp_new_txcoef_forpreset),
    .PIPERX6PHYSTATUS (pipe_rx6_phy_status),
    .PIPERX6STARTBLOCK (pipe_rx6_start_block),
    .PIPERX6STATUS (pipe_rx6_status),
    .PIPERX6SYNCHEADER (pipe_rx6_syncheader),
    .PIPERX6VALID (pipe_rx6_valid),
    .PIPERX7CHARISK (pipe_rx7_char_is_k),
    .PIPERX7DATA (pipe_rx7_data),
    .PIPERX7DATAVALID (pipe_rx7_data_valid),
    .PIPERX7ELECIDLE (pipe_rx7_elec_idle),
    .PIPERX7EQDONE (pipe_rx7_eqdone),
    .PIPERX7EQLPADAPTDONE (pipe_rx7_eqlp_adaptdone),
    .PIPERX7EQLPLFFSSEL (pipe_rx7_eqlp_lffs_sel),
    .PIPERX7EQLPNEWTXCOEFFORPRESET (pipe_rx7_eqlp_new_txcoef_forpreset),
    .PIPERX7PHYSTATUS (pipe_rx7_phy_status),
    .PIPERX7STARTBLOCK (pipe_rx7_start_block),
    .PIPERX7STATUS (pipe_rx7_status),
    .PIPERX7SYNCHEADER (pipe_rx7_syncheader),
    .PIPERX7VALID (pipe_rx7_valid),
    .PIPETX0EQCOEFF (pipe_tx0_eqcoeff),
    .PIPETX0EQDONE (pipe_tx0_eqdone),
    .PIPETX1EQCOEFF (pipe_tx1_eqcoeff),
    .PIPETX1EQDONE (pipe_tx1_eqdone),
    .PIPETX2EQCOEFF (pipe_tx2_eqcoeff),
    .PIPETX2EQDONE (pipe_tx2_eqdone),
    .PIPETX3EQCOEFF (pipe_tx3_eqcoeff),
    .PIPETX3EQDONE (pipe_tx3_eqdone),
    .PIPETX4EQCOEFF (pipe_tx4_eqcoeff),
    .PIPETX4EQDONE (pipe_tx4_eqdone),
    .PIPETX5EQCOEFF (pipe_tx5_eqcoeff),
    .PIPETX5EQDONE (pipe_tx5_eqdone),
    .PIPETX6EQCOEFF (pipe_tx6_eqcoeff),
    .PIPETX6EQDONE (pipe_tx6_eqdone),
    .PIPETX7EQCOEFF (pipe_tx7_eqcoeff),
    .PIPETX7EQDONE (pipe_tx7_eqdone),
    .PLEQRESETEIEOSCOUNT (pl_eq_reset_eieos_count),
    .PLGEN2UPSTREAMPREFERDEEMPH (pl_gen2_upstream_prefer_deemph),
    .RESETN (reset_n),
    .SPAREIN (32'b0),
    .USERCLK (user_clk),
    .CFGCURRENTSPEED (cfg_current_speed),
    .CFGDPASUBSTATECHANGE (cfg_dpa_substate_change),
    .CFGERRCOROUT (cfg_err_cor_out),
    .CFGERRFATALOUT (cfg_err_fatal_out),
    .CFGERRNONFATALOUT (cfg_err_nonfatal_out),
    .CFGEXTFUNCTIONNUMBER (cfg_ext_function_number),
    .CFGEXTREADRECEIVED (cfg_ext_read_received),
    .CFGEXTREGISTERNUMBER (cfg_ext_register_number),
    .CFGEXTWRITEBYTEENABLE (cfg_ext_write_byte_enable),
    .CFGEXTWRITEDATA (cfg_ext_write_data),
    .CFGEXTWRITERECEIVED (cfg_ext_write_received),
    .CFGFCCPLD (cfg_fc_cpld),
    .CFGFCCPLH (cfg_fc_cplh),
    .CFGFCNPD (cfg_fc_npd),
    .CFGFCNPH (cfg_fc_nph),
    .CFGFCPD (cfg_fc_pd),
    .CFGFCPH (cfg_fc_ph),
    .CFGFLRINPROCESS (cfg_flr_in_process),
    .CFGFUNCTIONPOWERSTATE (cfg_function_power_state),
    .CFGFUNCTIONSTATUS (cfg_function_status),
    .CFGHOTRESETOUT (cfg_hot_reset_out),
    .CFGINTERRUPTMSIDATA (cfg_interrupt_msi_data),
    .CFGINTERRUPTMSIENABLE (cfg_interrupt_msi_enable),
    .CFGINTERRUPTMSIFAIL (cfg_interrupt_msi_fail),
    .CFGINTERRUPTMSIMASKUPDATE (cfg_interrupt_msi_mask_update),
    .CFGINTERRUPTMSIMMENABLE (cfg_interrupt_msi_mmenable),
    .CFGINTERRUPTMSISENT (cfg_interrupt_msi_sent),
    .CFGINTERRUPTMSIVFENABLE (cfg_interrupt_msi_vf_enable),
    .CFGINTERRUPTMSIXENABLE (cfg_interrupt_msix_enable),
    .CFGINTERRUPTMSIXFAIL (cfg_interrupt_msix_fail),
    .CFGINTERRUPTMSIXMASK (cfg_interrupt_msix_mask),
    .CFGINTERRUPTMSIXSENT (cfg_interrupt_msix_sent),
    .CFGINTERRUPTMSIXVFENABLE (cfg_interrupt_msix_vf_enable),
    .CFGINTERRUPTMSIXVFMASK (cfg_interrupt_msix_vf_mask),
    .CFGINTERRUPTSENT (cfg_interrupt_sent),
    .CFGLINKPOWERSTATE (cfg_link_power_state),
    .CFGLOCALERROR (cfg_local_error),
    .CFGLTRENABLE (cfg_ltr_enable),
    .CFGLTSSMSTATE (cfg_ltssm_state),
    .CFGMAXPAYLOAD (cfg_max_payload),
    .CFGMAXREADREQ (cfg_max_read_req),
    .CFGMGMTREADDATA (cfg_mgmt_read_data),
    .CFGMGMTREADWRITEDONE (cfg_mgmt_read_write_done),
    .CFGMSGRECEIVED (cfg_msg_received),
    .CFGMSGRECEIVEDDATA (cfg_msg_received_data),
    .CFGMSGRECEIVEDTYPE (cfg_msg_received_type),
    .CFGMSGTRANSMITDONE (cfg_msg_transmit_done),
    .CFGNEGOTIATEDWIDTH (cfg_negotiated_width),
    .CFGOBFFENABLE (cfg_obff_enable),
    .CFGPERFUNCSTATUSDATA (cfg_per_func_status_data),
    .CFGPERFUNCTIONUPDATEDONE (cfg_per_function_update_done),
    .CFGPHYLINKDOWN (cfg_phy_link_down),
    .CFGPHYLINKSTATUS (cfg_phy_link_status),
    .CFGPLSTATUSCHANGE (cfg_pl_status_change),
    .CFGPOWERSTATECHANGEINTERRUPT (cfg_power_state_change_interrupt),
    .CFGRCBSTATUS (cfg_rcb_status),
    .CFGTPHFUNCTIONNUM (cfg_tph_function_num),
    .CFGTPHREQUESTERENABLE (cfg_tph_requester_enable),
    .CFGTPHSTMODE (cfg_tph_st_mode),
    .CFGTPHSTTADDRESS (cfg_tph_stt_address),
    .CFGTPHSTTREADENABLE (cfg_tph_stt_read_enable),
    .CFGTPHSTTWRITEBYTEVALID (cfg_tph_stt_write_byte_valid),
    .CFGTPHSTTWRITEDATA (cfg_tph_stt_write_data),
    .CFGTPHSTTWRITEENABLE (cfg_tph_stt_write_enable),
    .CFGVFFLRINPROCESS (cfg_vf_flr_in_process),
    .CFGVFPOWERSTATE (cfg_vf_power_state),
    .CFGVFSTATUS (cfg_vf_status),
    .CFGVFTPHREQUESTERENABLE (cfg_vf_tph_requester_enable),
    .CFGVFTPHSTMODE (cfg_vf_tph_st_mode),
    .CONFMCAPDESIGNSWITCH (conf_mcap_design_switch),
    .CONFMCAPEOS (conf_mcap_eos),
    .CONFMCAPINUSEBYPCIE (conf_mcap_in_use_by_pcie),
    .CONFREQREADY (conf_req_ready),
    .CONFRESPRDATA (conf_resp_rdata),
    .CONFRESPVALID (conf_resp_valid),
    .DBGDATAOUT (),
    .DBGMCAPCSB (dbg_mcap_cs_b),
    .DBGMCAPDATA (dbg_mcap_data),
    .DBGMCAPEOS (dbg_mcap_eos),
    .DBGMCAPERROR (dbg_mcap_errror),
    .DBGMCAPMODE (dbg_mcap_mode),
    .DBGMCAPRDATAVALID (dbg_mcap_rdata_valid),
    .DBGMCAPRDWRB (dbg_mcap_rdwr_b),
    .DBGMCAPRESET (dbg_mcap_reset),
    .DBGPLDATABLOCKRECEIVEDAFTEREDS (),
    .DBGPLGEN3FRAMINGERRORDETECTED (),
    .DBGPLGEN3SYNCHEADERERRORDETECTED (),
    .DBGPLINFERREDRXELECTRICALIDLE (),
    .DRPDO (drp_do),
    .DRPRDY (drp_rdy),
    .LL2LMMASTERTLPSENTTLPID0 (),  
    .LL2LMMASTERTLPSENTTLPID1 (),  
    .LL2LMMASTERTLPSENT0 (),  
    .LL2LMMASTERTLPSENT1 (),  
    .LL2LMMAXISRXTDATA (),  
    .LL2LMMAXISRXTUSER (),  
    .LL2LMMAXISRXTVALID (),  
    .LL2LMSAXISTXTREADY (),  
    .SAXISCCTDATA (s_axis_cc_tdata_i),
    .SAXISCCTKEEP (s_axis_cc_tkeep_i),
    .SAXISRQTDATA (s_axis_rq_tdata_i),
    .SAXISRQTKEEP (s_axis_rq_tkeep_i),
    .MAXISCQTDATA (m_axis_cq_tdata_i),
    .MAXISCQTKEEP (m_axis_cq_tkeep_i),
    .MAXISRCTDATA (m_axis_rc_tdata_i),
    .MAXISRCTKEEP (m_axis_rc_tkeep_i),
    .SAXISCCTLAST (s_axis_cc_tlast),
    .SAXISCCTUSER (s_axis_cc_tuser),
    .SAXISCCTVALID (s_axis_cc_tvalid),
    .SAXISRQTLAST (s_axis_rq_tlast),
    .SAXISRQTUSER (s_axis_rq_tuser),
    .SAXISRQTVALID (s_axis_rq_tvalid),
    .MAXISCQTLAST (m_axis_cq_tlast),
    .MAXISCQTUSER (m_axis_cq_tuser),
    .MAXISCQTVALID (m_axis_cq_tvalid),
    .MAXISRCTLAST (m_axis_rc_tlast),
    .MAXISRCTUSER (m_axis_rc_tuser),
    .MAXISRCTVALID (m_axis_rc_tvalid),
    .PCIECQNPREQCOUNT (pcie_cq_np_req_count),
    .PCIEPERST0B (pcie_perstn0_out),
    .PCIEPERST1B (pcie_perstn1_out),
    .PCIERQSEQNUM (pcie_rq_seq_num),
    .PCIERQSEQNUMVLD (pcie_rq_seq_num_vld),
    .PCIERQTAG (pcie_rq_tag),
    .PCIERQTAGAV (pcie_rq_tag_av),
    .PCIERQTAGVLD (pcie_rq_tag_vld),
    .PCIETFCNPDAV (pcie_tfc_npd_av),
    .PCIETFCNPHAV (pcie_tfc_nph_av),
    .PIPERX0EQCONTROL (pipe_rx0_eqcontrol),
    .PIPERX0EQLPLFFS (pipe_rx0_eqlp_lffs),
    .PIPERX0EQLPTXPRESET (pipe_rx0_eqlp_txpreset),
    .PIPERX0EQPRESET (pipe_rx0_eqpreset),
    .PIPERX0POLARITY (pipe_rx0_polarity),
    .PIPERX1EQCONTROL (pipe_rx1_eqcontrol),
    .PIPERX1EQLPLFFS (pipe_rx1_eqlp_lffs),
    .PIPERX1EQLPTXPRESET (pipe_rx1_eqlp_txpreset),
    .PIPERX1EQPRESET (pipe_rx1_eqpreset),
    .PIPERX1POLARITY (pipe_rx1_polarity),
    .PIPERX2EQCONTROL (pipe_rx2_eqcontrol),
    .PIPERX2EQLPLFFS (pipe_rx2_eqlp_lffs),
    .PIPERX2EQLPTXPRESET (pipe_rx2_eqlp_txpreset),
    .PIPERX2EQPRESET (pipe_rx2_eqpreset),
    .PIPERX2POLARITY (pipe_rx2_polarity),
    .PIPERX3EQCONTROL (pipe_rx3_eqcontrol),
    .PIPERX3EQLPLFFS (pipe_rx3_eqlp_lffs),
    .PIPERX3EQLPTXPRESET (pipe_rx3_eqlp_txpreset),
    .PIPERX3EQPRESET (pipe_rx3_eqpreset),
    .PIPERX3POLARITY (pipe_rx3_polarity),
    .PIPERX4EQCONTROL (pipe_rx4_eqcontrol),
    .PIPERX4EQLPLFFS (pipe_rx4_eqlp_lffs),
    .PIPERX4EQLPTXPRESET (pipe_rx4_eqlp_txpreset),
    .PIPERX4EQPRESET (pipe_rx4_eqpreset),
    .PIPERX4POLARITY (pipe_rx4_polarity),
    .PIPERX5EQCONTROL (pipe_rx5_eqcontrol),
    .PIPERX5EQLPLFFS (pipe_rx5_eqlp_lffs),
    .PIPERX5EQLPTXPRESET (pipe_rx5_eqlp_txpreset),
    .PIPERX5EQPRESET (pipe_rx5_eqpreset),
    .PIPERX5POLARITY (pipe_rx5_polarity),
    .PIPERX6EQCONTROL (pipe_rx6_eqcontrol),
    .PIPERX6EQLPLFFS (pipe_rx6_eqlp_lffs),
    .PIPERX6EQLPTXPRESET (pipe_rx6_eqlp_txpreset),
    .PIPERX6EQPRESET (pipe_rx6_eqpreset),
    .PIPERX6POLARITY (pipe_rx6_polarity),
    .PIPERX7EQCONTROL (pipe_rx7_eqcontrol),
    .PIPERX7EQLPLFFS (pipe_rx7_eqlp_lffs),
    .PIPERX7EQLPTXPRESET (pipe_rx7_eqlp_txpreset),
    .PIPERX7EQPRESET (pipe_rx7_eqpreset),
    .PIPERX7POLARITY (pipe_rx7_polarity),
    .PIPETX0CHARISK (pipe_tx0_char_is_k),
    .PIPETX0COMPLIANCE (pipe_tx0_compliance),
    .PIPETX0DATA (pipe_tx0_data),
    .PIPETX0DATAVALID (pipe_tx0_data_valid),
    .PIPETX0DEEMPH (pipe_tx0_deemph),
    .PIPETX0ELECIDLE (pipe_tx0_elec_idle),
    .PIPETX0EQCONTROL (pipe_tx0_eqcontrol),
    .PIPETX0EQDEEMPH (pipe_tx0_eqdeemph),
    .PIPETX0EQPRESET (pipe_tx0_eqpreset),
    .PIPETX0MARGIN (pipe_tx0_margin),
    .PIPETX0POWERDOWN (pipe_tx0_powerdown),
    .PIPETX0RATE (pipe_tx0_rate),
    .PIPETX0RCVRDET (pipe_tx0_rcvr_det),
    .PIPETX0RESET (pipe_tx0_reset),
    .PIPETX0STARTBLOCK (pipe_tx0_start_block),
    .PIPETX0SWING (pipe_tx0_swing),
    .PIPETX0SYNCHEADER (pipe_tx0_syncheader),
    .PIPETX1CHARISK (pipe_tx1_char_is_k),
    .PIPETX1COMPLIANCE (pipe_tx1_compliance),
    .PIPETX1DATA (pipe_tx1_data),
    .PIPETX1DATAVALID (pipe_tx1_data_valid),
    .PIPETX1DEEMPH (),  
    .PIPETX1ELECIDLE (pipe_tx1_elec_idle),
    .PIPETX1EQCONTROL (pipe_tx1_eqcontrol),
    .PIPETX1EQDEEMPH (pipe_tx1_eqdeemph),
    .PIPETX1EQPRESET (pipe_tx1_eqpreset),
    .PIPETX1MARGIN (),  
    .PIPETX1POWERDOWN (pipe_tx1_powerdown),
    .PIPETX1RATE (),  
    .PIPETX1RCVRDET (),  
    .PIPETX1RESET (),  
    .PIPETX1STARTBLOCK (pipe_tx1_start_block),
    .PIPETX1SWING (),  
    .PIPETX1SYNCHEADER (pipe_tx1_syncheader),
    .PIPETX2CHARISK (pipe_tx2_char_is_k),
    .PIPETX2COMPLIANCE (pipe_tx2_compliance),
    .PIPETX2DATA (pipe_tx2_data),
    .PIPETX2DATAVALID (pipe_tx2_data_valid),
    .PIPETX2DEEMPH (),  
    .PIPETX2ELECIDLE (pipe_tx2_elec_idle),
    .PIPETX2EQCONTROL (pipe_tx2_eqcontrol),
    .PIPETX2EQDEEMPH (pipe_tx2_eqdeemph),
    .PIPETX2EQPRESET (pipe_tx2_eqpreset),
    .PIPETX2MARGIN (),  
    .PIPETX2POWERDOWN (pipe_tx2_powerdown),
    .PIPETX2RATE (),  
    .PIPETX2RCVRDET (),  
    .PIPETX2RESET (),  
    .PIPETX2STARTBLOCK (pipe_tx2_start_block),
    .PIPETX2SWING (),  
    .PIPETX2SYNCHEADER (pipe_tx2_syncheader),
    .PIPETX3CHARISK (pipe_tx3_char_is_k),
    .PIPETX3COMPLIANCE (pipe_tx3_compliance),
    .PIPETX3DATA (pipe_tx3_data),
    .PIPETX3DATAVALID (pipe_tx3_data_valid),
    .PIPETX3DEEMPH (),  
    .PIPETX3ELECIDLE (pipe_tx3_elec_idle),
    .PIPETX3EQCONTROL (pipe_tx3_eqcontrol),
    .PIPETX3EQDEEMPH (pipe_tx3_eqdeemph),
    .PIPETX3EQPRESET (pipe_tx3_eqpreset),
    .PIPETX3MARGIN (), 
    .PIPETX3POWERDOWN (pipe_tx3_powerdown),
    .PIPETX3RATE (), 
    .PIPETX3RCVRDET (), 
    .PIPETX3RESET (), 
    .PIPETX3STARTBLOCK (pipe_tx3_start_block),
    .PIPETX3SWING (), 
    .PIPETX3SYNCHEADER (pipe_tx3_syncheader),
    .PIPETX4CHARISK (pipe_tx4_char_is_k),
    .PIPETX4COMPLIANCE (pipe_tx4_compliance),
    .PIPETX4DATA (pipe_tx4_data),
    .PIPETX4DATAVALID (pipe_tx4_data_valid),
    .PIPETX4DEEMPH (), 
    .PIPETX4ELECIDLE (pipe_tx4_elec_idle),
    .PIPETX4EQCONTROL (pipe_tx4_eqcontrol),
    .PIPETX4EQDEEMPH (pipe_tx4_eqdeemph),
    .PIPETX4EQPRESET (pipe_tx4_eqpreset),
    .PIPETX4MARGIN (), 
    .PIPETX4POWERDOWN (pipe_tx4_powerdown),
    .PIPETX4RATE (), 
    .PIPETX4RCVRDET (), 
    .PIPETX4RESET (), 
    .PIPETX4STARTBLOCK (pipe_tx4_start_block),
    .PIPETX4SWING (), 
    .PIPETX4SYNCHEADER (pipe_tx4_syncheader),
    .PIPETX5CHARISK (pipe_tx5_char_is_k),
    .PIPETX5COMPLIANCE (pipe_tx5_compliance),
    .PIPETX5DATA (pipe_tx5_data),
    .PIPETX5DATAVALID (pipe_tx5_data_valid),
    .PIPETX5DEEMPH (),
    .PIPETX5ELECIDLE (pipe_tx5_elec_idle),
    .PIPETX5EQCONTROL (pipe_tx5_eqcontrol),
    .PIPETX5EQDEEMPH (pipe_tx5_eqdeemph),
    .PIPETX5EQPRESET (pipe_tx5_eqpreset),
    .PIPETX5MARGIN (), 
    .PIPETX5POWERDOWN (pipe_tx5_powerdown),
    .PIPETX5RATE (), 
    .PIPETX5RCVRDET (),
    .PIPETX5RESET (), 
    .PIPETX5STARTBLOCK (pipe_tx5_start_block),
    .PIPETX5SWING (), 
    .PIPETX5SYNCHEADER (pipe_tx5_syncheader),
    .PIPETX6CHARISK (pipe_tx6_char_is_k),
    .PIPETX6COMPLIANCE (pipe_tx6_compliance),
    .PIPETX6DATA (pipe_tx6_data),
    .PIPETX6DATAVALID (pipe_tx6_data_valid),
    .PIPETX6DEEMPH (), 
    .PIPETX6ELECIDLE (pipe_tx6_elec_idle),
    .PIPETX6EQCONTROL (pipe_tx6_eqcontrol),
    .PIPETX6EQDEEMPH (pipe_tx6_eqdeemph),
    .PIPETX6EQPRESET (pipe_tx6_eqpreset),
    .PIPETX6MARGIN (), 
    .PIPETX6POWERDOWN (pipe_tx6_powerdown),
    .PIPETX6RATE (),
    .PIPETX6RCVRDET (),
    .PIPETX6RESET (), 
    .PIPETX6STARTBLOCK (pipe_tx6_start_block),
    .PIPETX6SWING (), 
    .PIPETX6SYNCHEADER (pipe_tx6_syncheader),
    .PIPETX7CHARISK (pipe_tx7_char_is_k),
    .PIPETX7COMPLIANCE (pipe_tx7_compliance),
    .PIPETX7DATA (pipe_tx7_data),
    .PIPETX7DATAVALID (pipe_tx7_data_valid),
    .PIPETX7DEEMPH (), 
    .PIPETX7ELECIDLE (pipe_tx7_elec_idle),
    .PIPETX7EQCONTROL (pipe_tx7_eqcontrol),
    .PIPETX7EQDEEMPH (pipe_tx7_eqdeemph),
    .PIPETX7EQPRESET (pipe_tx7_eqpreset),
    .PIPETX7MARGIN (), 
    .PIPETX7POWERDOWN (pipe_tx7_powerdown),
    .PIPETX7RATE (), 
    .PIPETX7RCVRDET (), 
    .PIPETX7RESET (), 
    .PIPETX7STARTBLOCK (pipe_tx7_start_block),
    .PIPETX7SWING (), 
    .PIPETX7SYNCHEADER (pipe_tx7_syncheader),
    .PLEQINPROGRESS (pl_eq_in_progress),
    .PLEQPHASE (pl_eq_phase),
    .SAXISCCTREADY (s_axis_cc_tready),
    .SAXISRQTREADY (s_axis_rq_tready),
    .SPAREOUT ()
  );

endmodule

module rp_init_ctrl 
 # (
  parameter         TCQ = 100,
  parameter         PL_UPSTREAM_FACING = "TRUE"
)(
  input  wire         clk_i,
  input  wire         phy_rdy_i,
  output wire         reset_n_o,
  output wire         pipe_reset_n_o,
  output wire         mgmt_reset_n_o,
  output wire         mgmt_sticky_reset_n_o,
  output wire   [2:0] state_o
  );

  localparam STATE_RESET = 3'b000;
  localparam STATE_MGMT_RESET_DEASSERT = 3'b001;
  localparam STATE_PHY_RDY = 3'b100;
  localparam STATE_RESET_DEASSERT = 3'b101;

  reg           [2:0] reg_state;
  reg           [2:0] reg_next_state;
(* ASYNC_REG = "TRUE", SHIFT_EXTRACT = "NO" *)    reg           [1:0] reg_phy_rdy = 2'b11; 
  reg           [1:0] reg_cold_reset = 2'b11;
  reg                 reg_reset_n_o;
  reg                 reg_pipe_reset_n_o;
  reg                 reg_mgmt_reset_n_o;
  reg                 reg_mgmt_sticky_reset_n_o;
  reg           [1:0] reg_reset_timer;
  wire          [2:0] state_w;
  wire          [2:0] next_state_w;
  wire                phy_rdy;
  wire                cold_reset_n;
  wire          [1:0] reset_timer_w;
  
    
  // Generate PHY Ready

  always @(posedge clk_i or negedge phy_rdy_i)
  begin
    if (!phy_rdy_i)
      reg_phy_rdy[1:0] <= #TCQ 2'b11;
    else
      reg_phy_rdy[1:0] <= #TCQ {reg_phy_rdy[0], 1'b0};
  end

  assign phy_rdy = !reg_phy_rdy[1];
  
   // Generate Cold reset

  always @(posedge clk_i)
  begin
    if (!phy_rdy && reg_cold_reset[1] )
      reg_cold_reset[1:0] <= #TCQ 2'b11;
    else
      reg_cold_reset[1:0] <= #TCQ {reg_cold_reset[0], 1'b0};
  end

  assign cold_reset_n = !reg_cold_reset[1];
  
  // Reset Timer
  
  always @(posedge clk_i or negedge phy_rdy_i)
  begin
    if (!phy_rdy_i)
        reg_reset_timer <= #TCQ 2'b00;
    else if ((state_w == STATE_MGMT_RESET_DEASSERT) && (reset_timer_w != 2'b11))
        reg_reset_timer <= #TCQ reset_timer_w + 1'b1;
    else
        reg_reset_timer <= #TCQ reset_timer_w;    
  end
  
  
  // Reset SM
  
  always @(posedge clk_i or negedge cold_reset_n)
  begin
    if (!cold_reset_n)
      reg_state <= #TCQ STATE_RESET;
    else
      reg_state <= #TCQ reg_next_state;
  end
  
 generate // Resets for EP and DSPort 
 begin: generate_resets
   if( PL_UPSTREAM_FACING == "TRUE") // DUT is a EP
     begin 

        always @*
        begin
          reg_next_state = STATE_RESET;
          reg_mgmt_reset_n_o = 1'b1;
          reg_mgmt_sticky_reset_n_o = 1'b1;
          reg_reset_n_o = 1'b0;
          reg_pipe_reset_n_o = 1'b0;
          case (state_w)
            STATE_RESET:
            begin
              reg_mgmt_reset_n_o = 1'b0;
              reg_mgmt_sticky_reset_n_o = 1'b0;
              if (phy_rdy)
                reg_next_state = STATE_MGMT_RESET_DEASSERT;
              else
                reg_next_state = STATE_RESET;
            end
            STATE_MGMT_RESET_DEASSERT:
            begin
              if (reset_timer_w == 2'b11)
              reg_next_state = STATE_RESET_DEASSERT;
              else
              reg_next_state = STATE_MGMT_RESET_DEASSERT;
            end
            STATE_RESET_DEASSERT:
            begin
              reg_reset_n_o = 1'b1;
              reg_pipe_reset_n_o = 1'b1;
              if (!phy_rdy)
                reg_next_state = STATE_RESET;
              else
                reg_next_state = STATE_RESET_DEASSERT;
            end
        endcase
      end  //  always @*
  
  end else  begin // DUT is a DSPort 
      
      always @*
        begin
          reg_next_state = STATE_RESET;
          reg_mgmt_reset_n_o = 1'b1;
          reg_mgmt_sticky_reset_n_o = 1'b1;
          reg_reset_n_o = 1'b0;
          reg_pipe_reset_n_o = 1'b0;
          case (state_w)
            STATE_RESET:
            begin
              reg_mgmt_reset_n_o = 1'b0;
              reg_mgmt_sticky_reset_n_o = 1'b0;
              if (phy_rdy)
                reg_next_state = STATE_MGMT_RESET_DEASSERT;
              else
                reg_next_state = STATE_RESET;
            end
            STATE_MGMT_RESET_DEASSERT:
            begin
              if (reset_timer_w == 2'b11)
                reg_next_state = STATE_PHY_RDY;
              else
                reg_next_state = STATE_MGMT_RESET_DEASSERT;
            end
            STATE_PHY_RDY:
            begin
              if (phy_rdy)
                reg_next_state = STATE_RESET_DEASSERT;
              else
              	reg_next_state = STATE_PHY_RDY;
              end
            STATE_RESET_DEASSERT:
            begin
              reg_reset_n_o = 1'b1;
              reg_pipe_reset_n_o = 1'b1;
              if (!phy_rdy)
                reg_next_state = STATE_PHY_RDY;
              else
                reg_next_state = STATE_RESET_DEASSERT;
            end
        endcase
      end  //  always @*
  
   
     end // else // DUT is a Downstream port
 end // generate resets
 endgenerate

  assign state_w = reg_state;
  assign next_state_w = reg_next_state;
  assign reset_n_o = reg_reset_n_o;
  assign pipe_reset_n_o = reg_pipe_reset_n_o;
  assign mgmt_reset_n_o = reg_mgmt_reset_n_o;
  assign mgmt_sticky_reset_n_o = reg_mgmt_sticky_reset_n_o;
  assign state_o = reg_state;
  assign reset_timer_w = reg_reset_timer;

endmodule

module rp_tph_tbl
#(
  parameter TCQ = 100
  ) (
  input  wire         user_clk,
  input  wire         reset_n,
  input  wire   [4:0] cfg_tph_stt_address_i,
  input  wire   [3:0] cfg_tph_function_num_i,
  input  wire  [31:0] cfg_tph_stt_write_data_i,
  input  wire         cfg_tph_stt_write_enable_i,
  input  wire   [3:0] cfg_tph_stt_write_byte_valid_i,
  output wire  [31:0] cfg_tph_stt_read_data_o,
  input  wire         cfg_tph_stt_read_enable_i,
  output wire         cfg_tph_stt_read_data_valid_o,
  input  wire   [4:0] user_tph_stt_address_i,
  input  wire   [3:0] user_tph_function_num_i,
  input  wire         user_tph_stt_read_enable_i,
  output wire  [31:0] user_tph_stt_read_data_o,
  output wire         user_tph_stt_read_data_valid_o
  );

  reg                 reg_cfg_tph_stt_read_data_valid_o;
  reg                 reg_user_tph_stt_read_data_valid_o;
  reg           [8:0] reg_count;
  reg                 reg_state = 1'b0;
  reg                 reg_next_state = 1'b0;
  reg                 reg_web;
  reg                 reg_cfg_tph_stt_read_enable_i;
  reg                 reg_user_tph_stt_read_enable_i;
  wire          [3:0] wea;
  wire                web;
  wire          [8:0] addra;
  wire          [8:0] addrb;
  wire         [31:0] dina;
  wire         [31:0] dinb;
  wire          [8:0] count_w;
  wire                ram_scrub_in_process_w;
  wire                state_w;
  wire                next_state_w;
  wire         [31:0] douta;
  wire         [31:0] doutb;

  always @(posedge user_clk or negedge reset_n)
  begin
    if (!reset_n)
    begin
      reg_cfg_tph_stt_read_data_valid_o <= #TCQ 1'b0;
      reg_cfg_tph_stt_read_enable_i <= #TCQ 1'b0;
    end
    else
    begin
      if (cfg_tph_stt_read_enable_i && reg_cfg_tph_stt_read_enable_i &&
          !reg_cfg_tph_stt_read_data_valid_o && !ram_scrub_in_process_w)
      begin
        reg_cfg_tph_stt_read_data_valid_o <= #TCQ 1'b1;
      end
      else
      begin
        reg_cfg_tph_stt_read_data_valid_o <= #TCQ 1'b0;
      end
      reg_cfg_tph_stt_read_enable_i <= #TCQ cfg_tph_stt_read_enable_i;
    end
  end

  always @(posedge user_clk or negedge reset_n)
  begin
    if (!reset_n)
    begin
      reg_user_tph_stt_read_data_valid_o <= #TCQ 1'b0;
      reg_user_tph_stt_read_enable_i <= #TCQ 1'b0;
    end
    else
    begin
      if (user_tph_stt_read_enable_i && reg_user_tph_stt_read_enable_i &&
          !reg_user_tph_stt_read_data_valid_o && !ram_scrub_in_process_w)
      begin
        reg_user_tph_stt_read_data_valid_o <= #TCQ 1'b1;
      end
      else
      begin
        reg_user_tph_stt_read_data_valid_o <= #TCQ 1'b0;
      end
      reg_user_tph_stt_read_enable_i <= #TCQ user_tph_stt_read_enable_i;
    end
  end

  always @(posedge user_clk)
  begin
    reg_state <= #TCQ next_state_w;
    if (state_w)
    begin
      reg_count <= #TCQ count_w + 1'b1;
    end
    else
    begin
      reg_count <= #TCQ 9'b0;
    end
  end

  always @*
  begin
    case (state_w)
      1'b0:
      begin
        if (!reset_n)
        begin
          reg_next_state = 1'b1;
        end
        else
        begin
          reg_next_state = 1'b0;
        end
      end
      1'b1:
      begin
        if (count_w == 9'h1FF)
        begin
          reg_next_state = 1'b0;
        end
        else
        begin
          reg_next_state = 1'b1;
        end
      end
    endcase
  end

  RAMB36E2 #(
    .DOA_REG (1),
    .DOB_REG (0),
    .EN_ECC_READ ("FALSE"),
    .EN_ECC_WRITE ("FALSE"),
    .INIT_A (36'h000000000),
    .INIT_B (36'h000000000),
    .INIT_FILE ("NONE"),
//    .RDADDR_COLLISION_HWCONFIG ("DELAYED_WRITE"),
    .READ_WIDTH_A (36),
    .READ_WIDTH_B (36),
    .RSTREG_PRIORITY_A ("REGCE"),
    .RSTREG_PRIORITY_B ("REGCE"),
    .SIM_COLLISION_CHECK ("GENERATE_X_ONLY"),
    .SRVAL_A (36'h000000000),
    .SRVAL_B (36'h000000000),
    .WRITE_MODE_A ("WRITE_FIRST"),
    .WRITE_MODE_B ("WRITE_FIRST"),
    .WRITE_WIDTH_A (36),
    .WRITE_WIDTH_B (36))
  ramb36e2_inst (
    .ADDRENA (1'b1),
    .ADDRENB (1'b1),
    .CASDIMUXA (1'b0),
    .CASDIMUXB (1'b0),
    .CASDOMUXA (1'b0),
    .CASDOMUXB (1'b0),
    .CASDOMUXEN_A (1'b0),
    .CASDOMUXEN_B (1'b0),
    .CASINDBITERR (1'b0),
    .CASINSBITERR (1'b0),
    .CASOREGIMUXA (1'b0),
    .CASOREGIMUXB (1'b0),
    .CASOREGIMUXEN_A (1'b0),
    .CASOREGIMUXEN_B (1'b0),
    .ECCPIPECE (1'b0),
    .SLEEP (1'b0),
    .CASDINA (32'b0),
    .CASDINB (32'b0),
    .CASDINPA(4'b0),
    .CASDINPB(4'b0),
    .CASDOUTA (),
    .CASDOUTB (),
    .CASDOUTPA (),
    .CASDOUTPB (),
    .CASOUTDBITERR (),
    .CASOUTSBITERR (),
    .CLKARDCLK (user_clk),
    .CLKBWRCLK (user_clk),
    .DBITERR (),
    .ENARDEN (1'b1),
    .ENBWREN (1'b1),
    .INJECTDBITERR (1'b0),
    .INJECTSBITERR (1'b0),
    .REGCEAREGCE (1'b1),
    .REGCEB (1'b0),
    .RSTRAMARSTRAM (1'b0),
    .RSTRAMB (1'b0),
    .RSTREGARSTREG (1'b0),
    .RSTREGB (1'b0),
    .SBITERR (),
    .ADDRARDADDR ({1'b0, addra[8:0], 5'b00000}),
    .ADDRBWRADDR ({1'b0, addrb[8:0], 5'b00000}),
    .DINADIN (dina[31:0]),
    .DINBDIN (dinb[31:0]),
    .DINPADINP (4'b0000),
    .DINPBDINP (4'b0000),
    .DOUTADOUT (douta[31:0]),
    .DOUTBDOUT (doutb[31:0]),
    .DOUTPADOUTP (),
    .DOUTPBDOUTP (),
    .ECCPARITY (),
    .RDADDRECC (),
    .WEA (wea[3:0]),
    .WEBWE ({4'b0000, web, web, web, web})
  );

  assign addra = {cfg_tph_function_num_i, cfg_tph_stt_address_i};
  assign dina = cfg_tph_stt_write_data_i;
  assign wea[3] = cfg_tph_stt_write_enable_i && cfg_tph_stt_write_byte_valid_i[3];
  assign wea[2] = cfg_tph_stt_write_enable_i && cfg_tph_stt_write_byte_valid_i[2];
  assign wea[1] = cfg_tph_stt_write_enable_i && cfg_tph_stt_write_byte_valid_i[1];
  assign wea[0] = cfg_tph_stt_write_enable_i && cfg_tph_stt_write_byte_valid_i[0];
  assign cfg_tph_stt_read_data_o = douta;
  assign cfg_tph_stt_read_data_valid_o = reg_cfg_tph_stt_read_data_valid_o;
  assign ram_scrub_in_process_w = state_w;
  assign count_w = reg_count;
  assign state_w = reg_state;
  assign next_state_w = reg_next_state;
  assign dinb = 32'b0;
  assign web = reg_next_state;
  assign user_tph_stt_read_data_o = doutb;
  assign addrb = ram_scrub_in_process_w ? count_w : {user_tph_function_num_i, user_tph_stt_address_i};
  assign user_tph_stt_read_data_valid_o = reg_user_tph_stt_read_data_valid_o;

endmodule

module rp_pipe_pipeline 
 #(
  parameter TCQ = 100,
  parameter PIPE_PIPELINE_STAGES = 0,
  parameter PL_LINK_CAP_MAX_LINK_WIDTH = 8
  ) (
  input  wire         pipe_tx_rcvr_det_i,
  input  wire         pipe_tx_reset_i,
  input  wire   [1:0] pipe_tx_rate_i,
  input  wire         pipe_tx_deemph_i,
  input  wire   [2:0] pipe_tx_margin_i,
  input  wire         pipe_tx_swing_i,
  input  wire   [5:0] pipe_tx_eqfs_i,
  input  wire   [5:0] pipe_tx_eqlf_i,
  output wire         pipe_tx_rcvr_det_o,
  output wire         pipe_tx_reset_o,
  output wire   [1:0] pipe_tx_rate_o,
  output wire         pipe_tx_deemph_o,
  output wire   [2:0] pipe_tx_margin_o,
  output wire         pipe_tx_swing_o,
  output wire   [5:0] pipe_tx_eqfs_o,
  output wire   [5:0] pipe_tx_eqlf_o,
  output wire   [1:0] pipe_rx0_char_is_k_o,
  output wire  [31:0] pipe_rx0_data_o,
  output wire         pipe_rx0_valid_o,
  output wire         pipe_rx0_data_valid_o,
  output wire   [2:0] pipe_rx0_status_o,
  output wire         pipe_rx0_phy_status_o,
  output wire         pipe_rx0_elec_idle_o,
  output wire         pipe_rx0_eqdone_o,
  output wire         pipe_rx0_eqlpadaptdone_o,
  output wire         pipe_rx0_eqlplffssel_o,
  output wire  [17:0] pipe_rx0_eqlpnewtxcoefforpreset_o,
  output wire         pipe_rx0_startblock_o,
  output wire   [1:0] pipe_rx0_syncheader_o,
  input  wire         pipe_rx0_polarity_i,
  input  wire   [1:0] pipe_rx0_eqcontrol_i,
  input  wire   [5:0] pipe_rx0_eqlplffs_i,
  input  wire   [3:0] pipe_rx0_eqlptxpreset_i,
  input  wire   [2:0] pipe_rx0_eqpreset_i,
  output wire  [17:0] pipe_tx0_eqcoeff_o,
  output wire         pipe_tx0_eqdone_o,
  input  wire         pipe_tx0_compliance_i,
  input  wire   [1:0] pipe_tx0_char_is_k_i,
  input  wire  [31:0] pipe_tx0_data_i,
  input  wire         pipe_tx0_elec_idle_i,
  input  wire   [1:0] pipe_tx0_powerdown_i,
  input  wire         pipe_tx0_datavalid_i,
  input  wire         pipe_tx0_startblock_i,
  input  wire   [1:0] pipe_tx0_syncheader_i,
  input  wire   [1:0] pipe_tx0_eqcontrol_i,
  input  wire   [5:0] pipe_tx0_eqdeemph_i,
  input  wire   [3:0] pipe_tx0_eqpreset_i,
  input  wire   [1:0] pipe_rx0_char_is_k_i,
  input  wire  [31:0] pipe_rx0_data_i,
  input  wire         pipe_rx0_valid_i,
  input  wire         pipe_rx0_data_valid_i,
  input  wire   [2:0] pipe_rx0_status_i,
  input  wire         pipe_rx0_phy_status_i,
  input  wire         pipe_rx0_elec_idle_i,
  input  wire         pipe_rx0_eqdone_i,
  input  wire         pipe_rx0_eqlpadaptdone_i,
  input  wire         pipe_rx0_eqlplffssel_i,
  input  wire  [17:0] pipe_rx0_eqlpnewtxcoefforpreset_i,
  input  wire         pipe_rx0_startblock_i,
  input  wire   [1:0] pipe_rx0_syncheader_i,
  output wire         pipe_rx0_polarity_o,
  output wire   [1:0] pipe_rx0_eqcontrol_o,
  output wire   [5:0] pipe_rx0_eqlplffs_o,
  output wire   [3:0] pipe_rx0_eqlptxpreset_o,
  output wire   [2:0] pipe_rx0_eqpreset_o,
  input  wire  [17:0] pipe_tx0_eqcoeff_i,
  input  wire         pipe_tx0_eqdone_i,
  output wire         pipe_tx0_compliance_o,
  output wire   [1:0] pipe_tx0_char_is_k_o,
  output wire  [31:0] pipe_tx0_data_o,
  output wire         pipe_tx0_elec_idle_o,
  output wire   [1:0] pipe_tx0_powerdown_o,
  output wire         pipe_tx0_datavalid_o,
  output wire         pipe_tx0_startblock_o,
  output wire   [1:0] pipe_tx0_syncheader_o,
  output wire   [1:0] pipe_tx0_eqcontrol_o,
  output wire   [5:0] pipe_tx0_eqdeemph_o,
  output wire   [3:0] pipe_tx0_eqpreset_o,
  output wire   [1:0] pipe_rx1_char_is_k_o,
  output wire  [31:0] pipe_rx1_data_o,
  output wire         pipe_rx1_valid_o,
  output wire         pipe_rx1_data_valid_o,
  output wire   [2:0] pipe_rx1_status_o,
  output wire         pipe_rx1_phy_status_o,
  output wire         pipe_rx1_elec_idle_o,
  output wire         pipe_rx1_eqdone_o,
  output wire         pipe_rx1_eqlpadaptdone_o,
  output wire         pipe_rx1_eqlplffssel_o,
  output wire  [17:0] pipe_rx1_eqlpnewtxcoefforpreset_o,
  output wire         pipe_rx1_startblock_o,
  output wire   [1:0] pipe_rx1_syncheader_o,
  input  wire         pipe_rx1_polarity_i,
  input  wire   [1:0] pipe_rx1_eqcontrol_i,
  input  wire   [5:0] pipe_rx1_eqlplffs_i,
  input  wire   [3:0] pipe_rx1_eqlptxpreset_i,
  input  wire   [2:0] pipe_rx1_eqpreset_i,
  output wire  [17:0] pipe_tx1_eqcoeff_o,
  output wire         pipe_tx1_eqdone_o,
  input  wire         pipe_tx1_compliance_i,
  input  wire   [1:0] pipe_tx1_char_is_k_i,
  input  wire  [31:0] pipe_tx1_data_i,
  input  wire         pipe_tx1_elec_idle_i,
  input  wire   [1:0] pipe_tx1_powerdown_i,
  input  wire         pipe_tx1_datavalid_i,
  input  wire         pipe_tx1_startblock_i,
  input  wire   [1:0] pipe_tx1_syncheader_i,
  input  wire   [1:0] pipe_tx1_eqcontrol_i,
  input  wire   [5:0] pipe_tx1_eqdeemph_i,
  input  wire   [3:0] pipe_tx1_eqpreset_i,
  input  wire   [1:0] pipe_rx1_char_is_k_i,
  input  wire  [31:0] pipe_rx1_data_i,
  input  wire         pipe_rx1_valid_i,
  input  wire         pipe_rx1_data_valid_i,
  input  wire   [2:0] pipe_rx1_status_i,
  input  wire         pipe_rx1_phy_status_i,
  input  wire         pipe_rx1_elec_idle_i,
  input  wire         pipe_rx1_eqdone_i,
  input  wire         pipe_rx1_eqlpadaptdone_i,
  input  wire         pipe_rx1_eqlplffssel_i,
  input  wire  [17:0] pipe_rx1_eqlpnewtxcoefforpreset_i,
  input  wire         pipe_rx1_startblock_i,
  input  wire   [1:0] pipe_rx1_syncheader_i,
  output wire         pipe_rx1_polarity_o,
  output wire   [1:0] pipe_rx1_eqcontrol_o,
  output wire   [5:0] pipe_rx1_eqlplffs_o,
  output wire   [3:0] pipe_rx1_eqlptxpreset_o,
  output wire   [2:0] pipe_rx1_eqpreset_o,
  input  wire  [17:0] pipe_tx1_eqcoeff_i,
  input  wire         pipe_tx1_eqdone_i,
  output wire         pipe_tx1_compliance_o,
  output wire   [1:0] pipe_tx1_char_is_k_o,
  output wire  [31:0] pipe_tx1_data_o,
  output wire         pipe_tx1_elec_idle_o,
  output wire   [1:0] pipe_tx1_powerdown_o,
  output wire         pipe_tx1_datavalid_o,
  output wire         pipe_tx1_startblock_o,
  output wire   [1:0] pipe_tx1_syncheader_o,
  output wire   [1:0] pipe_tx1_eqcontrol_o,
  output wire   [5:0] pipe_tx1_eqdeemph_o,
  output wire   [3:0] pipe_tx1_eqpreset_o,
  output wire   [1:0] pipe_rx2_char_is_k_o,
  output wire  [31:0] pipe_rx2_data_o,
  output wire         pipe_rx2_valid_o,
  output wire         pipe_rx2_data_valid_o,
  output wire   [2:0] pipe_rx2_status_o,
  output wire         pipe_rx2_phy_status_o,
  output wire         pipe_rx2_elec_idle_o,
  output wire         pipe_rx2_eqdone_o,
  output wire         pipe_rx2_eqlpadaptdone_o,
  output wire         pipe_rx2_eqlplffssel_o,
  output wire  [17:0] pipe_rx2_eqlpnewtxcoefforpreset_o,
  output wire         pipe_rx2_startblock_o,
  output wire   [1:0] pipe_rx2_syncheader_o,
  input  wire         pipe_rx2_polarity_i,
  input  wire   [1:0] pipe_rx2_eqcontrol_i,
  input  wire   [5:0] pipe_rx2_eqlplffs_i,
  input  wire   [3:0] pipe_rx2_eqlptxpreset_i,
  input  wire   [2:0] pipe_rx2_eqpreset_i,
  output wire  [17:0] pipe_tx2_eqcoeff_o,
  output wire         pipe_tx2_eqdone_o,
  input  wire         pipe_tx2_compliance_i,
  input  wire   [1:0] pipe_tx2_char_is_k_i,
  input  wire  [31:0] pipe_tx2_data_i,
  input  wire         pipe_tx2_elec_idle_i,
  input  wire   [1:0] pipe_tx2_powerdown_i,
  input  wire         pipe_tx2_datavalid_i,
  input  wire         pipe_tx2_startblock_i,
  input  wire   [1:0] pipe_tx2_syncheader_i,
  input  wire   [1:0] pipe_tx2_eqcontrol_i,
  input  wire   [5:0] pipe_tx2_eqdeemph_i,
  input  wire   [3:0] pipe_tx2_eqpreset_i,
  input  wire   [1:0] pipe_rx2_char_is_k_i,
  input  wire  [31:0] pipe_rx2_data_i,
  input  wire         pipe_rx2_valid_i,
  input  wire         pipe_rx2_data_valid_i,
  input  wire   [2:0] pipe_rx2_status_i,
  input  wire         pipe_rx2_phy_status_i,
  input  wire         pipe_rx2_elec_idle_i,
  input  wire         pipe_rx2_eqdone_i,
  input  wire         pipe_rx2_eqlpadaptdone_i,
  input  wire         pipe_rx2_eqlplffssel_i,
  input  wire  [17:0] pipe_rx2_eqlpnewtxcoefforpreset_i,
  input  wire         pipe_rx2_startblock_i,
  input  wire   [1:0] pipe_rx2_syncheader_i,
  output wire         pipe_rx2_polarity_o,
  output wire   [1:0] pipe_rx2_eqcontrol_o,
  output wire   [5:0] pipe_rx2_eqlplffs_o,
  output wire   [3:0] pipe_rx2_eqlptxpreset_o,
  output wire   [2:0] pipe_rx2_eqpreset_o,
  input  wire  [17:0] pipe_tx2_eqcoeff_i,
  input  wire         pipe_tx2_eqdone_i,
  output wire         pipe_tx2_compliance_o,
  output wire   [1:0] pipe_tx2_char_is_k_o,
  output wire  [31:0] pipe_tx2_data_o,
  output wire         pipe_tx2_elec_idle_o,
  output wire   [1:0] pipe_tx2_powerdown_o,
  output wire         pipe_tx2_datavalid_o,
  output wire         pipe_tx2_startblock_o,
  output wire   [1:0] pipe_tx2_syncheader_o,
  output wire   [1:0] pipe_tx2_eqcontrol_o,
  output wire   [5:0] pipe_tx2_eqdeemph_o,
  output wire   [3:0] pipe_tx2_eqpreset_o,
  output wire   [1:0] pipe_rx3_char_is_k_o,
  output wire  [31:0] pipe_rx3_data_o,
  output wire         pipe_rx3_valid_o,
  output wire         pipe_rx3_data_valid_o,
  output wire   [2:0] pipe_rx3_status_o,
  output wire         pipe_rx3_phy_status_o,
  output wire         pipe_rx3_elec_idle_o,
  output wire         pipe_rx3_eqdone_o,
  output wire         pipe_rx3_eqlpadaptdone_o,
  output wire         pipe_rx3_eqlplffssel_o,
  output wire  [17:0] pipe_rx3_eqlpnewtxcoefforpreset_o,
  output wire         pipe_rx3_startblock_o,
  output wire   [1:0] pipe_rx3_syncheader_o,
  input  wire         pipe_rx3_polarity_i,
  input  wire   [1:0] pipe_rx3_eqcontrol_i,
  input  wire   [5:0] pipe_rx3_eqlplffs_i,
  input  wire   [3:0] pipe_rx3_eqlptxpreset_i,
  input  wire   [2:0] pipe_rx3_eqpreset_i,
  output wire  [17:0] pipe_tx3_eqcoeff_o,
  output wire         pipe_tx3_eqdone_o,
  input  wire         pipe_tx3_compliance_i,
  input  wire   [1:0] pipe_tx3_char_is_k_i,
  input  wire  [31:0] pipe_tx3_data_i,
  input  wire         pipe_tx3_elec_idle_i,
  input  wire   [1:0] pipe_tx3_powerdown_i,
  input  wire         pipe_tx3_datavalid_i,
  input  wire         pipe_tx3_startblock_i,
  input  wire   [1:0] pipe_tx3_syncheader_i,
  input  wire   [1:0] pipe_tx3_eqcontrol_i,
  input  wire   [5:0] pipe_tx3_eqdeemph_i,
  input  wire   [3:0] pipe_tx3_eqpreset_i,
  input  wire   [1:0] pipe_rx3_char_is_k_i,
  input  wire  [31:0] pipe_rx3_data_i,
  input  wire         pipe_rx3_valid_i,
  input  wire         pipe_rx3_data_valid_i,
  input  wire   [2:0] pipe_rx3_status_i,
  input  wire         pipe_rx3_phy_status_i,
  input  wire         pipe_rx3_elec_idle_i,
  input  wire         pipe_rx3_eqdone_i,
  input  wire         pipe_rx3_eqlpadaptdone_i,
  input  wire         pipe_rx3_eqlplffssel_i,
  input  wire  [17:0] pipe_rx3_eqlpnewtxcoefforpreset_i,
  input  wire         pipe_rx3_startblock_i,
  input  wire   [1:0] pipe_rx3_syncheader_i,
  output wire         pipe_rx3_polarity_o,
  output wire   [1:0] pipe_rx3_eqcontrol_o,
  output wire   [5:0] pipe_rx3_eqlplffs_o,
  output wire   [3:0] pipe_rx3_eqlptxpreset_o,
  output wire   [2:0] pipe_rx3_eqpreset_o,
  input  wire  [17:0] pipe_tx3_eqcoeff_i,
  input  wire         pipe_tx3_eqdone_i,
  output wire         pipe_tx3_compliance_o,
  output wire   [1:0] pipe_tx3_char_is_k_o,
  output wire  [31:0] pipe_tx3_data_o,
  output wire         pipe_tx3_elec_idle_o,
  output wire   [1:0] pipe_tx3_powerdown_o,
  output wire         pipe_tx3_datavalid_o,
  output wire         pipe_tx3_startblock_o,
  output wire   [1:0] pipe_tx3_syncheader_o,
  output wire   [1:0] pipe_tx3_eqcontrol_o,
  output wire   [5:0] pipe_tx3_eqdeemph_o,
  output wire   [3:0] pipe_tx3_eqpreset_o,
  output wire   [1:0] pipe_rx4_char_is_k_o,
  output wire  [31:0] pipe_rx4_data_o,
  output wire         pipe_rx4_valid_o,
  output wire         pipe_rx4_data_valid_o,
  output wire   [2:0] pipe_rx4_status_o,
  output wire         pipe_rx4_phy_status_o,
  output wire         pipe_rx4_elec_idle_o,
  output wire         pipe_rx4_eqdone_o,
  output wire         pipe_rx4_eqlpadaptdone_o,
  output wire         pipe_rx4_eqlplffssel_o,
  output wire  [17:0] pipe_rx4_eqlpnewtxcoefforpreset_o,
  output wire         pipe_rx4_startblock_o,
  output wire   [1:0] pipe_rx4_syncheader_o,
  input  wire         pipe_rx4_polarity_i,
  input  wire   [1:0] pipe_rx4_eqcontrol_i,
  input  wire   [5:0] pipe_rx4_eqlplffs_i,
  input  wire   [3:0] pipe_rx4_eqlptxpreset_i,
  input  wire   [2:0] pipe_rx4_eqpreset_i,
  output wire  [17:0] pipe_tx4_eqcoeff_o,
  output wire         pipe_tx4_eqdone_o,
  input  wire         pipe_tx4_compliance_i,
  input  wire   [1:0] pipe_tx4_char_is_k_i,
  input  wire  [31:0] pipe_tx4_data_i,
  input  wire         pipe_tx4_elec_idle_i,
  input  wire   [1:0] pipe_tx4_powerdown_i,
  input  wire         pipe_tx4_datavalid_i,
  input  wire         pipe_tx4_startblock_i,
  input  wire   [1:0] pipe_tx4_syncheader_i,
  input  wire   [1:0] pipe_tx4_eqcontrol_i,
  input  wire   [5:0] pipe_tx4_eqdeemph_i,
  input  wire   [3:0] pipe_tx4_eqpreset_i,
  input  wire   [1:0] pipe_rx4_char_is_k_i,
  input  wire  [31:0] pipe_rx4_data_i,
  input  wire         pipe_rx4_valid_i,
  input  wire         pipe_rx4_data_valid_i,
  input  wire   [2:0] pipe_rx4_status_i,
  input  wire         pipe_rx4_phy_status_i,
  input  wire         pipe_rx4_elec_idle_i,
  input  wire         pipe_rx4_eqdone_i,
  input  wire         pipe_rx4_eqlpadaptdone_i,
  input  wire         pipe_rx4_eqlplffssel_i,
  input  wire  [17:0] pipe_rx4_eqlpnewtxcoefforpreset_i,
  input  wire         pipe_rx4_startblock_i,
  input  wire   [1:0] pipe_rx4_syncheader_i,
  output wire         pipe_rx4_polarity_o,
  output wire   [1:0] pipe_rx4_eqcontrol_o,
  output wire   [5:0] pipe_rx4_eqlplffs_o,
  output wire   [3:0] pipe_rx4_eqlptxpreset_o,
  output wire   [2:0] pipe_rx4_eqpreset_o,
  input  wire  [17:0] pipe_tx4_eqcoeff_i,
  input  wire         pipe_tx4_eqdone_i,
  output wire         pipe_tx4_compliance_o,
  output wire   [1:0] pipe_tx4_char_is_k_o,
  output wire  [31:0] pipe_tx4_data_o,
  output wire         pipe_tx4_elec_idle_o,
  output wire   [1:0] pipe_tx4_powerdown_o,
  output wire         pipe_tx4_datavalid_o,
  output wire         pipe_tx4_startblock_o,
  output wire   [1:0] pipe_tx4_syncheader_o,
  output wire   [1:0] pipe_tx4_eqcontrol_o,
  output wire   [5:0] pipe_tx4_eqdeemph_o,
  output wire   [3:0] pipe_tx4_eqpreset_o,
  output wire   [1:0] pipe_rx5_char_is_k_o,
  output wire  [31:0] pipe_rx5_data_o,
  output wire         pipe_rx5_valid_o,
  output wire         pipe_rx5_data_valid_o,
  output wire   [2:0] pipe_rx5_status_o,
  output wire         pipe_rx5_phy_status_o,
  output wire         pipe_rx5_elec_idle_o,
  output wire         pipe_rx5_eqdone_o,
  output wire         pipe_rx5_eqlpadaptdone_o,
  output wire         pipe_rx5_eqlplffssel_o,
  output wire  [17:0] pipe_rx5_eqlpnewtxcoefforpreset_o,
  output wire         pipe_rx5_startblock_o,
  output wire   [1:0] pipe_rx5_syncheader_o,
  input  wire         pipe_rx5_polarity_i,
  input  wire   [1:0] pipe_rx5_eqcontrol_i,
  input  wire   [5:0] pipe_rx5_eqlplffs_i,
  input  wire   [3:0] pipe_rx5_eqlptxpreset_i,
  input  wire   [2:0] pipe_rx5_eqpreset_i,
  output wire  [17:0] pipe_tx5_eqcoeff_o,
  output wire         pipe_tx5_eqdone_o,
  input  wire         pipe_tx5_compliance_i,
  input  wire   [1:0] pipe_tx5_char_is_k_i,
  input  wire  [31:0] pipe_tx5_data_i,
  input  wire         pipe_tx5_elec_idle_i,
  input  wire   [1:0] pipe_tx5_powerdown_i,
  input  wire         pipe_tx5_datavalid_i,
  input  wire         pipe_tx5_startblock_i,
  input  wire   [1:0] pipe_tx5_syncheader_i,
  input  wire   [1:0] pipe_tx5_eqcontrol_i,
  input  wire   [5:0] pipe_tx5_eqdeemph_i,
  input  wire   [3:0] pipe_tx5_eqpreset_i,
  input  wire   [1:0] pipe_rx5_char_is_k_i,
  input  wire  [31:0] pipe_rx5_data_i,
  input  wire         pipe_rx5_valid_i,
  input  wire         pipe_rx5_data_valid_i,
  input  wire   [2:0] pipe_rx5_status_i,
  input  wire         pipe_rx5_phy_status_i,
  input  wire         pipe_rx5_elec_idle_i,
  input  wire         pipe_rx5_eqdone_i,
  input  wire         pipe_rx5_eqlpadaptdone_i,
  input  wire         pipe_rx5_eqlplffssel_i,
  input  wire  [17:0] pipe_rx5_eqlpnewtxcoefforpreset_i,
  input  wire         pipe_rx5_startblock_i,
  input  wire   [1:0] pipe_rx5_syncheader_i,
  output wire         pipe_rx5_polarity_o,
  output wire   [1:0] pipe_rx5_eqcontrol_o,
  output wire   [5:0] pipe_rx5_eqlplffs_o,
  output wire   [3:0] pipe_rx5_eqlptxpreset_o,
  output wire   [2:0] pipe_rx5_eqpreset_o,
  input  wire  [17:0] pipe_tx5_eqcoeff_i,
  input  wire         pipe_tx5_eqdone_i,
  output wire         pipe_tx5_compliance_o,
  output wire   [1:0] pipe_tx5_char_is_k_o,
  output wire  [31:0] pipe_tx5_data_o,
  output wire         pipe_tx5_elec_idle_o,
  output wire   [1:0] pipe_tx5_powerdown_o,
  output wire         pipe_tx5_datavalid_o,
  output wire         pipe_tx5_startblock_o,
  output wire   [1:0] pipe_tx5_syncheader_o,
  output wire   [1:0] pipe_tx5_eqcontrol_o,
  output wire   [5:0] pipe_tx5_eqdeemph_o,
  output wire   [3:0] pipe_tx5_eqpreset_o,
  output wire   [1:0] pipe_rx6_char_is_k_o,
  output wire  [31:0] pipe_rx6_data_o,
  output wire         pipe_rx6_valid_o,
  output wire         pipe_rx6_data_valid_o,
  output wire   [2:0] pipe_rx6_status_o,
  output wire         pipe_rx6_phy_status_o,
  output wire         pipe_rx6_elec_idle_o,
  output wire         pipe_rx6_eqdone_o,
  output wire         pipe_rx6_eqlpadaptdone_o,
  output wire         pipe_rx6_eqlplffssel_o,
  output wire  [17:0] pipe_rx6_eqlpnewtxcoefforpreset_o,
  output wire         pipe_rx6_startblock_o,
  output wire   [1:0] pipe_rx6_syncheader_o,
  input  wire         pipe_rx6_polarity_i,
  input  wire   [1:0] pipe_rx6_eqcontrol_i,
  input  wire   [5:0] pipe_rx6_eqlplffs_i,
  input  wire   [3:0] pipe_rx6_eqlptxpreset_i,
  input  wire   [2:0] pipe_rx6_eqpreset_i,
  output wire  [17:0] pipe_tx6_eqcoeff_o,
  output wire         pipe_tx6_eqdone_o,
  input  wire         pipe_tx6_compliance_i,
  input  wire   [1:0] pipe_tx6_char_is_k_i,
  input  wire  [31:0] pipe_tx6_data_i,
  input  wire         pipe_tx6_elec_idle_i,
  input  wire   [1:0] pipe_tx6_powerdown_i,
  input  wire         pipe_tx6_datavalid_i,
  input  wire         pipe_tx6_startblock_i,
  input  wire   [1:0] pipe_tx6_syncheader_i,
  input  wire   [1:0] pipe_tx6_eqcontrol_i,
  input  wire   [5:0] pipe_tx6_eqdeemph_i,
  input  wire   [3:0] pipe_tx6_eqpreset_i,
  input  wire   [1:0] pipe_rx6_char_is_k_i,
  input  wire  [31:0] pipe_rx6_data_i,
  input  wire         pipe_rx6_valid_i,
  input  wire         pipe_rx6_data_valid_i,
  input  wire   [2:0] pipe_rx6_status_i,
  input  wire         pipe_rx6_phy_status_i,
  input  wire         pipe_rx6_elec_idle_i,
  input  wire         pipe_rx6_eqdone_i,
  input  wire         pipe_rx6_eqlpadaptdone_i,
  input  wire         pipe_rx6_eqlplffssel_i,
  input  wire  [17:0] pipe_rx6_eqlpnewtxcoefforpreset_i,
  input  wire         pipe_rx6_startblock_i,
  input  wire   [1:0] pipe_rx6_syncheader_i,
  output wire         pipe_rx6_polarity_o,
  output wire   [1:0] pipe_rx6_eqcontrol_o,
  output wire   [5:0] pipe_rx6_eqlplffs_o,
  output wire   [3:0] pipe_rx6_eqlptxpreset_o,
  output wire   [2:0] pipe_rx6_eqpreset_o,
  input  wire  [17:0] pipe_tx6_eqcoeff_i,
  input  wire         pipe_tx6_eqdone_i,
  output wire         pipe_tx6_compliance_o,
  output wire   [1:0] pipe_tx6_char_is_k_o,
  output wire  [31:0] pipe_tx6_data_o,
  output wire         pipe_tx6_elec_idle_o,
  output wire   [1:0] pipe_tx6_powerdown_o,
  output wire         pipe_tx6_datavalid_o,
  output wire         pipe_tx6_startblock_o,
  output wire   [1:0] pipe_tx6_syncheader_o,
  output wire   [1:0] pipe_tx6_eqcontrol_o,
  output wire   [5:0] pipe_tx6_eqdeemph_o,
  output wire   [3:0] pipe_tx6_eqpreset_o,
  output wire   [1:0] pipe_rx7_char_is_k_o,
  output wire  [31:0] pipe_rx7_data_o,
  output wire         pipe_rx7_valid_o,
  output wire         pipe_rx7_data_valid_o,
  output wire   [2:0] pipe_rx7_status_o,
  output wire         pipe_rx7_phy_status_o,
  output wire         pipe_rx7_elec_idle_o,
  output wire         pipe_rx7_eqdone_o,
  output wire         pipe_rx7_eqlpadaptdone_o,
  output wire         pipe_rx7_eqlplffssel_o,
  output wire  [17:0] pipe_rx7_eqlpnewtxcoefforpreset_o,
  output wire         pipe_rx7_startblock_o,
  output wire   [1:0] pipe_rx7_syncheader_o,
  input  wire         pipe_rx7_polarity_i,
  input  wire   [1:0] pipe_rx7_eqcontrol_i,
  input  wire   [5:0] pipe_rx7_eqlplffs_i,
  input  wire   [3:0] pipe_rx7_eqlptxpreset_i,
  input  wire   [2:0] pipe_rx7_eqpreset_i,
  output wire  [17:0] pipe_tx7_eqcoeff_o,
  output wire         pipe_tx7_eqdone_o,
  input  wire         pipe_tx7_compliance_i,
  input  wire   [1:0] pipe_tx7_char_is_k_i,
  input  wire  [31:0] pipe_tx7_data_i,
  input  wire         pipe_tx7_elec_idle_i,
  input  wire   [1:0] pipe_tx7_powerdown_i,
  input  wire         pipe_tx7_datavalid_i,
  input  wire         pipe_tx7_startblock_i,
  input  wire   [1:0] pipe_tx7_syncheader_i,
  input  wire   [1:0] pipe_tx7_eqcontrol_i,
  input  wire   [5:0] pipe_tx7_eqdeemph_i,
  input  wire   [3:0] pipe_tx7_eqpreset_i,
  input  wire   [1:0] pipe_rx7_char_is_k_i,
  input  wire  [31:0] pipe_rx7_data_i,
  input  wire         pipe_rx7_valid_i,
  input  wire         pipe_rx7_data_valid_i,
  input  wire   [2:0] pipe_rx7_status_i,
  input  wire         pipe_rx7_phy_status_i,
  input  wire         pipe_rx7_elec_idle_i,
  input  wire         pipe_rx7_eqdone_i,
  input  wire         pipe_rx7_eqlpadaptdone_i,
  input  wire         pipe_rx7_eqlplffssel_i,
  input  wire  [17:0] pipe_rx7_eqlpnewtxcoefforpreset_i,
  input  wire         pipe_rx7_startblock_i,
  input  wire   [1:0] pipe_rx7_syncheader_i,
  output wire         pipe_rx7_polarity_o,
  output wire   [1:0] pipe_rx7_eqcontrol_o,
  output wire   [5:0] pipe_rx7_eqlplffs_o,
  output wire   [3:0] pipe_rx7_eqlptxpreset_o,
  output wire   [2:0] pipe_rx7_eqpreset_o,
  input  wire  [17:0] pipe_tx7_eqcoeff_i,
  input  wire         pipe_tx7_eqdone_i,
  output wire         pipe_tx7_compliance_o,
  output wire   [1:0] pipe_tx7_char_is_k_o,
  output wire  [31:0] pipe_tx7_data_o,
  output wire         pipe_tx7_elec_idle_o,
  output wire   [1:0] pipe_tx7_powerdown_o,
  output wire         pipe_tx7_datavalid_o,
  output wire         pipe_tx7_startblock_o,
  output wire   [1:0] pipe_tx7_syncheader_o,
  output wire   [1:0] pipe_tx7_eqcontrol_o,
  output wire   [5:0] pipe_tx7_eqdeemph_o,
  output wire   [3:0] pipe_tx7_eqpreset_o,
  input  wire         pipe_clk,
  input  wire         rst_n
  );

  generate
    rp_pipe_misc 
  #(
      .TCQ (TCQ),
      .PIPE_PIPELINE_STAGES (PIPE_PIPELINE_STAGES))
    pipe_misc_inst (
      .pipe_tx_rcvr_det_i (pipe_tx_rcvr_det_i),
      .pipe_tx_reset_i (pipe_tx_reset_i),
      .pipe_tx_rate_i (pipe_tx_rate_i),
      .pipe_tx_deemph_i (pipe_tx_deemph_i),
      .pipe_tx_margin_i (pipe_tx_margin_i),
      .pipe_tx_swing_i (pipe_tx_swing_i),
      .pipe_tx_eqfs_i (pipe_tx_eqfs_i),
      .pipe_tx_eqlf_i (pipe_tx_eqlf_i),
      .pipe_tx_rcvr_det_o (pipe_tx_rcvr_det_o),
      .pipe_tx_reset_o (pipe_tx_reset_o),
      .pipe_tx_rate_o (pipe_tx_rate_o),
      .pipe_tx_deemph_o (pipe_tx_deemph_o),
      .pipe_tx_margin_o (pipe_tx_margin_o),
      .pipe_tx_swing_o (pipe_tx_swing_o),
      .pipe_tx_eqfs_o (pipe_tx_eqfs_o),
      .pipe_tx_eqlf_o (pipe_tx_eqlf_o),
      .pipe_clk (pipe_clk),
      .rst_n (rst_n)
    );
    rp_pipe_lane 
   #(
      .TCQ (TCQ),
      .PIPE_PIPELINE_STAGES (PIPE_PIPELINE_STAGES))
    pipe_lane_0_inst (
      .pipe_rx_char_is_k_o (pipe_rx0_char_is_k_o),
      .pipe_rx_data_o (pipe_rx0_data_o),
      .pipe_rx_valid_o (pipe_rx0_valid_o),
      .pipe_rx_data_valid_o (pipe_rx0_data_valid_o),
      .pipe_rx_status_o (pipe_rx0_status_o),
      .pipe_rx_phy_status_o (pipe_rx0_phy_status_o),
      .pipe_rx_elec_idle_o (pipe_rx0_elec_idle_o),
      .pipe_rx_eqdone_o (pipe_rx0_eqdone_o),
      .pipe_rx_eqlpadaptdone_o (pipe_rx0_eqlpadaptdone_o),
      .pipe_rx_eqlplffssel_o (pipe_rx0_eqlplffssel_o),
      .pipe_rx_eqlpnewtxcoefforpreset_o (pipe_rx0_eqlpnewtxcoefforpreset_o),
      .pipe_rx_startblock_o (pipe_rx0_startblock_o),
      .pipe_rx_syncheader_o (pipe_rx0_syncheader_o),
      .pipe_rx_polarity_i (pipe_rx0_polarity_i),
      .pipe_rx_eqcontrol_i (pipe_rx0_eqcontrol_i),
      .pipe_rx_eqlplffs_i (pipe_rx0_eqlplffs_i),
      .pipe_rx_eqlptxpreset_i (pipe_rx0_eqlptxpreset_i),
      .pipe_rx_eqpreset_i (pipe_rx0_eqpreset_i),
      .pipe_tx_eqcoeff_o (pipe_tx0_eqcoeff_o),
      .pipe_tx_eqdone_o (pipe_tx0_eqdone_o),
      .pipe_tx_compliance_i (pipe_tx0_compliance_i),
      .pipe_tx_char_is_k_i (pipe_tx0_char_is_k_i),
      .pipe_tx_data_i (pipe_tx0_data_i),
      .pipe_tx_elec_idle_i (pipe_tx0_elec_idle_i),
      .pipe_tx_powerdown_i (pipe_tx0_powerdown_i),
      .pipe_tx_datavalid_i (pipe_tx0_datavalid_i),
      .pipe_tx_startblock_i (pipe_tx0_startblock_i),
      .pipe_tx_syncheader_i (pipe_tx0_syncheader_i),
      .pipe_tx_eqcontrol_i (pipe_tx0_eqcontrol_i),
      .pipe_tx_eqdeemph_i (pipe_tx0_eqdeemph_i),
      .pipe_tx_eqpreset_i (pipe_tx0_eqpreset_i),
      .pipe_rx_char_is_k_i (pipe_rx0_char_is_k_i),
      .pipe_rx_data_i (pipe_rx0_data_i),
      .pipe_rx_valid_i (pipe_rx0_valid_i),
      .pipe_rx_data_valid_i (pipe_rx0_data_valid_i),
      .pipe_rx_status_i (pipe_rx0_status_i),
      .pipe_rx_phy_status_i (pipe_rx0_phy_status_i),
      .pipe_rx_elec_idle_i (pipe_rx0_elec_idle_i),
      .pipe_rx_eqdone_i (pipe_rx0_eqdone_i),
      .pipe_rx_eqlpadaptdone_i (pipe_rx0_eqlpadaptdone_i),
      .pipe_rx_eqlplffssel_i (pipe_rx0_eqlplffssel_i),
      .pipe_rx_eqlpnewtxcoefforpreset_i (pipe_rx0_eqlpnewtxcoefforpreset_i),
      .pipe_rx_startblock_i (pipe_rx0_startblock_i),
      .pipe_rx_syncheader_i (pipe_rx0_syncheader_i),
      .pipe_rx_polarity_o (pipe_rx0_polarity_o),
      .pipe_rx_eqcontrol_o (pipe_rx0_eqcontrol_o),
      .pipe_rx_eqlplffs_o (pipe_rx0_eqlplffs_o),
      .pipe_rx_eqlptxpreset_o (pipe_rx0_eqlptxpreset_o),
      .pipe_rx_eqpreset_o (pipe_rx0_eqpreset_o),
      .pipe_tx_eqcoeff_i (pipe_tx0_eqcoeff_i),
      .pipe_tx_eqdone_i (pipe_tx0_eqdone_i),
      .pipe_tx_compliance_o (pipe_tx0_compliance_o),
      .pipe_tx_char_is_k_o (pipe_tx0_char_is_k_o),
      .pipe_tx_data_o (pipe_tx0_data_o),
      .pipe_tx_elec_idle_o (pipe_tx0_elec_idle_o),
      .pipe_tx_powerdown_o (pipe_tx0_powerdown_o),
      .pipe_tx_datavalid_o (pipe_tx0_datavalid_o),
      .pipe_tx_startblock_o (pipe_tx0_startblock_o),
      .pipe_tx_syncheader_o (pipe_tx0_syncheader_o),
      .pipe_tx_eqcontrol_o (pipe_tx0_eqcontrol_o),
      .pipe_tx_eqdeemph_o (pipe_tx0_eqdeemph_o),
      .pipe_tx_eqpreset_o (pipe_tx0_eqpreset_o),
      .pipe_clk (pipe_clk),
      .rst_n (rst_n)
    );
    if (PL_LINK_CAP_MAX_LINK_WIDTH >= 2)
    begin : pipe_2_lane
      rp_pipe_lane 
    #(
        .TCQ (TCQ),
        .PIPE_PIPELINE_STAGES (PIPE_PIPELINE_STAGES))
      pipe_lane_1_inst (
        .pipe_rx_char_is_k_o (pipe_rx1_char_is_k_o),
        .pipe_rx_data_o (pipe_rx1_data_o),
        .pipe_rx_valid_o (pipe_rx1_valid_o),
        .pipe_rx_data_valid_o (pipe_rx1_data_valid_o),
        .pipe_rx_status_o (pipe_rx1_status_o),
        .pipe_rx_phy_status_o (pipe_rx1_phy_status_o),
        .pipe_rx_elec_idle_o (pipe_rx1_elec_idle_o),
        .pipe_rx_eqdone_o (pipe_rx1_eqdone_o),
        .pipe_rx_eqlpadaptdone_o (pipe_rx1_eqlpadaptdone_o),
        .pipe_rx_eqlplffssel_o (pipe_rx1_eqlplffssel_o),
        .pipe_rx_eqlpnewtxcoefforpreset_o (pipe_rx1_eqlpnewtxcoefforpreset_o),
        .pipe_rx_startblock_o (pipe_rx1_startblock_o),
        .pipe_rx_syncheader_o (pipe_rx1_syncheader_o),
        .pipe_rx_polarity_i (pipe_rx1_polarity_i),
        .pipe_rx_eqcontrol_i (pipe_rx1_eqcontrol_i),
        .pipe_rx_eqlplffs_i (pipe_rx1_eqlplffs_i),
        .pipe_rx_eqlptxpreset_i (pipe_rx1_eqlptxpreset_i),
        .pipe_rx_eqpreset_i (pipe_rx1_eqpreset_i),
        .pipe_tx_eqcoeff_o (pipe_tx1_eqcoeff_o),
        .pipe_tx_eqdone_o (pipe_tx1_eqdone_o),
        .pipe_tx_compliance_i (pipe_tx1_compliance_i),
        .pipe_tx_char_is_k_i (pipe_tx1_char_is_k_i),
        .pipe_tx_data_i (pipe_tx1_data_i),
        .pipe_tx_elec_idle_i (pipe_tx1_elec_idle_i),
        .pipe_tx_powerdown_i (pipe_tx1_powerdown_i),
        .pipe_tx_datavalid_i (pipe_tx1_datavalid_i),
        .pipe_tx_startblock_i (pipe_tx1_startblock_i),
        .pipe_tx_syncheader_i (pipe_tx1_syncheader_i),
        .pipe_tx_eqcontrol_i (pipe_tx1_eqcontrol_i),
        .pipe_tx_eqdeemph_i (pipe_tx1_eqdeemph_i),
        .pipe_tx_eqpreset_i (pipe_tx1_eqpreset_i),
        .pipe_rx_char_is_k_i (pipe_rx1_char_is_k_i),
        .pipe_rx_data_i (pipe_rx1_data_i),
        .pipe_rx_valid_i (pipe_rx1_valid_i),
        .pipe_rx_data_valid_i (pipe_rx1_data_valid_i),
        .pipe_rx_status_i (pipe_rx1_status_i),
        .pipe_rx_phy_status_i (pipe_rx1_phy_status_i),
        .pipe_rx_elec_idle_i (pipe_rx1_elec_idle_i),
        .pipe_rx_eqdone_i (pipe_rx1_eqdone_i),
        .pipe_rx_eqlpadaptdone_i (pipe_rx1_eqlpadaptdone_i),
        .pipe_rx_eqlplffssel_i (pipe_rx1_eqlplffssel_i),
        .pipe_rx_eqlpnewtxcoefforpreset_i (pipe_rx1_eqlpnewtxcoefforpreset_i),
        .pipe_rx_startblock_i (pipe_rx1_startblock_i),
        .pipe_rx_syncheader_i (pipe_rx1_syncheader_i),
        .pipe_rx_polarity_o (pipe_rx1_polarity_o),
        .pipe_rx_eqcontrol_o (pipe_rx1_eqcontrol_o),
        .pipe_rx_eqlplffs_o (pipe_rx1_eqlplffs_o),
        .pipe_rx_eqlptxpreset_o (pipe_rx1_eqlptxpreset_o),
        .pipe_rx_eqpreset_o (pipe_rx1_eqpreset_o),
        .pipe_tx_eqcoeff_i (pipe_tx1_eqcoeff_i),
        .pipe_tx_eqdone_i (pipe_tx1_eqdone_i),
        .pipe_tx_compliance_o (pipe_tx1_compliance_o),
        .pipe_tx_char_is_k_o (pipe_tx1_char_is_k_o),
        .pipe_tx_data_o (pipe_tx1_data_o),
        .pipe_tx_elec_idle_o (pipe_tx1_elec_idle_o),
        .pipe_tx_powerdown_o (pipe_tx1_powerdown_o),
        .pipe_tx_datavalid_o (pipe_tx1_datavalid_o),
        .pipe_tx_startblock_o (pipe_tx1_startblock_o),
        .pipe_tx_syncheader_o (pipe_tx1_syncheader_o),
        .pipe_tx_eqcontrol_o (pipe_tx1_eqcontrol_o),
        .pipe_tx_eqdeemph_o (pipe_tx1_eqdeemph_o),
        .pipe_tx_eqpreset_o (pipe_tx1_eqpreset_o),
        .pipe_clk (pipe_clk),
        .rst_n (rst_n)
      );
    end
    else
    begin
      assign pipe_rx1_char_is_k_o = 2'b00;
      assign pipe_rx1_data_o = 32'h00000000;
      assign pipe_rx1_valid_o = 1'b0;
      assign pipe_rx1_data_valid_o = 1'b0;
      assign pipe_rx1_status_o = 2'b00;
      assign pipe_rx1_phy_status_o = 1'b0;
      assign pipe_rx1_elec_idle_o = 1'b1;
      assign pipe_rx1_eqdone_o = 1'b0;
      assign pipe_rx1_eqlpadaptdone_o = 1'b0;
      assign pipe_rx1_eqlplffssel_o = 1'b0;
      assign pipe_rx1_eqlpnewtxcoefforpreset_o = 17'b00000000000000000;
      assign pipe_rx1_startblock_o = 1'b0;
      assign pipe_rx1_syncheader_o = 2'b00;
      assign pipe_tx1_eqcoeff_o = 17'b00000000000000000;
      assign pipe_tx1_eqdone_o = 1'b0;
      assign pipe_rx1_polarity_o = 1'b0;
      assign pipe_rx1_eqcontrol_o = 2'b00;
      assign pipe_rx1_eqlplffs_o = 6'b000000;
      assign pipe_rx1_eqlptxpreset_o = 4'h0;
      assign pipe_rx1_eqpreset_o = 3'b000;
      assign pipe_tx1_compliance_o = 1'b0;
      assign pipe_tx1_char_is_k_o = 2'b00;
      assign pipe_tx1_data_o = 32'h00000000;
      assign pipe_tx1_elec_idle_o = 1'b1;
      assign pipe_tx1_powerdown_o = 2'b00;
      assign pipe_tx1_datavalid_o = 1'b0;
      assign pipe_tx1_startblock_o = 1'b0;
      assign pipe_tx1_syncheader_o = 2'b00;
      assign pipe_tx1_eqcontrol_o = 2'b00;
      assign pipe_tx1_eqdeemph_o = 6'b000000;
      assign pipe_tx1_eqpreset_o = 4'h0;
    end
    if (PL_LINK_CAP_MAX_LINK_WIDTH >= 4)
    begin : pipe_4_lane
      rp_pipe_lane 
    #(
        .TCQ (TCQ),
        .PIPE_PIPELINE_STAGES (PIPE_PIPELINE_STAGES))
      pipe_lane_2_inst (
        .pipe_rx_char_is_k_o (pipe_rx2_char_is_k_o),
        .pipe_rx_data_o (pipe_rx2_data_o),
        .pipe_rx_valid_o (pipe_rx2_valid_o),
        .pipe_rx_data_valid_o (pipe_rx2_data_valid_o),
        .pipe_rx_status_o (pipe_rx2_status_o),
        .pipe_rx_phy_status_o (pipe_rx2_phy_status_o),
        .pipe_rx_elec_idle_o (pipe_rx2_elec_idle_o),
        .pipe_rx_eqdone_o (pipe_rx2_eqdone_o),
        .pipe_rx_eqlpadaptdone_o (pipe_rx2_eqlpadaptdone_o),
        .pipe_rx_eqlplffssel_o (pipe_rx2_eqlplffssel_o),
        .pipe_rx_eqlpnewtxcoefforpreset_o (pipe_rx2_eqlpnewtxcoefforpreset_o),
        .pipe_rx_startblock_o (pipe_rx2_startblock_o),
        .pipe_rx_syncheader_o (pipe_rx2_syncheader_o),
        .pipe_rx_polarity_i (pipe_rx2_polarity_i),
        .pipe_rx_eqcontrol_i (pipe_rx2_eqcontrol_i),
        .pipe_rx_eqlplffs_i (pipe_rx2_eqlplffs_i),
        .pipe_rx_eqlptxpreset_i (pipe_rx2_eqlptxpreset_i),
        .pipe_rx_eqpreset_i (pipe_rx2_eqpreset_i),
        .pipe_tx_eqcoeff_o (pipe_tx2_eqcoeff_o),
        .pipe_tx_eqdone_o (pipe_tx2_eqdone_o),
        .pipe_tx_compliance_i (pipe_tx2_compliance_i),
        .pipe_tx_char_is_k_i (pipe_tx2_char_is_k_i),
        .pipe_tx_data_i (pipe_tx2_data_i),
        .pipe_tx_elec_idle_i (pipe_tx2_elec_idle_i),
        .pipe_tx_powerdown_i (pipe_tx2_powerdown_i),
        .pipe_tx_datavalid_i (pipe_tx2_datavalid_i),
        .pipe_tx_startblock_i (pipe_tx2_startblock_i),
        .pipe_tx_syncheader_i (pipe_tx2_syncheader_i),
        .pipe_tx_eqcontrol_i (pipe_tx2_eqcontrol_i),
        .pipe_tx_eqdeemph_i (pipe_tx2_eqdeemph_i),
        .pipe_tx_eqpreset_i (pipe_tx2_eqpreset_i),
        .pipe_rx_char_is_k_i (pipe_rx2_char_is_k_i),
        .pipe_rx_data_i (pipe_rx2_data_i),
        .pipe_rx_valid_i (pipe_rx2_valid_i),
        .pipe_rx_data_valid_i (pipe_rx2_data_valid_i),
        .pipe_rx_status_i (pipe_rx2_status_i),
        .pipe_rx_phy_status_i (pipe_rx2_phy_status_i),
        .pipe_rx_elec_idle_i (pipe_rx2_elec_idle_i),
        .pipe_rx_eqdone_i (pipe_rx2_eqdone_i),
        .pipe_rx_eqlpadaptdone_i (pipe_rx2_eqlpadaptdone_i),
        .pipe_rx_eqlplffssel_i (pipe_rx2_eqlplffssel_i),
        .pipe_rx_eqlpnewtxcoefforpreset_i (pipe_rx2_eqlpnewtxcoefforpreset_i),
        .pipe_rx_startblock_i (pipe_rx2_startblock_i),
        .pipe_rx_syncheader_i (pipe_rx2_syncheader_i),
        .pipe_rx_polarity_o (pipe_rx2_polarity_o),
        .pipe_rx_eqcontrol_o (pipe_rx2_eqcontrol_o),
        .pipe_rx_eqlplffs_o (pipe_rx2_eqlplffs_o),
        .pipe_rx_eqlptxpreset_o (pipe_rx2_eqlptxpreset_o),
        .pipe_rx_eqpreset_o (pipe_rx2_eqpreset_o),
        .pipe_tx_eqcoeff_i (pipe_tx2_eqcoeff_i),
        .pipe_tx_eqdone_i (pipe_tx2_eqdone_i),
        .pipe_tx_compliance_o (pipe_tx2_compliance_o),
        .pipe_tx_char_is_k_o (pipe_tx2_char_is_k_o),
        .pipe_tx_data_o (pipe_tx2_data_o),
        .pipe_tx_elec_idle_o (pipe_tx2_elec_idle_o),
        .pipe_tx_powerdown_o (pipe_tx2_powerdown_o),
        .pipe_tx_datavalid_o (pipe_tx2_datavalid_o),
        .pipe_tx_startblock_o (pipe_tx2_startblock_o),
        .pipe_tx_syncheader_o (pipe_tx2_syncheader_o),
        .pipe_tx_eqcontrol_o (pipe_tx2_eqcontrol_o),
        .pipe_tx_eqdeemph_o (pipe_tx2_eqdeemph_o),
        .pipe_tx_eqpreset_o (pipe_tx2_eqpreset_o),
        .pipe_clk (pipe_clk),
        .rst_n (rst_n)
      );
      rp_pipe_lane 
     #(
        .TCQ (TCQ),
        .PIPE_PIPELINE_STAGES (PIPE_PIPELINE_STAGES))
      pipe_lane_3_inst (
        .pipe_rx_char_is_k_o (pipe_rx3_char_is_k_o),
        .pipe_rx_data_o (pipe_rx3_data_o),
        .pipe_rx_valid_o (pipe_rx3_valid_o),
        .pipe_rx_data_valid_o (pipe_rx3_data_valid_o),
        .pipe_rx_status_o (pipe_rx3_status_o),
        .pipe_rx_phy_status_o (pipe_rx3_phy_status_o),
        .pipe_rx_elec_idle_o (pipe_rx3_elec_idle_o),
        .pipe_rx_eqdone_o (pipe_rx3_eqdone_o),
        .pipe_rx_eqlpadaptdone_o (pipe_rx3_eqlpadaptdone_o),
        .pipe_rx_eqlplffssel_o (pipe_rx3_eqlplffssel_o),
        .pipe_rx_eqlpnewtxcoefforpreset_o (pipe_rx3_eqlpnewtxcoefforpreset_o),
        .pipe_rx_startblock_o (pipe_rx3_startblock_o),
        .pipe_rx_syncheader_o (pipe_rx3_syncheader_o),
        .pipe_rx_polarity_i (pipe_rx3_polarity_i),
        .pipe_rx_eqcontrol_i (pipe_rx3_eqcontrol_i),
        .pipe_rx_eqlplffs_i (pipe_rx3_eqlplffs_i),
        .pipe_rx_eqlptxpreset_i (pipe_rx3_eqlptxpreset_i),
        .pipe_rx_eqpreset_i (pipe_rx3_eqpreset_i),
        .pipe_tx_eqcoeff_o (pipe_tx3_eqcoeff_o),
        .pipe_tx_eqdone_o (pipe_tx3_eqdone_o),
        .pipe_tx_compliance_i (pipe_tx3_compliance_i),
        .pipe_tx_char_is_k_i (pipe_tx3_char_is_k_i),
        .pipe_tx_data_i (pipe_tx3_data_i),
        .pipe_tx_elec_idle_i (pipe_tx3_elec_idle_i),
        .pipe_tx_powerdown_i (pipe_tx3_powerdown_i),
        .pipe_tx_datavalid_i (pipe_tx3_datavalid_i),
        .pipe_tx_startblock_i (pipe_tx3_startblock_i),
        .pipe_tx_syncheader_i (pipe_tx3_syncheader_i),
        .pipe_tx_eqcontrol_i (pipe_tx3_eqcontrol_i),
        .pipe_tx_eqdeemph_i (pipe_tx3_eqdeemph_i),
        .pipe_tx_eqpreset_i (pipe_tx3_eqpreset_i),
        .pipe_rx_char_is_k_i (pipe_rx3_char_is_k_i),
        .pipe_rx_data_i (pipe_rx3_data_i),
        .pipe_rx_valid_i (pipe_rx3_valid_i),
        .pipe_rx_data_valid_i (pipe_rx3_data_valid_i),
        .pipe_rx_status_i (pipe_rx3_status_i),
        .pipe_rx_phy_status_i (pipe_rx3_phy_status_i),
        .pipe_rx_elec_idle_i (pipe_rx3_elec_idle_i),
        .pipe_rx_eqdone_i (pipe_rx3_eqdone_i),
        .pipe_rx_eqlpadaptdone_i (pipe_rx3_eqlpadaptdone_i),
        .pipe_rx_eqlplffssel_i (pipe_rx3_eqlplffssel_i),
        .pipe_rx_eqlpnewtxcoefforpreset_i (pipe_rx3_eqlpnewtxcoefforpreset_i),
        .pipe_rx_startblock_i (pipe_rx3_startblock_i),
        .pipe_rx_syncheader_i (pipe_rx3_syncheader_i),
        .pipe_rx_polarity_o (pipe_rx3_polarity_o),
        .pipe_rx_eqcontrol_o (pipe_rx3_eqcontrol_o),
        .pipe_rx_eqlplffs_o (pipe_rx3_eqlplffs_o),
        .pipe_rx_eqlptxpreset_o (pipe_rx3_eqlptxpreset_o),
        .pipe_rx_eqpreset_o (pipe_rx3_eqpreset_o),
        .pipe_tx_eqcoeff_i (pipe_tx3_eqcoeff_i),
        .pipe_tx_eqdone_i (pipe_tx3_eqdone_i),
        .pipe_tx_compliance_o (pipe_tx3_compliance_o),
        .pipe_tx_char_is_k_o (pipe_tx3_char_is_k_o),
        .pipe_tx_data_o (pipe_tx3_data_o),
        .pipe_tx_elec_idle_o (pipe_tx3_elec_idle_o),
        .pipe_tx_powerdown_o (pipe_tx3_powerdown_o),
        .pipe_tx_datavalid_o (pipe_tx3_datavalid_o),
        .pipe_tx_startblock_o (pipe_tx3_startblock_o),
        .pipe_tx_syncheader_o (pipe_tx3_syncheader_o),
        .pipe_tx_eqcontrol_o (pipe_tx3_eqcontrol_o),
        .pipe_tx_eqdeemph_o (pipe_tx3_eqdeemph_o),
        .pipe_tx_eqpreset_o (pipe_tx3_eqpreset_o),
        .pipe_clk (pipe_clk),
        .rst_n (rst_n)
      );
    end
    else
    begin
      assign pipe_rx2_char_is_k_o = 2'b00;
      assign pipe_rx2_data_o = 32'h00000000;
      assign pipe_rx2_valid_o = 1'b0;
      assign pipe_rx2_data_valid_o = 1'b0;
      assign pipe_rx2_status_o = 2'b00;
      assign pipe_rx2_phy_status_o = 1'b0;
      assign pipe_rx2_elec_idle_o = 1'b1;
      assign pipe_rx2_eqdone_o = 1'b0;
      assign pipe_rx2_eqlpadaptdone_o = 1'b0;
      assign pipe_rx2_eqlplffssel_o = 1'b0;
      assign pipe_rx2_eqlpnewtxcoefforpreset_o = 17'b00000000000000000;
      assign pipe_rx2_startblock_o = 1'b0;
      assign pipe_rx2_syncheader_o = 2'b00;
      assign pipe_tx2_eqcoeff_o = 17'b00000000000000000;
      assign pipe_tx2_eqdone_o = 1'b0;
      assign pipe_rx2_polarity_o = 1'b0;
      assign pipe_rx2_eqcontrol_o = 2'b00;
      assign pipe_rx2_eqlplffs_o = 6'b000000;
      assign pipe_rx2_eqlptxpreset_o = 4'h0;
      assign pipe_rx2_eqpreset_o = 3'b000;
      assign pipe_tx2_compliance_o = 1'b0;
      assign pipe_tx2_char_is_k_o = 2'b00;
      assign pipe_tx2_data_o = 32'h00000000;
      assign pipe_tx2_elec_idle_o = 1'b1;
      assign pipe_tx2_powerdown_o = 2'b00;
      assign pipe_tx2_datavalid_o = 1'b0;
      assign pipe_tx2_startblock_o = 1'b0;
      assign pipe_tx2_syncheader_o = 2'b00;
      assign pipe_tx2_eqcontrol_o = 2'b00;
      assign pipe_tx2_eqdeemph_o = 6'b000000;
      assign pipe_tx2_eqpreset_o = 4'h0;
      assign pipe_rx3_char_is_k_o = 2'b00;
      assign pipe_rx3_data_o = 32'h00000000;
      assign pipe_rx3_valid_o = 1'b0;
      assign pipe_rx3_data_valid_o = 1'b0;
      assign pipe_rx3_status_o = 2'b00;
      assign pipe_rx3_phy_status_o = 1'b0;
      assign pipe_rx3_elec_idle_o = 1'b1;
      assign pipe_rx3_eqdone_o = 1'b0;
      assign pipe_rx3_eqlpadaptdone_o = 1'b0;
      assign pipe_rx3_eqlplffssel_o = 1'b0;
      assign pipe_rx3_eqlpnewtxcoefforpreset_o = 17'b00000000000000000;
      assign pipe_rx3_startblock_o = 1'b0;
      assign pipe_rx3_syncheader_o = 2'b00;
      assign pipe_tx3_eqcoeff_o = 17'b00000000000000000;
      assign pipe_tx3_eqdone_o = 1'b0;
      assign pipe_rx3_polarity_o = 1'b0;
      assign pipe_rx3_eqcontrol_o = 2'b00;
      assign pipe_rx3_eqlplffs_o = 6'b000000;
      assign pipe_rx3_eqlptxpreset_o = 4'h0;
      assign pipe_rx3_eqpreset_o = 3'b000;
      assign pipe_tx3_compliance_o = 1'b0;
      assign pipe_tx3_char_is_k_o = 2'b00;
      assign pipe_tx3_data_o = 32'h00000000;
      assign pipe_tx3_elec_idle_o = 1'b1;
      assign pipe_tx3_powerdown_o = 2'b00;
      assign pipe_tx3_datavalid_o = 1'b0;
      assign pipe_tx3_startblock_o = 1'b0;
      assign pipe_tx3_syncheader_o = 2'b00;
      assign pipe_tx3_eqcontrol_o = 2'b00;
      assign pipe_tx3_eqdeemph_o = 6'b000000;
      assign pipe_tx3_eqpreset_o = 4'h0;
    end
    if (PL_LINK_CAP_MAX_LINK_WIDTH >= 8)
    begin : pipe_8_lane
      rp_pipe_lane 
    #(
        .TCQ (TCQ),
        .PIPE_PIPELINE_STAGES (PIPE_PIPELINE_STAGES))
      pipe_lane_4_inst (
        .pipe_rx_char_is_k_o (pipe_rx4_char_is_k_o),
        .pipe_rx_data_o (pipe_rx4_data_o),
        .pipe_rx_valid_o (pipe_rx4_valid_o),
        .pipe_rx_data_valid_o (pipe_rx4_data_valid_o),
        .pipe_rx_status_o (pipe_rx4_status_o),
        .pipe_rx_phy_status_o (pipe_rx4_phy_status_o),
        .pipe_rx_elec_idle_o (pipe_rx4_elec_idle_o),
        .pipe_rx_eqdone_o (pipe_rx4_eqdone_o),
        .pipe_rx_eqlpadaptdone_o (pipe_rx4_eqlpadaptdone_o),
        .pipe_rx_eqlplffssel_o (pipe_rx4_eqlplffssel_o),
        .pipe_rx_eqlpnewtxcoefforpreset_o (pipe_rx4_eqlpnewtxcoefforpreset_o),
        .pipe_rx_startblock_o (pipe_rx4_startblock_o),
        .pipe_rx_syncheader_o (pipe_rx4_syncheader_o),
        .pipe_rx_polarity_i (pipe_rx4_polarity_i),
        .pipe_rx_eqcontrol_i (pipe_rx4_eqcontrol_i),
        .pipe_rx_eqlplffs_i (pipe_rx4_eqlplffs_i),
        .pipe_rx_eqlptxpreset_i (pipe_rx4_eqlptxpreset_i),
        .pipe_rx_eqpreset_i (pipe_rx4_eqpreset_i),
        .pipe_tx_eqcoeff_o (pipe_tx4_eqcoeff_o),
        .pipe_tx_eqdone_o (pipe_tx4_eqdone_o),
        .pipe_tx_compliance_i (pipe_tx4_compliance_i),
        .pipe_tx_char_is_k_i (pipe_tx4_char_is_k_i),
        .pipe_tx_data_i (pipe_tx4_data_i),
        .pipe_tx_elec_idle_i (pipe_tx4_elec_idle_i),
        .pipe_tx_powerdown_i (pipe_tx4_powerdown_i),
        .pipe_tx_datavalid_i (pipe_tx4_datavalid_i),
        .pipe_tx_startblock_i (pipe_tx4_startblock_i),
        .pipe_tx_syncheader_i (pipe_tx4_syncheader_i),
        .pipe_tx_eqcontrol_i (pipe_tx4_eqcontrol_i),
        .pipe_tx_eqdeemph_i (pipe_tx4_eqdeemph_i),
        .pipe_tx_eqpreset_i (pipe_tx4_eqpreset_i),
        .pipe_rx_char_is_k_i (pipe_rx4_char_is_k_i),
        .pipe_rx_data_i (pipe_rx4_data_i),
        .pipe_rx_valid_i (pipe_rx4_valid_i),
        .pipe_rx_data_valid_i (pipe_rx4_data_valid_i),
        .pipe_rx_status_i (pipe_rx4_status_i),
        .pipe_rx_phy_status_i (pipe_rx4_phy_status_i),
        .pipe_rx_elec_idle_i (pipe_rx4_elec_idle_i),
        .pipe_rx_eqdone_i (pipe_rx4_eqdone_i),
        .pipe_rx_eqlpadaptdone_i (pipe_rx4_eqlpadaptdone_i),
        .pipe_rx_eqlplffssel_i (pipe_rx4_eqlplffssel_i),
        .pipe_rx_eqlpnewtxcoefforpreset_i (pipe_rx4_eqlpnewtxcoefforpreset_i),
        .pipe_rx_startblock_i (pipe_rx4_startblock_i),
        .pipe_rx_syncheader_i (pipe_rx4_syncheader_i),
        .pipe_rx_polarity_o (pipe_rx4_polarity_o),
        .pipe_rx_eqcontrol_o (pipe_rx4_eqcontrol_o),
        .pipe_rx_eqlplffs_o (pipe_rx4_eqlplffs_o),
        .pipe_rx_eqlptxpreset_o (pipe_rx4_eqlptxpreset_o),
        .pipe_rx_eqpreset_o (pipe_rx4_eqpreset_o),
        .pipe_tx_eqcoeff_i (pipe_tx4_eqcoeff_i),
        .pipe_tx_eqdone_i (pipe_tx4_eqdone_i),
        .pipe_tx_compliance_o (pipe_tx4_compliance_o),
        .pipe_tx_char_is_k_o (pipe_tx4_char_is_k_o),
        .pipe_tx_data_o (pipe_tx4_data_o),
        .pipe_tx_elec_idle_o (pipe_tx4_elec_idle_o),
        .pipe_tx_powerdown_o (pipe_tx4_powerdown_o),
        .pipe_tx_datavalid_o (pipe_tx4_datavalid_o),
        .pipe_tx_startblock_o (pipe_tx4_startblock_o),
        .pipe_tx_syncheader_o (pipe_tx4_syncheader_o),
        .pipe_tx_eqcontrol_o (pipe_tx4_eqcontrol_o),
        .pipe_tx_eqdeemph_o (pipe_tx4_eqdeemph_o),
        .pipe_tx_eqpreset_o (pipe_tx4_eqpreset_o),
        .pipe_clk (pipe_clk),
        .rst_n (rst_n)
      );
      rp_pipe_lane 
     #(
        .TCQ (TCQ),
        .PIPE_PIPELINE_STAGES (PIPE_PIPELINE_STAGES))
      pipe_lane_5_inst (
        .pipe_rx_char_is_k_o (pipe_rx5_char_is_k_o),
        .pipe_rx_data_o (pipe_rx5_data_o),
        .pipe_rx_valid_o (pipe_rx5_valid_o),
        .pipe_rx_data_valid_o (pipe_rx5_data_valid_o),
        .pipe_rx_status_o (pipe_rx5_status_o),
        .pipe_rx_phy_status_o (pipe_rx5_phy_status_o),
        .pipe_rx_elec_idle_o (pipe_rx5_elec_idle_o),
        .pipe_rx_eqdone_o (pipe_rx5_eqdone_o),
        .pipe_rx_eqlpadaptdone_o (pipe_rx5_eqlpadaptdone_o),
        .pipe_rx_eqlplffssel_o (pipe_rx5_eqlplffssel_o),
        .pipe_rx_eqlpnewtxcoefforpreset_o (pipe_rx5_eqlpnewtxcoefforpreset_o),
        .pipe_rx_startblock_o (pipe_rx5_startblock_o),
        .pipe_rx_syncheader_o (pipe_rx5_syncheader_o),
        .pipe_rx_polarity_i (pipe_rx5_polarity_i),
        .pipe_rx_eqcontrol_i (pipe_rx5_eqcontrol_i),
        .pipe_rx_eqlplffs_i (pipe_rx5_eqlplffs_i),
        .pipe_rx_eqlptxpreset_i (pipe_rx5_eqlptxpreset_i),
        .pipe_rx_eqpreset_i (pipe_rx5_eqpreset_i),
        .pipe_tx_eqcoeff_o (pipe_tx5_eqcoeff_o),
        .pipe_tx_eqdone_o (pipe_tx5_eqdone_o),
        .pipe_tx_compliance_i (pipe_tx5_compliance_i),
        .pipe_tx_char_is_k_i (pipe_tx5_char_is_k_i),
        .pipe_tx_data_i (pipe_tx5_data_i),
        .pipe_tx_elec_idle_i (pipe_tx5_elec_idle_i),
        .pipe_tx_powerdown_i (pipe_tx5_powerdown_i),
        .pipe_tx_datavalid_i (pipe_tx5_datavalid_i),
        .pipe_tx_startblock_i (pipe_tx5_startblock_i),
        .pipe_tx_syncheader_i (pipe_tx5_syncheader_i),
        .pipe_tx_eqcontrol_i (pipe_tx5_eqcontrol_i),
        .pipe_tx_eqdeemph_i (pipe_tx5_eqdeemph_i),
        .pipe_tx_eqpreset_i (pipe_tx5_eqpreset_i),
        .pipe_rx_char_is_k_i (pipe_rx5_char_is_k_i),
        .pipe_rx_data_i (pipe_rx5_data_i),
        .pipe_rx_valid_i (pipe_rx5_valid_i),
        .pipe_rx_data_valid_i (pipe_rx5_data_valid_i),
        .pipe_rx_status_i (pipe_rx5_status_i),
        .pipe_rx_phy_status_i (pipe_rx5_phy_status_i),
        .pipe_rx_elec_idle_i (pipe_rx5_elec_idle_i),
        .pipe_rx_eqdone_i (pipe_rx5_eqdone_i),
        .pipe_rx_eqlpadaptdone_i (pipe_rx5_eqlpadaptdone_i),
        .pipe_rx_eqlplffssel_i (pipe_rx5_eqlplffssel_i),
        .pipe_rx_eqlpnewtxcoefforpreset_i (pipe_rx5_eqlpnewtxcoefforpreset_i),
        .pipe_rx_startblock_i (pipe_rx5_startblock_i),
        .pipe_rx_syncheader_i (pipe_rx5_syncheader_i),
        .pipe_rx_polarity_o (pipe_rx5_polarity_o),
        .pipe_rx_eqcontrol_o (pipe_rx5_eqcontrol_o),
        .pipe_rx_eqlplffs_o (pipe_rx5_eqlplffs_o),
        .pipe_rx_eqlptxpreset_o (pipe_rx5_eqlptxpreset_o),
        .pipe_rx_eqpreset_o (pipe_rx5_eqpreset_o),
        .pipe_tx_eqcoeff_i (pipe_tx5_eqcoeff_i),
        .pipe_tx_eqdone_i (pipe_tx5_eqdone_i),
        .pipe_tx_compliance_o (pipe_tx5_compliance_o),
        .pipe_tx_char_is_k_o (pipe_tx5_char_is_k_o),
        .pipe_tx_data_o (pipe_tx5_data_o),
        .pipe_tx_elec_idle_o (pipe_tx5_elec_idle_o),
        .pipe_tx_powerdown_o (pipe_tx5_powerdown_o),
        .pipe_tx_datavalid_o (pipe_tx5_datavalid_o),
        .pipe_tx_startblock_o (pipe_tx5_startblock_o),
        .pipe_tx_syncheader_o (pipe_tx5_syncheader_o),
        .pipe_tx_eqcontrol_o (pipe_tx5_eqcontrol_o),
        .pipe_tx_eqdeemph_o (pipe_tx5_eqdeemph_o),
        .pipe_tx_eqpreset_o (pipe_tx5_eqpreset_o),
        .pipe_clk (pipe_clk),
        .rst_n (rst_n)
      );
      rp_pipe_lane 
     #(
        .TCQ (TCQ),
        .PIPE_PIPELINE_STAGES (PIPE_PIPELINE_STAGES))
      pipe_lane_6_inst (
        .pipe_rx_char_is_k_o (pipe_rx6_char_is_k_o),
        .pipe_rx_data_o (pipe_rx6_data_o),
        .pipe_rx_valid_o (pipe_rx6_valid_o),
        .pipe_rx_data_valid_o (pipe_rx6_data_valid_o),
        .pipe_rx_status_o (pipe_rx6_status_o),
        .pipe_rx_phy_status_o (pipe_rx6_phy_status_o),
        .pipe_rx_elec_idle_o (pipe_rx6_elec_idle_o),
        .pipe_rx_eqdone_o (pipe_rx6_eqdone_o),
        .pipe_rx_eqlpadaptdone_o (pipe_rx6_eqlpadaptdone_o),
        .pipe_rx_eqlplffssel_o (pipe_rx6_eqlplffssel_o),
        .pipe_rx_eqlpnewtxcoefforpreset_o (pipe_rx6_eqlpnewtxcoefforpreset_o),
        .pipe_rx_startblock_o (pipe_rx6_startblock_o),
        .pipe_rx_syncheader_o (pipe_rx6_syncheader_o),
        .pipe_rx_polarity_i (pipe_rx6_polarity_i),
        .pipe_rx_eqcontrol_i (pipe_rx6_eqcontrol_i),
        .pipe_rx_eqlplffs_i (pipe_rx6_eqlplffs_i),
        .pipe_rx_eqlptxpreset_i (pipe_rx6_eqlptxpreset_i),
        .pipe_rx_eqpreset_i (pipe_rx6_eqpreset_i),
        .pipe_tx_eqcoeff_o (pipe_tx6_eqcoeff_o),
        .pipe_tx_eqdone_o (pipe_tx6_eqdone_o),
        .pipe_tx_compliance_i (pipe_tx6_compliance_i),
        .pipe_tx_char_is_k_i (pipe_tx6_char_is_k_i),
        .pipe_tx_data_i (pipe_tx6_data_i),
        .pipe_tx_elec_idle_i (pipe_tx6_elec_idle_i),
        .pipe_tx_powerdown_i (pipe_tx6_powerdown_i),
        .pipe_tx_datavalid_i (pipe_tx6_datavalid_i),
        .pipe_tx_startblock_i (pipe_tx6_startblock_i),
        .pipe_tx_syncheader_i (pipe_tx6_syncheader_i),
        .pipe_tx_eqcontrol_i (pipe_tx6_eqcontrol_i),
        .pipe_tx_eqdeemph_i (pipe_tx6_eqdeemph_i),
        .pipe_tx_eqpreset_i (pipe_tx6_eqpreset_i),
        .pipe_rx_char_is_k_i (pipe_rx6_char_is_k_i),
        .pipe_rx_data_i (pipe_rx6_data_i),
        .pipe_rx_valid_i (pipe_rx6_valid_i),
        .pipe_rx_data_valid_i (pipe_rx6_data_valid_i),
        .pipe_rx_status_i (pipe_rx6_status_i),
        .pipe_rx_phy_status_i (pipe_rx6_phy_status_i),
        .pipe_rx_elec_idle_i (pipe_rx6_elec_idle_i),
        .pipe_rx_eqdone_i (pipe_rx6_eqdone_i),
        .pipe_rx_eqlpadaptdone_i (pipe_rx6_eqlpadaptdone_i),
        .pipe_rx_eqlplffssel_i (pipe_rx6_eqlplffssel_i),
        .pipe_rx_eqlpnewtxcoefforpreset_i (pipe_rx6_eqlpnewtxcoefforpreset_i),
        .pipe_rx_startblock_i (pipe_rx6_startblock_i),
        .pipe_rx_syncheader_i (pipe_rx6_syncheader_i),
        .pipe_rx_polarity_o (pipe_rx6_polarity_o),
        .pipe_rx_eqcontrol_o (pipe_rx6_eqcontrol_o),
        .pipe_rx_eqlplffs_o (pipe_rx6_eqlplffs_o),
        .pipe_rx_eqlptxpreset_o (pipe_rx6_eqlptxpreset_o),
        .pipe_rx_eqpreset_o (pipe_rx6_eqpreset_o),
        .pipe_tx_eqcoeff_i (pipe_tx6_eqcoeff_i),
        .pipe_tx_eqdone_i (pipe_tx6_eqdone_i),
        .pipe_tx_compliance_o (pipe_tx6_compliance_o),
        .pipe_tx_char_is_k_o (pipe_tx6_char_is_k_o),
        .pipe_tx_data_o (pipe_tx6_data_o),
        .pipe_tx_elec_idle_o (pipe_tx6_elec_idle_o),
        .pipe_tx_powerdown_o (pipe_tx6_powerdown_o),
        .pipe_tx_datavalid_o (pipe_tx6_datavalid_o),
        .pipe_tx_startblock_o (pipe_tx6_startblock_o),
        .pipe_tx_syncheader_o (pipe_tx6_syncheader_o),
        .pipe_tx_eqcontrol_o (pipe_tx6_eqcontrol_o),
        .pipe_tx_eqdeemph_o (pipe_tx6_eqdeemph_o),
        .pipe_tx_eqpreset_o (pipe_tx6_eqpreset_o),
        .pipe_clk (pipe_clk),
        .rst_n (rst_n)
      );
      rp_pipe_lane 
     #(
        .TCQ (TCQ),
        .PIPE_PIPELINE_STAGES (PIPE_PIPELINE_STAGES))
      pipe_lane_7_inst (
        .pipe_rx_char_is_k_o (pipe_rx7_char_is_k_o),
        .pipe_rx_data_o (pipe_rx7_data_o),
        .pipe_rx_valid_o (pipe_rx7_valid_o),
        .pipe_rx_data_valid_o (pipe_rx7_data_valid_o),
        .pipe_rx_status_o (pipe_rx7_status_o),
        .pipe_rx_phy_status_o (pipe_rx7_phy_status_o),
        .pipe_rx_elec_idle_o (pipe_rx7_elec_idle_o),
        .pipe_rx_eqdone_o (pipe_rx7_eqdone_o),
        .pipe_rx_eqlpadaptdone_o (pipe_rx7_eqlpadaptdone_o),
        .pipe_rx_eqlplffssel_o (pipe_rx7_eqlplffssel_o),
        .pipe_rx_eqlpnewtxcoefforpreset_o (pipe_rx7_eqlpnewtxcoefforpreset_o),
        .pipe_rx_startblock_o (pipe_rx7_startblock_o),
        .pipe_rx_syncheader_o (pipe_rx7_syncheader_o),
        .pipe_rx_polarity_i (pipe_rx7_polarity_i),
        .pipe_rx_eqcontrol_i (pipe_rx7_eqcontrol_i),
        .pipe_rx_eqlplffs_i (pipe_rx7_eqlplffs_i),
        .pipe_rx_eqlptxpreset_i (pipe_rx7_eqlptxpreset_i),
        .pipe_rx_eqpreset_i (pipe_rx7_eqpreset_i),
        .pipe_tx_eqcoeff_o (pipe_tx7_eqcoeff_o),
        .pipe_tx_eqdone_o (pipe_tx7_eqdone_o),
        .pipe_tx_compliance_i (pipe_tx7_compliance_i),
        .pipe_tx_char_is_k_i (pipe_tx7_char_is_k_i),
        .pipe_tx_data_i (pipe_tx7_data_i),
        .pipe_tx_elec_idle_i (pipe_tx7_elec_idle_i),
        .pipe_tx_powerdown_i (pipe_tx7_powerdown_i),
        .pipe_tx_datavalid_i (pipe_tx7_datavalid_i),
        .pipe_tx_startblock_i (pipe_tx7_startblock_i),
        .pipe_tx_syncheader_i (pipe_tx7_syncheader_i),
        .pipe_tx_eqcontrol_i (pipe_tx7_eqcontrol_i),
        .pipe_tx_eqdeemph_i (pipe_tx7_eqdeemph_i),
        .pipe_tx_eqpreset_i (pipe_tx7_eqpreset_i),
        .pipe_rx_char_is_k_i (pipe_rx7_char_is_k_i),
        .pipe_rx_data_i (pipe_rx7_data_i),
        .pipe_rx_valid_i (pipe_rx7_valid_i),
        .pipe_rx_data_valid_i (pipe_rx7_data_valid_i),
        .pipe_rx_status_i (pipe_rx7_status_i),
        .pipe_rx_phy_status_i (pipe_rx7_phy_status_i),
        .pipe_rx_elec_idle_i (pipe_rx7_elec_idle_i),
        .pipe_rx_eqdone_i (pipe_rx7_eqdone_i),
        .pipe_rx_eqlpadaptdone_i (pipe_rx7_eqlpadaptdone_i),
        .pipe_rx_eqlplffssel_i (pipe_rx7_eqlplffssel_i),
        .pipe_rx_eqlpnewtxcoefforpreset_i (pipe_rx7_eqlpnewtxcoefforpreset_i),
        .pipe_rx_startblock_i (pipe_rx7_startblock_i),
        .pipe_rx_syncheader_i (pipe_rx7_syncheader_i),
        .pipe_rx_polarity_o (pipe_rx7_polarity_o),
        .pipe_rx_eqcontrol_o (pipe_rx7_eqcontrol_o),
        .pipe_rx_eqlplffs_o (pipe_rx7_eqlplffs_o),
        .pipe_rx_eqlptxpreset_o (pipe_rx7_eqlptxpreset_o),
        .pipe_rx_eqpreset_o (pipe_rx7_eqpreset_o),
        .pipe_tx_eqcoeff_i (pipe_tx7_eqcoeff_i),
        .pipe_tx_eqdone_i (pipe_tx7_eqdone_i),
        .pipe_tx_compliance_o (pipe_tx7_compliance_o),
        .pipe_tx_char_is_k_o (pipe_tx7_char_is_k_o),
        .pipe_tx_data_o (pipe_tx7_data_o),
        .pipe_tx_elec_idle_o (pipe_tx7_elec_idle_o),
        .pipe_tx_powerdown_o (pipe_tx7_powerdown_o),
        .pipe_tx_datavalid_o (pipe_tx7_datavalid_o),
        .pipe_tx_startblock_o (pipe_tx7_startblock_o),
        .pipe_tx_syncheader_o (pipe_tx7_syncheader_o),
        .pipe_tx_eqcontrol_o (pipe_tx7_eqcontrol_o),
        .pipe_tx_eqdeemph_o (pipe_tx7_eqdeemph_o),
        .pipe_tx_eqpreset_o (pipe_tx7_eqpreset_o),
        .pipe_clk (pipe_clk),
        .rst_n (rst_n)
      );
    end
    else
    begin
      assign pipe_rx4_char_is_k_o = 2'b00;
      assign pipe_rx4_data_o = 32'h00000000;
      assign pipe_rx4_valid_o = 1'b0;
      assign pipe_rx4_data_valid_o = 1'b0;
      assign pipe_rx4_status_o = 2'b00;
      assign pipe_rx4_phy_status_o = 1'b0;
      assign pipe_rx4_elec_idle_o = 1'b1;
      assign pipe_rx4_eqdone_o = 1'b0;
      assign pipe_rx4_eqlpadaptdone_o = 1'b0;
      assign pipe_rx4_eqlplffssel_o = 1'b0;
      assign pipe_rx4_eqlpnewtxcoefforpreset_o = 17'b00000000000000000;
      assign pipe_rx4_startblock_o = 1'b0;
      assign pipe_rx4_syncheader_o = 2'b00;
      assign pipe_tx4_eqcoeff_o = 17'b00000000000000000;
      assign pipe_tx4_eqdone_o = 1'b0;
      assign pipe_rx4_polarity_o = 1'b0;
      assign pipe_rx4_eqcontrol_o = 2'b00;
      assign pipe_rx4_eqlplffs_o = 6'b000000;
      assign pipe_rx4_eqlptxpreset_o = 4'h0;
      assign pipe_rx4_eqpreset_o = 3'b000;
      assign pipe_tx4_compliance_o = 1'b0;
      assign pipe_tx4_char_is_k_o = 2'b00;
      assign pipe_tx4_data_o = 32'h00000000;
      assign pipe_tx4_elec_idle_o = 1'b1;
      assign pipe_tx4_powerdown_o = 2'b00;
      assign pipe_tx4_datavalid_o = 1'b0;
      assign pipe_tx4_startblock_o = 1'b0;
      assign pipe_tx4_syncheader_o = 2'b00;
      assign pipe_tx4_eqcontrol_o = 2'b00;
      assign pipe_tx4_eqdeemph_o = 6'b000000;
      assign pipe_tx4_eqpreset_o = 4'h0;
      assign pipe_rx5_char_is_k_o = 2'b00;
      assign pipe_rx5_data_o = 32'h00000000;
      assign pipe_rx5_valid_o = 1'b0;
      assign pipe_rx5_data_valid_o = 1'b0;
      assign pipe_rx5_status_o = 2'b00;
      assign pipe_rx5_phy_status_o = 1'b0;
      assign pipe_rx5_elec_idle_o = 1'b1;
      assign pipe_rx5_eqdone_o = 1'b0;
      assign pipe_rx5_eqlpadaptdone_o = 1'b0;
      assign pipe_rx5_eqlplffssel_o = 1'b0;
      assign pipe_rx5_eqlpnewtxcoefforpreset_o = 17'b00000000000000000;
      assign pipe_rx5_startblock_o = 1'b0;
      assign pipe_rx5_syncheader_o = 2'b00;
      assign pipe_tx5_eqcoeff_o = 17'b00000000000000000;
      assign pipe_tx5_eqdone_o = 1'b0;
      assign pipe_rx5_polarity_o = 1'b0;
      assign pipe_rx5_eqcontrol_o = 2'b00;
      assign pipe_rx5_eqlplffs_o = 6'b000000;
      assign pipe_rx5_eqlptxpreset_o = 4'h0;
      assign pipe_rx5_eqpreset_o = 3'b000;
      assign pipe_tx5_compliance_o = 1'b0;
      assign pipe_tx5_char_is_k_o = 2'b00;
      assign pipe_tx5_data_o = 32'h00000000;
      assign pipe_tx5_elec_idle_o = 1'b1;
      assign pipe_tx5_powerdown_o = 2'b00;
      assign pipe_tx5_datavalid_o = 1'b0;
      assign pipe_tx5_startblock_o = 1'b0;
      assign pipe_tx5_syncheader_o = 2'b00;
      assign pipe_tx5_eqcontrol_o = 2'b00;
      assign pipe_tx5_eqdeemph_o = 6'b000000;
      assign pipe_tx5_eqpreset_o = 4'h0;
      assign pipe_rx6_char_is_k_o = 2'b00;
      assign pipe_rx6_data_o = 32'h00000000;
      assign pipe_rx6_valid_o = 1'b0;
      assign pipe_rx6_data_valid_o = 1'b0;
      assign pipe_rx6_status_o = 2'b00;
      assign pipe_rx6_phy_status_o = 1'b0;
      assign pipe_rx6_elec_idle_o = 1'b1;
      assign pipe_rx6_eqdone_o = 1'b0;
      assign pipe_rx6_eqlpadaptdone_o = 1'b0;
      assign pipe_rx6_eqlplffssel_o = 1'b0;
      assign pipe_rx6_eqlpnewtxcoefforpreset_o = 17'b00000000000000000;
      assign pipe_rx6_startblock_o = 1'b0;
      assign pipe_rx6_syncheader_o = 2'b00;
      assign pipe_tx6_eqcoeff_o = 17'b00000000000000000;
      assign pipe_tx6_eqdone_o = 1'b0;
      assign pipe_rx6_polarity_o = 1'b0;
      assign pipe_rx6_eqcontrol_o = 2'b00;
      assign pipe_rx6_eqlplffs_o = 6'b000000;
      assign pipe_rx6_eqlptxpreset_o = 4'h0;
      assign pipe_rx6_eqpreset_o = 3'b000;
      assign pipe_tx6_compliance_o = 1'b0;
      assign pipe_tx6_char_is_k_o = 2'b00;
      assign pipe_tx6_data_o = 32'h00000000;
      assign pipe_tx6_elec_idle_o = 1'b1;
      assign pipe_tx6_powerdown_o = 2'b00;
      assign pipe_tx6_datavalid_o = 1'b0;
      assign pipe_tx6_startblock_o = 1'b0;
      assign pipe_tx6_syncheader_o = 2'b00;
      assign pipe_tx6_eqcontrol_o = 2'b00;
      assign pipe_tx6_eqdeemph_o = 6'b000000;
      assign pipe_tx6_eqpreset_o = 4'h0;
      assign pipe_rx7_char_is_k_o = 2'b00;
      assign pipe_rx7_data_o = 32'h00000000;
      assign pipe_rx7_valid_o = 1'b0;
      assign pipe_rx7_data_valid_o = 1'b0;
      assign pipe_rx7_status_o = 2'b00;
      assign pipe_rx7_phy_status_o = 1'b0;
      assign pipe_rx7_elec_idle_o = 1'b1;
      assign pipe_rx7_eqdone_o = 1'b0;
      assign pipe_rx7_eqlpadaptdone_o = 1'b0;
      assign pipe_rx7_eqlplffssel_o = 1'b0;
      assign pipe_rx7_eqlpnewtxcoefforpreset_o = 17'b00000000000000000;
      assign pipe_rx7_startblock_o = 1'b0;
      assign pipe_rx7_syncheader_o = 2'b00;
      assign pipe_tx7_eqcoeff_o = 17'b00000000000000000;
      assign pipe_tx7_eqdone_o = 1'b0;
      assign pipe_rx7_polarity_o = 1'b0;
      assign pipe_rx7_eqcontrol_o = 2'b00;
      assign pipe_rx7_eqlplffs_o = 6'b000000;
      assign pipe_rx7_eqlptxpreset_o = 4'h0;
      assign pipe_rx7_eqpreset_o = 3'b000;
      assign pipe_tx7_compliance_o = 1'b0;
      assign pipe_tx7_char_is_k_o = 2'b00;
      assign pipe_tx7_data_o = 32'h00000000;
      assign pipe_tx7_elec_idle_o = 1'b1;
      assign pipe_tx7_powerdown_o = 2'b00;
      assign pipe_tx7_datavalid_o = 1'b0;
      assign pipe_tx7_startblock_o = 1'b0;
      assign pipe_tx7_syncheader_o = 2'b00;
      assign pipe_tx7_eqcontrol_o = 2'b00;
      assign pipe_tx7_eqdeemph_o = 6'b000000;
      assign pipe_tx7_eqpreset_o = 4'h0;
    end
  endgenerate

endmodule

(* DowngradeIPIdentifiedWarnings = "yes" *)
module rp_pipe_misc 
 #(
  parameter TCQ = 100,
  parameter PIPE_PIPELINE_STAGES = 0
  ) (
  input  wire         pipe_tx_rcvr_det_i,
  input  wire         pipe_tx_reset_i,
  input  wire   [1:0] pipe_tx_rate_i,
  input  wire         pipe_tx_deemph_i,
  input  wire   [2:0] pipe_tx_margin_i,
  input  wire         pipe_tx_swing_i,
  input  wire   [5:0] pipe_tx_eqfs_i,
  input  wire   [5:0] pipe_tx_eqlf_i,
  output wire         pipe_tx_rcvr_det_o,
  output wire         pipe_tx_reset_o,
  output wire   [1:0] pipe_tx_rate_o,
  output wire         pipe_tx_deemph_o,
  output wire   [2:0] pipe_tx_margin_o,
  output wire         pipe_tx_swing_o,
  output wire   [5:0] pipe_tx_eqfs_o,
  output wire   [5:0] pipe_tx_eqlf_o,
  input  wire         pipe_clk,
  input  wire         rst_n
  );

  reg                 pipe_tx_rcvr_det_q;
  reg                 pipe_tx_reset_q;
  reg           [1:0] pipe_tx_rate_q;
  reg                 pipe_tx_deemph_q;
  reg           [2:0] pipe_tx_margin_q;
  reg                 pipe_tx_swing_q;
  reg           [5:0] pipe_tx_eqfs_q;
  reg           [5:0] pipe_tx_eqlf_q;
  reg                 pipe_tx_rcvr_det_qq;
  reg                 pipe_tx_reset_qq;
  reg           [1:0] pipe_tx_rate_qq;
  reg                 pipe_tx_deemph_qq;
  reg           [2:0] pipe_tx_margin_qq;
  reg                 pipe_tx_swing_qq;
  reg           [5:0] pipe_tx_eqfs_qq;
  reg           [5:0] pipe_tx_eqlf_qq;

  generate
    if (PIPE_PIPELINE_STAGES == 0)
    begin : pipe_stages_0
      assign pipe_tx_rcvr_det_o = pipe_tx_rcvr_det_i;
      assign pipe_tx_reset_o = pipe_tx_reset_i;
      assign pipe_tx_rate_o = pipe_tx_rate_i;
      assign pipe_tx_deemph_o = pipe_tx_deemph_i;
      assign pipe_tx_margin_o = pipe_tx_margin_i;
      assign pipe_tx_swing_o = pipe_tx_swing_i;
      assign pipe_tx_eqfs_o = pipe_tx_eqfs_i;
      assign pipe_tx_eqlf_o = pipe_tx_eqlf_i;
    end
    else if (PIPE_PIPELINE_STAGES == 1)
    begin : pipe_stages_1
      always @(posedge pipe_clk)
      begin
        if (!rst_n)
        begin
          pipe_tx_rcvr_det_q <= #TCQ 1'b0;
          pipe_tx_reset_q <= #TCQ 1'b1;
          pipe_tx_rate_q <= #TCQ 2'b0;
          pipe_tx_deemph_q <= #TCQ 1'b1;
          pipe_tx_margin_q <= #TCQ 3'b0;
          pipe_tx_swing_q <= #TCQ 1'b0;
          pipe_tx_eqfs_q <= #TCQ 5'b0;
          pipe_tx_eqlf_q <= #TCQ 5'b0;
        end
        else
        begin
          pipe_tx_rcvr_det_q <= #TCQ pipe_tx_rcvr_det_i;
          pipe_tx_reset_q <= #TCQ pipe_tx_reset_i;
          pipe_tx_rate_q <= #TCQ pipe_tx_rate_i;
          pipe_tx_deemph_q <= #TCQ pipe_tx_deemph_i;
          pipe_tx_margin_q <= #TCQ pipe_tx_margin_i;
          pipe_tx_swing_q <= #TCQ pipe_tx_swing_i;
          pipe_tx_eqfs_q <= #TCQ pipe_tx_eqfs_i;
          pipe_tx_eqlf_q <= #TCQ pipe_tx_eqlf_i;
        end
      end
      assign pipe_tx_rcvr_det_o = pipe_tx_rcvr_det_q;
      assign pipe_tx_reset_o = pipe_tx_reset_q;
      assign pipe_tx_rate_o = pipe_tx_rate_q;
      assign pipe_tx_deemph_o = pipe_tx_deemph_q;
      assign pipe_tx_margin_o = pipe_tx_margin_q;
      assign pipe_tx_swing_o = pipe_tx_swing_q;
      assign pipe_tx_eqfs_o = pipe_tx_eqfs_q;
      assign pipe_tx_eqlf_o = pipe_tx_eqlf_q;
    end
    else if (PIPE_PIPELINE_STAGES == 2)
    begin : pipe_stages_2
      always @(posedge pipe_clk)
      begin
        if (!rst_n)
        begin
          pipe_tx_rcvr_det_q <= #TCQ 1'b0;
          pipe_tx_reset_q <= #TCQ 1'b1;
          pipe_tx_rate_q <= #TCQ 2'b0;
          pipe_tx_deemph_q <= #TCQ 1'b1;
          pipe_tx_margin_q <= #TCQ 1'b0;
          pipe_tx_swing_q <= #TCQ 1'b0;
          pipe_tx_eqfs_q <= #TCQ 5'b0;
          pipe_tx_eqlf_q <= #TCQ 5'b0;
          pipe_tx_rcvr_det_qq <= #TCQ 1'b0;
          pipe_tx_reset_qq <= #TCQ 1'b1;
          pipe_tx_rate_qq <= #TCQ 2'b0;
          pipe_tx_deemph_qq <= #TCQ 1'b1;
          pipe_tx_margin_qq <= #TCQ 1'b0;
          pipe_tx_swing_qq <= #TCQ 1'b0;
          pipe_tx_eqfs_qq <= #TCQ 5'b0;
          pipe_tx_eqlf_qq <= #TCQ 5'b0;
        end
        else
        begin
          pipe_tx_rcvr_det_q <= #TCQ pipe_tx_rcvr_det_i;
          pipe_tx_reset_q <= #TCQ pipe_tx_reset_i;
          pipe_tx_rate_q <= #TCQ pipe_tx_rate_i;
          pipe_tx_deemph_q <= #TCQ pipe_tx_deemph_i;
          pipe_tx_margin_q <= #TCQ pipe_tx_margin_i;
          pipe_tx_swing_q <= #TCQ pipe_tx_swing_i;
          pipe_tx_eqfs_q <= #TCQ pipe_tx_eqfs_i;
          pipe_tx_eqlf_q <= #TCQ pipe_tx_eqlf_i;
          pipe_tx_rcvr_det_qq <= #TCQ pipe_tx_rcvr_det_q;
          pipe_tx_reset_qq <= #TCQ pipe_tx_reset_q;
          pipe_tx_rate_qq <= #TCQ pipe_tx_rate_q;
          pipe_tx_deemph_qq <= #TCQ pipe_tx_deemph_q;
          pipe_tx_margin_qq <= #TCQ pipe_tx_margin_q;
          pipe_tx_swing_qq <= #TCQ pipe_tx_swing_q;
          pipe_tx_eqfs_qq <= #TCQ pipe_tx_eqfs_q;
          pipe_tx_eqlf_qq <= #TCQ pipe_tx_eqlf_q;
        end
      end
      assign pipe_tx_rcvr_det_o = pipe_tx_rcvr_det_qq;
      assign pipe_tx_reset_o = pipe_tx_reset_qq;
      assign pipe_tx_rate_o = pipe_tx_rate_qq;
      assign pipe_tx_deemph_o = pipe_tx_deemph_qq;
      assign pipe_tx_margin_o = pipe_tx_margin_qq;
      assign pipe_tx_swing_o = pipe_tx_swing_qq;
      assign pipe_tx_eqfs_o = pipe_tx_eqfs_qq;
      assign pipe_tx_eqlf_o = pipe_tx_eqlf_qq;
    end
    else
    begin
      assign pipe_tx_rcvr_det_o = pipe_tx_rcvr_det_i;
      assign pipe_tx_reset_o = pipe_tx_reset_i;
      assign pipe_tx_rate_o = pipe_tx_rate_i;
      assign pipe_tx_deemph_o = pipe_tx_deemph_i;
      assign pipe_tx_margin_o = pipe_tx_margin_i;
      assign pipe_tx_swing_o = pipe_tx_swing_i;
      assign pipe_tx_eqfs_o = pipe_tx_eqfs_i;
      assign pipe_tx_eqlf_o = pipe_tx_eqlf_i;
    end
  endgenerate

endmodule

(* DowngradeIPIdentifiedWarnings = "yes" *)
module rp_pipe_lane 
 #(
  parameter TCQ = 100,
  parameter PIPE_PIPELINE_STAGES = 0
  ) (
  output wire   [1:0] pipe_rx_char_is_k_o,
  output wire  [31:0] pipe_rx_data_o,
  output wire         pipe_rx_valid_o,
  output wire         pipe_rx_data_valid_o,
  output wire   [2:0] pipe_rx_status_o,
  output wire         pipe_rx_phy_status_o,
  output wire         pipe_rx_elec_idle_o,
  output wire         pipe_rx_eqdone_o,
  output wire         pipe_rx_eqlpadaptdone_o,
  output wire         pipe_rx_eqlplffssel_o,
  output wire  [17:0] pipe_rx_eqlpnewtxcoefforpreset_o,
  output wire         pipe_rx_startblock_o,
  output wire   [1:0] pipe_rx_syncheader_o,
  input  wire         pipe_rx_polarity_i,
  input  wire   [1:0] pipe_rx_eqcontrol_i,
  input  wire   [5:0] pipe_rx_eqlplffs_i,
  input  wire   [3:0] pipe_rx_eqlptxpreset_i,
  input  wire   [2:0] pipe_rx_eqpreset_i,
  output wire  [17:0] pipe_tx_eqcoeff_o,
  output wire         pipe_tx_eqdone_o,
  input  wire         pipe_tx_compliance_i,
  input  wire   [1:0] pipe_tx_char_is_k_i,
  input  wire  [31:0] pipe_tx_data_i,
  input  wire         pipe_tx_elec_idle_i,
  input  wire   [1:0] pipe_tx_powerdown_i,
  input  wire         pipe_tx_datavalid_i,
  input  wire         pipe_tx_startblock_i,
  input  wire   [1:0] pipe_tx_syncheader_i,
  input  wire   [1:0] pipe_tx_eqcontrol_i,
  input  wire   [5:0] pipe_tx_eqdeemph_i,
  input  wire   [3:0] pipe_tx_eqpreset_i,
  input  wire   [1:0] pipe_rx_char_is_k_i,
  input  wire  [31:0] pipe_rx_data_i,
  input  wire         pipe_rx_valid_i,
  input  wire         pipe_rx_data_valid_i,
  input  wire   [2:0] pipe_rx_status_i,
  input  wire         pipe_rx_phy_status_i,
  input  wire         pipe_rx_elec_idle_i,
  input  wire         pipe_rx_eqdone_i,
  input  wire         pipe_rx_eqlpadaptdone_i,
  input  wire         pipe_rx_eqlplffssel_i,
  input  wire  [17:0] pipe_rx_eqlpnewtxcoefforpreset_i,
  input  wire         pipe_rx_startblock_i,
  input  wire   [1:0] pipe_rx_syncheader_i,
  output wire         pipe_rx_polarity_o,
  output wire   [1:0] pipe_rx_eqcontrol_o,
  output wire   [5:0] pipe_rx_eqlplffs_o,
  output wire   [3:0] pipe_rx_eqlptxpreset_o,
  output wire   [2:0] pipe_rx_eqpreset_o,
  input  wire  [17:0] pipe_tx_eqcoeff_i,
  input  wire         pipe_tx_eqdone_i,
  output wire         pipe_tx_compliance_o,
  output wire   [1:0] pipe_tx_char_is_k_o,
  output wire  [31:0] pipe_tx_data_o,
  output wire         pipe_tx_elec_idle_o,
  output wire   [1:0] pipe_tx_powerdown_o,
  output wire         pipe_tx_datavalid_o,
  output wire         pipe_tx_startblock_o,
  output wire   [1:0] pipe_tx_syncheader_o,
  output wire   [1:0] pipe_tx_eqcontrol_o,
  output wire   [5:0] pipe_tx_eqdeemph_o,
  output wire   [3:0] pipe_tx_eqpreset_o,
  input  wire         pipe_clk,
  input  wire         rst_n
  );

  reg           [1:0] pipe_rx_char_is_k_q;
  reg          [31:0] pipe_rx_data_q;
  reg                 pipe_rx_valid_q;
  reg                 pipe_rx_data_valid_q;
  reg           [2:0] pipe_rx_status_q;
  reg                 pipe_rx_phy_status_q;
  reg                 pipe_rx_elec_idle_q;
  reg                 pipe_rx_eqdone_q;
  reg                 pipe_rx_eqlpadaptdone_q;
  reg                 pipe_rx_eqlplffssel_q;
  reg          [17:0] pipe_rx_eqlpnewtxcoefforpreset_q;
  reg                 pipe_rx_startblock_q;
  reg           [1:0] pipe_rx_syncheader_q;
  reg                 pipe_rx_polarity_q;
  reg           [1:0] pipe_rx_eqcontrol_q;
  reg           [5:0] pipe_rx_eqlplffs_q;
  reg           [3:0] pipe_rx_eqlptxpreset_q;
  reg           [2:0] pipe_rx_eqpreset_q;
  reg          [17:0] pipe_tx_eqcoeff_q;
  reg                 pipe_tx_eqdone_q;
  reg                 pipe_tx_compliance_q;
  reg           [1:0] pipe_tx_char_is_k_q;
  reg          [31:0] pipe_tx_data_q;
  reg                 pipe_tx_elec_idle_q;
  reg           [1:0] pipe_tx_powerdown_q;
  reg                 pipe_tx_datavalid_q;
  reg                 pipe_tx_startblock_q;
  reg           [1:0] pipe_tx_syncheader_q;
  reg           [1:0] pipe_tx_eqcontrol_q;
  reg           [5:0] pipe_tx_eqdeemph_q;
  reg           [3:0] pipe_tx_eqpreset_q;
  reg           [1:0] pipe_rx_char_is_k_qq;
  reg          [31:0] pipe_rx_data_qq;
  reg                 pipe_rx_valid_qq;
  reg                 pipe_rx_data_valid_qq;
  reg           [2:0] pipe_rx_status_qq;
  reg                 pipe_rx_phy_status_qq;
  reg                 pipe_rx_elec_idle_qq;
  reg                 pipe_rx_eqdone_qq;
  reg                 pipe_rx_eqlpadaptdone_qq;
  reg                 pipe_rx_eqlplffssel_qq;
  reg          [17:0] pipe_rx_eqlpnewtxcoefforpreset_qq;
  reg                 pipe_rx_startblock_qq;
  reg           [1:0] pipe_rx_syncheader_qq;
  reg                 pipe_rx_polarity_qq;
  reg           [1:0] pipe_rx_eqcontrol_qq;
  reg           [5:0] pipe_rx_eqlplffs_qq;
  reg           [3:0] pipe_rx_eqlptxpreset_qq;
  reg           [2:0] pipe_rx_eqpreset_qq;
  reg          [17:0] pipe_tx_eqcoeff_qq;
  reg                 pipe_tx_eqdone_qq;
  reg                 pipe_tx_compliance_qq;
  reg           [1:0] pipe_tx_char_is_k_qq;
  reg          [31:0] pipe_tx_data_qq;
  reg                 pipe_tx_elec_idle_qq;
  reg           [1:0] pipe_tx_powerdown_qq;
  reg                 pipe_tx_datavalid_qq;
  reg                 pipe_tx_startblock_qq;
  reg           [1:0] pipe_tx_syncheader_qq;
  reg           [1:0] pipe_tx_eqcontrol_qq;
  reg           [5:0] pipe_tx_eqdeemph_qq;
  reg           [3:0] pipe_tx_eqpreset_qq;

  generate
    if (PIPE_PIPELINE_STAGES == 0)
    begin : pipe_stages_0
      assign pipe_rx_char_is_k_o = pipe_rx_char_is_k_i;
      assign pipe_rx_data_o = pipe_rx_data_i;
      assign pipe_rx_valid_o = pipe_rx_valid_i;
      assign pipe_rx_data_valid_o = pipe_rx_data_valid_i;
      assign pipe_rx_status_o = pipe_rx_status_i;
      assign pipe_rx_phy_status_o = pipe_rx_phy_status_i;
      assign pipe_rx_elec_idle_o = pipe_rx_elec_idle_i;
      assign pipe_rx_eqdone_o = pipe_rx_eqdone_i;
      assign pipe_rx_eqlpadaptdone_o = pipe_rx_eqlpadaptdone_i;
      assign pipe_rx_eqlplffssel_o = pipe_rx_eqlplffssel_i;
      assign pipe_rx_eqlpnewtxcoefforpreset_o = pipe_rx_eqlpnewtxcoefforpreset_i;
      assign pipe_rx_startblock_o = pipe_rx_startblock_i;
      assign pipe_rx_syncheader_o = pipe_rx_syncheader_i;
      assign pipe_rx_polarity_o = pipe_rx_polarity_i;
      assign pipe_rx_eqcontrol_o = pipe_rx_eqcontrol_i;
      assign pipe_rx_eqlplffs_o = pipe_rx_eqlplffs_i;
      assign pipe_rx_eqlptxpreset_o = pipe_rx_eqlptxpreset_i;
      assign pipe_rx_eqpreset_o = pipe_rx_eqpreset_i;
      assign pipe_tx_eqcoeff_o = pipe_tx_eqcoeff_i;
      assign pipe_tx_eqdone_o = pipe_tx_eqdone_i;
      assign pipe_tx_compliance_o = pipe_tx_compliance_i;
      assign pipe_tx_char_is_k_o = pipe_tx_char_is_k_i;
      assign pipe_tx_data_o = pipe_tx_data_i;
      assign pipe_tx_elec_idle_o = pipe_tx_elec_idle_i;
      assign pipe_tx_powerdown_o = pipe_tx_powerdown_i;
      assign pipe_tx_datavalid_o = pipe_tx_datavalid_i;
      assign pipe_tx_startblock_o = pipe_tx_startblock_i;
      assign pipe_tx_syncheader_o = pipe_tx_syncheader_i;
      assign pipe_tx_eqcontrol_o = pipe_tx_eqcontrol_i;
      assign pipe_tx_eqdeemph_o = pipe_tx_eqdeemph_i;
      assign pipe_tx_eqpreset_o = pipe_tx_eqpreset_i;
    end
    else if (PIPE_PIPELINE_STAGES == 1)
    begin : pipe_stages_1
      always @(posedge pipe_clk)
      begin
        if (!rst_n)
        begin
          pipe_rx_char_is_k_q <= #TCQ 2'b00;
          pipe_rx_data_q <= #TCQ 32'h00000000;
          pipe_rx_valid_q <= #TCQ 1'b0;
          pipe_rx_data_valid_q <= #TCQ 1'b0;
          pipe_rx_status_q <= #TCQ 2'b00;
          pipe_rx_phy_status_q <= #TCQ 1'b0;
          pipe_rx_elec_idle_q <= #TCQ 1'b1;
          pipe_rx_eqdone_q <= #TCQ 1'b0;
          pipe_rx_eqlpadaptdone_q <= #TCQ 1'b0;
          pipe_rx_eqlplffssel_q <= #TCQ 1'b0;
          pipe_rx_eqlpnewtxcoefforpreset_q <= #TCQ 17'b00000000000000000;
          pipe_rx_startblock_q <= #TCQ 1'b0;
          pipe_rx_syncheader_q <= #TCQ 2'b00;
          pipe_rx_polarity_q <= #TCQ 17'b00000000000000000;
          pipe_rx_eqcontrol_q <= #TCQ 1'b0;
          pipe_rx_eqlplffs_q <= #TCQ 1'b0;
          pipe_rx_eqlptxpreset_q <= #TCQ 2'b00;
          pipe_rx_eqpreset_q <= #TCQ 6'b000000;
          pipe_tx_eqcoeff_q <= #TCQ 4'h0;
          pipe_tx_eqdone_q <= #TCQ 3'b000;
          pipe_tx_compliance_q <= #TCQ 1'b0;
          pipe_tx_char_is_k_q <= #TCQ 2'b00;
          pipe_tx_data_q <= #TCQ 32'h00000000;
          pipe_tx_elec_idle_q <= #TCQ 1'b1;
          pipe_tx_powerdown_q <= #TCQ 2'b00;
          pipe_tx_datavalid_q <= #TCQ 1'b0;
          pipe_tx_startblock_q <= #TCQ 1'b0;
          pipe_tx_syncheader_q <= #TCQ 2'b00;
          pipe_tx_eqcontrol_q <= #TCQ 2'b00;
          pipe_tx_eqdeemph_q <= #TCQ 6'b000000;
          pipe_tx_eqpreset_q <= #TCQ 4'h0;
        end
        else
        begin
          pipe_rx_char_is_k_q <= #TCQ pipe_rx_char_is_k_i;
          pipe_rx_data_q <= #TCQ pipe_rx_data_i;
          pipe_rx_valid_q <= #TCQ pipe_rx_valid_i;
          pipe_rx_data_valid_q <= #TCQ pipe_rx_data_valid_i;
          pipe_rx_status_q <= #TCQ pipe_rx_status_i;
          pipe_rx_phy_status_q <= #TCQ pipe_rx_phy_status_i;
          pipe_rx_elec_idle_q <= #TCQ pipe_rx_elec_idle_i;
          pipe_rx_eqdone_q <= #TCQ pipe_rx_eqdone_i;
          pipe_rx_eqlpadaptdone_q <= #TCQ pipe_rx_eqlpadaptdone_i;
          pipe_rx_eqlplffssel_q <= #TCQ pipe_rx_eqlplffssel_i;
          pipe_rx_eqlpnewtxcoefforpreset_q <= #TCQ pipe_rx_eqlpnewtxcoefforpreset_i;
          pipe_rx_startblock_q <= #TCQ pipe_rx_startblock_i;
          pipe_rx_syncheader_q <= #TCQ pipe_rx_syncheader_i;
          pipe_rx_polarity_q <= #TCQ pipe_rx_polarity_i;
          pipe_rx_eqcontrol_q <= #TCQ pipe_rx_eqcontrol_i;
          pipe_rx_eqlplffs_q <= #TCQ pipe_rx_eqlplffs_i;
          pipe_rx_eqlptxpreset_q <= #TCQ pipe_rx_eqlptxpreset_i;
          pipe_rx_eqpreset_q <= #TCQ pipe_rx_eqpreset_i;
          pipe_tx_eqcoeff_q <= #TCQ pipe_tx_eqcoeff_i;
          pipe_tx_eqdone_q <= #TCQ pipe_tx_eqdone_i;
          pipe_tx_compliance_q <= #TCQ pipe_tx_compliance_i;
          pipe_tx_char_is_k_q <= #TCQ pipe_tx_char_is_k_i;
          pipe_tx_data_q <= #TCQ pipe_tx_data_i;
          pipe_tx_elec_idle_q <= #TCQ pipe_tx_elec_idle_i;
          pipe_tx_powerdown_q <= #TCQ pipe_tx_powerdown_i;
          pipe_tx_datavalid_q <= #TCQ pipe_tx_datavalid_i;
          pipe_tx_startblock_q <= #TCQ pipe_tx_startblock_i;
          pipe_tx_syncheader_q <= #TCQ pipe_tx_syncheader_i;
          pipe_tx_eqcontrol_q <= #TCQ pipe_tx_eqcontrol_i;
          pipe_tx_eqdeemph_q <= #TCQ pipe_tx_eqdeemph_i;
          pipe_tx_eqpreset_q <= #TCQ pipe_tx_eqpreset_i;
        end
      end
      assign pipe_rx_char_is_k_o = pipe_rx_char_is_k_q;
      assign pipe_rx_data_o = pipe_rx_data_q;
      assign pipe_rx_valid_o = pipe_rx_valid_q;
      assign pipe_rx_data_valid_o = pipe_rx_data_valid_q;
      assign pipe_rx_status_o = pipe_rx_status_q;
      assign pipe_rx_phy_status_o = pipe_rx_phy_status_q;
      assign pipe_rx_elec_idle_o = pipe_rx_elec_idle_q;
      assign pipe_rx_eqdone_o = pipe_rx_eqdone_q;
      assign pipe_rx_eqlpadaptdone_o = pipe_rx_eqlpadaptdone_q;
      assign pipe_rx_eqlplffssel_o = pipe_rx_eqlplffssel_q;
      assign pipe_rx_eqlpnewtxcoefforpreset_o = pipe_rx_eqlpnewtxcoefforpreset_q;
      assign pipe_rx_startblock_o = pipe_rx_startblock_q;
      assign pipe_rx_syncheader_o = pipe_rx_syncheader_q;
      assign pipe_rx_polarity_o = pipe_rx_polarity_q;
      assign pipe_rx_eqcontrol_o = pipe_rx_eqcontrol_q;
      assign pipe_rx_eqlplffs_o = pipe_rx_eqlplffs_q;
      assign pipe_rx_eqlptxpreset_o = pipe_rx_eqlptxpreset_q;
      assign pipe_rx_eqpreset_o = pipe_rx_eqpreset_q;
      assign pipe_tx_eqcoeff_o = pipe_tx_eqcoeff_q;
      assign pipe_tx_eqdone_o = pipe_tx_eqdone_q;
      assign pipe_tx_compliance_o = pipe_tx_compliance_q;
      assign pipe_tx_char_is_k_o = pipe_tx_char_is_k_q;
      assign pipe_tx_data_o = pipe_tx_data_q;
      assign pipe_tx_elec_idle_o = pipe_tx_elec_idle_q;
      assign pipe_tx_powerdown_o = pipe_tx_powerdown_q;
      assign pipe_tx_datavalid_o = pipe_tx_datavalid_q;
      assign pipe_tx_startblock_o = pipe_tx_startblock_q;
      assign pipe_tx_syncheader_o = pipe_tx_syncheader_q;
      assign pipe_tx_eqcontrol_o = pipe_tx_eqcontrol_q;
      assign pipe_tx_eqdeemph_o = pipe_tx_eqdeemph_q;
      assign pipe_tx_eqpreset_o = pipe_tx_eqpreset_q;
    end
    else if (PIPE_PIPELINE_STAGES == 2)
    begin : pipe_stages_2
      always @(posedge pipe_clk)
      begin
        if (!rst_n)
        begin
          pipe_rx_char_is_k_q <= #TCQ 2'b00;
          pipe_rx_data_q <= #TCQ 32'h00000000;
          pipe_rx_valid_q <= #TCQ 1'b0;
          pipe_rx_data_valid_q <= #TCQ 1'b0;
          pipe_rx_status_q <= #TCQ 2'b00;
          pipe_rx_phy_status_q <= #TCQ 1'b0;
          pipe_rx_elec_idle_q <= #TCQ 1'b1;
          pipe_rx_eqdone_q <= #TCQ 1'b0;
          pipe_rx_eqlpadaptdone_q <= #TCQ 1'b0;
          pipe_rx_eqlplffssel_q <= #TCQ 1'b0;
          pipe_rx_eqlpnewtxcoefforpreset_q <= #TCQ 17'b00000000000000000;
          pipe_rx_startblock_q <= #TCQ 1'b0;
          pipe_rx_syncheader_q <= #TCQ 2'b00;
          pipe_rx_polarity_q <= #TCQ 17'b00000000000000000;
          pipe_rx_eqcontrol_q <= #TCQ 1'b0;
          pipe_rx_eqlplffs_q <= #TCQ 1'b0;
          pipe_rx_eqlptxpreset_q <= #TCQ 2'b00;
          pipe_rx_eqpreset_q <= #TCQ 6'b000000;
          pipe_tx_eqcoeff_q <= #TCQ 4'h0;
          pipe_tx_eqdone_q <= #TCQ 3'b000;
          pipe_tx_compliance_q <= #TCQ 1'b0;
          pipe_tx_char_is_k_q <= #TCQ 2'b00;
          pipe_tx_data_q <= #TCQ 32'h00000000;
          pipe_tx_elec_idle_q <= #TCQ 1'b1;
          pipe_tx_powerdown_q <= #TCQ 2'b00;
          pipe_tx_datavalid_q <= #TCQ 1'b0;
          pipe_tx_startblock_q <= #TCQ 1'b0;
          pipe_tx_syncheader_q <= #TCQ 2'b00;
          pipe_tx_eqcontrol_q <= #TCQ 2'b00;
          pipe_tx_eqdeemph_q <= #TCQ 6'b000000;
          pipe_tx_eqpreset_q <= #TCQ 4'h0;
          pipe_rx_char_is_k_qq <= #TCQ 2'b00;
          pipe_rx_data_qq <= #TCQ 32'h00000000;
          pipe_rx_valid_qq <= #TCQ 1'b0;
          pipe_rx_data_valid_qq <= #TCQ 1'b0;
          pipe_rx_status_qq <= #TCQ 2'b00;
          pipe_rx_phy_status_qq <= #TCQ 1'b0;
          pipe_rx_elec_idle_qq <= #TCQ 1'b1;
          pipe_rx_eqdone_qq <= #TCQ 1'b0;
          pipe_rx_eqlpadaptdone_qq <= #TCQ 1'b0;
          pipe_rx_eqlplffssel_qq <= #TCQ 1'b0;
          pipe_rx_eqlpnewtxcoefforpreset_qq <= #TCQ 17'b00000000000000000;
          pipe_rx_startblock_qq <= #TCQ 1'b0;
          pipe_rx_syncheader_qq <= #TCQ 2'b00;
          pipe_rx_polarity_qq <= #TCQ 17'b00000000000000000;
          pipe_rx_eqcontrol_qq <= #TCQ 1'b0;
          pipe_rx_eqlplffs_qq <= #TCQ 1'b0;
          pipe_rx_eqlptxpreset_qq <= #TCQ 2'b00;
          pipe_rx_eqpreset_qq <= #TCQ 6'b000000;
          pipe_tx_eqcoeff_qq <= #TCQ 4'h0;
          pipe_tx_eqdone_qq <= #TCQ 3'b000;
          pipe_tx_compliance_qq <= #TCQ 1'b0;
          pipe_tx_char_is_k_qq <= #TCQ 2'b00;
          pipe_tx_data_qq <= #TCQ 32'h00000000;
          pipe_tx_elec_idle_qq <= #TCQ 1'b1;
          pipe_tx_powerdown_qq <= #TCQ 2'b00;
          pipe_tx_datavalid_qq <= #TCQ 1'b0;
          pipe_tx_startblock_qq <= #TCQ 1'b0;
          pipe_tx_syncheader_qq <= #TCQ 2'b00;
          pipe_tx_eqcontrol_qq <= #TCQ 2'b00;
          pipe_tx_eqdeemph_qq <= #TCQ 6'b000000;
          pipe_tx_eqpreset_qq <= #TCQ 4'h0;
        end
        else
        begin
          pipe_rx_char_is_k_q <= #TCQ pipe_rx_char_is_k_i;
          pipe_rx_data_q <= #TCQ pipe_rx_data_i;
          pipe_rx_valid_q <= #TCQ pipe_rx_valid_i;
          pipe_rx_data_valid_q <= #TCQ pipe_rx_data_valid_i;
          pipe_rx_status_q <= #TCQ pipe_rx_status_i;
          pipe_rx_phy_status_q <= #TCQ pipe_rx_phy_status_i;
          pipe_rx_elec_idle_q <= #TCQ pipe_rx_elec_idle_i;
          pipe_rx_eqdone_q <= #TCQ pipe_rx_eqdone_i;
          pipe_rx_eqlpadaptdone_q <= #TCQ pipe_rx_eqlpadaptdone_i;
          pipe_rx_eqlplffssel_q <= #TCQ pipe_rx_eqlplffssel_i;
          pipe_rx_eqlpnewtxcoefforpreset_q <= #TCQ pipe_rx_eqlpnewtxcoefforpreset_i;
          pipe_rx_startblock_q <= #TCQ pipe_rx_startblock_i;
          pipe_rx_syncheader_q <= #TCQ pipe_rx_syncheader_i;
          pipe_rx_polarity_q <= #TCQ pipe_rx_polarity_i;
          pipe_rx_eqcontrol_q <= #TCQ pipe_rx_eqcontrol_i;
          pipe_rx_eqlplffs_q <= #TCQ pipe_rx_eqlplffs_i;
          pipe_rx_eqlptxpreset_q <= #TCQ pipe_rx_eqlptxpreset_i;
          pipe_rx_eqpreset_q <= #TCQ pipe_rx_eqpreset_i;
          pipe_tx_eqcoeff_q <= #TCQ pipe_tx_eqcoeff_i;
          pipe_tx_eqdone_q <= #TCQ pipe_tx_eqdone_i;
          pipe_tx_compliance_q <= #TCQ pipe_tx_compliance_i;
          pipe_tx_char_is_k_q <= #TCQ pipe_tx_char_is_k_i;
          pipe_tx_data_q <= #TCQ pipe_tx_data_i;
          pipe_tx_elec_idle_q <= #TCQ pipe_tx_elec_idle_i;
          pipe_tx_powerdown_q <= #TCQ pipe_tx_powerdown_i;
          pipe_tx_datavalid_q <= #TCQ pipe_tx_datavalid_i;
          pipe_tx_startblock_q <= #TCQ pipe_tx_startblock_i;
          pipe_tx_syncheader_q <= #TCQ pipe_tx_syncheader_i;
          pipe_tx_eqcontrol_q <= #TCQ pipe_tx_eqcontrol_i;
          pipe_tx_eqdeemph_q <= #TCQ pipe_tx_eqdeemph_i;
          pipe_tx_eqpreset_q <= #TCQ pipe_tx_eqpreset_i;
          pipe_rx_char_is_k_qq <= #TCQ pipe_rx_char_is_k_q;
          pipe_rx_data_qq <= #TCQ pipe_rx_data_q;
          pipe_rx_valid_qq <= #TCQ pipe_rx_valid_q;
          pipe_rx_data_valid_qq <= #TCQ pipe_rx_data_valid_q;
          pipe_rx_status_qq <= #TCQ pipe_rx_status_q;
          pipe_rx_phy_status_qq <= #TCQ pipe_rx_phy_status_q;
          pipe_rx_elec_idle_qq <= #TCQ pipe_rx_elec_idle_q;
          pipe_rx_eqdone_qq <= #TCQ pipe_rx_eqdone_q;
          pipe_rx_eqlpadaptdone_qq <= #TCQ pipe_rx_eqlpadaptdone_q;
          pipe_rx_eqlplffssel_qq <= #TCQ pipe_rx_eqlplffssel_q;
          pipe_rx_eqlpnewtxcoefforpreset_qq <= #TCQ pipe_rx_eqlpnewtxcoefforpreset_q;
          pipe_rx_startblock_qq <= #TCQ pipe_rx_startblock_q;
          pipe_rx_syncheader_qq <= #TCQ pipe_rx_syncheader_q;
          pipe_rx_polarity_qq <= #TCQ pipe_rx_polarity_q;
          pipe_rx_eqcontrol_qq <= #TCQ pipe_rx_eqcontrol_q;
          pipe_rx_eqlplffs_qq <= #TCQ pipe_rx_eqlplffs_q;
          pipe_rx_eqlptxpreset_qq <= #TCQ pipe_rx_eqlptxpreset_q;
          pipe_rx_eqpreset_qq <= #TCQ pipe_rx_eqpreset_q;
          pipe_tx_eqcoeff_qq <= #TCQ pipe_tx_eqcoeff_q;
          pipe_tx_eqdone_qq <= #TCQ pipe_tx_eqdone_q;
          pipe_tx_compliance_qq <= #TCQ pipe_tx_compliance_q;
          pipe_tx_char_is_k_qq <= #TCQ pipe_tx_char_is_k_q;
          pipe_tx_data_qq <= #TCQ pipe_tx_data_q;
          pipe_tx_elec_idle_qq <= #TCQ pipe_tx_elec_idle_q;
          pipe_tx_powerdown_qq <= #TCQ pipe_tx_powerdown_q;
          pipe_tx_datavalid_qq <= #TCQ pipe_tx_datavalid_q;
          pipe_tx_startblock_qq <= #TCQ pipe_tx_startblock_q;
          pipe_tx_syncheader_qq <= #TCQ pipe_tx_syncheader_q;
          pipe_tx_eqcontrol_qq <= #TCQ pipe_tx_eqcontrol_q;
          pipe_tx_eqdeemph_qq <= #TCQ pipe_tx_eqdeemph_q;
          pipe_tx_eqpreset_qq <= #TCQ pipe_tx_eqpreset_q;
        end
      end
      assign pipe_rx_char_is_k_o = pipe_rx_char_is_k_qq;
      assign pipe_rx_data_o = pipe_rx_data_qq;
      assign pipe_rx_valid_o = pipe_rx_valid_qq;
      assign pipe_rx_data_valid_o = pipe_rx_data_valid_qq;
      assign pipe_rx_status_o = pipe_rx_status_qq;
      assign pipe_rx_phy_status_o = pipe_rx_phy_status_qq;
      assign pipe_rx_elec_idle_o = pipe_rx_elec_idle_qq;
      assign pipe_rx_eqdone_o = pipe_rx_eqdone_qq;
      assign pipe_rx_eqlpadaptdone_o = pipe_rx_eqlpadaptdone_qq;
      assign pipe_rx_eqlplffssel_o = pipe_rx_eqlplffssel_qq;
      assign pipe_rx_eqlpnewtxcoefforpreset_o = pipe_rx_eqlpnewtxcoefforpreset_qq;
      assign pipe_rx_startblock_o = pipe_rx_startblock_qq;
      assign pipe_rx_syncheader_o = pipe_rx_syncheader_qq;
      assign pipe_rx_polarity_o = pipe_rx_polarity_qq;
      assign pipe_rx_eqcontrol_o = pipe_rx_eqcontrol_qq;
      assign pipe_rx_eqlplffs_o = pipe_rx_eqlplffs_qq;
      assign pipe_rx_eqlptxpreset_o = pipe_rx_eqlptxpreset_qq;
      assign pipe_rx_eqpreset_o = pipe_rx_eqpreset_qq;
      assign pipe_tx_eqcoeff_o = pipe_tx_eqcoeff_qq;
      assign pipe_tx_eqdone_o = pipe_tx_eqdone_qq;
      assign pipe_tx_compliance_o = pipe_tx_compliance_qq;
      assign pipe_tx_char_is_k_o = pipe_tx_char_is_k_qq;
      assign pipe_tx_data_o = pipe_tx_data_qq;
      assign pipe_tx_elec_idle_o = pipe_tx_elec_idle_qq;
      assign pipe_tx_powerdown_o = pipe_tx_powerdown_qq;
      assign pipe_tx_datavalid_o = pipe_tx_datavalid_qq;
      assign pipe_tx_startblock_o = pipe_tx_startblock_qq;
      assign pipe_tx_syncheader_o = pipe_tx_syncheader_qq;
      assign pipe_tx_eqcontrol_o = pipe_tx_eqcontrol_qq;
      assign pipe_tx_eqdeemph_o = pipe_tx_eqdeemph_qq;
      assign pipe_tx_eqpreset_o = pipe_tx_eqpreset_qq;
    end
    else
    begin
      assign pipe_rx_char_is_k_o = pipe_rx_char_is_k_i;
      assign pipe_rx_data_o = pipe_rx_data_i;
      assign pipe_rx_valid_o = pipe_rx_valid_i;
      assign pipe_rx_data_valid_o = pipe_rx_data_valid_i;
      assign pipe_rx_status_o = pipe_rx_status_i;
      assign pipe_rx_phy_status_o = pipe_rx_phy_status_i;
      assign pipe_rx_elec_idle_o = pipe_rx_elec_idle_i;
      assign pipe_rx_eqdone_o = pipe_rx_eqdone_i;
      assign pipe_rx_eqlpadaptdone_o = pipe_rx_eqlpadaptdone_i;
      assign pipe_rx_eqlplffssel_o = pipe_rx_eqlplffssel_i;
      assign pipe_rx_eqlpnewtxcoefforpreset_o = pipe_rx_eqlpnewtxcoefforpreset_i;
      assign pipe_rx_startblock_o = pipe_rx_startblock_i;
      assign pipe_rx_syncheader_o = pipe_rx_syncheader_i;
      assign pipe_rx_polarity_o = pipe_rx_polarity_i;
      assign pipe_rx_eqcontrol_o = pipe_rx_eqcontrol_i;
      assign pipe_rx_eqlplffs_o = pipe_rx_eqlplffs_i;
      assign pipe_rx_eqlptxpreset_o = pipe_rx_eqlptxpreset_i;
      assign pipe_rx_eqpreset_o = pipe_rx_eqpreset_i;
      assign pipe_tx_eqcoeff_o = pipe_tx_eqcoeff_i;
      assign pipe_tx_eqdone_o = pipe_tx_eqdone_i;
      assign pipe_tx_compliance_o = pipe_tx_compliance_i;
      assign pipe_tx_char_is_k_o = pipe_tx_char_is_k_i;
      assign pipe_tx_data_o = pipe_tx_data_i;
      assign pipe_tx_elec_idle_o = pipe_tx_elec_idle_i;
      assign pipe_tx_powerdown_o = pipe_tx_powerdown_i;
      assign pipe_tx_datavalid_o = pipe_tx_datavalid_i;
      assign pipe_tx_startblock_o = pipe_tx_startblock_i;
      assign pipe_tx_syncheader_o = pipe_tx_syncheader_i;
      assign pipe_tx_eqcontrol_o = pipe_tx_eqcontrol_i;
      assign pipe_tx_eqdeemph_o = pipe_tx_eqdeemph_i;
      assign pipe_tx_eqpreset_o = pipe_tx_eqpreset_i;
    end
  endgenerate
endmodule

module rp_pcie3_uscale_wrapper 
#(
  parameter TCQ = 100,
  parameter NO_DECODE_LOGIC  = "TRUE",
  parameter INTERFACE_SPEED  = "500MHZ",
  parameter COMPLETION_SPACE = "16KB",
  parameter ARI_CAP_ENABLE = "FALSE",
  parameter AXISTEN_IF_CC_ALIGNMENT_MODE = "FALSE",
  parameter AXISTEN_IF_CC_PARITY_CHK = "TRUE",
  parameter AXISTEN_IF_CQ_ALIGNMENT_MODE = "FALSE",
  parameter AXISTEN_IF_ENABLE_CLIENT_TAG = "FALSE",
  parameter [17:0] AXISTEN_IF_ENABLE_MSG_ROUTE = 18'h00000,
  parameter AXISTEN_IF_ENABLE_RX_MSG_INTFC = "FALSE",
  parameter AXISTEN_IF_RC_ALIGNMENT_MODE = "FALSE",
  parameter AXISTEN_IF_RC_STRADDLE = "FALSE",
  parameter AXISTEN_IF_RQ_ALIGNMENT_MODE = "FALSE",
  parameter AXISTEN_IF_RQ_PARITY_CHK = "TRUE",
  parameter [1:0] AXISTEN_IF_WIDTH = 2'h2,
  parameter CRM_CORE_CLK_FREQ_500 = "TRUE",
  parameter [1:0] CRM_USER_CLK_FREQ = 2'h2,
  parameter DEBUG_CFG_LOCAL_MGMT_REG_ACCESS_OVERRIDE = "FALSE",
  parameter DEBUG_PL_DISABLE_EI_INFER_IN_L0 = "FALSE",
  parameter DEBUG_TL_DISABLE_RX_TLP_ORDER_CHECKS = "FALSE",
  parameter [7:0] DNSTREAM_LINK_NUM = 8'h00,
  parameter [8:0] LL_ACK_TIMEOUT = 9'h000,
  parameter LL_ACK_TIMEOUT_EN = "FALSE",
  parameter integer LL_ACK_TIMEOUT_FUNC = 0,
  parameter [15:0] LL_CPL_FC_UPDATE_TIMER = 16'h0000,
  parameter LL_CPL_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter [15:0] LL_FC_UPDATE_TIMER = 16'h0000,
  parameter LL_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter [15:0] LL_NP_FC_UPDATE_TIMER = 16'h0000,
  parameter LL_NP_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter [15:0] LL_P_FC_UPDATE_TIMER = 16'h0000,
  parameter LL_P_FC_UPDATE_TIMER_OVERRIDE = "FALSE",
  parameter [8:0] LL_REPLAY_TIMEOUT = 9'h000,
  parameter LL_REPLAY_TIMEOUT_EN = "FALSE",
  parameter integer LL_REPLAY_TIMEOUT_FUNC = 0,
  parameter [9:0] LTR_TX_MESSAGE_MINIMUM_INTERVAL = 10'h0fa,
  parameter LTR_TX_MESSAGE_ON_FUNC_POWER_STATE_CHANGE = "FALSE",
  parameter LTR_TX_MESSAGE_ON_LTR_ENABLE = "FALSE",
  parameter [11:0] MCAP_CAP_NEXTPTR = 12'h000,
  parameter MCAP_CONFIGURE_OVERRIDE = "FALSE",
  parameter MCAP_ENABLE = "FALSE",
  parameter MCAP_EOS_DESIGN_SWITCH = "TRUE",
  parameter [31:0] MCAP_FPGA_BITSTREAM_VERSION = 32'h00000000,
  parameter MCAP_GATE_IO_ENABLE_DESIGN_SWITCH = "TRUE",
  parameter MCAP_GATE_MEM_ENABLE_DESIGN_SWITCH = "TRUE",
  parameter MCAP_INPUT_GATE_DESIGN_SWITCH = "FALSE",
  parameter MCAP_INTERRUPT_ON_MCAP_EOS = "FALSE",
  parameter MCAP_INTERRUPT_ON_MCAP_ERROR = "FALSE",
  parameter [15:0] MCAP_VSEC_ID = 16'h0000,
  parameter [11:0] MCAP_VSEC_LEN = 12'h02c,
  parameter [3:0] MCAP_VSEC_REV = 4'h0,
  parameter PF0_AER_CAP_ECRC_CHECK_CAPABLE = "FALSE",
  parameter PF0_AER_CAP_ECRC_GEN_CAPABLE = "FALSE",
  parameter [11:0] PF0_AER_CAP_NEXTPTR = 12'h000,
  parameter [7:0] PF0_ARI_CAP_NEXT_FUNC = 8'h00,
  parameter [11:0] PF0_ARI_CAP_NEXTPTR = 12'h000,
  parameter [3:0] PF0_ARI_CAP_VER = 4'h1,
  parameter [5:0] PF0_BAR0_APERTURE_SIZE = 6'h03,
  parameter [2:0] PF0_BAR0_CONTROL = 3'h4,
  parameter [5:0] PF0_BAR1_APERTURE_SIZE = 6'h00,
  parameter [2:0] PF0_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF0_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF0_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF0_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF0_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_BAR5_CONTROL = 3'h0,
  parameter [7:0] PF0_BIST_REGISTER = 8'h00,
  parameter [7:0] PF0_CAPABILITY_POINTER = 8'h50,
  parameter [23:0] PF0_CLASS_CODE = 24'h000000,
  parameter integer PF0_DEV_CAP_ENDPOINT_L0S_LATENCY = 0,
  parameter integer PF0_DEV_CAP_ENDPOINT_L1_LATENCY = 0,
  parameter PF0_DEV_CAP_EXT_TAG_SUPPORTED = "TRUE",
  parameter PF0_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE = "TRUE",
  parameter [2:0] PF0_DEV_CAP_MAX_PAYLOAD_SIZE = 3'h3,
  parameter PF0_DEV_CAP2_ARI_FORWARD_ENABLE = "FALSE",
  parameter PF0_DEV_CAP2_CPL_TIMEOUT_DISABLE = "TRUE",
  parameter PF0_DEV_CAP2_LTR_SUPPORT = "TRUE",
  parameter [1:0] PF0_DEV_CAP2_OBFF_SUPPORT = 2'h0,
  parameter PF0_DEV_CAP2_TPH_COMPLETER_SUPPORT = "FALSE",
  parameter PF0_DEV_CAP2_32B_ATOMIC_COMPLETER_SUPPORT = "TRUE",
  parameter PF0_DEV_CAP2_64B_ATOMIC_COMPLETER_SUPPORT = "TRUE",
  parameter PF0_DEV_CAP2_128B_CAS_ATOMIC_COMPLETER_SUPPORT = "TRUE",
  parameter [15:0] PF0_DEVICE_ID = 16'h0000,
  parameter [11:0] PF0_DPA_CAP_NEXTPTR = 12'h000,
  parameter [4:0] PF0_DPA_CAP_SUB_STATE_CONTROL = 5'h00,
  parameter PF0_DPA_CAP_SUB_STATE_CONTROL_EN = "TRUE",
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 = 8'h00,
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 = 8'h00,
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 = 8'h00,
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 = 8'h00,
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 = 8'h00,
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 = 8'h00,
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 = 8'h00,
  parameter [7:0] PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 = 8'h00,
  parameter [3:0] PF0_DPA_CAP_VER = 4'h1,
  parameter [11:0] PF0_DSN_CAP_NEXTPTR = 12'h10c,
  parameter [4:0] PF0_EXPANSION_ROM_APERTURE_SIZE = 5'h03,
  parameter PF0_EXPANSION_ROM_ENABLE = "FALSE",
  parameter [7:0] PF0_INTERRUPT_LINE = 8'h00,
  parameter [2:0] PF0_INTERRUPT_PIN = 3'h1,
  parameter integer PF0_LINK_CAP_ASPM_SUPPORT = 0,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN3 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN3 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN3 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_GEN1 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_GEN2 = 7,
  parameter integer PF0_LINK_CAP_L1_EXIT_LATENCY_GEN3 = 7,
  parameter PF0_LINK_STATUS_SLOT_CLOCK_CONFIG = "TRUE",
  parameter [9:0] PF0_LTR_CAP_MAX_NOSNOOP_LAT = 10'h000,
  parameter [9:0] PF0_LTR_CAP_MAX_SNOOP_LAT = 10'h000,
  parameter [11:0] PF0_LTR_CAP_NEXTPTR = 12'h000,
  parameter [3:0] PF0_LTR_CAP_VER = 4'h1,
  parameter integer PF0_MSI_CAP_MULTIMSGCAP = 0,
  parameter [7:0] PF0_MSI_CAP_NEXTPTR = 8'h00,
  parameter PF0_MSI_CAP_PERVECMASKCAP = "FALSE",
  parameter [7:0] PF0_MSIX_CAP_NEXTPTR = 8'h00,
  parameter integer PF0_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] PF0_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer PF0_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] PF0_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] PF0_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [31:0] PF0_PB_CAP_DATA_REG_D0 = 32'h00000000,
  parameter [31:0] PF0_PB_CAP_DATA_REG_D0_SUSTAINED = 32'h00000000,
  parameter [31:0] PF0_PB_CAP_DATA_REG_D1 = 32'h00000000,
  parameter [31:0] PF0_PB_CAP_DATA_REG_D3HOT = 32'h00000000,
  parameter [11:0] PF0_PB_CAP_NEXTPTR = 12'h000,
  parameter PF0_PB_CAP_SYSTEM_ALLOCATED = "FALSE",
  parameter [3:0] PF0_PB_CAP_VER = 4'h1,
  parameter [7:0] PF0_PM_CAP_ID = 8'h01,
  parameter [7:0] PF0_PM_CAP_NEXTPTR = 8'h00,
  parameter PF0_PM_CAP_PMESUPPORT_D0 = "TRUE",
  parameter PF0_PM_CAP_PMESUPPORT_D1 = "TRUE",
  parameter PF0_PM_CAP_PMESUPPORT_D3HOT = "TRUE",
  parameter PF0_PM_CAP_SUPP_D1_STATE = "TRUE",
  parameter [2:0] PF0_PM_CAP_VER_ID = 3'h3,
  parameter PF0_PM_CSR_NOSOFTRESET = "TRUE",
  parameter PF0_RBAR_CAP_ENABLE = "FALSE",
  parameter [11:0] PF0_RBAR_CAP_NEXTPTR = 12'h000,
  parameter [19:0] PF0_RBAR_CAP_SIZE0 = 20'h00000,
  parameter [19:0] PF0_RBAR_CAP_SIZE1 = 20'h00000,
  parameter [19:0] PF0_RBAR_CAP_SIZE2 = 20'h00000,
  parameter [3:0] PF0_RBAR_CAP_VER = 4'h1,
  parameter [2:0] PF0_RBAR_CONTROL_INDEX0 = 3'h0,
  parameter [2:0] PF0_RBAR_CONTROL_INDEX1 = 3'h0,
  parameter [2:0] PF0_RBAR_CONTROL_INDEX2 = 3'h0,
  parameter [4:0] PF0_RBAR_CONTROL_SIZE0 = 5'h00,
  parameter [4:0] PF0_RBAR_CONTROL_SIZE1 = 5'h00,
  parameter [4:0] PF0_RBAR_CONTROL_SIZE2 = 5'h00,
  parameter [2:0] PF0_RBAR_NUM = 3'h1,
  parameter [7:0] PF0_REVISION_ID = 8'h00,
  parameter [11:0] PF0_SECONDARY_PCIE_CAP_NEXTPTR = 12'h000,
  parameter [4:0] PF0_SRIOV_BAR0_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_SRIOV_BAR0_CONTROL = 3'h4,
  parameter [4:0] PF0_SRIOV_BAR1_APERTURE_SIZE = 5'h00,
  parameter [2:0] PF0_SRIOV_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF0_SRIOV_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_SRIOV_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF0_SRIOV_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_SRIOV_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF0_SRIOV_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_SRIOV_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF0_SRIOV_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF0_SRIOV_BAR5_CONTROL = 3'h0,
  parameter [15:0] PF0_SRIOV_CAP_INITIAL_VF = 16'h0000,
  parameter [11:0] PF0_SRIOV_CAP_NEXTPTR = 12'h000,
  parameter [15:0] PF0_SRIOV_CAP_TOTAL_VF = 16'h0000,
  parameter [3:0] PF0_SRIOV_CAP_VER = 4'h1,
  parameter [15:0] PF0_SRIOV_FIRST_VF_OFFSET = 16'h0000,
  parameter [15:0] PF0_SRIOV_FUNC_DEP_LINK = 16'h0000,
  parameter [31:0] PF0_SRIOV_SUPPORTED_PAGE_SIZE = 32'h00000000,
  parameter [15:0] PF0_SRIOV_VF_DEVICE_ID = 16'h0000,
  parameter [15:0] PF0_SUBSYSTEM_ID = 16'h0000,
  parameter PF0_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter PF0_TPHR_CAP_ENABLE = "FALSE",
  parameter PF0_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] PF0_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] PF0_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] PF0_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] PF0_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] PF0_TPHR_CAP_VER = 4'h1,
  parameter PF0_VC_CAP_ENABLE = "FALSE",
  parameter [11:0] PF0_VC_CAP_NEXTPTR = 12'h000,
  parameter [3:0] PF0_VC_CAP_VER = 4'h1,
  parameter PF1_AER_CAP_ECRC_CHECK_CAPABLE = "FALSE",
  parameter PF1_AER_CAP_ECRC_GEN_CAPABLE = "FALSE",
  parameter [11:0] PF1_AER_CAP_NEXTPTR = 12'h000,
  parameter [7:0] PF1_ARI_CAP_NEXT_FUNC = 8'h00,
  parameter [11:0] PF1_ARI_CAP_NEXTPTR = 12'h000,
  parameter [5:0] PF1_BAR0_APERTURE_SIZE = 6'h03,
  parameter [2:0] PF1_BAR0_CONTROL = 3'h4,
  parameter [5:0] PF1_BAR1_APERTURE_SIZE = 6'h00,
  parameter [2:0] PF1_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF1_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF1_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF1_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF1_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_BAR5_CONTROL = 3'h0,
  parameter [7:0] PF1_BIST_REGISTER = 8'h00,
  parameter [7:0] PF1_CAPABILITY_POINTER = 8'h50,
  parameter [23:0] PF1_CLASS_CODE = 24'h000000,
  parameter [2:0] PF1_DEV_CAP_MAX_PAYLOAD_SIZE = 3'h3,
  parameter [15:0] PF1_DEVICE_ID = 16'h0000,
  parameter [11:0] PF1_DPA_CAP_NEXTPTR = 12'h000,
  parameter [4:0] PF1_DPA_CAP_SUB_STATE_CONTROL = 5'h00,
  parameter PF1_DPA_CAP_SUB_STATE_CONTROL_EN = "TRUE",
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 = 8'h00,
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 = 8'h00,
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 = 8'h00,
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 = 8'h00,
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 = 8'h00,
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 = 8'h00,
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 = 8'h00,
  parameter [7:0] PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 = 8'h00,
  parameter [3:0] PF1_DPA_CAP_VER = 4'h1,
  parameter [11:0] PF1_DSN_CAP_NEXTPTR = 12'h10c,
  parameter [4:0] PF1_EXPANSION_ROM_APERTURE_SIZE = 5'h03,
  parameter PF1_EXPANSION_ROM_ENABLE = "FALSE",
  parameter [7:0] PF1_INTERRUPT_LINE = 8'h00,
  parameter [2:0] PF1_INTERRUPT_PIN = 3'h1,
  parameter integer PF1_MSI_CAP_MULTIMSGCAP = 0,
  parameter [7:0] PF1_MSI_CAP_NEXTPTR = 8'h00,
  parameter PF1_MSI_CAP_PERVECMASKCAP = "FALSE",
  parameter [7:0] PF1_MSIX_CAP_NEXTPTR = 8'h00,
  parameter integer PF1_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] PF1_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer PF1_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] PF1_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] PF1_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [31:0] PF1_PB_CAP_DATA_REG_D0 = 32'h00000000,
  parameter [31:0] PF1_PB_CAP_DATA_REG_D0_SUSTAINED = 32'h00000000,
  parameter [31:0] PF1_PB_CAP_DATA_REG_D1 = 32'h00000000,
  parameter [31:0] PF1_PB_CAP_DATA_REG_D3HOT = 32'h00000000,
  parameter [11:0] PF1_PB_CAP_NEXTPTR = 12'h000,
  parameter PF1_PB_CAP_SYSTEM_ALLOCATED = "FALSE",
  parameter [3:0] PF1_PB_CAP_VER = 4'h1,
  parameter [7:0] PF1_PM_CAP_ID = 8'h01,
  parameter [7:0] PF1_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] PF1_PM_CAP_VER_ID = 3'h3,
  parameter PF1_RBAR_CAP_ENABLE = "FALSE",
  parameter [11:0] PF1_RBAR_CAP_NEXTPTR = 12'h000,
  parameter [19:0] PF1_RBAR_CAP_SIZE0 = 20'h00000,
  parameter [19:0] PF1_RBAR_CAP_SIZE1 = 20'h00000,
  parameter [19:0] PF1_RBAR_CAP_SIZE2 = 20'h00000,
  parameter [3:0] PF1_RBAR_CAP_VER = 4'h1,
  parameter [2:0] PF1_RBAR_CONTROL_INDEX0 = 3'h0,
  parameter [2:0] PF1_RBAR_CONTROL_INDEX1 = 3'h0,
  parameter [2:0] PF1_RBAR_CONTROL_INDEX2 = 3'h0,
  parameter [4:0] PF1_RBAR_CONTROL_SIZE0 = 5'h00,
  parameter [4:0] PF1_RBAR_CONTROL_SIZE1 = 5'h00,
  parameter [4:0] PF1_RBAR_CONTROL_SIZE2 = 5'h00,
  parameter [2:0] PF1_RBAR_NUM = 3'h1,
  parameter [7:0] PF1_REVISION_ID = 8'h00,
  parameter [4:0] PF1_SRIOV_BAR0_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_SRIOV_BAR0_CONTROL = 3'h4,
  parameter [4:0] PF1_SRIOV_BAR1_APERTURE_SIZE = 5'h00,
  parameter [2:0] PF1_SRIOV_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF1_SRIOV_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_SRIOV_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF1_SRIOV_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_SRIOV_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF1_SRIOV_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_SRIOV_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF1_SRIOV_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF1_SRIOV_BAR5_CONTROL = 3'h0,
  parameter [15:0] PF1_SRIOV_CAP_INITIAL_VF = 16'h0000,
  parameter [11:0] PF1_SRIOV_CAP_NEXTPTR = 12'h000,
  parameter [15:0] PF1_SRIOV_CAP_TOTAL_VF = 16'h0000,
  parameter [3:0] PF1_SRIOV_CAP_VER = 4'h1,
  parameter [15:0] PF1_SRIOV_FIRST_VF_OFFSET = 16'h0000,
  parameter [15:0] PF1_SRIOV_FUNC_DEP_LINK = 16'h0000,
  parameter [31:0] PF1_SRIOV_SUPPORTED_PAGE_SIZE = 32'h00000000,
  parameter [15:0] PF1_SRIOV_VF_DEVICE_ID = 16'h0000,
  parameter [15:0] PF1_SUBSYSTEM_ID = 16'h0000,
  parameter PF1_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter PF1_TPHR_CAP_ENABLE = "FALSE",
  parameter PF1_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] PF1_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] PF1_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] PF1_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] PF1_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] PF1_TPHR_CAP_VER = 4'h1,
  parameter PF2_AER_CAP_ECRC_CHECK_CAPABLE = "FALSE",
  parameter PF2_AER_CAP_ECRC_GEN_CAPABLE = "FALSE",
  parameter [11:0] PF2_AER_CAP_NEXTPTR = 12'h000,
  parameter [7:0] PF2_ARI_CAP_NEXT_FUNC = 8'h00,
  parameter [11:0] PF2_ARI_CAP_NEXTPTR = 12'h000,
  parameter [5:0] PF2_BAR0_APERTURE_SIZE = 6'h03,
  parameter [2:0] PF2_BAR0_CONTROL = 3'h4,
  parameter [5:0] PF2_BAR1_APERTURE_SIZE = 6'h00,
  parameter [2:0] PF2_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF2_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF2_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF2_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF2_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_BAR5_CONTROL = 3'h0,
  parameter [7:0] PF2_BIST_REGISTER = 8'h00,
  parameter [7:0] PF2_CAPABILITY_POINTER = 8'h50,
  parameter [23:0] PF2_CLASS_CODE = 24'h000000,
  parameter [2:0] PF2_DEV_CAP_MAX_PAYLOAD_SIZE = 3'h3,
  parameter [15:0] PF2_DEVICE_ID = 16'h0000,
  parameter [11:0] PF2_DPA_CAP_NEXTPTR = 12'h000,
  parameter [4:0] PF2_DPA_CAP_SUB_STATE_CONTROL = 5'h00,
  parameter PF2_DPA_CAP_SUB_STATE_CONTROL_EN = "TRUE",
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 = 8'h00,
  parameter [7:0] PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 = 8'h00,
  parameter [3:0] PF2_DPA_CAP_VER = 4'h1,
  parameter [11:0] PF2_DSN_CAP_NEXTPTR = 12'h10c,
  parameter [4:0] PF2_EXPANSION_ROM_APERTURE_SIZE = 5'h03,
  parameter PF2_EXPANSION_ROM_ENABLE = "FALSE",
  parameter [7:0] PF2_INTERRUPT_LINE = 8'h00,
  parameter [2:0] PF2_INTERRUPT_PIN = 3'h1,
  parameter integer PF2_MSI_CAP_MULTIMSGCAP = 0,
  parameter [7:0] PF2_MSI_CAP_NEXTPTR = 8'h00,
  parameter PF2_MSI_CAP_PERVECMASKCAP = "FALSE",
  parameter [7:0] PF2_MSIX_CAP_NEXTPTR = 8'h00,
  parameter integer PF2_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] PF2_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer PF2_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] PF2_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] PF2_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [31:0] PF2_PB_CAP_DATA_REG_D0 = 32'h00000000,
  parameter [31:0] PF2_PB_CAP_DATA_REG_D0_SUSTAINED = 32'h00000000,
  parameter [31:0] PF2_PB_CAP_DATA_REG_D1 = 32'h00000000,
  parameter [31:0] PF2_PB_CAP_DATA_REG_D3HOT = 32'h00000000,
  parameter [11:0] PF2_PB_CAP_NEXTPTR = 12'h000,
  parameter PF2_PB_CAP_SYSTEM_ALLOCATED = "FALSE",
  parameter [3:0] PF2_PB_CAP_VER = 4'h1,
  parameter [7:0] PF2_PM_CAP_ID = 8'h01,
  parameter [7:0] PF2_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] PF2_PM_CAP_VER_ID = 3'h3,
  parameter PF2_RBAR_CAP_ENABLE = "FALSE",
  parameter [11:0] PF2_RBAR_CAP_NEXTPTR = 12'h000,
  parameter [19:0] PF2_RBAR_CAP_SIZE0 = 20'h00000,
  parameter [19:0] PF2_RBAR_CAP_SIZE1 = 20'h00000,
  parameter [19:0] PF2_RBAR_CAP_SIZE2 = 20'h00000,
  parameter [3:0] PF2_RBAR_CAP_VER = 4'h1,
  parameter [2:0] PF2_RBAR_CONTROL_INDEX0 = 3'h0,
  parameter [2:0] PF2_RBAR_CONTROL_INDEX1 = 3'h0,
  parameter [2:0] PF2_RBAR_CONTROL_INDEX2 = 3'h0,
  parameter [4:0] PF2_RBAR_CONTROL_SIZE0 = 5'h00,
  parameter [4:0] PF2_RBAR_CONTROL_SIZE1 = 5'h00,
  parameter [4:0] PF2_RBAR_CONTROL_SIZE2 = 5'h00,
  parameter [2:0] PF2_RBAR_NUM = 3'h1,
  parameter [7:0] PF2_REVISION_ID = 8'h00,
  parameter [4:0] PF2_SRIOV_BAR0_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_SRIOV_BAR0_CONTROL = 3'h4,
  parameter [4:0] PF2_SRIOV_BAR1_APERTURE_SIZE = 5'h00,
  parameter [2:0] PF2_SRIOV_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF2_SRIOV_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_SRIOV_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF2_SRIOV_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_SRIOV_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF2_SRIOV_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_SRIOV_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF2_SRIOV_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF2_SRIOV_BAR5_CONTROL = 3'h0,
  parameter [15:0] PF2_SRIOV_CAP_INITIAL_VF = 16'h0000,
  parameter [11:0] PF2_SRIOV_CAP_NEXTPTR = 12'h000,
  parameter [15:0] PF2_SRIOV_CAP_TOTAL_VF = 16'h0000,
  parameter [3:0] PF2_SRIOV_CAP_VER = 4'h1,
  parameter [15:0] PF2_SRIOV_FIRST_VF_OFFSET = 16'h0000,
  parameter [15:0] PF2_SRIOV_FUNC_DEP_LINK = 16'h0000,
  parameter [31:0] PF2_SRIOV_SUPPORTED_PAGE_SIZE = 32'h00000000,
  parameter [15:0] PF2_SRIOV_VF_DEVICE_ID = 16'h0000,
  parameter [15:0] PF2_SUBSYSTEM_ID = 16'h0000,
  parameter PF2_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter PF2_TPHR_CAP_ENABLE = "FALSE",
  parameter PF2_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] PF2_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] PF2_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] PF2_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] PF2_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] PF2_TPHR_CAP_VER = 4'h1,
  parameter PF3_AER_CAP_ECRC_CHECK_CAPABLE = "FALSE",
  parameter PF3_AER_CAP_ECRC_GEN_CAPABLE = "FALSE",
  parameter [11:0] PF3_AER_CAP_NEXTPTR = 12'h000,
  parameter [7:0] PF3_ARI_CAP_NEXT_FUNC = 8'h00,
  parameter [11:0] PF3_ARI_CAP_NEXTPTR = 12'h000,
  parameter [5:0] PF3_BAR0_APERTURE_SIZE = 6'h03,
  parameter [2:0] PF3_BAR0_CONTROL = 3'h4,
  parameter [5:0] PF3_BAR1_APERTURE_SIZE = 6'h00,
  parameter [2:0] PF3_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF3_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF3_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF3_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF3_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_BAR5_CONTROL = 3'h0,
  parameter [7:0] PF3_BIST_REGISTER = 8'h00,
  parameter [7:0] PF3_CAPABILITY_POINTER = 8'h50,
  parameter [23:0] PF3_CLASS_CODE = 24'h000000,
  parameter [2:0] PF3_DEV_CAP_MAX_PAYLOAD_SIZE = 3'h3,
  parameter [15:0] PF3_DEVICE_ID = 16'h0000,
  parameter [11:0] PF3_DPA_CAP_NEXTPTR = 12'h000,
  parameter [4:0] PF3_DPA_CAP_SUB_STATE_CONTROL = 5'h00,
  parameter PF3_DPA_CAP_SUB_STATE_CONTROL_EN = "TRUE",
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 = 8'h00,
  parameter [7:0] PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 = 8'h00,
  parameter [3:0] PF3_DPA_CAP_VER = 4'h1,
  parameter [11:0] PF3_DSN_CAP_NEXTPTR = 12'h10c,
  parameter [4:0] PF3_EXPANSION_ROM_APERTURE_SIZE = 5'h03,
  parameter PF3_EXPANSION_ROM_ENABLE = "FALSE",
  parameter [7:0] PF3_INTERRUPT_LINE = 8'h00,
  parameter [2:0] PF3_INTERRUPT_PIN = 3'h1,
  parameter integer PF3_MSI_CAP_MULTIMSGCAP = 0,
  parameter [7:0] PF3_MSI_CAP_NEXTPTR = 8'h00,
  parameter PF3_MSI_CAP_PERVECMASKCAP = "FALSE",
  parameter [7:0] PF3_MSIX_CAP_NEXTPTR = 8'h00,
  parameter integer PF3_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] PF3_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer PF3_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] PF3_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] PF3_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [31:0] PF3_PB_CAP_DATA_REG_D0 = 32'h00000000,
  parameter [31:0] PF3_PB_CAP_DATA_REG_D0_SUSTAINED = 32'h00000000,
  parameter [31:0] PF3_PB_CAP_DATA_REG_D1 = 32'h00000000,
  parameter [31:0] PF3_PB_CAP_DATA_REG_D3HOT = 32'h00000000,
  parameter [11:0] PF3_PB_CAP_NEXTPTR = 12'h000,
  parameter PF3_PB_CAP_SYSTEM_ALLOCATED = "FALSE",
  parameter [3:0] PF3_PB_CAP_VER = 4'h1,
  parameter [7:0] PF3_PM_CAP_ID = 8'h01,
  parameter [7:0] PF3_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] PF3_PM_CAP_VER_ID = 3'h3,
  parameter PF3_RBAR_CAP_ENABLE = "FALSE",
  parameter [11:0] PF3_RBAR_CAP_NEXTPTR = 12'h000,
  parameter [19:0] PF3_RBAR_CAP_SIZE0 = 20'h00000,
  parameter [19:0] PF3_RBAR_CAP_SIZE1 = 20'h00000,
  parameter [19:0] PF3_RBAR_CAP_SIZE2 = 20'h00000,
  parameter [3:0] PF3_RBAR_CAP_VER = 4'h1,
  parameter [2:0] PF3_RBAR_CONTROL_INDEX0 = 3'h0,
  parameter [2:0] PF3_RBAR_CONTROL_INDEX1 = 3'h0,
  parameter [2:0] PF3_RBAR_CONTROL_INDEX2 = 3'h0,
  parameter [4:0] PF3_RBAR_CONTROL_SIZE0 = 5'h00,
  parameter [4:0] PF3_RBAR_CONTROL_SIZE1 = 5'h00,
  parameter [4:0] PF3_RBAR_CONTROL_SIZE2 = 5'h00,
  parameter [2:0] PF3_RBAR_NUM = 3'h1,
  parameter [7:0] PF3_REVISION_ID = 8'h00,
  parameter [4:0] PF3_SRIOV_BAR0_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_SRIOV_BAR0_CONTROL = 3'h4,
  parameter [4:0] PF3_SRIOV_BAR1_APERTURE_SIZE = 5'h00,
  parameter [2:0] PF3_SRIOV_BAR1_CONTROL = 3'h0,
  parameter [4:0] PF3_SRIOV_BAR2_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_SRIOV_BAR2_CONTROL = 3'h4,
  parameter [4:0] PF3_SRIOV_BAR3_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_SRIOV_BAR3_CONTROL = 3'h0,
  parameter [4:0] PF3_SRIOV_BAR4_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_SRIOV_BAR4_CONTROL = 3'h4,
  parameter [4:0] PF3_SRIOV_BAR5_APERTURE_SIZE = 5'h03,
  parameter [2:0] PF3_SRIOV_BAR5_CONTROL = 3'h0,
  parameter [15:0] PF3_SRIOV_CAP_INITIAL_VF = 16'h0000,
  parameter [11:0] PF3_SRIOV_CAP_NEXTPTR = 12'h000,
  parameter [15:0] PF3_SRIOV_CAP_TOTAL_VF = 16'h0000,
  parameter [3:0] PF3_SRIOV_CAP_VER = 4'h1,
  parameter [15:0] PF3_SRIOV_FIRST_VF_OFFSET = 16'h0000,
  parameter [15:0] PF3_SRIOV_FUNC_DEP_LINK = 16'h0000,
  parameter [31:0] PF3_SRIOV_SUPPORTED_PAGE_SIZE = 32'h00000000,
  parameter [15:0] PF3_SRIOV_VF_DEVICE_ID = 16'h0000,
  parameter [15:0] PF3_SUBSYSTEM_ID = 16'h0000,
  parameter PF3_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter PF3_TPHR_CAP_ENABLE = "FALSE",
  parameter PF3_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] PF3_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] PF3_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] PF3_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] PF3_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] PF3_TPHR_CAP_VER = 4'h1,
  parameter PL_DISABLE_AUTO_EQ_SPEED_CHANGE_TO_GEN3 = "FALSE",
  parameter PL_DISABLE_AUTO_SPEED_CHANGE_TO_GEN2 = "FALSE",
  parameter PL_DISABLE_EI_INFER_IN_L0 = "FALSE",
  parameter PL_DISABLE_GEN3_DC_BALANCE = "FALSE",
  parameter PL_DISABLE_GEN3_LFSR_UPDATE_ON_SKP = "FALSE",
  parameter PL_DISABLE_RETRAIN_ON_FRAMING_ERROR = "FALSE",
  parameter PL_DISABLE_SCRAMBLING = "FALSE",
  parameter PL_DISABLE_SYNC_HEADER_FRAMING_ERROR = "FALSE",
  parameter PL_DISABLE_UPCONFIG_CAPABLE = "FALSE",
  parameter PL_EQ_ADAPT_DISABLE_COEFF_CHECK = "FALSE",
  parameter PL_EQ_ADAPT_DISABLE_PRESET_CHECK = "FALSE",
  parameter [4:0] PL_EQ_ADAPT_ITER_COUNT = 5'h02,
  parameter [1:0] PL_EQ_ADAPT_REJECT_RETRY_COUNT = 2'h1,
  parameter PL_EQ_BYPASS_PHASE23 = "FALSE",
  parameter [2:0] PL_EQ_DEFAULT_GEN3_RX_PRESET_HINT = 3'h3,
  parameter [3:0] PL_EQ_DEFAULT_GEN3_TX_PRESET = 4'h4,
  parameter PL_EQ_PHASE01_RX_ADAPT = "FALSE",
  parameter PL_EQ_SHORT_ADAPT_PHASE = "FALSE",
  parameter [15:0] PL_LANE0_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE1_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE2_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE3_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE4_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE5_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE6_EQ_CONTROL = 16'h3400,
  parameter [15:0] PL_LANE7_EQ_CONTROL = 16'h3400,
  parameter [2:0] PL_LINK_CAP_MAX_LINK_SPEED = 3'h4,
  parameter [3:0] PL_LINK_CAP_MAX_LINK_WIDTH = 4'h8,
  parameter integer PL_N_FTS_COMCLK_GEN1 = 255,
  parameter integer PL_N_FTS_COMCLK_GEN2 = 255,
  parameter integer PL_N_FTS_COMCLK_GEN3 = 255,
  parameter integer PL_N_FTS_GEN1 = 255,
  parameter integer PL_N_FTS_GEN2 = 255,
  parameter integer PL_N_FTS_GEN3 = 255,
  parameter PL_REPORT_ALL_PHY_ERRORS = "TRUE",
  parameter PL_SIM_FAST_LINK_TRAINING = "TRUE",
  parameter PL_UPSTREAM_FACING = "TRUE",
  parameter [15:0] PM_ASPML0S_TIMEOUT = 16'h05dc,
  parameter [19:0] PM_ASPML1_ENTRY_DELAY = 20'h00000,
  parameter PM_ENABLE_L23_ENTRY = "FALSE",
  parameter PM_ENABLE_SLOT_POWER_CAPTURE = "TRUE",
  parameter [31:0] PM_L1_REENTRY_DELAY = 32'h00000000,
  parameter [19:0] PM_PME_SERVICE_TIMEOUT_DELAY = 20'h186a0,
  parameter [15:0] PM_PME_TURNOFF_ACK_DELAY = 16'h0064,
  parameter SIM_JTAG_IDCODE = 32'h00000000,
  parameter SIM_VERSION = "1.0",
  parameter integer SPARE_BIT0 = 0,
  parameter integer SPARE_BIT1 = 0,
  parameter integer SPARE_BIT2 = 0,
  parameter integer SPARE_BIT3 = 0,
  parameter integer SPARE_BIT4 = 0,
  parameter integer SPARE_BIT5 = 0,
  parameter integer SPARE_BIT6 = 0,
  parameter integer SPARE_BIT7 = 0,
  parameter integer SPARE_BIT8 = 0,
  parameter [7:0] SPARE_BYTE0 = 8'h00,
  parameter [7:0] SPARE_BYTE1 = 8'h00,
  parameter [7:0] SPARE_BYTE2 = 8'h00,
  parameter [7:0] SPARE_BYTE3 = 8'h00,
  parameter [31:0] SPARE_WORD0 = 32'h00000000,
  parameter [31:0] SPARE_WORD1 = 32'h00000000,
  parameter [31:0] SPARE_WORD2 = 32'h00000000,
  parameter [31:0] SPARE_WORD3 = 32'h00000000,
  parameter SRIOV_CAP_ENABLE = "FALSE",
  parameter TL_COMPLETION_RAM_SIZE_16K = "TRUE",
  parameter [23:0] TL_COMPL_TIMEOUT_REG0 = 24'hbebc20,
  parameter [27:0] TL_COMPL_TIMEOUT_REG1 = 28'h2faf080,
  parameter [11:0] TL_CREDITS_CD = 12'h3e0,
  parameter [7:0] TL_CREDITS_CH = 8'h20,
  parameter [11:0] TL_CREDITS_NPD = 12'h028,
  parameter [7:0] TL_CREDITS_NPH = 8'h20,
  parameter [11:0] TL_CREDITS_PD = 12'h198,
  parameter [7:0] TL_CREDITS_PH = 8'h20,
  parameter TL_ENABLE_MESSAGE_RID_CHECK_ENABLE = "TRUE",
  parameter TL_EXTENDED_CFG_EXTEND_INTERFACE_ENABLE = "FALSE",
  parameter TL_LEGACY_CFG_EXTEND_INTERFACE_ENABLE = "FALSE",
  parameter TL_LEGACY_MODE_ENABLE = "FALSE",
  parameter [1:0] TL_PF_ENABLE_REG = 2'h0,
  parameter TL_TX_MUX_STRICT_PRIORITY = "TRUE",
  parameter TWO_LAYER_MODE_DLCMSM_ENABLE = "TRUE",
  parameter TWO_LAYER_MODE_ENABLE = "FALSE",
  parameter TWO_LAYER_MODE_WIDTH_256 = "TRUE",
  parameter [11:0] VF0_ARI_CAP_NEXTPTR = 12'h000,
  parameter [7:0] VF0_CAPABILITY_POINTER = 8'h50,
  parameter integer VF0_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF0_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF0_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF0_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF0_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF0_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF0_PM_CAP_ID = 8'h01,
  parameter [7:0] VF0_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF0_PM_CAP_VER_ID = 3'h3,
  parameter VF0_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF0_TPHR_CAP_ENABLE = "FALSE",
  parameter VF0_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF0_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF0_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF0_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF0_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF0_TPHR_CAP_VER = 4'h1,
  parameter [11:0] VF1_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF1_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF1_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF1_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF1_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF1_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF1_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF1_PM_CAP_ID = 8'h01,
  parameter [7:0] VF1_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF1_PM_CAP_VER_ID = 3'h3,
  parameter VF1_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF1_TPHR_CAP_ENABLE = "FALSE",
  parameter VF1_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF1_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF1_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF1_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF1_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF1_TPHR_CAP_VER = 4'h1,
  parameter [11:0] VF2_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF2_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF2_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF2_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF2_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF2_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF2_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF2_PM_CAP_ID = 8'h01,
  parameter [7:0] VF2_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF2_PM_CAP_VER_ID = 3'h3,
  parameter VF2_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF2_TPHR_CAP_ENABLE = "FALSE",
  parameter VF2_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF2_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF2_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF2_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF2_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF2_TPHR_CAP_VER = 4'h1,
  parameter [11:0] VF3_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF3_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF3_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF3_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF3_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF3_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF3_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF3_PM_CAP_ID = 8'h01,
  parameter [7:0] VF3_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF3_PM_CAP_VER_ID = 3'h3,
  parameter VF3_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF3_TPHR_CAP_ENABLE = "FALSE",
  parameter VF3_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF3_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF3_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF3_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF3_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF3_TPHR_CAP_VER = 4'h1,
  parameter [11:0] VF4_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF4_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF4_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF4_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF4_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF4_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF4_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF4_PM_CAP_ID = 8'h01,
  parameter [7:0] VF4_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF4_PM_CAP_VER_ID = 3'h3,
  parameter VF4_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF4_TPHR_CAP_ENABLE = "FALSE",
  parameter VF4_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF4_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF4_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF4_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF4_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF4_TPHR_CAP_VER = 4'h1,
  parameter [11:0] VF5_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF5_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF5_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF5_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF5_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF5_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF5_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF5_PM_CAP_ID = 8'h01,
  parameter [7:0] VF5_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF5_PM_CAP_VER_ID = 3'h3,
  parameter VF5_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF5_TPHR_CAP_ENABLE = "FALSE",
  parameter VF5_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF5_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF5_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF5_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF5_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF5_TPHR_CAP_VER = 4'h1,
  parameter [11:0] VF6_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF6_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF6_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF6_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF6_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF6_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF6_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF6_PM_CAP_ID = 8'h01,
  parameter [7:0] VF6_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF6_PM_CAP_VER_ID = 3'h3,
  parameter VF6_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF6_TPHR_CAP_ENABLE = "FALSE",
  parameter VF6_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF6_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF6_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF6_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF6_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF6_TPHR_CAP_VER = 4'h1,
  parameter [11:0] VF7_ARI_CAP_NEXTPTR = 12'h000,
  parameter integer VF7_MSI_CAP_MULTIMSGCAP = 0,
  parameter integer VF7_MSIX_CAP_PBA_BIR = 0,
  parameter [28:0] VF7_MSIX_CAP_PBA_OFFSET = 29'h00000050,
  parameter integer VF7_MSIX_CAP_TABLE_BIR = 0,
  parameter [28:0] VF7_MSIX_CAP_TABLE_OFFSET = 29'h00000040,
  parameter [10:0] VF7_MSIX_CAP_TABLE_SIZE = 11'h000,
  parameter [7:0] VF7_PM_CAP_ID = 8'h01,
  parameter [7:0] VF7_PM_CAP_NEXTPTR = 8'h00,
  parameter [2:0] VF7_PM_CAP_VER_ID = 3'h3,
  parameter VF7_TPHR_CAP_DEV_SPECIFIC_MODE = "TRUE",
  parameter VF7_TPHR_CAP_ENABLE = "FALSE",
  parameter VF7_TPHR_CAP_INT_VEC_MODE = "TRUE",
  parameter [11:0] VF7_TPHR_CAP_NEXTPTR = 12'h000,
  parameter [2:0] VF7_TPHR_CAP_ST_MODE_SEL = 3'h0,
  parameter [1:0] VF7_TPHR_CAP_ST_TABLE_LOC = 2'h0,
  parameter [10:0] VF7_TPHR_CAP_ST_TABLE_SIZE = 11'h000,
  parameter [3:0] VF7_TPHR_CAP_VER = 4'h1
  ) (
  input  wire         CFGCONFIGSPACEENABLE,
  input  wire  [15:0] CFGDEVID,
  input  wire   [7:0] CFGDSBUSNUMBER,
  input  wire   [4:0] CFGDSDEVICENUMBER,
  input  wire   [2:0] CFGDSFUNCTIONNUMBER,
  input  wire  [63:0] CFGDSN,
  input  wire   [7:0] CFGDSPORTNUMBER,
  input  wire         CFGERRCORIN,
  input  wire         CFGERRUNCORIN,
  input  wire  [31:0] CFGEXTREADDATA,
  input  wire         CFGEXTREADDATAVALID,
  input  wire   [2:0] CFGFCSEL,
  input  wire   [3:0] CFGFLRDONE,
  input  wire         CFGHOTRESETIN,
  input  wire   [3:0] CFGINTERRUPTINT,
  input  wire   [2:0] CFGINTERRUPTMSIATTR,
  input  wire   [3:0] CFGINTERRUPTMSIFUNCTIONNUMBER,
  input  wire  [31:0] CFGINTERRUPTMSIINT,
  input  wire  [31:0] CFGINTERRUPTMSIPENDINGSTATUS,
  input  wire         CFGINTERRUPTMSIPENDINGSTATUSDATAENABLE,
  input  wire   [3:0] CFGINTERRUPTMSIPENDINGSTATUSFUNCTIONNUM,
  input  wire   [3:0] CFGINTERRUPTMSISELECT,
  input  wire         CFGINTERRUPTMSITPHPRESENT,
  input  wire   [8:0] CFGINTERRUPTMSITPHSTTAG,
  input  wire   [1:0] CFGINTERRUPTMSITPHTYPE,
  input  wire  [63:0] CFGINTERRUPTMSIXADDRESS,
  input  wire  [31:0] CFGINTERRUPTMSIXDATA,
  input  wire         CFGINTERRUPTMSIXINT,
  input  wire   [3:0] CFGINTERRUPTPENDING,
  input  wire         CFGLINKTRAININGENABLE,
  input  wire  [18:0] CFGMGMTADDR,
  input  wire   [3:0] CFGMGMTBYTEENABLE,
  input  wire         CFGMGMTREAD,
  input  wire         CFGMGMTTYPE1CFGREGACCESS,
  input  wire         CFGMGMTWRITE,
  input  wire  [31:0] CFGMGMTWRITEDATA,
  input  wire         CFGMSGTRANSMIT,
  input  wire  [31:0] CFGMSGTRANSMITDATA,
  input  wire   [2:0] CFGMSGTRANSMITTYPE,
  input  wire   [2:0] CFGPERFUNCSTATUSCONTROL,
  input  wire   [3:0] CFGPERFUNCTIONNUMBER,
  input  wire         CFGPERFUNCTIONOUTPUTREQUEST,
  input  wire         CFGPOWERSTATECHANGEACK,
  input  wire         CFGREQPMTRANSITIONL23READY,
  input  wire   [7:0] CFGREVID,
  input  wire  [15:0] CFGSUBSYSID,
  input  wire  [15:0] CFGSUBSYSVENDID,
  input  wire  [31:0] CFGTPHSTTREADDATA,
  input  wire         CFGTPHSTTREADDATAVALID,
  input  wire  [15:0] CFGVENDID,
  input  wire   [7:0] CFGVFFLRDONE,
  input  wire         CONFMCAPREQUESTBYCONF,
  input  wire  [31:0] CONFREQDATA,
  input  wire   [3:0] CONFREQREGNUM,
  input  wire   [1:0] CONFREQTYPE,
  input  wire         CONFREQVALID,
  input  wire         CORECLK,
  input  wire         CORECLKMICOMPLETIONRAML,
  input  wire         CORECLKMICOMPLETIONRAMU,
  input  wire         CORECLKMIREPLAYRAM,
  input  wire         CORECLKMIREQUESTRAM,
  input  wire         DBGCFGLOCALMGMTREGOVERRIDE,
  input  wire   [3:0] DBGDATASEL,
  input  wire   [9:0] DRPADDR,
  input  wire         DRPCLK,
  input  wire  [15:0] DRPDI,
  input  wire         DRPEN,
  input  wire         DRPWE,
  input  wire  [13:0] LL2LMSAXISTXTUSER,
  input  wire         LL2LMSAXISTXTVALID,
  input  wire   [3:0] LL2LMTXTLPID0,
  input  wire   [3:0] LL2LMTXTLPID1,
  input  wire  [21:0] MAXISCQTREADY,
  input  wire  [21:0] MAXISRCTREADY,
  input  wire         MCAPCLK,
  input  wire         MCAPPERST0B,
  input  wire         MCAPPERST1B,
  input  wire         MGMTRESETN,
  input  wire         MGMTSTICKYRESETN,
  input  wire         PCIECQNPREQ,
  input  wire         PIPECLK,
  input  wire   [5:0] PIPEEQFS,
  input  wire   [5:0] PIPEEQLF,
  input  wire         PIPERESETN,
  input  wire   [1:0] PIPERX0CHARISK,
  input  wire  [31:0] PIPERX0DATA,
  input  wire         PIPERX0DATAVALID,
  input  wire         PIPERX0ELECIDLE,
  input  wire         PIPERX0EQDONE,
  input  wire         PIPERX0EQLPADAPTDONE,
  input  wire         PIPERX0EQLPLFFSSEL,
  input  wire  [17:0] PIPERX0EQLPNEWTXCOEFFORPRESET,
  input  wire         PIPERX0PHYSTATUS,
  input  wire         PIPERX0STARTBLOCK,
  input  wire   [2:0] PIPERX0STATUS,
  input  wire   [1:0] PIPERX0SYNCHEADER,
  input  wire         PIPERX0VALID,
  input  wire   [1:0] PIPERX1CHARISK,
  input  wire  [31:0] PIPERX1DATA,
  input  wire         PIPERX1DATAVALID,
  input  wire         PIPERX1ELECIDLE,
  input  wire         PIPERX1EQDONE,
  input  wire         PIPERX1EQLPADAPTDONE,
  input  wire         PIPERX1EQLPLFFSSEL,
  input  wire  [17:0] PIPERX1EQLPNEWTXCOEFFORPRESET,
  input  wire         PIPERX1PHYSTATUS,
  input  wire         PIPERX1STARTBLOCK,
  input  wire   [2:0] PIPERX1STATUS,
  input  wire   [1:0] PIPERX1SYNCHEADER,
  input  wire         PIPERX1VALID,
  input  wire   [1:0] PIPERX2CHARISK,
  input  wire  [31:0] PIPERX2DATA,
  input  wire         PIPERX2DATAVALID,
  input  wire         PIPERX2ELECIDLE,
  input  wire         PIPERX2EQDONE,
  input  wire         PIPERX2EQLPADAPTDONE,
  input  wire         PIPERX2EQLPLFFSSEL,
  input  wire  [17:0] PIPERX2EQLPNEWTXCOEFFORPRESET,
  input  wire         PIPERX2PHYSTATUS,
  input  wire         PIPERX2STARTBLOCK,
  input  wire   [2:0] PIPERX2STATUS,
  input  wire   [1:0] PIPERX2SYNCHEADER,
  input  wire         PIPERX2VALID,
  input  wire   [1:0] PIPERX3CHARISK,
  input  wire  [31:0] PIPERX3DATA,
  input  wire         PIPERX3DATAVALID,
  input  wire         PIPERX3ELECIDLE,
  input  wire         PIPERX3EQDONE,
  input  wire         PIPERX3EQLPADAPTDONE,
  input  wire         PIPERX3EQLPLFFSSEL,
  input  wire  [17:0] PIPERX3EQLPNEWTXCOEFFORPRESET,
  input  wire         PIPERX3PHYSTATUS,
  input  wire         PIPERX3STARTBLOCK,
  input  wire   [2:0] PIPERX3STATUS,
  input  wire   [1:0] PIPERX3SYNCHEADER,
  input  wire         PIPERX3VALID,
  input  wire   [1:0] PIPERX4CHARISK,
  input  wire  [31:0] PIPERX4DATA,
  input  wire         PIPERX4DATAVALID,
  input  wire         PIPERX4ELECIDLE,
  input  wire         PIPERX4EQDONE,
  input  wire         PIPERX4EQLPADAPTDONE,
  input  wire         PIPERX4EQLPLFFSSEL,
  input  wire  [17:0] PIPERX4EQLPNEWTXCOEFFORPRESET,
  input  wire         PIPERX4PHYSTATUS,
  input  wire         PIPERX4STARTBLOCK,
  input  wire   [2:0] PIPERX4STATUS,
  input  wire   [1:0] PIPERX4SYNCHEADER,
  input  wire         PIPERX4VALID,
  input  wire   [1:0] PIPERX5CHARISK,
  input  wire  [31:0] PIPERX5DATA,
  input  wire         PIPERX5DATAVALID,
  input  wire         PIPERX5ELECIDLE,
  input  wire         PIPERX5EQDONE,
  input  wire         PIPERX5EQLPADAPTDONE,
  input  wire         PIPERX5EQLPLFFSSEL,
  input  wire  [17:0] PIPERX5EQLPNEWTXCOEFFORPRESET,
  input  wire         PIPERX5PHYSTATUS,
  input  wire         PIPERX5STARTBLOCK,
  input  wire   [2:0] PIPERX5STATUS,
  input  wire   [1:0] PIPERX5SYNCHEADER,
  input  wire         PIPERX5VALID,
  input  wire   [1:0] PIPERX6CHARISK,
  input  wire  [31:0] PIPERX6DATA,
  input  wire         PIPERX6DATAVALID,
  input  wire         PIPERX6ELECIDLE,
  input  wire         PIPERX6EQDONE,
  input  wire         PIPERX6EQLPADAPTDONE,
  input  wire         PIPERX6EQLPLFFSSEL,
  input  wire  [17:0] PIPERX6EQLPNEWTXCOEFFORPRESET,
  input  wire         PIPERX6PHYSTATUS,
  input  wire         PIPERX6STARTBLOCK,
  input  wire   [2:0] PIPERX6STATUS,
  input  wire   [1:0] PIPERX6SYNCHEADER,
  input  wire         PIPERX6VALID,
  input  wire   [1:0] PIPERX7CHARISK,
  input  wire  [31:0] PIPERX7DATA,
  input  wire         PIPERX7DATAVALID,
  input  wire         PIPERX7ELECIDLE,
  input  wire         PIPERX7EQDONE,
  input  wire         PIPERX7EQLPADAPTDONE,
  input  wire         PIPERX7EQLPLFFSSEL,
  input  wire  [17:0] PIPERX7EQLPNEWTXCOEFFORPRESET,
  input  wire         PIPERX7PHYSTATUS,
  input  wire         PIPERX7STARTBLOCK,
  input  wire   [2:0] PIPERX7STATUS,
  input  wire   [1:0] PIPERX7SYNCHEADER,
  input  wire         PIPERX7VALID,
  input  wire  [17:0] PIPETX0EQCOEFF,
  input  wire         PIPETX0EQDONE,
  input  wire  [17:0] PIPETX1EQCOEFF,
  input  wire         PIPETX1EQDONE,
  input  wire  [17:0] PIPETX2EQCOEFF,
  input  wire         PIPETX2EQDONE,
  input  wire  [17:0] PIPETX3EQCOEFF,
  input  wire         PIPETX3EQDONE,
  input  wire  [17:0] PIPETX4EQCOEFF,
  input  wire         PIPETX4EQDONE,
  input  wire  [17:0] PIPETX5EQCOEFF,
  input  wire         PIPETX5EQDONE,
  input  wire  [17:0] PIPETX6EQCOEFF,
  input  wire         PIPETX6EQDONE,
  input  wire  [17:0] PIPETX7EQCOEFF,
  input  wire         PIPETX7EQDONE,
  input  wire         PLEQRESETEIEOSCOUNT,
  input  wire         PLGEN2UPSTREAMPREFERDEEMPH,
  input  wire         RESETN,
  input  wire [255:0] SAXISCCTDATA,
  input  wire   [7:0] SAXISCCTKEEP,
  input  wire         SAXISCCTLAST,
  input  wire  [32:0] SAXISCCTUSER,
  input  wire         SAXISCCTVALID,
  input  wire [255:0] SAXISRQTDATA,
  input  wire   [7:0] SAXISRQTKEEP,
  input  wire         SAXISRQTLAST,
  input  wire  [59:0] SAXISRQTUSER,
  input  wire         SAXISRQTVALID,
  input  wire  [31:0] SPAREIN,
  input  wire         USERCLK,
  output wire   [2:0] CFGCURRENTSPEED,
  output wire   [3:0] CFGDPASUBSTATECHANGE,
  output wire         CFGERRCOROUT,
  output wire         CFGERRFATALOUT,
  output wire         CFGERRNONFATALOUT,
  output wire   [7:0] CFGEXTFUNCTIONNUMBER,
  output wire         CFGEXTREADRECEIVED,
  output wire   [9:0] CFGEXTREGISTERNUMBER,
  output wire   [3:0] CFGEXTWRITEBYTEENABLE,
  output wire  [31:0] CFGEXTWRITEDATA,
  output wire         CFGEXTWRITERECEIVED,
  output wire  [11:0] CFGFCCPLD,
  output wire   [7:0] CFGFCCPLH,
  output wire  [11:0] CFGFCNPD,
  output wire   [7:0] CFGFCNPH,
  output wire  [11:0] CFGFCPD,
  output wire   [7:0] CFGFCPH,
  output wire   [3:0] CFGFLRINPROCESS,
  output wire  [11:0] CFGFUNCTIONPOWERSTATE,
  output wire  [15:0] CFGFUNCTIONSTATUS,
  output wire         CFGHOTRESETOUT,
  output wire  [31:0] CFGINTERRUPTMSIDATA,
  output wire   [3:0] CFGINTERRUPTMSIENABLE,
  output wire         CFGINTERRUPTMSIFAIL,
  output wire         CFGINTERRUPTMSIMASKUPDATE,
  output wire  [11:0] CFGINTERRUPTMSIMMENABLE,
  output wire         CFGINTERRUPTMSISENT,
  output wire   [7:0] CFGINTERRUPTMSIVFENABLE,
  output wire   [3:0] CFGINTERRUPTMSIXENABLE,
  output wire         CFGINTERRUPTMSIXFAIL,
  output wire   [3:0] CFGINTERRUPTMSIXMASK,
  output wire         CFGINTERRUPTMSIXSENT,
  output wire   [7:0] CFGINTERRUPTMSIXVFENABLE,
  output wire   [7:0] CFGINTERRUPTMSIXVFMASK,
  output wire         CFGINTERRUPTSENT,
  output wire   [1:0] CFGLINKPOWERSTATE,
  output wire         CFGLOCALERROR,
  output wire         CFGLTRENABLE,
  output wire   [5:0] CFGLTSSMSTATE,
  output wire   [2:0] CFGMAXPAYLOAD,
  output wire   [2:0] CFGMAXREADREQ,
  output wire  [31:0] CFGMGMTREADDATA,
  output wire         CFGMGMTREADWRITEDONE,
  output wire         CFGMSGRECEIVED,
  output wire   [7:0] CFGMSGRECEIVEDDATA,
  output wire   [4:0] CFGMSGRECEIVEDTYPE,
  output wire         CFGMSGTRANSMITDONE,
  output wire   [3:0] CFGNEGOTIATEDWIDTH,
  output wire   [1:0] CFGOBFFENABLE,
  output wire  [15:0] CFGPERFUNCSTATUSDATA,
  output wire         CFGPERFUNCTIONUPDATEDONE,
  output wire         CFGPHYLINKDOWN,
  output wire   [1:0] CFGPHYLINKSTATUS,
  output wire         CFGPLSTATUSCHANGE,
  output wire         CFGPOWERSTATECHANGEINTERRUPT,
  output wire   [3:0] CFGRCBSTATUS,
  output wire   [3:0] CFGTPHFUNCTIONNUM,
  output wire   [3:0] CFGTPHREQUESTERENABLE,
  output wire  [11:0] CFGTPHSTMODE,
  output wire   [4:0] CFGTPHSTTADDRESS,
  output wire         CFGTPHSTTREADENABLE,
  output wire   [3:0] CFGTPHSTTWRITEBYTEVALID,
  output wire  [31:0] CFGTPHSTTWRITEDATA,
  output wire         CFGTPHSTTWRITEENABLE,
  output wire   [7:0] CFGVFFLRINPROCESS,
  output wire  [23:0] CFGVFPOWERSTATE,
  output wire  [15:0] CFGVFSTATUS,
  output wire   [7:0] CFGVFTPHREQUESTERENABLE,
  output wire  [23:0] CFGVFTPHSTMODE,
  output wire         CONFMCAPDESIGNSWITCH,
  output wire         CONFMCAPEOS,
  output wire         CONFMCAPINUSEBYPCIE,
  output wire         CONFREQREADY,
  output wire  [31:0] CONFRESPRDATA,
  output wire         CONFRESPVALID,
  output wire  [15:0] DBGDATAOUT,
  output wire         DBGMCAPCSB,
  output wire  [31:0] DBGMCAPDATA,
  output wire         DBGMCAPEOS,
  output wire         DBGMCAPERROR,
  output wire         DBGMCAPMODE,
  output wire         DBGMCAPRDATAVALID,
  output wire         DBGMCAPRDWRB,
  output wire         DBGMCAPRESET,
  output wire         DBGPLDATABLOCKRECEIVEDAFTEREDS,
  output wire         DBGPLGEN3FRAMINGERRORDETECTED,
  output wire         DBGPLGEN3SYNCHEADERERRORDETECTED,
  output wire   [7:0] DBGPLINFERREDRXELECTRICALIDLE,
  output wire  [15:0] DRPDO,
  output wire         DRPRDY,
  output wire   [3:0] LL2LMMASTERTLPSENTTLPID0,
  output wire   [3:0] LL2LMMASTERTLPSENTTLPID1,
  output wire         LL2LMMASTERTLPSENT0,
  output wire         LL2LMMASTERTLPSENT1,
  output wire [255:0] LL2LMMAXISRXTDATA,
  output wire  [17:0] LL2LMMAXISRXTUSER,
  output wire   [7:0] LL2LMMAXISRXTVALID,
  output wire   [7:0] LL2LMSAXISTXTREADY,
  output wire [255:0] MAXISCQTDATA,
  output wire   [7:0] MAXISCQTKEEP,
  output wire         MAXISCQTLAST,
  output wire  [84:0] MAXISCQTUSER,
  output wire         MAXISCQTVALID,
  output wire [255:0] MAXISRCTDATA,
  output wire   [7:0] MAXISRCTKEEP,
  output wire         MAXISRCTLAST,
  output wire  [74:0] MAXISRCTUSER,
  output wire         MAXISRCTVALID,
  output wire   [5:0] PCIECQNPREQCOUNT,
  output wire         PCIEPERST0B,
  output wire         PCIEPERST1B,
  output wire   [3:0] PCIERQSEQNUM,
  output wire         PCIERQSEQNUMVLD,
  output wire   [5:0] PCIERQTAG,
  output wire   [1:0] PCIERQTAGAV,
  output wire         PCIERQTAGVLD,
  output wire   [1:0] PCIETFCNPDAV,
  output wire   [1:0] PCIETFCNPHAV,
  output wire   [1:0] PIPERX0EQCONTROL,
  output wire   [5:0] PIPERX0EQLPLFFS,
  output wire   [3:0] PIPERX0EQLPTXPRESET,
  output wire   [2:0] PIPERX0EQPRESET,
  output wire         PIPERX0POLARITY,
  output wire   [1:0] PIPERX1EQCONTROL,
  output wire   [5:0] PIPERX1EQLPLFFS,
  output wire   [3:0] PIPERX1EQLPTXPRESET,
  output wire   [2:0] PIPERX1EQPRESET,
  output wire         PIPERX1POLARITY,
  output wire   [1:0] PIPERX2EQCONTROL,
  output wire   [5:0] PIPERX2EQLPLFFS,
  output wire   [3:0] PIPERX2EQLPTXPRESET,
  output wire   [2:0] PIPERX2EQPRESET,
  output wire         PIPERX2POLARITY,
  output wire   [1:0] PIPERX3EQCONTROL,
  output wire   [5:0] PIPERX3EQLPLFFS,
  output wire   [3:0] PIPERX3EQLPTXPRESET,
  output wire   [2:0] PIPERX3EQPRESET,
  output wire         PIPERX3POLARITY,
  output wire   [1:0] PIPERX4EQCONTROL,
  output wire   [5:0] PIPERX4EQLPLFFS,
  output wire   [3:0] PIPERX4EQLPTXPRESET,
  output wire   [2:0] PIPERX4EQPRESET,
  output wire         PIPERX4POLARITY,
  output wire   [1:0] PIPERX5EQCONTROL,
  output wire   [5:0] PIPERX5EQLPLFFS,
  output wire   [3:0] PIPERX5EQLPTXPRESET,
  output wire   [2:0] PIPERX5EQPRESET,
  output wire         PIPERX5POLARITY,
  output wire   [1:0] PIPERX6EQCONTROL,
  output wire   [5:0] PIPERX6EQLPLFFS,
  output wire   [3:0] PIPERX6EQLPTXPRESET,
  output wire   [2:0] PIPERX6EQPRESET,
  output wire         PIPERX6POLARITY,
  output wire   [1:0] PIPERX7EQCONTROL,
  output wire   [5:0] PIPERX7EQLPLFFS,
  output wire   [3:0] PIPERX7EQLPTXPRESET,
  output wire   [2:0] PIPERX7EQPRESET,
  output wire         PIPERX7POLARITY,
  output wire   [1:0] PIPETX0CHARISK,
  output wire         PIPETX0COMPLIANCE,
  output wire  [31:0] PIPETX0DATA,
  output wire         PIPETX0DATAVALID,
  output wire         PIPETX0DEEMPH,
  output wire         PIPETX0ELECIDLE,
  output wire   [1:0] PIPETX0EQCONTROL,
  output wire   [5:0] PIPETX0EQDEEMPH,
  output wire   [3:0] PIPETX0EQPRESET,
  output wire   [2:0] PIPETX0MARGIN,
  output wire   [1:0] PIPETX0POWERDOWN,
  output wire   [1:0] PIPETX0RATE,
  output wire         PIPETX0RCVRDET,
  output wire         PIPETX0RESET,
  output wire         PIPETX0STARTBLOCK,
  output wire         PIPETX0SWING,
  output wire   [1:0] PIPETX0SYNCHEADER,
  output wire   [1:0] PIPETX1CHARISK,
  output wire         PIPETX1COMPLIANCE,
  output wire  [31:0] PIPETX1DATA,
  output wire         PIPETX1DATAVALID,
  output wire         PIPETX1DEEMPH,
  output wire         PIPETX1ELECIDLE,
  output wire   [1:0] PIPETX1EQCONTROL,
  output wire   [5:0] PIPETX1EQDEEMPH,
  output wire   [3:0] PIPETX1EQPRESET,
  output wire   [2:0] PIPETX1MARGIN,
  output wire   [1:0] PIPETX1POWERDOWN,
  output wire   [1:0] PIPETX1RATE,
  output wire         PIPETX1RCVRDET,
  output wire         PIPETX1RESET,
  output wire         PIPETX1STARTBLOCK,
  output wire         PIPETX1SWING,
  output wire   [1:0] PIPETX1SYNCHEADER,
  output wire   [1:0] PIPETX2CHARISK,
  output wire         PIPETX2COMPLIANCE,
  output wire  [31:0] PIPETX2DATA,
  output wire         PIPETX2DATAVALID,
  output wire         PIPETX2DEEMPH,
  output wire         PIPETX2ELECIDLE,
  output wire   [1:0] PIPETX2EQCONTROL,
  output wire   [5:0] PIPETX2EQDEEMPH,
  output wire   [3:0] PIPETX2EQPRESET,
  output wire   [2:0] PIPETX2MARGIN,
  output wire   [1:0] PIPETX2POWERDOWN,
  output wire   [1:0] PIPETX2RATE,
  output wire         PIPETX2RCVRDET,
  output wire         PIPETX2RESET,
  output wire         PIPETX2STARTBLOCK,
  output wire         PIPETX2SWING,
  output wire   [1:0] PIPETX2SYNCHEADER,
  output wire   [1:0] PIPETX3CHARISK,
  output wire         PIPETX3COMPLIANCE,
  output wire  [31:0] PIPETX3DATA,
  output wire         PIPETX3DATAVALID,
  output wire         PIPETX3DEEMPH,
  output wire         PIPETX3ELECIDLE,
  output wire   [1:0] PIPETX3EQCONTROL,
  output wire   [5:0] PIPETX3EQDEEMPH,
  output wire   [3:0] PIPETX3EQPRESET,
  output wire   [2:0] PIPETX3MARGIN,
  output wire   [1:0] PIPETX3POWERDOWN,
  output wire   [1:0] PIPETX3RATE,
  output wire         PIPETX3RCVRDET,
  output wire         PIPETX3RESET,
  output wire         PIPETX3STARTBLOCK,
  output wire         PIPETX3SWING,
  output wire   [1:0] PIPETX3SYNCHEADER,
  output wire   [1:0] PIPETX4CHARISK,
  output wire         PIPETX4COMPLIANCE,
  output wire  [31:0] PIPETX4DATA,
  output wire         PIPETX4DATAVALID,
  output wire         PIPETX4DEEMPH,
  output wire         PIPETX4ELECIDLE,
  output wire   [1:0] PIPETX4EQCONTROL,
  output wire   [5:0] PIPETX4EQDEEMPH,
  output wire   [3:0] PIPETX4EQPRESET,
  output wire   [2:0] PIPETX4MARGIN,
  output wire   [1:0] PIPETX4POWERDOWN,
  output wire   [1:0] PIPETX4RATE,
  output wire         PIPETX4RCVRDET,
  output wire         PIPETX4RESET,
  output wire         PIPETX4STARTBLOCK,
  output wire         PIPETX4SWING,
  output wire   [1:0] PIPETX4SYNCHEADER,
  output wire   [1:0] PIPETX5CHARISK,
  output wire         PIPETX5COMPLIANCE,
  output wire  [31:0] PIPETX5DATA,
  output wire         PIPETX5DATAVALID,
  output wire         PIPETX5DEEMPH,
  output wire         PIPETX5ELECIDLE,
  output wire   [1:0] PIPETX5EQCONTROL,
  output wire   [5:0] PIPETX5EQDEEMPH,
  output wire   [3:0] PIPETX5EQPRESET,
  output wire   [2:0] PIPETX5MARGIN,
  output wire   [1:0] PIPETX5POWERDOWN,
  output wire   [1:0] PIPETX5RATE,
  output wire         PIPETX5RCVRDET,
  output wire         PIPETX5RESET,
  output wire         PIPETX5STARTBLOCK,
  output wire         PIPETX5SWING,
  output wire   [1:0] PIPETX5SYNCHEADER,
  output wire   [1:0] PIPETX6CHARISK,
  output wire         PIPETX6COMPLIANCE,
  output wire  [31:0] PIPETX6DATA,
  output wire         PIPETX6DATAVALID,
  output wire         PIPETX6DEEMPH,
  output wire         PIPETX6ELECIDLE,
  output wire   [1:0] PIPETX6EQCONTROL,
  output wire   [5:0] PIPETX6EQDEEMPH,
  output wire   [3:0] PIPETX6EQPRESET,
  output wire   [2:0] PIPETX6MARGIN,
  output wire   [1:0] PIPETX6POWERDOWN,
  output wire   [1:0] PIPETX6RATE,
  output wire         PIPETX6RCVRDET,
  output wire         PIPETX6RESET,
  output wire         PIPETX6STARTBLOCK,
  output wire         PIPETX6SWING,
  output wire   [1:0] PIPETX6SYNCHEADER,
  output wire   [1:0] PIPETX7CHARISK,
  output wire         PIPETX7COMPLIANCE,
  output wire  [31:0] PIPETX7DATA,
  output wire         PIPETX7DATAVALID,
  output wire         PIPETX7DEEMPH,
  output wire         PIPETX7ELECIDLE,
  output wire   [1:0] PIPETX7EQCONTROL,
  output wire   [5:0] PIPETX7EQDEEMPH,
  output wire   [3:0] PIPETX7EQPRESET,
  output wire   [2:0] PIPETX7MARGIN,
  output wire   [1:0] PIPETX7POWERDOWN,
  output wire   [1:0] PIPETX7RATE,
  output wire         PIPETX7RCVRDET,
  output wire         PIPETX7RESET,
  output wire         PIPETX7STARTBLOCK,
  output wire         PIPETX7SWING,
  output wire   [1:0] PIPETX7SYNCHEADER,
  output wire         PLEQINPROGRESS,
  output wire   [1:0] PLEQPHASE,
  output wire   [3:0] SAXISCCTREADY,
  output wire   [3:0] SAXISRQTREADY,
  output wire  [31:0] SPAREOUT
  );

  wire        [143:0] MICOMPLETIONRAMREADDATA;
  wire        [143:0] MIREPLAYRAMREADDATA;
  wire        [143:0] MIREQUESTRAMREADDATA;
  wire          [9:0] MICOMPLETIONRAMREADADDRESSAL;
  wire          [9:0] MICOMPLETIONRAMREADADDRESSAU;
  wire          [9:0] MICOMPLETIONRAMREADADDRESSBL;
  wire          [9:0] MICOMPLETIONRAMREADADDRESSBU;
  wire          [3:0] MICOMPLETIONRAMREADENABLEL;
  wire          [3:0] MICOMPLETIONRAMREADENABLEU;
  wire          [9:0] MICOMPLETIONRAMWRITEADDRESSAL;
  wire          [9:0] MICOMPLETIONRAMWRITEADDRESSAU;
  wire          [9:0] MICOMPLETIONRAMWRITEADDRESSBL;
  wire          [9:0] MICOMPLETIONRAMWRITEADDRESSBU;
  wire         [71:0] MICOMPLETIONRAMWRITEDATAL;
  wire         [71:0] MICOMPLETIONRAMWRITEDATAU;
  wire          [3:0] MICOMPLETIONRAMWRITEENABLEL;
  wire          [3:0] MICOMPLETIONRAMWRITEENABLEU;
  wire          [8:0] MIREPLAYRAMADDRESS;
  wire          [1:0] MIREPLAYRAMREADENABLE;
  wire        [143:0] MIREPLAYRAMWRITEDATA;
  wire          [1:0] MIREPLAYRAMWRITEENABLE;
  wire          [8:0] MIREQUESTRAMREADADDRESSA;
  wire          [8:0] MIREQUESTRAMREADADDRESSB;
  wire          [3:0] MIREQUESTRAMREADENABLE;
  wire          [8:0] MIREQUESTRAMWRITEADDRESSA;
  wire          [8:0] MIREQUESTRAMWRITEADDRESSB;
  wire        [143:0] MIREQUESTRAMWRITEDATA;
  wire          [3:0] MIREQUESTRAMWRITEENABLE;
  wire        [143:0] micompletionramwritedata;
  wire         [15:0] mim_cpl_wdip;
  wire         [15:0] mim_rep_wdip;
  wire         [15:0] mim_req_wdip;
  wire         [15:0] mim_cpl_rdop;
  wire         [15:0] mim_rep_rdop;
  wire         [15:0] mim_req_rdop;
  wire        [127:0] mim_cpl_wdata;
  wire        [127:0] mim_rep_wdata;
  wire        [127:0] mim_req_wdata;
  wire        [127:0] mim_cpl_rdata;
  wire        [127:0] mim_rep_rdata;
  wire        [127:0] mim_req_rdata;

  assign MIREPLAYRAMREADDATA = {
    mim_rep_rdop[15], mim_rep_rdata[127:120], mim_rep_rdop[14], mim_rep_rdata[119:112],
    mim_rep_rdop[13], mim_rep_rdata[111:104], mim_rep_rdop[12], mim_rep_rdata[103:96],
    mim_rep_rdop[11], mim_rep_rdata[95:88], mim_rep_rdop[10], mim_rep_rdata[87:80],
    mim_rep_rdop[9], mim_rep_rdata[79:72], mim_rep_rdop[8], mim_rep_rdata[71:64],
    mim_rep_rdop[7], mim_rep_rdata[63:56], mim_rep_rdop[6], mim_rep_rdata[55:48],
    mim_rep_rdop[5], mim_rep_rdata[47:40], mim_rep_rdop[4], mim_rep_rdata[39:32],
    mim_rep_rdop[3], mim_rep_rdata[31:24], mim_rep_rdop[2], mim_rep_rdata[23:16],
    mim_rep_rdop[1], mim_rep_rdata[15:8], mim_rep_rdop[0], mim_rep_rdata[7:0]};

  assign mim_rep_wdip = {
    MIREPLAYRAMWRITEDATA[143], MIREPLAYRAMWRITEDATA[134],
    MIREPLAYRAMWRITEDATA[125], MIREPLAYRAMWRITEDATA[116],
    MIREPLAYRAMWRITEDATA[107], MIREPLAYRAMWRITEDATA[98],
    MIREPLAYRAMWRITEDATA[89], MIREPLAYRAMWRITEDATA[80],
    MIREPLAYRAMWRITEDATA[71], MIREPLAYRAMWRITEDATA[62],
    MIREPLAYRAMWRITEDATA[53], MIREPLAYRAMWRITEDATA[44],
    MIREPLAYRAMWRITEDATA[35], MIREPLAYRAMWRITEDATA[26],
    MIREPLAYRAMWRITEDATA[17], MIREPLAYRAMWRITEDATA[8]};

  assign mim_rep_wdata = {
    MIREPLAYRAMWRITEDATA[142:135], MIREPLAYRAMWRITEDATA[133:126],
    MIREPLAYRAMWRITEDATA[124:117], MIREPLAYRAMWRITEDATA[115:108],
    MIREPLAYRAMWRITEDATA[106:99], MIREPLAYRAMWRITEDATA[97:90],
    MIREPLAYRAMWRITEDATA[88:81], MIREPLAYRAMWRITEDATA[79:72],
    MIREPLAYRAMWRITEDATA[70:63], MIREPLAYRAMWRITEDATA[61:54],
    MIREPLAYRAMWRITEDATA[52:45], MIREPLAYRAMWRITEDATA[43:36],
    MIREPLAYRAMWRITEDATA[34:27], MIREPLAYRAMWRITEDATA[25:18],
    MIREPLAYRAMWRITEDATA[16:9], MIREPLAYRAMWRITEDATA[7:0]};

  assign MIREQUESTRAMREADDATA = {
    mim_req_rdop[15], mim_req_rdata[127:120], mim_req_rdop[14], mim_req_rdata[119:112],
    mim_req_rdop[13], mim_req_rdata[111:104], mim_req_rdop[12], mim_req_rdata[103:96],
    mim_req_rdop[11], mim_req_rdata[95:88], mim_req_rdop[10], mim_req_rdata[87:80],
    mim_req_rdop[9], mim_req_rdata[79:72], mim_req_rdop[8], mim_req_rdata[71:64],
    mim_req_rdop[7], mim_req_rdata[63:56], mim_req_rdop[6], mim_req_rdata[55:48],
    mim_req_rdop[5], mim_req_rdata[47:40], mim_req_rdop[4], mim_req_rdata[39:32],
    mim_req_rdop[3], mim_req_rdata[31:24], mim_req_rdop[2], mim_req_rdata[23:16],
    mim_req_rdop[1], mim_req_rdata[15:8], mim_req_rdop[0], mim_req_rdata[7:0]};

  assign mim_req_wdip = {
    MIREQUESTRAMWRITEDATA[143], MIREQUESTRAMWRITEDATA[134],
    MIREQUESTRAMWRITEDATA[125], MIREQUESTRAMWRITEDATA[116],
    MIREQUESTRAMWRITEDATA[107], MIREQUESTRAMWRITEDATA[98],
    MIREQUESTRAMWRITEDATA[89], MIREQUESTRAMWRITEDATA[80],
    MIREQUESTRAMWRITEDATA[71], MIREQUESTRAMWRITEDATA[62],
    MIREQUESTRAMWRITEDATA[53], MIREQUESTRAMWRITEDATA[44],
    MIREQUESTRAMWRITEDATA[35], MIREQUESTRAMWRITEDATA[26],
    MIREQUESTRAMWRITEDATA[17], MIREQUESTRAMWRITEDATA[8]};

  assign mim_req_wdata = {
    MIREQUESTRAMWRITEDATA[142:135], MIREQUESTRAMWRITEDATA[133:126],
    MIREQUESTRAMWRITEDATA[124:117], MIREQUESTRAMWRITEDATA[115:108],
    MIREQUESTRAMWRITEDATA[106:99], MIREQUESTRAMWRITEDATA[97:90],
    MIREQUESTRAMWRITEDATA[88:81], MIREQUESTRAMWRITEDATA[79:72],
    MIREQUESTRAMWRITEDATA[70:63], MIREQUESTRAMWRITEDATA[61:54],
    MIREQUESTRAMWRITEDATA[52:45], MIREQUESTRAMWRITEDATA[43:36],
    MIREQUESTRAMWRITEDATA[34:27], MIREQUESTRAMWRITEDATA[25:18],
    MIREQUESTRAMWRITEDATA[16:9], MIREQUESTRAMWRITEDATA[7:0]};

  assign MICOMPLETIONRAMREADDATA = {
    mim_cpl_rdop[15], mim_cpl_rdata[127:120], mim_cpl_rdop[14], mim_cpl_rdata[119:112],
    mim_cpl_rdop[13], mim_cpl_rdata[111:104], mim_cpl_rdop[12], mim_cpl_rdata[103:96],
    mim_cpl_rdop[11], mim_cpl_rdata[95:88], mim_cpl_rdop[10], mim_cpl_rdata[87:80],
    mim_cpl_rdop[9], mim_cpl_rdata[79:72], mim_cpl_rdop[8], mim_cpl_rdata[71:64],
    mim_cpl_rdop[7], mim_cpl_rdata[63:56], mim_cpl_rdop[6], mim_cpl_rdata[55:48],
    mim_cpl_rdop[5], mim_cpl_rdata[47:40], mim_cpl_rdop[4], mim_cpl_rdata[39:32],
    mim_cpl_rdop[3], mim_cpl_rdata[31:24], mim_cpl_rdop[2], mim_cpl_rdata[23:16],
    mim_cpl_rdop[1], mim_cpl_rdata[15:8], mim_cpl_rdop[0], mim_cpl_rdata[7:0]};

  assign micompletionramwritedata = {
    MICOMPLETIONRAMWRITEDATAU[71:0], MICOMPLETIONRAMWRITEDATAL[71:0]};

  assign mim_cpl_wdip = {
    micompletionramwritedata[143], micompletionramwritedata[134],
    micompletionramwritedata[125], micompletionramwritedata[116],
    micompletionramwritedata[107], micompletionramwritedata[98],
    micompletionramwritedata[89], micompletionramwritedata[80],
    micompletionramwritedata[71], micompletionramwritedata[62],
    micompletionramwritedata[53], micompletionramwritedata[44],
    micompletionramwritedata[35], micompletionramwritedata[26],
    micompletionramwritedata[17], micompletionramwritedata[8]};

  assign mim_cpl_wdata = {
    micompletionramwritedata[142:135], micompletionramwritedata[133:126],
    micompletionramwritedata[124:117], micompletionramwritedata[115:108],
    micompletionramwritedata[106:99], micompletionramwritedata[97:90],
    micompletionramwritedata[88:81], micompletionramwritedata[79:72],
    micompletionramwritedata[70:63], micompletionramwritedata[61:54],
    micompletionramwritedata[52:45], micompletionramwritedata[43:36],
    micompletionramwritedata[34:27], micompletionramwritedata[25:18],
    micompletionramwritedata[16:9], micompletionramwritedata[7:0]};

  rp_bram #(
    .TCQ (TCQ),
    .COMPLETION_SPACE (COMPLETION_SPACE))
  bram_inst (
    .clk_i (CORECLK),
    .reset_i (1'b1),
    .mi_rep_addr_i (MIREPLAYRAMADDRESS),
    .mi_rep_wdata_i (mim_rep_wdata[127:0]),
    .mi_rep_wdip_i (mim_rep_wdip[15:0]),
    .mi_rep_wen0_i (MIREPLAYRAMWRITEENABLE[0]),
    .mi_rep_wen1_i (MIREPLAYRAMWRITEENABLE[1]),
    .mi_rep_rdata_o (mim_rep_rdata[127:0]),
    .mi_rep_rdop_o (mim_rep_rdop[15:0]),
    .mi_rep_rden0_i (MIREPLAYRAMREADENABLE[0]),
    .mi_rep_rden1_i (MIREPLAYRAMREADENABLE[1]),
    .mi_req_waddr0_i (MIREQUESTRAMWRITEADDRESSA),
    .mi_req_waddr1_i (MIREQUESTRAMWRITEADDRESSB),
    .mi_req_wdata_i (mim_req_wdata[127:0]),
    .mi_req_wdip_i (mim_req_wdip[15:0]),
    .mi_req_wen0_i (MIREQUESTRAMWRITEENABLE[0]),
    .mi_req_wen1_i (MIREQUESTRAMWRITEENABLE[1]),
    .mi_req_wen2_i (MIREQUESTRAMWRITEENABLE[2]),
    .mi_req_wen3_i (MIREQUESTRAMWRITEENABLE[3]),
    .mi_req_raddr0_i (MIREQUESTRAMREADADDRESSA),
    .mi_req_raddr1_i (MIREQUESTRAMREADADDRESSB),
    .mi_req_rdata_o (mim_req_rdata[127:0]),
    .mi_req_rdop_o (mim_req_rdop[15:0]),
    .mi_req_ren0_i (MIREQUESTRAMREADENABLE[0]),
    .mi_req_ren1_i (MIREQUESTRAMREADENABLE[1]),
    .mi_req_ren2_i (MIREQUESTRAMREADENABLE[2]),
    .mi_req_ren3_i (MIREQUESTRAMREADENABLE[3]),
    .mi_cpl_waddr0_i (MICOMPLETIONRAMWRITEADDRESSAL),
    .mi_cpl_waddr1_i (MICOMPLETIONRAMWRITEADDRESSBL),
    .mi_cpl_waddr2_i (MICOMPLETIONRAMWRITEADDRESSAU),
    .mi_cpl_waddr3_i (MICOMPLETIONRAMWRITEADDRESSBU),
    .mi_cpl_wdata_i (mim_cpl_wdata[127:0]),
    .mi_cpl_wdip_i (mim_cpl_wdip[15:0]),
    .mi_cpl_wen0_i (MICOMPLETIONRAMWRITEENABLEL[0]),
    .mi_cpl_wen1_i (MICOMPLETIONRAMWRITEENABLEL[1]),
    .mi_cpl_wen2_i (MICOMPLETIONRAMWRITEENABLEL[2]),
    .mi_cpl_wen3_i (MICOMPLETIONRAMWRITEENABLEL[3]),
    .mi_cpl_wen4_i (MICOMPLETIONRAMWRITEENABLEU[0]),
    .mi_cpl_wen5_i (MICOMPLETIONRAMWRITEENABLEU[1]),
    .mi_cpl_wen6_i (MICOMPLETIONRAMWRITEENABLEU[2]),
    .mi_cpl_wen7_i (MICOMPLETIONRAMWRITEENABLEU[3]),
    .mi_cpl_raddr0_i (MICOMPLETIONRAMREADADDRESSAL),
    .mi_cpl_raddr1_i (MICOMPLETIONRAMREADADDRESSBL),
    .mi_cpl_raddr2_i (MICOMPLETIONRAMREADADDRESSAU),
    .mi_cpl_raddr3_i (MICOMPLETIONRAMREADADDRESSBU),
    .mi_cpl_rdata_o (mim_cpl_rdata[127:0]),
    .mi_cpl_rdop_o (mim_cpl_rdop[15:0]),
    .mi_cpl_ren0_i (MICOMPLETIONRAMREADENABLEL[0]),
    .mi_cpl_ren1_i (MICOMPLETIONRAMREADENABLEL[1]),
    .mi_cpl_ren2_i (MICOMPLETIONRAMREADENABLEL[2]),
    .mi_cpl_ren3_i (MICOMPLETIONRAMREADENABLEL[3]),
    .mi_cpl_ren4_i (MICOMPLETIONRAMREADENABLEU[0]),
    .mi_cpl_ren5_i (MICOMPLETIONRAMREADENABLEU[1]),
    .mi_cpl_ren6_i (MICOMPLETIONRAMREADENABLEU[2]),
    .mi_cpl_ren7_i (MICOMPLETIONRAMREADENABLEU[3])
  );

  PCIE_3_1 #(
    .ARI_CAP_ENABLE (ARI_CAP_ENABLE),
    .AXISTEN_IF_CC_ALIGNMENT_MODE (AXISTEN_IF_CC_ALIGNMENT_MODE),
    .AXISTEN_IF_CC_PARITY_CHK (AXISTEN_IF_CC_PARITY_CHK),
    .AXISTEN_IF_CQ_ALIGNMENT_MODE (AXISTEN_IF_CQ_ALIGNMENT_MODE),
    .AXISTEN_IF_ENABLE_CLIENT_TAG (AXISTEN_IF_ENABLE_CLIENT_TAG),
    .AXISTEN_IF_ENABLE_MSG_ROUTE (AXISTEN_IF_ENABLE_MSG_ROUTE),
    .AXISTEN_IF_ENABLE_RX_MSG_INTFC (AXISTEN_IF_ENABLE_RX_MSG_INTFC),
    .AXISTEN_IF_RC_ALIGNMENT_MODE (AXISTEN_IF_RC_ALIGNMENT_MODE),
    .AXISTEN_IF_RC_STRADDLE (AXISTEN_IF_RC_STRADDLE),
    .AXISTEN_IF_RQ_ALIGNMENT_MODE (AXISTEN_IF_RQ_ALIGNMENT_MODE),
    .AXISTEN_IF_RQ_PARITY_CHK (AXISTEN_IF_RQ_PARITY_CHK),
    .AXISTEN_IF_WIDTH (AXISTEN_IF_WIDTH),
    .CRM_CORE_CLK_FREQ_500 (CRM_CORE_CLK_FREQ_500),
    .CRM_USER_CLK_FREQ (CRM_USER_CLK_FREQ),
    .DEBUG_CFG_LOCAL_MGMT_REG_ACCESS_OVERRIDE (DEBUG_CFG_LOCAL_MGMT_REG_ACCESS_OVERRIDE),
    .DEBUG_PL_DISABLE_EI_INFER_IN_L0 (DEBUG_PL_DISABLE_EI_INFER_IN_L0),
    .DEBUG_TL_DISABLE_RX_TLP_ORDER_CHECKS (DEBUG_TL_DISABLE_RX_TLP_ORDER_CHECKS),
    .DNSTREAM_LINK_NUM (DNSTREAM_LINK_NUM),
    .LL_ACK_TIMEOUT (LL_ACK_TIMEOUT),
    .LL_ACK_TIMEOUT_EN (LL_ACK_TIMEOUT_EN),
    .LL_ACK_TIMEOUT_FUNC (LL_ACK_TIMEOUT_FUNC),
    .LL_CPL_FC_UPDATE_TIMER (LL_CPL_FC_UPDATE_TIMER),
    .LL_CPL_FC_UPDATE_TIMER_OVERRIDE (LL_CPL_FC_UPDATE_TIMER_OVERRIDE),
    .LL_FC_UPDATE_TIMER (LL_FC_UPDATE_TIMER),
    .LL_FC_UPDATE_TIMER_OVERRIDE (LL_FC_UPDATE_TIMER_OVERRIDE),
    .LL_NP_FC_UPDATE_TIMER (LL_NP_FC_UPDATE_TIMER),
    .LL_NP_FC_UPDATE_TIMER_OVERRIDE (LL_NP_FC_UPDATE_TIMER_OVERRIDE),
    .LL_P_FC_UPDATE_TIMER (LL_P_FC_UPDATE_TIMER),
    .LL_P_FC_UPDATE_TIMER_OVERRIDE (LL_P_FC_UPDATE_TIMER_OVERRIDE),
    .LL_REPLAY_TIMEOUT (LL_REPLAY_TIMEOUT),
    .LL_REPLAY_TIMEOUT_EN (LL_REPLAY_TIMEOUT_EN),
    .LL_REPLAY_TIMEOUT_FUNC (LL_REPLAY_TIMEOUT_FUNC),
    .LTR_TX_MESSAGE_MINIMUM_INTERVAL (LTR_TX_MESSAGE_MINIMUM_INTERVAL),
    .LTR_TX_MESSAGE_ON_FUNC_POWER_STATE_CHANGE (LTR_TX_MESSAGE_ON_FUNC_POWER_STATE_CHANGE),
    .LTR_TX_MESSAGE_ON_LTR_ENABLE (LTR_TX_MESSAGE_ON_LTR_ENABLE),
    .MCAP_CAP_NEXTPTR (MCAP_CAP_NEXTPTR),
    .MCAP_CONFIGURE_OVERRIDE (MCAP_CONFIGURE_OVERRIDE),
    .MCAP_ENABLE (MCAP_ENABLE),
    .MCAP_EOS_DESIGN_SWITCH (MCAP_EOS_DESIGN_SWITCH),
    .MCAP_FPGA_BITSTREAM_VERSION (MCAP_FPGA_BITSTREAM_VERSION),
    .MCAP_GATE_IO_ENABLE_DESIGN_SWITCH (MCAP_GATE_IO_ENABLE_DESIGN_SWITCH),
    .MCAP_GATE_MEM_ENABLE_DESIGN_SWITCH (MCAP_GATE_MEM_ENABLE_DESIGN_SWITCH),
    .MCAP_INPUT_GATE_DESIGN_SWITCH (MCAP_INPUT_GATE_DESIGN_SWITCH),
    .MCAP_INTERRUPT_ON_MCAP_EOS (MCAP_INTERRUPT_ON_MCAP_EOS),
    .MCAP_INTERRUPT_ON_MCAP_ERROR (MCAP_INTERRUPT_ON_MCAP_ERROR),
    .MCAP_VSEC_ID (MCAP_VSEC_ID),
    .MCAP_VSEC_LEN (MCAP_VSEC_LEN),
    .MCAP_VSEC_REV (MCAP_VSEC_REV),
    .PF0_AER_CAP_ECRC_CHECK_CAPABLE (PF0_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF0_AER_CAP_ECRC_GEN_CAPABLE (PF0_AER_CAP_ECRC_GEN_CAPABLE),
    .PF0_AER_CAP_NEXTPTR (PF0_AER_CAP_NEXTPTR),
    .PF0_ARI_CAP_NEXT_FUNC (PF0_ARI_CAP_NEXT_FUNC),
    .PF0_ARI_CAP_NEXTPTR (PF0_ARI_CAP_NEXTPTR),
    .PF0_ARI_CAP_VER (PF0_ARI_CAP_VER),
    .PF0_BAR0_APERTURE_SIZE (PF0_BAR0_APERTURE_SIZE),
    .PF0_BAR0_CONTROL (PF0_BAR0_CONTROL),
    .PF0_BAR1_APERTURE_SIZE (PF0_BAR1_APERTURE_SIZE),
    .PF0_BAR1_CONTROL (PF0_BAR1_CONTROL),
    .PF0_BAR2_APERTURE_SIZE (PF0_BAR2_APERTURE_SIZE),
    .PF0_BAR2_CONTROL (PF0_BAR2_CONTROL),
    .PF0_BAR3_APERTURE_SIZE (PF0_BAR3_APERTURE_SIZE),
    .PF0_BAR3_CONTROL (PF0_BAR3_CONTROL),
    .PF0_BAR4_APERTURE_SIZE (PF0_BAR4_APERTURE_SIZE),
    .PF0_BAR4_CONTROL (PF0_BAR4_CONTROL),
    .PF0_BAR5_APERTURE_SIZE (PF0_BAR5_APERTURE_SIZE),
    .PF0_BAR5_CONTROL (PF0_BAR5_CONTROL),
    .PF0_BIST_REGISTER (PF0_BIST_REGISTER),
    .PF0_CAPABILITY_POINTER (PF0_CAPABILITY_POINTER),
    .PF0_CLASS_CODE (PF0_CLASS_CODE),
    .PF0_DEV_CAP_ENDPOINT_L0S_LATENCY (PF0_DEV_CAP_ENDPOINT_L0S_LATENCY),
    .PF0_DEV_CAP_ENDPOINT_L1_LATENCY (PF0_DEV_CAP_ENDPOINT_L1_LATENCY),
    .PF0_DEV_CAP_EXT_TAG_SUPPORTED (PF0_DEV_CAP_EXT_TAG_SUPPORTED),
    .PF0_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE (PF0_DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE),
    .PF0_DEV_CAP_MAX_PAYLOAD_SIZE (PF0_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF0_DEV_CAP2_ARI_FORWARD_ENABLE (PF0_DEV_CAP2_ARI_FORWARD_ENABLE),
    .PF0_DEV_CAP2_CPL_TIMEOUT_DISABLE (PF0_DEV_CAP2_CPL_TIMEOUT_DISABLE),
    .PF0_DEV_CAP2_LTR_SUPPORT (PF0_DEV_CAP2_LTR_SUPPORT),
    .PF0_DEV_CAP2_OBFF_SUPPORT (PF0_DEV_CAP2_OBFF_SUPPORT),
    .PF0_DEV_CAP2_TPH_COMPLETER_SUPPORT (PF0_DEV_CAP2_TPH_COMPLETER_SUPPORT),
    .PF0_DEV_CAP2_32B_ATOMIC_COMPLETER_SUPPORT (PF0_DEV_CAP2_32B_ATOMIC_COMPLETER_SUPPORT),
    .PF0_DEV_CAP2_64B_ATOMIC_COMPLETER_SUPPORT (PF0_DEV_CAP2_64B_ATOMIC_COMPLETER_SUPPORT),
    .PF0_DEV_CAP2_128B_CAS_ATOMIC_COMPLETER_SUPPORT (PF0_DEV_CAP2_128B_CAS_ATOMIC_COMPLETER_SUPPORT),
    .PF0_DEVICE_ID (PF0_DEVICE_ID),
    .PF0_DPA_CAP_NEXTPTR (PF0_DPA_CAP_NEXTPTR),
    .PF0_DPA_CAP_SUB_STATE_CONTROL (PF0_DPA_CAP_SUB_STATE_CONTROL),
    .PF0_DPA_CAP_SUB_STATE_CONTROL_EN (PF0_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF0_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF0_DPA_CAP_VER (PF0_DPA_CAP_VER),
    .PF0_DSN_CAP_NEXTPTR (PF0_DSN_CAP_NEXTPTR),
    .PF0_EXPANSION_ROM_APERTURE_SIZE (PF0_EXPANSION_ROM_APERTURE_SIZE),
    .PF0_EXPANSION_ROM_ENABLE (PF0_EXPANSION_ROM_ENABLE),
    .PF0_INTERRUPT_LINE (PF0_INTERRUPT_LINE),
    .PF0_INTERRUPT_PIN (PF0_INTERRUPT_PIN),
    .PF0_LINK_CAP_ASPM_SUPPORT (PF0_LINK_CAP_ASPM_SUPPORT),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 (PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 (PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN3 (PF0_LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN3),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN1 (PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN1),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN2 (PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN2),
    .PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN3 (PF0_LINK_CAP_L0S_EXIT_LATENCY_GEN3),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 (PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 (PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN3 (PF0_LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN3),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_GEN1 (PF0_LINK_CAP_L1_EXIT_LATENCY_GEN1),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_GEN2 (PF0_LINK_CAP_L1_EXIT_LATENCY_GEN2),
    .PF0_LINK_CAP_L1_EXIT_LATENCY_GEN3 (PF0_LINK_CAP_L1_EXIT_LATENCY_GEN3),
    .PF0_LINK_STATUS_SLOT_CLOCK_CONFIG (PF0_LINK_STATUS_SLOT_CLOCK_CONFIG),
    .PF0_LTR_CAP_MAX_NOSNOOP_LAT (PF0_LTR_CAP_MAX_NOSNOOP_LAT),
    .PF0_LTR_CAP_MAX_SNOOP_LAT (PF0_LTR_CAP_MAX_SNOOP_LAT),
    .PF0_LTR_CAP_NEXTPTR (PF0_LTR_CAP_NEXTPTR),
    .PF0_LTR_CAP_VER (PF0_LTR_CAP_VER),
    .PF0_MSI_CAP_MULTIMSGCAP (PF0_MSI_CAP_MULTIMSGCAP),
    .PF0_MSI_CAP_NEXTPTR (PF0_MSI_CAP_NEXTPTR),
    .PF0_MSI_CAP_PERVECMASKCAP (PF0_MSI_CAP_PERVECMASKCAP),
    .PF0_MSIX_CAP_NEXTPTR (PF0_MSIX_CAP_NEXTPTR),
    .PF0_MSIX_CAP_PBA_BIR (PF0_MSIX_CAP_PBA_BIR),
    .PF0_MSIX_CAP_PBA_OFFSET (PF0_MSIX_CAP_PBA_OFFSET),
    .PF0_MSIX_CAP_TABLE_BIR (PF0_MSIX_CAP_TABLE_BIR),
    .PF0_MSIX_CAP_TABLE_OFFSET (PF0_MSIX_CAP_TABLE_OFFSET),
    .PF0_MSIX_CAP_TABLE_SIZE (PF0_MSIX_CAP_TABLE_SIZE),
    .PF0_PB_CAP_DATA_REG_D0 (PF0_PB_CAP_DATA_REG_D0),
    .PF0_PB_CAP_DATA_REG_D0_SUSTAINED (PF0_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF0_PB_CAP_DATA_REG_D1 (PF0_PB_CAP_DATA_REG_D1),
    .PF0_PB_CAP_DATA_REG_D3HOT (PF0_PB_CAP_DATA_REG_D3HOT),
    .PF0_PB_CAP_NEXTPTR (PF0_PB_CAP_NEXTPTR),
    .PF0_PB_CAP_SYSTEM_ALLOCATED (PF0_PB_CAP_SYSTEM_ALLOCATED),
    .PF0_PB_CAP_VER (PF0_PB_CAP_VER),
    .PF0_PM_CAP_ID (PF0_PM_CAP_ID),
    .PF0_PM_CAP_NEXTPTR (PF0_PM_CAP_NEXTPTR),
    .PF0_PM_CAP_PMESUPPORT_D0 (PF0_PM_CAP_PMESUPPORT_D0),
    .PF0_PM_CAP_PMESUPPORT_D1 (PF0_PM_CAP_PMESUPPORT_D1),
    .PF0_PM_CAP_PMESUPPORT_D3HOT (PF0_PM_CAP_PMESUPPORT_D3HOT),
    .PF0_PM_CAP_SUPP_D1_STATE (PF0_PM_CAP_SUPP_D1_STATE),
    .PF0_PM_CAP_VER_ID (PF0_PM_CAP_VER_ID),
    .PF0_PM_CSR_NOSOFTRESET (PF0_PM_CSR_NOSOFTRESET),
    .PF0_RBAR_CAP_ENABLE (PF0_RBAR_CAP_ENABLE),
    .PF0_RBAR_CAP_NEXTPTR (PF0_RBAR_CAP_NEXTPTR),
    .PF0_RBAR_CAP_SIZE0 (PF0_RBAR_CAP_SIZE0),
    .PF0_RBAR_CAP_SIZE1 (PF0_RBAR_CAP_SIZE1),
    .PF0_RBAR_CAP_SIZE2 (PF0_RBAR_CAP_SIZE2),
    .PF0_RBAR_CAP_VER (PF0_RBAR_CAP_VER),
    .PF0_RBAR_CONTROL_INDEX0 (PF0_RBAR_CONTROL_INDEX0),
    .PF0_RBAR_CONTROL_INDEX1 (PF0_RBAR_CONTROL_INDEX1),
    .PF0_RBAR_CONTROL_INDEX2 (PF0_RBAR_CONTROL_INDEX2),
    .PF0_RBAR_CONTROL_SIZE0 (PF0_RBAR_CONTROL_SIZE0),
    .PF0_RBAR_CONTROL_SIZE1 (PF0_RBAR_CONTROL_SIZE1),
    .PF0_RBAR_CONTROL_SIZE2 (PF0_RBAR_CONTROL_SIZE2),
    .PF0_RBAR_NUM (PF0_RBAR_NUM),
    .PF0_REVISION_ID (PF0_REVISION_ID),
    .PF0_SECONDARY_PCIE_CAP_NEXTPTR (PF0_SECONDARY_PCIE_CAP_NEXTPTR),
    .PF0_SRIOV_BAR0_APERTURE_SIZE (PF0_SRIOV_BAR0_APERTURE_SIZE),
    .PF0_SRIOV_BAR0_CONTROL (PF0_SRIOV_BAR0_CONTROL),
    .PF0_SRIOV_BAR1_APERTURE_SIZE (PF0_SRIOV_BAR1_APERTURE_SIZE),
    .PF0_SRIOV_BAR1_CONTROL (PF0_SRIOV_BAR1_CONTROL),
    .PF0_SRIOV_BAR2_APERTURE_SIZE (PF0_SRIOV_BAR2_APERTURE_SIZE),
    .PF0_SRIOV_BAR2_CONTROL (PF0_SRIOV_BAR2_CONTROL),
    .PF0_SRIOV_BAR3_APERTURE_SIZE (PF0_SRIOV_BAR3_APERTURE_SIZE),
    .PF0_SRIOV_BAR3_CONTROL (PF0_SRIOV_BAR3_CONTROL),
    .PF0_SRIOV_BAR4_APERTURE_SIZE (PF0_SRIOV_BAR4_APERTURE_SIZE),
    .PF0_SRIOV_BAR4_CONTROL (PF0_SRIOV_BAR4_CONTROL),
    .PF0_SRIOV_BAR5_APERTURE_SIZE (PF0_SRIOV_BAR5_APERTURE_SIZE),
    .PF0_SRIOV_BAR5_CONTROL (PF0_SRIOV_BAR5_CONTROL),
    .PF0_SRIOV_CAP_INITIAL_VF (PF0_SRIOV_CAP_INITIAL_VF),
    .PF0_SRIOV_CAP_NEXTPTR (PF0_SRIOV_CAP_NEXTPTR),
    .PF0_SRIOV_CAP_TOTAL_VF (PF0_SRIOV_CAP_TOTAL_VF),
    .PF0_SRIOV_CAP_VER (PF0_SRIOV_CAP_VER),
    .PF0_SRIOV_FIRST_VF_OFFSET (PF0_SRIOV_FIRST_VF_OFFSET),
    .PF0_SRIOV_FUNC_DEP_LINK (PF0_SRIOV_FUNC_DEP_LINK),
    .PF0_SRIOV_SUPPORTED_PAGE_SIZE (PF0_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF0_SRIOV_VF_DEVICE_ID (PF0_SRIOV_VF_DEVICE_ID),
    .PF0_SUBSYSTEM_ID (PF0_SUBSYSTEM_ID),
    .PF0_TPHR_CAP_DEV_SPECIFIC_MODE (PF0_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF0_TPHR_CAP_ENABLE (PF0_TPHR_CAP_ENABLE),
    .PF0_TPHR_CAP_INT_VEC_MODE (PF0_TPHR_CAP_INT_VEC_MODE),
    .PF0_TPHR_CAP_NEXTPTR (PF0_TPHR_CAP_NEXTPTR),
    .PF0_TPHR_CAP_ST_MODE_SEL (PF0_TPHR_CAP_ST_MODE_SEL),
    .PF0_TPHR_CAP_ST_TABLE_LOC (PF0_TPHR_CAP_ST_TABLE_LOC),
    .PF0_TPHR_CAP_ST_TABLE_SIZE (PF0_TPHR_CAP_ST_TABLE_SIZE),
    .PF0_TPHR_CAP_VER (PF0_TPHR_CAP_VER),
    .PF0_VC_CAP_ENABLE (PF0_VC_CAP_ENABLE),
    .PF0_VC_CAP_NEXTPTR (PF0_VC_CAP_NEXTPTR),
    .PF0_VC_CAP_VER (PF0_VC_CAP_VER),
    .PF1_AER_CAP_ECRC_CHECK_CAPABLE (PF1_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF1_AER_CAP_ECRC_GEN_CAPABLE (PF1_AER_CAP_ECRC_GEN_CAPABLE),
    .PF1_AER_CAP_NEXTPTR (PF1_AER_CAP_NEXTPTR),
    .PF1_ARI_CAP_NEXT_FUNC (PF1_ARI_CAP_NEXT_FUNC),
    .PF1_ARI_CAP_NEXTPTR (PF1_ARI_CAP_NEXTPTR),
    .PF1_BAR0_APERTURE_SIZE (PF1_BAR0_APERTURE_SIZE),
    .PF1_BAR0_CONTROL (PF1_BAR0_CONTROL),
    .PF1_BAR1_APERTURE_SIZE (PF1_BAR1_APERTURE_SIZE),
    .PF1_BAR1_CONTROL (PF1_BAR1_CONTROL),
    .PF1_BAR2_APERTURE_SIZE (PF1_BAR2_APERTURE_SIZE),
    .PF1_BAR2_CONTROL (PF1_BAR2_CONTROL),
    .PF1_BAR3_APERTURE_SIZE (PF1_BAR3_APERTURE_SIZE),
    .PF1_BAR3_CONTROL (PF1_BAR3_CONTROL),
    .PF1_BAR4_APERTURE_SIZE (PF1_BAR4_APERTURE_SIZE),
    .PF1_BAR4_CONTROL (PF1_BAR4_CONTROL),
    .PF1_BAR5_APERTURE_SIZE (PF1_BAR5_APERTURE_SIZE),
    .PF1_BAR5_CONTROL (PF1_BAR5_CONTROL),
    .PF1_BIST_REGISTER (PF1_BIST_REGISTER),
    .PF1_CAPABILITY_POINTER (PF1_CAPABILITY_POINTER),
    .PF1_CLASS_CODE (PF1_CLASS_CODE),
    .PF1_DEV_CAP_MAX_PAYLOAD_SIZE (PF1_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF1_DEVICE_ID (PF1_DEVICE_ID),
    .PF1_DPA_CAP_NEXTPTR (PF1_DPA_CAP_NEXTPTR),
    .PF1_DPA_CAP_SUB_STATE_CONTROL (PF1_DPA_CAP_SUB_STATE_CONTROL),
    .PF1_DPA_CAP_SUB_STATE_CONTROL_EN (PF1_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF1_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF1_DPA_CAP_VER (PF1_DPA_CAP_VER),
    .PF1_DSN_CAP_NEXTPTR (PF1_DSN_CAP_NEXTPTR),
    .PF1_EXPANSION_ROM_APERTURE_SIZE (PF1_EXPANSION_ROM_APERTURE_SIZE),
    .PF1_EXPANSION_ROM_ENABLE (PF1_EXPANSION_ROM_ENABLE),
    .PF1_INTERRUPT_LINE (PF1_INTERRUPT_LINE),
    .PF1_INTERRUPT_PIN (PF1_INTERRUPT_PIN),
    .PF1_MSI_CAP_MULTIMSGCAP (PF1_MSI_CAP_MULTIMSGCAP),
    .PF1_MSI_CAP_NEXTPTR (PF1_MSI_CAP_NEXTPTR),
    .PF1_MSI_CAP_PERVECMASKCAP (PF1_MSI_CAP_PERVECMASKCAP),
    .PF1_MSIX_CAP_NEXTPTR (PF1_MSIX_CAP_NEXTPTR),
    .PF1_MSIX_CAP_PBA_BIR (PF1_MSIX_CAP_PBA_BIR),
    .PF1_MSIX_CAP_PBA_OFFSET (PF1_MSIX_CAP_PBA_OFFSET),
    .PF1_MSIX_CAP_TABLE_BIR (PF1_MSIX_CAP_TABLE_BIR),
    .PF1_MSIX_CAP_TABLE_OFFSET (PF1_MSIX_CAP_TABLE_OFFSET),
    .PF1_MSIX_CAP_TABLE_SIZE (PF1_MSIX_CAP_TABLE_SIZE),
    .PF1_PB_CAP_DATA_REG_D0 (PF1_PB_CAP_DATA_REG_D0),
    .PF1_PB_CAP_DATA_REG_D0_SUSTAINED (PF1_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF1_PB_CAP_DATA_REG_D1 (PF1_PB_CAP_DATA_REG_D1),
    .PF1_PB_CAP_DATA_REG_D3HOT (PF1_PB_CAP_DATA_REG_D3HOT),
    .PF1_PB_CAP_NEXTPTR (PF1_PB_CAP_NEXTPTR),
    .PF1_PB_CAP_SYSTEM_ALLOCATED (PF1_PB_CAP_SYSTEM_ALLOCATED),
    .PF1_PB_CAP_VER (PF1_PB_CAP_VER),
    .PF1_PM_CAP_ID (PF1_PM_CAP_ID),
    .PF1_PM_CAP_NEXTPTR (PF1_PM_CAP_NEXTPTR),
    .PF1_PM_CAP_VER_ID (PF1_PM_CAP_VER_ID),
    .PF1_RBAR_CAP_ENABLE (PF1_RBAR_CAP_ENABLE),
    .PF1_RBAR_CAP_NEXTPTR (PF1_RBAR_CAP_NEXTPTR),
    .PF1_RBAR_CAP_SIZE0 (PF1_RBAR_CAP_SIZE0),
    .PF1_RBAR_CAP_SIZE1 (PF1_RBAR_CAP_SIZE1),
    .PF1_RBAR_CAP_SIZE2 (PF1_RBAR_CAP_SIZE2),
    .PF1_RBAR_CAP_VER (PF1_RBAR_CAP_VER),
    .PF1_RBAR_CONTROL_INDEX0 (PF1_RBAR_CONTROL_INDEX0),
    .PF1_RBAR_CONTROL_INDEX1 (PF1_RBAR_CONTROL_INDEX1),
    .PF1_RBAR_CONTROL_INDEX2 (PF1_RBAR_CONTROL_INDEX2),
    .PF1_RBAR_CONTROL_SIZE0 (PF1_RBAR_CONTROL_SIZE0),
    .PF1_RBAR_CONTROL_SIZE1 (PF1_RBAR_CONTROL_SIZE1),
    .PF1_RBAR_CONTROL_SIZE2 (PF1_RBAR_CONTROL_SIZE2),
    .PF1_RBAR_NUM (PF1_RBAR_NUM),
    .PF1_REVISION_ID (PF1_REVISION_ID),
    .PF1_SRIOV_BAR0_APERTURE_SIZE (PF1_SRIOV_BAR0_APERTURE_SIZE),
    .PF1_SRIOV_BAR0_CONTROL (PF1_SRIOV_BAR0_CONTROL),
    .PF1_SRIOV_BAR1_APERTURE_SIZE (PF1_SRIOV_BAR1_APERTURE_SIZE),
    .PF1_SRIOV_BAR1_CONTROL (PF1_SRIOV_BAR1_CONTROL),
    .PF1_SRIOV_BAR2_APERTURE_SIZE (PF1_SRIOV_BAR2_APERTURE_SIZE),
    .PF1_SRIOV_BAR2_CONTROL (PF1_SRIOV_BAR2_CONTROL),
    .PF1_SRIOV_BAR3_APERTURE_SIZE (PF1_SRIOV_BAR3_APERTURE_SIZE),
    .PF1_SRIOV_BAR3_CONTROL (PF1_SRIOV_BAR3_CONTROL),
    .PF1_SRIOV_BAR4_APERTURE_SIZE (PF1_SRIOV_BAR4_APERTURE_SIZE),
    .PF1_SRIOV_BAR4_CONTROL (PF1_SRIOV_BAR4_CONTROL),
    .PF1_SRIOV_BAR5_APERTURE_SIZE (PF1_SRIOV_BAR5_APERTURE_SIZE),
    .PF1_SRIOV_BAR5_CONTROL (PF1_SRIOV_BAR5_CONTROL),
    .PF1_SRIOV_CAP_INITIAL_VF (PF1_SRIOV_CAP_INITIAL_VF),
    .PF1_SRIOV_CAP_NEXTPTR (PF1_SRIOV_CAP_NEXTPTR),
    .PF1_SRIOV_CAP_TOTAL_VF (PF1_SRIOV_CAP_TOTAL_VF),
    .PF1_SRIOV_CAP_VER (PF1_SRIOV_CAP_VER),
    .PF1_SRIOV_FIRST_VF_OFFSET (PF1_SRIOV_FIRST_VF_OFFSET),
    .PF1_SRIOV_FUNC_DEP_LINK (PF1_SRIOV_FUNC_DEP_LINK),
    .PF1_SRIOV_SUPPORTED_PAGE_SIZE (PF1_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF1_SRIOV_VF_DEVICE_ID (PF1_SRIOV_VF_DEVICE_ID),
    .PF1_SUBSYSTEM_ID (PF1_SUBSYSTEM_ID),
    .PF1_TPHR_CAP_DEV_SPECIFIC_MODE (PF1_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF1_TPHR_CAP_ENABLE (PF1_TPHR_CAP_ENABLE),
    .PF1_TPHR_CAP_INT_VEC_MODE (PF1_TPHR_CAP_INT_VEC_MODE),
    .PF1_TPHR_CAP_NEXTPTR (PF1_TPHR_CAP_NEXTPTR),
    .PF1_TPHR_CAP_ST_MODE_SEL (PF1_TPHR_CAP_ST_MODE_SEL),
    .PF1_TPHR_CAP_ST_TABLE_LOC (PF1_TPHR_CAP_ST_TABLE_LOC),
    .PF1_TPHR_CAP_ST_TABLE_SIZE (PF1_TPHR_CAP_ST_TABLE_SIZE),
    .PF1_TPHR_CAP_VER (PF1_TPHR_CAP_VER),
    .PF2_AER_CAP_ECRC_CHECK_CAPABLE (PF2_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF2_AER_CAP_ECRC_GEN_CAPABLE (PF2_AER_CAP_ECRC_GEN_CAPABLE),
    .PF2_AER_CAP_NEXTPTR (PF2_AER_CAP_NEXTPTR),
    .PF2_ARI_CAP_NEXT_FUNC (PF2_ARI_CAP_NEXT_FUNC),
    .PF2_ARI_CAP_NEXTPTR (PF2_ARI_CAP_NEXTPTR),
    .PF2_BAR0_APERTURE_SIZE (PF2_BAR0_APERTURE_SIZE),
    .PF2_BAR0_CONTROL (PF2_BAR0_CONTROL),
    .PF2_BAR1_APERTURE_SIZE (PF2_BAR1_APERTURE_SIZE),
    .PF2_BAR1_CONTROL (PF2_BAR1_CONTROL),
    .PF2_BAR2_APERTURE_SIZE (PF2_BAR2_APERTURE_SIZE),
    .PF2_BAR2_CONTROL (PF2_BAR2_CONTROL),
    .PF2_BAR3_APERTURE_SIZE (PF2_BAR3_APERTURE_SIZE),
    .PF2_BAR3_CONTROL (PF2_BAR3_CONTROL),
    .PF2_BAR4_APERTURE_SIZE (PF2_BAR4_APERTURE_SIZE),
    .PF2_BAR4_CONTROL (PF2_BAR4_CONTROL),
    .PF2_BAR5_APERTURE_SIZE (PF2_BAR5_APERTURE_SIZE),
    .PF2_BAR5_CONTROL (PF2_BAR5_CONTROL),
    .PF2_BIST_REGISTER (PF2_BIST_REGISTER),
    .PF2_CAPABILITY_POINTER (PF2_CAPABILITY_POINTER),
    .PF2_CLASS_CODE (PF2_CLASS_CODE),
    .PF2_DEV_CAP_MAX_PAYLOAD_SIZE (PF2_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF2_DEVICE_ID (PF2_DEVICE_ID),
    .PF2_DPA_CAP_NEXTPTR (PF2_DPA_CAP_NEXTPTR),
    .PF2_DPA_CAP_SUB_STATE_CONTROL (PF2_DPA_CAP_SUB_STATE_CONTROL),
    .PF2_DPA_CAP_SUB_STATE_CONTROL_EN (PF2_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF2_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF2_DPA_CAP_VER (PF2_DPA_CAP_VER),
    .PF2_DSN_CAP_NEXTPTR (PF2_DSN_CAP_NEXTPTR),
    .PF2_EXPANSION_ROM_APERTURE_SIZE (PF2_EXPANSION_ROM_APERTURE_SIZE),
    .PF2_EXPANSION_ROM_ENABLE (PF2_EXPANSION_ROM_ENABLE),
    .PF2_INTERRUPT_LINE (PF2_INTERRUPT_LINE),
    .PF2_INTERRUPT_PIN (PF2_INTERRUPT_PIN),
    .PF2_MSI_CAP_MULTIMSGCAP (PF2_MSI_CAP_MULTIMSGCAP),
    .PF2_MSI_CAP_NEXTPTR (PF2_MSI_CAP_NEXTPTR),
    .PF2_MSI_CAP_PERVECMASKCAP (PF2_MSI_CAP_PERVECMASKCAP),
    .PF2_MSIX_CAP_NEXTPTR (PF2_MSIX_CAP_NEXTPTR),
    .PF2_MSIX_CAP_PBA_BIR (PF2_MSIX_CAP_PBA_BIR),
    .PF2_MSIX_CAP_PBA_OFFSET (PF2_MSIX_CAP_PBA_OFFSET),
    .PF2_MSIX_CAP_TABLE_BIR (PF2_MSIX_CAP_TABLE_BIR),
    .PF2_MSIX_CAP_TABLE_OFFSET (PF2_MSIX_CAP_TABLE_OFFSET),
    .PF2_MSIX_CAP_TABLE_SIZE (PF2_MSIX_CAP_TABLE_SIZE),
    .PF2_PB_CAP_DATA_REG_D0 (PF2_PB_CAP_DATA_REG_D0),
    .PF2_PB_CAP_DATA_REG_D0_SUSTAINED (PF2_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF2_PB_CAP_DATA_REG_D1 (PF2_PB_CAP_DATA_REG_D1),
    .PF2_PB_CAP_DATA_REG_D3HOT (PF2_PB_CAP_DATA_REG_D3HOT),
    .PF2_PB_CAP_NEXTPTR (PF2_PB_CAP_NEXTPTR),
    .PF2_PB_CAP_SYSTEM_ALLOCATED (PF2_PB_CAP_SYSTEM_ALLOCATED),
    .PF2_PB_CAP_VER (PF2_PB_CAP_VER),
    .PF2_PM_CAP_ID (PF2_PM_CAP_ID),
    .PF2_PM_CAP_NEXTPTR (PF2_PM_CAP_NEXTPTR),
    .PF2_PM_CAP_VER_ID (PF2_PM_CAP_VER_ID),
    .PF2_RBAR_CAP_ENABLE (PF2_RBAR_CAP_ENABLE),
    .PF2_RBAR_CAP_NEXTPTR (PF2_RBAR_CAP_NEXTPTR),
    .PF2_RBAR_CAP_SIZE0 (PF2_RBAR_CAP_SIZE0),
    .PF2_RBAR_CAP_SIZE1 (PF2_RBAR_CAP_SIZE1),
    .PF2_RBAR_CAP_SIZE2 (PF2_RBAR_CAP_SIZE2),
    .PF2_RBAR_CAP_VER (PF2_RBAR_CAP_VER),
    .PF2_RBAR_CONTROL_INDEX0 (PF2_RBAR_CONTROL_INDEX0),
    .PF2_RBAR_CONTROL_INDEX1 (PF2_RBAR_CONTROL_INDEX1),
    .PF2_RBAR_CONTROL_INDEX2 (PF2_RBAR_CONTROL_INDEX2),
    .PF2_RBAR_CONTROL_SIZE0 (PF2_RBAR_CONTROL_SIZE0),
    .PF2_RBAR_CONTROL_SIZE1 (PF2_RBAR_CONTROL_SIZE1),
    .PF2_RBAR_CONTROL_SIZE2 (PF2_RBAR_CONTROL_SIZE2),
    .PF2_RBAR_NUM (PF2_RBAR_NUM),
    .PF2_REVISION_ID (PF2_REVISION_ID),
    .PF2_SRIOV_BAR0_APERTURE_SIZE (PF2_SRIOV_BAR0_APERTURE_SIZE),
    .PF2_SRIOV_BAR0_CONTROL (PF2_SRIOV_BAR0_CONTROL),
    .PF2_SRIOV_BAR1_APERTURE_SIZE (PF2_SRIOV_BAR1_APERTURE_SIZE),
    .PF2_SRIOV_BAR1_CONTROL (PF2_SRIOV_BAR1_CONTROL),
    .PF2_SRIOV_BAR2_APERTURE_SIZE (PF2_SRIOV_BAR2_APERTURE_SIZE),
    .PF2_SRIOV_BAR2_CONTROL (PF2_SRIOV_BAR2_CONTROL),
    .PF2_SRIOV_BAR3_APERTURE_SIZE (PF2_SRIOV_BAR3_APERTURE_SIZE),
    .PF2_SRIOV_BAR3_CONTROL (PF2_SRIOV_BAR3_CONTROL),
    .PF2_SRIOV_BAR4_APERTURE_SIZE (PF2_SRIOV_BAR4_APERTURE_SIZE),
    .PF2_SRIOV_BAR4_CONTROL (PF2_SRIOV_BAR4_CONTROL),
    .PF2_SRIOV_BAR5_APERTURE_SIZE (PF2_SRIOV_BAR5_APERTURE_SIZE),
    .PF2_SRIOV_BAR5_CONTROL (PF2_SRIOV_BAR5_CONTROL),
    .PF2_SRIOV_CAP_INITIAL_VF (PF2_SRIOV_CAP_INITIAL_VF),
    .PF2_SRIOV_CAP_NEXTPTR (PF2_SRIOV_CAP_NEXTPTR),
    .PF2_SRIOV_CAP_TOTAL_VF (PF2_SRIOV_CAP_TOTAL_VF),
    .PF2_SRIOV_CAP_VER (PF2_SRIOV_CAP_VER),
    .PF2_SRIOV_FIRST_VF_OFFSET (PF2_SRIOV_FIRST_VF_OFFSET),
    .PF2_SRIOV_FUNC_DEP_LINK (PF2_SRIOV_FUNC_DEP_LINK),
    .PF2_SRIOV_SUPPORTED_PAGE_SIZE (PF2_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF2_SRIOV_VF_DEVICE_ID (PF2_SRIOV_VF_DEVICE_ID),
    .PF2_SUBSYSTEM_ID (PF2_SUBSYSTEM_ID),
    .PF2_TPHR_CAP_DEV_SPECIFIC_MODE (PF2_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF2_TPHR_CAP_ENABLE (PF2_TPHR_CAP_ENABLE),
    .PF2_TPHR_CAP_INT_VEC_MODE (PF2_TPHR_CAP_INT_VEC_MODE),
    .PF2_TPHR_CAP_NEXTPTR (PF2_TPHR_CAP_NEXTPTR),
    .PF2_TPHR_CAP_ST_MODE_SEL (PF2_TPHR_CAP_ST_MODE_SEL),
    .PF2_TPHR_CAP_ST_TABLE_LOC (PF2_TPHR_CAP_ST_TABLE_LOC),
    .PF2_TPHR_CAP_ST_TABLE_SIZE (PF2_TPHR_CAP_ST_TABLE_SIZE),
    .PF2_TPHR_CAP_VER (PF2_TPHR_CAP_VER),
    .PF3_AER_CAP_ECRC_CHECK_CAPABLE (PF3_AER_CAP_ECRC_CHECK_CAPABLE),
    .PF3_AER_CAP_ECRC_GEN_CAPABLE (PF3_AER_CAP_ECRC_GEN_CAPABLE),
    .PF3_AER_CAP_NEXTPTR (PF3_AER_CAP_NEXTPTR),
    .PF3_ARI_CAP_NEXT_FUNC (PF3_ARI_CAP_NEXT_FUNC),
    .PF3_ARI_CAP_NEXTPTR (PF3_ARI_CAP_NEXTPTR),
    .PF3_BAR0_APERTURE_SIZE (PF3_BAR0_APERTURE_SIZE),
    .PF3_BAR0_CONTROL (PF3_BAR0_CONTROL),
    .PF3_BAR1_APERTURE_SIZE (PF3_BAR1_APERTURE_SIZE),
    .PF3_BAR1_CONTROL (PF3_BAR1_CONTROL),
    .PF3_BAR2_APERTURE_SIZE (PF3_BAR2_APERTURE_SIZE),
    .PF3_BAR2_CONTROL (PF3_BAR2_CONTROL),
    .PF3_BAR3_APERTURE_SIZE (PF3_BAR3_APERTURE_SIZE),
    .PF3_BAR3_CONTROL (PF3_BAR3_CONTROL),
    .PF3_BAR4_APERTURE_SIZE (PF3_BAR4_APERTURE_SIZE),
    .PF3_BAR4_CONTROL (PF3_BAR4_CONTROL),
    .PF3_BAR5_APERTURE_SIZE (PF3_BAR5_APERTURE_SIZE),
    .PF3_BAR5_CONTROL (PF3_BAR5_CONTROL),
    .PF3_BIST_REGISTER (PF3_BIST_REGISTER),
    .PF3_CAPABILITY_POINTER (PF3_CAPABILITY_POINTER),
    .PF3_CLASS_CODE (PF3_CLASS_CODE),
    .PF3_DEV_CAP_MAX_PAYLOAD_SIZE (PF3_DEV_CAP_MAX_PAYLOAD_SIZE),
    .PF3_DEVICE_ID (PF3_DEVICE_ID),
    .PF3_DPA_CAP_NEXTPTR (PF3_DPA_CAP_NEXTPTR),
    .PF3_DPA_CAP_SUB_STATE_CONTROL (PF3_DPA_CAP_SUB_STATE_CONTROL),
    .PF3_DPA_CAP_SUB_STATE_CONTROL_EN (PF3_DPA_CAP_SUB_STATE_CONTROL_EN),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION0 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION0),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION1 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION1),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION2 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION2),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION3 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION3),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION4 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION4),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION5 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION5),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION6 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION6),
    .PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION7 (PF3_DPA_CAP_SUB_STATE_POWER_ALLOCATION7),
    .PF3_DPA_CAP_VER (PF3_DPA_CAP_VER),
    .PF3_DSN_CAP_NEXTPTR (PF3_DSN_CAP_NEXTPTR),
    .PF3_EXPANSION_ROM_APERTURE_SIZE (PF3_EXPANSION_ROM_APERTURE_SIZE),
    .PF3_EXPANSION_ROM_ENABLE (PF3_EXPANSION_ROM_ENABLE),
    .PF3_INTERRUPT_LINE (PF3_INTERRUPT_LINE),
    .PF3_INTERRUPT_PIN (PF3_INTERRUPT_PIN),
    .PF3_MSI_CAP_MULTIMSGCAP (PF3_MSI_CAP_MULTIMSGCAP),
    .PF3_MSI_CAP_NEXTPTR (PF3_MSI_CAP_NEXTPTR),
    .PF3_MSI_CAP_PERVECMASKCAP (PF3_MSI_CAP_PERVECMASKCAP),
    .PF3_MSIX_CAP_NEXTPTR (PF3_MSIX_CAP_NEXTPTR),
    .PF3_MSIX_CAP_PBA_BIR (PF3_MSIX_CAP_PBA_BIR),
    .PF3_MSIX_CAP_PBA_OFFSET (PF3_MSIX_CAP_PBA_OFFSET),
    .PF3_MSIX_CAP_TABLE_BIR (PF3_MSIX_CAP_TABLE_BIR),
    .PF3_MSIX_CAP_TABLE_OFFSET (PF3_MSIX_CAP_TABLE_OFFSET),
    .PF3_MSIX_CAP_TABLE_SIZE (PF3_MSIX_CAP_TABLE_SIZE),
    .PF3_PB_CAP_DATA_REG_D0 (PF3_PB_CAP_DATA_REG_D0),
    .PF3_PB_CAP_DATA_REG_D0_SUSTAINED (PF3_PB_CAP_DATA_REG_D0_SUSTAINED),
    .PF3_PB_CAP_DATA_REG_D1 (PF3_PB_CAP_DATA_REG_D1),
    .PF3_PB_CAP_DATA_REG_D3HOT (PF3_PB_CAP_DATA_REG_D3HOT),
    .PF3_PB_CAP_NEXTPTR (PF3_PB_CAP_NEXTPTR),
    .PF3_PB_CAP_SYSTEM_ALLOCATED (PF3_PB_CAP_SYSTEM_ALLOCATED),
    .PF3_PB_CAP_VER (PF3_PB_CAP_VER),
    .PF3_PM_CAP_ID (PF3_PM_CAP_ID),
    .PF3_PM_CAP_NEXTPTR (PF3_PM_CAP_NEXTPTR),
    .PF3_PM_CAP_VER_ID (PF3_PM_CAP_VER_ID),
    .PF3_RBAR_CAP_ENABLE (PF3_RBAR_CAP_ENABLE),
    .PF3_RBAR_CAP_NEXTPTR (PF3_RBAR_CAP_NEXTPTR),
    .PF3_RBAR_CAP_SIZE0 (PF3_RBAR_CAP_SIZE0),
    .PF3_RBAR_CAP_SIZE1 (PF3_RBAR_CAP_SIZE1),
    .PF3_RBAR_CAP_SIZE2 (PF3_RBAR_CAP_SIZE2),
    .PF3_RBAR_CAP_VER (PF3_RBAR_CAP_VER),
    .PF3_RBAR_CONTROL_INDEX0 (PF3_RBAR_CONTROL_INDEX0),
    .PF3_RBAR_CONTROL_INDEX1 (PF3_RBAR_CONTROL_INDEX1),
    .PF3_RBAR_CONTROL_INDEX2 (PF3_RBAR_CONTROL_INDEX2),
    .PF3_RBAR_CONTROL_SIZE0 (PF3_RBAR_CONTROL_SIZE0),
    .PF3_RBAR_CONTROL_SIZE1 (PF3_RBAR_CONTROL_SIZE1),
    .PF3_RBAR_CONTROL_SIZE2 (PF3_RBAR_CONTROL_SIZE2),
    .PF3_RBAR_NUM (PF3_RBAR_NUM),
    .PF3_REVISION_ID (PF3_REVISION_ID),
    .PF3_SRIOV_BAR0_APERTURE_SIZE (PF3_SRIOV_BAR0_APERTURE_SIZE),
    .PF3_SRIOV_BAR0_CONTROL (PF3_SRIOV_BAR0_CONTROL),
    .PF3_SRIOV_BAR1_APERTURE_SIZE (PF3_SRIOV_BAR1_APERTURE_SIZE),
    .PF3_SRIOV_BAR1_CONTROL (PF3_SRIOV_BAR1_CONTROL),
    .PF3_SRIOV_BAR2_APERTURE_SIZE (PF3_SRIOV_BAR2_APERTURE_SIZE),
    .PF3_SRIOV_BAR2_CONTROL (PF3_SRIOV_BAR2_CONTROL),
    .PF3_SRIOV_BAR3_APERTURE_SIZE (PF3_SRIOV_BAR3_APERTURE_SIZE),
    .PF3_SRIOV_BAR3_CONTROL (PF3_SRIOV_BAR3_CONTROL),
    .PF3_SRIOV_BAR4_APERTURE_SIZE (PF3_SRIOV_BAR4_APERTURE_SIZE),
    .PF3_SRIOV_BAR4_CONTROL (PF3_SRIOV_BAR4_CONTROL),
    .PF3_SRIOV_BAR5_APERTURE_SIZE (PF3_SRIOV_BAR5_APERTURE_SIZE),
    .PF3_SRIOV_BAR5_CONTROL (PF3_SRIOV_BAR5_CONTROL),
    .PF3_SRIOV_CAP_INITIAL_VF (PF3_SRIOV_CAP_INITIAL_VF),
    .PF3_SRIOV_CAP_NEXTPTR (PF3_SRIOV_CAP_NEXTPTR),
    .PF3_SRIOV_CAP_TOTAL_VF (PF3_SRIOV_CAP_TOTAL_VF),
    .PF3_SRIOV_CAP_VER (PF3_SRIOV_CAP_VER),
    .PF3_SRIOV_FIRST_VF_OFFSET (PF3_SRIOV_FIRST_VF_OFFSET),
    .PF3_SRIOV_FUNC_DEP_LINK (PF3_SRIOV_FUNC_DEP_LINK),
    .PF3_SRIOV_SUPPORTED_PAGE_SIZE (PF3_SRIOV_SUPPORTED_PAGE_SIZE),
    .PF3_SRIOV_VF_DEVICE_ID (PF3_SRIOV_VF_DEVICE_ID),
    .PF3_SUBSYSTEM_ID (PF3_SUBSYSTEM_ID),
    .PF3_TPHR_CAP_DEV_SPECIFIC_MODE (PF3_TPHR_CAP_DEV_SPECIFIC_MODE),
    .PF3_TPHR_CAP_ENABLE (PF3_TPHR_CAP_ENABLE),
    .PF3_TPHR_CAP_INT_VEC_MODE (PF3_TPHR_CAP_INT_VEC_MODE),
    .PF3_TPHR_CAP_NEXTPTR (PF3_TPHR_CAP_NEXTPTR),
    .PF3_TPHR_CAP_ST_MODE_SEL (PF3_TPHR_CAP_ST_MODE_SEL),
    .PF3_TPHR_CAP_ST_TABLE_LOC (PF3_TPHR_CAP_ST_TABLE_LOC),
    .PF3_TPHR_CAP_ST_TABLE_SIZE (PF3_TPHR_CAP_ST_TABLE_SIZE),
    .PF3_TPHR_CAP_VER (PF3_TPHR_CAP_VER),
    .PL_DISABLE_AUTO_EQ_SPEED_CHANGE_TO_GEN3 (PL_DISABLE_AUTO_EQ_SPEED_CHANGE_TO_GEN3),
    .PL_DISABLE_AUTO_SPEED_CHANGE_TO_GEN2 (PL_DISABLE_AUTO_SPEED_CHANGE_TO_GEN2),
    .PL_DISABLE_EI_INFER_IN_L0 (PL_DISABLE_EI_INFER_IN_L0),
    .PL_DISABLE_GEN3_DC_BALANCE (PL_DISABLE_GEN3_DC_BALANCE),
    .PL_DISABLE_GEN3_LFSR_UPDATE_ON_SKP (PL_DISABLE_GEN3_LFSR_UPDATE_ON_SKP),
    .PL_DISABLE_RETRAIN_ON_FRAMING_ERROR (PL_DISABLE_RETRAIN_ON_FRAMING_ERROR),
    .PL_DISABLE_SCRAMBLING (PL_DISABLE_SCRAMBLING),
    .PL_DISABLE_SYNC_HEADER_FRAMING_ERROR (PL_DISABLE_SYNC_HEADER_FRAMING_ERROR),
    .PL_DISABLE_UPCONFIG_CAPABLE (PL_DISABLE_UPCONFIG_CAPABLE),
    .PL_EQ_ADAPT_DISABLE_COEFF_CHECK (PL_EQ_ADAPT_DISABLE_COEFF_CHECK),
    .PL_EQ_ADAPT_DISABLE_PRESET_CHECK (PL_EQ_ADAPT_DISABLE_PRESET_CHECK),
    .PL_EQ_ADAPT_ITER_COUNT (PL_EQ_ADAPT_ITER_COUNT),
    .PL_EQ_ADAPT_REJECT_RETRY_COUNT (PL_EQ_ADAPT_REJECT_RETRY_COUNT),
    .PL_EQ_BYPASS_PHASE23 (PL_EQ_BYPASS_PHASE23),
    .PL_EQ_DEFAULT_GEN3_RX_PRESET_HINT (PL_EQ_DEFAULT_GEN3_RX_PRESET_HINT),
    .PL_EQ_DEFAULT_GEN3_TX_PRESET (PL_EQ_DEFAULT_GEN3_TX_PRESET),
    .PL_EQ_PHASE01_RX_ADAPT (PL_EQ_PHASE01_RX_ADAPT),
    .PL_EQ_SHORT_ADAPT_PHASE (PL_EQ_SHORT_ADAPT_PHASE),
    .PL_LANE0_EQ_CONTROL (PL_LANE0_EQ_CONTROL),
    .PL_LANE1_EQ_CONTROL (PL_LANE1_EQ_CONTROL),
    .PL_LANE2_EQ_CONTROL (PL_LANE2_EQ_CONTROL),
    .PL_LANE3_EQ_CONTROL (PL_LANE3_EQ_CONTROL),
    .PL_LANE4_EQ_CONTROL (PL_LANE4_EQ_CONTROL),
    .PL_LANE5_EQ_CONTROL (PL_LANE5_EQ_CONTROL),
    .PL_LANE6_EQ_CONTROL (PL_LANE6_EQ_CONTROL),
    .PL_LANE7_EQ_CONTROL (PL_LANE7_EQ_CONTROL),
    .PL_LINK_CAP_MAX_LINK_SPEED (PL_LINK_CAP_MAX_LINK_SPEED),
    .PL_LINK_CAP_MAX_LINK_WIDTH (PL_LINK_CAP_MAX_LINK_WIDTH),
    .PL_N_FTS_COMCLK_GEN1 (PL_N_FTS_COMCLK_GEN1),
    .PL_N_FTS_COMCLK_GEN2 (PL_N_FTS_COMCLK_GEN2),
    .PL_N_FTS_COMCLK_GEN3 (PL_N_FTS_COMCLK_GEN3),
    .PL_N_FTS_GEN1 (PL_N_FTS_GEN1),
    .PL_N_FTS_GEN2 (PL_N_FTS_GEN2),
    .PL_N_FTS_GEN3 (PL_N_FTS_GEN3),
    .PL_REPORT_ALL_PHY_ERRORS (PL_REPORT_ALL_PHY_ERRORS),
  // synthesis translate_off
    .PL_SIM_FAST_LINK_TRAINING (PL_SIM_FAST_LINK_TRAINING),
  // synthesis translate_on
    .PL_UPSTREAM_FACING (PL_UPSTREAM_FACING),
    .PM_ASPML0S_TIMEOUT (PM_ASPML0S_TIMEOUT),
    .PM_ASPML1_ENTRY_DELAY (PM_ASPML1_ENTRY_DELAY),
    .PM_ENABLE_L23_ENTRY (PM_ENABLE_L23_ENTRY),
    .PM_ENABLE_SLOT_POWER_CAPTURE (PM_ENABLE_SLOT_POWER_CAPTURE),
    .PM_L1_REENTRY_DELAY (PM_L1_REENTRY_DELAY),
    .PM_PME_SERVICE_TIMEOUT_DELAY (PM_PME_SERVICE_TIMEOUT_DELAY),
    .PM_PME_TURNOFF_ACK_DELAY (PM_PME_TURNOFF_ACK_DELAY),
    .SIM_JTAG_IDCODE (SIM_JTAG_IDCODE),
    .SIM_VERSION (SIM_VERSION),
    .SPARE_BIT0 (SPARE_BIT0),
    .SPARE_BIT1 (SPARE_BIT1),
    .SPARE_BIT2 (SPARE_BIT2),
    .SPARE_BIT3 (SPARE_BIT3),
    .SPARE_BIT4 (SPARE_BIT4),
    .SPARE_BIT5 (SPARE_BIT5),
    .SPARE_BIT6 (SPARE_BIT6),
    .SPARE_BIT7 (SPARE_BIT7),
    .SPARE_BIT8 (SPARE_BIT8),
    .SPARE_BYTE0 (SPARE_BYTE0),
    .SPARE_BYTE1 (SPARE_BYTE1),
    .SPARE_BYTE2 (SPARE_BYTE2),
    .SPARE_BYTE3 (SPARE_BYTE3),
    .SPARE_WORD0 (SPARE_WORD0),
    .SPARE_WORD1 (SPARE_WORD1),
    .SPARE_WORD2 (SPARE_WORD2),
    .SPARE_WORD3 (SPARE_WORD3),
    .SRIOV_CAP_ENABLE (SRIOV_CAP_ENABLE),
    .TL_COMPLETION_RAM_SIZE_16K (TL_COMPLETION_RAM_SIZE_16K),
    .TL_COMPL_TIMEOUT_REG0 (TL_COMPL_TIMEOUT_REG0),
    .TL_COMPL_TIMEOUT_REG1 (TL_COMPL_TIMEOUT_REG1),
    .TL_CREDITS_CD (TL_CREDITS_CD),
    .TL_CREDITS_CH (TL_CREDITS_CH),
    .TL_CREDITS_NPD (TL_CREDITS_NPD),
    .TL_CREDITS_NPH (TL_CREDITS_NPH),
    .TL_CREDITS_PD (TL_CREDITS_PD),
    .TL_CREDITS_PH (TL_CREDITS_PH),
    .TL_ENABLE_MESSAGE_RID_CHECK_ENABLE (TL_ENABLE_MESSAGE_RID_CHECK_ENABLE),
    .TL_EXTENDED_CFG_EXTEND_INTERFACE_ENABLE (TL_EXTENDED_CFG_EXTEND_INTERFACE_ENABLE),
    .TL_LEGACY_CFG_EXTEND_INTERFACE_ENABLE (TL_LEGACY_CFG_EXTEND_INTERFACE_ENABLE),
    .TL_LEGACY_MODE_ENABLE (TL_LEGACY_MODE_ENABLE),
    .TL_PF_ENABLE_REG (TL_PF_ENABLE_REG),
    .TL_TX_MUX_STRICT_PRIORITY (TL_TX_MUX_STRICT_PRIORITY),
    .TWO_LAYER_MODE_DLCMSM_ENABLE (TWO_LAYER_MODE_DLCMSM_ENABLE),
    .TWO_LAYER_MODE_ENABLE (TWO_LAYER_MODE_ENABLE),
    .TWO_LAYER_MODE_WIDTH_256 (TWO_LAYER_MODE_WIDTH_256),
    .VF0_ARI_CAP_NEXTPTR (VF0_ARI_CAP_NEXTPTR),
    .VF0_CAPABILITY_POINTER (VF0_CAPABILITY_POINTER),
    .VF0_MSI_CAP_MULTIMSGCAP (VF0_MSI_CAP_MULTIMSGCAP),
    .VF0_MSIX_CAP_PBA_BIR (VF0_MSIX_CAP_PBA_BIR),
    .VF0_MSIX_CAP_PBA_OFFSET (VF0_MSIX_CAP_PBA_OFFSET),
    .VF0_MSIX_CAP_TABLE_BIR (VF0_MSIX_CAP_TABLE_BIR),
    .VF0_MSIX_CAP_TABLE_OFFSET (VF0_MSIX_CAP_TABLE_OFFSET),
    .VF0_MSIX_CAP_TABLE_SIZE (VF0_MSIX_CAP_TABLE_SIZE),
    .VF0_PM_CAP_ID (VF0_PM_CAP_ID),
    .VF0_PM_CAP_NEXTPTR (VF0_PM_CAP_NEXTPTR),
    .VF0_PM_CAP_VER_ID (VF0_PM_CAP_VER_ID),
    .VF0_TPHR_CAP_DEV_SPECIFIC_MODE (VF0_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF0_TPHR_CAP_ENABLE (VF0_TPHR_CAP_ENABLE),
    .VF0_TPHR_CAP_INT_VEC_MODE (VF0_TPHR_CAP_INT_VEC_MODE),
    .VF0_TPHR_CAP_NEXTPTR (VF0_TPHR_CAP_NEXTPTR),
    .VF0_TPHR_CAP_ST_MODE_SEL (VF0_TPHR_CAP_ST_MODE_SEL),
    .VF0_TPHR_CAP_ST_TABLE_LOC (VF0_TPHR_CAP_ST_TABLE_LOC),
    .VF0_TPHR_CAP_ST_TABLE_SIZE (VF0_TPHR_CAP_ST_TABLE_SIZE),
    .VF0_TPHR_CAP_VER (VF0_TPHR_CAP_VER),
    .VF1_ARI_CAP_NEXTPTR (VF1_ARI_CAP_NEXTPTR),
    .VF1_MSI_CAP_MULTIMSGCAP (VF1_MSI_CAP_MULTIMSGCAP),
    .VF1_MSIX_CAP_PBA_BIR (VF1_MSIX_CAP_PBA_BIR),
    .VF1_MSIX_CAP_PBA_OFFSET (VF1_MSIX_CAP_PBA_OFFSET),
    .VF1_MSIX_CAP_TABLE_BIR (VF1_MSIX_CAP_TABLE_BIR),
    .VF1_MSIX_CAP_TABLE_OFFSET (VF1_MSIX_CAP_TABLE_OFFSET),
    .VF1_MSIX_CAP_TABLE_SIZE (VF1_MSIX_CAP_TABLE_SIZE),
    .VF1_PM_CAP_ID (VF1_PM_CAP_ID),
    .VF1_PM_CAP_NEXTPTR (VF1_PM_CAP_NEXTPTR),
    .VF1_PM_CAP_VER_ID (VF1_PM_CAP_VER_ID),
    .VF1_TPHR_CAP_DEV_SPECIFIC_MODE (VF1_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF1_TPHR_CAP_ENABLE (VF1_TPHR_CAP_ENABLE),
    .VF1_TPHR_CAP_INT_VEC_MODE (VF1_TPHR_CAP_INT_VEC_MODE),
    .VF1_TPHR_CAP_NEXTPTR (VF1_TPHR_CAP_NEXTPTR),
    .VF1_TPHR_CAP_ST_MODE_SEL (VF1_TPHR_CAP_ST_MODE_SEL),
    .VF1_TPHR_CAP_ST_TABLE_LOC (VF1_TPHR_CAP_ST_TABLE_LOC),
    .VF1_TPHR_CAP_ST_TABLE_SIZE (VF1_TPHR_CAP_ST_TABLE_SIZE),
    .VF1_TPHR_CAP_VER (VF1_TPHR_CAP_VER),
    .VF2_ARI_CAP_NEXTPTR (VF2_ARI_CAP_NEXTPTR),
    .VF2_MSI_CAP_MULTIMSGCAP (VF2_MSI_CAP_MULTIMSGCAP),
    .VF2_MSIX_CAP_PBA_BIR (VF2_MSIX_CAP_PBA_BIR),
    .VF2_MSIX_CAP_PBA_OFFSET (VF2_MSIX_CAP_PBA_OFFSET),
    .VF2_MSIX_CAP_TABLE_BIR (VF2_MSIX_CAP_TABLE_BIR),
    .VF2_MSIX_CAP_TABLE_OFFSET (VF2_MSIX_CAP_TABLE_OFFSET),
    .VF2_MSIX_CAP_TABLE_SIZE (VF2_MSIX_CAP_TABLE_SIZE),
    .VF2_PM_CAP_ID (VF2_PM_CAP_ID),
    .VF2_PM_CAP_NEXTPTR (VF2_PM_CAP_NEXTPTR),
    .VF2_PM_CAP_VER_ID (VF2_PM_CAP_VER_ID),
    .VF2_TPHR_CAP_DEV_SPECIFIC_MODE (VF2_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF2_TPHR_CAP_ENABLE (VF2_TPHR_CAP_ENABLE),
    .VF2_TPHR_CAP_INT_VEC_MODE (VF2_TPHR_CAP_INT_VEC_MODE),
    .VF2_TPHR_CAP_NEXTPTR (VF2_TPHR_CAP_NEXTPTR),
    .VF2_TPHR_CAP_ST_MODE_SEL (VF2_TPHR_CAP_ST_MODE_SEL),
    .VF2_TPHR_CAP_ST_TABLE_LOC (VF2_TPHR_CAP_ST_TABLE_LOC),
    .VF2_TPHR_CAP_ST_TABLE_SIZE (VF2_TPHR_CAP_ST_TABLE_SIZE),
    .VF2_TPHR_CAP_VER (VF2_TPHR_CAP_VER),
    .VF3_ARI_CAP_NEXTPTR (VF3_ARI_CAP_NEXTPTR),
    .VF3_MSI_CAP_MULTIMSGCAP (VF3_MSI_CAP_MULTIMSGCAP),
    .VF3_MSIX_CAP_PBA_BIR (VF3_MSIX_CAP_PBA_BIR),
    .VF3_MSIX_CAP_PBA_OFFSET (VF3_MSIX_CAP_PBA_OFFSET),
    .VF3_MSIX_CAP_TABLE_BIR (VF3_MSIX_CAP_TABLE_BIR),
    .VF3_MSIX_CAP_TABLE_OFFSET (VF3_MSIX_CAP_TABLE_OFFSET),
    .VF3_MSIX_CAP_TABLE_SIZE (VF3_MSIX_CAP_TABLE_SIZE),
    .VF3_PM_CAP_ID (VF3_PM_CAP_ID),
    .VF3_PM_CAP_NEXTPTR (VF3_PM_CAP_NEXTPTR),
    .VF3_PM_CAP_VER_ID (VF3_PM_CAP_VER_ID),
    .VF3_TPHR_CAP_DEV_SPECIFIC_MODE (VF3_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF3_TPHR_CAP_ENABLE (VF3_TPHR_CAP_ENABLE),
    .VF3_TPHR_CAP_INT_VEC_MODE (VF3_TPHR_CAP_INT_VEC_MODE),
    .VF3_TPHR_CAP_NEXTPTR (VF3_TPHR_CAP_NEXTPTR),
    .VF3_TPHR_CAP_ST_MODE_SEL (VF3_TPHR_CAP_ST_MODE_SEL),
    .VF3_TPHR_CAP_ST_TABLE_LOC (VF3_TPHR_CAP_ST_TABLE_LOC),
    .VF3_TPHR_CAP_ST_TABLE_SIZE (VF3_TPHR_CAP_ST_TABLE_SIZE),
    .VF3_TPHR_CAP_VER (VF3_TPHR_CAP_VER),
    .VF4_ARI_CAP_NEXTPTR (VF4_ARI_CAP_NEXTPTR),
    .VF4_MSI_CAP_MULTIMSGCAP (VF4_MSI_CAP_MULTIMSGCAP),
    .VF4_MSIX_CAP_PBA_BIR (VF4_MSIX_CAP_PBA_BIR),
    .VF4_MSIX_CAP_PBA_OFFSET (VF4_MSIX_CAP_PBA_OFFSET),
    .VF4_MSIX_CAP_TABLE_BIR (VF4_MSIX_CAP_TABLE_BIR),
    .VF4_MSIX_CAP_TABLE_OFFSET (VF4_MSIX_CAP_TABLE_OFFSET),
    .VF4_MSIX_CAP_TABLE_SIZE (VF4_MSIX_CAP_TABLE_SIZE),
    .VF4_PM_CAP_ID (VF4_PM_CAP_ID),
    .VF4_PM_CAP_NEXTPTR (VF4_PM_CAP_NEXTPTR),
    .VF4_PM_CAP_VER_ID (VF4_PM_CAP_VER_ID),
    .VF4_TPHR_CAP_DEV_SPECIFIC_MODE (VF4_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF4_TPHR_CAP_ENABLE (VF4_TPHR_CAP_ENABLE),
    .VF4_TPHR_CAP_INT_VEC_MODE (VF4_TPHR_CAP_INT_VEC_MODE),
    .VF4_TPHR_CAP_NEXTPTR (VF4_TPHR_CAP_NEXTPTR),
    .VF4_TPHR_CAP_ST_MODE_SEL (VF4_TPHR_CAP_ST_MODE_SEL),
    .VF4_TPHR_CAP_ST_TABLE_LOC (VF4_TPHR_CAP_ST_TABLE_LOC),
    .VF4_TPHR_CAP_ST_TABLE_SIZE (VF4_TPHR_CAP_ST_TABLE_SIZE),
    .VF4_TPHR_CAP_VER (VF4_TPHR_CAP_VER),
    .VF5_ARI_CAP_NEXTPTR (VF5_ARI_CAP_NEXTPTR),
    .VF5_MSI_CAP_MULTIMSGCAP (VF5_MSI_CAP_MULTIMSGCAP),
    .VF5_MSIX_CAP_PBA_BIR (VF5_MSIX_CAP_PBA_BIR),
    .VF5_MSIX_CAP_PBA_OFFSET (VF5_MSIX_CAP_PBA_OFFSET),
    .VF5_MSIX_CAP_TABLE_BIR (VF5_MSIX_CAP_TABLE_BIR),
    .VF5_MSIX_CAP_TABLE_OFFSET (VF5_MSIX_CAP_TABLE_OFFSET),
    .VF5_MSIX_CAP_TABLE_SIZE (VF5_MSIX_CAP_TABLE_SIZE),
    .VF5_PM_CAP_ID (VF5_PM_CAP_ID),
    .VF5_PM_CAP_NEXTPTR (VF5_PM_CAP_NEXTPTR),
    .VF5_PM_CAP_VER_ID (VF5_PM_CAP_VER_ID),
    .VF5_TPHR_CAP_DEV_SPECIFIC_MODE (VF5_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF5_TPHR_CAP_ENABLE (VF5_TPHR_CAP_ENABLE),
    .VF5_TPHR_CAP_INT_VEC_MODE (VF5_TPHR_CAP_INT_VEC_MODE),
    .VF5_TPHR_CAP_NEXTPTR (VF5_TPHR_CAP_NEXTPTR),
    .VF5_TPHR_CAP_ST_MODE_SEL (VF5_TPHR_CAP_ST_MODE_SEL),
    .VF5_TPHR_CAP_ST_TABLE_LOC (VF5_TPHR_CAP_ST_TABLE_LOC),
    .VF5_TPHR_CAP_ST_TABLE_SIZE (VF5_TPHR_CAP_ST_TABLE_SIZE),
    .VF5_TPHR_CAP_VER (VF5_TPHR_CAP_VER),
    .VF6_ARI_CAP_NEXTPTR (VF6_ARI_CAP_NEXTPTR),
    .VF6_MSI_CAP_MULTIMSGCAP (VF6_MSI_CAP_MULTIMSGCAP),
    .VF6_MSIX_CAP_PBA_BIR (VF6_MSIX_CAP_PBA_BIR),
    .VF6_MSIX_CAP_PBA_OFFSET (VF6_MSIX_CAP_PBA_OFFSET),
    .VF6_MSIX_CAP_TABLE_BIR (VF6_MSIX_CAP_TABLE_BIR),
    .VF6_MSIX_CAP_TABLE_OFFSET (VF6_MSIX_CAP_TABLE_OFFSET),
    .VF6_MSIX_CAP_TABLE_SIZE (VF6_MSIX_CAP_TABLE_SIZE),
    .VF6_PM_CAP_ID (VF6_PM_CAP_ID),
    .VF6_PM_CAP_NEXTPTR (VF6_PM_CAP_NEXTPTR),
    .VF6_PM_CAP_VER_ID (VF6_PM_CAP_VER_ID),
    .VF6_TPHR_CAP_DEV_SPECIFIC_MODE (VF6_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF6_TPHR_CAP_ENABLE (VF6_TPHR_CAP_ENABLE),
    .VF6_TPHR_CAP_INT_VEC_MODE (VF6_TPHR_CAP_INT_VEC_MODE),
    .VF6_TPHR_CAP_NEXTPTR (VF6_TPHR_CAP_NEXTPTR),
    .VF6_TPHR_CAP_ST_MODE_SEL (VF6_TPHR_CAP_ST_MODE_SEL),
    .VF6_TPHR_CAP_ST_TABLE_LOC (VF6_TPHR_CAP_ST_TABLE_LOC),
    .VF6_TPHR_CAP_ST_TABLE_SIZE (VF6_TPHR_CAP_ST_TABLE_SIZE),
    .VF6_TPHR_CAP_VER (VF6_TPHR_CAP_VER),
    .VF7_ARI_CAP_NEXTPTR (VF7_ARI_CAP_NEXTPTR),
    .VF7_MSI_CAP_MULTIMSGCAP (VF7_MSI_CAP_MULTIMSGCAP),
    .VF7_MSIX_CAP_PBA_BIR (VF7_MSIX_CAP_PBA_BIR),
    .VF7_MSIX_CAP_PBA_OFFSET (VF7_MSIX_CAP_PBA_OFFSET),
    .VF7_MSIX_CAP_TABLE_BIR (VF7_MSIX_CAP_TABLE_BIR),
    .VF7_MSIX_CAP_TABLE_OFFSET (VF7_MSIX_CAP_TABLE_OFFSET),
    .VF7_MSIX_CAP_TABLE_SIZE (VF7_MSIX_CAP_TABLE_SIZE),
    .VF7_PM_CAP_ID (VF7_PM_CAP_ID),
    .VF7_PM_CAP_NEXTPTR (VF7_PM_CAP_NEXTPTR),
    .VF7_PM_CAP_VER_ID (VF7_PM_CAP_VER_ID),
    .VF7_TPHR_CAP_DEV_SPECIFIC_MODE (VF7_TPHR_CAP_DEV_SPECIFIC_MODE),
    .VF7_TPHR_CAP_ENABLE (VF7_TPHR_CAP_ENABLE),
    .VF7_TPHR_CAP_INT_VEC_MODE (VF7_TPHR_CAP_INT_VEC_MODE),
    .VF7_TPHR_CAP_NEXTPTR (VF7_TPHR_CAP_NEXTPTR),
    .VF7_TPHR_CAP_ST_MODE_SEL (VF7_TPHR_CAP_ST_MODE_SEL),
    .VF7_TPHR_CAP_ST_TABLE_LOC (VF7_TPHR_CAP_ST_TABLE_LOC),
    .VF7_TPHR_CAP_ST_TABLE_SIZE (VF7_TPHR_CAP_ST_TABLE_SIZE),
    .VF7_TPHR_CAP_VER (VF7_TPHR_CAP_VER))
  PCIE_3_1_inst (
    .CFGCONFIGSPACEENABLE (CFGCONFIGSPACEENABLE),
    .CFGDEVID (CFGDEVID),
    .CFGDSBUSNUMBER (CFGDSBUSNUMBER),
    .CFGDSDEVICENUMBER (CFGDSDEVICENUMBER),
    .CFGDSFUNCTIONNUMBER (CFGDSFUNCTIONNUMBER),
    .CFGDSN (CFGDSN),
    .CFGDSPORTNUMBER (CFGDSPORTNUMBER),
    .CFGERRCORIN (CFGERRCORIN),
    .CFGERRUNCORIN (CFGERRUNCORIN),
    .CFGEXTREADDATA (CFGEXTREADDATA),
    .CFGEXTREADDATAVALID (CFGEXTREADDATAVALID),
    .CFGFCSEL (CFGFCSEL),
    .CFGFLRDONE (CFGFLRDONE),
    .CFGHOTRESETIN (CFGHOTRESETIN),
    .CFGINTERRUPTINT (CFGINTERRUPTINT),
    .CFGINTERRUPTMSIATTR (CFGINTERRUPTMSIATTR),
    .CFGINTERRUPTMSIFUNCTIONNUMBER (CFGINTERRUPTMSIFUNCTIONNUMBER),
    .CFGINTERRUPTMSIINT (CFGINTERRUPTMSIINT),
    .CFGINTERRUPTMSIPENDINGSTATUS (CFGINTERRUPTMSIPENDINGSTATUS),
    .CFGINTERRUPTMSIPENDINGSTATUSDATAENABLE (CFGINTERRUPTMSIPENDINGSTATUSDATAENABLE),
    .CFGINTERRUPTMSIPENDINGSTATUSFUNCTIONNUM (CFGINTERRUPTMSIPENDINGSTATUSFUNCTIONNUM),
    .CFGINTERRUPTMSISELECT (CFGINTERRUPTMSISELECT),
    .CFGINTERRUPTMSITPHPRESENT (CFGINTERRUPTMSITPHPRESENT),
    .CFGINTERRUPTMSITPHSTTAG (CFGINTERRUPTMSITPHSTTAG),
    .CFGINTERRUPTMSITPHTYPE (CFGINTERRUPTMSITPHTYPE),
    .CFGINTERRUPTMSIXADDRESS (CFGINTERRUPTMSIXADDRESS),
    .CFGINTERRUPTMSIXDATA (CFGINTERRUPTMSIXDATA),
    .CFGINTERRUPTMSIXINT (CFGINTERRUPTMSIXINT),
    .CFGINTERRUPTPENDING (CFGINTERRUPTPENDING),
    .CFGLINKTRAININGENABLE (CFGLINKTRAININGENABLE),
    .CFGMGMTADDR (CFGMGMTADDR),
    .CFGMGMTBYTEENABLE (CFGMGMTBYTEENABLE),
    .CFGMGMTREAD (CFGMGMTREAD),
    .CFGMGMTTYPE1CFGREGACCESS (CFGMGMTTYPE1CFGREGACCESS),
    .CFGMGMTWRITE (CFGMGMTWRITE),
    .CFGMGMTWRITEDATA (CFGMGMTWRITEDATA),
    .CFGMSGTRANSMIT (CFGMSGTRANSMIT),
    .CFGMSGTRANSMITDATA (CFGMSGTRANSMITDATA),
    .CFGMSGTRANSMITTYPE (CFGMSGTRANSMITTYPE),
    .CFGPERFUNCSTATUSCONTROL (CFGPERFUNCSTATUSCONTROL),
    .CFGPERFUNCTIONNUMBER (CFGPERFUNCTIONNUMBER),
    .CFGPERFUNCTIONOUTPUTREQUEST (CFGPERFUNCTIONOUTPUTREQUEST),
    .CFGPOWERSTATECHANGEACK (CFGPOWERSTATECHANGEACK),
    .CFGREQPMTRANSITIONL23READY (CFGREQPMTRANSITIONL23READY),
    .CFGREVID (CFGREVID),
    .CFGSUBSYSID (CFGSUBSYSID),
    .CFGSUBSYSVENDID (CFGSUBSYSVENDID),
    .CFGTPHSTTREADDATA (CFGTPHSTTREADDATA),
    .CFGTPHSTTREADDATAVALID (CFGTPHSTTREADDATAVALID),
    .CFGVENDID (CFGVENDID),
    .CFGVFFLRDONE (CFGVFFLRDONE),
    .CONFMCAPREQUESTBYCONF (CONFMCAPREQUESTBYCONF),
    .CONFREQDATA (CONFREQDATA),
    .CONFREQREGNUM (CONFREQREGNUM),
    .CONFREQTYPE (CONFREQTYPE),
    .CONFREQVALID (CONFREQVALID),
    .CORECLK (CORECLK),
    .CORECLKMICOMPLETIONRAML (CORECLKMICOMPLETIONRAML),
    .CORECLKMICOMPLETIONRAMU (CORECLKMICOMPLETIONRAMU),
    .CORECLKMIREPLAYRAM (CORECLKMIREPLAYRAM),
    .CORECLKMIREQUESTRAM (CORECLKMIREQUESTRAM),
    .DBGCFGLOCALMGMTREGOVERRIDE (DBGCFGLOCALMGMTREGOVERRIDE),
    .DBGDATASEL (DBGDATASEL),
    .DRPADDR (DRPADDR),
    .DRPCLK (DRPCLK),
    .DRPDI (DRPDI),
    .DRPEN (DRPEN),
    .DRPWE (DRPWE),
    .LL2LMSAXISTXTUSER (LL2LMSAXISTXTUSER),
    .LL2LMSAXISTXTVALID (LL2LMSAXISTXTVALID),
    .LL2LMTXTLPID0 (LL2LMTXTLPID0),
    .LL2LMTXTLPID1 (LL2LMTXTLPID1),
    .MAXISCQTREADY (MAXISCQTREADY),
    .MAXISRCTREADY (MAXISRCTREADY),
    .MCAPCLK (MCAPCLK),
    .MCAPPERST0B (MCAPPERST0B),
    .MCAPPERST1B (MCAPPERST1B),
    .MGMTRESETN (MGMTRESETN),
    .MGMTSTICKYRESETN (MGMTSTICKYRESETN),
    .MICOMPLETIONRAMREADDATA (MICOMPLETIONRAMREADDATA),
    .MIREPLAYRAMREADDATA (MIREPLAYRAMREADDATA),
    .MIREQUESTRAMREADDATA (MIREQUESTRAMREADDATA),
    .PCIECQNPREQ (PCIECQNPREQ),
    .PIPECLK (PIPECLK),
    .PIPEEQFS (PIPEEQFS),
    .PIPEEQLF (PIPEEQLF),
    .PIPERESETN (PIPERESETN),
    .PIPERX0CHARISK (PIPERX0CHARISK),
    .PIPERX0DATA (PIPERX0DATA),
    .PIPERX0DATAVALID (PIPERX0DATAVALID),
    .PIPERX0ELECIDLE (PIPERX0ELECIDLE),
    .PIPERX0EQDONE (PIPERX0EQDONE),
    .PIPERX0EQLPADAPTDONE (PIPERX0EQLPADAPTDONE),
    .PIPERX0EQLPLFFSSEL (PIPERX0EQLPLFFSSEL),
    .PIPERX0EQLPNEWTXCOEFFORPRESET (PIPERX0EQLPNEWTXCOEFFORPRESET),
    .PIPERX0PHYSTATUS (PIPERX0PHYSTATUS),
    .PIPERX0STARTBLOCK (PIPERX0STARTBLOCK),
    .PIPERX0STATUS (PIPERX0STATUS),
    .PIPERX0SYNCHEADER (PIPERX0SYNCHEADER),
    .PIPERX0VALID (PIPERX0VALID),
    .PIPERX1CHARISK (PIPERX1CHARISK),
    .PIPERX1DATA (PIPERX1DATA),
    .PIPERX1DATAVALID (PIPERX1DATAVALID),
    .PIPERX1ELECIDLE (PIPERX1ELECIDLE),
    .PIPERX1EQDONE (PIPERX1EQDONE),
    .PIPERX1EQLPADAPTDONE (PIPERX1EQLPADAPTDONE),
    .PIPERX1EQLPLFFSSEL (PIPERX1EQLPLFFSSEL),
    .PIPERX1EQLPNEWTXCOEFFORPRESET (PIPERX1EQLPNEWTXCOEFFORPRESET),
    .PIPERX1PHYSTATUS (PIPERX1PHYSTATUS),
    .PIPERX1STARTBLOCK (PIPERX1STARTBLOCK),
    .PIPERX1STATUS (PIPERX1STATUS),
    .PIPERX1SYNCHEADER (PIPERX1SYNCHEADER),
    .PIPERX1VALID (PIPERX1VALID),
    .PIPERX2CHARISK (PIPERX2CHARISK),
    .PIPERX2DATA (PIPERX2DATA),
    .PIPERX2DATAVALID (PIPERX2DATAVALID),
    .PIPERX2ELECIDLE (PIPERX2ELECIDLE),
    .PIPERX2EQDONE (PIPERX2EQDONE),
    .PIPERX2EQLPADAPTDONE (PIPERX2EQLPADAPTDONE),
    .PIPERX2EQLPLFFSSEL (PIPERX2EQLPLFFSSEL),
    .PIPERX2EQLPNEWTXCOEFFORPRESET (PIPERX2EQLPNEWTXCOEFFORPRESET),
    .PIPERX2PHYSTATUS (PIPERX2PHYSTATUS),
    .PIPERX2STARTBLOCK (PIPERX2STARTBLOCK),
    .PIPERX2STATUS (PIPERX2STATUS),
    .PIPERX2SYNCHEADER (PIPERX2SYNCHEADER),
    .PIPERX2VALID (PIPERX2VALID),
    .PIPERX3CHARISK (PIPERX3CHARISK),
    .PIPERX3DATA (PIPERX3DATA),
    .PIPERX3DATAVALID (PIPERX3DATAVALID),
    .PIPERX3ELECIDLE (PIPERX3ELECIDLE),
    .PIPERX3EQDONE (PIPERX3EQDONE),
    .PIPERX3EQLPADAPTDONE (PIPERX3EQLPADAPTDONE),
    .PIPERX3EQLPLFFSSEL (PIPERX3EQLPLFFSSEL),
    .PIPERX3EQLPNEWTXCOEFFORPRESET (PIPERX3EQLPNEWTXCOEFFORPRESET),
    .PIPERX3PHYSTATUS (PIPERX3PHYSTATUS),
    .PIPERX3STARTBLOCK (PIPERX3STARTBLOCK),
    .PIPERX3STATUS (PIPERX3STATUS),
    .PIPERX3SYNCHEADER (PIPERX3SYNCHEADER),
    .PIPERX3VALID (PIPERX3VALID),
    .PIPERX4CHARISK (PIPERX4CHARISK),
    .PIPERX4DATA (PIPERX4DATA),
    .PIPERX4DATAVALID (PIPERX4DATAVALID),
    .PIPERX4ELECIDLE (PIPERX4ELECIDLE),
    .PIPERX4EQDONE (PIPERX4EQDONE),
    .PIPERX4EQLPADAPTDONE (PIPERX4EQLPADAPTDONE),
    .PIPERX4EQLPLFFSSEL (PIPERX4EQLPLFFSSEL),
    .PIPERX4EQLPNEWTXCOEFFORPRESET (PIPERX4EQLPNEWTXCOEFFORPRESET),
    .PIPERX4PHYSTATUS (PIPERX4PHYSTATUS),
    .PIPERX4STARTBLOCK (PIPERX4STARTBLOCK),
    .PIPERX4STATUS (PIPERX4STATUS),
    .PIPERX4SYNCHEADER (PIPERX4SYNCHEADER),
    .PIPERX4VALID (PIPERX4VALID),
    .PIPERX5CHARISK (PIPERX5CHARISK),
    .PIPERX5DATA (PIPERX5DATA),
    .PIPERX5DATAVALID (PIPERX5DATAVALID),
    .PIPERX5ELECIDLE (PIPERX5ELECIDLE),
    .PIPERX5EQDONE (PIPERX5EQDONE),
    .PIPERX5EQLPADAPTDONE (PIPERX5EQLPADAPTDONE),
    .PIPERX5EQLPLFFSSEL (PIPERX5EQLPLFFSSEL),
    .PIPERX5EQLPNEWTXCOEFFORPRESET (PIPERX5EQLPNEWTXCOEFFORPRESET),
    .PIPERX5PHYSTATUS (PIPERX5PHYSTATUS),
    .PIPERX5STARTBLOCK (PIPERX5STARTBLOCK),
    .PIPERX5STATUS (PIPERX5STATUS),
    .PIPERX5SYNCHEADER (PIPERX5SYNCHEADER),
    .PIPERX5VALID (PIPERX5VALID),
    .PIPERX6CHARISK (PIPERX6CHARISK),
    .PIPERX6DATA (PIPERX6DATA),
    .PIPERX6DATAVALID (PIPERX6DATAVALID),
    .PIPERX6ELECIDLE (PIPERX6ELECIDLE),
    .PIPERX6EQDONE (PIPERX6EQDONE),
    .PIPERX6EQLPADAPTDONE (PIPERX6EQLPADAPTDONE),
    .PIPERX6EQLPLFFSSEL (PIPERX6EQLPLFFSSEL),
    .PIPERX6EQLPNEWTXCOEFFORPRESET (PIPERX6EQLPNEWTXCOEFFORPRESET),
    .PIPERX6PHYSTATUS (PIPERX6PHYSTATUS),
    .PIPERX6STARTBLOCK (PIPERX6STARTBLOCK),
    .PIPERX6STATUS (PIPERX6STATUS),
    .PIPERX6SYNCHEADER (PIPERX6SYNCHEADER),
    .PIPERX6VALID (PIPERX6VALID),
    .PIPERX7CHARISK (PIPERX7CHARISK),
    .PIPERX7DATA (PIPERX7DATA),
    .PIPERX7DATAVALID (PIPERX7DATAVALID),
    .PIPERX7ELECIDLE (PIPERX7ELECIDLE),
    .PIPERX7EQDONE (PIPERX7EQDONE),
    .PIPERX7EQLPADAPTDONE (PIPERX7EQLPADAPTDONE),
    .PIPERX7EQLPLFFSSEL (PIPERX7EQLPLFFSSEL),
    .PIPERX7EQLPNEWTXCOEFFORPRESET (PIPERX7EQLPNEWTXCOEFFORPRESET),
    .PIPERX7PHYSTATUS (PIPERX7PHYSTATUS),
    .PIPERX7STARTBLOCK (PIPERX7STARTBLOCK),
    .PIPERX7STATUS (PIPERX7STATUS),
    .PIPERX7SYNCHEADER (PIPERX7SYNCHEADER),
    .PIPERX7VALID (PIPERX7VALID),
    .PIPETX0EQCOEFF (PIPETX0EQCOEFF),
    .PIPETX0EQDONE (PIPETX0EQDONE),
    .PIPETX1EQCOEFF (PIPETX1EQCOEFF),
    .PIPETX1EQDONE (PIPETX1EQDONE),
    .PIPETX2EQCOEFF (PIPETX2EQCOEFF),
    .PIPETX2EQDONE (PIPETX2EQDONE),
    .PIPETX3EQCOEFF (PIPETX3EQCOEFF),
    .PIPETX3EQDONE (PIPETX3EQDONE),
    .PIPETX4EQCOEFF (PIPETX4EQCOEFF),
    .PIPETX4EQDONE (PIPETX4EQDONE),
    .PIPETX5EQCOEFF (PIPETX5EQCOEFF),
    .PIPETX5EQDONE (PIPETX5EQDONE),
    .PIPETX6EQCOEFF (PIPETX6EQCOEFF),
    .PIPETX6EQDONE (PIPETX6EQDONE),
    .PIPETX7EQCOEFF (PIPETX7EQCOEFF),
    .PIPETX7EQDONE (PIPETX7EQDONE),
    .PLEQRESETEIEOSCOUNT (PLEQRESETEIEOSCOUNT),
    .PLGEN2UPSTREAMPREFERDEEMPH (PLGEN2UPSTREAMPREFERDEEMPH),
    .RESETN (RESETN),
    .SAXISCCTDATA (SAXISCCTDATA),
    .SAXISCCTKEEP (SAXISCCTKEEP),
    .SAXISCCTLAST (SAXISCCTLAST),
    .SAXISCCTUSER (SAXISCCTUSER),
    .SAXISCCTVALID (SAXISCCTVALID),
    .SAXISRQTDATA (SAXISRQTDATA),
    .SAXISRQTKEEP (SAXISRQTKEEP),
    .SAXISRQTLAST (SAXISRQTLAST),
    .SAXISRQTUSER (SAXISRQTUSER),
    .SAXISRQTVALID (SAXISRQTVALID),
    .SPAREIN (SPAREIN),
    .USERCLK (USERCLK),
    .CFGCURRENTSPEED (CFGCURRENTSPEED),
    .CFGDPASUBSTATECHANGE (CFGDPASUBSTATECHANGE),
    .CFGERRCOROUT (CFGERRCOROUT),
    .CFGERRFATALOUT (CFGERRFATALOUT),
    .CFGERRNONFATALOUT (CFGERRNONFATALOUT),
    .CFGEXTFUNCTIONNUMBER (CFGEXTFUNCTIONNUMBER),
    .CFGEXTREADRECEIVED (CFGEXTREADRECEIVED),
    .CFGEXTREGISTERNUMBER (CFGEXTREGISTERNUMBER),
    .CFGEXTWRITEBYTEENABLE (CFGEXTWRITEBYTEENABLE),
    .CFGEXTWRITEDATA (CFGEXTWRITEDATA),
    .CFGEXTWRITERECEIVED (CFGEXTWRITERECEIVED),
    .CFGFCCPLD (CFGFCCPLD),
    .CFGFCCPLH (CFGFCCPLH),
    .CFGFCNPD (CFGFCNPD),
    .CFGFCNPH (CFGFCNPH),
    .CFGFCPD (CFGFCPD),
    .CFGFCPH (CFGFCPH),
    .CFGFLRINPROCESS (CFGFLRINPROCESS),
    .CFGFUNCTIONPOWERSTATE (CFGFUNCTIONPOWERSTATE),
    .CFGFUNCTIONSTATUS (CFGFUNCTIONSTATUS),
    .CFGHOTRESETOUT (CFGHOTRESETOUT),
    .CFGINTERRUPTMSIDATA (CFGINTERRUPTMSIDATA),
    .CFGINTERRUPTMSIENABLE (CFGINTERRUPTMSIENABLE),
    .CFGINTERRUPTMSIFAIL (CFGINTERRUPTMSIFAIL),
    .CFGINTERRUPTMSIMASKUPDATE (CFGINTERRUPTMSIMASKUPDATE),
    .CFGINTERRUPTMSIMMENABLE (CFGINTERRUPTMSIMMENABLE),
    .CFGINTERRUPTMSISENT (CFGINTERRUPTMSISENT),
    .CFGINTERRUPTMSIVFENABLE (CFGINTERRUPTMSIVFENABLE),
    .CFGINTERRUPTMSIXENABLE (CFGINTERRUPTMSIXENABLE),
    .CFGINTERRUPTMSIXFAIL (CFGINTERRUPTMSIXFAIL),
    .CFGINTERRUPTMSIXMASK (CFGINTERRUPTMSIXMASK),
    .CFGINTERRUPTMSIXSENT (CFGINTERRUPTMSIXSENT),
    .CFGINTERRUPTMSIXVFENABLE (CFGINTERRUPTMSIXVFENABLE),
    .CFGINTERRUPTMSIXVFMASK (CFGINTERRUPTMSIXVFMASK),
    .CFGINTERRUPTSENT (CFGINTERRUPTSENT),
    .CFGLINKPOWERSTATE (CFGLINKPOWERSTATE),
    .CFGLOCALERROR (CFGLOCALERROR),
    .CFGLTRENABLE (CFGLTRENABLE),
    .CFGLTSSMSTATE (CFGLTSSMSTATE),
    .CFGMAXPAYLOAD (CFGMAXPAYLOAD),
    .CFGMAXREADREQ (CFGMAXREADREQ),
    .CFGMGMTREADDATA (CFGMGMTREADDATA),
    .CFGMGMTREADWRITEDONE (CFGMGMTREADWRITEDONE),
    .CFGMSGRECEIVED (CFGMSGRECEIVED),
    .CFGMSGRECEIVEDDATA (CFGMSGRECEIVEDDATA),
    .CFGMSGRECEIVEDTYPE (CFGMSGRECEIVEDTYPE),
    .CFGMSGTRANSMITDONE (CFGMSGTRANSMITDONE),
    .CFGNEGOTIATEDWIDTH (CFGNEGOTIATEDWIDTH),
    .CFGOBFFENABLE (CFGOBFFENABLE),
    .CFGPERFUNCSTATUSDATA (CFGPERFUNCSTATUSDATA),
    .CFGPERFUNCTIONUPDATEDONE (CFGPERFUNCTIONUPDATEDONE),
    .CFGPHYLINKDOWN (CFGPHYLINKDOWN),
    .CFGPHYLINKSTATUS (CFGPHYLINKSTATUS),
    .CFGPLSTATUSCHANGE (CFGPLSTATUSCHANGE),
    .CFGPOWERSTATECHANGEINTERRUPT (CFGPOWERSTATECHANGEINTERRUPT),
    .CFGRCBSTATUS (CFGRCBSTATUS),
    .CFGTPHFUNCTIONNUM (CFGTPHFUNCTIONNUM),
    .CFGTPHREQUESTERENABLE (CFGTPHREQUESTERENABLE),
    .CFGTPHSTMODE (CFGTPHSTMODE),
    .CFGTPHSTTADDRESS (CFGTPHSTTADDRESS),
    .CFGTPHSTTREADENABLE (CFGTPHSTTREADENABLE),
    .CFGTPHSTTWRITEBYTEVALID (CFGTPHSTTWRITEBYTEVALID),
    .CFGTPHSTTWRITEDATA (CFGTPHSTTWRITEDATA),
    .CFGTPHSTTWRITEENABLE (CFGTPHSTTWRITEENABLE),
    .CFGVFFLRINPROCESS (CFGVFFLRINPROCESS),
    .CFGVFPOWERSTATE (CFGVFPOWERSTATE),
    .CFGVFSTATUS (CFGVFSTATUS),
    .CFGVFTPHREQUESTERENABLE (CFGVFTPHREQUESTERENABLE),
    .CFGVFTPHSTMODE (CFGVFTPHSTMODE),
    .CONFMCAPDESIGNSWITCH (CONFMCAPDESIGNSWITCH),
    .CONFMCAPEOS (CONFMCAPEOS),
    .CONFMCAPINUSEBYPCIE (CONFMCAPINUSEBYPCIE),
    .CONFREQREADY (CONFREQREADY),
    .CONFRESPRDATA (CONFRESPRDATA),
    .CONFRESPVALID (CONFRESPVALID),
    .DBGDATAOUT (DBGDATAOUT),
    .DBGMCAPCSB (DBGMCAPCSB),
    .DBGMCAPDATA (DBGMCAPDATA),
    .DBGMCAPEOS (DBGMCAPEOS),
    .DBGMCAPERROR (DBGMCAPERROR),
    .DBGMCAPMODE (DBGMCAPMODE),
    .DBGMCAPRDATAVALID (DBGMCAPRDATAVALID),
    .DBGMCAPRDWRB (DBGMCAPRDWRB),
    .DBGMCAPRESET (DBGMCAPRESET),
    .DBGPLDATABLOCKRECEIVEDAFTEREDS (DBGPLDATABLOCKRECEIVEDAFTEREDS),
    .DBGPLGEN3FRAMINGERRORDETECTED (DBGPLGEN3FRAMINGERRORDETECTED),
    .DBGPLGEN3SYNCHEADERERRORDETECTED (DBGPLGEN3SYNCHEADERERRORDETECTED),
    .DBGPLINFERREDRXELECTRICALIDLE (DBGPLINFERREDRXELECTRICALIDLE),
    .DRPDO (DRPDO),
    .DRPRDY (DRPRDY),
    .LL2LMMASTERTLPSENTTLPID0 (LL2LMMASTERTLPSENTTLPID0),
    .LL2LMMASTERTLPSENTTLPID1 (LL2LMMASTERTLPSENTTLPID1),
    .LL2LMMASTERTLPSENT0 (LL2LMMASTERTLPSENT0),
    .LL2LMMASTERTLPSENT1 (LL2LMMASTERTLPSENT1),
    .LL2LMMAXISRXTDATA (LL2LMMAXISRXTDATA),
    .LL2LMMAXISRXTUSER (LL2LMMAXISRXTUSER),
    .LL2LMMAXISRXTVALID (LL2LMMAXISRXTVALID),
    .LL2LMSAXISTXTREADY (LL2LMSAXISTXTREADY),
    .MAXISCQTDATA (MAXISCQTDATA),
    .MAXISCQTKEEP (MAXISCQTKEEP),
    .MAXISCQTLAST (MAXISCQTLAST),
    .MAXISCQTUSER (MAXISCQTUSER),
    .MAXISCQTVALID (MAXISCQTVALID),
    .MAXISRCTDATA (MAXISRCTDATA),
    .MAXISRCTKEEP (MAXISRCTKEEP),
    .MAXISRCTLAST (MAXISRCTLAST),
    .MAXISRCTUSER (MAXISRCTUSER),
    .MAXISRCTVALID (MAXISRCTVALID),
    .MICOMPLETIONRAMREADADDRESSAL (MICOMPLETIONRAMREADADDRESSAL),
    .MICOMPLETIONRAMREADADDRESSAU (MICOMPLETIONRAMREADADDRESSAU),
    .MICOMPLETIONRAMREADADDRESSBL (MICOMPLETIONRAMREADADDRESSBL),
    .MICOMPLETIONRAMREADADDRESSBU (MICOMPLETIONRAMREADADDRESSBU),
    .MICOMPLETIONRAMREADENABLEL (MICOMPLETIONRAMREADENABLEL),
    .MICOMPLETIONRAMREADENABLEU (MICOMPLETIONRAMREADENABLEU),
    .MICOMPLETIONRAMWRITEADDRESSAL (MICOMPLETIONRAMWRITEADDRESSAL),
    .MICOMPLETIONRAMWRITEADDRESSAU (MICOMPLETIONRAMWRITEADDRESSAU),
    .MICOMPLETIONRAMWRITEADDRESSBL (MICOMPLETIONRAMWRITEADDRESSBL),
    .MICOMPLETIONRAMWRITEADDRESSBU (MICOMPLETIONRAMWRITEADDRESSBU),
    .MICOMPLETIONRAMWRITEDATAL (MICOMPLETIONRAMWRITEDATAL),
    .MICOMPLETIONRAMWRITEDATAU (MICOMPLETIONRAMWRITEDATAU),
    .MICOMPLETIONRAMWRITEENABLEL (MICOMPLETIONRAMWRITEENABLEL),
    .MICOMPLETIONRAMWRITEENABLEU (MICOMPLETIONRAMWRITEENABLEU),
    .MIREPLAYRAMADDRESS (MIREPLAYRAMADDRESS),
    .MIREPLAYRAMREADENABLE (MIREPLAYRAMREADENABLE),
    .MIREPLAYRAMWRITEDATA (MIREPLAYRAMWRITEDATA),
    .MIREPLAYRAMWRITEENABLE (MIREPLAYRAMWRITEENABLE),
    .MIREQUESTRAMREADADDRESSA (MIREQUESTRAMREADADDRESSA),
    .MIREQUESTRAMREADADDRESSB (MIREQUESTRAMREADADDRESSB),
    .MIREQUESTRAMREADENABLE (MIREQUESTRAMREADENABLE),
    .MIREQUESTRAMWRITEADDRESSA (MIREQUESTRAMWRITEADDRESSA),
    .MIREQUESTRAMWRITEADDRESSB (MIREQUESTRAMWRITEADDRESSB),
    .MIREQUESTRAMWRITEDATA (MIREQUESTRAMWRITEDATA),
    .MIREQUESTRAMWRITEENABLE (MIREQUESTRAMWRITEENABLE),
    .PCIECQNPREQCOUNT (PCIECQNPREQCOUNT),
    .PCIEPERST0B (PCIEPERST0B),
    .PCIEPERST1B (PCIEPERST1B),
    .PCIERQSEQNUM (PCIERQSEQNUM),
    .PCIERQSEQNUMVLD (PCIERQSEQNUMVLD),
    .PCIERQTAG (PCIERQTAG),
    .PCIERQTAGAV (PCIERQTAGAV),
    .PCIERQTAGVLD (PCIERQTAGVLD),
    .PCIETFCNPDAV (PCIETFCNPDAV),
    .PCIETFCNPHAV (PCIETFCNPHAV),
    .PIPERX0EQCONTROL (PIPERX0EQCONTROL),
    .PIPERX0EQLPLFFS (PIPERX0EQLPLFFS),
    .PIPERX0EQLPTXPRESET (PIPERX0EQLPTXPRESET),
    .PIPERX0EQPRESET (PIPERX0EQPRESET),
    .PIPERX0POLARITY (PIPERX0POLARITY),
    .PIPERX1EQCONTROL (PIPERX1EQCONTROL),
    .PIPERX1EQLPLFFS (PIPERX1EQLPLFFS),
    .PIPERX1EQLPTXPRESET (PIPERX1EQLPTXPRESET),
    .PIPERX1EQPRESET (PIPERX1EQPRESET),
    .PIPERX1POLARITY (PIPERX1POLARITY),
    .PIPERX2EQCONTROL (PIPERX2EQCONTROL),
    .PIPERX2EQLPLFFS (PIPERX2EQLPLFFS),
    .PIPERX2EQLPTXPRESET (PIPERX2EQLPTXPRESET),
    .PIPERX2EQPRESET (PIPERX2EQPRESET),
    .PIPERX2POLARITY (PIPERX2POLARITY),
    .PIPERX3EQCONTROL (PIPERX3EQCONTROL),
    .PIPERX3EQLPLFFS (PIPERX3EQLPLFFS),
    .PIPERX3EQLPTXPRESET (PIPERX3EQLPTXPRESET),
    .PIPERX3EQPRESET (PIPERX3EQPRESET),
    .PIPERX3POLARITY (PIPERX3POLARITY),
    .PIPERX4EQCONTROL (PIPERX4EQCONTROL),
    .PIPERX4EQLPLFFS (PIPERX4EQLPLFFS),
    .PIPERX4EQLPTXPRESET (PIPERX4EQLPTXPRESET),
    .PIPERX4EQPRESET (PIPERX4EQPRESET),
    .PIPERX4POLARITY (PIPERX4POLARITY),
    .PIPERX5EQCONTROL (PIPERX5EQCONTROL),
    .PIPERX5EQLPLFFS (PIPERX5EQLPLFFS),
    .PIPERX5EQLPTXPRESET (PIPERX5EQLPTXPRESET),
    .PIPERX5EQPRESET (PIPERX5EQPRESET),
    .PIPERX5POLARITY (PIPERX5POLARITY),
    .PIPERX6EQCONTROL (PIPERX6EQCONTROL),
    .PIPERX6EQLPLFFS (PIPERX6EQLPLFFS),
    .PIPERX6EQLPTXPRESET (PIPERX6EQLPTXPRESET),
    .PIPERX6EQPRESET (PIPERX6EQPRESET),
    .PIPERX6POLARITY (PIPERX6POLARITY),
    .PIPERX7EQCONTROL (PIPERX7EQCONTROL),
    .PIPERX7EQLPLFFS (PIPERX7EQLPLFFS),
    .PIPERX7EQLPTXPRESET (PIPERX7EQLPTXPRESET),
    .PIPERX7EQPRESET (PIPERX7EQPRESET),
    .PIPERX7POLARITY (PIPERX7POLARITY),
    .PIPETX0CHARISK (PIPETX0CHARISK),
    .PIPETX0COMPLIANCE (PIPETX0COMPLIANCE),
    .PIPETX0DATA (PIPETX0DATA),
    .PIPETX0DATAVALID (PIPETX0DATAVALID),
    .PIPETX0DEEMPH (PIPETX0DEEMPH),
    .PIPETX0ELECIDLE (PIPETX0ELECIDLE),
    .PIPETX0EQCONTROL (PIPETX0EQCONTROL),
    .PIPETX0EQDEEMPH (PIPETX0EQDEEMPH),
    .PIPETX0EQPRESET (PIPETX0EQPRESET),
    .PIPETX0MARGIN (PIPETX0MARGIN),
    .PIPETX0POWERDOWN (PIPETX0POWERDOWN),
    .PIPETX0RATE (PIPETX0RATE),
    .PIPETX0RCVRDET (PIPETX0RCVRDET),
    .PIPETX0RESET (PIPETX0RESET),
    .PIPETX0STARTBLOCK (PIPETX0STARTBLOCK),
    .PIPETX0SWING (PIPETX0SWING),
    .PIPETX0SYNCHEADER (PIPETX0SYNCHEADER),
    .PIPETX1CHARISK (PIPETX1CHARISK),
    .PIPETX1COMPLIANCE (PIPETX1COMPLIANCE),
    .PIPETX1DATA (PIPETX1DATA),
    .PIPETX1DATAVALID (PIPETX1DATAVALID),
    .PIPETX1DEEMPH (PIPETX1DEEMPH),
    .PIPETX1ELECIDLE (PIPETX1ELECIDLE),
    .PIPETX1EQCONTROL (PIPETX1EQCONTROL),
    .PIPETX1EQDEEMPH (PIPETX1EQDEEMPH),
    .PIPETX1EQPRESET (PIPETX1EQPRESET),
    .PIPETX1MARGIN (PIPETX1MARGIN),
    .PIPETX1POWERDOWN (PIPETX1POWERDOWN),
    .PIPETX1RATE (PIPETX1RATE),
    .PIPETX1RCVRDET (PIPETX1RCVRDET),
    .PIPETX1RESET (PIPETX1RESET),
    .PIPETX1STARTBLOCK (PIPETX1STARTBLOCK),
    .PIPETX1SWING (PIPETX1SWING),
    .PIPETX1SYNCHEADER (PIPETX1SYNCHEADER),
    .PIPETX2CHARISK (PIPETX2CHARISK),
    .PIPETX2COMPLIANCE (PIPETX2COMPLIANCE),
    .PIPETX2DATA (PIPETX2DATA),
    .PIPETX2DATAVALID (PIPETX2DATAVALID),
    .PIPETX2DEEMPH (PIPETX2DEEMPH),
    .PIPETX2ELECIDLE (PIPETX2ELECIDLE),
    .PIPETX2EQCONTROL (PIPETX2EQCONTROL),
    .PIPETX2EQDEEMPH (PIPETX2EQDEEMPH),
    .PIPETX2EQPRESET (PIPETX2EQPRESET),
    .PIPETX2MARGIN (PIPETX2MARGIN),
    .PIPETX2POWERDOWN (PIPETX2POWERDOWN),
    .PIPETX2RATE (PIPETX2RATE),
    .PIPETX2RCVRDET (PIPETX2RCVRDET),
    .PIPETX2RESET (PIPETX2RESET),
    .PIPETX2STARTBLOCK (PIPETX2STARTBLOCK),
    .PIPETX2SWING (PIPETX2SWING),
    .PIPETX2SYNCHEADER (PIPETX2SYNCHEADER),
    .PIPETX3CHARISK (PIPETX3CHARISK),
    .PIPETX3COMPLIANCE (PIPETX3COMPLIANCE),
    .PIPETX3DATA (PIPETX3DATA),
    .PIPETX3DATAVALID (PIPETX3DATAVALID),
    .PIPETX3DEEMPH (PIPETX3DEEMPH),
    .PIPETX3ELECIDLE (PIPETX3ELECIDLE),
    .PIPETX3EQCONTROL (PIPETX3EQCONTROL),
    .PIPETX3EQDEEMPH (PIPETX3EQDEEMPH),
    .PIPETX3EQPRESET (PIPETX3EQPRESET),
    .PIPETX3MARGIN (PIPETX3MARGIN),
    .PIPETX3POWERDOWN (PIPETX3POWERDOWN),
    .PIPETX3RATE (PIPETX3RATE),
    .PIPETX3RCVRDET (PIPETX3RCVRDET),
    .PIPETX3RESET (PIPETX3RESET),
    .PIPETX3STARTBLOCK (PIPETX3STARTBLOCK),
    .PIPETX3SWING (PIPETX3SWING),
    .PIPETX3SYNCHEADER (PIPETX3SYNCHEADER),
    .PIPETX4CHARISK (PIPETX4CHARISK),
    .PIPETX4COMPLIANCE (PIPETX4COMPLIANCE),
    .PIPETX4DATA (PIPETX4DATA),
    .PIPETX4DATAVALID (PIPETX4DATAVALID),
    .PIPETX4DEEMPH (PIPETX4DEEMPH),
    .PIPETX4ELECIDLE (PIPETX4ELECIDLE),
    .PIPETX4EQCONTROL (PIPETX4EQCONTROL),
    .PIPETX4EQDEEMPH (PIPETX4EQDEEMPH),
    .PIPETX4EQPRESET (PIPETX4EQPRESET),
    .PIPETX4MARGIN (PIPETX4MARGIN),
    .PIPETX4POWERDOWN (PIPETX4POWERDOWN),
    .PIPETX4RATE (PIPETX4RATE),
    .PIPETX4RCVRDET (PIPETX4RCVRDET),
    .PIPETX4RESET (PIPETX4RESET),
    .PIPETX4STARTBLOCK (PIPETX4STARTBLOCK),
    .PIPETX4SWING (PIPETX4SWING),
    .PIPETX4SYNCHEADER (PIPETX4SYNCHEADER),
    .PIPETX5CHARISK (PIPETX5CHARISK),
    .PIPETX5COMPLIANCE (PIPETX5COMPLIANCE),
    .PIPETX5DATA (PIPETX5DATA),
    .PIPETX5DATAVALID (PIPETX5DATAVALID),
    .PIPETX5DEEMPH (PIPETX5DEEMPH),
    .PIPETX5ELECIDLE (PIPETX5ELECIDLE),
    .PIPETX5EQCONTROL (PIPETX5EQCONTROL),
    .PIPETX5EQDEEMPH (PIPETX5EQDEEMPH),
    .PIPETX5EQPRESET (PIPETX5EQPRESET),
    .PIPETX5MARGIN (PIPETX5MARGIN),
    .PIPETX5POWERDOWN (PIPETX5POWERDOWN),
    .PIPETX5RATE (PIPETX5RATE),
    .PIPETX5RCVRDET (PIPETX5RCVRDET),
    .PIPETX5RESET (PIPETX5RESET),
    .PIPETX5STARTBLOCK (PIPETX5STARTBLOCK),
    .PIPETX5SWING (PIPETX5SWING),
    .PIPETX5SYNCHEADER (PIPETX5SYNCHEADER),
    .PIPETX6CHARISK (PIPETX6CHARISK),
    .PIPETX6COMPLIANCE (PIPETX6COMPLIANCE),
    .PIPETX6DATA (PIPETX6DATA),
    .PIPETX6DATAVALID (PIPETX6DATAVALID),
    .PIPETX6DEEMPH (PIPETX6DEEMPH),
    .PIPETX6ELECIDLE (PIPETX6ELECIDLE),
    .PIPETX6EQCONTROL (PIPETX6EQCONTROL),
    .PIPETX6EQDEEMPH (PIPETX6EQDEEMPH),
    .PIPETX6EQPRESET (PIPETX6EQPRESET),
    .PIPETX6MARGIN (PIPETX6MARGIN),
    .PIPETX6POWERDOWN (PIPETX6POWERDOWN),
    .PIPETX6RATE (PIPETX6RATE),
    .PIPETX6RCVRDET (PIPETX6RCVRDET),
    .PIPETX6RESET (PIPETX6RESET),
    .PIPETX6STARTBLOCK (PIPETX6STARTBLOCK),
    .PIPETX6SWING (PIPETX6SWING),
    .PIPETX6SYNCHEADER (PIPETX6SYNCHEADER),
    .PIPETX7CHARISK (PIPETX7CHARISK),
    .PIPETX7COMPLIANCE (PIPETX7COMPLIANCE),
    .PIPETX7DATA (PIPETX7DATA),
    .PIPETX7DATAVALID (PIPETX7DATAVALID),
    .PIPETX7DEEMPH (PIPETX7DEEMPH),
    .PIPETX7ELECIDLE (PIPETX7ELECIDLE),
    .PIPETX7EQCONTROL (PIPETX7EQCONTROL),
    .PIPETX7EQDEEMPH (PIPETX7EQDEEMPH),
    .PIPETX7EQPRESET (PIPETX7EQPRESET),
    .PIPETX7MARGIN (PIPETX7MARGIN),
    .PIPETX7POWERDOWN (PIPETX7POWERDOWN),
    .PIPETX7RATE (PIPETX7RATE),
    .PIPETX7RCVRDET (PIPETX7RCVRDET),
    .PIPETX7RESET (PIPETX7RESET),
    .PIPETX7STARTBLOCK (PIPETX7STARTBLOCK),
    .PIPETX7SWING (PIPETX7SWING),
    .PIPETX7SYNCHEADER (PIPETX7SYNCHEADER),
    .PLEQINPROGRESS (PLEQINPROGRESS),
    .PLEQPHASE (PLEQPHASE),
    .SAXISCCTREADY (SAXISCCTREADY),
    .SAXISRQTREADY (SAXISRQTREADY),
    .SPAREOUT (SPAREOUT)
  );

endmodule

module rp_bram 
#(
  parameter TCQ = 100,
  parameter COMPLETION_SPACE = "16KB"
  ) (
  input  wire         clk_i,
  input  wire         reset_i,
  input  wire   [8:0] mi_rep_addr_i,
  input  wire [127:0] mi_rep_wdata_i,
  input  wire  [15:0] mi_rep_wdip_i,
  input  wire         mi_rep_wen0_i,
  input  wire         mi_rep_wen1_i,
  output wire [127:0] mi_rep_rdata_o,
  output wire  [15:0] mi_rep_rdop_o,
  input  wire         mi_rep_rden0_i,
  input  wire         mi_rep_rden1_i,
  input  wire   [8:0] mi_req_waddr0_i,
  input  wire   [8:0] mi_req_waddr1_i,
  input  wire [127:0] mi_req_wdata_i,
  input  wire  [15:0] mi_req_wdip_i,
  input  wire         mi_req_wen0_i,
  input  wire         mi_req_wen1_i,
  input  wire         mi_req_wen2_i,
  input  wire         mi_req_wen3_i,
  input  wire   [8:0] mi_req_raddr0_i,
  input  wire   [8:0] mi_req_raddr1_i,
  output wire [127:0] mi_req_rdata_o,
  output wire  [15:0] mi_req_rdop_o,
  input  wire         mi_req_ren0_i,
  input  wire         mi_req_ren1_i,
  input  wire         mi_req_ren2_i,
  input  wire         mi_req_ren3_i,
  input  wire   [9:0] mi_cpl_waddr0_i,
  input  wire   [9:0] mi_cpl_waddr1_i,
  input  wire   [9:0] mi_cpl_waddr2_i,
  input  wire   [9:0] mi_cpl_waddr3_i,
  input  wire [127:0] mi_cpl_wdata_i,
  input  wire  [15:0] mi_cpl_wdip_i,
  input  wire         mi_cpl_wen0_i,
  input  wire         mi_cpl_wen1_i,
  input  wire         mi_cpl_wen2_i,
  input  wire         mi_cpl_wen3_i,
  input  wire         mi_cpl_wen4_i,
  input  wire         mi_cpl_wen5_i,
  input  wire         mi_cpl_wen6_i,
  input  wire         mi_cpl_wen7_i,
  input  wire   [9:0] mi_cpl_raddr0_i,
  input  wire   [9:0] mi_cpl_raddr1_i,
  input  wire   [9:0] mi_cpl_raddr2_i,
  input  wire   [9:0] mi_cpl_raddr3_i,
  output wire [127:0] mi_cpl_rdata_o,
  output wire  [15:0] mi_cpl_rdop_o,
  input  wire         mi_cpl_ren0_i,
  input  wire         mi_cpl_ren1_i,
  input  wire         mi_cpl_ren2_i,
  input  wire         mi_cpl_ren3_i,
  input  wire         mi_cpl_ren4_i,
  input  wire         mi_cpl_ren5_i,
  input  wire         mi_cpl_ren6_i,
  input  wire         mi_cpl_ren7_i
  );

  rp_bram_rep
 #(
    .TCQ (TCQ))
  bram_rep_inst (
    .clk_i (clk_i),
    .reset_i (reset_i),
    .addr_i (mi_rep_addr_i[8:0]),
    .wdata_i (mi_rep_wdata_i[127:0]),
    .wdip_i (mi_rep_wdip_i[15:0]),
    .wen0_i (mi_rep_wen0_i),
    .wen1_i (mi_rep_wen1_i),
    .rdata_o (mi_rep_rdata_o[127:0]),
    .rdop_o (mi_rep_rdop_o[15:0]),
    .rden0_i (mi_rep_rden0_i),
    .rden1_i (mi_rep_rden1_i)
  );

  rp_bram_req 
 #(
    .TCQ (TCQ))
  bram_req_inst (
    .clk_i (clk_i),
    .reset_i (reset_i),
    .waddr0_i (mi_req_waddr0_i[8:0]),
    .waddr1_i (mi_req_waddr1_i[8:0]),
    .wdata_i (mi_req_wdata_i[127:0]),
    .wdip_i (mi_req_wdip_i[15:0]),
    .wen0_i (mi_req_wen0_i),
    .wen1_i (mi_req_wen1_i),
    .wen2_i (mi_req_wen2_i),
    .wen3_i (mi_req_wen3_i),
    .raddr0_i (mi_req_raddr0_i[8:0]),
    .raddr1_i (mi_req_raddr1_i[8:0]),
    .rdata_o (mi_req_rdata_o[127:0]),
    .rdop_o (mi_req_rdop_o[15:0]),
    .ren0_i (mi_req_ren0_i),
    .ren1_i (mi_req_ren1_i),
    .ren2_i (mi_req_ren2_i),
    .ren3_i (mi_req_ren3_i)
  );

  rp_bram_cpl 
 #(
    .TCQ (TCQ),
    .COMPLETION_SPACE (COMPLETION_SPACE))
  bram_cpl_inst (
    .clk_i (clk_i),
    .reset_i (reset_i),
    .waddr0_i (mi_cpl_waddr0_i[9:0]),
    .waddr1_i (mi_cpl_waddr1_i[9:0]),
    .waddr2_i (mi_cpl_waddr2_i[9:0]),
    .waddr3_i (mi_cpl_waddr3_i[9:0]),
    .wdata_i (mi_cpl_wdata_i[127:0]),
    .wdip_i (mi_cpl_wdip_i[15:0]),
    .wen0_i (mi_cpl_wen0_i),
    .wen1_i (mi_cpl_wen1_i),
    .wen2_i (mi_cpl_wen2_i),
    .wen3_i (mi_cpl_wen3_i),
    .wen4_i (mi_cpl_wen4_i),
    .wen5_i (mi_cpl_wen5_i),
    .wen6_i (mi_cpl_wen6_i),
    .wen7_i (mi_cpl_wen7_i),
    .raddr0_i (mi_cpl_raddr0_i[9:0]),
    .raddr1_i (mi_cpl_raddr1_i[9:0]),
    .raddr2_i (mi_cpl_raddr2_i[9:0]),
    .raddr3_i (mi_cpl_raddr3_i[9:0]),
    .rdata_o (mi_cpl_rdata_o[127:0]),
    .rdop_o (mi_cpl_rdop_o[15:0]),
    .ren0_i (mi_cpl_ren0_i),
    .ren1_i (mi_cpl_ren1_i),
    .ren2_i (mi_cpl_ren2_i),
    .ren3_i (mi_cpl_ren3_i),
    .ren4_i (mi_cpl_ren4_i),
    .ren5_i (mi_cpl_ren5_i),
    .ren6_i (mi_cpl_ren6_i),
    .ren7_i (mi_cpl_ren7_i)
  );

endmodule

module rp_bram_rep 
 #(
  parameter TCQ = 100
  ) (
  input  wire         clk_i,
  input  wire         reset_i,
  input  wire   [8:0] addr_i,
  input  wire [127:0] wdata_i,
  input  wire  [15:0] wdip_i,
  input  wire         wen0_i,
  input  wire         wen1_i,
  input  wire         rden0_i,
  input  wire         rden1_i,
  output wire [127:0] rdata_o,
  output wire  [15:0] rdop_o
  );

  rp_bram_rep_8k 
 #(
    .TCQ (TCQ))
  bram_rep_8k_inst (
    .clk_i (clk_i),
    .reset_i (reset_i),
    .addr_i (addr_i[8:0]),
    .wdata_i (wdata_i[127:0]),
    .wdip_i (wdip_i[15:0]),
    .wen_i ({wen1_i, wen0_i}),
    .rden_i ({rden1_i,rden0_i}),
    .rdata_o (rdata_o[127:0]),
    .rdop_o (rdop_o[15:0])
  );

endmodule

module rp_bram_rep_8k
#(
  parameter TCQ = 100
  ) (
  input  wire         clk_i,
  input  wire         reset_i,
  input  wire   [8:0] addr_i,
  input  wire [127:0] wdata_i,
  input  wire  [15:0] wdip_i,
  input  wire   [1:0] wen_i,
  input  wire   [1:0] rden_i,
  output wire [127:0] rdata_o,
  output wire  [15:0] rdop_o
  );

  genvar              i;

  wire          [1:0] wen = {wen_i[1], wen_i[0]};
  wire          [1:0] rden = {rden_i[1], rden_i[0]};

  generate
    for (i = 0; i < 2; i = i + 1)
    begin : RAMB36E2
      RAMB36E2 #(
        .DOA_REG (1),
        .DOB_REG (1),
        .EN_ECC_READ ("FALSE"),
        .EN_ECC_WRITE ("FALSE"),
        .INIT_A (36'h000000000),
        .INIT_B (36'h000000000),
        .INIT_FILE ("NONE"),
        .READ_WIDTH_A (36),
        .READ_WIDTH_B (36),
        .RSTREG_PRIORITY_A ("REGCE"),
        .RSTREG_PRIORITY_B ("REGCE"),
        .SIM_COLLISION_CHECK ("ALL"),
        .SRVAL_A (36'h000000000),
        .SRVAL_B (36'h000000000),
        .WRITE_MODE_A ("READ_FIRST"),
        .WRITE_MODE_B ("READ_FIRST"),
        .WRITE_WIDTH_A (36),
        .WRITE_WIDTH_B (36))
      ramb36e2_inst (
        .ADDRENA (1'b1),
        .ADDRENB (1'b1),
        .CASDIMUXA (1'b0),
        .CASDIMUXB (1'b0),
        .CASDOMUXA (1'b0),
        .CASDOMUXB (1'b0),
        .CASDOMUXEN_A (1'b0),
        .CASDOMUXEN_B (1'b0),
        .CASINDBITERR (1'b0),
        .CASINSBITERR (1'b0),
        .CASOREGIMUXA (1'b0),
        .CASOREGIMUXB (1'b0),
        .CASOREGIMUXEN_A (1'b0),
        .CASOREGIMUXEN_B (1'b0),
        .ECCPIPECE (1'b0),
        .SLEEP (1'b0),
        .CASDINA (32'b0),
        .CASDINB (32'b0),
        .CASDINPA(4'b0),
        .CASDINPB(4'b0),
        .CASDOUTA (),
        .CASDOUTB (),
        .CASDOUTPA (),
        .CASDOUTPB (),
	.CASOUTDBITERR (),
	.CASOUTSBITERR (),
        .CLKARDCLK (clk_i),
        .CLKBWRCLK (clk_i),
        .DBITERR (),
        .ENARDEN (1'b1),
        .ENBWREN (1'b1),
        .INJECTDBITERR (1'b0),
        .INJECTSBITERR (1'b0),
        .REGCEAREGCE (1'b1),
        .REGCEB (1'b1),
        .RSTRAMARSTRAM (1'b0),
        .RSTRAMB (1'b0),
        .RSTREGARSTREG (1'b0),
        .RSTREGB (1'b0),
        .SBITERR (),
        .ADDRARDADDR ({addr_i[8:0], 6'b0}),
        .ADDRBWRADDR ({addr_i[8:0], 1'b1, 5'b0}),
        .DINADIN (wdata_i[(2*32*i)+31:(2*32*i)+0]),
        .DINBDIN (wdata_i[(2*32*i)+63:(2*32*i)+32]),
        .DINPADINP (wdip_i[(2*4*i)+3:(2*4*i)+0]),
        .DINPBDINP (wdip_i[(2*4*i)+7:(2*4*i)+4]),
        .DOUTADOUT (rdata_o[(2*32*i)+31:(2*32*i)+0]),
        .DOUTBDOUT (rdata_o[(2*32*i)+63:(2*32*i)+32]),
        .DOUTPADOUTP (rdop_o[(2*4*i)+3:(2*4*i)+0]),
        .DOUTPBDOUTP (rdop_o[(2*4*i)+7:(2*4*i)+4]),
        .ECCPARITY (),
        .RDADDRECC (),
        .WEA ({4{wen[i]}}),
        .WEBWE ({4'b0, {4{wen[i]}}})
      );
    end
  endgenerate

endmodule

module rp_bram_req 
 #(
  parameter TCQ = 100
  ) (
  input  wire         clk_i,
  input  wire         reset_i,
  input  wire   [8:0] waddr0_i,
  input  wire   [8:0] waddr1_i,
  input  wire [127:0] wdata_i,
  input  wire  [15:0] wdip_i,
  input  wire         wen0_i,
  input  wire         wen1_i,
  input  wire         wen2_i,
  input  wire         wen3_i,
  input  wire   [8:0] raddr0_i,
  input  wire   [8:0] raddr1_i,
  output wire [127:0] rdata_o,
  output wire  [15:0] rdop_o,
  input  wire         ren0_i,
  input  wire         ren1_i,
  input  wire         ren2_i,
  input  wire         ren3_i
  );

  rp_bram_8k 
 #(
    .TCQ (TCQ))
  bram_8k_inst (
    .clk_i (clk_i),
    .reset_i (reset_i),
    .waddr0_i (waddr0_i[8:0]),
    .waddr1_i (waddr1_i[8:0]),
    .wdata_i (wdata_i[127:0]),
    .wdip_i (wdip_i[15:0]),
    .wen_i ({wen3_i, wen2_i, wen1_i, wen0_i}),
    .raddr0_i (raddr0_i[8:0]),
    .raddr1_i (raddr1_i[8:0]),
    .rdata_o (rdata_o[127:0]),
    .rdop_o (rdop_o[15:0]),
    .ren_i ({ren3_i, ren2_i, ren1_i, ren0_i})
  );

endmodule

module rp_bram_8k 
#(
  parameter TCQ = 100
  ) (
  input  wire         clk_i,
  input  wire         reset_i,
  input  wire   [8:0] waddr0_i,
  input  wire   [8:0] waddr1_i,
  input  wire [127:0] wdata_i,
  input  wire  [15:0] wdip_i,
  input  wire   [3:0] wen_i,
  input  wire   [8:0] raddr0_i,
  input  wire   [8:0] raddr1_i,
  output wire [127:0] rdata_o,
  output wire  [15:0] rdop_o,
  input  wire   [3:0] ren_i
  );

  genvar              i;

  wire          [3:0] wen = {wen_i[3], wen_i[2], wen_i[1], wen_i[0]};
  wire          [3:0] ren = {ren_i[3], ren_i[2], ren_i[1], ren_i[0]};
  wire         [35:0] waddr = {waddr1_i, waddr1_i, waddr0_i, waddr0_i};
  wire         [35:0] raddr = {raddr1_i, raddr1_i, raddr0_i, raddr0_i};

  generate
    for (i = 0; i < 4; i = i + 1)
    begin : RAMB18E2
      RAMB18E2 #(
        .DOA_REG (1),
        .DOB_REG (1),
        .INIT_A (36'h00000),
        .INIT_B (36'h00000),
        .INIT_FILE ("NONE"),
        .READ_WIDTH_A (36),
        .READ_WIDTH_B (0),
        .RSTREG_PRIORITY_A ("REGCE"),
        .RSTREG_PRIORITY_B ("REGCE"),
        .SIM_COLLISION_CHECK ("ALL"),
        .SRVAL_A (36'h00000),
        .SRVAL_B (36'h00000),
        .WRITE_MODE_A ("READ_FIRST"),
        .WRITE_MODE_B ("READ_FIRST"),
        .WRITE_WIDTH_A (0),
        .WRITE_WIDTH_B (36))
      ramb18e2_inst (
        .ADDRENA (1'b1),
        .ADDRENB (1'b1),
        .CASDIMUXA (1'b0),
        .CASDIMUXB (1'b0),
        .CASDOMUXA (1'b0),
        .CASDOMUXB (1'b0),
        .CASDOMUXEN_A (1'b0),
        .CASDOMUXEN_B (1'b0),
        .CASOREGIMUXA (1'b0),
        .CASOREGIMUXB (1'b0),
        .CASOREGIMUXEN_A (1'b0),
        .CASOREGIMUXEN_B (1'b0),
        .SLEEP (1'b0),
        .CASDINA (16'b0),
        .CASDINB (16'b0),
        .CASDINPA(2'b0),
        .CASDINPB(2'b0),
        .CASDOUTA (),
        .CASDOUTB (),
        .CASDOUTPA (),
        .CASDOUTPB (),
        .CLKARDCLK (clk_i),
        .CLKBWRCLK (clk_i),
        .ENARDEN (ren[i]),
        .ENBWREN (1'b1),
        .REGCEAREGCE (1'b1),
        .REGCEB (1'b0),
        .RSTRAMARSTRAM (1'b0),
        .RSTRAMB (1'b0),
        .RSTREGARSTREG (1'b0),
        .RSTREGB (1'b0),
        .ADDRARDADDR ({raddr[(9*i)+8:(9*i)+0], 5'b0}),
        .ADDRBWRADDR ({waddr[(9*i)+8:(9*i)+0], 5'b0}),
        .DINADIN (wdata_i[(2*16*i)+15:(2*16*i)+0]),
        .DINBDIN (wdata_i[(2*16*i)+31:(2*16*i)+16]),
        .DINPADINP (wdip_i[(2*2*i)+1:(2*2*i)+0]),
        .DINPBDINP (wdip_i[(2*2*i)+3:(2*2*i)+2]),
        .DOUTADOUT (rdata_o[(2*16*i)+15:(2*16*i)+0]),
        .DOUTBDOUT (rdata_o[(2*16*i)+31:(2*16*i)+16]),
        .DOUTPADOUTP (rdop_o[(2*2*i)+1:(2*2*i)+0]),
        .DOUTPBDOUTP (rdop_o[(2*2*i)+3:(2*2*i)+2]),
        .WEA ({2'b00}),
        .WEBWE ({4{wen[i]}})
      );
    end
  endgenerate

endmodule

module rp_bram_cpl
#(
  parameter TCQ = 100,
  parameter COMPLETION_SPACE = "16KB"
  ) (
  input  wire         clk_i,
  input  wire         reset_i,
  input  wire   [9:0] waddr0_i,
  input  wire   [9:0] waddr1_i,
  input  wire   [9:0] waddr2_i,
  input  wire   [9:0] waddr3_i,
  input  wire [127:0] wdata_i,
  input  wire  [15:0] wdip_i,
  input  wire         wen0_i,
  input  wire         wen1_i,
  input  wire         wen2_i,
  input  wire         wen3_i,
  input  wire         wen4_i,
  input  wire         wen5_i,
  input  wire         wen6_i,
  input  wire         wen7_i,
  input  wire   [9:0] raddr0_i,
  input  wire   [9:0] raddr1_i,
  input  wire   [9:0] raddr2_i,
  input  wire   [9:0] raddr3_i,
  output wire [127:0] rdata_o,
  output wire  [15:0] rdop_o,
  input  wire         ren0_i,
  input  wire         ren1_i,
  input  wire         ren2_i,
  input  wire         ren3_i,
  input  wire         ren4_i,
  input  wire         ren5_i,
  input  wire         ren6_i,
  input  wire         ren7_i
  );

  generate
    if (COMPLETION_SPACE == "16KB")
    begin : CPL_FIFO_16KB
 rp_bram_16k 
     #(
        .TCQ (TCQ))
      bram_16k_inst (
        .clk_i (clk_i),
        .reset_i (reset_i),
        .waddr0_i (waddr0_i[9:0]),
        .waddr1_i (waddr1_i[9:0]),
        .waddr2_i (waddr2_i[9:0]),
        .waddr3_i (waddr3_i[9:0]),
        .wdata_i (wdata_i[127:0]),
        .wdip_i (wdip_i[15:0]),
        .wen_i ({wen7_i, wen6_i, wen5_i, wen4_i, wen3_i, wen2_i, wen1_i, wen0_i}),
        .raddr0_i (raddr0_i[9:0]),
        .raddr1_i (raddr1_i[9:0]),
        .raddr2_i (raddr2_i[9:0]),
        .raddr3_i (raddr3_i[9:0]),
        .rdata_o (rdata_o[127:0]),
        .rdop_o (rdop_o[15:0]),
        .ren_i ({ren7_i, ren6_i, ren5_i, ren4_i, ren3_i, ren2_i, ren1_i, ren0_i})
      );
    end
    else
    begin : CPL_FIFO_8KB
 rp_bram_8k
     #(
        .TCQ (TCQ))
      bram_8k_inst (
        .clk_i (clk_i),
        .reset_i (reset_i),
        .waddr0_i (waddr0_i[8:0]),
        .waddr1_i (waddr1_i[8:0]),
        .wdata_i (wdata_i[127:0]),
        .wdip_i (wdip_i[15:0]),
        .wen_i ({wen3_i, wen2_i, wen1_i, wen0_i}),
        .raddr0_i (raddr0_i[8:0]),
        .raddr1_i (raddr1_i[8:0]),
        .rdata_o (rdata_o[127:0]),
        .rdop_o (rdop_o[15:0]),
        .ren_i ({ren3_i, ren2_i, ren1_i, ren0_i})
      );
    end
  endgenerate

endmodule

module rp_bram_16k 
#(
  parameter TCQ = 100
  ) (
  input  wire         clk_i,
  input  wire         reset_i,
  input  wire   [9:0] waddr0_i,
  input  wire   [9:0] waddr1_i,
  input  wire   [9:0] waddr2_i,
  input  wire   [9:0] waddr3_i,
  input  wire [127:0] wdata_i,
  input  wire  [15:0] wdip_i,
  input  wire   [7:0] wen_i,
  input  wire   [9:0] raddr0_i,
  input  wire   [9:0] raddr1_i,
  input  wire   [9:0] raddr2_i,
  input  wire   [9:0] raddr3_i,
  output wire [127:0] rdata_o,
  output wire  [15:0] rdop_o,
  input  wire   [7:0] ren_i
  );

  genvar              i;

  wire         [79:0] waddr;
  wire         [79:0] raddr;
  wire          [7:0] wen;
  wire          [7:0] ren;

  assign wen = {wen_i[7], wen_i[6], wen_i[5], wen_i[4], wen_i[3], wen_i[2], wen_i[1], wen_i[0]};
  assign ren = {ren_i[7], ren_i[6], ren_i[5], ren_i[4], ren_i[3], ren_i[2], ren_i[1], ren_i[0]};

  generate
      assign waddr = {waddr3_i, waddr3_i, waddr2_i, waddr2_i, waddr1_i, waddr1_i, waddr0_i, waddr0_i};
      assign raddr = {raddr3_i, raddr3_i, raddr2_i, raddr2_i, raddr1_i, raddr1_i, raddr0_i, raddr0_i};
      for (i = 0; i < 8; i = i + 1)
      begin : RAMB18E2
        RAMB18E2 #(
          .DOA_REG (1),
          .DOB_REG (1),
          .INIT_A (18'h00000),
          .INIT_B (18'h00000),
          .INIT_FILE ("NONE"),
          .READ_WIDTH_A (18),
          .READ_WIDTH_B (18),
          .RSTREG_PRIORITY_A ("REGCE"),
          .RSTREG_PRIORITY_B ("REGCE"),
          .SIM_COLLISION_CHECK ("ALL"),
          .SRVAL_A (18'h00000),
          .SRVAL_B (18'h00000),
        .WRITE_MODE_A ("READ_FIRST"),
        .WRITE_MODE_B ("READ_FIRST"),
          .WRITE_WIDTH_A (18),
          .WRITE_WIDTH_B (18))
        ramb18e2_inst (
          .ADDRENA (1'b1),
          .ADDRENB (1'b1),
          .CASDIMUXA (1'b0),
          .CASDIMUXB (1'b0),
          .CASDOMUXA (1'b0),
          .CASDOMUXB (1'b0),
          .CASDOMUXEN_A (1'b0),
          .CASDOMUXEN_B (1'b0),
          .CASOREGIMUXA (1'b0),
          .CASOREGIMUXB (1'b0),
          .CASOREGIMUXEN_A (1'b0),
          .CASOREGIMUXEN_B (1'b0),
          .SLEEP (1'b0),
          .CASDINA (16'b0),
          .CASDINB (16'b0),
          .CASDINPA(2'b0),
          .CASDINPB(2'b0),
          .CASDOUTA (),
          .CASDOUTB (),
          .CASDOUTPA (),
          .CASDOUTPB (),
          .CLKARDCLK (clk_i),
          .CLKBWRCLK (clk_i),
          .ENARDEN (1'b1),
          .ENBWREN (ren[i]),
          .REGCEAREGCE (1'b0),
          .REGCEB (1'b1),
          .RSTRAMARSTRAM (1'b0),
          .RSTRAMB (1'b0),
          .RSTREGARSTREG (1'b0),
          .RSTREGB (1'b0),
          .ADDRARDADDR ({waddr[(10*i)+9:(10*i)+0], 4'b0}),
          .ADDRBWRADDR ({raddr[(10*i)+9:(10*i)+0], 4'b0}),
          .DINADIN (wdata_i[(16*i)+15:(16*i)+0]),
          .DINPADINP (wdip_i[(2*i)+1:(2*i)+0]),
          .DINBDIN ({16'b0}),
          .DINPBDINP (2'b0),
          .DOUTADOUT (),
          .DOUTBDOUT (rdata_o[(16*i)+15:(16*i)+0]),            
          .DOUTPADOUTP (),
          .DOUTPBDOUTP (rdop_o[(2*i)+1:(2*i)+0]),               
          .WEA ({wen[i], wen[i]}),
          .WEBWE ({1'b0, 1'b0, 1'b0, 1'b0})
        );
      end
  endgenerate

endmodule

module rp_deemph 
(
  input                     pipe_clk,
  input                     user_clk,
  input                     sys_or_hot_rst,
  input           [15:0]    pipe_rx_data,
  input            [1:0]    pipe_tx0_rate,
  input            [1:0]    pipe_rx_char_is_k,
  input            [5:0]    cfg_ltssm_state,
  input                     pipe_tx0_deemph,
  output                    phy_txdeemph_out
);

   localparam   WORD0 = 5'b00001;
   localparam   WORD1 = 5'b00010;
   localparam   WORD2 = 5'b00100;
   localparam   WORD3 = 5'b01000;
   localparam   WORD4 = 5'b10000;

   reg   [4:0]  state = 5'b00001;
   reg          pipe_tx_deemph_int = 1'b0;
   reg          pipe_byte_lower = 1'b0; 
   reg          pipe_deemph_flag = 1'b0;
   reg          deemph_capture = 1'b0;  
   reg          deemph_override = 1'b0;
   
   wire         deemph_capture_pipe;  
   
   ///////////////////////// user clock domain//////////////////////////
 
   always @ (posedge user_clk) 
   begin
      if (cfg_ltssm_state == 6'hD) begin
        deemph_capture <= 1'b1;
      end 
      else begin
        deemph_capture <= 1'b0;
      end
   end
   
   always @ (posedge user_clk) 
   begin
      if (deemph_capture) begin
        deemph_override <= 1'b1;
      end 
      else if (cfg_ltssm_state == 6'h0) begin
        deemph_override <= 1'b0;
      end
      else begin
        deemph_override <= deemph_override;
      end
   end
 
//////////////////////// pipe clock domain/////////////////////////////////
rp_phy_sync #(.WIDTH (1),.STAGE (3)) sync_deemph_capture (.CLK (pipe_clk), .D (deemph_capture), .Q (deemph_capture_pipe));  

  

 always @ (posedge pipe_clk)
 begin
    case(state ) 
      WORD0 : begin
        if (pipe_rx_data[7:0] == 8'hBC && pipe_rx_char_is_k[0] && deemph_capture_pipe )  begin
          state               <= WORD1;
          pipe_byte_lower     <= 1'b1;
        end
        else if (pipe_rx_data[15:8] == 8'hBC && pipe_rx_char_is_k[1] && deemph_capture_pipe )  begin
          state               <= WORD1;
          pipe_byte_lower     <= 1'b0;
        end
        else begin
          state               <= WORD0;
          pipe_byte_lower     <= 1'b0;
        end
          pipe_tx_deemph_int  <= pipe_tx_deemph_int;
          pipe_deemph_flag    <= 1'b0;
      end
      
      WORD1 : begin
        state               <= WORD2;
        pipe_byte_lower     <= pipe_byte_lower ;
        pipe_tx_deemph_int  <= pipe_tx_deemph_int;
        pipe_deemph_flag    <= 1'b0;
      end
      
      WORD2 : begin
        state               <= WORD3;
        pipe_byte_lower     <= pipe_byte_lower ;
        pipe_tx_deemph_int  <= pipe_tx_deemph_int;
        if (pipe_byte_lower) begin
          pipe_deemph_flag  <= pipe_rx_data[6];
        end
        else begin
          pipe_deemph_flag  <= pipe_rx_data[14];
        end
       end 
       
      WORD3 : begin
        state               <= WORD4;
        pipe_byte_lower     <= pipe_byte_lower ;
        pipe_tx_deemph_int  <= pipe_tx_deemph_int;
        pipe_deemph_flag    <= pipe_deemph_flag;
      end
       
      WORD4 : begin
        state               <= WORD0;
        pipe_byte_lower     <= 1'b0;
        pipe_deemph_flag    <= pipe_deemph_flag;
        if (pipe_rx_data == 16'h4545)  begin
          pipe_tx_deemph_int  <= pipe_deemph_flag;
        end
        else begin
          pipe_tx_deemph_int  <= pipe_tx_deemph_int;
        end
      end  
     
      default:begin
        state                <= WORD0;
        pipe_byte_lower      <= 1'b0;
        pipe_tx_deemph_int   <= 1'b0;
        pipe_deemph_flag     <= 1'b0;
      end
    endcase
 end // always
 
//Override value only for GEN2 
assign  phy_txdeemph_out = (deemph_override && pipe_tx0_rate[0])? pipe_tx_deemph_int : pipe_tx0_deemph ; 


/////////////////////// Debug Only/////////////////////////////// 

  wire  [4:0]  DBG_state;
  wire         DBG_deemph_int;
  wire         DBG_deemph_flag;

  assign DBG_state = state ;
  assign DBG_deemph_int = pipe_tx_deemph_int;
  assign DBG_deemph_flag = pipe_deemph_flag;

/////////////////////////////////////////////////////////////////


endmodule

module rp_rxcdrhold 
(
  input   wire              pipe_clk,
  input   wire              user_clk,
  input   wire     [5:0]    cfg_ltssm_state,
  input   wire              pipe_rx0_elec_idle,
  output  wire              rxcdrhold_out
);


  reg rxcdrhold_req = 1'b0;
  reg phy_rxcdrhold = 1'b0;
  wire pipe_rxcdrhold_req;

  // If LTSSM state is Recovery.Speed, L1.Entry, L1.Idle or Loopback_Entry_slave 

  always @ (posedge user_clk) 
  begin
    if (cfg_ltssm_state == 6'h0C||cfg_ltssm_state == 6'h17||cfg_ltssm_state == 6'h18|| cfg_ltssm_state == 6'h24)      
          rxcdrhold_req <= 1'b1;
        else 
          rxcdrhold_req <= 1'b0;
    end
    
  // CDC to pipe_clock domain  
   
rp_phy_sync #(.WIDTH (1),.STAGE (3)) sync_rxcdrhold_req (.CLK (pipe_clk), .D (rxcdrhold_req), .Q (pipe_rxcdrhold_req));

   always @ (posedge pipe_clk) 
    begin
      if (pipe_rxcdrhold_req && pipe_rx0_elec_idle ) begin
        phy_rxcdrhold  <= 1'b1;
      end 
      else begin
        phy_rxcdrhold  <= 1'b0;
      end
   end

assign rxcdrhold_out = phy_rxcdrhold;

endmodule

//-------------------------------------------------------------------------------------------------
//  PHY Synchronizer Module
//-------------------------------------------------------------------------------------------------
module rp_phy_sync #
(
    parameter integer WIDTH = 1, 
    parameter integer STAGE = 2
)
(
    //-------------------------------------------------------------------------- 
    //  Input Ports
    //-------------------------------------------------------------------------- 
    input                               CLK,
    input       [WIDTH-1:0]             D,
    
    //-------------------------------------------------------------------------- 
    //  Output Ports
    //-------------------------------------------------------------------------- 
    output      [WIDTH-1:0]             Q
);                                                        



//--------------------------------------------------------------------------------------------------
//  Generate Synchronizer - Begin
//--------------------------------------------------------------------------------------------------
genvar i;

generate for (i=0; i<WIDTH; i=i+1) 

    begin : sync_vec

    //----------------------------------------------------------------------
    //  Synchronizer
    //----------------------------------------------------------------------
rp_phy_sync_cell #
    (
        .STAGE                            (STAGE)
    )    
    sync_cell_i
    (
        //------------------------------------------------------------------
        //  Input Ports
        //------------------------------------------------------------------
        .CLK                              (CLK),
        .D                                (D[i]),

        //------------------------------------------------------------------
        //  Output Ports
        //------------------------------------------------------------------
        .Q                                (Q[i])
    );
 
    end   
      
endgenerate 
//--------------------------------------------------------------------------------------------------
//  Generate - End
//--------------------------------------------------------------------------------------------------



endmodule

//-------------------------------------------------------------------------------------------------
//  Synchronizer Library Module
//-------------------------------------------------------------------------------------------------
module rp_phy_sync_cell #
(
    parameter integer STAGE = 2
)
(
    //-------------------------------------------------------------------------- 
    //  Input Ports
    //-------------------------------------------------------------------------- 
    input                               CLK,
    input                               D,
    
    //-------------------------------------------------------------------------- 
    //  Output Ports
    //-------------------------------------------------------------------------- 
    output                              Q
);

    //-------------------------------------------------------------------------- 
    //  Synchronized Signals
    //--------------------------------------------------------------------------  
    (* ASYNC_REG = "TRUE", SHIFT_EXTRACT = "NO" *) reg [STAGE:0] sync;                                                            



//--------------------------------------------------------------------------------------------------
//  Synchronizier
//--------------------------------------------------------------------------------------------------
always @ (posedge CLK)
begin

    sync <= {sync[(STAGE-1):0], D};
            
end   



//--------------------------------------------------------------------------------------------------
//  Generate Output
//--------------------------------------------------------------------------------------------------
assign Q = sync[STAGE];


endmodule

//--------------------------------------------------------------------------------------------------
//  PHY Wrapper Top
//--------------------------------------------------------------------------------------------------

module rp_phy_wrapper #
(
    //--------------------------------------------------------------------------
    //  Parameters
    //--------------------------------------------------------------------------
    parameter PL_UPSTREAM_FACING = "TRUE",
    parameter integer SHARED_LOGIC     = 0,
    parameter         DIS_GT_WIZARD    = "FALSE",  
    parameter         PHY_SIM_EN       = "FALSE",   
    parameter integer PHY_LANE         = 1,   
    parameter integer PHY_MAX_SPEED    = 3,                    
    parameter         PHY_ASYNC_EN     = "FALSE",     
    parameter         PHY_REFCLK_FREQ  = 0,     
    parameter integer PHY_USERCLK_FREQ = 3,           
    parameter integer PHY_CORECLK_FREQ = 2,       
    parameter integer PHY_GT_TXPRESET  = 0,
    parameter integer PHY_LP_TXPRESET  = 4         
)                                                            
(                                         
    //--------------------------------------------------------------------------
    //  Clock & Reset Ports
    //--------------------------------------------------------------------------
    input                               PHY_REFCLK,          
    input                               PHY_GTREFCLK,     
    input                               PHY_RST_N,           
   
    output                              PHY_PCLK,  
    output                              PHY_CORECLK, 
    output                              PHY_USERCLK,                          
    output				mcap_clk,
  
    //--------------------------------------------------------------------------
    //  Serial Line Ports
    //--------------------------------------------------------------------------
    input       [PHY_LANE-1:0]          PHY_RXP,               
    input       [PHY_LANE-1:0]          PHY_RXN,               

    output      [PHY_LANE-1:0]          PHY_TXP,               
    output      [PHY_LANE-1:0]          PHY_TXN,   
 
    //--------------------------------------------------------------------------
    //  TX Data Ports 
    //--------------------------------------------------------------------------
    input       [(PHY_LANE*32)-1:0]     PHY_TXDATA,            
    input       [(PHY_LANE* 2)-1:0]     PHY_TXDATAK,    
    input       [PHY_LANE-1:0]          PHY_TXDATA_VALID,
    input       [PHY_LANE-1:0]          PHY_TXSTART_BLOCK,      
    input       [(PHY_LANE* 2)-1:0]     PHY_TXSYNC_HEADER,                    

    //--------------------------------------------------------------------------
    //  RX Data Ports 
    //--------------------------------------------------------------------------
    output      [(PHY_LANE*32)-1:0]     PHY_RXDATA,            
    output      [(PHY_LANE* 2)-1:0]     PHY_RXDATAK,       
    output      [PHY_LANE-1:0]          PHY_RXDATA_VALID,         
    output      [PHY_LANE-1:0]          PHY_RXSTART_BLOCK,        
    output      [(PHY_LANE* 2)-1:0]     PHY_RXSYNC_HEADER,        
    
    //--------------------------------------------------------------------------
    //  PHY Command Port
    //--------------------------------------------------------------------------
    input                               PHY_TXDETECTRX,        
    input       [PHY_LANE-1:0]          PHY_TXELECIDLE,        
    input       [PHY_LANE-1:0]          PHY_TXCOMPLIANCE,      
    input       [PHY_LANE-1:0]          PHY_RXPOLARITY,        
    input       [1:0]                   PHY_POWERDOWN,         
    input       [1:0]                   PHY_RATE,              
    
    //--------------------------------------------------------------------------   
    //  PHY Status Ports
    //-------------------------------------------------------------------------- 
    output      [PHY_LANE-1:0]          PHY_RXVALID,               
    output      [PHY_LANE-1:0]          PHY_PHYSTATUS,          
    output                              PHY_PHYSTATUS_RST,         
    output      [PHY_LANE-1:0]          PHY_RXELECIDLE,         
    output      [(PHY_LANE*3)-1:0]      PHY_RXSTATUS,                       
    
    //--------------------------------------------------------------------------
    //  TX Driver Ports
    //--------------------------------------------------------------------------
    input       [ 2:0]                  PHY_TXMARGIN,          
    input                               PHY_TXSWING,           
    input                               PHY_TXDEEMPH,    
    input                               PHY_RXCDRHOLD,    
    
    //--------------------------------------------------------------------------   
    //  TX Equalization Ports (Gen3)
    //--------------------------------------------------------------------------  
    input       [(PHY_LANE*2)-1:0]      PHY_TXEQ_CTRL,      
    input       [(PHY_LANE*4)-1:0]      PHY_TXEQ_PRESET,       
    input       [(PHY_LANE*6)-1:0]      PHY_TXEQ_COEFF,                                                            

    output      [ 5:0]                  PHY_TXEQ_FS,           
    output      [ 5:0]                  PHY_TXEQ_LF,           
    output      [(PHY_LANE*18)-1:0]     PHY_TXEQ_NEW_COEFF,        
    output      [PHY_LANE-1:0]          PHY_TXEQ_DONE,         

    //--------------------------------------------------------------------------
    //  RX Equalization Ports (Gen3)
    //--------------------------------------------------------------------------                                               
    input       [(PHY_LANE*2)-1:0]      PHY_RXEQ_CTRL,     
    input       [(PHY_LANE*3)-1:0]      PHY_RXEQ_PRESET,  
    input       [(PHY_LANE*4)-1:0]      PHY_RXEQ_TXPRESET,      
    input       [(PHY_LANE*6)-1:0]      PHY_RXEQ_LFFS,                                                         

    output      [PHY_LANE-1:0]          PHY_RXEQ_LFFS_SEL,    
    output      [(PHY_LANE*18)-1:0]     PHY_RXEQ_NEW_TXCOEFF,   
    output      [PHY_LANE-1:0]          PHY_RXEQ_ADAPT_DONE,     
    output      [PHY_LANE-1:0]          PHY_RXEQ_DONE,         
    
   //---------- Shared Logic Internal -------------------------
    output      [(PHY_LANE-1)>>2:0]     INT_QPLL1LOCK_OUT,
    output      [(PHY_LANE-1)>>2:0]     INT_QPLL1OUTREFCLK_OUT,
    output      [(PHY_LANE-1)>>2:0]     INT_QPLL1OUTCLK_OUT,
    //---------- External GT COMMON Ports ----------------------
    output      [(PHY_LANE-1)>>2:0]             EXT_QPLL1REFCLK,
    output      [(PHY_LANE-1)>>2:0]             EXT_QPLL1PD,
    output      [((((PHY_LANE-1)>>2)+1)*3)-1:0] EXT_QPLL1RATE,
    output      [(PHY_LANE-1)>>2:0]             EXT_QPLL1RESET,

    input       [(PHY_LANE-1)>>2:0]             EXT_QPLL1LOCK_OUT,
    input       [(PHY_LANE-1)>>2:0]             EXT_QPLL1OUTCLK_OUT,
    input       [(PHY_LANE-1)>>2:0]             EXT_QPLL1OUTREFCLK_OUT,
    //--------------------------------------------------------------------------
    //  GT Debug Ports
    //--------------------------------------------------------------------------
    output                                 GTW_DRPCLK,   
    input       [((PHY_LANE *  9)-1):0]    GTW_DRPADDR, 
    input       [((PHY_LANE *  1)-1):0]    GTW_DRPEN,    
    input       [((PHY_LANE *  1)-1):0]    GTW_DRPWE,    
    input       [((PHY_LANE * 16)-1):0]    GTW_DRPDI,   
                                            
    output      [((PHY_LANE *  1)-1):0]    GTW_DRPRDY,   
    output      [((PHY_LANE * 16)-1):0]    GTW_DRPDO,     
    //--------------------------------------------------------------------------
    //  Transceiver Debug And Status Ports
    //--------------------------------------------------------------------------
    input       [PHY_LANE-1:0]          GT_PCIEUSERRATEDONE,
    input       [(PHY_LANE*3)-1:0]      GT_LOOPBACK        ,             
    input       [PHY_LANE-1:0]          GT_TXPRBSFORCEERR  ,            
    input       [PHY_LANE-1:0]          GT_TXINHIBIT       ,            
    input       [PHY_LANE*4-1:0]        GT_TXPRBSSEL       ,            
    input       [PHY_LANE*4-1:0]        GT_RXPRBSSEL       ,          
    input       [PHY_LANE-1:0]          GT_RXPRBSCNTRESET  ,             

    output      [PHY_LANE-1:0]          GT_TXELECIDLE      ,             
    output      [PHY_LANE-1:0]          GT_TXRESETDONE     ,    
    output      [PHY_LANE-1:0]          GT_RXRESETDONE     ,        
    output      [PHY_LANE-1:0]          GT_RXPMARESETDONE  ,      
    output      [PHY_LANE-1:0]          GT_TXPHALIGNDONE   ,            
    output      [PHY_LANE-1:0]          GT_TXPHINITDONE    ,         
    output      [PHY_LANE-1:0]          GT_TXDLYSRESETDONE ,         
    output      [PHY_LANE-1:0]          GT_RXPHALIGNDONE   ,        
    output      [PHY_LANE-1:0]          GT_RXDLYSRESETDONE ,          
    output      [PHY_LANE-1:0]          GT_RXSYNCDONE      ,        
    output      [PHY_LANE-1:0]          GT_EYESCANDATAERROR,               
    output      [PHY_LANE-1:0]          GT_RXPRBSERR       ,           
    output      [PHY_LANE-1:0]          GT_RXCOMMADET      ,                   
    output      [PHY_LANE-1:0]          GT_PHYSTATUS       ,                   
    output      [PHY_LANE-1:0]          GT_RXVALID         ,              
    output      [PHY_LANE-1:0]          GT_RXCDRLOCK, 
    output      [PHY_LANE-1:0]          GT_PCIERATEIDLE,
    output      [PHY_LANE-1:0]          GT_PCIEUSERRATESTART,
    output      [PHY_LANE-1:0]          GT_GTPOWERGOOD,  
    output      [PHY_LANE-1:0]          GT_CPLLLOCK,          
    output      [PHY_LANE-1:0]          GT_RXOUTCLK, 
    output      [PHY_LANE-1:0]          GT_RXRECCLKOUT, 
    
    output      [(PHY_LANE*17)-1:0]     GT_DMONITOROUT,           
    output      [(PHY_LANE-1)>>2:0]     GT_QPLL1LOCK,               
    output      [(PHY_LANE*3)-1:0]      GT_RXSTATUS,            
    output      [(PHY_LANE*3)-1:0]      GT_RXBUFSTATUS,            
    output      [8:0]                   GT_BUFGTDIV,                 
    output      [(PHY_LANE*2)-1:0]      TXEQ_CTRL,                  
    output      [(PHY_LANE*4)-1:0]      TXEQ_PRESET,                   
    output      [3:0]                   PHY_RST_FSM,                 
    output      [(PHY_LANE*3)-1:0]      PHY_TXEQ_FSM,                  
    output      [(PHY_LANE*3)-1:0]      PHY_RXEQ_FSM,                 
    output                              PHY_RST_IDLE,                 
    output                              PHY_RRST_N,
    output                              PHY_PRST_N        
);

//--------------------------------------------------------------------------------------------------
//  Internal Signals
//--------------------------------------------------------------------------------------------------

    //--------------------------------------------------------------------------
    //  Clock 
    //--------------------------------------------------------------------------
    wire                                pclk; 
    //--------------------------------------------------------------------------
    //  Reset
    //--------------------------------------------------------------------------
    wire                                rrst_n;
    wire                                prst_n;
    
    wire                                rst_cpllpd;
    wire                                rst_cpllreset;  
    wire                                rst_qpll1pd;  
    wire                                rst_qpll1reset;
    wire                                rst_progdivreset;
    wire                                rst_gtreset;
    wire                                rst_userrdy; 
    wire                                rst_txsync_start;
    wire                                rst_idle;

    //--------------------------------------------------------------------------
    //  TX Equalization (Gen3)
    //-------------------------------------------------------------------------- 
    wire        [(PHY_LANE*5)-1:0]      txeq_precursor; 
    wire        [(PHY_LANE*7)-1:0]      txeq_maincursor; 
    wire        [(PHY_LANE*5)-1:0]      txeq_postcursor; 
    wire        [(PHY_LANE*18)-1:0]     txeq_new_coeff; 
    wire        [PHY_LANE-1:0]          txeq_done;  
    
    //--------------------------------------------------------------------------
    //  RX Equalization (Gen3)
    //-------------------------------------------------------------------------- 
    wire        [PHY_LANE-1:0]          rxeq_lffs_sel;   
    wire        [(PHY_LANE*18)-1:0]     rxeq_new_txcoeff;    
    wire        [PHY_LANE-1:0]          rxeq_adapt_done;     
    wire        [PHY_LANE-1:0]          rxeq_done;   
    
    //--------------------------------------------------------------------------
    //  GT Channel 
    //--------------------------------------------------------------------------
    wire        [(PHY_LANE*3)-1:0]      gt_bufgtce;    
    wire        [(PHY_LANE*3)-1:0]      gt_bufgtcemask;
    wire        [(PHY_LANE*3)-1:0]      gt_bufgtreset;
    wire        [(PHY_LANE*3)-1:0]      gt_bufgtrstmask;   
    wire        [(PHY_LANE*9)-1:0]      gt_bufgtdiv;
    wire        [PHY_LANE-1:0]          gt_txoutclk;
    wire        [PHY_LANE-1:0]          gt_rxoutclk;
    wire        [PHY_LANE-1:0]          gt_rxrecclkout;    

    wire        [PHY_LANE-1:0]          gt_gtpowergood;
    wire        [PHY_LANE-1:0]          gt_txprogdivresetdone;
    wire        [PHY_LANE-1:0]          gt_rxprogdivresetdone;
    wire        [PHY_LANE-1:0]          gt_txresetdone;
    wire        [PHY_LANE-1:0]          gt_rxresetdone;
    
    wire        [(PHY_LANE*3)-1:0]      gt_qpllrate;                            // Not use in GT Wizard mode
    
    wire        [PHY_LANE-1:0]          gt_phystatus;
    
    wire        [PHY_LANE-1:0]          gt_pcieuserphystatusrst;
    wire        [(PHY_LANE*2)-1:0]      gt_pcierateqpllpd;                 
    wire        [(PHY_LANE*2)-1:0]      gt_pcierateqpllreset;               
    wire        [PHY_LANE-1:0]          gt_pcierateidle;            
    wire        [PHY_LANE-1:0]          gt_pciesynctxsyncdone;                    
    wire        [PHY_LANE-1:0]          gt_pcierategen3;  
    wire        [PHY_LANE-1:0]          gt_pcieusergen3rdy; 
    wire        [PHY_LANE-1:0]          gt_pcieuserratestart;  
    
    wire        [PHY_LANE-1:0]          gt_txphaligndone;                       // Not use in GT Wizard mode                         
    wire        [PHY_LANE-1:0]          gt_txsyncout;                           // Not use in GT Wizard mode
    
    wire        [PHY_LANE-1:0]          gt_cplllock;     
    wire        [PHY_LANE-1:0]          gt_rxcdrlock;    
                                   
    //--------------------------------------------------------------------------
    //  GT Common
    //--------------------------------------------------------------------------
    wire        [   (PHY_LANE-1)>>2          :0]    qpll1pd;                    // Not used in GT Wizard mode
    wire        [   (PHY_LANE-1)>>2          :0]    qpll1reset;                 // Not used in GT Wizard mode
    
    wire        [   (PHY_LANE-1)>>2          :0]    gtcom_qpll1lock;
    wire        [   (PHY_LANE-1)>>2          :0]    gtcom_qpll1outclk;          // Not used in GT Wizard mode
    wire        [   (PHY_LANE-1)>>2          :0]    gtcom_qpll1outrefclk;       // Not used in GT Wizard mode

    //--------------------------------------------------------------------------
    //  Signals converted from per lane
    //--------------------------------------------------------------------------
    wire                                qpll1lock_all;                          // Not used in GT Wizard mode
    wire                                txsyncallin_all;                        // Not used in GT Wizard mode
    
    wire [2:0] clk_pclk_div   ;
    wire [2:0] clk_coreclk_div;
    wire [2:0] clk_userclk_div;

assign clk_pclk_div    = gt_bufgtdiv[2:0];
assign clk_coreclk_div = gt_bufgtdiv[5:3];
assign clk_userclk_div = gt_bufgtdiv[8:6];
//--------------------------------------------------------------------------------------------------
//  PHY Clock 
//--------------------------------------------------------------------------------------------------
rp_phy_clk phy_clk_i
(
    //--------------------------------------------------------------------------
    //  PCLK Ports
    //--------------------------------------------------------------------------
    .CLK_PCLK_CE                        (gt_bufgtce[0]),                        
    .CLK_PCLK_CEMASK                    (gt_bufgtcemask[0]), 
    .CLK_PCLK_CLR                       (gt_bufgtreset[0]),                     
    .CLK_PCLK_MASK                      (gt_bufgtrstmask[0]),   
    .CLK_PCLK_DIV                       (clk_pclk_div), //(gt_bufgtdiv[2:0]),    
    .CLK_PCLK_IN                        (gt_txoutclk[0]),     
    .CLK_PCLK                           (pclk),
    
    //--------------------------------------------------------------------------
    //  CORECLK Ports
    //--------------------------------------------------------------------------
    .CLK_CORECLK_CE                     (gt_bufgtce[0]),                        
    .CLK_CORECLK_CEMASK                 (rst_idle),            
    .CLK_CORECLK_CLR                    (gt_bufgtreset[0]),                     
    .CLK_CORECLK_MASK                   (rst_idle),              
    .CLK_CORECLK_DIV                    (clk_coreclk_div), //(gt_bufgtdiv[5:3]),               
    .CLK_CORECLK_IN                     (gt_txoutclk[0]),                       
    .CLK_CORECLK                        (PHY_CORECLK), 
    
    //--------------------------------------------------------------------------
    //  USERCLK Ports
    //--------------------------------------------------------------------------
    .CLK_USERCLK_CE                     (gt_bufgtce[0]),                        
    .CLK_USERCLK_CEMASK                 (rst_idle),
    .CLK_USERCLK_CLR                    (gt_bufgtreset[0]),                     
    .CLK_USERCLK_MASK                   (rst_idle),
    .CLK_USERCLK_DIV                    (clk_userclk_div), //(gt_bufgtdiv[8:6]),
    .CLK_USERCLK_IN                     (gt_txoutclk[0]),  
    .CLK_USERCLK                        (PHY_USERCLK)
);

BUFG_GT bufg_mcap_clk (.CE (gt_bufgtce[0]), .CEMASK (1'd0), .CLR (gt_bufgtreset[0]), .CLRMASK (1'd0), .DIV (3'd1), .I (gt_txoutclk[0]), .O (mcap_clk));

//--------------------------------------------------------------------------------------------------
//  PHY Reset
//--------------------------------------------------------------------------------------------------
rp_phy_rst #
(
    .PHY_LANE                           (PHY_LANE),
    .PL_UPSTREAM_FACING                 (PL_UPSTREAM_FACING),
    .PHY_MAX_SPEED                      (PHY_MAX_SPEED)            
)
phy_rst_i
(
    //-------------------------------------------------------------------------- 
    //  Input Ports
    //--------------------------------------------------------------------------       
    .RST_REFCLK                         (PHY_REFCLK),   
    .RST_PCLK                           (pclk),                         
    .RST_N                              (PHY_RST_N),  
    .RST_GTPOWERGOOD                    (gt_gtpowergood),                
    .RST_QPLL0LOCK                      (2'b0),                
    .RST_QPLL1LOCK                      (gtcom_qpll1lock), 
    .RST_CPLLLOCK                       (gt_cplllock),
    .RST_TXPROGDIVRESETDONE             (gt_txprogdivresetdone),
    .RST_RXPROGDIVRESETDONE             (gt_rxprogdivresetdone),                             
    .RST_TXRESETDONE                    (gt_txresetdone), 
    .RST_RXRESETDONE                    (gt_rxresetdone), 
    .RST_TXSYNC_DONE                    (gt_pciesynctxsyncdone),     
    .RST_PHYSTATUS                      (gt_phystatus),                                             

    //-------------------------------------------------------------------------- 
    //  Output Ports
    //--------------------------------------------------------------------------   
    .phy_rst_fsm                        (PHY_RST_FSM),
    .RST_RRST_N                         (rrst_n),
    .RST_PRST_N                         (prst_n), 
    .RST_CPLLPD                         (rst_cpllpd),               
    .RST_CPLLRESET                      (rst_cpllreset),  
    .RST_QPLLPD                         (rst_qpll1pd),
    .RST_QPLLRESET                      (rst_qpll1reset),  
    .RST_TXPROGDIVRESET                 (rst_progdivreset),                              
    .RST_GTRESET                        (rst_gtreset),               
    .RST_USERRDY                        (rst_userrdy),   
    .RST_TXSYNC_START                   (rst_txsync_start),                                
    .RST_IDLE                           (rst_idle)                          
);
   


//--------------------------------------------------------------------------------------------------
//  Generate PHY Lane - Begin
//--------------------------------------------------------------------------------------------------
genvar i;   
    
generate for (i=0; i<PHY_LANE; i=i+1) 

    begin : phy_lane

    //----------------------------------------------------------------------------------------------
    //  PHY TX Equalization (Gen3)
    //----------------------------------------------------------------------------------------------
rp_phy_txeq #
    (
        .PHY_GT_TXPRESET                (PHY_GT_TXPRESET)                
    )
    phy_txeq_i
    (
        //---------------------------------------------------------------------- 
        //  Input Ports
        //----------------------------------------------------------------------  
        .TXEQ_CLK                       (pclk),
        .TXEQ_RST_N                     (prst_n),    
        .TXEQ_CTRL                      (PHY_TXEQ_CTRL[(2*i)+1:(2*i)]), 
        .TXEQ_PRESET                    (PHY_TXEQ_PRESET[(4*i)+3:(4*i)]), 
        .TXEQ_COEFF                     (PHY_TXEQ_COEFF[(6*i)+5:(6*i)]),

        //---------------------------------------------------------------------- 
        //  Output Ports
        //----------------------------------------------------------------------   
        .phy_txeq_fsm                   (PHY_TXEQ_FSM[(3*i)+2:(3*i)]),
        .TXEQ_PRECURSOR                 (txeq_precursor[(5*i)+4:(5*i)]),        
        .TXEQ_MAINCURSOR                (txeq_maincursor[(7*i)+6:(7*i)]),       
        .TXEQ_POSTCURSOR                (txeq_postcursor[(5*i)+4:(5*i)]),       
        .TXEQ_NEW_COEFF                 (txeq_new_coeff[(18*i)+17:(18*i)]),          
        .TXEQ_DONE                      (txeq_done[i])      
    );                                                   



    //----------------------------------------------------------------------------------------------
    //  PHY RX Equalization (Gen3)
    //----------------------------------------------------------------------------------------------
rp_phy_rxeq #
    (
        .PHY_SIM_EN                     (PHY_SIM_EN),
        .PHY_LP_TXPRESET                (PHY_LP_TXPRESET)                
    )
    phy_rxeq_i
    (
        //---------------------------------------------------------------------- 
        //  Input Ports
        //----------------------------------------------------------------------  
        .RXEQ_CLK                       (pclk),
        .RXEQ_RST_N                     (prst_n),    
        .RXEQ_CTRL                      (PHY_RXEQ_CTRL[(2*i)+1:(2*i)]), 
        .RXEQ_PRESET                    (PHY_RXEQ_PRESET[(3*i)+2:(3*i)]), 
        .RXEQ_TXPRESET                  (PHY_RXEQ_TXPRESET[(4*i)+3:(4*i)]),
        .RXEQ_TXCOEFF                   (PHY_TXEQ_COEFF[(6*i)+5:(6*i)]),
        .RXEQ_LFFS                      (PHY_RXEQ_LFFS[(6*i)+5:(6*i)]),

        //---------------------------------------------------------------------- 
        //  Output Ports
        //----------------------------------------------------------------------     
        .phy_rxeq_fsm                   (PHY_RXEQ_FSM[(3*i)+2:(3*i)]),
        .RXEQ_LFFS_SEL                  (rxeq_lffs_sel[i]),   
        .RXEQ_NEW_TXCOEFF               (rxeq_new_txcoeff[(18*i)+17:(18*i)]),    
        .RXEQ_ADAPT_DONE                (rxeq_adapt_done[i]),      
        .RXEQ_DONE                      (rxeq_done[i])      
    );


if (DIS_GT_WIZARD == "TRUE") begin : gt_channel_int

        //----------------------------------------------------------------------
        //  Use Default GT Wrapper   -   GT Channel  
        //----------------------------------------------------------------------
rp_gt_channel #
        (
            .PHY_SIM_EN                     (PHY_SIM_EN),   
            .PHY_LANE                       (PHY_LANE),    
            .PHY_MAX_SPEED                  (PHY_MAX_SPEED),
            .PHY_ASYNC_EN                   (PHY_ASYNC_EN),
            .PHY_REFCLK_FREQ                (PHY_REFCLK_FREQ),       
            .PHY_USERCLK_FREQ               (PHY_USERCLK_FREQ),          
            .PHY_CORECLK_FREQ               (PHY_CORECLK_FREQ),
            .GT_LANE_NUM                    (i)                      
        )
        gt_channel_i
        (  
        
            //------------------------------------------------------------------
            //  Clock Ports
            //------------------------------------------------------------------
            .GT_GTREFCLK0                   (PHY_GTREFCLK),
            .GT_TXUSRCLK                    (pclk),
            .GT_RXUSRCLK                    (pclk), 
            .GT_TXUSRCLK2                   (pclk),
            .GT_RXUSRCLK2                   (pclk), 
            
            //------------------------------------------------------------------
            //  BUFG_GT Controller Ports                                               
            //------------------------------------------------------------------ 
            .GT_BUFGTCE                     (gt_bufgtce[(3*i)+2:(3*i)]),     
            .GT_BUFGTCEMASK                 (gt_bufgtcemask[(3*i)+2:(3*i)]), 
            .GT_BUFGTRESET                  (gt_bufgtreset[(3*i)+2:(3*i)]),
            .GT_BUFGTRSTMASK                (gt_bufgtrstmask[(3*i)+2:(3*i)]),   
            .GT_BUFGTDIV                    (gt_bufgtdiv[(9*i)+8:(9*i)]),
            .GT_TXOUTCLK                    (gt_txoutclk[i]),    
            .GT_RXOUTCLK                    (gt_rxoutclk[i]), 
            .GT_RXRECCLKOUT                 (gt_rxrecclkout[i]),
            
            //------------------------------------------------------------------
            //  Reset Ports
            //------------------------------------------------------------------
            .GT_CPLLPD                      (rst_cpllpd), 
            .GTHE3_TXOUTCLKSEL_OUT          (3'd5),
            .GT_CPLLRESET                   (rst_cpllreset),
            .GT_TXPROGDIVRESET              (rst_progdivreset),
            .GT_RXPROGDIVRESET              (rst_progdivreset),

            .GT_GTTXRESET                   (rst_gtreset),
            .GT_GTRXRESET                   (rst_gtreset), 
            .GT_TXUSERRDY                   (rst_userrdy),
            .GT_RXUSERRDY                   (rst_userrdy),              
                             
            .GT_GTPOWERGOOD                 (gt_gtpowergood[i]), 
            .GT_TXPROGDIVRESETDONE          (gt_txprogdivresetdone[i]),
            .GT_RXPROGDIVRESETDONE          (gt_rxprogdivresetdone[i]),                  
            .GT_TXRESETDONE                 (gt_txresetdone[i]),
            .GT_RXRESETDONE                 (gt_rxresetdone[i]),
            
            //------------------------------------------------------------------
            //  QPLL Ports
            //------------------------------------------------------------------
            .GT_QPLLCLK                     (gtcom_qpll1outclk[i>>2]),
            .GT_QPLLREFCLK                  (gtcom_qpll1outrefclk[i>>2]), 
            .GT_QPLLLOCK                    (qpll1lock_all),                    // From all lanes
            
            .GT_QPLLRATE                    (gt_qpllrate[(3*i)+2:(3*i)]),
            
            //------------------------------------------------------------------
            //  Serial Line Ports
            //------------------------------------------------------------------
            .GT_RXP                         (PHY_RXP[i]),
            .GT_RXN                         (PHY_RXN[i]),
            
            .GT_TXP                         (PHY_TXP[i]),
            .GT_TXN                         (PHY_TXN[i]),
            
            //------------------------------------------------------------------
            //  TX Data Ports
            //------------------------------------------------------------------
            .GT_TXDATA                      (PHY_TXDATA[(32*i)+31:(32*i)]),
            .GT_TXDATAK                     (PHY_TXDATAK[(2*i)+1:(2*i)]),
            .GT_TXDATA_VALID                (PHY_TXDATA_VALID[i]),
            .GT_TXSTART_BLOCK               (PHY_TXSTART_BLOCK[i]),
            .GT_TXSYNC_HEADER               (PHY_TXSYNC_HEADER[(2*i)+1:(2*i)]),
            
            //------------------------------------------------------------------
            //  RX Data Ports
            //------------------------------------------------------------------
            .GT_RXDATA                      (PHY_RXDATA[(32*i)+31:(32*i)]),
            .GT_RXDATAK                     (PHY_RXDATAK[(2*i)+1:(2*i)]),
            .GT_RXDATA_VALID                (PHY_RXDATA_VALID[i]),
            .GT_RXSTART_BLOCK               (PHY_RXSTART_BLOCK[i]),
            .GT_RXSYNC_HEADER               (PHY_RXSYNC_HEADER[(2*i)+1:(2*i)]),
            
            //------------------------------------------------------------------
            //  PHY Command Ports
            //------------------------------------------------------------------
            .GT_TXDETECTRX                  (PHY_TXDETECTRX),
            .GT_TXELECIDLE                  (PHY_TXELECIDLE[i]), 
            .GT_TXCOMPLIANCE                (PHY_TXCOMPLIANCE[i]),
            .GT_RXPOLARITY                  (PHY_RXPOLARITY[i]),
            .GT_POWERDOWN                   (PHY_POWERDOWN),
            .GT_RATE                        (PHY_RATE),       
                
            //------------------------------------------------------------------
            //  PHY Status Ports
            //------------------------------------------------------------------
            .GT_RXVALID                     (PHY_RXVALID[i]),
            .GT_PHYSTATUS                   (gt_phystatus[i]),
            .GT_RXELECIDLE                  (PHY_RXELECIDLE[i]),
            .GT_RXSTATUS                    (PHY_RXSTATUS[(3*i)+2:(3*i)]),
                
            //------------------------------------------------------------------
            //  TX Driver Ports
            //------------------------------------------------------------------
            .GT_TXMARGIN                    (PHY_TXMARGIN),
            .GT_TXSWING                     (PHY_TXSWING),
            .GT_TXDEEMPH                    (PHY_TXDEEMPH),  
            .GT_RXCDRHOLD                   (PHY_RXCDRHOLD),  
            
            //------------------------------------------------------------------
            //  TX Equalization Ports (Gen3) 
            //------------------------------------------------------------------
            .GT_TXPRECURSOR                 (txeq_precursor[(5*i)+4:(5*i)]),
            .GT_TXMAINCURSOR                (txeq_maincursor[(7*i)+6:(7*i)]),
            .GT_TXPOSTCURSOR                (txeq_postcursor[(5*i)+4:(5*i)]),
            
            //------------------------------------------------------------------
            //  PCIe PCS (Advance Feature)
            //------------------------------------------------------------------
            .GT_PCIERSTIDLE                 (rst_idle),        
            .GT_PCIERSTTXSYNCSTART          (rst_txsync_start), 
            .GT_PCIEEQRXEQADAPTDONE         (1'd0),                             // Not used
            .GT_PCIEUSERRATEDONE            (GT_PCIEUSERRATEDONE[i]),
        
            .GT_PCIEUSERPHYSTATUSRST        (gt_pcieuserphystatusrst[i]),    
            .GT_PCIERATEQPLLPD              (gt_pcierateqpllpd[(2*i)+1:(2*i)]),     
            .GT_PCIERATEQPLLRESET           (gt_pcierateqpllreset[(2*i)+1:(2*i)]), 
            .GT_PCIERATEIDLE                (gt_pcierateidle[i]),            
            .GT_PCIESYNCTXSYNCDONE          (gt_pciesynctxsyncdone[i]),  
            .GT_PCIERATEGEN3                (gt_pcierategen3[i]),    
            .GT_PCIEUSERGEN3RDY             (gt_pcieusergen3rdy[i]),  
            .GT_PCIEUSERRATESTART           (gt_pcieuserratestart[i]), 
            
            //------------------------------------------------------------------
            //  TX Sync Alignment Ports
            //------------------------------------------------------------------
            .GT_TXSYNCALLIN                 (txsyncallin_all),                  // From all lanes
            .GT_TXSYNCIN                    (gt_txsyncout[0]),                  // From Master Lane 0        
        
            .GT_TXPHALIGNDONE               (gt_txphaligndone[i]),            
            .GT_TXSYNCOUT                   (gt_txsyncout[i]),
            
            //--------------------------------------------------------------
            //  DRP Ports to/from CPLL_CAL module
            //--------------------------------------------------------------
            .GT_DRPCLK                      (PHY_REFCLK),
            .GT_DRPADDR                     (9'b000000000),
            .GT_DRPDI                       (16'h0000),
            .GT_DRPEN                       (1'b0),
            .GT_DRPWE                       (1'b0),
            .GT_DRPRDY                      ( ),
            .GT_DRPDO                       ( ),
             //-----------------------------------------------------------------
             //  Loopback and PRBS Ports
             //-----------------------------------------------------------------  
            .GT_LOOPBACK                    (GT_LOOPBACK[(3*i)+2:(3*i)]),
            .GT_PRBSSEL                     (GT_TXPRBSSEL[(4*i)+3:(4*i)]),
            .GT_TXPRBSFORCEERR              (GT_TXPRBSFORCEERR[i]),
            .GT_TXINHIBIT                   (GT_TXINHIBIT[i]),
            .GT_RXPRBSCNTRESET              (GT_RXPRBSCNTRESET[i]),                                           

            .GT_RXPMARESETDONE              (GT_RXPMARESETDONE[i]),
            .GT_RXPRBSERR                   (GT_RXPRBSERR[i]),                                              
            .GT_RXPRBSLOCKED                (),  

            .GT_RXPHALIGNDONE               (GT_RXPHALIGNDONE[i] ), 
            .GT_RXDLYSRESETDONE             (GT_RXDLYSRESETDONE[i] ),    
            .GT_TXDLYSRESETDONE             (GT_TXDLYSRESETDONE[i] ),    
            .GT_RXSYNCDONE                  (GT_RXSYNCDONE[i] ),
            .GT_EYESCANDATAERROR            (GT_EYESCANDATAERROR[i] ),
            .GT_DMONITOROUT                 (GT_DMONITOROUT[(17*i)+16:(17*i)] ),
            .GT_TXPHINITDONE                (GT_TXPHINITDONE[i]),
            .GT_RXCOMMADET                  (GT_RXCOMMADET[i]),
            .GT_RXBUFSTATUS                 (GT_RXBUFSTATUS[(3*i)+2:(3*i)]),
            //------------------------------------------------------------------
            //  GT Status Ports
            //------------------------------------------------------------------                                              
            .GT_MASTER_CPLLLOCK             (gt_cplllock[0]),                   // From Master Lane 0 
            
            .GT_CPLLLOCK                    (gt_cplllock[i]),  
            .GT_RXCDRLOCK                   (gt_rxcdrlock[i])
        );
        
end // gt_channel_int

        
        //------------------------------------------------------------------------------------------
        //  PHY Quad - Generate one Quad for every four Lanes
        //------------------------------------------------------------------------------------------
        if ((i%4)==0) 
                       
            begin : phy_quad   
                 
            //------------------------------------------------------------------
            //  Generate QPLL Powerdown and Reset
            //------------------------------------------------------------------
            //  * QPLL reset and powerdown for Quad 1 driven by       Master Lane 0
            //  * QPLL reset and powerdown for Quad 2 driven by Local Master Lane 4
            //------------------------------------------------------------------        
            assign qpll1pd[i>>2]    = (i > 3) ? (rst_qpll1pd    || gt_pcierateqpllpd[i*2]) : 
                                                (rst_qpll1pd    || gt_pcierateqpllpd[0]);
                                             
            assign qpll1reset[i>>2] = (i > 3) ? (rst_qpll1reset || gt_pcierateqpllreset[i*2]) : 
                                                (rst_qpll1reset || gt_pcierateqpllreset[0]);                                 


if ((SHARED_LOGIC == 1) && (DIS_GT_WIZARD == "TRUE")) begin : gt_common_int
            //------------------------------------------------------------------
            //  GT Common Module                                                   
            //------------------------------------------------------------------
rp_gt_common #
            (
                //--------------------------------------------------------------
                //  User Attributes
                //--------------------------------------------------------------
                .PHY_SIM_EN                 (PHY_SIM_EN),   
                .PHY_REFCLK_FREQ            (PHY_REFCLK_FREQ),       
                .GT_QUAD_NUM                (i>>2)                 
            )
            gt_common_i
            (    
                //--------------------------------------------------------------
                //  Clock Ports
                //--------------------------------------------------------------
                .GTCOM_REFCLK               (PHY_GTREFCLK),
                
                .GTCOM_QPLL1LOCK            (gtcom_qpll1lock[i>>2]),
                .GTCOM_QPLL1OUTCLK          (gtcom_qpll1outclk[i>>2]),
                .GTCOM_QPLL1OUTREFCLK       (gtcom_qpll1outrefclk[i>>2]),
                
                //--------------------------------------------------------------
                //  Reset Ports
                //--------------------------------------------------------------
                .GTCOM_QPLL1PD              (qpll1pd[i>>2]),         
                .GTCOM_QPLL1RESET           (qpll1reset[i>>2]),
                
                //--------------------------------------------------------------
                //  QPLL Ports
                //--------------------------------------------------------------    
              //.GTCOM_QPLLRATE             (gt_qpllrate[2:0]),                 // From Master Lane 0
                .GTCOM_QPLLRATE             ({1'd0, PHY_RATE}),                 // From RATE port
                
                //--------------------------------------------------------------
                //  DRP Ports
                //--------------------------------------------------------------
                .GTCOM_DRPCLK               (1'b0 ),          
                .GTCOM_DRPADDR              (9'b000000000 ),                       
                .GTCOM_DRPEN                (1'b0),       
                .GTCOM_DRPWE                (1'b0 ),
                .GTCOM_DRPDI                (16'h0000),                     
                                            
                .GTCOM_DRPRDY               ( ),
                .GTCOM_DRPDO                ( )
            );
              assign EXT_QPLL1REFCLK[i>>2]                     = 1'b0;
              assign EXT_QPLL1PD[i>>2]                         = 1'b0;
              assign EXT_QPLL1RATE[(3*(i>>2))+2:(3*(i>>2))]    = 3'b000;
              assign EXT_QPLL1RESET[i>>2]                      = 1'b0;              
              assign INT_QPLL1LOCK_OUT[i>>2]                = gtcom_qpll1lock[i>>2] ;
              assign INT_QPLL1OUTREFCLK_OUT[i>>2]           = gtcom_qpll1outrefclk[i>>2];
              assign INT_QPLL1OUTCLK_OUT[i>>2]              = gtcom_qpll1outclk[i>>2];
end // gt_common_int

if ((SHARED_LOGIC == 0) && (DIS_GT_WIZARD == "TRUE")) begin : sls_s0d1
              assign EXT_QPLL1REFCLK[i>>2]                  = PHY_GTREFCLK;
              assign EXT_QPLL1RATE[(3*(i>>2))+2:(3*(i>>2))] = {1'd0, PHY_RATE};
              assign EXT_QPLL1PD[i>>2]                      = qpll1pd[i>>2];
              assign EXT_QPLL1RESET[i>>2]                   = qpll1reset[i>>2];              
              assign gtcom_qpll1lock[i>>2]                  = EXT_QPLL1LOCK_OUT[i>>2];
              assign gtcom_qpll1outclk[i>>2]                = EXT_QPLL1OUTCLK_OUT[i>>2];
              assign gtcom_qpll1outrefclk[i>>2]             = EXT_QPLL1OUTREFCLK_OUT[i>>2];
              assign INT_QPLL1LOCK_OUT[i>>2]                = 1'b0;  
              assign INT_QPLL1OUTREFCLK_OUT[i>>2]           = 1'b0; 
              assign INT_QPLL1OUTCLK_OUT[i>>2]              = 1'b0; 
end // sls_s0d1

if ((SHARED_LOGIC == 1) && (DIS_GT_WIZARD == "FALSE")) begin : sls_s1d0
              assign EXT_QPLL1REFCLK[i>>2]                     = 1'b0;
              assign EXT_QPLL1PD[i>>2]                         = 1'b0;
              assign EXT_QPLL1RATE[(3*(i>>2))+2:(3*(i>>2))]    = 3'b000;
              assign EXT_QPLL1RESET[i>>2]                      = 1'b0;              
              assign INT_QPLL1LOCK_OUT      = gtcom_qpll1lock;
              assign INT_QPLL1OUTREFCLK_OUT = gtcom_qpll1outrefclk;
              assign INT_QPLL1OUTCLK_OUT    = gtcom_qpll1outclk;
end // sls_s1d0

if ((SHARED_LOGIC == 0) && (DIS_GT_WIZARD == "FALSE")) begin : sls_s0d00
              assign gtcom_qpll1lock[i>>2]                  = EXT_QPLL1LOCK_OUT[i>>2];
              assign gtcom_qpll1outclk[i>>2]                = EXT_QPLL1OUTCLK_OUT[i>>2];
              assign gtcom_qpll1outrefclk[i>>2]             = EXT_QPLL1OUTREFCLK_OUT[i>>2];            
end // sls_s0d00

end // phy_quad 
end // phy_lane
endgenerate 

  generate
if ((SHARED_LOGIC == 0) && (DIS_GT_WIZARD == "FALSE")) begin : sls_s0d01
              assign EXT_QPLL1REFCLK        = ({(((PHY_LANE)>>2)+1){PHY_GTREFCLK}});
              assign EXT_QPLL1RATE          = ({(((PHY_LANE)>>2)+1){1'd0, PHY_RATE}});
              assign EXT_QPLL1PD            = ({(((PHY_LANE)>>2)+1){qpll1pd}});
              assign EXT_QPLL1RESET         = ({(((PHY_LANE)>>2)+1){qpll1reset}});              
              assign INT_QPLL1LOCK_OUT      = 0;    
              assign INT_QPLL1OUTREFCLK_OUT = 0;  
              assign INT_QPLL1OUTCLK_OUT    = 0; 
end // sls_s0d01
  endgenerate
//--------------------------------------------------------------------------------------------------
//  Use GT Wizard 
//--------------------------------------------------------------------------------------------------
  generate
if (DIS_GT_WIZARD == "FALSE") begin : gt_wizard
assign gt_rxoutclk    = 0;
assign gt_rxrecclkout = 0;
        //----------------------------------------------------------------------
        //  GT Channel
        //----------------------------------------------------------------------
rp_gtwizard_top #
        (
            .PHY_MAX_SPEED                  (PHY_MAX_SPEED),
            .PHY_LANE                       (PHY_LANE)                    
        )
        gtwizard_top_i
        (  
        
            //------------------------------------------------------------------
            //  Clock Ports *
            //------------------------------------------------------------------
            .GT_GTREFCLK0                   (PHY_GTREFCLK),                     
            .GT_TXUSRCLK                    ({PHY_LANE{pclk}}),
            .GT_RXUSRCLK                    ({PHY_LANE{pclk}}), 
            .GT_TXUSRCLK2                   ({PHY_LANE{pclk}}),
            .GT_RXUSRCLK2                   ({PHY_LANE{pclk}}), 
            
            //------------------------------------------------------------------
            //  BUFG_GT Controller Ports *                                               
            //------------------------------------------------------------------ 
            .GT_BUFGTCE                     (gt_bufgtce),     
            .GT_BUFGTCEMASK                 (gt_bufgtcemask), 
            .GT_BUFGTRESET                  (gt_bufgtreset),
            .GT_BUFGTRSTMASK                (gt_bufgtrstmask),   
            .GT_BUFGTDIV                    (gt_bufgtdiv),
            .GT_TXOUTCLK                    (gt_txoutclk),   
          //.GT_RXOUTCLK                    (gt_rxoutclk),
          //.GT_RXRECCLKOUT                 (gt_rxrecclkout), 
            
            //------------------------------------------------------------------  
            //  Reset Ports *                                                      
            //------------------------------------------------------------------  
            .GT_CPLLPD                      ({PHY_LANE{rst_cpllpd}}),              
            .GT_CPLLRESET                   ({PHY_LANE{rst_cpllreset}}),           
            .GT_TXPROGDIVRESET              ({PHY_LANE{rst_progdivreset}}),        
            .GT_RXPROGDIVRESET              ({PHY_LANE{rst_progdivreset}}),        
            .GT_GTTXRESET                   ({PHY_LANE{rst_gtreset}}),             
            .GT_GTRXRESET                   ({PHY_LANE{rst_gtreset}}),             
            .GT_TXUSERRDY                   ({PHY_LANE{rst_userrdy}}),             
            .GT_RXUSERRDY                   ({PHY_LANE{rst_userrdy}}),             
                                                                                  
            .GT_GTPOWERGOOD                 (gt_gtpowergood),                     
            .GT_TXPROGDIVRESETDONE          (gt_txprogdivresetdone),              
            .GT_RXPROGDIVRESETDONE          (gt_rxprogdivresetdone),              
            .GT_TXRESETDONE                 (gt_txresetdone),                     
            .GT_RXRESETDONE                 (gt_rxresetdone),                     
            
            //--------------------------------------------------------------
            //  Common QPLL Ports *
            //--------------------------------------------------------------
            .GTCOM_QPLL1PD                  (qpll1pd),         
            .GTCOM_QPLL1RESET               (qpll1reset),
            
            .GTCOM_QPLL1LOCK                (gtcom_qpll1lock),
            .GTCOM_QPLL1OUTCLK              (gtcom_qpll1outclk),
            .GTCOM_QPLL1OUTREFCLK           (gtcom_qpll1outrefclk),
            
            //--------------------------------------------------------------
            //  Common DRP Ports *
            //--------------------------------------------------------------
            .GTCOM_DRPCLK                   ( {(((PHY_LANE)>>3)+1){1'b0}} ),                                     
            .GTCOM_DRPADDR                  ( {(((PHY_LANE)>>3)+1){9'b000000000}} ),  
            .GTCOM_DRPEN                    ( {(((PHY_LANE)>>3)+1){1'b0}} ),     
            .GTCOM_DRPWE                    ( {(((PHY_LANE)>>3)+1){1'b0}} ),
            .GTCOM_DRPDI                    ( {(((PHY_LANE)>>3)+1){16'h0000}} ),
                                                                         
            .GTCOM_DRPRDY                   ( ),
            .GTCOM_DRPDO                    ( ),
            
            .GT_DRPCLK                      ({PHY_LANE{PHY_REFCLK}}),
            .GT_DRPADDR                     (GTW_DRPADDR ),  
            .GT_DRPEN                       (GTW_DRPEN ),                
            .GT_DRPWE                       (GTW_DRPWE ),                
            .GT_DRPDI                       (GTW_DRPDI ), 
            .GT_DRPRDY                      (GTW_DRPRDY ),               
            .GT_DRPDO                       (GTW_DRPDO ), 
            //------------------------------------------------------------------
            //  Serial Line Ports *
            //------------------------------------------------------------------
            .GT_RXP                         (PHY_RXP),
            .GT_RXN                         (PHY_RXN),
            
            .GT_TXP                         (PHY_TXP),
            .GT_TXN                         (PHY_TXN),
            
            //------------------------------------------------------------------
            //  TX Data Ports *
            //------------------------------------------------------------------
            .GT_TXDATA                      (PHY_TXDATA),
            .GT_TXDATAK                     (PHY_TXDATAK),
            .GT_TXDATA_VALID                (PHY_TXDATA_VALID),
            .GT_TXSTART_BLOCK               (PHY_TXSTART_BLOCK),
            .GT_TXSYNC_HEADER               (PHY_TXSYNC_HEADER),
            
            //------------------------------------------------------------------
            //  RX Data Ports *
            //------------------------------------------------------------------
            .GT_RXDATA                      (PHY_RXDATA),
            .GT_RXDATAK                     (PHY_RXDATAK),
            .GT_RXDATA_VALID                (PHY_RXDATA_VALID),
            .GT_RXSTART_BLOCK               (PHY_RXSTART_BLOCK),
            .GT_RXSYNC_HEADER               (PHY_RXSYNC_HEADER),
            
            //------------------------------------------------------------------
            //  PHY Command Ports *
            //------------------------------------------------------------------
            .GT_TXDETECTRX                  ({PHY_LANE{PHY_TXDETECTRX}}),
            .GT_TXELECIDLE                  (PHY_TXELECIDLE), 
            .GT_TXCOMPLIANCE                (PHY_TXCOMPLIANCE),
            .GT_RXPOLARITY                  (PHY_RXPOLARITY),
            .GT_POWERDOWN                   ({PHY_LANE{PHY_POWERDOWN}}),
            .GT_RATE                        ({PHY_LANE{PHY_RATE}}),       
                
            //------------------------------------------------------------------
            //  PHY Status Ports *
            //------------------------------------------------------------------
            .GT_RXVALID                     (PHY_RXVALID),
            .GT_PHYSTATUS                   (gt_phystatus),
            .GT_RXELECIDLE                  (PHY_RXELECIDLE),
            .GT_RXSTATUS                    (PHY_RXSTATUS),
                
            //------------------------------------------------------------------
            //  TX Driver Ports *
            //------------------------------------------------------------------
            .GT_TXMARGIN                    ({PHY_LANE{PHY_TXMARGIN}}),
            .GT_TXSWING                     ({PHY_LANE{PHY_TXSWING}}),
            .GT_TXDEEMPH                    ({PHY_LANE{PHY_TXDEEMPH}}),  
            .GT_RXCDRHOLD                   ({PHY_LANE{PHY_RXCDRHOLD}}),  
            
            //------------------------------------------------------------------
            //  TX Equalization Ports (Gen3) *
            //------------------------------------------------------------------
            .GT_TXPRECURSOR                 (txeq_precursor),
            .GT_TXMAINCURSOR                (txeq_maincursor),
            .GT_TXPOSTCURSOR                (txeq_postcursor),
            
            //------------------------------------------------------------------
            //  PCIe PCS (Advance Feature) *
            //------------------------------------------------------------------
            .GT_PCIERSTIDLE                 ({PHY_LANE{rst_idle}}),        
            .GT_PCIERSTTXSYNCSTART          ({PHY_LANE{rst_txsync_start}}), 
            .GT_PCIEEQRXEQADAPTDONE         ({PHY_LANE{1'd0}}),                 // Not used
            .GT_PCIEUSERRATEDONE            (GT_PCIEUSERRATEDONE),
        
            .GT_PCIEUSERPHYSTATUSRST        (gt_pcieuserphystatusrst),    
            .GT_PCIERATEQPLLPD              (gt_pcierateqpllpd),     
            .GT_PCIERATEQPLLRESET           (gt_pcierateqpllreset), 
            .GT_PCIERATEIDLE                (gt_pcierateidle),            
            .GT_PCIESYNCTXSYNCDONE          (gt_pciesynctxsyncdone),  
            .GT_PCIERATEGEN3                (gt_pcierategen3),    
            .GT_PCIEUSERGEN3RDY             (gt_pcieusergen3rdy),  
            .GT_PCIEUSERRATESTART           (gt_pcieuserratestart), 
            
            .GT_TXPHALIGNDONE               (gt_txphaligndone),            
             //-----------------------------------------------------------------
             //  Loopback and PRBS Ports *
             //-----------------------------------------------------------------  
            .GT_LOOPBACK                    (GT_LOOPBACK),                                        
            .GT_PRBSSEL                     (GT_TXPRBSSEL),
            .GT_TXPRBSFORCEERR              (GT_TXPRBSFORCEERR), 
            .GT_TXINHIBIT                   (GT_TXINHIBIT),
            .GT_RXPRBSCNTRESET              (GT_RXPRBSCNTRESET),                                                                                                      
            
            .GT_RXPMARESETDONE              (GT_RXPMARESETDONE),
            .GT_RXPRBSERR                   (GT_RXPRBSERR ),                                              
            .GT_RXPRBSLOCKED                ( ),  
        
            .GT_RXPHALIGNDONE               (GT_RXPHALIGNDONE ), 
            .GT_RXDLYSRESETDONE             (GT_RXDLYSRESETDONE ),    
            .GT_TXDLYSRESETDONE             (GT_TXDLYSRESETDONE ),    
            .GT_RXSYNCDONE                  (GT_RXSYNCDONE ),
            .GT_EYESCANDATAERROR            (GT_EYESCANDATAERROR ),
            .GT_DMONITOROUT                 (GT_DMONITOROUT ),
            .GT_TXPHINITDONE                (GT_TXPHINITDONE),
            .GT_RXCOMMADET                  (GT_RXCOMMADET),
            .GT_RXBUFSTATUS                 (GT_RXBUFSTATUS),
            //------------------------------------------------------------------
            //  GT Status Ports *
            //------------------------------------------------------------------                                                   
            .GT_CPLLLOCK                    (gt_cplllock),  
            .GT_RXCDRLOCK                   (gt_rxcdrlock)
        );
end // gt_wizard
  endgenerate
//--------------------------------------------------------------------------------------------------
//  Convert per-lane signals to per-design 
//--------------------------------------------------------------------------------------------------
  generate
if (DIS_GT_WIZARD == "TRUE") begin : sls_d1
assign qpll1lock_all   = &gtcom_qpll1lock;
assign txsyncallin_all = &gt_txphaligndone;                            
end // sls_d1
  endgenerate
//--------------------------------------------------------------------------------------------------
//  PHY Wrapper Outputs
//--------------------------------------------------------------------------------------------------
assign PHY_PCLK          = pclk;
assign PHY_PHYSTATUS     = gt_phystatus;
assign PHY_PHYSTATUS_RST = !rst_idle;

//--------------------------------------------------------------------------------------------------
//  TX Equalization (Gen3) Outputs 
//--------------------------------------------------------------------------------------------------
assign PHY_TXEQ_FS        = 6'd40;                                             
assign PHY_TXEQ_LF        = 6'd12;                                             
assign PHY_TXEQ_NEW_COEFF = txeq_new_coeff;        
assign PHY_TXEQ_DONE      = txeq_done;                                                   
      
//--------------------------------------------------------------------------------------------------
//  RX Equalization (Gen3) Outputs
//--------------------------------------------------------------------------------------------------      
assign PHY_RXEQ_LFFS_SEL    = rxeq_lffs_sel;                                                  
assign PHY_RXEQ_NEW_TXCOEFF = rxeq_new_txcoeff;     
assign PHY_RXEQ_ADAPT_DONE  = rxeq_adapt_done;   
assign PHY_RXEQ_DONE        = rxeq_done;   

//--------------------------------------------------------------------------------------------------
//  Debug Outputs
//--------------------------------------------------------------------------------------------------  
assign GT_TXELECIDLE = PHY_TXELECIDLE; 
assign GT_TXRESETDONE = gt_txresetdone;                    
assign GT_RXRESETDONE = gt_rxresetdone;              
assign GT_TXPHALIGNDONE = gt_txphaligndone;          
assign GT_PHYSTATUS = gt_phystatus;
assign GT_RXVALID  = PHY_RXVALID;
assign GT_RXSTATUS = PHY_RXSTATUS;
assign GT_BUFGTDIV = gt_bufgtdiv;

assign GT_RXCDRLOCK   = gt_rxcdrlock; 
assign GT_PCIERATEIDLE  = gt_pcierateidle;
assign GT_PCIEUSERRATESTART  = gt_pcieuserratestart;
assign GT_GTPOWERGOOD = gt_gtpowergood;                
assign GT_CPLLLOCK   = gt_cplllock;   
assign GT_QPLL1LOCK  = gtcom_qpll1lock;
assign GT_RXOUTCLK    = gt_rxoutclk;
assign GT_RXRECCLKOUT = gt_rxrecclkout;

assign TXEQ_CTRL = PHY_TXEQ_CTRL;
assign TXEQ_PRESET = PHY_TXEQ_PRESET;
assign PHY_RST_IDLE    = rst_idle;
assign PHY_RRST_N      = rrst_n;   
assign PHY_PRST_N      = prst_n;                 
assign GTW_DRPCLK = PHY_REFCLK;
//--------------------------------------------------------------------------------------------------  

endmodule

//--------------------------------------------------------------------------------------------------
//  Clock Module
//--------------------------------------------------------------------------------------------------
module rp_phy_clk 
(
    //--------------------------------------------------------------------------
    //  PCLK Ports
    //--------------------------------------------------------------------------
    input                               CLK_PCLK_CE,
    input                               CLK_PCLK_CEMASK,
    input                               CLK_PCLK_CLR,
    input                               CLK_PCLK_MASK,
    input       [ 2:0]                  CLK_PCLK_DIV,
    input                               CLK_PCLK_IN,   
    output                              CLK_PCLK,
    
    //--------------------------------------------------------------------------
    //  CORECLK Ports
    //--------------------------------------------------------------------------
    input                               CLK_CORECLK_CE,
    input                               CLK_CORECLK_CEMASK,
    input                               CLK_CORECLK_CLR,
    input                               CLK_CORECLK_MASK,
    input       [ 2:0]                  CLK_CORECLK_DIV,
    input                               CLK_CORECLK_IN,
    output                              CLK_CORECLK,      
    
    //--------------------------------------------------------------------------
    //  USERCLK Ports
    //--------------------------------------------------------------------------
    input                               CLK_USERCLK_CE,
    input                               CLK_USERCLK_CEMASK,
    input                               CLK_USERCLK_CLR,
    input                               CLK_USERCLK_MASK,
    input       [ 2:0]                  CLK_USERCLK_DIV,
    input                               CLK_USERCLK_IN,  
    output                              CLK_USERCLK     
);



//--------------------------------------------------------------------------------------------------
//  BUFG_GT for PCLK
//--------------------------------------------------------------------------------------------------
BUFG_GT bufg_gt_pclk 
(
     //-------------------------------------------------------------------------
     //  Input Ports
     //-------------------------------------------------------------------------
    .CE                                 (CLK_PCLK_CE),
    .CEMASK                             (CLK_PCLK_CEMASK),
    .CLR                                (CLK_PCLK_CLR),
    .CLRMASK                            (CLK_PCLK_MASK),
    .DIV                                (CLK_PCLK_DIV),
    .I                                  (CLK_PCLK_IN),
    
     //-------------------------------------------------------------------------
     //  Output Ports
     //-------------------------------------------------------------------------
    .O                                  (CLK_PCLK)
);



//--------------------------------------------------------------------------------------------------
//  BUFG_GT for USERCLK
//--------------------------------------------------------------------------------------------------
BUFG_GT bufg_gt_userclk 
(
     //-------------------------------------------------------------------------
     //  Input Ports
     //-------------------------------------------------------------------------
    .CE                                 (CLK_USERCLK_CE),
    .CEMASK                             (CLK_USERCLK_CEMASK),
    .CLR                                (CLK_USERCLK_CLR),
    .CLRMASK                            (CLK_USERCLK_MASK),
    .DIV                                (CLK_USERCLK_DIV),
    .I                                  (CLK_USERCLK_IN),
    
     //-------------------------------------------------------------------------
     //  Output Ports
     //-------------------------------------------------------------------------
    .O                                  (CLK_USERCLK)
);



//--------------------------------------------------------------------------------------------------
//  BUFG_GT for CORECLK
//--------------------------------------------------------------------------------------------------
BUFG_GT bufg_gt_coreclk 
(
     //-------------------------------------------------------------------------
     //  Input Ports
     //-------------------------------------------------------------------------
    .CE                                 (CLK_CORECLK_CE),
    .CEMASK                             (CLK_CORECLK_CEMASK),
    .CLR                                (CLK_CORECLK_CLR),
    .CLRMASK                            (CLK_CORECLK_MASK),
    .DIV                                (CLK_CORECLK_DIV),
    .I                                  (CLK_CORECLK_IN),

     //-------------------------------------------------------------------------
     //  Output Ports
     //-------------------------------------------------------------------------
    .O                                  (CLK_CORECLK)
);



endmodule

//--------------------------------------------------------------------------------------------------
//  PHY Reset Module
//--------------------------------------------------------------------------------------------------

module rp_phy_rst #
(
    parameter integer PHY_LANE      = 8,   
    parameter PL_UPSTREAM_FACING = "TRUE",
    parameter integer PHY_MAX_SPEED = 4,
    parameter integer SYNC_STAGE    = 3
)
(
    //-------------------------------------------------------------------------- 
    //  Input Ports
    //-------------------------------------------------------------------------- 
    input                               RST_REFCLK,
    input                               RST_PCLK,
    input                               RST_N,
    input       [PHY_LANE-1:0]          RST_GTPOWERGOOD,
    input       [PHY_LANE-1:0]          RST_CPLLLOCK,
    input       [(PHY_LANE-1)>>2:0]     RST_QPLL0LOCK,   
    input       [(PHY_LANE-1)>>2:0]     RST_QPLL1LOCK,
    input       [PHY_LANE-1:0]          RST_TXPROGDIVRESETDONE,
    input       [PHY_LANE-1:0]          RST_RXPROGDIVRESETDONE,
    input       [PHY_LANE-1:0]          RST_TXRESETDONE,    
    input       [PHY_LANE-1:0]          RST_RXRESETDONE, 
    input       [PHY_LANE-1:0]          RST_TXSYNC_DONE,   
    input       [PHY_LANE-1:0]          RST_PHYSTATUS,
    
    //-------------------------------------------------------------------------- 
    //  Output Ports
    //-------------------------------------------------------------------------- 
    output      [3:0]                   phy_rst_fsm,
    output                              RST_RRST_N,
    output                              RST_PRST_N,
    output                              RST_CPLLPD,
    output                              RST_CPLLRESET,
    output                              RST_QPLLPD,
    output                              RST_QPLLRESET,
    output                              RST_TXPROGDIVRESET,
    output                              RST_GTRESET,
    output                              RST_USERRDY,
    output                              RST_TXSYNC_START,
    output                              RST_IDLE
);

    //-------------------------------------------------------------------------- 
    //  Reset Synchronized Signals
    //-------------------------------------------------------------------------- 
    (* ASYNC_REG = "TRUE", SHIFT_EXTRACT = "NO" *) reg [ 3:0] rrst_n_r;
    (* ASYNC_REG = "TRUE", SHIFT_EXTRACT = "NO" *) reg [ 3:0] prst_n_r;

    wire                                rrst_n;                                     
    wire                                prst_n;  
       
    //--------------------------------------------------------------------------
    //  Synchronized Signals
    //--------------------------------------------------------------------------                                     
    wire        [PHY_LANE-1:0]          gtpowergood_r;                                                                 
    wire        [PHY_LANE-1:0]          cplllock_r;
    wire        [(PHY_LANE-1)>>2:0]     qpll0lock_r;
    wire        [(PHY_LANE-1)>>2:0]     qpll1lock_r;
    wire        [PHY_LANE-1:0]          txprogdivresetdone_r;
    wire        [PHY_LANE-1:0]          txresetdone_r;  
    wire        [PHY_LANE-1:0]          rxresetdone_r;
    wire        [PHY_LANE-1:0]          txsync_done_r;
    wire        [PHY_LANE-1:0]          phystatus_r;
    
    //--------------------------------------------------------------------------
    //  Internal Signals
    //--------------------------------------------------------------------------
    wire                                gtpowergood_a;
    wire                                cplllock_a;
    wire                                qplllock_a;
    wire                                txprogdivresetdone_a;
    wire                                resetdone_a;
    wire                                txsync_done_a;
    wire                                phystatus_a;
    reg         [ 1:0]                  txsync_start_cnt;
    
    //--------------------------------------------------------------------------
    //  Output Delayed Signals
    //--------------------------------------------------------------------------     
    reg         [ 3:0]                  cpllpd_r;
    reg         [ 3:0]                  cpllreset_r;                                  
    reg         [ 3:0]                  qpllpd_r;
    reg         [ 3:0]                  qpllreset_r;                                
    reg         [ 3:0]                  txprogdivreset_r;
    reg         [ 3:0]                  gtreset_r;
    reg         [ 3:0]                  userrdy_r;
                
    wire                                cpllpd_dly;
    wire                                cpllreset_dly;                                    
    wire                                qpllpd_dly;
    wire                                qpllreset_dly;                        
    wire                                txprogdivreset_dly;
    wire                                gtreset_dly;
    wire                                userrdy_dly;
     
    //-------------------------------------------------------------------------- 
    //  FSM Signals
    //-------------------------------------------------------------------------- 
    reg [ 2:0] fsm;
    
    reg                                 idle;     
    reg                                 cpllpd;
    reg                                 cpllreset;
    reg                                 qpllpd;
    reg                                 qpllreset;
    reg                                 txprogdivreset;
    reg                                 gtreset;
    reg                                 userrdy; 
    reg                                 txsync_start;         
   
    //--------------------------------------------------------------------------
    //  FSM Encoding
    //-------------------------------------------------------------------------- 
    localparam FSM_IDLE               = 3'd0;
    localparam FSM_GTPOWERGOOD        = 3'd1;
    localparam FSM_PLLLOCK            = 3'd2;
    localparam FSM_TXPROGDIVRESETDONE = 3'd3;
    localparam FSM_RESETDONE          = 3'd4;
    localparam FSM_TXSYNC_START       = 3'd5;
    localparam FSM_TXSYNC_DONE        = 3'd6;
    localparam FSM_PHYSTATUS          = 3'd7;



//--------------------------------------------------------------------------------------------------
//  Reset Synchronizer for REFCLK
//--------------------------------------------------------------------------------------------------
always @ (posedge RST_REFCLK or negedge RST_N)
begin

    if (!RST_N) 
        rrst_n_r <= 4'd0;
    else
        rrst_n_r <= {rrst_n_r[2:0], 1'd1}; 
          
end   
 
assign rrst_n = rrst_n_r[3];



//--------------------------------------------------------------------------------------------------
//  Reset Synchronizer for PCLK
//--------------------------------------------------------------------------------------------------
always @ (posedge RST_PCLK or negedge RST_N)
begin

    if (!RST_N) 
        prst_n_r <= 4'd0;
    else
        prst_n_r <= {prst_n_r[2:0], 1'd1};
          
end   

assign prst_n = prst_n_r[3];



//--------------------------------------------------------------------------------------------------
//  Input Synchronizer or Pipeline
//--------------------------------------------------------------------------------------------------
rp_phy_sync #(.WIDTH (PHY_LANE),            .STAGE (SYNC_STAGE)) sync_gtpowergood        (.CLK (RST_REFCLK), .D (RST_GTPOWERGOOD),        .Q (gtpowergood_r));
rp_phy_sync #(.WIDTH (PHY_LANE),            .STAGE (SYNC_STAGE)) sync_cplllock           (.CLK (RST_REFCLK), .D (RST_CPLLLOCK),           .Q (cplllock_r));
rp_phy_sync #(.WIDTH (((PHY_LANE-1)>>2)+1), .STAGE (SYNC_STAGE)) sync_qpll0lock          (.CLK (RST_REFCLK), .D (RST_QPLL0LOCK),          .Q (qpll0lock_r));
rp_phy_sync #(.WIDTH (((PHY_LANE-1)>>2)+1), .STAGE (SYNC_STAGE)) sync_qpll1lock          (.CLK (RST_REFCLK), .D (RST_QPLL1LOCK),          .Q (qpll1lock_r));
rp_phy_sync #(.WIDTH (PHY_LANE),            .STAGE (SYNC_STAGE)) sync_txprogdivresetdone (.CLK (RST_REFCLK), .D (RST_TXPROGDIVRESETDONE), .Q (txprogdivresetdone_r));
rp_phy_sync #(.WIDTH (PHY_LANE),            .STAGE (SYNC_STAGE)) sync_txresetdone        (.CLK (RST_REFCLK), .D (RST_TXRESETDONE),        .Q (txresetdone_r));  
rp_phy_sync #(.WIDTH (PHY_LANE),            .STAGE (SYNC_STAGE)) sync_rxresetdone        (.CLK (RST_REFCLK), .D (RST_RXRESETDONE),        .Q (rxresetdone_r));
rp_phy_sync #(.WIDTH (PHY_LANE),            .STAGE (SYNC_STAGE)) sync_txsync_done        (.CLK (RST_REFCLK), .D (RST_TXSYNC_DONE),        .Q (txsync_done_r)); 
rp_phy_sync #(.WIDTH (PHY_LANE),            .STAGE (SYNC_STAGE)) sync_phystatus          (.CLK (RST_REFCLK), .D (RST_PHYSTATUS),          .Q (phystatus_r));



//--------------------------------------------------------------------------------------------------
//  Convert per-lane signals to per-design 
//--------------------------------------------------------------------------------------------------
assign gtpowergood_a        = &gtpowergood_r;
assign cplllock_a           = (PHY_MAX_SPEED  < 3) ? (&cplllock_r)  : cplllock_r[0];
assign qplllock_a           = (PHY_MAX_SPEED == 4) ? (&qpll0lock_r) : (&qpll1lock_r);
assign txprogdivresetdone_a = &txprogdivresetdone_r;
assign resetdone_a          = (&txresetdone_r) && (&rxresetdone_r);
assign txsync_done_a        = &txsync_done_r;
assign phystatus_a          = |phystatus_r;                 



//--------------------------------------------------------------------------------------------------
//  TX Sync Alignment Start Counter
//--------------------------------------------------------------------------------------------------
always @ (posedge RST_REFCLK)
begin

    if (!rrst_n)
        txsync_start_cnt <= 2'd0;
    else
        if (fsm == FSM_TXSYNC_START)
            txsync_start_cnt <= txsync_start_cnt + 2'd1; 
        else
            txsync_start_cnt <= 2'd0;
            
end



//--------------------------------------------------------------------------------------------------
//  Reset FSM
//--------------------------------------------------------------------------------------------------
always @ (posedge RST_REFCLK)
begin

    if (!rrst_n)
        begin
        fsm            <= FSM_GTPOWERGOOD;
        idle           <= 1'd0;
        cpllpd         <= 1'd1;                               
        cpllreset      <= 1'd1;
        qpllpd         <= 1'd1;
        qpllreset      <= 1'd1;
        txprogdivreset <= 1'd1;
        gtreset        <= 1'd1;
        userrdy        <= 1'd0;
        txsync_start   <= 1'd0;
        end
    else
        begin
        
        case (fsm)
            
        //------------------------------------------------------------------------------------------
        //  Stay in IDLE state until system reset is released
        //------------------------------------------------------------------------------------------
        FSM_IDLE :
        
            begin
            if (!rrst_n)
                begin
                fsm            <= FSM_GTPOWERGOOD;
                idle           <= 1'd0;
                cpllpd         <= 1'd1;
                cpllreset      <= 1'd1;
                qpllpd         <= 1'd1;
                qpllreset      <= 1'd1;
                txprogdivreset <= 1'd1;
                gtreset        <= 1'd1;
                userrdy        <= 1'd0;
                txsync_start   <= 1'd0;
                end
            else
                begin
                fsm            <= FSM_IDLE;
                idle           <= 1'd1;
                cpllpd         <= cpllpd;
                cpllreset      <= cpllreset;
                qpllpd         <= qpllpd;
                qpllreset      <= qpllreset;
                txprogdivreset <= txprogdivreset;
                gtreset        <= gtreset;
                userrdy        <= userrdy;
                txsync_start   <= txsync_start;
                end
            end   
            
        //------------------------------------------------------------------------------------------
        //  Release [CPLL/QPLL]PD and wait for GTPOWERGOOD to assert HIGH
        //------------------------------------------------------------------------------------------
        FSM_GTPOWERGOOD :
        
            begin
            fsm            <= (gtpowergood_a && (!cplllock_a) && (!qplllock_a || PHY_MAX_SPEED < 3)) ? FSM_PLLLOCK : FSM_GTPOWERGOOD;
            idle           <= idle;
            cpllpd         <= cpllpd;
            cpllreset      <= cpllreset;
            qpllpd         <= (PHY_MAX_SPEED < 3) ? 1'd1 : 1'd0;
            qpllreset      <= qpllreset;
            txprogdivreset <= txprogdivreset;
            gtreset        <= gtreset;
            userrdy        <= userrdy;
            txsync_start   <= txsync_start;
            end    
            
        //------------------------------------------------------------------------------------------
        //  Release [CPLL/QPLL]RESET and wait for [CPLL/QPLL]LOCK to assert HIGH
        //------------------------------------------------------------------------------------------
        FSM_PLLLOCK :
        
            begin
            fsm          <= (PL_UPSTREAM_FACING == "TRUE") ? (cplllock_a && (!qplllock_a || PHY_MAX_SPEED < 3) ? FSM_TXPROGDIVRESETDONE : FSM_PLLLOCK) :
                                                             (cplllock_a && (qplllock_a || PHY_MAX_SPEED < 3) ? FSM_TXPROGDIVRESETDONE : FSM_PLLLOCK);
//            fsm            <= (cplllock_a && (qplllock_a || PHY_MAX_SPEED < 3)) ? FSM_TXPROGDIVRESETDONE : FSM_PLLLOCK;
            idle           <= idle;
            cpllpd         <= 1'd0;
            cpllreset      <= 1'd0;
            qpllpd         <= qpllpd;
            qpllreset      <= (PHY_MAX_SPEED < 3) ? 1'd1 : 1'd0;
            txprogdivreset <= txprogdivreset;
            gtreset        <= gtreset;
            userrdy        <= userrdy;
            txsync_start   <= txsync_start;
            end

        //------------------------------------------------------------------------------------------
        //  Release TXPROGDIVRESET and wait for TXPROGDIVRESETDONE to assert HIGH
        //------------------------------------------------------------------------------------------
        FSM_TXPROGDIVRESETDONE :
        
            begin
            fsm            <= txprogdivresetdone_a ? FSM_RESETDONE : FSM_TXPROGDIVRESETDONE;  
            idle           <= idle;
            cpllpd         <= cpllpd;
            cpllreset      <= cpllreset;
            qpllpd         <= qpllpd;
            qpllreset      <= qpllreset;
            txprogdivreset <= 1'd0;
            gtreset        <= gtreset;
            userrdy        <= userrdy;
            txsync_start   <= txsync_start;
            end
            
        //------------------------------------------------------------------------------------------
        //  Release GT[TX/RX]RESET, assert [TX/RX]USERRDY, and wait for [TX/RX]RESETDONE to assert HIGH
        //------------------------------------------------------------------------------------------
        FSM_RESETDONE :
        
            begin
            fsm            <= resetdone_a ? FSM_TXSYNC_START : FSM_RESETDONE;  
            idle           <= idle;
            cpllpd         <= cpllpd;
            cpllreset      <= cpllreset;
            qpllpd         <= qpllpd;
            qpllreset      <= qpllreset;
            txprogdivreset <= txprogdivreset;
            gtreset        <= 1'd0;
            userrdy        <= 1'd1;
            txsync_start   <= txsync_start;
            end
        
        //------------------------------------------------------------------------------------------
        //  Start TX sync alignment.  Extend TXSYNC_START pulse by few REFCLK cycles
        //------------------------------------------------------------------------------------------
        FSM_TXSYNC_START :
        
            begin
            fsm            <= (!txsync_done_a && (txsync_start_cnt == 2'd3)) ? FSM_TXSYNC_DONE : FSM_TXSYNC_START;
            idle           <= idle;
            cpllpd         <= cpllpd;
            cpllreset      <= cpllreset;
            qpllpd         <= qpllpd;   
            qpllreset      <= qpllreset;
            txprogdivreset <= txprogdivreset;
            gtreset        <= gtreset;
            userrdy        <= userrdy;
            txsync_start   <= 1'd1;
            end
            
        //------------------------------------------------------------------------------------------
        //  Wait for TX sync alignment done
        //------------------------------------------------------------------------------------------
        FSM_TXSYNC_DONE :
        
            begin
            fsm            <= txsync_done_a ? FSM_PHYSTATUS : FSM_TXSYNC_DONE;
            idle           <= idle;
            cpllpd         <= cpllpd;
            cpllreset      <= cpllreset;
            qpllpd         <= qpllpd;
            qpllreset      <= qpllreset;
            txprogdivreset <= txprogdivreset;
            gtreset        <= gtreset;
            userrdy        <= userrdy;
            txsync_start   <= 1'd0;
            end    
            
        //------------------------------------------------------------------------------------------
        //  Wait for PHYSTATUS to de-assert LOW
        //------------------------------------------------------------------------------------------
        FSM_PHYSTATUS :
        
            begin
            fsm            <= !phystatus_a ? FSM_IDLE : FSM_PHYSTATUS;  
            idle           <= 1'd1;
            cpllpd         <= cpllpd;
            cpllreset      <= cpllreset;
            qpllpd         <= qpllpd;
            qpllreset      <= qpllreset;
            txprogdivreset <= txprogdivreset;
            gtreset        <= gtreset;
            userrdy        <= userrdy;
            txsync_start   <= txsync_start;
            end 
            
        //------------------------------------------------------------------------------------------
        //  Default State
        //------------------------------------------------------------------------------------------
        default :
        
            begin
            fsm            <= FSM_IDLE;
            idle           <= 1'd0;
            cpllpd         <= 1'd1;
            cpllreset      <= 1'd1;
            qpllpd         <= 1'd1;
            qpllreset      <= 1'd1;
            txprogdivreset <= 1'd1;
            gtreset        <= 1'd1;
            userrdy        <= 1'd0;
            txsync_start   <= 1'd0;
            end

        endcase
        
        end
        
end



//--------------------------------------------------------------------------------------------------
//  Delay Outputs
//--------------------------------------------------------------------------------------------------
always @ (posedge RST_REFCLK)
begin

    cpllpd_r         <= {cpllpd_r[2:0],         cpllpd}; 
    cpllreset_r      <= {cpllreset_r[2:0],      cpllreset}; 
    qpllpd_r         <= {qpllpd_r[2:0],         qpllpd}; 
    qpllreset_r      <= {qpllreset_r[2:0],      qpllreset}; 
    txprogdivreset_r <= {txprogdivreset_r[2:0], txprogdivreset}; 
    gtreset_r        <= {gtreset_r[2:0],        gtreset};    
    userrdy_r        <= {userrdy_r[2:0],        userrdy}; 
            
end

assign cpllpd_dly         = cpllpd_r[3];
assign cpllreset_dly      = cpllreset_r[3];
assign qpllpd_dly         = qpllpd_r[3];
assign qpllreset_dly      = qpllreset_r[3];
assign txprogdivreset_dly = txprogdivreset_r[3];
assign gtreset_dly        = gtreset_r[3];
assign userrdy_dly        = userrdy_r[3];



//--------------------------------------------------------------------------------------------------
//  PHY Reset Outputs
//--------------------------------------------------------------------------------------------------
assign RST_RRST_N         = rrst_n;
assign RST_PRST_N         = prst_n;

assign RST_CPLLPD         = cpllreset_dly;
assign RST_CPLLRESET      = cpllreset_dly; 
assign RST_QPLLPD         = qpllpd_dly;
assign RST_QPLLRESET      = qpllreset_dly;
assign RST_TXPROGDIVRESET = txprogdivreset_dly;
assign RST_GTRESET        = gtreset_dly;  
assign RST_USERRDY        = userrdy_dly;
assign RST_TXSYNC_START   = txsync_start;
assign RST_IDLE           = idle;
assign phy_rst_fsm      = {1'b0,fsm};
endmodule


//--------------------------------------------------------------------------------------------------
//  TX Equalization Module
//--------------------------------------------------------------------------------------------------
module rp_phy_txeq #
(
    parameter integer PHY_GT_TXPRESET = 0
)
(
    //-------------------------------------------------------------------------- 
    //  Input Ports
    //-------------------------------------------------------------------------- 
    input                               TXEQ_CLK,                            
    input                               TXEQ_RST_N,

    input       [ 1:0]                  TXEQ_CTRL,    
    input       [ 3:0]                  TXEQ_PRESET,
    input       [ 5:0]                  TXEQ_COEFF,
    
    //-------------------------------------------------------------------------- 
    //  Output Ports
    //-------------------------------------------------------------------------- 
    output      [2:0]                   phy_txeq_fsm,
    output  reg [ 4:0]                  TXEQ_PRECURSOR, 
    output  reg [ 6:0]                  TXEQ_MAINCURSOR,
    output  reg [ 4:0]                  TXEQ_POSTCURSOR,
    output  reg [17:0]                  TXEQ_NEW_COEFF,
    output  reg                         TXEQ_DONE
);          
    //--------------------------------------------------------------------------
    //  Synchronized Signals
    //-------------------------------------------------------------------------- 
    wire        [ 1:0]                  ctrl_r; 
    wire        [ 3:0]                  preset_r;
    wire        [ 5:0]                  coeff_r;
  
    //--------------------------------------------------------------------------
    //  Internal Signals
    //--------------------------------------------------------------------------
    reg         [18:0]                  preset;          
    reg                                 preset_done;
    
    //--------------------------------------------------------------------------
    //  FSM Signals                                                            
    //--------------------------------------------------------------------------    
    reg         [ 2:0]                  fsm;
    reg         [18:0]                  coeff;
    reg         [ 1:0]                  coeff_cnt;
    reg                                 done;
   
    //----------------------------------------------------------------------------------------------                   
    //  FSM Encoding                                                                               
    //----------------------------------------------------------------------------------------------                   
    localparam FSM_IDLE   = 3'd0; 
    localparam FSM_PRESET = 3'd1;                                     
    localparam FSM_COEFF  = 3'd2;
    localparam FSM_REMAP  = 3'd3;
    localparam FSM_QUERY  = 3'd4;                                     
    localparam FSM_DONE   = 3'd5;

    //----------------------------------------------------------------------------------------------
    //  TX Equalization Preset 
    //----------------------------------------------------------------------------------------------
    //  Advertise FS = 40
    //  Advertise LF = 12
    //  Actual    FS = 80
    //  Actual    LF = 24
    //----------------------------------------------------------------------------------------------
    //  Coefficient Rules:
    //  * C(-1) < Floor(FS/4)
    //  * C(-1) + C(0) + C(+1) = FS
    //  * C(0) - C(-1) - C(+1) >= LF
    //----------------------------------------------------------------------------------------------
    //  TXPRECURSOR  or C(-1) should be 20 or less
    //  TXMAINCURSOR or C( 0) should be 52 or more (automatically calcuated in GT)
    //  TXPOSTCURSOR or C(+1) should be 28 or less
    //----------------------------------------------------------------------------------------------                           
    localparam TXPRECURSOR_00  = 6'd0;   // 0.0 dB
    localparam TXMAINCURSOR_00 = 7'd60;                     
    localparam TXPOSTCURSOR_00 = 6'd20;  // 6.0 dB
                                         
    localparam TXPRECURSOR_01  = 6'd0;   // 0.0 dB
    localparam TXMAINCURSOR_01 = 7'd66;                               
    localparam TXPOSTCURSOR_01 = 6'd14;  // 3.5 dB
                                         
    localparam TXPRECURSOR_02  = 6'd0;   // 0.0 dB
    localparam TXMAINCURSOR_02 = 7'd64;                     
    localparam TXPOSTCURSOR_02 = 6'd16;  // 4.5 dB
                                         
    localparam TXPRECURSOR_03  = 6'd0;   // 0.0 dB
    localparam TXMAINCURSOR_03 = 7'd70;                     
    localparam TXPOSTCURSOR_03 = 6'd10;  // 2.5 dB
                                         
    localparam TXPRECURSOR_04  = 6'd0;   // 0.0 dB
    localparam TXMAINCURSOR_04 = 7'd80;                     
    localparam TXPOSTCURSOR_04 = 6'd0;   // 0.0 dB
                                         
    localparam TXPRECURSOR_05  = 6'd8;   // 2.0 dB
    localparam TXMAINCURSOR_05 = 7'd72;                     
    localparam TXPOSTCURSOR_05 = 6'd0;   // 0.0 dB
                                         
    localparam TXPRECURSOR_06  = 6'd10;  // 2.5 dB
    localparam TXMAINCURSOR_06 = 7'd70;                     
    localparam TXPOSTCURSOR_06 = 6'd0;   // 0.0 dB
                                         
    localparam TXPRECURSOR_07  = 6'd8;   // 3.5 dB
    localparam TXMAINCURSOR_07 = 7'd56;                     
    localparam TXPOSTCURSOR_07 = 6'd16;  // 6.0 dB
                                         
    localparam TXPRECURSOR_08  = 6'd10;  // 3.5 dB
    localparam TXMAINCURSOR_08 = 7'd60;                     
    localparam TXPOSTCURSOR_08 = 6'd10;  // 3.5 dB
                                         
    localparam TXPRECURSOR_09  = 6'd12;  // 3.5 dB
    localparam TXMAINCURSOR_09 = 7'd68;                    
    localparam TXPOSTCURSOR_09 = 6'd0;   // 0.0 dB
                                         
    localparam TXPRECURSOR_10  = 6'd0;   // 0.0 dB
    localparam TXMAINCURSOR_10 = 7'd54;                      
    localparam TXPOSTCURSOR_10 = 6'd26;  // 9.5 dB
    
    
    
//--------------------------------------------------------------------------------------------------
//  Input Synchronizer
//--------------------------------------------------------------------------------------------------
rp_phy_sync #(.WIDTH (2), .STAGE (2)) sync_ctrl   (.CLK (TXEQ_CLK), .D (TXEQ_CTRL),   .Q (ctrl_r));
rp_phy_sync #(.WIDTH (4), .STAGE (2)) sync_preset (.CLK (TXEQ_CLK), .D (TXEQ_PRESET), .Q (preset_r));
rp_phy_sync #(.WIDTH (6), .STAGE (2)) sync_coeff  (.CLK (TXEQ_CLK), .D (TXEQ_COEFF),  .Q (coeff_r));



//--------------------------------------------------------------------------------------------------
//  TX Equalization Preset
//--------------------------------------------------------------------------------------------------
always @ (posedge TXEQ_CLK)
begin

    if (!TXEQ_RST_N)
        begin
        
        //------------------------------------------------------------------
        //  Default TX Equalization Preset                                 
        //------------------------------------------------------------------
        case (PHY_GT_TXPRESET)
            4'd0    : preset <= {TXPOSTCURSOR_00, TXMAINCURSOR_00, TXPRECURSOR_00};
            4'd1    : preset <= {TXPOSTCURSOR_01, TXMAINCURSOR_01, TXPRECURSOR_01};
            4'd2    : preset <= {TXPOSTCURSOR_02, TXMAINCURSOR_02, TXPRECURSOR_02};
            4'd3    : preset <= {TXPOSTCURSOR_03, TXMAINCURSOR_03, TXPRECURSOR_03};
            4'd4    : preset <= {TXPOSTCURSOR_04, TXMAINCURSOR_04, TXPRECURSOR_04};
            4'd5    : preset <= {TXPOSTCURSOR_05, TXMAINCURSOR_05, TXPRECURSOR_05};
            4'd6    : preset <= {TXPOSTCURSOR_06, TXMAINCURSOR_06, TXPRECURSOR_06};
            4'd7    : preset <= {TXPOSTCURSOR_07, TXMAINCURSOR_07, TXPRECURSOR_07};
            4'd8    : preset <= {TXPOSTCURSOR_08, TXMAINCURSOR_08, TXPRECURSOR_08};      
            4'd9    : preset <= {TXPOSTCURSOR_09, TXMAINCURSOR_09, TXPRECURSOR_09};   
            4'd10   : preset <= {TXPOSTCURSOR_10, TXMAINCURSOR_10, TXPRECURSOR_10};                 
            default : preset <= {TXPOSTCURSOR_00, TXMAINCURSOR_00, TXPRECURSOR_00};   
        endcase	       
        
        preset_done <= 1'd0;
        end                    
    else
        begin   
        if (fsm == FSM_PRESET)
            begin    
                
            //------------------------------------------------------------------
            //  Update TX Equalization Preset
            //------------------------------------------------------------------
            case (preset_r)
                4'd0    : preset <= {TXPOSTCURSOR_00, TXMAINCURSOR_00, TXPRECURSOR_00};
                4'd1    : preset <= {TXPOSTCURSOR_01, TXMAINCURSOR_01, TXPRECURSOR_01};
                4'd2    : preset <= {TXPOSTCURSOR_02, TXMAINCURSOR_02, TXPRECURSOR_02};
                4'd3    : preset <= {TXPOSTCURSOR_03, TXMAINCURSOR_03, TXPRECURSOR_03};
                4'd4    : preset <= {TXPOSTCURSOR_04, TXMAINCURSOR_04, TXPRECURSOR_04};
                4'd5    : preset <= {TXPOSTCURSOR_05, TXMAINCURSOR_05, TXPRECURSOR_05};
                4'd6    : preset <= {TXPOSTCURSOR_06, TXMAINCURSOR_06, TXPRECURSOR_06};
                4'd7    : preset <= {TXPOSTCURSOR_07, TXMAINCURSOR_07, TXPRECURSOR_07};
                4'd8    : preset <= {TXPOSTCURSOR_08, TXMAINCURSOR_08, TXPRECURSOR_08};      
                4'd9    : preset <= {TXPOSTCURSOR_09, TXMAINCURSOR_09, TXPRECURSOR_09}; 
                4'd10   : preset <= {TXPOSTCURSOR_10, TXMAINCURSOR_10, TXPRECURSOR_10};                   
                default : preset <= {TXPOSTCURSOR_00, TXMAINCURSOR_00, TXPRECURSOR_00};    
            endcase
              
            preset_done <= 1'd1;
            end
        else
            begin
            preset      <= preset;
            preset_done <= 1'd0;
            end
        end
        
end     



//--------------------------------------------------------------------------------------------------
//  TX Equalization FSM
//--------------------------------------------------------------------------------------------------
always @ (posedge TXEQ_CLK)
begin

    if (!TXEQ_RST_N)
        begin
        fsm       <= FSM_IDLE; 
        coeff     <= preset;
        coeff_cnt <= 2'd0;
        done      <= 1'd0;
        end                    
    else
        begin
        
        case (fsm)
        
        //------------------------------------------------------------------------------------------
        //  Wait until TXEQ_CTRL != 2'b00
        //------------------------------------------------------------------------------------------
        FSM_IDLE :
        
            begin
            done <= 1'd0;
            
            case (ctrl_r)
            
            //------------------------------------------------------------------
            //  Idle
            //------------------------------------------------------------------
            2'd0 :
            
                begin
                fsm       <= FSM_IDLE; 
                coeff     <= coeff;
                coeff_cnt <= 2'd0;
                end 
                
            //------------------------------------------------------------------
            //  Preset
            //------------------------------------------------------------------
            2'd1 :
            
                begin
                fsm       <= FSM_PRESET; 
                coeff     <= coeff;
                coeff_cnt <= 2'd0;
                end  
                
            //------------------------------------------------------------------
            //  Coeff : Latch C(-1) 
            //------------------------------------------------------------------
            2'd2 :
            
                begin
                fsm       <= FSM_COEFF; 
                coeff     <= {coeff_r, coeff[18:6]};
                coeff_cnt <= 2'd1;
                end
                
            //------------------------------------------------------------------
            //  Query
            //------------------------------------------------------------------
            2'd3 :
            
                begin
                fsm       <= FSM_QUERY; 
                coeff     <= coeff;
                coeff_cnt <= 2'd0;
                end
                
            //------------------------------------------------------------------
            //  Stay in IDLE state (Default)
            //------------------------------------------------------------------
            default :
            
                begin
                fsm       <= FSM_IDLE; 
                coeff     <= coeff;
                coeff_cnt <= 2'd0;
                end
                
            endcase
            
            end
            
        //------------------------------------------------------------------------------------------
        //  Wait for TXEQ preset done
        //------------------------------------------------------------------------------------------
        FSM_PRESET :
        
            begin
            fsm       <= preset_done ? FSM_DONE : FSM_PRESET;
            coeff     <= preset;
            coeff_cnt <= 2'd0;
            done      <= 1'd0;
            end    
            
        //------------------------------------------------------------------------------------------
        //  Latch C(0) and C(+1)
        //------------------------------------------------------------------------------------------
        FSM_COEFF :
        
            begin
            fsm <= (coeff_cnt == 2'd2) ? FSM_REMAP : FSM_COEFF;
            
            //------------------------------------------------------------------
            //  Shift in one extra bit for TXMAINCURSOR
            //------------------------------------------------------------------
            if (coeff_cnt == 2'd1)
                coeff <= {1'd0, coeff_r, coeff[18:7]};
            else
                coeff <= {coeff_r, coeff[18:6]};
                
            coeff_cnt <= coeff_cnt + 2'd1;
            done      <= 1'd0; 
            end
            
        //------------------------------------------------------------------------------------------
        //  Multiply coefficient by 2x
        //------------------------------------------------------------------------------------------
        FSM_REMAP :
        
            begin
            fsm       <= FSM_DONE;
            coeff     <= coeff << 1;        
            coeff_cnt <= 2'd0;
            done      <= 1'd0; 
            end
            
        //------------------------------------------------------------------------------------------
        //  Query to display current TXEQ_NEW_COEFF
        //------------------------------------------------------------------------------------------
        FSM_QUERY:
        
            begin
            fsm       <= FSM_DONE;
            coeff     <= coeff; 
            coeff_cnt <= 2'd0;
            done      <= 1'd0;
            end     
                  
        //------------------------------------------------------------------------------------------
        //  Assert TXEQ_DONE until TXEQ_CTRL == 2'd0
        //------------------------------------------------------------------------------------------
        FSM_DONE :
        
            begin
            fsm       <= (ctrl_r == 2'd0) ? FSM_IDLE : FSM_DONE;
            coeff     <= coeff;          
            coeff_cnt <= 2'd0;
            done      <= 1'd1;
            end        
                          
        //------------------------------------------------------------------------------------------
        //  Default State
        //------------------------------------------------------------------------------------------
        default : 
        
            begin
            fsm       <= FSM_IDLE;
            coeff     <= 19'd0; 
            coeff_cnt <=  2'd0;
            done      <=  1'd0;
            end    
                    
        endcase
        
        end
        
end  



//-------------------------------------------------------------------------------------------------- 
//  TX Equalization Output Register                                                                               
//-------------------------------------------------------------------------------------------------- 
always @ (posedge TXEQ_CLK)
begin

    if (!TXEQ_RST_N)
        begin
        TXEQ_PRECURSOR        <= coeff[ 4: 0];  
        TXEQ_MAINCURSOR       <= coeff[12: 6]; 
        TXEQ_POSTCURSOR       <= coeff[17:13];
        TXEQ_NEW_COEFF[17:12] <= {1'd0, coeff[18:14]};
        TXEQ_NEW_COEFF[11: 6] <= coeff[12:7]; 
        TXEQ_NEW_COEFF[ 5: 0] <= {1'd0, coeff[5:1]}; 
        TXEQ_DONE             <= 1'd0;
        end
    else           
        begin
        TXEQ_DONE <= done;
        
        //----------------------------------------------------------------------
        //  Divide TXEQ_NEW_COEFF by 2x and update output
        //----------------------------------------------------------------------
        if (fsm == FSM_DONE)
            begin
            TXEQ_PRECURSOR        <= coeff[ 4: 0]; 
            TXEQ_MAINCURSOR       <= coeff[12: 6]; 
            TXEQ_POSTCURSOR       <= coeff[17:13];
            TXEQ_NEW_COEFF[17:12] <= {1'd0, coeff[18:14]};
            TXEQ_NEW_COEFF[11: 6] <= coeff[12:7]; 
            TXEQ_NEW_COEFF[ 5: 0] <= {1'd0, coeff[5:1]}; 
            end
            
        //----------------------------------------------------------------------
        //  Hold output
        //----------------------------------------------------------------------    
        else
            begin
            TXEQ_PRECURSOR        <= TXEQ_PRECURSOR;  
            TXEQ_MAINCURSOR       <= TXEQ_MAINCURSOR; 
            TXEQ_POSTCURSOR       <= TXEQ_POSTCURSOR; 
            TXEQ_NEW_COEFF[17:12] <= TXEQ_NEW_COEFF[17:12];
            TXEQ_NEW_COEFF[11: 6] <= TXEQ_NEW_COEFF[11: 6];
            TXEQ_NEW_COEFF[ 5: 0] <= TXEQ_NEW_COEFF[ 5: 0];
            end
            
        end    
        
end

assign phy_txeq_fsm      = fsm;

endmodule

//--------------------------------------------------------------------------------------------------
//  RX Equalization Module
//--------------------------------------------------------------------------------------------------
module rp_phy_rxeq #
(
    parameter         PHY_SIM_EN      = "FALSE",   
    parameter integer PHY_LP_TXPRESET = 4                        
)
(
    //-------------------------------------------------------------------------- 
    //  Input Ports
    //-------------------------------------------------------------------------- 
    input                               RXEQ_CLK,                            
    input                               RXEQ_RST_N,
    
    input       [ 1:0]                  RXEQ_CTRL,    
    input       [ 2:0]                  RXEQ_PRESET,
    input       [ 3:0]                  RXEQ_TXPRESET,
    input       [ 5:0]                  RXEQ_TXCOEFF,
    input       [ 5:0]                  RXEQ_LFFS,
    
    //-------------------------------------------------------------------------- 
    //  Output Ports
    //-------------------------------------------------------------------------- 
    output      [2:0]                   phy_rxeq_fsm,
    output                              RXEQ_LFFS_SEL, 
    output      [17:0]                  RXEQ_NEW_TXCOEFF,
    output                              RXEQ_ADAPT_DONE,
    output                              RXEQ_DONE 
);          
    //--------------------------------------------------------------------------
    //  Synchronized Signals
    //--------------------------------------------------------------------------   
    wire        [ 1:0]                  ctrl_r;
    wire        [ 2:0]                  preset_r;
    wire        [ 3:0]                  txpreset_r;
    wire        [ 5:0]                  txcoeff_r;
    wire        [ 5:0]                  lffs_r;

    //--------------------------------------------------------------------------
    //  Internal Signals
    //--------------------------------------------------------------------------
    reg         [ 21:0]                 adapt_cnt;

    //--------------------------------------------------------------------------
    //  FSM Signals                                                            
    //--------------------------------------------------------------------------    
    reg         [ 2:0]                  fsm;
    reg         [ 3:0]                  txpreset;
    reg         [17:0]                  txcoeff;
    reg         [ 1:0]                  txcoeff_cnt;
    reg                                 lffs_sel;
    reg                                 adapt_2nd;
    reg                                 adapt_done;
    reg                                 done;
   
    //----------------------------------------------------------------------------------------------  
    //  FSM Encoding                                                                                  
    //----------------------------------------------------------------------------------------------                                            
    localparam FSM_IDLE    = 3'd0; 
    localparam FSM_PRESET  = 3'd1;                                     
    localparam FSM_TXCOEFF = 3'd2;
    localparam FSM_ADAPT   = 3'd3;
    localparam FSM_DONE    = 3'd4;                                  

    //--------------------------------------------------------------------------
    //  New TX Coefficient
    //--------------------------------------------------------------------------
    localparam NEW_TXCOEFF = (PHY_LP_TXPRESET == 10) ? 18'd10 :
                             (PHY_LP_TXPRESET ==  9) ? 18'd9  :
                             (PHY_LP_TXPRESET ==  8) ? 18'd8  :
                             (PHY_LP_TXPRESET ==  7) ? 18'd7  :
                             (PHY_LP_TXPRESET ==  6) ? 18'd6  :                                                                     
                             (PHY_LP_TXPRESET ==  5) ? 18'd5  :
                             (PHY_LP_TXPRESET ==  4) ? 18'd4  :
                             (PHY_LP_TXPRESET ==  3) ? 18'd3  :
                             (PHY_LP_TXPRESET ==  2) ? 18'd2  :           
                             (PHY_LP_TXPRESET ==  1) ? 18'd1  :
                             (PHY_LP_TXPRESET ==  0) ? 18'd0  : 18'd0;   

    //--------------------------------------------------------------------------
    //  Counters (Simulation vs. Silicon)
    //--------------------------------------------------------------------------
    localparam ADAPT_MAX = (PHY_SIM_EN == "TRUE") ? 22'd1000 : 22'd2000000;
  
    
    
//--------------------------------------------------------------------------------------------------
//  Input Synchronizer
//--------------------------------------------------------------------------------------------------
rp_phy_sync #(.WIDTH (2), .STAGE (2)) sync_ctrl     (.CLK (RXEQ_CLK), .D (RXEQ_CTRL),     .Q (ctrl_r));
rp_phy_sync #(.WIDTH (3), .STAGE (2)) sync_preset   (.CLK (RXEQ_CLK), .D (RXEQ_PRESET),   .Q (preset_r));
rp_phy_sync #(.WIDTH (4), .STAGE (2)) sync_txpreset (.CLK (RXEQ_CLK), .D (RXEQ_TXPRESET), .Q (txpreset_r));    
rp_phy_sync #(.WIDTH (6), .STAGE (2)) sync_txcoeff  (.CLK (RXEQ_CLK), .D (RXEQ_TXCOEFF),  .Q (txcoeff_r));
rp_phy_sync #(.WIDTH (6), .STAGE (2)) sync_lffs     (.CLK (RXEQ_CLK), .D (RXEQ_LFFS),     .Q (lffs_r));            



//--------------------------------------------------------------------------------------------------
//  Adaptation Counter
//--------------------------------------------------------------------------------------------------
always @ (posedge RXEQ_CLK)
begin

    if (!RXEQ_RST_N)
        begin
        adapt_cnt <= 22'd0;
        end
    else
        begin
        
        //----------------------------------------------------------------------
        //  Increment Counter
        //----------------------------------------------------------------------
        if (fsm == FSM_ADAPT)
            begin
            adapt_cnt <= adapt_cnt + 22'd1;
            end
            
        //----------------------------------------------------------------------
        //  Reset Counter
        //----------------------------------------------------------------------
        else
            begin
            adapt_cnt <= 22'd0;
            end

        end
        
end



//-------------------------------------------------------------------------------------------------- 
//  RX Equalization FSM                                                                              
//-------------------------------------------------------------------------------------------------- 
always @ (posedge RXEQ_CLK)
begin

    if (!RXEQ_RST_N)
        begin
        fsm         <= FSM_IDLE; 
        txpreset    <=  4'd0;
        txcoeff     <= 18'd0;
        txcoeff_cnt <=  2'd0;
        lffs_sel    <=  1'd0;
        adapt_2nd   <=  1'd1;
        adapt_done  <=  1'd0;
        done        <=  1'd0;
        end                    
    else
        begin
        
        case (fsm)
        
        //------------------------------------------------------------------------------------------
        //  Wait until RXEQ_CTRL != 2'b00
        //------------------------------------------------------------------------------------------
        FSM_IDLE :
        
            begin
            
            case (ctrl_r)
                
            //------------------------------------------------------------------
            //  Idle
            //------------------------------------------------------------------
            2'd0 :
            
                begin
                fsm         <= FSM_IDLE; 
                txpreset    <=  4'd0;
                txcoeff     <= 18'd0;
                txcoeff_cnt <=  2'd0;
                lffs_sel    <=  1'd0;
                adapt_2nd   <= adapt_2nd;
                adapt_done  <=  1'd0;
                done        <=  1'd0;
                end      
                
            //------------------------------------------------------------------
            //  Preset
            //------------------------------------------------------------------
            2'd1 :
            
                begin
                fsm         <= FSM_PRESET; 
                txpreset    <=  4'd0;
                txcoeff     <= 18'd0;
                txcoeff_cnt <=  2'd0;
                lffs_sel    <=  1'd0;
                adapt_2nd   <= adapt_2nd;
                adapt_done  <=  1'd0;
                done        <=  1'd0;
                end  
                
            //------------------------------------------------------------------
            //  Coeff : Latch C(-1) and TXPRESET
            //------------------------------------------------------------------
            2'd2 :
            
                begin
                fsm         <= FSM_TXCOEFF; 
                txpreset    <= txpreset_r;
                txcoeff     <= {txcoeff_r, txcoeff[17:6]};
                txcoeff_cnt <= 2'd1;
                lffs_sel    <= 1'd1;
                adapt_2nd   <= !adapt_2nd;
                adapt_done  <= 1'd0;
                done        <= 1'd0;
                end
                
            //------------------------------------------------------------------
            //  Bypass : Latch C(-1) and TXPRESET
            //------------------------------------------------------------------
            2'd3 :
            
                begin
                fsm         <= FSM_TXCOEFF; 
                txpreset    <= txpreset_r;
                txcoeff     <= {txcoeff_r, txcoeff[17:6]};
                txcoeff_cnt <= 2'd1;
                lffs_sel    <= 1'd1;
                adapt_2nd   <= 1'd1;
                adapt_done  <= 1'd0;
                done        <= 1'd0;
                end
                
            //------------------------------------------------------------------
            //  Default
            //------------------------------------------------------------------
            default :
            
                begin
                fsm         <= FSM_IDLE; 
                txpreset    <=  4'd0;
                txcoeff     <= 18'd0;
                txcoeff_cnt <=  2'd0;
                lffs_sel    <=  1'd0;
                adapt_2nd   <= adapt_2nd;
                adapt_done  <=  1'd0;
                done        <=  1'd0;
                end
                
            endcase
            
            end
            
        //------------------------------------------------------------------------------------------
        //  Go to DONE state (RXEQ preset not supported)
        //------------------------------------------------------------------------------------------
        FSM_PRESET :
        
            begin
            fsm         <= FSM_DONE;
            txpreset    <=  4'd0;
            txcoeff     <= 18'd0; 
            txcoeff_cnt <=  2'd0;
            lffs_sel    <=  1'd0;
            adapt_2nd   <= adapt_2nd;
            adapt_done  <=  1'd0;
            done        <=  1'd0; 
            end        
            
        //------------------------------------------------------------------------------------------
        //  Latch C(0) and C(+1)
        //------------------------------------------------------------------------------------------
        FSM_TXCOEFF :
        
            begin
            fsm         <= (txcoeff_cnt == 2'd2) ? FSM_ADAPT : FSM_TXCOEFF;
            txpreset    <= txpreset;
            txcoeff     <= {txcoeff_r, txcoeff[17:6]};
            txcoeff_cnt <= txcoeff_cnt + 2'd1;
            lffs_sel    <= 1'd0;
            adapt_2nd   <= adapt_2nd;
            adapt_done  <= 1'd0;
            done        <= 1'd0; 
            end
   
        //------------------------------------------------------------------------------------------
        //  Wait for adaptation timer 
        //------------------------------------------------------------------------------------------
        FSM_ADAPT :
        
            begin            
            fsm         <= (adapt_cnt == ADAPT_MAX) || (!adapt_2nd) ? FSM_DONE : FSM_ADAPT;
            txpreset    <= txpreset;
            txcoeff     <= txcoeff;
            txcoeff_cnt <= 2'd0;
            lffs_sel    <= 1'd0;
            adapt_done  <= 1'd0;
            adapt_2nd   <= adapt_2nd;
            done        <= 1'd0;
            end             
             
        //------------------------------------------------------------------------------------------
        //  Assert RXEQ_DONE until RXEQ_CTRL == 2'd0
        //------------------------------------------------------------------------------------------
        FSM_DONE :
        
            begin
            fsm         <= (ctrl_r == 2'd0) ? FSM_IDLE : FSM_DONE;
            txpreset    <= txpreset;
            txcoeff     <= txcoeff;
            txcoeff_cnt <= 2'd0;
            lffs_sel    <= ((ctrl_r == 2'd2) || (ctrl_r == 2'd3));
            adapt_done  <= ((ctrl_r == 2'd2) || (ctrl_r == 2'd3)) ? adapt_2nd : 1'd0;
            adapt_2nd   <= adapt_2nd;  
            done        <= !(ctrl_r == 2'd0);
            end        
                          
        //------------------------------------------------------------------------------------------
        //  Default State
        //------------------------------------------------------------------------------------------
        default : 
        
            begin
            fsm         <= FSM_IDLE;
            txpreset    <=  4'd0;
            txcoeff     <= 18'd0;
            txcoeff_cnt <=  2'd0;
            lffs_sel    <=  1'd0;
            adapt_done  <=  1'd0; 
            adapt_2nd   <=  1'd0; 
            done        <=  1'd0; 
            end    
                    
        endcase
        
        end
        
end      



//-------------------------------------------------------------------------------------------------- 
//  RX Equalization Output                                                                           
//-------------------------------------------------------------------------------------------------- 
assign RXEQ_NEW_TXCOEFF = NEW_TXCOEFF;
assign RXEQ_LFFS_SEL    = lffs_sel;
assign RXEQ_ADAPT_DONE  = adapt_done;
assign RXEQ_DONE        = done;
assign phy_rxeq_fsm      = fsm;



endmodule

module rp_phy_reset_sync (

  input  wire clk_in,
  input  wire rst_in,
  output wire rst_out

);

  // Use 5 flip-flops as a single synchronizer, and tag each declaration with the appropriate synthesis attribute to
  // enable clustering. Each flip-flop in the synchronizer is asynchronously reset so that the downstream logic is also
  // asynchronously reset but encounters no reset assertion latency. The removal of reset is synchronous, so that the
  // downstream logic is also removed from reset synchronously. This module is designed for active-high reset use.

  (* ASYNC_REG = "TRUE" *) reg rst_in_meta  = 1'b0;
  (* ASYNC_REG = "TRUE" *) reg rst_in_sync1 = 1'b0;
  (* ASYNC_REG = "TRUE" *) reg rst_in_sync2 = 1'b0;
  (* ASYNC_REG = "TRUE" *) reg rst_in_sync3 = 1'b0;
                           reg rst_in_out   = 1'b0;

  always @(posedge clk_in, posedge rst_in) begin
    if (rst_in) begin
      rst_in_meta  <= 1'b1;
      rst_in_sync1 <= 1'b1;
      rst_in_sync2 <= 1'b1;
      rst_in_sync3 <= 1'b1;
      rst_in_out   <= 1'b1;
    end
    else begin
      rst_in_meta  <= 1'b0;
      rst_in_sync1 <= rst_in_meta;
      rst_in_sync2 <= rst_in_sync1;
      rst_in_sync3 <= rst_in_sync2;
      rst_in_out   <= rst_in_sync3;
    end
  end

  assign rst_out = rst_in_out;


endmodule

module rp_phy_multi_pipe_sync # (

  parameter INITIALIZE = 5'b00000

)(

  input  wire clk_in,
  input  wire i_in,
  output wire o_out

);

  // Use 5 flip-flops as a single synchronizer, and tag each declaration with the appropriate synthesis attribute to
  // enable clustering. Their GSR default values are provided by the INITIALIZE parameter.

  (* ASYNC_REG = "TRUE" *) reg i_in_meta  = INITIALIZE[0];
  (* ASYNC_REG = "TRUE" *) reg i_in_sync1 = INITIALIZE[1];
  (* ASYNC_REG = "TRUE" *) reg i_in_sync2 = INITIALIZE[2];
  (* ASYNC_REG = "TRUE" *) reg i_in_sync3 = INITIALIZE[3];
                           reg i_in_out   = INITIALIZE[4];

  always @(posedge clk_in) begin
    i_in_meta  <= i_in;
    i_in_sync1 <= i_in_meta;
    i_in_sync2 <= i_in_sync1;
    i_in_sync3 <= i_in_sync2;
    i_in_out   <= i_in_sync3;
  end

  assign o_out = i_in_out;


endmodule

module rp_phy_freq_cntr (
  output reg  [15:0] freq_cnt_o = 16'd0,
  output reg  done_o,
  input  wire rst_i,
  input  wire [15:0] test_term_cnt_i,
  input  wire ref_clk_i,
  input  wire test_clk_i
);
  //****************************************************************************
  //  Local Parameters
  //****************************************************************************
  localparam RESET_STATE = 0;
  localparam MEASURE_STATE = 1;
  localparam HOLD_STATE = 2;
  localparam UPDATE_STATE = 3;
  localparam DONE_STATE = 4;

  //****************************************************************************
  //  Local Signals
  //****************************************************************************
  reg [15:0] testclk_cnt = 16'h0000;
  reg [15:0] refclk_cnt = 16'h0000;
  reg [3:0] testclk_div4 = 4'h1;
  wire testclk_rst;
  wire testclk_en;
  reg [5:0] hold_clk = 6'd0;
  reg [4:0] state = 5'd1;

//  (* ASYNC_REG = "TRUE" *) reg tstclk_rst_dly1, tstclk_rst_dly2;
//  (* ASYNC_REG = "TRUE" *) reg testclk_en_dly1, testclk_en_dly2;
//
// need to get testclk_rst into TESTCLK_I domain
//
//  always @(posedge test_clk_i)
//  begin
//    tstclk_rst_dly1 <= testclk_rst;
//    tstclk_rst_dly2 <= tstclk_rst_dly1;
//  end
//
// need to get testclk_en into TESTCLK_I domain
//
//  always @(posedge test_clk_i)
//  begin
//    testclk_en_dly1 <= testclk_en;
//    testclk_en_dly2 <= testclk_en_dly1;
//  end

  wire tstclk_rst_dly2;
  wire testclk_en_dly2;

rp_phy_multi_pipe_sync bit_synchronizer_testclkreset_i (
    .clk_in (test_clk_i),
    .i_in   (testclk_rst),
    .o_out  (tstclk_rst_dly2)
  );

  always @(posedge test_clk_i)
  begin
    if (tstclk_rst_dly2 == 1'b1)
    begin
      testclk_div4 <= 4'h1;
    end
    else
    begin
      testclk_div4 <= {testclk_div4[2:0], testclk_div4[3]};
    end
  end

rp_phy_multi_pipe_sync bit_synchronizer_testclken_i (
    .clk_in (test_clk_i),
    .i_in   (testclk_en),
    .o_out  (testclk_en_dly2)
  );

  always @(posedge test_clk_i)
  begin
    if (tstclk_rst_dly2 == 1'b1)
    begin
      testclk_cnt <= 0;
    end
    else if (testclk_en_dly2 == 1'b1 && testclk_div4 == 4'h8)
    begin
      testclk_cnt <= testclk_cnt + 1;
    end
  end




  always @(posedge ref_clk_i or posedge rst_i)
  begin
    if (rst_i)
      done_o <= 1'b0;
    else
      done_o <= state[DONE_STATE];
  end

  always @(posedge ref_clk_i or posedge rst_i)
  begin
    if (rst_i) begin
      state <= 0;
      state[RESET_STATE] <= 1'b1;
    end
    else begin
      state <= 0;
      case (1'b1) // synthesis parallel_case full_case
        state[RESET_STATE]:
          begin
            if (hold_clk == 6'h3F)
              state[MEASURE_STATE] <= 1'b1;
            else
              state[RESET_STATE] <= 1'b1;
          end
        state[MEASURE_STATE]:
          begin
            if (refclk_cnt == test_term_cnt_i)
              state[HOLD_STATE] <= 1'b1;
            else
              state[MEASURE_STATE] <= 1'b1;
          end
        state[HOLD_STATE]:
          begin
            if (hold_clk == 6'hF)
              state[UPDATE_STATE] <= 1'b1;
            else
              state[HOLD_STATE] <= 1'b1;
          end
        state[UPDATE_STATE]:
          begin
            freq_cnt_o <= testclk_cnt;
            state[DONE_STATE] <= 1'b1;
          end
        state[DONE_STATE]:
          begin
            state[DONE_STATE] <= 1'b1;
          end
      endcase
    end
  end

  assign testclk_rst = state[RESET_STATE];
  assign testclk_en = state[MEASURE_STATE];


  always @(posedge ref_clk_i)
  begin
    if (state[RESET_STATE] == 1'b1 || state[HOLD_STATE] == 1'b1)
      hold_clk <= hold_clk + 1;
    else
      hold_clk <= 0;
  end

  always @(posedge ref_clk_i)
  begin
    if (state[MEASURE_STATE] == 1'b1)
      refclk_cnt <= refclk_cnt + 1;
    else
      refclk_cnt <= 0;
  end


endmodule

//--------------------------------------------------------------------------------------------------
//  GT Channel Module
//--------------------------------------------------------------------------------------------------
module rp_gt_channel #
(
    parameter         PHY_SIM_EN       = "FALSE", 
    parameter integer PHY_LANE         = 1,
    parameter integer PHY_MAX_SPEED    = 3,
    parameter         PHY_ASYNC_EN     = "FALSE",     
    parameter         PHY_REFCLK_FREQ  = 0,         
    parameter integer PHY_USERCLK_FREQ = 4,           
    parameter integer PHY_CORECLK_FREQ = 2,
    parameter         GT_LANE_NUM      = 0
)
(    
    //--------------------------------------------------------------------------
    //  Clock Ports
    //--------------------------------------------------------------------------
    input                               GT_GTREFCLK0,
    input                               GT_TXUSRCLK,
    input                               GT_RXUSRCLK,
    input                               GT_TXUSRCLK2,
    input                               GT_RXUSRCLK2,    

    input  [2:0]                        GTHE3_TXOUTCLKSEL_OUT,
    //--------------------------------------------------------------------------   
    //  BUFG_GT Controller Ports                                                                        
    //--------------------------------------------------------------------------                   
    output      [ 2:0]                  GT_BUFGTCE,       
    output      [ 2:0]                  GT_BUFGTCEMASK, 
    output      [ 2:0]                  GT_BUFGTRESET,
    output      [ 2:0]                  GT_BUFGTRSTMASK,
    output      [ 8:0]                  GT_BUFGTDIV,   
    output                              GT_TXOUTCLK, 
    output                              GT_RXOUTCLK,
    output                              GT_RXRECCLKOUT,
    output                              GT_RXPMARESETDONE,            
    //--------------------------------------------------------------------------
    //  Reset Ports
    //--------------------------------------------------------------------------
    input                               GT_CPLLPD,
    input                               GT_CPLLRESET,
    input                               GT_TXPROGDIVRESET,
    input                               GT_RXPROGDIVRESET,
    input                               GT_GTTXRESET,
    input                               GT_GTRXRESET,
    input                               GT_TXUSERRDY,
    input                               GT_RXUSERRDY,
                                        
    output                              GT_GTPOWERGOOD,
    output                              GT_TXPROGDIVRESETDONE,
    output                              GT_RXPROGDIVRESETDONE,
    output                              GT_TXRESETDONE,
    output                              GT_RXRESETDONE,                  
    output                              GT_RXCOMMADET, 
    //--------------------------------------------------------------------------
    //  QPLL Ports
    //--------------------------------------------------------------------------
    input                               GT_QPLLCLK,
    input                               GT_QPLLREFCLK,
    input                               GT_QPLLLOCK,
    
    output      [2:0]                   GT_QPLLRATE,
    
    //--------------------------------------------------------------------------
    //  Serial Line Ports
    //--------------------------------------------------------------------------
    input                               GT_RXN,
    input                               GT_RXP,
    
    output                              GT_TXP,
    output                              GT_TXN,
    
    //--------------------------------------------------------------------------
    //  TX Data Ports 
    //--------------------------------------------------------------------------
    input       [31:0]                  GT_TXDATA,
    input       [ 1:0]                  GT_TXDATAK,   
    input                               GT_TXDATA_VALID,
    input                               GT_TXSTART_BLOCK,      
    input       [ 1:0]                  GT_TXSYNC_HEADER,  
    
    //--------------------------------------------------------------------------
    //  RX Data Ports 
    //--------------------------------------------------------------------------
    output      [31:0]                  GT_RXDATA,
    output      [ 1:0]                  GT_RXDATAK,
    output                              GT_RXDATA_VALID,
    output                              GT_RXSTART_BLOCK,      
    output      [ 1:0]                  GT_RXSYNC_HEADER,     
    
    //--------------------------------------------------------------------------
    //  PHY Command Ports
    //--------------------------------------------------------------------------
    input                               GT_TXDETECTRX,
    input                               GT_TXELECIDLE,
    input                               GT_TXCOMPLIANCE,
    input                               GT_RXPOLARITY,
    input       [ 1:0]                  GT_POWERDOWN,
    input       [ 1:0]                  GT_RATE,
    input                               GT_RXCDRHOLD,                                                                 
      
    //--------------------------------------------------------------------------
    //  PHY Status Ports
    //--------------------------------------------------------------------------
    output                              GT_RXVALID,
    output                              GT_PHYSTATUS,
    output                              GT_RXELECIDLE,
    output      [ 2:0]                  GT_RXSTATUS,
    output                              GT_TXPHINITDONE,  
    //--------------------------------------------------------------------------
    //  TX Equalization Ports 
    //--------------------------------------------------------------------------
    input       [ 2:0]                  GT_TXMARGIN,
    input                               GT_TXSWING,
    input                               GT_TXDEEMPH,
    
    //--------------------------------------------------------------------------
    //  TX Equalization Ports (Gen3)
    //--------------------------------------------------------------------------
    input       [ 4:0]                  GT_TXPRECURSOR,
    input       [ 6:0]                  GT_TXMAINCURSOR,
    input       [ 4:0]                  GT_TXPOSTCURSOR,      
    
    //--------------------------------------------------------------------------
    //  PCIe PCS Ports
    //--------------------------------------------------------------------------
    input                               GT_PCIERSTIDLE,        
    input                               GT_PCIERSTTXSYNCSTART, 
    input                               GT_PCIEEQRXEQADAPTDONE,
    input                               GT_PCIEUSERRATEDONE,
             
    output                              GT_PCIEUSERPHYSTATUSRST,    
    output      [ 1:0]                  GT_PCIERATEQPLLPD,                  
    output      [ 1:0]                  GT_PCIERATEQPLLRESET,                
    output                              GT_PCIERATEIDLE,            
    output                              GT_PCIESYNCTXSYNCDONE,                      
    output                              GT_PCIERATEGEN3,    
    output                              GT_PCIEUSERGEN3RDY, 
    output                              GT_PCIEUSERRATESTART,  
                                                          
    //--------------------------------------------------------------------------
    //  TX Sync (Phase/Delay) Alignment Ports
    //--------------------------------------------------------------------------                                                      
    input                               GT_TXSYNCALLIN,
    input                               GT_TXSYNCIN,                                        
                
    output                              GT_TXPHALIGNDONE,            
    output                              GT_TXSYNCOUT,
   
    //--------------------------------------------------------------------------
    //  2527 GT DRP interface
    //--------------------------------------------------------------------------     
    input                               GT_DRPCLK,
    input      [ 8:0]                   GT_DRPADDR,
    input                               GT_DRPEN,
    input                               GT_DRPWE,
    input      [15:0]                   GT_DRPDI,
                                            
    output                              GT_DRPRDY,
    output     [15:0]                   GT_DRPDO,
    //--------------------------------------------------------------------------
    //  Loopback & PRBS Ports
    //--------------------------------------------------------------------------     
    input       [ 2:0]                  GT_LOOPBACK,                                              
    input       [ 3:0]                  GT_PRBSSEL,
    input                               GT_TXPRBSFORCEERR, 
    input                               GT_TXINHIBIT, 
    input                               GT_RXPRBSCNTRESET,                                                                                                      

    output                              GT_RXPRBSERR,                                              
    output                              GT_RXPRBSLOCKED,  
      
    output                              GT_RXPHALIGNDONE,  
    output                              GT_RXDLYSRESETDONE,     
    output                              GT_TXDLYSRESETDONE,     
    output                              GT_RXSYNCDONE, 
    output                              GT_EYESCANDATAERROR,
    output      [16:0]                  GT_DMONITOROUT,
    output      [ 2:0]                  GT_RXBUFSTATUS,
    //--------------------------------------------------------------------------
    //  GT Status Ports
    //--------------------------------------------------------------------------   
    input                               GT_MASTER_CPLLLOCK,
                                                                                                                      
    output                              GT_CPLLLOCK,
    output                              GT_RXCDRLOCK                                                                 
);

//-------------------------------------------------------------------------------------------------
//  Internal Signals
//-------------------------------------------------------------------------------------------------- 
    wire        [127:0]                 txdata;
    wire        [ 15:0]                 txctrl0;
    wire        [ 15:0]                 txctrl1;
    wire        [  7:0]                 txctrl2;
    
    wire        [127:0]                 rxdata;
    wire        [ 15:0]                 rxctrl0;
    
    wire                                pcierategen3;
    wire        [ 11:0]                 pcsrsvdout;
 
 
 
    //----------------------------------------------------------------------------------------------
    //  Single vs. Mulit-lane Selection
    //----------------------------------------------------------------------------------------------
    localparam [ 0:0] MULTI_LANE     = (PHY_LANE    == 1) ? 1'b0 : 1'b1;
    localparam [ 0:0] MASTER_LANE    = (GT_LANE_NUM == 0) ? 1'b1 : 1'b0;
  //localparam [ 0:0] LOCAL_MASTER   = (GT_LANE_NUM == 4) ? 1'b1 : 1'b0;                            // Default
    localparam [ 0:0] LOCAL_MASTER   = 1'b1;                                                        // 
    localparam [ 2:0] CPLLREFCLKSEL  = 3'd1;                                                        // Default       
  //localparam [ 2:0] CPLLREFCLKSEL  = (GT_LANE_NUM < 4) ? 3'd1 : (PHY_SIM_EN : 3'd1 : 3'd5);       // *** GTH 1.0 ***                                          



    //----------------------------------------------------------------------------------------------
    //  CPLL_FBDIV - CPLL Feedback (N1) Divider
    //----------------------------------------------------------------------------------------------
    localparam CPLL_FBDIV_45 = (PHY_MAX_SPEED < 3) ? 5 : 4;
    
    
    
    //----------------------------------------------------------------------------------------------
    //  CPLL_FBDIV - CPLL Feedback (N2) Divider
    //----------------------------------------------------------------------------------------------
    localparam CPLL_FBDIV = (PHY_REFCLK_FREQ == 2) ?  2 : 
                            (PHY_REFCLK_FREQ == 1) ?  4 : 5;
    
    
    
    //----------------------------------------------------------------------------------------------
    // [TX/RX]OUT_DIV - Output Clock Divider for Gen1
    //----------------------------------------------------------------------------------------------
    localparam OUT_DIV = (PHY_MAX_SPEED < 3) ? 2 : 4;  
    
    
    
    //----------------------------------------------------------------------------------------------
    //  [TX/RX]_CLK25_DIV - Clock Divider for 25 MHz
    //----------------------------------------------------------------------------------------------
    localparam CLK25_DIV = (PHY_REFCLK_FREQ == 2) ? 10 : 
                           (PHY_REFCLK_FREQ == 1) ?  5 : 4;
                   
                   
                       
    //----------------------------------------------------------------------------------------------
    //  [TX/RX]_PROGDIV_CFG - Programmable Divider Configuration
    //----------------------------------------------------------------------------------------------
    localparam PROGDIV_CFG = (PHY_MAX_SPEED < 3) ? 10.0 : (PHY_CORECLK_FREQ == 1) ? 8.0 : 4.0;
    
                       
    
    //----------------------------------------------------------------------------------------------
    //  [TX/RX]PLLCLKSEL - PLL Clock Select   
    //                                                    
    //    2'b00 = CPLL                                                                          
    //    2'b01 = Reserved                                                                          
    //    2'b11 = QPLL0                                                                         
    //    2'b10 = QPLL1                                                                           
    //----------------------------------------------------------------------------------------------
    localparam [ 1:0] PLLCLKSEL = (PHY_MAX_SPEED < 3) ? 2'b00 : 2'b10;                             
              
                                           
    //----------------------------------------------------------------------------------------------
    //  [TX/RX]SYSCLKSEL - System Clock Select   
    //                                                    
    //    2'b00 = CPLL                                                                          
    //    2'b01 = Reserved                                                                          
    //    2'b10 = QPLL0                                                                         
    //    2'b11 = QPLL1                                                                           
    //----------------------------------------------------------------------------------------------                 
    localparam [ 1:0] SYSCLKSEL = (PHY_MAX_SPEED < 3) ? 2'b00 : 2'b11;                     
                                           
                                                                                                    
    //----------------------------------------------------------------------------------------------
    //  PLL_SEL_MODE_GEN[12/3] - PLL Select Mode for Gen1/Gen2
    //
    //    [0] : 1'b0 = QPLL0 : 1'b1 = QPLL1 (bit [0] is don't care when bit [1] = 1'b0)
    //    [1] : 1'b0 = CPLL  : 1'b1 = QPLL0 or QPLL1 
    //----------------------------------------------------------------------------------------------
    localparam [ 1:0] PLL_SEL_MODE_GEN12 = (PHY_MAX_SPEED < 3) ? 2'b00 : 2'b11;                  
    localparam [ 1:0] PLL_SEL_MODE_GEN3  = 2'b11;   
    
    
                           
    //----------------------------------------------------------------------------------------------
    //  PCIE_[TX/RX]PMA_CFG - PCIe PMA Configuration    
    //                                         
    //    [   15] : Reserved                                                        
    //    [14:13] : [TX/RX]_INT_DATAWIDTH_G4                                                                    
    //    [12: 9] : [TX/RX]_DATA_WIDTH_G4                                                     
    //    [ 8: 6] : [TX/RX]OUTCLK_DIV_G2                                                        
    //    [ 5: 3] : [TX/RX]OUTCLK_DIV_G3                                                        
    //    [ 2: 0] : [TX/RX]OUTCLK_DIV_G4                                                          
    //----------------------------------------------------------------------------------------------                                                      
    localparam [ 1:0] INT_DATAWIDTH_G4 = 2'd0;
    localparam [ 3:0] DATA_WIDTH_G4    = 4'd0;
    localparam [ 2:0] OUT_DIV_G2       = (PHY_MAX_SPEED < 3) ? 3'd0 : 3'd1;                                                                                                                                                     
    localparam [ 2:0] OUT_DIV_G3       = 3'd0;                                                                                                                                                                    
    localparam [ 2:0] OUT_DIV_G4       = 3'd0;                                                              

    localparam [15:0] PCIE_PMA_CFG = {1'd0,      
                                     INT_DATAWIDTH_G4,                                    
                                     DATA_WIDTH_G4,                                                             
                                     OUT_DIV_G2,                                                 
                                     OUT_DIV_G3,                                                                                              
                                     OUT_DIV_G4};         
    
    
    
    //----------------------------------------------------------------------------------------------
    //  PCIE_BUFG_DIV_CTRL - PCIe BUFG_GT Divider Control
    //
    //    [   15] : BUFG_GT_FSM_CLK
    //    [14:12] : PCLK_DIV_G1
    //    [11:10] : PCLK_DIV_G2  
    //    [ 9: 8] : PCLK_DIV_G3 
    //    [ 7: 6] : PCLK_DIV_G4
    //    [ 5: 3] : USERCLK_DIV
    //    [ 2: 0] : CORECLK_DIV
    //----------------------------------------------------------------------------------------------  
    localparam [ 0:0] BUFG_GT_FSM_CLK = 1'd0;                                                       // 1'b0 = REFCLK : 1'b1 = PROGDIVCLK

    localparam [ 2:0] PCLK_DIV_G1 = (PHY_MAX_SPEED < 3) ? 3'd1 : 3'd3;                              // 125 MHz
    localparam [ 1:0] PCLK_DIV_G2 = (PHY_MAX_SPEED < 3) ? 2'd0 : 2'd1;                              // 250 MHz
    localparam [ 1:0] PCLK_DIV_G3 = (PHY_MAX_SPEED < 3) ? 2'd0 : 2'd1;                              // 250 MHz                             
    localparam [ 1:0] PCLK_DIV_G4 = 2'd0;                                                           // 500 MHz
  
    localparam [ 2:0] USERCLK_DIV_G12 = (PHY_USERCLK_FREQ == 3) ? 3'd0 :                            // 250.0 MHz
                                        (PHY_USERCLK_FREQ == 2) ? 3'd1 :                            // 125.0 MHz
                                        (PHY_USERCLK_FREQ == 1) ? 3'd3 : 3'd0;                      //  62.5 MHz
  
    localparam [ 2:0] USERCLK_DIV_G3 = (PHY_USERCLK_FREQ == 4) ? 3'd0 :                             // 500.0 MHz
                                       (PHY_USERCLK_FREQ == 3) ? 3'd1 :                             // 250.0 MHz
                                       (PHY_USERCLK_FREQ == 2) ? 3'd3 :                             // 125.0 MHz
                                       (PHY_USERCLK_FREQ == 1) ? 3'd7 : 3'd0;                       //  62.5 MHz

    localparam [ 2:0] USERCLK_DIV = (PHY_MAX_SPEED < 3) ? USERCLK_DIV_G12 : USERCLK_DIV_G3;
    
    localparam [ 2:0] CORECLK_DIV_G12 = 3'd0;                                                       // 250.0 MHz
 
    localparam [ 2:0] CORECLK_DIV_G3 = (PHY_CORECLK_FREQ == 2) ? 3'd0 :                             // 500.0 MHz
                                       (PHY_CORECLK_FREQ == 1) ? 3'd1 : 3'd0;                       // 250.0 MHz
                                       
    localparam [ 2:0] CORECLK_DIV = (PHY_MAX_SPEED < 3) ? CORECLK_DIV_G12 : CORECLK_DIV_G3;
            
    localparam [15:0] PCIE_BUFG_DIV_CTRL = {BUFG_GT_FSM_CLK,                    
                                            PCLK_DIV_G1, 
                                            PCLK_DIV_G2,  
                                            PCLK_DIV_G3,                                                            
                                            PCLK_DIV_G4,
                                            USERCLK_DIV,
                                            CORECLK_DIV};
                                     
     
                    
    //----------------------------------------------------------------------------------------------
    //  PCIE_TXPCS_CFG_GEN3 - PCIe TX PCS Configuration
    //                                             
    //    [15:14] : Reserved                                                        
    //    [13:12] : TX_DRIVE_MODE_G3                                                                    
    //    [   11] : ASYNC_EN   
    //    [   10] : TX_XCLK_SEL_G3                                                   
    //    [    9] : TXBUF_EN_G3                                                          
    //    [ 8: 7] : TX_INT_DATAWIDTH_G3
    //    [ 6: 3] : TX_DATA_WIDTH_G3
    //    [    2] : TX_SYNC_MODE
    //    [    1] : DRP_EXT_CTRL                                                         
    //    [    0] : Reserved                                                         
    //----------------------------------------------------------------------------------------------                                                      
    localparam [ 1:0] TX_DRIVE_MODE_G3    = 2'd2;                                      // "PIPEGEN3"
    localparam [ 0:0] ASYNC_EN            = (PHY_ASYNC_EN == "TRUE") ? 1'd1 : 1'd0;    // 1'b0 = Async : 1'b1 = Sync
    localparam [ 0:0] TX_XCLK_SEL_G3      = 1'd1;                                      // "TXUSER"                                                                                                                                                     
    localparam [ 0:0] TXBUF_EN_G3         = 1'd0;                                      // "FALSE"                                                                                                                                        
    localparam [ 1:0] TX_INT_DATAWIDTH_G3 = 2'd1;                                      // 4 byte
    localparam [ 3:0] TX_DATA_WIDTH_G3    = 4'd4;                                      // 32-bit 
    localparam [ 0:0] TX_SYNC_MODE        = 1'd1;                                      // Auto 
    localparam [ 0:0] DRP_EXT_CTRL        = 1'd0;                                      // Disable 
    
    localparam [15:0] PCIE_TXPCS_CFG_GEN3 = {2'd0,
                                             TX_DRIVE_MODE_G3,
                                             ASYNC_EN,
                                             TX_XCLK_SEL_G3,
                                             TXBUF_EN_G3,
                                             TX_INT_DATAWIDTH_G3,
                                             TX_DATA_WIDTH_G3,
                                             TX_SYNC_MODE,
                                             DRP_EXT_CTRL,
                                             1'd0};
    
    
    
    //----------------------------------------------------------------------------------------------
    //  PCIE_RXPCS_CFG_GEN3 - PCIe RX PCS Configuration  
    //                                                                                                  
    //    [   15] : RX_DFE_LPM_HOLD_DURING_EIDLE_G3 for Gen3                                                                     
    //    [   14] : RXCDR_PH_RESET_ON_EIDLE_G3  
    //    [   13] : RXCDR_FR_RESET_ON_EIDLE_G3                                             
    //    [   12] : RXCDR_HOLD_DURING_EIDLE_G3                                                      
    //    [   11] : CLK_CORRECT_USE_G3
    //    [   10] : RX_XCLK_SEL_G3
    //    [    9] : RXBUF_EN_G3
    //    [ 8: 7] : RX_INT_DATA_WIDTH_G3
    //    [ 6: 3] : RX_DATA_WIDTH_G3
    //    [    2] : RX_SYNC_MODE                                                        
    //    [    1] : RATE_FSM_CLK  
    //    [    0] : Reserved                                                  
    //----------------------------------------------------------------------------------------------                                                      
    localparam [ 0:0] RX_DFE_LPM_HOLD_DURING_EIDLE_G3 = 1'd0;                          // 
    localparam [ 0:0] RXCDR_PH_RESET_ON_EIDLE_G3      = 1'd0;                          // 
    localparam [ 0:0] RXCDR_FR_RESET_ON_EIDLE_G3      = 1'd0;                          //                                                                                                                                             
    localparam [ 0:0] RXCDR_HOLD_DURING_EIDLE_G3      = 1'd0;                          //      
    localparam [ 0:0] CLK_CORRECT_USE_G3              = 1'd0;                          // "FALSE"          
    localparam [ 0:0] RX_XCLK_SEL_G3                  = 1'd0;                          // RXDES                                                                                 
    localparam [ 0:0] RXBUF_EN_G3                     = 1'd1;                          // "TRUE"
    localparam [ 1:0] RX_INT_DATA_WIDTH_G3            = 2'd1;                          // 4 byte  
    localparam [ 3:0] RX_DATA_WIDTH_G3                = 4'd4;                          // 32-bit  
    localparam [ 0:0] RX_SYNC_MODE                    = 1'd1;                          // Auto
    localparam [ 0:0] RATE_FSM_CLK                    = 1'd0;                          // 1'b0 = REFCLK : 1'b1 = PCLK
    
    localparam [15:0] PCIE_RXPCS_CFG_GEN3 = {RX_DFE_LPM_HOLD_DURING_EIDLE_G3,
                                             RXCDR_PH_RESET_ON_EIDLE_G3,
                                             RXCDR_FR_RESET_ON_EIDLE_G3,
                                             RXCDR_HOLD_DURING_EIDLE_G3,
                                             CLK_CORRECT_USE_G3,
                                             RX_XCLK_SEL_G3,
                                             RXBUF_EN_G3,
                                             RX_INT_DATA_WIDTH_G3,
                                             RX_DATA_WIDTH_G3,
                                             RX_SYNC_MODE,
                                             RATE_FSM_CLK,
                                             1'd0};



//--------------------------------------------------------------------------------------------------
//  GTH Channel
//--------------------------------------------------------------------------------------------------
GTHE3_CHANNEL #
(  
    //----------------------------------------------------------------------------------------------
    //  Simulation Attributes
    //----------------------------------------------------------------------------------------------
    .SIM_RECEIVER_DETECT_PASS           ("TRUE"),
    .SIM_RESET_SPEEDUP                  ("TRUE"),
    .SIM_TX_EIDLE_DRIVE_LEVEL           ( 1'b0),
    .SIM_VERSION                        ("Ver_1"),                                                                          
   
    //----------------------------------------------------------------------------------------------     
    //  Clock Attributes
    //----------------------------------------------------------------------------------------------                                                                                                                       
    .TX_PROGCLK_SEL                     ("CPLL"),                               // PCIe
    .TX_PROGDIV_CFG                     (PROGDIV_CFG),                      
    .RX_PROGDIV_CFG                     (PROGDIV_CFG),                         
    .TX_CLK25_DIV                       (CLK25_DIV),                                                    
    .RX_CLK25_DIV                       (CLK25_DIV),                                                    
    .TX_CLKMUX_EN                       ( 1'b1),                                                
    .RX_CLKMUX_EN                       ( 1'b1),                                                
    .TX_XCLK_SEL                        ("TXUSR"),                                              
    .RX_XCLK_SEL                        ("RXDES"),   
    .TXOUT_DIV                          (OUT_DIV), 
    .RXOUT_DIV                          (OUT_DIV), 
    .LOCAL_MASTER                       (LOCAL_MASTER),   
    .RX_CLK_SLIP_OVRD                   ( 5'b00000),  
    .RXPMACLK_SEL                       ("DATA"),                                                                                                                            
    .USE_PCS_CLK_PHASE_SEL              ( 1'b0),                                                 
               
    //----------------------------------------------------------------------------------------------
    //  CPLL Attributes
    //---------------------------------------------------------------------------------------------- 
    .CPLL_FBDIV                         (CPLL_FBDIV),  
    .CPLL_FBDIV_45                      (CPLL_FBDIV_45),         
    .CPLL_REFCLK_DIV                    (1),                
    .CPLL_CFG0                          (16'b0110001111111010),                            
    .CPLL_CFG1                          (16'b1010010010010100),                                   
    .CPLL_CFG2                          (16'b1111000000000100),      
    .CPLL_CFG3                          ( 6'b000000),  
    .CPLL_INIT_CFG0                     (16'b0000000000011110),       
    .CPLL_INIT_CFG1                     ( 8'b00000000),            
    .CPLL_LOCK_CFG                      (16'b0000000111101000),                 // [0] : 1'b0   
                                                                              
    //----------------------------------------------------------------------------------------------
    //  Reset Attributes
    //----------------------------------------------------------------------------------------------    
  //.A_TXPROGDIVRESET                   ( 1'b0), 
  //.A_RXPROGDIVRESET                   ( 1'b0),
    .TX_DIVRESET_TIME                   ( 5'b00001),                              
    .RX_DIVRESET_TIME                   ( 5'b00001),  
  //.RXBUFRESET_TIME                    ( 5'b00001), 
    .RXCDRFREQRESET_TIME                ( 5'b00001),  
    .RXCDRPHRESET_TIME                  ( 5'b00001),    
    .RXDFELPMRESET_TIME                 ( 7'b0001111), 
  //.RXISCANRESET_TIME                  ( 5'b00001),
  //.RXOSCALRESET_TIME                  ( 5'b00011),         
  //.TXPCSRESET_TIME                    ( 5'b00001),                
  //.RXPCSRESET_TIME                    ( 5'b00001),                                                   
  //.TXPMARESET_TIME                    ( 5'b00001),                                                   
  //.RXPMARESET_TIME                    ( 5'b00001),                                                
  //.RESET_POWERSAVE_DISABLE            ( 1'b0),                                                      
               
    //----------------------------------------------------------------------------------------------
    //  PCIe Attributes
    //----------------------------------------------------------------------------------------------
    .PCIE_BUFG_DIV_CTRL                 (PCIE_BUFG_DIV_CTRL),                   // 16'b0011010100000000  
    .PCIE_RXPCS_CFG_GEN3                (PCIE_RXPCS_CFG_GEN3),                  // 16'b0000001010100100
    .PCIE_RXPMA_CFG                     (PCIE_PMA_CFG),                         // 16'b0000000001000000
    .PCIE_TXPCS_CFG_GEN3                (PCIE_TXPCS_CFG_GEN3),                  // 16'b0010010010100000        
    .PCIE_TXPMA_CFG                     (PCIE_PMA_CFG),                         // 16'b0000000001000000
    .PCS_PCIE_EN                        ("TRUE"),  
    .PLL_SEL_MODE_GEN12                 (PLL_SEL_MODE_GEN12),                   // 2'b10        
    .PLL_SEL_MODE_GEN3                  (PLL_SEL_MODE_GEN3),                    // 2'b10

    //---------------------------------------------------------------------------------------------- 
    //  Data Width Attributes
    //----------------------------------------------------------------------------------------------                          
    .TX_DATA_WIDTH                      (20),                                                                                                                                         
    .RX_DATA_WIDTH                      (20),  
    .TX_INT_DATAWIDTH                   ( 0),                                                                
    .RX_INT_DATAWIDTH                   ( 0),   
    .TX_FABINT_USRCLK_FLOP              ( 1'b0), 
    .RX_FABINT_USRCLK_FLOP              ( 1'b0),                                                    
              
    //----------------------------------------------------------------------------------------------
    //  Analog Front End Attributes
    //----------------------------------------------------------------------------------------------
    .RX_AFE_CM_EN                       ( 1'b0),
    .RX_BIAS_CFG0                       (16'b0000101010110100),
    .RX_CM_BUF_CFG                      ( 4'b1010),
    .RX_CM_BUF_PD                       ( 1'b0),                                           
    .RX_CM_SEL                          ( 2'b11),                                                        
    .RX_CM_TRIM                         ( 4'b1010),    
    .RX_TUNE_AFE_OS                     ( 2'b10),
    .TERM_RCAL_CFG                      (15'b100001000010000),                                     
    .TERM_RCAL_OVRD                     ( 3'b000),         
    .TX_QPI_STATUS_EN                   ( 1'b0),           
                                                                                                    
    //----------------------------------------------------------------------------------------------  
    //  Receiver Detection Attributes
    //----------------------------------------------------------------------------------------------                                      
    .TX_RXDETECT_CFG                    (14'h0032),                             // ***                            
    .TX_RXDETECT_REF                    ( 3'b100),                                  
    
    //----------------------------------------------------------------------------------------------  
    //  TX Electrical Idle Attributes
    //----------------------------------------------------------------------------------------------   
    .TX_EIDLE_ASSERT_DELAY              ( 3'b100),                              // PCIe option              
    .TX_EIDLE_DEASSERT_DELAY            ( 3'b011),                              // PCIe option
    .TX_IDLE_DATA_ZERO                  ( 1'b0),                                // PCIe option             
 
    //----------------------------------------------------------------------------------------------  
    //  RX OOB Attributes
    //----------------------------------------------------------------------------------------------   
    .OOB_PWRUP                          ( 1'b1),                                // PCIe option
    .OOBDIVCTL                          ( 2'b10),                               // PCIe option (div 4)                  
    .RX_SIG_VALID_DLY                   ( 4),                                   // PCIe optimized
    .RXOOB_CFG                          ( 9'b000000110),                          
    .RXOOB_CLK_CFG                      ("PMA"),      
    
    //----------------------------------------------------------------------------------------------  
    //  RX Electrical Idle Attributes
    //----------------------------------------------------------------------------------------------                                                   
    .RX_DFE_LPM_HOLD_DURING_EIDLE       ( 1'b0),                                
    .RXBUF_EIDLE_HI_CNT                 ( 4'b0100),                             // PCIe optimized
    .RXBUF_EIDLE_LO_CNT                 ( 4'b0000),
    .RXBUF_RESET_ON_EIDLE               ("TRUE"),
    .RXCDR_FR_RESET_ON_EIDLE            ( 1'b0),
    .RXCDR_PH_RESET_ON_EIDLE            ( 1'b0),
    .RXCDR_HOLD_DURING_EIDLE            ( 1'b1),                                // PCIe option
    .RXELECIDLE_CFG                     ("Sigcfg_1"),                           // PCIe option 
 
    //----------------------------------------------------------------------------------------------  
    //  Power Down Attributes
    //----------------------------------------------------------------------------------------------   
    .PD_TRANS_TIME_FROM_P2              (12'b000000111100),                                                     
    .PD_TRANS_TIME_NONE_P2              ( 8'b00011001),                                                      
    .PD_TRANS_TIME_TO_P2                ( 8'b01100100),   
    .TX_PMA_POWER_SAVE                  ( 1'b0),   
    .RX_PMA_POWER_SAVE                  ( 1'b0),                               
  
    //----------------------------------------------------------------------------------------------  
    //  Rate Change Attributes
    //---------------------------------------------------------------------------------------------- 
    .RATE_SW_USE_DRP                    ( 1'b0),                                // PCIe 
    .TRANS_TIME_RATE                    ( 8'b00001110),             
    .TXBUF_RESET_ON_RATE_CHANGE         ("TRUE"),                               // PCIe 
    .RXBUF_RESET_ON_RATE_CHANGE         ("TRUE"),                               // PCIe

    //----------------------------------------------------------------------------------------------
    //  TX Driver Attributes
    //----------------------------------------------------------------------------------------------                                   
    .TX_DEEMPH0                         ( 6'b010100),                           // -6.0 dB                           
    .TX_DEEMPH1                         ( 6'b001101),                           // -3.5 dB 
    .TX_DRIVE_MODE                      ("PIPE"),                               // PCIe Gen1/Gen2 
    .TX_LOOPBACK_DRIVE_HIZ              ("FALSE"),                   
    .TX_MARGIN_FULL_0                   ( 7'b1001111),                          // ~1200 mV
    .TX_MARGIN_FULL_1                   ( 7'b1001110),                          // ~1100 mV
    .TX_MARGIN_FULL_2                   ( 7'b1001100),                          // ~1000 mV
    .TX_MARGIN_FULL_3                   ( 7'b1001010),                          // ~ 900 mV
    .TX_MARGIN_FULL_4                   ( 7'b1001000),                          // ~ 800 mV
    .TX_MARGIN_LOW_0                    ( 7'b1000110),                          // ~ 700 mV            
    .TX_MARGIN_LOW_1                    ( 7'b1000101),                          // ~ 600 mV           
    .TX_MARGIN_LOW_2                    ( 7'b1000011),                          // ~ 500 mV          
    .TX_MARGIN_LOW_3                    ( 7'b1000010),                          // ~ 400 mV           
    .TX_MARGIN_LOW_4                    ( 7'b1000000),                          // ~ 300 mV
    .TX_MAINCURSOR_SEL                  ( 1'b0),   
    .TXDRVBIAS_N                        ( 4'b1010),                                                                         
    .TXDRVBIAS_P                        ( 4'b1111),                             // GTH 1.0       
   
    //----------------------------------------------------------------------------------------------    
    //  Comma Align & Detect Attributes
    //----------------------------------------------------------------------------------------------       
    .ALIGN_COMMA_DOUBLE                 ("FALSE"),                                                  
    .ALIGN_COMMA_ENABLE                 (10'b1111111111),                                           
    .ALIGN_COMMA_WORD                   ( 1),                                                       
    .ALIGN_MCOMMA_DET                   ("TRUE"),                                                   
    .ALIGN_MCOMMA_VALUE                 (10'b1010000011),                                           
    .ALIGN_PCOMMA_DET                   ("TRUE"),                                                   
    .ALIGN_PCOMMA_VALUE                 (10'b0101111100),                                           
    .DEC_MCOMMA_DETECT                  ("TRUE"),                                                      
    .DEC_PCOMMA_DETECT                  ("TRUE"),                                                      
    .DEC_VALID_COMMA_ONLY               ("FALSE"),                                                     
    .SHOW_REALIGN_COMMA                 ("FALSE"),       
   
    //----------------------------------------------------------------------------------------------   
    //  8B/10B Attributes                                                                             
    //----------------------------------------------------------------------------------------------                   
    .RX_DISPERR_SEQ_MATCH               ("TRUE"),        
   
    //----------------------------------------------------------------------------------------------  
    //  TX Buffer Attributes
    //----------------------------------------------------------------------------------------------                      
    .TXBUF_EN                           ("FALSE"),        
    .TXFIFO_ADDR_CFG                    ("LOW"),                                                                                      
 
    //----------------------------------------------------------------------------------------------
    //  RX Buffer Attributes                                                                        
    //----------------------------------------------------------------------------------------------     
    .RXBUF_ADDR_MODE                    ("FULL"),                               //
    .RXBUF_EN                           ("TRUE"),
    .RXBUF_RESET_ON_CB_CHANGE           ("TRUE"),
    .RXBUF_RESET_ON_COMMAALIGN          ("FALSE"),
    .RXBUF_THRESH_OVFLW                 (0),                                    // not used when RXBUF_THRESH_OVRD = "FALSE"
    .RXBUF_THRESH_OVRD                  ("FALSE"),                              //
    .RXBUF_THRESH_UNDFLW                (0),   
    .RX_BUFFER_CFG                      (6'b000000),
    .RX_DEFER_RESET_BUF_EN              ("TRUE"), 
   
    //----------------------------------------------------------------------------------------------   
    //  RX Buffer Attributes (Gen3)                                                                                       
    //----------------------------------------------------------------------------------------------   
    .PCI3_AUTO_REALIGN                  ("OVR_1K_BLK"),                         //  
    .PCI3_PIPE_RX_ELECIDLE              ( 1'b0),                                
    .PCI3_RX_ASYNC_EBUF_BYPASS          ( 2'b00),                               
    .PCI3_RX_ELECIDLE_EI2_ENABLE        ( 1'b0),                                
    .PCI3_RX_ELECIDLE_H2L_COUNT         ( 6'b000000),                           
    .PCI3_RX_ELECIDLE_H2L_DISABLE       ( 3'b000),                              
    .PCI3_RX_ELECIDLE_HI_COUNT          ( 6'b000000),                           
    .PCI3_RX_ELECIDLE_LP4_DISABLE       ( 1'b0),                                
    .PCI3_RX_FIFO_DISABLE               ( 1'b0),                                
       
    //---------------------------------------------------------------------------------------------- 
    //  Clock Correction Attributes
    //----------------------------------------------------------------------------------------------             
    .CLK_COR_KEEP_IDLE                  ("TRUE"),
    .CLK_COR_MAX_LAT                    (13),                                   // optimized for no channel bonding with clock correction
    .CLK_COR_MIN_LAT                    (11),                                   // optimized for no channel bonding with clock correction
    .CLK_COR_PRECEDENCE                 ("TRUE"),
    .CLK_COR_REPEAT_WAIT                (0),
    .CLK_COR_SEQ_LEN                    (1),
    .CLK_COR_SEQ_1_ENABLE               (4'b1111),
    .CLK_COR_SEQ_1_1                    (10'b0100011100),
    .CLK_COR_SEQ_1_2                    (10'b0000000000),
    .CLK_COR_SEQ_1_3                    (10'b0000000000),
    .CLK_COR_SEQ_1_4                    (10'b0000000000),
    .CLK_COR_SEQ_2_ENABLE               (4'b1111),
    .CLK_COR_SEQ_2_USE                  ("FALSE"),
    .CLK_COR_SEQ_2_1                    (10'b0000000000),
    .CLK_COR_SEQ_2_2                    (10'b0000000000),
    .CLK_COR_SEQ_2_3                    (10'b0000000000),
    .CLK_COR_SEQ_2_4                    (10'b0000000000),
    .CLK_CORRECT_USE                    ("TRUE"),                
       
    //---------------------------------------------------------------------------------------------- 
    //  FTS Deskew Attributes                                                                            
    //----------------------------------------------------------------------------------------------                                         
    .FTS_DESKEW_SEQ_ENABLE              ( 4'b1111),                                        
    .FTS_LANE_DESKEW_CFG                ( 4'b1111),                                          
    .FTS_LANE_DESKEW_EN                 ("TRUE"),           
       
    //---------------------------------------------------------------------------------------------- 
    //  Channel Bonding Attributes (Disabled)
    //----------------------------------------------------------------------------------------------          
    .CBCC_DATA_SOURCE_SEL               ("DECODED"),  
    .CHAN_BOND_KEEP_ALIGN               ("FALSE"),
    .CHAN_BOND_MAX_SKEW                 (1),
    .CHAN_BOND_SEQ_LEN                  (1),
    .CHAN_BOND_SEQ_1_ENABLE             (4'b1111),
    .CHAN_BOND_SEQ_1_1                  (10'b0000000000),
    .CHAN_BOND_SEQ_1_2                  (10'b0000000000),
    .CHAN_BOND_SEQ_1_3                  (10'b0000000000),
    .CHAN_BOND_SEQ_1_4                  (10'b0000000000),
    .CHAN_BOND_SEQ_2_ENABLE             (4'b1111),
    .CHAN_BOND_SEQ_2_USE                ("FALSE"),
    .CHAN_BOND_SEQ_2_1                  (10'b0000000000),
    .CHAN_BOND_SEQ_2_2                  (10'b0000000000),
    .CHAN_BOND_SEQ_2_3                  (10'b0000000000),
    .CHAN_BOND_SEQ_2_4                  (10'b0000000000),                                                                                
  
    //----------------------------------------------------------------------------------------------            
    //  TX Sync (Phase & Delay) Alignment Attributes                                                                              
    //----------------------------------------------------------------------------------------------     
    .TXDLY_CFG                          (16'b0000000000011111),    
    .TXDLY_LCFG                         (16'b0000000000110000),    
    .TXPHDLY_CFG0                       (16'b0010000000100000),
    .TXPHDLY_CFG1                       (16'b0000000000000001),
    .TXPH_CFG                           (16'b0000100110000000),  
    .TXPH_MONITOR_SEL                   ( 5'b00000),
                                                                                         
    //----------------------------------------------------------------------------------------------            
    //  TX Auto Sync (Phase & Delay) Alignment Attributes                                                                               
    //----------------------------------------------------------------------------------------------                
    .TXSYNC_MULTILANE                   (MULTI_LANE),                                                                                                              
    .TXSYNC_OVRD                        (1'b0),                                 // 1'b0 = auto : 1'b1 = manual                                                                
    .TXSYNC_SKIP_DA                     (1'b0),                     
                                                                                                    
    //----------------------------------------------------------------------------------------------            
    //  RX Sync (Phase & Delay) Alignment Attributes                                                                               
    //----------------------------------------------------------------------------------------------    
  //.RXPHBEACON_CFG                     (16'h0000),
  //.RXPHDLY_CFG                        (16'h2020),
  //.RXPHSAMP_CFG                       (16'h2100),
  //.RXPHSLIP_CFG                       (16'h6622),    
  //.RXPH_MONITOR_SEL                   (5'b00000),
  //.RXDLY_CFG                          (16'h001F),
  //.RXDLY_LCFG                         (16'h0030),   
           
    //----------------------------------------------------------------------------------------------            
    //  RX Auto Sync (Phase & Delay) Alignment Attributes                                                                                 
    //----------------------------------------------------------------------------------------------                
  //.RXSYNC_MULTILANE                   (1'b0),                                                                                                              
  //.RXSYNC_OVRD                        (1'b0),                                 // 1'b0 = auto : 1'b1 = manual                                                                
  //.RXSYNC_SKIP_DA                     (1'b0),                   
  
    //----------------------------------------------------------------------------------------------  
    //  Gearbox Attributes                                                                   
    //---------------------------------------------------------------------------------------------- 
  //.GEARBOX_MODE                       ( 5'b00000), 
  //.TX_SAMPLE_PERIOD                   ( 3'b101),
  //.RX_SAMPLE_PERIOD                   ( 3'b101),
  //.TXGEARBOX_EN                       ("FALSE"),
  //.RXGEARBOX_EN                       ("FALSE"),    
  //.TXGBOX_FIFO_INIT_RD_ADDR           ( 4),
  //.RXGBOX_FIFO_INIT_RD_ADDR           ( 4),
  //.RXSLIDE_AUTO_WAIT                  ( 7),                                                         
    .RXSLIDE_MODE                       ("PMA"),                                // required for Gen3         

    //----------------------------------------------------------------------------------------------
    //  PCS Attributes
    //----------------------------------------------------------------------------------------------
    .PCS_RSVD0                          (16'b0000000000000000),
    .PCS_RSVD1                          ( 3'b000),
  
    //----------------------------------------------------------------------------------------------  
    //  PMA Attributes
    //----------------------------------------------------------------------------------------------      
    .PMA_RSV1                           (16'b0001000000000000),                                                        
      
    //----------------------------------------------------------------------------------------------
    //  CFOK Attributes                                                                 
    //----------------------------------------------------------------------------------------------              
    .RXCFOK_CFG0                        (16'b0100000000000000), 
    .RXCFOK_CFG1                        (16'b0000000001100101),                 
    .RXCFOK_CFG2                        (16'b0000000000001110),                 

    //----------------------------------------------------------------------------------------------    
    //  RX LPM Attributes
    //----------------------------------------------------------------------------------------------        
    .RXLPM_CFG                          (16'b0000000000000000),    
    .RXLPM_GC_CFG                       (16'b0000000000000000),
    .RXLPM_KH_CFG0                      (16'b0000000000000000),
    .RXLPM_KH_CFG1                      (16'b0000000000000010),
    .RXLPM_OS_CFG0                      (16'b1000000000000000),
    .RXLPM_OS_CFG1                      (16'b0000000000000010),
 
    //----------------------------------------------------------------------------------------------    
    //  RX DFE Attributes
    //---------------------------------------------------------------------------------------------- 
    .DFE_D_X_REL_POS                    ( 1'b0),   
    .DFE_VCM_COMP_EN                    ( 1'b0),        
    .RXDFELPM_KL_CFG0                   (16'b0000000000000000),                 //    
    .RXDFELPM_KL_CFG1                   ((PHY_MAX_SPEED < 3) ? 16'b0000000000110010 : 16'b0000000000000010),    
    .RXDFELPM_KL_CFG2                   (16'b0000000000000000),                
    .RXDFE_CFG0                         (16'b0000101000000000),
    .RXDFE_CFG1                         (16'b0000000000000000),
    .RXDFE_GC_CFG0                      (16'b0000000000000000),                 // ***
    .RXDFE_GC_CFG1                      ((PHY_MAX_SPEED < 3) ? 16'b0111100001110000 : 16'b0111100001100000),
    .RXDFE_GC_CFG2                      ((PHY_MAX_SPEED < 3) ? 16'b0000000001000000 : 16'b0000000000000000),
    .RXDFE_H2_CFG0                      (16'b0000000000000000),
    .RXDFE_H2_CFG1                      (16'b0000000000000000),
    .RXDFE_H3_CFG0                      (16'b0100000000000000),
    .RXDFE_H3_CFG1                      (16'b0000000000000000),
    .RXDFE_H4_CFG0                      (16'b0010000000000000),
    .RXDFE_H4_CFG1                      (16'b0000000000000011),
    .RXDFE_H5_CFG0                      (16'b0010000000000000),
    .RXDFE_H5_CFG1                      (16'b0000000000000011),
    .RXDFE_H6_CFG0                      (16'b0010000000000000),
    .RXDFE_H6_CFG1                      (16'b0000000000000000),
    .RXDFE_H7_CFG0                      (16'b0010000000000000),
    .RXDFE_H7_CFG1                      (16'b0000000000000000),
    .RXDFE_H8_CFG0                      (16'b0010000000000000),
    .RXDFE_H8_CFG1                      (16'b0000000000000000),
    .RXDFE_H9_CFG0                      (16'b0010000000000000),
    .RXDFE_H9_CFG1                      (16'b0000000000000000),
    .RXDFE_HA_CFG0                      (16'b0010000000000000),
    .RXDFE_HA_CFG1                      (16'b0000000000000000),
    .RXDFE_HB_CFG0                      (16'b0010000000000000),
    .RXDFE_HB_CFG1                      (16'b0000000000000000),
    .RXDFE_HC_CFG0                      (16'b0000000000000000),
    .RXDFE_HC_CFG1                      (16'b0000000000000000),
    .RXDFE_HD_CFG0                      (16'b0000000000000000),
    .RXDFE_HD_CFG1                      (16'b0000000000000000),
    .RXDFE_HE_CFG0                      (16'b0000000000000000),
    .RXDFE_HE_CFG1                      (16'b0000000000000000),
    .RXDFE_HF_CFG0                      (16'b0000000000000000),
    .RXDFE_HF_CFG1                      (16'b0000000000000000),
    .RXDFE_OS_CFG0                      (16'b1000000000000000),
    .RXDFE_OS_CFG1                      (16'b0000000000000000),
    .RXDFE_UT_CFG0                      (16'b1000000000000000),
    .RXDFE_UT_CFG1                      (16'b0000000000000011),
    .RXDFE_VP_CFG0                      (16'b1010101000000000),
    .RXDFE_VP_CFG1                      (16'b0000000000110011),
    .RX_DFELPM_CFG0                     ( 4'b0110),
    .RX_DFELPM_CFG1                     ( 1'b1),                                                               
    .RX_DFELPM_KLKH_AGC_STUP_EN         ( 1'b1), 
    .RX_DFE_AGC_CFG0                    ((PHY_MAX_SPEED < 3) ? 2'b00  : 2'b10 ),                               
    .RX_DFE_AGC_CFG1                    ((PHY_MAX_SPEED < 3) ? 3'b000 : 3'b100),  
    .RX_DFE_KL_LPM_KH_CFG0              ( 2'b01),
    .RX_DFE_KL_LPM_KH_CFG1              ((PHY_MAX_SPEED < 3) ? 3'b000 : 3'b100),
    .RX_DFE_KL_LPM_KL_CFG0              ( 2'b01),
    .RX_DFE_KL_LPM_KL_CFG1              ((PHY_MAX_SPEED < 3) ? 3'b000 : 3'b100),   
    .RX_CTLE3_LPF                       ( 8'b00000001),                                                                       
          
    //----------------------------------------------------------------------------------------------  
    //  TX PI attributes
    //----------------------------------------------------------------------------------------------
    .TXPI_CFG0                          ( 2'b00),
    .TXPI_CFG1                          ( 2'b00),
    .TXPI_CFG2                          ( 2'b00),
    .TXPI_CFG3                          ( 1'b1),
    .TXPI_CFG4                          ((PHY_MAX_SPEED < 3) ? 1'b1   : 1'b0  ),
    .TXPI_CFG5                          ((PHY_MAX_SPEED < 3) ? 3'b011 : 3'b000),
    .TXPI_GRAY_SEL                      ( 1'b0),
    .TXPI_INVSTROBE_SEL                 ( 1'b0),
    .TXPI_LPM                           ( 1'b0),
    .TXPI_PPMCLK_SEL                    ("TXUSRCLK2"),
    .TXPI_PPM_CFG                       ( 8'b00000000),
    .TXPI_SYNFREQ_PPM                   ( 3'b000),
    .TXPI_VREFSEL                       ( 1'b0),    
    
    //----------------------------------------------------------------------------------------------  
    //  RX PI Attributes
    //----------------------------------------------------------------------------------------------    
    .RXPI_CFG0                          ( 2'b00),
    .RXPI_CFG1                          ( 2'b00),
    .RXPI_CFG2                          ( 2'b00),
    .RXPI_CFG3                          ( 2'b00),
    .RXPI_CFG4                          ( 1'b1),
    .RXPI_CFG5                          ((PHY_MAX_SPEED < 3) ? 1'b1   : 1'b0  ),
    .RXPI_CFG6                          ((PHY_MAX_SPEED < 3) ? 3'b011 : 3'b000),
    .RXPI_LPM                           ( 1'b0),
    .RXPI_VREFSEL                       ( 1'b0),              

    //----------------------------------------------------------------------------------------------
    //  RX CDR Attributes
    //----------------------------------------------------------------------------------------------    
    .CDR_SWAP_MODE_EN                   ( 1'b0),                 
    .RXCDR_CFG0                         (16'b0000000000000000),
    .RXCDR_CFG0_GEN3                    (16'b0000000000000000),                 
    .RXCDR_CFG1                         (16'b0000000000000000),                
    .RXCDR_CFG1_GEN3                    (16'b0000000010000000),                
  //.RXCDR_CFG2                         (16'b0000011111010100),                 // PCIe Gen1/Gen2
  //.RXCDR_CFG2                         (16'b0000011111010110),                 // PCIe Gen1/Gen2
    .RXCDR_CFG2                         ((PHY_MAX_SPEED < 3) ? 16'b0000011101100110 : 16'b0000011101010110),                 // PCIe Gen1/Gen2
                 
  //.RXCDR_CFG2_GEN3                    (16'b0000011111100111),                 // 1 - 07E7 - P - Default
  //.RXCDR_CFG2_GEN3                    (16'b0000011111110111),                 // 2 - 07F7 - P - GT Wizard Week 1
  //.RXCDR_CFG2_GEN3                    (16'b0000011111110101),                 // 3 - 07F5 - F - Generic 8G JTOL
  //.RXCDR_CFG2_GEN3                    (16'b0000011111100100),                 // 4 - 07E4 - F - GT Wizard Week 2
    .RXCDR_CFG2_GEN3                    (16'b0000011111100110),                 // 5 - 07E6 - P - GT Wizard Week 2 Modified
  //.RXCDR_CFG2_GEN3                    (16'b0000011111010101),                 // 6 - 07D5 - F - Gen3 JTOL
  //.RXCDR_CFG2_GEN3                    (16'b0000011111010110),                 // 7 - 07D6 - F - Gen3 JTOL Modified
  //.RXCDR_CFG2_GEN3                    (16'b0000011101100110),                 // 8 - 0766 - F - 2014.1 Feb 3
    
    .RXCDR_CFG3                         (16'b0000000000000000),
    .RXCDR_CFG3_GEN3                    (16'b0000000000000000),
    .RXCDR_CFG4                         (16'b0000000000000000),
    .RXCDR_CFG4_GEN3                    (16'b0000000000000000),
    .RXCDR_CFG5                         (16'b0000000000000000),
    .RXCDR_CFG5_GEN3                    (16'b0000000000000000),
    .RXCDR_LOCK_CFG0                    (16'b0100010010000000),
    .RXCDR_LOCK_CFG1                    (16'b0101111111111111),
    .RXCDR_LOCK_CFG2                    (16'b0111011111000011),                 
    .RX_WIDEMODE_CDR                    (1'b0),                              

    //---------------------------------------------------------------------------------------------- 
    //  Eye Scan Attributes
    //----------------------------------------------------------------------------------------------
    .ES_CLK_PHASE_SEL                   (1'b0),                           
    .ES_CONTROL                         (6'b000000),                      
    .ES_ERRDET_EN                       ("FALSE"),                        
    .ES_EYE_SCAN_EN                     ("FALSE"),                        
    .ES_HORZ_OFFSET                     (12'b000000000000),               
    .ES_PMA_CFG                         (10'b0000000000),                 
    .ES_PRESCALE                        (5'b00000),                       
    .ES_QUALIFIER0                      (16'b0000000000000000),           
    .ES_QUALIFIER1                      (16'b0000000000000000),           
    .ES_QUALIFIER2                      (16'b0000000000000000),           
    .ES_QUALIFIER3                      (16'b0000000000000000),           
    .ES_QUALIFIER4                      (16'b0000000000000000),           
    .ES_QUAL_MASK0                      (16'b0000000000000000),           
    .ES_QUAL_MASK1                      (16'b0000000000000000),           
    .ES_QUAL_MASK2                      (16'b0000000000000000),           
    .ES_QUAL_MASK3                      (16'b0000000000000000),           
    .ES_QUAL_MASK4                      (16'b0000000000000000),           
    .ES_SDATA_MASK0                     (16'b0000000000000000),           
    .ES_SDATA_MASK1                     (16'b0000000000000000),           
    .ES_SDATA_MASK2                     (16'b0000000000000000),           
    .ES_SDATA_MASK3                     (16'b0000000000000000),           
    .ES_SDATA_MASK4                     (16'b0000000000000000),           
    .EYE_SCAN_SWAP_EN                   ( 1'b0),
    .RX_EYESCAN_VS_CODE                 ( 7'b0000000),
    .RX_EYESCAN_VS_NEG_DIR              ( 1'b0),
    .RX_EYESCAN_VS_RANGE                ( 2'b00),
    .RX_EYESCAN_VS_UT_SIGN              ( 1'b0),                        
  
    //----------------------------------------------------------------------------------------------
    //  Loopback & PRBS Attributes
    //----------------------------------------------------------------------------------------------
    .RXPRBS_ERR_LOOPBACK                ( 1'b0),     
    .RXPRBS_LINKACQ_CNT                 (15),                                                   
                                                                                                    
    //----------------------------------------------------------------------------------------------   
    //  Digital Monitor Attribute
    //----------------------------------------------------------------------------------------------                     
    .DMONITOR_CFG0                      (10'b0000000000),                                                  
    .DMONITOR_CFG1                      ( 8'b00000000),                                                   
                                                      
    //----------------------------------------------------------------------------------------------   
    //  AC JTAG Attributes
    //----------------------------------------------------------------------------------------------                     
    .ACJTAG_DEBUG_MODE                  ( 1'b0),                                                        
    .ACJTAG_MODE                        ( 1'b0),                                                        
    .ACJTAG_RESET                       ( 1'b0),      
    
    //---------------------------------------------------------------------------------------------- 
    //  SATA Attributes
    //---------------------------------------------------------------------------------------------- 
    .SAS_MAX_COM                        (64),
    .SAS_MIN_COM                        (36),
    .SATA_BURST_SEQ_LEN                 (4'b1111),
    .SATA_BURST_VAL                     (3'b100),
    .SATA_CPLL_CFG                      ("VCO_3000MHZ"),
    .SATA_EIDLE_VAL                     (3'b100),
    .SATA_MAX_BURST                     ( 8),
    .SATA_MAX_INIT                      (21),
    .SATA_MAX_WAKE                      ( 7),
    .SATA_MIN_BURST                     ( 4),
    .SATA_MIN_INIT                      (12),
    .SATA_MIN_WAKE                      ( 4),  
  
    //----------------------------------------------------------------------------------------------
    //  Summer Attributes
    //----------------------------------------------------------------------------------------------
    .RX_SUM_DFETAPREP_EN                ( 1'b0),
    .RX_SUM_IREF_TUNE                   ((PHY_MAX_SPEED < 3) ? 4'b1100 : 4'b0000),
    .RX_SUM_RES_CTRL                    ((PHY_MAX_SPEED < 3) ? 2'b11   : 2'b00  ),
    .RX_SUM_VCMTUNE                     ( 4'b0000),
    .RX_SUM_VCM_OVWR                    ( 1'b0),
    .RX_SUM_VREF_TUNE                   ( 3'b000),

    //----------------------------------------------------------------------------------------------
    //  MISC Attributes
    //----------------------------------------------------------------------------------------------                 
    .A_RXOSCALRESET                     ( 1'b0),   
    .ADAPT_CFG0                         (16'b1111100000000000),
    .ADAPT_CFG1                         (16'b0000000000000000),                             
    .DDI_CTRL                           ( 2'b00),
    .DDI_REALIGN_WAIT                   (15),
    .EVODD_PHI_CFG                      (11'b00000000000),     
    .GM_BIAS_SELECT                     ( 1'b0),     
    .PROCESS_PAR                        ( 3'b010), 
    .RX_CAPFF_SARC_ENB                  ( 1'b0),    
    .RX_DDI_SEL                         ( 6'b000000),  
    .RX_EN_HI_LR                        ( 1'b0),
    .TAPDLY_SET_TX                      ( 2'b00),
    .TEMPERATUR_PAR                     ( 4'b0010),
    .TST_RSV0                           ( 8'b00000000),                                                        
    .TST_RSV1                           ( 8'b00000000),
    .TX_DCD_CFG                         ( 6'b000010),
    .TX_DCD_EN                          ( 1'b0),
    .TX_EML_PHI_TUNE                    ( 1'b0),
    .TX_MODE_SEL                        ( 3'b000),
    .TX_PMADATA_OPT                     ( 1'b0),
    .TX_SARC_LPBK_ENB                   ( 1'b0),
    .WB_MODE                            ( 2'b00)                                                                         
)                                                                                                   
gthe3_channel_i                                                                                     
(                                                                                                                                                                                                   
    //----------------------------------------------------------------------------------------------
    //  Clock Ports
    //----------------------------------------------------------------------------------------------
    .GTGREFCLK                          ( 1'd0),                                                     
    .GTREFCLK0                          (GT_GTREFCLK0),                                            
    .GTREFCLK1                          ( 1'd0),                                                    
    .GTNORTHREFCLK0                     ( 1'd0),                                                    
    .GTNORTHREFCLK1                     ( 1'd0),                                                    
    .GTSOUTHREFCLK0                     ( 1'd0),                                                    
    .GTSOUTHREFCLK1                     ( 1'd0),                                             
    .TXUSRCLK                           (GT_TXUSRCLK),                                              
    .RXUSRCLK                           (GT_RXUSRCLK),                                              
    .TXUSRCLK2                          (GT_TXUSRCLK2),                                             
    .RXUSRCLK2                          (GT_RXUSRCLK2),  
    .TXPLLCLKSEL                        (PLLCLKSEL),            
    .RXPLLCLKSEL                        (PLLCLKSEL),                                                    
    .TXSYSCLKSEL                        (SYSCLKSEL),                                             
    .RXSYSCLKSEL                        (SYSCLKSEL),                             
    .TXOUTCLKSEL                        ( GTHE3_TXOUTCLKSEL_OUT), //3'd5        // select TXPROGDIVCLK
    .RXOUTCLKSEL                        ( 3'd2),                                // select RXOUTCLKPMA      
    .CLKRSVD0                           ( 1'd0),          
    .CLKRSVD1                           ( 1'd0),                                                 
                                                                                                   
    .TXOUTCLK                           (GT_TXOUTCLK),                                             
    .RXOUTCLK                           (GT_RXOUTCLK),                                                        
    .TXOUTCLKFABRIC                     (),                                                        
    .RXOUTCLKFABRIC                     (),                                                        
    .TXOUTCLKPCS                        (),                                                        
    .RXOUTCLKPCS                        (),  
    .RXRECCLKOUT                        (GT_RXRECCLKOUT),                                                    
    .GTREFCLKMONITOR                    (),                                                    
    
    //----------------------------------------------------------------------------------------------
    //  BUFG_GT Controller Ports
    //----------------------------------------------------------------------------------------------
    .BUFGTCE                            (GT_BUFGTCE),      
    .BUFGTCEMASK                        (GT_BUFGTCEMASK), 
    .BUFGTRSTMASK                       (GT_BUFGTRSTMASK),
    .BUFGTRESET                         (GT_BUFGTRESET), 
    .BUFGTDIV                           (GT_BUFGTDIV),        
    
    //----------------------------------------------------------------------------------------------
    //  CPLL Ports
    //----------------------------------------------------------------------------------------------
    .CPLLLOCKDETCLK                     ( 1'd0),                              
    .CPLLLOCKEN                         ( 1'd1),    
    .CPLLPD                             (GT_CPLLPD),    
    .CPLLREFCLKSEL                      (CPLLREFCLKSEL),                        // 3'd1 = select GTREFCLK0         
    .CPLLRESET                          (GT_CPLLRESET),                               
  
    .CPLLFBCLKLOST                      (),     
    .CPLLLOCK                           (GT_CPLLLOCK),                                            
    .CPLLREFCLKLOST                     (),                                                                                                         
             
    //----------------------------------------------------------------------------------------------
    //  QPLL Ports                                                                                   
    //----------------------------------------------------------------------------------------------
    .QPLL0CLK                           ( 1'b0),  
    .QPLL0REFCLK                        ( 1'b0),         
    .QPLL1CLK                           (GT_QPLLCLK),  
    .QPLL1REFCLK                        (GT_QPLLREFCLK),           
    
    //----------------------------------------------------------------------------------------------
    //  Reset Ports
    //----------------------------------------------------------------------------------------------                                                                                                                             
    .GTTXRESET                          (GT_GTTXRESET),                                             
    .GTRXRESET                          (GT_GTRXRESET),  
    .TXPROGDIVRESET                     (GT_TXPROGDIVRESET),                       
    .RXPROGDIVRESET                     (GT_RXPROGDIVRESET),                                                                            
    .TXPMARESET                         ( 1'd0),                                            
    .RXPMARESET                         ( 1'd0),                                            
    .TXPCSRESET                         ( 1'd0),   
    .RXPCSRESET                         ( 1'd0),   
    .TXUSERRDY                          (GT_TXUSERRDY),                                             
    .RXUSERRDY                          (GT_RXUSERRDY),   
    .CFGRESET                           ( 1'd0),                                                    
    .GTRESETSEL                         ( 1'd0),  
    .RESETOVRD                          ( 1'd0),  
    .RSTCLKENTX                         ( 1'd0),   
    .RXOOBRESET                         ( 1'd0),                                              
                                           
    .GTPOWERGOOD                        (GT_GTPOWERGOOD), 
    .TXPRGDIVRESETDONE                  (GT_TXPROGDIVRESETDONE),
    .RXPRGDIVRESETDONE                  (GT_RXPROGDIVRESETDONE),        
    .RXPMARESETDONE                     (GT_RXPMARESETDONE),                                                
    .TXPMARESETDONE                     (),                                                          
    .TXRESETDONE                        (GT_TXRESETDONE),                                           
    .RXRESETDONE                        (GT_RXRESETDONE),  
    .RXCDRPHDONE                        (),
    .RESETEXCEPTION                     (),

    //----------------------------------------------------------------------------------------------
    //  PCIe Ports
    //----------------------------------------------------------------------------------------------
    .PCIERSTIDLE                        (GT_PCIERSTIDLE),        
    .PCIERSTTXSYNCSTART                 (GT_PCIERSTTXSYNCSTART), 
    .PCIEEQRXEQADAPTDONE                (GT_PCIEEQRXEQADAPTDONE),
    .PCIEUSERRATEDONE                   (GT_PCIEUSERRATEDONE),
             
    .PCIEUSERPHYSTATUSRST               (GT_PCIEUSERPHYSTATUSRST),    
    .PCIERATEQPLLPD                     (GT_PCIERATEQPLLPD),                    
    .PCIERATEQPLLRESET                  (GT_PCIERATEQPLLRESET),                 
    .PCIERATEIDLE                       (GT_PCIERATEIDLE),            
    .PCIESYNCTXSYNCDONE                 (GT_PCIESYNCTXSYNCDONE),                          
    .PCIERATEGEN3                       (pcierategen3),    
    .PCIEUSERGEN3RDY                    (GT_PCIEUSERGEN3RDY),   
    .PCIEUSERRATESTART                  (GT_PCIEUSERRATESTART),    
           
    //----------------------------------------------------------------------------------------------
    //  Serial Line Ports
    //----------------------------------------------------------------------------------------------
    .GTHRXP                             (GT_RXP),                                                   
    .GTHRXN                             (GT_RXN),   
   
    .GTHTXP                             (GT_TXP),                                                 
    .GTHTXN                             (GT_TXN),   

    //----------------------------------------------------------------------------------------------
    //  TX Data Ports
    //----------------------------------------------------------------------------------------------
    .TXDATA                             (txdata),                                     
    .TXCTRL0                            (txctrl0),
    .TXCTRL1                            (txctrl1),  
    .TXCTRL2                            (txctrl2),
    .TXDATAEXTENDRSVD                   ( 8'd0),                                

    //----------------------------------------------------------------------------------------------
    //  RX Data Ports
    //----------------------------------------------------------------------------------------------
    .RXDATA                             (rxdata),                                                    
    .RXCTRL0                            (rxctrl0),   
    .RXCTRL1                            (), 
    .RXCTRL2                            (),
    .RXCTRL3                            (), 
    .RXDATAEXTENDRSVD                   (),                                     
 
    //----------------------------------------------------------------------------------------------
    //  PHY Command Ports
    //----------------------------------------------------------------------------------------------
    .TXDETECTRX                         (GT_TXDETECTRX),                                            
    .TXELECIDLE                         (GT_TXELECIDLE),                                      
    .TXPDELECIDLEMODE                   ( 1'd0),                                                                                 
    .RXELECIDLEMODE                     ( 2'd0),                                // PCIe
    .SIGVALIDCLK                        ( 1'd0),                                                                                    
    .TXPOLARITY                         ( 1'd0),                                              
    .RXPOLARITY                         (GT_RXPOLARITY),                                
    .TXPD                               (GT_POWERDOWN),                                           
    .RXPD                               (GT_POWERDOWN),                                           
    .TXRATE                             ({1'd0, GT_RATE}),                                                
    .RXRATE                             ({1'd0, GT_RATE}),                                                
    .TXRATEMODE                         ( 1'd0),                                                    
    .RXRATEMODE                         ( 1'd0),                                                    
 
    //----------------------------------------------------------------------------------------------
    //  PHY Status Ports
    //----------------------------------------------------------------------------------------------
    .RXVALID                            (GT_RXVALID),                                              
    .PHYSTATUS                          (GT_PHYSTATUS),                                            
    .RXELECIDLE                         (GT_RXELECIDLE),                                           
    .RXSTATUS                           (GT_RXSTATUS),                                             
    .TXRATEDONE                         (),                                           
    .RXRATEDONE                         (),                  
 
    //----------------------------------------------------------------------------------------------
    //  TX Driver Ports
    //----------------------------------------------------------------------------------------------
    .TXMARGIN                           (GT_TXMARGIN),                                           
    .TXSWING                            (GT_TXSWING),                                            
    .TXDEEMPH                           (GT_TXDEEMPH),                                           
    .TXBUFDIFFCTRL                      ( 3'b000),                             
    .TXDIFFCTRL                         ( 4'b1100),                         // ***
    .TXDIFFPD                           ( 1'd0),            

    //----------------------------------------------------------------------------------------------
    //  TX Driver Ports (Gen3)
    //----------------------------------------------------------------------------------------------
    .TXPRECURSOR                        (GT_TXPRECURSOR),                                          
    .TXMAINCURSOR                       (GT_TXMAINCURSOR),                                         
    .TXPOSTCURSOR                       (GT_TXPOSTCURSOR),                                         
    .TXPRECURSORINV                     (1'd0),                                                    
    .TXPOSTCURSORINV                    (1'd0),                                             

    //----------------------------------------------------------------------------------------------
    //  PCS Ports
    //---------------------------------------------------------------------------------------------- 
    .PCSRSVDIN                          ({14'd0, GT_MASTER_CPLLLOCK, GT_QPLLLOCK}),                                        
    .PCSRSVDIN2                         ( 5'd0),                                                  

    .PCSRSVDOUT                         (pcsrsvdout),     

    //----------------------------------------------------------------------------------------------
    //  PMA Ports                                                                             
    //----------------------------------------------------------------------------------------------
    .PMARSVDIN                          ( 5'd0),                                                    

    //----------------------------------------------------------------------------------------------
    //  TX QPI Ports
    //----------------------------------------------------------------------------------------------
    .TXQPIBIASEN                        ( 1'd0),                                                    
    .TXQPISTRONGPDOWN                   ( 1'd0),                                                    
    .TXQPIWEAKPUP                       ( 1'd0),   
                                                                                                    
    .TXQPISENP                          (),                                                         
    .TXQPISENN                          (),   
    
    //----------------------------------------------------------------------------------------------
    //  RX QPI Ports
    //----------------------------------------------------------------------------------------------    
    .RXQPIEN                            ( 1'd0), 
                   
    .RXQPISENP                          (),                                                         
    .RXQPISENN                          (),  
    
    //----------------------------------------------------------------------------------------------
    //  RX Monitor Ports
    //----------------------------------------------------------------------------------------------
    .RXMONITORSEL                       (2'd0), 
    .RXMONITOROUT                       (),                                                                                                                                                                                                            
                                                                 
    //----------------------------------------------------------------------------------------------
    //  Comma Detect & Align Ports
    //----------------------------------------------------------------------------------------------
    .RXCOMMADETEN                       ( 1'd1),                  
    .RXMCOMMAALIGNEN                    (!pcierategen3),          
    .RXPCOMMAALIGNEN                    (!pcierategen3),          
                                                                                 
    .RXCOMMADET                         (GT_RXCOMMADET),                                            
    .RXBYTEISALIGNED                    (),                                        
    .RXBYTEREALIGN                      (),                                                                                                                 
                                                                                                    
    //----------------------------------------------------------------------------------------------
    // 8B10B Ports
    //----------------------------------------------------------------------------------------------
    .TX8B10BBYPASS                      ( 8'd0),                                                  
    .TX8B10BEN                          (!pcierategen3),                            
    .RX8B10BEN                          (!pcierategen3),                            
           
    //----------------------------------------------------------------------------------------------
    //  TX Buffer Ports
    //----------------------------------------------------------------------------------------------
    .TXBUFSTATUS                        (),                                                        
                                                                                                    
    //----------------------------------------------------------------------------------------------
    //  RX Buffer Ports
    //----------------------------------------------------------------------------------------------
    .RXBUFRESET                         ( 1'd0),                                          
    .RXBUFSTATUS                        (GT_RXBUFSTATUS),                
                      
    //----------------------------------------------------------------------------------------------
    //  Clock Correction Ports
    //----------------------------------------------------------------------------------------------
    .RXCLKCORCNT                        (),                            
                    
    //----------------------------------------------------------------------------------------------
    //  Channel Bonding Ports (disable)
    //----------------------------------------------------------------------------------------------
    .RXCHBONDEN                         ( 1'd0),                                         
    .RXCHBONDI                          ( 5'd0),                                         
    .RXCHBONDLEVEL                      ( 3'd0),                                         
    .RXCHBONDMASTER                     ( 1'd0),                                         
    .RXCHBONDSLAVE                      ( 1'd0),                                         
                                                                                    
    .RXCHANBONDSEQ                      (),                                         
    .RXCHANISALIGNED                    (),                                         
    .RXCHANREALIGN                      (),                                         
    .RXCHBONDO                          (),                                                                                                                                                                       
 
    //----------------------------------------------------------------------------------------------
    //  TX Phase Alignment Ports
    //----------------------------------------------------------------------------------------------
    .TXPHALIGN                          ( 1'd0),
    .TXPHALIGNEN                        ( 1'd0),
    .TXPHDLYPD                          ( 1'd0),
    .TXPHDLYRESET                       ( 1'd0),
    .TXPHDLYTSTCLK                      ( 1'd0),
    .TXPHINIT                           ( 1'd0),
    .TXPHOVRDEN                         ( 1'd0),
   
    .TXPHALIGNDONE                      (GT_TXPHALIGNDONE),
    .TXPHINITDONE                       (GT_TXPHINITDONE),
   
    //----------------------------------------------------------------------------------------------
    //  TX Delay Alignment Ports
    //----------------------------------------------------------------------------------------------
    .TXDLYBYPASS                        ( 1'd0),
    .TXDLYEN                            ( 1'd0),
    .TXDLYHOLD                          ( 1'd0),
    .TXDLYOVRDEN                        ( 1'd0),
    .TXDLYSRESET                        ( 1'd0),
    .TXDLYUPDOWN                        ( 1'd0),
       
    .TXDLYSRESETDONE                    (GT_TXDLYSRESETDONE),       
          
    //----------------------------------------------------------------------------------------------
    //  TX Auto Sync Alignment Ports 
    //----------------------------------------------------------------------------------------------
    .TXSYNCALLIN                        (GT_TXSYNCALLIN),
    .TXSYNCIN                           (GT_TXSYNCIN),
    .TXSYNCMODE                         (MASTER_LANE),                                         
                
    .TXSYNCDONE                         (),
    .TXSYNCOUT                          (GT_TXSYNCOUT),

    //----------------------------------------------------------------------------------------------
    //  RX Phase Alignment Ports 
    //----------------------------------------------------------------------------------------------
    .RXPHALIGN                          ( 1'd0),
    .RXPHALIGNEN                        ( 1'd0),
    .RXPHDLYPD                          ( 1'd0),
    .RXPHDLYRESET                       ( 1'd0),
    .RXPHOVRDEN                         ( 1'd0),
   
    .RXPHALIGNDONE                      (GT_RXPHALIGNDONE),
    .RXPHALIGNERR                       (),
       
    //----------------------------------------------------------------------------------------------
    //  RX Delay Alignment Ports
    //----------------------------------------------------------------------------------------------
    .RXDLYBYPASS                        ( 1'd1),
    .RXDLYEN                            ( 1'd0),
    .RXDLYOVRDEN                        ( 1'd0),
    .RXDLYSRESET                        ( 1'd0),
   
    .RXDLYSRESETDONE                    (GT_RXDLYSRESETDONE),                                           
        
    //----------------------------------------------------------------------------------------------
    //  RX Auto Sync Alignment Ports 
    //----------------------------------------------------------------------------------------------
    .RXSYNCALLIN                        ( 1'd0),
    .RXSYNCIN                           ( 1'd0),
    .RXSYNCMODE                         ( 1'd0),                                                    
                                                                                                    
    .RXSYNCDONE                         (GT_RXSYNCDONE),                                                
    .RXSYNCOUT                          (),    
       
    //----------------------------------------------------------------------------------------------
    //  Gearbox Ports 
    //----------------------------------------------------------------------------------------------
    .TXHEADER                           ( 6'd0), 
    .TXLATCLK                           ( 1'd0),                                                    
    .TXSEQUENCE                         ( 7'd0),                                                    
    .RXGEARBOXSLIP                      ( 1'd0),  
    .RXLATCLK                           ( 1'd0),  
    .RXSLIDE                            ( 1'd0),                                                    
                                                                                                    
    .RXDATAVALID                        (),                 
    .RXHEADER                           (),                                                         
    .RXHEADERVALID                      (), 
    .RXSLIDERDY                         (),                                                         
    .RXSTARTOFSEQ                       (),                             
                   
    //----------------------------------------------------------------------------------------------
    //  RX Slip Ports 
    //----------------------------------------------------------------------------------------------
    .RXSLIPOUTCLK                       ( 1'd0),
    .RXSLIPPMA                          ( 1'd0),   
                                                                   
    .RXSLIPDONE                         (),     
    .RXSLIPOUTCLKRDY                    (),
    .RXSLIPPMARDY                       (),             
       
    //----------------------------------------------------------------------------------------------
    //  RX LPM Ports 
    //----------------------------------------------------------------------------------------------
    .RXLPMEN                            (!pcierategen3),    
    .RXLPMGCHOLD                        ( 1'b0),            
    .RXLPMGCOVRDEN                      ( 1'b0),
    .RXLPMHFHOLD                        ( 1'b0),            
    .RXLPMHFOVRDEN                      ( 1'b0),
    .RXLPMLFHOLD                        ( 1'b0),         
    .RXLPMLFKLOVRDEN                    ( 1'b0), 
    .RXLPMOSHOLD                        ( 1'b0),            
    .RXLPMOSOVRDEN                      ( 1'b0),
                                                                                                    
    //----------------------------------------------------------------------------------------------
    //  RX DFE Ports
    //----------------------------------------------------------------------------------------------
    .RXDFEAGCCTRL                       ( 2'b01),                               // ***
    .RXDFEAGCHOLD                       ( 1'b0),            
    .RXDFEAGCOVRDEN                     ( 1'b0),
    .RXDFELFHOLD                        ( 1'b0),          
    .RXDFELFOVRDEN                      ( 1'b0),
    .RXDFELPMRESET                      ( 1'b0),
    .RXDFETAP2HOLD                      ( 1'b0),
    .RXDFETAP2OVRDEN                    ( 1'b0),
    .RXDFETAP3HOLD                      ( 1'b0),
    .RXDFETAP3OVRDEN                    ( 1'b0),
    .RXDFETAP4HOLD                      ( 1'b0),
    .RXDFETAP4OVRDEN                    ( 1'b0),
    .RXDFETAP5HOLD                      ( 1'b0),
    .RXDFETAP5OVRDEN                    ( 1'b0),
    .RXDFETAP6HOLD                      ( 1'b0),
    .RXDFETAP6OVRDEN                    ( 1'b0),
    .RXDFETAP7HOLD                      ( 1'b0),
    .RXDFETAP7OVRDEN                    ( 1'b0),
    .RXDFETAP8HOLD                      ( 1'b0),
    .RXDFETAP8OVRDEN                    ( 1'b0),
    .RXDFETAP9HOLD                      ( 1'b0),
    .RXDFETAP9OVRDEN                    ( 1'b0),
    .RXDFETAP10HOLD                     ( 1'b0),
    .RXDFETAP10OVRDEN                   ( 1'b0),
    .RXDFETAP11HOLD                     ( 1'b0),
    .RXDFETAP11OVRDEN                   ( 1'b0),
    .RXDFETAP12HOLD                     ( 1'b0),
    .RXDFETAP12OVRDEN                   ( 1'b0),
    .RXDFETAP13HOLD                     ( 1'b0),
    .RXDFETAP13OVRDEN                   ( 1'b0),
    .RXDFETAP14HOLD                     ( 1'b0),
    .RXDFETAP14OVRDEN                   ( 1'b0),
    .RXDFETAP15HOLD                     ( 1'b0),
    .RXDFETAP15OVRDEN                   ( 1'b0),
    .RXDFEUTHOLD                        ( 1'b0),
    .RXDFEUTOVRDEN                      ( 1'b0),
    .RXDFEVPHOLD                        ( 1'b0),
    .RXDFEVPOVRDEN                      ( 1'b0),
    .RXDFEVSEN                          ( 1'b0),
    .RXDFEXYDEN                         ( 1'b1),                                //                                                                    
    
    //----------------------------------------------------------------------------------------------
    //  TX PI Ports
    //----------------------------------------------------------------------------------------------
    .TXPIPPMEN                          ( 1'd0),
    .TXPIPPMOVRDEN                      ( 1'd0),
    .TXPIPPMPD                          ( 1'd0),
    .TXPIPPMSEL                         ( 1'd0),
    .TXPIPPMSTEPSIZE                    ( 5'd0),
    .TXPISOPD                           ( 1'd0),   
    
    //----------------------------------------------------------------------------------------------
    //  RX CDR Ports
    //----------------------------------------------------------------------------------------------
    .RXCDRFREQRESET                     ( 1'd0),
    .RXCDRHOLD                          (GT_RXCDRHOLD),
    .RXCDROVRDEN                        ( 1'd0),
    .RXCDRRESET                         ( 1'd0),
    .RXCDRRESETRSV                      ( 1'd0),
    
    .RXCDRLOCK                          (GT_RXCDRLOCK),     
       
    //----------------------------------------------------------------------------------------------
    //  Eye Scan Ports
    //----------------------------------------------------------------------------------------------
    .EYESCANMODE                        ( 1'd0),                                             
    .EYESCANRESET                       ( 1'd0),                                             
    .EYESCANTRIGGER                     ( 1'd0),                                             
                                                                                            
    .EYESCANDATAERROR                   (GT_EYESCANDATAERROR),           
       
    //----------------------------------------------------------------------------------------------
    //  RX OS Ports
    //----------------------------------------------------------------------------------------------
    .RXOSCALRESET                       ( 1'b0),
    .RXOSHOLD                           ( 1'b0),
    .RXOSINTCFG                         ( 4'b1101),                              // ***                                                  
    .RXOSINTEN                          ( 1'b1),                                
    .RXOSINTHOLD                        ( 1'b0),
    .RXOSINTOVRDEN                      ( 1'b0),
    .RXOSINTSTROBE                      ( 1'b0),
    .RXOSINTTESTOVRDEN                  ( 1'b0),
    .RXOSOVRDEN                         ( 1'b0),    
 
    .RXOSINTDONE                        (),                                                         
    .RXOSINTSTARTED                     (),                                                         
    .RXOSINTSTROBEDONE                  (),                                                         
    .RXOSINTSTROBESTARTED               (),         
           
    //----------------------------------------------------------------------------------------------
    //  DRP Ports
    //----------------------------------------------------------------------------------------------
    .DRPCLK                             (GT_DRPCLK ),
    .DRPADDR                            (GT_DRPADDR),
    .DRPEN                              (GT_DRPEN  ),
    .DRPWE                              (GT_DRPWE  ),
    .DRPDI                              (GT_DRPDI  ),
                                            
    .DRPRDY                             (GT_DRPRDY ),
    .DRPDO                              (GT_DRPDO  ),
    //----------------------------------------------------------------------------------------------
    //  Loopback & PRBS Ports
    //----------------------------------------------------------------------------------------------
    .LOOPBACK                           (GT_LOOPBACK), 
    .TXPRBSSEL                          (GT_PRBSSEL),                                                    
    .RXPRBSSEL                          (GT_PRBSSEL),  
    .TXPRBSFORCEERR                     (GT_TXPRBSFORCEERR),  
    .TXINHIBIT                          (GT_TXINHIBIT),  
    .RXPRBSCNTRESET                     (GT_RXPRBSCNTRESET),                                                                                                      

    .RXPRBSERR                          (GT_RXPRBSERR),                                                
    .RXPRBSLOCKED                       (GT_RXPRBSLOCKED),       

    //----------------------------------------------------------------------------------------------
    //  Digital Monitor Ports                                                                             
    //----------------------------------------------------------------------------------------------
    .DMONFIFORESET                      ( 1'd0),                                                    
    .DMONITORCLK                        ( 1'd0),                                                    
    
    .DMONITOROUT                        (GT_DMONITOROUT),                
      
   //----------------------------------------------------------------------------------------------
    //  SATA Ports 
    //----------------------------------------------------------------------------------------------
    .TXCOMINIT                          ( 1'd0),                                                    
    .TXCOMSAS                           ( 1'd0),                                                    
    .TXCOMWAKE                          ( 1'd0),                                                    

    .TXCOMFINISH                        (),                                                         
    .RXCOMINITDET                       (),                                                         
    .RXCOMSASDET                        (),                                                         
    .RXCOMWAKEDET                       (),        

    //----------------------------------------------------------------------------------------------
    //  EVO Ports
    //----------------------------------------------------------------------------------------------
    .EVODDPHICALDONE                    ( 1'd0), 
    .EVODDPHICALSTART                   ( 1'd0),
    .EVODDPHIDRDEN                      ( 1'd0),   
    .EVODDPHIDWREN                      ( 1'd0),   
    .EVODDPHIXRDEN                      ( 1'd0),   
    .EVODDPHIXWREN                      ( 1'd0),                                                   

    //----------------------------------------------------------------------------------------------
    //  MISC Ports
    //----------------------------------------------------------------------------------------------
    .GTRSVD                             (16'd0),
    .LPBKRXTXSEREN                      ( 1'd0),
    .LPBKTXRXSEREN                      ( 1'd0),
    .TSTIN                              (20'h00000),                                                // ***                          
                                                                                                    
    .PINRSRVDAS                         ()                                      
);
  
    
    
//--------------------------------------------------------------------------------------------------
//  Input Port Remapping
//--------------------------------------------------------------------------------------------------    
assign txdata[ 31: 0] = GT_TXDATA;
assign txdata[127:32] = 96'd0;

assign txctrl0[ 1:0] = 2'd0;
assign txctrl0[   2] = GT_TXDATA_VALID;
assign txctrl0[   3] = GT_TXSTART_BLOCK;
assign txctrl0[ 5:4] = GT_TXSYNC_HEADER;
assign txctrl0[15:6] = 10'd0;

assign txctrl1[   0] = GT_TXCOMPLIANCE;
assign txctrl1[15:1] = 15'd0;

assign txctrl2[ 1:0] = GT_TXDATAK;
assign txctrl2[ 7:2] = 6'd0;



//--------------------------------------------------------------------------------------------------
//  GT Channel Outputs
//--------------------------------------------------------------------------------------------------
assign GT_RXDATA             = rxdata[31:0];

assign GT_RXDATAK            = rxctrl0[1:0];
assign GT_RXDATA_VALID       = rxctrl0[2];
assign GT_RXSTART_BLOCK      = rxctrl0[3];
assign GT_RXSYNC_HEADER      = rxctrl0[5:4];

assign GT_PCIERATEGEN3       = pcierategen3;
assign GT_QPLLRATE           = pcsrsvdout[2:0];

endmodule

//--------------------------------------------------------------------------------------------------
//  GT Common Module
//--------------------------------------------------------------------------------------------------
module rp_gt_common #
(
    parameter         PHY_SIM_EN      = "FALSE", 
    parameter integer PHY_REFCLK_FREQ = 0,
    parameter         GT_QUAD_NUM     = 0       
)
(    
    //----------------------------------------------------------------------------------------------
    //  Clock Ports
    //----------------------------------------------------------------------------------------------
    input                               GTCOM_REFCLK,
    
    output                              GTCOM_QPLL1OUTCLK,
    output                              GTCOM_QPLL1OUTREFCLK,
    output                              GTCOM_QPLL1LOCK,
    
    //----------------------------------------------------------------------------------------------
    //  Reset Ports
    //----------------------------------------------------------------------------------------------
    input                               GTCOM_QPLL1PD,
    input                               GTCOM_QPLL1RESET,
            
    //----------------------------------------------------------------------------------------------
    //  Common Ports
    //----------------------------------------------------------------------------------------------
    input       [2:0]                   GTCOM_QPLLRATE,
    
    //----------------------------------------------------------------------------------------------
    //  DRP Ports
    //----------------------------------------------------------------------------------------------
    input                               GTCOM_DRPCLK,                                        
    input       [ 8:0]                  GTCOM_DRPADDR,                                       
    input                               GTCOM_DRPEN,                                             
    input                               GTCOM_DRPWE,     
    input       [15:0]                  GTCOM_DRPDI,                                      
                                                                
    output                              GTCOM_DRPRDY,    
    output      [15:0]                  GTCOM_DRPDO
);


    //----------------------------------------------------------------------------------------------
    //  Single vs. Mulit-lane Selection
    //----------------------------------------------------------------------------------------------
  //localparam [ 2:0] QPLLREFCLKSEL  = (GT_QUAD_NUM == 0) ? 3'd1 : (PHY_SIM_EN : 3'd1 : 3'd5);      // *** GTH 1.0 ***
    localparam [ 2:0] QPLLREFCLKSEL  = 3'd1;                                                        // Default
    

    //----------------------------------------------------------------------------------------------
    //  QPLL[0/1]_FBDIV - QPLL Feedback (N) Divider (Gen1 and Gen2)
    //----------------------------------------------------------------------------------------------
    localparam [ 7:0] QPLL_FBDIV = (PHY_REFCLK_FREQ == 2) ? 8'd40 : 
                                   (PHY_REFCLK_FREQ == 1) ? 8'd80 : 8'd100;
    
    
    
    //----------------------------------------------------------------------------------------------
    //  QPLL[1/0]_FBDIV_G3 - QPLL Feedback (N) Divider (Gen3)
    //----------------------------------------------------------------------------------------------    
    localparam [ 7:0] QPLL_FBDIV_G3 = (PHY_REFCLK_FREQ == 2) ? 8'd32 : 
                                      (PHY_REFCLK_FREQ == 1) ? 8'd64 : 8'd80;
    
    

//--------------------------------------------------------------------------------------------------
//  GTH Common
//--------------------------------------------------------------------------------------------------    
GTHE3_COMMON #
(   
    //---------------------------------------------------------------------------------------------- 
    //  Simulation Attributes
    //----------------------------------------------------------------------------------------------                                                    
    .SIM_RESET_SPEEDUP                  (PHY_SIM_EN),                                                                         
    .SIM_VERSION                        ("Ver_1"),                                                                          

    //----------------------------------------------------------------------------------------------               
    //  Clock Attributes
    //----------------------------------------------------------------------------------------------               
    .RXRECCLKOUT0_SEL                   ( 2'b00),
    .RXRECCLKOUT1_SEL                   ( 2'b00),                    

    //----------------------------------------------------------------------------------------------
    //  QPLL0 Attributes 
    //----------------------------------------------------------------------------------------------     
    .QPLL0_CFG0                         (16'b0011000000011100),                
    .QPLL0_CFG1                         (16'b0000000000011000),                 
    .QPLL0_CFG1_G3                      (16'b0000000000011000),                         
    .QPLL0_CFG2                         (16'b0000000001000000),                 // [6] : 1'b1 = select lower band VCO
    .QPLL0_CFG2_G3                      (16'b0000000001000000),                 // [6] : 1'b1 = select lower band VCO
    .QPLL0_CFG3                         (16'b0000000100100000),                 
    .QPLL0_CFG4                         (16'b0000000000001001),                 
    .QPLL0_CP                           (10'b1111111111),                       // Tune for PLL BW and peaking
    .QPLL0_CP_G3                        (10'b1111111111),                       // Tune for PLL BW and peaking
    .QPLL0_FBDIV                        (QPLL_FBDIV),
    .QPLL0_FBDIV_G3                     (QPLL_FBDIV_G3),
    .QPLL0_INIT_CFG0                    (16'b0000000000000000),
    .QPLL0_INIT_CFG1                    ( 8'b00000000),
    .QPLL0_LOCK_CFG                     (16'b0010010111101000),                 // [10] : 1'b1 = enable auto VCO selection
    .QPLL0_LOCK_CFG_G3                  (16'b0010010111101000),                 // [10] : 1'b1 = enable auto VCO selection
    .QPLL0_LPF                          (10'b0000010101),                       // Tune for PLL BW and peaking     
    .QPLL0_LPF_G3                       (10'b0000010101),                       // Tune for PLL BW and peaking
    .QPLL0_REFCLK_DIV                   (1),
    .QPLL0_SDM_CFG0                     (16'b0000000000000000),
    .QPLL0_SDM_CFG1                     (16'b0000000000000000),
    .QPLL0_SDM_CFG2                     (16'b0000000000000000),   
                     
    //---------------------------------------------------------------------------------------------- 
    //  QPLL1 Attributes               
    //----------------------------------------------------------------------------------------------    
    .QPLL1_CFG0                         (16'b0011000000011100),                 
    .QPLL1_CFG1                         (16'b0000000000011000),                 
    .QPLL1_CFG1_G3                      (16'b0000000000011000),                            
    .QPLL1_CFG2                         (16'b0000000001000000),                 // [6] : 1'b1 = select lower band VCO
    .QPLL1_CFG2_G3                      (16'b0000000001000000),                 // [6] : 1'b1 = select lower band VCO
    .QPLL1_CFG3                         (16'b0000000100100000),                 
    .QPLL1_CFG4                         (16'b0000000000000000),
    .QPLL1_CP                           (10'b1111111111),                       // Tune for PLL BW and peaking
    .QPLL1_CP_G3                        (10'b1111111111),                       // Tune for PLL BW and peaking
    .QPLL1_FBDIV                        (QPLL_FBDIV),
    .QPLL1_FBDIV_G3                     (QPLL_FBDIV_G3),
    .QPLL1_INIT_CFG0                    (16'b0000000000000000),
    .QPLL1_INIT_CFG1                    ( 8'b00000000),
    .QPLL1_LOCK_CFG                     (16'b0010010111101000),                 // [10] : 1'b1 = enable auto VCO selection, 16'b0010000111101000
    .QPLL1_LOCK_CFG_G3                  (16'b0010010111101000),                 // [10] : 1'b1 = enable auto VCO selection, 16'b0010000111101000
    .QPLL1_LPF                          (10'b0000010101),                       // Tune for PLL BW and peaking     
    .QPLL1_LPF_G3                       (10'b0000010101),                       // Tune for PLL BW and peaking
    .QPLL1_REFCLK_DIV                   (1),
    .QPLL1_SDM_CFG0                     (16'b0000000000000000),
    .QPLL1_SDM_CFG1                     (16'b0000000000000000),
    .QPLL1_SDM_CFG2                     (16'b0000000000000000),
       
    //----------------------------------------------------------------------------------------------
    //  Bias Attributes                                                          
    //----------------------------------------------------------------------------------------------
    .BIAS_CFG0                          (16'b0000000000000000),
    .BIAS_CFG1                          (16'b0000000000000000),
    .BIAS_CFG2                          (16'b0011000000000000),                 // Tune for PLL BW and peaking
    .BIAS_CFG3                          (16'b0000000001000000),                 
    .BIAS_CFG4                          (16'b0000000000000000),    
    .BIAS_CFG_RSVD                      (10'b0000000000),  
       
    //---------------------------------------------------------------------------------------------- 
    //  SDM0 Attributes                                                          
    //----------------------------------------------------------------------------------------------
    .SDM0DATA1_0                        (16'b0000000000000000),
    .SDM0DATA1_1                        ( 9'b000000000),
    .SDM0INITSEED0_0                    (16'b0000000000000000),
    .SDM0INITSEED0_1                    ( 9'b000000000),
    .SDM0_DATA_PIN_SEL                  ( 1'b0),
    .SDM0_WIDTH_PIN_SEL                 ( 1'b0),
    
    //---------------------------------------------------------------------------------------------- 
    //  SDM0 Attributes                                                          
    //----------------------------------------------------------------------------------------------     
    .SDM1DATA1_0                        (16'b0000000000000000),
    .SDM1DATA1_1                        ( 9'b000000000),
    .SDM1INITSEED0_0                    (16'b0000000000000000),
    .SDM1INITSEED0_1                    ( 9'b000000000),     
    .SDM1_DATA_PIN_SEL                  ( 1'b0),
    .SDM1_WIDTH_PIN_SEL                 ( 1'b0),                              
          
    //----------------------------------------------------------------------------------------------
    //  MISC Attributes                                                         
    //----------------------------------------------------------------------------------------------            
    .COMMON_CFG0                        (16'b0000000000000000),
    .COMMON_CFG1                        (16'b0000000000000000),
    .POR_CFG                            (16'b0000000000000100),                 //
    .RSVD_ATTR0                         (16'b0000000000000001),                 // [0] : 1'b1 = QPLL0 enable PCIe mode
    .RSVD_ATTR1                         (16'b0000000000000000),    
    .RSVD_ATTR2                         (16'b0000000000000001),                 // [0] : 1'b1 = QPLL1 enable PCIe mode
    .RSVD_ATTR3                         (16'b0000000000000000),
    .SARC_EN                            ( 1'b0),
    .SARC_SEL                           ( 1'b0)                                                                                 
)
gthe3_common_i 
(       
    //----------------------------------------------------------------------------------------------
    //  QPLL0 Clock Ports
    //----------------------------------------------------------------------------------------------
    .GTGREFCLK0                         ( 1'd0), 
    .GTREFCLK00                         ( 1'd0),
    .GTREFCLK10                         ( 1'd0),
    .GTNORTHREFCLK00                    ( 1'd0),
    .GTNORTHREFCLK10                    ( 1'd0),
    .GTSOUTHREFCLK00                    ( 1'd0),
    .GTSOUTHREFCLK10                    ( 1'd0),
   
    .RXRECCLK0_SEL                      (),
    .REFCLKOUTMONITOR0                  (),
    
    //----------------------------------------------------------------------------------------------
    //  QPLL1 Clock Ports
    //----------------------------------------------------------------------------------------------
    .GTGREFCLK1                         ( 1'd0),
    .GTREFCLK01                         (GTCOM_REFCLK),
    .GTREFCLK11                         ( 1'd0),
    .GTNORTHREFCLK01                    ( 1'd0),    
    .GTNORTHREFCLK11                    ( 1'd0),
    .GTSOUTHREFCLK01                    ( 1'd0),
    .GTSOUTHREFCLK11                    ( 1'd0),        
        
	.RXRECCLK1_SEL	                    (),
    .REFCLKOUTMONITOR1                  (),   
        
    //----------------------------------------------------------------------------------------------
    //  QPLL Ports
    //----------------------------------------------------------------------------------------------
    .QPLLRSVD1                          ( 8'd0),
    .QPLLRSVD2                          ({2'd0, GTCOM_QPLLRATE}),               // [2:0] : QPLL0 rate
    .QPLLRSVD3                          ({2'd0, GTCOM_QPLLRATE}),               // [2:0] : QPLL1 rate
    .QPLLRSVD4                          ( 8'd0),
    
    .QPLLDMONITOR0                      (),
    .QPLLDMONITOR1                      (),
    
    //----------------------------------------------------------------------------------------------
    //  QPLL0 Ports
    //----------------------------------------------------------------------------------------------
    .QPLL0CLKRSVD0                      ( 1'd0),
    .QPLL0CLKRSVD1                      ( 1'd0),
    .QPLL0LOCKDETCLK                    ( 1'd0),
    .QPLL0LOCKEN                        ( 1'd0),
    .QPLL0PD                            ( 1'd1),
    .QPLL0REFCLKSEL                     ( 3'd1),                                // selects GTREFCLK00                             
    .QPLL0RESET                         ( 1'd1),
       
    .QPLL0FBCLKLOST                     (),
    .QPLL0LOCK                          (),
    .QPLL0OUTCLK                        (),
    .QPLL0OUTREFCLK                     (),
    .QPLL0REFCLKLOST                    (),                                          
                                               
    //----------------------------------------------------------------------------------------------
    //  QPLL1 Ports
    //----------------------------------------------------------------------------------------------
    .QPLL1CLKRSVD0                      ( 1'd0),
    .QPLL1CLKRSVD1                      ( 1'd0),
    .QPLL1LOCKDETCLK                    ( 1'd0),
    .QPLL1LOCKEN                        ( 1'd1),
    .QPLL1PD                            (GTCOM_QPLL1PD),
    .QPLL1REFCLKSEL                     (QPLLREFCLKSEL),                        // 1'd1 = selects GTREFCLK01
    .QPLL1RESET                         (GTCOM_QPLL1RESET),      
     
    .QPLL1FBCLKLOST                     (),  
    .QPLL1LOCK                          (GTCOM_QPLL1LOCK),       
    .QPLL1OUTCLK                        (GTCOM_QPLL1OUTCLK),     
    .QPLL1OUTREFCLK                     (GTCOM_QPLL1OUTREFCLK),                       
    .QPLL1REFCLKLOST                    (),                                        
                                                                                                   
    //----------------------------------------------------------------------------------------------
    //  DRP Ports
    //----------------------------------------------------------------------------------------------
    .DRPCLK                             (GTCOM_DRPCLK),                                        
    .DRPADDR                            (GTCOM_DRPADDR),                                       
    .DRPEN                              (GTCOM_DRPEN),                                             
    .DRPWE                              (GTCOM_DRPWE),     
    .DRPDI                              (GTCOM_DRPDI),                                      
                                                                         
    .DRPRDY                             (GTCOM_DRPRDY),    
    .DRPDO                              (GTCOM_DRPDO),                                      
                                                                                              
    //----------------------------------------------------------------------------------------------
    //  Band Gap Ports
    //----------------------------------------------------------------------------------------------
    .BGBYPASSB                          ( 1'b1),                                
    .BGMONITORENB                       ( 1'b1),                                
    .BGPDB                              ( 1'b1),                                
    .BGRCALOVRDENB                      ( 1'b1),                                
    .BGRCALOVRD                         ( 5'b11111),                               
        
    //----------------------------------------------------------------------------------------------
    //  MISC Ports
    //----------------------------------------------------------------------------------------------
    .PMARSVD0                           ( 8'd0),            
    .PMARSVD1                           ( 8'd0),
    .RCALENB                            ( 1'd1),                            

    .PMARSVDOUT0                        (),
    .PMARSVDOUT1                        ()
);


endmodule

//--------------------------------------------------------------------------------------------------
//  GT Wizard Top Module
//--------------------------------------------------------------------------------------------------
module rp_gtwizard_top #
(
    parameter integer PHY_MAX_SPEED    = 3,
    parameter integer PHY_LANE = 1
)
(    
                                                                                                      
    //--------------------------------------------------------------------------
    //  Clock Ports
    //--------------------------------------------------------------------------
    input                               GT_GTREFCLK0,
    input       [PHY_LANE-1:0]          GT_TXUSRCLK,
    input       [PHY_LANE-1:0]          GT_RXUSRCLK,  
    input       [PHY_LANE-1:0]          GT_TXUSRCLK2, 
    input       [PHY_LANE-1:0]          GT_RXUSRCLK2,    

    //--------------------------------------------------------------------------   
    //  BUFG_GT Controller Ports                                                                        
    //--------------------------------------------------------------------------                   
    output      [(PHY_LANE* 3)-1:0]     GT_BUFGTCE,       
    output      [(PHY_LANE* 3)-1:0]     GT_BUFGTCEMASK, 
    output      [(PHY_LANE* 3)-1:0]     GT_BUFGTRESET,
    output      [(PHY_LANE* 3)-1:0]     GT_BUFGTRSTMASK,
    output      [(PHY_LANE* 9)-1:0]     GT_BUFGTDIV,   
    output      [PHY_LANE-1:0]          GT_TXOUTCLK,  
                
    //--------------------------------------------------------------------------
    //  Reset Ports
    //--------------------------------------------------------------------------
    input       [PHY_LANE-1:0]          GT_CPLLPD,    
    input       [PHY_LANE-1:0]          GT_CPLLRESET,
    input       [PHY_LANE-1:0]          GT_TXPROGDIVRESET,  
    input       [PHY_LANE-1:0]          GT_RXPROGDIVRESET,   
    input       [PHY_LANE-1:0]          GT_GTTXRESET,  
    input       [PHY_LANE-1:0]          GT_GTRXRESET,  
    input       [PHY_LANE-1:0]          GT_TXUSERRDY, 
    input       [PHY_LANE-1:0]          GT_RXUSERRDY, 
                                        
    output      [PHY_LANE-1:0]          GT_GTPOWERGOOD, 
    output      [PHY_LANE-1:0]          GT_TXPROGDIVRESETDONE,  
    output      [PHY_LANE-1:0]          GT_RXPROGDIVRESETDONE,    
    output      [PHY_LANE-1:0]          GT_TXRESETDONE,   
    output      [PHY_LANE-1:0]          GT_RXRESETDONE,                  
    
    output      [PHY_LANE-1:0]          GT_TXPHALIGNDONE,            
    output      [PHY_LANE-1:0]          GT_RXPMARESETDONE,            
    output      [PHY_LANE-1:0]          GT_TXPHINITDONE,
    output      [PHY_LANE-1:0]          GT_RXCOMMADET,


    //--------------------------------------------------------------------------
    //  Common QPLL Ports
    //--------------------------------------------------------------------------
    input       [(PHY_LANE-1)>>2:0]     GTCOM_QPLL1PD,     
    input       [(PHY_LANE-1)>>2:0]     GTCOM_QPLL1RESET,
    
    output      [(PHY_LANE-1)>>2:0]     GTCOM_QPLL1LOCK, 
    output      [(PHY_LANE-1)>>2:0]     GTCOM_QPLL1OUTCLK,
    output      [(PHY_LANE-1)>>2:0]     GTCOM_QPLL1OUTREFCLK, 
    
    //----------------------------------------------------------------------------------------------
    //  Common DRP Ports
    //----------------------------------------------------------------------------------------------
    input       [   (PHY_LANE-1)>>2          :0]    GTCOM_DRPCLK,
    input       [((((PHY_LANE-1)>>2)+1)* 9)-1:0]    GTCOM_DRPADDR,                                       
    input       [   (PHY_LANE-1)>>2          :0]    GTCOM_DRPEN,                                             
    input       [   (PHY_LANE-1)>>2          :0]    GTCOM_DRPWE,     
    input       [((((PHY_LANE-1)>>2)+1)*16)-1:0]    GTCOM_DRPDI,                                      
                                                                         
    output      [   (PHY_LANE-1)>>2          :0]    GTCOM_DRPRDY,    
    output      [((((PHY_LANE-1)>>2)+1)*16)-1:0]    GTCOM_DRPDO,         
    
   input       [((PHY_LANE *  1)-1):0]    GT_DRPCLK,   
   input       [((PHY_LANE *  9)-1):0]    GT_DRPADDR, 
   input       [((PHY_LANE *  1)-1):0]    GT_DRPEN,    
   input       [((PHY_LANE *  1)-1):0]    GT_DRPWE,    
   input       [((PHY_LANE * 16)-1):0]    GT_DRPDI,   
                                           
   output      [((PHY_LANE *  1)-1):0]    GT_DRPRDY,   
   output      [((PHY_LANE * 16)-1):0]    GT_DRPDO,     

    //--------------------------------------------------------------------------
    //  Serial Line Ports
    //--------------------------------------------------------------------------
    input       [PHY_LANE-1:0]          GT_RXN,  
    input       [PHY_LANE-1:0]          GT_RXP,  
    
    output      [PHY_LANE-1:0]          GT_TXP,  
    output      [PHY_LANE-1:0]          GT_TXN,  
    
    //--------------------------------------------------------------------------
    //  TX Data Ports 
    //--------------------------------------------------------------------------
    input       [(PHY_LANE*32)-1:0]     GT_TXDATA,    
    input       [(PHY_LANE* 2)-1:0]     GT_TXDATAK,  
    input       [PHY_LANE-1:0]          GT_TXDATA_VALID,  
    input       [PHY_LANE-1:0]          GT_TXSTART_BLOCK,      
    input       [(PHY_LANE* 2)-1:0]     GT_TXSYNC_HEADER,  
    
    //--------------------------------------------------------------------------
    //  RX Data Ports 
    //--------------------------------------------------------------------------
    output      [(PHY_LANE*32)-1:0]     GT_RXDATA,      
    output      [(PHY_LANE* 2)-1:0]     GT_RXDATAK,        
    output      [PHY_LANE-1:0]          GT_RXDATA_VALID,  
    output      [PHY_LANE-1:0]          GT_RXSTART_BLOCK,       
    output      [(PHY_LANE* 2)-1:0]     GT_RXSYNC_HEADER,     
    
    //--------------------------------------------------------------------------
    //  PHY Command Ports
    //--------------------------------------------------------------------------
    input       [PHY_LANE-1:0]          GT_TXDETECTRX,      
    input       [PHY_LANE-1:0]          GT_TXELECIDLE, 
    input       [PHY_LANE-1:0]          GT_TXCOMPLIANCE, 
    input       [PHY_LANE-1:0]          GT_RXPOLARITY,
    input       [(PHY_LANE* 2)-1:0]     GT_POWERDOWN,      
    input       [(PHY_LANE* 2)-1:0]     GT_RATE,  
      
    //--------------------------------------------------------------------------
    //  PHY Status Ports
    //--------------------------------------------------------------------------
    output      [PHY_LANE-1:0]          GT_RXVALID, 
    output      [PHY_LANE-1:0]          GT_PHYSTATUS,
    output      [PHY_LANE-1:0]          GT_RXELECIDLE,
    output      [(PHY_LANE* 3)-1:0]     GT_RXSTATUS,
      
    //--------------------------------------------------------------------------
    //  TX Equalization Ports 
    //--------------------------------------------------------------------------
    input       [(PHY_LANE* 3)-1:0]     GT_TXMARGIN,  
    input       [PHY_LANE-1:0]          GT_TXSWING,  
    input       [PHY_LANE-1:0]          GT_TXDEEMPH, 
    input       [PHY_LANE-1:0]          GT_RXCDRHOLD, 
    
    //--------------------------------------------------------------------------
    //  TX Equalization Ports (Gen3)
    //--------------------------------------------------------------------------
    input       [(PHY_LANE* 5)-1:0]     GT_TXPRECURSOR,  
    input       [(PHY_LANE* 7)-1:0]     GT_TXMAINCURSOR,  
    input       [(PHY_LANE* 5)-1:0]     GT_TXPOSTCURSOR,      
    
    //--------------------------------------------------------------------------
    //  PCIe PCS Ports
    //--------------------------------------------------------------------------
    input       [PHY_LANE-1:0]          GT_PCIERSTIDLE,        
    input       [PHY_LANE-1:0]          GT_PCIERSTTXSYNCSTART,  
    input       [PHY_LANE-1:0]          GT_PCIEEQRXEQADAPTDONE, 
    input       [PHY_LANE-1:0]          GT_PCIEUSERRATEDONE,    
             
    output      [PHY_LANE-1:0]          GT_PCIEUSERPHYSTATUSRST,  
    output      [(PHY_LANE* 2)-1:0]     GT_PCIERATEQPLLPD,              
    output      [(PHY_LANE* 2)-1:0]     GT_PCIERATEQPLLRESET,                
    output      [PHY_LANE-1:0]          GT_PCIERATEIDLE,          
    output      [PHY_LANE-1:0]          GT_PCIESYNCTXSYNCDONE,                      
    output      [PHY_LANE-1:0]          GT_PCIERATEGEN3,   
    output      [PHY_LANE-1:0]          GT_PCIEUSERGEN3RDY, 
    output      [PHY_LANE-1:0]          GT_PCIEUSERRATESTART,  
   
    //--------------------------------------------------------------------------
    //  Loopback & PRBS Ports
    //--------------------------------------------------------------------------     
    input       [(PHY_LANE* 3)-1:0]     GT_LOOPBACK,                                                 
    input       [(PHY_LANE* 4)-1:0]     GT_PRBSSEL,  
    input       [PHY_LANE-1:0]          GT_TXPRBSFORCEERR,     
    input       [PHY_LANE-1:0]          GT_TXINHIBIT,     
    input       [PHY_LANE-1:0]          GT_RXPRBSCNTRESET,                                                                                                       

    output      [PHY_LANE-1:0]          GT_RXPRBSERR,                                              
    output      [PHY_LANE-1:0]          GT_RXPRBSLOCKED,  
      
    output      [PHY_LANE-1:0]          GT_RXPHALIGNDONE,  
    output      [PHY_LANE-1:0]          GT_RXDLYSRESETDONE,     
    output      [PHY_LANE-1:0]          GT_TXDLYSRESETDONE,     
    output      [PHY_LANE-1:0]          GT_RXSYNCDONE, 
    output      [PHY_LANE-1:0]          GT_EYESCANDATAERROR,
    output      [(PHY_LANE*17)-1:0]     GT_DMONITOROUT,
    output      [(PHY_LANE*3)-1:0]      GT_RXBUFSTATUS,
    //--------------------------------------------------------------------------
    //  GT Status Ports
    //--------------------------------------------------------------------------                                                     
    output      [PHY_LANE-1:0]          GT_CPLLLOCK,       
    output      [PHY_LANE-1:0]          GT_RXCDRLOCK                                                                 
);

//-------------------------------------------------------------------------------------------------
//  CPLL CALibration ports
//-------------------------------------------------------------------------------------------------- 
    wire [PHY_LANE-1:0] cpllpd_in              ;                                          
    wire [PHY_LANE-1:0] cpllreset_in           ;                                          
    wire [(PHY_LANE* 1)-1:0]  drpclk_in;
    assign drpclk_in = GT_DRPCLK;

    assign GT_DRPDO = {PHY_LANE{16'b0}};
    assign GT_DRPRDY = {PHY_LANE{1'b0}};

    wire gtwiz_userclk_tx_reset_in;
    wire [(PHY_LANE* 3)-1:0]    bufgtce_out ;
    wire [(PHY_LANE* 3)-1:0]    bufgtreset_out          ;
    wire [(PHY_LANE* 18)-1:0] gtwiz_gthe3_cpll_cal_txoutclk_period_in;
    wire [(PHY_LANE* 18)-1:0] gtwiz_gthe3_cpll_cal_cnt_tol_in;
    wire [(PHY_LANE*  1)-1:0] gtwiz_gthe3_cpll_cal_bufg_ce_in;
    assign gtwiz_gthe3_cpll_cal_txoutclk_period_in = {PHY_LANE{18'd4000}}; 
    assign gtwiz_gthe3_cpll_cal_cnt_tol_in         = {PHY_LANE{18'd40}};    
    assign gtwiz_userclk_tx_reset_in               = bufgtreset_out[21];
    assign gtwiz_gthe3_cpll_cal_bufg_ce_in         = {PHY_LANE{bufgtce_out[21]}};

//-------------------------------------------------------------------------------------------------
//  Internal Signals
//-------------------------------------------------------------------------------------------------- 
    wire        [PHY_LANE-1 : 0] qpll0clk_in; 
    wire        [PHY_LANE-1 : 0] qpll0refclk_in;
    wire        [PHY_LANE-1 : 0] rxbyteisaligned_out; 
    wire        [PHY_LANE-1 : 0] rxbyterealign_out; 
    wire        [(PHY_LANE * 2)-1 : 0] rxclkcorcnt_out; 
    wire        [(PHY_LANE*16)-1:0]     rxctrl1_out;  
    wire        [(PHY_LANE*8)-1:0]     rxctrl2_out;  
    wire        [(PHY_LANE*8)-1:0]     rxctrl3_out;  
    wire        [PHY_LANE-1 : 0] rxoutclk_out; 
    wire        [PHY_LANE-1 : 0] txpmaresetdone_out; 
    wire        [PHY_LANE-1 : 0] txsyncdone_out; 
//-------------------------------------------------------------------------------------------------- 
    wire        [(PHY_LANE* 3)-1:0]     rate;
    wire        [(PHY_LANE*128)-1:0]    txdata_in; 
    wire        [(PHY_LANE-1)>>2:0]     qpll1lock_out;
    wire        [(PHY_LANE-1)>>2:0]     qpll1outclk_out;
    wire        [(PHY_LANE-1)>>2:0]     qpll1outrefclk_out;
    wire        [PHY_LANE-1:0]          pcierategen3_out;  
    wire        [(PHY_LANE*2)-1:0]      pcierateqpllpd_out;              
    wire        [(PHY_LANE*2)-1:0]      pcierateqpllreset_out;
    wire        [(PHY_LANE*12)-1:0]     pcsrsvdout_out;
    wire        [(PHY_LANE*16)-1:0]     rxctrl0_out;  
    wire        [(PHY_LANE*128)-1:0]    rxdata_out;  
    wire        [PHY_LANE-1:0]          txphaligndone_out;  
    wire        [PHY_LANE-1:0]          txsyncout_out;  
//--------------------------------------------------------------------------------------------------
//  Signals converted from per lane
//--------------------------------------------------------------------------------------------------
    wire                                qpll1lock_all;    
    wire                                txsyncallin_all;
//--------------------------------------------------------------------------------------------------
    wire        [(PHY_LANE*16)-1:0]     txctrl0_in;
    wire        [(PHY_LANE*16)-1:0]     txctrl1_in;
    wire        [(PHY_LANE* 8)-1:0]     txctrl2_in;
    wire        [   (PHY_LANE-1)>>2          :0] qpll1pd_in;
    wire        [((((PHY_LANE-1)>>2)+1)* 5)-1:0] qpllrsvd2_3;
    wire        [(PHY_LANE*16)-1:0]     pcsrsvdin_in;
    wire        [PHY_LANE-1:0]          txsyncmode_in;
    wire        [PHY_LANE-1:0]          cplllock_out;  
 
    wire [PHY_LANE-1:0]         rxphaligndone_out       ;
    wire [PHY_LANE-1:0]         rxdlysresetdone_out     ;     
    wire [PHY_LANE-1:0]         rxsyncdone_out          ;
    wire [PHY_LANE-1:0]         eyescandataerror_out    ;
    wire [(PHY_LANE*17)-1:0]    dmonitorout_out         ;
    wire [(PHY_LANE* 3)-1:0]    bufgtcemask_out         ;
    wire [(PHY_LANE* 9)-1:0]    bufgtdiv_out            ;
    wire [(PHY_LANE* 3)-1:0]    bufgtrstmask_out        ;
    wire [PHY_LANE-1:0]         gthtxn_out              ;
    wire [PHY_LANE-1:0]         gthtxp_out              ;
    wire [PHY_LANE-1:0]         gtpowergood_out         ;
    wire [PHY_LANE-1:0]         pcierateidle_out        ;       
    wire [PHY_LANE-1:0]         pciesynctxsyncdone_out  ;                      
    wire [PHY_LANE-1:0]         pcieusergen3rdy_out     ; 
    wire [PHY_LANE-1:0]         pcieuserphystatusrst_out;  
    wire [PHY_LANE-1:0]         pcieuserratestart_out   ;  
    wire [PHY_LANE-1:0]         phystatus_out           ;
    wire [(PHY_LANE*3)-1:0]     rxbufstatus_out         ;
    wire [PHY_LANE-1:0]         rxcdrlock_out           ;                                                          
    wire [PHY_LANE-1:0]         rxcommadet_out          ;
    wire [PHY_LANE-1:0]         rxelecidle_out          ;
    wire [PHY_LANE-1:0]         rxpmaresetdone_out      ;           
    wire [PHY_LANE-1:0]         rxprbserr_out           ;                                        
    wire [PHY_LANE-1:0]         rxprbslocked_out        ;
    wire [PHY_LANE-1:0]         rxprgdivresetdone_out   ;    
    wire [PHY_LANE-1:0]         rxresetdone_out         ;              
    wire [(PHY_LANE* 3)-1:0]    rxstatus_out            ;
    wire [PHY_LANE-1:0]         rxvalid_out             ;
    wire [PHY_LANE-1:0]         txdlysresetdone_out     ;     
    wire [PHY_LANE-1:0]         txoutclk_out            ;
    wire [PHY_LANE-1:0]         txphinitdone_out        ;
    wire [PHY_LANE-1:0]         txprgdivresetdone_out   ;  
    wire [PHY_LANE-1:0]         txresetdone_out         ;
    wire [(PHY_LANE-1)>>2:0] gtrefclk01_in;
    wire [PHY_LANE-1:0] gtrefclk0_in;
    wire [PHY_LANE-1:0] txusrclk_in            ;                                          
    wire [PHY_LANE-1:0] rxusrclk_in            ;                                          
    wire [PHY_LANE-1:0] txusrclk2_in           ;                                          
    wire [PHY_LANE-1:0] rxusrclk2_in           ;                                          
    wire [PHY_LANE-1:0] txprogdivreset_in      ;                                          
    wire [PHY_LANE-1:0] rxprogdivreset_in      ;                                          
    wire [PHY_LANE-1:0] gttxreset_in           ;                                          
    wire [PHY_LANE-1:0] gtrxreset_in           ;                                          
    wire [PHY_LANE-1:0] txuserrdy_in           ;                                          
    wire [PHY_LANE-1:0] rxuserrdy_in           ;                                          
    wire [PHY_LANE-1:0] gthrxn_in              ;                                          
    wire [PHY_LANE-1:0] gthrxp_in              ;                                          
    wire [PHY_LANE-1:0] txdetectrx_in          ;                                          
    wire [PHY_LANE-1:0] txelecidle_in          ;                                          
    wire [PHY_LANE-1:0] rxpolarity_in          ;                                          
    wire [(PHY_LANE* 2)-1:0]rxpd_in            ;                                              
    wire [(PHY_LANE* 2)-1:0]txpd_in            ;                                              
    wire [(PHY_LANE* 3)-1:0]txmargin_in        ;                                              
    wire [PHY_LANE-1:0] txswing_in             ;                                          
    wire [PHY_LANE-1:0] txdeemph_in            ;                                          
    wire [PHY_LANE-1:0] rxcdrhold_in           ;                                          
    wire [(PHY_LANE* 5)-1:0] txprecursor_in    ;                                               
    wire [(PHY_LANE* 7)-1:0] txmaincursor_in   ;                                               
    wire [(PHY_LANE* 5)-1:0] txpostcursor_in   ;                                               
    wire [PHY_LANE-1:0] pcierstidle_in         ;                                          
    wire [PHY_LANE-1:0] pciersttxsyncstart_in  ;                                          
    wire [PHY_LANE-1:0] pcieeqrxeqadaptdone_in ;                                          
    wire [PHY_LANE-1:0] pcieuserratedone_in    ;                                          
    wire [(PHY_LANE* 3)-1:0] loopback_in       ;                                               
    wire [(PHY_LANE* 4)-1:0] rxprbssel_in      ;                                               
    wire [(PHY_LANE* 4)-1:0] txprbssel_in      ;                                               
    wire [PHY_LANE-1:0] txprbsforceerr_in      ;                                          
    wire [PHY_LANE-1:0] txinhibit_in      ;                                          
    wire [PHY_LANE-1:0] rxprbscntreset_in      ; 

    wire gtwiz_userclk_tx_active_in ;                                                
    wire gtwiz_userclk_rx_active_in ;                                                
    wire gtwiz_reset_tx_done_in     ;                                                
    wire gtwiz_reset_rx_done_in     ;                                                                                      
    wire [PHY_LANE-1:0] rx8b10ben_in;                                                          
    wire [PHY_LANE-1:0] rxlpmen_in;                                                            
    wire [PHY_LANE-1:0] rxmcommaalignen_in;                                                    
    wire [PHY_LANE-1:0] rxpcommaalignen_in;                                                    
    wire [PHY_LANE-1:0] tx8b10ben_in;                                                          
    wire [PHY_LANE-1:0] rxbufreset_in    ;                                                
    wire [PHY_LANE-1:0] rxcommadeten_in  ;
    wire [PHY_LANE-1:0] rxslide_in       ;                                                
    wire [PHY_LANE-1:0] txdlybypass_in   ;                                                
    wire [PHY_LANE-1:0] txdlyen_in       ;                                                
    wire [PHY_LANE-1:0] txdlyhold_in     ;                                                
    wire [PHY_LANE-1:0] txdlyovrden_in   ;                                                
    wire [PHY_LANE-1:0] txdlysreset_in   ;                                                
    wire [PHY_LANE-1:0] txdlyupdown_in   ;                                                
    wire [PHY_LANE-1:0] txphalign_in     ;                                                
    wire [PHY_LANE-1:0] txphalignen_in   ;                                                
    wire [PHY_LANE-1:0] txphdlypd_in     ;                                                
    wire [PHY_LANE-1:0] txphdlyreset_in  ;                                                
    wire [PHY_LANE-1:0] txphdlytstclk_in ;                                                
    wire [PHY_LANE-1:0] txphinit_in      ;                                                
    wire [PHY_LANE-1:0] txphovrden_in    ;                                                
    wire [(PHY_LANE-1) : 0] txsyncallin_in; 
    wire [(PHY_LANE-1) : 0] txsyncin_in;   
    wire [((((PHY_LANE-1)>>2)+1)* 5)-1:0] qpllrsvd2_in;
    wire [((((PHY_LANE-1)>>2)+1)* 5)-1:0] qpllrsvd3_in;
    wire [   (PHY_LANE-1)>>2          :0] qpll1reset_in;
    wire [(PHY_LANE* 3)-1:0]     rxrate_in;
    wire [(PHY_LANE* 3)-1:0]     txrate_in;

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    assign qpll0clk_in = 0; 
    assign qpll0refclk_in = 0;

    assign qpll1lock_all   = &qpll1lock_out;
    assign txsyncallin_all = &txphaligndone_out;    
    
    assign gtwiz_userclk_tx_active_in = 1'd0;                                                
    assign gtwiz_userclk_rx_active_in = 1'd0;                                                
    assign gtwiz_reset_tx_done_in     = 1'd0;                                                
    assign gtwiz_reset_rx_done_in     = 1'd0;                                                                                      
    assign gtrefclk01_in         = ({(((PHY_LANE-1)>>2)+1){GT_GTREFCLK0}});                                                  
    assign gtrefclk0_in          = ({PHY_LANE{GT_GTREFCLK0}});                                                    
    assign rx8b10ben_in          = (~pcierategen3_out);                                                
    assign rxlpmen_in            = (~pcierategen3_out);                                                
    assign rxmcommaalignen_in    = (~pcierategen3_out);                                                
    assign rxpcommaalignen_in    = (~pcierategen3_out);                                                
    assign tx8b10ben_in          = (~pcierategen3_out);                                                
    assign rxbufreset_in         = ({PHY_LANE{1'd0}});                                                
    assign rxcommadeten_in       = ({PHY_LANE{1'd1}});     // Always 1'd1            
    assign rxslide_in            = ({PHY_LANE{1'd0}});                                                
    assign txdlybypass_in        = ({PHY_LANE{1'd0}});                                                
    assign txdlyen_in            = ({PHY_LANE{1'd0}});                                                
    assign txdlyhold_in          = ({PHY_LANE{1'd0}});                                                
    assign txdlyovrden_in        = ({PHY_LANE{1'd0}});                                                
    assign txdlysreset_in        = ({PHY_LANE{1'd0}});                                                
    assign txdlyupdown_in        = ({PHY_LANE{1'd0}});                                                
    assign txphalign_in          = ({PHY_LANE{1'd0}});                                                
    assign txphalignen_in        = ({PHY_LANE{1'd0}});                                                
    assign txphdlypd_in          = ({PHY_LANE{1'd0}});                                                
    assign txphdlyreset_in       = ({PHY_LANE{1'd0}});                                                
    assign txphdlytstclk_in      = ({PHY_LANE{1'd0}});                                                
    assign txphinit_in           = ({PHY_LANE{1'd0}});                                                
    assign txphovrden_in         = ({PHY_LANE{1'd0}});                                                
    assign txsyncallin_in        = ({PHY_LANE{txsyncallin_all}}); // From all lanes                         

    assign qpllrsvd2_in          = qpllrsvd2_3;
    assign qpllrsvd3_in          = qpllrsvd2_3;
    assign rxrate_in             = rate;
    assign txrate_in             = rate;
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
 // dynamic GT instance call
   rp_gt rp_gt_i
  (
   .bufgtce_out(bufgtce_out),
   .bufgtcemask_out(bufgtcemask_out),
   .bufgtdiv_out(bufgtdiv_out),
   .bufgtreset_out(bufgtreset_out),
   .bufgtrstmask_out(bufgtrstmask_out),
   .cplllock_out(cplllock_out),
   .cpllpd_in(cpllpd_in),
   .cpllreset_in(cpllreset_in),
   .dmonitorout_out(dmonitorout_out),
   .drpclk_in(drpclk_in),
   .eyescandataerror_out(eyescandataerror_out),
   .gthrxn_in(gthrxn_in),
   .gthrxp_in(gthrxp_in),
   .gthtxn_out(gthtxn_out),
   .gthtxp_out(gthtxp_out),
   .gtpowergood_out(gtpowergood_out),
   .gtrefclk01_in(gtrefclk01_in),
   .gtrefclk0_in(gtrefclk0_in),
   .gtrxreset_in(gtrxreset_in),
   .gttxreset_in(gttxreset_in),
   .gtwiz_gthe3_cpll_cal_bufg_ce_in(gtwiz_gthe3_cpll_cal_bufg_ce_in),
   .gtwiz_gthe3_cpll_cal_cnt_tol_in(gtwiz_gthe3_cpll_cal_cnt_tol_in),
   .gtwiz_gthe3_cpll_cal_txoutclk_period_in(gtwiz_gthe3_cpll_cal_txoutclk_period_in),
   .gtwiz_reset_rx_done_in(gtwiz_reset_rx_done_in),
   .gtwiz_reset_tx_done_in(gtwiz_reset_tx_done_in),
   .gtwiz_userclk_rx_active_in(gtwiz_userclk_rx_active_in),
   .gtwiz_userclk_tx_active_in(gtwiz_userclk_tx_active_in),
   .gtwiz_userclk_tx_reset_in(gtwiz_userclk_tx_reset_in),
   .loopback_in(loopback_in),
   .pcieeqrxeqadaptdone_in(pcieeqrxeqadaptdone_in),
   .pcierategen3_out(pcierategen3_out),
   .pcierateidle_out(pcierateidle_out),
   .pcierateqpllpd_out(pcierateqpllpd_out),
   .pcierateqpllreset_out(pcierateqpllreset_out),
   .pcierstidle_in(pcierstidle_in),
   .pciersttxsyncstart_in(pciersttxsyncstart_in),
   .pciesynctxsyncdone_out(pciesynctxsyncdone_out),
   .pcieusergen3rdy_out(pcieusergen3rdy_out),
   .pcieuserphystatusrst_out(pcieuserphystatusrst_out),
   .pcieuserratedone_in(pcieuserratedone_in),
   .pcieuserratestart_out(pcieuserratestart_out),
   .pcsrsvdin_in(pcsrsvdin_in),
   .pcsrsvdout_out(pcsrsvdout_out),
   .phystatus_out(phystatus_out),
   .qpll1lock_out(qpll1lock_out),
   .qpll1outclk_out(qpll1outclk_out),
   .qpll1outrefclk_out(qpll1outrefclk_out),
   .qpll1pd_in(qpll1pd_in),
   .qpll1reset_in(qpll1reset_in),
   .qpllrsvd2_in(qpllrsvd2_in),
   .qpllrsvd3_in(qpllrsvd3_in),
   .rx8b10ben_in(rx8b10ben_in),
   .rxbufreset_in(rxbufreset_in),
   .rxbufstatus_out(rxbufstatus_out),
   .rxbyteisaligned_out(rxbyteisaligned_out),
   .rxbyterealign_out(rxbyterealign_out),
   .rxcdrhold_in(rxcdrhold_in),
   .rxcdrlock_out(rxcdrlock_out),
   .rxclkcorcnt_out(rxclkcorcnt_out),
   .rxcommadet_out(rxcommadet_out),
   .rxcommadeten_in(rxcommadeten_in),
   .rxctrl0_out(rxctrl0_out),
   .rxctrl1_out(rxctrl1_out),
   .rxctrl2_out(rxctrl2_out),
   .rxctrl3_out(rxctrl3_out),
   .rxdata_out(rxdata_out),
   .rxdlysresetdone_out(rxdlysresetdone_out),
   .rxelecidle_out(rxelecidle_out),
   .rxlpmen_in(rxlpmen_in),
   .rxmcommaalignen_in(rxmcommaalignen_in),
   .rxoutclk_out(rxoutclk_out),
   .rxpcommaalignen_in(rxpcommaalignen_in),
   .rxpd_in(rxpd_in),
   .rxphaligndone_out(rxphaligndone_out),
   .rxpmaresetdone_out(rxpmaresetdone_out),
   .rxpolarity_in(rxpolarity_in),
   .rxprbscntreset_in(rxprbscntreset_in),
   .rxprbserr_out(rxprbserr_out),
   .rxprbslocked_out(rxprbslocked_out),
   .rxprbssel_in(rxprbssel_in),
   .rxprgdivresetdone_out(rxprgdivresetdone_out),
   .rxprogdivreset_in(rxprogdivreset_in),
   .rxrate_in(rxrate_in),
   .rxresetdone_out(rxresetdone_out),
   .rxslide_in(rxslide_in),
   .rxstatus_out(rxstatus_out),
   .rxsyncdone_out(rxsyncdone_out),
   .rxuserrdy_in(rxuserrdy_in),
   .rxusrclk2_in(rxusrclk2_in),
   .rxusrclk_in(rxusrclk_in),
   .rxvalid_out(rxvalid_out),
   .tx8b10ben_in(tx8b10ben_in),
   .txctrl0_in(txctrl0_in),
   .txctrl1_in(txctrl1_in),
   .txctrl2_in(txctrl2_in),
   .txdata_in(txdata_in),
   .txdeemph_in(txdeemph_in),
   .txdetectrx_in(txdetectrx_in),
   .txdlybypass_in(txdlybypass_in),
   .txdlyen_in(txdlyen_in),
   .txdlyhold_in(txdlyhold_in),
   .txdlyovrden_in(txdlyovrden_in),
   .txdlysreset_in(txdlysreset_in),
   .txdlysresetdone_out(txdlysresetdone_out),
   .txdlyupdown_in(txdlyupdown_in),
   .txelecidle_in(txelecidle_in),
   .txmaincursor_in(txmaincursor_in),
   .txmargin_in(txmargin_in),
   .txoutclk_out(txoutclk_out),
   .txpd_in(txpd_in),
   .txphalign_in(txphalign_in),
   .txphaligndone_out(txphaligndone_out),
   .txphalignen_in(txphalignen_in),
   .txphdlypd_in(txphdlypd_in),
   .txphdlyreset_in(txphdlyreset_in),
   .txphdlytstclk_in(txphdlytstclk_in),
   .txphinit_in(txphinit_in),
   .txphinitdone_out(txphinitdone_out),
   .txphovrden_in(txphovrden_in),
   .txpmaresetdone_out(txpmaresetdone_out),
   .txpostcursor_in(txpostcursor_in),
   .txprbsforceerr_in(txprbsforceerr_in),
   .txinhibit_in(txinhibit_in),
   .txprbssel_in(txprbssel_in),
   .txprecursor_in(txprecursor_in),
   .txprgdivresetdone_out(txprgdivresetdone_out),
   .txprogdivreset_in(txprogdivreset_in),
   .txrate_in(txrate_in),
   .txresetdone_out(txresetdone_out),
   .txswing_in(txswing_in),
   .txsyncallin_in(txsyncallin_in),
   .txsyncdone_out(txsyncdone_out),
   .txsyncin_in(txsyncin_in),
   .txsyncmode_in(txsyncmode_in),
   .txsyncout_out(txsyncout_out),
   .txuserrdy_in(txuserrdy_in),
   .txusrclk2_in(txusrclk2_in),
   .txusrclk_in(txusrclk_in)
  );

//--------------------------------------------------------------------- Mapping ----------------------------------------------------------------------------------------------------------------------------------------------
    assign rate                   = {{1'd0,GT_RATE[1:0]},{1'd0,GT_RATE[3:2]},{1'd0,GT_RATE[5:4]},{1'd0,GT_RATE[7:6]},{1'd0,GT_RATE[9:8]},{1'd0,GT_RATE[11:10]},{1'd0,GT_RATE[13:12]},{1'd0,GT_RATE[15:14]}};
    assign txsyncmode_in          = 8'h80; // X0Y7 is the Master. So, txsyncmode_in[7] = 1'b1;
    assign txsyncin_in            = ({PHY_LANE{txsyncout_out[7]}}); // From Master Lane 0 - X0Y7                  
    assign pcsrsvdin_in           = {PHY_LANE{14'd0,cplllock_out[7],qpll1lock_all}};

    assign gthrxn_in              = {GT_RXN[0],GT_RXN[1],GT_RXN[2],GT_RXN[3],GT_RXN[4],GT_RXN[5],GT_RXN[6],GT_RXN[7]};
    assign gthrxp_in              = {GT_RXP[0],GT_RXP[1],GT_RXP[2],GT_RXP[3],GT_RXP[4],GT_RXP[5],GT_RXP[6],GT_RXP[7]};
    assign GT_TXN                 = {gthtxn_out[0],gthtxn_out[1],gthtxn_out[2],gthtxn_out[3],gthtxn_out[4],gthtxn_out[5],gthtxn_out[6],gthtxn_out[7]};                                      
    assign GT_TXP                 = {gthtxp_out[0],gthtxp_out[1],gthtxp_out[2],gthtxp_out[3],gthtxp_out[4],gthtxp_out[5],gthtxp_out[6],gthtxp_out[7]};                                      
    assign cpllpd_in              = {GT_CPLLPD[0],GT_CPLLPD[1],GT_CPLLPD[2],GT_CPLLPD[3],GT_CPLLPD[4],GT_CPLLPD[5],GT_CPLLPD[6],GT_CPLLPD[7]};
    assign cpllreset_in           = {GT_CPLLRESET[0],GT_CPLLRESET[1],GT_CPLLRESET[2],GT_CPLLRESET[3],GT_CPLLRESET[4],GT_CPLLRESET[5],GT_CPLLRESET[6],GT_CPLLRESET[7]};
    assign txswing_in             = {GT_TXSWING[0],GT_TXSWING[1],GT_TXSWING[2],GT_TXSWING[3],GT_TXSWING[4],GT_TXSWING[5],GT_TXSWING[6],GT_TXSWING[7]};
    assign txusrclk_in            = {GT_TXUSRCLK[0],GT_TXUSRCLK[1],GT_TXUSRCLK[2],GT_TXUSRCLK[3],GT_TXUSRCLK[4],GT_TXUSRCLK[5],GT_TXUSRCLK[6],GT_TXUSRCLK[7]};
    assign rxusrclk_in            = {GT_RXUSRCLK[0],GT_RXUSRCLK[1],GT_RXUSRCLK[2],GT_RXUSRCLK[3],GT_RXUSRCLK[4],GT_RXUSRCLK[5],GT_RXUSRCLK[6],GT_RXUSRCLK[7]};
    assign txdeemph_in            = {GT_TXDEEMPH[0],GT_TXDEEMPH[1],GT_TXDEEMPH[2],GT_TXDEEMPH[3],GT_TXDEEMPH[4],GT_TXDEEMPH[5],GT_TXDEEMPH[6],GT_TXDEEMPH[7]};
    assign rxcdrhold_in           = {GT_RXCDRHOLD[0],GT_RXCDRHOLD[1],GT_RXCDRHOLD[2],GT_RXCDRHOLD[3],GT_RXCDRHOLD[4],GT_RXCDRHOLD[5],GT_RXCDRHOLD[6],GT_RXCDRHOLD[7]};
    assign txusrclk2_in           = {GT_TXUSRCLK2[0],GT_TXUSRCLK2[1],GT_TXUSRCLK2[2],GT_TXUSRCLK2[3],GT_TXUSRCLK2[4],GT_TXUSRCLK2[5],GT_TXUSRCLK2[6],GT_TXUSRCLK2[7]};
    assign rxusrclk2_in           = {GT_RXUSRCLK2[0],GT_RXUSRCLK2[1],GT_RXUSRCLK2[2],GT_RXUSRCLK2[3],GT_RXUSRCLK2[4],GT_RXUSRCLK2[5],GT_RXUSRCLK2[6],GT_RXUSRCLK2[7]};
    assign gttxreset_in           = {GT_GTTXRESET[0],GT_GTTXRESET[1],GT_GTTXRESET[2],GT_GTTXRESET[3],GT_GTTXRESET[4],GT_GTTXRESET[5],GT_GTTXRESET[6],GT_GTTXRESET[7]};
    assign gtrxreset_in           = {GT_GTRXRESET[0],GT_GTRXRESET[1],GT_GTRXRESET[2],GT_GTRXRESET[3],GT_GTRXRESET[4],GT_GTRXRESET[5],GT_GTRXRESET[6],GT_GTRXRESET[7]};
    assign txuserrdy_in           = {GT_TXUSERRDY[0],GT_TXUSERRDY[1],GT_TXUSERRDY[2],GT_TXUSERRDY[3],GT_TXUSERRDY[4],GT_TXUSERRDY[5],GT_TXUSERRDY[6],GT_TXUSERRDY[7]};
    assign rxuserrdy_in           = {GT_RXUSERRDY[0],GT_RXUSERRDY[1],GT_RXUSERRDY[2],GT_RXUSERRDY[3],GT_RXUSERRDY[4],GT_RXUSERRDY[5],GT_RXUSERRDY[6],GT_RXUSERRDY[7]};
    assign txdetectrx_in          = {GT_TXDETECTRX[0],GT_TXDETECTRX[1],GT_TXDETECTRX[2],GT_TXDETECTRX[3],GT_TXDETECTRX[4],GT_TXDETECTRX[5],GT_TXDETECTRX[6],GT_TXDETECTRX[7]};
    assign txelecidle_in          = {GT_TXELECIDLE[0],GT_TXELECIDLE[1],GT_TXELECIDLE[2],GT_TXELECIDLE[3],GT_TXELECIDLE[4],GT_TXELECIDLE[5],GT_TXELECIDLE[6],GT_TXELECIDLE[7]};
    assign rxpolarity_in          = {GT_RXPOLARITY[0],GT_RXPOLARITY[1],GT_RXPOLARITY[2],GT_RXPOLARITY[3],GT_RXPOLARITY[4],GT_RXPOLARITY[5],GT_RXPOLARITY[6],GT_RXPOLARITY[7]};
    assign txprogdivreset_in      = {GT_TXPROGDIVRESET[0],GT_TXPROGDIVRESET[1],GT_TXPROGDIVRESET[2],GT_TXPROGDIVRESET[3],GT_TXPROGDIVRESET[4],GT_TXPROGDIVRESET[5],GT_TXPROGDIVRESET[6],GT_TXPROGDIVRESET[7]};
    assign rxprogdivreset_in      = {GT_RXPROGDIVRESET[0],GT_RXPROGDIVRESET[1],GT_RXPROGDIVRESET[2],GT_RXPROGDIVRESET[3],GT_RXPROGDIVRESET[4],GT_RXPROGDIVRESET[5],GT_RXPROGDIVRESET[6],GT_RXPROGDIVRESET[7]};

    assign GT_TXOUTCLK            = {txoutclk_out[0],txoutclk_out[1],txoutclk_out[2],txoutclk_out[3],txoutclk_out[4],txoutclk_out[5],txoutclk_out[6],txoutclk_out[7]};                                      
    assign GT_RXCOMMADET          = {rxcommadet_out[0],rxcommadet_out[1],rxcommadet_out[2],rxcommadet_out[3],rxcommadet_out[4],rxcommadet_out[5],rxcommadet_out[6],rxcommadet_out[7]}          ;   
    assign GT_GTPOWERGOOD         = {gtpowergood_out[0],gtpowergood_out[1],gtpowergood_out[2],gtpowergood_out[3],gtpowergood_out[4],gtpowergood_out[5],gtpowergood_out[6],gtpowergood_out[7]}         ;                                      
    assign GT_TXRESETDONE         = {txresetdone_out[0],txresetdone_out[1],txresetdone_out[2],txresetdone_out[3],txresetdone_out[4],txresetdone_out[5],txresetdone_out[6],txresetdone_out[7]}         ;                                      
    assign GT_RXRESETDONE         = {rxresetdone_out[0],rxresetdone_out[1],rxresetdone_out[2],rxresetdone_out[3],rxresetdone_out[4],rxresetdone_out[5],rxresetdone_out[6],rxresetdone_out[7]}         ;                                      
    assign GT_TXPHINITDONE        = {txphinitdone_out[0],txphinitdone_out[1],txphinitdone_out[2],txphinitdone_out[3],txphinitdone_out[4],txphinitdone_out[5],txphinitdone_out[6],txphinitdone_out[7]}        ;    
    assign GT_TXPHALIGNDONE       = {txphaligndone_out[0],txphaligndone_out[1],txphaligndone_out[2],txphaligndone_out[3],txphaligndone_out[4],txphaligndone_out[5],txphaligndone_out[6],txphaligndone_out[7]};
    assign GT_RXPMARESETDONE      = {rxpmaresetdone_out[0],rxpmaresetdone_out[1],rxpmaresetdone_out[2],rxpmaresetdone_out[3],rxpmaresetdone_out[4],rxpmaresetdone_out[5],rxpmaresetdone_out[6],rxpmaresetdone_out[7]}      ; 
    assign GT_TXPROGDIVRESETDONE  = {txprgdivresetdone_out[0],txprgdivresetdone_out[1],txprgdivresetdone_out[2],txprgdivresetdone_out[3],txprgdivresetdone_out[4],txprgdivresetdone_out[5],txprgdivresetdone_out[6],txprgdivresetdone_out[7]}   ;                                      
    assign GT_RXPROGDIVRESETDONE  = {rxprgdivresetdone_out[0],rxprgdivresetdone_out[1],rxprgdivresetdone_out[2],rxprgdivresetdone_out[3],rxprgdivresetdone_out[4],rxprgdivresetdone_out[5],rxprgdivresetdone_out[6],rxprgdivresetdone_out[7]}   ;                                      

    assign GT_RXVALID             = {rxvalid_out[0],rxvalid_out[1],rxvalid_out[2],rxvalid_out[3],rxvalid_out[4],rxvalid_out[5],rxvalid_out[6],rxvalid_out[7]};
    assign GT_RXPRBSERR           = {rxprbserr_out[0],rxprbserr_out[1],rxprbserr_out[2],rxprbserr_out[3],rxprbserr_out[4],rxprbserr_out[5],rxprbserr_out[6],rxprbserr_out[7]};                                      
    assign GT_PHYSTATUS           = {phystatus_out[0],phystatus_out[1],phystatus_out[2],phystatus_out[3],phystatus_out[4],phystatus_out[5],phystatus_out[6],phystatus_out[7]};                                      
    assign GT_RXCDRLOCK           = {rxcdrlock_out[0],rxcdrlock_out[1],rxcdrlock_out[2],rxcdrlock_out[3],rxcdrlock_out[4],rxcdrlock_out[5],rxcdrlock_out[6],rxcdrlock_out[7]};                                                                                               
    assign pcierstidle_in         = {GT_PCIERSTIDLE[0],GT_PCIERSTIDLE[1],GT_PCIERSTIDLE[2],GT_PCIERSTIDLE[3],GT_PCIERSTIDLE[4],GT_PCIERSTIDLE[5],GT_PCIERSTIDLE[6],GT_PCIERSTIDLE[7]};
    assign GT_RXSYNCDONE          = {rxsyncdone_out[0],rxsyncdone_out[1],rxsyncdone_out[2],rxsyncdone_out[3],rxsyncdone_out[4],rxsyncdone_out[5],rxsyncdone_out[6],rxsyncdone_out[7]};           
    assign GT_RXELECIDLE          = {rxelecidle_out[0],rxelecidle_out[1],rxelecidle_out[2],rxelecidle_out[3],rxelecidle_out[4],rxelecidle_out[5],rxelecidle_out[6],rxelecidle_out[7]};                                      
    assign GT_PCIERATEIDLE        = {pcierateidle_out[0],pcierateidle_out[1],pcierateidle_out[2],pcierateidle_out[3],pcierateidle_out[4],pcierateidle_out[5],pcierateidle_out[6],pcierateidle_out[7]};                                      
    assign GT_RXPRBSLOCKED        = {rxprbslocked_out[0],rxprbslocked_out[1],rxprbslocked_out[2],rxprbslocked_out[3],rxprbslocked_out[4],rxprbslocked_out[5],rxprbslocked_out[6],rxprbslocked_out[7]};                                      
    assign GT_PCIERATEGEN3        = {pcierategen3_out[0],pcierategen3_out[1],pcierategen3_out[2],pcierategen3_out[3],pcierategen3_out[4],pcierategen3_out[5],pcierategen3_out[6],pcierategen3_out[7]};
    assign GT_RXPHALIGNDONE       = {rxphaligndone_out[0],rxphaligndone_out[1],rxphaligndone_out[2],rxphaligndone_out[3],rxphaligndone_out[4],rxphaligndone_out[5],rxphaligndone_out[6],rxphaligndone_out[7]};          
    assign txprbsforceerr_in      = {GT_TXPRBSFORCEERR[0],GT_TXPRBSFORCEERR[1],GT_TXPRBSFORCEERR[2],GT_TXPRBSFORCEERR[3],GT_TXPRBSFORCEERR[4],GT_TXPRBSFORCEERR[5],GT_TXPRBSFORCEERR[6],GT_TXPRBSFORCEERR[7]};
    assign txinhibit_in           = {GT_TXINHIBIT[0],GT_TXINHIBIT[1],GT_TXINHIBIT[2],GT_TXINHIBIT[3],GT_TXINHIBIT[4],GT_TXINHIBIT[5],GT_TXINHIBIT[6],GT_TXINHIBIT[7]};
    assign rxprbscntreset_in      = {GT_RXPRBSCNTRESET[0],GT_RXPRBSCNTRESET[1],GT_RXPRBSCNTRESET[2],GT_RXPRBSCNTRESET[3],GT_RXPRBSCNTRESET[4],GT_RXPRBSCNTRESET[5],GT_RXPRBSCNTRESET[6],GT_RXPRBSCNTRESET[7]};
    assign GT_RXDLYSRESETDONE     = {rxdlysresetdone_out[0],rxdlysresetdone_out[1],rxdlysresetdone_out[2],rxdlysresetdone_out[3],rxdlysresetdone_out[4],rxdlysresetdone_out[5],rxdlysresetdone_out[6],rxdlysresetdone_out[7]};           
    assign GT_TXDLYSRESETDONE     = {txdlysresetdone_out[0],txdlysresetdone_out[1],txdlysresetdone_out[2],txdlysresetdone_out[3],txdlysresetdone_out[4],txdlysresetdone_out[5],txdlysresetdone_out[6],txdlysresetdone_out[7]};  
    assign GT_PCIEUSERGEN3RDY     = {pcieusergen3rdy_out[0],pcieusergen3rdy_out[1],pcieusergen3rdy_out[2],pcieusergen3rdy_out[3],pcieusergen3rdy_out[4],pcieusergen3rdy_out[5],pcieusergen3rdy_out[6],pcieusergen3rdy_out[7]};                                      
    assign pcieuserratedone_in    = {GT_PCIEUSERRATEDONE[0],GT_PCIEUSERRATEDONE[1],GT_PCIEUSERRATEDONE[2],GT_PCIEUSERRATEDONE[3],GT_PCIEUSERRATEDONE[4],GT_PCIEUSERRATEDONE[5],GT_PCIEUSERRATEDONE[6],GT_PCIEUSERRATEDONE[7]};
    assign GT_EYESCANDATAERROR    = {eyescandataerror_out[0],eyescandataerror_out[1],eyescandataerror_out[2],eyescandataerror_out[3],eyescandataerror_out[4],eyescandataerror_out[5],eyescandataerror_out[6],eyescandataerror_out[7]};            
    assign GT_PCIEUSERRATESTART   = {pcieuserratestart_out[0],pcieuserratestart_out[1],pcieuserratestart_out[2],pcieuserratestart_out[3],pcieuserratestart_out[4],pcieuserratestart_out[5],pcieuserratestart_out[6],pcieuserratestart_out[7]};                                      
    assign pciersttxsyncstart_in  = {GT_PCIERSTTXSYNCSTART[0],GT_PCIERSTTXSYNCSTART[1],GT_PCIERSTTXSYNCSTART[2],GT_PCIERSTTXSYNCSTART[3],GT_PCIERSTTXSYNCSTART[4],GT_PCIERSTTXSYNCSTART[5],GT_PCIERSTTXSYNCSTART[6],GT_PCIERSTTXSYNCSTART[7]};
    assign GT_PCIESYNCTXSYNCDONE  = {pciesynctxsyncdone_out[0],pciesynctxsyncdone_out[1],pciesynctxsyncdone_out[2],pciesynctxsyncdone_out[3],pciesynctxsyncdone_out[4],pciesynctxsyncdone_out[5],pciesynctxsyncdone_out[6],pciesynctxsyncdone_out[7]};                                      
    assign pcieeqrxeqadaptdone_in = {GT_PCIEEQRXEQADAPTDONE[0],GT_PCIEEQRXEQADAPTDONE[1],GT_PCIEEQRXEQADAPTDONE[2],GT_PCIEEQRXEQADAPTDONE[3],GT_PCIEEQRXEQADAPTDONE[4],GT_PCIEEQRXEQADAPTDONE[5],GT_PCIEEQRXEQADAPTDONE[6],GT_PCIEEQRXEQADAPTDONE[7]};
    assign GT_PCIEUSERPHYSTATUSRST= {pcieuserphystatusrst_out[0],pcieuserphystatusrst_out[1],pcieuserphystatusrst_out[2],pcieuserphystatusrst_out[3],pcieuserphystatusrst_out[4],pcieuserphystatusrst_out[5],pcieuserphystatusrst_out[6],pcieuserphystatusrst_out[7]};                                      

    assign GT_BUFGTCE             = {bufgtce_out[2:0],bufgtce_out[5:3],bufgtce_out[8:6],bufgtce_out[11:9],bufgtce_out[14:12],bufgtce_out[17:15],bufgtce_out[20:18],bufgtce_out[23:21]};                                          
    assign loopback_in            = {GT_LOOPBACK[2:0],GT_LOOPBACK[5:3],GT_LOOPBACK[8:6],GT_LOOPBACK[11:9],GT_LOOPBACK[14:12],GT_LOOPBACK[17:15],GT_LOOPBACK[20:18],GT_LOOPBACK[23:21]};
    assign txmargin_in            = {GT_TXMARGIN[2:0],GT_TXMARGIN[5:3],GT_TXMARGIN[8:6],GT_TXMARGIN[11:9],GT_TXMARGIN[14:12],GT_TXMARGIN[17:15],GT_TXMARGIN[20:18],GT_TXMARGIN[23:21]};
    assign GT_RXSTATUS            = {rxstatus_out[2:0],rxstatus_out[5:3],rxstatus_out[8:6],rxstatus_out[11:9],rxstatus_out[14:12],rxstatus_out[17:15],rxstatus_out[20:18],rxstatus_out[23:21]};                                      
    assign GT_BUFGTRESET          = {bufgtreset_out[2:0],bufgtreset_out[5:3],bufgtreset_out[8:6],bufgtreset_out[11:9],bufgtreset_out[14:12],bufgtreset_out[17:15],bufgtreset_out[20:18],bufgtreset_out[23:21]};                                      
    assign GT_RXBUFSTATUS         = {rxbufstatus_out[2:0],rxbufstatus_out[5:3],rxbufstatus_out[8:6],rxbufstatus_out[11:9],rxbufstatus_out[14:12],rxbufstatus_out[17:15],rxbufstatus_out[20:18],rxbufstatus_out[23:21]};                                                    
    assign GT_BUFGTCEMASK         = {bufgtcemask_out[2:0],bufgtcemask_out[5:3],bufgtcemask_out[8:6],bufgtcemask_out[11:9],bufgtcemask_out[14:12],bufgtcemask_out[17:15],bufgtcemask_out[20:18],bufgtcemask_out[23:21]};                                      
    assign GT_BUFGTRSTMASK        = {bufgtrstmask_out[2:0],bufgtrstmask_out[5:3],bufgtrstmask_out[8:6],bufgtrstmask_out[11:9],bufgtrstmask_out[14:12],bufgtrstmask_out[17:15],bufgtrstmask_out[20:18],bufgtrstmask_out[23:21]};                                      

    assign rxpd_in                = {GT_POWERDOWN[1:0],GT_POWERDOWN[3:2],GT_POWERDOWN[5:4],GT_POWERDOWN[7:6],GT_POWERDOWN[9:8],GT_POWERDOWN[11:10],GT_POWERDOWN[13:12],GT_POWERDOWN[15:14]};
    assign txpd_in                = {GT_POWERDOWN[1:0],GT_POWERDOWN[3:2],GT_POWERDOWN[5:4],GT_POWERDOWN[7:6],GT_POWERDOWN[9:8],GT_POWERDOWN[11:10],GT_POWERDOWN[13:12],GT_POWERDOWN[15:14]};

    assign rxprbssel_in           = {GT_PRBSSEL[3:0],GT_PRBSSEL[7:4],GT_PRBSSEL[11:8],GT_PRBSSEL[15:12],GT_PRBSSEL[19:16],GT_PRBSSEL[23:20],GT_PRBSSEL[27:24],GT_PRBSSEL[31:28]};
    assign txprbssel_in           = {GT_PRBSSEL[3:0],GT_PRBSSEL[7:4],GT_PRBSSEL[11:8],GT_PRBSSEL[15:12],GT_PRBSSEL[19:16],GT_PRBSSEL[23:20],GT_PRBSSEL[27:24],GT_PRBSSEL[31:28]};
    assign txprecursor_in         = {GT_TXPRECURSOR[4:0],GT_TXPRECURSOR[9:5],GT_TXPRECURSOR[14:10],GT_TXPRECURSOR[19:15],GT_TXPRECURSOR[24:20],GT_TXPRECURSOR[29:25],GT_TXPRECURSOR[34:30],GT_TXPRECURSOR[39:35]};
    assign txpostcursor_in        = {GT_TXPOSTCURSOR[4:0],GT_TXPOSTCURSOR[9:5],GT_TXPOSTCURSOR[14:10],GT_TXPOSTCURSOR[19:15],GT_TXPOSTCURSOR[24:20],GT_TXPOSTCURSOR[29:25],GT_TXPOSTCURSOR[34:30],GT_TXPOSTCURSOR[39:35]};
    assign txmaincursor_in        = {GT_TXMAINCURSOR[6:0],GT_TXMAINCURSOR[13:7],GT_TXMAINCURSOR[20:14],GT_TXMAINCURSOR[27:21],GT_TXMAINCURSOR[34:28],GT_TXMAINCURSOR[41:35],GT_TXMAINCURSOR[48:42],GT_TXMAINCURSOR[55:49]};

    assign GT_BUFGTDIV            = {bufgtdiv_out[8:0],bufgtdiv_out[17:9],bufgtdiv_out[26:18],bufgtdiv_out[35:27],bufgtdiv_out[44:36],bufgtdiv_out[53:45],bufgtdiv_out[62:54],bufgtdiv_out[71:63]};                                      
    assign GT_DMONITOROUT         = {dmonitorout_out[16:0],dmonitorout_out[33:17],dmonitorout_out[50:34],dmonitorout_out[67:51],dmonitorout_out[84:68],dmonitorout_out[101:85],dmonitorout_out[118:102],dmonitorout_out[135:119]};     

    assign txdata_in[1023:896]  = {96'd0,GT_TXDATA[31:0]};        // Lane - 0 -to X0Y7                                
    assign txdata_in[895:768]   = {96'd0,GT_TXDATA[63:32]};                                        
    assign txdata_in[767:640]   = {96'd0,GT_TXDATA[95:64]};                                        
    assign txdata_in[639:512]   = {96'd0,GT_TXDATA[127:96]};                                        
    assign txdata_in[511:384]   = {96'd0,GT_TXDATA[159:128]};                                        
    assign txdata_in[383:256]   = {96'd0,GT_TXDATA[191:160]};                                        
    assign txdata_in[255:128]   = {96'd0,GT_TXDATA[223:192]};                                        
    assign txdata_in[127:0]     = {96'd0,GT_TXDATA[255:224]};                                        
                                                                             
    assign txctrl2_in[63:56]    = {6'd0,GT_TXDATAK[1:0]};        // Lane - 0 -to X0Y7
    assign txctrl2_in[55:48]    = {6'd0,GT_TXDATAK[3:2]};
    assign txctrl2_in[47:40]    = {6'd0,GT_TXDATAK[5:4]};
    assign txctrl2_in[39:32]    = {6'd0,GT_TXDATAK[7:6]};
    assign txctrl2_in[31:24]    = {6'd0,GT_TXDATAK[9:8]};
    assign txctrl2_in[23:16]    = {6'd0,GT_TXDATAK[11:10]};
    assign txctrl2_in[15:8]     = {6'd0,GT_TXDATAK[13:12]};
    assign txctrl2_in[7:0]      = {6'd0,GT_TXDATAK[15:14]};
   
    assign txctrl0_in[127:112]  = {10'd0,GT_TXSYNC_HEADER[1:0],GT_TXSTART_BLOCK[0],GT_TXDATA_VALID[0],2'd0};     // Lane - 0 -to X0Y7                                    
    assign txctrl0_in[111:96]   = {10'd0,GT_TXSYNC_HEADER[3:2],GT_TXSTART_BLOCK[1],GT_TXDATA_VALID[1],2'd0};                                      
    assign txctrl0_in[95:80]    = {10'd0,GT_TXSYNC_HEADER[5:4],GT_TXSTART_BLOCK[2],GT_TXDATA_VALID[2],2'd0};                                      
    assign txctrl0_in[79:64]    = {10'd0,GT_TXSYNC_HEADER[7:6],GT_TXSTART_BLOCK[3],GT_TXDATA_VALID[3],2'd0};                                      
    assign txctrl0_in[63:48]    = {10'd0,GT_TXSYNC_HEADER[9:8],GT_TXSTART_BLOCK[4],GT_TXDATA_VALID[4],2'd0};                                      
    assign txctrl0_in[47:32]    = {10'd0,GT_TXSYNC_HEADER[11:10],GT_TXSTART_BLOCK[5],GT_TXDATA_VALID[5],2'd0};                                      
    assign txctrl0_in[31:16]    = {10'd0,GT_TXSYNC_HEADER[13:12],GT_TXSTART_BLOCK[6],GT_TXDATA_VALID[6],2'd0};                                      
    assign txctrl0_in[15:0]     = {10'd0,GT_TXSYNC_HEADER[15:14],GT_TXSTART_BLOCK[7],GT_TXDATA_VALID[7],2'd0};                                      
    
    assign txctrl1_in[127:112]  = {15'd0,GT_TXCOMPLIANCE[0]};                  // Lane - 0 -to X0Y7                    
    assign txctrl1_in[111:96]   = {15'd0,GT_TXCOMPLIANCE[1]};                            
    assign txctrl1_in[95:80]    = {15'd0,GT_TXCOMPLIANCE[2]};                            
    assign txctrl1_in[79:64]    = {15'd0,GT_TXCOMPLIANCE[3]};                            
    assign txctrl1_in[63:48]    = {15'd0,GT_TXCOMPLIANCE[4]};                            
    assign txctrl1_in[47:32]    = {15'd0,GT_TXCOMPLIANCE[5]};                            
    assign txctrl1_in[31:16]    = {15'd0,GT_TXCOMPLIANCE[6]};                            
    assign txctrl1_in[15:0]     = {15'd0,GT_TXCOMPLIANCE[7]};                            
                                                                                          
    assign GT_RXDATA[255:224]  = rxdata_out[31:0];             
    assign GT_RXDATA[223:192]  = rxdata_out[159:128];  
    assign GT_RXDATA[191:160]  = rxdata_out[287:256];  
    assign GT_RXDATA[159:128]  = rxdata_out[415:384];  
    assign GT_RXDATA[127:96]   = rxdata_out[543:512];  
    assign GT_RXDATA[95:64]    = rxdata_out[671:640];  
    assign GT_RXDATA[63:32]    = rxdata_out[799:768];  
    assign GT_RXDATA[31:0]     = rxdata_out[927:896];    // Lane - 0 -to X0Y7 

    assign GT_RXDATAK[15:14]   = rxctrl0_out[1:0];           
    assign GT_RXDATAK[13:12]   = rxctrl0_out[17:16];
    assign GT_RXDATAK[11:10]   = rxctrl0_out[33:32];
    assign GT_RXDATAK[9:8]     = rxctrl0_out[49:48];
    assign GT_RXDATAK[7:6]     = rxctrl0_out[65:64];
    assign GT_RXDATAK[5:4]     = rxctrl0_out[81:80];
    assign GT_RXDATAK[3:2]     = rxctrl0_out[97:96];
    assign GT_RXDATAK[1:0]     = rxctrl0_out[113:112];  // Lane - 0 -to X0Y7 

    assign GT_RXDATA_VALID[7]  = rxctrl0_out[2];           
    assign GT_RXDATA_VALID[6]  = rxctrl0_out[18];
    assign GT_RXDATA_VALID[5]  = rxctrl0_out[34];
    assign GT_RXDATA_VALID[4]  = rxctrl0_out[50];
    assign GT_RXDATA_VALID[3]  = rxctrl0_out[66];
    assign GT_RXDATA_VALID[2]  = rxctrl0_out[82];
    assign GT_RXDATA_VALID[1]  = rxctrl0_out[98];
    assign GT_RXDATA_VALID[0]  = rxctrl0_out[114];   // Lane - 0 -to X0Y7 

    assign GT_RXSTART_BLOCK[7] = rxctrl0_out[3];             
    assign GT_RXSTART_BLOCK[6] = rxctrl0_out[19];
    assign GT_RXSTART_BLOCK[5] = rxctrl0_out[35];
    assign GT_RXSTART_BLOCK[4] = rxctrl0_out[51];
    assign GT_RXSTART_BLOCK[3] = rxctrl0_out[67];
    assign GT_RXSTART_BLOCK[2] = rxctrl0_out[83];
    assign GT_RXSTART_BLOCK[1] = rxctrl0_out[99];
    assign GT_RXSTART_BLOCK[0] = rxctrl0_out[115];  // Lane - 0 -to X0Y7 

    assign GT_RXSYNC_HEADER[15:14] = rxctrl0_out[5:4];           
    assign GT_RXSYNC_HEADER[13:12] = rxctrl0_out[21:20];
    assign GT_RXSYNC_HEADER[11:10] = rxctrl0_out[37:36];
    assign GT_RXSYNC_HEADER[9:8]   = rxctrl0_out[53:52];
    assign GT_RXSYNC_HEADER[7:6]   = rxctrl0_out[69:68];
    assign GT_RXSYNC_HEADER[5:4]   = rxctrl0_out[85:84];
    assign GT_RXSYNC_HEADER[3:2]   = rxctrl0_out[101:100];
    assign GT_RXSYNC_HEADER[1:0]   = rxctrl0_out[117:116]; // Lane - 0 -to X0Y7 

    //----------------------------------------------------------------------------------------------
    //  PHY Quad - Generate one Quad for every four Lanes
    //----------------------------------------------------------------------------------------------
    //  Generate QPLL Powerdown and Reset
    //----------------------------------------------------------------------
    //  * QPLL reset and powerdown for Quad 1 driven by       Master Lane 0
    //  * QPLL reset and powerdown for Quad 2 driven by Local Master Lane 4
    //----------------------------------------------------------------------        
    assign qpll1pd_in[0]    = (GTCOM_QPLL1PD[1]    || pcierateqpllpd_out[8]);     // Quad-X0Y0 - 1
    assign qpll1reset_in[0] = (GTCOM_QPLL1RESET[1] || pcierateqpllreset_out[8]);  // Quad-X0Y0 - 1
    assign qpll1pd_in[1]    = (GTCOM_QPLL1PD[0]    || pcierateqpllpd_out[0]);     // Quad-X0Y1 - 0
    assign qpll1reset_in[1] = (GTCOM_QPLL1RESET[0] || pcierateqpllreset_out[0]);  // Quad-X0Y1 - 0
             
    assign qpllrsvd2_3     = {{2'd0,1'd1, GT_RATE[1:0]},{2'd0,1'd1, GT_RATE[1:0]}};   // From [TX/RX]RATE port
    //----------------------------------------------------------------------        
    assign GT_CPLLLOCK          = {cplllock_out[0],cplllock_out[1],cplllock_out[2],cplllock_out[3],cplllock_out[4],cplllock_out[5],cplllock_out[6],cplllock_out[7]};
    assign GT_PCIERATEQPLLPD    = {pcierateqpllpd_out[1:0],pcierateqpllpd_out[3:2],pcierateqpllpd_out[5:4],pcierateqpllpd_out[7:6],pcierateqpllpd_out[9:8],pcierateqpllpd_out[11:10],pcierateqpllpd_out[13:12],pcierateqpllpd_out[15:14]};              
    assign GT_PCIERATEQPLLRESET = {pcierateqpllreset_out[1:0],pcierateqpllreset_out[3:2],pcierateqpllreset_out[5:4],pcierateqpllreset_out[7:6],pcierateqpllreset_out[9:8],pcierateqpllreset_out[11:10],pcierateqpllreset_out[13:12],pcierateqpllreset_out[15:14]};    

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    assign GTCOM_QPLL1LOCK      = qpll1lock_out;
    assign GTCOM_QPLL1OUTCLK    = qpll1outclk_out;
    assign GTCOM_QPLL1OUTREFCLK = qpll1outrefclk_out;
    assign GTCOM_DRPRDY = 0;    
    assign GTCOM_DRPDO  = 0;         
endmodule

(* X_CORE_INFO = "rp_gt_gtwizard_top,Vivado 2015.1.0" *)
(* CHECK_LICENSE_TYPE = "rp_gt,rp_gt_gtwizard_top,{}" *)
(* CORE_GENERATION_INFO = "rp_gt,rp_gt_gtwizard_top,{x_ipProduct=Vivado 2015.1.0,x_ipVendor=xilinx.com,x_ipLibrary=ip,x_ipName=gtwizard_ultrascale,x_ipVersion=1.5,x_ipCoreRevision=1,x_ipLanguage=VERILOG,x_ipSimLanguage=MIXED,C_CHANNEL_ENABLE=000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111,C_COMMON_SCALING_FACTOR=2,C_CPLL_VCO_FREQUENCY=2000.0,C_FORCE_COMMONS=0,C_FREERUN_FREQUENCY=200,C_GT_TYPE=0,C_GT_REV=11,C_INCLUDE_CPLL_CAL=1,C_LOCATE_COMMON=0,C_LOCATE_RESET_CONTROLLER=1,C_LOCATE_USER_DATA_WIDTH_SIZING=1,C_LOCATE_RX_BUFFER_BYPASS_CONTROLLER=0,C_LOCATE_IN_SYSTEM_IBERT_CORE=2,C_LOCATE_RX_USER_CLOCKING=1,C_LOCATE_TX_BUFFER_BYPASS_CONTROLLER=1,C_LOCATE_TX_USER_CLOCKING=1,C_RESET_CONTROLLER_INSTANCE_CTRL=0,C_RX_BUFFBYPASS_MODE=0,C_RX_BUFFER_BYPASS_INSTANCE_CTRL=0,C_RX_BUFFER_MODE=1,C_RX_CB_DISP=00000000,C_RX_CB_K=00000000,C_RX_CB_MAX_LEVEL=4,C_RX_CB_LEN_SEQ=1,C_RX_CB_NUM_SEQ=0,C_RX_CB_VAL=00000000000000000000000000000000000000000000000000000000000000000000000000000000,C_RX_CC_DISP=00000000,C_RX_CC_ENABLE=1,C_RX_CC_K=00000001,C_RX_CC_LEN_SEQ=1,C_RX_CC_NUM_SEQ=1,C_RX_CC_PERIODICITY=5000,C_RX_CC_VAL=00000000000000000000000000000000000000000000000000000000000000000000000000011100,C_RX_COMMA_M_ENABLE=1,C_RX_COMMA_M_VAL=1010000011,C_RX_COMMA_P_ENABLE=1,C_RX_COMMA_P_VAL=0101111100,C_RX_DATA_DECODING=1,C_RX_ENABLE=1,C_RX_INT_DATA_WIDTH=20,C_RX_LINE_RATE=8,C_RX_MASTER_CHANNEL_IDX=7,C_RX_OUTCLK_BUFG_GT_DIV=1,C_RX_OUTCLK_FREQUENCY=400.0000000,C_RX_OUTCLK_SOURCE=1,C_RX_PLL_TYPE=1,C_RX_RECCLK_OUTPUT=0x000000000000000000000000000000000000000000000000,C_RX_REFCLK_FREQUENCY=100,C_RX_SLIDE_MODE=2,C_RX_USER_CLOCKING_CONTENTS=0,C_RX_USER_CLOCKING_INSTANCE_CTRL=0,C_RX_USER_CLOCKING_RATIO_FSRC_FUSRCLK=1,C_RX_USER_CLOCKING_RATIO_FUSRCLK_FUSRCLK2=1,C_RX_USER_CLOCKING_SOURCE=0,C_RX_USER_DATA_WIDTH=16,C_RX_USRCLK_FREQUENCY=400.0000000,C_RX_USRCLK2_FREQUENCY=400.0000000,C_SECONDARY_QPLL_ENABLE=0,C_SECONDARY_QPLL_REFCLK_FREQUENCY=257.8125,C_TOTAL_NUM_CHANNELS=8,C_TOTAL_NUM_COMMONS=2,C_TOTAL_NUM_COMMONS_EXAMPLE=0,C_TXPROGDIV_FREQ_ENABLE=1,C_TXPROGDIV_FREQ_SOURCE=2,C_TXPROGDIV_FREQ_VAL=400,C_TX_BUFFBYPASS_MODE=0,C_TX_BUFFER_BYPASS_INSTANCE_CTRL=0,C_TX_BUFFER_MODE=0,C_TX_DATA_ENCODING=1,C_TX_ENABLE=1,C_TX_INT_DATA_WIDTH=20,C_TX_LINE_RATE=8,C_TX_MASTER_CHANNEL_IDX=7,C_TX_OUTCLK_BUFG_GT_DIV=1,C_TX_OUTCLK_FREQUENCY=400.0000000,C_TX_OUTCLK_SOURCE=4,C_TX_PLL_TYPE=1,C_TX_REFCLK_FREQUENCY=100,C_TX_USER_CLOCKING_CONTENTS=0,C_TX_USER_CLOCKING_INSTANCE_CTRL=0,C_TX_USER_CLOCKING_RATIO_FSRC_FUSRCLK=1,C_TX_USER_CLOCKING_RATIO_FUSRCLK_FUSRCLK2=1,C_TX_USER_CLOCKING_SOURCE=0,C_TX_USER_DATA_WIDTH=16,C_TX_USRCLK_FREQUENCY=400.0000000,C_TX_USRCLK2_FREQUENCY=400.0000000}" *)
(* DowngradeIPIdentifiedWarnings = "yes" *)
module rp_gt (
  gtwiz_userclk_tx_reset_in,
  gtwiz_userclk_tx_active_in,
  gtwiz_userclk_rx_active_in,
  gtwiz_reset_tx_done_in,
  gtwiz_reset_rx_done_in,
  gtwiz_gthe3_cpll_cal_txoutclk_period_in,
  gtwiz_gthe3_cpll_cal_cnt_tol_in,
  gtwiz_gthe3_cpll_cal_bufg_ce_in,
  gtrefclk01_in,
  qpll1pd_in,
  qpll1reset_in,
  qpllrsvd2_in,
  qpllrsvd3_in,
  qpll1lock_out,
  qpll1outclk_out,
  qpll1outrefclk_out,
  cpllpd_in,
  cpllreset_in,
  drpclk_in,
  gthrxn_in,
  gthrxp_in,
  gtrefclk0_in,
  gtrxreset_in,
  gttxreset_in,
  loopback_in,
  pcieeqrxeqadaptdone_in,
  pcierstidle_in,
  pciersttxsyncstart_in,
  pcieuserratedone_in,
  pcsrsvdin_in,
  rx8b10ben_in,
  rxbufreset_in,
  rxcdrhold_in,
  rxcommadeten_in,
  rxlpmen_in,
  rxmcommaalignen_in,
  rxpcommaalignen_in,
  rxpd_in,
  rxpolarity_in,
  rxprbscntreset_in,
  rxprbssel_in,
  rxprogdivreset_in,
  rxrate_in,
  rxslide_in,
  rxuserrdy_in,
  rxusrclk_in,
  rxusrclk2_in,
  tx8b10ben_in,
  txctrl0_in,
  txctrl1_in,
  txctrl2_in,
  txdata_in,
  txdeemph_in,
  txdetectrx_in,
  txdlybypass_in,
  txdlyen_in,
  txdlyhold_in,
  txdlyovrden_in,
  txdlysreset_in,
  txdlyupdown_in,
  txelecidle_in,
  txmaincursor_in,
  txmargin_in,
  txpd_in,
  txphalign_in,
  txphalignen_in,
  txphdlypd_in,
  txphdlyreset_in,
  txphdlytstclk_in,
  txphinit_in,
  txphovrden_in,
  txpostcursor_in,
  txprbsforceerr_in,
  txinhibit_in,
  txprbssel_in,
  txprecursor_in,
  txprogdivreset_in,
  txrate_in,
  txswing_in,
  txsyncallin_in,
  txsyncin_in,
  txsyncmode_in,
  txuserrdy_in,
  txusrclk_in,
  txusrclk2_in,
  bufgtce_out,
  bufgtcemask_out,
  bufgtdiv_out,
  bufgtreset_out,
  bufgtrstmask_out,
  cplllock_out,
  dmonitorout_out,
  eyescandataerror_out,
  gthtxn_out,
  gthtxp_out,
  gtpowergood_out,
  pcierategen3_out,
  pcierateidle_out,
  pcierateqpllpd_out,
  pcierateqpllreset_out,
  pciesynctxsyncdone_out,
  pcieusergen3rdy_out,
  pcieuserphystatusrst_out,
  pcieuserratestart_out,
  pcsrsvdout_out,
  phystatus_out,
  rxbufstatus_out,
  rxbyteisaligned_out,
  rxbyterealign_out,
  rxcdrlock_out,
  rxclkcorcnt_out,
  rxcommadet_out,
  rxctrl0_out,
  rxctrl1_out,
  rxctrl2_out,
  rxctrl3_out,
  rxdata_out,
  rxdlysresetdone_out,
  rxelecidle_out,
  rxoutclk_out,
  rxphaligndone_out,
  rxpmaresetdone_out,
  rxprbserr_out,
  rxprbslocked_out,
  rxprgdivresetdone_out,
  rxresetdone_out,
  rxstatus_out,
  rxsyncdone_out,
  rxvalid_out,
  txdlysresetdone_out,
  txoutclk_out,
  txphaligndone_out,
  txphinitdone_out,
  txpmaresetdone_out,
  txprgdivresetdone_out,
  txresetdone_out,
  txsyncdone_out,
  txsyncout_out
);

input wire [0 : 0] gtwiz_userclk_tx_reset_in;
input wire [0 : 0] gtwiz_userclk_tx_active_in;
input wire [0 : 0] gtwiz_userclk_rx_active_in;
input wire [0 : 0] gtwiz_reset_tx_done_in;
input wire [0 : 0] gtwiz_reset_rx_done_in;
input wire [143 : 0] gtwiz_gthe3_cpll_cal_txoutclk_period_in;
input wire [143 : 0] gtwiz_gthe3_cpll_cal_cnt_tol_in;
input wire [7 : 0] gtwiz_gthe3_cpll_cal_bufg_ce_in;
input wire [1 : 0] gtrefclk01_in;
input wire [1 : 0] qpll1pd_in;
input wire [1 : 0] qpll1reset_in;
input wire [9 : 0] qpllrsvd2_in;
input wire [9 : 0] qpllrsvd3_in;
output wire [1 : 0] qpll1lock_out;
output wire [1 : 0] qpll1outclk_out;
output wire [1 : 0] qpll1outrefclk_out;
input wire [7 : 0] cpllpd_in;
input wire [7 : 0] cpllreset_in;
input wire [7 : 0] drpclk_in;
input wire [7 : 0] gthrxn_in;
input wire [7 : 0] gthrxp_in;
input wire [7 : 0] gtrefclk0_in;
input wire [7 : 0] gtrxreset_in;
input wire [7 : 0] gttxreset_in;
input wire [23 : 0] loopback_in;
input wire [7 : 0] pcieeqrxeqadaptdone_in;
input wire [7 : 0] pcierstidle_in;
input wire [7 : 0] pciersttxsyncstart_in;
input wire [7 : 0] pcieuserratedone_in;
input wire [127 : 0] pcsrsvdin_in;
input wire [7 : 0] rx8b10ben_in;
input wire [7 : 0] rxbufreset_in;
input wire [7 : 0] rxcdrhold_in;
input wire [7 : 0] rxcommadeten_in;
input wire [7 : 0] rxlpmen_in;
input wire [7 : 0] rxmcommaalignen_in;
input wire [7 : 0] rxpcommaalignen_in;
input wire [15 : 0] rxpd_in;
input wire [7 : 0] rxpolarity_in;
input wire [7 : 0] rxprbscntreset_in;
input wire [31 : 0] rxprbssel_in;
input wire [7 : 0] rxprogdivreset_in;
input wire [23 : 0] rxrate_in;
input wire [7 : 0] rxslide_in;
input wire [7 : 0] rxuserrdy_in;
input wire [7 : 0] rxusrclk_in;
input wire [7 : 0] rxusrclk2_in;
input wire [7 : 0] tx8b10ben_in;
input wire [127 : 0] txctrl0_in;
input wire [127 : 0] txctrl1_in;
input wire [63 : 0] txctrl2_in;
input wire [1023 : 0] txdata_in;
input wire [7 : 0] txdeemph_in;
input wire [7 : 0] txdetectrx_in;
input wire [7 : 0] txdlybypass_in;
input wire [7 : 0] txdlyen_in;
input wire [7 : 0] txdlyhold_in;
input wire [7 : 0] txdlyovrden_in;
input wire [7 : 0] txdlysreset_in;
input wire [7 : 0] txdlyupdown_in;
input wire [7 : 0] txelecidle_in;
input wire [55 : 0] txmaincursor_in;
input wire [23 : 0] txmargin_in;
input wire [15 : 0] txpd_in;
input wire [7 : 0] txphalign_in;
input wire [7 : 0] txphalignen_in;
input wire [7 : 0] txphdlypd_in;
input wire [7 : 0] txphdlyreset_in;
input wire [7 : 0] txphdlytstclk_in;
input wire [7 : 0] txphinit_in;
input wire [7 : 0] txphovrden_in;
input wire [39 : 0] txpostcursor_in;
input wire [7 : 0] txprbsforceerr_in;
input wire [7 : 0] txinhibit_in;
input wire [31 : 0] txprbssel_in;
input wire [39 : 0] txprecursor_in;
input wire [7 : 0] txprogdivreset_in;
input wire [23 : 0] txrate_in;
input wire [7 : 0] txswing_in;
input wire [7 : 0] txsyncallin_in;
input wire [7 : 0] txsyncin_in;
input wire [7 : 0] txsyncmode_in;
input wire [7 : 0] txuserrdy_in;
input wire [7 : 0] txusrclk_in;
input wire [7 : 0] txusrclk2_in;
output wire [23 : 0] bufgtce_out;
output wire [23 : 0] bufgtcemask_out;
output wire [71 : 0] bufgtdiv_out;
output wire [23 : 0] bufgtreset_out;
output wire [23 : 0] bufgtrstmask_out;
output wire [7 : 0] cplllock_out;
output wire [135 : 0] dmonitorout_out;
output wire [7 : 0] eyescandataerror_out;
output wire [7 : 0] gthtxn_out;
output wire [7 : 0] gthtxp_out;
output wire [7 : 0] gtpowergood_out;
output wire [7 : 0] pcierategen3_out;
output wire [7 : 0] pcierateidle_out;
output wire [15 : 0] pcierateqpllpd_out;
output wire [15 : 0] pcierateqpllreset_out;
output wire [7 : 0] pciesynctxsyncdone_out;
output wire [7 : 0] pcieusergen3rdy_out;
output wire [7 : 0] pcieuserphystatusrst_out;
output wire [7 : 0] pcieuserratestart_out;
output wire [95 : 0] pcsrsvdout_out;
output wire [7 : 0] phystatus_out;
output wire [23 : 0] rxbufstatus_out;
output wire [7 : 0] rxbyteisaligned_out;
output wire [7 : 0] rxbyterealign_out;
output wire [7 : 0] rxcdrlock_out;
output wire [15 : 0] rxclkcorcnt_out;
output wire [7 : 0] rxcommadet_out;
output wire [127 : 0] rxctrl0_out;
output wire [127 : 0] rxctrl1_out;
output wire [63 : 0] rxctrl2_out;
output wire [63 : 0] rxctrl3_out;
output wire [1023 : 0] rxdata_out;
output wire [7 : 0] rxdlysresetdone_out;
output wire [7 : 0] rxelecidle_out;
output wire [7 : 0] rxoutclk_out;
output wire [7 : 0] rxphaligndone_out;
output wire [7 : 0] rxpmaresetdone_out;
output wire [7 : 0] rxprbserr_out;
output wire [7 : 0] rxprbslocked_out;
output wire [7 : 0] rxprgdivresetdone_out;
output wire [7 : 0] rxresetdone_out;
output wire [23 : 0] rxstatus_out;
output wire [7 : 0] rxsyncdone_out;
output wire [7 : 0] rxvalid_out;
output wire [7 : 0] txdlysresetdone_out;
output wire [7 : 0] txoutclk_out;
output wire [7 : 0] txphaligndone_out;
output wire [7 : 0] txphinitdone_out;
output wire [7 : 0] txpmaresetdone_out;
output wire [7 : 0] txprgdivresetdone_out;
output wire [7 : 0] txresetdone_out;
output wire [7 : 0] txsyncdone_out;
output wire [7 : 0] txsyncout_out;

  rp_gt_gtwizard_top #(
    .C_CHANNEL_ENABLE(192'B000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111),
    .C_COMMON_SCALING_FACTOR(2),
    .C_CPLL_VCO_FREQUENCY(2000.0),
    .C_FORCE_COMMONS(0),
    .C_FREERUN_FREQUENCY(200),
    .C_GT_TYPE(0),
    .C_GT_REV(11),
    .C_INCLUDE_CPLL_CAL(1),
    .C_LOCATE_COMMON(0),
    .C_LOCATE_RESET_CONTROLLER(1),
    .C_LOCATE_USER_DATA_WIDTH_SIZING(1),
    .C_LOCATE_RX_BUFFER_BYPASS_CONTROLLER(0),
    .C_LOCATE_IN_SYSTEM_IBERT_CORE(2),
    .C_LOCATE_RX_USER_CLOCKING(1),
    .C_LOCATE_TX_BUFFER_BYPASS_CONTROLLER(1),
    .C_LOCATE_TX_USER_CLOCKING(1),
    .C_RESET_CONTROLLER_INSTANCE_CTRL(0),
    .C_RX_BUFFBYPASS_MODE(0),
    .C_RX_BUFFER_BYPASS_INSTANCE_CTRL(0),
    .C_RX_BUFFER_MODE(1),
    .C_RX_CB_DISP(8'B00000000),
    .C_RX_CB_K(8'B00000000),
    .C_RX_CB_MAX_LEVEL(4),
    .C_RX_CB_LEN_SEQ(1),
    .C_RX_CB_NUM_SEQ(0),
    .C_RX_CB_VAL(80'B00000000000000000000000000000000000000000000000000000000000000000000000000000000),
    .C_RX_CC_DISP(8'B00000000),
    .C_RX_CC_ENABLE(1),
    .C_RX_CC_K(8'B00000001),
    .C_RX_CC_LEN_SEQ(1),
    .C_RX_CC_NUM_SEQ(1),
    .C_RX_CC_PERIODICITY(5000),
    .C_RX_CC_VAL(80'B00000000000000000000000000000000000000000000000000000000000000000000000000011100),
    .C_RX_COMMA_M_ENABLE(1),
    .C_RX_COMMA_M_VAL(10'B1010000011),
    .C_RX_COMMA_P_ENABLE(1),
    .C_RX_COMMA_P_VAL(10'B0101111100),
    .C_RX_DATA_DECODING(1),
    .C_RX_ENABLE(1),
    .C_RX_INT_DATA_WIDTH(20),
    .C_RX_LINE_RATE(8),
    .C_RX_MASTER_CHANNEL_IDX(7),
    .C_RX_OUTCLK_BUFG_GT_DIV(1),
    .C_RX_OUTCLK_FREQUENCY(400.0000000),
    .C_RX_OUTCLK_SOURCE(1),
    .C_RX_PLL_TYPE(1),
    .C_RX_RECCLK_OUTPUT(192'H000000000000000000000000000000000000000000000000),
    .C_RX_REFCLK_FREQUENCY(100),
    .C_RX_SLIDE_MODE(2),
    .C_RX_USER_CLOCKING_CONTENTS(0),
    .C_RX_USER_CLOCKING_INSTANCE_CTRL(0),
    .C_RX_USER_CLOCKING_RATIO_FSRC_FUSRCLK(1),
    .C_RX_USER_CLOCKING_RATIO_FUSRCLK_FUSRCLK2(1),
    .C_RX_USER_CLOCKING_SOURCE(0),
    .C_RX_USER_DATA_WIDTH(16),
    .C_RX_USRCLK_FREQUENCY(400.0000000),
    .C_RX_USRCLK2_FREQUENCY(400.0000000),
    .C_SECONDARY_QPLL_ENABLE(0),
    .C_SECONDARY_QPLL_REFCLK_FREQUENCY(257.8125),
    .C_TOTAL_NUM_CHANNELS(8),
    .C_TOTAL_NUM_COMMONS(2),
    .C_TOTAL_NUM_COMM