#*****************************************************************************************
# Vivado (TM) v2018.2 (64-bit)
#
# run_vivado_sysmmu_vcu108_tb.tcl: Tcl script for re-creating project 'mm_sys_mm'
#
# Generated by Vivado on Tue Apr 09 21:56:56 EDT 2019
# IP Build 2256618 on Thu Jun 14 22:10:49 MDT 2018
#
# This file contains the Vivado Tcl commands for re-creating the project to the state*
# when this script was generated. In order to re-create the project, please source this
# file in the Vivado Tcl Shell.
#
# * Note that the runs in the created project will be configured the same way as the
#   original project, however they will not be launched automatically. To regenerate the
#   run results please launch the synthesis/implementation runs as needed.
#
#*****************************************************************************************
# NOTE: In order to use this script for source control purposes, please make sure that the
#       following files are added to the source control system:-
#
# 1. This project restoration tcl script (run_vivado_sysmmu_vcu108_tb.tcl) that was generated.
#
# 2. The following source(s) files that were local or imported into the original project.
#    (Please see the '$orig_proj_dir' and '$origin_dir' variable setting below at the start of the script)
#
# 3. The following remote source files that were added to the original project:-
#
#    "$(PRJ_DIR)/mm/ip_sysmmu_segment/top.xdc"
#    "$(PRJ_DIR)/system/vcu108/tb/ddr4_model/arch_defines.v"
#    "$(PRJ_DIR)/system/vcu108/tb/ddr4_model/arch_package.sv"
#    "$(PRJ_DIR)/system/vcu108/tb/ddr4_model/MemoryArray.sv"
#    "$(PRJ_DIR)/system/vcu108/tb/ddr4_model/ddr4_sdram_model_wrapper.sv"
#    "$(PRJ_DIR)/system/vcu108/tb/ddr4_model/proj_package.sv"
#    "$(PRJ_DIR)/system/vcu108/tb/ddr4_model/StateTableCore.sv"
#    "$(PRJ_DIR)/system/vcu108/tb/ddr4_model/StateTable.sv"
#    "$(PRJ_DIR)/system/vcu108/tb/ddr4_model/ddr4_model.sv"
#    "$(PRJ_DIR)/system/vcu108/tb/ddr4_model/ddr4_tb_top.sv"
#    "$(PRJ_DIR)/system/vcu108/tb/ddr4_model/interface.sv"
#    "$(PRJ_DIR)/mm/ip_sysmmu_segment/tb/ddr4_top.v"
#    "$(PRJ_DIR)/system/vcu108/tb/ddr4_model/glbl.v"
#    "$(PRJ_DIR)/system/vcu108/tb/ddr4_model/microblaze_mcs_0.sv"
#    "$(PRJ_DIR)/system/vcu108/tb/ddr4_model/bd_9054_second_lmb_bram_I_0.mem"
#    "$(PRJ_DIR)/system/vcu108/tb/ddr4_model/bd_9054_lmb_bram_I_0.mem"
#    "$(PRJ_DIR)/mm/ip_sysmmu_segment/waveform/sysmmu_tb_top_behav.wcfg"
#
#*****************************************************************************************

# Set the reference directory for source file relative paths (by default the value is script directory path)
set origin_dir "."

# Use origin directory path location variable, if specified in the tcl shell
if { [info exists ::origin_dir_loc] } {
  set origin_dir $::origin_dir_loc
}

# Set the project name
set _xil_proj_name_ "mm_sys_mm"

# Use project name variable, if specified in the tcl shell
if { [info exists ::user_project_name] } {
  set _xil_proj_name_ $::user_project_name
}

variable script_file
set script_file "run_vivado_sysmmu_vcu108_tb.tcl"

# Help information for this script
proc help {} {
  variable script_file
  puts "\nDescription:"
  puts "Recreate a Vivado project from this script. The created project will be"
  puts "functionally equivalent to the original project for which this script was"
  puts "generated. The script contains commands for creating a project, filesets,"
  puts "runs, adding/importing sources and setting properties on various objects.\n"
  puts "Syntax:"
  puts "$script_file"
  puts "$script_file -tclargs \[--origin_dir <path>\]"
  puts "$script_file -tclargs \[--project_name <name>\]"
  puts "$script_file -tclargs \[--help\]\n"
  puts "Usage:"
  puts "Name                   Description"
  puts "-------------------------------------------------------------------------"
  puts "\[--origin_dir <path>\]  Determine source file paths wrt this path. Default"
  puts "                       origin_dir path value is \".\", otherwise, the value"
  puts "                       that was set with the \"-paths_relative_to\" switch"
  puts "                       when this script was generated.\n"
  puts "\[--project_name <name>\] Create project with the specified name. Default"
  puts "                       name is the name of the project from where this"
  puts "                       script was generated.\n"
  puts "\[--help\]               Print help information for this script"
  puts "-------------------------------------------------------------------------\n"
  exit 0
}

if { $::argc > 0 } {
  for {set i 0} {$i < $::argc} {incr i} {
    set option [string trim [lindex $::argv $i]]
    switch -regexp -- $option {
      "--origin_dir"   { incr i; set origin_dir [lindex $::argv $i] }
      "--project_name" { incr i; set _xil_proj_name_ [lindex $::argv $i] }
      "--help"         { help }
      default {
        if { [regexp {^-} $option] } {
          puts "ERROR: Unknown option '$option' specified, please type '$script_file -tclargs --help' for usage info.\n"
          return 1
        }
      }
    }
  }
}

# Set the directory path for the original project from where this script was exported
set orig_proj_dir "[file normalize "$origin_dir/generated_tb"]"

# Create project
create_project -force ${_xil_proj_name_} "./generated_tb" -part xcvu095-ffva2104-2-e

# Set the directory path for the new project
set proj_dir [get_property directory [current_project]]

# Reconstruct message rules
# None

# Set project properties
set obj [current_project]
set_property -name "board_part" -value "xilinx.com:vcu108:part0:1.4" -objects $obj
set_property -name "default_lib" -value "xil_defaultlib" -objects $obj
set_property -name "dsa.accelerator_binary_content" -value "bitstream" -objects $obj
set_property -name "dsa.accelerator_binary_format" -value "xclbin2" -objects $obj
set_property -name "dsa.board_id" -value "vcu108" -objects $obj
set_property -name "dsa.description" -value "Vivado generated DSA" -objects $obj
set_property -name "dsa.dr_bd_base_address" -value "0" -objects $obj
set_property -name "dsa.emu_dir" -value "emu" -objects $obj
set_property -name "dsa.flash_interface_type" -value "bpix16" -objects $obj
set_property -name "dsa.flash_offset_address" -value "0" -objects $obj
set_property -name "dsa.flash_size" -value "1024" -objects $obj
set_property -name "dsa.host_architecture" -value "x86_64" -objects $obj
set_property -name "dsa.host_interface" -value "pcie" -objects $obj
set_property -name "dsa.num_compute_units" -value "60" -objects $obj
set_property -name "dsa.platform_state" -value "pre_synth" -objects $obj
set_property -name "dsa.uses_pr" -value "1" -objects $obj
set_property -name "dsa.vendor" -value "xilinx" -objects $obj
set_property -name "dsa.version" -value "0.0" -objects $obj
set_property -name "enable_vhdl_2008" -value "1" -objects $obj
set_property -name "ip_cache_permissions" -value "read write" -objects $obj
set_property -name "ip_output_repo" -value "$proj_dir/${_xil_proj_name_}.cache/ip" -objects $obj
set_property -name "mem.enable_memory_map_generation" -value "1" -objects $obj
set_property -name "sim.central_dir" -value "$proj_dir/${_xil_proj_name_}.ip_user_files" -objects $obj
set_property -name "sim.ip.auto_export_scripts" -value "1" -objects $obj
set_property -name "simulator_language" -value "Mixed" -objects $obj
set_property -name "webtalk.activehdl_export_sim" -value "30" -objects $obj
set_property -name "webtalk.ies_export_sim" -value "30" -objects $obj
set_property -name "webtalk.modelsim_export_sim" -value "30" -objects $obj
set_property -name "webtalk.questa_export_sim" -value "30" -objects $obj
set_property -name "webtalk.riviera_export_sim" -value "30" -objects $obj
set_property -name "webtalk.vcs_export_sim" -value "30" -objects $obj
set_property -name "webtalk.xcelium_export_sim" -value "2" -objects $obj
set_property -name "webtalk.xsim_export_sim" -value "30" -objects $obj
set_property -name "webtalk.xsim_launch_sim" -value "45" -objects $obj

# Create 'sources_1' fileset (if not found)
if {[string equal [get_filesets -quiet sources_1] ""]} {
  create_fileset -srcset sources_1
}

# Set IP repository paths
set obj [get_filesets sources_1]
set_property "ip_repo_paths" "[file normalize "$origin_dir/../../generated_ip"]" $obj

# Rebuild user ip_repo's index before adding any source files
update_ip_catalog -rebuild


# Set 'sources_1' fileset properties
set obj [get_filesets sources_1]
set_property -name "top" -value "sys_mm_wrapper" -objects $obj

# Create 'constrs_1' fileset (if not found)
if {[string equal [get_filesets -quiet constrs_1] ""]} {
  create_fileset -constrset constrs_1
}

# Set 'constrs_1' fileset object
set obj [get_filesets constrs_1]

# Add/Import constrs file and set constrs file properties
set file "[file normalize "$origin_dir/top.xdc"]"
set file_added [add_files -norecurse -fileset $obj [list $file]]
set file "$origin_dir/top.xdc"
set file [file normalize $file]
set file_obj [get_files -of_objects [get_filesets constrs_1] [list "*$file"]]
set_property -name "file_type" -value "XDC" -objects $file_obj

# Set 'constrs_1' fileset properties
set obj [get_filesets constrs_1]

# Create 'sim_1' fileset (if not found)
if {[string equal [get_filesets -quiet sim_1] ""]} {
  create_fileset -simset sim_1
}

# Set 'sim_1' fileset object
set obj [get_filesets sim_1]
set files [list \
 [file normalize "${origin_dir}/../../system/vcu108/tb/ddr4_model/arch_defines.v"] \
 [file normalize "${origin_dir}/../../system/vcu108/tb/ddr4_model/arch_package.sv"] \
 [file normalize "${origin_dir}/../../system/vcu108/tb/ddr4_model/MemoryArray.sv"] \
 [file normalize "${origin_dir}/../../system/vcu108/tb/ddr4_model/ddr4_sdram_model_wrapper.sv"] \
 [file normalize "${origin_dir}/../../system/vcu108/tb/ddr4_model/proj_package.sv"] \
 [file normalize "${origin_dir}/../../system/vcu108/tb/ddr4_model/StateTableCore.sv"] \
 [file normalize "${origin_dir}/../../system/vcu108/tb/ddr4_model/StateTable.sv"] \
 [file normalize "${origin_dir}/../../system/vcu108/tb/ddr4_model/ddr4_model.sv"] \
 [file normalize "${origin_dir}/../../system/vcu108/tb/ddr4_model/ddr4_tb_top.sv"] \
 [file normalize "${origin_dir}/../../system/vcu108/tb/ddr4_model/interface.sv"] \
 [file normalize "${origin_dir}/tb/ddr4_top.v"] \
 [file normalize "${origin_dir}/../../system/vcu108/tb/ddr4_model/glbl.v"] \
 [file normalize "${origin_dir}/../../system/vcu108/tb/ddr4_model/microblaze_mcs_0.sv"] \
 [file normalize "${origin_dir}/../../system/vcu108/tb/ddr4_model/bd_9054_second_lmb_bram_I_0.mem"] \
 [file normalize "${origin_dir}/../../system/vcu108/tb/ddr4_model/bd_9054_lmb_bram_I_0.mem"] \
 [file normalize "${origin_dir}/waveform/sysmmu_tb_top_behav.wcfg"] \
]
add_files -norecurse -fileset $obj $files

# Set 'sim_1' fileset file properties for remote files
set file "$origin_dir/../../system/vcu108/tb/ddr4_model/arch_package.sv"
set file [file normalize $file]
set file_obj [get_files -of_objects [get_filesets sim_1] [list "*$file"]]
set_property -name "file_type" -value "SystemVerilog" -objects $file_obj

set file "$origin_dir/../../system/vcu108/tb/ddr4_model/MemoryArray.sv"
set file [file normalize $file]
set file_obj [get_files -of_objects [get_filesets sim_1] [list "*$file"]]
set_property -name "file_type" -value "SystemVerilog" -objects $file_obj

set file "$origin_dir/../../system/vcu108/tb/ddr4_model/ddr4_sdram_model_wrapper.sv"
set file [file normalize $file]
set file_obj [get_files -of_objects [get_filesets sim_1] [list "*$file"]]
set_property -name "file_type" -value "SystemVerilog" -objects $file_obj

set file "$origin_dir/../../system/vcu108/tb/ddr4_model/proj_package.sv"
set file [file normalize $file]
set file_obj [get_files -of_objects [get_filesets sim_1] [list "*$file"]]
set_property -name "file_type" -value "SystemVerilog" -objects $file_obj

set file "$origin_dir/../../system/vcu108/tb/ddr4_model/StateTableCore.sv"
set file [file normalize $file]
set file_obj [get_files -of_objects [get_filesets sim_1] [list "*$file"]]
set_property -name "file_type" -value "SystemVerilog" -objects $file_obj

set file "$origin_dir/../../system/vcu108/tb/ddr4_model/StateTable.sv"
set file [file normalize $file]
set file_obj [get_files -of_objects [get_filesets sim_1] [list "*$file"]]
set_property -name "file_type" -value "SystemVerilog" -objects $file_obj

set file "$origin_dir/../../system/vcu108/tb/ddr4_model/ddr4_model.sv"
set file [file normalize $file]
set file_obj [get_files -of_objects [get_filesets sim_1] [list "*$file"]]
set_property -name "file_type" -value "SystemVerilog" -objects $file_obj

set file "$origin_dir/../../system/vcu108/tb/ddr4_model/ddr4_tb_top.sv"
set file [file normalize $file]
set file_obj [get_files -of_objects [get_filesets sim_1] [list "*$file"]]
set_property -name "file_type" -value "SystemVerilog" -objects $file_obj

set file "$origin_dir/../../system/vcu108/tb/ddr4_model/interface.sv"
set file [file normalize $file]
set file_obj [get_files -of_objects [get_filesets sim_1] [list "*$file"]]
set_property -name "file_type" -value "SystemVerilog" -objects $file_obj

set file "$origin_dir/../../system/vcu108/tb/ddr4_model/microblaze_mcs_0.sv"
set file [file normalize $file]
set file_obj [get_files -of_objects [get_filesets sim_1] [list "*$file"]]
set_property -name "file_type" -value "SystemVerilog" -objects $file_obj

set file "$origin_dir/../../system/vcu108/tb/ddr4_model/bd_9054_second_lmb_bram_I_0.mem"
set file [file normalize $file]
set file_obj [get_files -of_objects [get_filesets sim_1] [list "*$file"]]
set_property -name "file_type" -value "Memory File" -objects $file_obj

set file "$origin_dir/../../system/vcu108/tb/ddr4_model/bd_9054_lmb_bram_I_0.mem"
set file [file normalize $file]
set file_obj [get_files -of_objects [get_filesets sim_1] [list "*$file"]]
set_property -name "file_type" -value "Memory File" -objects $file_obj

# Set 'sim_1' fileset file properties for local files
# None

# Set 'sim_1' fileset properties
set obj [get_filesets sim_1]
set_property -name "top" -value "sysmmu_tb_top" -objects $obj
set_property -name "top_auto_set" -value "0" -objects $obj
set_property -name "top_lib" -value "xil_defaultlib" -objects $obj


# Adding sources referenced in BDs, if not already added


# Proc to create BD sys_mm
proc cr_bd_sys_mm { parentCell } {

  # CHANGE DESIGN NAME HERE
  set design_name sys_mm

  common::send_msg_id "BD_TCL-003" "INFO" "Currently there is no design <$design_name> in project, so creating one..."

  create_bd_design $design_name

  set bCheckIPsPassed 1
  ##################################################################
  # CHECK IPs
  ##################################################################
  set bCheckIPs 1
  if { $bCheckIPs == 1 } {
     set list_check_ips "\
  wuklab:user:axi_mmu_wrapper_sync:1.0\
  purdue.wuklab:hls:mm_segment_top:1.0\
  xilinx.com:ip:xlconstant:1.1\
  "

   set list_ips_missing ""
   common::send_msg_id "BD_TCL-006" "INFO" "Checking if the following IPs exist in the project's IP catalog: $list_check_ips ."

   foreach ip_vlnv $list_check_ips {
      set ip_obj [get_ipdefs -all $ip_vlnv]
      if { $ip_obj eq "" } {
         lappend list_ips_missing $ip_vlnv
      }
   }

   if { $list_ips_missing ne "" } {
      catch {common::send_msg_id "BD_TCL-115" "ERROR" "The following IPs are not found in the IP Catalog:\n  $list_ips_missing\n\nResolution: Please add the repository containing the IP(s) to the project." }
      set bCheckIPsPassed 0
   }

  }

  if { $bCheckIPsPassed != 1 } {
    common::send_msg_id "BD_TCL-1003" "WARNING" "Will not continue with creation of design due to the error(s) above."
    return 3
  }

  variable script_folder

  if { $parentCell eq "" } {
     set parentCell [get_bd_cells /]
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_msg_id "BD_TCL-100" "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_msg_id "BD_TCL-101" "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj


  # Create interface ports
  set ctrl_V_0 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:axis_rtl:1.0 ctrl_V_0 ]
  set_property -dict [ list \
   CONFIG.HAS_TKEEP {0} \
   CONFIG.HAS_TLAST {0} \
   CONFIG.HAS_TREADY {1} \
   CONFIG.HAS_TSTRB {0} \
   CONFIG.LAYERED_METADATA {xilinx.com:interface:datatypes:1.0 {TDATA {datatype {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value {}} bitwidth {attribs {resolve_type automatic dependency {} format long minimum {} maximum {}} value 0} bitoffset {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 0} struct {field_opcode {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value opcode} enabled {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value true} datatype {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value {}} bitwidth {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 1} bitoffset {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 0} integer {signed {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value false}}}} field_rw {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value rw} enabled {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value true} datatype {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value {}} bitwidth {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 1} bitoffset {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 1} integer {signed {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value false}}}} field_pid {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value pid} enabled {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value true} datatype {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value {}} bitwidth {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 8} bitoffset {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 2} integer {signed {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value false}}}} field_idx {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value idx} enabled {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value true} datatype {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value {}} bitwidth {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 4} bitoffset {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 10} integer {signed {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value false}}}}}}}}} \
   CONFIG.TDATA_NUM_BYTES {2} \
   CONFIG.TDEST_WIDTH {0} \
   CONFIG.TID_WIDTH {0} \
   CONFIG.TUSER_WIDTH {0} \
   ] $ctrl_V_0
  set ctrl_stat_V_V_0 [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 ctrl_stat_V_V_0 ]
  set m_axi_0 [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:aximm_rtl:1.0 m_axi_0 ]
  set_property -dict [ list \
   CONFIG.ADDR_WIDTH {32} \
   CONFIG.CLK_DOMAIN {sys_mm_s_axi_clk_0} \
   CONFIG.DATA_WIDTH {128} \
   CONFIG.HAS_QOS {0} \
   CONFIG.HAS_REGION {0} \
   CONFIG.NUM_READ_OUTSTANDING {2} \
   CONFIG.NUM_WRITE_OUTSTANDING {2} \
   CONFIG.PROTOCOL {AXI4} \
   ] $m_axi_0
  set s_axi_0 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:aximm_rtl:1.0 s_axi_0 ]
  set_property -dict [ list \
   CONFIG.ADDR_WIDTH {32} \
   CONFIG.ARUSER_WIDTH {1} \
   CONFIG.AWUSER_WIDTH {1} \
   CONFIG.BUSER_WIDTH {1} \
   CONFIG.CLK_DOMAIN {sys_mm_s_axi_clk_0} \
   CONFIG.DATA_WIDTH {128} \
   CONFIG.HAS_BRESP {1} \
   CONFIG.HAS_BURST {1} \
   CONFIG.HAS_CACHE {1} \
   CONFIG.HAS_LOCK {1} \
   CONFIG.HAS_PROT {1} \
   CONFIG.HAS_QOS {0} \
   CONFIG.HAS_REGION {0} \
   CONFIG.HAS_RRESP {1} \
   CONFIG.HAS_WSTRB {1} \
   CONFIG.ID_WIDTH {4} \
   CONFIG.MAX_BURST_LENGTH {256} \
   CONFIG.NUM_READ_OUTSTANDING {2} \
   CONFIG.NUM_READ_THREADS {1} \
   CONFIG.NUM_WRITE_OUTSTANDING {2} \
   CONFIG.NUM_WRITE_THREADS {1} \
   CONFIG.PROTOCOL {AXI4} \
   CONFIG.READ_WRITE_MODE {READ_WRITE} \
   CONFIG.RUSER_BITS_PER_BYTE {0} \
   CONFIG.RUSER_WIDTH {1} \
   CONFIG.SUPPORTS_NARROW_BURST {1} \
   CONFIG.WUSER_BITS_PER_BYTE {0} \
   CONFIG.WUSER_WIDTH {1} \
   ] $s_axi_0

  # Create ports
  set s_aresetn_0 [ create_bd_port -dir I -type rst s_aresetn_0 ]
  set s_axi_clk_0 [ create_bd_port -dir I -type clk s_axi_clk_0 ]
  set_property -dict [ list \
   CONFIG.ASSOCIATED_BUSIF {s_axi_0:m_axi_0:ctrl_V_0:ctrl_stat_V_V_0} \
 ] $s_axi_clk_0

  # Create instance: axi_mmu_wrapper_sync_0, and set properties
  set axi_mmu_wrapper_sync_0 [ create_bd_cell -type ip -vlnv wuklab:user:axi_mmu_wrapper_sync:1.0 axi_mmu_wrapper_sync_0 ]
  set_property -dict [ list \
   CONFIG.AR_BUF_SZ {16} \
   CONFIG.AW_BUF_SZ {16} \
   CONFIG.AXI_ARUSER_WIDTH {1} \
   CONFIG.AXI_AWUSER_WIDTH {1} \
   CONFIG.AXI_BUSER_WIDTH {1} \
   CONFIG.AXI_DATA_WIDTH {128} \
   CONFIG.AXI_ID_WIDTH {4} \
   CONFIG.AXI_RUSER_WIDTH {1} \
   CONFIG.AXI_STRB_WIDTH {16} \
   CONFIG.AXI_WUSER_WIDTH {1} \
 ] $axi_mmu_wrapper_sync_0

  # Create instance: mm_segment_top_0, and set properties
  set mm_segment_top_0 [ create_bd_cell -type ip -vlnv purdue.wuklab:hls:mm_segment_top:1.0 mm_segment_top_0 ]

  # Create instance: xlconstant_0, and set properties
  set xlconstant_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:xlconstant:1.1 xlconstant_0 ]

  # Create interface connections
  connect_bd_intf_net -intf_net axi_mmu_wrapper_sync_0_m_axi [get_bd_intf_ports m_axi_0] [get_bd_intf_pins axi_mmu_wrapper_sync_0/m_axi]
  connect_bd_intf_net -intf_net axi_mmu_wrapper_sync_0_toMM_RD [get_bd_intf_pins axi_mmu_wrapper_sync_0/toMM_RD] [get_bd_intf_pins mm_segment_top_0/rd_in_V]
  connect_bd_intf_net -intf_net axi_mmu_wrapper_sync_0_toMM_WR [get_bd_intf_pins axi_mmu_wrapper_sync_0/toMM_WR] [get_bd_intf_pins mm_segment_top_0/wr_in_V]
  connect_bd_intf_net -intf_net ctrl_V_0_1 [get_bd_intf_ports ctrl_V_0] [get_bd_intf_pins mm_segment_top_0/ctrl_V]
  connect_bd_intf_net -intf_net mm_segment_top_0_ctrl_stat_V_V [get_bd_intf_ports ctrl_stat_V_V_0] [get_bd_intf_pins mm_segment_top_0/ctrl_stat_V_V]
  connect_bd_intf_net -intf_net mm_segment_top_0_rd_out_V [get_bd_intf_pins axi_mmu_wrapper_sync_0/fromMM_RD] [get_bd_intf_pins mm_segment_top_0/rd_out_V]
  connect_bd_intf_net -intf_net mm_segment_top_0_wr_out_V [get_bd_intf_pins axi_mmu_wrapper_sync_0/fromMM_WR] [get_bd_intf_pins mm_segment_top_0/wr_out_V]
  connect_bd_intf_net -intf_net s_axi_0_1 [get_bd_intf_ports s_axi_0] [get_bd_intf_pins axi_mmu_wrapper_sync_0/s_axi]

  # Create port connections
  connect_bd_net -net s_aresetn_0_1 [get_bd_ports s_aresetn_0] [get_bd_pins axi_mmu_wrapper_sync_0/s_aresetn] [get_bd_pins mm_segment_top_0/ap_rst_n]
  connect_bd_net -net s_axi_clk_0_1 [get_bd_ports s_axi_clk_0] [get_bd_pins axi_mmu_wrapper_sync_0/s_axi_clk] [get_bd_pins mm_segment_top_0/ap_clk]
  connect_bd_net -net xlconstant_0_dout [get_bd_pins mm_segment_top_0/ap_start] [get_bd_pins xlconstant_0/dout]

  # Create address segments

  # Exclude Address Segments
  create_bd_addr_seg -range 0x00010000 -offset 0x44A00000 [get_bd_addr_spaces axi_mmu_wrapper_sync_0/m_axi] [get_bd_addr_segs m_axi_0/Reg] SEG_m_axi_0_Reg
  exclude_bd_addr_seg [get_bd_addr_segs axi_mmu_wrapper_sync_0/m_axi/SEG_m_axi_0_Reg]

  create_bd_addr_seg -range 0x000100000000 -offset 0x00000000 [get_bd_addr_spaces s_axi_0] [get_bd_addr_segs axi_mmu_wrapper_sync_0/s_axi/reg0] SEG_axi_mmu_wrapper_sync_0_reg0
  exclude_bd_addr_seg [get_bd_addr_segs s_axi_0/SEG_axi_mmu_wrapper_sync_0_reg0]



  # Restore current instance
  current_bd_instance $oldCurInst

  save_bd_design
  close_bd_design $design_name
}
# End of cr_bd_sys_mm()
cr_bd_sys_mm ""
set_property IS_MANAGED "0" [get_files sys_mm.bd ]
set_property REGISTERED_WITH_MANAGER "1" [get_files sys_mm.bd ]
set_property SYNTH_CHECKPOINT_MODE "Hierarchical" [get_files sys_mm.bd ]

# Yizhou
# We have to manually create the wrapper if we want to use th IP.
# Due to the conflict AXI FREQ_HZ thing.
make_wrapper -files [get_files ${origin_dir}/generated_tb/mm_sys_mm.srcs/sources_1/bd/sys_mm/sys_mm.bd] -top
add_files -norecurse ${origin_dir}/generated_tb/mm_sys_mm.srcs/sources_1/bd/sys_mm/hdl/sys_mm_wrapper.v

# Proc to create BD sys_mm_tb
proc cr_bd_sys_mm_tb { parentCell } {

  # CHANGE DESIGN NAME HERE
  set design_name sys_mm_tb

  common::send_msg_id "BD_TCL-003" "INFO" "Currently there is no design <$design_name> in project, so creating one..."

  create_bd_design $design_name

  set bCheckIPsPassed 1
  ##################################################################
  # CHECK IPs
  ##################################################################
  set bCheckIPs 1
  if { $bCheckIPs == 1 } {
     set list_check_ips "\
  wuklab:user:axi_mmu_wrapper_sync:1.0\
  xilinx.com:ip:axi_traffic_gen:3.0\
  purdue.wuklab:hls:mm_segment_top:1.0\
  xilinx.com:ip:xlconstant:1.1\
  xilinx.com:ip:ddr4:2.2\
  xilinx.com:ip:util_vector_logic:2.0\
  "

   set list_ips_missing ""
   common::send_msg_id "BD_TCL-006" "INFO" "Checking if the following IPs exist in the project's IP catalog: $list_check_ips ."

   foreach ip_vlnv $list_check_ips {
      set ip_obj [get_ipdefs -all $ip_vlnv]
      if { $ip_obj eq "" } {
         lappend list_ips_missing $ip_vlnv
      }
   }

   if { $list_ips_missing ne "" } {
      catch {common::send_msg_id "BD_TCL-115" "ERROR" "The following IPs are not found in the IP Catalog:\n  $list_ips_missing\n\nResolution: Please add the repository containing the IP(s) to the project." }
      set bCheckIPsPassed 0
   }

  }

  if { $bCheckIPsPassed != 1 } {
    common::send_msg_id "BD_TCL-1003" "WARNING" "Will not continue with creation of design due to the error(s) above."
    return 3
  }


# Hierarchical cell: mc
proc create_hier_cell_mc { parentCell nameHier } {

  variable script_folder

  if { $parentCell eq "" || $nameHier eq "" } {
     catch {common::send_msg_id "BD_TCL-102" "ERROR" "create_hier_cell_mc() - Empty argument(s)!"}
     return
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_msg_id "BD_TCL-100" "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_msg_id "BD_TCL-101" "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj

  # Create cell and set as current instance
  set hier_obj [create_bd_cell -type hier $nameHier]
  current_bd_instance $hier_obj

  # Create interface pins
  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:aximm_rtl:1.0 C0_DDR4_S_AXI
  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 C0_SYS_CLK_0
  create_bd_intf_pin -mode Master -vlnv xilinx.com:interface:ddr4_rtl:1.0 DDR4_0

  # Create pins
  create_bd_pin -dir O -from 0 -to 0 -type rst c0_ddr4_aresetn
  create_bd_pin -dir O -type clk c0_ddr4_ui_clk
  create_bd_pin -dir O init_calib_complete_0
  create_bd_pin -dir I -type rst sys_rst_0

  # Create instance: ddr4_0, and set properties
  set ddr4_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:ddr4:2.2 ddr4_0 ]
  set_property -dict [ list \
   CONFIG.C0_DDR4_BOARD_INTERFACE {ddr4_sdram_c1} \
   CONFIG.System_Clock {Differential} \
 ] $ddr4_0

  # Create instance: util_vector_logic_0, and set properties
  set util_vector_logic_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:util_vector_logic:2.0 util_vector_logic_0 ]
  set_property -dict [ list \
   CONFIG.C_OPERATION {not} \
   CONFIG.C_SIZE {1} \
   CONFIG.LOGO_FILE {data/sym_notgate.png} \
 ] $util_vector_logic_0

  # Create interface connections
  connect_bd_intf_net -intf_net Conn1 [get_bd_intf_pins C0_SYS_CLK_0] [get_bd_intf_pins ddr4_0/C0_SYS_CLK]
  connect_bd_intf_net -intf_net axi_mmu_wrapper_sync_0_m_axi [get_bd_intf_pins C0_DDR4_S_AXI] [get_bd_intf_pins ddr4_0/C0_DDR4_S_AXI]
  connect_bd_intf_net -intf_net ddr4_0_C0_DDR4 [get_bd_intf_pins DDR4_0] [get_bd_intf_pins ddr4_0/C0_DDR4]

  # Create port connections
  connect_bd_net -net Net1 [get_bd_pins c0_ddr4_aresetn] [get_bd_pins ddr4_0/c0_ddr4_aresetn] [get_bd_pins util_vector_logic_0/Res]
  connect_bd_net -net ddr4_0_c0_ddr4_ui_clk [get_bd_pins c0_ddr4_ui_clk] [get_bd_pins ddr4_0/c0_ddr4_ui_clk]
  connect_bd_net -net ddr4_0_c0_ddr4_ui_clk_sync_rst [get_bd_pins ddr4_0/c0_ddr4_ui_clk_sync_rst] [get_bd_pins util_vector_logic_0/Op1]
  connect_bd_net -net ddr4_0_c0_init_calib_complete [get_bd_pins init_calib_complete_0] [get_bd_pins ddr4_0/c0_init_calib_complete]
  connect_bd_net -net sys_rst_0_1 [get_bd_pins sys_rst_0] [get_bd_pins ddr4_0/sys_rst]

  # Restore current instance
  current_bd_instance $oldCurInst
}
  variable script_folder

  if { $parentCell eq "" } {
     set parentCell [get_bd_cells /]
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_msg_id "BD_TCL-100" "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_msg_id "BD_TCL-101" "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj


  # Create interface ports
  set C0_SYS_CLK_0 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:diff_clock_rtl:1.0 C0_SYS_CLK_0 ]
  set_property -dict [ list \
   CONFIG.FREQ_HZ {300000000} \
   ] $C0_SYS_CLK_0
  set ctrl [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:axis_rtl:1.0 ctrl ]
  set_property -dict [ list \
   CONFIG.FREQ_HZ {300000000} \
   CONFIG.HAS_TKEEP {0} \
   CONFIG.HAS_TLAST {0} \
   CONFIG.HAS_TREADY {1} \
   CONFIG.HAS_TSTRB {0} \
   CONFIG.LAYERED_METADATA {xilinx.com:interface:datatypes:1.0 {TDATA {datatype {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value {}} bitwidth {attribs {resolve_type automatic dependency {} format long minimum {} maximum {}} value 0} bitoffset {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 0} struct {field_opcode {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value opcode} enabled {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value true} datatype {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value {}} bitwidth {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 1} bitoffset {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 0} integer {signed {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value false}}}} field_rw {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value rw} enabled {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value true} datatype {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value {}} bitwidth {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 1} bitoffset {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 1} integer {signed {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value false}}}} field_pid {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value pid} enabled {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value true} datatype {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value {}} bitwidth {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 8} bitoffset {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 2} integer {signed {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value false}}}} field_idx {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value idx} enabled {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value true} datatype {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value {}} bitwidth {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 4} bitoffset {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 10} integer {signed {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value false}}}}}}}}} \
   CONFIG.TDATA_NUM_BYTES {2} \
   CONFIG.TDEST_WIDTH {0} \
   CONFIG.TID_WIDTH {0} \
   CONFIG.TUSER_WIDTH {0} \
   ] $ctrl
  set ctrl_stat [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 ctrl_stat ]
  set_property -dict [ list \
   CONFIG.FREQ_HZ {300000000} \
   ] $ctrl_stat
  set ddr4_sdram_c1 [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:ddr4_rtl:1.0 ddr4_sdram_c1 ]

  # Create ports
  set core_ext_start_0 [ create_bd_port -dir I core_ext_start_0 ]
  set mc_init_calib_complete [ create_bd_port -dir O mc_init_calib_complete ]
  set pc_asserted_0 [ create_bd_port -dir O pc_asserted_0 ]
  set pc_asserted_1 [ create_bd_port -dir O pc_asserted_1 ]
  set pc_status_0 [ create_bd_port -dir O -from 159 -to 0 pc_status_0 ]
  set pc_status_1 [ create_bd_port -dir O -from 159 -to 0 pc_status_1 ]
  set sys_rst [ create_bd_port -dir I -type rst sys_rst ]
  set_property -dict [ list \
   CONFIG.POLARITY {ACTIVE_HIGH} \
 ] $sys_rst

  # Create instance: axi_mmu_wrapper_sync_0, and set properties
  set axi_mmu_wrapper_sync_0 [ create_bd_cell -type ip -vlnv wuklab:user:axi_mmu_wrapper_sync:1.0 axi_mmu_wrapper_sync_0 ]
  set_property -dict [ list \
   CONFIG.AR_BUF_SZ {16} \
   CONFIG.AW_BUF_SZ {16} \
   CONFIG.AXI_ARUSER_WIDTH {1} \
   CONFIG.AXI_AWUSER_WIDTH {1} \
   CONFIG.AXI_BUSER_WIDTH {1} \
   CONFIG.AXI_DATA_WIDTH {512} \
   CONFIG.AXI_ID_WIDTH {4} \
   CONFIG.AXI_RUSER_WIDTH {1} \
   CONFIG.AXI_STRB_WIDTH {16} \
   CONFIG.AXI_WUSER_WIDTH {1} \
 ] $axi_mmu_wrapper_sync_0

  set_property CONFIG.FREQ_HZ 300000000 [get_bd_intf_pins /axi_mmu_wrapper_sync_0/s_axi]
  set_property CONFIG.FREQ_HZ 300000000 [get_bd_intf_pins /axi_mmu_wrapper_sync_0/m_axi]
  set_property CONFIG.FREQ_HZ 300000000 [get_bd_intf_pins /axi_mmu_wrapper_sync_0/toMM_RD]
  set_property CONFIG.FREQ_HZ 300000000 [get_bd_intf_pins /axi_mmu_wrapper_sync_0/toMM_WR]
  set_property CONFIG.FREQ_HZ 300000000 [get_bd_intf_pins /axi_mmu_wrapper_sync_0/fromMM_RD]
  set_property CONFIG.FREQ_HZ 300000000 [get_bd_intf_pins /axi_mmu_wrapper_sync_0/fromMM_WR]

  # Create instance: axi_traffic_gen_0, and set properties
  set axi_traffic_gen_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_traffic_gen:3.0 axi_traffic_gen_0 ]
  set_property -dict [ list \
   CONFIG.ATG_HLT_STATIC_LENGTH {64} \
   CONFIG.ATG_OPTIONS {High Level Traffic} \
   CONFIG.C_ATG_REPEAT_TYPE {One_Shot} \
   CONFIG.C_ATG_STATIC_HLTP_INCR {true} \
   CONFIG.DATA_SIZE_AVG {8} \
   CONFIG.DATA_SIZE_MAX {64} \
   CONFIG.DATA_TRAFFIC_PATTERN {Fixed} \
   CONFIG.DATA_TRANS_GAP {Random} \
   CONFIG.ETHERNET_LOAD {75} \
   CONFIG.MASTER_AXI_WIDTH {512} \
   CONFIG.MASTER_HIGH_ADDRESS {0x00FFFFFF} \
   CONFIG.TRAFFIC_PROFILE {Data} \
 ] $axi_traffic_gen_0

  # Create instance: mc
  create_hier_cell_mc [current_bd_instance .] mc

  # Create instance: mm_segment_top_0, and set properties
  set mm_segment_top_0 [ create_bd_cell -type ip -vlnv purdue.wuklab:hls:mm_segment_top:1.0 mm_segment_top_0 ]

  # Create instance: wrapper_downstream_checker, and set properties
  set wrapper_downstream_checker [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_protocol_checker:2.0 wrapper_downstream_checker ]
  set_property -dict [ list \
   CONFIG.MAX_WR_BURSTS {16} \
 ] $wrapper_downstream_checker

  # Create instance: wrapper_upstream_checker, and set properties
  set wrapper_upstream_checker [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_protocol_checker:2.0 wrapper_upstream_checker ]
  set_property -dict [ list \
   CONFIG.MAX_RD_BURSTS {32} \
 ] $wrapper_upstream_checker

  # Create instance: xlconstant_0, and set properties
  set xlconstant_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:xlconstant:1.1 xlconstant_0 ]

  # Create interface connections
  connect_bd_intf_net -intf_net C0_SYS_CLK_0_1 [get_bd_intf_ports C0_SYS_CLK_0] [get_bd_intf_pins mc/C0_SYS_CLK_0]
  connect_bd_intf_net -intf_net axi_mmu_wrapper_sync_0_m_axi [get_bd_intf_pins axi_mmu_wrapper_sync_0/m_axi] [get_bd_intf_pins mc/C0_DDR4_S_AXI]
connect_bd_intf_net -intf_net [get_bd_intf_nets axi_mmu_wrapper_sync_0_m_axi] [get_bd_intf_pins mc/C0_DDR4_S_AXI] [get_bd_intf_pins wrapper_downstream_checker/PC_AXI]
  connect_bd_intf_net -intf_net axi_mmu_wrapper_sync_0_toMM_RD [get_bd_intf_pins axi_mmu_wrapper_sync_0/toMM_RD] [get_bd_intf_pins mm_segment_top_0/rd_in_V]
  connect_bd_intf_net -intf_net axi_mmu_wrapper_sync_0_toMM_WR [get_bd_intf_pins axi_mmu_wrapper_sync_0/toMM_WR] [get_bd_intf_pins mm_segment_top_0/wr_in_V]
  connect_bd_intf_net -intf_net axi_traffic_gen_0_M_AXI [get_bd_intf_pins axi_mmu_wrapper_sync_0/s_axi] [get_bd_intf_pins axi_traffic_gen_0/M_AXI]
connect_bd_intf_net -intf_net [get_bd_intf_nets axi_traffic_gen_0_M_AXI] [get_bd_intf_pins axi_traffic_gen_0/M_AXI] [get_bd_intf_pins wrapper_upstream_checker/PC_AXI]
  connect_bd_intf_net -intf_net ctrl_V_0_1 [get_bd_intf_ports ctrl] [get_bd_intf_pins mm_segment_top_0/ctrl_V]
  connect_bd_intf_net -intf_net ddr4_0_C0_DDR4 [get_bd_intf_ports ddr4_sdram_c1] [get_bd_intf_pins mc/DDR4_0]
  connect_bd_intf_net -intf_net mm_segment_top_0_ctrl_stat_V_V [get_bd_intf_ports ctrl_stat] [get_bd_intf_pins mm_segment_top_0/ctrl_stat_V_V]
  connect_bd_intf_net -intf_net mm_segment_top_0_rd_out_V [get_bd_intf_pins axi_mmu_wrapper_sync_0/fromMM_RD] [get_bd_intf_pins mm_segment_top_0/rd_out_V]
  connect_bd_intf_net -intf_net mm_segment_top_0_wr_out_V [get_bd_intf_pins axi_mmu_wrapper_sync_0/fromMM_WR] [get_bd_intf_pins mm_segment_top_0/wr_out_V]

  # Create port connections
  connect_bd_net -net Net1 [get_bd_pins axi_mmu_wrapper_sync_0/s_aresetn] [get_bd_pins axi_traffic_gen_0/s_axi_aresetn] [get_bd_pins mc/c0_ddr4_aresetn] [get_bd_pins mm_segment_top_0/ap_rst_n] [get_bd_pins wrapper_downstream_checker/aresetn] [get_bd_pins wrapper_upstream_checker/aresetn]
  connect_bd_net -net axi_protocol_checker_0_pc_asserted [get_bd_ports pc_asserted_0] [get_bd_pins wrapper_downstream_checker/pc_asserted]
  connect_bd_net -net axi_protocol_checker_0_pc_status [get_bd_ports pc_status_0] [get_bd_pins wrapper_downstream_checker/pc_status]
  connect_bd_net -net axi_protocol_checker_1_pc_asserted [get_bd_ports pc_asserted_1] [get_bd_pins wrapper_upstream_checker/pc_asserted]
  connect_bd_net -net axi_protocol_checker_1_pc_status [get_bd_ports pc_status_1] [get_bd_pins wrapper_upstream_checker/pc_status]
  connect_bd_net -net core_ext_start_0_1 [get_bd_ports core_ext_start_0] [get_bd_pins axi_traffic_gen_0/core_ext_start]
  connect_bd_net -net ddr4_0_c0_ddr4_ui_clk [get_bd_pins axi_mmu_wrapper_sync_0/s_axi_clk] [get_bd_pins axi_traffic_gen_0/s_axi_aclk] [get_bd_pins mc/c0_ddr4_ui_clk] [get_bd_pins mm_segment_top_0/ap_clk] [get_bd_pins wrapper_downstream_checker/aclk] [get_bd_pins wrapper_upstream_checker/aclk]
  connect_bd_net -net ddr4_0_c0_init_calib_complete [get_bd_ports mc_init_calib_complete] [get_bd_pins mc/init_calib_complete_0]
  connect_bd_net -net sys_rst_0_1 [get_bd_ports sys_rst] [get_bd_pins mc/sys_rst_0]
  connect_bd_net -net xlconstant_0_dout [get_bd_pins mm_segment_top_0/ap_start] [get_bd_pins xlconstant_0/dout]

  # Create address segments
  create_bd_addr_seg -range 0x000100000000 -offset 0x00000000 [get_bd_addr_spaces axi_mmu_wrapper_sync_0/m_axi] [get_bd_addr_segs mc/ddr4_0/C0_DDR4_MEMORY_MAP/C0_DDR4_ADDRESS_BLOCK] SEG_ddr4_0_C0_DDR4_ADDRESS_BLOCK
  create_bd_addr_seg -range 0x000100000000 -offset 0x00000000 [get_bd_addr_spaces axi_traffic_gen_0/Data] [get_bd_addr_segs axi_mmu_wrapper_sync_0/s_axi/reg0] SEG_axi_mmu_wrapper_sync_0_reg0


  # Restore current instance
  current_bd_instance $oldCurInst

  save_bd_design
  close_bd_design $design_name
}
# End of cr_bd_sys_mm_tb()
cr_bd_sys_mm_tb ""
set_property IS_MANAGED "0" [get_files sys_mm_tb.bd ]
set_property REGISTERED_WITH_MANAGER "1" [get_files sys_mm_tb.bd ]
set_property SYNTH_CHECKPOINT_MODE "Hierarchical" [get_files sys_mm_tb.bd ]
set_property USED_IN "simulation" [get_files sys_mm_tb.bd ]
set_property USED_IN_IMPLEMENTATION "0" [get_files sys_mm_tb.bd ]
set_property USED_IN_SYNTHESIS "0" [get_files sys_mm_tb.bd ]

# Create 'synth_1' run (if not found)
if {[string equal [get_runs -quiet synth_1] ""]} {
    create_run -name synth_1 -part xcvu095-ffva2104-2-e -flow {Vivado Synthesis 2018} -strategy "Vivado Synthesis Defaults" -report_strategy {No Reports} -constrset constrs_1
} else {
  set_property strategy "Vivado Synthesis Defaults" [get_runs synth_1]
  set_property flow "Vivado Synthesis 2018" [get_runs synth_1]
}
set obj [get_runs synth_1]
set_property set_report_strategy_name 1 $obj
set_property report_strategy {Vivado Synthesis Default Reports} $obj
set_property set_report_strategy_name 0 $obj
# Create 'synth_1_synth_report_utilization_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs synth_1] synth_1_synth_report_utilization_0] "" ] } {
  create_report_config -report_name synth_1_synth_report_utilization_0 -report_type report_utilization:1.0 -steps synth_design -runs synth_1
}
set obj [get_report_configs -of_objects [get_runs synth_1] synth_1_synth_report_utilization_0]
if { $obj != "" } {

}
set obj [get_runs synth_1]
set_property -name "strategy" -value "Vivado Synthesis Defaults" -objects $obj

# set the current synth run
current_run -synthesis [get_runs synth_1]

# Create 'impl_1' run (if not found)
if {[string equal [get_runs -quiet impl_1] ""]} {
    create_run -name impl_1 -part xcvu095-ffva2104-2-e -flow {Vivado Implementation 2018} -strategy "Vivado Implementation Defaults" -report_strategy {No Reports} -constrset constrs_1 -parent_run synth_1
} else {
  set_property strategy "Vivado Implementation Defaults" [get_runs impl_1]
  set_property flow "Vivado Implementation 2018" [get_runs impl_1]
}
set obj [get_runs impl_1]
set_property set_report_strategy_name 1 $obj
set_property report_strategy {Vivado Implementation Default Reports} $obj
set_property set_report_strategy_name 0 $obj

make_wrapper -files [get_files $origin_dir/generated_tb/mm_sys_mm.srcs/sources_1/bd/sys_mm_tb/sys_mm_tb.bd] -inst_template
add_files -norecurse ${origin_dir}/generated_tb/mm_sys_mm.srcs/sources_1/bd/sys_mm_tb/hdl/sys_mm_tb_wrapper.v

set file ${origin_dir}/generated_tb/mm_sys_mm.srcs/sources_1/bd/sys_mm_tb/hdl/sys_mm_tb_wrapper.v
set file_obj [get_files -of_objects [get_filesets sources_1] [list "$file"]]
set_property -name "used_in" -value "simulation" -objects $file_obj
set_property -name "used_in_implementation" -value "0" -objects $file_obj
set_property -name "used_in_synthesis" -value "0" -objects $file_obj

# Create 'impl_1_init_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_init_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_init_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps init_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_init_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_opt_report_drc_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_opt_report_drc_0] "" ] } {
  create_report_config -report_name impl_1_opt_report_drc_0 -report_type report_drc:1.0 -steps opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_opt_report_drc_0]
if { $obj != "" } {

}
# Create 'impl_1_opt_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_opt_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_opt_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_opt_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_power_opt_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_power_opt_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_power_opt_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps power_opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_power_opt_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_place_report_io_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_io_0] "" ] } {
  create_report_config -report_name impl_1_place_report_io_0 -report_type report_io:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_io_0]
if { $obj != "" } {

}
# Create 'impl_1_place_report_utilization_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_utilization_0] "" ] } {
  create_report_config -report_name impl_1_place_report_utilization_0 -report_type report_utilization:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_utilization_0]
if { $obj != "" } {

}
# Create 'impl_1_place_report_control_sets_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_control_sets_0] "" ] } {
  create_report_config -report_name impl_1_place_report_control_sets_0 -report_type report_control_sets:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_control_sets_0]
if { $obj != "" } {

}
# Create 'impl_1_place_report_incremental_reuse_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_incremental_reuse_0] "" ] } {
  create_report_config -report_name impl_1_place_report_incremental_reuse_0 -report_type report_incremental_reuse:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_incremental_reuse_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_place_report_incremental_reuse_1' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_incremental_reuse_1] "" ] } {
  create_report_config -report_name impl_1_place_report_incremental_reuse_1 -report_type report_incremental_reuse:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_incremental_reuse_1]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_place_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_place_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_post_place_power_opt_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_post_place_power_opt_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_post_place_power_opt_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps post_place_power_opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_post_place_power_opt_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_phys_opt_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_phys_opt_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_phys_opt_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps phys_opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_phys_opt_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_route_report_drc_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_drc_0] "" ] } {
  create_report_config -report_name impl_1_route_report_drc_0 -report_type report_drc:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_drc_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_methodology_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_methodology_0] "" ] } {
  create_report_config -report_name impl_1_route_report_methodology_0 -report_type report_methodology:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_methodology_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_power_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_power_0] "" ] } {
  create_report_config -report_name impl_1_route_report_power_0 -report_type report_power:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_power_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_route_status_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_route_status_0] "" ] } {
  create_report_config -report_name impl_1_route_report_route_status_0 -report_type report_route_status:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_route_status_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_route_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_timing_summary_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_incremental_reuse_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_incremental_reuse_0] "" ] } {
  create_report_config -report_name impl_1_route_report_incremental_reuse_0 -report_type report_incremental_reuse:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_incremental_reuse_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_clock_utilization_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_clock_utilization_0] "" ] } {
  create_report_config -report_name impl_1_route_report_clock_utilization_0 -report_type report_clock_utilization:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_clock_utilization_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_bus_skew_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_bus_skew_0] "" ] } {
  create_report_config -report_name impl_1_route_report_bus_skew_0 -report_type report_bus_skew:1.1 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_bus_skew_0]
if { $obj != "" } {

}
# Create 'impl_1_post_route_phys_opt_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_post_route_phys_opt_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_post_route_phys_opt_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps post_route_phys_opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_post_route_phys_opt_report_timing_summary_0]
if { $obj != "" } {

}
# Create 'impl_1_post_route_phys_opt_report_bus_skew_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_post_route_phys_opt_report_bus_skew_0] "" ] } {
  create_report_config -report_name impl_1_post_route_phys_opt_report_bus_skew_0 -report_type report_bus_skew:1.1 -steps post_route_phys_opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_post_route_phys_opt_report_bus_skew_0]
if { $obj != "" } {

}
set obj [get_runs impl_1]
set_property -name "strategy" -value "Vivado Implementation Defaults" -objects $obj
set_property -name "steps.write_bitstream.args.readback_file" -value "0" -objects $obj
set_property -name "steps.write_bitstream.args.verbose" -value "0" -objects $obj

# set the current impl run
current_run -implementation [get_runs impl_1]

puts "INFO: Project created:${_xil_proj_name_}"
exit
