#*****************************************************************************************
# Vivado (TM) v2018.2.2 (64-bit)
#
# run_vivado.tcl: Tcl script for re-creating project 'memcached_pipeline'
#
# Generated by Vivado on Thu Mar 21 20:00:39 EDT 2019
# IP Build 2318053 on Mon Oct  1 21:44:26 MDT 2018
#
# This file contains the Vivado Tcl commands for re-creating the project to the state*
# when this script was generated. In order to re-create the project, please source this
# file in the Vivado Tcl Shell.
#
# * Note that the runs in the created project will be configured the same way as the
#   original project, however they will not be launched automatically. To regenerate the
#   run results please launch the synthesis/implementation runs as needed.
#
#*****************************************************************************************
# NOTE: In order to use this script for source control purposes, please make sure that the
#       following files are added to the source control system:-
#
# 1. This project restoration tcl script (run_vivado.tcl) that was generated.
#
# 2. The following source(s) files that were local or imported into the original project.
#    (Please see the '$orig_proj_dir' and '$origin_dir' variable setting below at the start of the script)
#
# 3. The following remote source files that were added to the original project:-
#
#    "/root/GitHub/FPGA/app/memcached/hls/rtl/memcachedPipeline_top.v"
#
#*****************************************************************************************

# Set the reference directory for source file relative paths (by default the value is script directory path)
set origin_dir "."

# Use origin directory path location variable, if specified in the tcl shell
if { [info exists ::origin_dir_loc] } {
  set origin_dir $::origin_dir_loc
}

# Set the project name
set _xil_proj_name_ "memcached_pipeline"

# Use project name variable, if specified in the tcl shell
if { [info exists ::user_project_name] } {
  set _xil_proj_name_ $::user_project_name
}

variable script_file
set script_file "run_vivado.tcl"

# Help information for this script
proc help {} {
  variable script_file
  puts "\nDescription:"
  puts "Recreate a Vivado project from this script. The created project will be"
  puts "functionally equivalent to the original project for which this script was"
  puts "generated. The script contains commands for creating a project, filesets,"
  puts "runs, adding/importing sources and setting properties on various objects.\n"
  puts "Syntax:"
  puts "$script_file"
  puts "$script_file -tclargs \[--origin_dir <path>\]"
  puts "$script_file -tclargs \[--project_name <name>\]"
  puts "$script_file -tclargs \[--help\]\n"
  puts "Usage:"
  puts "Name                   Description"
  puts "-------------------------------------------------------------------------"
  puts "\[--origin_dir <path>\]  Determine source file paths wrt this path. Default"
  puts "                       origin_dir path value is \".\", otherwise, the value"
  puts "                       that was set with the \"-paths_relative_to\" switch"
  puts "                       when this script was generated.\n"
  puts "\[--project_name <name>\] Create project with the specified name. Default"
  puts "                       name is the name of the project from where this"
  puts "                       script was generated.\n"
  puts "\[--help\]               Print help information for this script"
  puts "-------------------------------------------------------------------------\n"
  exit 0
}

if { $::argc > 0 } {
  for {set i 0} {$i < $::argc} {incr i} {
    set option [string trim [lindex $::argv $i]]
    switch -regexp -- $option {
      "--origin_dir"   { incr i; set origin_dir [lindex $::argv $i] }
      "--project_name" { incr i; set _xil_proj_name_ [lindex $::argv $i] }
      "--help"         { help }
      default {
        if { [regexp {^-} $option] } {
          puts "ERROR: Unknown option '$option' specified, please type '$script_file -tclargs --help' for usage info.\n"
          return 1
        }
      }
    }
  }
}

# Set the directory path for the original project from where this script was exported
set orig_proj_dir "[file normalize "$origin_dir/generated_vivado_project"]"

# Create project
create_project -force ${_xil_proj_name_} "./generated_vivado_project" -part xcvu095-ffva2104-2-e

# Set the directory path for the new project
set proj_dir [get_property directory [current_project]]

# Reconstruct message rules
# None

# Set project properties
set obj [current_project]
set_property -name "default_lib" -value "xil_defaultlib" -objects $obj
set_property -name "dsa.accelerator_binary_content" -value "bitstream" -objects $obj
set_property -name "dsa.accelerator_binary_format" -value "xclbin2" -objects $obj
set_property -name "dsa.description" -value "Vivado generated DSA" -objects $obj
set_property -name "dsa.dr_bd_base_address" -value "0" -objects $obj
set_property -name "dsa.emu_dir" -value "emu" -objects $obj
set_property -name "dsa.flash_interface_type" -value "bpix16" -objects $obj
set_property -name "dsa.flash_offset_address" -value "0" -objects $obj
set_property -name "dsa.flash_size" -value "1024" -objects $obj
set_property -name "dsa.host_architecture" -value "x86_64" -objects $obj
set_property -name "dsa.host_interface" -value "pcie" -objects $obj
set_property -name "dsa.num_compute_units" -value "60" -objects $obj
set_property -name "dsa.platform_state" -value "pre_synth" -objects $obj
set_property -name "dsa.uses_pr" -value "1" -objects $obj
set_property -name "dsa.vendor" -value "xilinx" -objects $obj
set_property -name "dsa.version" -value "0.0" -objects $obj
set_property -name "enable_vhdl_2008" -value "1" -objects $obj
set_property -name "ip_cache_permissions" -value "read write" -objects $obj
set_property -name "ip_output_repo" -value "$proj_dir/${_xil_proj_name_}.cache/ip" -objects $obj
set_property -name "mem.enable_memory_map_generation" -value "1" -objects $obj
set_property -name "part" -value "xcvu095-ffva2104-2-e" -objects $obj
set_property -name "sim.central_dir" -value "$proj_dir/${_xil_proj_name_}.ip_user_files" -objects $obj
set_property -name "sim.ip.auto_export_scripts" -value "1" -objects $obj
set_property -name "simulator_language" -value "Mixed" -objects $obj
set_property -name "webtalk.activehdl_export_sim" -value "2" -objects $obj
set_property -name "webtalk.ies_export_sim" -value "2" -objects $obj
set_property -name "webtalk.modelsim_export_sim" -value "2" -objects $obj
set_property -name "webtalk.questa_export_sim" -value "2" -objects $obj
set_property -name "webtalk.riviera_export_sim" -value "2" -objects $obj
set_property -name "webtalk.vcs_export_sim" -value "2" -objects $obj
set_property -name "webtalk.xcelium_export_sim" -value "2" -objects $obj
set_property -name "webtalk.xsim_export_sim" -value "2" -objects $obj
set_property -name "xpm_libraries" -value "XPM_CDC XPM_FIFO XPM_MEMORY" -objects $obj

# Create 'sources_1' fileset (if not found)
if {[string equal [get_filesets -quiet sources_1] ""]} {
  create_fileset -srcset sources_1
}

# Set IP repository paths
set obj [get_filesets sources_1]
set_property "ip_repo_paths" "[file normalize "$origin_dir/../../../generated_ip"]" $obj

# Rebuild user ip_repo's index before adding any source files
update_ip_catalog -rebuild

# Set 'sources_1' fileset object
set obj [get_filesets sources_1]
set files [list \
 [file normalize "${origin_dir}/rtl/memcachedPipeline_top.v"] \
]
add_files -norecurse -fileset $obj $files

# Import local files from the original project
#set files [list \
# [file normalize "${origin_dir}/generated_vivado_project/memcached_pipeline.srcs/sources_1/bd/memcached_pipeline/hdl/memcached_pipeline_wrapper.v" ]\
#]
#set imported_files [import_files -fileset sources_1 $files]

# Set 'sources_1' fileset file properties for remote files
#set file "$origin_dir/../../../generated_ip/app_memcached_vcu108/component.xml"
#set file [file normalize $file]
#set file_obj [get_files -of_objects [get_filesets sources_1] [list "*$file"]]
#set_property -name "file_type" -value "IP-XACT" -objects $file_obj


# Set 'sources_1' fileset file properties for local files
# None

# Set 'sources_1' fileset properties
set obj [get_filesets sources_1]
set_property -name "top" -value "memcachedPipeline_top" -objects $obj

# Create 'constrs_1' fileset (if not found)
if {[string equal [get_filesets -quiet constrs_1] ""]} {
  create_fileset -constrset constrs_1
}

# Set 'constrs_1' fileset object
set obj [get_filesets constrs_1]

# Empty (no sources present)

# Set 'constrs_1' fileset properties
set obj [get_filesets constrs_1]
set_property -name "target_part" -value "xcvu095-ffva2104-2-e" -objects $obj

# Create 'sim_1' fileset (if not found)
if {[string equal [get_filesets -quiet sim_1] ""]} {
  create_fileset -simset sim_1
}

# Set 'sim_1' fileset object
set obj [get_filesets sim_1]
# Empty (no sources present)

# Set 'sim_1' fileset properties
set obj [get_filesets sim_1]
set_property -name "top" -value "memcachedPipeline_top" -objects $obj
set_property -name "top_lib" -value "xil_defaultlib" -objects $obj


# Adding sources referenced in BDs, if not already added


# Proc to create BD axi_interconnect
proc cr_bd_axi_interconnect { parentCell } {

  # CHANGE DESIGN NAME HERE
  set design_name axi_interconnect

  common::send_msg_id "BD_TCL-003" "INFO" "Currently there is no design <$design_name> in project, so creating one..."

  create_bd_design $design_name

  set bCheckIPsPassed 1
  ##################################################################
  # CHECK IPs
  ##################################################################
  set bCheckIPs 1
  if { $bCheckIPs == 1 } {
     set list_check_ips "\ 
  "

   set list_ips_missing ""
   common::send_msg_id "BD_TCL-006" "INFO" "Checking if the following IPs exist in the project's IP catalog: $list_check_ips ."

   foreach ip_vlnv $list_check_ips {
      set ip_obj [get_ipdefs -all $ip_vlnv]
      if { $ip_obj eq "" } {
         lappend list_ips_missing $ip_vlnv
      }
   }

   if { $list_ips_missing ne "" } {
      catch {common::send_msg_id "BD_TCL-115" "ERROR" "The following IPs are not found in the IP Catalog:\n  $list_ips_missing\n\nResolution: Please add the repository containing the IP(s) to the project." }
      set bCheckIPsPassed 0
   }

  }

  if { $bCheckIPsPassed != 1 } {
    common::send_msg_id "BD_TCL-1003" "WARNING" "Will not continue with creation of design due to the error(s) above."
    return 3
  }

  variable script_folder

  if { $parentCell eq "" } {
     set parentCell [get_bd_cells /]
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_msg_id "BD_TCL-100" "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_msg_id "BD_TCL-101" "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj


  # Create interface ports
  set M00_AXI_0 [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:aximm_rtl:1.0 M00_AXI_0 ]
  set_property -dict [ list \
   CONFIG.ADDR_WIDTH {32} \
   CONFIG.DATA_WIDTH {512} \
   CONFIG.NUM_READ_OUTSTANDING {2} \
   CONFIG.NUM_WRITE_OUTSTANDING {2} \
   CONFIG.PROTOCOL {AXI4} \
   ] $M00_AXI_0
  set S00_AXI_0 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:aximm_rtl:1.0 S00_AXI_0 ]
  set_property -dict [ list \
   CONFIG.ADDR_WIDTH {32} \
   CONFIG.ARUSER_WIDTH {5} \
   CONFIG.AWUSER_WIDTH {5} \
   CONFIG.BUSER_WIDTH {5} \
   CONFIG.DATA_WIDTH {512} \
   CONFIG.HAS_BRESP {1} \
   CONFIG.HAS_BURST {1} \
   CONFIG.HAS_CACHE {1} \
   CONFIG.HAS_LOCK {1} \
   CONFIG.HAS_PROT {1} \
   CONFIG.HAS_QOS {1} \
   CONFIG.HAS_REGION {1} \
   CONFIG.HAS_RRESP {1} \
   CONFIG.HAS_WSTRB {1} \
   CONFIG.ID_WIDTH {8} \
   CONFIG.MAX_BURST_LENGTH {256} \
   CONFIG.NUM_READ_OUTSTANDING {2} \
   CONFIG.NUM_READ_THREADS {1} \
   CONFIG.NUM_WRITE_OUTSTANDING {2} \
   CONFIG.NUM_WRITE_THREADS {1} \
   CONFIG.PROTOCOL {AXI4} \
   CONFIG.READ_WRITE_MODE {READ_WRITE} \
   CONFIG.RUSER_BITS_PER_BYTE {0} \
   CONFIG.RUSER_WIDTH {5} \
   CONFIG.SUPPORTS_NARROW_BURST {1} \
   CONFIG.WUSER_BITS_PER_BYTE {0} \
   CONFIG.WUSER_WIDTH {5} \
   ] $S00_AXI_0
  set S01_AXI_0 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:aximm_rtl:1.0 S01_AXI_0 ]
  set_property -dict [ list \
   CONFIG.ADDR_WIDTH {32} \
   CONFIG.ARUSER_WIDTH {5} \
   CONFIG.AWUSER_WIDTH {5} \
   CONFIG.BUSER_WIDTH {5} \
   CONFIG.DATA_WIDTH {512} \
   CONFIG.HAS_BRESP {1} \
   CONFIG.HAS_BURST {1} \
   CONFIG.HAS_CACHE {1} \
   CONFIG.HAS_LOCK {1} \
   CONFIG.HAS_PROT {1} \
   CONFIG.HAS_QOS {1} \
   CONFIG.HAS_REGION {1} \
   CONFIG.HAS_RRESP {1} \
   CONFIG.HAS_WSTRB {1} \
   CONFIG.ID_WIDTH {8} \
   CONFIG.MAX_BURST_LENGTH {256} \
   CONFIG.NUM_READ_OUTSTANDING {2} \
   CONFIG.NUM_READ_THREADS {1} \
   CONFIG.NUM_WRITE_OUTSTANDING {2} \
   CONFIG.NUM_WRITE_THREADS {1} \
   CONFIG.PROTOCOL {AXI4} \
   CONFIG.READ_WRITE_MODE {READ_WRITE} \
   CONFIG.RUSER_BITS_PER_BYTE {0} \
   CONFIG.RUSER_WIDTH {5} \
   CONFIG.SUPPORTS_NARROW_BURST {1} \
   CONFIG.WUSER_BITS_PER_BYTE {0} \
   CONFIG.WUSER_WIDTH {5} \
   ] $S01_AXI_0

  # Create ports
  set APCLK_0 [ create_bd_port -dir I -type clk APCLK_0 ]
  set_property -dict [ list \
   CONFIG.FREQ_HZ {10000000} \
 ] $APCLK_0
  set ARESETN_0 [ create_bd_port -dir I -type rst ARESETN_0 ]
  set axi_clk [ create_bd_port -dir I -type clk axi_clk ]
  set axi_resetn [ create_bd_port -dir I -type rst axi_resetn ]

  # Create instance: axi_interconnect_0, and set properties
  set axi_interconnect_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_interconnect:2.1 axi_interconnect_0 ]
  set_property -dict [ list \
   CONFIG.ENABLE_ADVANCED_OPTIONS {1} \
   CONFIG.M00_HAS_DATA_FIFO {1} \
   CONFIG.M00_HAS_REGSLICE {3} \
   CONFIG.NUM_MI {1} \
   CONFIG.NUM_SI {2} \
   CONFIG.S00_HAS_DATA_FIFO {2} \
   CONFIG.S00_HAS_REGSLICE {3} \
   CONFIG.S01_HAS_DATA_FIFO {2} \
   CONFIG.S01_HAS_REGSLICE {3} \
   CONFIG.S02_HAS_DATA_FIFO {2} \
   CONFIG.STRATEGY {2} \
   CONFIG.SYNCHRONIZATION_STAGES {2} \
   CONFIG.XBAR_DATA_WIDTH {512} \
 ] $axi_interconnect_0

  # Create interface connections
  connect_bd_intf_net -intf_net S00_AXI_0_1 [get_bd_intf_ports S00_AXI_0] [get_bd_intf_pins axi_interconnect_0/S00_AXI]
  connect_bd_intf_net -intf_net S01_AXI_0_1 [get_bd_intf_ports S01_AXI_0] [get_bd_intf_pins axi_interconnect_0/S01_AXI]
  connect_bd_intf_net -intf_net axi_interconnect_0_M00_AXI [get_bd_intf_ports M00_AXI_0] [get_bd_intf_pins axi_interconnect_0/M00_AXI]

  # Create port connections
  connect_bd_net -net ACLK_0_1 [get_bd_ports APCLK_0] [get_bd_pins axi_interconnect_0/ACLK]
  connect_bd_net -net ARESETN_0_1 [get_bd_ports ARESETN_0] [get_bd_pins axi_interconnect_0/ARESETN]
  connect_bd_net -net S00_ACLK_1 [get_bd_ports axi_clk] [get_bd_pins axi_interconnect_0/M00_ACLK] [get_bd_pins axi_interconnect_0/S00_ACLK] [get_bd_pins axi_interconnect_0/S01_ACLK]
  connect_bd_net -net S00_ARESETN_1 [get_bd_ports axi_resetn] [get_bd_pins axi_interconnect_0/M00_ARESETN] [get_bd_pins axi_interconnect_0/S00_ARESETN] [get_bd_pins axi_interconnect_0/S01_ARESETN]

  # Create address segments
  create_bd_addr_seg -range 0x000100000000 -offset 0x00000000 [get_bd_addr_spaces S00_AXI_0] [get_bd_addr_segs M00_AXI_0/Reg] SEG_M00_AXI_0_Reg
  create_bd_addr_seg -range 0x000100000000 -offset 0x00000000 [get_bd_addr_spaces S01_AXI_0] [get_bd_addr_segs M00_AXI_0/Reg] SEG_M00_AXI_0_Reg


  # Restore current instance
  current_bd_instance $oldCurInst

  save_bd_design
common::send_msg_id "BD_TCL-1000" "WARNING" "This Tcl script was generated from a block design that has not been validated. It is possible that design <$design_name> may result in errors during validation."

  close_bd_design $design_name 
}
# End of cr_bd_axi_interconnect()
cr_bd_axi_interconnect ""
set_property IS_MANAGED "0" [get_files axi_interconnect.bd ] 
set_property REGISTERED_WITH_MANAGER "1" [get_files axi_interconnect.bd ] 
set_property SYNTH_CHECKPOINT_MODE "Hierarchical" [get_files axi_interconnect.bd ] 

##################################################################
# Make wrappers so that these IPs can be treated as black boxes 
##################################################################
make_wrapper -files [get_files ${origin_dir}/generated_vivado_project/memcached_pipeline.srcs/sources_1/bd/axi_interconnect/axi_interconnect.bd] -top
add_files -norecurse ${origin_dir}/generated_vivado_project/memcached_pipeline.srcs/sources_1/bd/axi_interconnect/hdl/axi_interconnect_wrapper.v

# Proc to create BD memcached_pipeline
proc cr_bd_memcached_pipeline { parentCell } {

  # CHANGE DESIGN NAME HERE
  set design_name memcached_pipeline

  common::send_msg_id "BD_TCL-003" "INFO" "Currently there is no design <$design_name> in project, so creating one..."

  create_bd_design $design_name

  set bCheckIPsPassed 1
  ##################################################################
  # CHECK IPs
  ##################################################################
  set bCheckIPs 1
  if { $bCheckIPs == 1 } {
     set list_check_ips "\ 
  xilinx.com:ip:axi_datamover:5.1\
  xilinx.com:ip:axis_clock_converter:1.1\
  xilinx.labs:hls:readConverter:1.04\
  xilinx.labs:hls:writeConverter:1.05\
  xilinx.labs:hls:memcachedPipeline:1.07\
  "

   set list_ips_missing ""
   common::send_msg_id "BD_TCL-006" "INFO" "Checking if the following IPs exist in the project's IP catalog: $list_check_ips ."

   foreach ip_vlnv $list_check_ips {
      set ip_obj [get_ipdefs -all $ip_vlnv]
      if { $ip_obj eq "" } {
         lappend list_ips_missing $ip_vlnv
      }
   }

   if { $list_ips_missing ne "" } {
      catch {common::send_msg_id "BD_TCL-115" "ERROR" "The following IPs are not found in the IP Catalog:\n  $list_ips_missing\n\nResolution: Please add the repository containing the IP(s) to the project." }
      set bCheckIPsPassed 0
   }

  }

  if { $bCheckIPsPassed != 1 } {
    common::send_msg_id "BD_TCL-1003" "WARNING" "Will not continue with creation of design due to the error(s) above."
    return 3
  }

  variable script_folder

  if { $parentCell eq "" } {
     set parentCell [get_bd_cells /]
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_msg_id "BD_TCL-100" "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_msg_id "BD_TCL-101" "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj


  # Create interface ports
  set MCD_AXI2DRAM_RD_C0 [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:aximm_rtl:1.0 MCD_AXI2DRAM_RD_C0 ]
  set_property -dict [ list \
   CONFIG.ADDR_WIDTH {32} \
   CONFIG.DATA_WIDTH {512} \
   CONFIG.HAS_BRESP {0} \
   CONFIG.HAS_BURST {0} \
   CONFIG.HAS_CACHE {0} \
   CONFIG.HAS_LOCK {0} \
   CONFIG.HAS_PROT {0} \
   CONFIG.HAS_QOS {0} \
   CONFIG.HAS_REGION {0} \
   CONFIG.HAS_WSTRB {0} \
   CONFIG.NUM_READ_OUTSTANDING {2} \
   CONFIG.NUM_WRITE_OUTSTANDING {2} \
   CONFIG.PROTOCOL {AXI4} \
   CONFIG.READ_WRITE_MODE {READ_ONLY} \
   ] $MCD_AXI2DRAM_RD_C0
  set MCD_AXI2DRAM_RD_C1 [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:aximm_rtl:1.0 MCD_AXI2DRAM_RD_C1 ]
  set_property -dict [ list \
   CONFIG.ADDR_WIDTH {32} \
   CONFIG.DATA_WIDTH {512} \
   CONFIG.HAS_BRESP {0} \
   CONFIG.HAS_BURST {0} \
   CONFIG.HAS_CACHE {0} \
   CONFIG.HAS_LOCK {0} \
   CONFIG.HAS_PROT {0} \
   CONFIG.HAS_QOS {0} \
   CONFIG.HAS_REGION {0} \
   CONFIG.HAS_WSTRB {0} \
   CONFIG.NUM_READ_OUTSTANDING {2} \
   CONFIG.NUM_WRITE_OUTSTANDING {2} \
   CONFIG.PROTOCOL {AXI4} \
   CONFIG.READ_WRITE_MODE {READ_ONLY} \
   ] $MCD_AXI2DRAM_RD_C1
  set MCD_AXI2DRAM_WR_C0 [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:aximm_rtl:1.0 MCD_AXI2DRAM_WR_C0 ]
  set_property -dict [ list \
   CONFIG.ADDR_WIDTH {32} \
   CONFIG.DATA_WIDTH {512} \
   CONFIG.HAS_BURST {0} \
   CONFIG.HAS_CACHE {0} \
   CONFIG.HAS_LOCK {0} \
   CONFIG.HAS_PROT {0} \
   CONFIG.HAS_QOS {0} \
   CONFIG.HAS_REGION {0} \
   CONFIG.HAS_RRESP {0} \
   CONFIG.NUM_READ_OUTSTANDING {2} \
   CONFIG.NUM_WRITE_OUTSTANDING {2} \
   CONFIG.PROTOCOL {AXI4} \
   CONFIG.READ_WRITE_MODE {WRITE_ONLY} \
   ] $MCD_AXI2DRAM_WR_C0
  set MCD_AXI2DRAM_WR_C1 [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:aximm_rtl:1.0 MCD_AXI2DRAM_WR_C1 ]
  set_property -dict [ list \
   CONFIG.ADDR_WIDTH {32} \
   CONFIG.DATA_WIDTH {512} \
   CONFIG.HAS_BURST {0} \
   CONFIG.HAS_CACHE {0} \
   CONFIG.HAS_LOCK {0} \
   CONFIG.HAS_PROT {0} \
   CONFIG.HAS_QOS {0} \
   CONFIG.HAS_REGION {0} \
   CONFIG.HAS_RRESP {0} \
   CONFIG.NUM_READ_OUTSTANDING {2} \
   CONFIG.NUM_WRITE_OUTSTANDING {2} \
   CONFIG.PROTOCOL {AXI4} \
   CONFIG.READ_WRITE_MODE {WRITE_ONLY} \
   ] $MCD_AXI2DRAM_WR_C1
  set alloc2mcd_DramIn_V_V_0 [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:axis_rtl:1.0 alloc2mcd_DramIn_V_V_0 ]
  set_property -dict [ list \
   CONFIG.HAS_TKEEP {0} \
   CONFIG.HAS_TLAST {0} \
   CONFIG.HAS_TREADY {1} \
   CONFIG.HAS_TSTRB {0} \
   CONFIG.LAYERED_METADATA {xilinx.com:interface:datatypes:1.0 {CLK {datatype {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value {}} bitwidth {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 1} bitoffset {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 0}}}}} \
   CONFIG.TDATA_NUM_BYTES {4} \
   CONFIG.TDEST_WIDTH {0} \
   CONFIG.TID_WIDTH {0} \
   CONFIG.TUSER_WIDTH {0} \
   ] $alloc2mcd_DramIn_V_V_0
  set fromNet [ create_bd_intf_port -mode Slave -vlnv xilinx.com:interface:axis_rtl:1.0 fromNet ]
  set_property -dict [ list \
   CONFIG.HAS_TKEEP {1} \
   CONFIG.HAS_TLAST {1} \
   CONFIG.HAS_TREADY {1} \
   CONFIG.HAS_TSTRB {0} \
   CONFIG.LAYERED_METADATA {xilinx.com:interface:datatypes:1.0 {TDATA {datatype {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value {}} bitwidth {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 64} bitoffset {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 0} integer {signed {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value false}}}} TUSER {datatype {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value {}} bitwidth {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 112} bitoffset {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 0} integer {signed {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value false}}}}}} \
   CONFIG.TDATA_NUM_BYTES {8} \
   CONFIG.TDEST_WIDTH {0} \
   CONFIG.TID_WIDTH {0} \
   CONFIG.TUSER_WIDTH {112} \
   ] $fromNet
  set mcd2alloc_V_V_0 [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 mcd2alloc_V_V_0 ]
  set toNet [ create_bd_intf_port -mode Master -vlnv xilinx.com:interface:axis_rtl:1.0 toNet ]

  # Create ports
  set aclk [ create_bd_port -dir I -type clk aclk ]
  set_property -dict [ list \
   CONFIG.ASSOCIATED_BUSIF {fromNet:toNet:alloc2mcd_DramIn_V_V_0:mcd2alloc_V_V_0} \
 ] $aclk
  set aresetn [ create_bd_port -dir I -type rst aresetn ]
  set flushAck_V_0 [ create_bd_port -dir I -from 0 -to 0 -type data flushAck_V_0 ]
  set_property -dict [ list \
   CONFIG.LAYERED_METADATA {xilinx.com:interface:datatypes:1.0 {DATA {datatype {name {attribs {resolve_type immediate dependency {} format string minimum {} maximum {}} value {}} bitwidth {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 1} bitoffset {attribs {resolve_type immediate dependency {} format long minimum {} maximum {}} value 0} integer {signed {attribs {resolve_type immediate dependency {} format bool minimum {} maximum {}} value false}}}}}} \
 ] $flushAck_V_0
  set flushDone_V_0 [ create_bd_port -dir O -from 0 -to 0 -type data flushDone_V_0 ]
  set flushReq_V_0 [ create_bd_port -dir O -from 0 -to 0 -type data flushReq_V_0 ]
  set mem_c0_clk [ create_bd_port -dir I -type clk mem_c0_clk ]
  set_property -dict [ list \
   CONFIG.ASSOCIATED_BUSIF {MCD_AXI2DRAM_RD_C0:MCD_AXI2DRAM_WR_C0:MCD_AXI2DRAM_RD_C1:MCD_AXI2DRAM_WR_C1} \
 ] $mem_c0_clk
  set mem_c0_resetn [ create_bd_port -dir I -type rst mem_c0_resetn ]

  # Create instance: ht_axi_datamover, and set properties
  set ht_axi_datamover [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_datamover:5.1 ht_axi_datamover ]
  set_property -dict [ list \
   CONFIG.c_dummy {1} \
   CONFIG.c_enable_mm2s_adv_sig {0} \
   CONFIG.c_enable_s2mm_adv_sig {0} \
   CONFIG.c_include_mm2s_dre {false} \
   CONFIG.c_include_s2mm_dre {false} \
   CONFIG.c_m_axi_mm2s_data_width {512} \
   CONFIG.c_m_axi_mm2s_id_width {5} \
   CONFIG.c_m_axi_s2mm_data_width {512} \
   CONFIG.c_m_axi_s2mm_id_width {5} \
   CONFIG.c_m_axis_mm2s_tdata_width {512} \
   CONFIG.c_mm2s_btt_used {23} \
   CONFIG.c_mm2s_burst_size {4} \
   CONFIG.c_s2mm_btt_used {23} \
   CONFIG.c_s2mm_burst_size {4} \
   CONFIG.c_s2mm_support_indet_btt {false} \
   CONFIG.c_s_axis_s2mm_tdata_width {512} \
   CONFIG.c_single_interface {0} \
 ] $ht_axi_datamover

  # Create instance: ht_rd_axis_clock_converter, and set properties
  set ht_rd_axis_clock_converter [ create_bd_cell -type ip -vlnv xilinx.com:ip:axis_clock_converter:1.1 ht_rd_axis_clock_converter ]
  set_property -dict [ list \
   CONFIG.HAS_TKEEP {1} \
   CONFIG.HAS_TLAST {1} \
   CONFIG.TDATA_NUM_BYTES {64} \
 ] $ht_rd_axis_clock_converter

  # Create instance: ht_readConverter, and set properties
  set ht_readConverter [ create_bd_cell -type ip -vlnv xilinx.labs:hls:readConverter:1.04 ht_readConverter ]

  # Create instance: ht_wr_axis_clock_converter, and set properties
  set ht_wr_axis_clock_converter [ create_bd_cell -type ip -vlnv xilinx.com:ip:axis_clock_converter:1.1 ht_wr_axis_clock_converter ]
  set_property -dict [ list \
   CONFIG.HAS_TKEEP {1} \
   CONFIG.HAS_TLAST {1} \
   CONFIG.TDATA_NUM_BYTES {64} \
 ] $ht_wr_axis_clock_converter

  # Create instance: ht_writeConverter, and set properties
  set ht_writeConverter [ create_bd_cell -type ip -vlnv xilinx.labs:hls:writeConverter:1.05 ht_writeConverter ]

  # Create instance: memcachedPipeline_0, and set properties
  set memcachedPipeline_0 [ create_bd_cell -type ip -vlnv xilinx.labs:hls:memcachedPipeline:1.07 memcachedPipeline_0 ]

  # Create instance: vs_axi_datamover, and set properties
  set vs_axi_datamover [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_datamover:5.1 vs_axi_datamover ]
  set_property -dict [ list \
   CONFIG.c_dummy {1} \
   CONFIG.c_enable_mm2s_adv_sig {0} \
   CONFIG.c_enable_s2mm_adv_sig {0} \
   CONFIG.c_include_mm2s_dre {false} \
   CONFIG.c_include_s2mm_dre {false} \
   CONFIG.c_m_axi_mm2s_data_width {512} \
   CONFIG.c_m_axi_mm2s_id_width {5} \
   CONFIG.c_m_axi_s2mm_data_width {512} \
   CONFIG.c_m_axi_s2mm_id_width {5} \
   CONFIG.c_m_axis_mm2s_tdata_width {512} \
   CONFIG.c_mm2s_btt_used {23} \
   CONFIG.c_mm2s_burst_size {4} \
   CONFIG.c_s2mm_btt_used {23} \
   CONFIG.c_s2mm_burst_size {4} \
   CONFIG.c_s2mm_support_indet_btt {false} \
   CONFIG.c_s_axis_s2mm_tdata_width {512} \
   CONFIG.c_single_interface {0} \
 ] $vs_axi_datamover

  # Create instance: vs_rd_axis_clock_converter, and set properties
  set vs_rd_axis_clock_converter [ create_bd_cell -type ip -vlnv xilinx.com:ip:axis_clock_converter:1.1 vs_rd_axis_clock_converter ]
  set_property -dict [ list \
   CONFIG.HAS_TKEEP {1} \
   CONFIG.HAS_TLAST {1} \
   CONFIG.TDATA_NUM_BYTES {64} \
 ] $vs_rd_axis_clock_converter

  # Create instance: vs_readConverter, and set properties
  set vs_readConverter [ create_bd_cell -type ip -vlnv xilinx.labs:hls:readConverter:1.04 vs_readConverter ]

  # Create instance: vs_wr_axis_clock_converter, and set properties
  set vs_wr_axis_clock_converter [ create_bd_cell -type ip -vlnv xilinx.com:ip:axis_clock_converter:1.1 vs_wr_axis_clock_converter ]
  set_property -dict [ list \
   CONFIG.HAS_TKEEP {1} \
   CONFIG.HAS_TLAST {1} \
   CONFIG.TDATA_NUM_BYTES {64} \
 ] $vs_wr_axis_clock_converter

  # Create instance: vs_writeConverter, and set properties
  set vs_writeConverter [ create_bd_cell -type ip -vlnv xilinx.labs:hls:writeConverter:1.05 vs_writeConverter ]

  # Create interface connections
  connect_bd_intf_net -intf_net addressAssignDramIn_V_V_0_1 [get_bd_intf_ports alloc2mcd_DramIn_V_V_0] [get_bd_intf_pins memcachedPipeline_0/addressAssignDramIn_V_V]
  connect_bd_intf_net -intf_net ht_axi_datamover_M_AXIS_MM2S [get_bd_intf_pins ht_axi_datamover/M_AXIS_MM2S] [get_bd_intf_pins ht_rd_axis_clock_converter/S_AXIS]
  connect_bd_intf_net -intf_net ht_axi_datamover_M_AXIS_MM2S_STS [get_bd_intf_pins ht_axi_datamover/M_AXIS_MM2S_STS] [get_bd_intf_pins ht_readConverter/dmRdStatus_V_V]
  connect_bd_intf_net -intf_net ht_axi_datamover_M_AXIS_S2MM_STS [get_bd_intf_pins ht_axi_datamover/M_AXIS_S2MM_STS] [get_bd_intf_pins ht_writeConverter/dmWrStatus_V_V]
  connect_bd_intf_net -intf_net ht_axi_datamover_M_AXI_MM2S [get_bd_intf_ports MCD_AXI2DRAM_RD_C0] [get_bd_intf_pins ht_axi_datamover/M_AXI_MM2S]
  connect_bd_intf_net -intf_net ht_axi_datamover_M_AXI_S2MM [get_bd_intf_ports MCD_AXI2DRAM_WR_C0] [get_bd_intf_pins ht_axi_datamover/M_AXI_S2MM]
  connect_bd_intf_net -intf_net ht_rd_axis_clock_converter_M_AXIS [get_bd_intf_pins ht_rd_axis_clock_converter/M_AXIS] [get_bd_intf_pins ht_readConverter/dmRdData_V]
  connect_bd_intf_net -intf_net ht_readConverter_dmRdCmd_V [get_bd_intf_pins ht_axi_datamover/S_AXIS_MM2S_CMD] [get_bd_intf_pins ht_readConverter/dmRdCmd_V]
  connect_bd_intf_net -intf_net ht_wr_axis_clock_converter_M_AXIS [get_bd_intf_pins ht_axi_datamover/S_AXIS_S2MM] [get_bd_intf_pins ht_wr_axis_clock_converter/M_AXIS]
  connect_bd_intf_net -intf_net ht_writeConverter_dmWrCmd_V [get_bd_intf_pins ht_axi_datamover/S_AXIS_S2MM_CMD] [get_bd_intf_pins ht_writeConverter/dmWrCmd_V]
  connect_bd_intf_net -intf_net ht_writeConverter_dmWrData_V [get_bd_intf_pins ht_wr_axis_clock_converter/S_AXIS] [get_bd_intf_pins ht_writeConverter/dmWrData_V]
  connect_bd_intf_net -intf_net inData_0_1 [get_bd_intf_ports fromNet] [get_bd_intf_pins memcachedPipeline_0/inData]
  connect_bd_intf_net -intf_net memcachedPipeline_0_addressReturnOut_V_V [get_bd_intf_ports mcd2alloc_V_V_0] [get_bd_intf_pins memcachedPipeline_0/addressReturnOut_V_V]
  connect_bd_intf_net -intf_net memcachedPipeline_0_dramValueStoreMemRdCmd_V [get_bd_intf_pins memcachedPipeline_0/dramValueStoreMemRdCmd_V] [get_bd_intf_pins vs_readConverter/memRdCmd_V]
  connect_bd_intf_net -intf_net memcachedPipeline_0_dramValueStoreMemWrCmd_V [get_bd_intf_pins memcachedPipeline_0/dramValueStoreMemWrCmd_V] [get_bd_intf_pins vs_writeConverter/memWrCmd_V]
  connect_bd_intf_net -intf_net memcachedPipeline_0_dramValueStoreMemWrData_V_V [get_bd_intf_pins memcachedPipeline_0/dramValueStoreMemWrData_V_V] [get_bd_intf_pins vs_writeConverter/memWrData_V_V]
  connect_bd_intf_net -intf_net memcachedPipeline_0_hashTableMemRdCmd_V [get_bd_intf_pins ht_readConverter/memRdCmd_V] [get_bd_intf_pins memcachedPipeline_0/hashTableMemRdCmd_V]
  connect_bd_intf_net -intf_net memcachedPipeline_0_hashTableMemWrCmd_V [get_bd_intf_pins ht_writeConverter/memWrCmd_V] [get_bd_intf_pins memcachedPipeline_0/hashTableMemWrCmd_V]
  connect_bd_intf_net -intf_net memcachedPipeline_0_hashTableMemWrData_V_V [get_bd_intf_pins ht_writeConverter/memWrData_V_V] [get_bd_intf_pins memcachedPipeline_0/hashTableMemWrData_V_V]
  connect_bd_intf_net -intf_net memcachedPipeline_0_outData [get_bd_intf_ports toNet] [get_bd_intf_pins memcachedPipeline_0/outData]
  connect_bd_intf_net -intf_net readConverter_0_memRdData_V_V [get_bd_intf_pins ht_readConverter/memRdData_V_V] [get_bd_intf_pins memcachedPipeline_0/hashTableMemRdData_V_V]
  connect_bd_intf_net -intf_net vs_axi_datamover_M_AXIS_MM2S [get_bd_intf_pins vs_axi_datamover/M_AXIS_MM2S] [get_bd_intf_pins vs_rd_axis_clock_converter/S_AXIS]
  connect_bd_intf_net -intf_net vs_axi_datamover_M_AXIS_MM2S_STS [get_bd_intf_pins vs_axi_datamover/M_AXIS_MM2S_STS] [get_bd_intf_pins vs_readConverter/dmRdStatus_V_V]
  connect_bd_intf_net -intf_net vs_axi_datamover_M_AXIS_S2MM_STS [get_bd_intf_pins vs_axi_datamover/M_AXIS_S2MM_STS] [get_bd_intf_pins vs_writeConverter/dmWrStatus_V_V]
  connect_bd_intf_net -intf_net vs_axi_datamover_M_AXI_MM2S [get_bd_intf_ports MCD_AXI2DRAM_RD_C1] [get_bd_intf_pins vs_axi_datamover/M_AXI_MM2S]
  connect_bd_intf_net -intf_net vs_axi_datamover_M_AXI_S2MM [get_bd_intf_ports MCD_AXI2DRAM_WR_C1] [get_bd_intf_pins vs_axi_datamover/M_AXI_S2MM]
  connect_bd_intf_net -intf_net vs_rd_axis_clock_converter_M_AXIS [get_bd_intf_pins vs_rd_axis_clock_converter/M_AXIS] [get_bd_intf_pins vs_readConverter/dmRdData_V]
  connect_bd_intf_net -intf_net vs_readConverter_dmRdCmd_V [get_bd_intf_pins vs_axi_datamover/S_AXIS_MM2S_CMD] [get_bd_intf_pins vs_readConverter/dmRdCmd_V]
  connect_bd_intf_net -intf_net vs_readConverter_memRdData_V_V [get_bd_intf_pins memcachedPipeline_0/dramValueStoreMemRdData_V_V] [get_bd_intf_pins vs_readConverter/memRdData_V_V]
  connect_bd_intf_net -intf_net vs_wr_axis_clock_converter_M_AXIS [get_bd_intf_pins vs_axi_datamover/S_AXIS_S2MM] [get_bd_intf_pins vs_wr_axis_clock_converter/M_AXIS]
  connect_bd_intf_net -intf_net vs_writeConverter_dmWrCmd_V [get_bd_intf_pins vs_axi_datamover/S_AXIS_S2MM_CMD] [get_bd_intf_pins vs_writeConverter/dmWrCmd_V]
  connect_bd_intf_net -intf_net vs_writeConverter_dmWrData_V [get_bd_intf_pins vs_wr_axis_clock_converter/S_AXIS] [get_bd_intf_pins vs_writeConverter/dmWrData_V]

  # Create port connections
  connect_bd_net -net Net [get_bd_ports aclk] [get_bd_pins ht_axi_datamover/m_axis_mm2s_cmdsts_aclk] [get_bd_pins ht_axi_datamover/m_axis_s2mm_cmdsts_awclk] [get_bd_pins ht_rd_axis_clock_converter/m_axis_aclk] [get_bd_pins ht_readConverter/aclk] [get_bd_pins ht_wr_axis_clock_converter/s_axis_aclk] [get_bd_pins ht_writeConverter/aclk] [get_bd_pins memcachedPipeline_0/ap_clk] [get_bd_pins vs_axi_datamover/m_axis_mm2s_cmdsts_aclk] [get_bd_pins vs_axi_datamover/m_axis_s2mm_cmdsts_awclk] [get_bd_pins vs_rd_axis_clock_converter/m_axis_aclk] [get_bd_pins vs_readConverter/aclk] [get_bd_pins vs_wr_axis_clock_converter/s_axis_aclk] [get_bd_pins vs_writeConverter/aclk]
  connect_bd_net -net Net1 [get_bd_ports aresetn] [get_bd_pins ht_axi_datamover/m_axis_mm2s_cmdsts_aresetn] [get_bd_pins ht_axi_datamover/m_axis_s2mm_cmdsts_aresetn] [get_bd_pins ht_rd_axis_clock_converter/m_axis_aresetn] [get_bd_pins ht_readConverter/aresetn] [get_bd_pins ht_wr_axis_clock_converter/s_axis_aresetn] [get_bd_pins ht_writeConverter/aresetn] [get_bd_pins memcachedPipeline_0/ap_rst_n] [get_bd_pins vs_axi_datamover/m_axis_mm2s_cmdsts_aresetn] [get_bd_pins vs_axi_datamover/m_axis_s2mm_cmdsts_aresetn] [get_bd_pins vs_rd_axis_clock_converter/m_axis_aresetn] [get_bd_pins vs_readConverter/aresetn] [get_bd_pins vs_wr_axis_clock_converter/s_axis_aresetn] [get_bd_pins vs_writeConverter/aresetn]
  connect_bd_net -net Net2 [get_bd_ports mem_c0_clk] [get_bd_pins ht_axi_datamover/m_axi_mm2s_aclk] [get_bd_pins ht_axi_datamover/m_axi_s2mm_aclk] [get_bd_pins ht_rd_axis_clock_converter/s_axis_aclk] [get_bd_pins ht_wr_axis_clock_converter/m_axis_aclk] [get_bd_pins vs_axi_datamover/m_axi_mm2s_aclk] [get_bd_pins vs_axi_datamover/m_axi_s2mm_aclk] [get_bd_pins vs_rd_axis_clock_converter/s_axis_aclk] [get_bd_pins vs_wr_axis_clock_converter/m_axis_aclk]
  connect_bd_net -net Net4 [get_bd_ports mem_c0_resetn] [get_bd_pins ht_axi_datamover/m_axi_mm2s_aresetn] [get_bd_pins ht_axi_datamover/m_axi_s2mm_aresetn] [get_bd_pins ht_rd_axis_clock_converter/s_axis_aresetn] [get_bd_pins ht_wr_axis_clock_converter/m_axis_aresetn] [get_bd_pins vs_axi_datamover/m_axi_mm2s_aresetn] [get_bd_pins vs_axi_datamover/m_axi_s2mm_aresetn] [get_bd_pins vs_rd_axis_clock_converter/s_axis_aresetn] [get_bd_pins vs_wr_axis_clock_converter/m_axis_aresetn]
  connect_bd_net -net flushAck_V_0_1 [get_bd_ports flushAck_V_0] [get_bd_pins memcachedPipeline_0/flushAck_V]
  connect_bd_net -net memcachedPipeline_0_flushDone_V [get_bd_ports flushDone_V_0] [get_bd_pins memcachedPipeline_0/flushDone_V]
  connect_bd_net -net memcachedPipeline_0_flushReq_V [get_bd_ports flushReq_V_0] [get_bd_pins memcachedPipeline_0/flushReq_V]

  # Create address segments


  # Restore current instance
  current_bd_instance $oldCurInst

  save_bd_design
  close_bd_design $design_name 
}
# End of cr_bd_memcached_pipeline()
cr_bd_memcached_pipeline ""
set_property IS_MANAGED "0" [get_files memcached_pipeline.bd ] 
set_property REGISTERED_WITH_MANAGER "1" [get_files memcached_pipeline.bd ] 
set_property SYNTH_CHECKPOINT_MODE "Hierarchical" [get_files memcached_pipeline.bd ] 

##################################################################
# Make wrappers so that these IPs can be treated as black boxes 
##################################################################
make_wrapper -files [get_files ${origin_dir}/generated_vivado_project/memcached_pipeline.srcs/sources_1/bd/memcached_pipeline/memcached_pipeline.bd] -top
add_files -norecurse ${origin_dir}/generated_vivado_project/memcached_pipeline.srcs/sources_1/bd/memcached_pipeline/hdl/memcached_pipeline_wrapper.v

# Create 'synth_1' run (if not found)
if {[string equal [get_runs -quiet synth_1] ""]} {
    create_run -name synth_1 -part xcvu095-ffva2104-2-e -flow {Vivado Synthesis 2018} -strategy "Vivado Synthesis Defaults" -report_strategy {No Reports} -constrset constrs_1
} else {
  set_property strategy "Vivado Synthesis Defaults" [get_runs synth_1]
  set_property flow "Vivado Synthesis 2018" [get_runs synth_1]
}
set obj [get_runs synth_1]
set_property set_report_strategy_name 1 $obj
set_property report_strategy {Vivado Synthesis Default Reports} $obj
set_property set_report_strategy_name 0 $obj
# Create 'synth_1_synth_report_utilization_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs synth_1] synth_1_synth_report_utilization_0] "" ] } {
  create_report_config -report_name synth_1_synth_report_utilization_0 -report_type report_utilization:1.0 -steps synth_design -runs synth_1
}
set obj [get_report_configs -of_objects [get_runs synth_1] synth_1_synth_report_utilization_0]
if { $obj != "" } {

}
set obj [get_runs synth_1]
set_property -name "part" -value "xcvu095-ffva2104-2-e" -objects $obj
set_property -name "strategy" -value "Vivado Synthesis Defaults" -objects $obj

# set the current synth run
current_run -synthesis [get_runs synth_1]

# Create 'impl_1' run (if not found)
if {[string equal [get_runs -quiet impl_1] ""]} {
    create_run -name impl_1 -part xcvu095-ffva2104-2-e -flow {Vivado Implementation 2018} -strategy "Vivado Implementation Defaults" -report_strategy {No Reports} -constrset constrs_1 -parent_run synth_1
} else {
  set_property strategy "Vivado Implementation Defaults" [get_runs impl_1]
  set_property flow "Vivado Implementation 2018" [get_runs impl_1]
}
set obj [get_runs impl_1]
set_property set_report_strategy_name 1 $obj
set_property report_strategy {Vivado Implementation Default Reports} $obj
set_property set_report_strategy_name 0 $obj
# Create 'impl_1_init_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_init_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_init_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps init_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_init_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_opt_report_drc_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_opt_report_drc_0] "" ] } {
  create_report_config -report_name impl_1_opt_report_drc_0 -report_type report_drc:1.0 -steps opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_opt_report_drc_0]
if { $obj != "" } {

}
# Create 'impl_1_opt_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_opt_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_opt_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_opt_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_power_opt_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_power_opt_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_power_opt_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps power_opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_power_opt_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_place_report_io_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_io_0] "" ] } {
  create_report_config -report_name impl_1_place_report_io_0 -report_type report_io:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_io_0]
if { $obj != "" } {

}
# Create 'impl_1_place_report_utilization_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_utilization_0] "" ] } {
  create_report_config -report_name impl_1_place_report_utilization_0 -report_type report_utilization:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_utilization_0]
if { $obj != "" } {

}
# Create 'impl_1_place_report_control_sets_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_control_sets_0] "" ] } {
  create_report_config -report_name impl_1_place_report_control_sets_0 -report_type report_control_sets:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_control_sets_0]
if { $obj != "" } {

}
# Create 'impl_1_place_report_incremental_reuse_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_incremental_reuse_0] "" ] } {
  create_report_config -report_name impl_1_place_report_incremental_reuse_0 -report_type report_incremental_reuse:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_incremental_reuse_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_place_report_incremental_reuse_1' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_incremental_reuse_1] "" ] } {
  create_report_config -report_name impl_1_place_report_incremental_reuse_1 -report_type report_incremental_reuse:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_incremental_reuse_1]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_place_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_place_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps place_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_place_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_post_place_power_opt_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_post_place_power_opt_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_post_place_power_opt_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps post_place_power_opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_post_place_power_opt_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_phys_opt_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_phys_opt_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_phys_opt_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps phys_opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_phys_opt_report_timing_summary_0]
if { $obj != "" } {
set_property -name "is_enabled" -value "0" -objects $obj

}
# Create 'impl_1_route_report_drc_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_drc_0] "" ] } {
  create_report_config -report_name impl_1_route_report_drc_0 -report_type report_drc:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_drc_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_methodology_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_methodology_0] "" ] } {
  create_report_config -report_name impl_1_route_report_methodology_0 -report_type report_methodology:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_methodology_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_power_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_power_0] "" ] } {
  create_report_config -report_name impl_1_route_report_power_0 -report_type report_power:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_power_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_route_status_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_route_status_0] "" ] } {
  create_report_config -report_name impl_1_route_report_route_status_0 -report_type report_route_status:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_route_status_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_route_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_timing_summary_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_incremental_reuse_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_incremental_reuse_0] "" ] } {
  create_report_config -report_name impl_1_route_report_incremental_reuse_0 -report_type report_incremental_reuse:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_incremental_reuse_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_clock_utilization_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_clock_utilization_0] "" ] } {
  create_report_config -report_name impl_1_route_report_clock_utilization_0 -report_type report_clock_utilization:1.0 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_clock_utilization_0]
if { $obj != "" } {

}
# Create 'impl_1_route_report_bus_skew_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_bus_skew_0] "" ] } {
  create_report_config -report_name impl_1_route_report_bus_skew_0 -report_type report_bus_skew:1.1 -steps route_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_route_report_bus_skew_0]
if { $obj != "" } {

}
# Create 'impl_1_post_route_phys_opt_report_timing_summary_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_post_route_phys_opt_report_timing_summary_0] "" ] } {
  create_report_config -report_name impl_1_post_route_phys_opt_report_timing_summary_0 -report_type report_timing_summary:1.0 -steps post_route_phys_opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_post_route_phys_opt_report_timing_summary_0]
if { $obj != "" } {

}
# Create 'impl_1_post_route_phys_opt_report_bus_skew_0' report (if not found)
if { [ string equal [get_report_configs -of_objects [get_runs impl_1] impl_1_post_route_phys_opt_report_bus_skew_0] "" ] } {
  create_report_config -report_name impl_1_post_route_phys_opt_report_bus_skew_0 -report_type report_bus_skew:1.1 -steps post_route_phys_opt_design -runs impl_1
}
set obj [get_report_configs -of_objects [get_runs impl_1] impl_1_post_route_phys_opt_report_bus_skew_0]
if { $obj != "" } {

}
set obj [get_runs impl_1]
set_property -name "part" -value "xcvu095-ffva2104-2-e" -objects $obj
set_property -name "strategy" -value "Vivado Implementation Defaults" -objects $obj
set_property -name "steps.write_bitstream.args.readback_file" -value "0" -objects $obj
set_property -name "steps.write_bitstream.args.verbose" -value "0" -objects $obj

# set the current impl run
current_run -implementation [get_runs impl_1]

#####################################################
#
####################################################

set_property strategy Flow_PerfOptimized_high [get_runs synth_1]
set_property STEPS.SYNTH_DESIGN.ARGS.FANOUT_LIMIT 300 [get_runs synth_1]
set_property strategy Performance_ExplorePostRoutePhysOpt [get_runs impl_1]
set_property STEPS.PHYS_OPT_DESIGN.ARGS.DIRECTIVE AggressiveExplore [get_runs impl_1]
set_property STEPS.POST_ROUTE_PHYS_OPT_DESIGN.ARGS.DIRECTIVE AggressiveExplore [get_runs impl_1]

##################################################################
# run synthesis 
##################################################################
#launch_runs synth_1 -jobs 12
#wait_on_run synth_1

#launch_runs impl_1 -to_step write_bitstream -jobs 8
#wait_on_run impl_1

##################################################################
# package and export  the design as IP 
##################################################################
ipx::package_project -root_dir ${origin_dir}/../../../generated_ip/app_memcached_vcu108 -vendor wuklab -library user -taxonomy UserIP -import_files -set_current false -force

update_ip_catalog -rebuild

puts "INFO: Project created:${_xil_proj_name_}"

exit
