function(chcore_dump_cmake_vars)
    message(STATUS "CMAKE_TOOLCHAIN_FILE: ${CMAKE_TOOLCHAIN_FILE}")
    message(STATUS "CMAKE_MODULE_PATH: ${CMAKE_MODULE_PATH}")
    message(STATUS "CMAKE_CROSSCOMPILING: ${CMAKE_CROSSCOMPILING}")
    message(STATUS "CMAKE_SYSTEM_PROCESSOR: ${CMAKE_SYSTEM_PROCESSOR}")
    message(STATUS "CMAKE_SYSTEM_NAME: ${CMAKE_SYSTEM_NAME}")
    message(
        STATUS "CMAKE_HOST_SYSTEM_PROCESSOR: ${CMAKE_HOST_SYSTEM_PROCESSOR}")
    message(STATUS "CMAKE_HOST_SYSTEM_NAME: ${CMAKE_HOST_SYSTEM_NAME}")
    message(STATUS "CMAKE_BUILD_TYPE: ${CMAKE_BUILD_TYPE}")
    message(STATUS "CMAKE_ASM_COMPILER: ${CMAKE_ASM_COMPILER}")
    message(STATUS "CMAKE_C_COMPILER: ${CMAKE_C_COMPILER}")
    message(STATUS "CMAKE_C_OUTPUT_EXTENSION: ${CMAKE_C_OUTPUT_EXTENSION}")
    message(STATUS "CMAKE_LINKER: ${CMAKE_LINKER}")
    message(STATUS "CMAKE_SOURCE_DIR: ${CMAKE_SOURCE_DIR}")
    message(STATUS "CMAKE_BINARY_DIR: ${CMAKE_BINARY_DIR}")
    message(STATUS "CMAKE_PREFIX_PATH: ${CMAKE_PREFIX_PATH}")
    message(STATUS "CMAKE_INSTALL_PREFIX: ${CMAKE_INSTALL_PREFIX}")

    chcore_dump_chcore_vars()
endfunction()

function(chcore_dump_chcore_vars)
    get_cmake_property(_variable_names VARIABLES)
    list(SORT _variable_names)
    foreach(_variable_name ${_variable_names})
        string(REGEX MATCH "^CHCORE_" _matched ${_variable_name})
        if(NOT _matched)
            continue()
        endif()
        message(STATUS "${_variable_name}: ${${_variable_name}}")
    endforeach()
endfunction()

macro(chcore_config_include _config_rel_path)
    include(${CMAKE_CURRENT_LIST_DIR}/${_config_rel_path})
endmacro()

function(chcore_target_remove_compile_options _target)
    get_target_property(_target_options ${_target} COMPILE_OPTIONS)
    if(_target_options)
        foreach(_option ${ARGN})
            list(REMOVE_ITEM _target_options ${_option})
        endforeach()
        set_target_properties(${_target} PROPERTIES COMPILE_OPTIONS
                                                    "${_target_options}")
    endif()
endfunction()

function(chcore_target_remove_link_options _target)
    get_target_property(_target_options ${_target} LINK_OPTIONS)
    if(_target_options)
        foreach(_option ${ARGN})
            list(REMOVE_ITEM _target_options ${_option})
        endforeach()
        set_target_properties(${_target} PROPERTIES LINK_OPTIONS
                                                    "${_target_options}")
    endif()
endfunction()

if(NOT COMMAND ProcessorCount)
    include(ProcessorCount)
endif()

macro(chcore_get_nproc _nproc)
    ProcessorCount(${_nproc})
    if(${_nproc} EQUAL 0)
        set(${_nproc} 16)
    endif()
endmacro()
