/*
 * Copyright (c) 2022 Institute of Parallel And Distributed Systems (IPADS)
 * ChCore-Lab is licensed under the Mulan PSL v1.
 * You can use this software according to the terms and conditions of the Mulan PSL v1.
 * You may obtain a copy of Mulan PSL v1 at:
 *     http://license.coscl.org.cn/MulanPSL
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
 * PURPOSE.
 * See the Mulan PSL v1 for more details.
 */

#pragma once

#define __asm_syscall(...)                              \
        do {                                            \
                __asm__ __volatile__("svc 0"            \
                                     : "=r"(x0)         \
                                     : __VA_ARGS__      \
                                     : "memory", "cc"); \
                return x0;                              \
        } while (0)

static inline long __chcore_syscall0(long n)
{
        register long x8 __asm__("x8") = n;
        register long x0 __asm__("x0");
        __asm_syscall("r"(x8));
}

static inline long __chcore_syscall1(long n, long a)
{
        register long x8 __asm__("x8") = n;
        register long x0 __asm__("x0") = a;
        __asm_syscall("r"(x8), "0"(x0));
}

static inline long __chcore_syscall2(long n, long a, long b)
{
        register long x8 __asm__("x8") = n;
        register long x0 __asm__("x0") = a;
        register long x1 __asm__("x1") = b;
        __asm_syscall("r"(x8), "0"(x0), "r"(x1));
}

static inline long __chcore_syscall3(long n, long a, long b, long c)
{
        register long x8 __asm__("x8") = n;
        register long x0 __asm__("x0") = a;
        register long x1 __asm__("x1") = b;
        register long x2 __asm__("x2") = c;
        __asm_syscall("r"(x8), "0"(x0), "r"(x1), "r"(x2));
}

static inline long __chcore_syscall4(long n, long a, long b, long c, long d)
{
        register long x8 __asm__("x8") = n;
        register long x0 __asm__("x0") = a;
        register long x1 __asm__("x1") = b;
        register long x2 __asm__("x2") = c;
        register long x3 __asm__("x3") = d;
        __asm_syscall("r"(x8), "0"(x0), "r"(x1), "r"(x2), "r"(x3));
}

static inline long __chcore_syscall5(long n, long a, long b, long c, long d,
                                     long e)
{
        register long x8 __asm__("x8") = n;
        register long x0 __asm__("x0") = a;
        register long x1 __asm__("x1") = b;
        register long x2 __asm__("x2") = c;
        register long x3 __asm__("x3") = d;
        register long x4 __asm__("x4") = e;
        __asm_syscall("r"(x8), "0"(x0), "r"(x1), "r"(x2), "r"(x3), "r"(x4));
}

static inline long __chcore_syscall6(long n, long a, long b, long c, long d,
                                     long e, long f)
{
        register long x8 __asm__("x8") = n;
        register long x0 __asm__("x0") = a;
        register long x1 __asm__("x1") = b;
        register long x2 __asm__("x2") = c;
        register long x3 __asm__("x3") = d;
        register long x4 __asm__("x4") = e;
        register long x5 __asm__("x5") = f;
        __asm_syscall(
                "r"(x8), "0"(x0), "r"(x1), "r"(x2), "r"(x3), "r"(x4), "r"(x5));
}
