# Yukina - Yukina

A simple and elegant Astro blog template.

![Preview](https://s2.loli.net/2024/12/06/KQlEiph216mOZdy.webp)

## Demo Preview Link

[🖥️ Live Demo (Vercel)](https://yukina-blog.vercel.app) |
[🖥️ WhitePaper233's Blog (may not be the latest version)](https://yukina-blog.vercel.app)

## 🛠️ Build Guide

### 1. Install Node.js version 22 or above

Go to the [Node.js official website](https://nodejs.org/) to download and install the latest version of Node.js.

### 2. Enable Corepack

```bash
corepack enable
```

### 3. Install Yarn version 4.5.1 or above

```bash
corepack prepare yarn@4.5.1 --activate
```

### 4. Install dependencies

```bash
yarn
```

### 5. Start the development server

```bash
yarn dev
```

### 6. Build the project

```bash
yarn build
```

### 7. Preview the project

```bash
yarn preview
```

## 🗺️ Roadmap

### Short-term

✅ - Completed | 🧪 - Testing | 🚧 - In Progress | ⏳ - Planned

| Status | Project                                           |
| ------ | ------------------------------------------------- |
| 🧪     | Basic functionality implementation                |
| 🚧     | Refactor some code and optimize overall structure |
| 🚧     | Optimize animation effects                        |
| 🚧     | Mobile adaptation                                 |
| 🚧     | Optimize website performance                      |
| 🧪     | Adjustable colors                                 |
| ⏳     | Add RSS, SiteMap, etc.                            |
| ⏳     | More build options (e.g., SLUG generation method) |
| ⏳     | Add Live2D character                              |
| 🧪     | Search functionality                              |
| 🧪     | i18n                                              |

### Long-term

| Status | Project                                             |
| ------ | --------------------------------------------------- |
| ⏳     | Develop a CLI and a small CMS for easier management |
| ⏳     | Slidev components                                   |
| ⏳     | More Markdown components                            |

## 🙏 Special Thanks

- [Hexo Shoka Theme](https://github.com/amehime/hexo-theme-shoka) for providing design ideas

- [Astro Fuwari Template](https://github.com/saicaca/fuwari) for providing the main design ideas and some code implementations
