<p align="center"><img width="210" src="https://github.com/Water-Melon/Melon/blob/master/docs/logo.png?raw=true" alt="Melon logo"></p>
<p align="center"><img src="https://img.shields.io/github/license/Water-Melon/Melang" /></p>



Welcome to the Melon C language library. This library contains many algorithms, data structures, functional components, scripting languages and practical frameworks, which can facilitate developers to quickly develop application functions and avoid the dilemma of repeated wheel building.

QQ: 756582294


### Components

Melon currently provides the following components:

- Components
  - Library Initialization
  - Configuration
  - Log
  - Error Code Management
  - Memory Pool
  - Thread Pool
  - I/O Thread
  - TCP Encapsulation
  - Event Mechanism
  - File Set
  - HTTP Handling
  - Scripting Language
  - Lexical Analyzer
  - Parser Generator
  - Websocket
  - String
  - Regular Expression
  - Big Number Calculation
  - FEC
  - JSON
  - Matrix Operations
  - Reed Solomon Coding
  - Cron Format Parser
  - Spin Lock
  - Prime Generator
  - Span
  - Expression
- Data Structures
  - Doubly Linked List
  - Fibonacci Heap
  - Hash Table
  - Queue
  - Red-black Tree
  - Stack
  - Array
- Algorithms
  - AES
  - DES/3DES
  - RC4
  - RSA
  - MD5
  - SHA
  - Base64
- Template
  - Function Template
  - Class Template
- Scripting Language Development
- Frameworks
  - Multi-Process Model
  - Multi-Thread Model
  - Trace Mode
  - IPC



### Platform Support

Melon was originally written for UNIX systems, so it is suitable for UNIX-like systems such as Linux and MacOS. And there are a few optimizations for Intel CPUs.

At present, Melon has also completed the preliminary porting to Windows, so it can be used on Windows. However, because Windows differs greatly from the UNIX system in the creation process, some functions of the above `framework` are temporarily not supported in Windows.
