<?php

declare(strict_types=1);

/**
 * This file is part of the EaseCore package.
 *
 * (c) Vítězslav Dvořák <info@vitexsoftware.cz>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Test\Ease;

use Ease\Sand;
/**
 * @codingStandardsIgnoreFile
 *
 * @codeCoverageIgnoreStart
 */
use PHPUnit\Framework\Attributes\CoversClass;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2016-01-17 at 09:50:39.
 */
#[CoversClass(Sand::class)]

class SandTest extends AtomTest
{
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp(): void
    {
        $this->object = new \Ease\Sand();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown(): void
    {
    }

    /**
     * @covers \Ease\Sand::dataReset
     */
    public function testDataReset(): void
    {
        $this->object->dataReset();
        $this->assertEmpty($this->object->getData());
    }

    /**
     * @covers \Ease\Sand::setData
     */
    public function testSetData(): void
    {
        $data = ['a' => 1, 'b' => 2];
        $this->object->setData($data, true);
        $this->assertEquals($data, $this->object->getData());
    }

    /**
     * @covers \Ease\Sand::getData
     *
     * @depends testSetData
     */
    public function testGetData(): void
    {
        $data = ['a' => 1, 'b' => 2];
        $this->object->setData($data);
        $this->assertEquals($data, $this->object->getData());
    }

    /**
     * @covers \Ease\Sand::getDataCount
     */
    public function testGetDataCount(): void
    {
        $this->object->dataReset();
        $data = ['a' => 1, 'b' => 2];
        $this->object->setData($data);
        $this->assertEquals(2, $this->object->getDataCount());
    }

    /**
     * @covers \Ease\Sand::getDataValue
     */
    public function testGetDataValue(): void
    {
        $data = ['a' => 1, 'b' => 2];
        $this->object->setData($data);
        $this->assertEquals(2, $this->object->getDataValue('b'));
        $this->assertNull($this->object->getDataValue('c'));
    }

    /**
     * @covers \Ease\Sand::setDataValue
     */
    public function testSetDataValue(): void
    {
        $this->object->setDataValue('c', 3);
        $this->assertEquals(3, $this->object->getDataValue('c'));
    }

    /**
     * @covers \Ease\Sand::unsetDataValue
     */
    public function testUnsetDataValue(): void
    {
        $data = ['a' => 1, 'b' => 2];
        $this->object->setData($data);
        $this->assertTrue($this->object->unsetDataValue('a'));
        $this->assertNull($this->object->getDataValue('a'));
        $this->assertFalse($this->object->unsetDataValue('c'));
    }

    /**
     * @covers \Ease\Sand::takeData
     */
    public function testTakeData(): void
    {
        $data = ['d' => 4, 'e' => 5];
        $this->object->takeData($data);
        $this->assertEquals(5, $this->object->getDataValue('e'));
        $data = ['f' => 6, 'g' => 7];
        $this->object->takeData($data);
        $this->assertEquals(4, $this->object->getDataValue('d'));
    }

    /**
     * @covers \Ease\Sand::draw
     *
     * @param null|mixed $whatWant
     */
    public function testDraw($whatWant = null): void
    {
        $this->assertEmpty($this->object->draw());
    }
}

// @codeCoverageIgnoreEnd
