<?php

declare(strict_types=1);

/**
 * This file is part of the EaseCore package.
 *
 * (c) Vítězslav Dvořák <info@vitexsoftware.cz>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Test\Ease\Logger;

use Ease\Logger\ToStd;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2018-04-06 at 23:38:43.
 */
class ToStdTest extends ToMemoryTest
{
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp(): void
    {
        $this->object = new ToStd();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown(): void
    {
    }

    /**
     * Test Constructor.
     *
     * @covers \Ease\Logger\ToStd::__construct
     */
    public function testConstructor(): void
    {
        $classname = \get_class($this->object);

        // Get mock, without the constructor being called
        $mock = $this->getMockBuilder($classname)
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();

        $mock->__construct();
        $this->assertEquals('unitTest', $mock->logName);

        $mock->__construct('test');
        $this->assertEquals('test', $mock->logName);
    }

    /**
     * @covers \Ease\Logger\ToStd::singleton
     */
    public function testSingleton(): void
    {
        $this->assertInstanceOf('Ease\Logger\ToStd', ToStd::singleton());
    }

    /**
     * @covers \Ease\Logger\ToStd::addToLog
     */
    public function testAddToLog(): void
    {
        $this->assertEquals(49, $this->object->addToLog($this, 'test'));
    }

    /**
     * @covers \Ease\Logger\ToStd::output
     */
    public function testOutput(): void
    {
        $this->assertIsInt($this->object->output('info', 'test'));
        $this->assertIsInt($this->object->output('error', 'test'));
    }

    /**
     * @covers \Ease\Logger\ToStd::finalizeMessage
     */
    public function testFinalizeMessage(): void
    {
        $this->assertEquals('TEST'.\PHP_EOL, $this->object->finalizeMessage(' TEST '));
    }
}
