<?php

declare(strict_types=1);

/**
 * This file is part of the EaseCore package.
 *
 * (c) Vítězslav Dvořák <info@vitexsoftware.cz>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Test\Ease\Logger;

use Ease\Logger\ToFile;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2016-01-17 at 23:59:52.
 */
class ToFileTest extends ToMemoryTest
{
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp(): void
    {
        $this->object = new ToFile(sys_get_temp_dir().'/');
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown(): void
    {
    }

    /**
     * Test Constructor.
     *
     * @covers \Ease\Logger\ToFile::__construct
     */
    public function testConstructor(): void
    {
        $classname = \get_class($this->object);

        $mock = $this->getMockBuilder($classname)
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();

        $mock->__construct(sys_get_temp_dir().'/');
        $this->assertEquals(sys_get_temp_dir().'/Ease.log', $mock->logFileName);
    }

    /**
     * @covers \Ease\Logger\ToFile::singleton
     */
    public function testSingleton(): void
    {
        $this->assertInstanceOf('Ease\Logger\ToFile', ToFile::singleton());
    }

    /**
     * @covers \Ease\Logger\ToFile::setupLogFiles
     */
    public function testSetupLogFiles(): void
    {
        $this->expectException('\Exception');
        $this->assertEquals(sys_get_temp_dir().'/Ease.log', $this->object->logFileName);
        $this->object->setupLogFiles('/var/log');
    }

    /**
     * @covers \Ease\Logger\ToFile::addToLog
     */
    public function testAddToLog(): void
    {
        $this->assertIsInt($this->object->addToLog($this, 'test'));
    }

    /**
     * @covers \Ease\Logger\ToFile::testDirectory
     */
    public function testTestDirectory(): void
    {
        $this->assertTrue($this->object->testDirectory(sys_get_temp_dir()));
        $this->expectException('\Exception');
        \Ease\Logger\ToFile::testDirectory('none', true);
        $this->expectException('\Exception');
        \Ease\Logger\ToFile::testDirectory('/root', true, true);
        $this->expectException('\Exception');
        \Ease\Logger\ToFile::testDirectory('/root', true, true, true);
    }

    /**
     * @covers \Ease\Logger\ToFile::__destruct
     */
    public function testDestruct(): void
    {
        $this->assertEmpty($this->object->__destruct());
    }
}
