<?php

declare(strict_types=1);

/**
 * This file is part of the EaseCore package.
 *
 * (c) Vítězslav Dvořák <info@vitexsoftware.cz>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Test\Ease\Logger;

use Ease\Logger\ToConsole;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2019-08-05 at 05:48:05.
 */
class ToConsoleTest extends ToMemoryTest
{
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp(): void
    {
        $this->object = new ToConsole();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown(): void
    {
    }

    /**
     * Test Constructor.
     *
     * @covers \Ease\Logger\ToConsole::__construct
     */
    public function testConstructor(): void
    {
        $classname = \get_class($this->object);

        // Get mock, without the constructor being called
        $mock = $this->getMockBuilder($classname)
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();

        $mock->__construct();

        $this->assertIsResource($mock->stdout, 'StdOut is not resource');
        $this->assertIsResource($mock->stderr, 'StdErr is not resource');
    }

    /**
     * @covers \Ease\Logger\ToConsole::set
     */
    public function testSet(): void
    {
        $this->assertEquals("\033[31mred\033[0m", $this->object->set('red', 'red'));
    }

    /**
     * @covers \Ease\Logger\Loggingable::addToLog
     * @covers \Ease\Logger\ToConsole::addToLog
     */
    public function testAddToLog(): void
    {
        $this->assertIsInt($this->object->addToLog($this, 'test'));
        $this->assertIsInt($this->object->addToLog($this, 'test', 'success'));
        $this->assertIsInt($this->object->addToLog($this, 'test error', 'error'));
    }

    /**
     * @covers \Ease\Logger\ToConsole::getTypeColor
     */
    public function testGetTypeColor(): void
    {
        $this->assertEquals('blue', \Ease\Logger\ToConsole::getTypeColor('mail'));
        $this->assertEquals('yellow', \Ease\Logger\ToConsole::getTypeColor('warning'));
        $this->assertEquals('red', \Ease\Logger\ToConsole::getTypeColor('error'));
        $this->assertEquals('magenta', \Ease\Logger\ToConsole::getTypeColor('debug'));
        $this->assertEquals('green', \Ease\Logger\ToConsole::getTypeColor('success'));
        $this->assertEquals('white', \Ease\Logger\ToConsole::getTypeColor('test'));
    }

    /**
     * @covers \Ease\Logger\ToConsole::singleton
     */
    public function testSingleton(): void
    {
        $this->assertInstanceOf('\Ease\Logger\ToConsole', \Ease\Logger\ToConsole::singleton());
    }
}
