<?php

declare(strict_types=1);

/**
 * This file is part of the EaseCore package.
 *
 * (c) Vítězslav Dvořák <info@vitexsoftware.cz>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Test\Ease\Logger;

use Ease\Logger\Regent;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2017-11-28 at 21:17:33.
 */
class RegentTest extends \Test\Ease\AtomTest
{
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp(): void
    {
        $this->object = new Regent([]);
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown(): void
    {
    }

    /**
     * @covers \Ease\Logger\Regent::__construct
     */
    public function testConstructor(): void
    {
        $classname = \get_class($this->object);

        // Get mock, without the constructor being called
        $mock = $this->getMockBuilder($classname)
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();
        $mock->__construct();
        $mock->__construct('syslog');
        $mock->__construct('console');
        $mock->__construct('file');
        $mock->__construct('std');
        $mock->__construct('eventlog');
        $mock->__construct('\Ease\Logger\ToFile');

        $this->assertEquals(
            ['memory', 'syslog', 'console', 'file', 'std', 'eventlog', '\Ease\Logger\ToFile'],
            array_keys($mock->loggers),
        );
    }

    /**
     * @covers \Ease\Logger\Regent::takeMessage
     */
    public function testTakeMessage(): void
    {
        $this->assertEmpty($this->object->takeMessage());
    }

    /**
     * @covers \Ease\Logger\Regent::getMessages
     */
    public function testgetMessages(): void
    {
        $this->assertIsArray($this->object->getMessages());
    }

    /**
     * @covers \Ease\Logger\Regent::cleanMessages
     */
    public function testcleanMessages(): void
    {
        $this->object->cleanMessages();
        $this->assertEmpty($this->object->getMessages());
    }

    /**
     * @covers \Ease\Logger\Loggingable::addToLog
     * @covers \Ease\Logger\Regent::addToLog
     */
    public function testAddToLog(): void
    {
        $this->object->cleanMessages();
        $this->object->addToLog(\get_class($this), 'Unit Test');
        $this->object->addToLog(\get_class($this), 'Code Coverage', 'debug');
        $this->assertCount(2, $this->object->getMessages());
    }

    /**
     * @covers \Ease\Logger\Regent::addStatusObject
     */
    public function testAddStatusObject(): void
    {
        $this->object->cleanMessages();
        $message = 'Regent::addStatusObject Unit Test';
        $this->object->addStatusObject(new \Ease\Logger\Message($message), 'info');
        $this->assertCount(1, $this->object->getMessages());
    }

    /**
     * @covers \Ease\Logger\Regent::singleton
     */
    public function testSingleton(): void
    {
        $this->assertInstanceOf('Ease\Logger\Regent', Regent::singleton());
    }
}
