<?php

declare(strict_types=1);

/**
 * This file is part of the EaseCore package.
 *
 * (c) Vítězslav Dvořák <info@vitexsoftware.cz>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Test\Ease\Logger;

use Ease\Logger\Message;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2016-12-29 at 21:58:32.
 */
class MessageTest extends \PHPUnit\Framework\TestCase
{
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp(): void
    {
        $this->object = new Message('test');
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown(): void
    {
    }

    /**
     * Test Constructor.
     *
     * @covers \Ease\Logger\Message::__construct
     */
    public function testConstructor(): void
    {
        $classname = \get_class($this->object);

        // Get mock, without the constructor being called
        $mock = $this->getMockBuilder($classname)
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();
        $mock->__construct('test');
        $mock->__construct('test', 'test', new \Ease\Atom(), time());
        $this->assertEquals('test', $mock->body);
    }

    /**
     * Test getTypeUnicodeSymbol.
     *
     * @covers \Ease\Logger\Message::getTypeUnicodeSymbol
     */
    public function testGetTypeUnicodeSymbol(): void
    {
        $this->assertEquals('✉', Message::getTypeUnicodeSymbol('mail', false));
        $this->assertEquals('⚠', Message::getTypeUnicodeSymbol('warning', false));
        $this->assertEquals('☠', Message::getTypeUnicodeSymbol('error', false));
        $this->assertEquals('❁', Message::getTypeUnicodeSymbol('success', false));
        $this->assertEquals('⚙', Message::getTypeUnicodeSymbol('debug', false));
        $this->assertEquals('ⓘ', Message::getTypeUnicodeSymbol('info', false));
        $this->assertEquals('🯄', Message::getTypeUnicodeSymbol('anythingelse', false));

        $this->assertEquals('✉', Message::getTypeUnicodeSymbol('mail'));
        $this->assertEquals('⚠', Message::getTypeUnicodeSymbol('warning'));
        $this->assertEquals('💀', Message::getTypeUnicodeSymbol('error'));
        $this->assertEquals('🌼', Message::getTypeUnicodeSymbol('success'));
        $this->assertEquals('⚙', Message::getTypeUnicodeSymbol('debug'));
        $this->assertEquals('ℹ', Message::getTypeUnicodeSymbol('info'));
        $this->assertEquals('🤔', Message::getTypeUnicodeSymbol('anythingelse'));
    }
}
