<?php

declare(strict_types=1);

/**
 * This file is part of the EaseCore package.
 *
 * (c) Vítězslav Dvořák <info@vitexsoftware.cz>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Test\Ease;

use Ease\Locale;
use PHPUnit\Framework\Attributes\CoversClass;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2018-06-27 at 13:23:52.
 */
#[CoversClass(Locale::class)]
class LocaleTest extends \PHPUnit\Framework\TestCase
{
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp(): void
    {
        if (file_exists('i18n')) {
            $locales = 'i18n';
        } else {
            if (file_exists('../i18n')) {
                $locales = '../i18n';
            } else {
                $locales = '/usr/share/locale';
            }
        }

        $this->object = new Locale('cs_CZ', $locales, 'php-vitexsoftware-ease-core');
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown(): void
    {
    }

    /**
     * Test Constructor.
     *
     * @covers \Ease\Locale::__construct
     */
    public function testConstructor(): void
    {
        $classname = \get_class($this->object);
        // Get mock, without the constructor being called
        $mock = $this->getMockBuilder($classname)
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();
        $mock->__construct();
        $mock->__construct('cs_CZ', './i18n', 'php-vitexsoftware-ease-core');
        $this->assertEquals('cs_CZ', $mock->getLocaleUsed());
        \Ease\Locale::$textDomain = '';
        $mock->__construct('cs_CZ', './i18n');
    }

    /**
     * @covers \Ease\Locale::getPreferedLocale
     */
    public function testGetPreferedLocale(): void
    {
        global $_REQUEST, $_SESSION;
        $_SESSION['locale'] = 'C';
        $_REQUEST['locale'] = 'C';
        putenv('LOCALE=C');
        $this->assertEquals('C', Locale::getPreferedLocale(false));
        $_SESSION['locale'] = 'en_US';
        unset($_REQUEST['locale']);
        $this->assertEquals('en_US', Locale::getPreferedLocale(false));
        $this->assertEquals('cs_CZ', Locale::getPreferedLocale(true));
        $_REQUEST['locale'] = 'test';
        $this->assertEquals('test', Locale::getPreferedLocale(false));
    }

    /**
     * @covers \Ease\Locale::requestLocale
     */
    public function testRequestLocale(): void
    {
        unset($_REQUEST['locale']);
        $this->assertNull(Locale::requestLocale());
        $_REQUEST['locale'] = 'en_US';
        $this->assertEquals('en_US', Locale::requestLocale());
    }

    /**
     * @covers \Ease\Locale::sessionLocale
     */
    public function testSessionLocale(): void
    {
        $_SESSION['locale'] = 'cs_CZ';
        $this->assertEquals('cs_CZ', Locale::sessionLocale());
    }

    /**
     * @covers \Ease\Locale::browserLocale
     */
    public function testBrowserLocale(): void
    {
        $this->assertEquals('C', Locale::browserLocale());
    }

    /**
     * @covers \Ease\Locale::availble
     */
    public function testAvalilble(): void
    {
        $this->assertEquals([
            'en_US' => 'English (United States)',
            'cs_CZ' => 'Czech (Czech Republic)',
            'eo' => 'Esperanto',
        ], $this->object->availble(), 'Cannot find locales ?!? in '.Locale::$i18n);
    }

    /**
     * @covers \Ease\Locale::setTextDomain
     */
    public function testSetTextDomain(): void
    {
        Locale::setTextDomain('some');
        $this->assertEquals('some', Locale::$textDomain);
    }

    /**
     * @covers \Ease\Locale::initializeGetText
     */
    public function testInitializeGetText(): void
    {
        Locale::initializeGetText('EaseTest', 'en_US', './i18n');
        $this->assertEquals(Locale::$i18n, './i18n');
    }

    /**
     * @covers \Ease\Locale::langToLocale
     */
    public function testLangToLocal(): void
    {
        $this->assertEquals('cs_CZ', Locale::langToLocale('cs'));
    }

    /**
     * @covers \Ease\Locale::useLocale
     */
    public function testUseLocale(): void
    {
        Locale::useLocale('en_US');
        $this->assertEquals('en_US', Locale::getLocaleUsed());
    }

    /**
     * @covers \Ease\Locale::autodetected
     */
    public function testAutodetected(): void
    {
        $this->assertNull(Locale::autodetected());
    }

    /**
     * @covers \Ease\Locale::get2code
     */
    public function testGet2code(): void
    {
        $this->assertEquals('cs', $this->object->get2Code());
        Locale::useLocale('');
        $this->assertEquals('C', $this->object->get2Code());
    }

    /**
     * @covers \Ease\Locale::getLocaleUsed
     */
    public function testGetLocaleUsed(): void
    {
        $this->assertEquals('cs_CZ', $this->object->getLocaleUsed());
    }

    /**
     * @covers \Ease\Locale::singleton
     */
    public function testSingleton(): void
    {
        $this->assertInstanceOf('\Ease\Locale', \Ease\Locale::singleton());
    }
}
