<?php

declare(strict_types=1);

/**
 * This file is part of the EaseCore package.
 *
 * (c) Vítězslav Dvořák <info@vitexsoftware.cz>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Test\Ease;

use Ease\Brick;
use PHPUnit\Framework\Attributes\CoversClass;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2016-01-17 at 23:23:11.
 */
#[CoversClass(Brick::class)]
class BrickTest extends SandTest
{
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp(): void
    {
        $this->object = new Local\BrickTester();
        $this->object = new Brick();
        $this->object->setupProperty(['nameColumn' => 'name'], 'nameColumn');
        $this->object->setKeyColumn('id');
        $this->object->nameColumn = 'name';
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown(): void
    {
    }

    /**
     * Test Constructor.
     *
     * @covers \Ease\Brick::__construct
     */
    public function testConstructor(): void
    {
        $classname = \get_class($this->object);

        // Get mock, without the constructor being called
        $mock = $this->getMockBuilder($classname)
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();
        $mock->__construct(null, ['debug' => true]);
        $mock->__construct(1, ['autoload' => true, 'myTable' => 'test']);
        $this->assertNull($mock->getMyKey());
    }

    /**
     * @covers \Ease\Brick::setObjectName
     */
    public function testSetObjectName(): void
    {
        //        parent::testSetObjectName();
        $this->object->setMyKey(123);
        $this->object->setObjectName();
        $this->assertEquals(
            '123@'.\get_class($this->object),
            $this->object->getObjectName(),
        );
        $this->object->setObjectName('customBrick');
        $this->assertEquals('customBrick', $this->object->getObjectName());
    }

    /**
     * @covers \Ease\Brick::useIdentifier
     */
    public function testuseIdentifier(): void
    {
        $this->object->useIdentifier(null);
        $this->object->useIdentifier($this->object);
        $this->assertEquals(
            $this->object->getMyKey(),
            $this->object->useIdentifier(123),
        );
        $this->object->useIdentifier(['key' => 'value']);
        $this->assertEquals(
            ['key' => 'value', 'id' => 123],
            $this->object->getData(),
        );
        $this->object->dataReset();
        $this->object->useIdentifier('name');
        $this->object->setDataValue('name', 'name');
        $this->assertEquals(['name' => 'name'], $this->object->getData());
    }

    /**
     * @covers \Ease\Brick::howToProcess
     */
    public function testhowToProcess(): void
    {
        $this->assertEquals('id', $this->object->howToProcess(123));
        $this->assertEquals(
            'values',
            $this->object->howToProcess(['key' => 'value']),
        );
        $this->assertEquals('reuse', $this->object->howToProcess($this->object));
        $this->assertEquals('unknown', $this->object->howToProcess(false));
        $this->object->nameColumn = 'name';
        $this->assertEquals('name', $this->object->howToProcess('name'));
        $this->assertEquals('unknown', $this->object->howToProcess(null));
    }
}
