<?php

/**
 * Základní objekty systému.
 *
 * @author     Vitex <vitex@hippy.cz>
 * @copyright  2009-2021 Vitex@hippy.cz (G)
 */
// @codingStandardsIgnoreFile
// @codeCoverageIgnoreStart

declare(strict_types=1);

/**
 * This file is part of the EaseCore package.
 *
 * (c) Vítězslav Dvořák <info@vitexsoftware.cz>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Test\Ease;

use Ease\Atom;
use PHPUnit\Framework\Attributes\CoversClass;

/**
 * Test class for EaseAtom.
 * Generated by PHPUnit on 2012-03-17 at 23:53:07.
 *
 * @author     Vitex <vitex@hippy.cz>
 * @copyright  2009-2024 Vitex@hippy.cz (G)
 */
#[CoversClass(Atom::class)]

class AtomTest extends \PHPUnit\Framework\TestCase
{
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp(): void
    {
        $this->object = new Atom();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown(): void
    {
    }

    /**
     * @covers \Ease\Atom::getObjectName
     */
    public function testgetObjectName(): void
    {
        $this->assertNotEmpty($this->object->getObjectName(), 'Object does not provide its name');
    }

    /**
     * @covers \Ease\Atom::__toString
     */
    public function testToString(): void
    {
        $this->assertIsString($this->object->__toString(), 'Object does not provide its textual representation');
    }

    /**
     * @covers \Ease\Atom::draw
     *
     * @param null|mixed $whatWant
     */
    public function testDraw($whatWant = null): void
    {
        $this->assertEquals('', $this->object->draw());
    }
}

// @codeCoverageIgnoreEnd
