/*
 * This file is part of Visual Code Space.
 *
 * Visual Code Space is free software: you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * Visual Code Space is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with Visual Code Space.
 * If not, see <https://www.gnu.org/licenses/>.
 */

package com.itsvks.monaco

@JvmInline
value class MonacoLanguage(val value: String) {
  companion object {
    val Plaintext = MonacoLanguage("plaintext")

    val Abap = MonacoLanguage("abap")
    val Apex = MonacoLanguage("apex")
    val Azcli = MonacoLanguage("azcli")
    val Bat = MonacoLanguage("bat")
    val Bicep = MonacoLanguage("bicep")
    val Cameligo = MonacoLanguage("cameligo")
    val Clojure = MonacoLanguage("clojure")
    val Coffee = MonacoLanguage("coffee")
    val Cpp = MonacoLanguage("cpp")
    val Csharp = MonacoLanguage("csharp")
    val Csp = MonacoLanguage("csp")
    val CSS = MonacoLanguage("css")
    val Cypher = MonacoLanguage("cypher")
    val Dart = MonacoLanguage("dart")
    val Dockerfile = MonacoLanguage("dockerfile")
    val Ecl = MonacoLanguage("ecl")
    val Elixir = MonacoLanguage("elixir")
    val Flow9 = MonacoLanguage("flow9")
    val Freemarker2 = MonacoLanguage("freemarker2")
    val Fsharp = MonacoLanguage("fsharp")
    val Go = MonacoLanguage("go")
    val GraphQl = MonacoLanguage("graphql")
    val Handlebars = MonacoLanguage("handlebars")
    val Hcl = MonacoLanguage("hcl")
    val HTML = MonacoLanguage("html")
    val Ini = MonacoLanguage("ini")
    val Java = MonacoLanguage("java")
    val Javascript = MonacoLanguage("javascript")
    val JSON = MonacoLanguage("json")
    val Julia = MonacoLanguage("julia")
    val Kotlin = MonacoLanguage("kotlin")
    val Less = MonacoLanguage("less")
    val Lexon = MonacoLanguage("lexon")
    val Liquid = MonacoLanguage("liquid")
    val Lua = MonacoLanguage("lua")
    val M3 = MonacoLanguage("m3")
    val Markdown = MonacoLanguage("markdown")
    val Mdx = MonacoLanguage("mdx")
    val Mips = MonacoLanguage("mips")
    val MsDax = MonacoLanguage("msdax")
    val MySql = MonacoLanguage("mysql")
    val ObjectiveC = MonacoLanguage("objective-c")
    val Pascal = MonacoLanguage("pascal")
    val Pascaligo = MonacoLanguage("pascaligo")
    val Perl = MonacoLanguage("perl")
    val PgSql = MonacoLanguage("pgsql")
    val Php = MonacoLanguage("php")
    val Pla = MonacoLanguage("pla")
    val Postiats = MonacoLanguage("postiats")
    val PowerQuery = MonacoLanguage("powerquery")
    val Powershell = MonacoLanguage("powershell")
    val ProtoBuf = MonacoLanguage("protobuf")
    val Pug = MonacoLanguage("pug")
    val Python = MonacoLanguage("python")
    val Qsharp = MonacoLanguage("qsharp")
    val R = MonacoLanguage("r")
    val Razor = MonacoLanguage("razor")
    val Redis = MonacoLanguage("redis")
    val RedShift = MonacoLanguage("redshift")
    val RestructuredText = MonacoLanguage("restructuredtext")
    val Ruby = MonacoLanguage("ruby")
    val Rust = MonacoLanguage("rust")
    val Sb = MonacoLanguage("sb")
    val Scala = MonacoLanguage("scala")
    val Scheme = MonacoLanguage("scheme")
    val SCSS = MonacoLanguage("scss")
    val Shell = MonacoLanguage("shell")
    val Solidity = MonacoLanguage("solidity")
    val Sophia = MonacoLanguage("sophia")
    val SparkQl = MonacoLanguage("sparkql")
    val SQL = MonacoLanguage("sql")
    val ST = MonacoLanguage("st")
    val Swift = MonacoLanguage("swift")
    val SystemVerilog = MonacoLanguage("systemverilog")
    val Tcl = MonacoLanguage("tcl")
    val Twig = MonacoLanguage("twig")
    val TypeScript = MonacoLanguage("typescript")
    val TypeSpec = MonacoLanguage("typespec")
    val VB = MonacoLanguage("vb")
    val WGSL = MonacoLanguage("wgsl")
    val XML = MonacoLanguage("xml")
    val YAML = MonacoLanguage("yaml")
  }
}
