/*
 * This file is part of Visual Code Space.
 *
 * Visual Code Space is free software: you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * Visual Code Space is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with Visual Code Space.
 * If not, see <https://www.gnu.org/licenses/>.
 */

@file:Suppress("EnumEntryName")

package com.itsvks.monaco

enum class EditorOption(val value: Int) {
  acceptSuggestionOnCommitCharacter(0),
  acceptSuggestionOnEnter(1),
  accessibilitySupport(2),
  accessibilityPageSize(3),
  ariaLabel(4),
  ariaRequired(5),
  screenReaderAnnounceInlineSuggestion(8),
  autoClosingBrackets(6),
  autoClosingComments(7),
  autoClosingDelete(9),
  autoClosingOvertype(10),
  autoClosingQuotes(11),
  autoIndent(12),
  automaticLayout(13),
  autoSurround(14),
  bracketPairColorization(15),
  bracketPairGuides(16),
  codeLens(17),
  codeLensFontFamily(18),
  codeLensFontSize(19),
  colorDecorators(20),
  colorDecoratorsLimit(21),
  columnSelection(22),
  comments(23),
  contextmenu(24),
  copyWithSyntaxHighlighting(25),
  cursorBlinking(26),
  cursorSmoothCaretAnimation(27),
  cursorStyle(28),
  cursorSurroundingLines(29),
  cursorSurroundingLinesStyle(30),
  cursorWidth(31),
  disableLayerHinting(32),
  disableMonospaceOptimizations(33),
  domReadOnly(34),
  dragAndDrop(35),
  dropIntoEditor(36),
  emptySelectionClipboard(37),
  experimentalWhitespaceRendering(38),
  extraEditorClassName(39),
  fastScrollSensitivity(40),
  find(41),
  fixedOverflowWidgets(42),
  folding(43),
  foldingStrategy(44),
  foldingHighlight(45),
  foldingImportsByDefault(46),
  foldingMaximumRegions(47),
  unfoldOnClickAfterEndOfLine(48),
  fontFamily(49),
  fontInfo(50),
  fontLigatures(51),
  fontSize(52),
  fontWeight(53),
  fontVariations(54),
  formatOnPaste(55),
  formatOnType(56),
  glyphMargin(57),
  gotoLocation(58),
  hideCursorInOverviewRuler(59),
  hover(60),
  inDiffEditor(61),
  inlineSuggest(62),
  inlineEdit(63),
  letterSpacing(64),
  lightbulb(65),
  lineDecorationsWidth(66),
  lineHeight(67),
  lineNumbers(68),
  lineNumbersMinChars(69),
  linkedEditing(70),
  links(71),
  matchBrackets(72),
  minimap(73),
  mouseStyle(74),
  mouseWheelScrollSensitivity(75),
  mouseWheelZoom(76),
  multiCursorMergeOverlapping(77),
  multiCursorModifier(78),
  multiCursorPaste(79),
  multiCursorLimit(80),
  occurrencesHighlight(81),
  overviewRulerBorder(82),
  overviewRulerLanes(83),
  padding(84),
  pasteAs(85),
  parameterHints(86),
  peekWidgetDefaultFocus(87),
  placeholder(88),
  definitionLinkOpensInPeek(89),
  quickSuggestions(90),
  quickSuggestionsDelay(91),
  readOnly(92),
  readOnlyMessage(93),
  renameOnType(94),
  renderControlCharacters(95),
  renderFinalNewline(96),
  renderLineHighlight(97),
  renderLineHighlightOnlyWhenFocus(98),
  renderValidationDecorations(99),
  renderWhitespace(100),
  revealHorizontalRightPadding(101),
  roundedSelection(102),
  rulers(103),
  scrollbar(104),
  scrollBeyondLastColumn(105),
  scrollBeyondLastLine(106),
  scrollPredominantAxis(107),
  selectionClipboard(108),
  selectionHighlight(109),
  selectOnLineNumbers(110),
  showFoldingControls(111),
  showUnused(112),
  snippetSuggestions(113),
  smartSelect(114),
  smoothScrolling(115),
  stickyScroll(116),
  stickyTabStops(117),
  stopRenderingLineAfter(118),
  suggest(119),
  suggestFontSize(120),
  suggestLineHeight(121),
  suggestOnTriggerCharacters(122),
  suggestSelection(123),
  tabCompletion(124),
  tabIndex(125),
  unicodeHighlighting(126),
  unusualLineTerminators(127),
  useShadowDOM(128),
  useTabStops(129),
  wordBreak(130),
  wordSegmenterLocales(131),
  wordSeparators(132),
  wordWrap(133),
  wordWrapBreakAfterCharacters(134),
  wordWrapBreakBeforeCharacters(135),
  wordWrapColumn(136),
  wordWrapOverride1(137),
  wordWrapOverride2(138),
  wrappingIndent(139),
  wrappingStrategy(140),
  showDeprecated(141),
  inlayHints(142),
  editorClassName(143),
  pixelRatio(144),
  tabFocusMode(145),
  layoutInfo(146),
  wrappingInfo(147),
  defaultColorDecorators(148),
  colorDecoratorsActivatedOn(149),
  inlineCompletionsAccessibilityVerbose(150)
}

data class IEditorOption<T>(val option: EditorOption, val defaultValue: T)
