/*
 * This file is part of Visual Code Space.
 *
 * Visual Code Space is free software: you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * Visual Code Space is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with Visual Code Space.
 * If not, see <https://www.gnu.org/licenses/>.
 */

package com.teixeira.vcspace.ui.icons

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp

val Glyphs: ImageVector
  get() {
    if (_Glyphs != null) {
      return _Glyphs!!
    }
    _Glyphs = ImageVector.Builder(
      name = "Glyphs",
      defaultWidth = 24.dp,
      defaultHeight = 24.dp,
      viewportWidth = 960f,
      viewportHeight = 960f
    ).apply {
      path(fill = SolidColor(Color(0xFF000000))) {
        moveTo(224f, 82f)
        lineTo(302f, 82f)
        lineTo(437f, 442f)
        lineTo(362f, 442f)
        lineTo(332f, 356f)
        lineTo(194f, 356f)
        lineTo(164f, 442f)
        lineTo(89f, 442f)
        lineTo(224f, 82f)
        close()
        moveTo(229f, 484f)
        quadTo(271f, 484f, 300f, 513f)
        quadTo(329f, 542f, 329f, 584f)
        quadTo(329f, 604f, 321.5f, 622.5f)
        quadTo(314f, 641f, 300f, 655f)
        lineTo(285f, 669f)
        lineTo(313f, 697f)
        lineTo(370f, 641f)
        lineTo(427f, 698f)
        lineTo(371f, 754f)
        lineTo(427f, 811f)
        lineTo(370f, 867f)
        lineTo(314f, 811f)
        lineTo(272f, 853f)
        quadTo(257f, 868f, 238f, 875.5f)
        quadTo(219f, 883f, 198f, 883f)
        quadTo(156f, 883f, 128f, 853.5f)
        quadTo(100f, 824f, 100f, 782f)
        quadTo(100f, 762f, 108f, 743.5f)
        quadTo(116f, 725f, 130f, 711f)
        lineTo(172f, 669f)
        lineTo(158f, 655f)
        quadTo(144f, 641f, 136f, 623f)
        quadTo(128f, 605f, 128f, 585f)
        quadTo(128f, 543f, 157.5f, 513.5f)
        quadTo(187f, 484f, 229f, 484f)
        close()
        moveTo(229f, 726f)
        lineTo(186f, 768f)
        quadTo(183f, 771f, 182f, 774.5f)
        quadTo(181f, 778f, 181f, 782f)
        quadTo(181f, 790f, 186.5f, 796f)
        quadTo(192f, 802f, 200f, 802f)
        quadTo(204f, 802f, 207.5f, 800.5f)
        quadTo(211f, 799f, 214f, 796f)
        lineTo(257f, 754f)
        lineTo(229f, 726f)
        close()
        moveTo(228f, 564f)
        quadTo(220f, 564f, 214.5f, 570f)
        quadTo(209f, 576f, 209f, 584f)
        quadTo(209f, 588f, 210f, 591.5f)
        quadTo(211f, 595f, 214f, 598f)
        lineTo(229f, 612f)
        lineTo(242f, 599f)
        quadTo(245f, 596f, 246.5f, 592.5f)
        quadTo(248f, 589f, 248f, 585f)
        quadTo(248f, 577f, 242f, 570.5f)
        quadTo(236f, 564f, 228f, 564f)
        close()
        moveTo(261f, 160f)
        lineTo(215f, 294f)
        lineTo(311f, 294f)
        lineTo(265f, 160f)
        lineTo(261f, 160f)
        close()
        moveTo(699f, 55f)
        quadTo(707f, 68f, 712.5f, 82f)
        quadTo(718f, 96f, 722f, 110f)
        lineTo(679f, 123f)
        lineTo(880f, 123f)
        lineTo(880f, 203f)
        lineTo(813f, 203f)
        quadTo(802f, 236f, 784.5f, 265.5f)
        quadTo(767f, 295f, 744f, 320f)
        quadTo(771f, 336f, 800f, 346.5f)
        quadTo(829f, 357f, 860f, 365f)
        lineTo(841f, 442f)
        quadTo(798f, 431f, 757.5f, 415f)
        quadTo(717f, 399f, 680f, 374f)
        quadTo(643f, 398f, 602.5f, 414.5f)
        quadTo(562f, 431f, 519f, 442f)
        lineTo(501f, 365f)
        quadTo(531f, 357f, 560f, 346.5f)
        quadTo(589f, 336f, 616f, 320f)
        quadTo(593f, 295f, 575.5f, 265.5f)
        quadTo(558f, 236f, 548f, 203f)
        lineTo(480f, 203f)
        lineTo(480f, 123f)
        lineTo(656f, 123f)
        quadTo(653f, 110f, 648f, 97.5f)
        quadTo(643f, 85f, 638f, 73f)
        lineTo(699f, 55f)
        close()
        moveTo(803f, 499f)
        lineTo(860f, 555f)
        lineTo(549f, 866f)
        lineTo(492f, 810f)
        lineTo(803f, 499f)
        close()
        moveTo(580f, 522f)
        quadTo(605f, 522f, 622.5f, 539.5f)
        quadTo(640f, 557f, 640f, 582f)
        quadTo(640f, 607f, 622.5f, 624.5f)
        quadTo(605f, 642f, 580f, 642f)
        quadTo(555f, 642f, 537.5f, 624.5f)
        quadTo(520f, 607f, 520f, 582f)
        quadTo(520f, 557f, 537.5f, 539.5f)
        quadTo(555f, 522f, 580f, 522f)
        close()
        moveTo(633f, 203f)
        quadTo(641f, 222f, 653f, 239f)
        quadTo(665f, 256f, 680f, 271f)
        quadTo(695f, 256f, 707f, 239f)
        quadTo(719f, 222f, 728f, 203f)
        lineTo(633f, 203f)
        close()
        moveTo(780f, 722f)
        quadTo(805f, 722f, 822.5f, 739.5f)
        quadTo(840f, 757f, 840f, 782f)
        quadTo(840f, 807f, 822.5f, 824.5f)
        quadTo(805f, 842f, 780f, 842f)
        quadTo(755f, 842f, 737.5f, 824.5f)
        quadTo(720f, 807f, 720f, 782f)
        quadTo(720f, 757f, 737.5f, 739.5f)
        quadTo(755f, 722f, 780f, 722f)
        close()
      }
    }.build()

    return _Glyphs!!
  }

@Suppress("ObjectPropertyName")
private var _Glyphs: ImageVector? = null
