/*
 * This file is part of Visual Code Space.
 *
 * Visual Code Space is free software: you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * Visual Code Space is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with Visual Code Space.
 * If not, see <https://www.gnu.org/licenses/>.
 */

package com.teixeira.vcspace.github

import retrofit2.Call
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.PUT
import retrofit2.http.Path
import retrofit2.http.Query

interface GitHubApiService {
  @PUT("repos/{owner}/{repo}/contents/{path}")
  fun createFile(
    @Path("owner") owner: String,
    @Path("repo") repo: String,
    @Path("path") path: String,
    @Body request: FileCreateRequest
  ): Call<FileCreateResponse>

  @PUT("repos/{owner}/{repo}/contents/{path}")
  fun updateFile(
    @Path("owner") owner: String,
    @Path("repo") repo: String,
    @Path("path") path: String,
    @Body request: FileUpdateRequest
  ): Call<FileUpdateResponse>

  @GET("repos/{owner}/{repo}/contents/{path}")
  fun getContents(
    @Path("owner") owner: String,
    @Path("repo") repo: String,
    @Path("path") path: String = "", // Default is the root of the repo
    @Query("ref") branch: String = "main"
  ): Call<List<Content>>

  @GET("repos/{owner}/{repo}/contents/{path}")
  fun getFileContent(
    @Path("owner") owner: String,
    @Path("repo") repo: String,
    @Path("path") path: String
  ): Call<FileContent>

  @GET("repos/{owner}/{repo}/contributors")
  fun getContributors(
    @Path("owner") owner: String,
    @Path("repo") repo: String
  ): Call<List<Contributor>>

  @GET("users/{username}")
  fun getUser(
    @Path("username") username: String
  ): Call<User>
}
