/*
 * This file is part of Visual Code Space.
 *
 * Visual Code Space is free software: you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * Visual Code Space is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with Visual Code Space.
 * If not, see <https://www.gnu.org/licenses/>.
 */

package com.teixeira.vcspace.editor.language.java

enum class Tokens {
  WHITESPACE,
  NEWLINE,
  UNKNOWN,
  EOF,

  LONG_COMMENT_COMPLETE,
  LONG_COMMENT_INCOMPLETE,
  LINE_COMMENT,

  DIV,
  MULT,
  IDENTIFIER,
  INTEGER_LITERAL,
  DOT,
  MINUS,
  STRING,
  CHARACTER_LITERAL,
  LPAREN,
  RPAREN,
  LBRACE,
  RBRACE,
  LBRACK,
  RBRACK,
  SEMICOLON,
  COMMA,
  EQ,
  GT,
  LT,
  NOT,
  COMP,
  QUESTION,
  COLON,
  AND,
  OR,
  PLUS,
  XOR,
  MOD,
  FLOATING_POINT_LITERAL,

  VAR,
  SEALED,
  PERMITS,
  ABSTRACT,
  ASSERT,
  BOOLEAN,
  BYTE,
  CHAR,
  CLASS,
  DO,
  DOUBLE,
  FINAL,
  FLOAT,
  FOR,
  IF,
  INT,
  LONG,
  NEW,
  PUBLIC,
  PRIVATE,
  PROTECTED,
  PACKAGE,
  RETURN,
  STATIC,
  SHORT,
  SUPER,
  SWITCH,
  ELSE,
  VOLATILE,
  SYNCHRONIZED,
  STRICTFP,
  GOTO,
  CONTINUE,
  BREAK,
  TRANSIENT,
  VOID,
  TRY,
  CATCH,
  FINALLY,
  WHILE,
  CASE,
  DEFAULT,
  CONST,
  ENUM,
  EXTENDS,
  IMPLEMENTS,
  IMPORT,
  INSTANCEOF,
  INTERFACE,
  NATIVE,
  THIS,
  THROW,
  THROWS,
  AT,

  TRUE,
  FALSE,
  NULL,
}