# Integration Tests

This directory contains the integration tests for the SDK.

## Running the Tests

To run the tests, use the following command:

```bash
just test-integration
```

And if you need to clean up, use the following command:

```bash
just clean-test-integration
```

## Core Tests

[`CoreTests.test.scala`](CoreTests.test.scala) runs the complete set of SDK core tests against the [`core`](../core).

## Codegen Tests

[`CodegenTests.test.scala`](CodegenTests.test.scala)` runs the complete set of SDK code generation tests against
a Scala code generator. It also verifies that the generated code is structurally sound.

The test files live in [resources/testdata](resources/testdata) and are sourced using
the [`scripts/Schemas.scala`](../scripts/Schemas.scala) script.

If you need to update the test data from upstream(s), you can run the following command:

```bash
just copy-test-schemas
```

There are two types of tests:

- schema-based tests, which are generated from the schema files (`schema.json`, `schema.yaml`)
- PCL-based tests, which are generated from the PCL files (`*.pp`)

The schema or PCL is the only piece that must be manually authored typically.
In addition, there might be some tests, that test the generated code, that are manually authored.

Once the schema has been written, the actual codegen outputs are generated by running the tests.

## Compiler Plugin Tests

There are also compiler plugin tests.

```bash
just test-compiler-plugin
```