# Deploy two App Services - Front web app with VNet injection and Back web app with a Private Endpoint

This deploys a secure front end - back end web app. The front end web app is plugged in a subnet with the feature
regional VNet integration enabled. Settings are set to consume a DNS private zone. The backend web app is only exposed
through a private endpoint.

It will create a VNet, two subnets, one where your Private Endpoint will exist, the second where you will inject the
front web app, an App Service Plan in PremiumV2 tier (mandatory for Private Endpoint), a Private Endpoint, settings for
DNS queries to the DNS Private Zone, and a private DNS zone with record for the Private Endpoint.

## Deploying the App

To deploy your infrastructure, follow the below steps.

### Optional config params

1. `virtualNetworkCIDR` - CIDR range for the vnet (defaults to `10.200.0.0/16`)
2. `backendCIDR` - subnet CIDR range for the backend (defaults to `10.200.1.0/24`)
3. `frontendCIDR` - subnet CIDR range for the frontend (defaults to `10.200.2.0/24`)

### Prerequisites

1. [Install Pulumi](https://www.pulumi.com/docs/get-started/install/)
2. [Configure Azure Credentials](https://www.pulumi.com/docs/intro/cloud-providers/azure/setup/)

## Running the App

1. Create a new stack:

   ```bash
   $ pulumi stack init dev
   ```

2. Set the Azure region location to use:

   ```bash
   $ pulumi config set azure-native:location westus2
   ```

3. Run `pulumi up` to preview and deploy changes:

   ```bash
   $ pulumi up
   ```

4. From there, feel free to experiment. Simply making edits and running `pulumi up` will incrementally update your
   stack.

5. Once you've finished experimenting, tear down your stack's resources by destroying and removing it:

    ```bash
    $ pulumi destroy --yes
    $ pulumi stack rm --yes
    ```
