# Azure Kubernetes Service (AKS) Cluster using the native Azure Provider

This example deploys an AKS cluster, creates an Azure User Assigned Managed Identity, and sets credentials to manage
access to the cluster.

## Deploying the App

To deploy your infrastructure, follow the below steps.

### Prerequisites

1. [Install Pulumi](https://www.pulumi.com/docs/get-started/install/)
2. [Configure Azure Credentials](https://www.pulumi.com/docs/intro/cloud-providers/azure/setup/)

### Steps

After [cloning](https://github.com/pulumi/examples#checking-out-a-single-example) this repo, from this working
directory, run these commands:

1. Create a new stack, which is an isolated deployment target for this example:

    ```bash
    $ pulumi stack init dev
    ```

2. Set the Azure region location to use:

    ```
    $ pulumi config set azure-native:location westus2
    ```

3. Stand up the cluster by invoking pulumi
    ```bash
    $ pulumi up
    ```

4. After 3-4 minutes, your cluster will be ready, and the kubeconfig YAML you'll use to connect to the cluster will be
   available as an [Output](https://www.pulumi.com/docs/concepts/inputs-outputs/#outputs). You can save this kubeconfig
   to a file like so:

    ```bash
    $ pulumi stack output kubeconfig --show-secrets > kubeconfig.yaml
    ```

   Once you have this file in hand, you can interact with your new cluster as usual via `kubectl`:

    ```bash
    $ KUBECONFIG=./kubeconfig.yaml kubectl get nodes
    ```

5. From there, feel free to experiment. Simply making edits and running `pulumi up` will incrementally update your
   stack.

6. Once you've finished experimenting, tear down your stack's resources by destroying and removing it:

    ```bash
    $ pulumi destroy --yes
    $ pulumi stack rm --yes
    ```