# Contribution Guidelines

Welcome to the Tree2Hope official website! We're thrilled that you're interested in contributing to our open-source community. We value and appreciate contributions from the community, whether you're a seasoned developer or just starting your journey. Before you start, please take a moment to read these guidelines to ensure a smooth and collaborative experience for everyone.

## Getting Started
To start contributing, please follow these steps:

### 1. Fork This Repository
- Once you're on the repository's page, you should see a "Fork" button. Click on it. Now, you have your own copy of the Tree2Hope repository in your account, and you can make changes to it without affecting the original repository.

### 2. Clone Your Forked Repository
- Clone your forked repository to your local machine through the following command: 

```sh
git clone https://github.com/your-username/Tree2Hope.git
```

- Replace 'your-username' with your GitHub username.

- Alternatively, click on the '<> Code' dropdown button in your forked repo and copy the url. Then use the command 'git clone "copied url" '.
- Paste the url you copied after typing 'git clone'.

### 3. Create a New Branch
- Make sure to create a new branch solely dedicated to the changes that you will make. Use the following command to do so:

```sh
git checkout -b branch-name
```

- Replace 'branch-name' with any short and suitable name that fits the issue.

### 4. Make Changes
- Make the desired changes to the files in your local branch using your preferred text editor or integrated development environment (IDE).

### 5. Test Changes
- To test your changes, you should run any relevant tests and manually validate that your code works as expected. This may involve executing your code, interacting with the application, and ensuring that it doesn't introduce errors or regressions.

### 6. Commit Changes
- Once you are satisfied with your changes and they pass your tests, commit your changes locally. Use the following Git commands:

```sh
git add .
```

```sh
git commit -m "Your commit message"
```

- Replace "Your commit message" with a brief and meaningful message that describes the changes you wish to commit. 
- Ensure that the message is in imperative present tense. 

### 7. Push Your Changes
To save your progress in your forked repository on GitHub, push your branch to your fork with this command:

```sh
git push origin your-branch-name
```

### 8. Create a PR
- At last, go to the [Pull Requests](https://github.com/Virtual4087/Tree2Hope/pulls) tab of the original repository. 
- Click on the "New Pull Request" button to open a new pull request.
- In the description, provide details about the changes you made. Be sure to provide a clear description of your changes and the problems they solve.
 Your PR will be reviewed, given feedback if needed, and if approved, will be merged into the main branch of the repository. 

## Thank You

We appreciate your contributions to our project. Your work is essential in helping us improve and grow. Thank you for your time and effort!

