"""empty message

Revision ID: 319c7bd1d8b7
Revises: 5032f4520049
Create Date: 2023-09-26 11:56:22.821284

"""
from alembic import op
import sqlalchemy as sa
import sqlmodel
import app


# revision identifiers, used by Alembic.
revision = '319c7bd1d8b7'
down_revision = '5032f4520049'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('course',
                    sa.Column('created', app.db.base_model.TZDateTime(timezone=True), nullable=True),
                    sa.Column('updated', app.db.base_model.TZDateTime(timezone=True), nullable=True),
                    sa.Column('outline', sa.JSON(), nullable=True),
                    sa.Column('concepts', sa.JSON(), nullable=True),
                    sa.Column('markdown', sa.JSON(), nullable=True),
                    sa.Column('components', sa.JSON(), nullable=True),
                    sa.Column('context', sa.JSON(), nullable=True),
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('model', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
                    sa.Column('topic', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('topic', 'model', name='unique_topic_model')
                    )
    op.create_index(op.f('ix_course_id'), 'course', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_course_id'), table_name='course')
    op.drop_table('course')
    # ### end Alembic commands ###
