"""empty message

Revision ID: 5032f4520049
Revises: 
Create Date: 2023-09-20 12:19:11.011545

"""
from alembic import op
import sqlalchemy as sa
import sqlmodel
import app


# revision identifiers, used by Alembic.
revision = '5032f4520049'
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('prompt',
                    sa.Column('created', app.db.base_model.TZDateTime(timezone=True), nullable=True),
                    sa.Column('updated', app.db.base_model.TZDateTime(timezone=True), nullable=True),
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('hash', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
                    sa.Column('prompt', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
                    sa.Column('response', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
                    sa.Column('type', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
                    sa.Column('model', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('hash', 'model', name='unique_hash_model')
                    )
    op.create_index(op.f('ix_prompt_hash'), 'prompt', ['hash'], unique=False)
    op.create_index(op.f('ix_prompt_id'), 'prompt', ['id'], unique=False)
    op.create_table('scrapeddata',
                    sa.Column('created', app.db.base_model.TZDateTime(timezone=True), nullable=True),
                    sa.Column('updated', app.db.base_model.TZDateTime(timezone=True), nullable=True),
                    sa.Column('extra', sa.JSON(), nullable=True),
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('source', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
                    sa.Column('uploaded', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_index(op.f('ix_scrapeddata_id'), 'scrapeddata', ['id'], unique=False)
    op.create_index(op.f('ix_scrapeddata_source'), 'scrapeddata', ['source'], unique=True)
    op.create_table('serviceresponse',
                    sa.Column('created', app.db.base_model.TZDateTime(timezone=True), nullable=True),
                    sa.Column('updated', app.db.base_model.TZDateTime(timezone=True), nullable=True),
                    sa.Column('request', sa.JSON(), nullable=True),
                    sa.Column('response', sa.JSON(), nullable=True),
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('hash', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
                    sa.Column('name', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('hash', 'name', name='unique_hash_name')
                    )
    op.create_index(op.f('ix_serviceresponse_hash'), 'serviceresponse', ['hash'], unique=False)
    op.create_index(op.f('ix_serviceresponse_id'), 'serviceresponse', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_serviceresponse_id'), table_name='serviceresponse')
    op.drop_index(op.f('ix_serviceresponse_hash'), table_name='serviceresponse')
    op.drop_table('serviceresponse')
    op.drop_index(op.f('ix_scrapeddata_source'), table_name='scrapeddata')
    op.drop_index(op.f('ix_scrapeddata_id'), table_name='scrapeddata')
    op.drop_table('scrapeddata')
    op.drop_index(op.f('ix_prompt_id'), table_name='prompt')
    op.drop_index(op.f('ix_prompt_hash'), table_name='prompt')
    op.drop_table('prompt')
    # ### end Alembic commands ###
