/*
 * The MIT License
 *
 * Copyright 2017 Victor Santiago.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package victor.santiago.soccer.elo.ratings.model;

/**
 *
 * @author Victor Santiago
 */
public class TeamPerformance implements Comparable<TeamPerformance> {
    
    private String team;
    private int wins;
    private int losses;
    private int ties;
    private int points;
    private int goals;

    public TeamPerformance(String team) {
        this.team = team;
    }

    public TeamPerformance(String team, int wins, int losses, int ties, int points, int goals) {
        this.team = team;
        this.wins = wins;
        this.losses = losses;
        this.ties = ties;
        this.points = points;
        this.goals = goals;
    }

    public String getTeam() {
        return team;
    }

    public int getWins() {
        return wins;
    }

    public void setWins(int wins) {
        this.wins = wins;
    }

    public int getLosses() {
        return losses;
    }

    public void setLosses(int losses) {
        this.losses = losses;
    }

    public int getPoints() {
        return points;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public int getTies() {
        return ties;
    }

    public void setTies(int ties) {
        this.ties = ties;
    }
    
    public void increaseWin() {
        this.wins++;
        this.points += 3;
    }
    
    public void increaseLosses() {
        this.losses++;
    }
    
    public void increaseTie() {
        this.ties++;
        this.points++;
    }

    public int getGoals() {
        return goals;
    }

    public void setGoals(int goals) {
        this.goals = goals;
    }
    
    public void increaseGoalsBy(int n) {
        this.goals += n;
    }

    @Override
    public int compareTo(TeamPerformance o) {
        if (this.points == o.getPoints()) {
            if (this.wins == o.getWins()) {
                return Integer.compare(this.goals, o.getGoals());
            } else {
                return Integer.compare(this.wins, o.getWins());
            }
        }

        return Integer.compare(this.points, o.getPoints());
    }
    
}
