# Documentation

## Classes

- [Auth](classes/auth.md)
- [Client](classes/client.md)
- [Server](classes/server.md)
- [Message](classes/message.md)
- [Action](classes/action.md)

## Exceptions

- [NtfyException](exceptions.md#NtfyException)
- [EndpointException](exceptions.md#EndpointException)

## Code Examples

- [Send a message](../examples/send-message.php)
- [Send a message with a markdown body](../examples/send-message-with-markdown-body.php)
- [Send a message with a view action button](../examples/send-message-with-view-action.php)
- [Send a message to a server protected with user authentication](../examples/send-message-with-user-auth.php)
- [Send a message to a server protected with token authentication](../examples/send-message-with-token-auth.php)

## External Links

- [ntfy documentation (docs.ntfy.sh)](https://ntfy.sh/docs/)
- [ntfy source code (github.com/binwiederhier/ntfy)](https://github.com/binwiederhier/ntfy)