/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MPrenotazione.java
 *
 * Created on 10-lug-2011, 16.16.09
 */

package app.gui;

import archive.data.Corso;
import archive.data.Prenotazione;
import archive.exception.DoubleRoomNotAvailableException;
import archive.system.AgenziaSystem;
import archive.system.PrenotationManager;
import javax.swing.JOptionPane;

public class MPrenotazione extends javax.swing.JFrame {
 private PrenotationManager gpren=new PrenotationManager(AgenziaSystem.archivio.getPrenotazioni());
 private Prenotazione oldPren=AgenziaSystem.archivio.getOnePrenotazioni(GPrenotazioneP.nvillaggio).getPrenotazione(GPrenotazioneP.cognome, GPrenotazioneP.nweek);
 private Prenotazione appoPren = new Prenotazione(oldPren.getNumeroSett(), oldPren.getCognome(), oldPren.getNome());

    /** Creates new form MPrenotazione */
    public MPrenotazione() {
        initComponents();
        appoPren.setTipo(oldPren.getTipo());
        appoPren.setCorsi(oldPren.getCorsi());
        jFTFNsett.setText(String.valueOf(GPrenotazioneP.nweek));
        switch(appoPren.getTipo()){
            case 'D':
                  jCmBTipo.setSelectedIndex(0);
                 break;
            case 'S':
                jCmBTipo.setSelectedIndex(1);
                break;
        }
         for (Corso c : appoPren.getCorsi()) {
            switch (c) {
                case V:
                     jCBV.setSelected(true);
                    break;
                case E:
                    jCBT.setSelected(true);
                    break;
                case T:
                    jCBE.setSelected(true);
                    break;
                case S:
                    jCBS.setSelected(true);
                    break;
                case B:
                    jCBB.setSelected(true);
                    break;
            }
        }
       
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jCmBTipo = new javax.swing.JComboBox();
        jLabel6 = new javax.swing.JLabel();
        jCBT = new javax.swing.JCheckBox();
        jCBB = new javax.swing.JCheckBox();
        jLabel7 = new javax.swing.JLabel();
        jCBV = new javax.swing.JCheckBox();
        jCBS = new javax.swing.JCheckBox();
        jCBE = new javax.swing.JCheckBox();
        jBSalva = new javax.swing.JButton();
        jFTFNsett = new javax.swing.JFormattedTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jLabel1.setText("Numero Settimana");

        jCmBTipo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "D", "S" }));
        jCmBTipo.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jCmBTipoMouseReleased(evt);
            }
        });

        jLabel6.setText("Tipo Stanza");

        jCBT.setText("E");

        jCBB.setText("B");

        jLabel7.setText("Corsi");

        jCBV.setText("V");

        jCBS.setText("S");

        jCBE.setText("T");

        jBSalva.setText("Salva Modifiche");
        jBSalva.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBSalvaActionPerformed(evt);
            }
        });

        jFTFNsett.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter(java.text.NumberFormat.getIntegerInstance())));
        jFTFNsett.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jFTFNsettKeyReleased(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(89, 89, 89)
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jFTFNsett, javax.swing.GroupLayout.PREFERRED_SIZE, 70, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(100, 100, 100)
                        .addComponent(jLabel6)
                        .addGap(37, 37, 37)
                        .addComponent(jCmBTipo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(113, 113, 113)
                        .addComponent(jLabel7)
                        .addGap(38, 38, 38)
                        .addComponent(jCBV)
                        .addGap(2, 2, 2)
                        .addComponent(jCBT)
                        .addGap(2, 2, 2)
                        .addComponent(jCBE)
                        .addComponent(jCBS)
                        .addComponent(jCBB))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(175, 175, 175)
                        .addComponent(jBSalva)))
                .addContainerGap(66, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(45, 45, 45)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jFTFNsett, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(33, 33, 33)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addComponent(jLabel6))
                    .addComponent(jCmBTipo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel7)
                    .addComponent(jCBV)
                    .addComponent(jCBT)
                    .addComponent(jCBE)
                    .addComponent(jCBS)
                    .addComponent(jCBB))
                .addGap(50, 50, 50)
                .addComponent(jBSalva))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jCmBTipoMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jCmBTipoMouseReleased
        
        try {
            gpren.modPrenotation(appoPren, "T" +";"+ jCmBTipo.getSelectedItem());
        } catch (DoubleRoomNotAvailableException ex) {
            int showConfirmDialog = JOptionPane.showConfirmDialog(rootPane, "Stanze Doppie non disponibili vuoi essere aggiunto in lista d'attesa?", "", JOptionPane.YES_NO_OPTION);
           if(showConfirmDialog==0){
               gpren.addInQueue(true);
           }
        }
    }//GEN-LAST:event_jCmBTipoMouseReleased

    private void jBSalvaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBSalvaActionPerformed
        String corsi="";
          if(jCBV.isSelected()) corsi+="V";
          if(jCBT.isSelected()) corsi+="E";
          if(jCBE.isSelected()) corsi+="T";
          if(jCBS.isSelected()) corsi+="S";
          if(jCBB.isSelected()) corsi+="B";
        try {
            gpren.modPrenotation(appoPren, "S" + ";" + corsi);
        } catch (DoubleRoomNotAvailableException ex) {
        }
        try {
            if(gpren.modPrenotation(appoPren, "C;save")){
                JOptionPane.showConfirmDialog(rootPane,"Modifiche Effettuate");
            }
        } catch (DoubleRoomNotAvailableException ex) {
        }
    }//GEN-LAST:event_jBSalvaActionPerformed

    private void jFTFNsettKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jFTFNsettKeyReleased
        int nsett = Integer.parseInt(jFTFNsett.getText());
        if(nsett<1 || nsett>52) jFTFNsett.setText("");
    }//GEN-LAST:event_jFTFNsettKeyReleased

    /**
    * @param args the command line arguments
    */
   

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jBSalva;
    private javax.swing.JCheckBox jCBB;
    private javax.swing.JCheckBox jCBE;
    private javax.swing.JCheckBox jCBS;
    private javax.swing.JCheckBox jCBT;
    private javax.swing.JCheckBox jCBV;
    private javax.swing.JComboBox jCmBTipo;
    private javax.swing.JFormattedTextField jFTFNsett;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    // End of variables declaration//GEN-END:variables

}
