/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * GPrenotazioneV.java
 *
 * Created on 11-lug-2011, 11.21.10
 */
package app.gui;

import app.Main;
import archive.data.Cliente;
import archive.data.PrenotazioneVolo;
import archive.exception.DoubleRoomNotAvailableException;
import archive.interfacce.GestionePrenotazione;
import archive.system.AgenziaSystem;
import archive.system.PrenotationManager;
import archive.utility.FormattedSetPrenotationArray;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JOptionPane;

public class GPrenotazioneV extends javax.swing.JFrame {

    private GestionePrenotazione gprenv = new PrenotationManager(AgenziaSystem.archivio.getPrenVoli());

    /** Creates new form GPrenotazioneV */
    public GPrenotazioneV() {
        Main.gui.setVisible(false);
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jTFCognome = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jBCancella = new javax.swing.JButton();
        jBModifica = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jLElenco = new javax.swing.JList();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jTFCognome.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTFCognomeActionPerformed(evt);
            }
        });
        jTFCognome.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTFCognomeKeyReleased(evt);
            }
        });

        jLabel1.setText("Cognome Cliente");

        jBCancella.setText("Cancella Prenotazione");
        jBCancella.setEnabled(false);
        jBCancella.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBCancellaActionPerformed(evt);
            }
        });

        jBModifica.setText("Modifica Caratteristiche");
        jBModifica.setEnabled(false);
        jBModifica.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBModificaActionPerformed(evt);
            }
        });

        jScrollPane1.setViewportView(jLElenco);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addGap(10, 10, 10)
                        .addComponent(jTFCognome, javax.swing.GroupLayout.PREFERRED_SIZE, 73, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(33, 33, 33)
                        .addComponent(jBCancella))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(33, 33, 33)
                        .addComponent(jBModifica)))
                .addGap(42, 42, 42)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 231, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(47, 47, 47)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGap(3, 3, 3)
                                .addComponent(jLabel1))
                            .addComponent(jTFCognome, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(62, 62, 62)
                        .addComponent(jBCancella)
                        .addGap(42, 42, 42)
                        .addComponent(jBModifica))
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 205, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(48, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jTFCognomeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTFCognomeActionPerformed

        Cliente cliente = null;
        try {
            cliente= gprenv.requestInformation(jTFCognome.getText());
        } catch (NoSuchElementException e) {
            JOptionPane.showMessageDialog(rootPane, "Cliente non presente nell'archivio", "", JOptionPane.ERROR_MESSAGE);
        }
        if(gprenv.showList(cliente).isEmpty()){
            JOptionPane.showMessageDialog(rootPane, "Prenotazioni non presenti", "", JOptionPane.ERROR_MESSAGE);
        }else{
           jBCancella.setEnabled(true);
           jBModifica.setEnabled(true);
        }
        
}//GEN-LAST:event_jTFCognomeActionPerformed

    private void jTFCognomeKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTFCognomeKeyReleased
}//GEN-LAST:event_jTFCognomeKeyReleased

    private void jBCancellaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBCancellaActionPerformed
        Cliente cliente = gprenv.requestInformation(jTFCognome.getText());
        Set<PrenotazioneVolo> set = gprenv.showList(cliente);
        String[] s = new String[0];
        for (PrenotazioneVolo x : set) {
            int n = s.length;
            s = Arrays.copyOf(s, n + 1);
            s[n] = x.toString();

        }
        s = FormattedSetPrenotationArray.formattedSetPrenotation(s);
        jLElenco.setListData(s);
        String sigla = JOptionPane.showInputDialog(rootPane, "Inserisci sigla Volo");
        if (gprenv.delPrenotation(AgenziaSystem.archivio.getonePrenVoli(sigla))) {
            JOptionPane.showMessageDialog(rootPane, "Cancellazione Effettuata","",JOptionPane.INFORMATION_MESSAGE);
        }
    }//GEN-LAST:event_jBCancellaActionPerformed

    private void jBModificaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBModificaActionPerformed
        Cliente cliente = gprenv.requestInformation(jTFCognome.getText());
        Set<PrenotazioneVolo> set = gprenv.showList(cliente);
        String[] s = new String[0];
        for (PrenotazioneVolo x : set) {
            int n = s.length;
            s = Arrays.copyOf(s, n + 1);
            s[n] = x.toString();

        }
        s = FormattedSetPrenotationArray.formattedSetPrenotation(s);
        jLElenco.setListData(s);
        String sigla = JOptionPane.showInputDialog(rootPane, "Inserisci sigla Volo");
        String orario = JOptionPane.showInputDialog(rootPane, "Inserisci l'orario");
        try {
            if (gprenv.modPrenotation(AgenziaSystem.archivio.getonePrenVoli(sigla), orario)) {
                 JOptionPane.showMessageDialog(rootPane, "Modifica Effettuata","",JOptionPane.INFORMATION_MESSAGE);
            } else {
                JOptionPane.showMessageDialog(rootPane, "Non ci sono voli in questo orario","",JOptionPane.ERROR_MESSAGE);
            }
        } catch (DoubleRoomNotAvailableException ex) {
        }

}//GEN-LAST:event_jBModificaActionPerformed

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
Main.gui.setVisible(true);        // TODO add your handling code here:
    }//GEN-LAST:event_formWindowClosing
    /**
     * @param args the command line arguments
     */
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jBCancella;
    private javax.swing.JButton jBModifica;
    private javax.swing.JList jLElenco;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField jTFCognome;
    // End of variables declaration//GEN-END:variables
}
