/*
 * Decompiled with CFR 0.152.
 */
package archive.data;

import archive.data.Corso;
import archive.interfacce.HasGotCorsi;
import archive.utility.SetArray;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Settimana
implements HasGotCorsi {
    private int nsett;
    private int nsd;
    private int psd;
    private int nsu;
    private int psu;
    private Set<Corso> seq = new SetArray<Corso>();
    private Queue<String> lista = new LinkedList<String>();

    public Settimana() {
    }

    public Settimana(int nsett, int nsd, int psd, int nsu, int psu) {
        this.nsett = nsett;
        this.nsd = nsd;
        this.psd = psd;
        this.nsu = nsu;
        this.psu = psu;
    }

    public int getNSett() {
        return this.nsett;
    }

    public int getNSD() {
        return this.nsd;
    }

    public int getPSD() {
        return this.psd;
    }

    public int getNSU() {
        return this.nsu;
    }

    public int getPSU() {
        return this.psu;
    }

    @Override
    public Set<Corso> getCorsi() {
        return this.seq;
    }

    public boolean removeNSD() {
        if (this.nsd == 0) {
            return false;
        }
        --this.nsd;
        return true;
    }

    public boolean removeNSU() {
        if (this.nsu == 0) {
            return false;
        }
        --this.nsu;
        return true;
    }

    public String removeFromAttesa() {
        return this.lista.poll();
    }

    public void addNSD() {
        ++this.nsd;
    }

    public void addNSU() {
        ++this.nsu;
    }

    @Override
    public void resetCorsi() {
        this.seq = new SetArray<Corso>();
    }

    public boolean setCorsi(Set<Corso> newCorsi) {
        this.resetCorsi();
        for (Corso c : newCorsi) {
            this.seq.add(c);
        }
        return true;
    }

    public boolean setPSD(int p) {
        if (p < 0) {
            p *= -1;
        }
        this.psd = p;
        return true;
    }

    public boolean setPSU(int p) {
        if (p < 0) {
            p *= -1;
        }
        this.psu = p;
        return true;
    }

    public void setLista(Queue<String> lista) {
        if (lista == null) {
            throw new NullPointerException();
        }
        this.lista = lista;
    }

    public boolean isQueueEmpty() {
        return this.lista.peek() == null || this.lista.peek().equals("");
    }

    @Override
    public boolean containCorso(Corso c) {
        return this.seq.contains((Object)c);
    }

    @Override
    public boolean removeCorso(Corso c) {
        return this.seq.remove((Object)c);
    }

    public boolean addInAttesa(String cognome) {
        if (this.lista.contains(cognome)) {
            return false;
        }
        return this.lista.add(cognome);
    }

    public boolean addInAttesa(String[] cognome) {
        return this.lista.addAll(Arrays.asList(cognome));
    }

    @Override
    public boolean addCorso(Corso c) {
        return this.seq.add(c);
    }

    @Override
    public void addCorso(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        block7: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case 'V': {
                    this.addCorso(Corso.V);
                    continue block7;
                }
                case 'E': {
                    this.addCorso(Corso.E);
                    continue block7;
                }
                case 'T': {
                    this.addCorso(Corso.T);
                    continue block7;
                }
                case 'S': {
                    this.addCorso(Corso.S);
                    continue block7;
                }
                case 'B': {
                    this.addCorso(Corso.B);
                }
            }
        }
    }

    public String stampaCorsi() {
        String sc = "";
        for (Corso c : this.seq) {
            switch (c.getNome().charAt(0)) {
                case 'v': {
                    sc = sc + "V";
                    break;
                }
                case 'e': {
                    sc = sc + "E";
                    break;
                }
                case 't': {
                    sc = sc + "T";
                    break;
                }
                case 's': {
                    sc = sc + "S";
                    break;
                }
                case 'i': {
                    sc = sc + "B";
                }
            }
        }
        return sc;
    }

    public String toString() {
        String sc = this.stampaCorsi();
        String l = "";
        if (!this.lista.isEmpty()) {
            for (String x : this.lista) {
                if (x.equals("")) continue;
                l = l + x + ";";
            }
            l = l.substring(0, l.length());
        }
        return this.nsett + ";" + this.nsd + ";" + this.psd + ";" + this.nsu + ";" + this.psu + ";" + sc + "\n" + l + "\n";
    }
}

