/*
 * Decompiled with CFR 0.152.
 */
package archive.data;

import archive.data.Cliente;
import archive.data.Corso;
import archive.interfacce.Prenotation;
import archive.system.AgenziaSystem;
import archive.utility.SetArray;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Prenotazione
implements Comparable,
Prenotation {
    private int numeroSett;
    private String cognome;
    private String nome;
    private Tipo tipo;
    private Set<Corso> seq = new SetArray<Corso>();

    public Prenotazione(int ns, String c, String n) {
        this.numeroSett = ns;
        this.cognome = c;
        this.nome = n;
    }

    public int getNumeroSett() {
        return this.numeroSett;
    }

    public String getCognome() {
        return this.cognome;
    }

    public String getNome() {
        return this.nome;
    }

    public char getTipo() {
        char c = ' ';
        switch (this.tipo) {
            case D: {
                c = 'D';
                break;
            }
            case S: {
                c = 'S';
            }
        }
        return c;
    }

    public Set<Corso> getCorsi() {
        return this.seq;
    }

    public void setCorsi(Set<Corso> sc) {
        for (Corso c : sc) {
            this.seq.add(c);
        }
    }

    public void setNumeroSett(int ns) {
        if (ns < 1 || ns > 52) {
            throw new IllegalArgumentException();
        }
        this.numeroSett = ns;
    }

    public void setCognome(String s) {
        this.cognome = s;
    }

    public void setNome(String s) {
        this.nome = s;
    }

    public void setTipo(Tipo t) {
        this.tipo = t;
    }

    public void setTipo(char t) {
        t = Character.toUpperCase(t);
        switch (t) {
            case 'D': {
                this.setTipo(Tipo.D);
                break;
            }
            case 'S': {
                this.setTipo(Tipo.S);
            }
        }
    }

    public void addTipo(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        switch (s.charAt(0)) {
            case 'D': {
                this.setTipo(Tipo.D);
                break;
            }
            case 'S': {
                this.setTipo(Tipo.S);
            }
        }
    }

    public boolean isCorso(String nome, Corso c) {
        try {
            return AgenziaSystem.archivio.getPacchetto(nome).getSettimana(this.numeroSett).containCorso(c);
        }
        catch (NullPointerException ex) {
            return true;
        }
    }

    public boolean addCorso(String nome, Corso c) {
        if (!this.isCorso(nome, c)) {
            return false;
        }
        return this.seq.add(c);
    }

    public void addCorso(String nome, String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        block7: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case 'V': {
                    this.addCorso(nome, Corso.V);
                    continue block7;
                }
                case 'E': {
                    this.addCorso(nome, Corso.E);
                    continue block7;
                }
                case 'T': {
                    this.addCorso(nome, Corso.T);
                    continue block7;
                }
                case 'S': {
                    this.addCorso(nome, Corso.S);
                    continue block7;
                }
                case 'B': {
                    this.addCorso(nome, Corso.B);
                }
            }
        }
    }

    public void resetCorsi() {
        this.seq = new SetArray<Corso>();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Prenotazione) {
            Prenotazione c = (Prenotazione)o;
            return c.getCognome().equals(this.cognome) && c.numeroSett == this.numeroSett;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + this.numeroSett;
        hash = 97 * hash + (this.cognome != null ? this.cognome.hashCode() : 0);
        return hash;
    }

    public String stampaCorsi() {
        String sc = "";
        for (Corso c : this.seq) {
            switch (c.getNome().charAt(0)) {
                case 'v': {
                    sc = sc + "V";
                    break;
                }
                case 'e': {
                    sc = sc + "E";
                    break;
                }
                case 't': {
                    sc = sc + "T";
                    break;
                }
                case 's': {
                    sc = sc + "S";
                    break;
                }
                case 'i': {
                    sc = sc + "B";
                }
            }
        }
        return sc;
    }

    public String toString() {
        String sc = this.stampaCorsi();
        char t = ' ';
        switch (this.tipo) {
            case D: {
                t = 'D';
                break;
            }
            case S: {
                t = 'S';
            }
        }
        return this.numeroSett + ";" + this.cognome + ";" + this.nome + ";" + t + ";" + sc;
    }

    @Override
    public boolean isPresentClient(Cliente c) {
        return c.getCognome().equals(this.cognome);
    }

    public int compareTo(Object o) {
        Prenotazione p = (Prenotazione)o;
        if (this.numeroSett == p.getNumeroSett()) {
            return 0;
        }
        return this.numeroSett > p.getNumeroSett() ? 1 : -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tipo {
        D,
        S;

    }
}

