/*
 * Decompiled with CFR 0.152.
 */
package archive.data;

import archive.data.Cliente;
import archive.data.Pacchetto;
import archive.data.Prenotazione;
import archive.data.PrenotazioneVolo;
import archive.data.Prenotazioni;
import archive.data.Volo;
import archive.utility.SetArray;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Archivio {
    private Set<Cliente> clienti = new SetArray<Cliente>();
    private Set<Pacchetto> pacchetti = new SetArray<Pacchetto>();
    private Set<Prenotazioni> prenotazioni = new SetArray<Prenotazioni>();
    private Set<Volo> voli = new SetArray<Volo>();
    private Set<PrenotazioneVolo> prenVoli = new SetArray<PrenotazioneVolo>();

    public void addCliente(Cliente c) {
        if (!this.clienti.add(c)) {
            throw new IllegalArgumentException();
        }
    }

    public void addPacchetto(Pacchetto p) {
        if (!this.pacchetti.add(p)) {
            throw new IllegalArgumentException();
        }
    }

    public boolean addPrenotazioni(Prenotazioni p) {
        return this.prenotazioni.add(p);
    }

    public void addPrenotazione(Prenotazione p, String nomeVillaggio) {
        for (Prenotazioni x : this.prenotazioni) {
            if (!x.getNomeVillaggio().equals(nomeVillaggio)) continue;
            x.add(p);
        }
    }

    public void addVolo(Volo v) {
        if (!this.voli.add(v)) {
            throw new IllegalArgumentException();
        }
    }

    public void addPrenVolo(PrenotazioneVolo pv) {
        if (!this.prenVoli.add(pv)) {
            throw new IllegalArgumentException();
        }
        for (Volo x : this.voli) {
            if (!x.getSigla().equals(pv.getSigla())) continue;
            x.subRimasti(1);
        }
    }

    public void removeCliente(Cliente c) {
        if (!this.clienti.remove(c)) {
            throw new IllegalArgumentException();
        }
    }

    public void removePacchetto(Pacchetto p) {
        if (!this.pacchetti.remove(p)) {
            throw new IllegalArgumentException();
        }
    }

    public void removePrenotazioni(Prenotazioni p) {
        if (!this.prenotazioni.remove(p)) {
            throw new IllegalArgumentException();
        }
    }

    public void removeVolo(Volo v) {
        if (!this.voli.remove(v)) {
            throw new IllegalArgumentException();
        }
    }

    public boolean removePrenVolo(PrenotazioneVolo pv) {
        if (!this.prenVoli.remove(pv)) {
            return false;
        }
        for (Volo x : this.voli) {
            if (!x.getSigla().equals(pv.getSigla())) continue;
            x.addRimasti(1);
        }
        return true;
    }

    public boolean removePrenotazione(Prenotazione p, String nomeVillaggio) {
        for (Prenotazioni x : this.prenotazioni) {
            if (!x.getNomeVillaggio().equals(nomeVillaggio)) continue;
            return x.getElenco().remove(p);
        }
        return false;
    }

    public boolean removePrenotazione(String cognomeCliente, int numWeek, String nomeVillaggio) {
        Prenotazione p = new Prenotazione(numWeek, cognomeCliente, "");
        return this.removePrenotazione(p, nomeVillaggio);
    }

    public Pacchetto getPacchetto(String nome) {
        if (nome == null) {
            throw new NullPointerException();
        }
        for (Pacchetto x : this.pacchetti) {
            if (x == null || !nome.equals(x.getNome())) continue;
            return x;
        }
        return null;
    }

    public Cliente getCliente(String cognome) {
        if (cognome == null) {
            throw new NullPointerException();
        }
        for (Cliente x : this.clienti) {
            if (x == null || !cognome.equals(x.getCognome())) continue;
            return x;
        }
        return null;
    }

    public Prenotazioni getOnePrenotazioni(String nome) {
        if (nome == null) {
            throw new NullPointerException();
        }
        for (Prenotazioni p : this.prenotazioni) {
            if (p == null || !nome.equals(p.getNomeVillaggio())) continue;
            return p;
        }
        return null;
    }

    public Volo getVolo(String sigla) {
        if (sigla == null) {
            throw new NullPointerException();
        }
        for (Volo x : this.voli) {
            if (!x.getSigla().equals(sigla)) continue;
            return x;
        }
        return null;
    }

    public Set<Pacchetto> getPacchetti() {
        return Collections.unmodifiableSet(this.pacchetti);
    }

    public Set<Cliente> getClienti() {
        return Collections.unmodifiableSet(this.clienti);
    }

    public Set<Prenotazioni> getPrenotazioni() {
        return Collections.unmodifiableSet(this.prenotazioni);
    }

    public Set<Volo> getVoli() {
        return Collections.unmodifiableSet(this.voli);
    }

    public Set<PrenotazioneVolo> getPrenVoli() {
        return Collections.unmodifiableSet(this.prenVoli);
    }

    public Set<PrenotazioneVolo> getPrenVoli(String sigla) {
        if (sigla == null) {
            throw new NullPointerException();
        }
        SetArray<PrenotazioneVolo> pV = new SetArray<PrenotazioneVolo>();
        for (PrenotazioneVolo x : this.prenVoli) {
            if (!x.getSigla().equals(sigla)) continue;
            pV.add(x);
        }
        return pV;
    }

    public PrenotazioneVolo getonePrenVoli(String sigla) {
        if (sigla == null) {
            throw new NullPointerException();
        }
        SetArray pV = new SetArray();
        for (PrenotazioneVolo x : this.prenVoli) {
            if (!x.getSigla().equals(sigla)) continue;
            return x;
        }
        return null;
    }

    public boolean hasGotPrenotation(Cliente c, int n) {
        for (Prenotazioni p : this.prenotazioni) {
            if (!p.isPresentClient(c, n)) continue;
            return true;
        }
        return false;
    }
}

