/*
 * Decompiled with CFR 0.152.
 */
package app.tui;

import java.util.Arrays;
import java.util.Scanner;

public abstract class TextMenu {
    private String[] menu;
    private int spacing = 0;

    protected TextMenu(String ... item) {
        int n = item.length;
        this.menu = Arrays.copyOf(item, n);
    }

    private int input(Scanner in) {
        int n = this.menu.length;
        int index = 0;
        while (true) {
            try {
                index = Integer.parseInt(in.nextLine());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (index >= 1 && index <= n) {
                return index;
            }
            System.out.println("Digitare un intero tra 1e" + n);
        }
    }

    private void printMenu() {
        int i;
        int n = this.menu.length;
        int maxlen = 0;
        for (i = 0; i < n; ++i) {
            if (this.menu[i].length() <= maxlen) continue;
            maxlen = this.menu[i].length();
        }
        maxlen += 8;
        for (i = 0; i < maxlen; ++i) {
            System.out.print('*');
        }
        System.out.println();
        for (i = 0; i < n; ++i) {
            System.out.printf("* %2d. %s", i + 1, this.menu[i]);
            int s = maxlen - 7 - this.menu[i].length();
            for (int j = 0; j < s; ++j) {
                System.out.print(' ');
            }
            System.out.println('*');
        }
        for (i = 0; i < maxlen; ++i) {
            System.out.print('*');
        }
        System.out.println();
    }

    public void run() {
        int n = this.menu.length;
        boolean quit = false;
        Scanner in = new Scanner(System.in);
        while (!quit) {
            this.printMenu();
            int index = this.input(in);
            if (index <= n) {
                this.doMenu(index);
            }
            quit = true;
        }
    }

    protected abstract void doMenu(int var1);
}

