/*
 * Decompiled with CFR 0.152.
 */
package app.gui;

import app.gui.GPrenotazioneP;
import archive.data.Corso;
import archive.data.Prenotazione;
import archive.data.Prenotazioni;
import archive.exception.DoubleRoomNotAvailableException;
import archive.system.AgenziaSystem;
import archive.system.PrenotationManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class MPrenotazione
extends JFrame {
    private PrenotationManager<Prenotazioni> gpren = new PrenotationManager<Prenotazioni>(AgenziaSystem.archivio.getPrenotazioni());
    private Prenotazione oldPren = AgenziaSystem.archivio.getOnePrenotazioni(GPrenotazioneP.nvillaggio).getPrenotazione(GPrenotazioneP.cognome, GPrenotazioneP.nweek);
    private Prenotazione appoPren = new Prenotazione(this.oldPren.getNumeroSett(), this.oldPren.getCognome(), this.oldPren.getNome());
    private JButton jBSalva;
    private JCheckBox jCBB;
    private JCheckBox jCBE;
    private JCheckBox jCBS;
    private JCheckBox jCBT;
    private JCheckBox jCBV;
    private JComboBox jCmBTipo;
    private JFormattedTextField jFTFNsett;
    private JLabel jLabel1;
    private JLabel jLabel6;
    private JLabel jLabel7;

    public MPrenotazione() {
        this.initComponents();
        this.appoPren.setTipo(this.oldPren.getTipo());
        this.appoPren.setCorsi(this.oldPren.getCorsi());
        this.jFTFNsett.setText(String.valueOf(GPrenotazioneP.nweek));
        switch (this.appoPren.getTipo()) {
            case 'D': {
                this.jCmBTipo.setSelectedIndex(0);
                break;
            }
            case 'S': {
                this.jCmBTipo.setSelectedIndex(1);
            }
        }
        for (Corso c : this.appoPren.getCorsi()) {
            switch (c) {
                case V: {
                    this.jCBV.setSelected(true);
                    break;
                }
                case E: {
                    this.jCBT.setSelected(true);
                    break;
                }
                case T: {
                    this.jCBE.setSelected(true);
                    break;
                }
                case S: {
                    this.jCBS.setSelected(true);
                    break;
                }
                case B: {
                    this.jCBB.setSelected(true);
                }
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jCmBTipo = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jCBT = new JCheckBox();
        this.jCBB = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.jCBV = new JCheckBox();
        this.jCBS = new JCheckBox();
        this.jCBE = new JCheckBox();
        this.jBSalva = new JButton();
        this.jFTFNsett = new JFormattedTextField();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText("Numero Settimana");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(48, 89, 0, 0);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jCmBTipo.setModel(new DefaultComboBoxModel<String>(new String[]{"D", "S"}));
        this.jCmBTipo.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                MPrenotazione.this.jCmBTipoMouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(33, 16, 0, 0);
        this.getContentPane().add((Component)this.jCmBTipo, gridBagConstraints);
        this.jLabel6.setText("Tipo Stanza");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(36, 100, 0, 0);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.jCBT.setText("E");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 2, 0, 0);
        this.getContentPane().add((Component)this.jCBT, gridBagConstraints);
        this.jCBB.setText("B");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 54;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 0, 0, 72);
        this.getContentPane().add((Component)this.jCBB, gridBagConstraints);
        this.jLabel7.setText("Corsi");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 113, 0, 0);
        this.getContentPane().add((Component)this.jLabel7, gridBagConstraints);
        this.jCBV.setText("V");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 19, 0, 0);
        this.getContentPane().add((Component)this.jCBV, gridBagConstraints);
        this.jCBS.setText("S");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 27;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 27;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.getContentPane().add((Component)this.jCBS, gridBagConstraints);
        this.jCBE.setText("T");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 15;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 2, 0, 0);
        this.getContentPane().add((Component)this.jCBE, gridBagConstraints);
        this.jBSalva.setText("Salva Modifiche");
        this.jBSalva.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MPrenotazione.this.jBSalvaActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 26;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(32, 19, 43, 0);
        this.getContentPane().add((Component)this.jBSalva, gridBagConstraints);
        this.jFTFNsett.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(NumberFormat.getIntegerInstance())));
        this.jFTFNsett.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                MPrenotazione.this.jFTFNsettKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 11;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 64;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(45, 10, 0, 0);
        this.getContentPane().add((Component)this.jFTFNsett, gridBagConstraints);
        this.pack();
    }

    private void jCmBTipoMouseReleased(MouseEvent evt) {
        block2: {
            try {
                this.gpren.modPrenotation(this.appoPren, "T;" + this.jCmBTipo.getSelectedItem());
            }
            catch (DoubleRoomNotAvailableException ex) {
                int showConfirmDialog = JOptionPane.showConfirmDialog(this.rootPane, "Stanze Doppie non disponibili vuoi essere aggiunto in lista d'attesa?", "", 0);
                if (showConfirmDialog != 0) break block2;
                this.gpren.addInQueue(true);
            }
        }
    }

    private void jBSalvaActionPerformed(ActionEvent evt) {
        this.gpren.setVillaggio(GPrenotazioneP.nvillaggio);
        try {
            this.gpren.modPrenotation(this.appoPren, "N;" + this.jFTFNsett.getText());
        }
        catch (DoubleRoomNotAvailableException ex) {
            // empty catch block
        }
        String corsi = "";
        if (this.jCBV.isSelected()) {
            corsi = corsi + "V";
        }
        if (this.jCBT.isSelected()) {
            corsi = corsi + "E";
        }
        if (this.jCBE.isSelected()) {
            corsi = corsi + "T";
        }
        if (this.jCBS.isSelected()) {
            corsi = corsi + "S";
        }
        if (this.jCBB.isSelected()) {
            corsi = corsi + "B";
        }
        try {
            this.gpren.modPrenotation(this.appoPren, "S;" + corsi);
        }
        catch (DoubleRoomNotAvailableException ex) {
            // empty catch block
        }
        try {
            if (this.gpren.modPrenotation(this.appoPren, "C;save")) {
                JOptionPane.showMessageDialog(this.rootPane, "Modifiche Effettuate", "", 1);
            }
        }
        catch (DoubleRoomNotAvailableException doubleRoomNotAvailableException) {
            // empty catch block
        }
    }

    private void jFTFNsettKeyReleased(KeyEvent evt) {
        int nsett = Integer.parseInt(this.jFTFNsett.getText());
        if (nsett < 1 || nsett > 52) {
            this.jFTFNsett.setText("");
        }
    }
}

