/*
 * Decompiled with CFR 0.152.
 */
package app.gui;

import app.Main;
import archive.data.Cliente;
import archive.data.PrenotazioneVolo;
import archive.exception.DoubleRoomNotAvailableException;
import archive.interfacce.Prenotation;
import archive.system.AgenziaSystem;
import archive.system.PrenotationManager;
import archive.utility.FormattedSetPrenotationArray;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class GPrenotazioneV
extends JFrame {
    private PrenotationManager<PrenotazioneVolo> gprenv = new PrenotationManager<PrenotazioneVolo>(AgenziaSystem.archivio.getPrenVoli());
    private String[] prenotation = null;
    private JButton jBCancella;
    private JButton jBModifica;
    private JList jLElenco;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTextField jTFCognome;

    public GPrenotazioneV() {
        Main.gui.setVisible(false);
        this.initComponents();
    }

    private void initComponents() {
        this.jTFCognome = new JTextField();
        this.jLabel1 = new JLabel();
        this.jBCancella = new JButton();
        this.jBModifica = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jLElenco = new JList();
        this.setDefaultCloseOperation(2);
        this.setTitle("Gestione Prenotazione Voli");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GPrenotazioneV.this.formWindowClosing(evt);
            }
        });
        this.jTFCognome.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GPrenotazioneV.this.jTFCognomeActionPerformed(evt);
            }
        });
        this.jTFCognome.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                GPrenotazioneV.this.jTFCognomeKeyReleased(evt);
            }
        });
        this.jLabel1.setText("Cognome Cliente");
        this.jBCancella.setText("Cancella Prenotazione");
        this.jBCancella.setEnabled(false);
        this.jBCancella.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GPrenotazioneV.this.jBCancellaActionPerformed(evt);
            }
        });
        this.jBModifica.setText("Modifica Orario");
        this.jBModifica.setEnabled(false);
        this.jBModifica.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GPrenotazioneV.this.jBModificaActionPerformed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jLElenco);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(10, 10, 10).addComponent(this.jTFCognome, -2, 73, -2)).addGroup(layout.createSequentialGroup().addGap(33, 33, 33).addComponent(this.jBCancella)).addGroup(layout.createSequentialGroup().addGap(33, 33, 33).addComponent(this.jBModifica))).addGap(42, 42, 42).addComponent(this.jScrollPane1, -2, 154, -2).addContainerGap(56, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(47, 47, 47).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 225, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.jLabel1)).addComponent(this.jTFCognome, -2, -1, -2)).addGap(62, 62, 62).addComponent(this.jBCancella).addGap(42, 42, 42).addComponent(this.jBModifica))).addContainerGap(47, Short.MAX_VALUE)));
        this.pack();
    }

    private void jTFCognomeActionPerformed(ActionEvent evt) {
        Cliente cliente = null;
        try {
            cliente = this.gprenv.requestInformation(this.jTFCognome.getText());
        }
        catch (NoSuchElementException e) {
            JOptionPane.showMessageDialog(this.rootPane, "Cliente non presente nell'archivio", "", 0);
        }
        if (this.gprenv.showList(cliente).isEmpty()) {
            JOptionPane.showMessageDialog(this.rootPane, "Prenotazioni non presenti", "", 0);
        } else {
            Set<Prenotation> set = this.gprenv.showList(cliente);
            this.prenotation = new String[0];
            for (Prenotation x : set) {
                int n = this.prenotation.length;
                this.prenotation = Arrays.copyOf(this.prenotation, n + 1);
                this.prenotation[n] = x.toString();
            }
            this.prenotation = FormattedSetPrenotationArray.formattedSetPrenotation(this.prenotation);
            this.jLElenco.setListData(this.prenotation);
            this.jBCancella.setEnabled(true);
            this.jBModifica.setEnabled(true);
        }
    }

    private void jTFCognomeKeyReleased(KeyEvent evt) {
    }

    private void jBCancellaActionPerformed(ActionEvent evt) {
        String prenotazione = (String)JOptionPane.showInputDialog(this.rootPane, "Seleziona la prenotazione", "Prenotazione Volo", -1, null, this.prenotation, "inputValue");
        String[] appo = prenotazione.split(";");
        if (this.gprenv.delPrenotation(AgenziaSystem.archivio.getonePrenVoli(appo[2]))) {
            JOptionPane.showMessageDialog(this.rootPane, "Cancellazione Effettuata", "", 1);
        }
    }

    private void jBModificaActionPerformed(ActionEvent evt) {
        String prenotazione = (String)JOptionPane.showInputDialog(this.rootPane, "Seleziona la prenotazione", "Prenotazione Volo", -1, null, this.prenotation, "inputValue");
        String[] appo = prenotazione.split(";");
        String orario = JOptionPane.showInputDialog(this.rootPane, (Object)"Inserisci l'orario");
        try {
            if (this.gprenv.modPrenotation(AgenziaSystem.archivio.getonePrenVoli(appo[2]), orario)) {
                JOptionPane.showMessageDialog(this.rootPane, "Modifica Effettuata", "", 1);
            } else {
                JOptionPane.showMessageDialog(this.rootPane, "Non ci sono voli in questo orario", "", 0);
            }
        }
        catch (DoubleRoomNotAvailableException ex) {
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        Main.gui.setVisible(true);
    }
}

