/*
 * Decompiled with CFR 0.152.
 */
package archive.utility;

import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetArray<E>
implements Set<E> {
    private E[] array = new Object[0];
    private int size = 0;
    private int modCount = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private int find(Object c) {
        int i;
        for (i = 0; i < this.size && !(c != null ? c.equals(this.array[i]) : this.array[i] == null); ++i) {
        }
        return i < this.size ? i : -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.find(o) >= 0;
    }

    @Override
    public Iterator<E> iterator() {
        final SetArray col = this;
        return new Iterator<E>(){
            private int cursor = 0;
            private int lastRet = -1;
            private int expectedModCount = SetArray.access$000(SetArray.this);

            private void checkForModification() {
                if (this.expectedModCount != SetArray.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                this.checkForModification();
                return this.cursor < SetArray.this.size;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.cursor;
                return SetArray.this.array[this.cursor++];
            }

            @Override
            public void remove() {
                this.checkForModification();
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                col.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = SetArray.this.modCount;
            }
        };
    }

    @Override
    public E[] toArray() {
        Object[] a = new Object[]{};
        int n = 0;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            n = a.length;
            a = Arrays.copyOf(a, n + 1);
            a[n] = this.array[i];
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean add(E e) {
        if (this.contains(e)) {
            return false;
        }
        if (this.array.length == this.size) {
            this.array = Arrays.copyOf(this.array, 3 * (this.size + 1) / 2);
        }
        this.array[this.size] = e;
        ++this.size;
        ++this.modCount;
        return true;
    }

    private void remove(int i) {
        ++this.modCount;
        this.array[i] = this.array[this.size - 1];
        --this.size;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.find(o);
        if (i < 0) {
            return false;
        }
        this.remove(i);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

