/*
 * Decompiled with CFR 0.152.
 */
package archive.system;

import archive.data.Cliente;
import archive.data.Prenotazione;
import archive.data.PrenotazioneVolo;
import archive.data.Prenotazioni;
import archive.data.Settimana;
import archive.data.Volo;
import archive.exception.DoubleRoomNotAvailableException;
import archive.interfacce.GestionePrenotazione;
import archive.interfacce.Prenotation;
import archive.system.AgenziaSystem;
import archive.system.PRequestPacchettoManager;
import archive.utility.AbstractPrenotation;
import archive.utility.SetArray;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrenotationManager<E extends AbstractPrenotation>
implements GestionePrenotazione {
    private Set<Prenotation<E>> prenotation;
    private String nomeVillaggio = null;
    private int appoNumWeek = 0;
    private boolean toAddInQueue = false;

    public PrenotationManager(Set<Prenotation<E>> p) {
        this.prenotation = p;
    }

    public void setVillaggio(String nome) {
        this.nomeVillaggio = nome;
    }

    @Override
    public Cliente requestInformation(String cognome) {
        if (cognome == null) {
            throw new NullPointerException();
        }
        Cliente c = AgenziaSystem.archivio.getCliente(cognome);
        if (c == null || !this.isRegistered(c)) {
            throw new NoSuchElementException();
        }
        return c;
    }

    private Prenotazione defaultPrenotation(String cognome, int numWeek) {
        Cliente client = AgenziaSystem.archivio.getCliente(cognome);
        Prenotazione newPren = new Prenotazione(numWeek, client.getCognome(), client.getNome());
        newPren.addTipo("D");
        return newPren;
    }

    @Override
    public boolean delPrenotation(Prenotation p) {
        Settimana set;
        Prenotazione pren;
        if (p == null) {
            throw new NullPointerException();
        }
        if (p instanceof PrenotazioneVolo) {
            PrenotazioneVolo prenV = (PrenotazioneVolo)p;
            return AgenziaSystem.archivio.removePrenVolo(prenV);
        }
        if (p instanceof Prenotazione && AgenziaSystem.archivio.removePrenotazione((Prenotazione)p, this.nomeVillaggio) && (pren = (Prenotazione)p).getTipo() == 'D' && !(set = AgenziaSystem.archivio.getPacchetto(this.nomeVillaggio).getSettimana(pren.getNumeroSett())).isQueueEmpty()) {
            String cognome = set.removeFromAttesa();
            AgenziaSystem.archivio.addPrenotazione(this.defaultPrenotation(cognome, pren.getNumeroSett()), this.nomeVillaggio);
        }
        return false;
    }

    private boolean modPrenVolo(PrenotazioneVolo p, String ora) {
        PrenotazioneVolo oldPren = p;
        for (Volo x : AgenziaSystem.archivio.getVoli()) {
            if (x == null || !x.getOPartenza().equals(ora) || !p.getDest().equals(x.getLArrivo()) || !p.getOri().equals(x.getLPartenza())) continue;
            p.setSigla(x.getSigla());
            AgenziaSystem.archivio.addPrenVolo(p);
            AgenziaSystem.archivio.removePrenVolo(oldPren);
            return true;
        }
        return false;
    }

    private boolean modPrenPach(Prenotazione p, String mod) throws DoubleRoomNotAvailableException {
        String appo = mod.substring(2);
        PRequestPacchettoManager rpp = new PRequestPacchettoManager();
        switch (mod.charAt(0)) {
            case 'N': {
                if (Integer.parseInt(appo) == p.getNumeroSett()) {
                    this.appoNumWeek = p.getNumeroSett();
                    return true;
                }
                if (AgenziaSystem.day.compareTo(Integer.parseInt(appo)) <= 0 || !rpp.isAvaible(Integer.parseInt(appo), this.nomeVillaggio)) {
                    return false;
                }
                this.appoNumWeek = p.getNumeroSett();
                p.setNumeroSett(Integer.parseInt(appo));
                return true;
            }
            case 'T': {
                if (appo.charAt(0) == p.getTipo()) {
                    return true;
                }
                PRequestPacchettoManager ra = new PRequestPacchettoManager();
                if (ra.isAvaible(p.getNumeroSett(), this.nomeVillaggio) && ra.getFreeRoom(appo.charAt(0)) > 0) {
                    p.setTipo(appo.charAt(0));
                    break;
                }
                if (appo.charAt(0) != 'D') break;
                throw new DoubleRoomNotAvailableException();
            }
            case 'S': {
                p.resetCorsi();
                p.addCorso(this.nomeVillaggio, appo);
                break;
            }
            case 'C': {
                AgenziaSystem.archivio.removePrenotazione(p.getCognome(), this.appoNumWeek, this.nomeVillaggio);
                if (this.toAddInQueue) {
                    AgenziaSystem.archivio.getPacchetto(this.nomeVillaggio).getSettimana(p.getNumeroSett()).addInAttesa(p.getCognome());
                    this.toAddInQueue = false;
                    break;
                }
                AgenziaSystem.archivio.addPrenotazione(p, this.nomeVillaggio);
            }
        }
        return true;
    }

    @Override
    public void addInQueue(boolean addInQueue) {
        this.toAddInQueue = addInQueue;
    }

    @Override
    public boolean modPrenotation(Prenotation p, String modifiche) throws DoubleRoomNotAvailableException {
        if (p instanceof PrenotazioneVolo) {
            PrenotazioneVolo prenV = (PrenotazioneVolo)p;
            return this.modPrenVolo(prenV, modifiche);
        }
        if (p instanceof Prenotazione) {
            Prenotazione pren = (Prenotazione)p;
            return this.modPrenPach(pren, modifiche);
        }
        return false;
    }

    @Override
    public boolean isRegistered(Cliente c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return AgenziaSystem.archivio.getClienti().contains(c);
    }

    public boolean hasGotPrenotation(Cliente c) {
        if (c == null) {
            throw new NullPointerException();
        }
        for (Prenotation<E> p : this.prenotation) {
            if (!p.isPresentClient(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Prenotation<E>> showList(Cliente c) {
        SetArray<Prenotation<Prenotation<E>>> prenCliente = new SetArray<Prenotation<Prenotation<E>>>();
        if (c == null) {
            throw new NullPointerException();
        }
        for (Prenotation<E> p : this.prenotation) {
            Prenotazioni prenp;
            if (p instanceof PrenotazioneVolo) {
                PrenotazioneVolo prenv = (PrenotazioneVolo)p;
                if (!prenv.getCognome().equals(c.getCognome())) continue;
                prenCliente.add(p);
                continue;
            }
            if (!(p instanceof Prenotazioni) || !(prenp = (Prenotazioni)p).isPresentClient(c)) continue;
            Prenotazioni appoPren = new Prenotazioni(prenp.getNomeVillaggio());
            for (Prenotazione x : prenp.getElenco()) {
                if (!x.getCognome().equals(c.getCognome())) continue;
                appoPren.add(x);
            }
            prenCliente.add(appoPren);
        }
        return prenCliente;
    }
}

