/*
 * Decompiled with CFR 0.152.
 */
package archive.system;

import archive.data.Carta;
import archive.data.Cliente;
import archive.data.Pacchetto;
import archive.data.Prenotazione;
import archive.data.Settimana;
import archive.interfacce.RichiestaPrenotazionePacchetto;
import archive.system.AgenziaSystem;
import archive.utility.RequestInfo;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PRequestPacchettoManager
extends RequestInfo
implements RichiestaPrenotazionePacchetto {
    private final char doppia = (char)68;
    private final char suite = (char)83;
    private int freeD = 0;
    private int freeS = 0;
    private String nomeVillaggio = "";

    @Override
    public String[] showList() {
        Set<Pacchetto> pacchetti = AgenziaSystem.archivio.getPacchetti();
        String[] s = new String[pacchetti.size()];
        int i = 0;
        for (Pacchetto p : pacchetti) {
            s[i] = p.getNome();
            ++i;
        }
        return s;
    }

    private void setNomeVillaggio(String nome) {
        this.nomeVillaggio = nome;
    }

    @Override
    public String[] showDetails(String nome, int sett) {
        this.setNomeVillaggio(nome);
        String[] s = new String[3];
        Pacchetto p = AgenziaSystem.archivio.getPacchetto(nome);
        s[0] = p.getNome();
        s[1] = p.getIndirizzo();
        String[] recapiti = p.getRecapiti();
        s = Arrays.copyOf(s, s.length + recapiti.length + 1);
        for (int i = 2; i < s.length - 2; ++i) {
            s[i] = recapiti[i - 2];
        }
        this.isAvaible(sett, nome);
        s[s.length - 2] = "Numero doppie disponibili: " + this.freeD;
        s[s.length - 1] = "Numero suite disponibili: " + this.freeS;
        return s;
    }

    private int countPrenRoom(Set<Prenotazione> sP, char c) {
        int x = 0;
        for (Prenotazione p : sP) {
            if (p.getTipo() != c) continue;
            ++x;
        }
        return x;
    }

    private boolean avaibility(int sett, String nome) {
        Pacchetto p = AgenziaSystem.archivio.getPacchetto(nome);
        if (p == null) {
            throw new NoSuchElementException();
        }
        Settimana s = p.getSettimana(sett);
        Set<Prenotazione> sP = AgenziaSystem.archivio.getOnePrenotazioni(nome).getPrenotazioniWeek(sett);
        int nPrenSuite = this.countPrenRoom(sP, 'S');
        int nPrenDoppia = this.countPrenRoom(sP, 'D');
        if (s.getNSD() > nPrenDoppia || s.getNSU() > nPrenSuite) {
            this.freeD = s.getNSD() - nPrenDoppia;
            this.freeS = s.getNSU() - nPrenSuite;
            return true;
        }
        this.freeD = 0;
        this.freeS = 0;
        return false;
    }

    @Override
    public boolean isAvaible(int sett, String nome) {
        if (AgenziaSystem.day.compareTo(sett) <= 0) {
            throw new IllegalArgumentException();
        }
        return this.avaibility(sett, nome);
    }

    @Override
    public boolean anyWeekAvaible(int sett, String nome) {
        return this.avaibility(sett, nome);
    }

    @Override
    public boolean addInListaAttesa(int n, String cognome) {
        return AgenziaSystem.archivio.getPacchetto(this.nomeVillaggio).getSettimana(n).addInAttesa(cognome);
    }

    @Override
    public boolean doPrenotation(int ns, String c, String n, String t, Carta carta, String tipo, String corsi) {
        switch (tipo.charAt(0)) {
            case 'D': {
                if (this.freeD <= 0) {
                    throw new NoSuchElementException();
                }
            }
            case 'S': {
                if (this.freeS > 0) break;
                return false;
            }
        }
        Cliente client = this.requestInformation(c, n, t, carta);
        if (AgenziaSystem.archivio.hasGotPrenotation(client, ns)) {
            return false;
        }
        Prenotazione newPren = new Prenotazione(ns, client.getCognome(), client.getNome());
        newPren.addTipo(tipo);
        newPren.addCorso(this.nomeVillaggio, corsi);
        AgenziaSystem.archivio.addPrenotazione(newPren, this.nomeVillaggio);
        return true;
    }

    @Override
    public int getFreeRoom(char tipo) {
        switch (tipo) {
            case 'D': {
                return this.freeD;
            }
            case 'S': {
                return this.freeS;
            }
        }
        return 0;
    }
}

