/*
 * Decompiled with CFR 0.152.
 */
package archive.system;

import archive.data.Archivio;
import archive.data.Pacchetto;
import archive.data.PrenotazioneVolo;
import archive.data.Prenotazioni;
import archive.interfacce.FileExport;
import archive.system.AgenziaSystem;
import archive.utility.ClientMaker;
import archive.utility.PacchettoMaker;
import archive.utility.PrenVoloMaker;
import archive.utility.PrenotazioniMaker;
import archive.utility.StringConverter;
import archive.utility.StringInverter;
import archive.utility.VoloMaker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Scanner;
import java.util.Set;

public class FileSystem
implements FileExport {
    private File fileSource;
    private Scanner fileScanner;
    private PrintStream wFile;

    public FileSystem() {
    }

    public FileSystem(String path) throws FileNotFoundException {
        this.fileSource = new File(path);
        this.fileScanner = new Scanner(this.fileSource);
    }

    private void rewind() throws FileNotFoundException {
        this.fileScanner.close();
        this.fileScanner = new Scanner(this.fileSource);
    }

    private void switchState(String state, String s, Archivio archivio) {
        StringConverter or = null;
        if (state.equals("PACCHETTO")) {
            or = new PacchettoMaker(archivio);
        } else if (state.equals("CLIENTI")) {
            or = new ClientMaker(archivio);
        } else if (state.equals("PRENOTAZIONI")) {
            or = new PrenotazioniMaker(archivio);
        } else if (state.equals("VOLI")) {
            or = new VoloMaker(archivio);
        } else if (state.equals("PREN VOLI")) {
            or = new PrenVoloMaker(archivio);
        }
        if (or == null) {
            throw new NullPointerException();
        }
        or.split(s);
        or.create();
    }

    public Archivio read() throws FileNotFoundException {
        Archivio archivio = new Archivio();
        this.rewind();
        String state = "PACCHETTO";
        String s = "";
        while (this.fileScanner.hasNextLine()) {
            String appo = this.fileScanner.nextLine();
            if (appo.equals("PACCHETTO")) {
                if (appo.equals("")) {
                    s = s + "\n";
                }
                this.switchState(state, s, archivio);
                s = "";
                state = appo;
                continue;
            }
            if (appo.equals("CLIENTI")) {
                this.switchState(state, s, archivio);
                s = "";
                state = appo;
                continue;
            }
            if (appo.equals("PRENOTAZIONI")) {
                this.switchState(state, s, archivio);
                s = "";
                state = appo;
                continue;
            }
            if (appo.equals("VOLI")) {
                this.switchState(state, s, archivio);
                s = "";
                state = appo;
                continue;
            }
            if (appo.equals("PREN VOLI")) {
                this.switchState(state, s, archivio);
                s = "";
                state = appo;
                continue;
            }
            s = s + appo + "\n";
        }
        if (state.equals("PREN VOLI")) {
            this.switchState(state, s, archivio);
            s = "";
        }
        this.fileScanner.close();
        return archivio;
    }

    private void writeln(String[] s) {
        if (this.wFile == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < s.length; ++i) {
            this.wFile.println(s[i]);
        }
    }

    public void write(String path) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(path, false);
        this.wFile = new PrintStream(fos, true);
        StringInverter<Object> ow = new StringInverter<Object>();
        for (Pacchetto pacchetto : AgenziaSystem.archivio.getPacchetti()) {
            this.wFile.println("PACCHETTO");
            String[] s = ow.split(pacchetto.toString());
            if (s.length == 106) {
                s = Arrays.copyOf(s, 107);
                s[106] = "";
            }
            this.writeln(s);
        }
        this.wFile.println("CLIENTI");
        ow = new StringInverter();
        this.writeln(ow.split(ow.merge(AgenziaSystem.archivio.getClienti())));
        ow = new StringInverter();
        for (Prenotazioni prenotazioni : AgenziaSystem.archivio.getPrenotazioni()) {
            this.wFile.println("PRENOTAZIONI");
            this.writeln(ow.split(prenotazioni.toString()));
        }
        this.wFile.println("VOLI");
        ow = new StringInverter();
        this.writeln(ow.split(ow.merge(AgenziaSystem.archivio.getVoli())));
        this.wFile.println("PREN VOLI");
        ow = new StringInverter();
        this.writeln(ow.split(ow.merge(AgenziaSystem.archivio.getPrenVoli())));
        this.wFile.close();
    }

    public void exportPrenPacchetti(String path) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(path, false);
        this.wFile = new PrintStream(fos, true);
        StringInverter ow = new StringInverter();
        Set<Prenotazioni> setPren = AgenziaSystem.archivio.getPrenotazioni();
        for (Prenotazioni x : setPren) {
            this.wFile.println(x.getNomeVillaggio());
            Object[] arrayP = x.getElenco().toArray();
            Arrays.sort(arrayP);
            for (int i = 0; i < arrayP.length; ++i) {
                this.wFile.println(arrayP[i].toString());
            }
        }
    }

    public void exportPrenVoli(String path) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(path, false);
        this.wFile = new PrintStream(fos, true);
        StringInverter<PrenotazioneVolo> ow = new StringInverter<PrenotazioneVolo>();
        this.wFile.println("PREN VOLI");
        ow = new StringInverter();
        this.writeln(ow.split(ow.merge(AgenziaSystem.archivio.getPrenVoli())));
        this.wFile.close();
    }
}

