/*
 * Decompiled with CFR 0.152.
 */
package archive.data;

import archive.data.Cliente;
import archive.data.Prenotazione;
import archive.system.AgenziaSystem;
import archive.utility.AbstractPrenotation;
import archive.utility.SetArray;
import archive.utility.StringInverter;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Prenotazioni
extends AbstractPrenotation {
    private String nomeVillaggio;
    private Set<Prenotazione> elenco = new SetArray<Prenotazione>();

    public Prenotazioni(String nome) {
        this.nomeVillaggio = nome;
    }

    public boolean add(Prenotazione p) {
        if (AgenziaSystem.day.compareTo(p.getNumeroSett()) >= 0) {
            return this.elenco.add(p);
        }
        return false;
    }

    public boolean remove(String cognome, int numWeek) {
        if (cognome == null || numWeek < 1 || numWeek > 52) {
            throw new IllegalArgumentException();
        }
        for (Prenotazione x : this.elenco) {
            if (x == null || !cognome.equals(x.getCognome()) || numWeek != x.getNumeroSett()) continue;
            this.elenco.remove(x);
            return true;
        }
        return false;
    }

    public boolean remove(Prenotazione p) {
        return this.elenco.remove(p);
    }

    public String getNomeVillaggio() {
        return this.nomeVillaggio;
    }

    public Set<Prenotazione> getElenco() {
        return this.elenco;
    }

    public Prenotazione getPrenotazione(String cognome, int numWeek) {
        if (cognome == null || numWeek < 1 || numWeek > 52) {
            throw new IllegalArgumentException();
        }
        for (Prenotazione x : this.elenco) {
            if (x == null || !cognome.equals(x.getCognome()) || numWeek != x.getNumeroSett()) continue;
            return x;
        }
        return null;
    }

    public Set<Prenotazione> getPrenotazioniWeek(int numWeek) {
        if (numWeek < 1 || numWeek > 52) {
            throw new IllegalArgumentException();
        }
        SetArray<Prenotazione> sP = new SetArray<Prenotazione>();
        for (Prenotazione x : this.elenco) {
            if (x == null || numWeek != x.getNumeroSett()) continue;
            sP.add(x);
        }
        return sP;
    }

    public String toString() {
        StringInverter<Prenotazione> ow = new StringInverter<Prenotazione>();
        return this.nomeVillaggio + "\n" + ow.merge(this.elenco);
    }

    @Override
    public boolean isPresentClient(Cliente c) {
        for (Prenotazione x : this.elenco) {
            if (!x.getCognome().equals(c.getCognome())) continue;
            return true;
        }
        return false;
    }

    public boolean isPresentClient(Cliente c, int n) {
        for (Prenotazione x : this.elenco) {
            if (!x.getCognome().equals(c.getCognome()) || x.getNumeroSett() != n) continue;
            return true;
        }
        return false;
    }
}

