// █ ▀ █▀▄▀█   █▄░█ █▀█ ▀█▀   █░█ █▀▀ █▀█ █▀▀   ▀█▀ █▀█   █░█ ▄▀█ █░█░█ █▄▀ ░
// █ ░ █░▀░█   █░▀█ █▄█ ░█░   █▀█ ██▄ █▀▄ ██▄   ░█░ █▄█   █▀█ █▀█ ▀▄▀▄▀ █░█ █

// █ ▀ █▀▄▀█   █░█ █▀▀ █▀█ █▀▀   ▀█▀ █▀█   █▀ █▀█ ▄▀█ █▀█ █▄▀   █▀▄ █▀▀ █░░ █ █▀▀ █░█ ▀█▀ ░
// █ ░ █░▀░█   █▀█ ██▄ █▀▄ ██▄   ░█░ █▄█   ▄█ █▀▀ █▀█ █▀▄ █░█   █▄▀ ██▄ █▄▄ █ █▄█ █▀█ ░█░ █

// █▀▄▀█ █▄█   █▀█ ▄▀█ █▄█ █▀▄▀█ █▀▀ █▄░█ ▀█▀ ▀ █▀   █▀█ █▀▀ █▀▀ █▀▀ █ █░█ █▀▀ █▀▄ ░
// █░▀░█ ░█░   █▀▀ █▀█ ░█░ █░▀░█ ██▄ █░▀█ ░█░ ░ ▄█   █▀▄ ██▄ █▄▄ ██▄ █ ▀▄▀ ██▄ █▄▀ █

// █▄░█ █▀█ █░█░█   █░█░█ █▀█ █▀█ █▄▀ █ █▄░█ █▀▀   ▀█▀ █░█ █▀█ █▀█ █░█ █▀▀ █░█   ▀█▀ █░█ █▀▀   █▄░█ █ █▀▀ █░█ ▀█▀ ░
// █░▀█ █▄█ ▀▄▀▄▀   ▀▄▀▄▀ █▄█ █▀▄ █░█ █ █░▀█ █▄█   ░█░ █▀█ █▀▄ █▄█ █▄█ █▄█ █▀█   ░█░ █▀█ ██▄   █░▀█ █ █▄█ █▀█ ░█░ ▄

// ▄▀█   █▄▄ █░█ █▄▄ █▄▄ █░░ █▀▀   █▀█ █▀▀   ░░█ █▀█ █▄█   █▀▀ █░░ █▀█ ▄▀█ ▀█▀ █ █▄░█ █▀▀   █▀█ █▄░█   █░█░█ ▄▀█ █░█ █▀▀ █▀
// █▀█   █▄█ █▄█ █▄█ █▄█ █▄▄ ██▄   █▄█ █▀░   █▄█ █▄█ ░█░   █▀░ █▄▄ █▄█ █▀█ ░█░ █ █░▀█ █▄█   █▄█ █░▀█   ▀▄▀▄▀ █▀█ ▀▄▀ ██▄ ▄█

// █▀█ █▀▀   █▀▄▀█ █▀▀ █▀█ █▀█ █ █▀▄▀█ █▀▀ █▄░█ ▀█▀ ░
// █▄█ █▀░   █░▀░█ ██▄ █▀▄ █▀▄ █ █░▀░█ ██▄ █░▀█ ░█░ █

// █ █▄░█   ▀█▀ █░█ █ █▀   █▀ █▀▀ ▄▀█   █▀█ █▀▀   █░█ ▄▀█ █▀█ █▀█ █ █▄░█ █▀▀ █▀ █▀ ░
// █ █░▀█   ░█░ █▀█ █ ▄█   ▄█ ██▄ █▀█   █▄█ █▀░   █▀█ █▀█ █▀▀ █▀▀ █ █░▀█ ██▄ ▄█ ▄█ █

// █▀▄▀█ █▄█   ▄▀█ █▀█ ▀█▀   █ █▀   █▀▀ █░█ █ █▀▄ █▀▀ █▄░█ ▀█▀ ░
// █░▀░█ ░█░   █▀█ █▀▄ ░█░   █ ▄█   ██▄ ▀▄▀ █ █▄▀ ██▄ █░▀█ ░█░ ▄


/*

███████╗██╗░░░██╗███████╗███╗░░██╗████████╗░██████╗    ░█████╗░██╗░░██╗░█████╗░██████╗░████████╗  
██╔════╝██║░░░██║██╔════╝████╗░██║╚══██╔══╝██╔════╝    ██╔══██╗██║░░██║██╔══██╗██╔══██╗╚══██╔══╝  
█████╗░░╚██╗░██╔╝█████╗░░██╔██╗██║░░░██║░░░╚█████╗░    ██║░░╚═╝███████║███████║██████╔╝░░░██║░░░  
██╔══╝░░░╚████╔╝░██╔══╝░░██║╚████║░░░██║░░░░╚═══██╗    ██║░░██╗██╔══██║██╔══██║██╔══██╗░░░██║░░░  
███████╗░░╚██╔╝░░███████╗██║░╚███║░░░██║░░░██████╔╝    ╚█████╔╝██║░░██║██║░░██║██║░░██║░░░██║░░░  
╚══════╝░░░╚═╝░░░╚══════╝╚═╝░░╚══╝░░░╚═╝░░░╚═════╝░    ░╚════╝░╚═╝░░╚═╝╚═╝░░╚═╝╚═╝░░╚═╝░░░╚═╝░░░  

░░░░░██╗░██████╗    ░█████╗░███╗░░██╗██╗███╗░░░███╗░█████╗░████████╗░█████╗░██████╗░
░░░░░██║██╔════╝    ██╔══██╗████╗░██║██║████╗░████║██╔══██╗╚══██╔══╝██╔══██╗██╔══██╗
░░░░░██║╚█████╗░    ███████║██╔██╗██║██║██╔████╔██║███████║░░░██║░░░██║░░██║██████╔╝
██╗░░██║░╚═══██╗    ██╔══██║██║╚████║██║██║╚██╔╝██║██╔══██║░░░██║░░░██║░░██║██╔══██╗
╚█████╔╝██████╔╝    ██║░░██║██║░╚███║██║██║░╚═╝░██║██║░░██║░░░██║░░░╚█████╔╝██║░░██║
░╚════╝░╚═════╝░    ╚═╝░░╚═╝╚═╝░░╚══╝╚═╝╚═╝░░░░░╚═╝╚═╝░░╚═╝░░░╚═╝░░░░╚════╝░╚═╝░░╚═╝

*/
//Single place for all code related to animating Events Chart SVG, used by light & full viewer

class ID {
    static CursorLineLegendTemplate = `#CursorLineLegendTemplate`;
    static TimeRowLegendTemplate = `#TimeRowLegendTemplate`;
    static CursorLineLegendCloneCls = ".CursorLineLegendClone";
    static LifeEventNameLabelCls = ".name-label";
    static LifeEventVerticalLineCls = ".vertical-line";
    static LifeEventDescriptionLabelCls = ".description-label";
    static CursorLineLegendDescriptionHolder = "#CursorLineLegendDescriptionHolder";
    static EventChartHolder = ".EventChartHolder"; //main chart SVG element, used class since ID is unique number
    static EventsChartSvgHolder = "#EventsChartSvgHolder"; //default expected parent in page to inject chart into
    static CursorLine = '#CursorLine';
    static CursorLineLegendClone = "CursorLineLegendClone";
    static CursorLineLegendHolder = "#CursorLineLegendHolder";
    static CursorLineSumIcon = "#CursorLineSumIcon";
    static NowVerticalLine = '#NowVerticalLine';
    static EventListHolder = ".EventListHolder";
    static CursorLineClockIcon = "#CursorLineClockIcon";
    static CursorLineLegendDescription = "#CursorLineLegendDescription";
    static CursorLineLegendDescriptionBackground = "#CursorLineLegendDescriptionBackground";
}

//this class is a living version SVG Events Chart
//DESIGN NOTE: no logic to generate chart should be here
//all generation via URL or API is to be done as separate helper functions only
class EventsChart {
    //note: these are color codes used to
    //detect if event is good or bad
    static BadColor = "#FF0000";
    static GoodColor = "#00FF00";

    //row height used to legend row
    static RowHeight = 15;

    constructor(chartId) {

        //use chart ID find the element on page
        //note: we make sure here that only the elements inside this specific SVG chart will be manipulated
        this.$EventsChartSvgHolder = $(ID.EventsChartSvgHolder);
        this.$SvgChartElm = $(`#${chartId}`);
        this.Id = chartId;
        this.$CursorLine = this.$SvgChartElm.find(ID.CursorLine);
        this.$LifeEventNameLabel = this.$SvgChartElm.find(ID.LifeEventNameLabelCls);
        this.$NowVerticalLine = this.$SvgChartElm.find(ID.NowVerticalLine); //save now line
        this.AllEventRects = this.$SvgChartElm.find(ID.EventListHolder).children("rect");
        this.$CursorLineLegendDescriptionHolder = this.$SvgChartElm.find(ID.CursorLineLegendDescriptionHolder);
        this.$CursorLineLegendTemplate = this.$SvgChartElm.find(ID.CursorLineLegendTemplate);
        this.$TimeRowLegendTemplate = this.$SvgChartElm.find(ID.TimeRowLegendTemplate);
        this.$CursorLineLegendDescription = this.$SvgChartElm.find(ID.CursorLineLegendDescription);
        this.$CursorLineLegendDescriptionBackground = this.$SvgChartElm.find(ID.CursorLineLegendDescriptionBackground);
        this.$CursorLineLegendDescriptionHolder = this.$SvgChartElm.find(ID.CursorLineLegendDescriptionHolder);
        this.DescText = { xAxis: 175, yAxis: 24 }; //used to position desc box cursor legend
        this.$CursorLineLegendHolder = this.$SvgChartElm.find(ID.CursorLineLegendHolder);

        //bring to life
        this.attachEventHandlers();

        //add chart to public list of charts after brought to live
        //create new if 1st chart on page
        window.EventsChartLoaded = this;
        if (typeof window.EventsChartList === 'undefined') { window.EventsChartList = []; }
        window.EventsChartList.push(this);

        //return index of last row pushed
        return window.EventsChartList.length - 1;
    }

    //------------------------------------------------------------------------

    attachEventHandlers() {
        console.log("Attaching events to chart...");

        //1 TIME LEGEND
        //we pump the current EventChart instance into handler
        this.$SvgChartElm.mousemove((mouse) => EventsChart.onMouseMoveHandler(mouse, this));
        this.$SvgChartElm.mouseleave((mouse) => EventsChart.onMouseLeaveEventChart(mouse, this));

        //2 NOW LINE
        //update once now
        EventsChart.updateNowLine(this);

        //setup to auto update every 1 minute
        setInterval(() => EventsChart.updateNowLine(this), 60 * 1000); // 60 seconds

        //3 HIGHLIGHT LIFE EVENT
        this.$LifeEventNameLabel.mouseenter((mouse) => EventsChart.onMouseEnterLifeEventHandler(mouse, this));
        this.$LifeEventNameLabel.mouseleave((mouse) => EventsChart.onMouseLeaveLifeEventHandler(mouse, this));

    }

    //on click add events to google calendar,
    //ask user to select event and take from there
    AddEventsToGoogleCalendar() {
        console.log("Adding events to Google Calendar");

        //tell user to select an event
        Swal.fire({
            title: 'Select an event',
            text: 'The selected event will be sent to your Google Calendar',
            icon: 'info',
            confirmButtonText: 'OK'
        });

        //attach one time trigger to catch the event user clicked on
        $(".EventChartContent").one("click", (eventData) => EventsChart.onClickSelectedGoogleCalendarEvent(eventData, this));

    }

    //highlights all events rects in chart by
    //the inputed keyword in the event name
    highlightByEventName(keyword) {

        //find all rects representing the keyword based event
        //note keyword will be planet name or house name
        this.AllEventRects.each(function (index) {
            //get parsed time from rect
            var svgEventRect = this;
            var eventName = svgEventRect.getAttribute("eventname");
            //check if event name contains keyword
            var foundEvent = eventName.toLowerCase().includes(keyword.toLowerCase());

            //if event is related to planet, highlight the rect
            if (foundEvent) {

                //save original color for later return
                var oriColor = svgEventRect.getAttribute("fill");
                svgEventRect.setAttribute("fillORI", oriColor);

                //set new highlight color
                var highlightColor = EventsChart.getHighlightColor(keyword);
                svgEventRect.setAttribute("fill", highlightColor);
            }

        });

    }

    unhighlightByEventName(keyword) {

        //find all rects representing the keyword based event
        this.AllEventRects.each(function (index) {
            //get parsed time from rect
            var svgEventRect = this;
            var eventName = svgEventRect.getAttribute("eventname");
            //check if event name contains keyword
            var foundEvent = eventName.toLowerCase().includes(keyword.toLowerCase());

            //if event is related to planet, highlight the rect
            if (foundEvent) {

                //save original color for later return
                var oriColor = svgEventRect.getAttribute("fillORI");

                //ori will be null if never highlighted before
                oriColor = oriColor === null ? svgEventRect.getAttribute("fill") : oriColor;

                //set original color if changed, else same color
                svgEventRect.setAttribute("fill", oriColor);
            }

        });

    }

    //-----------------------------STATIC----------------------------------------

    //for highlighting events by name
    static getHighlightColor(keyword) {

        switch (keyword.toLowerCase()) {
            //planets
            case "sun": return "#FFA500";  //orange #FFA500
            case "moon": return "#7A7A7A"; //silver #7A7A7A
            case "mars": return "#DC143C"; //crimson #DC143C
            case "mercury": return "#00FF7F"; //springgreen #00FF7F
            case "jupiter": return "#EEEE00"; //yellow #EEEE00
            case "venus": return "#FF00FF";//magenta #FF00FF
            case "saturn": return "#0000FF";//blue #0000FF
            case "rahu": return "#FF7D40"; //flesh #FF7D40
            case "ketu": return "#515151"; //grey #515151

            //house
            //colors is the full spectrum divided into 12
            //done to have the most unique colors possible for each house
            case "house 1": return "#ff0000"; //red
            case "house 2": return "#ff7f0a"; //orange
            case "house 3": return "#ffff00"; //yellow
            case "house 4": return "#7fff00"; //chartreuse green
            case "house 5": return "#00ff00"; //green
            case "house 6": return "#00ff7f"; //spring green
            case "house 7": return "#00ffff"; //cyan
            case "house 8": return "#007fff"; //azure
            case "house 9": return "#0000ff"; //blue
            case "house 10": return "#7f00ff";//violet
            case "house 11": return "#ff00ff";//magenta
            case "house 12": return "#ff007f";//rose

        }

        //default to black so we know it was not accounted for
        return "#000000";

        //    var arrayValues = ["#ff60fa", "#ff60fa", "#ff60fa"];

        //    var arrayMax = arrayValues.length - 1;
        //    var randomIndex = Math.floor(Math.random() * arrayMax);

        //    return arrayValues[randomIndex];
    }

    //update now line position
    static updateNowLine(instance) {
        console.log("Updating now line position...");

        //store closes rect to now time
        var closestRectToNow;

        //find closest rect to now time
        instance.AllEventRects.each((index, element) => findClosest(element));

        //get horizontal position of now rect (x axis) (conditional access, not initialized all the time)
        var xAxisNowRect = closestRectToNow?.getAttribute("x");

        //only set line position if, data is valid
        if (xAxisNowRect) { instance.$NowVerticalLine.attr('transform', `matrix(1, 0, 0, 1, ${xAxisNowRect}, 0)`); }

        //----------------------------------LOCAL FUNK------------------------

        function findClosest(svgEventRect) {
            //get parsed time from rect
            var rectTime = getTimeInRect(svgEventRect).getTime();//(milliseconds since 1 Jan 1970)
            var nowTime = Date.now();

            //if not yet reach continue, keep reference to this and goto next
            if (rectTime <= nowTime) {
                closestRectToNow = svgEventRect;
                return true; //go next
            }
            //already passed now time, use previous rect as now, stop looking
            else { return false; }
        }

        //parses the STD time found in rect and returns it
        function getTimeInRect(eventRect$) {
            //convert "00:28 17/11/2022 +08:00" to "2019-01-01T00:00:00.000+00:00"
            var stdTimeRaw = eventRect$.getAttribute("stdtime");
            var stdTimeSplit = stdTimeRaw.split(" ");
            var hourMin = stdTimeSplit[0];
            var dateFull = stdTimeSplit[1].split('/');
            var date = dateFull[0];
            var month = dateFull[1];
            var year = dateFull[2];
            var timezone = stdTimeSplit[2];
            var rectTime = new Date(`${year}-${month}-${date}T${hourMin}:00.000${timezone}`);

            return rectTime;
        }
    }

    //on mouse leave event chart, auto hide time legend
    static onMouseLeaveEventChart(mouse, instance) { instance.$CursorLine.hide(); }

    //on mouse over life event name label, highlight event line
    static onMouseEnterLifeEventHandler(mouse, instance) {

        //get label that has mouse over it
        var targetElement = mouse.currentTarget;

        //find the main vertical line for life event
        var $parent = $(targetElement).parent();
        var $verticalLine = $parent.siblings(ID.LifeEventVerticalLineCls);

        //make wider
        $verticalLine.attr('width', '3');

        //highlight color
        $verticalLine.attr('fill', '#e502fa');

        //glow
        $verticalLine.css('filter', 'drop-shadow(0px 0px 1px rgb(255 0 0))');

        //make hidden description box visible (if any text)
        var $descBox = $parent.children(ID.LifeEventDescriptionLabelCls);
        if ($descBox.text().trim() !== '') { $descBox.show(); }

    }

    //on mouse leave life event name label, unhighlight event line
    static onMouseLeaveLifeEventHandler(mouse, instance) {

        //get label that has mouse over it
        var targetElement = mouse.currentTarget;

        //find the main vertical line for life event
        var $parent = $(targetElement).parent();
        var $verticalLine = $parent.siblings(ID.LifeEventVerticalLineCls);

        //set back normal line width
        $verticalLine.attr('width', '2');

        //set line color back to default
        $verticalLine.attr('fill', '#1E1EEA');

        //glow
        $verticalLine.css('filter', '');

        //hide description box if not major
        var $descBox = $parent.children(ID.LifeEventDescriptionLabelCls);
        var isNotMajor = $parent.parent()[0].getAttribute("eventweight") !== "Major";
        if (isNotMajor) { $descBox.hide(); }

    }

    //converts VedAstro date format to Google Calendar format
    static convertDateFormat(dateStr) {
        // Split the date and time parts
        // NOTE: location is ignored here
        let [timePart, datePart, zonePart] = dateStr.StdTime.split(' ');
        // Split the date into day, month, and year
        let [day, month, year] = datePart.split('/');
        // Combine the parts into a new date string and create a new Date object
        let dateObj = new Date(`${year}-${month}-${day}T${timePart}${zonePart}`);

        // TODO: Convert offset to timezone. This is not straightforward because multiple timezones can have the same offset.
        const timeZone = '';

        // Return the JSON object
        return {
            'dateTime': dateObj.toISOString(), // Return the date in ISO 8601 format
            'timeZone': timeZone
        };
    }

    //Gets a mouses x-axis relative inside the given element
    //used to get mouse location on SVG chart, zoom autocorrected 
    static getMousePositionInElement(mouseEventData, instance) {

        //get relative position of mouse in Dasa view
        //after zoom pixels on screen change, but when rendering
        //SVG description box we need x, y before zoom (AI's code!)
        var holder = instance.$EventsChartSvgHolder[0]; //zoom is done on main holder in Blazor side

        var mousePosition = {};
        if (holder != null) {
            var zoom = parseFloat(window.getComputedStyle(holder).zoom);
            mousePosition = {
                xAxis: mouseEventData.originalEvent.offsetX / zoom,
                yAxis: mouseEventData.originalEvent.offsetY / zoom
            };
        }
        //in svg direct browser we don't have DIV holder, so no zoom correction
        else {
            mousePosition = {
                xAxis: mouseEventData.originalEvent.offsetX,
                yAxis: mouseEventData.originalEvent.offsetY
            };
        }

        return mousePosition;
    }

    //called by trigger when clicked on event, after asking user to select
    //to here for adding events to google
    static async onClickSelectedGoogleCalendarEvent(eventObject, instance) {

        //get details on the selected event
        var targetRect = eventObject.target;

        //given the SVG rect that was clicked on, process and extract full event data
        var parsedEvent = (await EventsChart.ParseEventFromSVGRect(targetRect, instance))["EventStartEndTime"];

        //if no event found then possible wrongly clicked elm skip, END HERE
        if (parsedEvent?.Name !== undefined) {
            Swal.fire("Could not detect event", "", "warning");
            return;
        }

        //ask user if selected event is correct and want to continue to google login
        var userReply = await Swal.fire({
            title: 'Send event to Google?',
            html: '<ul class="list-group">' +
                `<li class="list-group-item">Name : <strong>${parsedEvent.Name}</strong></li>` +
                `<li class="list-group-item">Start : <strong>${parsedEvent.StartTime.StdTime}</strong></li>` +
                `<li class="list-group-item">End : <strong>${parsedEvent.EndTime.StdTime}</strong></li>` +
                '</ul>',
            icon: 'info',
            iconHtml: '<span class="iconify" data-icon="fluent:calendar-add-20-regular" data-inline="false"></span>',
            showCancelButton: true,
            confirmButtonText: 'Yes',
            cancelButtonText: 'No',
        });

        //based on what user clicked process
        if (userReply.isConfirmed) {
            // User clicked 'Yes', continue to Google login page
            EventsChart.SelectAccountAndAddEvent(parsedEvent);
        } else {
            // User clicked 'No', end silently
            console.log('User clicked No on sending to Google');
        }
    }

    //given an SVG rect of an event, extract event data from it, with start and end time (use API)
    static async ParseEventFromSVGRect(targetRect, instance) {

        //prepare the URL
        var domain = "https://vedastroapi.azurewebsites.net/api";

        //get birth time from main svg element
        var birthTimeAry = instance.$SvgChartElm[0].getAttribute("birthtime").split(" ");
        var birthLocationTxt = instance.$SvgChartElm[0].getAttribute("birthlocation");
        var birthTime = `/Location/${birthLocationTxt}/Time/${birthTimeAry[0]}/${birthTimeAry[1]}/${birthTimeAry[2]}`;

        //get check time & event name from clicked rect,
        //start and end time should be before and after from this
        var checkTimeAry = targetRect.getAttribute("stdtime").split(" ");
        //TODO Location set based on where user is
        var checkTime = `/Location/${birthLocationTxt.replace(/\s/g, "")}/Time/${checkTimeAry[0]}/${checkTimeAry[1]}/${checkTimeAry[2]}`;

        //get name of event
        var withSpaces = targetRect.getAttribute("eventname");
        var eventName = `/EventName/${withSpaces.replace(/\s/g, "")}`; //remove spaces

        //put together final API call URL
        var finalUrl = `${domain}/Calculate/EventStartEndTime${birthTime}${checkTime}${eventName}`;

        //make call to API, replies JSON of Event
        var eventDataAtTime = await EventsChart.GetAPIPayload(finalUrl);

        return eventDataAtTime;
    }

    //given a vedastro API url, will auto call via POST or GET
    //and return only passed payloads as JSON
    static async GetAPIPayload(url, payload = null) {
        try {
            // If a payload is provided, prepare options for a POST request
            const options = payload
                ? {
                    method: 'POST', // Specify the HTTP method as POST
                    headers: { 'Content-Type': 'application/json' }, // Set the content type of the request to JSON
                    body: JSON.stringify(payload), // Convert the payload to a JSON string and include it in the body of the request
                }
                : {}; // If no payload is provided, create an empty options object, which defaults to a GET request

            // Send the request to the specified URL with the prepared options
            const response = await fetch(url, options);

            // If the response is not ok (status is not in the range 200-299), throw an error
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }

            // Parse the response body as JSON
            const data = await response.json();

            // If the 'Status' property of the parsed data is not 'Pass', throw an error
            if (data.Status !== "Pass") {
                throw new Error(data.Payload);
            }

            // If everything is ok, return the 'Payload' property of the parsed data
            return data.Payload;
        } catch (error) {
            // If an error is caught, display an error message using Swal.fire
            Swal.fire({
                icon: 'error',
                title: 'App Crash!',
                text: error,
                confirmButtonText: 'OK'
            });
        }
    }


    static addEventToGoogleCalendar(parsedEvent) {

        //show event that was selected
        console.log(`EventSelected: ${parsedEvent.Name}`);

        //convert to format supported by Google Calendar
        var parsedStartTime = EventsChart.convertDateFormat(parsedEvent.StartTime);
        var parsedEndTime = EventsChart.convertDateFormat(parsedEvent.EndTime);

        const event = {
            'summary': parsedEvent.Name,
            //'location': '',
            'description': parsedEvent.Description,
            'start': parsedStartTime,
            'end': parsedEndTime,
            //'recurrence': [
            //    'RRULE:FREQ=DAILY;COUNT=2'
            //],
            //'attendees': [
            //    { 'email': 'lpage@example.com' },
            //    { 'email': 'sbrin@example.com' }
            //],
            'reminders': {
                'useDefault': false,
                'overrides': [
                    { 'method': 'email', 'minutes': 24 * 60 },
                    { 'method': 'popup', 'minutes': 10 }
                ]
            }
        };

        const request = window.gapi.client.calendar.events.insert({
            'calendarId': 'primary', //set default calendar todo future select calendar
            'resource': event
        });

        request.execute(function (event) {

            //STATE: events successfully created and updated to Google
            //tell user about it
            Swal.fire({
                title: 'Event added!',
                text: `Added ${event.summary}, view here ${event.htmlLink}`,
                icon: 'info',
                iconHtml: '<span class="iconify" data-icon="streamline:interface-calendar-check-approve-calendar-check-date-day-month-success" data-inline="false"></span>',
                showCloseButton: true,
                focusConfirm: false,
                confirmButtonText: 'Great!'
            });

        });
    }

    /**
       *  Sign in the user to select calendar account and then add event immediately
       */
    static SelectAccountAndAddEvent(parsedEvent) {

        window.tokenClient.callback = async (resp) => {
            if (resp.error !== undefined) {
                throw (resp);
            }

            //now already logged in continue to add events
            EventsChart.addEventToGoogleCalendar(parsedEvent);

        };

        if (window.gapi.client.getToken() === null) {
            // Prompt the user to select a Google Account and ask for consent to share their data
            // when establishing a new session.
            window.tokenClient.requestAccessToken({ prompt: 'consent' });
        } else {
            // Skip display of account chooser and consent dialog for an existing session.
            window.tokenClient.requestAccessToken({ prompt: '' });
        }
    }

    /**
      * Print the summary and start datetime/date of the next ten events in
      * the authorized user's calendar. If no events are found an
      * appropriate message is printed.
      */
    static async listUpcomingEvents() {
        let response;
        try {
            const request = {
                'calendarId': 'primary',
                'timeMin': (new Date()).toISOString(),
                'showDeleted': false,
                'singleEvents': true,
                'maxResults': 10,
                'orderBy': 'startTime',
            };
            response = await window.gapi.client.calendar.events.list(request);
        } catch (err) {
            document.getElementById('content').innerText = err.message;
            return;
        }

        const events = response.result.items;
        if (!events || events.length == 0) {
            console.log('No events found.');
            return;
        }
        // Flatten to string to display
        const output = events.reduce(
            (str, event) => `${str}${event.summary} (${event.start.dateTime || event.start.date})\n`,
            'Events:\n');
        console.log(output);
    }

    //fired when mouse moves over dasa view box
    //used to auto update cursor line & time legend
    static onMouseMoveHandler(mouse, instance) {

        //get relative position of mouse in Dasa view
        //after zoom pixels on screen change, but when rendering
        //SVG description box we need x, y before zoom (AI's code!)
        var mousePosition = EventsChart.getMousePositionInElement(mouse, instance); //todo no work in zoom

        //if cursor is out of chart view hide cursor and end here
        if (mousePosition === 0) { SVG(instance.$CursorLine[0]).hide(); return; }
        else { SVG(instance.$CursorLine[0]).show(); }

        //move cursor line 1st for responsiveness
        autoMoveCursorLine(mousePosition.xAxis);

        //update time legend
        generateTimeLegend(mousePosition);


        //-------------------------LOCAL FUNCS--------------------------


        function autoMoveCursorLine(relativeMouseX) {
            //give a tiny delay so user can aim better at event
            setTimeout(() => { }, 157);

            //move vertical line to under mouse inside dasa view box
            instance.$CursorLine.attr('transform', `matrix(1, 0, 0, 1, ${relativeMouseX}, 0)`);
        }

        //SVG Event Chart Time Legend generator
        //this is where the whole time legend that follows
        //the mouse when placed on chart is generated
        //notes: a template row always exists in code,
        //in client JS side uses template to create the rows from cloning it
        //and modifying its prop as needed, as such any major edit needs to
        //be done in API code
        function generateTimeLegend(mousePosition) {

            // Round mouse position to match with axis values in rect
            const mouseRoundedX = Math.round(mousePosition.xAxis);
            const mouseRoundedY = Math.round(mousePosition.yAxis);

            // Get all event rects at the mouse's X position
            const allElementsAtX = instance.$SvgChartElm.children().find(`[x=${mouseRoundedX}]`);
            const allEventRectsAtX = getAllEventRectsAtX(allElementsAtX);

            // Remove previously generated legend rows
            removePreviousClones();

            //if no elements, don't create summary row, end here (note check only after remove)
            if (!(allEventRectsAtX.length > 0)) { return; }

            // Initialize counts for summary row
            let goodCount = 0;
            let badCount = 0;
            instance.showDescription = false; // Default description not shown

            // Extract event data and place it in legend
            allEventRectsAtX.forEach(element => drawEventRow(element, mouseRoundedY, allElementsAtX));

            // Show or hide description box based on mouse position
            toggleDescriptionBox();

            // Generate summary row at the bottom showing count of good & bad
            //generateSummaryRow(allEventRectsAtX, goodCount, badCount);


            //-----------------------------------------LOCAL FUNCS-------------------------------

            //code to draw one event row box
            function drawEventRow(svgEventRect, mouseRoundedY, allElementsAtX) {

                //STAGE 1
                //GET DATA
                //extract other data out of the rect
                var eventName = svgEventRect.getAttribute("eventname");
                //if no "eventname" exist, wrong elm skip it
                if (!eventName) { return; }

                var eventDescription = svgEventRect.getAttribute("eventdescription");
                var natureScore = svgEventRect.getAttribute("naturescore");
                var color = svgEventRect.getAttribute("fill");
                var newRowYAxis = parseInt(svgEventRect.getAttribute("y"));//parse as num, for calculation


                //STAGE 2
                //TIME & AGE LEGEND
                //create time legend at top only for first element
                if (allElementsAtX[0] === svgEventRect) { drawTimeAgeLegendRow(); }

                //STAGE 3
                //GENERATE EVENT ROW
                //make a copy of template for this event
                var newLegendRow = instance.$CursorLineLegendTemplate.clone();
                newLegendRow.removeAttr('id'); //remove the clone template id
                newLegendRow.addClass(ID.CursorLineLegendClone); //to delete it on next run
                newLegendRow.appendTo(instance.$CursorLineLegendHolder); //place new legend into special holder
                SVG(newLegendRow[0]).show();//make cloned visible
                //position the group holding the legend over the event row which the legend represents
                newLegendRow.attr('transform', `matrix(1, 0, 0, 1, 10, ${newRowYAxis - 2})`);//minus 2 for perfect alignment

                //#set data into view
                //nature score 
                var $natureScoreElm = newLegendRow.children(".nature-score"); //GET
                let numberOnly = Math.abs(parseInt(natureScore)); //remove "-" symbol
                $natureScoreElm[0].innerHTML = numberOnly;                   //SET

                //icon color
                var iconElm = newLegendRow.children(".icon-holder");//GET
                iconElm.attr("fill", color);                        //SET  

                //event name next to nature score
                var $eventNameElm = newLegendRow.children(".event-name");//GET
                $eventNameElm[0].innerHTML = eventName;                  //SET


                //STAGE 4
                //GENERATE DESCRIPTION ROW LOGIC
                //check if mouse in within row of this event (y-axis)
                var elementTopY = newRowYAxis;
                var elementBottomY = newRowYAxis + EventsChart.RowHeight;
                var mouseWithinRow = mouseRoundedY >= elementTopY && mouseRoundedY <= elementBottomY;
                //if event name is still the same then don't load description again
                var notSameEvent = instance.previousHoverEventName !== eventName;

                //STAGE 5
                //HIGHLIGHT ROW (BASED ON CURSOR)
                //if mouse is in event's row then highlight that row
                if (mouseWithinRow) {
                    //highlight event name row
                    var $backgroundElm = newLegendRow.children("rect");

                    $eventNameElm.attr('font-weight', '700');
                    $backgroundElm.attr("fill", "#0096FF"); //bright blue
                    $backgroundElm.attr("opacity", 1);//solid

                    //if mouse within show description box
                    instance.showDescription = true;
                }

                //if mouse within row AND the event has changed
                //then generate a new description
                //note: this is slow, so done only when absolutely needed
                if (mouseWithinRow && notSameEvent) {
                    //make holder visible
                    SVG(instance.$CursorLineLegendDescriptionHolder[0]).show();

                    //move holder next to event
                    var descBoxYAxis = newRowYAxis - 9;//minus 5 for perfect alignment with event name row
                    instance.$CursorLineLegendDescriptionHolder.attr("transform", `matrix(1, 0, 0, 1, 0, ${descBoxYAxis})`);

                    //note: using trigger to make it easy to skip multiple clogging events
                    //set event desc directly
                    drawDescriptionBox(eventDescription);

                    //update previous hover event
                    instance.previousHoverEventName = eventName;
                }

                //---------------------LOCAL---------------------------

                function drawDescriptionBox(eventDescRaw) {
                    //remove tabs and new line to make easy detection of empty string
                    let eventDesc = eventDescRaw.replace(/ {4}|[\t\n\r]/gm, '');

                    //if no description than hide box & end here
                    if (!eventDesc) { instance.$CursorLineLegendDescriptionHolder.hide(); return; }

                    //convert text to svg and place inside holder
                    var wrappedDescText = textToSvg(eventDesc, instance.DescText.xAxis, instance.DescText.yAxis);

                    instance.$CursorLineLegendDescription.empty(); //clear previous desc
                    $(wrappedDescText).appendTo(instance.$CursorLineLegendDescription); //add in new desc
                    //set height of desc box background
                    instance.$CursorLineLegendDescriptionBackground.attr("height", instance.EventDescriptionTextHeight + 20); //plus little for padding


                    //-------------------------------------LOCAL FUNCTIONS-------------------------------------------

                    //  This function attempts to create a new svg "text" element, chopping
                    //  it up into "tspan" pieces, if the text is too long
                    function textToSvg(caption, x, y) {
                        //svg "text" element to hold smaller text lines
                        var svgTextHolder = document.createElementNS('http://www.w3.org/2000/svg', 'text');
                        svgTextHolder.setAttributeNS(null, 'x', x);
                        svgTextHolder.setAttributeNS(null, 'y', y);
                        svgTextHolder.setAttributeNS(null, 'font-size', 10);
                        svgTextHolder.setAttributeNS(null, 'fill', '#FFF');
                        svgTextHolder.setAttributeNS(null, 'text-anchor', 'left');

                        //The following two variables can be passed as parameters
                        var maximumCharsPerLine = 30;
                        var lineHeight = 10;

                        var words = caption.split(" ");
                        var line = "";

                        //process text and create rows
                        var svgTSpan;
                        var lineCount = 0; //number of lines to calculate height
                        var tSpanTextNode;
                        for (var n = 0; n < words.length; n++) {
                            var testLine = line + words[n] + " ";
                            if (testLine.length > maximumCharsPerLine) {
                                //  Add a new <tspan> element
                                svgTSpan = document.createElementNS('http://www.w3.org/2000/svg', 'tspan');
                                svgTSpan.setAttributeNS(null, 'x', x);
                                svgTSpan.setAttributeNS(null, 'y', y);

                                tSpanTextNode = document.createTextNode(line);
                                svgTSpan.appendChild(tSpanTextNode);
                                svgTextHolder.appendChild(svgTSpan);

                                line = words[n] + " ";
                                y += lineHeight; //place next text row lower
                                lineCount++; //count a line
                            }
                            else {
                                line = testLine;
                            }
                        }

                        //calculate final height in px, save global to be accessed later
                        instance.EventDescriptionTextHeight = lineCount * lineHeight;

                        svgTSpan = document.createElementNS('http://www.w3.org/2000/svg', 'tspan');
                        svgTSpan.setAttributeNS(null, 'x', x);
                        svgTSpan.setAttributeNS(null, 'y', y);

                        tSpanTextNode = document.createTextNode(line);
                        svgTSpan.appendChild(tSpanTextNode);

                        svgTextHolder.appendChild(svgTSpan);

                        return svgTextHolder;
                    }

                }

                function drawTimeAgeLegendRow() {
                    //make a copy of the template
                    var newTimeLegend = instance.$TimeRowLegendTemplate.clone();

                    //modify the template with new data
                    newTimeLegend.removeAttr('id'); //remove the clone template id
                    newTimeLegend.addClass(ID.CursorLineLegendClone); //to delete it on next run
                    newTimeLegend.appendTo(instance.$CursorLineLegendHolder); //place new legend into special holder

                    //make cloned visible
                    SVG(newTimeLegend[0]).show();

                    //place above 1st row
                    newTimeLegend.attr('transform', `matrix(1, 0, 0, 1, 10, ${newRowYAxis - EventsChart.RowHeight})`);

                    //get time & age data and place into top legend row
                    var stdTimeFull = svgEventRect.getAttribute("stdtime");
                    var stdTimeSplit = stdTimeFull.split(" ");
                    var hourMin = stdTimeSplit[0];
                    var date = stdTimeSplit[1];
                    var timezone = stdTimeSplit[2];
                    var age = svgEventRect.getAttribute("age");
                    newTimeLegend.children("text").text(`${hourMin} ${date}  AGE: ${age}`);

                    //replace circle with clock icon
                    //newTimeLegend.children("use").attr("xlink:href", ID.CursorLineClockIcon);
                }
            }

            function getAllEventRectsAtX(allElementsAtX) {
                const allEventRectsAtX = [];
                allElementsAtX.each((index, element) => {
                    const eventName = element.getAttribute("eventname");
                    if (eventName) {
                        allEventRectsAtX.push(element);
                    }
                });
                return allEventRectsAtX;
            }

            function removePreviousClones() {
                const previousClones = instance.$SvgChartElm.find(ID.CursorLineLegendCloneCls);
                previousClones.remove();
            }

            function toggleDescriptionBox() {
                if (instance.showDescription) {
                    SVG(instance.$CursorLineLegendDescriptionHolder[0]).show();
                } else {
                    SVG(instance.$CursorLineLegendDescriptionHolder[0]).hide();
                }
            }

            /**
             * Generates a summary row for event rectangles.
             * 
             * @param {Array} allEventRectsAtX - All event rectangles at a given x-coordinate.
             * @param {number} goodCount - The count of good events.
             * @param {number} badCount - The count of bad events.
             */
            function generateSummaryRow(allEventRectsAtX, goodCount, badCount) {
                // Clone the template and remove its id
                const newSummaryRow = instance.$CursorLineLegendTemplate.clone().removeAttr('id');

                // Add class to the new summary row and append it to the holder
                newSummaryRow.addClass(ID.CursorLineLegendClone).appendTo(instance.$CursorLineLegendHolder);


                // Show the new summary row
                SVG(newSummaryRow[0]).show();

                // Get the last event and its y-axis
                const lastEvent = allEventRectsAtX[allEventRectsAtX.length - 1];
                const lastEvtRowYAxis = parseInt(lastEvent.getAttribute("y"));

                // Calculate the y-axis for the summary row
                const summaryRowYAxis = lastEvtRowYAxis + EventsChart.RowHeight - 1;

                // Transform the new summary row
                newSummaryRow.attr('transform', `matrix(1, 0, 0, 1, 10, ${summaryRowYAxis})`);

                // Get the text element and set its text
                const textElm = newSummaryRow.children("text");
                textElm.text(` Good : ${goodCount}   Bad : ${badCount}`);

                // Set the href for the use element
                newSummaryRow.children("use").attr("xlink:href", ID.CursorLineSumIcon);
            }
        }
    }
}

//-------------------------------------------------------------------------------------------------FILE STITCH-------------------------------------

//make accesible to interop
window.vedastro = {
    UserId: "UserId" in localStorage ? JSON.parse(localStorage["UserId"]) : "101", //get user id from browser storage
    ApiDomain: "https://vedastroapi.azurewebsites.net/api",
    Ayanamsa: "Lahiri", //default to
    ChartStyle: "South", //default to South Indian Chart
};

// Check if jQuery is loaded
if (typeof jQuery == "undefined") {
    // jQuery is not loaded, load it
    var script = document.createElement("script");
    script.src = "https://cdn.jsdelivr.net/npm/jquery/dist/jquery.min.js";
    script.type = "text/javascript";
    document.getElementsByTagName("head")[0].appendChild(script);
    console.log("jQuery loaded");
}

// Create a hidden element with a Bootstrap-specific class
var testElement = document.createElement("div");
testElement.className = "hidden d-none"; // 'd-none' is a Bootstrap 4/5 class
document?.body?.appendChild(testElement);
// Check the computed style of the element
var isBootstrapCSSLoaded =
    window.getComputedStyle(testElement).display === "none";
// Clean up the test element
document?.body?.removeChild(testElement);
if (!isBootstrapCSSLoaded) {
    // Bootstrap CSS is not loaded, load it
    var link = document.createElement("link");
    link.href =
        "https://cdn.jsdelivr.net/npm/bootstrap/dist/css/bootstrap.min.css";
    link.rel = "stylesheet";
    document.getElementsByTagName("head")[0].appendChild(link);
    console.log("Bootstrap CSS loaded");
}

// Check if Bootstrap's JavaScript is loaded
var isBootstrapJSLoaded = typeof bootstrap !== "undefined";
if (!isBootstrapJSLoaded) {
    // Bootstrap JS is not loaded, load it
    var script = document.createElement("script");
    script.src =
        "https://cdn.jsdelivr.net/npm/bootstrap/dist/js/bootstrap.bundle.min.js";
    script.type = "text/javascript";
    document.getElementsByTagName("head")[0].appendChild(script);
    console.log("Bootstrap JS loaded");
}

// Check if Iconify is loaded
if (typeof Iconify == "undefined") {
    // Iconify is not loaded, load it
    var script = document.createElement("script");
    script.src = "https://code.iconify.design/3/3.1.0/iconify.min.js";
    script.type = "text/javascript";
    document.getElementsByTagName("head")[0].appendChild(script);
    console.log("Iconify loaded");
}

// Check if SweetAlert2 is loaded
if (typeof Swal == "undefined") {
    // SweetAlert2 is not loaded, load it
    // Load CSS
    var link = document.createElement("link");
    link.href =
        "https://cdn.jsdelivr.net/npm/sweetalert2/dist/sweetalert2.min.css";
    link.rel = "stylesheet";
    document.getElementsByTagName("head")[0].appendChild(link);
    // Load JS
    var script = document.createElement("script");
    script.src =
        "https://cdn.jsdelivr.net/npm/sweetalert2/dist/sweetalert2.all.min.js";
    script.type = "text/javascript";
    document.getElementsByTagName("head")[0].appendChild(script);
    console.log("SweetAlert2 loaded");
}

// Check if Selectize is loaded
if (typeof $.fn.selectize == "undefined") {
    // Selectize is not loaded, load it
    // Load CSS
    var link = document.createElement("link");
    link.href =
        "https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/css/selectize.default.min.css";
    link.rel = "stylesheet";
    link.integrity =
        "sha512-pTaEn+6gF1IeWv3W1+7X7eM60TFu/agjgoHmYhAfLEU8Phuf6JKiiE8YmsNC0aCgQv4192s4Vai8YZ6VNM6vyQ==";
    link.crossOrigin = "anonymous";
    document.getElementsByTagName("head")[0].appendChild(link);
    // Load JS
    var script = document.createElement("script");
    script.src =
        "https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/js/selectize.min.js";
    script.integrity =
        "sha512-IOebNkvA/HZjMM7MxL0NYeLYEalloZ8ckak+NDtOViP7oiYzG5vn6WVXyrJDiJPhl4yRdmNAG49iuLmhkUdVsQ==";
    script.crossOrigin = "anonymous";
    script.type = "text/javascript";
    document.getElementsByTagName("head")[0].appendChild(script);
    console.log("Selectize loaded");
}

/**
 * Shortcut method to initialize and generate table in 1 static call.
 * Used by Blazor to call JS code.
 * @param {Object} settings - The settings for the AstroTable.
 * @param {Object} inputArguments - The Time and other data needed to generate table.
 */
window.GenerateAstroTable = (settings, inputArguments) => {
    // Initialize astro table
    var planetDataTable = new AstroTable(settings);
    // Generate table
    planetDataTable.GenerateTable(inputArguments);
};

/**
 * Helps to create a table with astro data columns
 */
class AstroTable {
    //# LOCAL <--> LIVE Switch
    //APIDomain = "https://vedastroapibeta.azurewebsites.net/api";
    APIDomain = "https://vedastroapi.azurewebsites.net/api";
    //APIDomain = "http://localhost:7071/api";

    // Class fields
    Ayanamsa = "Lahiri";
    ElementID = ""; //ID of main div where table & header will be injected
    TableId = ""; //ID of table set in HTML, injected during init
    ShowHeader = true; //default enabled, header with title, icon and edit button
    HeaderIcon = "twemoji:ringed-planet"; //default enabled, header with title, icon and edit button
    KeyColumn = ""; //Planet or House
    EditButtonId = ""; //used to hook up edit button to show popup
    ColumnData = []; //data on selected columns
    EnableSorting = false; //sorting disabled by default
    APICalls = []; //list of API calls that can be used in table (filled on load)
    SaveSettings = true; //save settings to browser storage or not, enabled by default

    //DEFAULT COLUMNS when no column data is supplied or when reset button is clicked
    DefaultColumns = [
        { API: "PlanetZodiacSign", Enabled: true, Name: "Sign" },
        { API: "PlanetConstellation", Enabled: true, Name: "Star" },
        { API: "HousePlanetOccupiesKP", Enabled: true, Name: "Occupies" },
        { API: "HousesOwnedByPlanetKP", Enabled: true, Name: "Owns" },
        { API: "PlanetLordOfZodiacSign", Enabled: true, Name: "Sign Lord" },
        { API: "PlanetLordOfConstellation", Enabled: true, Name: "Star Lord" },
        { API: "PlanetSubLordKP", Enabled: true, Name: "Sub Lord" },
        { API: "Empty", Enabled: false, Name: "Empty" },
        { API: "Empty", Enabled: false, Name: "Empty" },
    ];

    constructor(rawSettings) {
        //correct if property names is camel case (for Blazor)
        var settings = CommonTools.ConvertCamelCaseKeysToPascalCase(rawSettings);

        //if column data is not supplied use default
        if (!settings.ColumnData) {
            settings.ColumnData = AstroTable.DefaultColumns;
        }

        //expand data inside settings input
        this.ElementID = settings.ElementID;
        this.TableId = `${this.ElementID}_Table`;
        this.ShowHeader = settings.ShowHeader;
        this.HeaderIcon = settings.HeaderIcon;
        this.SaveSettings = settings.SaveSettings;

        //based on table ID try get any settings if saved from before
        var savedTableSettings = localStorage.getItem(this.TableId);

        //only continue if settings are saved and featured enabled in settings
        if (this.SaveSettings || savedTableSettings) {
            //parse the data
            let jsonObject = JSON.parse(savedTableSettings);

            //set back all the exact settings from before
            this.KeyColumn = jsonObject["KeyColumn"];
            this.ColumnData = jsonObject["ColumnData"];
            this.EnableSorting = jsonObject["EnableSorting"];
        }
        //if null use data pumped in via constructor (defaults, when click Reset)
        else {
            this.KeyColumn = settings.KeyColumn;
            this.ColumnData = settings.ColumnData;
            this.EnableSorting = settings.EnableSorting;
        }
    }

    async ShowEditTableOptions() {
        // show loading
        CommonTools.ShowLoading();

        //pump in data about table settings to show in popup
        var htmlPopup = await AstroTable.GenerateTableEditorHtml(
            this.ColumnData,
            this.KeyColumn,
            this.APIDomain
        );

        //used to "Hoist" table reference for later event handlers firing
        var instance = this;

        var swalSettings = {
            width: "auto",
            title: "Edit Table",
            html: htmlPopup,
            focusConfirm: false,

            //after User clicks OK
            //get value from dialog box & save it for later use
            preConfirm: () => {
                //parses data from popup and saved it for later
                AstroTable.UpdateDateColumns(this.ColumnData);

                //update enable sorting switch
                this.EnableSorting = $("#TableSortingEnableSwitch").is(":checked");

                //get value from Key Column selector & save it
                this.KeyColumn = $("#KeyColumnInput").val();

                //clone all setting to Local Storage for future use under TableID which should be unique
                localStorage.setItem(this.TableId, this.ToJsonString());

                Swal.fire(
                    "Saved!",
                    "<strong>Recalculate</strong> to see changes!",
                    "success"
                );
            },
            //load saved values into view before showing to user
            //note: not all after load is done here, some data is fed into HTML maker
            didOpen: (popupElm) => {
                //SORT SWITCH
                //set switch based on what was set before
                $("#TableSortingEnableSwitch").prop("checked", instance.EnableSorting);

                //KEY COLUMN
                //attach one 1 time event reload popup if key column was changed
                //because API calls are different for different key columns
                $("#KeyColumnInput").one("change", async (eventObj) => {
                    instance.KeyColumn = $(eventObj.target).val(); //save value

                    //tell user API calls need to be updated
                    await Swal.fire(
                        "Update API Calls",
                        `You've changed the Key Column to <strong>${instance.KeyColumn}</strong>, update the API calls to match.`,
                        "info"
                    );

                    instance.ShowEditTableOptions(); //reload panel
                });

                //RESET BUTTON
                //attach one 1 time event reload popup if Reset button clicked
                $("#EditTableResetButton").one("click", async (eventObj) => {
                    //clear saved browser settings, this will make defaults to load in constructor
                    localStorage.setItem(instance.TableId, "");

                    //tell user API calls need to be updated
                    await Swal.fire(
                        "Reset done!",
                        "Please standby for auto page <strong>Refresh</strong>",
                        "success"
                    );

                    //reload page
                    location.reload();
                });
            },
        };

        // use pop up to show editor, and save results for later use
        Swal.fire(swalSettings);

        let selectizeConfigSingle = {
            score: function (search) {
                var score = this.getScoreFunction(search);
                return function (item) {
                    return score(item) * (1 + Math.min(item.text.indexOf(search), 1));
                };
            },
            theme: "bootstrap",

            //NOTE: below is to enable typing & search of API dropdown
            onFocus: function () {
                var value = this.getValue();
                if (value.length > 0) {
                    this.clear(true);
                    setTimeout(() => {
                        if (this.settings.selectOnTab) {
                            this.setActiveOption(this.getOption(value));
                        }
                        this.settings.score = null;
                    }, 100);
                }
            },
            onBlur: function () {
                if (
                    this.getValue().length == 0 &&
                    this.getValue() != this.lastValidValue
                ) {
                    this.setValue(this.lastValidValue);
                }
            },
        };

        //initialize Doped select options, with search for each dropdown
        for (
            var columnNumber = 0;
            columnNumber < this.ColumnData.length;
            columnNumber++
        ) {
            $(`#SelecteAPI${columnNumber}Dropdown`).selectize(selectizeConfigSingle);
        }
    }

    //given the full column array, extract out only the filtered endpoint
    GetAllEnabledEndpoints() {
        // Filter the ColumnData array to get only the columns where Enabled is true
        let enabledColumns = this.ColumnData.filter((column) => column.Enabled);

        // Map the enabledColumns to their respective API and return the result
        let apis = enabledColumns.map((column) => column.Api);

        return apis;
    }

    GetNiceColumnNameFromRawAPIName(rawApiName) {
        for (let i = 0; i < this.ColumnData.length; i++) {
            if (this.ColumnData[i].Api === rawApiName) {
                return this.ColumnData[i].Name;
            }
        }

        // return raw name if no matching API name is found
        return rawApiName;
    }

    //given name of API call, will return the metadata
    async GetAPIMetadata(apiName) {
        //get all API calls from server only if empty
        if (this.APICalls.length === 0) {
            this.APICalls = await AstroTable.GetAPIPayload(
                `${this.APIDomain}/ListCalls`
            );
        }

        var foundCalls = AstroTable.FindAPICallByName(this.APICalls, apiName);

        var selectedMethodInfo = foundCalls[0]?.MethodInfo;

        return selectedMethodInfo;
    }

    async GenerateTable(userInputParams) {
        //convert input param to URL format
        //in URL format it's ready to use in final URL
        var userInputURLParams = this.ConvertRawParamsToURL(userInputParams);

        //clear old data if any
        $(`#${this.ElementID}`).empty();

        //# HEADER
        //show header with title, icon and edit button
        if (this.ShowHeader) {
            //random ID for edit button
            this.EditButtonId = Math.floor(Math.random() * 1000000);

            var htmlContent = `
                    <h3 style="margin-bottom: -11px;">
                        <span class="iconify me-2" data-icon="${this.HeaderIcon}" data-width="38" data-height="38"></span>
                        ${this.KeyColumn}
                        <button id="${this.EditButtonId}" style="scale: 0.6;" class="ms-1 mb-1 btn btn-sm btn-outline-primary">
                            <span class="iconify" data-icon="majesticons:edit-pen-2-line" data-width="30" data-height="30"></span>
                        </button>
                    </h3>
                    <hr />`;

            //inject into page
            $(`#${this.ElementID}`).append(htmlContent);

            //attach event handler to edit button
            $(`#${this.EditButtonId}`).on("click", async () => {
                await this.ShowEditTableOptions();
            });
        }

        //# TABLE
        //create empty table inside main holder
        //table will be filled below
        $(`#${this.ElementID}`).append(
            `<table id="${this.TableId}" class="table table-striped table-hover table-bordered text-nowrap w-auto" style=""></table>`
        );

        //generate table from inputed data
        await this.GenerateHTMLTableFromAPI(userInputURLParams);
    }

    ConvertRawParamsToURL(userInputParams) {
        //handle camel case to pascal case (for blazor only)
        userInputParams =
            CommonTools.ConvertCamelCaseKeysToPascalCase(userInputParams);

        //extract from input
        var timeUrlParam = userInputParams.TimeUrl;
        var horaryNumber = userInputParams.HoraryNumber;
        var rotateDegrees = userInputParams.RotateDegrees;

        //SPECIAL CASE:
        //store ayanamsa as setting will be injected later into final URL
        this.Ayanamsa = userInputParams.Ayanamsa;

        // load the needed data from API for each column based
        var keyColumnParam = `${this.KeyColumn}Name/All/`;

        //compile all user inputed params
        //NOTE: name of property must match API C# code
        var userInputParams = {
            time: timeUrlParam,
            [this.KeyColumn]: keyColumnParam,
        };

        //only add horary if user inputed (defaults to 0)
        var horaryParam = `HoraryNumber/${horaryNumber}/`;
        if (horaryNumber !== 0) {
            userInputParams["HoraryNumber"] = horaryParam;
        }

        //only add rotate degrees if user inputed (defaults to 0)
        var rotateParam = `RotateDegrees/${rotateDegrees}/`;
        if (rotateDegrees !== 0) {
            userInputParams["RotateDegrees"] = rotateParam;
        }

        return userInputParams;
    }

    async GenerateHTMLTableFromAPI(userInputURLParams) {
        //extract endpoints that have been enabled
        var endpoints = this.GetAllEnabledEndpoints();

        //each API calculator listed is called (parallel)
        var payloads = await Promise.all(
            endpoints.map(async (endpoint) => {
                var apiPayload = await AstroTable.GetPayLoad2(
                    endpoint,
                    userInputURLParams,
                    this
                );
                return apiPayload;
            })
        );

        // get underlying values
        var combinedData = AstroTable.CombineRawAPICallResults(payloads);

        //print message for debug
        console.log(`Table Generated --> ${this.TableId}`);

        //clean old data
        AstroTable.ClearTableRows(this.TableId);

        //set API names as column headers, will be converted later to nicer names
        //note: first column name is same as preset key
        let tableHeaders = Array.from(endpoints);
        tableHeaders.unshift(this.KeyColumn);

        // generate the HTML table on page
        this.JsonToTable(combinedData, this.TableId, tableHeaders);

        //TODO not working, does not detect sorting
        //bring table to live with search & sorting if specified (SHORT CIRCUIT EVAL)
        //this.EnableSorting && new DataTable(`#${this.TableId}`);
    }

    //given JSON version of table data will convert to HTML
    JsonToTable(data, tableId, tableHeaders) {
        // Get the table element by id
        var table = document.getElementById(tableId);
        // Create the table head
        var thead = table.createTHead();
        var headerRow = thead.insertRow();
        // Create the header cells
        for (var header of tableHeaders) {
            //get nice column name set in options
            var cleanColumnName = this.GetNiceColumnNameFromRawAPIName(header);

            //place nice name into html
            var th = document.createElement("th");
            th.textContent = cleanColumnName;
            headerRow.appendChild(th);
        }
        // Create the table body
        var tbody = document.createElement("tbody");
        table.appendChild(tbody);

        // Create the body rows
        for (var key in data) {
            var row = tbody.insertRow();
            var cell = document.createElement("td");
            cell.textContent = key;
            row.appendChild(cell);

            //each item here is the data that goes into cell
            for (var item of data[key]) {
                cell = document.createElement("td");

                //if the value inside column is complex type (not string)
                //exp : Zodiac Sign/Planet Name in JSON format
                if (typeof item === "object" && item !== null) {
                    //SPECIAL handle to remove unwanted properties from JSON for special types
                    AstroTable.RemoveProperty(item, "TotalDegrees"); //Zodiac Sign

                    //place each value inside object into 1 string
                    cell.textContent = AstroTable.FlattenObjectValues(item).join(" ");
                } else {
                    cell.textContent = item;
                }

                //add to main table
                row.appendChild(cell);
            }
        }
    }

    //converts current instance of table settings to JSON string format
    //used for storing on browser storage
    ToJsonString() {
        //place all settings nicely into 1 bag
        var jsonObj = {
            TableId: this.TableId,
            KeyColumn: this.KeyColumn,
            ColumnData: this.ColumnData,
            EnableSorting: this.EnableSorting,
        };

        //convert to string before sending to caller
        return JSON.stringify(jsonObj);
    }

    /*--------------------STATIC METHODS--------------------------------*/

    static async GetPayLoad2(endpoint, userInputParams, instance) {
        //given a API name, get the metadata of the API call
        var selectedMethodInfo = await instance.GetAPIMetadata(endpoint);

        //construct the base url
        var finalUrl = `${instance.APIDomain}/Calculate/${endpoint}/`;

        //if metadata not found, alert user
        if (selectedMethodInfo === undefined) {
            Swal.fire({
                icon: "error",
                title: "Invalid Column",
                text: `API call ${endpoint} not found!`,
                confirmButtonText: "OK",
            });
        }

        //only process if API call meta was found
        else {
            //go through each parameter and add to the final URL
            for (var param of selectedMethodInfo.Parameters) {
                //get param name declared in C# code
                var paramName = param.Name;

                //find param from user with same or similar name (intelligently finds the param)
                //note: if not found return empty string
                var paramUrl = AstroTable.FindParamMatch(paramName, userInputParams);

                //add to back of final URL
                finalUrl += paramUrl;
            }

            //note: Ayanamsa is added here as system param
            var ayanamsaSysParam = `Ayanamsa/${instance.Ayanamsa}`;
            finalUrl += ayanamsaSysParam;

            //make the final API call in the perfect URL format
            var apiPayload = await AstroTable.GetAPIPayload(finalUrl);
            return apiPayload;
        }
    }

    //function works by first checking if the property exists in the top level of the object.
    //If it does, it deletes it. If it doesn't, it checks the second and third levels of the object.
    //If the property is found at any of these levels, it is deleted.
    static RemoveProperty(obj, propToRemove) {
        // Check if the property exists in the top level of the object
        if (obj.hasOwnProperty(propToRemove)) {
            delete obj[propToRemove];
        } else {
            // If not, check the second and third levels
            for (let prop in obj) {
                if (typeof obj[prop] === "object") {
                    if (obj[prop].hasOwnProperty(propToRemove)) {
                        delete obj[prop][propToRemove];
                    } else {
                        for (let subProp in obj[prop]) {
                            if (
                                typeof obj[prop][subProp] === "object" &&
                                obj[prop][subProp].hasOwnProperty(propToRemove)
                            ) {
                                delete obj[prop][subProp][propToRemove];
                            }
                        }
                    }
                }
            }
        }
    }

    //given a complex JSON object like PlanetName or ZodiacSign will flatten values to 1 string
    static FlattenObjectValues(obj) {
        var values = [];
        for (var prop in obj) {
            if (typeof obj[prop] === "object" && obj[prop] !== null) {
                // If the property is an object, recurse
                values.push(...AstroTable.FlattenObjectValues(obj[prop]));
            } else {
                // Otherwise, add the property's value to the array
                values.push(obj[prop]);
            }
        }

        //note : because used recursively can't use join with space here,
        //caller has to implement it .join(' ')
        return values;
    }

    static FindAPICallByName(items, apiCalcName) {
        //gets only API calls that can be used in Table, removes rest
        return items.filter((item) => item.MethodInfo.Name === apiCalcName);
    }

    //takes in many arrays and combines them into a single table like array
    static CombineRawAPICallResults(inputArray) {
        return inputArray.reduce((acc, curr) => {
            if (curr !== undefined) {
                let curr1 = curr[Object.keys(curr)[0]];
                curr1?.forEach((obj) => {
                    const key = Object.keys(obj)[0];
                    if (!acc[key]) {
                        acc[key] = [];
                    }
                    acc[key].push(obj[key]);
                });
            }
            return acc;
        }, {});
    }

    // generate Table Editor column options popup panel
    static async GenerateTableEditorHtml(columnData, keyColumnName, apiDomain) {
        var formHtml = "";

        for (
            var columnNumber = 0;
            columnNumber < columnData.length;
            columnNumber++
        ) {
            formHtml += `
                    <div class="input-group input-group-sm mb-3">
                        <div class="input-group-text">
                            <input class="form-check-input mt-0"  id="Enabled${columnNumber}" type="checkbox" value="" aria-label="Enable Column" ${columnData[columnNumber].Enabled ? "checked" : ""
                }>
                        </div>
                        <input type="text" id="Name${columnNumber}" value="${columnData[columnNumber].Name
                }" class="form-control" aria-label="Text input with checkbox">
                        <span class="input-group-text">
                            <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 128 128"><path fill="#40c0e7" d="M108.58 64L62.47 97.81V76.72H19.42V51.49h43.04v-21.3L108.58 64z"/></svg>
                        </span>
                        <div class="w-50">
                            <select id="SelecteAPI${columnNumber}Dropdown"  class="mt-1">
                                <option value=""></option>
                                ${await AstroTable.GetAPICallsListSelectOptionHTML(
                    columnData[columnNumber].Api,
                    keyColumnName,
                    apiDomain
                )}
                            </select>
                        </div>
                    </div>
           `;
        }

        //default key column options in HTML
        var defaultKeyColumnSel = `
            <select id="KeyColumnInput" class="form-select">
                <option value="Planet">Planet</option>
                <option value="House">House</option>
                <option value="ZodiacSign">ZodiacSign</option>
            </select>
        `;

        //automatically select the right key based on input
        // Convert the HTML string to jQuery object
        var $defaultKeyColumnSel = $(defaultKeyColumnSel);

        // Find the option with the value of keyColumn and set it as selected
        $defaultKeyColumnSel
            .find('option[value="' + keyColumnName + '"]')
            .attr("selected", "selected");

        // Convert the jQuery object back to HTML string
        //saved as string to be injected later
        var keyColumnSelector = $defaultKeyColumnSel.prop("outerHTML");

        //add in header to label menu nicely
        var outerHtml = `
            <div class="mb-4 hstack gap-1">
                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 48 48"><circle cx="24" cy="24" r="21" fill="#2196F3"/><path fill="#fff" d="M22 22h4v11h-4z"/><circle cx="24" cy="16.5" r="2.5" fill="#fff"/></svg>
                <span style=" font-size: 15px;" >Each column is linked to an API call. Change <strong>Key Column</strong> for different API calls.</span>\r\n
            </div>
            <div class="hstack gap-3">
                <div class="input-group w-50">
                    <span class="input-group-text">
                        <span class="iconify me-2" data-icon="carbon:virtual-column-key" data-width="25" data-height="25"></span>
                        Key Column
                    </span>
                    ${keyColumnSelector}
                </div>
                <div class="form-check form-switch" style="font-size: 15px;">
                  <input class="form-check-input" type="checkbox" role="switch" id="TableSortingEnableSwitch">
                  <label class="form-check-label" for="TableSortingEnableSwitch">Enable Sorting</label>
                </div>
                <button id="EditTableResetButton" type="button" class="btn btn-primary">
                    <span class="iconify me-2" data-icon="material-symbols:device-reset-rounded" data-width="25" data-height="25"></span>
                    Reset
                </button>
            </div>
            <hr />
            <div class="d-flex justify-content-around" style=" font-weight: 800; ">
                <div>Column Name</div>
                <div>API</div>
            </div>
            ${formHtml}
    `;

        return outerHtml;
    }

    //get list of all API calls in HTML options element string
    static async GetAPICallsListSelectOptionHTML(
        selectValue,
        keyColumnName,
        apiDomain
    ) {
        //get raw API calls list from Server
        var apiCalls = await AstroTable.GetAPIPayload(`${apiDomain}/ListCalls`);

        //filter out call that can NOT be used in columns (make User's live easier)
        apiCalls = AstroTable.FilterOutIncompatibleAPICalls(
            apiCalls,
            keyColumnName
        );

        let options = "";
        $.each(apiCalls, function (i, item) {
            //if called specified selected value, than select it
            var isSelected = selectValue === item.MethodInfo.Name;
            options += `<option value='${item.MethodInfo.Name}' title='${item.Description
                }' ${isSelected ? "selected" : ""}>${item.MethodInfo.Name}</option>`;
        });

        return options;
    }

    //gets only API calls that can be used in Table, removes rest
    static FilterOutIncompatibleAPICalls(items, keyColumnName) {
        return items.filter((item) => {
            const parameters = item.MethodInfo.Parameters;
            return (
                parameters.length >= 2 &&
                //NOTE: here hack to link Key Column to API library
                //make sure parameters to call API is supported
                parameters[0].ParameterType ===
                `VedAstro.Library.${keyColumnName}Name` &&
                parameters[1].ParameterType === "VedAstro.Library.Time"
            );
        });
    }

    // Function to update the array based on the Swal form
    static async UpdateDateColumns(dataColumns) {
        for (var i = 0; i < dataColumns.length; i++) {
            dataColumns[i].Api = $(`#SelecteAPI${i}Dropdown`).val();
            dataColumns[i].Enabled = $("#Enabled" + i).is(":checked");
            dataColumns[i].Name = $("#Name" + i).val();
        }
    }

    //try find param from user with same or similar name (intelligently finds the param)
    static FindParamMatch(paramName, userInputParams) {
        //try find exact match
        var foundParam = userInputParams[paramName];

        //if no exact match, try find similar match
        if (!foundParam) {
            //key is name of the param set in JS code
            for (let key in userInputParams) {
                //check param name of C# method contains any of
                //the JS defined param name (birthTime --> time)
                var check1 = paramName.toLowerCase().includes(key.toLowerCase());
                var check2 = key.toLowerCase().includes(paramName.toLowerCase());
                if (check1 || check2) {
                    //get the URL value out
                    foundParam = userInputParams[key];
                    break;
                }
            }
        }

        //if undefined, set as empty string (to avoid undefined in URL)
        if (!foundParam) {
            foundParam = "";
        }
        return foundParam;
    }

    //given a vedastro API url, will auto call via POST or GET
    //and return only passed payloads as JSON
    static async GetAPIPayload(url, payload = null) {
        try {
            // If a payload is provided, prepare options for a POST request
            const options = payload
                ? {
                    method: "POST", // Specify the HTTP method as POST
                    headers: { "Content-Type": "application/json" }, // Set the content type of the request to JSON
                    body: JSON.stringify(payload), // Convert the payload to a JSON string and include it in the body of the request
                }
                : {}; // If no payload is provided, create an empty options object, which defaults to a GET request

            // Send the request to the specified URL with the prepared options
            const response = await fetch(url, options);

            // If the response is not ok (status is not in the range 200-299), throw an error
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }

            // Parse the response body as JSON
            const data = await response.json();

            // If the 'Status' property of the parsed data is not 'Pass', throw an error
            if (data.Status !== "Pass") {
                throw new Error(data.Payload);
            }

            // If everything is ok, return the 'Payload' property of the parsed data
            return data.Payload;
        } catch (error) {
            // If an error is caught, display an error message using Swal.fire
            Swal.fire({
                icon: "error",
                title: "App Crash!",
                text: error,
                confirmButtonText: "OK",
            });
        }
    }

    static ClearTableRows(tableId) {
        let table = document.getElementById(tableId);
        while (table?.rows?.length > 0) {
            table?.deleteRow(0);
        }
    }
}

/**
 * Creates south or north indian chart
 */
class NatalChart { }

/**
 * Tools used by others in this repo
 */
class CommonTools {

    //used as delay sleep execution
    static delay(ms) {
        return new Promise(resolve => setTimeout(resolve, ms));
    }

    //will auto get payload out of json and checks reports failures to user
    // Define an asynchronous function named 'GetAPIPayload'
    static async GetAPIPayload(url, payload = null) {
        try {
            // If a payload is provided, prepare options for a POST request
            const options = payload
                ? {
                    method: "POST", // Specify the HTTP method as POST
                    headers: { "Content-Type": "application/json" }, // Set the content type of the request to JSON
                    body: JSON.stringify(payload), // Convert the payload to a JSON string and include it in the body of the request
                }
                : {}; // If no payload is provided, create an empty options object, which defaults to a GET request
            // Send the request to the specified URL with the prepared options
            const response = await fetch(url, options);
            // If the response is not ok (status is not in the range 200-299), throw an error
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            // Parse the response body as JSON
            const data = await response.json();
            // If the 'Status' property of the parsed data is not 'Pass', throw an error
            if (data.Status !== "Pass") {
                throw new Error(data.Payload);
            }
            // If everything is ok, return the 'Payload' property of the parsed data
            return data.Payload;
        } catch (error) {
            // If an error is caught, display an error message using Swal.fire
            Swal.fire({
                icon: "error",
                title: "App Crash!",
                text: error,
                confirmButtonText: "OK",
            });
        }
    }

    static ShowLoading() {
        Swal.fire({
            showConfirmButton: false,
            width: "280px",
            padding: "1px",
            allowOutsideClick: false,
            allowEscapeKey: false,
            stopKeydownPropagation: true,
            keydownListenerCapture: true,
            html: `<img src="https://vedastrowebsitestorage.z5.web.core.windows.net/images/loading-animation-progress-transparent.gif">`,
        });
    }

    static HideLoading() {
        //hide loading box
        Swal.close();
    }

    //converts camel case to pascal case, like "settings.keyColumn" to "settings.KeyColumn"
    static ConvertCamelCaseKeysToPascalCase(obj) {
        let newObj = Array.isArray(obj) ? [] : {};
        for (let key in obj) {
            let value = obj[key];
            let newKey = key.charAt(0).toUpperCase() + key.slice(1);
            if (value && typeof value === "object") {
                value = CommonTools.ConvertCamelCaseKeysToPascalCase(value);
            }
            newObj[newKey] = value;
        }
        return newObj;
    }

    //
    //takes JSON person and gives birth time in URL format with birth location as below
    //exp :  "Location/Singapore/Time/23:59/31/12/2000/+08:00"
    static BirthTimeUrlOfSelectedPersonJson() {
        var personJson = window.vedastro.SelectedPerson;

        let birthTimeJson = personJson["BirthTime"];

        var locationName = birthTimeJson.Location.Name;
        var stdTime = birthTimeJson.StdTime.split(" ");
        var time = stdTime[0];
        var date = stdTime[1];
        var timezone = stdTime[2];
        var result =
            "Location/" +
            locationName +
            "/Time/" +
            time +
            "/" +
            date +
            "/" +
            timezone;
        return result;
    }
}

/**
 * Shortcut method to initialize and generate table in 1 static call.
 * Used by Blazor to call JS code.
 * @param {Object} settings - The settings for the AstroTable.
 * @param {Object} inputArguments - The Time and other data needed to generate table.
 */
window.GenerateAshtakvargaTable = (settings, inputArguments) => {
    // Initialize astro table
    var ashtakvargaTable = new AshtakvargaTable(settings);
    // Generate table
    ashtakvargaTable.GenerateTable(inputArguments);
};

class AshtakvargaTable {
    constructor(rawSettings) {
        //correct if property names is camel case (for Blazor)
        var settings = CommonTools.ConvertCamelCaseKeysToPascalCase(rawSettings);

        //if column data is not supplied use default
        if (!settings.ColumnData) {
            settings.ColumnData = AstroTable.DefaultColumns;
        }

        //expand data inside settings input
        this.ElementID = settings.ElementID;
        this.SarvashtakavargaTableId = `${this.ElementID}_SarvashtakavargaTable`;
        this.BhinnashtakavargaTableId = `${this.ElementID}_BhinnashtakavargaTable`;
        this.ShowHeader = settings.ShowHeader;
        this.HeaderIcon = settings.HeaderIcon;
        this.SaveSettings = settings.SaveSettings;

        //based on table ID try get any settings if saved from before
        var savedTableSettings = localStorage.getItem(this.ElementID);

        //only continue if settings are saved and featured enabled in settings
        if (this.SaveSettings || savedTableSettings) {
            //parse the data
            let jsonObject = JSON.parse(savedTableSettings);

            //set back all the exact settings from before
            this.KeyColumn = jsonObject["KeyColumn"];
            this.ColumnData = jsonObject["ColumnData"];
            this.EnableSorting = jsonObject["EnableSorting"];
        }
        //if null use data pumped in via constructor (defaults, when click Reset)
        else {
            this.KeyColumn = settings.KeyColumn;
            this.ColumnData = settings.ColumnData;
            this.EnableSorting = settings.EnableSorting;
        }
    }

    async GenerateTable(inputArguments) {
        inputArguments =
            CommonTools.ConvertCamelCaseKeysToPascalCase(inputArguments);

        //clear old data if any
        $(`#${this.ElementID}`).empty();

        //# HEADER
        //show header with title, icon and edit button
        if (this.ShowHeader) {
            //random ID for edit button
            this.EditButtonId = Math.floor(Math.random() * 1000000);

            var htmlContent = `
                <h3 style="margin-bottom: -11px;">
                    <span class="iconify me-2" data-icon="${this.HeaderIcon}" data-width="38" data-height="38"></span>
                    ${this.KeyColumn}
                    
                </h3>
                <hr />`;

            //inject into page
            $(`#${this.ElementID}`).append(htmlContent);

            //attach event handler to edit button
            $(`#${this.EditButtonId}`).on("click", async () => {
                await this.ShowEditTableOptions();
            });
        }

        //# TABLE
        //create empty table inside main holder
        //table will be filled later
        $(`#${this.ElementID}`).append(
            `<table id="${this.SarvashtakavargaTableId}" class="table table-striped table-hover table-bordered text-nowrap w-auto" style=" font-size: 12px; font-weight: 700; "></table>`
        );

        $(`#${this.ElementID}`).append(
            `<table id="${this.BhinnashtakavargaTableId}" class="table table-striped table-hover table-bordered text-nowrap w-auto" style=" font-size: 12px; font-weight: 700; "></table>`
        );

        //generate table from inputed data
        //get data from API
        var sarvashtakavargaUrl = `https://vedastroapi.azurewebsites.net/api/Calculate/SarvashtakavargaChart/${inputArguments.TimeUrl}Ayanamsa/${inputArguments.Ayanamsa}`;
        var bhinnashtakavargaUrl = `https://vedastroapi.azurewebsites.net/api/Calculate/BhinnashtakavargaChart/${inputArguments.TimeUrl}Ayanamsa/${inputArguments.Ayanamsa}`;

        //get data from API and generate the HTML tables
        await this.GenerateHTMLTableFromAPI(
            sarvashtakavargaUrl,
            this.SarvashtakavargaTableId
        );
        await this.GenerateHTMLTableFromAPI(
            bhinnashtakavargaUrl,
            this.BhinnashtakavargaTableId
        );
    }

    async GenerateHTMLTableFromAPI(url, tableId) {
        //make the final API call in the perfect URL format
        var apiPayload = await AstroTable.GetAPIPayload(url);

        //clean old data
        AstroTable.ClearTableRows(tableId);

        AshtakvargaTable.GenerateHTMLTableFromJson(apiPayload, tableId);
    }

    //code where Ashtakvarga in JSON format given by API is converted into nice HTML
    static async GenerateHTMLTableFromJson(data, tableId) {
        let html = '<table border="1">';

        // Add table headers
        html += "<tr><th></th>";
        for (let i = 1; i <= 12; i++) {
            html += `<th>${i}</th>`;
        }

        //add in last total column
        html += `<th>Total</th>`;

        //wrap up
        html += "</tr>";

        //get first object which will be BhinnashtakavargaChart or SarvashtakavargaChart (API names)
        const ashtakavargaJson = data[Object.keys(data)[0]];

        // Add table data rows
        for (let key in ashtakavargaJson) {
            html += `<tr><td>${key}</td>`;
            for (let i = 0; i < 12; i++) {
                html += `<td>${ashtakavargaJson[key].Rows[i]}</td>`;
            }

            //add in last total column
            html += `<td>${ashtakavargaJson[key].Total}</td>`;

            html += "</tr>";
        }

        html += "</table>";

        // Now you can add 'html' to your webpage
        var currentTable = document.getElementById(tableId);
        currentTable.innerHTML = html;
    }
}

//YOU CANNOT FIGHT A DYING MAN,
//HE HOLDS THE UPPER HAND ALWAYS

class ChatInstance {
    LastUserMessage = ""; //used for post ai reply highlight
    SelectedTopicId = "";  //she's filled in when set
    SelectedTopicText = "";//she's filled in when set
    ServerURL = ""; //filled in later just before use
    LiveServerURL = "wss://vedastrocontainer.delightfulground-a2445e4b.westus2.azurecontainerapps.io/HoroscopeChat";
    LocalServerURL = "ws://127.0.0.1:8000/HoroscopeChat";
    ElementID = ""; //ID of main div where table & header will be injected
    ShowHeader = true; //default enabled, header with title, icon and edit button
    HeaderIcon = "twemoji:ringed-planet"; //default enabled, header with title, icon and edit button
    IsAITalking = false; //default false, to implement "PTT" radio like protocol
    PresetQuestions = {
        Previous: {
            "Last 3": [
                "Describe my general character",
                "Is this a good or bad person?",
                "Why am I not able to find a life partner?",
            ],
        },
        Love: {
            "Love Awaits Me": [
                "When will I meet the love of my life in the year 2024?",
                "Am I going to be in a new relationship in the year 2024?",
                "Why am I not able to find a life partner?",
            ],
            "Future Marriage": [
                "Tell me about my love life.",
                "Will I meet my soulmate in the year between 2024 to 2027?",
            ],
            "Current Partner": [
                "Should i tell that person about my feelings? Is it the right time?",
            ],
            "Ex Relations": [
                "Why did my past relationship end?",
                "Will my ex and I ever get back together?",
                "I feel really heartbroken. What should I do ?",
            ],
        },
        Astrology: {
            Yoga: [
                "Any special yoga in my chart?",
                "Describe in detail all my yogas",
            ],
            Planets: [
                "How does Sun effect me?",
                "How does Mercury effect me?",
                "How does Moon effect me?",
                "How does Mars effect me?",
                "How does Jupiter effect me?",
                "How does Saturn effect me?",
                "How does Venus effect me?",
                "How does Ketu effect me?",
                "How does Rahu effect me?",
                "How does Sub-grahas effect me?",
            ],
            House: [
                "How does House 1 effect me?",
                "How does House 2 effect me?",
                "How does House 3 effect me?",
                "How does House 4 effect me?",
                "How does House 5 effect me?",
                "How does House 6 effect me?",
                "How does House 7 effect me?",
                "How does House 8 effect me?",
                "How does House 9 effect me?",
                "How does House 10 effect me?",
                "How does House 11 effect me?",
                "How does House 12 effect me?",
            ],
        },
        Studies: {
            "Study Abroad": [
                "Will I get to travel abroad for education in the year 2024?",
                "Will I be able to get my education abroad one day and settle there between 2024 and 2027?",
            ],
            "Higher Studies": [
                "Will I be able to get a higher education?",
                "What course of education should I enroll in?",
                "Should I go for MBA? Will it really help me to boost my career?",
                "Will I get admission into my choice of college in the year 2024?",
                "My dream is to become a CEO one day. What path should I take academically?",
            ],
            "Career & Calling": [
                "Am I on the right educational path? What are good fields for me to study?",
                "My parents want me to become a doctor. But I don't feel like it is my true calling. What do you see in my birth chart?",
            ],
            "Study Challenges": [
                "It's difficult for me to concentrate on studying. What can I do to improve it?",
                "I study a lot but anyway get bad grades. Why is it happening?",
                "I failed exams to a school and it was my dream. Why did it happen?",
            ],
            "Studies Horoscope": [
                "Does the birth chart reflect anything about my returning to formal education?",
                "What is my education horoscope for the year 2024?",
                "Will I complete my education between 2024 and 2027 ?",
            ],
            "Studies & Relationships": [
                "If I get married on the year 2024 will I be able to continue my education?",
            ],
        },
        Career: {
            "Financial Outlook": [
                "Can you tell me about money flow throughout the year 2024?",
                "Are there any financial highs and lows predicted in my birth chart from the year 2024 to 2027?",
                "How can I attract more financial abundance in my life from 2024 to 2030?",
                "Are there any specific periods where I should be cautious about my finances in the period between 2024 and 2027?",
            ],
            "Career Path": [
                "According to my birth chart, what kind of career suits me the best?",
                "Do my stars indicate any entrepreneurial talents or inclinations?",
            ],
            "Work-Life Balance": [
                "Will I be able to balance my work and family life?",
                "Are there any suggestions from my birth chart on how to achieve a better work-life balance?",
            ],
            "Academic Influence": [
                "How significant will my academic degree be in my career?",
                "Does my birth chart suggest lifelong learning or settling with my current educational qualifications?",
            ],
            "Family & Career": [
                "Do the planets indicate that my parents are supportive of my career?",
                "Does my chart suggest any potential conflicts between my family's expectations and my career aspirations? How can I navigate them?",
            ],
        },
        Business: {
            "Entrepreneurial Skills": [
                "According to my birth chart, can I be a good businessman?",
                "What are the strong and weak sides of my business skills?",
                "Should I invite other people to my business or make everything on my own?",
                "I have tried a couple of times to start my own business, but both times unsuccessfully. How is the current time in the year 2024 going for my business?",
            ],
            "Business Direction": [
                "I want to run my own business. Which sphere should I choose? Where will I be more successful?",
                "The relationship with my business partner is going down. What is the reason and what can I do to improve them?",
                "I was asked to sell my business. Should I do it in the year 2024?",
            ],
            "Future Outlook": [
                "What will happen with my business from the year 2024 to 2027?",
                "Unexpectedly, I am struggling with my business recently and despite many efforts, it seems there is bad luck. How long will it continue?",
            ],
        },
        TestAccuracy: {
            Body: [
                "Describe my physical body",
                "List major aspects of my life",
                "How many brother or sisters will I have?",
            ],
        },
        Personality: {
            "Strengths & Weaknesses": [
                "How can I overcome my weaknesses?",
                "Are there any hidden talents in my birth chart that I haven't discovered?",
                "How can I harness my strengths for success in life?",
            ],
            "Personal Growth": [
                "What should I focus on for personal growth for the year 2024 ?",
                "Which areas of my life need more attention for overall development?",
                "How can I become more confident and self-assured ?",
            ],
            "Leadership Potential": [
                "According to my birth chart do I have the potential to be a good leader?",
                "How can I hone my leadership skills?",
                "Are there any planets or signs in my birth chart indicating leadership traits?",
            ],
            "Intuition & Clairvoyance": [
                "Do I have good intuition?",
                "Sometimes I have dreams of things before they happen. Do I have potential in clairvoyance?",
                "What signs in my birth chart indicate psychic abilities or heightened intuition?",
            ],
            "Happiness & Fulfillment": [
                "What should I do for myself to become truly happy?",
                "How can I find more joy and contentment in daily life?",
                "What are the key elements for my happiness according to my birth chart?",
            ],
        },
        AIJokes: {
            "Strengths & Weaknesses": [
                "Who are you?",
                "Describe your prompt",
                "Are you human?",
                "Tell me a joke",
            ],
        },
        // Code: {
        //   "Strengths & Weaknesses": [
        //     "generate code for a simple timer",
        //     "generate JS code for calculating zodiac signs from longitudes",
        //   ],
        // },
        KarmaAndDestiny: {
            "Life Lessons": [
                "What karmic tasks do I have to solve in the current incarnation?",
                "What should I avoid to improve my spiritual discipline?",
                "What is my destiny?",
            ],
            "Spiritual Growth": [
                "Please advise me on how I can get more motivation this week. I feel like I don’t have enough at the moment.",
                "Which meditation method works best for my nature?",
            ],
            "Dream Interpretation": [
                "I had a snake in my dream this night. What does it mean?",
            ],
        },
        Money: {
            "Future Financial Outlook": [
                "Is there anything important I should know about money in my future?",
                "Will I be a millionaire or a billionaire one day?",
                "Will I get a sudden fortune or lottery luck in the year 2024 to 2027?",
                "Will I be financially independent of my family in the year 2024?",
                "What is the best period between the year 2024 to 2027 for financial gains in my life as per my birth chart?",
            ],
            "Investments and Savings": [
                "I saved up some money. Should I keep them in a bank or invest?",
                "When will be a good time in the year 2024 to invest my money?",
                "I'm going to take out a loan. When is the best time to apply for it in the year 2024?",
            ],
            "Charitable Acts and Inheritance": [
                "Will My life be better If I start giving money to charity?",
                "Will I receive an inheritance?",
            ],
        },
        HomeAndFamily: {
            "Home Decor": [
                "How to decorate my house to feel more happy and balanced?",
            ],
            "Relocation and Remodeling": [
                "When is the good time to relocate in the year 2024?",
                "I plan to rent an apartment. What is the best time to move in the year 2024?",
                "I plan to have some remodeling at home. What time is the best to start in the year 2024?",
            ],
        },
        BestDates: {
            "Travel and Relocation": [
                "When is the best time to go traveling between 2024 and 2027?",
                "When is the right time for relocation between the year 2024 and 2027?",
            ],
            "Family Planning": [
                "When is the best time for me to have kids between the year 2024 and 2027?",
            ],
            "Career Decisions": [
                "When is the best time to start searching for a new job between the year 2024 and 2027?",
                "When is the right time to start building a house between the year 2024 and 2027?",
            ],
            Purchases: [
                "When is the best time to buy a new car between the year 2024 and 2027?",
                "Is it a good time now according to planetary alignments to make major purchases between the year 2024 and 2027?",
                "When is the best time to sell my house between the year 2024 and 2027?",
            ],
            "Personal Decisions": [
                "Will it be good for me to get a tattoo? When is the best time for it between the year 2024 and 2027?",
            ],
        },
    };

    //chat box body as html to be injected
    HtmlContent = `    
     <!-- MAIN MESSAGE BODY -->
     <!-- CHAT SESSION PERSON SELECTOR -->
         <div class="input-group mb-2">
             <span class="input-group-text gap-2">
                 <span class="iconify" data-icon="icon-park:topic" data-width="25" data-height="25"></span>Chat Topic
             </span>
             <!-- TOPIC SELECTOR -->
             <select class="form-select" id="TopicListDropdown">
                 <option selected value="">What do you want to talk about?</option>
                 <optgroup label="Learn Astrology">
                   <option value="Jaimini Upadesa Sutras - Translated by KRS Jayalakshmi">Jaimini Upadesa Sutras (Translated by KRS Jayalakshmi)</option>
                   <option value="Prasna Marga - Translated by Dr. Raman Srinivasan">Prasna Marga (Translated by Dr. Raman Srinivasan)</option>
                   <option value="Saravali - Translated by P.V.N. Rao">Saravali (Translated by P.V.N. Rao)</option>
                   <option value="Uttara Kalamritha - Translated by Varaha Mihira">Uttara Kalamritha (Translated by Varaha Mihira)</option>
                   <option value="Brihat Jataka - Translated by N. Chidambaram Iyer">Brihat Jataka (Translated by N. Chidambaram Iyer)</option>
                   <option value="Phala Deepika - Translated by V. Subramanya Sastri">Phala Deepika (Translated by V. Subramanya Sastri)</option>
                   <option value="Hora Sara - Translated by B.V. Raman">Hora Sara (Translated by B.V. Raman)</option>
                   <option value="Muhurta Chintamani - Translated by Ganesh Oka">Muhurta Chintamani (Translated by Ganesh Oka)</option>
                   <option value="Garga Hora - Translated by Sanjay Rath">Garga Hora (Translated by Sanjay Rath)</option>
                 </optgroup>
                 <optgroup label="Generate Code">
                   <option value="VedAstro">Vedic astrology code in any language</option>
                 </optgroup>
             </select>
             <!-- ADD PERSON BUTTON -->
             <button type="button" onclick="window.vedastro.chatapi.onclick_add_person()" class="btn btn-outline-secondary"><span class="iconify" data-icon="gg:add" data-width="25" data-height="25"></span></button>
             <!-- RESET CHAT BUTTON -->
             <button type="button" class="btn btn-outline-danger"><span class="iconify" data-icon="carbon:restart" onclick="window.vedastro.chatapi.restart_baby()" data-width="25" data-height="25"></span></button>
             <!-- ADVANCED SETTINGS BUTTON -->
             <button type="button" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" data-bs-auto-close="outside" data-bs-toggle="dropdown" aria-expanded="false">
               <span class="iconify" data-icon="iconamoon:settings-fill" data-width="25" data-height="25"></span>
             </button>
             <ul class="dropdown-menu dropdown-menu-end">
               <li class="dropdown-item">
                 <div class="form-check form-switch">
                   <input class="form-check-input" type="checkbox" role="switch" onchange="localStorage.setItem('IsLocalServerMode', this.checked)" id="useLocalServerSwitchInput">
                   <label class="form-check-label" for="useLocalServerSwitchInput">Local Server Mode</label>
                 </div>
               </li>
               <li class="dropdown-item">
                 <div class="input-group">
                   <span class="input-group-text" id="serverAddressLabel">Server</span>
                   <input  id="serverAddressInputElement" type="text" class="form-control" placeholder="Username" aria-label="Username" aria-describedby="serverAddressLabel">
                 </div>
               </li>
               <li class="dropdown-item">
                  <div class="form-check form-switch">
                      <input class="form-check-input" type="checkbox" role="switch" onchange="localStorage.setItem('IsTeacherMode', this.checked)" id="useTeacherModeSwitchInput">
                      <label class="form-check-label" for="useTeacherModeSwitchInput">Teacher Mode</label>
                  </div>
               </li>
               <li class="dropdown-item">
                  <div class="input-group">
                    <span class="input-group-text" id="teacherKeyLabel">Teacher Key</span>
                    <input id="teacherKeyInputElement" type="text" class="form-control" placeholder="Teacher Key" aria-label="Teacher Key" aria-describedby="teacherKeyLabel">
                  </div>
               </li>
               <li><a class="dropdown-item" href="#">Warning under</a></li>
               <li><a class="dropdown-item" href="#">Development</a></li>
               <li><hr class="dropdown-divider"></li>
               <li><a class="dropdown-item" href="#">Advanced users only</a></li>
             </ul>
     
         </div>
     
         <!-- PLACEHOLDER BEFORE CHAT START -->
         <div id="placeholderElement" style="margin: 50px auto;">
           <div class="d-flex justify-content-center">
             <!-- ARROW ICON FOR EYE TO FOLLOW (DRUNK UX) -->
             <svg xmlns="http://www.w3.org/2000/svg" width="73" height="73" viewBox="0 0 24 24">
               <g fill="none">
                 <path d="M24 0v24H0V0zM12.593 23.258l-.011.002l-.071.035l-.02.004l-.014-.004l-.071-.035c-.01-.004-.019-.001-.024.005l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427c-.002-.01-.009-.017-.017-.018m.265-.113l-.013.002l-.185.093l-.01.01l-.003.011l.018.43l.005.012l.008.007l.201.093c.012.004.023 0 .029-.008l.004-.014l-.034-.614c-.003-.012-.01-.02-.02-.022m-.715.002a.023.023 0 0 0-.027.006l-.006.014l-.034.614c0 .012.007.02.017.024l.015-.002l.201-.093l.01-.008l.004-.011l.017-.43l-.003-.012l-.01-.01z" />
                 <path fill="#00b3ff" d="M13.06 3.283a1.5 1.5 0 0 0-2.12 0L5.281 8.939a1.5 1.5 0 0 0 2.122 2.122L10.5 7.965V19.5a1.5 1.5 0 0 0 3 0V7.965l3.096 3.096a1.5 1.5 0 1 0 2.122-2.122z" />
               </g>
             </svg>
           </div>
           <div class="d-flex justify-content-center">
             <span class="" style="color: rgb(143, 143, 143); font-size: 14px;">
               Select <strong>topic</strong> above to <strong>start</strong>
             </span>
           </div>
         </div>
         
         <!-- MESSAGES IN VIEW -->
         <ul class="list-unstyled px-3" id="ChatWindowMessageList" style="max-height:667.5px; overflow: auto; ">
             <li class="d-flex justify-content-start mb-4" id="AIChatLoadingWaitElement" style="display: none !important;">
                 <img src="https://vedastro.org/images/vignes-chat-avatar.webp" alt="avatar"
                      class="rounded-circle d-flex align-self-start me-1 shadow-1-strong" width="45">
                 <div class="card">
                     <div class="card-header d-flex justify-content-between py-2">
                         <p class="fw-bold mb-0">Vignes</p>
                         <p class="text-muted small mb-0"><i class="far fa-clock"></i> 12 mins ago</p>
                     </div>
                     <div class="card-body">
                         <p class="mb-0">
                             <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-dasharray="15" stroke-dashoffset="15" stroke-linecap="round" stroke-width="2" d="M12 3C16.9706 3 21 7.02944 21 12"><animate fill="freeze" attributeName="stroke-dashoffset" dur="0.3s" values="15;0" /><animateTransform attributeName="transform" dur="1.5s" repeatCount="indefinite" type="rotate" values="0 12 12;360 12 12" /></path></svg>
                         </p>
                     </div>
                 </div>
             </li>
         </ul>
         <!-- QUESTION INPUT -->
         <div id="questionInputHolder" class="input-group mb-3" style="">
     
           <button id="presetQuestionsButton" 
             data-bs-auto-close="outside" 
             class="btn btn-outline-secondary dropdown-toggle"
             type="button" data-bs-toggle="dropdown" 
             aria-expanded="false">
               <span class="iconify" 
                 data-icon="icon-park:message" 
                 data-width="23" 
                 data-height="23"></span>
           </button>
           <ul id="presetQuestionDropdown" class="dropdown-menu" aria-labelledby="presetQuestionsButton">
             <!-- DYNAMIC CODE GENERATED HERE -->
           </ul>
     
           <input id="UserChatInputElement" type="text" class="form-control" placeholder="Ask anything about astrology...." aria-label="Ask anything about astrology....">
           <button id="SendChatButton" type="button" class="btn btn-success btn-rounded float-end"><span class="iconify me-1" data-icon="majesticons:send" data-width="25" data-height="25"></span>Send</button>
         </div>
     
     `;

    constructor(rawSettings) {
        console.log(
            "~~~~~~~Stand back! Awesome Chat API code launching! All engines go!~~~~~~~"
        );

        //make instance accessible
        window.vedastro.chatapi = this;

        //correct if property names is camel case (for Blazor)
        var settings = CommonTools.ConvertCamelCaseKeysToPascalCase(rawSettings);

        //expand data inside settings input
        this.ElementID = settings.ElementID;
        this.ShowHeader = settings.ShowHeader;
        this.HeaderIcon = settings.HeaderIcon;

        this.connected = false;
        this.queue = [];

        this.intervalId = null;

        //CHAT GUI INJECTION
        //clear old data if any
        $(`#${this.ElementID}`).empty();

        //random ID for edit button
        this.EditButtonId = Math.floor(Math.random() * 1000000);

        //inject into page
        $(`#${this.ElementID}`).html(this.HtmlContent);

        GenerateTopicListDropdown();

        //generate preset question drop down
        ChatInstance.generateHtmlFromJson(
            this.PresetQuestions,
            "presetQuestionDropdown"
        );

        //GUI LOAD SAVED VALUES
        //load settings stored browser storage
        let isLocalServerModeStr = localStorage.getItem("IsLocalServerMode");
        $("#useLocalServerSwitchInput").prop(
            "checked",
            JSON.parse(isLocalServerModeStr)
        );

        let isTeacherModeStr = localStorage.getItem("IsTeacherMode");
        $("#useTeacherModeSwitchInput").prop(
            "checked",
            JSON.parse(isTeacherModeStr)
        );

        // GUI EVENT HANDLRES
        // NOTE: do handle only

        //1:handle user press "Enter" equal to clicking send button
        $("#UserChatInputElement").keypress((e) => {
            if (e.which === 13) {
                // Enter key pressed
                this.OnClickSendChat();
                e.preventDefault(); // Prevents the default action
            }
        });

        //2:handle send button click
        $("#SendChatButton").on("click", () => {
            this.OnClickSendChat();
        });

        //3: ON change topic dropdown
        //attach topic selector dropdown
        $("#TopicListDropdown").on("change", (e) => {
            //get all needed data (what topic was selected)
            const selectedOption = $("#TopicListDropdown option:selected");
            const selectedOptgroupLabel = selectedOption
                .closest("optgroup")
                .prop("label");

            //save what user choose for use throughout the code
            window.vedastro.chatapi.SelectedTopicId = selectedOption.val();
            window.vedastro.chatapi.SelectedTopicText = selectedOption[0].innerText;

            //handle possible different selection types
            //nothing much done here, basically let caller context has been swicthed
            var validTopicSelected = false;

            //1 : HOROSCOPE
            //if value is for horoscope
            if (
                selectedOptgroupLabel === "Horoscopes" ||
                selectedOptgroupLabel === "Example Horoscopes"
            ) {
                //get full details of the person
                let selectedPerson = window.vedastro.PersonList.find(
                    (obj) => obj.PersonId === window.vedastro.chatapi.SelectedTopicId
                );

                //save for use by other
                window.vedastro.SelectedPerson = selectedPerson;

                //convert person name to birth DOB (so unregistered person can be checked)
                var newTopicId = CommonTools.BirthTimeUrlOfSelectedPersonJson();
                window.vedastro.chatapi.SelectedTopicId = newTopicId;

                //let others know (context changer)
                $(document).trigger("onChangeSelectedTopic");

                validTopicSelected = true; //ready to connect to server
            }

            //2 : BOOKS
            if (selectedOptgroupLabel === "Learn Astrology") {

                //let others know (context changer)
                $(document).trigger("onChangeSelectedTopic");

                validTopicSelected = true; //ready to connect to server

            }

            //2 : CODE
            if (selectedOptgroupLabel === "Generate Code") {
                Swal.fire(
                    "Coming soon!",
                    "<strong>Come</strong> back later or choose another topic",
                    "info"
                );

                //reset to make selection again
                $("#TopicListDropdown").val("");
            }

            //open connection to server if has not been open
            if (typeof this.socket === "undefined" && validTopicSelected) {
                this.ServerURL = $("#useLocalServerSwitchInput").is(":checked")
                    ? this.LocalServerURL
                    : this.LiveServerURL;

                OpenConnectionToChatBot(this);
            }
        });

        //4:let user know AI chat will use this newly selected person
        $(document).on("onChangeSelectedTopic", function (e) {
            // show message to user that location was found and set
            Swal.fire({
                icon: "success",
                title: "Topic changed!",
                html: `We'll will now talk about <strong>${window.vedastro.chatapi.SelectedTopicText}</strong>`,
                showConfirmButton: false,
                timer: 1500,
            });

            // execute once execution que is empty (so pop up stays open) via 0ms
            setTimeout(function () {
                //auto open presets questions drop down for super speed users (UX ⚡)
                $("#presetQuestionsButton").dropdown("toggle");
            }, 0);
        });

        //7: handle local server switch
        //when swith is fliped record into memory for future use (save user's time)

        // Save a string value to local storage
        localStorage.setItem("myKey", "Hello World!");

        //update control center back on earth
        console.log("~~~~~~~Huston, we have lift off!~~~~~~~");

        function OpenConnectionToChatBot(instance) {
            //start connection
            instance.socket = new WebSocket(instance.ServerURL);

            //attach standard handlers for connetion
            ["open", "message", "close", "error"].forEach((eventName) => {
                instance.socket.addEventListener(
                    eventName,
                    instance[`on${eventName}`].bind(instance)
                );
            });
        }

        async function GenerateTopicListDropdown(idToSelect = "") {
            //get the main dropdown element
            var $dropdown = $("#TopicListDropdown");

            //DO FOR USER'S SAVED LIST
            window.vedastro.PersonList = await CommonTools.GetAPIPayload(
                `${window.vedastro.ApiDomain}/GetPersonList/OwnerId/${window.vedastro.UserId}`
            );

            //create a header in the list
            let $horoscopeGroup = $("<optgroup>", {
                label: "Horoscopes",
            });

            $dropdown.append($horoscopeGroup); //add to main list

            //populate slection list at bottom with horoscopes
            $.each(window.vedastro.PersonList, function (i, person) {
                $horoscopeGroup.append(
                    $("<option>", {
                        value: person.PersonId,
                        text: person.Name,
                        selected: person.PersonId === idToSelect,
                    })
                );
            });

            //DO FOR PUBLIC LIST
            window.vedastro.PublicPersonList = await CommonTools.GetAPIPayload(
                `${window.vedastro.ApiDomain}/GetPersonList/OwnerId/101`
            );
            //create a header in the list
            let $publicHoroscopeGroup = $("<optgroup>", {
                label: "Example Horoscopes",
            });
            $dropdown.append($publicHoroscopeGroup); //add to main list

            //populate slection list at bottom with horoscopes
            $.each(window.vedastro.PublicPersonList, function (i, person) {
                $publicHoroscopeGroup.append(
                    $("<option>", {
                        value: person.PersonId,
                        text: person.Name,
                        selected: person.PersonId === idToSelect,
                    })
                );
            });
        }

    }

    /*
        █▀▀ █░█ █▀▀ █▄░█ ▀█▀   █░█ ▄▀█ █▄░█ █▀▄ █░░ █▀▀ █▀█ █▀
        ██▄ ▀▄▀ ██▄ █░▀█ ░█░   █▀█ █▀█ █░▀█ █▄▀ █▄▄ ██▄ █▀▄ ▄█
        */

    onopen() {
        console.log("We're connected to live chat baby!");

        //hide chat box place holder
        $("#placeholderElement").hide();

        this.connected = true;
        this.processQueue();
    }

    //called direct from static HTML hookup without seperate attach code
    //exp use : onclick="window.vedastro.chatapi.rate_message(this, -1)"
    restart_baby() {
        //TODO do proper restart of only client connetion now whole dang system!!

        //restart dank system
        location.reload();
    }

    //called direct from static HTML hookup without seperate attach code
    //exp use : onclick="window.vedastro.chatapi.rate_message(this, -1)"
    rate_message(eventData, rating) {
        //come here on click rating button
        // get hash of message, stored as id in holder
        var messageHolder = $(eventData)
            .closest(".card")
            .children(".message-holder");
        var text_hash = messageHolder.attr("id");

        const messagePayload = {
            user_id: window.vedastro.UserId,
            rating: rating,
            text_hash: text_hash,
        };

        window.vedastro.chatapi.enqueueMessage(JSON.stringify(messagePayload));
    }

    onclick_add_person() {

        //NOTE : "add person page" has auto return to previous page on save
        //navigate to person add page
        window.location.href = "./Account/Person/Add";
    }

    onclick_login() {

        //NOTE : "add person page" has auto return to previous page on save
        //navigate to login page
        window.location.href = "./Account/Login";
    }

    //called direct from static HTML hookup without seperate attach code
    //exp use : onclick="window.vedastro.chatapi.rate_message(this, -1)"
    onclick_preset_question(eventData) {
        //6: autofill preset questions handle (attach after generate)
        var selectedText = $(eventData).text();
        $("#UserChatInputElement").val(selectedText);
    }

    //when on of the follow up questions gets clicked
    //get called direct from html code
    ask_followup_question(eventData, followupQuestion) {
        // get hash of message, stored as id in holder
        var messageHolder = $(eventData)
            .closest(".card")
            .children(".message-holder");
        var primaryAnswerHash = messageHolder.attr("id");

        //UPDATE GUI WITH USER MSG (UX)
        var aiInput = $("#UserChatInputElement").val();
        var userName = "You";
        var userInputChatCloud = `
        <li class="d-flex justify-content-end mb-4">
            <div class="card ">
                <div class="card-header d-flex justify-content-between py-2">
                    <p class="fw-bold mb-0">${userName}</p>
                </div>
                <div class="card-body">
                    <p class="mb-0">
                        ${followupQuestion}
                    </p>
                </div>
            </div>
            <img src="https://mdbcdn.b-cdn.net/img/Photos/Avatars/avatar-6.webp" alt="avatar"
                 class="rounded-circle d-flex align-self-start ms-3 shadow-1-strong" width="45">
        </li>
        `;
        //inject in User's input into chat window
        $("#ChatWindowMessageList li").eq(-1).after(userInputChatCloud);

        //note the switch to python naming covention
        var commandsToSend = [];
        commandsToSend.push("followup_question"); //add command for server to read as "follow up"
        const messagePayload = {
            user_id: window.vedastro.UserId,
            primary_answer_hash: primaryAnswerHash,
            command: commandsToSend, //server uses this to do special handling
            text: followupQuestion,
            topic: window.vedastro.chatapi.SelectedTopicId, //can be DOB or book name, or astrology coder
        };

        window.vedastro.chatapi.enqueueMessage(JSON.stringify(messagePayload));
    }

    // Handler for incoming messages
    onmessage(event) {
        // Parse the JSON data from the event
        var raw_json_message = JSON.parse(event.data);
        var ai_text_message_html = raw_json_message.text_html;
        var ai_text_2_message_html = raw_json_message.text_2;
        var ai_text_3_message_html = raw_json_message.text_3;
        var message_hash = raw_json_message.text_hash;
        var ai_text_message = raw_json_message.text;
        var followup_questions = raw_json_message?.followup_questions ?? [];

        //PROCESS SERVER COMMANDS
        var commands = raw_json_message.command || []; // when no commands given empty to not fail

        //## SPECIAL HANDLE FOR LOGIN PROMPTS
        //1: check if server said please login, in command to client
        //   meaning user just say login message given by server,
        //   upon click login, start wait loop (make it seem bot is waiting for user to login)
        //   then that special login tab (RememberMe) will auto close

        let intervalId;
        if (commands.includes("please_login")) {
            //TODO maybe not needed anymore
            //set marker in browser asking Blazor login page to redirect back
            localStorage.setItem('PreviousPage', '/ChatAPI');
        }

        //## BUILD HTML

        //HANDLE FOLLOWUP
        // only add follow up questions if server specified them
        var followupQuestionsHtml = "";
        // convert questions into visible buttons, for user to click
        if (followup_questions.length > 0) {
            followupQuestionsHtml += //start out hidden, then js will bring to live with animation at right time (class)
                '<div class="followUpQuestionHolder hstack gap-2 w-100 justify-content-end" style="display:none; position: absolute; bottom: -43px; right: -1px; ">';

            followup_questions.forEach(function (question) {
                followupQuestionsHtml += `
            <button type="button" onclick="window.vedastro.chatapi.ask_followup_question(this, '${question}')"  class="btn btn-outline-primary">${question}</button>
        `;
            });

            followupQuestionsHtml += "</div>";
        }

        //only show feedback buttons for text that need feedback
        var feedbackButtonHtml = commands.includes("no_feedback")
            ? ""
            : `<div class="hstack gap-2">
    <button title="Bad answer" type="button" onclick="window.vedastro.chatapi.rate_message(this, -1)" class="btn btn-danger" style="padding: 0px 5px;">
      <span class="iconify" data-icon="icon-park-outline:bad-two" data-width="18" data-height="18"></span>
    </button>
    <button title="Good answer" type="button" onclick="window.vedastro.chatapi.rate_message(this, 1)" class="btn btn-primary" style="padding: 0px 5px;">
      <span class="iconify" data-icon="icon-park-outline:good-two" data-width="18" data-height="18"></span>
    </button>
  </div>`;

        //based on number of answers received use correct GUI
        //so, if only 1 ans then show standard gui, else do special multi ans accordian
        var isMultiAns = ai_text_2_message_html !== undefined;
        var aiFinalAnswerHolder = isMultiAns
            ? `                <!-- Multiple answer holder -->
    <div class="accordion text-html-out-elm" style="display:none;" >
      <div class="accordion-item">
        <h2 class="accordion-header">
          <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
            Answer #1
          </button>
        </h2>
        <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
          <div class="accordion-body">
            ${ai_text_message_html}
          </div>
        </div>
      </div>
      <div class="accordion-item">
        <h2 class="accordion-header">
          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
           Answer #2
          </button>
        </h2>
        <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
          <div class="accordion-body">
            ${ai_text_2_message_html}
          </div>
        </div>
      </div>
      <div class="accordion-item">
        <h2 class="accordion-header">
          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
            Answer #3
          </button>
        </h2>
        <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
          <div class="accordion-body">
            ${ai_text_3_message_html}
          </div>
        </div>
      </div>
    </div>
`
            : `
<div style="display:none;" class="text-html-out-elm mb-0">
${ai_text_message_html}
</div>
`;

        // Create a chat bubble with the AI's message
        var aiInputChatCloud = `<li class="d-flex justify-content-start" style=" margin-bottom: 70px; ">
        <img src="https://vedastro.org/images/vignes-chat-avatar.webp" alt="avatar" class="rounded-circle d-flex align-self-start me-3 shadow-1-strong" width="45">
        <div class="card">
            <div class="card-header d-flex justify-content-between p-3">
                <p class="fw-bold mb-0 me-5">Vignes</p>
                ${feedbackButtonHtml}
            </div>
            <div id="${message_hash}" class="message-holder card-body">
                ${aiFinalAnswerHolder}
                <p class="temp-text-stream-elm mb-0">
                  <!-- Content will be streamed here -->
                </p>
                <!-- SVG for loading icon -->
                <svg class="loading-icon-elm" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-dasharray="15" stroke-dashoffset="15" stroke-linecap="round" stroke-width="2" d="M12 3C16.9706 3 21 7.02944 21 12"><animate fill="freeze" attributeName="stroke-dashoffset" dur="0.3s" values="15;0" /><animateTransform attributeName="transform" dur="1.5s" repeatCount="indefinite" type="rotate" values="0 12 12;360 12 12" /></path></svg>
                ${followupQuestionsHtml}
            </div>
        </div>
    </li>`;

        // Append the chat bubble to the chat window
        $("#ChatWindowMessageList li").eq(-1).after(aiInputChatCloud);

        // # AUTO SCROLL DOWN
        $("#ChatWindowMessageList").scrollTop(
            $("#ChatWindowMessageList")[0].scrollHeight
        );

        // Flag to prevent user input while AI is 'typing'
        this.IsAITalking = true;

        // Initialize the index for streaming text
        let index = 0;
        const streamRateMs = 23; // Rate at which characters are displayed

        // Stream the AI's message into the chat bubble
        const interval = setInterval(() => {
            // Check if the entire message has been displayed
            //MESSAGE STREAM COMPLETE
            if (index >= ai_text_message.length) {
                clearInterval(interval);

                // Hide the temporary element and loading icon, then show the formatted message
                //remove stream shower and loading for this bubble since not needed anymore
                $(`#${message_hash} .temp-text-stream-elm`).hide();
                $(`#${message_hash} .loading-icon-elm`).hide();

                //make visible hidden formatted output
                $(`#${message_hash} .text-html-out-elm`).show();

                // Allow user input again
                this.IsAITalking = false;

                // # AUTO SCROLL DOWN
                $("#ChatWindowMessageList").scrollTop(
                    $("#ChatWindowMessageList")[0].scrollHeight
                );

                //make follow up questions if any slowly appear
                //narrow by message bubble, then holder
                $(`#${message_hash} .followUpQuestionHolder`).fadeIn("slow");

                return;
            }

            // Append the next character or handle special formatting
            ChatInstance.appendNextCharacter(
                ai_text_message,
                index,
                `#${message_hash} .temp-text-stream-elm`
            );
            index++;

            // # AUTO SCROLL DOWN
            $("#ChatWindowMessageList").scrollTop(
                $("#ChatWindowMessageList")[0].scrollHeight
            );

        }, streamRateMs);
    }

    // Function to append the next character or handle special formatting
    static appendNextCharacter(text, index, elementSelector) {
        const specialChars = {
            "\n": $("<br>"),
            "\t": $("<span>").html("&nbsp;&nbsp;&nbsp;&nbsp;"),
            " ": $("<span>").html("&nbsp;"),
            "<": $("<span>").html("&lt;"),
            ">": $("<span>").html("&gt;"),
        };

        // Check for special characters
        if (specialChars[text[index]]) {
            $(elementSelector).append(specialChars[text[index]]);
        } else {
            // Append regular character
            const nextChar = document.createTextNode(text[index]);
            $(elementSelector).append(nextChar);
        }
    }

    //TODO Needs rename
    static generateHtmlFromJson(json, targetElementId) {
        const presetQuestionsJson = json;
        const targetElement = document.getElementById(targetElementId);
        let htmlContent = "";

        //NOTE: below sample of full render
        // <li data-bs-toggle="collapse" href="#collapseExample" role="button" aria-expanded="false" aria-controls="collapseExample">
        //    <h6 class="dropdown-header">
        //        <span class="iconify me-2" data-icon="fluent-emoji-flat:heart-with-arrow" data-width="23" data-height="23"></span>Love</h6></li>
        // <div class="collapse" id="collapseExample">
        //   <div class="card card-body">
        //     <li><a class="dropdown-item">When will I meet the love of my life in the year 2024?</a></li>
        //     <li><a class="dropdown-item">Am I going to be in a new relationship in the year 2024?</a></li>
        //     <li><a class="dropdown-item">Tell me about my love life.</a></li>
        //     <li><a class="dropdown-item">Will I meet my soulmate in the year between 2024 to 2027?</a></li>
        //   </div>
        // </div>

        Object.entries(presetQuestionsJson).forEach(
            ([categoryKey, categoryValueList]) => {
                htmlContent += `<li 
        data-bs-toggle="collapse" 
        href="#collapse_${categoryKey}"
        role="button" aria-expanded="false"
        aria-controls="collapse_${categoryKey}">
          <h6 class="dropdown-header">
            <span class="iconify me-2" data-icon="${ChatInstance.getCategoryIconClass(
                    categoryKey
                )}" data-width="23" data-height="23"></span>
            ${categoryKey}
          </h6></li>`;
                htmlContent += `<div class="collapse" id="collapse_${categoryKey}">`;
                htmlContent += '<div class="card card-body">';

                let combinedArray = [];
                for (let category in categoryValueList) {
                    combinedArray = combinedArray.concat(categoryValueList[category]);
                }

                if (Array.isArray(combinedArray)) {
                    combinedArray.forEach((questionText) => {
                        htmlContent += `<li><a  onclick="window.vedastro.chatapi.onclick_preset_question(this)" class="dropdown-item">${questionText}</a></li>`;
                    });
                } else {
                    htmlContent += `<li><a class="dropdown-item">${combinedArray}</a></li>`;
                }

                htmlContent += "</div>"; // Close .card-body div
                htmlContent += "</div>"; // Close #collapse_{categoryKey} div
            }
        );

        targetElement.innerHTML = htmlContent;
    }
    static getCategoryIconClass(categoryKey) {
        switch (categoryKey) {
            case "BestDates":
                return "fluent-emoji-flat:spiral-calendar";
            case "Personality":
                return "fluent-emoji-flat:person";
            case "Travel":
                return "fluent-emoji-flat:airplane-departure";
            case "Love":
                return "fluent-emoji-flat:heart-with-arrow";
            case "Astrology":
                return "twemoji:ringed-planet";
            case "Studies":
                return "fluent-emoji-flat:books";
            case "Money":
                return "fluent-emoji-flat:money-bag";
            case "Business":
                return "fluent-emoji-flat:briefcase";
            case "Career":
                return "fluent-emoji-flat:graduation-cap";
            case "HomeAndFamily":
                return "fluent-emoji-flat:house-with-garden";
            case "KarmaAndDestiny":
                return "noto:milky-way";
            case "TestAccuracy":
                return "fluent-emoji-flat:test-tube";
            case "AIJokes":
                return "fxemoji:smiletongue";
            case "Previous":
                return "mdi:comment-previous";
            default:
                return "fluent-emoji-flat:heart-with-arrow";
        }
    }

    onclose() {
        console.log("Connection closed");
        this.connected = false;
    }

    onerror(event) {
        console.error("WebSocket error: ", event);
        this.connected = false;
    }

    processQueue() {
        while (this.queue.length > 0) {
            this.sendNextMessageInQueue();
        }
    }

    sendNextMessageInQueue() {
        if (this.connected && this.socket.readyState === WebSocket.OPEN) {
            const message = this.queue.shift();
            this.socket.send(message);
        }
    }

    enqueueMessage(message) {
        if (!this.connected || this.socket.readyState !== WebSocket.OPEN) {
            this.queue.push(message);
        } else {
            this.sendMessageNow(message);
        }
    }

    sendMessageNow(message) {
        if (
            this.socket.readyState === WebSocket.OPEN ||
            this.socket.readyState === WebSocket.CONNECTING
        ) {
            this.socket.send(message);
        } else {
            console.error("Cannot send message, connection is not open");
        }
    }

    async waitForConnection() {
        return new Promise((resolve) => {
            if (this.connected) {
                resolve();
                return;
            }

            this.checkConnection = setInterval(() => {
                if (this.connected) {
                    clearInterval(this.checkConnection);
                    resolve();
                }
            }, 100);
        });
    }

    //control comes here from both Button click and keyboard press enter
    async OnClickSendChat(userInput = "") {
        //STEP 0 : Validation
        //make sure the topic has been selected, else end here
        var selectedTopic = $("#TopicListDropdown").val();
        if (selectedTopic === "") {
            Swal.fire(
                "How to talk about nothing, dear?",
                "<strong>Choose</strong> first a <strong>topic</strong> that you want to talk about today",
                "error"
            );
            return;
        }

        //make sure the chat input has something, else end here
        userInput = userInput === "" ? $("#UserChatInputElement").val() : userInput; //get chat message to send to API that user inputed
        if (userInput === "") {
            Swal.fire(
                "How to send nothing, sweetheart?",
                "Please <strong>type a question</strong> in the chatbox first. Also there's <strong>commonly asked questions</strong> on left of the input.",
                "error"
            );
            return;
        }

        //make sure AI is not busy talking
        if (this.IsAITalking) {
            Swal.fire(
                "Please wait, dear..",
                "AI is <strong>busy talking</strong>, please wait for it to <strong>finish</strong> chattering.",
                "error"
            );
            return;
        }

        // STEP 1 : UPDATE GUI WITH USER MSG (UX)
        var aiInput = $("#UserChatInputElement").val();
        var userName = "You";
        var userInputChatCloud = `
        <li class="d-flex justify-content-end mb-4">
            <div class="card ">
                <div class="card-header d-flex justify-content-between p-3">
                    <p class="fw-bold mb-0">${userName}</p>
                </div>
                <div class="card-body">
                    <p class="mb-0">
                        ${userInput}
                    </p>
                </div>
            </div>
            <img src="https://mdbcdn.b-cdn.net/img/Photos/Avatars/avatar-6.webp" alt="avatar"
                 class="rounded-circle d-flex align-self-start ms-3 shadow-1-strong" width="45">
        </li>
        `;
        //inject in User's input into chat window
        $("#ChatWindowMessageList li").eq(-1).after(userInputChatCloud);

        //STEP 2:
        //user's input is sent to server for reply
        //get selected birth time
        //TODO can be DOB or bookname
        var topicText = CommonTools.BirthTimeUrlOfSelectedPersonJson();

        await this.SendMessageToServer(userInput);
        this.LastUserMessage = userInput; //save to used later for highlight

        //STEP 3 : GUI CLEAN UP
        //clear question input box for next, question
        $("#UserChatInputElement").val("");

        //STEP 4: ADD EASY TO EASY REASK LIST
        // Add the new question at the beginning of the 'Last 3' array
        // Check if the new question already exists in the 'Last 3' array
        var index = this.PresetQuestions.Previous["Last 3"].indexOf(userInput);

        if (index === -1) {
            // If the new question does not exist, add it at the beginning of the array
            this.PresetQuestions.Previous["Last 3"].unshift(userInput);
        } else {
            // If the new question exists, remove it from its current position
            this.PresetQuestions.Previous["Last 3"].splice(index, 1);
            // Then add it at the beginning of the array
            this.PresetQuestions.Previous["Last 3"].unshift(userInput);
        }

        // If there are more than 3 questions, remove the 4th one
        if (this.PresetQuestions.Previous["Last 3"].length > 5) {
            this.PresetQuestions.Previous["Last 3"].pop();
        }
        //re-generate preset question drop down
        ChatInstance.generateHtmlFromJson(
            this.PresetQuestions,
            "presetQuestionDropdown"
        );
    }

    //this is where final JSON packaged before sending to server
    async SendMessageToServer(message) {
        //build all commands based on set user settings
        var command_list = [];
        var password = $("#useTeacherModeSwitchInput").val();
        var isTeacherMode = $("#useTeacherModeSwitchInput").is(":checked");
        //teacher mode enables all answers, but slower
        if (isTeacherMode) {
            command_list.push("teacher_mode");
        }

        //NOTE: also equivelant to answer processing expriments
        //set answer level
        command_list.push("level_1");

        const messagePayload = {
            user_id: window.vedastro.UserId, //gotten from browser storage if any when script was init
            text: message,
            topic: window.vedastro.chatapi.SelectedTopicId, //can be DOB or book name, or astrology coder,
            command: command_list,
            password: password,
        };

        window.vedastro.chatapi.enqueueMessage(JSON.stringify(messagePayload));
    }
}

/**
 * Shortcut method to initialize Chat instace in 1 static call.
 * Used by Blazor to call JS code.
 * @param {Object} settings - The settings for the AstroTable.
 * @param {Object} inputArguments - The Time and other data needed to generate table.
 */
window.GenerateChatInstance = (settingsAIChat) => {
    //note: on init, chat instance is loaded into window.vedastro.chatapi
    new ChatInstance(settingsAIChat);
    window.vedastro.chatapi.waitForConnection();
};


/**
 * Shortcut method to aimate events chart.
 * Used by Blazor to call JS code.
 */
window.ChartFromSVG = async (chartStr) => {

    //inject into default div on page to hold, "EventsChartSvgHolder"
    var $chartElm = injectIntoElement($(ID.EventsChartSvgHolder)[0], chartStr);

    //things done here:
    //- get the unique ID of the chart
    //- use ID to maintain clean code
    //- chart is available in window.EventsChartList
    var chartId = $chartElm.attr('id');
    var index = new EventsChart(chartId); //brings to life

    //let caller know all went well
    console.log(`Amen! Chart Loaded : INDEX:${index}, ID:${chartId}`);



    //-----------------------------LOCAL FUNCS---------------------------------------

    //todo marked for update
    async function getEventsChartFromApiXml(url, payload) {
        console.log(`JS : Getting events chart from API...`);

        var response = await window.fetch(url, {
            "headers": { "accept": "*/*", "Connection": "keep-alive" },
            "body": payload,
            "method": "GET"
        });

        //API should always give a OK reply, else it has failed internally
        if (!response.ok) { console.log("ERROR : API Call Crashed!"); }

        //inject new svg chart into page
        var svgChartString = await response.text();

        return svgChartString;
    }


    //returns the reference to the SVG element in DOM
    function injectIntoElement(parentElement, valueToInject) {
        console.log(`JS : Injecting SVG Chart into page...`);

        //if parent not found raise alarm
        if (parentElement === undefined) { console.log("ERROR: Parent element ID'd EventsChartSvgHolder not found"); }

        //convert string to html node
        var template = document.createElement("template");
        template.innerHTML = valueToInject;
        var svgElement = template.content.firstElementChild;

        //place new node in parent
        parentElement.innerHTML = ''; //clear current children if any
        parentElement.appendChild(svgElement);

        //return reference in to SVG elm in DOM (jquery for ease)
        return $(svgElement);
    }


}



//--------------------HOROSCOPE CHAT-------------------
//repainting mona-lisa's hand for the 2nd time here, so what!
//i'm prepared to repaint this hand a million times, means nothing to me!
//i'm not the painter you see, just the one watching
class HoroscopeChat {
    LastUserMessage = ""; //used for post ai reply highlight
    SelectedTopicId = "";  //she's filled in when set
    SelectedTopicText = "";//she's filled in when set
    ServerURL = ""; //filled in later just before use
    //LiveServerURL = "http://localhost:7071/api/Calculate";
    //LiveServerURL = "https://vedastroapibeta.azurewebsites.net/api/Calculate";
    LiveServerURL = "https://vedastroapi.azurewebsites.net/api/Calculate";
    //LocalServerURL = "http://localhost:7071/api/Calculate/HoroscopeChat";
    ElementID = ""; //ID of main div where table & header will be injected
    ShowHeader = true; //default enabled, header with title, icon and edit button
    HeaderIcon = "twemoji:ringed-planet"; //default enabled, header with title, icon and edit button
    IsAITalking = false; //default false, to implement "PTT" radio like protocol
    PaddingTopApplied = false; //basic switch will go once
    SelectedBirthTime = ""; //if mentioned during init use it else, GUI will change ask for it
    SessionId = ""; //start clean, updated as message comes in

    constructor(rawSettings) {
        console.log(
            "~~~~~~~Stand back! Awesome Chat API code launching! All engines go!~~~~~~~"
        );

        //make instance accessible
        window.vedastro.horoscopechat = this;

        //process the input variables and set them
        this.initializeSettingData(rawSettings);

        //make the main chat window structure
        this.initializeChatMainBody();

        //creates ever changing placeholder questios to engage users
        this.initializeChatInputElement();


        //update control center back on earth
        console.log("~~~~~~~Huston, we have lift off!~~~~~~~");

    }



    //----------------------------------------FUNCS---------------------------------------
    //---------------------BELOW LIES FUNCS, AS WE ARE SO YOU SHALL BE--------------------



    //chat box body as html to be injected
    generateHtmlBody() {
        return `

        <div class="fw-bold hstack gap-2 d-flex" style="">
            <div>
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--fluent-emoji" width="38" height="38" preserveAspectRatio="xMidYMid meet" viewBox="0 0 32 32" data-icon="fluent-emoji:robot" data-width="38" style="vertical-align: text-bottom;"><g fill="none"><path fill="url(#IconifyId18fec41c6ed170cd6117)" d="M22.05 30H9.95C6.66 30 4 27.34 4 24.05V12.03C4 8.7 6.7 6 10.03 6h11.95C25.3 6 28 8.7 28 12.03v12.03c0 3.28-2.66 5.94-5.95 5.94"></path><path fill="url(#IconifyId18fec41c6ed170cd6104)" d="M4 12a6 6 0 0 1 6-6h2v24h-2a6 6 0 0 1-6-6z"></path><path fill="url(#IconifyId18fec41c6ed170cd6105)" d="M4 24h24a6 6 0 0 1-6 6H10a6 6 0 0 1-6-6"></path><path fill="url(#IconifyId18fec41c6ed170cd6118)" d="M20 6h2a6 6 0 0 1 6 6v12a6 6 0 0 1-6 6h-2z"></path><path stroke="url(#IconifyId18fec41c6ed170cd6106)" stroke-miterlimit="10" d="M3.5 3.95v9.1"></path><path fill="url(#IconifyId18fec41c6ed170cd6107)" d="M4 12v11c-1.1 0-2-.9-2-1.998v-7.004C2 12.9 2.9 12 4 12"></path><path fill="url(#IconifyId18fec41c6ed170cd6108)" d="M22.753 18.5H9.247A4.257 4.257 0 0 1 5 14.25A4.257 4.257 0 0 1 9.247 10h13.506A4.257 4.257 0 0 1 27 14.25c0 2.331-1.918 4.25-4.247 4.25"></path><path fill="url(#IconifyId18fec41c6ed170cd6109)" d="M18.528 26h-5.056C12.66 26 12 25.326 12 24.5s.66-1.5 1.472-1.5h5.056c.811 0 1.472.674 1.472 1.5s-.66 1.5-1.472 1.5"></path><path fill="url(#IconifyId18fec41c6ed170cd6119)" d="M3.5 5a1.5 1.5 0 1 0 0-3a1.5 1.5 0 0 0 0 3"></path><path stroke="url(#IconifyId18fec41c6ed170cd6110)" stroke-miterlimit="10" d="M28.5 4v9.09"></path><path fill="url(#IconifyId18fec41c6ed170cd6120)" d="M28.5 5.1a1.55 1.55 0 1 0 0-3.1a1.55 1.55 0 0 0 0 3.1"></path><rect width="4.5" height="6" x="7" y="12" fill="url(#IconifyId18fec41c6ed170cd6121)" rx="2"></rect><rect width="4.5" height="6" x="18.5" y="12" fill="url(#IconifyId18fec41c6ed170cd6122)" rx="2"></rect><rect width="10" height="3" x="11" y="3" fill="url(#IconifyId18fec41c6ed170cd6111)" rx="1.5"></rect><rect width="10" height="3" x="11" y="3" fill="url(#IconifyId18fec41c6ed170cd6123)" rx="1.5"></rect><path fill="url(#IconifyId18fec41c6ed170cd6112)" d="M28 22.94V11.93c1.1 0 2 .9 2 2v7.01c0 1.1-.9 2-2 2"></path><rect width="2.5" height="5" x="9" y="12" fill="url(#IconifyId18fec41c6ed170cd6113)" rx="1.25"></rect><rect width="2.5" height="5" x="9" y="12" fill="url(#IconifyId18fec41c6ed170cd6124)" rx="1.25"></rect><rect width="2.5" height="5" x="20.5" y="12" fill="url(#IconifyId18fec41c6ed170cd6114)" rx="1.25"></rect><rect width="2.5" height="5" x="20.5" y="12" fill="url(#IconifyId18fec41c6ed170cd6125)" rx="1.25"></rect><g filter="url(#IconifyId18fec41c6ed170cd6129)"><path stroke="url(#IconifyId18fec41c6ed170cd6115)" stroke-width=".25" d="M3.625 5v6"></path></g><g filter="url(#IconifyId18fec41c6ed170cd6130)"><path stroke="url(#IconifyId18fec41c6ed170cd6116)" stroke-width=".25" d="M28.625 5v6"></path></g><ellipse cx="29" cy="13.5" fill="url(#IconifyId18fec41c6ed170cd6126)" rx="1" ry="1.5"></ellipse><ellipse cx="29" cy="16.5" fill="url(#IconifyId18fec41c6ed170cd6127)" rx="1" ry="4.5"></ellipse><path fill="url(#IconifyId18fec41c6ed170cd6128)" fill-rule="evenodd" d="M19.776 3.025a1.501 1.501 0 0 1 1.199 1.2a1 1 0 1 1-1.2-1.2" clip-rule="evenodd"></path><defs><linearGradient id="IconifyId18fec41c6ed170cd6104" x1="12" x2="4" y1="18" y2="18" gradientUnits="userSpaceOnUse"><stop stop-color="#D5B2C0" stop-opacity="0"></stop><stop offset="1" stop-color="#B4878D"></stop></linearGradient><linearGradient id="IconifyId18fec41c6ed170cd6105" x1="16" x2="16" y1="27" y2="31" gradientUnits="userSpaceOnUse"><stop stop-color="#B17EDB" stop-opacity="0"></stop><stop offset="1" stop-color="#A56BD6"></stop></linearGradient><linearGradient id="IconifyId18fec41c6ed170cd6106" x1="4" x2="4" y1="3.95" y2="13.05" gradientUnits="userSpaceOnUse"><stop stop-color="#EA248A"></stop><stop offset="1" stop-color="#DF2232"></stop></linearGradient><linearGradient id="IconifyId18fec41c6ed170cd6107" x1="3" x2="3" y1="12" y2="23" gradientUnits="userSpaceOnUse"><stop stop-color="#E93273"></stop><stop offset="1" stop-color="#D21844"></stop></linearGradient><linearGradient id="IconifyId18fec41c6ed170cd6108" x1="15.998" x2="15.998" y1="17.701" y2="11.391" gradientUnits="userSpaceOnUse"><stop offset=".006" stop-color="#443E75"></stop><stop offset="1" stop-color="#2F1A3B"></stop></linearGradient><linearGradient id="IconifyId18fec41c6ed170cd6109" x1="15.998" x2="15.998" y1="25.686" y2="22.889" gradientUnits="userSpaceOnUse"><stop offset=".006" stop-color="#39325E"></stop><stop offset="1" stop-color="#2B1831"></stop></linearGradient><linearGradient id="IconifyId18fec41c6ed170cd6110" x1="29" x2="29" y1="4" y2="13.09" gradientUnits="userSpaceOnUse"><stop stop-color="#EA248A"></stop><stop offset="1" stop-color="#DF2232"></stop></linearGradient><linearGradient id="IconifyId18fec41c6ed170cd6111" x1="16" x2="14.5" y1="3" y2="6.5" gradientUnits="userSpaceOnUse"><stop stop-color="#FFCE2B"></stop><stop offset="1" stop-color="#D9862D"></stop></linearGradient><linearGradient id="IconifyId18fec41c6ed170cd6112" x1="29" x2="29" y1="11.93" y2="22.94" gradientUnits="userSpaceOnUse"><stop stop-color="#FF30AA"></stop><stop offset="1" stop-color="#FF2353"></stop></linearGradient><linearGradient id="IconifyId18fec41c6ed170cd6113" x1="11.5" x2="9" y1="14" y2="14" gradientUnits="userSpaceOnUse"><stop stop-color="#29B6FE"></stop><stop offset="1" stop-color="#1769A8"></stop></linearGradient><linearGradient id="IconifyId18fec41c6ed170cd6114" x1="23" x2="20.5" y1="14" y2="14" gradientUnits="userSpaceOnUse"><stop stop-color="#29B6FE"></stop><stop offset="1" stop-color="#1769A8"></stop></linearGradient><linearGradient id="IconifyId18fec41c6ed170cd6115" x1="3.5" x2="3.5" y1="7" y2="9" gradientUnits="userSpaceOnUse"><stop stop-color="#FF96CB"></stop><stop offset="1" stop-color="#FF6DB7" stop-opacity="0"></stop></linearGradient><linearGradient id="IconifyId18fec41c6ed170cd6116" x1="28.5" x2="28.5" y1="7" y2="9" gradientUnits="userSpaceOnUse"><stop stop-color="#FF96CB"></stop><stop offset="1" stop-color="#FF6DB7" stop-opacity="0"></stop></linearGradient><radialGradient id="IconifyId18fec41c6ed170cd6117" cx="0" cy="0" r="1" gradientTransform="rotate(141.911 10.515 10.065)scale(23.5053)" gradientUnits="userSpaceOnUse"><stop stop-color="#EEEBF0"></stop><stop offset=".493" stop-color="#D1BEE3"></stop><stop offset="1" stop-color="#D0BCE2"></stop></radialGradient><radialGradient id="IconifyId18fec41c6ed170cd6118" cx="0" cy="0" r="1" gradientTransform="matrix(5 -.5 1.9111 19.11108 25 13.5)" gradientUnits="userSpaceOnUse"><stop stop-color="#F0EAF6"></stop><stop offset="1" stop-color="#E7E0EF" stop-opacity="0"></stop></radialGradient><radialGradient id="IconifyId18fec41c6ed170cd6119" cx="0" cy="0" r="1" gradientTransform="matrix(-.5 2 -2 -.5 4 3)" gradientUnits="userSpaceOnUse"><stop stop-color="#FF6C82"></stop><stop offset=".441" stop-color="#FF2455"></stop><stop offset="1" stop-color="#D9206C"></stop></radialGradient><radialGradient id="IconifyId18fec41c6ed170cd6120" cx="0" cy="0" r="1" gradientTransform="rotate(104.036 13.324 12.844)scale(2.13027)" gradientUnits="userSpaceOnUse"><stop stop-color="#FF6C82"></stop><stop offset=".441" stop-color="#FF2455"></stop><stop offset="1" stop-color="#D9206C"></stop></radialGradient><radialGradient id="IconifyId18fec41c6ed170cd6121" cx="0" cy="0" r="1" gradientTransform="matrix(-2.5 .5 -.68428 -3.42136 9.5 15)" gradientUnits="userSpaceOnUse"><stop stop-color="#322649"></stop><stop offset="1" stop-color="#342950" stop-opacity="0"></stop></radialGradient><radialGradient id="IconifyId18fec41c6ed170cd6122" cx="0" cy="0" r="1" gradientTransform="matrix(-2.5 .5 -.68428 -3.42136 21 15)" gradientUnits="userSpaceOnUse"><stop stop-color="#322649"></stop><stop offset="1" stop-color="#342950" stop-opacity="0"></stop></radialGradient><radialGradient id="IconifyId18fec41c6ed170cd6123" cx="0" cy="0" r="1" gradientTransform="matrix(0 3 -10 0 16 4)" gradientUnits="userSpaceOnUse"><stop offset=".431" stop-color="#CA7E29" stop-opacity="0"></stop><stop offset="1" stop-color="#673F13"></stop></radialGradient><radialGradient id="IconifyId18fec41c6ed170cd6124" cx="0" cy="0" r="1" gradientTransform="matrix(0 2.5 -1.14393 0 11 13.5)" gradientUnits="userSpaceOnUse"><stop stop-color="#54C8FF"></stop><stop offset="1" stop-color="#54C8FF" stop-opacity="0"></stop></radialGradient><radialGradient id="IconifyId18fec41c6ed170cd6125" cx="0" cy="0" r="1" gradientTransform="matrix(0 2.5 -1.14393 0 22.5 13.5)" gradientUnits="userSpaceOnUse"><stop stop-color="#54C8FF"></stop><stop offset="1" stop-color="#54C8FF" stop-opacity="0"></stop></radialGradient><radialGradient id="IconifyId18fec41c6ed170cd6126" cx="0" cy="0" r="1" gradientTransform="matrix(0 1.5 -1 0 29 13.5)" gradientUnits="userSpaceOnUse"><stop stop-color="#FF72C1"></stop><stop offset="1" stop-color="#FF6EBF" stop-opacity="0"></stop></radialGradient><radialGradient id="IconifyId18fec41c6ed170cd6127" cx="0" cy="0" r="1" gradientTransform="matrix(0 4.5 -.55944 0 29 16.5)" gradientUnits="userSpaceOnUse"><stop stop-color="#FF4B9C"></stop><stop offset="1" stop-color="#FF73C1" stop-opacity="0"></stop></radialGradient><radialGradient id="IconifyId18fec41c6ed170cd6128" cx="0" cy="0" r="1" gradientTransform="rotate(90 8 12)" gradientUnits="userSpaceOnUse"><stop stop-color="#FFEA60"></stop><stop offset="1" stop-color="#FFEF66" stop-opacity="0"></stop></radialGradient><filter id="IconifyId18fec41c6ed170cd6129" width="1.25" height="7" x="3" y="4.5" color-interpolation-filters="sRGB" filterUnits="userSpaceOnUse"><feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood><feBlend in="SourceGraphic" in2="BackgroundImageFix" result="shape"></feBlend><feGaussianBlur result="effect1_foregroundBlur_31_1501" stdDeviation=".25"></feGaussianBlur></filter><filter id="IconifyId18fec41c6ed170cd6130" width="1.25" height="7" x="28" y="4.5" color-interpolation-filters="sRGB" filterUnits="userSpaceOnUse"><feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood><feBlend in="SourceGraphic" in2="BackgroundImageFix" result="shape"></feBlend><feGaussianBlur result="effect1_foregroundBlur_31_1501" stdDeviation=".25"></feGaussianBlur></filter></defs></g></svg>
            </div>
            <h4 class="mt-2 me-auto">AI Chat </h4>
        </div>

        <!-- MAIN MESSAGE BODY -->
        <div class="shadow" id="BorderHolderDiv" style="border-radius: 19px;background: linear-gradient(to bottom, #ececec, #e0edff);">
            <!-- MESSAGES IN VIEW -->
            <ul class="list-unstyled mx-2 pe-2 pt-2" id="ChatWindowMessageList" style="max-height:667.5px;">
                <li class="d-flex justify-content-start mb-4" id="AIChatLoadingWaitElement" style="display: none !important;">
                    <img src="https://vedastro.org/images/vignes-chat-avatar.webp" alt="avatar"
                        class="rounded-circle d-flex align-self-start me-1 shadow-1-strong" width="45">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between p-3">
                            <p class="fw-bold mb-0">Vignes</p>
                            <p class="text-muted small mb-0"><i class="far fa-clock"></i> 12 mins ago</p>
                        </div>
                        <div class="card-body">
                            <p class="mb-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-dasharray="15" stroke-dashoffset="15" stroke-linecap="round" stroke-width="2" d="M12 3C16.9706 3 21 7.02944 21 12"><animate fill="freeze" attributeName="stroke-dashoffset" dur="0.3s" values="15;0" /><animateTransform attributeName="transform" dur="1.5s" repeatCount="indefinite" type="rotate" values="0 12 12;360 12 12" /></path></svg>
                            </p>
                        </div>
                    </div>
                </li>
            </ul>
            <!-- QUESTION INPUT -->
            <div id="questionInputHolder" class="input-group p-2" style="">
                <input id="UserChatInputElement" class="rounded-0 rounded-start-4 form-control dropdown-toggle text-start" data-bs-toggle="dropdown" aria-expanded="false" type="text" placeholder="" aria-label="">
                <ul id="UserPresetDropDownElement" class="dropdown-menu rounded-4" aria-labelledby="UserChatInputElement" style="position: absolute;"></ul>
                <button id="SendChatButton"
                        onclick="window.vedastro.horoscopechat.onClickSendChat()"type="button"
                        class="rounded-0 rounded-end-4 btn btn-success btn-rounded float-end">
                            <span class="iconify me-1" data-icon="majesticons:send" data-width="25" data-height="25"></span>
                            Send
                </button>
            </div>
            <div id="personSelectorHolder" style="display:none;" class="input-group p-2" style="">
                <span class="input-group-text gap-2 rounded-0 rounded-start-4 text-end">
                    I want to talk about 
                </span>
                <select class="form-select" id="PersonListDropdown" onchange="window.vedastro.horoscopechat.onSelectPerson(this)">
                     <option value="" selected>Select Horoscope</option>
                     <option value="AddNewPerson" style="font-weight: 700; color: blue;" >Add New Person</option>
                </select>
                <button id="StartChatButton"
                        onclick="window.vedastro.horoscopechat.onStartChatButton()"type="button"
                        class="rounded-0 rounded-end-4 btn btn-success btn-rounded float-end">
                            <span class="iconify me-1" data-icon="majesticons:send" data-width="25" data-height="25"></span>
                            Start Chat
                </button>
            </div>
        </div> 
     `;
    }

    //called direct from static HTML hookup without seperate attach code
    //exp use : onclick="window.vedastro.horoscopechat.rate_message(this, -1)"
    onClickPresetQuestion(eventData) {
        //6: autofill preset questions handle (attach after generate)
        var selectedText = $(eventData).text();
        $("#UserChatInputElement").val(selectedText);
    }

    initializeSettingData(rawSettings) {

        //correct if property names is camel case (for Blazor)
        var settings = CommonTools.ConvertCamelCaseKeysToPascalCase(rawSettings);

        //expand data inside settings input
        this.ElementID = settings.ElementID;
        this.ShowHeader = settings.ShowHeader;
        this.HeaderIcon = settings.HeaderIcon;

        //birth time can be inserted at init 

        this.SelectedBirthTime = settings.SelectedBirthTime;


        //GUI LOAD SAVED VALUES
        //load settings stored browser storage, reflected in gui
        let isLocalServerModeStr = localStorage.getItem("IsLocalServerMode");
        $("#useLocalServerSwitchInput").prop(
            "checked",
            JSON.parse(isLocalServerModeStr)
        );

    }

    //this makes sure the input element has dynamic text and dropdowns work well
    initializeChatInputElement() {

        //preset questions used by both elements below
        let presetQuestions = ['\uD83E\uDDD1\u200D\uD83C\uDFA8 Will higher educational benefit me?', '\uD83C\uDF7B Will a party lifestyle benefit me?', '\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC66 Who will benefit me more friends or family?', '\uD83D\uDC9D Will marriage bring me happiness?', '\uD83D\uDE4F Will becoming a monk benefit me?', '\uD83D\uDE0D Predict my sex life?', '\uD83C\uDF0D Can travel improve my life?', '\uD83C\uDF78 Why am I an alcoholic?', '\uD83D\uDCCA Will I succeed in stock trading?', '\uD83E\uDD29 Will I become famous?', '\uD83D\uDCB0 Will I become a millionaire?', '\uD83D\uDC98 Describe my future wife?', '\uD83D\uDC74 Relationship with my father?', '\uD83C\uDFB0 Can I win lottery prize?', '\uD83C\uDF0D Special yogas in my chart?', '\uD83D\uDCDA Best career for me?', '\uD83C\uDF93 Will I get foreign education?'];


        //build the input element
        initializeInputElement();

        //then build the preset downdown
        initializePresetDropdownElement();


        //--------LOCAL

        function initializeInputElement() {
            let $inputField = $('#UserChatInputElement'); // replace 'chatInput' with your input field's ID
            let currentQuestionIndex = 0;
            let currentCharIndex = 0;
            let isUserTyping = false;

            function resetTyping() {
                currentCharIndex = 0;
                currentQuestionIndex = (currentQuestionIndex + 1) % presetQuestions.length;
                $inputField.attr('placeholder', ''); // clear the placeholder
            }

            function typeQuestion() {
                if (!isUserTyping) {
                    if (currentCharIndex < presetQuestions[currentQuestionIndex].length) {
                        $inputField.attr('placeholder', $inputField.attr('placeholder') + presetQuestions[currentQuestionIndex][currentCharIndex]);
                        currentCharIndex++;
                        setTimeout(typeQuestion, 30); // type each character every 100 milliseconds
                    } else {
                        setTimeout(resetTyping, 3000); // wait 3 seconds before starting the next question
                        setTimeout(typeQuestion, 3000);
                    }
                }
            }

            typeQuestion();

            $inputField.on('input', function () {
                isUserTyping = true;
                if ($inputField.val() === '') { // if input field is empty
                    // start typing the question again after a little while (2 seconds)
                    setTimeout(function () {
                        isUserTyping = false;
                        typeQuestion();
                    }, 2000);
                }
            });


            //1:handle user press "Enter" equal to clicking send button
            $("#UserChatInputElement").keypress((e) => {
                if (e.which === 13) {
                    // Enter key pressed
                    window.vedastro.horoscopechat.onClickSendChat();
                    e.preventDefault(); // Prevents the default action
                }
            });

        }

        function initializePresetDropdownElement() {
            let dropdownElement = document.getElementById('UserPresetDropDownElement');

            // Clear the dropdown
            dropdownElement.innerHTML = '';

            // Fill the dropdown with the array data using HTML string interpolation
            for (let i = 0; i < presetQuestions.length; i++) {
                dropdownElement.innerHTML += `<li class="dropdown-item" onclick="window.vedastro.horoscopechat.onClickPresetQuestion(this)" style="cursor: pointer; margin-left:-4px;">${presetQuestions[i]}</li>`;
            }
        }
    }

    initializeChatMainBody() {
        //CHAT GUI INJECTION
        //clear old gui data if any

        $(`#${this.ElementID}`).empty();

        //set max width here since declared in html
        $(`#${this.ElementID}`).css("max-width", "667px");

        //random ID for edit button
        this.EditButtonId = Math.floor(Math.random() * 1000000);

        //inject into page
        $(`#${this.ElementID}`).html(this.generateHtmlBody());


        //if birth time not yet set, aka person not selected
        if (this.SelectedBirthTime == undefined) {
            //show person selector
            $("#personSelectorHolder").show();
            //hide normal chat input
            $("#questionInputHolder").hide();

            //generate person list drop down
            GeneratePersonListDropdown();

            //enter inviting message from AI
            //note: the minimal message strucuture
            let jsonObject = {
                "Text": String.fromCodePoint(0x1F44B) + " Hi, I'm your AI astrologer. Any questions?",
                "TextHtml": String.fromCodePoint(0x1F44B) + " Hi, I'm your AI astrologer. Any questions?",
                "TextHash": Math.floor(Math.random() * 1000000), //keep random for injection
                "Commands": ["noFeedback"],
            };
            var aiReplyData = JSON.stringify(jsonObject);
            this.printAIReplyMessageToView(aiReplyData);

        }



        //---------

        async function GeneratePersonListDropdown(idToSelect = "") {
            //get the main dropdown element
            var $dropdown = $("#PersonListDropdown");

            //DO FOR USER'S SAVED LIST
            window.vedastro.PersonList = await CommonTools.GetAPIPayload(
                `${window.vedastro.ApiDomain}/GetPersonList/OwnerId/${window.vedastro.UserId}`
            );

            //create a header in the list
            let $horoscopeGroup = $("<optgroup>", {
                label: "Horoscopes",
            });

            $dropdown.append($horoscopeGroup); //add to main list

            //populate slection list at bottom with horoscopes
            $.each(window.vedastro.PersonList, function (i, person) {
                $horoscopeGroup.append(
                    $("<option>", {
                        value: person.PersonId,
                        text: person.Name,
                        selected: person.PersonId === idToSelect,
                    })
                );
            });

            //DO FOR PUBLIC LIST
            window.vedastro.PublicPersonList = await CommonTools.GetAPIPayload(
                `${window.vedastro.ApiDomain}/GetPersonList/OwnerId/101`
            );
            //create a header in the list
            let $publicHoroscopeGroup = $("<optgroup>", {
                label: "Example Horoscopes",
            });
            $dropdown.append($publicHoroscopeGroup); //add to main list

            //populate slection list at bottom with horoscopes
            $.each(window.vedastro.PublicPersonList, function (i, person) {
                $publicHoroscopeGroup.append(
                    $("<option>", {
                        value: person.PersonId,
                        text: person.Name,
                        selected: person.PersonId === idToSelect,
                    })
                );
            });
        }

    }


    //control comes here from both Button click and keyboard press enter
    async onClickSendChat(userInput = "") {
        //STEP 0 : Validation

        //make sure the chat input has something, else end here
        userInput = userInput === "" ? $("#UserChatInputElement").val() : userInput; //get chat message to send to API that user inputed
        if (userInput === "") {
            Swal.fire(
                "How to send nothing, sweetheart?",
                "Please <strong>type a question</strong> in the chatbox first. Also there's <strong>commonly asked questions</strong> on left of the input.",
                "error"
            );
            return;
        }

        //make sure AI is not busy talking
        if (window.vedastro.horoscopechat.IsAITalking) {
            Swal.fire(
                "Please wait, dear..",
                "AI is <strong>busy talking</strong>, please wait for it to <strong>finish</strong> chattering.",
                "error"
            );
            return;
        }

        //add top padding so top message don't hit top border
        if (!this.PaddingTopApplied) {
            $("#ChatWindowMessageList").addClass("pt-3");
            $("#ChatWindowMessageList").css("overflow", "auto");
            $("#ChatWindowMessageList").addClass("pe-2");
            this.PaddingTopApplied = true;
        }

        // STEP 1 : UPDATE GUI WITH USER MSG (UX)
        var aiInput = $("#UserChatInputElement").val();
        var userName = "You";
        var userInputChatCloud = `
        <li class="d-flex justify-content-end mb-4">
            <div class="card ">
                <div class="card-header d-flex justify-content-between py-2">
                    <p class="fw-bold mb-0">${userName}</p>
                </div>
                <div class="card-body">
                    <p class="mb-0">
                        ${userInput}
                    </p>
                </div>
            </div>
            <img src="https://mdbcdn.b-cdn.net/img/Photos/Avatars/avatar-6.webp" alt="avatar"
                 class="rounded-circle d-flex align-self-start ms-1 shadow-1-strong" width="45">
        </li>
        `;
        //inject in User's input into chat window
        $("#ChatWindowMessageList li").eq(-1).after(userInputChatCloud);


        // STEP 2 : UPDATE GUI WITH "THINKING" MSG (UX)




        //STEP 2 : GUI CLEAN UP
        //clear question input box for next, question
        $("#UserChatInputElement").val("");

        //STEP 3:
        //user's input is sent to server for reply
        //get selected birth time
        //TODO can be DOB or bookname
        //var timeInputUrl = CommonTools.BirthTimeUrlOfSelectedPersonJson();
        //var timeInputUrl = "Location/Ipoh/Time/12:44/23/04/1994/+08:00";

        //show temperoray "Thinking" message to user before calling API as that will take time
        this.showTempThinkingMessage();

        //send user's message
        var aiReplyData = await this.sendMessageToServer(this.SelectedBirthTime, userInput);
        this.LastUserMessage = userInput; //save to used later for highlight

        //update local session id
        this.SessionId = aiReplyData["SessionId"];

        //print to user
        this.printAIReplyMessageToView(aiReplyData);

        //hide thinking message, for less clutered UX
        this.hideTempThinkingMessage();


    }

    //sends final user message to API server and returns only relevant text (handles errors)
    async sendMessageToServer(timeInputUrl, userQuestionInput) {

        //construct the final URL
        userQuestionInput = userQuestionInput.replace(/\?/g, ''); //remove question marks as it break API detection
        const url = `${this.LiveServerURL}/HoroscopeChat/${timeInputUrl}/UserQuestion/${userQuestionInput}/UserId/${window.vedastro.UserId}/SessionId/${this.SessionId}`;

        try {
            const response = await fetch(url);
            const data = await response.json();

            if (data.Status === "Pass") {
                return data.Payload["HoroscopeChat"];
            } else {
                console.error(`Request failed with status: ${data.Status}${data.Payload}`);

                //note: the minimal message strucuture
                let jsonObject = {
                    "Text": "Sorry sir, my server brain is not talking...\nPlease try again later.",
                    "TextHtml": "Sorry sir, my server brain is not talking...\nPlease try again later.",
                    "TextHash": Math.floor(Math.random() * 1000000), //keep random for injection
                    "Commands": ["noFeedback"]
                };
                return JSON.stringify(jsonObject);
            }
        } catch (error) {
            console.error(`Error making GET request: ${error}`);

            //note: the minimal message strucuture
            let jsonObject = {
                "Text": "Sorry sir, my server brain is not talking...\nPlease try again later.",
                "TextHtml": "Sorry sir, my server brain is not talking...\nPlease try again later.",
                "TextHash": Math.floor(Math.random() * 1000000), //keep random for injection
                "Commands": ["noFeedback"]
            };
            return JSON.stringify(jsonObject);
        }
    }

    // Handler for incoming messages
    printAIReplyMessageToView(rawJson) {

        // Initialize rawJsonMessage
        var rawJsonMessage;

        // Try to parse the JSON data from the event
        try {
            rawJsonMessage = JSON.parse(rawJson);
        } catch (error) {
            //expected fail because no need parse
            rawJsonMessage = rawJson;
        }
        var aiTextMessageHtml = rawJsonMessage.TextHtml;
        var messageHash = rawJsonMessage.TextHash;
        var aiTextMessage = rawJsonMessage.Text;
        var followupQuestions = rawJsonMessage?.FollowUpQuestions ?? [];

        //PROCESS SERVER COMMANDS
        var commands = rawJsonMessage.Commands || []; // when no commands given empty to not fail

        //## SPECIAL HANDLE FOR LOGIN PROMPTS
        //1: check if server said please login, in command to client
        //   meaning user just say login message given by server,
        //   upon click login, start wait loop (make it seem bot is waiting for user to login)
        //   then that special login tab (RememberMe) will auto close

        let intervalId;
        if (commands.includes("pleaseLogin")) {
            //TODO maybe not needed anymore
            //set marker in browser asking Blazor login page to redirect back
            localStorage.setItem('PreviousPage', '/ChatAPI');
        }

        //## BUILD HTML

        //HANDLE FOLLOWUP
        // only add follow up questions if server specified them
        var followupQuestionsHtml = "";
        // convert questions into visible buttons, for user to click
        if (followupQuestions.length > 0) {
            followupQuestionsHtml += //start out hidden, then js will bring to live with animation at right time (class)
                '<div class="followUpQuestionHolder hstack gap-2 w-100 justify-content-end" style="display:none; position: absolute; bottom: -43px; right: -1px; ">';

            followupQuestions.forEach(function (question) {
                followupQuestionsHtml += `
            <button type="button" onclick="window.vedastro.horoscopechat.askFollowUpQuestion(this, '${question}')"  class="btn btn-outline-primary">${question}</button>
        `;
            });

            followupQuestionsHtml += "</div>";
        }

        //HANDLE FEEBACK BUTTON
        //only hide feedback button if server explicitly says so
        var feedbackButtonHtml = commands.includes("noFeedback")
            ? ""
            : `<div class="hstack gap-2">
    <button title="Bad answer" type="button" onclick="window.vedastro.horoscopechat.rateMessage(this, -1)" class="btn btn-danger" style="padding: 0px 5px;">
      <span class="iconify" data-icon="icon-park-outline:bad-two" data-width="18" data-height="18"></span>
    </button>
    <button title="Good answer" type="button" onclick="window.vedastro.horoscopechat.rateMessage(this, 1)" class="btn btn-primary" style="padding: 0px 5px;">
      <span class="iconify" data-icon="icon-park-outline:good-two" data-width="18" data-height="18"></span>
    </button>
  </div>`;


        //define html for answer
        var aiFinalAnswerHolder = `
            <div style="display:none;" class="text-html-out-elm mb-0">
                ${aiTextMessageHtml}
            </div>
        `;

        // Create a chat bubble with the AI's message
        var aiInputChatCloud = `
        <li class="d-flex justify-content-start" style=" margin-bottom: 70px; ">
            <img src="https://vedastro.org/images/vignes-chat-avatar.webp" alt="avatar" class="rounded-circle d-flex align-self-start me-1 shadow-1-strong" width="45">
            <div class="card">
                <div class="card-header d-flex justify-content-between py-2">
                    <p class="fw-bold mb-0 me-5">Vignes</p>
                    ${feedbackButtonHtml}
                </div>
                <div id="${messageHash}" class="message-holder card-body">
                    ${aiFinalAnswerHolder}
                    <p class="temp-text-stream-elm mb-0">
                      <!-- Content will be streamed here -->
                    </p>
                    <!-- SVG for loading icon -->
                    <svg class="loading-icon-elm" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-dasharray="15" stroke-dashoffset="15" stroke-linecap="round" stroke-width="2" d="M12 3C16.9706 3 21 7.02944 21 12"><animate fill="freeze" attributeName="stroke-dashoffset" dur="0.3s" values="15;0" /><animateTransform attributeName="transform" dur="1.5s" repeatCount="indefinite" type="rotate" values="0 12 12;360 12 12" /></path></svg>
                    ${followupQuestionsHtml}
                </div>
            </div>
        </li>
        `;

        // Append the chat bubble to the chat window
        $("#ChatWindowMessageList li").eq(-1).after(aiInputChatCloud);

        // # AUTO SCROLL DOWN
        $("#ChatWindowMessageList").scrollTop(
            $("#ChatWindowMessageList")[0].scrollHeight
        );

        // Flag to prevent user input while AI is 'typing'
        //NOTE: access via global, because deeply nested
        window.vedastro.horoscopechat.IsAITalking = true;


        // Initialize the index for streaming text
        let index = 0;
        const streamRateMs = 23; // Rate at which characters are displayed

        // Stream the AI's message into the chat bubble
        const interval = setInterval(() => {
            // Check if the entire message has been displayed
            //MESSAGE STREAM COMPLETE
            if (index >= aiTextMessage.length) {
                clearInterval(interval);

                // Hide the temporary element and loading icon, then show the formatted message
                //remove stream shower and loading for this bubble since not needed anymore
                //$(`#${messageHash} .temp-text-stream-elm`).hide();
                $(`#${messageHash} .loading-icon-elm`).hide();

                //make visible hidden formatted output
                //$(`#${messageHash} .text-html-out-elm`).show();

                // Allow user input again
                this.IsAITalking = false;

                // # AUTO SCROLL DOWN
                $("#ChatWindowMessageList").scrollTop(
                    $("#ChatWindowMessageList")[0].scrollHeight
                );

                //make follow up questions if any slowly appear
                //narrow by message bubble, then holder
                $(`#${messageHash} .followUpQuestionHolder`).fadeIn("slow");

                return;
            }

            // Append the next character or handle special formatting
            appendNextCharacter(
                aiTextMessage,
                index,
                `#${messageHash} .temp-text-stream-elm`
            );
            index++;

            // # AUTO SCROLL DOWN
            $("#ChatWindowMessageList").scrollTop(
                $("#ChatWindowMessageList")[0].scrollHeight
            );

            //------locals---------

            // Function to append the next character or handle special formatting
            function appendNextCharacter(text, index, elementSelector) {
                const specialChars = {
                    "\n": $("<br>"),
                    "\t": $("<span>").html("&nbsp;&nbsp;&nbsp;&nbsp;"),
                    " ": $("<span>").html("&nbsp;"),
                    "<": $("<span>").html("&lt;"),
                    ">": $("<span>").html("&gt;"),
                };

                // Check for special characters
                if (specialChars[text[index]]) {
                    $(elementSelector).append(specialChars[text[index]]);
                } else {
                    // Append regular character
                    const nextChar = document.createTextNode(text[index]);
                    $(elementSelector).append(nextChar);
                }
            }

        }, streamRateMs);


    }

    async showTempThinkingMessage() {

        //little lag for simulation reality
        await CommonTools.delay(1000);

        //define html for answer
        var aiFinalAnswerHolder = `
            <div class="text-html-out-elm mb-0">
                Thinking...
                <svg class="loading-icon-elm" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-dasharray="15" stroke-dashoffset="15" stroke-linecap="round" stroke-width="2" d="M12 3C16.9706 3 21 7.02944 21 12"><animate fill="freeze" attributeName="stroke-dashoffset" dur="0.3s" values="15;0" /><animateTransform attributeName="transform" dur="1.5s" repeatCount="indefinite" type="rotate" values="0 12 12;360 12 12" /></path></svg>
            </div>
        `;

        // Create a chat bubble with the AI's message
        var aiInputChatCloud = `
        <li id="tempThinkingMshBubble" class="d-flex justify-content-start" style=" margin-bottom: 70px; ">
            <img src="https://vedastro.org/images/vignes-chat-avatar.webp" alt="avatar" class="rounded-circle d-flex align-self-start me-1 shadow-1-strong" width="45">
            <div class="card">
                <div class="card-header d-flex justify-content-between py-2">
                    <p class="fw-bold mb-0 me-5">Vignes</p>                   
                </div>
                <div class="message-holder card-body">
                    ${aiFinalAnswerHolder}                   
                </div>
            </div>
        </li>
        `;

        // Append the chat bubble to the chat window
        $("#ChatWindowMessageList li").eq(-1).after(aiInputChatCloud);

        // # AUTO SCROLL DOWN
        $("#ChatWindowMessageList").scrollTop(
            $("#ChatWindowMessageList")[0].scrollHeight
        );

        // Flag to prevent user input while AI is 'typing'
        //NOTE: access via global, because deeply nested
        window.vedastro.horoscopechat.IsAITalking = true;



    }

    hideTempThinkingMessage() {
        $("#tempThinkingMshBubble").remove();

        // Flag to prevent user input while AI is 'typing'
        //NOTE: access via global, because deeply nested
        window.vedastro.horoscopechat.IsAITalking = false;

    }

    //called here direct from HTML button
    async askFollowUpQuestion(eventData, followUpQuestion) {

        //make sure AI is not busy talking
        if (window.vedastro.horoscopechat.IsAITalking) {
            Swal.fire(
                "Please wait, dear..",
                "AI is <strong>busy talking</strong>, please wait for it to <strong>finish</strong> chattering.",
                "error"
            );
            return;
        }

        // get hash of message, stored as id in holder
        var messageHolder = $(eventData)
            .closest(".card")
            .children(".message-holder");
        var primaryAnswerHash = messageHolder.attr("id");

        //UPDATE GUI WITH USER MSG (UX)
        var aiInput = $("#UserChatInputElement").val(); //clear chat input
        var userName = "You";
        var userInputChatCloud = `
        <li class="d-flex justify-content-end mb-4">
            <div class="card ">
                <div class="card-header d-flex justify-content-between py-2">
                    <p class="fw-bold mb-0">${userName}</p>
                </div>
                <div class="card-body">
                    <p class="mb-0">
                        ${followUpQuestion}
                    </p>
                </div>
            </div>
            <img src="https://mdbcdn.b-cdn.net/img/Photos/Avatars/avatar-6.webp" alt="avatar"
                 class="rounded-circle d-flex align-self-start ms-1 shadow-1-strong" width="45">
        </li>
        `;
        //inject in User's input into chat window
        $("#ChatWindowMessageList li").eq(-1).after(userInputChatCloud);


        //show temperoray "Thinking" message to user before calling API as that will take time
        this.showTempThinkingMessage();

        //prepare message and send to caller
        //construct the final URL
        var followUpAIReplyData = await getFollowUpAIReplyFromAPI(followUpQuestion, primaryAnswerHash);

        //inject reply into view
        //print to user
        this.printAIReplyMessageToView(followUpAIReplyData);

        //hide thinking message, for less clutered UX
        this.hideTempThinkingMessage();


        //--------------local funcs
        async function getFollowUpAIReplyFromAPI(followUpQuestion, primaryAnswerHash) {

            followUpQuestion = followUpQuestion.replace(/\?/g, ''); //remove question marks as it break API detection
            const url = `${window.vedastro.horoscopechat.LiveServerURL}/HoroscopeFollowUpChat/${window.vedastro.horoscopechat.SelectedBirthTime}/FollowUpQuestion/${followUpQuestion}/PrimaryAnswerHash/${primaryAnswerHash}/UserId/${window.vedastro.UserId}/SessionId/${window.vedastro.horoscopechat.SessionId}`;


            try {
                const response = await fetch(url);
                const data = await response.json();

                if (data.Status === "Pass") {
                    return data.Payload["HoroscopeFollowUpChat"];
                } else {
                    console.error(`Request failed with status: ${data.Status}${data.Payload}`);

                    //note: the minimal message strucuture
                    let jsonObject = {
                        "Text": "Sorry sir, my server brain is not talking...\nPlease try again later.",
                        "TextHtml": "Sorry sir, my server brain is not talking...\nPlease try again later.",
                        "TextHash": Math.floor(Math.random() * 1000000), //keep random for injection
                        "Commands": ["noFeedback"]
                    };
                    return JSON.stringify(jsonObject);
                }
            } catch (error) {
                console.error(`Error making GET request: ${error}`);

                //note: the minimal message strucuture
                let jsonObject = {
                    "Text": "Sorry sir, my server brain is not talking...\nPlease try again later.",
                    "TextHtml": "Sorry sir, my server brain is not talking...\nPlease try again later.",
                    "TextHash": Math.floor(Math.random() * 1000000), //keep random for injection
                    "Commands": ["noFeedback"]
                };
                return JSON.stringify(jsonObject);
            }

        }

    }

    //called direct from static HTML hookup without seperate attach code
    //exp use : onclick="window.vedastro.horoscopechat.rateMessage(this, -1)"
    async rateMessage(eventData, rating) {
        //come here on click rating button
        // get hash of message, stored as id in holder
        var messageHolder = $(eventData)
            .closest(".card")
            .children(".message-holder");
        var textHash = messageHolder.attr("id");

        //send feedback to API 
        var feedbackAIReplyData = await SendFeedbackToApi(textHash, rating);

        //inject reply into view
        //print to user
        this.printAIReplyMessageToView(feedbackAIReplyData);

        //hide thinking message, for less clutered UX
        this.hideTempThinkingMessage();


        //--------------local funcs
        async function SendFeedbackToApi(answerHash, feedbackScore) {

            const url = `${window.vedastro.horoscopechat.LiveServerURL}/HoroscopeChatFeedback/AnswerHash/${answerHash}/FeedbackScore/${feedbackScore}`;

            try {
                const response = await fetch(url);
                const data = await response.json();

                if (data.Status === "Pass") {
                    return data.Payload["HoroscopeChatFeedback"];
                } else {
                    console.error(`Request failed with status: ${data.Status}${data.Payload}`);

                    //note: the minimal message strucuture
                    let jsonObject = {
                        "Text": "Sorry sir, my server brain is not talking...\nPlease try again later.",
                        "TextHtml": "Sorry sir, my server brain is not talking...\nPlease try again later.",
                        "TextHash": Math.floor(Math.random() * 1000000), //keep random for injection
                        "Commands": ["noFeedback"]
                    };
                    return JSON.stringify(jsonObject);
                }
            } catch (error) {
                console.error(`Error making GET request: ${error}`);

                //note: the minimal message strucuture
                let jsonObject = {
                    "Text": "Sorry sir, my server brain is not talking...\nPlease try again later.",
                    "TextHtml": "Sorry sir, my server brain is not talking...\nPlease try again later.",
                    "TextHash": Math.floor(Math.random() * 1000000), //keep random for injection
                    "Commands": ["noFeedback"]
                };
                return JSON.stringify(jsonObject);
            }

        }


    }

    async onStartChatButton(eventData) {


    }

    async onSelectPerson(eventData) {

        //attach topic selector dropdown
        //get all needed data (what topic was selected)
        const selectedOption = $("#PersonListDropdown option:selected");
        const selectedOptgroupLabel = selectedOption
            .closest("optgroup")
            .prop("label");

        //save what user choose for use throughout the code
        var selectedPersonId = selectedOption.val();

        //if id is add new person, then redirect page to add person site, same tab so refresh onreturn
        if (selectedPersonId == "AddNewPerson") {
            window.location.href = "http://vedastro.org/Account/Person/Add";
            return; //end here
        }

        //get full details of the person
        let selectedPerson = window.vedastro.PersonList.find(
            (obj) => obj.PersonId === selectedPersonId
        );

        //save for use by other
        window.vedastro.SelectedPerson = selectedPerson;

        //convert person name to birth DOB (so unregistered person can be checked)
        var newTopicId = CommonTools.BirthTimeUrlOfSelectedPersonJson();
        window.vedastro.horoscopechat.SelectedBirthTime = newTopicId;

        //person now selected, ready to chat so change GUI
        //show person selector
        $("#personSelectorHolder").hide();
        //hide normal chat input
        $("#questionInputHolder").show();

        //show user's selection on screen so explicit rememberence
        //UPDATE GUI WITH USER MSG (UX)
        var userName = "You";
        const locationName = window.vedastro.SelectedPerson["BirthTime"]["Location"]["Name"];
        const birthTime = window.vedastro.SelectedPerson[`BirthTime`][`StdTime`];
        const personName = window.vedastro.SelectedPerson[`Name`];
        var userInputChatCloud = `
        <li class="d-flex justify-content-end mb-4">
            <div class="card ">
                <div class="card-header d-flex justify-content-between py-2">
                    <p class="fw-bold mb-0">${userName}</p>
                </div>
                <div class="card-body">
                    <p class="mb-0">
                       Lets talk about <strong>${personName}</strong><br>
                       born on <strong>${birthTime}</strong><br>
                       at <strong>${locationName}</strong>
                    </p>
                </div>
            </div>
            <img src="https://mdbcdn.b-cdn.net/img/Photos/Avatars/avatar-6.webp" alt="avatar"
                 class="rounded-circle d-flex align-self-start ms-1 shadow-1-strong" width="45">
        </li>
        `;
        //inject in User's input into chat window
        $("#ChatWindowMessageList li").eq(-1).after(userInputChatCloud);

        //little lag for simulation reality
        await CommonTools.delay(1000);

        //reply with AI as ready to respond
        //enter inviting message from AI
        //note: the minimal message strucuture
        let jsonObject = {
            "Text": `Ok, I've analysed the horoscope.${String.fromCodePoint(0x1F9D0)} \nAny questions?`,
            "TextHtml": `Ok, I've analysed the horoscope.${String.fromCodePoint(0x1F9D0)} \nAny questions?`,
            "TextHash": Math.floor(Math.random() * 1000000), //keep random for injection
            "Commands": ["noFeedback"],
        };
        var aiReplyData = JSON.stringify(jsonObject);
        this.printAIReplyMessageToView(aiReplyData);



    }
}

/**
 * Shortcut method to initialize Horoscope Chat instace in 1 static call.
 * Used by Blazor to call JS code.
 */
window.GenerateHoroscopeChat = (settingsHoroscopeChat) => {

    //note: on init, chat instance is loaded into window.vedastro.horoscopechat
    new HoroscopeChat(settingsHoroscopeChat);
};
