﻿
<a href="https://vedastro.org">
<img
  src="https://vedastro.org/images/website-header-screenshot.png"
  alt="VedAstro.org"
  title="VedAstro.org">
</a>
<span align="center">

[![Ko-fi](https://img.shields.io/static/v1?style=for-the-badge&message=Ko-fi&color=FF5E5B&logo=Ko-fi&logoColor=FFFFFF&label=)](https://ko-fi.com/vedastro)
[![Patreon](https://img.shields.io/static/v1?style=for-the-badge&message=Patreon&color=FF424D&logo=Patreon&logoColor=FFFFFF&label=)](https://www.patreon.com/vedastro)
[![Card](https://img.shields.io/static/v1?style=for-the-badge&message=Card&color=blue&logo=PayPal&logoColor=FFFFFF&label=)](https://buy.stripe.com/7sI15E8rZepVbio289)
[![Slack](https://img.shields.io/static/v1?style=for-the-badge&message=Slack&color=4A154B&logo=Slack&logoColor=FFFFFF&label=)](https://join.slack.com/t/vedastro/shared_invite/zt-1u7pdqjky-hrJZ7e3_vM2dZOmVY8FeHA)
[![Facebook](https://img.shields.io/badge/Facebook-1877F2?style=for-the-badge&logo=facebook&logoColor=white)](https://www.facebook.com/vedastro.org)
[![Twitter](https://img.shields.io/badge/Twitter-1DA1F2?style=for-the-badge&logo=twitter&logoColor=white)](https://twitter.com/_VedAstro)
[![YouTube](https://img.shields.io/badge/YouTube-FF0000?style=for-the-badge&logo=youtube&logoColor=white)](https://www.youtube.com/@vedastro)

</span>
<span align="center">

![GitHub last commit](https://img.shields.io/github/last-commit/gen-so/Genso.Astrology)
![GitHub commit activity](https://img.shields.io/github/commit-activity/m/gen-so/Genso.Astrology)
[![License](https://img.shields.io/badge/license-MIT-blue.svg)](LICENSE.md)

</span>


# 🙏 How VedAstro can help you...

- [Website](https://vedastro.org/Docs/QuickGuide) --> easy & fast astrology data for **normal users**
- [JavaScript SDK](https://github.com/VedAstro/VedAstro/tree/master/Website/wwwroot/Demo/JavaScript) --> easy to use JS library to simplify API access and use
- [Learn Astro Computation](https://github.com/VedAstro/VedAstro/tree/master/Library/Logic/Calculate) --> learn exact math & logic used in astrology via **`Free Open Source`** code
- [Life Predictor](https://vedastro.org/LifePredictor) --> accurate algorithmic prediction of a human life's past and future
- [Build On Top](https://github.com/VedAstro/VedAstro/tree/master/Library/Logic/Calculate) --> import VedAstro code directly into your existing projects
- [15000 Famous People DOB](https://huggingface.co/datasets/vedastro-org/15000-Famous-People-Birth-Date-Location) --> Accurate birth dataset for Machine Learning & AI
- [15000 Famous People Marriage Info](https://huggingface.co/datasets/vedastro-org/15000-Famous-People-Marriage-Divorce-Info) --> Accurate marriage/divorce dataset for Machine Learning & AI


[![.NET](https://img.shields.io/static/v1?style=for-the-badge&message=.NET&color=512BD4&logo=.NET&logoColor=FFFFFF&label=)](https://www.nuget.org/packages/VedAstro.Library) [![Python](https://img.shields.io/badge/python-3670A0?style=for-the-badge&logo=python&logoColor=ffdd54)](https://pypi.org/project/VedAstro/)  [![Docker](https://img.shields.io/static/v1?style=for-the-badge&message=Docker&color=2496ED&logo=Docker&logoColor=FFFFFF&label=)](https://hub.docker.com/r/vedastro/api)

# 🆓 100% Open Source
The sage **`Parashara taught everybody`** the ways of astrology without asking money, as such VedAstro does the same.

![OpenSourceCode](https://vedastro.org/images/open-source-code-sample.png)


# 🛖 Philosophy
Philosophy's the scaffold we use when we build,<br>
Without it, a mud hut, not a structure fulfilled.<br>
For creating grand codes, like VedAstro’s design,<br>
Philosophy’s essential, its role is divine.<br>

The purpose of VedAstro, we must understand,<br>
Born of joy, in development it must stand.<br>
This project thrives on happiness, pure and bright,<br>
Don’t code till your heart feels the building's delight.<br>

When your fingers can’t keep up, joy fills the air,<br>
You’ll know that your code is placed right with care.<br>
In the universe vast, it finds its own way,<br>
Your work shines with brilliance, come what may.<br>

# 🎯 Perfect Predictions
[![LifePredictor](https://vedastro.org/images/proof/life-chart-proof-steve.jpg)](https://vedastro.org/LifePredictor)   
[![LifePredictor](https://vedastro.org/images/proof/life-chart-proof-monroe.jpg)](https://vedastro.org/LifePredictor)   
[![LifePredictor](https://vedastro.org/images/proof/life-chart-proof-hitler.jpg)](https://vedastro.org/LifePredictor)   
[![LifePredictor](https://vedastro.org/images/proof/life-chart-proof-elon.jpg)](https://vedastro.org/LifePredictor)   
[![MatchChecker](https://vedastro.org/images/marriage-prediction-perfect-example.png)](https://vedastro.org/Match)   
[![SkyChartGIF](https://vedastro.org/images/SkyChart/release-mk3.gif)](https://vedastro.org/Horoscope)   


# 📊 +200 Astro API Calls
Below is sample API call result for data related to "**Sun**" on "**30/06/2023**" at "**Singapore**"
--> [Watch Video Guide](https://www.youtube.com/watch?v=y110RAgIorY)
--> [JS Demo Files](https://github.com/VedAstro/VedAstro/tree/master/Demo/JavaScript)
--> [Demo API Call](https://vedastroapi.azurewebsites.net/api/Calculate/AllPlanetData/PlanetName/Sun/Location/Singapore/Time/00:00/24/04/2024/+08:00)
```json
 "Payload": {
    "SwissEphemeris": "{ Longitude = 97.672406549912, Latitude = 2.2248025536827577E-05, DistanceAU = 1.0165940297895264, SpeedLongitude = 0, SpeedLatitude = 0, SpeedDistance = 0 }",
    "AbdaBala": "0",
    "AspectedByMalefics": "False",
    "AyanaBala": "118.071100045034",
    "Benefic": "False",
    "ChestaBala": "0",
    "ConjunctWithMalefics": "True",
    "Constellation": "Aridra - 3",
    "Debilitated": "False",
    "Declination": "23.2284400180136",
    "DigBala": "5.222314814814815",
    "Drekkana": "Libra",
    "DrekkanaBala": "0",
    "DrikBala": "4.883715277777782",
    "Dwadasamsa": "Scorpio",
    "Exalted": "False",
    "HoraBala": "60",
    "HousePlanetIsIn": "5",
    "InKendra": "False",
    "IsPlanetInOwnHouse": "False",
    "IsPlanetStrongInShadvarga": "False",
    "KalaBala": "200.68443337836732",
    "KendraBala": "15",
    "Malefic": "True",
    "MasaBala": "0",
    "Moolatrikona": "False",
    "Motion": "Direct",
    "NaisargikaBala": "60",
    "NathonnathaBala": "5.709722222222221",
    "Navamsa": "Aquarius",
    "NirayanaLongitude": {
      "DegreeMinuteSecond": "74° 56' 18",
      "TotalDegrees": "74.93833333333333"
    },
    "OchchaBala": "38.35388888888889",
    "OjayugmarasyamsaBala": "30",
    "PakshaBala": "16.90361111111111",
    "PlanetHoraSign": "Leo",
    "PlanetsInConjuction": "Mercury",
    "ReceivingAspectFrom": "",
    "Saptamsa": "Virgo",
    "SaptavargajaBala": "91.875",
    "SayanaLatitude": {
      "DegreeMinuteSecond": "0° 0' 0",
      "TotalDegrees": "0"
    },
    "SayanaLongitude": {
      "DegreeMinuteSecond": "97° 40' 20",
      "TotalDegrees": "97.67222222222222"
    },
    "ShadbalaPinda": "446.02",
    "ShadvargaBala": "88.125",
    "Sign": {
      "Name": "Gemini",
      "DegreesIn": {
        "DegreeMinuteSecond": "14° 56' 17",
        "TotalDegrees": "14.938055555555556"
      }
    },
    "SignsPlanetIsAspecting": "Sagittarius",
    "Speed": "0.9533156649003025",
    "SthanaBala": "175.2288888888889",
    "TemporaryFriends": "Venus, Mars, Jupiter",
    "Thrimsamsa": "Sagittarius",
    "TotalStrength": "446.02",
    "TransmittingAspectToHouse": "House11",
    "TransmittingAspectToPlanet": "",
    "TribhagaBala": "0",
    "VaraBala": "0"
  }
```


<!--

# Examples of Accurate Predictions
The Dasa Life Calculator is the most advanced and amazingly accurate prediction tool we've ever seen.
Take a look at this example charts of Napoleon Bonaparte and Queen Elizabeth II. Every major event in their life
can be clearly seen predicted by the chart in the "Summary Row". Red for a bad event and green for a good life event.
Using a combination of Dasa, Bhukti, Antaram and Gocharam of 9 planets this complex chart can give perfect predictions!
The chart takes alot of computational power to generate, so please be patient after you click the Calculate button.

[![](GithubImages/napoleon-dasa-chart.png)](https://vedastro.org)
[![](GithubImages/elizabeth-dasa-chart.png)](https://vedastro.org)
 -->


# 📜 About
Anybody who has studied Vedic Astrology knows well how accurate it can be.
But also how complex it can get to make accurate predictions.
It takes **decades of experience** to be able make accurate prediction.
As such this knowledge only reaches a limited people.
This project is an effort to change that. [Read More](https://vedastro.org/About)

# 🎂 9 Years Old 
The first line of code for this project was written in **late 2014** at **Itä-Pasila**.
Started as a simple desktop software, with no UI and only text display.
With continued support from users, this project has steadily grown to what it is today. Helping people from all over the world. 🌍
    
# 📚 Credits &amp; Reference 
![credits](https://vedastro.org/images/bv-raman-rao.png)

Thanks to [B.V. Raman](https://en.wikipedia.org/wiki/B._V._Raman) and his grandfather B. Suryanarain Rao for pioneering easy to read astrology books. Credit also goes to [St. Jean-Baptiste de La Salle](https://en.wikipedia.org/wiki/Jean-Baptiste_de_La_Salle) for proving the **efficacy of free and open work** for the benefit of all men...[Read More](https://vedastro.org/About).


# 💌 Support
[![membership](https://vedastro.org/images/kofi-membership-page.png)](https://ko-fi.com/vedastro/tiers)


# 🧰 Gonzo Development Pattern
This development style celebrates the methodology of chaotic development at the benefit of low cost and fast paced prototyping.
Inspired by the concept of "**Gonzo Journalism**", pioneered by [Hunter S. Thompson](https://en.wikipedia.org/wiki/Hunter_S._Thompson) in the 1970s.

We favour this pattern for the development of VedAstro simply due to the volatile nature of this project.
Other development styles like "Waterfall" and "Scrum" are equally good when the need is.

✅ We want to :
- 💓 try out novel ideas at a heartbeat
- 📬 we want the latest platform 
- 💰 we want it cheap

Hence the "**gonzo development**" pattern is best suited for this needs.

<!--
### Beta & Stable
The negative side effect is that there will be bugs forever. Because it's near impossible to constantly
change an ever-growing code base without having to constantly fix breaking changes.
To deal with this, we split the Web App into Beta and Stable.

![gonzon-dev-button](https://vedastro.org/images/gonzon-dev-button.png)

Stable version will contain an old version of the App, while beta will always contain latest buildable code.
But the database will be shared between these. Meaning data changes in Beta will seen in Stable as well.
-->

 # 👶 Drunk Proof UI 
 We would like to introduce in this project a novel UX concept called "**Drunk Proofing**".
 The idea is simple. All UI is designed to be operated by an alcoholically intoxicated person aka drunk.

 Why? Because this forces the team to make a simple and intuitive UI design.
 It is all too easy during development to make a complicated UI that only coders understand.
 But it is far more difficult and **rewarding** to make the UI intuitive & easy.
 A "no manuals" and "no brainer" approach to design.

 
 # 🥀 Digital Astrology
The wisdom of ages, once passed down by word,<br>
Now stored in circuits, rarely heard.<br>

Once this knowledge was held in minds so keen,<br>
Now it's coded in machines unseen.<br>

The human touch, that once gave knowledge birth,<br>
Replaced by algorithms, shaping future's girth.<br>

<!-- # 🛖 Philosophy
Philosophy is equivalent to the **scaffolding** used when constructing a building.
You can build without **scaffolding** it is called a **mud hut** not a building.
Thus philosophy is essential to build a large & complex code structure like **VedAstro**.

The reason for the existence of **VedAstro** needs to be understood and kept in mind during development.
This is a project born of joy, kept alive by it and as such do not touch the code until 
your heart is filled with the joy of building beauty with electrons and your fingers can't keep up.

Then you know your code is right, and **has a place for it in this universe**.
-->

# 🙏 Special Thanks
<img src="https://pics.paypal.com/00/p/ZjU4ZjZiMjEtNDE0Ny00MGExLTg2ZTMtNzkxOTQ1MTI4Mzc0/image_34.PNG" width="100"/>

**Leslie Choi** : Believed in the project even when work was only half done.

<img src="https://play-lh.googleusercontent.com/Rya_zHj8gLRk3uenRehcLbfhSj-fushukfQH-JbtO2-hbJTRyr43F42Z9CrypGMacyY=w240-h480-rw" width="100"/>

**[Swarn Siddhi](https://swarnsiddhi.com/)** : The makers of this awesome app keep this VedAstro project alive 

<img src="https://resources.jetbrains.com/storage/products/company/brand/logos/jb_beam.png" width="100"/>

**JetBrains** : Gave free "ReSharper License" that made coding life easier.

# ❤️ Social
Just **Like** & **Share** our social pages and it'll be a **big** help already!

[![Instagram](https://img.shields.io/badge/Instagram-E4405F?style=for-the-badge&logo=instagram&logoColor=white)](https://www.instagram.com/_vedastro/)
[![Facebook](https://img.shields.io/badge/Facebook-1877F2?style=for-the-badge&logo=facebook&logoColor=white)](https://www.facebook.com/vedastro.org)
[![Twitter](https://img.shields.io/badge/Twitter-1DA1F2?style=for-the-badge&logo=twitter&logoColor=white)](https://twitter.com/_VedAstro)
[![YouTube](https://img.shields.io/badge/YouTube-FF0000?style=for-the-badge&logo=youtube&logoColor=white)](https://www.youtube.com/@vedastro)

<!--
# 👪 Join our family
If you want to do more than just click "Like" & "Share", then [join us.](https://vedastro.org/JoinOurFamily)  
We're always looking for somebody to **[improve code.](https://vedastro.org/JoinOurFamily)** or **[help with funding](https://vedastro.org/Donate)**.
-->

# 🙋‍♂️ Come say "Hi", we don't bite!
We discuss & share ideas on astrology and computation. And ways you can integrate VedAstro into your own project.
<!-- SLACK JOIN IMAGE -->
[![image](https://user-images.githubusercontent.com/43817262/227275627-609ceb21-025a-4902-b552-6e12f62f2f9d.png)](https://join.slack.com/t/vedastro/shared_invite/zt-1u7pdqjky-hrJZ7e3_vM2dZOmVY8FeHA)


# ⚙️ Project Structure
![vedastro-4-parts](https://vedastro.org/images/4-parts-of-vedastro.jpg)

## Core Library Explained
The main part of the program is the prediction/event generator.
It works by combining **logic** on how to calculate a prediction with **data** about that prediction.
This is done everytime a "Calculate" button is clicked. Below you will see a brief explanation of this process.
This method was chosen to easily accommodate the thousands of astrological calculation possibilities.

## event prediction = (data + logic) * time

```

            CREATION OF AN EVENT/PREDICTION

STEP 1

Hard coded event data like name is stored in XML file.
A copy of the event name is stored as Enum to link
Calculator Methods with data from XML.
These static methods are the logic to check
if an event occurred. No astro calculation done at this stage.
This is the linking process of the logic and data.

                      -------+
                             |
     +-----------------+     |
     | Event Data (xml)|     |
     +-----------------+     |
              +              |
     +------------------+    |
     |Event Names (Enum)|    +-----> Event Data (Instance)
     +------------------+    |
              +              |
     +------------------+    |
     |Calculator Methods|    |
     +------------------+    |
                             |
                       ------+


STEP 2

From the above step, list of Event Data is generated.
Is occuring logic of each Event Data is called with time slices,
generated from a start time & end time (inputed at runtime).
An Event is created if IsOccuring is true.
This's a merger of Time and EventData to create an
Event at a specific time. This Event is then used
throughout the program.



              Event Data    +    Time Range
                 List               List
                            |
                            |
                            |
                            v

                        Event List


```

## Website
```
+--------+          +------------------------+                +------------------+
|  User  | <------+ |        Website         | -------------> |        API       |
|        | +------> | - Blazor WebAssembly   | <------------- | -Azure Functions |
+--------+   GUI    | - Azure Static WebApp  |      XML       |                  |
                    |                        |                |                  |
                    +------------------------+                +------------------+
```

<!--
# ⚙️ Setup Guide

### Prerequisite
- Visual Studio 2022
- Target .Net 8.0

### Steps
- Fork the project and Checkout in your local.
- Go to history and checkout commit tagged with stable otherwise you might face API to webside mismatch
- Open the project in Visual Studio
- Right click and unload below projects (as you don't need these for general project work)
  - API.Python
  - Console
  - Library.API
  - StaticTableGenerator
- Right click on project and 'Build Solution' (If face any issues please post in Slack channel for support)
- If you want to run against server running API you need to set "Website" as "startup project" by right click
  - Now from Run menu in toolbar (dark Green Arrow) select "IISExpress" (dont select Website)
  - this will open a browser window, you can copy the URL and paste to open in other main browser window so that you can use logged in Google/Facebook Auth 
- If you want to run against your local running VedAstro APIs then 
  - stop the running website in local and then do below steps  
  - you need to open one more instance of VS2022 
  - open same project, and now set API as "startup project" for that VS instance 
  - find local.settings.sample.json file  (contact Slack Channel to get these properties - these are sensitive so not need to be checked in)
  - and rename it by removing "sample" from the name and it become "local.settings.json"
  - Now from Run menu in toolbar (dark Green Arrow) select "API" (not need to select Docker) 
  - this will open a command window and show APIs initialized (if any error please connect @ Slack Vedastro channel)
  - run the website using above steps and then login using your Facebook or Google OAuth 
  - go to provide and Enable Debug, save (this will instruct the code to look for API in local).

Now you can have fun with VedAstro, ;-) try making horoscope and share your feedback in Slack channel. 
-->

# Code Edit Guide

### Internal Project Linking
all 3 independent, only linked in VS for easy access
don't commit local referenced .csproj to Git as it'll be used by CI/CD

### To add a new prediction/event
1. Create a method in EventCalculatorMethods.cs
2. Add the name in EventNames.cs
3. Add the prediction/event details HoroscopeDataList.xml

### To add a new Event Tag
1. Edit in Genso.Astrology.Library EventTag enum. Change here reflects even in GUI


# Design Decision Notes
These are randomly ordered notes on why a feature was implemented in a certain way.<br/>
Will prove usefull when debugging & upgrading code.

## Handling SEO bots via Rules
Shows only clean & nice html index for bots from best known SEs

## Stop 404 error
for direct access Blazor page via static storage without 404 error
since no page actually exists at page url, blazor takes url and runs the page as app
using rule engine this is possible
rules also make sure not to redirect file & api access only page access
- not begins with "/api/"
- has a path
- Sec-Fetch-Mode = navigate
- Sec-Fetch-Dest = document

## Domain redirection #06/03/2023
web : vedastro.org -> domain registra -> azure DNS -> azure cdn -> web blob storage
api **stable** : api.vedastro.org -> domain registra -> azure DNS -> azure cdn -> stable api server (render)
api **beta** : beta.api.vedastro.org -> domain registra -> azure DNS -> azure cdn -> beta api server (azure)
domain cert managed by lets encyrpt acme bot azure func

## API domain is routed # MAR 2023
via Azure CDN Rules Engine, this allows the use of ```api.vedastro.org/...``` & ```api.vedastro.org/nlp/...```

## Antaram > Sukshma > Prana > Avi Prana > Viprana  # FEB 2023
Since not documented by BV. Raman, code here is created through experimentation by
repeating relationship between Dasa planet & Bhukti planet.

## Skipping EventDataList.xml # FEB 2023
Not all data regarding an event is hardwired. Generating gochara, antaram, sukshma and others is more effcient if description was created by Astronomical calculator
At the moment EventDataList.xml is the source of truth, meaning if an event exists in xml file, then it must exist in code.

## Direct Events Chart # NOV 2022
- Accessing events chart directly via API generated html
- CORS in Azure Website Storage needs to be disabled for this to work, outside of vedastro.org

## Events Chart default timezone # NOV 2022
The default timezone generated for all svg charts will be based on client timezone.
Timezone does not matter when full life charts are made, but will matter alot when
short term muhurtha charts are generated. Since most users are not living where they were born,
it is only logical to default it client browser's timezone.
This timezone must be visible/changeable to users who need to use otherwise.

## Event Chart Notes : Life Events # APR 2022
- This feature is to store notes on the dasa report
- The notes are actualy Events converted to XML and stored inside each person's record
- When rendering these events are placed on top dasa report view

## WEBSITE : Why astrological calculation done on API server and not in client (browser) via webassmebly?
- The calculations tested on Intel Xeon with parallel procesing takes about 1GB RAM & 30% CPU.
With these loads browsers with mobile CPU's are going to be probelmatic for sure.
So as not to waste time, the API route has been decided since it has been proven to work.
- There are places where all Astronomical computation is done in client, exp. Planet Info Box 


## MUHURTHA : Notes On Gochara Prediction (from book ) # FEB 2022

- Built on reference to, Hindu Predictive Astrology pg. 254

- Asthavarga bindus are different from shadbala and it is to be implemented soon.
- Asthavarga bindus are not yet account for, asthavarga good or bad nature of the planet.
  It is assumed that Shadbala system can compensate for it.

- This passage on page 255 needs to be clarified
"It must be noted that when passing through the first 10
degrees of a sign, Mars and the Sun produce results."

- It's interpreted that Vendha is an obstruction and not a reversal of the Gochara results
  So as for now the design is that if a vedha is present than the result is simply nullified.

- In Horoscope predictions methods have "time" & "person" arguments available, 
  obvioulsy "time" is not needed, but for sake of semantic similarity 
  with Muhurtha methods this is maintained.


## Zoom functionality in Dasa View Box

  - Option 1 : generate a high res image (svg/html) and zoom horitontally into it
              - very fast
              - image gets blurry

  - Option 2 : Regenerate whole component in Blazor
              - very slow
              - hard to implement with touch screen

  - Option 3 : Generate multiple preset zooms, than place them on top of each other,
               and only make visible what is needed via selector
              - complicated, needs documentation
              - easy touch screen implimentation
              - very fast

Thus Option 3 was chosen.

## Astrology Library: Use of Struct vs Class
-   Structs are used to reduce overhead from large collections, exp. List<>
-   When structs are part of a class, they are stored in the heap. An additional benefit is that structs need less memory than a class because they have no ObjectHeader or MethodTable. You should consider using a
    struct when the size of the struct will be minimal (say around 16 bytes), the struct will be short-lived, or the struct will be immutable.


## Person Get Hash uses MD5
- default hashing is inconsistent, MD5 is used
- many class's get hash overrides still use default hashing (in cache mechanism),
  could result in errors, needs to be updated
- NOTE : all default hashing is instance specific (FOR STRINGS ONLY so far), works as id in 1 enviroment, 
but with Client + Server config, hashes become different, needs changing to MD5


## Not Obvious Code Conventions
-   In class/struct that only represent data and not computation, use direct property naming without modifiers like "Get" or "Set".
    Example: Person struct should be "Person.BirthTime" and not "Person.GetBirthTime()"
        

## EventDataList.xml
-   3 files exist now, azure storage, desktop, wwwroot (TODO delete all but wwwroot)
-   2 of these files exist, 1 local in MuhurthaCore for desktop version.
    The other online in VedAstro Azure storage for use by API.
    Both files need to be in sync, if forgot to sync. Use file with latest update.
-   Future todo simplify into 1 file. Local MuhurthaCore can be deprecated.

## Event/Prediction Multiple Tags
-   Generally 1 tag for 1 event, add only when needed.
-   Multiple tags can be used by 1 event, separated by "," in in the Tag element
-   Done so that event can be accessed for multiple uses.
    Example, Tarabala Events is taged for Personal & Tarabala.
-   Needs to be added with care and where absolutely needed,
    else could get very confusing.

# Things to remember
To all those who say we need money todo good. Jesus said not.

"It is easier for a camel to go through the eye of a needle,
than for a rich man to enter the kingdom of God"

<img src="https://upload.wikimedia.org/wikipedia/commons/thumb/8/8e/Hoffman-ChristAndTheRichYoungRuler.jpg/1024px-Hoffman-ChristAndTheRichYoungRuler.jpg" width="600"/>


# POEMS
Oh so bright, On a Tuesday morning,<br>
I'm pondering life, and what's in sight.<br>
Is it fear, fate, justice, or a test of might?<br>

From my father's voice rings a resounding insight.<br>
Joy of my love, it's your guiding light!<br>
All men that have joy, have God, just right,<br>
Making love to their sweet wife, there, God's in sight!<br>

When men love their wives, with all their heart,<br>
They see a glimpse of God, a work of art.<br>
In those precious moments, they see God's might.<br>
Yet, swiftly it fades, like a star in the night<br>

When fleeting moments pass, and cries are heard,<br>
And we're left to wonder, if joy's been blurred.<br>
Chasing worldly delights, may bring us cheer<br>
But joy is what lasts, and banishes all fear.<br>

To pursue worldly pleasures, is not quite right,<br>
It's short-sighted, like a bat in the daylight.<br>
They seek joy, in their ceaseless flight,<br>
Forgetting it's joy that makes their wings ignite.
