﻿using System;
using ExCSS;
using System.Collections.Generic;
using static VedAstro.Library.Calculate;
using System.Linq;

namespace VedAstro.Library
{
    /// <summary>
    /// Logic to create South Indian Chart, simple chart with zodiac and planets in it
    /// </summary>
    public class SouthChartFactory
    {
        private ChartType ChartType { get; set; }
        private Time Time { get; set; }

        public string SVGChart { get; set; }

        private double widthPx = 1000;
        private double heightPx = 1000;

        private const string StaticBackgroundLayer = "<g id=\"Prerender\">\r\n\t<rect id=\"DarkBack\" x=\"-0.1\" y=\"-0.1\" fill=\"#F0F2F5\" width=\"1001.2\" height=\"1000.1\"/>\r\n\t<g id=\"BackFrame\">\r\n\t\t<g id=\"border\">\r\n\t\t\t<path fill=\"#915C25\" d=\"M75.8,984.9l-0.6,9.8c-21.8,3.9-43.8,0.7-65.8,1.7c-1.8-0.2-2.8-1.3-3-3.1c0.7-1.4,1.9-2.4,3.3-3.1\r\n\t\t\t\tc17.9-3.3,36.1,0.2,54.2-3.1c-9.3-1.8-18.9-1.2-28.3-1.5c-6.4-0.2-13,1.2-18.7-3.6c-6.2-15.9-1.6-32.5-3-48.7\r\n\t\t\t\tc0-1.6,0-3.1,0.1-4.6c0.1-1.6,0.4-3.1,1-4.5c2.5-4-0.3-9.2,3-13.1c1.7-0.2,3,0.4,3.9,1.9c4.1,15.9,1,32.3,2,48.3\r\n\t\t\t\tc0.3,4.9-1.7,10.5,4.3,13.7c6,1.4,12.2,0.7,18.2,0.7l473.7,0.1c6.9,0,14-0.7,20.8,1.2c1.6,0.6,2.9,1.8,3.6,3.3\r\n\t\t\t\tc-1.2,4.7-5.3,2.2-8,3.2c-2.1,0.8-4.2,1.8-6.6,2c-17.8,0.8-35.9-0.6-53.7,1.7c18.2,3.6,36.9-0.7,55,3.5c1.9,1.5,4,3,1.2,5.5\r\n\t\t\t\tc-22.4-0.3-44.8,1.8-67.1-1.2h0.1c-1.3-7.7-3.3-12.8-13.7-11.9c-38.5,3.1-77,0.3-115.5,0.3H83.1\r\n\t\t\t\tC80.7,983.4,77.9,982.9,75.8,984.9L75.8,984.9L75.8,984.9z\"/>\r\n\t\t\t<path fill=\"#E9DBCB\" d=\"M75.8,984.9c2.8-5.3,7.7-2.6,11.6-2.6l365.8-0.4c10.8,0,13.8,3.6,12.6,13.2c-2.8-7.3-6.9-12.6-15.9-10.1\r\n\t\t\t\th-2.8c-14.7,1.8-29.6,1.8-44.3,0H379c-5.2,1.6-10.4,1.8-15.5-0.1L358,985c-5.2,1.5-10.3,1.7-15.5-0.1h-23.7\r\n\t\t\t\tC237.9,984.9,156.8,984.9,75.8,984.9L75.8,984.9L75.8,984.9z\"/>\r\n\t\t\t<path fill=\"#F0EADF\" d=\"M18.2,911.9l-0.6,12.6c-3.4,3.7-7.4,3.8-11.8,1.9l-1.6-1.5c10-2,11.6-8.5,11.1-17.7\r\n\t\t\t\tc-0.7-18.4-0.2-36.8-0.3-55.3c-2.1-3.5-1.9-6.9,0-10.3v-13.1l0.2-283.9c1.8-0.7,3.2-0.2,4.1,1.4c1.3,2.2,1.7,4.6,1.9,7.2\r\n\t\t\t\tl0.2,290.6V897C21.4,902.1,21.8,907.4,18.2,911.9L18.2,911.9L18.2,911.9z M15,465.9v-372c-3.5-4.6-3.9-9.2,0.4-13.6\r\n\t\t\t\tc1.9-0.2,3.3,0.6,4.1,2.3c2.4,5.4,1.8,11.1,1.8,16.7v349.2c0,5.6,0.7,11.3-2,16.6C18.2,466.7,16.7,467,15,465.9L15,465.9z\"/>\r\n\t\t\t<path fill=\"#F8F5ED\" d=\"M2,945.6c1.1-6.9-2.1-14.2,2.2-20.9l0.7,0.3c6.2,21.9,3.5,44.1,1.6,66.4c-0.3,1.6-1.3,3-2.5,3.9\r\n\t\t\t\tC-0.3,979,3.2,962.2,2,945.6L2,945.6L2,945.6z\"/>\r\n\t\t\t<path fill=\"#EEE7D8\" d=\"M7.3,994.7h67.9c-1.7,3.4-4.9,3.3-8,3.1c-21-1.4-42.3,3.1-63.2-2.3l1-0.4C5.6,993.8,6.4,993.8,7.3,994.7\r\n\t\t\t\tL7.3,994.7z\"/>\r\n\t\t\t<path fill=\"#F8F6ED\" d=\"M4,536.9c-2.4-23.5-4.6-46.9,1.1-70.4c1,1.3,1.8,2.6,2.3,4c1.3,21,1.8,41.9-0.3,62.9\r\n\t\t\t\tC6.4,534.9,5.4,536.1,4,536.9L4,536.9L4,536.9z\"/>\r\n\t\t\t<path fill=\"#A37F4C\" d=\"M5.1,469.1c-0.2-0.8-0.3-1.7-0.1-2.5l10.1-0.6c0.8,0.3,1.7,0.3,2.5,0.1c1.7,2.6,0.1,4.3-1.8,6\r\n\t\t\t\tc-1.6,0.9-3.3,1.3-5.1,0.9C8.2,472.5,6.7,470.8,5.1,469.1L5.1,469.1z\"/>\r\n\t\t\t<path fill=\"#EFE3D9\" d=\"M17.4,544.5h-2.1C14.9,537,6.7,541,4,536.9l0.8-0.4c1.2-1.1,2.5-1.8,4-2.2\r\n\t\t\t\tC16,534.3,22.2,534.8,17.4,544.5L17.4,544.5z\"/>\r\n\t\t\t<path fill=\"#A17747\" d=\"M984.6,81v385.2l-2.3,0.8c-1.5-0.9-2.5-2.2-3.2-3.8c-2.5-29-0.5-58-1.1-86.9c-0.2-12.6,0-25.1-0.1-37.7\r\n\t\t\t\tl0.2-253.1c0.1-1.6,0.5-3.2,1.1-4.7c0.7-1.5,1.9-2.5,3.5-3.1C984.4,78,985,79.2,984.6,81L984.6,81L984.6,81z\"/>\r\n\t\t\t<path fill=\"#E9DBCB\" d=\"M926.4,995.8c-1.8-10.1-8.3-11.4-17.7-11.4l-359.2,0.1c-0.7-1.9-0.2-3.3,1.6-4.2\r\n\t\t\t\tc4.9-2.4,10.2-1.9,15.4-1.9l342.6,0.1c8.9,0,20.8-2.7,20,12.9C928.6,993.2,927.6,994.7,926.4,995.8L926.4,995.8z\"/>\r\n\t\t\t<path fill=\"#A17747\" d=\"M984.5,750.2v174.4c-1.9,0.5-3.4,0-4.5-1.6c-3-5.3-2.1-11-2.1-16.6V569.8c0-5.2-0.5-10.4,1.7-15.4\r\n\t\t\t\tc0.8-1.8,2.3-2.4,4.2-2.1l0.4,181.1C984.2,739.1,984.4,744.7,984.5,750.2L984.5,750.2z\"/>\r\n\t\t\t<path fill=\"#AB8457\" d=\"M984.5,466.1c10.3-1.6,13.4,2.7,12.9,13c-0.8,19.1-0.3,38.2-0.4,57.3c-1.3,1.3-2.5,1.2-3.7-0.2\r\n\t\t\t\tc-0.8-1.3-1.4-2.6-1.8-4c-1.3-15.7-0.4-31.5-0.5-47.3c0-5.8-0.6-11.1-6.4-14.2c-1.2-1.1-1.6-2.4-1.3-3.9L984.5,466.1L984.5,466.1\r\n\t\t\t\tL984.5,466.1z M994.4,925.3c4.6,1.8,2.7,5.8,2.7,8.9l-0.1,60.6c-1.5,1.3-2.8,1.2-3.8-0.4c-0.8-1.4-1.4-2.8-1.7-4.3\r\n\t\t\t\tc-0.5-20.3-1.4-40.5,0.4-60.8C992.4,927.7,993.3,926.4,994.4,925.3L994.4,925.3L994.4,925.3z\"/>\r\n\t\t\t<path fill=\"#EEE7D9\" d=\"M994.3,994.7h2.7c-2.5,4.2-6.8,3.1-10.5,3c-20-0.9-40.3,2.3-60.2-1.8l0.4-1.1c3.5-3.2,8-3.6,12.3-3.3\r\n\t\t\t\tC957.4,993,976.2,987.9,994.3,994.7L994.3,994.7z\"/>\r\n\t\t\t<path fill=\"#EEE7D8\" d=\"M465.6,995l67.9-0.3c0.8-0.9,1.7-0.9,2.5,0c-1.5,2.7-4,3-6.7,3h-57C469.7,997.7,467.2,997.5,465.6,995\r\n\t\t\t\tL465.6,995z\"/>\r\n\t\t\t<path fill=\"#9D6928\" d=\"M994.4,925.3l-0.1,2.2c-2.3,2.5-6.4,3.7-6.4,8c-1.3,15.2,2.3,30.6-2.4,45.6c-1.1,1.4-2.3,1.9-4,1.5\r\n\t\t\t\tc-1.2-1.1-2.1-2.4-2.7-3.9c-1.1-17.4-2.7-34.8,1-52.1l1.7-1.8l3-0.2L994.4,925.3L994.4,925.3L994.4,925.3z\"/>\r\n\t\t\t<path fill=\"#A58251\" d=\"M536,994.8l-1.3,0.1l-1.3-0.2l-2.4-2.4c-0.8-0.7-1.5-1.7-1.9-2.6c-0.4-1.6-0.4-3.3,0-4.9\r\n\t\t\t\tc0.4-0.9,1.2-1.9,2-2.5h5.5c0.7,0.5,1,1.1,0.7,1.7c-0.2,0.5-0.4,0.8-0.6,0.8L536,994.8L536,994.8L536,994.8z\"/>\r\n\t\t\t<path fill=\"#9F7545\" d=\"M983.6,552.3h-2.1c-1.1-0.8-1.9-1.9-2.3-3.2c-1.1-4-1.1-7.9,0.8-11.7c0.8-1.2,2-1.7,3.4-1.4\r\n\t\t\t\tc1.3,0.8,1.6,2,1,3.4L983.6,552.3L983.6,552.3z\"/>\r\n\t\t\t<path fill=\"#EDE3D3\" d=\"M984.6,539.5c-0.3-0.8-0.3-1.7-0.1-2.5c3.2-3.3,6.5-2.8,10-0.5c0.8,0.2,1.7,0.2,2.5,0\r\n\t\t\t\tC993.8,541.4,988.7,538.5,984.6,539.5L984.6,539.5L984.6,539.5z\"/>\r\n\t\t\t<path fill=\"#E7DACA\" d=\"M536.7,984.9c-0.3-0.8-0.3-1.7-0.1-2.5l7.5-0.6c2-1.2,3.7-0.9,5.2,0.8v2.1L536.7,984.9L536.7,984.9\r\n\t\t\t\tL536.7,984.9z\"/>\r\n\t\t\t<path fill=\"#9C7541\" d=\"M75.5,20.5l302.3,0.3l85.1-0.4c1.8-0.5,3,0.1,3.4,1.9c-0.5,1.6-1.5,2.7-3.1,3.5c-1.6,0.6-3.2,0.9-4.8,1.2\r\n\t\t\t\tL89.3,27.2c-4.3,0-8.8,0.2-12.7-2.2C74.9,23.8,74.5,22.3,75.5,20.5L75.5,20.5L75.5,20.5z\"/>\r\n\t\t\t<path fill=\"#9C7542\" d=\"M816.5,20.5h107.2c1.9-0.5,3,0.2,3.4,2.1c-0.7,1.6-1.9,2.6-3.4,3.3c-22.9,2.8-45.9,0.5-68.9,1.4\r\n\t\t\t\tc-97.9-0.1-195.8,0-293.7-0.1c-6.7,0-14.1,1.9-19.8-3.8c3.8-4.5,8.9-2.3,13.4-2.3L802,20.9C806.9,20.9,811.7,20.6,816.5,20.5\r\n\t\t\t\tL816.5,20.5L816.5,20.5z\"/>\r\n\t\t\t<path fill=\"#BE792A\" d=\"M541.2,23.4l314.5,0.3c0.8,1.5,0.6,2.6-0.7,3.7c-1.3,0.8-2.7,1.4-4.1,1.7c-3.1,0.7-6.2,0.6-9.3,0.6H556.7\r\n\t\t\t\tc-5.6,0-11.3,0.5-16.9-0.9c-1.6-0.5-3.1-1.6-4-3l0.7-2.4C536.6,23.4,541.2,23.4,541.2,23.4z\"/>\r\n\t\t\t<path fill=\"#A98254\" d=\"M926.8,8.1L950,7.4h10.5c9,0.1,18.1,0.7,27.2,0.3c7.4-0.3,9.8,2.2,9.5,9.6c-0.4,20.2-0.2,40.4-0.3,60.6\r\n\t\t\t\tc-1.5,1.2-2.8,1.1-3.8-0.5c-0.8-1.3-1.4-2.7-1.7-4.3C990.3,57.1,991,41,991,25c0-7.7-3.1-10.9-10.9-10.9\r\n\t\t\t\tc-16.1,0-32.2,0.6-48.4-0.4c-1.6-0.3-3-0.8-4.3-1.7C925.8,10.9,925.6,9.5,926.8,8.1L926.8,8.1L926.8,8.1z\"/>\r\n\t\t\t<path fill=\"#9D6728\" d=\"M75.5,20.5l-0.1,3c-1,1.2-2.2,2-3.6,2.5c-15.5,2.3-31.1,0-46.6,1.5c-1.5,0.3-3,0.3-4.5,0\r\n\t\t\t\tc-2.2-0.6-4-1.8-5.3-3.7c0.2-7.3,6.3-5.8,10.3-6.1c9.9-0.7,19.7,0,29.6-0.4c4-0.2,8.9,1.5,11.3-3.7c0.6-1.3,1.5-2.3,2.5-3.2\r\n\t\t\t\tc1.9-1.2,3.8-1.4,5.6,0.3L75.5,20.5L75.5,20.5z\"/>\r\n\t\t\t<path fill=\"#9C6427\" d=\"M465.5,23.5l-0.1-3c-1.7-3.3-1.3-6.6-0.4-10c1.2-1.1,2.4-1.1,3.8-0.3c1.1,0.8,2,1.9,2.7,3.2\r\n\t\t\t\tc2.9,5.7,8.3,3.7,12.7,3.8c14.6,0.5,29.4-0.2,44.1,0.4c1.5,0.1,2.9,0.4,4.2,0.9c1.3,0.6,2.4,1.5,3.5,2.5c0.3,0.7,0.5,1.5,0.5,2.3\r\n\t\t\t\tl-0.4,0.3c-15.7,7.3-32.2,2.4-48.3,3.4C480.3,27.4,472.2,29.4,465.5,23.5L465.5,23.5z\"/>\r\n\t\t\t<path fill=\"#A88353\" d=\"M535.9,21l-2.2-0.2c-5-6.9-12.4-6.3-19.7-6.9c-15.2-1.2-31,3.8-45.7-3.4h-1.2l-1.2,0.1\r\n\t\t\t\tc-1-0.5-1.2-1.2-0.8-1.7c0.3-0.5,0.6-0.8,1-0.8c19.4,0,38.9,0.5,58.3-0.4C535.4,7.1,537.8,11.5,535.9,21L535.9,21L535.9,21z\"/>\r\n\t\t\t<path fill=\"#A88355\" d=\"M74.9,10.6l-4.8-0.1c-4.6,4.2-10.4,3.7-15.9,3.6c-15.1-0.3-30,1.1-45.1-0.8c-1.6-0.6-3-1.5-4.2-2.6V8\r\n\t\t\t\tc0.8-1.2,2-1.9,3.3-2.3c4.2-1.4,8.2,0,12,1.9l54.9,0.6C75.4,9,75.3,9.9,74.9,10.6z\"/>\r\n\t\t\t<path fill=\"#EDE0CF\" d=\"M465.9,8.1c-0.2,0.8-0.2,1.7,0,2.5l-0.5,9.9l-1.3,0.2l-1.3-0.2C463.7,16.3,460.8,11.2,465.9,8.1\r\n\t\t\t\tL465.9,8.1L465.9,8.1z\"/>\r\n\t\t\t<path fill=\"#EADCC9\" d=\"M994.4,77.9c0.8,0.2,1.7,0.1,2.5-0.1c-3.1,5.1-8.3,2.1-12.4,3.2c-0.3-0.8-0.3-1.7,0-2.5\r\n\t\t\t\tC987.7,75.2,990.9,75.6,994.4,77.9L994.4,77.9z\"/>\r\n\t\t\t<path fill=\"#E08E27\" d=\"M544.1,979.8l-223.9-0.3L23,979.3c-0.5-1.9,0.1-3.4,1.8-4.2c12-3.5,24.3-1.9,36.4-1.9l473.5-0.1\r\n\t\t\t\tc3.9,0,7.8-0.2,11.6,1.4c1.6,0.7,2.9,1.8,3.7,3.4C549.1,981.6,546.6,980.7,544.1,979.8L544.1,979.8L544.1,979.8z\"/>\r\n\t\t\t<path fill=\"#915B24\" d=\"M544.1,979.8l5.2-0.5c4.3-3.8,9.8-3.4,15-3.4h402.3c3.5,0,7,0,10.4,0.9c1.6,0.6,3.2,1.6,4.5,2.6l-0.1,2.3\r\n\t\t\t\tc-8.3,6.9-18.2,2.7-27.4,3.8c-5.4,0.6-11-0.9-18.9,2c20.2,3,38.1-0.6,55.7,2.3c1.3,0.6,2.4,1.5,3.6,2.4v2.2l-67.7,0.1\r\n\t\t\t\tc-0.1-6.9,1.1-13.1-10.3-13L551.9,982c-0.8,0-1.7,0.2-2.5,0.3l-5.2-0.8v-1.7H544.1z\"/>\r\n\t\t\t<path fill=\"#D78728\" d=\"M23,976.9v2.4c-4.3-3.2-2.5-7.9-2.7-11.9L20,912c-2.2-22.7-0.4-45.4-1.1-68V552c-0.1-1.7,0.2-3.5,0.8-5.1\r\n\t\t\t\tc1.8-0.7,3.3-0.2,4.5,1.4c3.3,6.1,2.1,12.8,2.1,19.2l0.1,277.4c-0.3,7.3,0.6,14.6,0,21.8c-0.1,5.5,0.3,11,0.1,16.5\r\n\t\t\t\tc0.1,5.5-0.2,11.1,0.2,16.6c-0.5,24.3,1.5,48.6-1.3,72.9C25,974.2,24.1,975.6,23,976.9L23,976.9z\"/>\r\n\t\t\t<path fill=\"#DC8A27\" d=\"M530.7,989.9c0.1,0.8,0.2,1.7,0.2,2.4l-53.4,0.1c-3.7,0-8.6,1.2-9-4.5c-0.5-6.9,5.1-5.7,9.1-5.8l53.4,0.2\r\n\t\t\t\tc0,0.8-0.1,1.7-0.2,2.4c-13.9,5.8-28.4,0.5-40.2,2.5C502.4,989.3,516.9,984,530.7,989.9L530.7,989.9z\"/>\r\n\t\t\t<path fill=\"#DA8927\" d=\"M18,982l45.8,0.1c3.8,0,8.6-0.6,8.5,5.3c-0.1,5.9-4.9,5.1-8.7,5.1l-53.7-0.2c-0.8-1.4-0.5-2.6,0.7-3.6\r\n\t\t\t\tc16.2-3.6,32.7,0.2,46.6-1.6c-11.7-1.9-26.1,4-39.7-3.2C17.7,983.4,17.9,982.8,18,982L18,982L18,982z\"/>\r\n\t\t\t<path fill=\"#976830\" d=\"M7.3,994.7L6.1,995H5v-69.8l12.6-0.6l0.1,3.2c-5.5,3.8-6.9,9.2-6.8,15.6c0.2,11.5,0,23,0.1,34.5\r\n\t\t\t\tc0,5.3-0.6,10.2-3.5,14.7L7.3,994.7L7.3,994.7z\"/>\r\n\t\t\t<path fill=\"#CB7E29\" d=\"M7.3,992.4l-0.2-54.6c-0.2-7.9,2.4-11.5,10.5-10.1c0,0.8,0,1.7-0.1,2.5c-1.1,1.1-1.9,2.1-2.8,3.4\r\n\t\t\t\tc-2.7,13.5-0.7,27.1-1.3,40.6c-0.2,5.5,0.6,11.2-3.5,15.7v2.4L7.3,992.4L7.3,992.4L7.3,992.4z\"/>\r\n\t\t\t<path fill=\"#9A672E\" d=\"M20.2,844l-0.1,67.8h-1.9V844C18.9,842.9,19.5,842.9,20.2,844L20.2,844z\"/>\r\n\t\t\t<path fill=\"#E99326\" d=\"M15,930.1h2.4L18,982h-0.5c-1.9,0-3.8-0.8-3.9-2.5C12.7,963,10.2,946.5,15,930.1L15,930.1z\"/>\r\n\t\t\t<path fill=\"#945F25\" d=\"M20.7,547.1l-0.4,2.6c-0.6,1.2-1.3,1.2-2,0l-0.8-5.2c2.4-9.7-5.2-7.3-10.1-8.2c-1-1.3-0.8-2.4,0.3-3.5\r\n\t\t\t\tc1-0.9,2-1.7,3.2-2.4c4.8-3.5,3.2-8.7,3.4-13.2c0.5-14.7-0.6-29.3,0.6-44l0.4-2l2.3-5.3l-0.3-385c-3-3.2-7.5,0.1-10.5-2.7\r\n\t\t\t\tc-0.4-1.3-0.2-2.5,0.5-3.6c1-0.9,1.9-1.8,3.1-2.4c5.1-3.2,3.6-8.3,3.8-13c0.6-10.8-1.1-21.6,1.2-32.3c0.6-1.3,1.4-2.4,2.4-3.4\r\n\t\t\t\tl2.5,2.6c4.6,4.5,3.6,10.4,3.6,16v488.8C24.1,536.5,24.7,542.3,20.7,547.1L20.7,547.1z\"/>\r\n\t\t\t<path fill=\"#945F25\" d=\"M18.1,549.7h2V844H18L18.1,549.7L18.1,549.7z\"/>\r\n\t\t\t<path fill=\"#E8D9C7\" d=\"M7.3,77.8c3.2,1.6,7.8-1.9,10,3.1h-2.1c-3.8-0.4-8,0.7-11.1-2.6L5.2,78C5.7,77,6.4,77,7.3,77.8z\"/>\r\n\t\t\t<path fill=\"#97672F\" d=\"M7.3,77.8l-1.2,0.3L5,78V10.6h2.3c1.1,1.3,1.9,2.6,2.5,4.2c0.3,20.2,4.7,40.6-2.4,60.6\r\n\t\t\t\tC7.3,76.2,7.3,77.1,7.3,77.8L7.3,77.8z M7.4,533.9l-0.1,2.5l-1.2,0.3l-1.3-0.2L5.1,469c1.9,0,3.7,0.2,4.8,2.2l0.4,2.3\r\n\t\t\t\tc1.3,16.5,0.3,32.9,0.5,49.4C10.8,526.9,10.3,530.8,7.4,533.9L7.4,533.9L7.4,533.9z\"/>\r\n\t\t\t<path fill=\"#F99C2E\" d=\"M9.8,471.2h5.4l-0.1,0.4c3,18.4,0.6,36.8,1.3,55.3c0.1,4.3-1.9,6.5-6.6,4.9c-1.9-20-2-40.2,0.1-60.2\r\n\t\t\t\tL9.8,471.2L9.8,471.2z\"/>\r\n\t\t\t<path fill=\"#BC762A\" d=\"M981.3,80.9v257.8c-1.8,0.7-3.2,0.2-4.2-1.5c-0.8-1.5-1.4-3.1-1.7-4.7c-1.6-41-0.4-82.2-0.6-123.3V101.5\r\n\t\t\t\tc0-6.4-0.7-13,2.3-19.1C978,80.6,979.5,80.1,981.3,80.9L981.3,80.9L981.3,80.9z\"/>\r\n\t\t\t<path fill=\"#BD792A\" d=\"M979.1,338.7h2.3l0.2,127.7c6.9,14.8,2.8,30.4,3.4,45.6c0.3,8.3,2.4,17.2-3.4,24.9l-0.2,13\r\n\t\t\t\tc-1.8,0.7-3.2,0.2-4.2-1.5c-3.9-13.6-1.5-27.4-1.9-41.2c-0.5-15.9,0.1-32-0.3-48c-0.3-16.1-0.1-32.4-0.1-48.5\r\n\t\t\t\tc0.7-5.6-0.2-11.2,0.3-16.7v-5c-0.3-12.4-0.1-24.8,0.1-37.2C975.4,347.1,974.8,342.2,979.1,338.7L979.1,338.7z\"/>\r\n\t\t\t<path fill=\"#9D6527\" d=\"M994.4,77.9l-10,0.5l-3-0.1c-5.5-5.7-2.9-13-3.7-19.6c-1.1-9.6,2.8-19.7-3.1-28.7\r\n\t\t\t\tc-9.2-5.6-19.3-1.8-28.8-2.8c-6.6-0.7-13.8,1.8-19.6-3.7l-0.1-3.1c-1.3-3.4-2-6.6,0.5-9.8c0.8-0.1,1.6-0.1,2.4-0.1l2.9,3.3\r\n\t\t\t\tc9,6.4,19.3,3,29,3.2c26.6,0.5,26.5,0.5,27,27c0.2,9.6-3.3,19.8,3.2,28.8c1.1,0.9,2.1,1.9,3.2,2.8\r\n\t\t\t\tC994.6,76.3,994.6,77.2,994.4,77.9L994.4,77.9L994.4,77.9z\"/>\r\n\t\t\t<path fill=\"#9D6627\" d=\"M981.5,536.7v-70.5c0.6,0,1.3,0.1,1.9,0.3c0.4,0.7,0.6,1.5,0.7,2.2c1,1.2,1.7,2.3,2.3,3.7\r\n\t\t\t\tc2.7,15.2,0.5,30.6,1.4,45.8c0.2,4.4-1.5,9.6,3.4,12.9c1.1,0.9,2.1,1.8,3.2,2.7c0.1,0.7,0.1,1.6,0,2.3l-10,0.5L981.5,536.7\r\n\t\t\t\tL981.5,536.7z\"/>\r\n\t\t\t<path fill=\"#BD782A\" d=\"M979,25.9c5.6,17.3,0.8,34.9,2.4,52.4c0,0.8-0.1,1.7-0.2,2.5h-2.3c-7.5-17.5-4.8-35.3-1.8-53.2L979,25.9\r\n\t\t\t\tL979,25.9L979,25.9z\"/>\r\n\t\t\t<path fill=\"#BC752A\" d=\"M979.1,549.7h2.2l0.2,2.6v372.4h-0.1c-1.8,0.7-3.2,0.3-4.1-1.4c-5-18.4-1.3-37.1-2.3-55.6\r\n\t\t\t\tc-0.3-4.7,0.3-9.5,0.3-14.3c-0.1-4.7-0.3-9.4,0-14.1v-7c-0.3-12.6-0.1-25.1-0.2-37.7c-0.3-3.3-0.3-6.5,0.1-9.8l0.2-216.8\r\n\t\t\t\tC975.3,561.8,973.7,555,979.1,549.7L979.1,549.7L979.1,549.7z\"/>\r\n\t\t\t<path fill=\"#B16C29\" d=\"M984.2,471.7v-2.8c7.5-0.8,10.8,1.7,10.6,9.9c-0.5,18.4-0.2,36.8-0.2,55.2l-3.1-0.3\r\n\t\t\t\tc-6.8-14.7-1.8-30.3-3.4-45.4C987.6,482.7,989.8,476.3,984.2,471.7L984.2,471.7L984.2,471.7z\"/>\r\n\t\t\t<path fill=\"#B26D29\" d=\"M994.3,992.6l-2.7-0.2c-1-1.2-1.8-2.4-2.4-3.8c-2.5-14.7-0.5-29.4-1.3-44.1c-0.2-5.1,1-10.5-4-14.3\r\n\t\t\t\tc2.7-3.9,6.7-2.3,10.3-2.5L994.3,992.6z\"/>\r\n\t\t\t<path fill=\"#F99C2D\" d=\"M984.1,930c8-1.1,8,4.1,7.8,9.6l-0.2,50.1c-18.3,3.1-36.9,0.5-55.4,1.4c-2.9,0.1-5.6-0.6-5.5-3.9\r\n\t\t\t\tc0-3.2,2.9-3.8,5.6-3.8l33.7-0.1c4.6-0.1,9.5,1.5,13.8-1.5L984.1,930L984.1,930L984.1,930z\"/>\r\n\t\t\t<path fill=\"#DB8A27\" d=\"M983.9,981.9c-5.5,5.4-12.3,2.4-18.5,2.6c-10.6,0.5-21.3,0.1-32.1,2.1c9.1,4.7,19.1,2.8,28.6,3.2\r\n\t\t\t\tc9.9,0.3,19.8,0,29.8,0c0.1,0.8,0.1,1.7,0,2.5l-53.2,0.1c-4.1,0-9.7,0.9-9.1-5.8c0.4-5.8,5.4-4.4,9-4.5l42.9-0.3\r\n\t\t\t\tC982.3,982,983.1,982,983.9,981.9L983.9,981.9z\"/>\r\n\t\t\t<path fill=\"#BC782A\" d=\"M979.1,924.8h2.3l0.1,54.6l-2.8-0.2c-1.1-1.3-1.9-2.6-2.5-4.2C975.5,958.3,971.2,941.2,979.1,924.8\r\n\t\t\t\tL979.1,924.8z\"/>\r\n\t\t\t<path fill=\"#F99C2D\" d=\"M530.7,989.9h-58.3v-5.1h58.3V989.9z\"/>\r\n\t\t\t<path fill=\"#E5D7C4\" d=\"M926.8,10.6l-0.5,9.8l-1.3,0.2l-1.3-0.2c1.1-4.1-1.9-9.3,3.2-12.4C926.6,8.9,926.6,9.8,926.8,10.6\r\n\t\t\t\tL926.8,10.6z\"/>\r\n\t\t\t<path fill=\"#BE792A\" d=\"M72.7,23.7l2.7-0.2L463,23.7c0.7,1.7,0.3,3.1-1.3,4c-5.4,2.6-11.1,2.3-16.9,2.1\r\n\t\t\t\tc-117.9-0.1-235.9,0-353.8,0c-5.7-0.3-11.6,0.6-17-2.1C72.4,26.7,72,25.4,72.7,23.7L72.7,23.7z\"/>\r\n\t\t\t<path fill=\"#BF792A\" d=\"M463,26v-2.3l2.5-0.2l70.6,0.1l0.1,2.3c-1.1,1.4-2.4,2.3-4,3c-19.9,2.6-39.9,1.1-59.9,0.9\r\n\t\t\t\tC468.8,29.8,465.4,29,463,26L463,26L463,26z\"/>\r\n\t\t\t<path fill=\"#BF7B2A\" d=\"M926.4,23.6l40.3,0.1c4.2,0,8.8-1.3,12.3,2.3l-0.3,0.3c-5,4.4-11.2,4-17.2,4c-24.6,0-49.2,0.3-73.7-0.2\r\n\t\t\t\tc-10.7-1.3-22.1,2.8-32-4.1v-2.3L926.4,23.6L926.4,23.6L926.4,23.6z\"/>\r\n\t\t\t<path fill=\"#F5992C\" d=\"M853.2,26.3h-8.1c-11.1,2.8-22.5-0.1-33.7,1.7c-3.1,3.4-6.6,5-11.3,5c-19.4-0.3-38.9,0.2-58.4-0.4\r\n\t\t\t\tc-3.8-0.1-8.7-2.2-10.7,1.8c-2.5,4.9,2.2,7.4,5.8,9.7c17.5,1.1,35,1.6,52.5,1.7c1-0.1,1.8-0.1,2.8-0.1c1.1,0,2.1,0.1,3.2,0.1\r\n\t\t\t\tc18.6,0,37.2-0.6,55.8-1.7C857.5,38.9,860.7,33.3,853.2,26.3z\"/>\r\n\t\t\t<path fill=\"#F89A32\" d=\"M845.1,26.3c-10.9,5.3-22.7,1.1-33.9,2.4c-5.5,4.9-12.2,3.8-18.7,3.8l-219.2,0.1\r\n\t\t\t\tc-7.4,0-14.7,0.4-22.2,0.6c-6.3,0.2-14.3,1.8-17.5-7.1c0.8-0.1,1.7-0.2,2.5-0.3L828,26.1L845.1,26.3L845.1,26.3L845.1,26.3z\"/>\r\n\t\t\t<path fill=\"#F8A038\" d=\"M853.2,41.4c-0.8-5.1,4.2-10,0.1-15.1l2.5-0.4l31.5,0.4c6,4,14,6.8,9.7,16.7c-4.5,2.3-8.9,2.2-13.6,0.7\r\n\t\t\t\tc-0.7-0.3-1.6-0.7-2.1-1.4c-6.6-6.5-12.2-6.1-16.9,1.4C860.2,44.9,856.2,45.2,853.2,41.4L853.2,41.4z\"/>\r\n\t\t\t<path fill=\"#B16D29\" d=\"M994.4,75.6l-3.1-0.3c-6.8-14-3.1-28.9-3-43.3c0.1-11.9-3.4-15.5-15.5-15.4c-14.4,0.1-29.5,3.8-43.5-3\r\n\t\t\t\tl-0.3-3.1l55.8-0.2c7.3-0.1,9.9,2.4,9.8,9.7C994.2,38.6,994.4,57.1,994.4,75.6L994.4,75.6z\"/>\r\n\t\t\t<path fill=\"#D78728\" d=\"M20.7,547.1L20.3,37.9V26.2l2.7-0.4l1.7,2c2.8,5.8,1.9,11.9,1.9,17.9v481.5c0,6.8,1.8,14-3.7,19.8\r\n\t\t\t\tL20.7,547.1L20.7,547.1z\"/>\r\n\t\t\t<path fill=\"#F79C2F\" d=\"M17.8,23.6l-0.4,2.6c-2.2,13.1-0.3,26.3-1.1,39.5c-0.2,4.2,1.2,10.7-7.1,7.2c-0.7-20-1.4-39.9,0.3-60\r\n\t\t\t\tc20.2-1.5,40.3-2.2,60.5,0.4c1.1,8-4.3,7.6-9.8,7.6l-42.4,0.6c-0.2,0-0.6,0.5-0.5,0.8C17.3,22.7,17.6,23.2,17.8,23.6L17.8,23.6z\"\r\n\t\t\t\t/>\r\n\t\t\t<path fill=\"#B57129\" d=\"M70,13.3H10.1c-0.8,1.2-1.8,1.1-2.7,0l-0.1-2.7h62.8L70,13.3z\"/>\r\n\t\t\t<path fill=\"#BE792A\" d=\"M72.7,23.7v2.2c-16.5,6.4-33.1,5.7-49.7,0.4v-0.5C39.4,20.9,56.2,24.7,72.7,23.7z\"/>\r\n\t\t\t<path fill=\"#F79C2B\" d=\"M530.8,20.8L477.4,21c-5.3,0-9.8-0.3-8.9-7.4c19.3-3.9,38.7-0.9,58.1-1.6C533.1,11.9,533.3,16,530.8,20.8\r\n\t\t\t\tL530.8,20.8z\"/>\r\n\t\t\t<path fill=\"#B36E29\" d=\"M530.8,20.8c1.1-6.6-2.7-7.9-8.3-7.8l-54,0.5l-0.3-3l55.5-0.2c8.3-0.2,10.9,3,10,10.5H530.8L530.8,20.8z\"\r\n\t\t\t\t/>\r\n\t\t\t<path fill=\"#F5992C\" d=\"M979.1,924.8l-0.4-72.9c-12.7-0.2-13,11.7-18.3,18.7c-1.6,13.2-0.2,26.5-0.8,39.8\r\n\t\t\t\tc-0.7,15.7,2.2,31.5-1.9,47.2c-4.9,4.1-10.7,2.7-16.2,2.7l-199.9,0.1c-6.4,0-13.2-1.4-18.9,3c0,9.8,7.3,9,13.7,9.2\r\n\t\t\t\tc4.6,0.1,9,0.2,13.6,0.3l-163.7,0.2c43.9-0.1,87.8-0.3,131.8-2.5c-68-3-136.1-2.5-204.1-2.7c-0.3,0.1-0.7,0.2-1.1,0.3\r\n\t\t\t\tc0.3-0.1,0.6-0.2,0.8-0.3h62.5l132.8-0.2c3.4,0,10.2,4.4,10.3-4.4c-5.8-4.2-12.5-2.8-18.9-2.8L505,960.2l-205.3,0.1\r\n\t\t\t\tc-6.4,0-13.2-1.3-19.1,2.6c-0.7,8,5.5,4.5,8.6,4.6c1.7,0.1,3.5,0.1,5.2,0.2c-4.8,0.2-9.4,1.1-14,3.1c7.5,2.6,15.2,1.9,21,2.1\r\n\t\t\t\th-96.7c26.3-0.8,48.8-2.2,52.9-4c1.2,0.3,2.3,0.8,3.6,1.5c7,3.7,13.4-0.3,15.2-7.6c-5.9-3.8-12.6-2.5-19.1-2.5L40.7,960\r\n\t\t\t\tc-1.7-0.3-3.4-0.7-5.1-0.5c-4.8,0.5-8.7,2.3-8.2,7.8c0.3,2.5,1.5,3.9,3.2,4.4c-2.5,0.1-5.1,0.8-7.5,2.6v2.5l526.3,0.1\r\n\t\t\t\tc3.7,2.1,7.6,1.2,11.6,1.2h406.3c3.8,0,7.8,1.1,11.5-1.3L979.1,924.8L979.1,924.8L979.1,924.8z M34.9,971.9\r\n\t\t\t\tc0.4-0.1,1-0.1,1.4-0.2c3.2-0.5,6,1.4,9.2,1.3C42,973.2,38.5,972.3,34.9,971.9z M247.2,967.8c3.2,0,6.2,0.1,9.2,0.9l-197.5-0.9\r\n\t\t\t\tH247.2z M493.5,971.8c6-0.7,12.2-1.4,18-3.3c-1.4,0.6-2.1,1.6-0.6,3.2l0.5,0.5C505.4,971.5,499.4,971.3,493.5,971.8z\r\n\t\t\t\t M876.9,969.5c2.5,2,5.1,2.8,7.5,3.2h-35.1c1.3-0.4,2.4-1.7,2.9-4.9h-98.6c61.9-0.1,123.9,0.2,185.8,0\r\n\t\t\t\tC918.6,967.9,897.7,967.8,876.9,969.5z\"/>\r\n\t\t\t<path fill=\"#E28E25\" d=\"M549.4,977l429.4-0.1v2.4l-429.4-0.1V977L549.4,977z\"/>\r\n\t\t\t<path fill=\"#F7992C\" d=\"M23,26.3l49.7-0.4l15.7,0.4c0.2,3.2-2,4.1-4.3,5.2c-13.5,2.5-26.9,1.2-40.5,1.2c-10.1,0-14,3.9-14,13.9\r\n\t\t\t\tl0.1,408.7L29.3,748l0.2,80.7c0,5.6,0.6,11.4-2.2,16.6c-1,1.6-2.3,2-4.1,1.3L23,547.1V26.3L23,26.3L23,26.3z\"/>\r\n\t\t\t<path fill=\"#F5992B\" d=\"M36,961.2c-3.7,0.3-7.7,1.5-6.9,5.7c1.1,5.3,5.2,3.1,8.1,1.5c6.2-3.5,6.6,6,11.7,5.8H23l0.1-75.6\r\n\t\t\t\tc6.2-7.6,11-5.2,15.4,1.8C39.1,920.8,43.4,941.3,36,961.2L36,961.2L36,961.2z\"/>\r\n\t\t\t<path fill=\"#F9A037\" d=\"M23.1,846.7h2.5c4.7,3.4,9.1,7,12.4,11.7c1.8,5.3,2,10.7-0.4,15.8c-8,4.3-10.4-3.2-14.6-6.8L23.1,846.7\r\n\t\t\t\tL23.1,846.7z\"/>\r\n\t\t\t<path fill=\"#EF962A\" d=\"M23,867.6c6.2-0.2,8.3,6,13,7.8c3.2,3.4,3,6.9,0.8,10.7c-5.6,3.7-10.2,2.8-13.9-2.8L23,867.6L23,867.6z\"\r\n\t\t\t\t/>\r\n\t\t\t<path fill=\"#F9A037\" d=\"M23,883.2c4,2.4,8.5,2.8,13,2.5c3.8,4.3,3.8,8.8-0.1,13.1c-4.3-3-8.6-3-12.9,0L23,883.2L23,883.2\r\n\t\t\t\tL23,883.2z\"/>\r\n\t\t\t<path fill=\"#F99C2E\" d=\"M15,930.1l0.1,39.9c0,4.1-1.4,8.7,2.3,12.1c10.2,5.5,21.1,1.6,31.6,2.5c6.4,0.5,12.7,0.1,19.1,0.1\r\n\t\t\t\tl0.2,5.2H9.9v-50C9.9,935.9,8.5,930.9,15,930.1L15,930.1z\"/>\r\n\t\t\t<path fill=\"#E99323\" d=\"M10.1,531.4c7.2-1.3,5-7,5-11.2v-48.5c5.3,5.5,2.2,12.3,2.5,18.5c0.5,11.6,0,23.3,0.2,35\r\n\t\t\t\tc0.1,5.4-0.5,9.7-7.6,8.5c-0.8-0.5-1.2-0.9-1-1.5C9.4,531.7,9.7,531.4,10.1,531.4L10.1,531.4z\"/>\r\n\t\t\t<path fill=\"#CA7D29\" d=\"M10.1,531.4c0,0.7,0,1.6,0.1,2.3l-2.8,0.1v-51.6c0-3.7-1.3-7.9,2.5-10.8L10.1,531.4L10.1,531.4z\"/>\r\n\t\t\t<path fill=\"#CA8029\" d=\"M7.4,13.2h2.7L9.9,72.9c0.8,0.5,1.1,0.9,0.8,1.5s-0.5,0.8-0.7,0.8l-2.7,0.1L7.4,13.2L7.4,13.2z\"/>\r\n\t\t\t<path fill=\"#E79225\" d=\"M10.1,75.3C10,74.6,10,73.8,10,73c7.3-1.3,4.6-7.1,5.1-11.3c1.4-11.8-2.8-23.9,2.3-35.4L17.8,67\r\n\t\t\t\tC17.9,72.5,16.8,76.4,10.1,75.3L10.1,75.3z\"/>\r\n\t\t\t<path fill=\"#F69A2D\" d=\"M897.6,41.4l-10.4-15.1l91.5-0.1l0.3,54.6l-0.4,255.4c-1.4,2.6-4.5,5.4-3.3,8.1\r\n\t\t\t\tc3.7,8.7,1.4,16.7-0.5,25.1c-1.7,7.4,1.1,14.3,3.8,21.2l-0.1,2.7c-8.9,4.3-14.1-0.2-18-7.6c-1.6-6.9-1.1-13.8-1.1-20.7V64.6\r\n\t\t\t\tc0-12.8-6.6-19.1-19.7-19.2c-9.5,0-19.2,0.1-28.7-0.1C906.2,45.2,901.1,45.7,897.6,41.4L897.6,41.4L897.6,41.4z\"/>\r\n\t\t\t<path fill=\"#F9A139\" d=\"M978.6,390.7c-8.5-9.2-11.3-18.9-3.7-30.2c2.3-3.4,2.2-7.5-0.7-10.9c-6.5-7.2-1.7-10.5,4.5-13.5l0.4,2.5\r\n\t\t\t\tL978.6,390.7L978.6,390.7z\"/>\r\n\t\t\t<path fill=\"#F69A2D\" d=\"M978.6,833.5v5.3c-11.2,1.5-11.5-10.1-17.6-14.7c-2.3-9.6-1.6-19.2-0.5-28.8c2.9-8.2,1.8-16.4-0.4-24.6\r\n\t\t\t\tl-0.6-259.4c0.6-33-1-66,0.7-99c7.1-12.2,10.1-12.8,18.5-3.4l0.1,49.7c-2.7,14.1-1,28.5-1.1,42.7c-0.1,16-0.8,32.1-0.2,48\r\n\t\t\t\tc0.1,2.6,0,5.9-3.3,6.1c-4.5,0.3-3.9-3.2-3.9-6.3c0.1-6.3-1.1-12.7-0.5-17.6l-0.1,174l0.1-150.1c7.7,6.1,6.4,11.9,6.4,17\r\n\t\t\t\tl0.1,186.1c0,9.5,0.5,19,2.4,28.3v8C969.4,807.6,971.6,820.6,978.6,833.5L978.6,833.5L978.6,833.5z\"/>\r\n\t\t\t<path fill=\"#F69A2D\" d=\"M978.6,786.6c-4.1-8.8-5.1-18-5.1-27.5V572.9c0-4.2,1.2-8.7-2.3-15v157.7h-2V515.4c5.3,14.5-1,27,7,38.4\r\n\t\t\t\tv-32.1l0.1-50.7c0-4.2-1.5-8.8,2.4-12.2l0.4,91L978.6,786.6L978.6,786.6L978.6,786.6z\"/>\r\n\t\t\t<path fill=\"#F8A138\" d=\"M978.6,409c-5.1-5.1-10.2-5.3-15.2,0.1c-5.3-7-5.4-13.9,0-20.8c4.8,2.4,9.2,5.8,15.1,5.3L978.6,409\r\n\t\t\t\tL978.6,409z\"/>\r\n\t\t\t<path fill=\"#F89B2D\" d=\"M929.4,13.7L983,13c6.8-0.2,9.2,2.3,9.1,9.1l-0.6,53.3c-7.2,0.9-7.4-3.7-7.4-8.9l0.1-36.4\r\n\t\t\t\tc0.2-6.8-2.3-9.3-9.1-9.1c-12.2,0.3-24.4,0-36.6,0.1C933.2,21,928.5,20.8,929.4,13.7L929.4,13.7z M984.2,471.7\r\n\t\t\t\tc6.6-1.1,8,2.6,7.8,8.2l-0.5,53.8c-7.1,0.8-7.4-3.6-7.4-8.9L984.2,471.7L984.2,471.7z\"/>\r\n\t\t\t<path fill=\"#F69F37\" d=\"M963.4,825.8c9.1-0.4,7,12.3,15.2,13.1v13c-8.5,1.9-7.2,13.2-15.2,15.6\r\n\t\t\t\tC957.1,853.6,957.2,839.7,963.4,825.8L963.4,825.8z\"/>\r\n\t\t\t<path fill=\"#F9A037\" d=\"M978.6,833.5c-14.5-19-14.5-23.6,0-38.8V833.5z\"/>\r\n\t\t\t<path fill=\"#F7992C\" d=\"M35.9,857.1c-6.2-0.8-9.7-4.3-10.4-10.4v-264l0.2-469.6c0.1-24.3,1.9-48.6-0.3-72.9\r\n\t\t\t\tc-0.8-9.3,3-12,12-11.7c16.1,0.5,32.2,0.2,48.4,0.2c7.3-1.2,14.6-1.3,22.1-1.3H433c4.7,0,9.5,1.1,14.1-1.2l15.8-0.3l70.9,0.3\r\n\t\t\t\tc6.7,3.5,13.5,4.6,21,3.1c4.1-0.9,8.7-0.5,13-0.5h243.5c0.8,4.3,1.9,8.3-5.4,7.9c-24.4-1.3-48.9,1.9-73.4-2.1l2.8,6.9\r\n\t\t\t\tc-1.3,2-3.4,2.7-5.6,3.1s-4.5,0.1-6.7-0.4c-1.5-0.4-3-0.9-4.2-1.7c-5.7-3-11.9-2-17.9-2.1l-176-0.1c-6.9,0-14,0.6-20-4.4\r\n\t\t\t\tc1.6,2.4,5.2,4.3,1.4,7.5c-6.6,3.4-13.7,2.1-20.6,2.1H61.3c-6,0-12.2-1.1-18,1.6c-5.4,4.9-3.4,11.3-3.4,17.1L39.8,258\r\n\t\t\t\tc0,6.4,0.4,13-0.8,19.4c-3.8,8-4.7,16.5-4.5,25.3c0.8,54.1-0.2,108.1,0,162.3v231.3c0,44.1,1.9,88.2,2.8,132.3\r\n\t\t\t\tc0.1,3.5,0.5,6.9,1.6,10.2C39.4,845.1,41.1,851.6,35.9,857.1L35.9,857.1L35.9,857.1z\"/>\r\n\t\t\t<path fill=\"#F89A32\" d=\"M447.1,26.3c-4.3,4.3-10,2.3-15,2.3c-108.4,0.1-216.8,0.2-325.1-0.2c-7.1,0-14.2,3.6-21.2,0.2l2.5-2.4\r\n\t\t\t\tL447.1,26.3L447.1,26.3z\"/>\r\n\t\t\t<path fill=\"#EE9629\" d=\"M882,41.4l-15.9,0.1c-3-4.7-2.3-10.5,2.3-11.6C876.4,28.1,879.9,34.7,882,41.4z\"/>\r\n\t\t\t<path fill=\"#F5992B\" d=\"M722.2,963.9c3.6,7.1,10.2,7,16.8,7l110.9-1.6H743.2v-2.1h203.5v1.7h-67.4v2.6h25.5v2h-350v-1.4h161.3\r\n\t\t\t\tV969H510c4.2-4.5,9.9-2.5,14.8-2.5l179.9-0.2c5,0,10.5,2,14.8-2.5C720.5,963.2,721.3,963.2,722.2,963.9L722.2,963.9L722.2,963.9z\r\n\t\t\t\t\"/>\r\n\t\t\t<path fill=\"#E18C2A\" d=\"M35.9,857.1l0.1-18.3c-0.2-0.4-0.5-0.7-0.5-1.2c-0.3-38-3.5-76-0.6-113.9c0.4-2,1.6-2.8,3.6-2.5\r\n\t\t\t\tc1.3,1.1,2.3,2.5,2.9,4.1c2.3,36.9,0.3,73.8,1.1,110.8v57.8l-0.1,51.9c-0.1,8.2,3.3,12.1,11.7,11.8c4.3-0.2,8.7,0,13,0h410.7\r\n\t\t\t\tc7,0,13.9-0.3,20.9,0.3c1.7,0.2,3.3,0.7,4.8,1.6c1.7,1.1,2.1,2.4,1.4,4.2l-225.2,0.1c-0.8,1.1-1.7,1.1-2.7,0\r\n\t\t\t\tc-75.4,0-150.7,0-226-0.1c-5,0-10.5,2-14.8-2.5l-0.1-62.6l0.1-13.1v-10.3L35.9,857.1L35.9,857.1L35.9,857.1z\"/>\r\n\t\t\t<path fill=\"#E28C2A\" d=\"M504.8,963.8v-2.2c3.5-4.2,8.5-3.9,13.3-3.9h435.1c1.8,0,3.5,0.3,5.2,0.6c1.7,0.5,3.2,1.4,4.6,2.5\r\n\t\t\t\tc-4,5.2-9.7,2.8-14.5,2.8l-226.1,0.1H504.8V963.8z\"/>\r\n\t\t\t<path fill=\"#F5992B\" d=\"M486.4,969c-25.6,0-51.1,1.1-76.5-0.5c-11.6-0.7-20.3,8.5-31.5,5.7c-2.4-0.6-5.7,0.1-6.2-3.3\r\n\t\t\t\tc-0.5-4.5,3.2-4.4,6.2-4.4h108.1L486.4,969L486.4,969L486.4,969z M527.5,973.7h-47.9C494.5,963.2,509.9,968.7,527.5,973.7z\r\n\t\t\t\t M416.6,972.2h27.7v1.3h-28.2L416.6,972.2L416.6,972.2z\"/>\r\n\t\t\t<path fill=\"#F69A2D\" d=\"M970.5,748.5v32.7h-1.3V748L970.5,748.5z M963.5,794.4v-20.6C967.1,780.7,967.1,787.6,963.5,794.4z\"/>\r\n\t\t\t<path fill=\"#F7992C\" d=\"M36.1,721.7L36,838.9c-2.9-2.1-2.9-5.3-2.5-8.3c2.8-29.4-3.2-58.6-2.1-88c1.7-45.8-0.6-91.7-0.4-137.5\r\n\t\t\t\tc0.1-35.4,2-71,1.2-106.1c-1.3-49.8-0.7-99.6-0.8-149.4l-0.5-54c0.1-6.1-0.1-12.2,5.3-16.7c4.7,4.5,3.6,10.4,3.6,15.9v410.8\r\n\t\t\t\tC39.8,711.1,40.4,716.9,36.1,721.7L36.1,721.7L36.1,721.7z\"/>\r\n\t\t\t<path fill=\"#E18B2A\" d=\"M39,41.9c-0.1,0.8-0.1,1.7,0,2.5c4,4.9,3.3,10.7,3.3,16.1v644c0,5.9,1.4,12.3-3.9,17.1H36l-0.1-442.8\r\n\t\t\t\tL36,56.5C36.3,51.5,33.9,45.9,39,41.9L39,41.9L39,41.9z\"/>\r\n\t\t\t<path fill=\"#F5992C\" d=\"M722.1,41.5H507.3l-7-8.3c11,4.3,20.6,3.4,30,3.4L707,36.7C712.5,36.7,718.7,35,722.1,41.5L722.1,41.5z\"\r\n\t\t\t\t/>\r\n\t\t\t<path fill=\"#9E672C\" d=\"M725.3,48.5c3-0.9,6-1.6,9.2-1.8c-0.4-0.7-1-1.5-1.5-2.2l-2.9-2.3h-5.3l-0.1,1.9l0,0\r\n\t\t\t\tC724.7,45.5,724.8,47,725.3,48.5z\"/>\r\n\t\t\t<path fill=\"#9D6728\" d=\"M960.4,270.8c-1.3-1.1-2.8-1.9-4.2-2.5c-0.6,0-1.3,0-1.8-0.1c0.2,1.6,0.4,3.1,0.5,4.6s0,3-0.1,4.4h1.2\r\n\t\t\t\tc1.7-0.1,3.3-0.5,4.8-1.3L960.4,270.8L960.4,270.8z\"/>\r\n\t\t\t<path fill=\"#946226\" d=\"M503.4,50.3c-0.1-1.1-0.4-2-1.1-3.1l-3.3-2.5c-1.1,1.3-1.9,2.7-2.3,4.3c0,0.3-0.1,0.6-0.1,0.9\r\n\t\t\t\tC498.8,49.8,501,49.9,503.4,50.3L503.4,50.3z\"/>\r\n\t\t\t<path fill=\"#925B25\" d=\"M265.9,52.9c2.9-0.7,5.7-1.3,8.8-1.4c0-0.8-0.1-1.7-0.1-2.5c-0.5-1.6-1.4-3.2-2.4-4.4h-3.4l-0.1,2.6l0,0\r\n\t\t\t\tC267.2,49,266.3,50.9,265.9,52.9z\"/>\r\n\t\t\t<path fill=\"#CFB095\" d=\"M954.8,273.7c0,1.6-0.1,3.3-0.3,4.7c1.1-0.5,2.1-1.2,3.1-2.1c0.4-0.2,0.8-0.5,1.3-0.7\r\n\t\t\t\tC957.5,274.6,956.2,274,954.8,273.7L954.8,273.7z\"/>\r\n\t\t\t<path fill=\"#DECFBC\" d=\"M50,738c-0.5-1.9-1-3.9-1.3-6c-2.7-0.3-5.3-0.5-6.9,2.8l2.3,0.1l0,0C46,736.5,48,737.5,50,738z\"/>\r\n\t\t\t<path fill=\"#F0EBDE\" d=\"M272.2,956l2.2-0.1\"/>\r\n\t\t\t<path fill=\"#ECE7DB\" d=\"M48.4,728.6c-0.1-1.6,0-3.2,0.2-4.6c-1.3,0.3-2.5,0.7-3.7,1.4c-1.4,0.9-1.8,2.1-1,3.6h4.6\r\n\t\t\t\tC48.6,728.8,48.6,728.7,48.4,728.6z\"/>\r\n\t\t\t<path fill=\"#9D6728\" d=\"M45.8,273.7c-0.1-1.9,0-3.7,0.3-5.5H46c-1.6,0.5-3.2,1.4-4.5,2.4l0.1,3.5h4.2\r\n\t\t\t\tC45.8,274,45.8,273.8,45.8,273.7L45.8,273.7z\"/>\r\n\t\t\t<path fill=\"#CFB296\" d=\"M45.8,274.1h-4.2c0,0.7,0,1.6,0.2,2.3c0.7,1.1,1.5,1.2,2.3,0.2H46C45.9,275.8,45.9,275,45.8,274.1\r\n\t\t\t\tL45.8,274.1z\"/>\r\n\t\t\t<path fill=\"#D4BCA5\" d=\"M494.7,50.1c1.4-0.2,2.9-0.2,4.3-0.2v-2.7c-0.8,0-1.6,0-2.4,0.1l0,0C495.7,48.2,495.1,49.1,494.7,50.1\r\n\t\t\t\tL494.7,50.1z\"/>\r\n\t\t\t<path fill=\"#DDCDB9\" d=\"M265.7,53c1-0.3,2-0.5,3-0.7v-5.1c-0.8-0.1-1.6,0-2.4,0.1l0.1,4.7C266.1,52.4,265.9,52.7,265.7,53z\"/>\r\n\t\t\t<path fill=\"#EEE9DE\" d=\"M274.8,51.5h2.2c-0.5-1.6-1.4-3-2.5-4.1c-0.7-0.2-1.6-0.2-2.3-0.1v4.5C273,51.6,273.9,51.5,274.8,51.5z\"\r\n\t\t\t\t/>\r\n\t\t</g>\r\n\t\t<g id=\"lines\">\r\n\t\t\t<line fill=\"#00F456\" stroke=\"#FF911F\" stroke-width=\"12\" stroke-miterlimit=\"10\" x1=\"272.1\" y1=\"44.6\" x2=\"272.1\" y2=\"956\"/>\r\n\t\t\t<line fill=\"#00F456\" stroke=\"#FF911F\" stroke-width=\"12\" stroke-miterlimit=\"10\" x1=\"727.5\" y1=\"46.9\" x2=\"727.5\" y2=\"958.3\"/>\r\n\t\t\t<line fill=\"#00F456\" stroke=\"#FF911F\" stroke-width=\"12\" stroke-miterlimit=\"10\" x1=\"37.3\" y1=\"505.7\" x2=\"268.4\" y2=\"505.7\"/>\r\n\t\t\t<line fill=\"#00F456\" stroke=\"#FF911F\" stroke-width=\"12\" stroke-miterlimit=\"10\" x1=\"733\" y1=\"500.1\" x2=\"957.6\" y2=\"500.1\"/>\r\n\t\t\t<line fill=\"#00F456\" stroke=\"#FF911F\" stroke-width=\"12\" stroke-miterlimit=\"10\" x1=\"503.7\" y1=\"958.6\" x2=\"503.7\" y2=\"732.5\"/>\r\n\t\t\t<line fill=\"#00F456\" stroke=\"#FF911F\" stroke-width=\"12\" stroke-miterlimit=\"10\" x1=\"499\" y1=\"44.7\" x2=\"499\" y2=\"277\"/>\r\n\t\t\t<path fill=\"#00F456\" stroke=\"#FF911F\" stroke-miterlimit=\"10\" d=\"M299.6,966.4c-0.8,0-1.6,0.2-2.2,0.4c-0.8-1.3-2.2-2.2-4.2-2.2\r\n\t\t\t\tc-1,0-1.8,0.2-2.4,0.6c-0.7-0.5-1.7-0.8-2.8-0.7c-1.6,0.1-3.2,0-4.8-0.2c-0.4,0-0.8,0-1.3,0.1c-0.4-0.1-1-0.2-1.4-0.2\r\n\t\t\t\tc-0.4-0.1-1-0.2-1.5-0.2c-0.4,0-0.7,0-1.1,0.1c-0.3-0.1-0.6-0.1-1.1-0.1c-1.2,0-2.1,0.3-2.9,0.8c-0.8-0.3-1.7-0.3-2.8-0.2\r\n\t\t\t\tc-7,1.2-14.5-0.5-21.6-0.5s-14.2,0.4-21.3-0.1c-1.5-0.1-2.7,0.3-3.5,1.1c-8.5-0.1-17.1-0.4-25.5,0.5c-0.8-0.7-2-1.3-3.4-1.3\r\n\t\t\t\tc-22.3,0-44.4,0.1-66.7,0.3c-0.7-0.5-1.7-0.8-3-0.7c-22.5,0.5-45.1,0.8-67.6,1.1c-6.8,0.1-6.8,10.7,0,10.5\r\n\t\t\t\tc22.1-0.2,44-0.5,66.1-1.1c0.7,0.5,1.7,0.7,2.9,0.7c22.8-0.3,45.5-0.4,68.3-0.3c0.4,0,0.8,0,1.2-0.1c1.1,0.8,2.5,1.3,4.2,1.1\r\n\t\t\t\tc8.7-1.2,18-0.3,26.7-0.2c1.3,0,2.3-0.3,3.1-0.9c6.8,0.3,13.7-0.1,20.5,0c7.5,0.1,14.8,1.4,22.4,0.1c0.1,0,0.2,0,0.3-0.1\r\n\t\t\t\tc0.5,0.2,1.1,0.3,1.7,0.3s1.3-0.1,1.8-0.3h0.1c0.3,0,0.7,0,1.1-0.1c0.3,0.1,0.6,0.1,1,0.1h0.2c0.4,0,0.8,0,1.3-0.2\r\n\t\t\t\tc0.5,0.1,1.1,0.2,1.6,0.3c1.6,0.2,3.2,0.2,4.8,0.2c0.8,0,1.6-0.2,2.3-0.6c0.7,0.5,1.7,0.8,2.9,0.8c0.8,0,1.6-0.2,2.2-0.4\r\n\t\t\t\tc0.8,1.3,2.2,2.2,4.2,2.2C306.5,977,306.5,966.4,299.6,966.4L299.6,966.4z\"/>\r\n\t\t\t<line fill=\"#00F456\" stroke=\"#FF911F\" stroke-width=\"12\" stroke-miterlimit=\"10\" x1=\"41.9\" y1=\"276.5\" x2=\"960.4\" y2=\"276.5\"/>\r\n\t\t\t<line fill=\"#00F456\" stroke=\"#FF911F\" stroke-width=\"12\" stroke-miterlimit=\"10\" x1=\"34.3\" y1=\"731.8\" x2=\"979.2\" y2=\"731.8\"/>\r\n\t\t\t<polygon fill=\"none\" stroke=\"#FF911F\" stroke-width=\"20\" stroke-miterlimit=\"10\" points=\"31.6,35.2 965.3,37.1 965.3,967.2 \r\n\t\t\t\t33.8,967.2 \t\t\t\"/>\r\n\t\t</g>\r\n\t</g>\r\n\t<g id=\"SignLayer\">\r\n\t\t<g id=\"ARIES\">\r\n\t\t\t<path fill=\"#FF386C\" d=\"M355.8,207.3c0.1,0.8,1,2.4,3.1,2.4c0.1,0,0.2-0.1,0.3-0.1l5.3-8c1.1,0.1,5,0.3,5.7-2.8\r\n\t\t\t\tc0-0.1,0-0.2-0.1-0.3s-0.1-0.1-0.3-0.1H368c0.5-0.5,1.1-1.1,1.4-1.9c0.4-0.3,0.5-0.8,0.5-1.3c0-1-0.8-1.8-1.8-1.8h-0.3\r\n\t\t\t\tc0.6-0.3,1-0.8,1-1.5c0-0.9-0.8-1.7-1.7-1.7c-0.4,0-0.8,0.1-1.1,0.4c0.3-0.3,0.5-0.7,0.5-1.1c0-0.9-0.8-1.7-1.7-1.7\r\n\t\t\t\tc-0.5,0-0.9,0.1-1.2,0.5c0.1-0.2,0.2-0.5,0.2-0.9c0-0.9-0.8-1.7-1.7-1.7c-0.6,0-1.1,0.4-1.5,0.8c0.1-0.1,0.1-0.3,0.1-0.5\r\n\t\t\t\tc0-0.9-0.8-1.7-1.7-1.7c-0.4,0-0.8,0.1-1.1,0.4c-0.1,0-0.2-0.1-0.4-0.1c-0.6,0-1.1,0.4-1.5,0.8c0.1-0.1,0.1-0.3,0.1-0.5\r\n\t\t\t\tc0-0.9-0.8-1.7-1.7-1.7c-0.8,0-1.5,0.6-1.7,1.4c-0.1-0.9-0.8-1.6-1.7-1.6c-0.9,0-1.7,0.8-1.7,1.7v0.3c-0.3-0.6-0.8-1-1.5-1\r\n\t\t\t\tc-0.9,0-1.7,0.8-1.7,1.7c0,0.3,0.1,0.6,0.2,0.9c-0.3-0.4-0.8-0.7-1.4-0.7c-0.9,0-1.7,0.8-1.7,1.7c0,0.5,0.1,0.8,0.5,1.1\r\n\t\t\t\tc-0.2-0.1-0.5-0.2-0.9-0.2c-0.9,0-1.7,0.8-1.7,1.7c0,0.7,0.5,1.3,1,1.5c-0.1-0.1-0.3-0.1-0.5-0.1c-0.9,0-1.7,0.8-1.7,1.7\r\n\t\t\t\ts0.8,1.7,1.7,1.7h0.1c-0.8,0.1-1.5,0.8-1.5,1.7s0.7,1.6,1.6,1.7c-0.1,0.5-0.5,1.4-1.2,3c-1.5,3.8-3.7,9.4-4.7,11.5\r\n\t\t\t\tc-1,2-4.1,5.4-7.4,9c-1.7,1.8-3.4,3.8-5,5.6c-1.8,2-2.4,4.3-2.7,6.2c0,0-0.1,0-0.1,0.1l-4.5,5.1c-0.1,0.1-0.1,0.2-0.1,0.3\r\n\t\t\t\ts0.1,0.2,0.2,0.3s1.1,0.6,2.4,0.6c0.8,0,1.6-0.1,2.4-0.8v0.1c0.1,0.8,0.3,1.4,0.3,1.8c-0.1,1.3-3.4,5.1-5.6,7.2\r\n\t\t\t\tc-0.1,0.1-0.1,0.1-0.1,0.3v13.8c0,0.2,0.1,0.4,0.4,0.4h7.4c0.2,0,0.4-0.1,0.4-0.4c0-0.1,0.1-1.6-0.9-2.7\r\n\t\t\t\tc-0.6-0.7-1.5-1.1-2.6-1.1V251c1.1-0.2,4.3-1.1,7.4-3.3c0.1,0,0.1,0.1,0.2,0.1h0.1c0.5,0,3.9-0.1,6.6-2.8\r\n\t\t\t\tc2.4-2.4,3.4-6.2,3.1-11.1c1.1-0.7,2.4-1.4,3.6-1.8c1.9-0.6,5.1-2.1,7.9-4.3c1.5-1.2,2.7-2.5,3.7-3.8h2.4v5.6l-2.6,2.7\r\n\t\t\t\tc-0.1,0.1-0.1,0.4,0,0.5l2.7,3c0.1,0.1,0.1,0.1,0.3,0.1c0.1,0,0.1,0,0.2-0.1l3.5-3c0.1-0.1,0.9-1,1.1-3.9l1.1,1.4\r\n\t\t\t\tc0.1,0.1,0.3,0.1,0.5,0.1c0.1-0.1,4.2-2,4.2-5.5v-6.6c0-0.1-0.8-4.6-5-4.6H355v-13h0.8V207.3\r\n\t\t\t\tC355.9,207.2,355.9,207.3,355.8,207.3L355.8,207.3z M359,184.9c0.5,0,0.9,0.4,0.9,0.9c0,0.1,0,0.1-0.1,0.2c-0.1,0.1,0,0.4,0,0.5\r\n\t\t\t\tc-0.4,0.1-0.7,0.2-0.9,0.5c0.1-0.2,0.2-0.5,0.2-0.9c0-0.5-0.2-0.9-0.5-1.2H359L359,184.9z M341.2,196.6c0-0.5,0.4-0.8,0.8-0.9\r\n\t\t\t\tc0.3,0,0.6-0.3,0.7-0.6V195c0.1-0.2,0-0.5-0.1-0.6c-0.1-0.2-0.4-0.3-0.6-0.3h-0.1c-0.5,0-0.8-0.4-0.8-0.9s0.4-0.9,0.9-0.9\r\n\t\t\t\tc0.1,0,0.1,0,0.2,0.1h0.2c0.3,0,0.6-0.2,0.8-0.5c0.1-0.4-0.1-0.8-0.5-1c-0.3-0.1-0.5-0.5-0.5-0.8c0-0.5,0.4-0.9,0.9-0.9\r\n\t\t\t\tc0.1,0,0.3,0.1,0.5,0.1c0.1,0.1,0.3,0.1,0.4,0.1c0.2,0,0.5-0.1,0.6-0.3c0.2-0.3,0.2-0.8-0.1-1.1c-0.1-0.1-0.2-0.4-0.2-0.6\r\n\t\t\t\tc0-0.5,0.4-0.9,0.9-0.9c0.3,0,0.5,0.1,0.7,0.4c0.1,0.2,0.4,0.3,0.6,0.3c0.1,0,0.3-0.1,0.5-0.1c0.4-0.2,0.5-0.7,0.2-1.1\r\n\t\t\t\tc-0.1-0.1-0.1-0.3-0.1-0.5c0-0.5,0.4-0.9,0.9-0.9c0.4,0,0.7,0.2,0.8,0.5c0.1,0.3,0.4,0.5,0.7,0.5h0.2c0.4-0.1,0.6-0.5,0.5-0.9\r\n\t\t\t\tv-0.1c0-0.5,0.4-0.9,0.9-0.9s0.8,0.4,0.9,0.8c0,0.4,0.4,0.7,0.8,0.8h0.1c0.4,0,0.7-0.3,0.8-0.6c0.1-0.5,0.5-0.8,0.9-0.8\r\n\t\t\t\tc0.5,0,0.9,0.4,0.9,0.9c0,0.1,0,0.1-0.1,0.2c-0.1,0.4,0.1,0.8,0.5,0.9c0.1,0.1,0.2,0.1,0.3,0.1c0.3,0,0.5-0.1,0.7-0.4\r\n\t\t\t\tc0.1-0.3,0.5-0.5,0.8-0.5c0.5,0,0.9,0.4,0.9,0.9c0,0.1-0.1,0.3-0.1,0.5c-0.2,0.3-0.1,0.8,0.1,1.1c0.1,0.1,0.3,0.1,0.5,0.1\r\n\t\t\t\ts0.4-0.1,0.5-0.2c0.1-0.2,0.4-0.2,0.6-0.2c0.5,0,0.9,0.4,0.9,0.9c0,0.3-0.1,0.5-0.2,0.6c-0.3,0.3-0.3,0.8,0,1.1\r\n\t\t\t\tc0.1,0.1,0.4,0.2,0.6,0.2c0.1,0,0.3-0.1,0.5-0.1c0.1-0.1,0.3-0.2,0.5-0.2c0.5,0,0.9,0.4,0.9,0.9c0,0.4-0.2,0.7-0.5,0.8\r\n\t\t\t\tc-0.4,0.1-0.5,0.6-0.4,1c0.1,0.3,0.4,0.5,0.8,0.5h0.3c0.6,0,1.1,0.5,1.1,1.1c0,0.3-0.1,0.5-0.3,0.8c-0.1,0.1-0.1,0.1-0.1,0.3\r\n\t\t\t\tc-0.6,1.7-2.1,2.4-3.2,2.4h-0.4c-0.9-0.1-1.5-0.8-1.5-1.8c0-3.5-3.3-6.5-6.9-6.5c-3.7,0-7.3,2.1-7.3,6.8c0,3.3,3,6.5,4.5,8\r\n\t\t\t\tc-3.4-0.4-4.3-1.4-4.3-1.9c0-0.2,0.1-0.5,0.2-0.5c0.1-0.2,0.2-0.5,0.1-0.8c-0.1-0.2-0.2-0.5-0.5-0.5c-0.1,0-0.1-0.1-0.2-0.1\r\n\t\t\t\ts-0.3,0.1-0.5,0.1c-0.1,0.1-0.3,0.1-0.5,0.1c-0.5,0-0.9-0.4-0.9-0.9c0-0.2,0.1-0.5,0.3-0.7s0.3-0.6,0.1-0.9\r\n\t\t\t\tc-0.1-0.3-0.4-0.5-0.7-0.5H342C341.6,197.6,341.2,197.1,341.2,196.6L341.2,196.6z M317.4,238.9l3.5-4c0,1.3,0.2,2.5,0.4,3.5\r\n\t\t\t\tC319.9,239.5,318.3,239.2,317.4,238.9L317.4,238.9z M334.5,244.4c-1.8,1.9-4.1,2.4-5.3,2.5c2.7-2.3,5-5.7,5.7-10.8\r\n\t\t\t\tc0.3-0.2,1.3-1,2.5-1.8C337.6,238.9,336.7,242.2,334.5,244.4z M359.4,232.4l-3.2,2.7l-2.3-2.4l2.4-2.5c0.1-0.1,0.1-0.1,0.1-0.3\r\n\t\t\t\tv-6.2c0-0.2-0.1-0.4-0.4-0.4h-2.3c0.6-1.1,1-2.2,1.1-3.3c1.7,0.1,3,0.5,3.9,1.6c1.7,1.9,1.4,4.9,1.4,4.9\r\n\t\t\t\tc-0.1,0.1-0.3,0.1-0.5,0.2c-0.1,0.1-0.2,0.1-0.2,0.3s0,0.2,0.1,0.4l0.7,0.8C360.1,231.5,359.3,232.4,359.4,232.4L359.4,232.4z\r\n\t\t\t\t M355.8,219.2h5.3c0.1,0,0.8,0.2,0.8,1.2v3.8c-0.1,0.2-0.4,1-1.1,1.6c0-1.1-0.1-3.3-1.6-4.8C358.5,220,357.3,219.4,355.8,219.2\r\n\t\t\t\tL355.8,219.2z M354.6,200.1c-0.2,0-0.4,0.1-0.4,0.4v13.7c0,0.2,0.1,0.4,0.4,0.4h7.2c3.3,0,4.1,3.4,4.2,3.9v6.5\r\n\t\t\t\tc0,2.6-2.7,4.3-3.5,4.7l-2.1-2.5c1.7-1,2.4-2.7,2.4-2.9v-3.9c0-1.4-1-1.9-1.5-2h-6.6c-0.2,0-0.4,0.1-0.4,0.4\r\n\t\t\t\tc-0.1,7-9.4,11.5-12.7,12.6c-3.4,1.1-7.1,4.1-7.3,4.3c-0.1,0.1-0.1,0.1-0.1,0.2c-1.3,12.3-13.6,14.4-13.7,14.4\r\n\t\t\t\tc-0.2,0-0.3,0.2-0.3,0.4v8.3c0,0.2,0.1,0.4,0.4,0.4c1.1,0,1.9,0.3,2.4,0.8s0.7,1.3,0.7,1.8h-6.6v-13.3c0.9-1,5.6-5.7,5.7-7.6\r\n\t\t\t\tc0-0.5-0.1-1.1-0.3-2c-0.5-2.7-1.5-7.1,2-11.2c1.5-1.8,3.3-3.7,5-5.5c3.4-3.7,6.5-7.1,7.6-9.2c1.1-2,3.3-7.8,4.7-11.5\r\n\t\t\t\tc0.1-0.5,0.4-0.9,0.5-1.4c0.3,0.5,0.8,0.9,1.5,0.9c0.4,0,0.7-0.1,1-0.3l0,0c-0.2,0.3-0.4,0.7-0.4,1.1c0,0.8,1,2.4,6.3,2.7l0,0\r\n\t\t\t\tc0.1,0,0.3-0.1,0.4-0.2s0-0.3-0.1-0.5c-0.1-0.1-5.1-4.3-5.1-8.2c0-4.2,3.3-6,6.5-6s6.2,2.7,6.2,5.7c0,1.4,0.8,2.4,2.1,2.6\r\n\t\t\t\tc0.1,0,0.4,0.1,0.5,0.1c1.5,0,3.2-0.9,3.9-2.9c0.4-0.3,0.5-0.8,0.5-1.3c0-1-0.8-1.8-1.8-1.8h-0.3c0.6-0.3,1-0.8,1-1.5\r\n\t\t\t\tc0-0.9-0.8-1.7-1.7-1.7c-0.4,0-0.8,0.1-1.1,0.4c0.3-0.3,0.5-0.7,0.5-1.1c0-0.6-0.3-1.1-0.8-1.4c0.1-0.1,0.1-0.1,0.1-0.1\r\n\t\t\t\tc0.1-0.3,0.5-0.5,0.8-0.5c0.5,0,0.9,0.4,0.9,0.9c0,0.1-0.1,0.3-0.1,0.5c-0.2,0.3-0.1,0.8,0.1,1.1c0.1,0.1,0.3,0.1,0.5,0.1\r\n\t\t\t\ts0.4-0.1,0.5-0.2c0.1-0.2,0.4-0.2,0.6-0.2c0.5,0,0.9,0.4,0.9,0.9c0,0.3-0.1,0.5-0.2,0.6c-0.3,0.3-0.3,0.8,0,1.1\r\n\t\t\t\tc0.1,0.1,0.4,0.2,0.6,0.2c0.1,0,0.3-0.1,0.5-0.1c0.1-0.1,0.3-0.2,0.5-0.2c0.5,0,0.9,0.4,0.9,0.9c0,0.4-0.2,0.7-0.5,0.8\r\n\t\t\t\tc-0.4,0.1-0.5,0.6-0.4,1c0.1,0.3,0.4,0.5,0.8,0.5h0.3c0.6,0,1.1,0.5,1.1,1.1c0,0.3-0.1,0.5-0.3,0.8c-0.1,0.1-0.1,0.1-0.1,0.3\r\n\t\t\t\tc-0.4,1.1-1.2,1.8-2,2.1h-0.5c-0.2,0-0.4,0.1-0.4,0.4c0,0.2,0.1,0.4,0.4,0.4h3.3c-1,2.2-4.9,1.7-5,1.7s-0.3,0.1-0.4,0.1l-5.3,8\r\n\t\t\t\tc-1.7-0.1-2.1-1.4-2.1-1.7v-6.6c0-0.2-0.1-0.4-0.4-0.4L354.6,200.1L354.6,200.1L354.6,200.1z\"/>\r\n\t\t\t<g id=\"stars_00000142153472370070283740000013772449811545204880_\">\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M359.5,237.3L359.5,237.3c-0.7,0.2-1.1,0.8-1.1,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.8-1.8-0.6l0,0c0.4-0.5,0.4-1.3,0-1.8l0,0c0.7,0.2,1.4,0,1.8-0.6l0,0C358.4,236.4,358.9,237,359.5,237.3\r\n\t\t\t\t\tL359.5,237.3L359.5,237.3z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M358.8,227L358.8,227c-0.6,0.2-1,0.9-1,1.6l0,0\r\n\t\t\t\t\tc-0.5-0.5-1.1-0.7-1.8-0.5l0,0c0.4-0.6,0.3-1.3-0.1-1.8l0,0c0.7,0.1,1.4-0.1,1.7-0.7l0,0C357.7,226.2,358.1,226.8,358.8,227\r\n\t\t\t\t\tL358.8,227L358.8,227z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M350,218.1L350,218.1c-0.6,0.2-1,0.9-1,1.6l0,0\r\n\t\t\t\t\tc-0.5-0.5-1.1-0.7-1.8-0.5l0,0c0.4-0.6,0.3-1.3-0.1-1.8l0,0c0.7,0.1,1.4-0.1,1.7-0.7l0,0C348.7,217.3,349.3,217.9,350,218.1\r\n\t\t\t\t\tL350,218.1L350,218.1z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M325.9,211.9L325.9,211.9c-0.4,0.5-0.4,1.3,0,1.8l0,0\r\n\t\t\t\t\tc-0.7-0.2-1.4,0-1.8,0.6l0,0c0-0.7-0.5-1.3-1.1-1.5l0,0c0.7-0.2,1.1-0.8,1.1-1.5l0,0C324.5,211.9,325.3,212.1,325.9,211.9\r\n\t\t\t\t\tL325.9,211.9L325.9,211.9z\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"357.8,237.4 357.1,227.2 348.4,218.2 324.5,212.8 \r\n\t\t\t\t\t324.5,212.4 348.5,217.9 348.6,217.9 357.4,227 358.2,237.4 \t\t\t\t\"/>\r\n\t\t\t</g>\r\n\t\t</g>\r\n\t\t<g id=\"TAURUS\">\r\n\t\t\t<path fill=\"#FF8233\" d=\"M613,232.1c0.1-0.2,0-0.4-0.2-0.6c-0.2-0.2-0.4-0.2-0.6,0l-6.6,4.8H599c-1.7-3.7-6-10.4-8.5-14.3\r\n\t\t\t\tc-2.3-3.4-9.9-14.7-12.9-16.1c-4.4-2-10.9-0.6-17.3,4c-6.1,4.3-10.9,5.4-19.9,6.3c-7.7,0.8-12.1,3.4-13.4,8.1\r\n\t\t\t\tc-0.9,0.1-3.8,0.4-5.8-0.9c-0.9-0.6-1.5-1.6-1.7-2.8c-0.7-4.1,3.2-5.7,6.7-7c0.8-0.3,1.5-0.6,2.1-0.9c2.3-1.1,9.7-5.4,6.5-15.2\r\n\t\t\t\tc-1.5-4.8-2.7-6.2-3.5-7c-0.6-0.7-0.9-1-0.9-2.8c0-0.2-0.1-0.3-0.3-0.4s-0.3-0.1-0.5,0s-3.3,2.1-3.3,5.3c0,2.3,1.5,4.6,4.7,6.7\r\n\t\t\t\tc0.3,0.7,2,4.7-0.9,7.6c-1.1,1.1-3.2,2.1-5.5,3.1c-4.5,2-9.6,4.3-9.7,9.3c-0.1,3,1,5.4,3.1,7c1.7,1.4,4,2,6.3,2\r\n\t\t\t\tc0.7,0,1.4-0.1,2.1-0.2c0.2,5.3,1.5,11.9,1.8,13.2l-10.2,17c-0.1,0.1-0.1,0.3,0,0.4l1.4,3.7c0.1,0.2,0.3,0.3,0.4,0.3h8.9\r\n\t\t\t\tc0.2,0,0.3-0.1,0.3-0.2s0.2-0.3,0.1-0.4l-0.8-4.6l8.9-10.4h3.6l-8.2,10.9c-0.1,0.1-0.1,0.3-0.1,0.4l0.9,3.8\r\n\t\t\t\tc0.1,0.3,0.3,0.4,0.5,0.4h8.5c0.2,0,0.3-0.1,0.4-0.2c0.1-0.2,0.2-0.3,0.1-0.4l-1.1-3.8l10.1-11l11.9,0.1l8.9,14.9\r\n\t\t\t\tc0.1,0.2,0.3,0.3,0.4,0.3h8.9c0.2,0,0.3-0.1,0.4-0.3c0.1-0.2,0.1-0.3,0-0.5c-0.1-0.1-5.4-10.4-6.8-12.9c-0.3-0.5-0.3-0.9-0.2-1.2\r\n\t\t\t\tc0.3-0.7,1.7-1,2.1-1.1h5.4c0.4,4.6,1.9,7.6,4.3,9.3c3,2,6.3,0.8,6.4,0.8c0.2-0.1,0.3-0.2,0.3-0.3c0.1-0.3,0.9-2.6,2-5.5l4.8,7.5\r\n\t\t\t\tv3.7c0,0.3,0.3,0.5,0.5,0.5h9.7c0.2,0,0.3-0.1,0.4-0.3c0.1-0.2,0.1-0.3,0-0.5l-11.5-20h4.6C604.5,241.8,609,242.1,613,232.1\r\n\t\t\t\tL613,232.1z M526.7,227.2c-2.8,0.6-5.8,0-7.9-1.6c-1.8-1.4-2.7-3.7-2.7-6.3c0.1-4.5,4.9-6.6,9.1-8.5c2.3-1,4.5-2,5.7-3.3\r\n\t\t\t\tc3.6-3.7,0.9-8.8,0.9-8.8c0-0.1-0.1-0.2-0.2-0.2c-2.9-2-4.4-4-4.4-6s1.4-3.3,2.2-4.1c0.1,1.3,0.5,1.8,1.1,2.5\r\n\t\t\t\tc0.8,0.9,1.9,2.1,3.3,6.7c2.8,8.8-3.2,12.7-6,14.1c-0.6,0.3-1.3,0.6-2,0.9c-3.4,1.4-8.2,3.2-7.4,8.1c0.3,1.4,0.9,2.6,2.1,3.4\r\n\t\t\t\tc2,1.4,4.9,1.3,6.2,1.1C526.8,225.8,526.7,226.5,526.7,227.2L526.7,227.2z M541,257.7c-0.1,0.2-0.2,0.3-0.1,0.5l1,3.4h-7.4\r\n\t\t\t\tl-0.8-3.1l8.5-11.3l8.5,0.1L541,257.7L541,257.7z M595.5,249.3c-0.1,0.1-0.1,0.2-0.1,0.3c-1,2.9-1.9,5.3-2.1,6.1\r\n\t\t\t\tc-0.8,0.2-3.2,0.7-5.4-0.8c-2.2-1.4-3.5-4.5-3.8-8.9c0-0.3-0.3-0.4-0.5-0.4h-5.9c-0.3,0-2.3,0.3-3,1.6c-0.3,0.6-0.3,1.4,0.2,2.1\r\n\t\t\t\tc1.2,2.1,5.2,9.8,6.5,12.2h-7.8l-8.9-14.9c-0.1-0.2-0.3-0.3-0.4-0.3l-27.1-0.3c-0.2,0-0.3,0.1-0.3,0.2l-9.1,10.7\r\n\t\t\t\tc-0.1,0.1-0.2,0.3-0.1,0.4l0.7,4.3h-8l-1.2-3.2l10.4-16.8c0.1-0.1,0.1-0.3,0.1-0.3s-1.8-8.2-1.8-13.9s4.3-9.3,13-10.2\r\n\t\t\t\tc9.2-0.9,14.1-2,20.4-6.5c6-4.3,12.3-5.8,16.3-3.9c4.2,2,21.8,29.2,21.6,31.6C598.8,239.6,597,244.9,595.5,249.3L595.5,249.3z\r\n\t\t\t\t M610.1,261.5h-8.3v-3.4c0-0.1,0-0.2-0.1-0.3l-5.3-8.2c0.9-2.6,1.8-5.3,2.5-7.5L610.1,261.5L610.1,261.5z M599.3,240.8\r\n\t\t\t\tc0.3-1.1,0.5-1.9,0.6-2.3c0-0.3-0.1-0.7-0.3-1.2h6.3c0.1,0,0.2,0,0.3-0.1l5.3-3.8c-3.5,7.6-7,7.5-7.1,7.5L599.3,240.8\r\n\t\t\t\tL599.3,240.8L599.3,240.8z\"/>\r\n\t\t\t<path fill=\"#FF8233\" d=\"M587.1,236.7L587.1,236.7c-0.2-0.1-0.3-0.1-0.3-0.1h-8.9l-8.1-5.8c-0.2-0.1-0.4-0.1-0.6,0\r\n\t\t\t\tc-0.2,0.1-0.3,0.3-0.2,0.5c0.2,0.4,3.2,9.8,7.8,10.4H587c0.1,0,2.2-0.7,2.2-2.6C589.1,237.3,587.6,236.8,587.1,236.7L587.1,236.7\r\n\t\t\t\tz M586.6,240.7h-9.9c-2.7-0.3-5.2-5.2-6.4-8.2l7,4.9c0.1,0.1,0.2,0.1,0.3,0.1h9c0,0,0.1,0,0.1,0.1c0.7,0.3,1.5,0.6,1.5,1.5\r\n\t\t\t\tC588.2,240.2,587,240.6,586.6,240.7z\"/>\r\n\t\t\t<g id=\"stars_00000003810303168224481210000014347154050854893460_\">\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M568.2,235.8L568.2,235.8c-0.8,0.3-1.4,1-1.4,1.8l0,0\r\n\t\t\t\t\tc-0.5-0.7-1.4-0.9-2.1-0.7l0,0c0.5-0.7,0.5-1.6,0-2.2l0,0c0.8,0.3,1.6,0,2.1-0.7l0,0C566.8,234.8,567.3,235.6,568.2,235.8\r\n\t\t\t\t\tL568.2,235.8L568.2,235.8z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M576.1,230.6L576.1,230.6c-0.8,0.3-1.4,1-1.4,1.8l0,0\r\n\t\t\t\t\tc-0.5-0.7-1.4-0.9-2.1-0.7l0,0c0.5-0.7,0.5-1.6,0-2.2l0,0c0.8,0.3,1.6,0,2.1-0.7l0,0C574.9,229.6,575.4,230.4,576.1,230.6\r\n\t\t\t\t\tL576.1,230.6L576.1,230.6z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M554,237.4L554,237.4c-0.8,0.3-1.3,1.1-1.2,2l0,0\r\n\t\t\t\t\tc-0.5-0.6-1.5-0.9-2.2-0.5l0,0c0.4-0.7,0.3-1.6-0.2-2.2l0,0c0.9,0.2,1.6-0.2,2-0.9l0,0C552.6,236.6,553.2,237.3,554,237.4\r\n\t\t\t\t\tL554,237.4L554,237.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M598.5,258.1L598.5,258.1c-0.8,0.3-1.3,1.1-1.2,2l0,0\r\n\t\t\t\t\tc-0.5-0.6-1.5-0.9-2.2-0.5l0,0c0.4-0.7,0.3-1.6-0.2-2.2l0,0c0.9,0.2,1.6-0.2,2-0.9l0,0C597.1,257.2,597.7,257.9,598.5,258.1\r\n\t\t\t\t\tL598.5,258.1L598.5,258.1z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M529.1,237.3L529.1,237.3c-0.8,0.3-1.3,1.1-1.2,2l0,0\r\n\t\t\t\t\tc-0.5-0.6-1.5-0.9-2.2-0.5l0,0c0.4-0.7,0.3-1.6-0.2-2.2l0,0c0.9,0.2,1.6-0.2,2-0.9l0,0C527.6,236.4,528.2,237.1,529.1,237.3\r\n\t\t\t\t\tL529.1,237.3L529.1,237.3z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M587.2,235.4L587.2,235.4c0.8-0.3,1.3-1.1,1.2-2l0,0\r\n\t\t\t\t\tc0.5,0.6,1.5,0.9,2.2,0.5l0,0c-0.4,0.7-0.3,1.6,0.2,2.2l0,0c-0.9-0.2-1.6,0.2-2,0.9l0,0C588.6,236.3,588,235.6,587.2,235.4\r\n\t\t\t\t\tL587.2,235.4L587.2,235.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M568.5,221.5L568.5,221.5c0.8-0.3,1.3-1.1,1.2-2l0,0\r\n\t\t\t\t\tc0.5,0.6,1.5,0.9,2.2,0.5l0,0c-0.4,0.7-0.3,1.6,0.2,2.2l0,0c-0.9-0.2-1.6,0.2-2,0.9l0,0C569.9,222.4,569.3,221.7,568.5,221.5\r\n\t\t\t\t\tL568.5,221.5L568.5,221.5z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M580.9,254.4L580.9,254.4c0.8-0.3,1.3-1.1,1.2-2l0,0\r\n\t\t\t\t\tc0.5,0.6,1.5,0.9,2.2,0.5l0,0c-0.4,0.7-0.3,1.6,0.2,2.2l0,0c-0.9-0.2-1.6,0.2-2,0.9l0,0C582.4,255.4,581.8,254.7,580.9,254.4\r\n\t\t\t\t\tL580.9,254.4L580.9,254.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M544.4,217.5L544.4,217.5c0.8-0.4,1.1-1.2,1-2l0,0\r\n\t\t\t\t\tc0.6,0.6,1.5,0.7,2.2,0.3l0,0c-0.3,0.8-0.3,1.6,0.3,2.2l0,0c-0.9-0.1-1.6,0.3-2,1l0,0C545.8,218.2,545.1,217.6,544.4,217.5\r\n\t\t\t\t\tL544.4,217.5L544.4,217.5z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M609.2,232L609.2,232c0.8-0.4,1.1-1.2,1-2l0,0\r\n\t\t\t\t\tc0.6,0.6,1.5,0.7,2.2,0.3l0,0c-0.3,0.8-0.3,1.6,0.3,2.2l0,0c-0.9-0.1-1.6,0.3-2,1l0,0C610.6,232.8,609.9,232.2,609.2,232\r\n\t\t\t\t\tL609.2,232L609.2,232z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M519.6,216.4L519.6,216.4c0.8-0.4,1.1-1.2,1-2l0,0\r\n\t\t\t\t\tc0.6,0.6,1.5,0.7,2.2,0.3l0,0c-0.3,0.8-0.3,1.6,0.3,2.2l0,0c-0.9-0.1-1.6,0.3-2,1l0,0C521,217.1,520.4,216.5,519.6,216.4\r\n\t\t\t\t\tL519.6,216.4L519.6,216.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M602.8,219.7L602.8,219.7c0.8-0.4,1.1-1.2,1-2l0,0\r\n\t\t\t\t\tc0.6,0.6,1.5,0.7,2.2,0.3l0,0c-0.3,0.8-0.3,1.6,0.3,2.2l0,0c-0.9-0.1-1.6,0.3-2,1l0,0C604.2,220.4,603.6,219.8,602.8,219.7\r\n\t\t\t\t\tL602.8,219.7L602.8,219.7z\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"526.9,237.9 526.9,237.4 552.1,237.4 566,235.9 \r\n\t\t\t\t\t574.2,230.4 570.2,221.3 546.2,217.4 521.4,216.2 521.5,215.8 546.3,216.9 570.6,221 570.7,221 574.8,230.6 566.1,236.4 \r\n\t\t\t\t\t552.1,237.9 \t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"596.8,258.6 582.2,254.8 582.3,254.5 588.9,235.2 \r\n\t\t\t\t\t604.8,218.3 611.2,231.6 610.8,231.8 604.6,219.1 589.3,235.4 582.8,254.4 596.9,258.2 \t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"574.1,230.9 574.2,230.5 589.2,235.2 589,235.6 \t\t\t\t\r\n\t\t\t\t\t\"/>\r\n\t\t\t</g>\r\n\t\t</g>\r\n\t\t<g id=\"GEMINI\">\r\n\t\t\t<path fill=\"#4DFFAD\" d=\"M818.1,256.7c-0.6-0.6-5.1-8.5-8.1-13.8c-0.1-6.9-0.3-16.2-0.4-18c0-1.7-1.1-3.7-2-5.4\r\n\t\t\t\tc-0.6-1.2-1.2-2.3-1.3-3c-0.1-1.3,1.3-4.1,2.3-5.8c0.1,2.8,0.5,8.9,0.6,9.6c0.2,0.9,3.9,10.5,5.5,12c0.9,0.8,2.1,0.9,3.1,0.3\r\n\t\t\t\tc0.9-0.6,1.3-1.6,0.9-2.7c-0.7-2.1-4.2-8.9-4.7-9.7l-0.1-11.2c0-0.1,0.2-1.9-1.1-3.4c-1-1.1-2.5-1.7-4.6-1.8V194\r\n\t\t\t\tc0-0.1,0-3-1.8-4.9c-1.1-1.2-2.7-1.7-4.6-1.7c-2.6,0-5,1.4-6.3,3.9c-2,3.6-1.7,8.5,0.8,12.9c-0.5,0.2-1.3,0.6-2.2,1.5\r\n\t\t\t\tc-1.2,1.2-2.7,3.4-2.7,7.2c0,0.9-0.2,1.7-0.6,2.3c-0.4-0.7-0.6-1.4-0.6-2.3c0-6.1-3.6-8.1-4.9-8.7c2.5-4.4,2.8-9.3,0.8-12.9\r\n\t\t\t\tc-1.4-2.5-3.7-3.9-6.3-3.9c-1.9,0-3.5,0.6-4.6,1.7c-1.9,1.9-1.8,4.8-1.8,4.9v9.8c-2.1,0-3.6,0.7-4.6,1.8\r\n\t\t\t\tc-1.3,1.5-1.1,3.3-1.1,3.4l-0.1,11.3c-0.4,0.9-4,7.6-4.7,9.7c-0.4,1.1,0,2.2,0.9,2.7c1,0.6,2.2,0.5,3.1-0.3\r\n\t\t\t\tc1.6-1.5,5.3-11.1,5.5-12c0.2-0.8,0.5-6.9,0.6-9.6c0.9,1.7,2.4,4.4,2.3,5.8c0,0.7-0.7,1.8-1.3,3c-0.9,1.7-2,3.7-2,5.4\r\n\t\t\t\tc0,1.8-0.2,11-0.4,18c-2.9,5.3-7.4,13.2-8.1,13.8c-0.9,0.9-1.5,1.6-0.6,3c0.8,1.2,4.5,3.3,4.6,3.4h0.1h1l0,0h17.5v-0.4\r\n\t\t\t\tc0-0.3-0.3-31.8-0.3-36c0-1.4-0.1-2.8-0.4-4.2c1.8-0.2,3.7-0.6,5.4-1.4c1.7,0.8,3.5,1.2,5.4,1.4c-0.2,1.4-0.4,2.8-0.4,4.2\r\n\t\t\t\tc0,4.1-0.3,35.7-0.3,36v0.4H813l0,0h1h0.1c0.1-0.1,3.8-2.2,4.6-3.4C819.6,258.3,819,257.6,818.1,256.7L818.1,256.7z M812.3,206.1\r\n\t\t\t\tc1.1,1.2,0.9,2.8,0.9,2.9l0.1,11.5v0.1c0,0.1,4,7.5,4.7,9.7c0.3,0.8,0,1.5-0.6,1.9s-1.5,0.4-2.2-0.2c-1.4-1.3-5-10.7-5.3-11.6\r\n\t\t\t\tc-0.2-0.7-0.5-8.1-0.7-10.8v-1.3l-0.6,1.1c-0.1,0.2-0.2,0.4-0.3,0.6c-0.2,0.4-0.4,0.8-0.6,1.2l-7.1-6.7v-2.8l-0.3-0.1\r\n\t\t\t\tc-3.8-1.3-2.9-6.9-2.7-8.2c1.6-0.2,2.6-1,3.1-1.6c0.9,1.6,2.5,2.3,3.2,2.6v7.8c0,0.8,0.3,1.5,0.8,2c1.1,1,3.1,0.8,3.3,0.8\r\n\t\t\t\tC809.9,204.6,811.4,205.1,812.3,206.1L812.3,206.1z M796.1,191.7c1.3-2.2,3.3-3.5,5.7-3.5c1.7,0,3.1,0.5,4.1,1.5\r\n\t\t\t\tc1.7,1.7,1.6,4.3,1.6,4.4v9.8c-0.6,0-1.7,0-2.4-0.6c-0.4-0.3-0.6-0.8-0.6-1.4v-8.2l-0.3-0.1c0,0-2.4-0.7-3.2-2.8l-0.3-0.9\r\n\t\t\t\tl-0.4,0.8c0,0-0.8,1.6-3.1,1.8H797v0.3c0,0.1-0.4,1.9-0.3,3.9c0.2,2.7,1.3,4.5,3.2,5.3v2.1h-2.7\r\n\t\t\t\tC794.1,199,794.7,194.4,796.1,191.7L796.1,191.7z M789.4,212.8c0,1.1,0.3,2.2,0.9,3c0,0-0.1,0.1-0.2,0.2c-0.6,0.6-1.5,1-2.4,1.4\r\n\t\t\t\tc-0.8-1.3-1.3-2.8-1.5-4.8c0.8-3.6-2.1-6.5-3.6-7.8h2.1C785.2,204.9,789.4,206.3,789.4,212.8L789.4,212.8z M784.7,215.9\r\n\t\t\t\tc0.1-1,0.5-1.9,0.9-2.4c0.2,1.7,0.7,3,1.4,4.1c-0.7,0.2-1.4,0.3-2.2,0.4C784.7,217.2,784.6,216.4,784.7,215.9L784.7,215.9z\r\n\t\t\t\t M775.7,189.7c1-1,2.3-1.5,4.1-1.5c2.3,0,4.4,1.3,5.7,3.5c1.5,2.7,2,7.3-0.9,12.3h-2.7v-2c1.9-0.8,3-2.6,3.2-5.3\r\n\t\t\t\tc0.1-2.1-0.3-3.9-0.3-3.9v-0.3h-0.3c-2.3-0.2-3.1-1.8-3.1-1.8l-0.4-0.8l-0.3,0.9c-0.8,2.1-3.2,2.8-3.2,2.8l-0.3,0.1v8.3\r\n\t\t\t\tc0,0.6-0.2,1.1-0.6,1.4c-0.7,0.6-1.9,0.6-2.4,0.6v-9.9C774.1,194.1,774.1,191.4,775.7,189.7L775.7,189.7z M773,209.2l-0.6-1.1\r\n\t\t\t\tv1.3c-0.1,2.8-0.5,10.1-0.7,10.8c-0.2,1-3.9,10.3-5.3,11.6c-0.7,0.7-1.6,0.6-2.2,0.2c-0.6-0.4-0.9-1.1-0.6-1.9\r\n\t\t\t\tc0.7-2.2,4.6-9.6,4.7-9.7v-0.1l0.1-11.5c0,0-0.2-1.6,0.9-2.8c0.9-1,2.3-1.5,4.4-1.5c0.3,0,2.2,0.2,3.3-0.8c0.5-0.5,0.8-1.1,0.8-2\r\n\t\t\t\tV194c0.6-0.2,2.2-1,3.2-2.6c0.5,0.6,1.4,1.4,3.1,1.6c0.3,1.3,1.1,6.9-2.7,8.2l-0.3,0.1v2.8L774,211c-0.2-0.4-0.4-0.8-0.6-1.2\r\n\t\t\t\tC773.3,209.6,773.1,209.4,773,209.2L773,209.2z M767.8,262.4c-1.1-0.6-3.7-2.3-4.3-3.1c-0.6-0.9-0.4-1.2,0.5-2\r\n\t\t\t\tc0.8-0.8,5.6-9.2,7.6-12.8c0,3.4-0.1,6-0.1,6.4l-0.8,3.2c-3.6,2.8-3.8,4-3.6,4.4c0.4,0.8,1.6,2.1,1.9,2.5l-0.3,1.3h-0.9\r\n\t\t\t\tL767.8,262.4L767.8,262.4z M769.3,260.1c-0.5-0.5-1.2-1.4-1.5-2c-0.1-0.4,1.1-1.6,2.6-2.9L769.3,260.1L769.3,260.1z M785.1,226.8\r\n\t\t\t\tc0,3.9,0.3,32,0.3,35.6h-15.5l0,0h-0.3l2.7-11.4v-0.1c0-0.1,0-3.5,0.1-7.8l0,0c0.1-7,0.3-16.4,0.4-18.1c0-1.3,0.8-2.9,1.5-4.3\r\n\t\t\t\tc0.1-0.3,0.3-0.5,0.4-0.8c0.3-0.5,0.5-1,0.8-1.4c0.4-0.7,0.6-1.3,0.6-1.8c0.1-1.2-0.7-3-1.7-4.9l7.2-6.7c1,0.8,4.7,3.9,3.9,7.5\r\n\t\t\t\tc-0.3,0.4-1.4,1.6-1.6,3.4c0,0.6,0,1.3,0.1,2.3c0,0.2,0,0.5,0.1,0.7c0,0.4,0.1,0.9,0.2,1.3c0.1,0.5,0.2,1.1,0.3,1.7\r\n\t\t\t\tc0,0.3,0.1,0.5,0.1,0.8C784.9,224.1,785,225.5,785.1,226.8L785.1,226.8z M785.4,221.9c-0.1-0.6-0.2-1.2-0.3-1.8\r\n\t\t\t\tc-0.1-0.4-0.1-0.9-0.2-1.3c0.9-0.1,1.7-0.3,2.5-0.5c0.3-0.1,0.5-0.2,0.8-0.3c0.9-0.4,1.8-0.8,2.5-1.5c0,0,0.1-0.1,0.1-0.2\r\n\t\t\t\tc0.2-0.2,0.4-0.4,0.5-0.6c0.6-0.9,0.9-1.8,0.9-3c0-6.5,4.2-7.9,4.7-8.1h2.1c-1.5,1.3-4.4,4.2-3.6,7.8c-0.2,2-0.7,3.6-1.5,4.8\r\n\t\t\t\tc-0.1,0.2-0.3,0.4-0.4,0.6c-0.8,1-1.7,1.7-2.7,2.3c-0.3,0.1-0.6,0.3-0.9,0.4C788.5,221.4,787,221.7,785.4,221.9L785.4,221.9z\r\n\t\t\t\t M796.9,218.1c-0.7-0.1-1.5-0.2-2.2-0.4c0.7-1.1,1.1-2.5,1.4-4.1c0.4,0.5,0.8,1.4,0.9,2.4C797,216.4,797,217.2,796.9,218.1\r\n\t\t\t\tL796.9,218.1z M791.7,220.8c1-0.6,1.9-1.4,2.6-2.4c0.8,0.2,1.6,0.4,2.5,0.5c0,0.4-0.1,0.9-0.2,1.3c-0.1,0.6-0.2,1.2-0.3,1.8\r\n\t\t\t\tC794.7,221.7,793.1,221.4,791.7,220.8L791.7,220.8z M796.6,226.8c0-1.3,0.1-2.8,0.3-4.1c0-0.3,0.1-0.5,0.1-0.8\r\n\t\t\t\tc0.1-0.6,0.2-1.2,0.3-1.7s0.1-0.9,0.2-1.3c0-0.3,0.1-0.5,0.1-0.7c0.1-0.9,0.2-1.7,0.1-2.3c-0.2-1.8-1.3-3.1-1.6-3.4\r\n\t\t\t\tc-0.8-3.6,2.9-6.7,3.9-7.5l7.2,6.7c-1,1.9-1.8,3.7-1.7,4.9c0,0.5,0.3,1.1,0.6,1.8c0.2,0.4,0.5,0.9,0.8,1.4\r\n\t\t\t\tc0.1,0.3,0.3,0.5,0.4,0.8c0.8,1.4,1.5,3,1.5,4.3c0,1.8,0.2,11.2,0.4,18.1l0,0c0.1,4.3,0.1,7.8,0.1,7.8l2.7,11.5h-0.3l0,0h-15.5\r\n\t\t\t\tC796.3,258.8,796.5,230.7,796.6,226.8L796.6,226.8z M811.1,255.2c1.5,1.3,2.7,2.6,2.6,2.9c-0.3,0.6-1,1.4-1.5,2L811.1,255.2\r\n\t\t\t\tL811.1,255.2z M818,259.3c-0.6,0.9-3.2,2.5-4.3,3.1h-1l-0.3-1.3c0.4-0.4,1.5-1.7,1.9-2.5c0.2-0.4,0.1-1.6-3.6-4.4l-0.8-3.2\r\n\t\t\t\tc0-0.4,0-3-0.1-6.4c2,3.5,6.8,12,7.6,12.8C818.5,258.1,818.7,258.4,818,259.3L818,259.3z\"/>\r\n\t\t\t<g id=\"stars_00000007414291848918002390000009742619794377438398_\">\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M780.4,210.2L780.4,210.2c-0.6-0.1-1.3,0.1-1.6,0.7l0,0\r\n\t\t\t\t\tc0-0.6-0.5-1.2-1.1-1.3l0,0c0.6-0.2,1-0.9,0.9-1.5l0,0c0.4,0.5,1.1,0.7,1.7,0.4l0,0C780,209,780,209.7,780.4,210.2L780.4,210.2\r\n\t\t\t\t\tL780.4,210.2z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M765.4,217.8L765.4,217.8c-0.6-0.1-1.3,0.1-1.6,0.7l0,0\r\n\t\t\t\t\tc0-0.6-0.5-1.2-1.1-1.3l0,0c0.6-0.2,1-0.9,0.9-1.5l0,0c0.4,0.5,1.1,0.7,1.7,0.4l0,0C764.9,216.6,765,217.3,765.4,217.8\r\n\t\t\t\t\tL765.4,217.8L765.4,217.8z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M767.4,204.7L767.4,204.7c-0.6-0.1-1.3,0.1-1.6,0.7l0,0\r\n\t\t\t\t\tc0-0.6-0.5-1.2-1.1-1.3l0,0c0.6-0.2,1-0.9,0.9-1.5l0,0c0.4,0.5,1.1,0.7,1.7,0.4l0,0C766.9,203.5,766.9,204.2,767.4,204.7\r\n\t\t\t\t\tL767.4,204.7L767.4,204.7z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M798.8,220.8L798.8,220.8c-0.5,0.4-0.6,1.1-0.4,1.7l0,0\r\n\t\t\t\t\tc-0.5-0.3-1.3-0.3-1.8,0.1l0,0c0.1-0.6-0.1-1.3-0.7-1.6l0,0c0.6,0,1.2-0.5,1.3-1.2l0,0C797.5,220.5,798.2,220.9,798.8,220.8\r\n\t\t\t\t\tL798.8,220.8L798.8,220.8z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M792.9,205.7L792.9,205.7c-0.6-0.1-1.3,0.2-1.6,0.8l0,0\r\n\t\t\t\t\tc-0.1-0.6-0.6-1.1-1.3-1.3l0,0c0.6-0.3,0.9-0.9,0.8-1.6l0,0c0.4,0.4,1.2,0.6,1.8,0.3l0,0C792.3,204.5,792.4,205.3,792.9,205.7\r\n\t\t\t\t\tL792.9,205.7L792.9,205.7z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M787.5,235.1L787.5,235.1c-0.6-0.1-1.3,0.2-1.6,0.8l0,0\r\n\t\t\t\t\tc-0.1-0.6-0.6-1.1-1.3-1.3l0,0c0.6-0.3,0.9-0.9,0.8-1.6l0,0c0.4,0.4,1.2,0.6,1.8,0.3l0,0C787,233.9,787,234.6,787.5,235.1\r\n\t\t\t\t\tL787.5,235.1L787.5,235.1z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M819.3,232.1L819.3,232.1c-0.6-0.1-1.3,0.2-1.6,0.8l0,0\r\n\t\t\t\t\tc-0.1-0.6-0.6-1.1-1.3-1.3l0,0c0.6-0.3,0.9-0.9,0.8-1.6l0,0c0.4,0.4,1.2,0.6,1.8,0.3l0,0C818.8,231,818.9,231.6,819.3,232.1\r\n\t\t\t\t\tL819.3,232.1L819.3,232.1z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M774.5,229.8L774.5,229.8c-0.6-0.1-1.3,0.2-1.6,0.8l0,0\r\n\t\t\t\t\tc-0.1-0.6-0.6-1.1-1.3-1.3l0,0c0.6-0.3,0.9-0.9,0.8-1.6l0,0c0.4,0.4,1.2,0.6,1.8,0.3l0,0C773.9,228.7,774,229.4,774.5,229.8\r\n\t\t\t\t\tL774.5,229.8L774.5,229.8z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M755.4,214.3L755.4,214.3c-0.6-0.1-1.3,0.2-1.6,0.8l0,0\r\n\t\t\t\t\tc-0.1-0.6-0.6-1.1-1.3-1.3l0,0c0.6-0.3,0.9-0.9,0.8-1.6l0,0c0.4,0.4,1.2,0.6,1.8,0.3l0,0C754.8,213.1,754.9,213.8,755.4,214.3\r\n\t\t\t\t\tL755.4,214.3L755.4,214.3z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M775.1,205.4L775.1,205.4c-0.6-0.1-1.3,0.2-1.6,0.8l0,0\r\n\t\t\t\t\tc-0.1-0.6-0.6-1.1-1.3-1.3l0,0c0.6-0.3,0.9-0.9,0.8-1.6l0,0c0.4,0.4,1.2,0.6,1.8,0.3l0,0C774.5,204.2,774.6,204.9,775.1,205.4\r\n\t\t\t\t\tL775.1,205.4L775.1,205.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M805.7,245.9L805.7,245.9c-0.5,0.3-0.9,1-0.7,1.6l0,0\r\n\t\t\t\t\tc-0.5-0.4-1.2-0.5-1.8-0.2l0,0c0.3-0.6,0.1-1.3-0.4-1.7l0,0c0.6,0,1.3-0.3,1.5-0.9l0,0C804.6,245.4,805.1,245.9,805.7,245.9\r\n\t\t\t\t\tL805.7,245.9L805.7,245.9z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M773.9,215.5L773.9,215.5c-0.6,0.2-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.7-0.4l0,0c0.4-0.5,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.6-0.7l0,0C772.8,214.8,773.3,215.3,773.9,215.5\r\n\t\t\t\t\tL773.9,215.5L773.9,215.5z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M811.7,236.9L811.7,236.9c-0.6,0.2-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.7-0.4l0,0c0.4-0.5,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.6-0.7l0,0C810.6,236.2,811.1,236.7,811.7,236.9\r\n\t\t\t\t\tL811.7,236.9L811.7,236.9z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M759.8,224.9L759.8,224.9c-0.6,0.2-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.7-0.4l0,0c0.4-0.5,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.6-0.7l0,0C758.7,224.1,759.2,224.7,759.8,224.9\r\n\t\t\t\t\tL759.8,224.9L759.8,224.9z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M829.1,230.3L829.1,230.3c-0.6,0.2-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.7-0.4l0,0c0.4-0.5,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.6-0.7l0,0C828,229.6,828.5,230.1,829.1,230.3\r\n\t\t\t\t\tL829.1,230.3L829.1,230.3z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M798,253.9L798,253.9c-0.6,0.2-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.7-0.4l0,0c0.4-0.5,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.6-0.7l0,0C796.9,253.1,797.3,253.7,798,253.9\r\n\t\t\t\t\tL798,253.9L798,253.9z\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"804.2,246.5 786,234.8 773.2,229.4 773.1,229.4 \r\n\t\t\t\t\t763.7,216.8 772.5,215.4 779.3,209.3 791.7,204.7 791.8,205.1 779.5,209.6 772.6,215.7 772.6,215.7 764.3,217.1 773.4,229.1 \r\n\t\t\t\t\t786.1,234.5 804.4,246.3 \t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"785.7,234.4 786,234.2 796.8,253.9 796.5,254.1 \t\t\t\t\r\n\t\t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"758.2,225 763.9,217.2 764.2,217.4 758.5,225.2 \t\t\t\t\r\n\t\t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"753.9,213.6 754,213.3 764.1,216.8 764,217.1 \t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"809.8,237 796.7,220.7 818.1,231.3 827.7,230.2 \r\n\t\t\t\t\t827.7,230.6 818.1,231.7 818,231.6 798,221.7 810.1,236.8 \t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"797.2,221.4 779.3,209.6 773.6,204.9 765.8,204.1 \r\n\t\t\t\t\t765.8,203.8 773.8,204.6 779.5,209.3 797.4,221 \t\t\t\t\"/>\r\n\t\t\t</g>\r\n\t\t</g>\r\n\t\t<g id=\"CANCER\">\r\n\t\t\t<path fill=\"#FF4C53\" d=\"M820.8,474.4c-1.5-0.7-4.3-0.5-6.5-0.4c-0.9,0.1-2,0.1-2.4,0.1c-0.7-0.7-3.1-2.4-5.9-3.3\r\n\t\t\t\tc-0.6-0.2-1.2-0.4-1.9-0.5c3.8-0.7,7.9-1,8-1c0.3,0,0.5-0.2,0.5-0.5c0-0.3-0.1-0.5-0.4-0.6c-1.9-0.6-3.5-1.3-5.2-2.2\r\n\t\t\t\tc2.3-0.2,4.6-0.4,5.3-0.4c2.6-0.2,4.5-1.7,7.6-4.5c3.2-2.8,4-7.8,4-8.1c0-0.1,0-0.1,0-0.2c-1.7-6.6-7.2-8.1-7.4-8.1\r\n\t\t\t\tc-0.3-0.1-0.5,0.1-0.6,0.3c-0.1,0.2,0,0.5,0.2,0.7c0.8,0.5,3.3,3.5,3.6,5.8c0.1,0.7,0,1.1-0.3,1.5c-1.5,1.9-2.7,5-3,6\r\n\t\t\t\tc-2.1,0.3-5.9,2.4-6.6,2.7c-3.3,0-6.2,0.5-8,0.9c-0.4-0.3-0.9-0.7-1.2-0.9c1.5-0.2,3.5-0.4,4.8-0.5c1.2-0.1,2.4-0.2,3-0.3\r\n\t\t\t\tc2-0.3,3.3-1.6,4.7-3c0.4-0.4,0.9-0.9,1.2-1.2c1.4-1.3,1.3-2.1,1.2-4.3c-0.1-1.3-0.2-3.3-0.1-6.4c0.3-8.5-4.7-9.2-5-9.2\r\n\t\t\t\tc-0.2,0-0.5,0.1-0.6,0.3s0,0.5,0.2,0.6c0,0,2,1.5,1.7,4c-0.2,1.3-0.2,4.1-0.2,6.8c0,2.2,0,4.8-0.1,5.5c-0.7,0.4-2.1,1.5-4.4,3.3\r\n\t\t\t\tc-0.9-0.1-3.5-0.5-5.8-0.1c-1.6,0.3-3.1,1.1-4.1,1.9l-0.5-0.4c-0.2-0.1-0.4-0.3-0.6-0.4c6.2-2.1,13.4-8.1,13.7-8.3\r\n\t\t\t\tc0.1-0.1,0.1-0.1,0.2-0.2c0.8-1.7,0.5-7.5,0.4-8.1c0-0.1,0-0.2-0.1-0.3c-6.5-8.6-12.9-13.2-18.9-13.7c-5-0.5-7.9,2.2-8,2.3\r\n\t\t\t\tc-0.2,0.2-0.2,0.4-0.1,0.6s0.3,0.3,0.6,0.3c4.9-0.6,8.1,0.8,9.9,1.9c1.3,0.9,2.2,1.8,2.6,2.3c-5,2.7-13.4-2.5-13.5-2.5\r\n\t\t\t\tc-0.2-0.1-0.5-0.1-0.7,0.1c-0.2,0.2-0.2,0.5-0.1,0.7c5.9,9.2,18,12.2,21.5,13c-0.9,0.9-1.3,2.2-1.5,2.7c-4.4,1-8.5,5.3-10.4,7.5\r\n\t\t\t\tc-5.5-1.6-13-1.6-18.7-0.2c-2.4-2.2-7.1-6.2-10.8-7.2c-0.1-0.5-0.2-1.4-0.9-2.5c3.8,0,16.7-0.4,21.4-7c0.1-0.2,0.1-0.4,0-0.6\r\n\t\t\t\ts-0.4-0.3-0.6-0.2c-0.1,0-8.5,2.7-12.9-0.8c1.4-1,6-4,12.3-1.6c0.2,0.1,0.5,0,0.6-0.1c0.1-0.2,0.2-0.4,0.1-0.6\r\n\t\t\t\tc-0.1-0.1-1.9-3.3-6.4-4.1c-5.8-1-13.1,2.3-21.7,9.8c-0.1,0.1-0.1,0.2-0.2,0.3c0,0.2-1,4.9,0,7.8c0,0.1,0.1,0.1,0.1,0.2\r\n\t\t\t\tc0.2,0.3,5.4,6.4,13.6,8.8c-0.1,0.1-0.2,0.1-0.3,0.2l-0.5,0.4c-0.9-0.7-2.5-1.6-4.1-1.9c-2.3-0.4-5-0.1-5.8,0.1\r\n\t\t\t\tc-2.3-1.9-3.7-3-4.4-3.3c-0.1-0.7-0.1-3.3-0.1-5.5c0-2.7,0-5.5-0.2-6.8c-0.4-2.4,1.6-3.9,1.7-4c0.2-0.1,0.3-0.4,0.2-0.6\r\n\t\t\t\tc-0.1-0.2-0.3-0.4-0.6-0.3c-0.2,0-5.3,0.7-5,9.2c0.1,3.1,0,5.1-0.1,6.4c-0.2,2.2-0.2,2.9,1.2,4.3c0.5,0.4,0.9,0.9,1.2,1.2\r\n\t\t\t\tc1.4,1.4,2.7,2.8,4.7,3c0.7,0.1,1.8,0.2,3,0.3c1.3,0.1,3.3,0.2,4.8,0.4c-0.5,0.3-0.9,0.7-1.3,0.9c-1.8-0.5-4.6-0.9-8-0.9\r\n\t\t\t\tc-0.8-0.4-4.5-2.5-6.6-2.7c-0.4-1-1.5-4.1-3-6c-0.3-0.4-0.4-0.9-0.3-1.5c0.4-2.3,2.9-5.3,3.6-5.8c0.2-0.1,0.3-0.4,0.2-0.7\r\n\t\t\t\ts-0.4-0.4-0.6-0.3s-5.7,1.5-7.4,8.1c0,0.1,0,0.1,0,0.2c0,0.2,0.8,5.2,4,8.1c3.1,2.7,5,4.3,7.6,4.5c0.8,0.1,3.1,0.2,5.3,0.4\r\n\t\t\t\tc-1.6,0.9-3.3,1.6-5.2,2.2c-0.2,0.1-0.4,0.3-0.4,0.6s0.2,0.5,0.5,0.5c0.1,0,4.2,0.4,8,1c-0.8,0.1-1.4,0.3-1.9,0.5\r\n\t\t\t\tc-2.7,0.9-5.2,2.7-5.9,3.3c-0.3,0.1-1.4,0-2.4-0.1c-2.3-0.2-5-0.4-6.5,0.4c-2.6,1.2-3.6,5.1-3.6,6.3c0,0.2,0.1,0.4,0.3,0.5\r\n\t\t\t\tc0.1,0,0.1,0,0.2,0s0.3-0.1,0.4-0.1c1.1-1.1,3.3-2.9,4.3-3.1c0.4-0.1,1.1,0.1,2,0.4c1.9,0.5,4.4,1.1,6.9,0.2\r\n\t\t\t\tc2.9-1.1,4.6-2.7,5.7-3.7c0.2-0.2,0.5-0.4,0.6-0.6c0.3-0.2,1.7-0.1,2.8,0c2,0.2,4.4,0.3,6.2-0.3c0.1,0.1,0.2,0.1,0.3,0.2\r\n\t\t\t\tc-1.9,0.3-4.1,0.6-5,0.9c-1.8,0.7-5.2,3.8-5.2,6.8c0,2.5,0,6.9,4.7,8.4c0.6,0.2,0.9,0.2,1.3,0.2c1.1,0,1.7-0.7,2-1\r\n\t\t\t\tc0.9-1.6-0.1-4.6-2.2-6.6c0.3-0.7,0.7-2.1,0.8-3.9c1.7,0,6.7-0.1,9.3-2.3c1.9,0.6,4.1,0.9,6.5,0.9c0,0,0,0,0.1,0h0.1\r\n\t\t\t\tc0,0,0,0,0.1,0c2.6,0,4.7-0.4,6.6-0.9c2.6,2.2,7.7,2.4,9.3,2.3c0,1.8,0.5,3.2,0.8,3.9c-2.1,2-3.1,5-2.2,6.6c0.3,0.5,0.9,1,2,1\r\n\t\t\t\tc0.4,0,0.9-0.1,1.3-0.2c4.7-1.5,4.7-6,4.7-8.4c0-3.1-3.4-6.2-5.2-6.8c-0.9-0.4-3.1-0.7-5.1-0.9c0.1-0.1,0.2-0.1,0.3-0.2\r\n\t\t\t\tc1.8,0.6,4.2,0.5,6.2,0.3c1-0.1,2.6-0.2,2.8,0c0.2,0.1,0.4,0.3,0.6,0.6c1,0.9,2.7,2.6,5.7,3.7c2.5,0.9,5,0.3,6.9-0.2\r\n\t\t\t\tc0.9-0.2,1.6-0.4,2-0.4c0.9,0.1,3.1,2,4.3,3.1c0.1,0.1,0.2,0.1,0.4,0.1c0.1,0,0.1,0,0.2,0c0.2-0.1,0.3-0.3,0.3-0.5\r\n\t\t\t\tC824.4,479.5,823.4,475.7,820.8,474.4L820.8,474.4z M819.4,477.1c-0.6-0.1-1.4,0.1-2.4,0.4c-1.7,0.5-4.1,1-6.3,0.2\r\n\t\t\t\tc-2.7-1-4.4-2.6-5.4-3.5c-0.3-0.2-0.5-0.4-0.7-0.6c-0.6-0.5-1.6-0.4-3.6-0.3c-1.5,0.1-3.4,0.3-4.9,0c-0.5-0.1-0.9-0.2-1.3-0.4\r\n\t\t\t\tc-0.1-0.1-0.3-0.1-0.4-0.2c-0.3-0.2-0.6-0.1-0.8,0.2c-0.1,0.2-0.1,0.5,0.1,0.7c-0.3,0.2-0.6,0.3-0.9,0.5\r\n\t\t\t\tc-0.9-0.1-1.5-0.2-1.6-0.2c-0.3,0-0.6,0.2-0.6,0.5c0,0.3,0.2,0.5,0.4,0.6h0.1c0,0,0.8,0.1,1.9,0.2c2.1,0.2,5.2,0.7,6.3,1\r\n\t\t\t\tc1.6,0.7,4.5,3.4,4.5,5.9c0,3.1-0.3,6.3-4.1,7.4c-0.8,0.3-1.7,0.4-2.2-0.4c-0.7-1.1,0.2-3.9,2.2-5.7c0.2-0.2,0.2-0.4,0.1-0.6\r\n\t\t\t\tc0,0-0.9-1.9-0.8-4.3c0-0.1-0.1-0.3-0.2-0.4c-0.1-0.1-0.3-0.2-0.4-0.2c-0.1,0-5.7,0.3-8.6-1.7c-0.4-0.2-0.7-0.5-0.9-0.8l-0.1-0.1\r\n\t\t\t\tc-0.2-0.2-0.5-0.3-0.8-0.1c-0.2,0.1-0.2,0.3-0.2,0.5c-1.7,0.5-3.7,0.8-6,0.8c0,0,0,0-0.1,0c0,0,0,0-0.1,0c-2.3,0-4.2-0.3-5.9-0.8\r\n\t\t\t\tc0-0.2,0-0.4-0.2-0.5c-0.2-0.2-0.6-0.2-0.8,0.1c0,0.1-0.1,0.1-0.1,0.2c-0.3,0.3-0.6,0.6-0.9,0.8c-2.9,1.9-8.5,1.6-8.6,1.6\r\n\t\t\t\ts-0.3,0.1-0.4,0.2c-0.1,0.1-0.2,0.3-0.2,0.4c0.1,2.4-0.8,4.3-0.8,4.3c-0.1,0.2,0,0.5,0.1,0.6c2.1,1.8,2.8,4.5,2.2,5.7\r\n\t\t\t\tc-0.4,0.8-1.4,0.6-2.2,0.4c-3.7-1.1-4.1-4.3-4.1-7.4c0-2.6,2.9-5.3,4.5-5.9c1-0.4,4.1-0.9,6.2-1c1.1-0.1,1.9-0.2,2-0.2l0,0\r\n\t\t\t\tc0.3,0,0.5-0.3,0.5-0.6c0-0.3-0.3-0.5-0.6-0.5c-0.1,0-0.8,0.1-1.7,0.2c-0.3-0.2-0.6-0.4-0.9-0.5c0.2-0.2,0.3-0.5,0.1-0.7\r\n\t\t\t\tc-0.2-0.3-0.5-0.3-0.8-0.2c-0.1,0.1-0.3,0.1-0.4,0.2c-0.4,0.2-0.9,0.3-1.3,0.4c-1.5,0.3-3.4,0.1-4.9,0c-2-0.1-3-0.2-3.6,0.3\r\n\t\t\t\tc-0.2,0.2-0.4,0.4-0.7,0.6c-1,0.9-2.7,2.4-5.4,3.5c-2.2,0.9-4.5,0.2-6.3-0.2c-1-0.3-1.8-0.5-2.4-0.4c-1,0.2-2.7,1.4-3.8,2.4\r\n\t\t\t\tc0.4-1.4,1.3-3.4,2.7-4.1c1.2-0.6,4-0.4,6.1-0.3c2.1,0.1,2.7,0.2,3.1-0.2c0.4-0.4,2.7-2.1,5.5-3c1.1-0.4,3-0.7,4.7-0.8\r\n\t\t\t\tc0.9-0.1,1.9-0.1,2.7-0.2c1.3-0.1,2.3-0.1,2.3-0.1c0.3,0,0.5-0.2,0.5-0.5c0-0.3-0.2-0.5-0.5-0.5l0,0c-0.2,0-2.5,0-4.9,0.2\r\n\t\t\t\tc-2.7-0.7-6.4-1.1-8.8-1.4c1.5-0.6,2.9-1.3,4.5-2.3c1,0.1,1.9,0.2,2.5,0.3h0.1c0.3,0,0.5-0.2,0.5-0.5c0.1-0.3-0.1-0.6-0.4-0.6\r\n\t\t\t\tc-0.3-0.1-0.8-0.1-1.2-0.2c-0.5-0.1-1-0.1-1.6-0.2c-2.5-0.2-5.6-0.5-6.7-0.6c-2.2-0.2-4-1.6-7-4.3c-2.7-2.4-3.5-6.6-3.7-7.3\r\n\t\t\t\tc0.9-3.3,2.7-5.2,4.4-6.3c-0.9,1.3-2,3-2.2,4.5c-0.2,0.9,0,1.7,0.5,2.3c1.7,2.1,2.9,6,3,6c0.1,0.2,0.3,0.4,0.5,0.4\r\n\t\t\t\tc1.6,0.1,5.3,2,6.6,2.7c0.1,0,0.2,0.1,0.3,0.1c2.7,0,5.2,0.3,6.9,0.7c0.5,0.1,0.9,0.2,1.3,0.3c0.9,0.2,1.4,0.4,1.4,0.4\r\n\t\t\t\tc0.3,0.1,0.6-0.1,0.7-0.3c0.1-0.3-0.1-0.6-0.3-0.7c0,0-0.3-0.1-0.7-0.2c0.5-0.4,0.9-0.7,1.4-1c0.3,0.1,0.5,0.1,0.6,0.2\r\n\t\t\t\tc0.1,0.1,0.3,0.2,0.4,0.2c0.1,0,0.2,0,0.3-0.1c0.2-0.2,0.3-0.5,0.1-0.7c-0.1-0.1-0.2-0.2-0.4-0.3c-0.3-0.1-0.7-0.3-1.2-0.4\r\n\t\t\t\tc-1.1-0.2-3-0.4-5.9-0.6c-1.2-0.1-2.3-0.2-2.9-0.3c-1.6-0.2-2.7-1.4-4.1-2.7c-0.4-0.4-0.9-0.9-1.3-1.2c-1-0.9-1-1.3-0.9-3.4\r\n\t\t\t\tc0.1-1.3,0.2-3.3,0.1-6.5c-0.1-4.1,1-6.2,2.2-7.2c-0.4,0.8-0.7,1.8-0.6,3c0.2,1.2,0.2,4.1,0.2,6.6c0,6.1,0.1,6.3,0.7,6.4\r\n\t\t\t\tc0.4,0.2,2.6,1.8,4.4,3.4c0.1,0.1,0.3,0.1,0.4,0.1c0,0,3.2-0.5,5.7-0.1c1.3,0.2,2.6,0.9,3.4,1.5c0.4,0.3,0.7,0.5,0.9,0.7\r\n\t\t\t\tc0.2,0.2,0.3,0.3,0.4,0.3c0.2,0.2,0.6,0.2,0.8,0c0.2-0.2,0.2-0.6,0-0.8c0,0-0.1-0.1-0.2-0.2l0.3-0.2c0.3-0.3,0.7-0.5,1-0.7\r\n\t\t\t\tc0.3,0.1,0.5,0.1,0.8,0.2h0.1c0.3,0,0.5-0.2,0.5-0.4c0-0.1,0-0.3-0.1-0.4s-0.2-0.2-0.3-0.2c-0.4-0.1-0.8-0.2-1-0.3\r\n\t\t\t\tc-8-2-13.4-8-14-8.7c-0.8-2.4-0.1-6.2,0.1-7c10.3-8.9,17-10,20.7-9.4c2.3,0.4,3.8,1.5,4.7,2.4c-7.2-1.8-12.1,2.7-12.1,2.7\r\n\t\t\t\tc-0.1,0.1-0.2,0.2-0.2,0.4s0.1,0.3,0.2,0.4c3.5,3.3,9.8,2.5,12.7,1.8c-6,6-20.4,5.4-20.6,5.4c-0.2,0-0.4,0.1-0.5,0.3\r\n\t\t\t\tc-0.1,0.2-0.1,0.4,0.1,0.6c1.2,1.5,1.2,3,1.2,3c0,0.3,0.2,0.5,0.4,0.5c3.3,0.8,7.8,4.4,10.2,6.6c0.4,0.3,0.7,0.6,0.9,0.9\r\n\t\t\t\tc0.4-0.1,0.8-0.2,1.1-0.3c5.2-1.2,11.9-1.1,17.1,0.2c0.4,0.1,0.8,0.2,1,0.3c0.2-0.3,0.5-0.5,0.8-0.9c2-2.3,6-6.1,9.9-6.9\r\n\t\t\t\tc0.2,0,0.4-0.2,0.4-0.4c0,0,0.7-2.1,2.1-3.2c0.2-0.1,0.2-0.3,0.2-0.6c-0.1-0.2-0.2-0.4-0.4-0.4c-0.1,0-13.4-2.2-20.5-10.8\r\n\t\t\t\tc3,1.5,9,3.8,13,1c0.2-0.2,0.3-0.5,0.2-0.7c-0.1-0.3-3.3-5.5-11.8-5.3c1.2-0.6,3.1-1.1,5.6-0.9c5.7,0.5,11.9,5,18.2,13.2\r\n\t\t\t\tc0.1,1.8,0.2,6.1-0.3,7.4c-0.9,0.8-8.5,6.7-14.2,8.3c-0.6,0.2-1.1,0.3-1.7,0.4c0,0,0,0-0.1,0c-0.3,0.1-0.4,0.3-0.4,0.6\r\n\t\t\t\ts0.3,0.5,0.5,0.5c0,0,0,0,0.1,0c0.5-0.1,0.9-0.2,1.4-0.3c0.5,0.3,0.9,0.6,1.3,0.9l0.3,0.2c-0.1,0.1-0.2,0.2-0.2,0.2\r\n\t\t\t\tc-0.2,0.2-0.2,0.5,0,0.8c0.2,0.2,0.6,0.2,0.8,0c0,0,0.1-0.1,0.4-0.3c0.2-0.2,0.5-0.4,0.9-0.7c0.9-0.6,2.1-1.3,3.4-1.5\r\n\t\t\t\tc2.5-0.4,5.7,0.1,5.7,0.1c0.1,0,0.3,0,0.4-0.1c1.9-1.5,4-3.2,4.4-3.4c0.7-0.1,0.7-0.4,0.7-6.4c0-2.6,0-5.4,0.2-6.6\r\n\t\t\t\tc0.2-1.1-0.1-2.2-0.5-2.9c1.1,1,2.3,3,2.2,7.1c-0.1,3.1,0,5.2,0.1,6.5c0.2,2.2,0.2,2.5-0.9,3.4c-0.5,0.4-0.9,0.9-1.3,1.2\r\n\t\t\t\tc-1.3,1.4-2.6,2.6-4.1,2.7c-0.7,0.1-1.7,0.2-2.9,0.3c-2.8,0.2-4.7,0.4-5.9,0.6c-0.6,0.1-0.9,0.2-1.2,0.4\r\n\t\t\t\tc-0.2,0.1-0.3,0.2-0.4,0.3c-0.2,0.2-0.1,0.6,0.1,0.8c0.1,0.1,0.2,0.1,0.3,0.1c0.2,0,0.3-0.1,0.4-0.2s0.3-0.2,0.6-0.2\r\n\t\t\t\tc0.5,0.4,0.9,0.7,1.4,1c-0.4,0.1-0.7,0.2-0.7,0.2c-0.3,0.1-0.4,0.4-0.3,0.7c0.1,0.3,0.4,0.4,0.7,0.3c0,0,0.6-0.2,1.4-0.4\r\n\t\t\t\tc0.4-0.1,0.9-0.2,1.3-0.3c1.8-0.4,4.3-0.8,6.9-0.7c0.1,0,0.2,0,0.3-0.1c1.3-0.8,5-2.7,6.6-2.7c0.2,0,0.4-0.2,0.5-0.4\r\n\t\t\t\tc0,0,1.2-3.9,3-6c0.5-0.6,0.7-1.3,0.5-2.3c-0.2-1.4-1.2-3.1-2.2-4.5c1.5,1,3.4,2.8,4.4,6.2c-0.1,0.7-0.9,4.9-3.7,7.3\r\n\t\t\t\tc-2.9,2.6-4.7,4.1-7,4.3c-1.2,0.1-4.4,0.3-6.7,0.6c-0.6,0.1-1.1,0.1-1.6,0.2c-0.5,0.1-0.9,0.1-1.2,0.2c-0.3,0.1-0.5,0.3-0.4,0.6\r\n\t\t\t\tc0,0.3,0.3,0.5,0.5,0.5h0.1c0.5-0.1,1.4-0.2,2.5-0.3c1.4,0.9,2.8,1.6,4.5,2.3c-2.4,0.3-6.2,0.8-8.8,1.4c-2.5-0.2-4.7-0.2-4.9-0.2\r\n\t\t\t\tl0,0c-0.3,0-0.5,0.2-0.5,0.5c0,0.3,0.2,0.5,0.5,0.5c0,0,0.9,0,2.3,0.1c0.8,0,1.7,0.1,2.7,0.2c1.8,0.2,3.6,0.4,4.7,0.8\r\n\t\t\t\tc2.8,1,5.1,2.7,5.5,3c0.3,0.4,1,0.4,3.1,0.2c2-0.1,4.7-0.3,6.1,0.3c1.4,0.7,2.4,2.7,2.7,4.1c-1.1-0.9-2.7-2.3-3.8-2.4\r\n\t\t\t\tL819.4,477.1z\"/>\r\n\t\t\t<g id=\"stars_00000162334972743372162270000000241223181152984202_\">\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M779.4,465.8L779.4,465.8c-0.9,0.3-1.4,1-1.4,1.9l0,0\r\n\t\t\t\t\tc-0.6-0.8-1.4-1-2.3-0.8l0,0c0.6-0.8,0.6-1.7,0-2.4l0,0c0.9,0.3,1.8,0,2.3-0.8l0,0C778,464.8,778.6,465.5,779.4,465.8\r\n\t\t\t\t\tL779.4,465.8L779.4,465.8z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M812.3,476L812.3,476c-0.9,0.4-1.3,1.1-1.2,2.1l0,0\r\n\t\t\t\t\tc-0.6-0.7-1.5-0.9-2.4-0.6l0,0c0.5-0.8,0.4-1.7-0.2-2.4l0,0c0.9,0.2,1.8-0.2,2.2-0.9l0,0C810.9,475.1,811.4,475.8,812.3,476\r\n\t\t\t\t\tL812.3,476z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M777.5,486L777.5,486c-0.9,0.4-1.3,1.1-1.2,2.1l0,0\r\n\t\t\t\t\tc-0.6-0.7-1.5-0.9-2.4-0.6l0,0c0.5-0.8,0.4-1.7-0.2-2.4l0,0c0.9,0.2,1.8-0.2,2.2-0.9l0,0C776,485,776.7,485.7,777.5,486\r\n\t\t\t\t\tL777.5,486z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M772,452.4L772,452.4c-0.9,0.4-1.3,1.1-1.2,2.1l0,0\r\n\t\t\t\t\tc-0.6-0.7-1.5-0.9-2.4-0.6l0,0c0.5-0.8,0.4-1.7-0.2-2.4l0,0c0.9,0.2,1.8-0.2,2.2-0.9l0,0C770.5,451.6,771.2,452.3,772,452.4\r\n\t\t\t\t\tL772,452.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M755.8,431.3L755.8,431.3c-0.6,0.8-0.5,1.7,0,2.4l0,0\r\n\t\t\t\t\tc-0.9-0.3-1.8,0-2.3,0.8l0,0c0-0.9-0.6-1.7-1.4-1.9l0,0c0.9-0.3,1.4-1,1.4-2l0,0C754.1,431.3,755.1,431.6,755.8,431.3\r\n\t\t\t\t\tL755.8,431.3L755.8,431.3z\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"775.7,486.4 775.2,486.3 777,465.7 769.5,453 \r\n\t\t\t\t\t754,432.7 754.4,432.5 769.8,452.7 777.4,465.6 777.4,465.7 \t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"777.1,465.9 777.2,465.4 810.4,476.2 810.2,476.7 \t\t\t\t\r\n\t\t\t\t\t\"/>\r\n\t\t\t</g>\r\n\t\t</g>\r\n\t\t<g id=\"LEO\">\r\n\t\t\t<path fill=\"#F5AE2A\" d=\"M837.1,660.2c-0.1,0-6.5-2.6-10-4.2c-1-0.5-1.4-1-1.9-1.5c-0.7-0.8-1.5-1.6-3.6-2c-0.1,0-0.1-0.1-0.2-0.1\r\n\t\t\t\tl0,0c-1.5-0.3-3.5-0.5-6.6-0.5c-8.6,0-19.5,8.6-26.1,13.8c-2,1.5-3.5,2.8-4.3,3.2c-3.7,2.1-9.2,2.2-17.9,2.2\r\n\t\t\t\tc-3.2,0-5.4,1.4-7,3.3c-0.6,0-7.5-0.4-7.7-4.8c-0.1-1,0.2-1.9,0.9-2.6c2-2.1,6.8-2.2,11.2-2.2c0.5,0,1,0,1.6,0\r\n\t\t\t\tc5.2,0.1,11.6,0.1,16.8-4.7c1.1-0.1,7.7-1,10.6-7c0.1-0.1,0.1-0.3,0-0.4c-0.1-0.1-0.2-0.2-0.3-0.2s-8.4-1.6-12.1,5.8\r\n\t\t\t\tc-0.4,0.4-4.1,3.9-10.4,3.9c-0.9,0-2,0-3.2-0.1c-7.6-0.2-18-0.5-18.4,6.8c-0.4,7.1,6.9,8.7,9.1,9c-1.7,4.1-1.8,8.5-1.8,8.6\r\n\t\t\t\tc0,2.6-2.6,6.2-4.9,7.5c-2.5,1.5-2.1,5-2,5.1v16.5c0,0.2,0.2,0.4,0.4,0.4h12.9c0.2,0,0.4-0.2,0.4-0.4c0-4.8-5.3-6-6.8-6.2\r\n\t\t\t\tc0.1-1.8,0.9-8.8,4.2-9.9c0.8-0.3,1.7-0.6,2.7-1.1c-0.6,1.4-1.5,3.8-0.8,5.2c0.9,2,7.1,11.5,7.3,11.9c0.1,0.1,0.2,0.2,0.4,0.2h11\r\n\t\t\t\tc0.1,0,0.2-0.1,0.3-0.1c0.1-0.1,0.1-0.2,0.1-0.3s-0.3-4.9-6.5-5.2c-0.9-1.7-3-5.8-3-7.3c0-1,2.1-3.2,3.9-5\r\n\t\t\t\tc1.2-1.2,2.4-2.4,3.2-3.4c4.1,0.2,8.4,0.2,11.9,0.1c0.4,1.3,1.8,5.1,4,7.5c0.8,0.9,0.2,2.4-0.2,3.2c-1.6,2.9-5.6,5.9-8.5,5.5\r\n\t\t\t\tc-0.2,0-0.3,0-0.4,0.2c-0.1,0.1-0.1,0.3,0,0.4c0.1,0.1,1.8,3.7,5.4,4c0.2,0,0.3,0,0.5,0c3.6,0,7.7-3.2,12.1-9.4\r\n\t\t\t\tc3.4,5.1,6.8,9.2,7.1,9.5c0.1,0.1,0.2,0.2,0.3,0.2H823c0.2,0,0.4-0.2,0.4-0.4c0-5.4-6.9-6-8.2-6.1c-4-4.8-3.8-14-3.7-15.4\r\n\t\t\t\tc7-6.9,12.5-15.9,13.4-17.4h8.8c0.2,0,0.4-0.2,0.4-0.4V672c0-0.2-0.1-0.3-0.3-0.4c-0.2-0.1-0.4,0-0.5,0.1\r\n\t\t\t\tc-0.4,0.4-1.7,0.6-2.9,0.2c-0.7-0.2-1.9-0.9-1.9-2.5c0-0.6,0.2-1,0.6-1.4c1.2-1.1,3.9-0.9,4.6-0.9l1.1,1.4\r\n\t\t\t\tc0.1,0.1,0.3,0.2,0.4,0.2c0.2,0,0.3-0.2,0.3-0.3l1.8-7.7C837.5,660.4,837.3,660.2,837.1,660.2L837.1,660.2z M810.9,692.9\r\n\t\t\t\tc-0.9-0.4-1.8-0.8-2.7-1.4l15.7-17l0.2,1.2C823.4,676.9,817.9,685.9,810.9,692.9L810.9,692.9z M822.2,664.9l0.4,2.2\r\n\t\t\t\tc-7.4,3.1-19.9,16.3-22,18.6c-1-0.9-2-1.9-3-2.8C799.5,680.9,812.6,667.6,822.2,664.9z M822.7,668l0.4,2.5\r\n\t\t\t\tc-7.4,5.1-17.4,16.1-19.2,18.1c-0.9-0.7-1.8-1.5-2.8-2.3C803.3,684.1,815.6,671.2,822.7,668L822.7,668z M823.4,671.4l0.4,2\r\n\t\t\t\tL807.4,691c-0.9-0.6-1.8-1.2-2.8-1.9C806.5,687,816.2,676.5,823.4,671.4L823.4,671.4z M796.9,682.3c-1.1-1.1-2.2-2.2-3.2-3.2\r\n\t\t\t\tc2.1-2,13.3-12.4,23.8-16.1c0.2,0.2,0.4,0.4,0.6,0.6c0.8,0.6,1.8,0.8,2.7,0.9C811.1,667.8,798.9,680.2,796.9,682.3L796.9,682.3z\r\n\t\t\t\t M790.2,675.2c2.2-1.9,16.2-13.3,26.7-15.3c0,0.1-0.1,0.2-0.1,0.3c-0.1,0.7,0,1.4,0.2,2c-10.6,3.7-21.8,14.2-24,16.2\r\n\t\t\t\tC792.1,677.3,791.1,676.2,790.2,675.2L790.2,675.2z M817.2,658.9c-4.9,0.8-11.1,3.7-18.4,8.7c-4.6,3.1-8.2,6.1-9.2,6.9\r\n\t\t\t\tc-0.8-0.9-1.6-1.8-2.2-2.6c2.5-2.1,21.7-18.3,33.6-16.6v1.2C819.7,656.6,818,657.2,817.2,658.9L817.2,658.9z M789.2,666.4\r\n\t\t\t\tc6.4-5.1,17.2-13.6,25.5-13.6c2.9,0,4.8,0.2,6.2,0.4v1.2c-5.5-0.7-12.9,1.9-22,7.8c-6.1,3.9-10.9,8-12.1,9.1\r\n\t\t\t\tc-0.7-0.8-1.3-1.5-1.6-1.9C786.2,668.8,787.6,667.7,789.2,666.4L789.2,666.4z M753.5,675.7c-3-1.4-4.4-3.7-4.2-6.8\r\n\t\t\t\tc0.4-6.4,10.3-6.1,17.5-5.9c1.2,0,2.2,0.1,3.2,0.1c7.1,0,10.9-4,11.1-4.2l0.1-0.1c2.8-5.8,8.7-5.7,10.5-5.4c-3.1,5.6-9.7,6-9.8,6\r\n\t\t\t\ts-0.2,0.1-0.3,0.1c-5,4.7-11.3,4.7-16.3,4.6c-0.5,0-1.1,0-1.6,0c-4.6,0-9.6,0.2-11.8,2.5c-0.8,0.9-1.2,1.9-1.1,3.2\r\n\t\t\t\tc0.3,4.6,6,5.4,8,5.6c-0.4,0.5-0.7,1.1-1,1.7C757.2,676.9,755.3,676.6,753.5,675.7L753.5,675.7z M774.9,697.2\r\n\t\t\t\tc-2.2,2.2-4.2,4.3-4.2,5.7c0.1,2,3.1,7.7,3.2,7.9c0.1,0.1,0.2,0.2,0.4,0.2c4.6,0.1,5.6,2.8,5.9,3.9h-10.3\r\n\t\t\t\tc-0.9-1.4-6.3-9.9-7.1-11.6c-0.6-1.4,0.7-4.3,1.3-5.5c3.3-1.6,6.9-3.7,7.7-4.1c1.8,0.3,3.8,0.5,5.8,0.6\r\n\t\t\t\tC776.8,695.2,775.8,696.2,774.9,697.2L774.9,697.2z M790.8,714.3c-2.2-0.2-3.7-1.9-4.3-2.8c3.2-0.1,7-3,8.6-6\r\n\t\t\t\tc0.9-1.7,0.9-3.2,0.1-4.2c-1.9-2.1-3.2-5.5-3.7-6.9c2.9-0.1,5.1-0.2,6-0.3c0.9,3.3,3.1,7.3,5.4,10.9\r\n\t\t\t\tC798.4,711.3,794.2,714.6,790.8,714.3L790.8,714.3z M814.6,709.7c0.1,0.1,0.2,0.1,0.3,0.1c0,0,2,0,3.9,0.7\r\n\t\t\t\tc2.3,0.8,3.5,2.2,3.7,4.1H811c-1.3-1.5-11.1-13.6-12.8-21.1c-0.1-0.2-0.3-0.4-0.5-0.3c-0.1,0-2.8,0.2-6.7,0.3\r\n\t\t\t\tc-0.1-0.1-0.3-0.1-0.4-0.1c-0.1,0-0.1,0.1-0.2,0.1c-5.6,0.2-13.2,0.2-18.8-0.8c-0.1,0-0.2,0-0.3,0.1c-0.1,0-7.9,4.6-11.7,5.8\r\n\t\t\t\tc-4.2,1.4-4.9,10-4.9,11.2c0,0.2,0.2,0.4,0.4,0.4c0.3,0,6,0.5,6.4,4.9h-12V699c0,0-0.4-3.1,1.6-4.3c2.5-1.5,5.3-5.3,5.3-8.3\r\n\t\t\t\tc0-0.1,0.1-14.4,9.8-14.4c8.5,0,14.1-0.2,17.9-2.2c0.9,1.1,4.1,5,8.2,9.4c0,0,0,0.1,0.1,0.1c0,0,0,0,0.1,0\r\n\t\t\t\tc5.3,5.6,12.2,12,17.7,14.3C810.5,695.5,810.3,704.8,814.6,709.7L814.6,709.7z M835,667.3l-0.6-0.8c-0.1-0.1-0.2-0.2-0.3-0.2\r\n\t\t\t\ts-3.8-0.5-5.5,1.1c-0.6,0.5-0.9,1.2-0.9,2c0,1.6,0.9,2.8,2.5,3.3c1.1,0.4,2.2,0.4,3.1,0.1v2.6H825l-2.1-11.7\r\n\t\t\t\tc0-0.1-0.1-0.3-0.2-0.3c-0.1-0.1-0.3-0.1-0.4,0c-0.8,0.4-2.5,0.3-3.6-0.5c-0.8-0.6-1.1-1.4-1-2.5c0.4-3,3.5-2.9,3.6-2.9\r\n\t\t\t\ts0.2,0,0.3-0.1s0.1-0.2,0.1-0.3v-3.6c1.6,0.4,2.2,1,2.8,1.7c0.5,0.5,1.1,1.1,2.2,1.7c3,1.4,8.3,3.6,9.7,4.1L835,667.3L835,667.3z\r\n\t\t\t\t\"/>\r\n\t\t\t<g id=\"stars_00000129194645885514298710000016501387975659809452_\">\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M800.1,668.7L800.1,668.7c-0.7,0.2-1.2,0.9-1.2,1.7l0,0\r\n\t\t\t\t\tc-0.4-0.6-1.2-0.9-2-0.6l0,0c0.4-0.6,0.4-1.4,0-2.1l0,0c0.7,0.2,1.5,0,2-0.6l0,0C798.8,667.8,799.3,668.5,800.1,668.7\r\n\t\t\t\t\tL800.1,668.7L800.1,668.7z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M821.1,665.4L821.1,665.4c-0.7,0.2-1.2,0.9-1.2,1.7l0,0\r\n\t\t\t\t\tc-0.4-0.6-1.2-0.9-2-0.6l0,0c0.4-0.6,0.4-1.4,0-2.1l0,0c0.7,0.2,1.5,0,2-0.6l0,0C819.8,664.5,820.3,665.1,821.1,665.4\r\n\t\t\t\t\tL821.1,665.4L821.1,665.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M815.3,698.6L815.3,698.6c-0.7,0.2-1.2,0.9-1.2,1.7l0,0\r\n\t\t\t\t\tc-0.4-0.6-1.2-0.9-2-0.6l0,0c0.4-0.6,0.4-1.4,0-2.1l0,0c0.7,0.2,1.5,0,2-0.6l0,0C814.1,697.7,814.5,698.4,815.3,698.6\r\n\t\t\t\t\tL815.3,698.6L815.3,698.6z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M812.2,658.4L812.2,658.4c-0.7,0.3-1.1,1-1.1,1.8l0,0\r\n\t\t\t\t\tc-0.5-0.6-1.3-0.8-2-0.5l0,0c0.4-0.6,0.3-1.5-0.2-2l0,0l0,0c0.7,0.2,1.5-0.1,1.9-0.8l0,0C810.9,657.6,811.5,658.2,812.2,658.4\r\n\t\t\t\t\tL812.2,658.4L812.2,658.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M772.1,682.1L772.1,682.1c-0.7,0.3-1.1,1-1.1,1.8l0,0\r\n\t\t\t\t\tc-0.5-0.6-1.3-0.8-2-0.5l0,0c0.4-0.6,0.3-1.5-0.2-2l0,0c0.7,0.2,1.5-0.1,1.9-0.8l0,0C770.9,681.3,771.4,682,772.1,682.1\r\n\t\t\t\t\tL772.1,682.1L772.1,682.1z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M751.7,700.6L751.7,700.6c-0.7,0.3-1.1,1-1.1,1.8l0,0\r\n\t\t\t\t\tc-0.5-0.6-1.3-0.8-2-0.5l0,0c0.4-0.6,0.3-1.5-0.2-2l0,0c0.7,0.2,1.5-0.1,1.9-0.8l0,0C750.4,699.8,751,700.4,751.7,700.6\r\n\t\t\t\t\tL751.7,700.6L751.7,700.6z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M774.4,696.1L774.4,696.1c-0.7,0.3-1.1,1-1.1,1.8l0,0\r\n\t\t\t\t\tc-0.5-0.6-1.3-0.8-2-0.5l0,0c0.4-0.6,0.3-1.5-0.2-2l0,0l0,0c0.7,0.2,1.5-0.1,1.9-0.8l0,0C773.2,695.3,773.7,696,774.4,696.1\r\n\t\t\t\t\tL774.4,696.1L774.4,696.1z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M812.3,684.7L812.3,684.7c-0.4,0.7-0.2,1.5,0.3,2l0,0\r\n\t\t\t\t\tc-0.8-0.1-1.5,0.2-1.9,0.9l0,0c-0.1-0.7-0.7-1.4-1.4-1.5l0,0c0.7-0.3,1.1-1.1,1-1.8l0,0C810.8,684.9,811.6,685.1,812.3,684.7\r\n\t\t\t\t\tL812.3,684.7z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M800.1,676.7L800.1,676.7c-0.4,0.6-0.4,1.4,0,2.1l0,0l0,0\r\n\t\t\t\t\tc-0.7-0.2-1.5,0-2,0.6l0,0c0-0.8-0.5-1.4-1.2-1.7l0,0c0.7-0.2,1.2-0.9,1.2-1.7l0,0C798.6,676.7,799.4,676.9,800.1,676.7\r\n\t\t\t\t\tL800.1,676.7L800.1,676.7z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M749.3,701.1l20.9-19.2h0.1l28.5-4.6h0.1l12.7,8.4v0.1\r\n\t\t\t\t\tl2.4,13.1l-41-2.7L749.3,701.1L749.3,701.1z M770.3,682.3l-19.7,18.1l22.1-4.5l0,0l40.5,2.6l-2.3-12.5l-12.4-8.2L770.3,682.3\r\n\t\t\t\t\tL770.3,682.3z\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"798.4,677.6 798.3,668.3 798.4,668.3 810.6,658.1 \r\n\t\t\t\t\t819.7,665.3 819.4,665.6 810.6,658.6 798.7,668.5 798.8,677.6 \t\t\t\t\"/>\r\n\t\t\t</g>\r\n\t\t</g>\r\n\t\t<g id=\"VIRGO\">\r\n\t\t\t<path fill=\"#FF46FF\" d=\"M815,866.8c0.2,0,0.5,0,0.7,0c1.6,0,3.2-0.6,4.4-1.8c1.3-1.3,2-3.2,1.8-5c0-0.2-0.2-0.4-0.4-0.4\r\n\t\t\t\tc-1.9-0.2-3.7,0.4-5.1,1.8c-0.8,0.8-1.4,1.8-1.6,2.9v-1.8c1.4-1.2,2.2-2.9,2.2-4.7s-0.8-3.6-2.3-4.8c-0.2-0.1-0.4-0.1-0.6,0\r\n\t\t\t\tc-1.5,1.2-2.3,2.9-2.3,4.8c0,1.9,0.8,3.5,2.2,4.7v1.8c-0.3-1.1-0.8-2.1-1.6-2.9c-1.3-1.3-3.2-2-5.1-1.8c-0.2,0-0.4,0.2-0.4,0.4\r\n\t\t\t\tc-0.2,1.9,0.4,3.7,1.8,5c1.2,1.2,2.7,1.8,4.4,1.8c0.2,0,0.5,0,0.7,0c0.1,0,0.2-0.1,0.3-0.1v1.4c-1.4,0.5-2.4,1.7-2.5,1.8\r\n\t\t\t\tc0,0,0,0.1-0.1,0.1l-4.3,8.2c-1-0.9-3.6-3.1-5.9-5.3c-1.1-1-2.4-1.7-3.6-2c2.9-3.7,3.6-10.9,1.4-15.7c-1.4-3.2-3.9-4.9-7-4.9\r\n\t\t\t\tc-3,0-5.3,0.9-6.9,2.5c-1.7,1.8-2,4.2-2,5.3c-2.5-1.9-4.6-2.7-6.5-2.7c-1.7,0.1-3,0.8-3.9,2.1c-0.6-0.2-1.3-0.3-1.9-0.2\r\n\t\t\t\tc-1.4,0.1-2.6,0.6-3.5,1.6c-2.2,2.6-1.9,7.2-1.8,7.3v42.9c0,0.2,0.1,0.3,0.3,0.4c0.1,0,0.1,0,0.2,0c0.1,0,0.2-0.1,0.3-0.1\r\n\t\t\t\tl7.4-7.6v0.2c0,1.6,0.9,3.4,3.4,3.4c2.4,0,3-2.5,3.1-3.8c0-0.1-0.1-12.5,0-14.7c0.1-1.5,2.2-5.5,3.4-7.7l2.4,7.1\r\n\t\t\t\tc-3.8,6.4-4.1,14.3-4.1,14.6v25.4l-7.6,15.5c-0.1,0.1-0.1,0.3,0,0.4c0.1,0.1,0.2,0.2,0.4,0.2h24.1h0.1h0.1h7\r\n\t\t\t\tc0.2,0,0.3-0.1,0.4-0.2c0.1-0.1,0.1-0.3,0-0.5c-0.1-0.1-2.2-3.3-7.1-4.3c-0.1-10.1-0.2-34.1-0.2-39.4c0-6.3-1.2-11.7-1.4-12.6\r\n\t\t\t\tl1.9-5.6l3.8,3c4.3,3.5,7.1,0.6,7.2,0.5c0.6-0.6,2.2-3.7,3.8-7v2.6c0,0.3,0.2,0.5,0.5,0.5s0.5-0.2,0.5-0.5v-4.4\r\n\t\t\t\tc0.1-0.3,0.3-0.5,0.3-0.7c0.2-0.3,0.5-0.7,0.8-1c0.9-1,2.2-2.3,0.7-4c-0.6-0.7-1.3-1.1-2.1-1.1l0,0l0,0v-1.2\r\n\t\t\t\tC814.8,866.8,814.9,866.8,815,866.8L815,866.8z M817,862c1-1,2.5-1.6,3.9-1.5c0.1,1.5-0.5,2.9-1.5,3.9s-2.5,1.6-3.9,1.5\r\n\t\t\t\tC815.4,864.4,816,863,817,862z M809.1,864.4c-1.1-1-1.6-2.5-1.5-3.9c1.5-0.1,2.9,0.5,3.9,1.5c1.1,1,1.6,2.5,1.5,3.9\r\n\t\t\t\tC811.6,866,810.2,865.4,809.1,864.4z M785.7,853.4c1.4-1.5,3.4-2.2,6.2-2.2c3.5,0,5.3,2.4,6.2,4.3c2,4.6,1.3,11.9-1.6,15.1\r\n\t\t\t\tc-1.3-0.2-2.4-0.2-3-0.2l-0.1-1.8c6-2.4,4.5-10.7,4.5-10.8s-0.1-0.3-0.2-0.3c-2.3-1.2-2.5-3-2.5-3.1c0-0.2-0.1-0.4-0.3-0.4\r\n\t\t\t\tc-0.2-0.1-0.4,0-0.5,0.2c-2.7,4.1-7.8,4.4-7.8,4.4c-0.2,0-0.4,0.2-0.4,0.5v11.7c-0.8,0-1.5,0.1-2.1,0.3v-12.2\r\n\t\t\t\tC783.9,858.8,783.7,855.6,785.7,853.4L785.7,853.4z M776.5,856.4c1.8-0.1,4,0.9,6.5,2.9v7.1c-1.6-2-5.6-6.9-9.6-8.5\r\n\t\t\t\tC774.2,856.9,775.2,856.4,776.5,856.4L776.5,856.4z M766.3,908.1v-41.8c0,0-0.4-4.4,1.6-6.7c0.7-0.8,1.7-1.3,2.8-1.3\r\n\t\t\t\tc5.3-0.3,12.2,9.4,12.2,9.5c0,0,0,0,0.1,0.1v3.5c-3.1,1.3-4.8,4.5-6.2,7.5c-0.2,0.4-0.4,0.7-0.5,1.1c-2.2,4.2-2.6,7.6-2.7,7.8\r\n\t\t\t\tv12.8L766.3,908.1L766.3,908.1z M783.6,877.7c-0.2,0-0.4,0.1-0.4,0.2c-0.2,0.3-3.9,6.7-4,9c-0.1,2.2,0,14.2,0,14.7\r\n\t\t\t\tc0,0.1-0.1,2.9-2.1,2.9c-2.3,0-2.5-1.9-2.5-2.5v-14.3c0,0,0.5-3.4,2.6-7.5c0.2-0.3,0.4-0.7,0.5-1.1c2-3.8,4-7.8,8.9-7.6\r\n\t\t\t\tc0.1,0,0.2,0,0.3-0.1s0.1-0.2,0.1-0.3v-11.7c1.3-0.1,5-0.9,7.5-4c0.3,0.8,1,1.9,2.5,2.7c0.2,1.3,0.9,7.9-4.2,9.6\r\n\t\t\t\tc-0.2,0.1-0.3,0.2-0.3,0.4l0.1,2.5l-6.6,13.1l-2-5.7C783.9,877.8,783.8,877.7,783.6,877.7L783.6,877.7z M804.9,941.6h-5.8\r\n\t\t\t\tc0-0.6,0-1.7,0-3.1C802.1,939.1,804,940.7,804.9,941.6L804.9,941.6z M796.6,885.6c0,0.1,1.4,5.8,1.4,12.5\r\n\t\t\t\tc0,6.4,0.2,39.2,0.2,43.5h-23l7.3-14.9c0-0.1,0-0.1,0-0.2v-25.4c0-0.1,0.3-8.2,4.1-14.4c0.1-0.1,0.1-0.3,0-0.4l-0.4-1.2l6.7-13.4\r\n\t\t\t\tl5.5,7.5l-2,6.2C796.5,885.5,796.5,885.5,796.6,885.6L796.6,885.6z M814.8,868.8c0.5,0,1,0.2,1.4,0.7c0.9,1,0.3,1.7-0.7,2.7\r\n\t\t\t\tc-0.2,0.2-0.4,0.4-0.5,0.6v-1.7c0-0.3-0.2-0.5-0.5-0.5s-0.5,0.2-0.5,0.5v3.3c0,0.1-0.1,0.2-0.1,0.3c-1.1,2.2-3.7,7.4-4.3,8.1\r\n\t\t\t\tc-0.1,0.1-2.3,2.4-6-0.6l-4.2-3.4l-5.6-7.6c1.5,0,4.6,0.2,6.6,2.2c2.9,2.8,6.3,5.7,6.4,5.7c0.1,0.1,0.2,0.1,0.4,0.1\r\n\t\t\t\tc0.1,0,0.3-0.1,0.3-0.2l4.6-8.7C812.3,870.2,813.5,868.8,814.8,868.8L814.8,868.8z M812.6,857.8c0-1.5,0.6-2.9,1.7-3.9\r\n\t\t\t\tc1.1,1,1.7,2.4,1.7,3.9s-0.6,2.9-1.7,3.9C813.2,860.6,812.6,859.3,812.6,857.8z\"/>\r\n\t\t\t<g id=\"stars_00000043441834381386755420000013925496633254915490_\">\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M758,931.1L758,931.1c-0.6,0.5-0.8,1.4-0.4,2.1l0,0\r\n\t\t\t\t\tc-0.7-0.4-1.5-0.3-2.1,0.2l0,0c0.2-0.8-0.2-1.6-0.9-2l0,0c0.8-0.1,1.4-0.7,1.6-1.4l0,0C756.5,930.7,757.3,931.2,758,931.1\r\n\t\t\t\t\tL758,931.1L758,931.1z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M816.6,853.4L816.6,853.4c-0.6,0.5-0.8,1.4-0.4,2.1l0,0\r\n\t\t\t\t\tc-0.7-0.4-1.5-0.3-2.1,0.2l0,0c0.2-0.8-0.2-1.6-0.9-2l0,0c0.8-0.1,1.4-0.7,1.6-1.4l0,0C815.1,853,815.8,853.5,816.6,853.4\r\n\t\t\t\t\tL816.6,853.4L816.6,853.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M789.5,901.5L789.5,901.5c-0.6,0.5-0.8,1.4-0.4,2.1l0,0\r\n\t\t\t\t\tc-0.7-0.4-1.5-0.3-2.1,0.2l0,0c0.2-0.8-0.2-1.6-0.9-2l0,0c0.8-0.1,1.4-0.7,1.6-1.4l0,0C788,901.1,788.7,901.5,789.5,901.5\r\n\t\t\t\t\tL789.5,901.5L789.5,901.5z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M772.9,939.2L772.9,939.2c0.1,0.8,0.7,1.4,1.5,1.6l0,0\r\n\t\t\t\t\tc-0.7,0.3-1.1,1.1-1,1.9l0,0c-0.5-0.6-1.4-0.7-2.1-0.4l0,0c0.4-0.7,0.3-1.6-0.3-2.1l0,0C771.7,940.2,772.5,939.9,772.9,939.2\r\n\t\t\t\t\tL772.9,939.2L772.9,939.2z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M785.4,926.9L785.4,926.9c-0.5,0.6-0.6,1.4-0.3,2.1l0,0\r\n\t\t\t\t\tc-0.7-0.3-1.6-0.2-2.1,0.4l0,0c0.1-0.8-0.3-1.5-1-1.9l0,0c0.8-0.1,1.4-0.8,1.5-1.6l0,0C783.8,926.7,784.6,927.1,785.4,926.9\r\n\t\t\t\t\tL785.4,926.9L785.4,926.9z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M815.7,869.3L815.7,869.3c-0.5,0.6-0.6,1.4-0.3,2.1l0,0\r\n\t\t\t\t\tc-0.7-0.3-1.6-0.2-2.1,0.4l0,0c0.1-0.8-0.3-1.5-1-1.9l0,0c0.8-0.1,1.4-0.8,1.5-1.6l0,0C814.2,869.1,815,869.5,815.7,869.3\r\n\t\t\t\t\tL815.7,869.3L815.7,869.3z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M810.4,884.6L810.4,884.6c-0.5,0.6-0.6,1.4-0.3,2.1l0,0\r\n\t\t\t\t\tc-0.7-0.3-1.6-0.2-2.1,0.4l0,0c0.1-0.8-0.3-1.5-1-1.9l0,0c0.8-0.1,1.4-0.8,1.5-1.6l0,0C808.8,884.4,809.6,884.7,810.4,884.6\r\n\t\t\t\t\tL810.4,884.6L810.4,884.6z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M786.9,876.8L786.9,876.8c-0.5,0.6-0.6,1.4-0.3,2.1l0,0\r\n\t\t\t\t\tc-0.7-0.3-1.6-0.2-2.1,0.4l0,0c0.1-0.8-0.3-1.5-1-1.9l0,0c0.8-0.1,1.4-0.8,1.5-1.6l0,0C785.4,876.5,786.1,876.9,786.9,876.8\r\n\t\t\t\t\tL786.9,876.8L786.9,876.8z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M804.7,911.7L804.7,911.7c-0.1,0.8,0.4,1.5,1.1,1.8l0,0\r\n\t\t\t\t\tc-0.8,0.2-1.3,0.9-1.4,1.6l0,0c-0.4-0.7-1.2-1-2-0.8l0,0c0.5-0.6,0.6-1.5,0.1-2.1l0,0C803.3,912.5,804.2,912.3,804.7,911.7\r\n\t\t\t\t\tL804.7,911.7z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M776.2,909.3L776.2,909.3c-0.2,0.8,0.2,1.6,0.9,2l0,0\r\n\t\t\t\t\tc-0.8,0.1-1.4,0.7-1.6,1.4l0,0c-0.3-0.7-1.1-1.1-1.9-1.1l0,0c0.6-0.5,0.8-1.4,0.4-2.1l0,0C774.8,909.9,775.6,909.8,776.2,909.3\r\n\t\t\t\t\tL776.2,909.3L776.2,909.3z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M797,883.5L797,883.5c-0.2,0.8,0.2,1.6,0.9,2l0,0\r\n\t\t\t\t\tc-0.8,0.1-1.4,0.7-1.6,1.4l0,0c-0.3-0.7-1.1-1.1-1.9-1.1l0,0c0.6-0.5,0.8-1.4,0.4-2.1l0,0C795.5,884.1,796.4,884,797,883.5\r\n\t\t\t\t\tL797,883.5L797,883.5z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M804.4,897.7L804.4,897.7c-0.2,0.8,0.2,1.6,0.9,2l0,0\r\n\t\t\t\t\tc-0.8,0.1-1.4,0.7-1.6,1.4l0,0c-0.3-0.7-1.1-1.1-1.9-1.1l0,0c0.6-0.5,0.8-1.4,0.4-2.1l0,0C802.9,898.3,803.8,898.2,804.4,897.7\r\n\t\t\t\t\tL804.4,897.7L804.4,897.7z\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"772.7,941.2 772.3,940.9 783.6,927.8 804,913.6 \r\n\t\t\t\t\t803.2,898.7 803.2,898.7 808.5,885.5 814,870.2 814.8,854.2 815.2,854.2 814.4,870.3 808.9,885.6 803.7,898.8 804.4,913.8 \r\n\t\t\t\t\t783.9,928.2 \t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"756.3,932 756,931.7 775.1,910.7 787.5,902.1 \r\n\t\t\t\t\t795.8,885 809.2,885 809.2,885.4 796.1,885.4 787.8,902.4 787.8,902.4 775.4,911 \t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"785.2,877.7 785.5,877.3 796.1,885 795.8,885.3 \t\t\t\t\r\n\t\t\t\t\t\"/>\r\n\t\t\t</g>\r\n\t\t</g>\r\n\t\t<g id=\"LIBRA\">\r\n\t\t\t<path fill=\"#598DFF\" d=\"M608.1,899.4c-0.1-0.1-0.2-0.2-0.4-0.2h-2.1l-6.9-16.4l0.1-0.1c0.2-0.2,0.2-0.5,0-0.7s-0.5-0.2-0.7,0\r\n\t\t\t\tc0,0-3.5,3.1-8.1-0.1l0,0l0,0c-0.1-0.1-0.2-0.1-0.3-0.1h-8V875v-0.1c0.1-0.7-0.1-1.4-0.6-2c-1.3-2-3.7-1.5-4.8-0.9l-13.8,6.8\r\n\t\t\t\tc-0.8-0.7-3.7-3.2-6.2-5.6c-1.1-1.1-2.4-1.7-3.7-2c2.9-3.7,3.6-11.1,1.5-16c-1.5-3.3-3.9-5-7.2-5c-3.1,0-5.4,0.9-7,2.6\r\n\t\t\t\tc-2.4,2.6-2.1,6.1-2.1,6.2v12.8c-3.2,1.3-4.8,4.6-6.4,7.6c-0.2,0.4-0.4,0.7-0.6,1.1c-2.2,4.3-2.7,7.8-2.7,8v14.6\r\n\t\t\t\tc0,1.6,0.9,3.5,3.5,3.5c2.4,0,3.1-2.6,3.1-3.9c0-0.1-0.1-12.8,0-15c0.1-1.5,2.2-5.6,3.5-7.8l2.4,7.3c-3.9,6.5-4.2,14.6-4.2,14.9\r\n\t\t\t\tV928l-7.8,15.8c-0.1,0.1-0.1,0.3,0,0.5s0.2,0.2,0.4,0.2h24.6h0.1h0.1h7.1c0.2,0,0.3-0.1,0.4-0.2c0.1-0.1,0.1-0.3,0-0.5\r\n\t\t\t\tc-0.1-0.1-2.3-3.4-7.3-4.3c-0.1-10.3-0.2-34.8-0.2-40.2c0-6.4-1.3-12-1.5-12.9l1.9-5.7l3.8,3.1c1.6,1.3,3.3,1.7,4.7,1.6l-6.2,14\r\n\t\t\t\th-2.2c-0.1,0-0.3,0.1-0.4,0.2c-0.1,0.1-0.1,0.3-0.1,0.4c0.4,1.7,1.5,3,2.9,3h14.5c1.3,0,2.5-1.2,2.9-3c0-0.1,0-0.3-0.1-0.4\r\n\t\t\t\tc-0.1-0.1-0.2-0.2-0.4-0.2h-2.1l-6.1-14.6c0.4-0.1,0.7-0.3,0.9-0.4c0.5,0.1,0.9,0.2,1.5,0.2c1.3,0,2.9-0.4,4.6-1.6h8v1.8\r\n\t\t\t\tc0,0.3,0.2,0.5,0.5,0.5s0.5-0.2,0.5-0.5V883h8c1.7,1.1,3.3,1.6,4.6,1.6s2.4-0.4,3.1-0.7l-6.8,15.6h-2.2c-0.1,0-0.3,0.1-0.4,0.2\r\n\t\t\t\tc-0.1,0.1-0.1,0.3-0.1,0.4c0.4,1.7,1.5,3,2.9,3H605c1.3,0,2.5-1.2,2.9-3C608.1,899.6,608.1,899.5,608.1,899.4L608.1,899.4z\r\n\t\t\t\t M538.7,859c0,0-0.3-3.3,1.8-5.5c1.4-1.5,3.5-2.3,6.3-2.3c3.6,0,5.4,2.4,6.3,4.4c2.1,4.7,1.3,12.1-1.6,15.4\r\n\t\t\t\tc-1.3-0.2-2.5-0.2-3.1-0.2l-0.1-1.8c6.1-2.4,4.6-10.9,4.5-11c0-0.1-0.1-0.3-0.2-0.3c-2.4-1.2-2.5-3.1-2.5-3.1\r\n\t\t\t\tc0-0.2-0.1-0.4-0.4-0.4c-0.2-0.1-0.4,0-0.5,0.2c-2.7,4.2-7.9,4.5-8,4.5c-0.2,0-0.4,0.2-0.4,0.5v11.9c-0.8,0-1.5,0.1-2.1,0.3V859\r\n\t\t\t\tL538.7,859z M538.3,878.3c-0.2,0-0.4,0.1-0.5,0.2c-0.2,0.3-4,6.8-4.1,9.2c-0.1,2.2,0,14.5,0,15c0,0.1-0.1,3-2.2,3\r\n\t\t\t\tc-2.4,0-2.6-1.9-2.6-2.5v-14.6c0,0,0.5-3.5,2.6-7.6c0.2-0.4,0.4-0.7,0.6-1.1c2-3.9,4.1-7.9,9.1-7.7c0.1,0,0.3,0,0.3-0.1\r\n\t\t\t\tc0.1-0.1,0.1-0.2,0.1-0.3v-12c1.3-0.2,5.1-0.9,7.7-4.1c0.3,0.8,1,1.9,2.5,2.8c0.2,1.3,0.9,8-4.3,9.8c-0.2,0.1-0.3,0.3-0.3,0.5\r\n\t\t\t\tl0.1,2.5l-6.7,13.4l-2-6C538.7,878.4,538.5,878.3,538.3,878.3L538.3,878.3z M560.1,943.5h-5.9c0-0.6,0-1.7,0-3.2\r\n\t\t\t\tC557.3,941,559.2,942.6,560.1,943.5z M551.6,886.4c0,0.1,1.5,5.9,1.5,12.8c0,6.5,0.2,40,0.2,44.4h-23.4l7.5-15.2\r\n\t\t\t\tc0-0.1,0-0.1,0-0.2v-26c0-0.1,0.3-8.3,4.1-14.7c0.1-0.1,0.1-0.3,0-0.4l-0.4-1.3l6.9-13.6l5.6,7.6l-2.1,6.3\r\n\t\t\t\tC551.5,886.2,551.5,886.3,551.6,886.4L551.6,886.4z M558.8,882.9l-4.3-3.4l-5.7-7.7c1.5,0,4.6,0.2,6.7,2.2c3,2.9,6.5,5.8,6.5,5.8\r\n\t\t\t\tc0.1,0.1,0.3,0.1,0.5,0.1l14.1-7c0.1-0.1,2.4-1.3,3.6,0.5c0.4,0.7,0.5,1.2,0.4,1.8c-0.2,0.7-0.8,1.4-1.8,2\r\n\t\t\t\tc-1.3,0.8-12.2,5.9-12.4,6l0,0c-1.4-0.4-2.2-1.1-2.3-1.2c-0.2-0.2-0.5-0.2-0.7,0s-0.2,0.5,0,0.7c0,0,0.1,0.1,0.3,0.3v0.1l0,0\r\n\t\t\t\tl-0.5,1.1C562,884.4,560.4,884.1,558.8,882.9L558.8,882.9z M563.8,885.5v13.7h-6L563.8,885.5z M571.5,901.8H557\r\n\t\t\t\tc-0.8,0-1.5-0.7-1.8-1.7h18.1C573,901.1,572.3,901.8,571.5,901.8L571.5,901.8z M570.8,899.2h-6.1v-14.3c0,0,0,0,0.1,0\r\n\t\t\t\tL570.8,899.2L570.8,899.2z M572.6,881.8c-0.1,0-0.3,0.1-0.4,0.1l0,0c-1.6,1.1-3,1.5-4.2,1.5c2.9-1.4,10.1-4.8,11.2-5.5\r\n\t\t\t\tc0.6-0.3,1-0.7,1.4-1.1v4.9L572.6,881.8L572.6,881.8z M598.5,884.8l6.1,14.5h-6.1V884.8z M597.6,885.5v13.7h-6L597.6,885.5z\r\n\t\t\t\t M605.3,901.8h-14.5c-0.8,0-1.5-0.7-1.8-1.7h18.1C606.7,901.1,606,901.8,605.3,901.8L605.3,901.8z\"/>\r\n\t\t\t<g id=\"stars_00000018217385844909828140000017973858654029297834_\">\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M576.3,916.4L576.3,916.4c-0.8,0.3-1.3,1-1.3,1.8l0,0\r\n\t\t\t\t\tc-0.5-0.7-1.3-0.9-2.1-0.7l0,0c0.5-0.7,0.5-1.5,0-2.2l0,0c0.8,0.3,1.6,0,2.1-0.7l0,0C575,915.5,575.5,916.2,576.3,916.4\r\n\t\t\t\t\tL576.3,916.4L576.3,916.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M567.4,863.9L567.4,863.9c-0.2,0.8,0.1,1.6,0.7,2.1l0,0\r\n\t\t\t\t\tc-0.8,0-1.5,0.5-1.8,1.3l0,0c-0.3-0.8-1-1.3-1.8-1.3l0,0c0.6-0.5,0.9-1.3,0.6-2.1l0,0C565.9,864.4,566.7,864.4,567.4,863.9\r\n\t\t\t\t\tL567.4,863.9L567.4,863.9z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M552.9,887L552.9,887c-0.7,0.3-1.2,1.1-1.1,1.9l0,0\r\n\t\t\t\t\tc-0.5-0.6-1.4-0.8-2.1-0.5l0,0c0.4-0.7,0.4-1.6-0.2-2.2l0,0c0.8,0.2,1.6-0.2,2-0.8l0,0C551.6,886.2,552.1,886.8,552.9,887\r\n\t\t\t\t\tL552.9,887L552.9,887z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M525.3,881.9L525.3,881.9c-0.7,0.3-1.2,1.1-1.1,1.9l0,0\r\n\t\t\t\t\tc-0.5-0.6-1.4-0.8-2.1-0.5l0,0c0.4-0.7,0.3-1.6-0.2-2.2l0,0c0.8,0.2,1.6-0.2,2-0.8l0,0C523.9,881,524.5,881.7,525.3,881.9\r\n\t\t\t\t\tL525.3,881.9L525.3,881.9z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M534.1,894.7L534.1,894.7c-0.7,0.3-1.2,1.1-1.1,1.9l0,0\r\n\t\t\t\t\tc-0.5-0.6-1.4-0.8-2.1-0.5l0,0c0.4-0.7,0.4-1.6-0.2-2.2l0,0c0.8,0.2,1.6-0.2,2-0.8l0,0C532.7,893.9,533.3,894.5,534.1,894.7\r\n\t\t\t\t\tL534.1,894.7L534.1,894.7z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M548.4,940L548.4,940c-0.4,0.7-0.3,1.6,0.3,2.2l0,0\r\n\t\t\t\t\tc-0.8-0.1-1.6,0.3-2,1l0,0c-0.1-0.8-0.7-1.4-1.5-1.6l0,0c0.7-0.4,1.1-1.1,1-1.9l0,0C546.8,940.2,547.7,940.3,548.4,940\r\n\t\t\t\t\tL548.4,940L548.4,940z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M591.7,882.5L591.7,882.5c-0.5,0.7-0.5,1.5,0,2.2l0,0\r\n\t\t\t\t\tc-0.8-0.2-1.6,0-2.1,0.7l0,0c0-0.8-0.5-1.5-1.3-1.8l0,0c0.8-0.3,1.3-1,1.3-1.8l0,0C590.1,882.5,591,882.8,591.7,882.5\r\n\t\t\t\t\tL591.7,882.5L591.7,882.5z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M549.1,923.7L549.1,923.7c-0.5,0.7-0.5,1.5,0,2.2l0,0\r\n\t\t\t\t\tc-0.8-0.2-1.6,0-2.1,0.7l0,0c0-0.8-0.5-1.5-1.3-1.8l0,0c0.8-0.3,1.3-1,1.3-1.8l0,0C547.5,923.7,548.4,924,549.1,923.7\r\n\t\t\t\t\tL549.1,923.7L549.1,923.7z\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"547.2,941.3 546.8,941.3 547.3,924.2 574.3,916.1 \r\n\t\t\t\t\t590.3,883.6 566.9,865.6 551.7,887.4 551.6,887.4 531.9,895.2 523.1,882 523.4,881.8 532.1,894.7 551.4,887 566.8,865 \r\n\t\t\t\t\t567,865.1 590.8,883.5 574.6,916.4 574.5,916.5 547.7,924.5 \t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"565.9,865.4 566.3,865.3 574.6,916.3 574.2,916.3 \t\t\t\t\r\n\t\t\t\t\t\"/>\r\n\t\t\t</g>\r\n\t\t</g>\r\n\t\t<g id=\"SAGITTARIUS\">\r\n\t\t\t<path fill=\"#AF00E0\" d=\"M116.8,879.5l-5.6-2c-0.1,0-0.3,0-0.4,0.1s-0.2,0.2-0.2,0.3v1.6h-1.8c0-1.8,0-5.3,0-9.1\r\n\t\t\t\tc-0.1-5.3-5.7-7.5-8.7-7.9c-0.7-0.1-1.3,0.4-1.4,1c-0.1,0.3,0,0.7,0.2,0.9c0.1,0.2,0.4,0.3,0.6,0.4l-13.7,13.3h-1v-1\r\n\t\t\t\tc1.4-0.4,2.1-1.9,2.2-2.7c0,0,0,0,0-0.1v-2.6h1.2c0.1,0,0.3-0.1,0.3-0.2c0.1-0.1,0.1-0.2,0.1-0.4l-1.5-4.4v-2.5h0.7\r\n\t\t\t\tc0.2,0,0.4-0.2,0.4-0.4c0-1.8-1.5-2.3-2.3-2.3h-3.7c-2.2,0-4,0.7-5.1,2c-2.1,2.3-1.7,5.8-1.7,5.9v3.8c0,0.7,0.2,1.1,0.6,1.5\r\n\t\t\t\ts1,0.4,1.2,0.4v2.4H62.4c-1.8,0-3.2,1.4-3.2,3.2c0,1.7,1.4,3.2,3.2,3.2h9.3v16.9H63c-1.8,0.1-5.3,1-5.3,4.2v9.8\r\n\t\t\t\tc0,0.1,0.1,1.9,1.2,2.8c1,0.9,2.6,2.1,2.6,2.2c0.2,0.1,0.4,0.1,0.6,0l1-1.1v2.1c0,0,0,0,0,0.1c0,0.2,0.4,1.8,3.6,3.8\r\n\t\t\t\tc0.1,0,0.1,0.1,0.2,0.1s0.2,0,0.3-0.1l2.8-3.1c0.1-0.1,0.1-0.2,0.1-0.3s-0.1-0.2-0.2-0.3l-2-1.6v-8.6h4.4c0.1,0,0.1,0,0.2-0.1\r\n\t\t\t\tc2.3,2.1,6.3,4.9,13.3,7.8c-0.2,0.8-0.8,5.8,11,13v7.2l-1.6,3.5c-0.1,0.1-0.1,0.3,0,0.4c0.1,0.1,0.2,0.2,0.4,0.2h5\r\n\t\t\t\tc0.2,0,0.3-0.1,0.4-0.3l1-2.8v-0.1v-10.1c1.5,1.3,3.5,2.6,6.2,4.2v7.7l-1.7,3.3c-0.1,0.1-0.1,0.3,0,0.4c0.1,0.1,0.2,0.2,0.4,0.2\r\n\t\t\t\th5.1c0.2,0,0.3-0.1,0.4-0.3l1.1-2.7v-0.1v-8.4c0.1-0.5,0.3-2.7-5-6.6c0.7-1.4,3-6.7,1.6-11.9c1.7,1.8,1.5,3.3,1.5,3.3s0,0,0,0.1\r\n\t\t\t\tv7.7c0,3.6,3.8,5.9,3.9,6c0.1,0,0.1,0.1,0.2,0.1s0.1,0,0.2-0.1s0.2-0.2,0.2-0.4v-10.9c0-4.9-5.6-8.1-6.7-8.7\r\n\t\t\t\tc-0.4-0.2-0.6-0.3-0.7-0.3c-1.4-2.2-3.6-3.9-6.7-5.2c-12.4-5-13.8-5.9-14-6c-0.1-0.1-0.1-0.1-0.2-0.1V886h1.5l10,10.5\r\n\t\t\t\tc-0.5,0.2-0.8,0.7-0.7,1.3c0.1,0.6,0.6,1.1,1.2,1.1c0.1,0,0.1,0,0.2,0c3-0.4,8.6-2.6,8.7-7.9c0-1.9,0-3.7,0-5.2\r\n\t\t\t\tc1.1-0.5,1.8-1.6,1.8-2.9c0-0.9-0.4-1.7-1-2.3h1v1.6c0,0.1,0.1,0.3,0.2,0.3c0.1,0.1,0.1,0.1,0.2,0.1s0.1,0,0.1,0l5.6-2\r\n\t\t\t\tc0.2-0.1,0.3-0.2,0.3-0.4S117,879.6,116.8,879.5L116.8,879.5z M99.9,864.1c-0.1,0-0.2-0.1-0.3-0.2c-0.1-0.1-0.1-0.2-0.1-0.3\r\n\t\t\t\tc0-0.2,0.2-0.3,0.4-0.3c0,0,0,0,0.1,0c2.7,0.4,7.9,2.4,8,7.1c0,3.8,0,7.2,0,9.1h-0.3c-0.1,0-0.1,0-0.2,0h-0.3c0-1.8,0-5.3,0-9.1\r\n\t\t\t\ts-3.9-5.4-6-6c-0.4-0.1-0.7-0.2-0.9-0.2C100,864.1,99.9,864.1,99.9,864.1L99.9,864.1z M100.5,865c1.7,0.4,5.8,1.8,5.8,5.3\r\n\t\t\t\tc0,3.8,0,7.3,0,9.1H87.6c-0.1,0-0.1,0-0.2,0h-0.9h-0.1v-0.9L100.5,865L100.5,865z M85.5,878.9L85.5,878.9\r\n\t\t\t\tc0.1,0.1,0.1,0.1,0.2,0.1v2.2H82c0.1-0.2,0.1-0.5,0.1-0.7c0-0.6-0.1-1.1-0.4-1.6H85.5L85.5,878.9z M87.7,870.8h-6.9v-5.9h5.4v1.8\r\n\t\t\t\tv0.1l0,0l0.8,2.4L87.7,870.8L87.7,870.8z M77.1,874.1c0,0-0.4,0.1-0.6-0.2c-0.2-0.2-0.3-0.4-0.3-0.8v-3.9c0,0-0.4-3.2,1.5-5.3\r\n\t\t\t\tc1-1.1,2.5-1.7,4.5-1.7h3.7c0.1,0,1.2,0.1,1.5,1.1h-0.6c-0.2,0-0.4,0.2-0.4,0.4v0.4h-5.9c-0.2,0-0.4,0.2-0.4,0.4v6.7\r\n\t\t\t\tc0,0.2,0.2,0.4,0.4,0.4h5.9v2.6c-0.1,0.3-0.5,2.2-2.3,2.2h-2.9c-0.1,0-2.3-0.2-2.3-1.8c0-0.2-0.2-0.4-0.4-0.4h-1.4\r\n\t\t\t\tC77.2,874.1,77.1,874.1,77.1,874.1z M78,874.9L78,874.9c0.4,1.6,2.1,2.2,3.1,2.3H84c0,0,0,0,0.1,0v0.9H81\r\n\t\t\t\tc-0.6-0.5-1.3-0.8-2.1-0.8H78V874.9L78,874.9z M62.4,882.8c-1.3,0-2.3-1-2.3-2.3s1.1-2.3,2.3-2.3h16.4c0.2,0,0.4,0,0.7,0.1\r\n\t\t\t\tc0.4,0.1,0.8,0.4,1.1,0.7c0.4,0.4,0.6,0.9,0.6,1.6c0,0.3-0.1,0.5-0.1,0.7c-0.1,0.3-0.3,0.6-0.5,0.8c-0.4,0.5-1,0.8-1.7,0.8\r\n\t\t\t\tL62.4,882.8L62.4,882.8z M67.6,909.5c-0.2,0-0.4,0.2-0.4,0.4v9.2c0,0.1,0.1,0.2,0.2,0.3l1.9,1.4l-2.3,2.5c-2.4-1.6-2.8-2.9-2.9-3\r\n\t\t\t\tv-2.9l1.2-1.3c0.1-0.1,0.1-0.2,0.1-0.3s-0.1-0.2-0.2-0.3l-1.2-1V909c0-1.9,1.3-2.7,2-3h3.6c0.2,0.6,0.7,1.8,2.3,3.4\r\n\t\t\t\tC71.7,909.5,67.6,909.5,67.6,909.5z M62.7,913.7V906h1.7c-0.7,0.6-1.3,1.5-1.3,3v5L62.7,913.7z M101.2,928.3V939l-0.9,2.5h-4.1\r\n\t\t\t\tl1.4-3c0-0.1,0-0.1,0-0.2v-7.6c0-0.1-0.1-0.3-0.2-0.3c-10.9-6.6-10.9-11.2-10.8-12.1c3,1.2,6.5,2.5,10.6,3.7\r\n\t\t\t\tC97.2,923,97.6,925.1,101.2,928.3L101.2,928.3L101.2,928.3z M115.4,920.8v10.1c-1-0.8-2.9-2.6-2.9-4.9v-7.7\r\n\t\t\t\tc0-0.3,0.2-2.6-2.8-4.9c0,0,0,0-0.1,0c-0.1-0.1-0.1-0.2-0.2-0.3C111.4,914,115.4,916.9,115.4,920.8L115.4,920.8z M101.9,907.3\r\n\t\t\t\tc3.7,1.5,6.1,3.8,7.2,6.8c2.1,5.8-1.4,12.5-1.4,12.5c-0.1,0.2,0,0.4,0.1,0.5c5.5,4,5,5.9,5,5.9c0,0.1,0,0.1,0,0.2v8.4l-1,2.4\r\n\t\t\t\th-4.2l1.4-2.8c0-0.1,0-0.1,0-0.2v-8.1c0-0.1-0.1-0.3-0.2-0.4c-11.7-6.7-10.7-10.6-10.7-10.7c0-0.1,0-0.2,0-0.3\r\n\t\t\t\tc-0.1-0.1-0.1-0.2-0.2-0.2c-26.1-7.9-27.7-15.8-27.7-15.8c0-0.2-0.2-0.4-0.4-0.4h-3.4c-0.1-0.1-0.2-0.1-0.4-0.1\r\n\t\t\t\tc0,0-0.1,0-0.3,0.1h-3.4c-0.2,0-0.4,0.2-0.4,0.4v8.3c0,0.1,0.1,0.2,0.2,0.3l1.1,0.9l0.1,0.1l1,0.8l-0.8,0.9\r\n\t\t\t\tc-0.1,0-0.2,0.1-0.2,0.3l-1.4,1.5c-0.5-0.4-1.6-1.3-2.3-1.9c-0.8-0.7-0.9-2.2-0.9-2.2v-9.8c0-3.1,4.3-3.3,4.5-3.3H88\r\n\t\t\t\tC89.3,902.2,97.1,905.4,101.9,907.3L101.9,907.3z M88,884.9h-0.4c-0.2,0-0.3,0-0.5,0v15.6H72.5v-16.9h6.3c1.2,0,2.2-0.6,2.8-1.6\r\n\t\t\t\th4.3l2.8,2.9H88L88,884.9z M90.6,885.7h15.8c0,1.5,0,3.1,0,4.9c0,3.7-4.4,5-6,5.4L90.6,885.7L90.6,885.7z M108,890.7\r\n\t\t\t\tc-0.1,4.7-5.3,6.7-8,7.1c-0.2,0-0.4-0.1-0.5-0.3c0-0.2,0.1-0.4,0.4-0.5c0,0,0.1,0,0.2,0c0.2,0,0.5-0.1,0.9-0.2\r\n\t\t\t\tc2-0.5,6.1-2.1,6.2-6.1c0-1.8,0-3.4,0-4.9h0.3c0.2,0,0.3,0,0.5,0C108.1,887.2,108.1,888.9,108,890.7L108,890.7z M109.9,882.6\r\n\t\t\t\tc0,0.8-0.4,1.5-1,1.9c-0.2,0.2-0.5,0.3-0.8,0.4c-0.2,0-0.3,0.1-0.5,0.1H89.8l-3.3-3.5v-0.8c0.3-0.2,0.7-0.3,1.1-0.3h20.1\r\n\t\t\t\tc0.1,0,0.3,0,0.4,0c0.3,0.1,0.6,0.2,0.8,0.3C109.5,881.1,109.9,881.8,109.9,882.6L109.9,882.6z M111.5,881.3v-2.9l4,1.4\r\n\t\t\t\tL111.5,881.3L111.5,881.3z\"/>\r\n\t\t\t<g id=\"stars_00000119084683753886117270000006132609786968240554_\">\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M81.7,948.3L81.7,948.3c-0.7,0.2-1.1,0.9-1.1,1.6l0,0\r\n\t\t\t\t\tc-0.4-0.6-1.2-0.8-1.8-0.6l0,0c0.4-0.6,0.4-1.4,0-1.9l0,0l0,0c0.7,0.2,1.4,0,1.8-0.6l0,0l0,0C80.5,947.5,81,948.1,81.7,948.3\r\n\t\t\t\t\tL81.7,948.3L81.7,948.3z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M113.1,888.4L113.1,888.4c-0.7,0.2-1.1,0.9-1.1,1.6l0,0\r\n\t\t\t\t\tc-0.4-0.6-1.2-0.8-1.8-0.6l0,0c0.4-0.6,0.4-1.4,0-1.9l0,0c0.7,0.2,1.4,0,1.8-0.6l0,0C112,887.5,112.5,888.1,113.1,888.4\r\n\t\t\t\t\tL113.1,888.4L113.1,888.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M102.6,891.5L102.6,891.5c-0.7,0.2-1.1,0.9-1.1,1.6l0,0\r\n\t\t\t\t\tc-0.4-0.6-1.2-0.8-1.8-0.6l0,0c0.4-0.6,0.4-1.4,0-1.9l0,0c0.7,0.2,1.4,0,1.8-0.6l0,0C101.4,890.7,101.9,891.3,102.6,891.5\r\n\t\t\t\t\tL102.6,891.5L102.6,891.5z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M87.4,895.5L87.4,895.5c-0.7,0.2-1.1,0.9-1.1,1.6l0,0\r\n\t\t\t\t\tc-0.4-0.6-1.2-0.8-1.8-0.6l0,0c0.4-0.6,0.4-1.4,0-1.9l0,0c0.7,0.2,1.4,0,1.8-0.6l0,0C86.2,894.7,86.7,895.3,87.4,895.5\r\n\t\t\t\t\tL87.4,895.5L87.4,895.5z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M84.8,876.1L84.8,876.1c-0.7,0.2-1.1,0.9-1.1,1.6l0,0\r\n\t\t\t\t\tc-0.4-0.6-1.2-0.8-1.8-0.6l0,0c0.4-0.6,0.4-1.4,0-1.9l0,0c0.7,0.2,1.4,0,1.8-0.6l0,0C83.7,875.3,84.1,875.9,84.8,876.1\r\n\t\t\t\t\tL84.8,876.1L84.8,876.1z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M81.3,928.5L81.3,928.5c-0.2,0.7,0,1.4,0.6,1.8l0,0\r\n\t\t\t\t\tc-0.7,0-1.3,0.5-1.5,1.2l0,0c-0.2-0.7-0.9-1.1-1.6-1.1l0,0c0.6-0.4,0.8-1.2,0.6-1.8l0,0C80,928.9,80.8,928.9,81.3,928.5\r\n\t\t\t\t\tL81.3,928.5L81.3,928.5z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M63.1,936.2L63.1,936.2c-0.7,0.3-1.1,0.9-1,1.6l0,0\r\n\t\t\t\t\tc-0.5-0.5-1.2-0.7-1.9-0.4l0,0c0.4-0.6,0.3-1.4-0.2-1.9l0,0c0.7,0.2,1.4-0.1,1.8-0.7l0,0C61.9,935.4,62.4,936,63.1,936.2\r\n\t\t\t\t\tL63.1,936.2L63.1,936.2z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M128.6,901.2L128.6,901.2c-0.7,0.3-1.1,0.9-1,1.6l0,0\r\n\t\t\t\t\tc-0.5-0.5-1.2-0.7-1.9-0.4l0,0c0.4-0.6,0.3-1.4-0.2-1.9l0,0c0.7,0.2,1.4-0.1,1.8-0.7l0,0C127.4,900.4,127.9,901,128.6,901.2\r\n\t\t\t\t\tL128.6,901.2L128.6,901.2z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M119.9,877.6L119.9,877.6c-0.7,0.3-1.1,0.9-1,1.6l0,0\r\n\t\t\t\t\tc-0.5-0.5-1.2-0.7-1.9-0.4l0,0c0.4-0.6,0.3-1.4-0.2-1.9l0,0c0.7,0.2,1.4-0.1,1.8-0.7l0,0C118.7,876.9,119.2,877.5,119.9,877.6\r\n\t\t\t\t\tL119.9,877.6L119.9,877.6z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M94.7,887.9L94.7,887.9c-0.7,0.3-1.1,0.9-1,1.6l0,0\r\n\t\t\t\t\tc-0.5-0.5-1.2-0.7-1.9-0.4l0,0c0.4-0.6,0.3-1.4-0.2-1.9l0,0c0.7,0.2,1.4-0.1,1.8-0.7l0,0l0,0C93.5,887.1,94,887.7,94.7,887.9\r\n\t\t\t\t\tL94.7,887.9L94.7,887.9z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M64.3,917.5L64.3,917.5c-0.7,0.3-1.1,0.9-1,1.6l0,0\r\n\t\t\t\t\tc-0.5-0.5-1.2-0.7-1.9-0.4l0,0c0.4-0.6,0.3-1.4-0.2-1.9l0,0c0.7,0.2,1.4-0.1,1.8-0.7l0,0C63.1,916.7,63.6,917.3,64.3,917.5\r\n\t\t\t\t\tL64.3,917.5L64.3,917.5z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M117.8,899.8L117.8,899.8c-0.7,0.3-1.1,0.9-1,1.6l0,0\r\n\t\t\t\t\tc-0.5-0.5-1.2-0.7-1.9-0.4l0,0c0.4-0.6,0.3-1.4-0.2-1.9l0,0c0.7,0.2,1.4-0.1,1.8-0.7l0,0C116.6,899,117.1,899.6,117.8,899.8\r\n\t\t\t\t\tL117.8,899.8L117.8,899.8z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M94.2,900.5L94.2,900.5c-0.7,0.3-1.1,0.9-1,1.6l0,0\r\n\t\t\t\t\tc-0.5-0.5-1.2-0.7-1.9-0.4l0,0c0.4-0.6,0.3-1.4-0.2-1.9l0,0c0.7,0.2,1.4-0.1,1.8-0.7l0,0C93,899.7,93.6,900.3,94.2,900.5\r\n\t\t\t\t\tL94.2,900.5L94.2,900.5z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M76.2,866.6L76.2,866.6c-0.7,0.3-1.1,0.9-1,1.6l0,0\r\n\t\t\t\t\tc-0.5-0.5-1.2-0.7-1.9-0.4l0,0c0.4-0.6,0.3-1.4-0.2-1.9l0,0c0.7,0.2,1.4-0.1,1.8-0.7l0,0C75,865.8,75.5,866.4,76.2,866.6\r\n\t\t\t\t\tL76.2,866.6L76.2,866.6z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M73.5,881.9L73.5,881.9c-0.3,0.6-0.2,1.4,0.3,1.9l0,0\r\n\t\t\t\t\tc-0.7-0.1-1.4,0.2-1.7,0.9l0,0c-0.1-0.7-0.6-1.3-1.3-1.4l0,0c0.6-0.3,1-1,0.9-1.7l0,0C72.1,882,72.9,882.2,73.5,881.9\r\n\t\t\t\t\tL73.5,881.9z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M81.8,938.6L81.8,938.6c-0.4,0.6-0.4,1.4,0,1.9l0,0\r\n\t\t\t\t\tc-0.7-0.2-1.4,0-1.8,0.6l0,0c0-0.7-0.5-1.3-1.1-1.6l0,0c0.7-0.2,1.1-0.9,1.1-1.6l0,0C80.4,938.6,81.2,938.8,81.8,938.6\r\n\t\t\t\t\tL81.8,938.6L81.8,938.6z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M112.6,910.3L112.6,910.3c-0.4,0.6-0.4,1.4,0,1.9l0,0\r\n\t\t\t\t\tc-0.7-0.2-1.4,0-1.8,0.6l0,0c0-0.7-0.5-1.3-1.1-1.6l0,0c0.7-0.2,1.1-0.9,1.1-1.6l0,0C111.2,910.3,111.9,910.5,112.6,910.3\r\n\t\t\t\t\tL112.6,910.3L112.6,910.3z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M57.2,910.4L57.2,910.4c-0.4,0.6-0.4,1.4,0,1.9l0,0\r\n\t\t\t\t\tc-0.7-0.2-1.4,0-1.8,0.6l0,0c0-0.7-0.5-1.3-1.1-1.6l0,0c0.7-0.2,1.1-0.9,1.1-1.6l0,0C55.7,910.4,56.5,910.7,57.2,910.4\r\n\t\t\t\t\tL57.2,910.4L57.2,910.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M120.2,918.8L120.2,918.8c-0.4,0.6-0.4,1.4,0,1.9l0,0\r\n\t\t\t\t\tc-0.7-0.2-1.4,0-1.8,0.6l0,0c0-0.7-0.5-1.3-1.1-1.6l0,0c0.7-0.2,1.1-0.9,1.1-1.6l0,0C118.7,918.8,119.5,919.1,120.2,918.8\r\n\t\t\t\t\tL120.2,918.8L120.2,918.8z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M57.4,887.9L57.4,887.9c-0.4,0.6-0.4,1.4,0,1.9l0,0\r\n\t\t\t\t\tc-0.7-0.2-1.4,0-1.8,0.6l0,0c0-0.7-0.5-1.3-1.1-1.6l0,0c0.7-0.2,1.1-0.9,1.1-1.6l0,0C56,887.9,56.7,888.1,57.4,887.9L57.4,887.9\r\n\t\t\t\t\tL57.4,887.9z\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"80.2,948.4 79.8,948.4 80.2,939.8 61.2,936.7 \r\n\t\t\t\t\t61.2,936.5 62.3,917.4 55.8,911.3 55.8,888.5 72.8,882.5 85.7,895.1 93,887.8 101.2,891.3 111.8,887.9 111.9,888.1 116.6,900 \r\n\t\t\t\t\t116.6,900.1 111.5,911.2 118.7,919.5 118.5,919.8 111,911.3 116.2,900 111.6,888.4 101.2,891.7 101.1,891.6 93.1,888.3 \r\n\t\t\t\t\t85.7,895.6 72.7,883 56.1,888.8 56.1,911.2 62.7,917.2 62.7,917.3 61.6,936.4 80.6,939.5 \t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"92.8,900.9 85.7,895.9 85.7,895.9 83,876.3 \r\n\t\t\t\t\t74.5,866.8 74.8,866.5 83.4,876.1 83.4,876.2 86.1,895.7 92.8,900.3 101.1,891.3 101.4,891.6 \t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"111.4,888.4 118.5,877.5 118.8,877.7 111.7,888.6 \t\t\t\t\r\n\t\t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"116.1,900.4 116.1,900 127.3,901.1 127.2,901.5 \t\t\t\t\r\n\t\t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"61.5,936.7 61.3,936.4 80.5,929.6 80.7,930 \t\t\t\t\"/>\r\n\t\t\t</g>\r\n\t\t</g>\r\n\t\t<g id=\"SCORPIO\">\r\n\t\t\t<path fill=\"#E04C00\" d=\"M361.6,896.5c0,0-1.3,3-2.6,5l0.6-6.4c0-0.2-0.1-0.3-0.2-0.4c-0.1-0.1-0.3,0-0.4,0.1l0,0\r\n\t\t\t\tc-0.1,0.1-2.8,2.9-3.5,7.2c-1.2,0.4-6.6,2.3-8.2,6.8c-0.7-0.7-1.9-1.9-3-2.2c-0.9-0.2-2.5,0.4-4.1,0.9c-0.5,0.2-1.1,0.4-1.6,0.5\r\n\t\t\t\tc0-0.1,0-0.2,0-0.3c0.1-1.3-0.3-2.3-1-3s-1.8-1.1-3.1-1c-0.1,0-0.3,0-0.4,0c0.1-0.5,0.4-1.1,0.6-1.7c0.6-1.5,1.1-3.1,0.9-4\r\n\t\t\t\tc-0.2-1.1-1.4-2.3-2.2-3c4.5-1.6,6.4-6.9,6.8-8.1c4.3-0.8,7.1-3.4,7.2-3.5l0,0c0.1-0.1,0.1-0.3,0.1-0.4c-0.1-0.1-0.2-0.2-0.4-0.2\r\n\t\t\t\tl-6.4,0.6c1.9-1.3,5-2.6,5-2.6c0.2-0.1,0.3-0.2,0.2-0.4c0-0.2-0.2-0.3-0.4-0.3c-11.4-0.8-16.5,4.5-18.2,6.8\r\n\t\t\t\tc-1.6,2.3-2.2,4.9-1.5,6.6c1.4,3.3,4.6,5.7,5.6,6.4c-1.1,2.2-1,3.9-0.7,4.9c-0.4,0.2-0.9,0.4-1.3,0.6c-0.4-0.5-1.2-1.3-2.5-2.8\r\n\t\t\t\tl-0.1-0.1c-1.4-0.6-4-0.8-5-0.8c0.2-1.6-0.2-3.6-0.4-4.2c1.3-1.7,2.6-4.8,2.6-4.9c0.1-0.1,0-0.3-0.1-0.4\r\n\t\t\t\tc-0.1-0.1-0.3-0.1-0.4-0.1c-1.8,0.8-4.8,5.1-4.9,5.2c0,0,0,0.1-0.1,0.1c-0.7,2.8,0.6,6.7,0.7,6.9c0,0.1,0.1,0.1,0.2,0.2\r\n\t\t\t\tc1.5,0.9,4.7,0.8,5.6,0.8c0.3,0.5,0.9,1.2,1.4,1.8c-0.5,0.3-0.9,0.6-1.4,0.9c-0.6-0.7-1.6-1.6-2.3-1.9c-1-0.4-3.9-0.7-5.1-0.8\r\n\t\t\t\tc0.2-2-0.6-5-0.6-5.1s-0.1-0.1-0.1-0.2c-2.2-2.1-5.9-3.1-6-3.2c-0.2,0-0.4,0-0.4,0.2c-0.1,0.2,0,0.4,0.1,0.5\r\n\t\t\t\tc1.8,1.4,3.7,3.4,4.2,4c-0.1,1.1-0.1,6.2,1,6.8c0.8,0.4,4.3,0.5,5.3,0.5l1.3,1.3c-0.5,0.4-0.9,0.8-1.4,1.3\r\n\t\t\t\tc-0.8-0.9-1.9-1.7-1.9-1.8c0,0-0.1,0-0.1-0.1c-0.9-0.4-3.7-0.3-4.9-0.2c0.2-1.3,0.5-4.7-0.9-5.6c-1.7-1.1-6.3,0.9-6.9,1.1\r\n\t\t\t\tc-0.2,0.1-0.3,0.2-0.2,0.4s0.2,0.3,0.4,0.3l4.4,0.4c-0.1,2,0,5.9,1.3,6.2c1.2,0.3,4.8,0.2,5.6,0.2l1.1,1.2\r\n\t\t\t\tc-0.4,0.4-0.8,0.9-1.2,1.3l-1.8-1.7l-0.1-0.1c-1.2-0.5-5.5-0.2-6-0.2h-0.1c-1.9,0.6-4.2,3.6-4.6,4.2l-5.5,1.4\r\n\t\t\t\tc-0.2,0-0.3,0.2-0.3,0.4s0.1,0.3,0.3,0.4c0.6,0.1,5.7,0.7,7,0.2c1.2-0.4,3.9-2.7,4.5-3.2c1,0.1,2.6-0.2,3.2-0.3l1.3,1.5\r\n\t\t\t\tc-3,3.9-4.6,7.7-4.5,10.3c-1.5-0.1-3.2,0.6-4.5,1.9c-1,1-1.6,2.2-1.8,3.4c-1.2-0.8-3-1.3-5-1.4c-1.6,0-3.1,0.2-4.3,0.7\r\n\t\t\t\tc0-1.4-0.7-2.9-1.8-4.1s-2.8-1.9-4.2-1.8c0.6-1.1,0.7-2.7,0.5-4.3s-0.9-3.1-1.8-4c1.3-0.5,2.7-1.6,3.9-3.1c0.9-1.1,1.6-2.4,2-3.5\r\n\t\t\t\tc1.8,1.1,5.4,2.7,9,0.9c0.7,0.3,3.5,1.1,6.4-0.6c0.1-0.1,0.2-0.2,0.2-0.4s-0.1-0.3-0.3-0.3c0,0-3.4-0.7-4.7-2.2\r\n\t\t\t\tc-0.3-0.3-3.1-3.3-6.7-3.3c-1.9,0-3.6,0.7-5.1,2.2c-1.5-0.1-3.6,1.2-5.4,3.4c-1.9,2.4-2.7,4.8-2.1,6.2c-1.4,0.7-2.2,3-1.8,5.7\r\n\t\t\t\tc0.4,2.5,1.7,4.5,3.2,4.9c-1,1.6-0.4,4.1,1.4,5.9c1.5,1.5,3.5,2.1,5.1,1.7c0.4,1.8,3.1,3.3,6.5,3.4c3.1,0.1,5.8-1,6.6-2.6\r\n\t\t\t\tc1.6,1,4.1,0.4,5.9-1.4c1.2-1.2,1.9-2.7,1.9-4c2.6,0.3,6.7-1.4,10.8-4.4l1.3,1.2c-0.1,0.6-0.3,2.3-0.3,3.2\r\n\t\t\t\tc-0.5,0.6-2.8,3.3-3.2,4.5c-0.4,1.3,0.2,6.4,0.2,7c0,0.2,0.2,0.3,0.4,0.3c0.1,0,0.2,0,0.3-0.1c0.1-0.1,0.1-0.1,0.1-0.2l1.4-5.5\r\n\t\t\t\tc0.6-0.5,3.6-2.8,4.2-4.6v-0.1c0-0.5,0.3-4.7-0.2-5.9c0,0,0-0.1-0.1-0.1l-1.6-1.7c0.5-0.4,0.9-0.8,1.4-1.2l1.1,1\r\n\t\t\t\tc0,0.8-0.1,4.4,0.2,5.6c0.3,1.3,4.2,1.4,6.2,1.3l0.4,4.4c0,0.2,0.1,0.3,0.3,0.3c0.1,0,0.2,0,0.3-0.1l0.1-0.1\r\n\t\t\t\tc0.2-0.5,2.2-5.2,1.1-6.8c-0.9-1.4-4.3-1.1-5.7-0.9c0.1-1.2,0.2-4-0.2-4.8c0,0,0-0.1-0.1-0.1c0-0.1-0.8-1-1.7-1.8\r\n\t\t\t\tc0.4-0.5,0.8-0.9,1.3-1.4l1.1,1.2c0,1,0.1,4.5,0.5,5.3c0.6,1.1,5.7,1.1,6.8,1c0.5,0.5,2.6,2.4,4,4.2c0.1,0.1,0.3,0.2,0.5,0.1\r\n\t\t\t\tc0,0,0.1,0,0.1-0.1c0.1-0.1,0.1-0.2,0.1-0.4c0-0.1-1-3.8-3.2-6c-0.1-0.1-0.1-0.1-0.2-0.1s-3.2-0.8-5.2-0.6\r\n\t\t\t\tc-0.1-1.1-0.3-4.1-0.8-5c-0.3-0.7-1.1-1.5-1.8-2.1c0.3-0.5,0.7-0.9,1-1.4c0.6,0.5,1.3,1,1.7,1.3c-0.1,0.9-0.2,4,0.8,5.5\r\n\t\t\t\tc0,0.1,0.1,0.1,0.2,0.2c0.2,0.1,4.1,1.4,6.9,0.7c0,0,0.1,0,0.1-0.1c0.1-0.1,2.4-1.6,3.9-3.2c0.6-0.6,1.1-1.2,1.3-1.7\r\n\t\t\t\tc0.1-0.1,0-0.3-0.1-0.4c-0.1-0.1-0.3-0.1-0.4-0.1c-0.1,0.1-3.2,1.4-4.9,2.6c-0.6-0.1-2.7-0.5-4.3-0.4c0-1-0.2-3.5-0.8-4.9\r\n\t\t\t\tc0-0.1-0.1-0.1-0.1-0.1c-1.3-1.2-2.1-1.9-2.6-2.3c0.2-0.5,0.5-0.9,0.6-1.4c1,0.3,2.7,0.4,4.8-0.7c0.7,1,3,4.1,6.4,5.5\r\n\t\t\t\tc1.7,0.7,4.3,0.1,6.6-1.5c0.5-0.3,1.1-0.8,1.7-1.5c2.5-2.5,5.8-7.6,5.1-16.6c0-0.2-0.1-0.3-0.3-0.3\r\n\t\t\t\tC361.9,896.2,361.8,896.3,361.6,896.5L361.6,896.5z M332.5,899.9c0.1-0.2,0-0.4-0.1-0.5c0,0-4-2.5-5.6-6.2\r\n\t\t\t\tc-0.6-1.4-0.1-3.7,1.4-5.8c3.1-4.3,8.9-6.7,15.9-6.6c-1.5,0.7-3.7,1.8-4.8,2.9c-0.1,0.1-0.1,0.3-0.1,0.4c0.1,0.1,0.2,0.2,0.4,0.2\r\n\t\t\t\tl6.4-0.6c-1.2,0.8-3.3,2.1-6.1,2.6c-0.1,0-0.3,0.1-0.3,0.3c0,0.1-2,6.8-7.1,8c-0.1,0-0.3,0.1-0.3,0.3c0,0.1,0,0.3,0.1,0.4\r\n\t\t\t\tc0.6,0.5,2.2,1.9,2.5,3c0.1,0.7-0.4,2.3-0.9,3.6c-0.3,0.9-0.6,1.6-0.7,2.1c-0.5,0.1-1.1,0.3-1.6,0.5\r\n\t\t\t\tC331.4,903.6,331.3,902,332.5,899.9L332.5,899.9z M325.5,904.5c0,0-3.6,0.3-5.2-0.6c-0.2-0.7-1.2-3.9-0.7-6.2\r\n\t\t\t\tc0.7-0.9,2.2-3,3.5-4.2c-0.5,1.1-1.3,2.7-2.1,3.6c-0.1,0.1-0.1,0.2-0.1,0.3c0,0,0.7,2.9,0.3,4.5c0,0.1,0,0.2,0.1,0.3\r\n\t\t\t\ts0.2,0.1,0.3,0.1c0,0,3.4,0,5,0.7c0.7,0.8,1.7,1.9,2.3,2.5c-0.5,0.3-1.1,0.6-1.6,0.9c-0.7-0.8-1.4-1.7-1.5-2\r\n\t\t\t\tC325.8,904.5,325.6,904.4,325.5,904.5L325.5,904.5z M321.9,908.1c-0.1-0.1-0.2-0.1-0.3-0.1c-1.7,0-4.6-0.1-5.1-0.4\r\n\t\t\t\tc-0.6-0.4-0.8-5.1-0.6-6.2c0-0.1,0-0.2-0.1-0.3s-1.3-1.5-2.8-2.8c1.2,0.5,2.6,1.2,3.7,2.2c0.1,0.6,0.9,3.5,0.5,5.1\r\n\t\t\t\tc0,0.1,0,0.2,0.1,0.3s0.2,0.1,0.3,0.1c1.2,0.1,4.4,0.3,5.2,0.7c0.6,0.3,1.4,1,2,1.7c-0.4,0.3-0.9,0.7-1.3,1L321.9,908.1\r\n\t\t\t\tL321.9,908.1z M318.3,911.4c0,0-4.4,0.1-5.6-0.2c-0.5-0.1-0.9-2.8-0.7-5.8c0-0.2-0.1-0.4-0.3-0.4l-3.1-0.3\r\n\t\t\t\tc1.8-0.6,3.8-1.1,4.6-0.6c1,0.6,0.8,3.6,0.5,5.3c0,0.1,0,0.2,0.1,0.3s0.2,0.1,0.3,0.1c1.5-0.1,4.2-0.2,4.9,0.1\r\n\t\t\t\tc0.2,0.2,1.1,0.9,1.8,1.7c-0.4,0.3-0.7,0.7-1.1,1.1l-1.2-1.3C318.5,911.5,318.4,911.4,318.3,911.4L318.3,911.4z M314.7,915\r\n\t\t\t\tc-0.7,0.1-2.6,0.4-3.4,0.3c-0.1,0-0.2,0-0.3,0.1c-0.9,0.8-3.4,2.9-4.4,3.2c-0.6,0.2-2.6,0.1-4.5,0l3.6-0.9c0.1,0,0.2-0.1,0.2-0.1\r\n\t\t\t\ts2.5-3.3,4.3-4c1.3-0.1,4.5-0.2,5.5,0.1l1.8,1.7c0,0,0,0,0,0.1c-0.4,0.4-0.7,0.8-1,1.3l-1.4-1.5C315,915,314.8,915,314.7,915\r\n\t\t\t\tL314.7,915z M328.7,926.5c0.3,1,0.2,4.2,0.1,5.5c-0.7,1.8-4,4.3-4,4.3c-0.1,0.1-0.1,0.1-0.1,0.2l-0.9,3.5c-0.2-1.9-0.3-3.9,0-4.5\r\n\t\t\t\tc0.3-1,2.4-3.5,3.2-4.4c0.1-0.1,0.1-0.2,0.1-0.3c-0.1-1,0.3-3.4,0.3-3.4c0-0.1,0-0.3-0.1-0.3l-1.4-1.2c0.4-0.3,0.8-0.7,1.3-1\r\n\t\t\t\tc0,0,0,0,0.1,0L328.7,926.5L328.7,926.5z M332.2,923.2c0.3,0.7,0.2,3.4,0.1,4.9c0,0.1,0,0.2,0.1,0.3s0.2,0.1,0.3,0.1\r\n\t\t\t\tc1.8-0.3,4.8-0.4,5.4,0.5c0.5,0.7,0,2.8-0.6,4.6l-0.3-3.1c0-0.2-0.2-0.4-0.4-0.3c-3,0.1-5.7-0.2-5.8-0.7\r\n\t\t\t\tc-0.3-1.2-0.2-5.5-0.2-5.5c0-0.1,0-0.2-0.1-0.3l-1.2-1.1c0.1-0.1,0.3-0.3,0.4-0.4c0.2-0.2,0.4-0.4,0.6-0.7\r\n\t\t\t\tC331.4,922.2,332.1,923,332.2,923.2L332.2,923.2z M335.5,919.5c0.4,0.9,0.7,4,0.7,5.2c0,0.1,0.1,0.2,0.1,0.3\r\n\t\t\t\tc0.1,0.1,0.2,0.1,0.3,0.1c1.6-0.3,4.6,0.4,5.2,0.5c1,1.1,1.8,2.5,2.2,3.7c-1.4-1.5-2.8-2.7-2.8-2.8c-0.1-0.1-0.2-0.1-0.3-0.1\r\n\t\t\t\tc-1.1,0.1-5.8-0.1-6.2-0.6c-0.3-0.6-0.4-3.4-0.4-5.1c0-0.1,0-0.2-0.1-0.3L333,919c0.4-0.4,0.7-0.9,1.1-1.3\r\n\t\t\t\tC334.6,918.3,335.3,919,335.5,919.5L335.5,919.5z M339.2,915.6c0.7,1.6,0.8,5,0.8,5c0,0.1,0.1,0.2,0.1,0.3\r\n\t\t\t\tc0.1,0.1,0.2,0.1,0.3,0.1c1.7-0.3,4.5,0.3,4.6,0.3s0.2,0,0.3-0.1c0.9-0.7,2.5-1.6,3.6-2.1c-1.2,1.3-3.2,2.8-4.2,3.5\r\n\t\t\t\tc-2.3,0.5-5.6-0.4-6.3-0.7c-0.8-1.6-0.6-5.2-0.6-5.2c0-0.2-0.1-0.3-0.2-0.4c-0.3-0.1-1.1-0.7-1.8-1.4c0.3-0.5,0.6-1.1,0.9-1.6\r\n\t\t\t\tC337.5,914.1,338.5,915,339.2,915.6L339.2,915.6z M337.1,911.1c-0.2,0.4-0.3,0.7-0.5,1.1c-0.1,0.2-0.2,0.5-0.4,0.7\r\n\t\t\t\tc-0.3,0.5-0.6,1-0.9,1.6c-0.1,0.2-0.3,0.4-0.4,0.6c-0.3,0.4-0.6,0.9-0.9,1.4c-0.1,0.2-0.3,0.4-0.5,0.6c-0.3,0.4-0.7,0.8-1,1.3\r\n\t\t\t\tc-0.2,0.2-0.3,0.4-0.5,0.6c-0.4,0.5-0.8,1-1.3,1.4c-0.2,0.2-0.4,0.4-0.5,0.6c-0.3,0.4-0.7,0.7-1.1,1.1c-0.2,0.2-0.4,0.4-0.6,0.5\r\n\t\t\t\tc-0.4,0.4-0.9,0.8-1.3,1.2c-0.2,0.2-0.4,0.3-0.6,0.5l0,0c-0.5,0.4-0.9,0.7-1.4,1.1c-0.2,0.2-0.4,0.3-0.6,0.5\r\n\t\t\t\tc-4.2,3.1-8.2,4.7-10.6,4.1c-0.1,0-0.3,0-0.4,0.1l0,0c-0.1,0.1-0.1,0.2-0.1,0.3c0.1,1.3-0.5,2.8-1.6,3.9\r\n\t\t\t\tc-1.7,1.7-4.1,2.2-5.3,1.1c-0.1-0.1-0.2-0.1-0.4-0.1c-0.1,0-0.2,0.1-0.3,0.3c-0.3,1.5-2.9,2.6-6,2.5c-3.2-0.1-5.9-1.5-5.8-3.1\r\n\t\t\t\tc0-0.1-0.1-0.3-0.2-0.3s-0.3-0.1-0.4,0c-1.4,0.6-3.3,0.1-4.8-1.4c-1.7-1.7-2.1-4.1-0.9-5.4c0.1-0.1,0.1-0.3,0.1-0.4\r\n\t\t\t\tc-0.1-0.1-0.2-0.2-0.4-0.2c-1.4,0.1-2.8-1.8-3.2-4.3c-0.4-2.4,0.4-4.7,1.7-5c0.1,0,0.2-0.1,0.3-0.3c0-0.1,0-0.3-0.1-0.4\r\n\t\t\t\tc-0.7-0.8-0.2-3.2,1.9-5.7c1.8-2.3,3.9-3.3,4.9-3.1c0.1,0,0.3,0,0.3-0.1c1.4-1.4,3-2.1,4.7-2.1c2.7,0.1,5.1,2,6.2,3.1\r\n\t\t\t\tc1,1.1,2.9,1.8,4.1,2.1c-2.6,1-4.9,0.1-4.9,0c-0.1,0-0.2,0-0.3,0c-3.6,1.9-7.3-0.1-8.8-1.1c-0.1-0.1-0.2-0.1-0.4,0\r\n\t\t\t\tc-0.1,0-0.2,0.1-0.2,0.3c-0.3,1.1-1,2.5-2,3.7c-1.3,1.6-2.9,2.8-4.1,3.1c-0.1,0-0.3,0.1-0.3,0.3c0,0.1,0,0.3,0.2,0.4\r\n\t\t\t\tc1,0.7,1.8,2.2,2.1,4c0.3,1.8,0,3.4-0.8,4.4c-0.1,0.1-0.1,0.3,0,0.4c0.1,0.1,0.3,0.2,0.4,0.2c1.4-0.3,3,0.3,4.3,1.5\r\n\t\t\t\tc1.2,1.2,1.8,2.8,1.6,4.1c0,0.1,0,0.3,0.2,0.4c0.1,0.1,0.3,0.1,0.4,0c1.2-0.7,2.8-1,4.6-1c2.1,0.1,4,0.7,5,1.6\r\n\t\t\t\tc0.1,0.1,0.3,0.1,0.4,0.1c0.1-0.1,0.2-0.2,0.2-0.3c0-1.2,0.6-2.5,1.7-3.6c1.3-1.3,2.9-1.9,4.3-1.6c0.1,0,0.3,0,0.4-0.1\r\n\t\t\t\ts0.1-0.2,0.1-0.3c-0.4-2.4,1.3-6.2,4.2-10.2c0.1-0.2,0.3-0.4,0.5-0.6c0.4-0.5,0.7-0.9,1.1-1.4l0,0c0.2-0.2,0.3-0.4,0.5-0.6\r\n\t\t\t\tc0.4-0.4,0.8-0.9,1.2-1.3c0.2-0.2,0.4-0.4,0.5-0.5c0.4-0.4,0.7-0.7,1.1-1c0.2-0.2,0.4-0.4,0.6-0.5c0.5-0.5,1-0.9,1.5-1.3\r\n\t\t\t\tc0.2-0.2,0.4-0.3,0.6-0.5c0.4-0.3,0.8-0.7,1.3-1c0.2-0.2,0.4-0.3,0.6-0.5c0.5-0.3,0.9-0.6,1.4-0.9c0.2-0.1,0.4-0.3,0.6-0.4\r\n\t\t\t\tc0.5-0.3,1.1-0.6,1.6-0.9c0.2-0.1,0.5-0.2,0.7-0.4c0.4-0.2,0.7-0.3,1.1-0.5c0.2-0.1,0.5-0.2,0.7-0.3c0.4-0.2,0.9-0.3,1.3-0.4\r\n\t\t\t\tc0.3-0.1,0.5-0.1,0.8-0.1c0.2,0,0.4-0.1,0.6-0.1c1.1,0,1.9,0.2,2.5,0.8s0.8,1.4,0.8,2.5c0,0.2,0,0.3,0,0.5c0,0.3-0.1,0.5-0.1,0.8\r\n\t\t\t\tc-0.1,0.4-0.2,0.9-0.4,1.3C337.2,910.6,337.1,910.9,337.1,911.1L337.1,911.1z M355.1,914.1c-2.1,1.5-4.4,2-5.8,1.4\r\n\t\t\t\tc-3.7-1.6-6.2-5.5-6.2-5.5c-0.1-0.2-0.3-0.2-0.5-0.1c-1.9,1.1-3.5,1.1-4.4,0.8c0.2-0.6,0.4-1.2,0.5-1.7c0.5-0.1,1.2-0.4,2-0.6\r\n\t\t\t\tc1.3-0.5,2.9-1,3.6-0.9c1.1,0.2,2.5,1.8,3,2.4c0.1,0.1,0.2,0.2,0.4,0.1c0.1,0,0.3-0.1,0.3-0.3c1.2-5.1,8-7,8.1-7s0.3-0.2,0.3-0.3\r\n\t\t\t\tc0.4-2.8,1.7-4.9,2.6-6.1l-0.6,6.4c0,0.2,0.1,0.3,0.2,0.4s0.3,0,0.4-0.1c1-1.1,2.2-3.3,2.9-4.7\r\n\t\t\t\tC361.8,905.2,359.4,911,355.1,914.1L355.1,914.1z\"/>\r\n\t\t\t<path fill=\"#E04C00\" d=\"M314.3,923.7c-0.1,0.1-0.1,0.4,0,0.5l3.6,3.6c0.1,0.1,0.4,0.1,0.5,0s0.1-0.4,0-0.5l-3.6-3.6\r\n\t\t\t\tC314.7,923.5,314.5,923.5,314.3,923.7z\"/>\r\n\t\t\t<path fill=\"#E04C00\" d=\"M316.7,920c-0.1,0.1-0.1,0.4,0,0.5l5,5c0.1,0.1,0.4,0.1,0.5,0s0.1-0.4,0-0.5l-5-5\r\n\t\t\t\tC317.1,919.8,316.8,919.8,316.7,920z\"/>\r\n\t\t\t<path fill=\"#E04C00\" d=\"M319.4,916.2c-0.1,0.1-0.1,0.4,0,0.5l6.1,6c0.1,0.1,0.4,0.1,0.5,0s0.1-0.4,0-0.5l-6.1-6\r\n\t\t\t\tC319.8,916.1,319.5,916.1,319.4,916.2z\"/>\r\n\t\t\t<path fill=\"#E04C00\" d=\"M322.2,912.9c-0.1,0.1-0.1,0.4,0,0.5l6.6,6.6c0.1,0.1,0.4,0.1,0.5,0s0.1-0.4,0-0.5l-6.6-6.6\r\n\t\t\t\tC322.6,912.7,322.4,912.7,322.2,912.9z\"/>\r\n\t\t\t<path fill=\"#E04C00\" d=\"M325.9,910c-0.1,0.1-0.1,0.4,0,0.5l5.8,5.8c0.1,0.1,0.4,0.1,0.5,0s0.1-0.4,0-0.5l-5.8-5.8\r\n\t\t\t\tC326.3,909.8,326.1,909.8,325.9,910z\"/>\r\n\t\t\t<path fill=\"#E04C00\" d=\"M329.4,907.9c-0.1,0.1-0.1,0.4,0,0.5l4.4,4.4c0.1,0.1,0.4,0.1,0.5,0s0.1-0.4,0-0.5l-4.4-4.4\r\n\t\t\t\tC329.8,907.8,329.5,907.8,329.4,907.9z\"/>\r\n\t\t\t<g id=\"stars_00000007419245438642412430000000212573308425023145_\">\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M294.1,925.8L294.1,925.8c-0.6,0.2-1.1,0.8-1.1,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.8-1.7-0.6l0,0c0.4-0.5,0.4-1.3,0-1.8l0,0c0.6,0.2,1.3,0,1.7-0.6l0,0C293,925,293.5,925.6,294.1,925.8\r\n\t\t\t\t\tL294.1,925.8L294.1,925.8z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M355.9,891.6L355.9,891.6c-0.6,0.2-1.1,0.8-1.1,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.8-1.7-0.6l0,0c0.4-0.5,0.4-1.3,0-1.8l0,0c0.6,0.2,1.3,0,1.7-0.6l0,0C354.8,890.8,355.2,891.4,355.9,891.6\r\n\t\t\t\t\tL355.9,891.6L355.9,891.6z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M356.1,899.3L356.1,899.3c-0.6,0.2-1.1,0.8-1.1,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.8-1.7-0.6l0,0l0,0c0.4-0.5,0.4-1.3,0-1.8l0,0l0,0c0.6,0.2,1.3,0,1.7-0.6l0,0C355,898.5,355.4,899.1,356.1,899.3\r\n\t\t\t\t\tL356.1,899.3L356.1,899.3z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M323.7,917.4L323.7,917.4c-0.6,0.2-1.1,0.8-1.1,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.8-1.7-0.6l0,0c0.4-0.5,0.4-1.3,0-1.8l0,0c0.6,0.2,1.3,0,1.7-0.6l0,0C322.7,916.6,323.1,917.1,323.7,917.4\r\n\t\t\t\t\tL323.7,917.4L323.7,917.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M323.2,936.9L323.2,936.9c-0.6,0.2-1.1,0.8-1.1,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.8-1.7-0.6l0,0c0.4-0.5,0.4-1.3,0-1.8l0,0c0.6,0.2,1.3,0,1.7-0.6l0,0C322.2,936.1,322.6,936.7,323.2,936.9\r\n\t\t\t\t\tL323.2,936.9L323.2,936.9z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M308.4,927L308.4,927c-0.2,0.6,0,1.3,0.6,1.7l0,0\r\n\t\t\t\t\tc-0.7,0-1.2,0.4-1.4,1.1l0,0c-0.2-0.6-0.8-1-1.5-1l0,0c0.5-0.4,0.7-1.1,0.5-1.7l0,0C307.1,927.4,307.8,927.4,308.4,927\r\n\t\t\t\t\tL308.4,927z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M302.4,932.7L302.4,932.7c-0.6,0.3-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.8-0.4l0,0c0.3-0.6,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.7-0.7l0,0C301.3,932,301.8,932.6,302.4,932.7\r\n\t\t\t\t\tL302.4,932.7L302.4,932.7z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M353,885.9L353,885.9c-0.6,0.3-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.8-0.4l0,0c0.3-0.6,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.7-0.7l0,0C351.9,885.2,352.4,885.8,353,885.9\r\n\t\t\t\t\tL353,885.9L353,885.9z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M344.1,896.2L344.1,896.2c-0.6,0.3-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.8-0.4l0,0c0.3-0.6,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.7-0.7l0,0C343,895.5,343.5,896.1,344.1,896.2\r\n\t\t\t\t\tL344.1,896.2L344.1,896.2z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M324.1,927.1L324.1,927.1c-0.6,0.3-1,0.9-0.9,1.5l0,0l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.8-0.4l0,0c0.3-0.6,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.7-0.7l0,0C323,926.3,323.5,926.9,324.1,927.1\r\n\t\t\t\t\tL324.1,927.1L324.1,927.1z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M345,884.5L345,884.5c-0.6,0.3-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.8-0.4l0,0c0.3-0.6,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.7-0.7l0,0C343.9,883.8,344.4,884.4,345,884.5\r\n\t\t\t\t\tL345,884.5L345,884.5z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M354.3,907.1L354.3,907.1c-0.6,0.3-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.8-0.4l0,0c0.3-0.6,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.7-0.7l0,0C353.2,906.4,353.7,906.9,354.3,907.1\r\n\t\t\t\t\tL354.3,907.1L354.3,907.1z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M314.3,940.1L314.3,940.1c-0.6,0.3-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.8-0.4l0,0c0.3-0.6,0.3-1.3-0.1-1.8l0,0l0,0c0.6,0.1,1.3-0.1,1.7-0.7l0,0C313.2,939.4,313.7,940,314.3,940.1\r\n\t\t\t\t\tL314.3,940.1L314.3,940.1z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M295.5,938.1L295.5,938.1c-0.3,0.6-0.2,1.3,0.3,1.8l0,0\r\n\t\t\t\t\tc-0.7-0.1-1.3,0.2-1.6,0.8l0,0c-0.1-0.7-0.6-1.2-1.3-1.3l0,0c0.6-0.3,0.9-0.9,0.8-1.6l0,0C294.2,938.3,294.9,938.4,295.5,938.1\r\n\t\t\t\t\tL295.5,938.1z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M304.9,921.7L304.9,921.7c-0.4,0.5-0.4,1.3,0,1.8l0,0\r\n\t\t\t\t\tc-0.6-0.2-1.3,0-1.7,0.6l0,0c0-0.7-0.4-1.2-1.1-1.4l0,0c0.6-0.2,1.1-0.8,1.1-1.5l0,0C303.6,921.6,304.3,921.9,304.9,921.7\r\n\t\t\t\t\tL304.9,921.7z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M338.5,897.2L338.5,897.2c-0.4,0.5-0.4,1.3,0,1.8l0,0\r\n\t\t\t\t\tc-0.6-0.2-1.3,0-1.7,0.6l0,0c0-0.7-0.4-1.2-1.1-1.4l0,0c0.6-0.2,1.1-0.8,1.1-1.5l0,0C337.1,897.2,337.8,897.4,338.5,897.2\r\n\t\t\t\t\tL338.5,897.2z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M331.5,900.7L331.5,900.7c-0.4,0.5-0.4,1.3,0,1.8l0,0\r\n\t\t\t\t\tc-0.6-0.2-1.3,0-1.7,0.6l0,0c0-0.7-0.4-1.2-1.1-1.4l0,0c0.6-0.2,1.1-0.8,1.1-1.5l0,0C330.2,900.6,330.9,900.9,331.5,900.7\r\n\t\t\t\t\tL331.5,900.7z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M305.3,943.3L305.3,943.3c-0.4,0.5-0.4,1.3,0,1.8l0,0\r\n\t\t\t\t\tc-0.6-0.2-1.3,0-1.7,0.6l0,0c0-0.7-0.4-1.2-1.1-1.4l0,0c0.6-0.2,1.1-0.8,1.1-1.5l0,0C304,943.3,304.7,943.5,305.3,943.3\r\n\t\t\t\t\tL305.3,943.3z\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"304.2,944.4 304.1,944.3 294.2,939.4 300.8,932.9 \r\n\t\t\t\t\t307.4,928.2 303.6,922.7 292.6,925.9 292.5,925.5 303.7,922.3 307.9,928.3 301.1,933.2 294.8,939.3 304.2,944 312.9,940.1 \r\n\t\t\t\t\t321.6,936.7 322.4,927.1 322,917.3 322.1,917.3 330.2,901.4 336.9,898.2 342.3,896.2 343.3,884.6 351.7,885.7 354.6,891.5 \r\n\t\t\t\t\t354.3,891.6 351.4,886 343.6,885 342.6,896.5 337.1,898.5 330.5,901.6 322.4,917.4 322.8,927.1 322,937 313,940.4 \t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"352.9,907.5 342.3,896.5 342.5,896.2 352.7,906.8 \r\n\t\t\t\t\t354.3,899.2 354.6,899.2 \t\t\t\t\"/>\r\n\t\t\t</g>\r\n\t\t</g>\r\n\t\t<g id=\"CAPRICORN\">\r\n\t\t\t<path fill=\"#F63184\" d=\"M126.2,658.7c-0.1-0.1-0.2-0.2-0.3-0.2h-5.2c-0.1-1.8-0.8-12.8-8.9-12.8H96.3c0,0-5-0.1-9.2-1.9\r\n\t\t\t\tc-0.1-0.1-0.3,0-0.4,0.1s-0.1,0.3,0,0.4c0.1,0.2,2,3.3,5.5,5c-3.8-0.3-7.2-1.8-7.2-1.8c-0.2-0.1-0.4,0-0.5,0.1s-0.1,0.3,0,0.5\r\n\t\t\t\tc5.1,6,11,5.5,11.2,5.5h11.7c2,0,3.5,0.5,4.4,1.4c0.5,0.6,0.8,1.2,0.9,1.6c-3.4-2.2-7.1-3-10.6-2.3c-0.3,0.1-0.7,0.2-1,0.3H101\r\n\t\t\t\tc-2.4,0-4.7,0.3-7.1,0.6c-1.5,0.2-3.1,0.6-4.5,1.3c-1.6,0.8-2.7,2.1-3.2,3.5c-0.4,1.2-0.2,2.5,0.4,3.3c-0.5,0.3-0.9,0.7-1.3,1.2\r\n\t\t\t\tc-1.3,1.3-1.9,2.9-1.9,4.4c0,0.7,0.2,1.3,0.5,1.9c-0.2,0.1-0.4,0.2-0.6,0.3c-1.6,0.9-2.7,2.2-3.1,3.6c-0.4,1.4-0.1,2.8,0.8,3.6\r\n\t\t\t\tc0.6,0.5,1.4,0.9,2.2,0.9h0.1c0.2,0,0.5,0,0.7-0.1c-4,2.6-10.7,4.2-11.9,4.4c-0.8-0.7-1.5-1.4-2.1-2c-0.7-0.7-1.3-1.2-1.8-1.7\r\n\t\t\t\tc-2.5-2.5-3.5-6.4-3.7-8c0.4,0,0.8,0.1,1.2,0.1c6.2,0,11.5-4.4,12.6-10.5c0-0.2-0.1-0.4-0.3-0.4c-1.1-0.3-2.3-0.5-3.4-0.5\r\n\t\t\t\tc-4.9,0-9.3,2.8-11.4,7c-2.1-4.2-6.5-7-11.4-7c-1.2,0-2.3,0.2-3.4,0.5c-0.2,0.1-0.3,0.2-0.3,0.4c1.1,6.1,6.4,10.5,12.6,10.5\r\n\t\t\t\tc0.4,0,0.7,0,1,0c-0.4,1.6-1.5,6.5-0.1,10.8c0.4,1.2,1.2,2.5,2.1,3.8c-4.8,1.8-8.3,6.5-8.3,11.9c0,7,5.7,12.7,12.8,12.7\r\n\t\t\t\tc5.5,0,10.2-3.4,12-8.3c10.1,1.9,17.9-2.5,19.2-3.3c1.8,0.8,3.6,0.2,4.4-0.1c0.6,0.7,2.2,2.8,3.2,4.2c0.3,0.4,0.4,0.7,0.3,1.1\r\n\t\t\t\tc-0.2,0.6-0.9,1.1-1.2,1.2H97l-2-2.4c-0.1-0.1-0.2-0.1-0.3-0.1c-0.1,0-0.2,0-0.3,0.1l-3.4,3.2c-0.1,0.1-0.2,0.4,0,0.5\r\n\t\t\t\tc0,0,1.1,1.3,2.4,2.6c1.4,1.5,4.3,1.6,4.4,1.6h8.9c0.1,0,3.7-0.5,5.4-4.2c1.6-3.7-0.3-6.9-0.4-7l-6.2-9c0.1-0.2,0.3-0.5,0.4-0.8\r\n\t\t\t\th8.6c0.1,0,0.7,0.1,0.7,0.8v5.1l-2.5,3c-0.1,0.2-0.1,0.4,0,0.5l3.8,3.4c0.1,0.1,0.2,0.1,0.3,0.1l0,0c0.1,0,0.2-0.1,0.3-0.1\r\n\t\t\t\tl3.5-3.9c0.1-0.1,0.1-0.2,0.1-0.3v-8c0-0.1-0.4-5.8-4.9-5.8h-8.9c0-0.5,0-0.8,0-0.9v-15.7c0,0,0-1.1,0.8-1.1s0.8,0.7,0.8,0.8v6.8\r\n\t\t\t\tc0,0.1,0,0.2,0.1,0.2c0.9,1.3,1.9,2,3.1,2.1c1.9,0.1,3.3-1.3,3.4-1.4l0.1-0.1l5.8-12.4c3.8-0.2,5.3-4.4,5.3-4.6\r\n\t\t\t\tC126.3,658.9,126.2,658.7,126.2,658.7L126.2,658.7z M88,644.9c4,1.4,8.1,1.5,8.3,1.5h15.5c7.4,0,8.1,10.3,8.2,12.1h-1.2\r\n\t\t\t\tc-1.1-9.7-8.5-9.1-8.5-9.1H94.6C91.4,648.7,89.1,646.3,88,644.9L88,644.9z M86.8,660.4c0.4-1.2,1.4-2.3,2.9-3.1\r\n\t\t\t\tc1.3-0.7,2.9-1,4.3-1.2c1.6-0.3,3.3-0.4,4.9-0.5c-1.9,0.9-3.6,2.3-4.9,4c-0.1,0.1-0.1,0.2-0.2,0.3c-0.3,0.3-0.5,0.7-0.7,1.1\r\n\t\t\t\tc-0.2,0.3-0.3,0.6-0.5,0.9c0-0.2,0-0.4-0.1-0.6v-0.1c-0.1-0.2-0.1-0.4-0.3-0.6c-0.4-0.7-1.2-1.3-2-1.3c-0.9,0-1.8,0.6-2,1.4\r\n\t\t\t\tc-0.1,0.5,0,1,0.3,1.4c0.1,0.1,0.1,0.2,0.2,0.2c0.3,0.2,0.6,0.3,0.9,0.3c0.2,0,0.4-0.2,0.4-0.4s-0.2-0.4-0.4-0.4c0,0,0,0-0.1,0\r\n\t\t\t\tc-0.2,0-0.3-0.1-0.5-0.3s-0.2-0.5-0.2-0.7c0.1-0.5,0.7-0.8,1.3-0.8c0.5,0,1.1,0.4,1.4,0.8c0.1,0.1,0.2,0.3,0.2,0.5\r\n\t\t\t\tc0,0.1,0,0.2,0.1,0.3c0.1,0.6-0.2,1.3-0.6,1.8c-0.5,0.5-1.3,0.8-2.2,0.8c-0.5,0-0.9-0.2-1.3-0.4c-0.1-0.1-0.3-0.2-0.4-0.3\r\n\t\t\t\ts-0.1-0.1-0.2-0.2C86.6,662.3,86.4,661.3,86.8,660.4L86.8,660.4z M83.9,669c0-1.3,0.6-2.7,1.7-3.8c0.4-0.4,0.9-0.8,1.3-1.1\r\n\t\t\t\tc0.5,0.4,1.2,0.7,1.9,0.7c0.1,0,0.2,0,0.3,0c0.9,0,1.8-0.3,2.4-0.9c-0.6,1.5-1.1,3-1.7,4.6v0.1c-0.1-0.3-0.2-0.5-0.4-0.8\r\n\t\t\t\tc-0.6-0.9-1.8-1.3-2.8-1c-0.9,0.3-1.5,1.1-1.5,2c0,0.5,0.3,0.9,0.7,1.2c0.1,0,0.1,0.1,0.2,0.1c0.3,0.2,0.7,0.2,1,0.1\r\n\t\t\t\tc0.2-0.1,0.2-0.2,0.3-0.3v-0.1c-0.1-0.2-0.3-0.3-0.5-0.2s-0.4,0-0.6-0.1s-0.4-0.4-0.4-0.6c0-0.5,0.4-1,0.9-1.2\r\n\t\t\t\tc0.7-0.2,1.5,0.1,1.9,0.7c0.2,0.4,0.4,0.8,0.3,1.3c0,0.3-0.1,0.5-0.2,0.8v0.1c-0.3,0.7-1,1.2-1.8,1.4c-0.6,0.2-1.3,0.1-1.8-0.1\r\n\t\t\t\tc-0.2-0.1-0.4-0.2-0.5-0.4c-0.2-0.2-0.4-0.4-0.5-0.6C84.1,670.1,83.9,669.6,83.9,669L83.9,669z M82.9,678.6\r\n\t\t\t\tc-0.7,0-1.3-0.3-1.7-0.7c-0.7-0.7-0.9-1.8-0.6-2.9c0.4-1.3,1.3-2.4,2.8-3.2c0.2-0.1,0.4-0.2,0.7-0.3c0.3,0.3,0.6,0.6,0.9,0.7\r\n\t\t\t\tc0.4,0.2,0.9,0.3,1.5,0.3c0.3,0,0.6,0,0.9-0.1c0.5-0.1,0.9-0.3,1.3-0.6c-0.7,1.8-1.4,3.4-2.2,4.8c0.1-0.4,0-0.8-0.1-1.2\r\n\t\t\t\tc-0.3-1-1.3-1.8-2.4-1.8c-1,0-1.8,0.6-2,1.4c-0.1,0.5,0,1,0.4,1.4c0.3,0.4,0.7,0.6,1.2,0.5c0.2,0,0.4-0.2,0.4-0.4\r\n\t\t\t\ts-0.2-0.4-0.4-0.4c-0.2,0-0.4-0.1-0.5-0.3c-0.2-0.2-0.3-0.5-0.2-0.7c0.1-0.5,0.7-0.9,1.2-0.9l0,0c0.7,0,1.4,0.5,1.6,1.3\r\n\t\t\t\tc0.2,0.7,0,1.5-0.5,2.1C84.5,678.3,83.7,678.6,82.9,678.6L82.9,678.6z M60.2,671.3c-5.7,0-10.6-4-11.8-9.5\r\n\t\t\t\tc0.9-0.2,1.9-0.3,2.9-0.3c4.9,0,9.1,2.9,11,7.1c0.2,0.3,0.3,0.7,0.4,1.1c0.1-0.4,0.3-0.7,0.4-1.1c1.9-4.3,6.2-7.1,11-7.1\r\n\t\t\t\tc1,0,1.9,0.1,2.9,0.3c-1.2,5.5-6.1,9.5-11.8,9.5c-0.4,0-0.9,0-1.3-0.1c0,0,0,0-0.1,0c-0.2,0-0.4-0.1-0.6-0.1\r\n\t\t\t\tc-0.2,0-0.4-0.1-0.6-0.1c-0.3,0.1-0.6,0.1-0.9,0.2c-0.1,0-0.1,0-0.2,0c0,0,0,0-0.1,0C61.1,671.2,60.7,671.2,60.2,671.3\r\n\t\t\t\tL60.2,671.3z M67.8,710.5c-6.6,0-12-5.4-12-12c0-5.2,3.3-9.6,8-11.3c1,1.3,2.2,2.6,3.3,3.9c0.9,1,1.8,2,2.5,3\r\n\t\t\t\tc-0.6-0.2-1.1-0.3-1.8-0.3c-2.6,0-4.7,2.1-4.7,4.7s2.1,4.7,4.7,4.7s4.7-2.1,4.7-4.7c0-0.1,0-0.2,0-0.4V698c0-0.4-0.1-0.8-0.3-1.2\r\n\t\t\t\tc-0.1-0.2-0.2-0.4-0.3-0.7c-0.9-1.6-2.5-3.4-4.3-5.5c-1.1-1.2-2.1-2.5-3.1-3.7c-0.2-0.2-0.3-0.4-0.5-0.7c-1-1.3-1.8-2.6-2.2-3.8\r\n\t\t\t\tc-1.4-4.3-0.1-9.4,0.2-10.6c0.2,0,0.4-0.1,0.7-0.1c0.2,0,0.4,0.1,0.6,0.1c0.2,1.5,1.2,5.9,4,8.7c0.5,0.5,1.1,1.1,1.9,1.7\r\n\t\t\t\tc1.6,1.5,3.6,3.3,5.5,5.4c0.9,1,1.8,2.2,2.6,3.3c1.5,2.3,2.5,4.7,2.6,7.2c0,0.1,0,0.1,0,0.1v0.1C79.8,705,74.4,710.4,67.8,710.5\r\n\t\t\t\tL67.8,710.5z M71.8,698.5c0,2.2-1.8,4-4,4s-4-1.8-4-4s1.8-4,4-4c1.5,0,2.7,0.8,3.4,1.9c0.1,0.2,0.2,0.4,0.3,0.5\r\n\t\t\t\tC71.7,697.4,71.8,697.9,71.8,698.5L71.8,698.5z M115.8,686c3.8,0,4.1,4.9,4.1,5.1v8l-3.2,3.5l-3.2-2.9l2.4-2.8\r\n\t\t\t\tc0.1-0.1,0.1-0.2,0.1-0.2v-5.3c0-1.1-0.9-1.5-1.5-1.5h-8.3c0.4-1.3,0.6-2.7,0.6-3.8L115.8,686L115.8,686z M120.6,662.8\r\n\t\t\t\tc-0.1,0-0.3,0.1-0.4,0.2l-5.9,12.5c-0.2,0.2-1.4,1.2-2.7,1.1c-0.9-0.1-1.7-0.6-2.4-1.6v-6.7c0-0.5-0.4-1.6-1.6-1.6\r\n\t\t\t\ts-1.5,1.2-1.6,1.8v15.7c0,0,0,4.8-1.4,6.8c-0.1,0.1-0.1,0.3,0,0.4l6.3,9.2c0,0,1.8,3,0.4,6.3c-1.4,3.2-4.4,3.7-4.8,3.8h-8.8\r\n\t\t\t\tc0,0-2.7-0.1-3.9-1.3c-0.9-1-1.8-1.9-2.1-2.3l2.9-2.7l1.8,2.2c0.1,0.1,0.2,0.1,0.3,0.1h8.9c0.1,0,0.1,0,0.2,0s1.3-0.6,1.7-1.7\r\n\t\t\t\tc0.2-0.6,0-1.1-0.4-1.7c-1.2-1.8-3.4-4.5-3.4-4.5c-0.1-0.1-0.3-0.2-0.5-0.1c0,0-2.3,1.2-4.1,0.1c-0.1-0.1-0.3-0.1-0.4,0\r\n\t\t\t\ts-8.1,5.3-18.7,3.3c0.4-1.2,0.6-2.4,0.6-3.7c0-3-1-5.7-2.7-7.9c-1.5-2.3-3.5-4.5-5.4-6.3c2.2-0.5,9.3-2.3,12.8-5.3\r\n\t\t\t\tc2.1-1.8,3.5-5.3,4.8-9c0.1-0.3,0.2-0.5,0.3-0.8c0.1-0.2,0.1-0.4,0.2-0.6c1.1-3.1,2.2-6.3,3.6-8.3c0.1-0.1,0.2-0.3,0.3-0.4\r\n\t\t\t\tc0.2-0.3,0.4-0.5,0.6-0.8c3.9-4.3,10.7-6.3,17.7-1.4c0.1,0.1,0.3,0.1,0.4,0s0.2-0.2,0.2-0.3s0.1-1.6-1.1-3\r\n\t\t\t\tc-1.1-1.1-2.7-1.7-5-1.7H95.6c-0.1,0-5,0.4-9.5-4.1c1.7,0.6,4.6,1.3,7.6,1.3h16.6c0.3,0,6.9-0.5,7.7,8.8c0,0.2,0.2,0.3,0.4,0.3\r\n\t\t\t\th6.9C124.8,660.4,123.3,662.8,120.6,662.8L120.6,662.8z\"/>\r\n\t\t\t<g id=\"stars\">\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M73.8,673.6L73.8,673.6c-0.6,0.2-1.1,0.8-1.1,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.8-1.7-0.6l0,0c0.4-0.5,0.4-1.3,0-1.8l0,0c0.6,0.2,1.3,0,1.7-0.6l0,0C72.8,672.8,73.2,673.3,73.8,673.6\r\n\t\t\t\t\tL73.8,673.6L73.8,673.6z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M63.5,669L63.5,669c-0.6,0.2-1.1,0.8-1.1,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.8-1.7-0.6l0,0c0.4-0.5,0.4-1.3,0-1.8l0,0l0,0c0.6,0.2,1.3,0,1.7-0.6l0,0l0,0C62.4,668.2,62.8,668.8,63.5,669\r\n\t\t\t\t\tL63.5,669L63.5,669z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M120.7,669.4L120.7,669.4c-0.6,0.2-1.1,0.8-1.1,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.8-1.7-0.6l0,0c0.4-0.5,0.4-1.3,0-1.8l0,0c0.6,0.2,1.3,0,1.7-0.6l0,0C119.6,668.6,120.1,669.2,120.7,669.4\r\n\t\t\t\t\tL120.7,669.4L120.7,669.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M113.8,670.6L113.8,670.6c-0.6,0.2-1.1,0.8-1.1,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.8-1.7-0.6l0,0c0.4-0.5,0.4-1.3,0-1.8l0,0c0.6,0.2,1.3,0,1.7-0.6l0,0C112.8,669.8,113.2,670.4,113.8,670.6\r\n\t\t\t\t\tL113.8,670.6L113.8,670.6z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M86.7,678.5L86.7,678.5c-0.6,0.3-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.8-0.4l0,0l0,0c0.4-0.6,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.7-0.7l0,0l0,0\r\n\t\t\t\t\tC85.5,677.8,86,678.3,86.7,678.5L86.7,678.5z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M55.3,667L55.3,667c-0.6,0.3-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.8-0.4l0,0c0.4-0.6,0.3-1.3-0.1-1.8l0,0l0,0c0.6,0.1,1.3-0.1,1.7-0.7l0,0C54.1,666.3,54.6,666.9,55.3,667\r\n\t\t\t\t\tL55.3,667z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M105.2,696.4L105.2,696.4c-0.6,0.3-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.8-0.4l0,0c0.4-0.6,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.7-0.7l0,0C104,695.7,104.5,696.3,105.2,696.4\r\n\t\t\t\t\tL105.2,696.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M72.9,689.8L72.9,689.8c-0.6,0.3-1,0.9-0.9,1.5l0,0l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.8-0.4l0,0c0.4-0.6,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.7-0.7l0,0C71.7,689.1,72.2,689.6,72.9,689.8\r\n\t\t\t\t\tL72.9,689.8z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M93.5,700.9L93.5,700.9c-0.4,0.5-0.4,1.3,0,1.8l0,0l0,0\r\n\t\t\t\t\tc-0.6-0.2-1.3,0-1.7,0.6l0,0c0-0.7-0.4-1.2-1.1-1.4l0,0c0.6-0.2,1.1-0.8,1.1-1.5l0,0C92.2,700.9,92.9,701.1,93.5,700.9\r\n\t\t\t\t\tL93.5,700.9L93.5,700.9z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M111.6,678.8L111.6,678.8c-0.4,0.5-0.4,1.3,0,1.8l0,0l0,0\r\n\t\t\t\t\tc-0.6-0.2-1.3,0-1.7,0.6l0,0c0-0.7-0.4-1.2-1.1-1.4l0,0c0.6-0.2,1.1-0.8,1.1-1.5l0,0C110.2,678.8,110.9,679,111.6,678.8\r\n\t\t\t\t\tL111.6,678.8L111.6,678.8z\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"91.9,702 71.1,690.2 53,667 61.9,668.7 72.5,673.4 \r\n\t\t\t\t\t85.2,678.4 110.2,679.6 110.2,679.9 85.1,678.7 72.3,673.7 61.7,669.1 53.9,667.5 71.4,689.9 92,701.6 103.6,696.4 110.7,679.4 \r\n\t\t\t\t\t112.1,670.2 119.5,669.5 119.6,669.8 112.4,670.5 111.1,679.5 103.8,696.7 103.8,696.7 \t\t\t\t\"/>\r\n\t\t\t</g>\r\n\t\t</g>\r\n\t\t<g id=\"AQUARIUS\">\r\n\t\t\t<path fill=\"#24E2FF\" d=\"M119.8,448c-1.5-2.6-3-4.6-4.3-6.1c0.2-0.6,0.3-1.3,0.3-2c0-3.1-2-5.7-4.8-6.6c-0.7-1.7-2-3.1-3.7-4\r\n\t\t\t\tc0.2-0.9,0.7-3.9-1.5-6.2c-2.8-2.9-8.8-3.3-17.9-1.1c-0.1,0-0.1,0-0.1,0.1c-7.3-1.7-15-1.5-16.9-1.2c-1.9,0.2-4.2,2-5,4.5\r\n\t\t\t\tc-0.4,1.4-0.6,4.1,2.5,6.7c5.1,4.4,12.2,7.6,13.1,8.1v2.7v0.1c-0.7,1-0.8,2-0.8,2v9.7c0,1.3,0.4,2.4,1.3,3.1\r\n\t\t\t\tc1.3,1.1,3.1,1.2,4.1,1.2c-5.5,15.7-9.1,21.7-10.2,21.7c-2.5,0.2-3.5,2.5-4.3,4.3c-0.2,0.5-0.4,1-0.6,1.3c-0.3,0.5-1.2,0.7-2,0.9\r\n\t\t\t\tc-1.1,0.2-2.4,0.5-2.1,1.8c0.3,1.5,2.2,1.7,3.1,1.7c0.3,0,0.6,0,0.6,0h34.8c1.8,0,3.4-0.8,4.5-2.2c1.1-1.4,1.4-3.4,0.9-5\r\n\t\t\t\tc-0.3-1.1-1.8-3.6-3.6-6.4l4.3-4.3c0.3-0.2,2.7-2.2,1.8-5.6c-1-3.6-5.8-3.3-5.9-3.3h-8.7c-0.3-0.8-0.9-1.6-1.5-2.4\r\n\t\t\t\tc-0.9-1.2-1.8-2.4-1.5-3.2c0.8-1.7,1.3-5.7,1.4-6.5c1.5-1.2,2.7-2.2,3.1-2.6c0.2-0.1,0.4-0.3,0.5-0.5c1.1-0.9,2.4-2.1,2.5-3.4\r\n\t\t\t\tc0-0.4-0.1-0.8-0.3-1.1l0,0c1.3,1.8,3.4,3,5.8,3c0.4,0,0.8,0,1.2-0.1c2.9,5.4,6.5,16.8,5.7,39.5c0,0.2,0.2,0.4,0.4,0.4l0,0\r\n\t\t\t\tc0.2,0,0.4-0.2,0.4-0.4c0.8-22.5-2.7-34-5.6-39.7c-0.1-0.2-0.2-0.5-0.4-0.7c-0.6-1.1-1.2-2-1.8-2.6c-0.3-0.4-0.6-0.7-0.8-0.9\r\n\t\t\t\tc-0.4-0.2-0.8-0.4-1.1-0.8c-0.4-0.5-0.6-1.1-0.6-1.7v-0.1c0.5,0.3,1.8,1.1,3.2,2.8c0.2,0.2,0.4,0.4,0.5,0.6\r\n\t\t\t\tc0.5,0.7,1.1,1.4,1.7,2.4c0.1,0.2,0.3,0.4,0.4,0.6c3.8,6.4,7.9,18.6,7.1,41.4c0,0.2,0.2,0.4,0.4,0.4l0,0c0.2,0,0.4-0.2,0.4-0.4\r\n\t\t\t\tc0.4-12.1-0.3-28.9-6.2-40.2c-0.3-0.6-0.6-1.1-0.9-1.6c-0.1-0.2-0.3-0.4-0.4-0.6c-0.6-0.9-1.1-1.7-1.7-2.3\r\n\t\t\t\tc-0.2-0.2-0.3-0.4-0.5-0.6c-1.9-2.1-3.4-3-3.9-3.2c0.1-0.3,0.3-0.5,0.4-0.8c0.6,0.3,2.3,1.1,4.3,3.2c0.2,0.2,0.4,0.4,0.5,0.6\r\n\t\t\t\tc0.6,0.6,1.2,1.4,1.8,2.2c0.1,0.2,0.3,0.4,0.4,0.6c0.2,0.3,0.5,0.7,0.7,1c6.7,10.7,8,26.8,8,38.6c0,0.2,0.2,0.4,0.4,0.4l0,0\r\n\t\t\t\tc0.2,0,0.4-0.2,0.4-0.4c0.1-21.5-4.4-33.1-8.1-39c-0.3-0.4-0.5-0.8-0.8-1.1c-0.1-0.2-0.3-0.4-0.5-0.6c-0.7-0.9-1.3-1.7-1.9-2.3\r\n\t\t\t\tc-0.2-0.2-0.4-0.4-0.6-0.6c-1.8-1.8-3.3-2.6-4.1-3c0.4-0.3,0.9-0.4,1.5-0.4c1,0,1.9,0.6,2.4,1.4c0.1,0.1,0.1,0.3,0.2,0.4\r\n\t\t\t\ts0.4,0.3,0.9,0.6c0.6,0.5,1.5,1.2,2.5,2.3c0.2,0.2,0.4,0.4,0.6,0.6c4.7,5.4,11.8,17.9,11.3,42.7c0,0.2,0.2,0.4,0.4,0.4l0,0\r\n\t\t\t\tc0.2,0,0.4-0.2,0.4-0.4C127.5,474.8,126.4,459.7,119.8,448L119.8,448z M110.1,433c-0.4-0.1-0.9-0.1-1.4-0.1s-1,0.1-1.5,0.2\r\n\t\t\t\tc-0.5-0.1-4.2-0.8-6.9-0.8c-2.8,0-3.2-1.2-3.2-2.3c0-0.4,0.1-0.7,0.5-1c0.5-0.4,1.8-1,5-0.5C106.3,429.1,108.9,430.7,110.1,433\r\n\t\t\t\tL110.1,433z M99.4,427.6c-1.3-1.3-2.9-2.3-4.6-3.1c3.7-1,6.4-0.8,8,0.5c1.3,1,1.5,2.5,1.5,3.1c-0.5-0.1-1-0.2-1.6-0.3\r\n\t\t\t\tC101.4,427.6,100.3,427.5,99.4,427.6z M105.3,423.6c1.8,1.8,1.5,4.3,1.4,5.3c-0.5-0.2-1-0.4-1.6-0.6c0-0.6-0.1-2.6-1.8-3.9\r\n\t\t\t\tc-1.9-1.5-5-1.7-9.3-0.4c-0.1,0-0.1,0.1-0.1,0.1c-1.4-0.6-2.9-1.1-4.5-1.6C97.3,420.7,102.8,421.1,105.3,423.6L105.3,423.6z\r\n\t\t\t\t M82.3,430.6c0,0-0.1-1.9,1.3-3.3c1.1-1.2,3-1.8,5.4-1.8c2.1,0,3.8,0.6,4.9,1.8c1.8,2,1.7,4.9,1.7,4.9v13.3\r\n\t\t\t\tc0,0.2,0.2,0.4,0.4,0.4h0.1l-8.9,7.4v-2.5c0,0,0-0.1,0-0.2v-0.2c2.7-2.3,4-8.7,4.1-8.9v-0.1v-11.1c0-0.2-0.1-0.3-0.3-0.4\r\n\t\t\t\tc-2.4-0.6-3.6-2.8-3.6-2.8c-0.1-0.1-0.2-0.2-0.3-0.2c-0.1,0-0.3,0.1-0.3,0.2c-1.5,2.4-3.1,2.8-3.1,2.8c-0.2,0-0.3,0.2-0.3,0.4\r\n\t\t\t\tv5.9c0,2.1,1.8,3.1,3,3.4v1.3c-2,0.1-3.2,0.6-4,1.3L82.3,430.6L82.3,430.6z M96.3,441.7c0.8,0,3.3,0,5.1,1.2c-0.1,0-0.3,0-0.5,0\r\n\t\t\t\tc-1.8,0.1-3.7,2-3.9,2.3l-0.8,0.7c0,0,0-0.1,0-0.2L96.3,441.7L96.3,441.7z M86.4,450.2c0,0,0,0.1,0,0.2v3.5c-0.1,0-0.2,0-0.3,0\r\n\t\t\t\tc-0.1-0.1-0.2-0.3-0.2-0.7V448c0-0.2,0-0.7,0.2-0.9c0,0,0.1-0.1,0.3-0.1h0.1L86.4,450.2L86.4,450.2z M110.1,483.7\r\n\t\t\t\tc0.4,1.4,0.1,3.1-0.8,4.3c-0.9,1.3-2.3,1.9-3.9,1.9H89.1c2.8-1.1,4.9-3,6.3-5.1l0,0h6.9c0.5,0,0.8-0.2,1-0.5\r\n\t\t\t\tc0.3-0.5-0.2-1.1-0.2-1.3c0,0,0-0.1-0.1-0.1l-1.1-0.9l-0.6-0.5l-3.2-2.7c0.6-2.1,0.8-3.6,0.8-3.7s0-6.3,0-9.3\r\n\t\t\t\tc1.4,2,4.6,6.8,7.3,10.9c0.1,0.2,0.3,0.4,0.4,0.7C108.4,480.3,109.8,482.7,110.1,483.7L110.1,483.7z M97.9,479.8l2.9,2.4\r\n\t\t\t\tl-1.9,1.9h-3.1C96.8,482.7,97.5,481.1,97.9,479.8L97.9,479.8z M101.4,482.7l1.1,0.9c0.1,0.2,0.2,0.4,0.2,0.4s-0.1,0.1-0.3,0.1\r\n\t\t\t\tH100L101.4,482.7L101.4,482.7z M103.3,471h0.6l-0.5,0.3C103.4,471.2,103.3,471.1,103.3,471z M107.5,464.5c0,0,4.3-0.2,5.1,2.8\r\n\t\t\t\tc0.8,3-1.4,4.7-1.5,4.8l0,0l-4.2,4.2c-0.9-1.5-1.9-3-2.9-4.4l1.7-0.9c0.1-0.1,0.2-0.3,0.2-0.4c0-0.2-0.2-0.3-0.4-0.3h-2.6l0,0\r\n\t\t\t\tc-1.9-2.8-3.5-5.1-3.8-5.6c0-0.1,0-0.1,0-0.2H107.5L107.5,464.5z M95.1,457.8c-0.5,1.2,0.5,2.6,1.5,4c0.8,1.1,1.6,2.2,1.6,3\r\n\t\t\t\tc-0.1,2.1,0,10.5,0,10.5s-0.1,1.5-0.8,3.5l0,0c-0.1,0.1-0.1,0.2-0.1,0.3c-1.2,3.9-4.2,9.5-10.9,10.8l0,0H70.6\r\n\t\t\t\tc0,0-2.7,0.3-2.9-1.1c-0.1-0.5,0.3-0.7,1.5-0.9c0.9-0.2,2-0.4,2.5-1.2c0.2-0.4,0.5-0.8,0.7-1.4c0.7-1.6,1.7-3.7,3.7-3.8\r\n\t\t\t\tc3-0.2,9.5-18.3,10.9-22.6c0.9-0.1,2.2-0.9,2.4-0.9c0,0,0,0,0.1,0c0.2-0.2,3.9-3.2,6.9-5.7C96.1,453.8,95.6,456.5,95.1,457.8\r\n\t\t\t\tL95.1,457.8z M100.3,448c-0.2,0.2-0.4,0.3-0.6,0.5c-1.3,1.2-10.3,8.5-10.8,9c-0.6,0.3-1.8,0.9-2.2,0.9l0,0l0,0\r\n\t\t\t\tc0,0-2.6,0.3-4.1-0.9c-0.7-0.6-1-1.5-1-2.6v-9.7c0,0,0-0.8,0.7-1.7c0.8-1.1,2.4-1.7,4.5-1.7c0.2,0,0.4-0.2,0.4-0.4v-2\r\n\t\t\t\tc0-0.2-0.1-0.3-0.3-0.4c-0.1,0-2.7-0.4-2.7-2.7v-5.6c0.5-0.2,1.7-0.9,2.9-2.6c0.5,0.7,1.7,2,3.5,2.6v10.8c-0.1,0.5-1.2,5.6-3.3,8\r\n\t\t\t\tv-2.8c0-0.2-0.2-0.4-0.4-0.4h-0.2c-0.5-0.1-0.8,0.1-1,0.3c-0.5,0.5-0.5,1.4-0.5,1.4v5.1c0,0.7,0.2,1.1,0.6,1.3\r\n\t\t\t\tc0.5,0.3,1.2,0,1.3,0c0,0,0,0,0.1,0l0,0l10.5-8.7l0,0c0.5-0.6,2.1-2,3.4-2c0.4,0,0.8,0.1,1.1,0.4c0.4,0.4,0.5,0.7,0.5,1.1\r\n\t\t\t\tC102.5,446.1,101.3,447.1,100.3,448L100.3,448z M96.3,440.9v-8.7c0-0.1,0.2-3.3-1.9-5.5c-1.3-1.4-3.1-2-5.5-2\r\n\t\t\t\tc-2.7,0-4.7,0.7-6,2.1c-1.6,1.7-1.5,3.8-1.5,3.8v8.7c-1.7-0.8-8-3.8-12.6-7.8c-2.7-2.3-2.7-4.5-2.2-5.9c0.7-2.2,2.8-3.8,4.4-4\r\n\t\t\t\tc1.3-0.2,6.3-0.4,12.4,0.4c4.7,0.7,11,2.2,15.1,5.8c-0.6,0.1-1,0.4-1.4,0.7c-0.5,0.4-0.7,0.9-0.7,1.5c0,2.1,1.3,3,4,3\r\n\t\t\t\tc1.8,0,4,0.3,5.5,0.5c-2.4,1.1-4.1,3.5-4.1,6.4c0,0.9,0.2,1.8,0.5,2.6C100.2,440.9,97.2,440.9,96.3,440.9L96.3,440.9z M112,438.6\r\n\t\t\t\tc-0.5-1.3-1.8-2.2-3.2-2.2c-1.9,0-3.4,1.5-3.4,3.4c0,1.4,0.8,2.6,2,3.1c0.6,0.6,1.4,1.6,2.2,3.1c-0.3,0-0.5,0.1-0.8,0.1\r\n\t\t\t\tc-3.5,0-6.3-2.8-6.3-6.3c0-3.4,2.8-6.3,6.3-6.3s6.3,2.8,6.3,6.3c0,0.5-0.1,0.9-0.1,1.3C113.5,439.8,112.4,439,112,438.6\r\n\t\t\t\tL112,438.6z\"/>\r\n\t\t\t<g id=\"stars_00000036247939541078051140000004797637232981623176_\">\r\n\t\t\t\t<path fill=\"#FFFF48\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M75.8,440.5L75.8,440.5c-0.6,0.2-1,0.8-1,1.4l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.7-0.5l0,0c0.4-0.5,0.4-1.2,0-1.8l0,0c0.6,0.2,1.3,0,1.7-0.5l0,0C74.7,439.7,75.1,440.3,75.8,440.5\r\n\t\t\t\t\tL75.8,440.5L75.8,440.5z\"/>\r\n\t\t\t\t<path fill=\"#FFFF48\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M68.2,474.1L68.2,474.1c-0.6,0.2-1,0.8-1,1.4l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.7-0.5l0,0c0.4-0.5,0.4-1.2,0-1.8l0,0c0.6,0.2,1.3,0,1.7-0.5l0,0C67.1,473.3,67.5,473.9,68.2,474.1\r\n\t\t\t\t\tL68.2,474.1L68.2,474.1z\"/>\r\n\t\t\t\t<path fill=\"#FFFF48\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M88.3,453.6L88.3,453.6c-0.6,0.2-1,0.8-1,1.4l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.7-0.5l0,0c0.4-0.5,0.4-1.2,0-1.8l0,0c0.6,0.2,1.3,0,1.7-0.5l0,0C87.3,452.8,87.7,453.3,88.3,453.6\r\n\t\t\t\t\tL88.3,453.6L88.3,453.6z\"/>\r\n\t\t\t\t<path fill=\"#FFFF48\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M84.3,442.5L84.3,442.5c-0.2,0.6,0,1.3,0.6,1.7l0,0\r\n\t\t\t\t\tc-0.7,0-1.2,0.4-1.4,1.1l0,0c-0.2-0.6-0.8-1-1.5-1l0,0c0.5-0.4,0.7-1.1,0.5-1.7l0,0C83,442.9,83.7,442.9,84.3,442.5L84.3,442.5z\r\n\t\t\t\t\t\"/>\r\n\t\t\t\t<path fill=\"#FFFF48\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M92.8,438L92.8,438c-0.6,0.3-1,0.9-0.9,1.5l0,0l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.7-0.4l0,0c0.3-0.6,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.6-0.7l0,0C91.6,437.3,92.1,437.8,92.8,438\r\n\t\t\t\t\tL92.8,438L92.8,438z\"/>\r\n\t\t\t\t<path fill=\"#FFFF48\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M108.9,447.6L108.9,447.6c-0.6,0.3-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.7-0.4l0,0c0.3-0.6,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.6-0.7l0,0C107.8,446.9,108.2,447.5,108.9,447.6\r\n\t\t\t\t\tL108.9,447.6L108.9,447.6z\"/>\r\n\t\t\t\t<path fill=\"#FFFF48\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M60.8,485L60.8,485c-0.6,0.3-1,0.9-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.7-1.7-0.4l0,0c0.3-0.6,0.3-1.3-0.1-1.8l0,0c0.6,0.1,1.3-0.1,1.6-0.7l0,0C59.7,484.3,60.1,484.9,60.8,485\r\n\t\t\t\t\tL60.8,485L60.8,485z\"/>\r\n\t\t\t\t<path fill=\"#FFFF48\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M72.1,466.6L72.1,466.6c-0.3,0.6-0.2,1.3,0.3,1.8l0,0\r\n\t\t\t\t\tc-0.6-0.1-1.3,0.2-1.6,0.8l0,0c-0.1-0.6-0.6-1.1-1.2-1.3l0,0l0,0c0.6-0.3,0.9-0.9,0.8-1.6l0,0C70.8,466.7,71.5,466.9,72.1,466.6\r\n\t\t\t\t\tL72.1,466.6L72.1,466.6z\"/>\r\n\t\t\t\t<path fill=\"#FFFF48\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M81.7,437.1L81.7,437.1c-0.4,0.5-0.4,1.2,0,1.8l0,0\r\n\t\t\t\t\tc-0.6-0.2-1.3,0-1.7,0.6l0,0c0-0.7-0.4-1.2-1.1-1.4l0,0c0.6-0.2,1-0.8,1-1.4l0,0C80.4,437.1,81,437.3,81.7,437.1L81.7,437.1\r\n\t\t\t\t\tL81.7,437.1z\"/>\r\n\t\t\t\t<path fill=\"#FFFF48\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M97.3,467.8L97.3,467.8c-0.4,0.5-0.4,1.2,0,1.8l0,0\r\n\t\t\t\t\tc-0.6-0.2-1.3,0-1.7,0.6l0,0c0-0.7-0.4-1.2-1.1-1.4l0,0l0,0c0.6-0.2,1-0.8,1-1.4l0,0C96,467.8,96.6,468,97.3,467.8L97.3,467.8\r\n\t\t\t\t\tL97.3,467.8z\"/>\r\n\t\t\t\t<path fill=\"#FFFF48\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M130.9,449.4L130.9,449.4c-0.4,0.5-0.4,1.2,0,1.8l0,0\r\n\t\t\t\t\tc-0.6-0.2-1.3,0-1.7,0.6l0,0c0-0.7-0.4-1.2-1.1-1.4l0,0l0,0c0.6-0.2,1-0.8,1-1.4l0,0C129.6,449.3,130.3,449.6,130.9,449.4\r\n\t\t\t\t\tL130.9,449.4L130.9,449.4z\"/>\r\n\t\t\t\t<path fill=\"#FFFF48\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M66.5,457.6L66.5,457.6c-0.4,0.5-0.4,1.2,0,1.8l0,0\r\n\t\t\t\t\tc-0.6-0.2-1.3,0-1.7,0.6l0,0c0-0.7-0.4-1.2-1.1-1.4l0,0c0.6-0.2,1-0.8,1-1.4l0,0C65.2,457.6,65.9,457.8,66.5,457.6L66.5,457.6\r\n\t\t\t\t\tL66.5,457.6z\"/>\r\n\t\t\t\t<polygon fill=\"#FFFF48\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"59.2,485.3 58.9,485.1 66.3,474 70.9,467.6 65,458.6 \r\n\t\t\t\t\t65,458.5 74.2,440.5 80.5,437.7 83.7,443.4 91.2,437.8 91.3,437.9 107.5,447.5 129.6,450 129.5,450.3 107.3,447.8 91.2,438.3 \r\n\t\t\t\t\t83.5,443.9 80.4,438.1 74.5,440.7 65.4,458.6 71.3,467.6 66.6,474.2 \t\t\t\t\"/>\r\n\t\t\t\t<polygon fill=\"#FFFF48\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"96.1,469 86.9,453.3 86.9,453.3 91,438 91.4,438.1 \r\n\t\t\t\t\t87.3,453.3 96.4,468.8 \t\t\t\t\"/>\r\n\t\t\t</g>\r\n\t\t</g>\r\n\t\t<g id=\"PISCES\">\r\n\t\t\t<path fill=\"#7854FF\" d=\"M75.5,239.5c0-0.1,0-0.2-0.1-0.3s-1.9-2.6-6.2-4.8c0.9-1.8,6.2-11.2,16.2-15.7c1.1-0.5,2.2-1,3.3-1.6\r\n\t\t\t\tl1.9,6.9c0,0.1,0.2,0.3,0.3,0.3l0,0c0.1,0,0.3-0.1,0.3-0.2l5.3-11.4c6.5-4.3,11.2-9.1,14.4-14.7c0.1-0.1,0.1-0.2,0-0.3\r\n\t\t\t\tc0-0.1-0.1-0.2-0.2-0.2s-5-1.6-11.5-1.9c0-0.1-0.1-0.1-0.2-0.1s-0.3,0-0.4,0.1c-2.5-0.1-5.2,0-7.9,0.5c-0.1-0.1-0.1-0.1-0.2-0.1\r\n\t\t\t\tl0,0l-12.8,0.1c-0.2,0-0.3,0.1-0.4,0.3l-1.3,6.9c0,0.1,0,0.1,0,0.2c-2.6,2.7-4.7,6-6.3,10c-0.1,0-0.2,0.1-0.3,0.2l-6.3,10.8\r\n\t\t\t\tc-0.1,0.1-0.1,0.3,0,0.4c0.1,0.1,0.2,0.2,0.3,0.2l0,0l3.5-0.2c-0.4,3.1-0.5,6.4-0.5,9.9c-0.4,1-4.6,11.3-1.1,21\r\n\t\t\t\tc0.1,0.1,0.2,0.2,0.4,0.2l0,0c0.2,0,0.3-0.1,0.3-0.3l3.7-13.4c0.7-0.3,3.2-1.2,5.4-2.5C75.4,239.7,75.5,239.6,75.5,239.5\r\n\t\t\t\tL75.5,239.5z M91,222.9l-1.6-6.1c2.1-1.1,4.1-2.2,6-3.4L91,222.9L91,222.9z M104,205.8c-5.6-2.8-5.1-8-4.8-9.5\r\n\t\t\t\tc5.3,0.2,9.5,1.4,10.9,1.7C108.4,200.8,106.5,203.4,104,205.8L104,205.8z M78.1,196.9l9.7-0.1c-2.9,0.8-5.8,2.1-8.5,4\r\n\t\t\t\tc-0.8,0.6-1.6,1.2-2.3,1.9L78.1,196.9L78.1,196.9z M64.2,224.3l4.6-7.9c-0.7,2.4-1.3,4.9-1.6,7.7L64.2,224.3z M69.5,241.6\r\n\t\t\t\tc-0.1,0-0.2,0.1-0.2,0.3l-3.4,12.4c-2.8-9.5,1.4-19.2,1.5-19.3c0-0.1,0-0.1,0-0.1c-0.2-16.1,3.9-27.4,12.3-33.5\r\n\t\t\t\tc5.5-4,12-5.1,17.6-5.1c0.4,0,0.8,0,1.1,0c-0.1,0.7-0.2,2,0,3.6c-0.1-0.1-0.2-0.2-0.4-0.2c-15,3-22.5,12.3-26.1,19.6\r\n\t\t\t\tc-4,7.8-4.4,15.1-4.4,15.2c0,0.2,0.1,0.4,0.4,0.4l0,0c0.2,0,0.4-0.1,0.4-0.3c0-0.1,0.4-7.2,4.3-14.9c3.6-7.1,11-16.2,25.6-19.2\r\n\t\t\t\tc0.2,0,0.3-0.2,0.3-0.3c0.5,2.1,1.7,4.6,4.9,6.2c-2.1,2-4.5,3.9-7.2,5.7c-0.1,0-0.3,0.1-0.3,0.2c-3.2,2-6.7,4-10.8,5.8\r\n\t\t\t\tc-11.3,5.1-16.6,16.3-16.7,16.4c-0.1,0.2,0,0.4,0.2,0.5c3.5,1.7,5.4,3.7,6,4.4C72.2,240.7,69.5,241.7,69.5,241.6L69.5,241.6z\"/>\r\n\t\t\t<path fill=\"#7854FF\" d=\"M84.1,209.8l11.3,1.8c0,0,0,0,0.1,0s0.3-0.1,0.3-0.2l3.2-7.1c0.1-0.2,0-0.3-0.1-0.4\r\n\t\t\t\tc-0.1-0.1-0.3-0.1-0.5,0c-3.8,3.1-14.2,5.2-14.3,5.2c-0.2,0-0.3,0.2-0.3,0.4S84,209.8,84.1,209.8L84.1,209.8z M97.8,205.2\r\n\t\t\t\tl-2.5,5.6l-9.1-1.4C89,208.7,94.6,207.2,97.8,205.2L97.8,205.2z\"/>\r\n\t\t\t<path fill=\"#7854FF\" d=\"M122.2,232.2c-0.1-0.1-0.2-0.2-0.3-0.2l-3.5,0.2c0.4-3.1,0.5-6.4,0.5-9.9c0.4-1,4.6-11.3,1.1-21\r\n\t\t\t\tc-0.1-0.1-0.2-0.3-0.4-0.2c-0.2,0-0.3,0.1-0.3,0.3l-3.7,13.4c-0.7,0.3-3.2,1.2-5.4,2.5c-0.1,0.1-0.1,0.1-0.2,0.2\r\n\t\t\t\tc0,0.1,0,0.2,0.1,0.3s1.9,2.6,6.2,4.8c-0.9,1.8-6.2,11.2-16.2,15.7c-1.1,0.5-2.2,1-3.3,1.6l-1.9-6.9c0-0.1-0.2-0.3-0.3-0.3\r\n\t\t\t\tc-0.1,0-0.3,0.1-0.4,0.2l-5.3,11.4c-6.5,4.3-11.2,9.1-14.4,14.7c-0.1,0.1-0.1,0.2,0,0.3c0,0.1,0.1,0.2,0.2,0.2s5,1.6,11.5,1.9\r\n\t\t\t\tc0,0.1,0.1,0.1,0.2,0.1h0.1c0.1,0,0.2,0,0.3-0.1c0.4,0,0.9,0,1.4,0c2.1,0,4.3-0.2,6.6-0.5c0.1,0.1,0.1,0.1,0.2,0.1l0,0l12.8-0.1\r\n\t\t\t\tc0.2,0,0.3-0.1,0.4-0.3l1.3-6.9c0-0.1,0-0.1,0-0.2c2.6-2.7,4.7-6,6.3-10c0.1,0,0.2-0.1,0.3-0.2l6.3-10.8\r\n\t\t\t\tC122.3,232.4,122.3,232.3,122.2,232.2L122.2,232.2z M94.4,234.2l1.6,6.1c-2.1,1.1-4.1,2.2-6,3.4L94.4,234.2L94.4,234.2z\r\n\t\t\t\t M81.4,251.3c5.6,2.8,5.1,8,4.8,9.5c-5.3-0.2-9.5-1.4-10.9-1.8C77,256.2,79,253.7,81.4,251.3L81.4,251.3z M87,260.8\r\n\t\t\t\tc0.1-0.7,0.2-2,0-3.6c0.1,0.1,0.2,0.2,0.3,0.2h0.1c15-3,22.5-12.3,26.1-19.6c4-7.8,4.4-15.1,4.4-15.2c0-0.2-0.1-0.4-0.4-0.4\r\n\t\t\t\tc-0.2,0-0.4,0.1-0.4,0.3c0,0.1-0.4,7.2-4.3,14.9c-3.6,7.1-11,16.2-25.6,19.2c-0.2,0-0.3,0.2-0.3,0.3c-0.5-2.1-1.7-4.6-4.9-6.2\r\n\t\t\t\tc2.1-2,4.5-3.9,7.2-5.7c0.1,0,0.3-0.1,0.3-0.2c3.2-2,6.7-4,10.8-5.8c11.3-5.1,16.6-16.3,16.7-16.4c0.1-0.2,0-0.4-0.2-0.5\r\n\t\t\t\tc-3.5-1.7-5.4-3.7-6-4.4c2.4-1.4,5.1-2.3,5.1-2.3c0.1,0,0.2-0.1,0.2-0.3l3.4-12.4c2.8,9.5-1.4,19.2-1.5,19.3c0,0.1,0,0.1,0,0.1\r\n\t\t\t\tc0.2,16.1-3.9,27.4-12.3,33.5C99.9,259.9,92.9,260.9,87,260.8L87,260.8z M107.4,260.2l-9.7,0.1c2.9-0.8,5.8-2.1,8.5-4\r\n\t\t\t\tc0.8-0.6,1.6-1.2,2.3-1.9L107.4,260.2L107.4,260.2z M116.6,240.7c0.7-2.4,1.3-4.9,1.6-7.7l3-0.2L116.6,240.7z\"/>\r\n\t\t\t<path fill=\"#7854FF\" d=\"M101.3,247.3L90,245.5c-0.2,0-0.3,0.1-0.4,0.2l-3.2,7.1c-0.1,0.2,0,0.3,0.1,0.4c0.1,0.1,0.1,0.1,0.2,0.1\r\n\t\t\t\ts0.2,0,0.2-0.1c3.8-3.1,14.2-5.2,14.3-5.2c0.2,0,0.3-0.2,0.3-0.4C101.6,247.4,101.5,247.3,101.3,247.3L101.3,247.3z M87.7,251.9\r\n\t\t\t\tl2.5-5.6l9.1,1.4C96.4,248.4,90.9,249.8,87.7,251.9L87.7,251.9z\"/>\r\n\t\t\t<g id=\"stars_00000150070404707711737150000012136617424777778592_\">\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M74.6,242.8L74.6,242.8c-0.6,0.2-1,0.8-1,1.4l0,0\r\n\t\t\t\t\tc-0.4-0.5-1-0.7-1.6-0.5l0,0c0.4-0.5,0.4-1.2,0-1.7l0,0c0.6,0.2,1.3,0,1.6-0.5l0,0C73.6,242,74,242.6,74.6,242.8L74.6,242.8\r\n\t\t\t\t\tL74.6,242.8z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M72.8,222.5L72.8,222.5c-0.6,0.2-1,0.8-1,1.4l0,0\r\n\t\t\t\t\tc-0.4-0.5-1-0.7-1.6-0.5l0,0c0.4-0.5,0.4-1.2,0-1.7l0,0c0.6,0.2,1.3,0,1.6-0.5l0,0C71.8,221.8,72.2,222.4,72.8,222.5L72.8,222.5\r\n\t\t\t\t\tL72.8,222.5z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M60.8,239.2L60.8,239.2c-0.6,0.2-1,0.8-1,1.4l0,0\r\n\t\t\t\t\tc-0.4-0.5-1-0.7-1.6-0.5l0,0c0.4-0.5,0.4-1.2,0-1.7l0,0c0.6,0.2,1.3,0,1.6-0.5l0,0C59.8,238.4,60.2,239,60.8,239.2L60.8,239.2\r\n\t\t\t\t\tL60.8,239.2z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M129.5,224.7L129.5,224.7c-0.2,0.6,0,1.3,0.6,1.6l0,0l0,0\r\n\t\t\t\t\tc-0.6,0-1.2,0.4-1.4,1l0,0c-0.2-0.6-0.8-1-1.4-1l0,0c0.5-0.4,0.7-1,0.5-1.6l0,0C128.2,225,128.9,225,129.5,224.7L129.5,224.7z\"\r\n\t\t\t\t\t/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M85.5,231.1L85.5,231.1c-0.6,0.2-0.9,0.8-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.6-1.7-0.4l0,0c0.3-0.5,0.3-1.2-0.1-1.7l0,0c0.6,0.1,1.3-0.1,1.6-0.7l0,0C84.4,230.5,84.9,231,85.5,231.1\r\n\t\t\t\t\tL85.5,231.1L85.5,231.1z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M120.1,220.7L120.1,220.7c-0.6,0.2-0.9,0.8-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.6-1.7-0.4l0,0c0.3-0.5,0.3-1.2-0.1-1.7l0,0c0.6,0.1,1.3-0.1,1.6-0.7l0,0C119,220.1,119.4,220.6,120.1,220.7\r\n\t\t\t\t\tL120.1,220.7L120.1,220.7z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M80.6,208L80.6,208c-0.6,0.2-0.9,0.8-0.9,1.5l0,0l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.6-1.7-0.4l0,0c0.3-0.5,0.3-1.2-0.1-1.7l0,0c0.6,0.1,1.3-0.1,1.6-0.7l0,0C79.6,207.4,80,207.9,80.6,208L80.6,208\r\n\t\t\t\t\tL80.6,208z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M122.9,228.6L122.9,228.6c-0.6,0.2-0.9,0.8-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.6-1.7-0.4l0,0c0.3-0.5,0.3-1.2-0.1-1.7l0,0c0.6,0.1,1.3-0.1,1.6-0.7l0,0C121.8,227.9,122.3,228.5,122.9,228.6\r\n\t\t\t\t\tL122.9,228.6L122.9,228.6z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M56.1,251.3L56.1,251.3c-0.6,0.2-0.9,0.8-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.6-1.7-0.4l0,0c0.3-0.5,0.3-1.2-0.1-1.7l0,0c0.6,0.1,1.3-0.1,1.6-0.7l0,0C55,250.6,55.5,251.2,56.1,251.3\r\n\t\t\t\t\tL56.1,251.3L56.1,251.3z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M67.5,243.9L67.5,243.9c-0.6,0.2-0.9,0.8-0.9,1.5l0,0\r\n\t\t\t\t\tc-0.4-0.5-1.1-0.6-1.7-0.4l0,0c0.3-0.5,0.3-1.2-0.1-1.7l0,0c0.6,0.1,1.3-0.1,1.6-0.7l0,0C66.4,243.2,66.9,243.7,67.5,243.9\r\n\t\t\t\t\tL67.5,243.9L67.5,243.9z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M72.3,201.8L72.3,201.8c-0.3,0.6-0.2,1.2,0.2,1.7l0,0\r\n\t\t\t\t\tc-0.6-0.1-1.3,0.2-1.5,0.8l0,0c-0.1-0.6-0.6-1.1-1.2-1.2l0,0c0.6-0.3,0.9-0.9,0.8-1.5l0,0C71.1,202,71.8,202.1,72.3,201.8\r\n\t\t\t\t\tL72.3,201.8z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M92.5,229.7L92.5,229.7c-0.4,0.5-0.4,1.2,0,1.7l0,0\r\n\t\t\t\t\tc-0.6-0.2-1.3,0-1.6,0.5l0,0c0-0.6-0.4-1.2-1-1.4l0,0c0.6-0.2,1-0.8,1-1.4l0,0C91.2,229.7,91.9,229.9,92.5,229.7L92.5,229.7\r\n\t\t\t\t\tL92.5,229.7z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M123.8,215.6L123.8,215.6c-0.4,0.5-0.4,1.2,0,1.7l0,0\r\n\t\t\t\t\tc-0.6-0.2-1.3,0-1.6,0.5l0,0c0-0.6-0.4-1.2-1-1.4l0,0c0.6-0.2,1-0.8,1-1.4l0,0C122.5,215.6,123.2,215.8,123.8,215.6L123.8,215.6\r\n\t\t\t\t\tL123.8,215.6z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M110.7,224.4L110.7,224.4c-0.4,0.5-0.4,1.2,0,1.7l0,0\r\n\t\t\t\t\tc-0.6-0.2-1.3,0-1.6,0.5l0,0l0,0c0-0.6-0.4-1.2-1-1.4l0,0c0.6-0.2,1-0.8,1-1.4l0,0C109.4,224.4,110.1,224.6,110.7,224.4\r\n\t\t\t\t\tL110.7,224.4L110.7,224.4z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M132.1,219L132.1,219c-0.4,0.5-0.4,1.2,0,1.7l0,0\r\n\t\t\t\t\tc-0.6-0.2-1.3,0-1.6,0.5l0,0c0-0.6-0.4-1.2-1-1.4l0,0c0.6-0.2,1-0.8,1-1.4l0,0C130.8,219,131.5,219.2,132.1,219L132.1,219\r\n\t\t\t\t\tL132.1,219z\"/>\r\n\t\t\t\t<path fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" d=\"M77,194.6L77,194.6c-0.4,0.5-0.4,1.2,0,1.7l0,0\r\n\t\t\t\t\tc-0.6-0.2-1.3,0-1.6,0.5l0,0c0-0.6-0.4-1.2-1-1.4l0,0c0.6-0.2,1-0.8,1-1.4l0,0C75.7,194.6,76.4,194.8,77,194.6L77,194.6\r\n\t\t\t\t\tL77,194.6z\"/>\r\n\t\t\t\t<polygon fill=\"#00AA21\" stroke=\"#00AA21\" stroke-miterlimit=\"10\" points=\"54,251.9 59.3,239.1 71.3,222.1 79.1,208.5 \r\n\t\t\t\t\t75.7,195.7 71.4,202.9 78.8,207.8 78.6,208.1 70.9,203 75.8,194.8 79.5,208.5 79.4,208.6 71.6,222.3 59.6,239.3 54.8,251 \r\n\t\t\t\t\t66.1,243.6 73.2,242.5 83.7,231.2 83.8,231.1 91.2,230.4 109.5,225.2 118.4,220.7 122.7,216.1 131.1,219.6 128.9,226.4 \r\n\t\t\t\t\t121.5,229.3 118.6,221.4 118.9,221.3 121.7,228.8 128.7,226.1 130.7,219.8 122.8,216.5 118.5,221 109.6,225.5 91.2,230.7 \r\n\t\t\t\t\t83.9,231.5 73.4,242.9 66.2,244 \t\t\t\t\"/>\r\n\t\t\t</g>\r\n\t\t</g>\r\n\t\t<g id=\"SignNames\">\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 402.1123 261.2148)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">ARIES</text>\r\n\t\t\t\r\n\t\t\t\t<text transform=\"matrix(1.0054 0 0 1 620.3223 261.2148)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\" letter-spacing=\"-1\">T</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 632.5732 261.2148)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">A</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 649.5332 261.2148)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">URUS</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 851.0781 261.2148)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">GEMINI</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 843.9189 475.4072)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">C</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 860.8779 475.4072)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">ANCER</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 875.0488 710.8086)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">LEO</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 851.0781 936.7412)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">VI</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 874.2227 936.7412)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">R</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 889.9307 936.7412)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">GO</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 607.7207 937.8721)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">LIB</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 644.1016 937.8721)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">R</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 659.8633 937.8721)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">A</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 125.3999 949.8145)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">S</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 137.9473 949.8145)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">A</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 153.147 949.8145)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">GI</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 175.6753 949.8145)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">T</text>\r\n\t\t\t\r\n\t\t\t\t<text transform=\"matrix(1.0054 0 0 1 189.2939 949.8145)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\" letter-spacing=\"-1\">T</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 200.0391 949.8145)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">ARIUS</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 370.4946 938.04)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">S</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 384.814 938.04)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">C</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 401.0415 938.04)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">ORPIO</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 134.3936 714.8799)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">C</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 149.2642 714.8799)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">APRI</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 198.1606 714.8799)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">C</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 212.3945 714.8799)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">ORN</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 140.2822 488.749)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">A</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 155.4814 488.749)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">Q</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 173.0146 488.749)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">U</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 188.627 488.749)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">ARIUS</text>\r\n\t\t\t<text transform=\"matrix(1.0054 0 0 1 158.8584 262.6167)\" fill=\"#F06A9E\" font-family=\"'Arial-BoldMT'\" font-size=\"20px\">PISCES</text>\r\n\t\t</g>\r\n\t</g>\r\n\t<g id=\"HouseIconLayer\">\r\n\t\t<g id=\"houseIcon\">\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M745.1,526.6l8.5-8.1c0.1-0.1,0.4-0.1,0.5,0l0,0l0,0l8.4,8.1\r\n\t\t\t\tl0,0l0.3,0.2c0.1,0.1,0.1,0.2,0.1,0.3l0,0v12c0,0.2-0.2,0.4-0.4,0.4h-6v-7.3c0-0.2-0.2-0.4-0.4-0.4h-4.6c-0.2,0-0.4,0.2-0.4,0.4\r\n\t\t\t\tv7.3h-6c-0.2,0-0.4-0.2-0.4-0.4v-12c0-0.1,0.1-0.2,0.1-0.3L745.1,526.6L745.1,526.6z\"/>\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M753.8,516.5l-11.6,10.9c-0.3,0.3-0.8,0.3-1.1,0s-0.3-0.8,0-1.1\r\n\t\t\t\tl12.1-11.4c0.3-0.3,0.8-0.3,1.1,0l12.1,11.4c0.3,0.3,0.3,0.8,0,1.1s-0.8,0.3-1.1,0L753.8,516.5L753.8,516.5z\"/>\r\n\t\t\t<polygon fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" points=\"746.9,522.2 745.3,524.4 744,524.4 744,517.7 \r\n\t\t\t\t747.8,517.7 747.8,522.1 \t\t\t\"/>\r\n\t\t</g>\r\n\t\t<g id=\"houseIcon-2\">\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M743.4,301.4l8.5-8.1c0.1-0.1,0.4-0.1,0.5,0l0,0l0,0l8.4,8.1\r\n\t\t\t\tl0,0l0.3,0.2c0.1,0.1,0.1,0.2,0.1,0.3l0,0v12c0,0.2-0.2,0.4-0.4,0.4h-6V307c0-0.2-0.2-0.4-0.4-0.4h-4.5c-0.2,0-0.4,0.2-0.4,0.4\r\n\t\t\t\tv7.3h-6c-0.2,0-0.4-0.2-0.4-0.4v-12.1c0-0.1,0.1-0.2,0.1-0.3L743.4,301.4L743.4,301.4z\"/>\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M752.2,291.3l-11.6,10.9c-0.3,0.3-0.8,0.3-1.1,0s-0.3-0.8,0-1.1\r\n\t\t\t\tl12.1-11.4c0.3-0.3,0.8-0.3,1.1,0l12.1,11.4c0.3,0.3,0.3,0.8,0,1.1c-0.3,0.3-0.8,0.3-1.1,0L752.2,291.3L752.2,291.3z\"/>\r\n\t\t\t<polygon fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" points=\"745.2,297 743.7,299.2 742.3,299.2 742.3,292.5 \r\n\t\t\t\t746.2,292.5 746.2,296.9 \t\t\t\"/>\r\n\t\t</g>\r\n\t\t<g id=\"houseIcon-3\">\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M746.8,67.9l8.5-8.1c0.1-0.1,0.4-0.1,0.5,0l0,0l0,0l8.4,8.1l0,0\r\n\t\t\t\tl0.3,0.2c0.1,0.1,0.1,0.2,0.1,0.3l0,0v12c0,0.2-0.2,0.4-0.4,0.4h-6v-7.3c0-0.2-0.2-0.4-0.4-0.4h-4.6c-0.2,0-0.4,0.2-0.4,0.4v7.3\r\n\t\t\t\th-6c-0.2,0-0.4-0.2-0.4-0.4v-12c0-0.1,0.1-0.2,0.1-0.3L746.8,67.9L746.8,67.9z\"/>\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M755.5,57.8L744,68.7c-0.3,0.3-0.8,0.3-1.1,0s-0.3-0.8,0-1.1\r\n\t\t\t\tL755,56.2c0.3-0.3,0.8-0.3,1.1,0l12.1,11.4c0.3,0.3,0.3,0.8,0,1.1c-0.3,0.3-0.8,0.3-1.1,0L755.5,57.8L755.5,57.8z\"/>\r\n\t\t\t<polygon fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" points=\"748.6,63.5 747.1,65.7 745.7,65.7 745.7,59 749.6,59 \r\n\t\t\t\t749.6,63.4 \t\t\t\"/>\r\n\t\t</g>\r\n\t\t<g id=\"houseIcon-4\">\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M515.3,67.9l8.5-8.1c0.1-0.1,0.4-0.1,0.5,0l0,0l0,0l8.4,8.1l0,0\r\n\t\t\t\tl0.3,0.2c0.1,0.1,0.1,0.2,0.1,0.3l0,0v12c0,0.2-0.2,0.4-0.4,0.4h-6v-7.3c0-0.2-0.2-0.4-0.4-0.4h-4.6c-0.2,0-0.4,0.2-0.4,0.4v7.3\r\n\t\t\t\th-6c-0.2,0-0.4-0.2-0.4-0.4v-12c0-0.1,0.1-0.2,0.1-0.3L515.3,67.9L515.3,67.9z\"/>\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M524.1,57.8l-11.6,10.9c-0.3,0.3-0.8,0.3-1.1,0\r\n\t\t\t\tc-0.3-0.3-0.3-0.8,0-1.1l12.1-11.4c0.3-0.3,0.8-0.3,1.1,0l12.1,11.4c0.3,0.3,0.3,0.8,0,1.1c-0.3,0.3-0.8,0.3-1.1,0L524.1,57.8\r\n\t\t\t\tL524.1,57.8z\"/>\r\n\t\t\t<polygon fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" points=\"517.1,63.5 515.6,65.7 514.2,65.7 514.2,59 518.1,59 \r\n\t\t\t\t518.1,63.4 \t\t\t\"/>\r\n\t\t</g>\r\n\t\t<g id=\"houseIcon-5\">\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M288.2,67.9l8.5-8.1c0.1-0.1,0.4-0.1,0.5,0l0,0l0,0l8.4,8.1l0,0\r\n\t\t\t\tl0.3,0.2c0.1,0.1,0.1,0.2,0.1,0.3l0,0v12c0,0.2-0.2,0.4-0.4,0.4h-6v-7.3c0-0.2-0.2-0.4-0.4-0.4h-4.6c-0.2,0-0.4,0.2-0.4,0.4v7.3\r\n\t\t\t\th-6c-0.2,0-0.4-0.2-0.4-0.4v-12c0-0.1,0.1-0.2,0.1-0.3L288.2,67.9L288.2,67.9z\"/>\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M297,57.8l-11.6,10.9c-0.3,0.3-0.8,0.3-1.1,0\r\n\t\t\t\tc-0.3-0.3-0.3-0.8,0-1.1l12.1-11.4c0.3-0.3,0.8-0.3,1.1,0l12.1,11.4c0.3,0.3,0.3,0.8,0,1.1s-0.8,0.3-1.1,0L297,57.8L297,57.8z\"/>\r\n\t\t\t<polygon fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" points=\"290,63.5 288.5,65.7 287.1,65.7 287.1,59 291,59 \r\n\t\t\t\t291,63.3 \t\t\t\"/>\r\n\t\t</g>\r\n\t\t<g id=\"houseIcon-6\">\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M52.4,67.9l8.5-8.1c0.1-0.1,0.4-0.1,0.5,0l0,0l0,0l8.4,8.1l0,0\r\n\t\t\t\tl0.3,0.2c0.1,0.1,0.1,0.2,0.1,0.3l0,0v12c0,0.2-0.2,0.4-0.4,0.4h-6v-7.3c0-0.2-0.2-0.4-0.4-0.4h-4.6c-0.2,0-0.4,0.2-0.4,0.4v7.3\r\n\t\t\t\th-6c-0.2,0-0.4-0.2-0.4-0.4v-12c0-0.1,0.1-0.2,0.1-0.3L52.4,67.9L52.4,67.9z\"/>\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M61.1,57.8L49.6,68.7c-0.3,0.3-0.8,0.3-1.1,0s-0.3-0.8,0-1.1\r\n\t\t\t\tl12.1-11.4c0.3-0.3,0.8-0.3,1.1,0l12.1,11.4c0.3,0.3,0.3,0.8,0,1.1c-0.3,0.3-0.8,0.3-1.1,0L61.1,57.8L61.1,57.8z\"/>\r\n\t\t\t<polygon fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" points=\"54.2,63.5 52.7,65.7 51.3,65.7 51.3,59 55.2,59 \r\n\t\t\t\t55.2,63.3 \t\t\t\"/>\r\n\t\t</g>\r\n\t\t<g id=\"houseIcon-7\">\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M52,301.4l8.5-8.1c0.1-0.1,0.4-0.1,0.5,0l0,0l0,0l8.4,8.1l0,0\r\n\t\t\t\tl0.3,0.2c0.1,0.1,0.1,0.2,0.1,0.3l0,0v12c0,0.2-0.2,0.4-0.4,0.4h-6V307c0-0.2-0.2-0.4-0.4-0.4h-4.5c-0.2,0-0.4,0.2-0.4,0.4v7.3\r\n\t\t\t\th-6c-0.2,0-0.4-0.2-0.4-0.4v-12.1c0-0.1,0.1-0.2,0.1-0.3L52,301.4L52,301.4z\"/>\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M60.9,291.4l-11.6,10.9c-0.3,0.3-0.8,0.3-1.1,0s-0.3-0.8,0-1.1\r\n\t\t\t\tl12.1-11.4c0.3-0.3,0.8-0.3,1.1,0l12.1,11.4c0.3,0.3,0.3,0.8,0,1.1c-0.3,0.3-0.8,0.3-1.1,0L60.9,291.4L60.9,291.4z\"/>\r\n\t\t\t<polygon fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" points=\"53.9,297 52.4,299.2 50.9,299.2 50.9,292.5 54.9,292.5 \r\n\t\t\t\t54.9,296.9 \t\t\t\"/>\r\n\t\t</g>\r\n\t\t<g id=\"houseIcon-8\">\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M50.8,529.9l8.5-8.1c0.1-0.1,0.4-0.1,0.5,0l0,0l0,0l8.4,8.1l0,0\r\n\t\t\t\tl0.3,0.2c0.1,0.1,0.1,0.2,0.1,0.3l0,0v12c0,0.2-0.2,0.4-0.4,0.4h-6v-7.3c0-0.2-0.2-0.4-0.4-0.4h-4.6c-0.2,0-0.4,0.2-0.4,0.4v7.3\r\n\t\t\t\th-6c-0.2,0-0.4-0.2-0.4-0.4v-12.1c0-0.1,0.1-0.2,0.1-0.3L50.8,529.9L50.8,529.9z\"/>\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M59.5,519.8l-11.6,10.9c-0.3,0.3-0.8,0.3-1.1,0s-0.3-0.8,0-1.1\r\n\t\t\t\tl12.1-11.4c0.3-0.3,0.8-0.3,1.1,0l12.1,11.4c0.3,0.3,0.3,0.8,0,1.1s-0.8,0.3-1.1,0L59.5,519.8L59.5,519.8z\"/>\r\n\t\t\t<polygon fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" points=\"52.6,525.5 51.1,527.7 49.7,527.7 49.7,520.9 \r\n\t\t\t\t53.6,520.9 53.6,525.3 \t\t\t\"/>\r\n\t\t</g>\r\n\t\t<g id=\"houseIcon-9\">\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M50.6,758.8l8.5-8.1c0.1-0.1,0.4-0.1,0.5,0l0,0l0,0l8.4,8.1l0,0\r\n\t\t\t\tl0.3,0.2c0.1,0.1,0.1,0.2,0.1,0.3l0,0v12c0,0.2-0.2,0.4-0.4,0.4h-6v-7.3c0-0.2-0.2-0.4-0.4-0.4H57c-0.2,0-0.4,0.2-0.4,0.4v7.3h-6\r\n\t\t\t\tc-0.2,0-0.4-0.2-0.4-0.4v-12.1c0-0.1,0.1-0.2,0.1-0.3L50.6,758.8L50.6,758.8z\"/>\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M59.4,748.7l-11.6,10.9c-0.3,0.3-0.8,0.3-1.1,0s-0.3-0.8,0-1.1\r\n\t\t\t\tl12.1-11.4c0.3-0.3,0.8-0.3,1.1,0L72,758.6c0.3,0.3,0.3,0.8,0,1.1s-0.8,0.3-1.1,0L59.4,748.7L59.4,748.7z\"/>\r\n\t\t\t<polygon fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" points=\"52.4,754.4 50.9,756.6 49.5,756.6 49.5,749.9 \r\n\t\t\t\t53.4,749.9 53.4,754.3 \t\t\t\"/>\r\n\t\t</g>\r\n\t\t<g id=\"houseIcon-10\">\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M287.1,760.7l8.5-8.1c0.1-0.1,0.4-0.1,0.5,0l0,0l0,0l8.4,8.1\r\n\t\t\t\tl0,0l0.3,0.2c0.1,0.1,0.1,0.2,0.1,0.3l0,0v12c0,0.2-0.2,0.4-0.4,0.4h-6v-7.3c0-0.2-0.2-0.4-0.4-0.4h-4.6c-0.2,0-0.4,0.2-0.4,0.4\r\n\t\t\t\tv7.3h-6c-0.2,0-0.4-0.2-0.4-0.4v-12.1c0-0.1,0.1-0.2,0.1-0.3L287.1,760.7L287.1,760.7z\"/>\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M295.8,750.6l-11.6,10.9c-0.3,0.3-0.8,0.3-1.1,0\r\n\t\t\t\tc-0.3-0.3-0.3-0.8,0-1.1l12.1-11.4c0.3-0.3,0.8-0.3,1.1,0l12.1,11.4c0.3,0.3,0.3,0.8,0,1.1s-0.8,0.3-1.1,0L295.8,750.6\r\n\t\t\t\tL295.8,750.6z\"/>\r\n\t\t\t<polygon fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" points=\"288.9,756.3 287.3,758.5 286,758.5 286,751.8 \r\n\t\t\t\t289.8,751.8 289.8,756.2 \t\t\t\"/>\r\n\t\t</g>\r\n\t\t<g id=\"houseIcon-11\">\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M516.5,759.4l8.5-8.1c0.1-0.1,0.4-0.1,0.5,0l0,0l0,0l8.4,8.1\r\n\t\t\t\tl0,0l0.3,0.2c0.1,0.1,0.1,0.2,0.1,0.3l0,0v12c0,0.2-0.2,0.4-0.4,0.4h-6V765c0-0.2-0.2-0.4-0.4-0.4H523c-0.2,0-0.4,0.2-0.4,0.4\r\n\t\t\t\tv7.3h-6c-0.2,0-0.4-0.2-0.4-0.4v-12.1c0-0.1,0.1-0.2,0.1-0.3L516.5,759.4L516.5,759.4z\"/>\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M525.3,749.3l-11.6,10.9c-0.3,0.3-0.8,0.3-1.1,0s-0.3-0.8,0-1.1\r\n\t\t\t\tl12.1-11.4c0.3-0.3,0.8-0.3,1.1,0l12.1,11.4c0.3,0.3,0.3,0.8,0,1.1s-0.8,0.3-1.1,0L525.3,749.3L525.3,749.3z\"/>\r\n\t\t\t<polygon fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" points=\"518.3,755 516.8,757.2 515.4,757.2 515.4,750.5 \r\n\t\t\t\t519.3,750.5 519.3,754.9 \t\t\t\"/>\r\n\t\t</g>\r\n\t\t<g id=\"houseIcon-12\">\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M744.8,759.4l8.5-8.1c0.1-0.1,0.4-0.1,0.5,0l0,0l0,0l8.4,8.1\r\n\t\t\t\tl0,0l0.3,0.2c0.1,0.1,0.1,0.2,0.1,0.3l0,0v12c0,0.2-0.2,0.4-0.4,0.4h-6V765c0-0.2-0.2-0.4-0.4-0.4h-4.6c-0.2,0-0.4,0.2-0.4,0.4\r\n\t\t\t\tv7.3h-6c-0.2,0-0.4-0.2-0.4-0.4v-12.1c0-0.1,0.1-0.2,0.1-0.3L744.8,759.4L744.8,759.4z\"/>\r\n\t\t\t<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" d=\"M753.6,749.3l-11.6,11c-0.3,0.3-0.8,0.3-1.1,0s-0.3-0.8,0-1.1\r\n\t\t\t\tl12.1-11.4c0.3-0.3,0.8-0.3,1.1,0l12.1,11.4c0.3,0.3,0.3,0.8,0,1.1s-0.8,0.3-1.1,0L753.6,749.3L753.6,749.3z\"/>\r\n\t\t\t<polygon fill-rule=\"evenodd\" clip-rule=\"evenodd\" fill=\"#3300FF\" points=\"746.6,755 745.1,757.2 743.7,757.2 743.7,750.5 \r\n\t\t\t\t747.6,750.5 747.6,754.9 \t\t\t\"/>\r\n\t\t</g>\r\n\t</g>\r\n</g>";


        public SouthChartFactory(Time time, ChartType chartType)
        {
            //save for later
            ChartType = chartType;
            Time = time;

            //generate SVG chart based on given data
            SVGChart = GenerateChart();
        }

        /// <summary>
        /// Keeps track of planets in a sign box so that stack nicely
        /// </summary>
        private static Dictionary<ZodiacName, int> ChartOccupiedMarker { get; set; } =
            new Dictionary<ZodiacName, int>()
            {
                { ZodiacName.Aries, 0 },
                { ZodiacName.Taurus, 0 },
                { ZodiacName.Gemini, 0 },
                { ZodiacName.Cancer, 0 },
                { ZodiacName.Leo, 0 },
                { ZodiacName.Virgo, 0 },
                { ZodiacName.Libra, 0 },
                { ZodiacName.Scorpio, 0 },
                { ZodiacName.Sagittarius, 0 },
                { ZodiacName.Capricorn, 0 },
                { ZodiacName.Aquarius, 0 },
                { ZodiacName.Pisces, 0 },
            };

        /// <summary>
        /// This goes under group PlanetLayer
        /// </summary>
        private static Dictionary<ZodiacName, dynamic> ChartPlanetStartCoordinates { get; set; } =
            new()
            {
                { ZodiacName.Aries, new { xAxis = 344.1343, yAxis = 116.4543 } },
                { ZodiacName.Gemini, new { xAxis = 809.8004, yAxis = 116.4545 } },
                { ZodiacName.Cancer, new { xAxis = 812.5844, yAxis = 345.47 } },
                { ZodiacName.Leo, new { xAxis = 811.8781, yAxis = 574.8698 } },
                { ZodiacName.Virgo, new { xAxis = 811.8781, yAxis = 801.5934 } },
                { ZodiacName.Taurus, new { xAxis = 574.7999, yAxis = 116.4543 } },
                { ZodiacName.Libra, new { xAxis = 574.6001, yAxis = 801.5942 } },
                { ZodiacName.Scorpio, new { xAxis = 342.95, yAxis = 801.5942 } },
                { ZodiacName.Sagittarius, new { xAxis = 116.0999, yAxis = 801.5934 } },
                { ZodiacName.Capricorn, new { xAxis = 115.4, yAxis = 574.8705 } },
                { ZodiacName.Aquarius, new { xAxis = 114.7001, yAxis = 345.47 } },
                { ZodiacName.Pisces, new { xAxis = 115.1002, yAxis = 116.4543 } }, //115.1002 116.4543
            };

        /// <summary>
        /// This goes under group "HouseNumberLayer"
        /// </summary>
        private static Dictionary<ZodiacName, dynamic> ChartHouseStartCoordinates { get; set; } =
            new Dictionary<ZodiacName, dynamic>()
            {
                //translate(437 212) 127 112
                { ZodiacName.Aries, new { xAxis = 319.8589, yAxis = 80.7979 } },
                { ZodiacName.Taurus, new { xAxis = 546.8398, yAxis = 80.7979 } },
                { ZodiacName.Gemini, new { xAxis = 772.2188, yAxis = 80.7979 } },
                { ZodiacName.Cancer, new { xAxis = 772.2188, yAxis = 314.3319 } },
                { ZodiacName.Leo, new { xAxis = 772.2188, yAxis = 540.3138 } },
                { ZodiacName.Virgo, new { xAxis = 772.2188, yAxis = 771.7588 } },
                { ZodiacName.Libra, new { xAxis = 546.8398, yAxis = 771.7588 } },
                { ZodiacName.Scorpio, new { xAxis = 319.8589, yAxis = 771.7588 } },
                { ZodiacName.Sagittarius, new { xAxis = 77, yAxis = 771.7588 } },
                { ZodiacName.Capricorn, new { xAxis = 77, yAxis = 540.3138 } },
                { ZodiacName.Aquarius, new { xAxis = 81.6, yAxis = 314.3319 } },
                { ZodiacName.Pisces, new { xAxis = 84.3926, yAxis = 80.7979 } },
            };

        /// <summary>
        /// Sweet heart takes this away!
        /// Basically generating 1 frame
        /// </summary>
        private string GenerateChart()
        {
            //PART I : declare the components
            string svgHead = null;
            string svgTail = null;
            string planetsLayer = null;
            string houseNumberLayer = null;
            string chartTypeNameLayer = null;
            string globalStyles = null;

            //PART II : fill the components in order
            GenerateComponents();

            //PART III : compile in right placement
            var final =
                $@" <!--MADE BY MACHINES FOR HUMAN EYES-->
                    {svgHead}
                        {globalStyles}
                        {StaticBackgroundLayer}
                        {planetsLayer}
                        {houseNumberLayer}
                        {chartTypeNameLayer}
                    {svgTail}
                ";

            return final;

            //------------------------LOCALS NEEDED FOR REFS

            void GenerateComponents()
            {
                //STEP 0: RESET
                foreach (var zodiac in ZodiacSign.All12ZodiacNames) { ChartOccupiedMarker[zodiac] = 0; }

                //STEP 1: USER INPUT > USABLE DATA
                var svgBackgroundColor = "#f0f2f5"; //not bleach white
                var randomId = Tools.GenerateId();

                planetsLayer = GetPlanetsPositionLayer(this.Time);

                houseNumberLayer = GetHouseNumberLayer(this.Time);

                chartTypeNameLayer = GetChartTypeNameLayer();

                //set styles used in whole chart, like font family
                globalStyles = @"
                    <style>
                        text {
                          font-family: monospace, sans-serif;
                        }
                    </style>
                ";

                //note: if width & height not hard set, parent div clips it
                var svgTotalHeight = this.heightPx;
                var svgTotalWidth = this.widthPx;
                var svgStyle = $@"background:{svgBackgroundColor};";//end of style tag
                svgHead = $"<svg viewBox=\"0 0 {svgTotalWidth} {svgTotalHeight}\" width=\"{svgTotalWidth}px\" height=\"{svgTotalHeight}px\" style=\"{svgStyle}\" class=\"SkyChartHolder\" id=\"{randomId}\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">";//much needed for use tags to work
                svgTail = "</svg>";

            }
        }

        private string GetChartTypeNameLayer()
        {
            //add space between chart name and division number
            var chartTypeName = Tools.CamelPascalCaseToSpaced(ChartType.ToString());

            //get center of chart based on width & height
            var centerX = this.widthPx / 2;
            var centerY = this.heightPx / 2;

            var fontSize = 40;

            var chartTypeNameLayer = $@"
                <g id=""ChartTypeNameLayer"">
                    <text x=""{centerX}"" y=""{centerY}"" font-size=""{fontSize}"" text-anchor=""middle"" fill=""#000000"">{chartTypeName}</text>
                </g>
            ";

            return chartTypeNameLayer;
        }

        /// <summary>
        /// Given a time will name all the house boxes
        /// </summary>
        private string GetHouseNumberLayer(Time time)
        {

            var compiled = "";

            foreach (var houseName in House.AllHouses)
            {
                //get 
                ZodiacName houseSignName = ZodiacName.Empty;
                ZodiacSign houseZodiacSign;
                switch (this.ChartType)
                {
                    case ChartType.Bhava:
                    case ChartType.RasiD1:
                        houseZodiacSign = HouseZodiacSign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    case ChartType.HoraD2:
                        houseZodiacSign = HouseHoraD2Sign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    case ChartType.DrekkanaD3:
                        houseZodiacSign = HouseDrekkanaD3Sign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    case ChartType.ChaturthamshaD4:
                        houseZodiacSign = HouseChaturthamshaD4Sign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    case ChartType.SaptamshaD7:
                        houseZodiacSign = HouseSaptamshaD7Sign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    case ChartType.NavamshaD9:
                        houseZodiacSign = HouseNavamshaD9Sign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    case ChartType.DashamamshaD10:
                        houseZodiacSign = HouseDashamamshaD10Sign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    case ChartType.DwadashamshaD12:
                        houseZodiacSign = HouseDwadashamshaD12Sign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    case ChartType.ShodashamshaD16:
                        houseZodiacSign = HouseShodashamshaD16Sign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    case ChartType.VimshamshaD20:
                        houseZodiacSign = HouseVimshamshaD20Sign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    case ChartType.ChaturvimshamshaD24:
                        houseZodiacSign = HouseChaturvimshamshaD24Sign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    case ChartType.BhamshaD27:
                        houseZodiacSign = HouseBhamshaD27Sign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    case ChartType.TrimshamshaD30:
                        houseZodiacSign = HouseTrimshamshaD30Sign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    case ChartType.KhavedamshaD40:
                        houseZodiacSign = HouseKhavedamshaD40Sign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    case ChartType.AkshavedamshaD45:
                        houseZodiacSign = HouseAkshavedamshaD45Sign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    case ChartType.ShashtyamshaD60:
                        houseZodiacSign = HouseShashtyamshaD60Sign(houseName, time);
                        houseSignName = houseZodiacSign.GetSignName();
                        break;
                    default:
                        throw new Exception("Chart Type Not YET Coded for!");
                        break;
                }


                var coordinates = GetHousePositionForSignBox(houseSignName);
                var xx = $"<text  transform=\"translate({coordinates.xAxis} {coordinates.yAxis})\"" +
                         $" style=\"fill:#3300FF; font-size:28px; font-weight:700;\">" +
                         $"{(int)houseName}</text>";
                compiled += xx;
            }

            var finalGroup = $@"<g id=""HouseNumberLayer"">{compiled}</g>";

            return finalGroup;
        }

        private string GetPlanetsPositionLayer(Time time)
        {
            var compiled = "";
            Dictionary<PlanetName, ZodiacSign> allPlanetsSigns = new Dictionary<PlanetName, ZodiacSign>();

            switch (this.ChartType)
            {
                case ChartType.Bhava:
                    allPlanetsSigns = Calculate.AllPlanetSignsBasedOnHouseLongitudes(time); break;
                case ChartType.RasiD1:
                    allPlanetsSigns = Calculate.AllPlanetZodiacSigns(time); break;
                case ChartType.HoraD2:
                    allPlanetsSigns = Calculate.AllPlanetHoraSign(time); break;
                case ChartType.DrekkanaD3:
                    allPlanetsSigns = Calculate.AllPlanetDrekkanaSign(time); break;
                case ChartType.ChaturthamshaD4:
                    allPlanetsSigns = Calculate.AllPlanetChaturthamsaSign(time); break;
                case ChartType.SaptamshaD7:
                    allPlanetsSigns = Calculate.AllPlanetSaptamshaSign(time); break;
                case ChartType.NavamshaD9:
                    allPlanetsSigns = Calculate.AllPlanetNavamshaSign(time); break;
                case ChartType.DashamamshaD10:
                    allPlanetsSigns = Calculate.AllPlanetDashamamshaSign(time); break;
                case ChartType.DwadashamshaD12:
                    allPlanetsSigns = Calculate.AllPlanetDwadashamshaSign(time); break;
                case ChartType.ShodashamshaD16:
                    allPlanetsSigns = Calculate.AllPlanetShodashamshaSign(time); break;
                case ChartType.VimshamshaD20:
                    allPlanetsSigns = Calculate.AllPlanetVimshamshaSign(time); break;
                case ChartType.ChaturvimshamshaD24:
                    allPlanetsSigns = Calculate.AllPlanetChaturvimshamshaSign(time); break;
                case ChartType.BhamshaD27:
                    allPlanetsSigns = Calculate.AllPlanetBhamshaSign(time); break;
                case ChartType.TrimshamshaD30:
                    allPlanetsSigns = Calculate.AllPlanetTrimshamshaSign(time); break;
                case ChartType.KhavedamshaD40:
                    allPlanetsSigns = Calculate.AllPlanetKhavedamshaSign(time); break;
                case ChartType.AkshavedamshaD45:
                    allPlanetsSigns = Calculate.AllPlanetAkshavedamshaSign(time); break;
                case ChartType.ShashtyamshaD60:
                    allPlanetsSigns = Calculate.AllPlanetShashtyamshaSign(time); break;
                default:
                    break;
            }


            var signs = allPlanetsSigns.GroupBy(ps => ps.Value.GetSignName()).ToDictionary(g => g.Key, g => g.Count());

            foreach (var planetSign in allPlanetsSigns)
            {
                var zodiacSign = planetSign.Value;
                var coordinates = GetPlanetPositionForSignBox(zodiacSign.GetSignName(), signs[zodiacSign.GetSignName()]);
                var xx = $"<text transform=\"matrix(1 0 0 1 {coordinates.xAxis} {coordinates.yAxis})\" font-size=\"{coordinates.fontSize}\" fill=\"black\">{planetSign.Key}</text>";
                compiled += xx;

                //increment for next check
                ChartOccupiedMarker[zodiacSign.GetSignName()]++;
            }

            // reset ChartOccupiedMarker
            foreach (var zodiac in ZodiacSign.All12ZodiacNames) { ChartOccupiedMarker[zodiac] = 0; }

            var finalGroup = $@"<g id=""PlanetLayer"">{compiled}</g>";

            return finalGroup;
        }

        /// <summary>
        /// given a house zodiac sign will return x & y where it starts
        /// </summary>
        private static dynamic GetPlanetPositionForSignBox(ZodiacName zodiacName, int occupancyCount)
        {
            double xAxis = 0;
            double yAxis = 0;

            // determine the font size based on the number of planets in the sign
            int fontSize = 35;
            int jumpCount = 43;
            if (occupancyCount > 3)
            {
                fontSize = 30;
                jumpCount = 30;
            }
            if (occupancyCount >= 4)
            {
                yAxis -= jumpCount; // move the start of the planet list higher
                xAxis += 13; //move little to right, so not to hit house number
            }

            //check if occupancy number
            var occupancy = ChartOccupiedMarker[zodiacName];
            xAxis += ChartPlanetStartCoordinates[zodiacName].xAxis;
            yAxis += ChartPlanetStartCoordinates[zodiacName].yAxis + (occupancy * jumpCount); //if any will go next row

            return new { xAxis = xAxis, yAxis = yAxis, fontSize = fontSize };
        }


        /// <summary>
        /// given a house zodiac sign will return x & y where it starts for placing house number
        /// </summary>
        private static dynamic GetHousePositionForSignBox(ZodiacName zodiacName)
        {
            double xAxis = 0;
            double yAxis = 0;

            xAxis = ChartHouseStartCoordinates[zodiacName].xAxis;
            yAxis = ChartHouseStartCoordinates[zodiacName].yAxis;

            return new { xAxis = xAxis, yAxis = yAxis };
        }


    }

}
