﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace VedAstro.Library
{
    /// <summary>
    /// Logic to create North Indian Astrology Chart in SVG
    /// </summary>
    public class NorthChartFactory
    {

        private ChartType ChartType { get; set; }
        private Time Time { get; set; }
        public string SVGChart { get; set; }

        private const string StaticBackgroundLayer = "<g x=\"0\" y=\"0\"  width=\"1000\" height=\"1000\"  ><style><![CDATA[.K{fill:#fdfefd}.L{fill:#fff}.M{fill:#9e6b2b}.N{fill:#fcfaf8}.O{fill:#945f25}.P{fill:#ad8957}]]></style><path d=\"M967.28 48.2l1.15 12.33v4.91 142.72l-.53 156.79.66 131.03c-1.15 44.32-1.25 88.64 0 132.97l-.66 46.47.54 224.12c-.19 15.04-.86 30.1-.38 45.12.25 7.84-2.48 9.72-9.77 9.38-10.13-.47-20.32.16-30.48.32l-215.66-.45c-30.63-.03-61.25.29-91.88.46H502.15l-221.76-.45c-24.49-.03-48.99.3-73.49.46l-136.93-.51c-5.08-.02-11.6 1.53-9.59-7.58 2.41-3.3 1.48-7.11 1.48-10.71l.08-331.76.1-555.38c.8-.13 1.6-.18 2.41-.16l-.03 2.58-.32 13.51-.01 870.86q0 15.7 16.04 15.71h868.41q16.07 0 16.09-15.64l-.02-770-.26-114.38.06-2.63 2.89-.08z\" class=\"O\"/><path d=\"M967.28 48.2l-2.89.08c-299.98 0-599.97-.01-899.96-.02-.81-.02-1.61.03-2.41.16a15.79 15.79 0 0 1-.21-2.16l86.01-.99h9.83l120.37.41 675.76.16c4.46 0 9.74-2.52 13.49 2.37z\" fill=\"#a07237\"/><path d=\"M61.82 46.27c.01.73.08 1.45.21 2.16l-.1 555.38-.08 331.76c0 3.6.93 7.41-1.48 10.71l-1.34-4.92v-19.68l.46-15.95L59.62 60c0-4.56-2.26-9.79 2.2-13.76z\" class=\"P\"/><path d=\"M964.33 50.91l.26 114.38.02 770q0 15.62-16.09 15.64H80.11q-16.04 0-16.04-15.71l.01-870.86c0-4.5.21-9.01.32-13.52l695.85-.11 204.08.18zm-12.02 445.12l.04-425.68c1.94-10.47-5.01-9.81-11.92-9.81-284.07.05-568.15.1-852.22-.17-9.58 0-13.59 3.12-13.77 12.18l1.62 2.92v107.96c-2.67 2.53-2.58 5.07-.03 7.62-3.35 11.34 0 22.65.02 33.97l-.02 270.87c-2.99 4.19-2.96 8.37 0 12.56-3.18 29.41.03 58.83-.16 88.24-.25.3-.77.66-.71.89.16.68.54 1.31.83 1.96l.03 11.99c-1.74 1.36-2.05 3.19-1.69 5.23 4.06 104.02.96 208.08 1.67 312.12-.27.29-.79.63-.75.86.14.68.5 1.31.78 1.96.12 3.64.06 7.42 5.45 6.88l9.82.28 473.25-.05 374.92.18c8.4.01 13.33-.54 13.29-11.5l-.48-426.53.02-4.94z\" fill=\"#f2982c\"/><path d=\"M964.33 50.91l-204.08-.18-695.85.11.03-2.57 899.96.02-.06 2.63z\" fill=\"#ca812a\"/><path d=\"M75.89 596.7c.19-29.41-3.02-58.83.16-88.24V495.9l.02-270.87c-.02-11.32-3.37-22.63-.02-33.97l.03-7.62V75.48l-1.62-2.92c.17-9.07 4.18-12.19 13.77-12.18l852.22.17c6.91 0 13.85-.66 11.92 9.81-.71-.02-1.43-.03-2.14-.03l-2.76.13-4.95 2.54c-3.1-3.63 1.88-4.6 2.33-7.06-2.76-4.62-7.33-2.8-11.12-2.81-135.13-.09-270.26-.09-405.38 0-3.86 0-8.33-1.63-11.33 2.58-.08 1.6 2.41 3.21-.03 4.79h-5l-2.33-5.61c-3.19-2.67-7.02-1.81-10.63-1.81-133.25-.03-266.49-.03-399.74 0-3.61 0-7.44-.87-10.63 1.81l-4.21 1.4 3.72 4.08c5.02 6.68 11 12.41 17.56 17.56l-.06-.03 23.38 23.7 4.64 4.58 16.38 16.12 2.25 2.19c6.8 8.08 14.03 15.74 22.33 22.32l-.09-.09c2.59 4.09 5.96 7.4 10 10.04 2.53 3.85 5.61 7.15 9.57 9.57l13.18 13.34.83.88 18.26 18.03 7.07 7.13 15.04 15.1 2.15 2.14 17.54 17.53 7.18 7.03c3.42 4.96 7.63 9.13 12.5 12.66 3.38 5.8 8.13 9.35 15.12 9.27-3.75 5.03 3.89 7.88 2.38 12.48-5.99-4.29-11.18-4.7-15.71 2.35-1.4 2.19-4.32 3.41-6.54 5.08-2.66-4.18 1.5-5.82 3.46-7.26 8.11-5.98 7.04-10.71-.1-17.01-9.81-8.66-18.66-18.4-27.95-27.66L81.81 71.32c-4.68-1.03-2.14 2.22-2.3 3.87l.05 115.34-.12 7.78.01 290.31v10.83l9.47-10.76 7.28-7.34c1.67-.13 3.28-2.77 5-.1-2.34 5.93-7.72 9.26-11.99 13.43-4.03 3.93-4.5 6.37-.17 10.6l80.76 79.79 2.17 2.19 12.62 12.5 7.07 7.18 12.61 12.51 7.07 7.17 15.08 14.95 8 8.11 9.22 9.12 7.08 7.18 15.6 15.75c.19.4.49.72.88.94l4.03 4.03c.22.39.53.69.94.88l10.85 10.6c5.99 6.8 10.65 16.09 22.47 11.94-1.06 3.57-6.08 5.83-.69 11.02l81.56 80.42 2.17 2.21 17.51 17.48 2.18 2.2c4.72 4.99 9.92 9.62 14.05 15.05 5.07 6.67 14.55 9.67 15.96 19.29-5.07-.53-7.14-5.05-10.16-8.06L311.93 733.79c-6.41-6.38-11.64-16.36-23.65-10.43 7.48-5.33 4.13-9.39-.93-14.42L178.7 600.5l-95.09-93.96c-1.03-1-2.36-3.02-3.02-2.82-2.43.72-1.18 2.91-1.05 4.6-.15 4.9-.44 9.8-.44 14.69v328.83l.43 72.36.13 5.93c2.24-.18 3.63-1.4 4.33-3.49 6.77-2.77 8.57-12.44 17.32-12.46-3.93 8.18-12.49 12.27-17.32 19.66l-.39 2.73-2.05 2.01c-5.39.54-5.33-3.24-5.44-6.88l-.03-2.82c-.71-104.04 2.39-208.1-1.68-312.13 1.73-1.36 2.09-3.17 1.69-5.23l-.02-11.99-.12-2.85z\" class=\"M\"/><path d=\"M81.49 938.59l2.05-2.01 2.86-1.38 106.84-.25c99.02.61 198.06-2.15 297.06 1.43 7.22.26 14.66 1.07 21.34-2.97 1.26 2.33 2.7 3.78 5.02 1.07l95.77.27 330.36-.32-.09-.31 1.21 1.26 1.08-2.52 2.39-1.29c4.43-2.6 2.25-6.47 1.93-9.99l-.02-415.46.81-3.3 2.17-1.84.48 426.53c.03 10.95-4.89 11.51-13.29 11.5l-374.92-.18-473.25.05c-3.27 0-6.55-.18-9.82-.28zM950.21 70.33l2.14.03-.04 425.68-4.99-.05c2.91-39.49 2.22-79.05 2.17-118.6l-.52-159.37v-7.41l.02-24.6.07-4.91-.09-78.76.02-14.75.37-14.61.85-2.65z\" class=\"O\"/><path d=\"M947.32 495.99l4.99.05-.02 4.94-2.17 1.85c-2.65-.67-4.35.42-5.34 2.85l-31.21 30.53c-2.06 1.93-3.29 7.07-8.12 4.22 2.58-5.77 8.2-8.83 12.03-13.48 8.17-9.93 20-16.54 25.8-28.6l1.76-2.34 1.14.16 1.14-.16z\" class=\"M\"/><path d=\"M76.04 495.9v12.56c-2.96-4.19-3-8.37 0-12.56zm.03-312.46l-.03 7.62c-2.55-2.55-2.64-5.09.03-7.62zm-.04 428.1c.39 2.05.04 3.86-1.69 5.23-.35-2.04-.05-3.86 1.69-5.23zm-.02 317.35l.03 2.82c-.28-.65-.64-1.28-.78-1.96-.05-.22.48-.57.75-.86zm-.12-332.19l.12 2.85c-.3-.65-.68-1.28-.83-1.96-.05-.23.46-.59.71-.89zM74.45 72.57l1.62 2.92-1.62-2.92z\" fill=\"#ca812a\"/><g class=\"L\"><path d=\"M944.82 65.94c-.45 2.46-5.42 3.43-2.33 7.06l.16-.24c-4.53-1.14-6.13.65-5.08 5.09l.17-.16c-5.06-2.18-5.82 2.19-7.61 4.99l.14-.13c-9.29 6.65-16.71 15.23-24.33 23.6a4.08 4.08 0 0 0-1.4 1.4l-18.03 17.86-12.59 12.74a4.36 4.36 0 0 0-1.33 1.34l-7.84 7.66-17.6 17.62-12.36 12.29-3.29 3.7-3.66 3.29-16.02 16.39-4.28 4.12c-.56.35-1.02.8-1.37 1.36l-18.31 18.31c-.58.35-1.05.81-1.39 1.4l-14.01 14.18-3.66 3.31-16.03 16.38-4.28 4.12c-.59.35-1.06.82-1.4 1.41l-7.77 7.62c-3.89 3.36-7.37 7.51-13.33 6.79l.16.15c1.32-3.07.37-3.87-2.62-2.63l.16.16c1.27-3.02.39-3.89-2.62-2.62l.16.16c1.28-3.03.37-3.87-2.63-2.62l.16.16c1.23-2.98.43-3.93-2.62-2.62l.16.16c1.34-3.09.36-3.86-2.62-2.62l.16.16c1.22-2.96.43-3.92-2.62-2.62l.16.16c1.27-3.02.4-3.89-2.62-2.62l.16.16c1.28-3.03.42-3.91-2.62-2.62l.16.16c1.28-3.03.43-3.91-2.62-2.62l.14.16c.36-5.38-2.14-7.89-7.52-7.52l.16.14c1.33-3.07.42-3.91-2.62-2.62l.16.16c1.28-3.03.4-3.89-2.62-2.62l.16.16c1.27-3.02.4-3.89-2.62-2.62l.16.16c1.29-3.03.38-3.87-2.62-2.62l.16.16c1.24-2.98.48-3.96-2.61-2.62l.14.15c1.35-4.74-.75-6.02-5.07-5.07l.16.16c1.24-2.99.39-3.89-2.62-2.62l.16.16c1.29-3.04.39-3.89-2.62-2.62l.16.16c1.22-2.96.44-3.94-2.62-2.62l.16.16c1.28-3.03.41-3.9-2.62-2.62l.16.16c1.29-3.04.41-3.91-2.62-2.62l.16.16c1.29-3.04.41-3.9-2.62-2.62l.16.16c1.3-3.05.34-3.84-2.62-2.62l.16.16c1.23-2.98.36-3.86-2.62-2.62l.16.16c1.24-2.99.4-3.9-2.62-2.62l.16.16c1.28-3.03.41-3.91-2.62-2.62l.16.16c1.25-3 .4-3.9-2.62-2.62l.16.16c1.26-3.01.39-3.89-2.62-2.62l.16.16c1.27-3.02.41-3.91-2.62-2.62l.16.16c1.3-3.04.42-3.9-2.62-2.62l.14.15c.37-5.38-2.17-7.86-7.52-7.52l.15.14c1.29-3.04.42-3.91-2.62-2.61l.15.16c1.27-3.02.42-3.92-2.62-2.62l.16.16c1.27-3.02.39-3.89-2.62-2.62l.16.16c1.28-3.03.41-3.9-2.62-2.62l.16.16c1.29-3.03.41-3.9-2.62-2.62l.15.16c1.31-4.69-.77-6-5.07-5.07l.16.16c1.26-3 .4-3.89-2.62-2.63l.16.16c1.28-3.02.41-3.9-2.62-2.62l.16.16c1.26-3.01.41-3.91-2.62-2.62l.16.16c1.27-3.01.39-3.89-2.62-2.62l.16.16c1.28-3.03.4-3.89-2.62-2.62l.16.16c1.28-3.02.4-3.89-2.62-2.62l.16.16c1.26-3.02.37-3.87-2.63-2.62l.16.17c.9-4.28-.33-6.44-5.07-5.08l.16.15c1.3-3.05.42-3.92-2.62-2.62l.16.16c1.28-3.02.4-3.9-2.62-2.62l.16.16c1.27-3.02.41-3.9-2.62-2.62l.16.16c1.28-3.03.42-3.91-2.62-2.62l.16.16c1.3-3.04.43-3.91-2.61-2.62l.14.15c.44-5.46-2.17-7.87-7.53-7.52l.16.15c1.3-3.07.25-3.77-2.64-2.63l.18.18c1.08-2.84.16-3.69-2.65-2.64l.19.19c1-2.76.24-3.77-2.65-2.65l.19.18c1.2-2.97.32-3.85-2.64-2.64l.18.18c1.17-2.91.5-4-2.62-2.64l.15.16c1.36-4.74-.67-6.09-5.07-5.07l.16.16c1.24-3.01.36-3.87-2.64-2.63l.18.18c1.34-3.11.23-3.75-2.64-2.64l.19.19c1.02-2.79.2-3.73-2.65-2.65l.18.18c1.11-2.86.41-3.93-2.63-2.64l.17.17c1.27-3.01.4-3.89-2.62-2.63l.16.16c1.24-2.98.48-3.96-2.61-2.62l.14.15c.39-5.4-2.11-7.91-7.52-7.52l.15.14c1.37-3.11.39-3.87-2.62-2.61l.16.16c1.25-3 .41-3.91-2.62-2.62l.16.16c1.27-3.02.39-3.89-2.62-2.62l.16.16c1.3-3.05.35-3.85-2.62-2.62l.16.16c1.22-2.96.47-3.96-2.62-2.62l.15.15c1.33-3.08.35-3.85-2.62-2.62l.17.17c1.24-2.98.4-3.89-2.62-2.63l.15.16c1.19-4.58-.49-6.29-5.09-5.07l.16.2c2.43-1.58-.06-3.19.03-4.79l345.47-.17 82.35.41zM101.25 914.2c-8.74.02-10.55 9.69-17.32 12.46l-4.45-2.44-.43-72.36V523.03c0-4.9.29-9.8.44-14.69l4.07-1.78 95.09 93.96L287.3 708.96c5.07 5.02 8.42 9.08.93 14.42l-.17.11c-2.58 2.87-6.26 4.8-7.5 8.8l.15-.17c-2.45.94-5.08 1.79-2.52 5.17l.15-.19-2.78-.14.13 2.78.18-.15c-8.07.4-10.82 7.25-14.99 12.37l.15-.16c-2.43.95-5.11 1.77-2.52 5.17l.15-.19-2.79-.15.14 2.79.18-.15c-1.25-1.96-2.68-1.17-3.79-.03-10.31 10.68-21.99 20.04-30.89 32.08l.15-.16c-2.42.95-5.11 1.77-2.52 5.17l.15-.19-2.78-.14.14 2.78.18-.15c-8.06.42-10.83 7.24-14.99 12.37l.15-.16c-2.39.97-5.12 1.77-2.52 5.17l.15-.19-2.79-.15.14 2.79.18-.15c-7.31.99-11.59 5.01-12.45 12.45l.15-.18-2.79-.14.15 2.79.19-.19-2.79-.15.14 2.8.18-.16c-7.42.88-11.44 5.17-12.46 12.45l.16-.14c-3.38-2.56-4.2.13-5.16 2.52l.16-.15c-2.43.95-5.1 1.78-2.52 5.17l.15-.16c-8.89 1.32-12.49 8.89-17.46 14.83l.15-.16c-2.41.96-5.1 1.78-2.52 5.17l.15-.16c-8.94 1.27-12.46 8.92-17.46 14.83l.15-.16c-2.45.94-5.08 1.79-2.52 5.17l.15-.19-2.78-.14.13 2.78.18-.15c-8.91 2.67-14.88 8.29-17.37 17.38l.22-.23zM79.44 488.63l-.01-290.31c6.23-2.5 5.55-5.1.12-7.78L79.5 75.2l2.3-3.87 176.73 176.1c9.29 9.26 18.14 19 27.95 27.66 7.14 6.3 8.21 11.03.1 17.01-1.95 1.44-6.12 3.09-3.46 7.26l.13-.26c-3.05-1.29-4.1-.58-2.64 2.64l.18-.18-2.75-.13.1 2.77.18-.18c-3.13-1.36-4-.48-2.64 2.64l.18-.16c-7.34.97-11.39 5.23-12.46 12.47l.16-.19c-3.01-1.25-4.12-.59-2.65 2.64l.18-.18-2.75-.13.11 2.77.18-.18c-3.13-1.37-4.01-.49-2.64 2.64l.18-.16c-7.3 1.01-11.42 5.19-12.46 12.46l.16-.18c-3.04-1.28-4.1-.57-2.64 2.64l.18-.18-2.74-.13.1 2.77.18-.18c-3.12-1.36-4-.48-2.65 2.64l.18-.16c-7.32.99-11.42 5.2-12.46 12.46l.16-.18c-3.06-1.29-4.09-.57-2.64 2.64l.18-.18-2.75-.13.11 2.77.18-.18c-3.14-1.38-4.01-.49-2.64 2.64l.18-.16c-7.34.97-11.42 5.2-12.46 12.46l.16-.18c-3.05-1.29-4.09-.56-2.64 2.64l.18-.18-2.75-.12.11 2.77.18-.18c-3.13-1.37-4.01-.49-2.64 2.64l.18-.16c-7.32.99-11.42 5.2-12.46 12.46l.16-.18-2.76-.1.12 2.75.18-.18-2.75-.13.11 2.77.18-.18c-3.17-1.41-3.94-.42-2.64 2.64l.18-.16c-6.64.02-9.83 3.51-10 10l.16-.18-2.74-.13.11 2.77.19-.18c-3.07-1.3-4.07-.54-2.64 2.65l.18-.18-2.75-.12.11 2.77.19-.19c-3.14-1.38-4-.47-2.65 2.64l.18-.16c-7.3 1.01-11.46 5.16-12.46 12.46l.16-.16c-1.69-2.58-3.28-.02-4.92.1l-2.52 2.5.04-.04-2.5 2.54c-1.9 5.87-11.15 6.78-9.94 14.74l.16-.16c-1.69-2.59-3.29-.04-4.93.09l-2.51 2.54c-.15 1.63-2.68 3.22-.1 4.91l.16-.16c-7.98-1.23-8.84 8.07-14.71 9.96-5.57-.62-8.1 1.82-7.49 7.43l-7.28 7.34-9.47-.07zm10.47-319.58c-3.13.45-5.86 1.99-5.16 5.29.66 3.1 3.04 5.89 6.73 5.83 2.76-.05 4.22-2.27 4.29-4.89.11-3.85-2.17-5.79-5.86-6.23z\"/><path d=\"M288.07 723.47l.17-.11c12.01-5.93 17.24 4.05 23.65 10.43l116.14 115.94c3.02 3.01 5.09 7.52 10.17 8.06l-.13-.13c-.31 2.05.55 2.92 2.61 2.61l-.15-.13c.73 4.27 3.31 6.7 7.51 7.51l-.13-.15c-.34 2.08.62 2.86 2.61 2.61l-.15-.15c-.24 1.98.59 2.89 2.61 2.61l-.15-.15c-.28 2.02.6 2.89 2.61 2.61l-.16-.16c-.27 2.01.58 2.91 2.61 2.61l-.15-.15c-.31 2.05.55 2.93 2.61 2.61l-.15-.15c-.3 2.04.57 2.91 2.61 2.61l-.15-.13c1.24 3.76 1.62 8.4 7.51 7.5l-.13-.14c-.26 2 .6 2.88 2.61 2.61l-.15-.15c-.27 2.02.6 2.89 2.61 2.61l-.15-.16c-.27 2.01.57 2.91 2.61 2.61l-.15-.15c-.3 2.04.55 2.93 2.61 2.61l-.15-.13c3.18 5.1 4.98 11.59 12.43 12.42l-.13-.14c-.26 2.01.61 2.88 2.62 2.62l-.16-.16c-.26 2 .58 2.9 2.61 2.61l-.14-.12c1.59 5.04 4.93 8.34 9.95 9.95l-.12-.14c-.29 2.03.54 2.94 2.61 2.61l-.13-.15c-1.07 2.38 1.64 2.85 2.22 4.4-6.68 4.05-14.12 3.23-21.34 2.97-99.01-3.58-198.04-.82-297.06-1.43-35.61-.22-71.23.15-106.84.25l-2.47-1.35c4.82-7.39 13.39-11.48 17.32-19.66l-.22.23c7.09-4.49 12.98-10.19 17.37-17.38l-.18.15c1.81.05 2.63-.9 2.65-2.64l-.15.19c2.54-.89 5.08-1.79 2.52-5.17l-.15.16c9.07-1.12 12.71-8.62 17.46-14.83l-.15.16c2.54-.89 5.07-1.79 2.52-5.17l-.15.16c9.07-1.12 12.72-8.62 17.46-14.83l-.15.16c2.55-.89 5.06-1.79 2.52-5.17l-.16.15c3.39 2.58 4.31.1 5.16-2.52l-.16.14c5.51-2.79 9.61-6.99 12.46-12.45l-.18.16c1.76 0 2.64-.89 2.65-2.65l-.19.19c1.73-.04 2.66-.87 2.64-2.65l-.15.18c5.48-2.82 9.64-6.96 12.45-12.45l-.18.15c1.81.05 2.62-.9 2.65-2.64l-.15.19c2.53-.9 5.07-1.79 2.52-5.17l-.15.16c8.18-.27 11.07-6.95 14.99-12.37l-.18.15c1.81.05 2.63-.9 2.65-2.64l-.15.19c2.57-.88 5.08-1.79 2.52-5.17l-.15.16c1.19 1.97 2.67 1.33 3.81.16 10.35-10.68 22.17-19.95 30.87-32.21l-.18.15c1.82.06 2.63-.89 2.65-2.64l-.15.19c2.56-.89 5.07-1.79 2.52-5.17l-.15.16c8.23-.21 11.04-6.98 14.99-12.37l-.18.15c1.81.05 2.63-.9 2.65-2.64l-.15.19c2.54-.89 5.08-1.79 2.52-5.17l-.15.17c5.74-.17 9.9-1.69 7.5-8.8zm14.92-444.02c-6.99.09-11.74-3.47-15.12-9.27 1.5-9.81-2.61-14.09-12.5-12.66l-7.18-7.03c.57-12.26-5.27-18.11-17.54-17.53l-2.15-2.14c.26-10.29-2.75-17.31-15.04-15.1l-7.07-7.13c-.44-12.56-6.39-18.42-18.26-18.03l-.82-.88c3.32-12.08-3.23-14.39-13.19-13.33-3.96-2.42-7.04-5.72-9.57-9.57 1.31-7.97-1.77-11.58-10-10.04l.09.09c-8.74-14.5 2.76-21.6 11.09-29.55 22.08-21.07 41.12-45.51 67.9-61.38l243.56-.01c0 2.89.29 6.43-2.6 7.72-7.67 3.43-7.64 9.78-7.22 16.51l-2.31 2.38-2.57 2.59.04-.04c-9.64.21-16.89 2.81-14.84 14.77-1.69 3.2-4.19 5.59-7.34 7.32-9.82-1.61-13.97 2.47-12.35 12.32-1.73 3.17-4.11 5.7-7.35 7.36-9.37-1.14-13.49 2.97-12.32 12.35l-2.36 2.45-2.54 2.54-6.44 6.71c-1.61-3.28-4.48-5.39-7.69-3.57-5.79 3.28-2.15 9.33-3.09 14.09-.14 1.63-2.68 3.2-.11 4.89l.15-.15c-1.69-2.6-3.3-.05-4.95.08l-2.48 2.52.03-.03c-13.06-6.52-9.12 4.03-9.89 9.85l-2.38 2.44-2.6 2.61-2.38 2.29c-9.83-1.61-13.96 2.48-12.35 12.33l-2.3 2.4-2.66 2.66-2.4 2.3c-11.66-1.74-16.56 3.21-14.72 14.85l.04-.05-2.6 2.55-2.34 2.33c-9.85-1.61-14.02 2.45-12.37 12.36-1.81 3.56-4.81 5.93-8.02 8.1-4.45.07-10.19-3.61-12.73 2.27-1.19 2.76 3.07 4.05 6.03 4.35-.16 1.66-2.75 3.26-.13 4.99l.16-.16c-5.4-.37-7.94 2.12-7.54 7.54l.16-.18-2.77-.13.13 2.77.18-.18-2.77-.13.13 2.77.24-.15z\"/></g><path d=\"M504.81 919.03c2.39-.36 5.68.16 7.04-1.22 9.78-9.91 21.14-18.36 30.34-28.48 10.54-11.58 20.46-23.62 32.65-33.56.94-.76 2.5-.97 3.12-1.88 18.16-26.51 45.69-43.91 66.45-68.18 9.03-10.56 21.59-19.97 30.94-30.58 8.46-9.6 20.97-16.01 25.69-29.13 4.1-11.42-.62-14.42-8.57-21.88-9.63-9.03-21.23-17.91-27.27-29.41-4.81-9.16-12.92-8.54-18.21-13.28-5.1-4.58-2.35-16.44-13.51-17.64-1.63-.17-4.6-.1-4.68-.56-2.59-13.98-17.75-16.94-24-27.6-1.44-2.45-2.39-6.34-4.45-7.07-9.2-3.25-14.65-8.54-17.54-18.47-1.8-6.18-9.23-2.95-12.48.12-8.24 7.8-18.32 13.32-25.12 23.05-10.72 15.34-24.29 28.21-38.87 40.05-7.59 6.17-13.47 14.15-19.88 21.59-13.6 15.81-31.46 27.09-46.95 40.95-11.46 10.25-30.18 5.53-38.52-9.78-5.17-9.49-10.43-19.56-12.01-30.67-1.09-7.67-5.3-10-12.71-9.74-7.82.28-10.07 4.35-9.43 11.09.71 7.4-3.12 9.31-9.6 8.76-7.36-.62-10.82 3.06-10.07 10.27.83 7.97-3.24 10.47-10.2 9.31-8.09-1.35-9.74 3.77-10.7 9.82-2.2 13.9 2.17 23.25 13.95 32.92 9.58 7.87 20.33 16.17 27.46 27.31 1.93 3.01 4.62 6.75 7.67 7.58 10.32 2.83 12.09 9.79 10.96 18.83l-81.56-80.42c-5.39-5.19-.36-7.45.69-11.02l-.22.07c12.2-9.15 22.34-20.41 32.42-31.73l4.95-4.86c5.64-4.22 10.64-9.07 14.76-14.8l3.62-3.3 13.61-13.87 2.44-2.52c7.31-5.81 13.94-12.3 19.69-19.67 6.51-4.96 12.24-10.69 17.25-17.16l2.44-2.53 3.62-3.3 13.62-13.86 2.46-2.51 3.6-3.32 13.63-13.85 2.43-2.53 3.61-3.26c12.23-11.78 25.13-22.9 35.5-36.49l-.17.14c1.73-.03 2.61-.91 2.64-2.64l-.15.18c4.57-2.08 7.96-5.36 9.98-9.99l-.14.14c5.74-5.7 9.79-3.09 14.7 1.9l85.8 86.06 112.16 111.78c7.03 6.89 6.96 10.89-.24 17.08-5.77 4.95-11.91 9.89-15.67 16.85l.15-.16c-5.23 4.09-12.05 6.86-12.37 15l.14-.15c-8.11.36-10.89 7.16-14.99 12.37l.16-.16c-14.45 11.9-27.57 25.13-39.52 39.52l.16-.16c-22.64 20.11-43.99 41.51-64.13 64.13l.16-.16c-14.41 11.94-27.6 25.1-39.52 39.52l.15-.17c-2.45.94-5.08 1.79-2.52 5.17l.14-.16c-6.58.87-11.35 3.33-9.96 11.25l-1.09 1.08c-3.75-3.01-7.54.21-11.3-.06l.13.15c1.07-2.81.2-3.68-2.61-2.61l.12.14c2.47-3.71-2.55-4.51-2.78-7.18l.52-.49z\" class=\"K\"/><path d=\"M169.79 585.08l-80.76-79.79c-4.33-4.23-3.86-6.67.17-10.6 4.27-4.17 9.65-7.49 11.99-13.43l-.18.12c1.81.06 2.69-.82 2.63-2.63l-.14.17c6.36-3.59 11.36-8.53 14.89-14.93l-.16.16c3.86-1.16 6.35-3.7 7.54-7.54l-.16.16a65.86 65.86 0 0 0 19.84-19.84l-.16.16c5.55-2.76 9.71-6.91 12.46-12.46l-.18.16c1.81.05 2.69-.83 2.65-2.64l-.19.19c1.81.05 2.69-.84 2.65-2.65l-.18.18c1.81.04 2.69-.84 2.65-2.65l-.19.18c1.83.07 2.75-.77 2.64-2.64l-.16.18c4.72-1.94 8.07-5.27 10-10l-.18.16c1.84.07 2.72-.81 2.64-2.64l-.18.18c1.83.07 2.7-.82 2.64-2.64l-.18.18c1.82.06 2.7-.82 2.64-2.64l-.16.18c5.55-2.76 9.69-6.92 12.46-12.46l-.18.16c1.83.06 2.71-.82 2.64-2.64l-.18.18c1.82.06 2.7-.82 2.64-2.64l-.18.18c1.82.06 2.7-.82 2.64-2.64l-.16.18c5.55-2.76 9.66-6.96 12.46-12.46l-.18.16c1.82.05 2.7-.83 2.64-2.64l-.18.18c1.81.05 2.69-.83 2.64-2.64l-.18.18c1.81.05 2.69-.83 2.64-2.64l-.16.18c5.53-2.78 9.7-6.92 12.46-12.46l-.18.16c1.82.06 2.7-.82 2.65-2.64l-.18.18c1.82.06 2.7-.82 2.64-2.64l-.18.18c1.82.06 2.7-.83 2.64-2.64l-.16.18c5.54-2.77 9.7-6.91 12.46-12.46l-.18.16c1.83.07 2.71-.81 2.64-2.64l-.18.18c1.83.07 2.71-.82 2.64-2.64l-.18.18c1.83.07 2.7-.82 2.65-2.64l-.16.19c5.56-2.75 9.7-6.92 12.46-12.47l-.18.16c1.82.06 2.7-.82 2.65-2.64l-.18.18c1.82.06 2.7-.82 2.64-2.64l-.18.18c1.82.06 2.7-.82 2.64-2.64l-.13.26c2.22-1.67 5.14-2.89 6.54-5.08 4.52-7.06 9.72-6.65 15.71-2.35l-.15-.2c-.32 2.06.56 2.93 2.61 2.62l-.15-.14c15.36 19.19 32.53 36.56 51.82 51.83l-.16-.16c.2 4.74 4.36 6.63 7.09 9.37l134.34 134.14c5.69 5.64 10.32 10.67 6.27 19.07l.14-.14c-6.57.09-9.84 3.47-9.98 9.99l.15-.18-2.79-.15.15 2.79.17-.14c-5.42-2.52-6.02 4.54-9.94 5.01-.38-5.81.49-11.24 3.14-16.63 3.9-7.9 1.35-17.46-4-21.32-10.14-7.31-17.46-17.28-25.66-25.85-9.83-10.27-20.18-20.6-30.31-30.32-9.54-9.15-16.32-22.53-30.39-26.67-3.69-1.09-3.11-4.16-4.17-6.68-5.3-12.64-17.98-18.97-27.95-25.4-8-5.16-18.65 6.46-27.08 12.65-2.29 1.68-4.01 4.11-6.15 6-13.58 12-30.25 9-38.56-6.98-3.4-6.54-6.93-13.05-9.73-19.86-6.86-16.67-1.22-31.02 15.75-37.54 7.05-2.71 8.64-6.7 7.79-12.97-.91-6.62-6.94-6.31-11.33-7.15-6.65-1.26-8.26 4.28-9.15 9.13-1.38 7.51-2.62 13.78-12.83 13.93-4.97.07-8.65 4.63-11 10.24-4.39 10.47-19.48 13.46-20.06 27.22-.02.37-3.85.36-5.8.89-10.07 2.73-12.4 8.18-8.42 19.44-1.05 1.98-2.89 2.41-4.91 2.45-7.83-5.46-12.94-2.38-16.1 5.45-1.68 4.18-2.47 9.39-7.23 10.7-7.91 2.18-12.6 6.55-14.67 14.57-.59 2.28-3.59 4.81-6.01 5.6-14.09 4.61-15.93 22.95-30.48 26.9-.51.14-1.04 1.41-1.02 2.14.23 8.33-5.4 11.09-12.1 12.78-6.98 1.75-8.96 6.68-7.84 13.02 1.18 6.67 6.19 7.57 12.06 7.35 9.36-.34 18.77-.63 27.84 2.5 20.78 7.18 39.02 34.17 15.08 54.03-12.37 10.26-18.81 23.22-13.86 39.82zm148.39-206.32c-.72-8.6 8.54-15.38 17.65-12.56 2.95.91 5.52 1.99 7.5-1.06 2.39-3.68.19-5.79-2.82-7.88-11.14-7.73-24.38-10.69-36.67-15.62-5.96-2.39-9.81 2.65-6.89 9.63 4.06 9.72 7.72 19.67 12.6 28.97 1.73 3.3 3 10.3 8.62 8.27 3.96-1.43 1.11-6.38 0-9.74zM161.4 498.26l-3.69 3.1c-5.15 4.05 1.19 14.47-5.98 14.94-4.24.27-8.99-7.34-13.51-11.41l-1.81-1.66c-2.14-1.83-4.32-2.27-6.39.05-2.16 2.41-1.01 4.57.83 6.42 9.52 9.55 18.86 19.3 28.77 28.44 4.09 3.77 7.52 2.53 7.78-3.76.11-2.63-3.21-5.19.21-8.2 3.22.88 6.71 2.67 10.39 1.17 1.96-.8 3.43-2.24 3.73-4.47.32-2.36-.72-4.4-3.09-4.33-12.94.41-16.18-8.3-17.24-20.3z\" class=\"N\"/><path d=\"M229.01 387.78c-3.98-11.26-1.66-16.71 8.42-19.44 1.95-.53 5.78-.52 5.8-.89.58-13.76 15.67-16.75 20.06-27.22 2.35-5.61 6.03-10.17 11-10.24 10.21-.15 11.45-6.42 12.83-13.93.89-4.85 2.49-10.4 9.15-9.13 4.39.83 10.43.53 11.33 7.15.86 6.27-.73 10.26-7.79 12.97-16.97 6.52-22.61 20.87-15.75 37.54 2.8 6.8 6.33 13.32 9.73 19.86 8.31 15.98 24.98 18.98 38.56 6.98 2.15-1.9 3.87-4.32 6.15-6 8.43-6.2 19.08-17.81 27.08-12.65 9.97 6.43 22.65 12.75 27.95 25.4 1.06 2.52.48 5.6 4.17 6.68 14.07 4.13 20.86 17.52 30.39 26.67 10.13 9.72 20.48 20.05 30.31 30.32 8.21 8.57 15.52 18.55 25.66 25.85 5.35 3.86 7.9 13.42 4 21.32-2.66 5.39-3.52 10.82-3.14 16.63l-2.44 2.41c-10.75-.89-16.51 3.21-14.78 14.79-1.73 3.19-4.25 5.59-7.41 7.34-12.1-2.21-16.92 2.82-14.73 14.81l-4.92 4.87c-9.84-1.6-13.94 2.51-12.31 12.35-2.54 4.01-5.87 7.23-9.83 9.81-12.58-4.36-10.77 5.66-12.31 12.32l-2.44 2.44c-13.82-2.31-16.68 6.33-17.24 17.27l-2.43 2.43c-11.58-1.75-16.57 3.11-14.8 14.75h0l-2.46 2.49-4.93 4.88c-11.08-1.2-14.45 5.28-14.75 14.81l-2.44 2.43-2.5 2.43-.02.02c-10.75-.86-16.45 3.29-14.72 14.83l-2.45 2.41c-15.86.06-22.87 7.06-19.68 19.69-.23 1.66-2.77 3.27-.11 5l.22-.07c-11.81 4.16-16.48-5.14-22.47-11.94 3.47-10.78-1.03-13.41-10.85-10.6-.41-.19-.72-.49-.94-.88.28-1.36 1.21-3.08.69-3.98-1.22-2.13-3.11-1.13-4.72-.05-.39-.22-.68-.53-.87-.94 3.45-13.82-5.71-15.14-15.6-15.74l-7.08-7.18c.55-6.7-.19-12.1-9.22-9.12l-8-8.11c2.13-12.21-4.89-15.18-15.08-14.95l-7.07-7.17c1.42-9.84-3.79-12.99-12.61-12.51l-7.07-7.18c4.64-13.1-5.15-11.62-12.62-12.5l-2.17-2.19c-4.95-16.6 1.48-29.56 13.85-39.82 23.93-19.85 5.7-46.84-15.08-54.03-9.07-3.13-18.49-2.84-27.84-2.5-5.87.21-10.88-.68-12.06-7.35-1.12-6.33.86-11.26 7.84-13.02 6.7-1.68 12.33-4.44 12.1-12.78-.02-.73.51-2 1.02-2.14 14.55-3.94 16.39-22.28 30.48-26.9 2.42-.79 5.42-3.32 6.01-5.6 2.07-8.02 6.76-12.38 14.67-14.57 4.75-1.31 5.54-6.52 7.23-10.7 3.15-7.83 8.27-10.91 16.1-5.45.39 6.88-9.4 3-9.67 9.12-.43 9.74-9.19 11.28-14.31 16.49-8.14 8.28-16.75 16.3-24.54 24.85-4.5 4.94-8.25 10.2-14.3 13.37-1.74.91-5.15 1.64-5.14 2.42.18 13.06-9.49 16.79-19.72 20.44 2.51 1.23 4.67 2.23 6.29 1.68 22.95-7.84 38.17 4.71 52.75 19.5 17.21 17.46 17.48 25.31 2.53 45.19-6.3 8.39-15.39 14.08-20.18 24.14-3.86 8.11-3.13 11.68 5.71 12.14 5.29.28 7.19 3.71 8.47 7.53 2.73 8.14 6.53 14.71 15.86 16.74 3.9.85 5.32 4.93 6.2 8.55.83 3.42 2.53 6.58 5.56 7.69 7.33 2.7 12.11 13.03 15.16 13.51 14.69 2.33 16.02 14.58 21.97 23.47.33.5 1.62.81 2.25.58 10.25-3.62 10.5 5.69 12.85 10.74 8.22 17.65 23.52 19.82 35.28 4.53.98-1.28 2.19-3 3.54-3.28 9.53-1.95 11.74-10.04 16.88-16.59 7.26-9.26 16.1-19.67 25.55-25.33 11.23-6.73 12.92-24.47 29.23-23.67.36.02 1.12-1.31 1.14-2.03.32-10.63 3.68-18.39 16.21-18.36 1.13 0 2.87-1.92 3.29-3.28 2.65-8.5 5.45-16.26 17.12-14.43 2.13.33 2.69-3.5 3.35-5.93 2.06-7.47 3.56-15.7 14.8-13.21 2.18.48 4.18-1.78 4.18-3.73-.03-11.36 5.46-17.31 16.67-18.7 1.34-.17 2.95-2.84 3.42-4.62 1.82-6.91 5.65-11.82 12.69-13.63 4.1-1.05 4.86-3.71 4.69-7.36-.16-3.63-2.26-4.68-5.47-5.31-6.73-1.32-9.91-6.62-12.88-12.14-1.29-2.4-.79-6.11-4.29-6.96-15.13-3.67-17.64-22.05-31.72-27.16-2.01-.73-3.03-4.68-4.13-7.3-.96-2.28-1.38-4.85-4.42-5.21-8.63-1.02-10.88-8.53-15.55-14.09-7.35-8.75-20.38-11.68-24.35-24.95-.76-2.53-10.21-4.99-14.09-9.97-1.69-2.17-3.94-2.95-6.37-.99-4.43 3.58-9.96 6.44-13.02 10.97-17.6 25.95-46.59 17.47-59.3-5.28-5.24-9.38-9.32-18.94-11.43-29.47-.6-2.98-1.77-7.62-5.83-6.38-4.19 1.28-12.16-.34-12.15 3.5.06 18.14-22.06 15.85-25.88 29.73z\" class=\"L\"/><path d=\"M253.64 65.9c-26.78 15.87-45.82 40.31-67.9 61.38-8.33 7.95-19.83 15.04-11.09 29.55-8.3-6.58-15.53-14.24-22.33-22.32 8.84.46 12.24-6.18 16.62-12.11 4.54-6.15 4.99-12.26.42-17.78-4.97-6-12.12-6.29-18.81-3.06-3.32 1.6-6.25 3.63-10.11 3.27-5.7-5.64.69-8.25 3.01-11.84 1.38-2.13 2.59-4.37.46-6.45-2.12-2.07-4.36-.84-6.46.58-8.44 5.7-11.28 13.06-6.85 22.63a9.69 9.69 0 0 0-1.56 1.88l-23.38-23.7c18.77-.82 21.57-3.3 24.93-22.02l49.23-.02c-1.72 9.86 3.31 16.62 11.27 20.64 6.04 3.05 12.81 1.42 18.11-3.05 5.85-4.93 5.09-11.23 2.59-17.6l41.85.04zm-89.36 8.67c-4.02-1.23-7.5-2.98-8.73 1.98-1.05 4.21-.5 9.26 2.87 11.31 7.36 4.47 13.74 9.81 19.93 15.71 2.6 2.48 7.02 1.85 10.47 0 2.37-1.27 3.21-3.61 3.06-6.23-.31-5.6-4.82-4.23-8.18-5.02-5.6-1.32-10.18-5.04-10.73-10.45-.7-6.82-2.55-9.88-8.69-7.29z\" class=\"K\"/><path d=\"M944.82 65.94l-82.35-.41L517 65.7c3-4.2 7.47-2.57 11.33-2.58h405.38c3.79 0 8.36-1.81 11.12 2.81zm-691.18-.04l-41.85-.04h-4.9l-19.71.04c-2.45 0-4.91-.01-7.36-.02l-49.23.02-41.95-.99c3.18-2.68 7.02-1.81 10.63-1.81h399.74c3.61 0 7.44-.86 10.63 1.81l-12.45.99-243.56.01z\" class=\"P\"/><path d=\"M408.18 823.45c9.03-1.18 16.34.45 18.64 10.93.31 1.43 1.67 3.03 2.98 3.77 20.76 11.84 30.69 34.92 50.56 48.2 7.32 4.9 11.74 14.68 21.01 19.1 5.05 2.4 2.75 8.86 3.44 13.57l-.52.49c-2.66-.22-3.46-5.27-7.17-2.78l.14.12c1.2-2.94.34-3.82-2.61-2.61l.16.16c1.2-2.95.34-3.83-2.62-2.62l.13.14c-1.27-7.01-5.64-10.93-12.43-12.42l.15.13c1.08-2.83.46-3.94-2.61-2.61l.15.15c1.29-3.03.29-3.77-2.61-2.61l.15.16c1.17-2.92.38-3.87-2.61-2.61l.15.15c1.22-2.96.33-3.82-2.61-2.61l.13.14c.36-5.37-2.3-7.71-7.51-7.5l.15.13c1.23-2.97.29-3.77-2.61-2.61l.15.15c1.18-2.92.35-3.83-2.61-2.61l.15.15c1.11-2.85.2-3.69-2.61-2.61l.16.16c1.1-2.84.47-3.96-2.61-2.61l.15.15c1.3-3.04.33-3.81-2.61-2.61l.15.15c1.24-2.98.38-3.86-2.61-2.61l.13.15c.29-5.3-2.26-7.75-7.51-7.51l.15.13c1.2-2.94.36-3.84-2.61-2.61l.13.13c-1.42-9.62-10.9-12.62-15.96-19.29-4.13-5.44-9.33-10.07-14.05-15.05z\" class=\"K\"/><path d=\"M88.65 64.9l41.95.99c-3.35 18.72-6.16 21.2-24.93 22.02l.06.03c2.17-9.78-3.36-15.3-17.56-17.56l-3.72-4.08 4.21-1.4zm51.79 39.92c3.86.35 6.79-1.67 10.11-3.27 6.69-3.23 13.84-2.94 18.81 3.06 4.57 5.52 4.12 11.63-.42 17.78-4.38 5.93-7.78 12.56-16.62 12.11l-2.25-2.19c1.36-7.62 14.83-10.69 10.46-18.18-3.77-6.46-13.06 2.28-20.09.53v-9.84z\" class=\"L\"/><path d=\"M140.44 114.66c7.02 1.75 16.32-6.99 20.09-.53 4.37 7.49-9.1 10.57-10.46 18.18l-16.38-16.12c.67-.44 1.28-.95 1.84-1.54h4.92zM497.2 65.89l12.45-.99 2.33 5.61.12-.18c-4.47-1.09-6.06.71-5.08 5.07l.15-.15c-5.36-.34-7.96 2.08-7.53 7.53l.15-.18-2.77-.1.13 2.74.18-.18-2.76-.13.12 2.77.18-.18-2.75-.12.11 2.76.17-.15c-1.72-2.66-3.35-.04-5.02.09-.42-6.72-.45-13.08 7.22-16.51 2.89-1.29 2.6-4.83 2.6-7.72zm452.15 7.09l-.37 14.61c-8.72-2.5-14.99 6.58-23.52 4.97.4-3.91 7.51-4.6 4.8-10l-.14.13c4.98 2.06 6.06-1.82 7.61-4.99l-.17.16c2.9-.49 4.62-2.16 5.08-5.09l-.16.24 4.95-2.54 1.91 2.52zM208.13 190.57c11.87-.39 17.82 5.47 18.26 18.03l-18.26-18.03zm180.36 613.2c11.67-.02 19.14 4.18 17.51 17.48l-17.51-17.48zM88.17 70.39c14.2 2.25 19.73 7.77 17.56 17.56-6.56-5.14-12.54-10.87-17.56-17.56zm162.48 162.58c12.26-.57 18.11 5.27 17.54 17.53l-17.54-17.53z\" class=\"K\"/><path d=\"M250.7 665.99c9.89.6 19.05 1.92 15.6 15.74l-15.6-15.74zm-39.38-39.36c10.19-.22 17.22 2.74 15.08 14.95l-15.08-14.95z\" class=\"N\"/><path d=\"M233.46 215.73c12.29-2.21 15.3 4.81 15.04 15.1l-15.04-15.1zm-39.34-39.38c9.96-1.06 16.5 1.26 13.19 13.33l-13.19-13.33z\" class=\"K\"/><path d=\"M171.96 587.26c7.46.88 17.26-.6 12.62 12.5l-12.62-12.5zm100.18 100.33c9.81-2.81 14.31-.18 10.85 10.6l-10.85-10.6z\" class=\"N\"/><path d=\"m275.37,257.53c9.89-1.43,14,2.84,12.5,12.66-4.87-3.53-9.08-7.7-12.5-12.66Z\" class=\"K\"/><path d=\"M191.65 606.94c8.81-.47 14.03 2.68 12.61 12.51l-12.61-12.51zM79.44 488.63l9.47.07-9.47 10.76v-10.83z\" class=\"N\"/><path d=\"m174.55,156.74c8.24-1.54,11.31,2.07,10,10.04-4.04-2.64-7.41-5.96-10-10.04Z\" class=\"K\"/><path d=\"M234.4 649.69c9.03-2.98 9.77 2.42 9.22 9.12l-9.22-9.12zM96.19 481.36c-.6-5.6 1.93-8.05 7.49-7.43-.14 1.66-2.79 3.22-.18 4.98l.14-.17-2.74-.13.1 2.77.18-.12c-1.72-2.67-3.34-.02-5 .1zM79.54 190.54c5.43 2.68 6.11 5.28-.12 7.78l.12-7.78zm-.05 733.67l4.45 2.44c-.69 2.09-2.09 3.31-4.33 3.49l-.13-5.93zm187.69-241.53c1.61-1.09 3.5-2.08 4.72.05.52.9-.41 2.63-.69 3.98l-4.03-4.03z\" class=\"N\"/><path d=\"M133.69 116.19l-4.64-4.58a9.69 9.69 0 0 1 1.56-1.88c3.2.08 4.84 1.72 4.92 4.92-.55.58-1.17 1.1-1.84 1.54z\" class=\"K\"/><path d=\"M81.8 71.34l-2.3 3.87c.16-1.65-2.38-4.9 2.3-3.87zm1.77 435.21l-4.07 1.78c-.13-1.69-1.39-3.88 1.05-4.6.67-.2 2 1.82 3.02 2.82z\" class=\"N\"/><path d=\"M83.93 933.85l2.47 1.35-2.86 1.38.39-2.73z\" class=\"P\"/><path d=\"M949.35 72.98l-1.91-2.52 2.76-.13-.85 2.65z\" fill=\"#d9cbb3\"/><path d=\"M905.45 540.42c4.84 2.85 6.06-2.29 8.12-4.21 10.63-9.93 20.85-20.31 31.21-30.53l4.53.44.02 415.46c-2.38 2.27-1.53 5.31-1.96 8.05L737.89 721.27c-5.17-5.12-.72-7.56.55-11.21l-.15.14c17.04-13.78 31.34-30.38 46.94-45.64 1.16-1.13 1.88-2.6-.12-3.8l-.16.16c5.5.47 7.98-2.08 7.54-7.54l-.16.16c9.29-2.3 14.79-8.38 17.38-17.38l-.16.16c11.02-3.85 18.2-11.54 22.3-22.3l-.16.16c13.36-6.43 23.02-16.55 29.68-29.68l-.15.16c11.52-4.99 20.13-12.88 24.76-24.76l-.16.19 2.8.15-.14-2.8-.19.16c9.17-2.41 14.92-8.26 17.38-17.38l-.24.21zM520.74 929.08l1.09-1.08c3.4-3.68 8.08-6.23 9.96-11.25l-.14.16c2.43-.95 5.06-1.79 2.52-5.17l-.15.17c2.79 2.87 4.16-.22 5.53-1.58l32.43-32.41c1.36-1.38 4.44-2.76 1.56-5.54l-.16.16c2.03 2.7 3.63.38 4.76-.74l58.64-58.64c1.15-1.16 3.44-2.73.72-4.75l-.16.16c3.63 3.36 4.85-.91 6.37-2.39 10.38-10.1 20.62-20.36 30.68-30.78 1.47-1.52 5.77-2.69 2.48-6.35l-.16.16c8.16-.29 10.91-7.14 14.99-12.37l-.14.15c5.16-4.14 12.12-6.8 12.37-15 0 0-.15.16-.16.16 9.68-.42 12.91-9.4 18.49-14.8 6.11-5.91 9.26-7.34 16.12-.4l197.69 198.23c2.64 2.65 7.08 4.33 6.72 9.28l-330.36.32c-31.92.02-63.85-.17-95.77-.27l4.06-5.4z\" class=\"L\"/><path d=\"M942.81 934.42c.36-4.95-4.08-6.63-6.72-9.28L738.4 726.91c-6.87-6.93-10.02-5.51-16.12.4-5.58 5.4-8.81 14.38-18.49 14.8 3.76-6.97 9.91-11.9 15.67-16.85 7.21-6.19 7.28-10.18.24-17.08L607.54 596.4l-85.8-86.06c-4.91-4.99-8.97-7.6-14.7-1.9 4.05-8.4-.57-13.43-6.27-19.07L366.43 355.23c-2.73-2.74-6.89-4.63-7.09-9.37 11.51 3.81 16.35 15.51 25.78 21.77l.13.04 4.15 4.12.78.78 15.78 15.73 2.15 2.13 17.54 17.54 7.21 7.01c8.34 10.14 17.85 19.12 27.62 27.84l6.69 6.66L484.71 467l4.66 4.6c3.18 4.61 7.11 8.47 11.68 11.69l8.04 7.98c3.52 6.47 6.93 5.88 10.24-.17l2.61-.06c-6.24 9.46.4 14.6 6.37 20.55l192.06 192.07c5.22 5.23 9.76 10.68 18.08 6.4-1.27 3.64-5.72 6.09-.55 11.21l209.48 208.36a5.01 5.01 0 0 0 .02 1.93l-2.39 1.29-2.29 1.26.09.31zm-422.07-5.34l-4.06 5.4c-2.33 2.71-3.77 1.26-5.03-1.07-.57-1.55-3.29-2.02-2.22-4.4 3.77.27 7.55-2.95 11.3.06z\" class=\"M\"/><path d=\"M947.41 931.57c-.13-.64-.14-1.29-.02-1.93.43-2.74-.42-5.79 1.96-8.05.32 3.52 2.49 7.39-1.93 9.99zm1.91-425.45l-4.53-.44c.99-2.43 2.69-3.52 5.34-2.85l-.81 3.29z\" fill=\"#d9cbb3\"/><path d=\"M942.72 934.11l2.29-1.26-1.08 2.52-1.21-1.26z\" class=\"P\"/><path d=\"M925.47 92.56c8.53 1.61 14.8-7.47 23.52-4.97l-.02 14.75c-12.44 1.41-11.37 10.92-11.23 19.4.18 10.6.13 22.39-10.84 26.52-14.93 5.62-22.98 21-38.83 24.68-5 1.16-5.72 5.81-3.27 9.91 2.07 3.47 5.04 7.36 9.71 3.05 7.01-6.47 14.79-7.08 22.26-1.95 9.38 6.45 9.66 16.54 8.11 26.61-1.01 6.59-6.8 8.65-11.99 11.18-6.31 3.08-7.52-2.89-10.42-5.71-7.06-6.84-13.57-14.32-21.1-20.58-5.55-4.62-11.9-8.31-15.72 3.09-2.06 6.16-7.6 11.27-13.42 13.84-10.99 4.87-7.26 11.21-2.45 17.08 5.43 6.62 12.08 12.23 18.05 18.42 9.31 9.66 7.68 16.01-3.79 23.16-8.56 5.34-16.52 2.05-24.82 1.09h-.01c-1.15-9.77-7.15-19.45-.15-29.34 3.36-4.75 1.81-7.99-3.37-10.65-5.49-2.82-8.56-1.05-10.48 4.04-3.43 9.1-9.47 14.96-19.22 17.09-4.89 1.07-6.84 4.21-3.69 9-1.68 3.07-2.85 6.26-2.46 9.84-7.16-.34-8.55 3.36-6.33 9.3l8.79 22.69-9.84-4.92v-4.92c-.08-3.2-1.72-4.84-4.92-4.92v-7.38c0-3.68 1.08-7.81-.23-10.94-2.52-6.05 9.6-16.95-2.87-17.67-13.61-.78-5.43 11.94-6.75 18.77-5.72.96-12.04-2.28-17.22 2.46h-7.38c5.16-11.27 16.27-17.51 25.02-24.42 7.15-5.64 10.72-16.69 21.73-17.4-.71 5.07-4.89 11.6 5.05 12.23 5.9.37 11.52-1.99 11.32-7.92-.25-7.55-7.51-2.99-11.52-4.27-.73-.23-1.59-.03-2.39-.03.1-2.42.19-4.66 1.84-6.85 9.65-12.81 24.09-21.14 32.61-34.97v4.91c-.06 5.86 1.66 11.6 8.22 11.22 5.01-.29 11.4-3.76 10.7-9.84-.75-6.47-7.43-6.25-12.79-6.29-2.05-.01-4.09 0-6.14 0 1.06-2.32 2.98-3.56 5.16-4.84 7.97-4.66 3.9-6.72-1.98-8.22l8.29-8.36c8.76 7.47 12.1-4.15 18.27-5.87 4.08-1.13.13-6.64-2.54-9.58l2.49-2.46c5.81 1.49 9.38-3.71 14.26-4.79 9.94-2.2 7.91-6.88 2.95-12.43l4.87-4.95c5.35.5 7.81-1.91 7.33-7.28l5-4.99c2.43.35 3.57 6.73 6.24 2.67 3.48-5.29 10.75-9.18 8.44-17.37l4.93-4.9c2.47 2.26 4.79 5.05 8.89 3.12-.89-3.99-4.16-4.18-6.35-5.68l2.46-2.47zm-39.1 73.69c6.14-1.18 12.52-4.47 18.03-9.68 5.02-4.75 9.02-10.77 15.76-13.44 6.79-2.7 9.31-7.83 11.12-14.76 1.9-7.27 0-12.03-6.51-13.03-6.95-1.07-11.76 3.1-10.67 10.89.53 3.74-.09 6.49-3.84 5-9.4-3.75-12 4.58-14.83 9.14-3.43 5.52-4.63 11.49-12.87 12.35-4.17.43-4.17 5.48-3.77 9.27.4 3.77 3.17 4.31 7.57 4.28z\" class=\"L\"/><path d=\"M839.22 272.14c8.3.96 16.26 4.25 24.82-1.09 11.47-7.15 13.09-13.51 3.79-23.16-5.97-6.19-12.62-11.8-18.05-18.42-4.81-5.87-8.54-12.21 2.45-17.08 5.82-2.58 11.35-7.68 13.42-13.84 3.81-11.4 10.17-7.7 15.72-3.09 7.53 6.26 14.04 13.74 21.1 20.58 2.9 2.82 4.11 8.79 10.42 5.71 5.19-2.53 10.98-4.59 11.99-11.18 1.55-10.06 1.27-20.16-8.11-26.61-7.47-5.13-15.25-4.53-22.26 1.95-4.66 4.3-7.64.41-9.71-3.05-2.45-4.1-1.73-8.75 3.27-9.91 15.85-3.69 23.9-19.07 38.83-24.68 10.97-4.13 11.01-15.92 10.84-26.52-.14-8.48-1.21-17.99 11.23-19.4l.09 78.76c-8.55.27-18.09 1.42-8.26-11.63 2.6-3.45 2.53-7.64-.46-11.29-2.5-3.05-5.56-4.7-9.6-3.83-11.26 2.43-16.1 16.86-9.65 26.33 7.85 11.53 17.27 10.61 27.91 5.32l-.02 24.6c-6.5-.02-12.61-.45-18.02 5.2-15.55 16.29-32.12 31.63-47.46 48.11-5.64 6.06-12.36 11.88-14.75 20.51h-2.46c-8.56 3-14.86 9.15-21.31 15.13-5.17 4.79-10.45 9.35-18.06 4.55-3.66-14.32-.63-18.02 14.67-17.61 2.67.07 4.87-.44 6.16-2.8 1.53-2.81-.32-4.66-2.45-5.93-2.46-1.47-4.93-2.79-6.06-5.63zm59.05-41.82c.01-13.97-7-21.63-20.19-22.1-9.88-.35-16.76 7.26-16.67 18.45.08 9.92 10.67 20.61 20.62 20.81 11.88.23 16.23-4.37 16.24-17.16z\" class=\"K\"/><g class=\"L\"><path d=\"M947.32 495.99l-1.14.16-1.14-.16c-1.29-1.62-1.79-4.85-5.04-2.48l.19.18c1.18-2.96.34-3.89-2.67-2.67l.21.21c1.19-2.97.3-3.86-2.67-2.67l.21.21c1.23-3.01.31-3.86-2.67-2.67l.21.2c1.22-3 .34-3.89-2.67-2.66l.21.2c1.2-2.98.34-3.89-2.66-2.67l.2.2c1.21-2.98.32-3.87-2.67-2.67l.21.21c1.18-2.96.28-3.84-2.67-2.67l.21.21c1.18-2.96.28-3.83-2.66-2.67l.18.2c2.49-2.52-1.47-4.68-.4-7.13l5.95 1.15q16.52 3.73 16.53-13.02V244.97q0-19.97-17.22-12.23c3.51-11.92 11.91-15.99 23.63-14.74l.52 159.37c.05 39.54.74 79.1-2.17 118.6zm1.67-309.98c-10.64 5.28-20.07 6.21-27.91-5.32-6.44-9.47-1.61-23.9 9.65-26.33 4.04-.87 7.11.79 9.6 3.83 2.99 3.65 3.06 7.84.46 11.29-9.83 13.05-.29 11.89 8.26 11.63l-.07 4.91zm-18.91-15.21c2.19-.42 3.97-1.68 4.06-3.86.11-2.89-2.29-3.04-4.29-2.46-1.96.57-3.79 1.86-3.44 4.3.29 2 1.95 2.26 3.67 2.02z\"/><path d=\"M948.96 218.02c-11.72-1.24-20.12 2.83-23.63 14.74l-2.46 2.46c-3.55 0-6.01 1.65-7.38 4.92-10.55 10.01-23.14 18.14-29.53 31.99-3.2.08-4.84 1.72-4.92 4.92a15.38 15.38 0 0 0-7.38 7.38h-4.92c2.39-8.63 9.12-14.45 14.75-20.51 15.34-16.48 31.9-31.82 47.46-48.11 5.4-5.66 11.52-5.22 18.02-5.2v7.41z\"/></g><path d=\"M738.46 710.07c-8.31 4.28-12.86-1.17-18.08-6.4L528.32 511.6c-5.97-5.95-12.61-11.09-6.37-20.55l-.25.08c7.6 1.35 8.66-6.14 12.81-9.46 13.84-12.42 27.07-25.44 39.37-39.4 6.49-4.98 12.23-10.7 17.26-17.15l2.43-2.53 3.61-3.31 13.62-13.85 2.45-2.52 3.6-3.27 13.67-13.88 19.66-19.69 2.42-2.52 2.48-2.48c6.52-4.97 12.25-10.72 17.25-17.21 1.71-1.27 4.67-2.63 2.2-4.93-1.54-1.44-2.97 1.35-4.19 2.64l-5.82 4.39c.34-9.52 3.72-16 14.8-14.76-.86 1.71-2.88 4.08-2.36 5.01 1.42 2.52 3.4.42 4.63-.8 2.78-2.77 5.31-5.79 7.93-8.72l2.44-2.53c10.82-10.49 22.22-20.48 32.25-31.68 5.54-6.19 9-4.53 13.53-.06l4.82 4.96 2.56 2.42 2.47 2.46 2.48 2.49c1.39 2.05 2.32 4.67 5.56 4.35l-.14-.13c.15 3.23 1.84 4.93 5.07 5.08l-.15-.15c-.27 3.21 2.15 4.31 4.37 5.56l2.48 2.5 2.46 2.46 2.47 2.45 2.42 2.48 2.51 2.48 4.85 4.88 2.49 2.48 2.48 2.45 2.46 2.46 2.46 2.47 2.48 2.52 4.87 4.85 2.47 2.49 2.5 2.42 2.47 2.45 2.44 2.48 2.46 2.47 2.49 2.51 7.31 7.33 2.53 2.44 2.46 2.46 2.43 2.48 2.44 2.48 2.51 2.49 7.31 7.33 2.53 2.44 2.46 2.46 2.45 2.48 2.5 2.49 7.32 7.33 2.46 2.5 2.5 2.42 2.44 2.47 2.46 2.46 2.46 2.48 2.45 2.46 2.5 2.48 4.84 4.89 2.55 2.44 2.44 2.48 2.46 2.46 2.45 2.47 2.47 2.5 7.07 6.99 2.88 2.66 2.47 2.48 2.46 2.46 2.49 2.43 2.45 2.52c2.04 3 3.79 6.33 7.91 6.98l-.18-.2c-.22 1.99.77 2.78 2.66 2.67l-.21-.21c-.13 1.91.74 2.82 2.67 2.67l-.21-.21c-.14 1.92.74 2.81 2.67 2.67l-.2-.2c-.16 1.94.75 2.8 2.66 2.67 0 0-.21-.2-.21-.21-.13 1.9.69 2.86 2.67 2.66l-.21-.2c-.15 1.93.8 2.75 2.67 2.67l-.21-.21c-.13 1.91.76 2.8 2.67 2.67l-.21-.21c-.13 1.91.75 2.8 2.67 2.67l-.19-.18c-.36 2.59 1.88 3.43 3.28 4.82-5.79 12.06-17.63 18.68-25.8 28.6-3.83 4.65-9.45 7.71-12.03 13.48l.24-.21c-7.01 4.57-12.82 10.36-17.38 17.38l.19-.16c-1.74.03-2.59.94-2.65 2.65l.16-.19c-9.47 7.03-17.78 15.24-24.76 24.76l.15-.16c-11.19 8.6-21 18.58-29.68 29.68l.16-.16c-8.63 6.23-16.1 13.63-22.3 22.3l.16-.16c-6.97 4.62-12.87 10.31-17.38 17.38l.16-.16c-3.73 1.3-6.21 3.85-7.54 7.54l.16-.16c-17.04 13.76-31.28 30.39-46.87 45.63-1.16 1.13-1.92 2.56.05 3.8l.15-.14zm181.85-209.59c3.09-14.4-23.82-11.22-21.12-28.4.3-1.91-3.54-2.94-6.11-3.05-.82-.03-1.64-.05-2.45-.15-5.96-.78-9.62-3.32-9.81-10.17-.17-5.98-3.29-9.75-10.2-9.51-7.39.26-8.88-5.18-12.22-10.87-6.33-10.79-19.85-16.02-25.26-28.31-.14-.32-1.55-.1-2.37-.11-12.31-.2-8.49-11.75-12.81-17.3-4.32-5.54-18.3-.38-17.98-13.56.16-6.39-2.33-8.84-8.65-8.6-6.18.24-11.19-3.26-10.77-9.26.83-11.89-8.83-10.03-14.81-13.85-5.78-3.69-1.3-16.13-12.25-17.2-7.87-.77-10.52-4.92-10.81-12.86-.22-5.86-5.4-9.29-11.64-7.74-5.39 1.34-13.13 2.84-11.26 10.21 2.95 11.59-3.59 11.41-11.17 11.46-6.86.04-10.05 3.51-8.11 10.18 2.15 7.38-.61 10.03-7.7 9.47-7.73-.61-11.8 2.61-11 10.65.7 7.05-2.5 9.9-9.29 9.03-8.02-1.03-11.48 2.32-10.44 10.4.87 6.74-1.87 9.94-8.98 9.38-5.19-.41-10.35.28-10.42 7.21-.07 6.89 5.01 8.1 10.23 7.38 17.37-2.41 29.56 5.71 40.74 17.87 13.24 14.41 12.68 26.09 1.29 42.25-12.97 18.42-33.69 28.28-46.83 46.13-4.09 5.55-8.31 11.4-13.68 15.53-11.46 8.83-20.99 19.23-29.99 30.44-5.03 6.26-5.45 12.7-.95 17.87 8.54 9.81 15.89 23.08 26.22 28.32 12.51 6.35 13.28 24.11 28.85 24.93.88 16 21.05 15.98 24.82 30.15 1.79 6.73 13.99 5.52 15.06 10.52 3.33 15.44 21.11 14.58 26.99 26.54 1.55 3.16 6.62 3.38 8.45.2 5.92-10.29 17.59-14.03 24.68-23.07 13.26-16.91 30.21-30.39 45.01-45.91 9.6-10.08 20.91-19.64 30.07-29.91 6.42-7.21 15.67-11.57 20.24-19.83 7.7-13.91 22.3-20.49 32.46-32 9.46-10.72 19.19-21.87 29.98-31.69 2.62-2.38 4.03-6.15 4.03-12.75z\" class=\"K\"/><path d=\"M943.27 498.33c-1.41-1.4-3.64-2.23-3.28-4.82 3.25-2.37 3.75.86 5.04 2.48l-1.76 2.34z\" class=\"O\"/><g class=\"M\"><path d=\"M737.75 292.41c-4.52-4.47-7.99-6.13-13.53.06-10.03 11.2-21.43 21.19-32.25 31.68l-2.29-1.95 6.83-8.24 2.47-2.44 2.55-2.51 4.78-5.08c7.09-7.74 19.01-11.59 19.66-24.5 5.96.72 9.44-3.43 13.33-6.79l1.93 2.37c-.8 3.72-6.85 4.41-5.43 9.41l4.11 5.77-2.15 2.21zM925.47 92.56l-2.46 2.47-2.54 2.55-4.93 4.9-7.04 5.17-2.56-1.5c7.62-8.37 15.04-16.95 24.33-23.6 2.71 5.4-4.4 6.09-4.8 10zm-59.03 59.06l-2.49 2.46-14.51 12.6-2.31-1.9 17.6-17.62 2.02 2.36-.32 2.09zm34.41-34.43l-5 4.99-7.03 5.14-2.32-1.9 18.04-17.86 1.53 2.61-5.21 7.02zM787.84 224.24l18.31-18.31 1.51 2.67c-5.02 6.46-10.8 12.16-17.26 17.17l-2.57-1.53zm23.96-23.78l16.02-16.39 1.93 2.33-15.77 16.17-2.18-2.12zm-59.05 59.05l16.03-16.38 1.92 2.32-15.78 16.16-2.17-2.1z\"/><path d=\"M848.22 169.52l-8.29 8.36-2.77 1.23-2.38-2.03 12.36-12.29 2.3 1.9-1.22 2.84zm-75.78 70.3l14.01-14.18 1.53 2.65-13.36 13.64-2.18-2.12zm116.08-110.37l-4.87 4.95-7.08 5.31-2.67-1.55 12.6-12.74 2.32 1.9c-.14.71-.24 1.42-.3 2.14zM703.97 257.44c-4.2-.81-6.68-3.35-7.52-7.52 5.38-.37 7.89 2.14 7.52 7.52zM546.49 99.96c-4.23-.78-6.74-3.29-7.52-7.52 5.41-.4 7.91 2.12 7.52 7.52zm318.25 47.2l7.84-7.66 1.5 2.65-7.32 7.38-2.01-2.36zm-219.83 51.22c-4.2-.81-6.69-3.34-7.52-7.52 5.35-.34 7.89 2.14 7.52 7.52zm94.38 74.27l7.77-7.62 1.54 2.61-7.38 7.38-1.93-2.37zM585.86 139.33c-4.25-.76-6.74-3.29-7.53-7.52 5.36-.35 7.97 2.06 7.53 7.52zM937.74 77.7c-1.55 3.17-2.63 7.05-7.61 4.99 1.79-2.8 2.55-7.17 7.61-4.99zm-334.65 78.87c-3.23-.15-4.92-1.85-5.07-5.08 4.75-1.36 5.98.79 5.07 5.08zm81.19 81.18c-3.24-.14-4.93-1.83-5.07-5.07 4.33-.95 6.42.33 5.07 5.07z\"/><path d=\"M942.65 72.76c-.46 2.93-2.18 4.6-5.08 5.09-1.05-4.43.55-6.23 5.08-5.09zm-420.76 2.61c-3.25-.14-4.82-1.95-5.09-5.07 4.6-1.22 6.28.49 5.09 5.07zM625.23 178.7c-3.22-.16-4.93-1.83-5.07-5.07 4.3-.92 6.38.38 5.07 5.07zm-59.05-59.05c-3.24-.14-4.96-1.81-5.07-5.07 4.4-1.02 6.43.33 5.07 5.07zm265.31 61.13l3.29-3.7 2.38 2.03-3.49 3.77-2.18-2.1zm-62.71 62.35l3.66-3.31 2.18 2.12-3.92 3.51-1.92-2.32z\"/><path d=\"M827.83 184.07l3.66-3.29 2.18 2.1-3.91 3.53-1.93-2.33zm-20.32 20.5l4.29-4.11 2.18 2.12-3.92 3.5-2.56-1.5zm-59.05 59.05l4.29-4.12 2.17 2.1-3.91 3.5-2.55-1.49zM627.7 181.16c-2.01.26-2.91-.58-2.62-2.62 3.03-1.28 3.9-.41 2.62 2.62zm63.98 63.98c-2 .25-2.87-.63-2.62-2.62 3.02-1.27 3.89-.4 2.62 2.62z\"/><path d=\"m689.22,242.68c-1.99.25-2.86-.64-2.62-2.62,3-1.25,3.91-.41,2.62,2.62Z\"/><path d=\"M686.76 240.22c-2 .25-2.92-.58-2.61-2.62 3.09-1.34 3.85-.36 2.61 2.62zm-7.39-7.38c-2 .25-2.87-.63-2.62-2.62 3.01-1.26 3.86-.36 2.62 2.62z\"/><path d=\"M676.91 230.37c-2.03.28-2.88-.62-2.62-2.62 3.01-1.27 3.91-.42 2.62 2.62zm19.69 19.69c-2.02.28-2.89-.6-2.62-2.62 3.04-1.29 3.94-.45 2.62 2.62zm89.85-24.42c.35-.58.82-1.05 1.39-1.4l2.56 1.53-2.42 2.52-1.53-2.65z\"/><path d=\"m674.45,227.91c-2,.25-2.87-.63-2.62-2.62,3.06-1.32,3.84-.34,2.62,2.62Z\"/><path d=\"m671.99,225.45c-2,.25-2.86-.63-2.62-2.62,3.03-1.28,3.9-.41,2.62,2.62Z\"/><path d=\"m669.53,222.99c-1.99.24-2.86-.63-2.62-2.62,3.03-1.29,3.91-.42,2.62,2.62Z\"/><path d=\"m667.07,220.53c-1.98.23-2.9-.59-2.62-2.62,3.03-1.28,3.91-.41,2.62,2.62Z\"/><path d=\"M664.61 218.07c-2.01.27-2.88-.61-2.62-2.62 2.96-1.22 3.92-.43 2.62 2.62zm41.83 41.83c-1.98.23-2.91-.58-2.62-2.62 3.04-1.29 3.9-.41 2.62 2.62z\"/><path d=\"m662.15,215.61c-2.01.27-2.89-.61-2.62-2.62,2.98-1.23,3.85-.36,2.62,2.62Z\"/><path d=\"m659.69,213.15c-2.01.26-2.85-.64-2.62-2.62,3.02-1.27,3.87-.37,2.62,2.62Z\"/><path d=\"M657.23 210.69c-2.01.26-2.87-.62-2.62-2.62 3.03-1.28 3.91-.41 2.62 2.62zm148.92-4.75a4.05 4.05 0 0 1 1.37-1.36l2.55 1.5-2.41 2.53-1.51-2.67z\"/><path d=\"M654.77 208.23c-1.98.23-2.87-.63-2.62-2.62 3.02-1.28 3.87-.38 2.62 2.62zm39.37 39.37c-1.99.24-2.87-.62-2.62-2.62 3.02-1.27 3.9-.41 2.62 2.62zm14.76 14.76c-2 .25-2.86-.63-2.62-2.62 3.04-1.29 3.9-.4 2.62 2.62z\"/><path d=\"m652.31,205.77c-2,.25-2.86-.64-2.62-2.62,3.02-1.27,3.89-.39,2.62,2.62Z\"/><path d=\"m649.85,203.31c-1.99.24-2.85-.64-2.62-2.62,3.04-1.29,3.89-.4,2.62,2.62Z\"/><path d=\"M647.39 200.85c-1.99.25-2.92-.57-2.62-2.62 3.03-1.28 3.91-.42 2.62 2.62zm-9.84-9.85c-2.05.31-2.9-.59-2.62-2.61 3.04-1.29 3.91-.42 2.62 2.61z\"/><path d=\"m635.08,188.54c-1.99.25-2.86-.63-2.62-2.62,3.04-1.3,3.89-.4,2.62,2.62Z\"/><path d=\"M632.63 186.09c-1.99.24-2.86-.64-2.62-2.62 3.02-1.27 3.89-.39 2.62 2.62zm78.73 78.73c-2.02.27-2.86-.64-2.62-2.62 3.02-1.28 3.89-.4 2.62 2.62z\"/><path d=\"M630.16 183.63c-1.99.24-2.86-.64-2.62-2.62 3.03-1.28 3.9-.41 2.62 2.62zm95.96 95.96c-1.99.24-2.87-.63-2.62-2.63 2.99-1.24 3.94-.44 2.62 2.63zm-105.8-105.8c-1.99.24-2.87-.63-2.62-2.63 3.02-1.27 3.88-.38 2.62 2.63z\"/><path d=\"m617.86,171.32c-2.04.29-2.85-.65-2.62-2.62,3.03-1.28,3.9-.4,2.62,2.62Z\"/><path d=\"m615.4,168.87c-1.98.23-2.88-.62-2.62-2.62,3.03-1.28,3.88-.38,2.62,2.62Z\"/><path d=\"m612.94,166.4c-1.99.25-2.87-.63-2.62-2.62,3.01-1.27,3.89-.39,2.62,2.62Z\"/><path d=\"m610.48,163.94c-2.01.26-2.86-.64-2.62-2.62,3.02-1.27,3.9-.41,2.62,2.62Z\"/><path d=\"M608.02 161.48c-1.97.22-2.95-.54-2.62-2.62 3.02-1.27 3.9-.4 2.62 2.62zm105.8 105.8c-1.99.24-2.89-.61-2.62-2.62 3.05-1.3 3.84-.34 2.62 2.62z\"/><path d=\"M605.56 159.02c-2.03.29-2.84-.65-2.63-2.62 3-1.26 3.89-.4 2.63 2.62zm-7.38-7.38c-2.04.3-2.84-.65-2.62-2.62 3.04-1.3 3.92-.43 2.62 2.62z\"/><path d=\"m595.72,149.18c-1.97.22-2.88-.62-2.62-2.62,3.02-1.27,3.9-.4,2.62,2.62Z\"/><path d=\"m593.26,146.72c-1.99.25-2.86-.63-2.62-2.62,3.03-1.28,3.89-.4,2.62,2.62Z\"/><path d=\"M590.8 144.26c-2 .25-2.87-.63-2.62-2.62 3.04-1.29 3.9-.41 2.62 2.62zm281.78-4.76a4.36 4.36 0 0 1 1.33-1.34l2.66 1.55-2.5 2.44-1.5-2.65z\"/><path d=\"M588.34 141.8c-1.98.24-2.96-.52-2.61-2.62 3.04-1.29 3.91-.42 2.61 2.62zm-9.84-9.84c-2.04.29-2.79-.71-2.64-2.63 2.89-1.15 3.94-.44 2.64 2.63zm137.78 137.78c-2 .25-2.87-.62-2.62-2.62 2.99-1.24 3.96-.47 2.62 2.62z\"/><path d=\"m576.04,129.52c-1.93.17-2.81-.72-2.65-2.64,2.81-1.05,3.72-.2,2.65,2.64Z\"/><path d=\"m573.58,127.06c-1.9.13-2.78-.75-2.65-2.65,2.89-1.12,3.64-.11,2.65,2.65Z\"/><path d=\"m571.12,124.6c-1.93.17-2.78-.75-2.64-2.64,2.97-1.2,3.85-.32,2.64,2.64Z\"/><path d=\"M568.66 122.14c-1.88.12-2.9-.61-2.62-2.64 3.12-1.36 3.79-.27 2.62 2.64zm-7.39-7.4c-2.02.27-2.8-.7-2.64-2.63 2.99-1.25 3.88-.38 2.64 2.63zm185.79 150.29a4.02 4.02 0 0 1 1.4-1.41l2.54 1.49-2.41 2.53-1.54-2.61z\"/><path d=\"M558.81 112.29c-1.93.17-2.81-.71-2.64-2.64 2.87-1.11 3.99-.47 2.64 2.64zm159.93 159.92c-1.98.23-2.87-.63-2.62-2.62 3.05-1.3 3.85-.35 2.62 2.62z\"/><path d=\"M721.2 274.67c-1.98.23-2.86-.64-2.63-2.62 2.99-1.24 3.9-.4 2.63 2.62zm183.34-167.12a4.08 4.08 0 0 1 1.4-1.4l2.55 1.5-2.42 2.51-1.53-2.61zm-348.18 2.28c-1.93.16-2.81-.71-2.65-2.65 2.85-1.09 3.67-.14 2.65 2.65z\"/><path d=\"m553.89,107.37c-1.92.16-2.82-.7-2.63-2.64,3.05-1.28,3.74-.22,2.63,2.64Z\"/><path d=\"m551.43,104.9c-1.99.24-2.9-.6-2.62-2.63,3.02-1.26,3.89-.38,2.62,2.63Z\"/><path d=\"M548.97 102.43c-2 .26-2.94-.55-2.61-2.62 3.09-1.35 3.86-.37 2.61 2.62zm174.69 174.7c-2 .25-2.85-.65-2.62-2.62 3.02-1.27 3.89-.4 2.62 2.62zM539.13 92.58c-2.03.29-2.9-.59-2.62-2.61 3-1.26 3.98-.5 2.62 2.61z\"/><path d=\"m536.67,90.13c-2,.25-2.87-.63-2.62-2.62,3.03-1.29,3.87-.38,2.62,2.62Z\"/><path d=\"m534.21,87.67c-1.99.24-2.86-.64-2.62-2.62,3.02-1.27,3.89-.39,2.62,2.62Z\"/><path d=\"m531.75,85.21c-1.99.24-2.86-.64-2.62-2.62,2.98-1.23,3.92-.42,2.62,2.62Z\"/><path d=\"m529.29,82.75c-2,.25-2.9-.59-2.62-2.62,3.09-1.34,3.84-.34,2.62,2.62Z\"/><path d=\"m526.82,80.28c-2.03.28-2.83-.66-2.62-2.62,2.97-1.23,3.95-.46,2.62,2.62Z\"/><path d=\"M524.36 77.83c-1.96.21-2.88-.62-2.62-2.63 3.02-1.27 3.86-.36 2.62 2.63zM256.19 759.26c-8.7 12.26-20.52 21.53-30.87 32.21-1.13 1.17-2.62 1.82-3.81-.16 8.89-12.04 20.57-21.41 30.89-32.08 1.11-1.15 2.54-1.94 3.79.03zM118.41 897.04c-4.4 7.19-10.28 12.89-17.37 17.38 2.5-9.09 8.46-14.71 17.37-17.38zm41.83-41.82c-4.74 6.22-8.39 13.72-17.46 14.83 4.97-5.94 8.56-13.51 17.46-14.83zm-19.69 19.68c-4.74 6.21-8.39 13.71-17.46 14.83 5-5.91 8.52-13.56 17.46-14.83zm76.28-76.27c-3.93 5.42-6.82 12.1-14.99 12.37 4.16-5.14 6.94-11.96 14.99-12.37zm59.05-59.05c-3.95 5.39-6.76 12.16-14.99 12.37 4.18-5.12 6.92-11.97 14.99-12.37zm-78.74 78.73c-2.81 5.49-6.97 9.63-12.45 12.45.86-7.44 5.14-11.46 12.45-12.45zm-17.22 17.22c-2.85 5.46-6.95 9.66-12.46 12.45 1.02-7.28 5.03-11.57 12.46-12.45zm108.15-112.06c2.4 7.11-1.76 8.63-7.5 8.8 1.24-4.01 4.93-5.93 7.5-8.8z\"/><path d=\"M280.72 732.11c2.55 3.38.02 4.28-2.52 5.17-2.55-3.38.08-4.23 2.52-5.17zm-19.69 19.68c2.55 3.38.03 4.28-2.52 5.17-2.58-3.4.09-4.22 2.52-5.17zm-39.36 39.37c2.55 3.38.05 4.29-2.52 5.17-2.58-3.39.1-4.22 2.52-5.17zm-19.69 19.68c2.55 3.38.01 4.27-2.52 5.17-2.59-3.4.13-4.2 2.52-5.17zm-34.36 37c-.85 2.62-1.77 5.1-5.16 2.52.97-2.39 1.78-5.08 5.16-2.52z\"/><path d=\"M162.61 850.21c2.54 3.37.03 4.28-2.52 5.17-2.58-3.39.09-4.22 2.52-5.17zm-19.68 19.68c2.55 3.38.02 4.28-2.52 5.17-2.58-3.39.11-4.21 2.52-5.17zm-19.68 19.69c2.55 3.38.02 4.28-2.52 5.17-2.55-3.38.08-4.23 2.52-5.17z\"/><path d=\"M120.87 894.55c-.02 1.75-.84 2.69-2.65 2.64l-.13-2.78 2.78.14zm61.52-61.51c0 1.76-.89 2.64-2.65 2.65l-.14-2.8 2.79.15z\"/><path d=\"M184.84 830.58c.01 1.78-.92 2.61-2.64 2.65l-.15-2.79 2.79.14zm14.77-14.76c-.03 1.74-.84 2.69-2.65 2.64l-.14-2.79 2.79.15zm19.68-19.68c-.02 1.74-.84 2.69-2.65 2.64l-.14-2.78 2.78.14zm39.37-39.37c-.01 1.75-.83 2.7-2.65 2.64l-.14-2.79 2.79.15zm19.68-19.68c-.02 1.75-.84 2.69-2.65 2.64l-.13-2.78 2.78.14z\"/></g><path d=\"m89.91,169.05c3.7.45,5.97,2.39,5.86,6.23-.07,2.62-1.53,4.85-4.29,4.89-3.7.06-6.07-2.73-6.73-5.83-.7-3.3,2.04-4.85,5.16-5.29Z\" class=\"N\"/><g class=\"M\"><path d=\"M145.46 436.92c-5.2 8.03-11.8 14.66-19.84 19.84-1.21-7.96 8.04-8.87 9.94-14.74l2.5-2.54-.04.04 2.52-2.5c1.64-.12 3.23-2.67 4.92-.1zm-41.96 41.99c-2.61-1.76.04-3.32.18-4.98 5.87-1.88 6.73-11.19 14.71-9.96-3.54 6.4-8.53 11.35-14.89 14.93zm113.31-113.35c-2.81 5.5-6.91 9.71-12.46 12.46 1.04-7.26 5.12-11.5 12.46-12.46zm19.68-19.68c-2.77 5.54-6.94 9.68-12.46 12.46 1.05-7.26 5.14-11.48 12.46-12.46z\"/><path d=\"M157.76 424.61c-2.76 5.55-6.92 9.7-12.46 12.46 1-7.31 5.16-11.45 12.46-12.46zm98.41-98.42c-2.76 5.55-6.92 9.7-12.46 12.46 1.04-7.27 5.16-11.46 12.46-12.46zm19.69-19.68c-2.77 5.54-6.91 9.71-12.46 12.47 1.07-7.24 5.13-11.49 12.46-12.47zm-78.73 78.73c-2.77 5.54-6.92 9.7-12.46 12.46 1.04-7.27 5.14-11.47 12.46-12.46zm-19.69 19.69c-1.94 4.73-5.28 8.05-10 10 .18-6.49 3.36-9.97 10-10zm-51.67 51.67c-1.18 3.84-3.68 6.38-7.54 7.54-2.58-1.69-.05-3.28.1-4.91l2.51-2.54c1.64-.13 3.24-2.68 4.93-.09z\"/><path d=\"m243.88,338.47c.05,1.82-.83,2.7-2.64,2.64-1.45-3.22-.4-3.93,2.64-2.64Z\"/><path d=\"M241.41 340.94c.06 1.82-.82 2.7-2.64 2.64l-.1-2.77 2.74.13z\"/><path d=\"M238.96 343.39c.06 1.82-.82 2.71-2.65 2.64-1.36-3.12-.48-4.01 2.65-2.64zm19.68-19.68c.07 1.83-.81 2.71-2.64 2.64-1.37-3.13-.49-4.02 2.64-2.64z\"/><path d=\"M261.1 321.25c.07 1.83-.81 2.71-2.64 2.64l-.11-2.77 2.75.13zm-36.91 36.91c.05 1.81-.83 2.69-2.64 2.64-1.45-3.21-.41-3.94 2.64-2.64z\"/><path d=\"M221.73 360.62c.05 1.81-.83 2.7-2.64 2.64l-.11-2.77 2.75.13zm41.83-41.83c.06 1.82-.82 2.71-2.65 2.64-1.47-3.24-.36-3.89 2.65-2.64z\"/><path d=\"M219.27 363.08c.05 1.82-.83 2.7-2.64 2.64-1.37-3.13-.5-4.02 2.64-2.64zm59.05-59.05c.06 1.82-.82 2.71-2.65 2.64-1.36-3.12-.48-4.01 2.65-2.64z\"/><path d=\"M280.78 301.57c.06 1.82-.82 2.7-2.64 2.64l-.1-2.77 2.75.13zm-76.27 76.27c.06 1.82-.82 2.7-2.64 2.64-1.44-3.2-.41-3.93 2.64-2.64z\"/><path d=\"M202.05 380.3c.06 1.82-.82 2.7-2.64 2.64l-.11-2.77 2.75.12z\"/><path d=\"M199.59 382.76c.06 1.82-.82 2.71-2.64 2.64-1.37-3.13-.49-4.02 2.64-2.64zm83.65-83.65c.06 1.82-.82 2.7-2.64 2.64-1.46-3.22-.41-3.93 2.64-2.64zm-98.42 98.42c.06 1.82-.82 2.7-2.64 2.64l-.12-2.75 2.76.1z\"/><path d=\"M182.36 399.99c.06 1.82-.81 2.71-2.64 2.64l-.11-2.77 2.75.13z\"/><path d=\"M179.9 402.45c.07 1.84-.81 2.72-2.64 2.64-1.3-3.06-.53-4.05 2.64-2.64zm-12.31 12.3c.12 1.87-.81 2.71-2.64 2.64l-.11-2.77 2.74.13z\"/><path d=\"m165.14,417.21c.04,1.8-.84,2.69-2.65,2.65-1.42-3.19-.42-3.95,2.65-2.65Z\"/><path d=\"M162.68 419.67c.04 1.8-.83 2.69-2.65 2.65l-.11-2.77 2.75.12z\"/><path d=\"m160.22,422.13c.05,1.81-.83,2.7-2.65,2.64-1.35-3.12-.49-4.02,2.65-2.64Z\"/></g><g class=\"N\"><path d=\"M120.84 456.69l-2.51 2.54 2.51-2.54zm17.22-17.21l-2.5 2.54 2.5-2.54z\"/><path d=\"M140.54 437.01l-2.52 2.5 2.52-2.5z\"/></g><g class=\"M\"><path d=\"M479.89 899.51c6.79 1.49 11.16 5.41 12.43 12.42-7.45-.83-9.25-7.32-12.43-12.42zm17.23 17.24c3.71-2.49 4.51 2.55 7.17 2.78.23 2.66 5.25 3.47 2.78 7.18-5.02-1.61-8.36-4.91-9.95-9.95zm-34.45-34.46c5.21-.21 7.87 2.13 7.51 7.5-5.89.89-6.27-3.74-7.51-7.5zm-22.14-22.15c5.25-.24 7.8 2.21 7.51 7.51-4.2-.81-6.78-3.24-7.51-7.51z\"/><path d=\"M506.96 926.56c2.81-1.07 3.68-.2 2.61 2.61-2.07.33-2.9-.57-2.61-2.61zm-12.31-12.31c2.95-1.21 3.81-.33 2.61 2.61-2.03.29-2.87-.61-2.61-2.61z\"/><path d=\"M492.19 911.79c2.96-1.21 3.82-.33 2.62 2.62-2.01.26-2.88-.61-2.62-2.62zm-14.76-14.76c3.07-1.33 3.69-.22 2.61 2.61-2.06.32-2.91-.57-2.61-2.61z\"/><path d=\"m474.97,894.57c2.9-1.16,3.9-.41,2.61,2.61-2.04.3-2.88-.6-2.61-2.61Z\"/><path d=\"m472.51,892.11c3-1.25,3.79-.3,2.61,2.61-2.01.27-2.89-.6-2.61-2.61Z\"/><path d=\"M470.05 889.65c2.95-1.2 3.84-.35 2.61 2.61-2.01.27-2.87-.61-2.61-2.61zm-9.84-9.84c2.9-1.16 3.84-.36 2.61 2.61-2.04.3-2.91-.57-2.61-2.61z\"/><path d=\"m457.75,877.35c2.96-1.22,3.79-.31,2.61,2.61-2.06.32-2.92-.56-2.61-2.61Z\"/><path d=\"m455.28,874.88c2.81-1.07,3.72-.23,2.61,2.61-2.04.29-2.88-.6-2.61-2.61Z\"/><path d=\"m452.83,872.43c3.09-1.35,3.71-.23,2.61,2.61-2.02.28-2.89-.59-2.61-2.61Z\"/><path d=\"m450.36,869.97c2.94-1.2,3.91-.43,2.61,2.61-2.02.28-2.85-.64-2.61-2.61Z\"/><path d=\"M447.91 867.51c2.99-1.25 3.85-.36 2.61 2.61-1.99.25-2.95-.53-2.61-2.61zm-9.84-9.84c2.97-1.23 3.81-.33 2.61 2.61-2.05.32-2.92-.56-2.61-2.61z\"/></g><path d=\"M347.19 230.4c-1.84-11.64 3.06-16.6 14.72-14.85-.19 1.67-2.75 3.31-.06 5.02l.15-.17-2.77-.1.14 2.74s.18-.17.18-.18l-2.74-.14.11 2.78.18-.18c-3.13-1.37-4.01-.49-2.64 2.64l.17-.15c-3.81-2.97-4.73 2.35-7.42 2.59zm59.03-59.03c.94-4.76-2.7-10.81 3.09-14.09 3.21-1.82 6.07.29 7.69 3.57-.49 1.83-3.95 3.13-1.01 5.58l.14-.17-2.75-.11.11 2.75s.17-.14.17-.15c-3.82-2.95-4.73 2.4-7.44 2.61zm61.47-61.56c-2.05-11.96 5.2-14.56 14.84-14.77-.52 3.89-7.48 4.5-5.04 9.89l.15-.17-2.76-.14.12 2.77.17-.15c-3.76-2.83-4.74 2.44-7.48 2.56zm-98.42 98.38c-1.61-9.85 2.52-13.94 12.35-12.33-.2 2.72-5.32 3.76-2.54 7.48l.15-.17-2.76-.14.12 2.77.17-.15c-3.74-2.84-4.75 2.4-7.49 2.53zM448 129.45c-1.62-9.85 2.53-13.93 12.35-12.32-.1 2.75-5.38 3.73-2.55 7.48l.14-.17-2.75-.14.11 2.78.18-.15c-3.73-2.83-4.74 2.43-7.49 2.52zM329.92 247.59c-1.65-9.9 2.53-13.97 12.37-12.36-.22 2.71-5.42 3.71-2.59 7.48l.14-.17-2.76-.13.12 2.77.17-.15c-3.75-2.82-4.73 2.44-7.47 2.56z\" class=\"K\"/><path d=\"M415.98 166.43c-2.94-2.45.52-3.75 1.01-5.58l6.44-6.71 2.54-2.54 2.36-2.45c2.74-.11 3.72-5.43 7.48-2.52-5.23 7.98-11.82 14.6-19.83 19.8z\" class=\"M\"/><path d=\"M435.82 146.64c-3.76-2.91-4.74 2.4-7.48 2.52-1.17-9.38 2.94-13.49 12.32-12.35-.18 1.67-2.76 3.31-.07 5.02l.15-.17-2.76-.11.12 2.75.18-.18-2.76-.12.12 2.76.18-.12z\" class=\"K\"/><path d=\"M457.81 124.61c-2.83-3.75 2.44-4.73 2.55-7.48 3.15-1.74 5.65-4.12 7.34-7.32 2.74-.13 3.72-5.4 7.48-2.56-4.36 7.21-10.17 12.99-17.37 17.37zM329.92 247.59c2.74-.12 3.72-5.37 7.47-2.56-4.34 7.25-10.23 12.94-17.36 17.41-3.39-3.36 1.81-4.34 1.87-6.74 3.21-2.17 6.21-4.55 8.02-8.1z\" class=\"M\"/><path d=\"M321.9 255.69c-.06 2.4-5.26 3.39-1.87 6.74l.13-.18c-1.68-2.63-3.31-.09-4.96.06-2.96-.3-7.22-1.59-6.03-4.35 2.54-5.88 8.28-2.19 12.73-2.27zm67.07-67.16c.77-5.82-3.17-16.37 9.89-9.85-.15 2.72-5.54 3.64-2.56 7.44l.14-.14c-3.75-2.83-4.72 2.46-7.47 2.55z\" class=\"K\"/><g class=\"M\"><path d=\"M388.97 188.53c2.75-.09 3.72-5.38 7.47-2.55-4.38 7.2-10.18 12.98-17.37 17.37-2.77-3.73 2.35-4.77 2.54-7.48l2.38-2.29 2.6-2.61 2.38-2.44zm51.61-46.7c-2.68-1.71-.11-3.35.07-5.02 3.24-1.66 5.62-4.19 7.35-7.36 2.75-.09 3.75-5.35 7.49-2.52-3.56 6.37-8.53 11.34-14.91 14.91zm-71.31 66.36c2.74-.13 3.75-5.37 7.49-2.53-3.59 6.34-8.53 11.34-14.91 14.9-2.69-1.71-.12-3.35.07-5.02l2.4-2.3 2.65-2.66 2.3-2.4zm108.22-103.26c-2.43-5.39 4.52-6 5.04-9.89l-.04.04 2.57-2.59 2.31-2.38c1.67-.13 3.3-2.75 5.02-.09-3.55 6.38-8.56 11.32-14.9 14.91zM339.7 242.71c-2.83-3.77 2.36-4.77 2.59-7.48l2.34-2.33 2.6-2.55-.04.05c2.69-.24 3.61-5.57 7.42-2.59-3.54 6.4-8.56 11.31-14.9 14.9z\"/><path d=\"M396.29 186.12c-2.98-3.8 2.42-4.72 2.56-7.44l-.03.03 2.48-2.52c1.65-.13 3.26-2.68 4.95-.08-1.89 4.76-5.3 8.01-9.97 10.01z\"/><path d=\"M406.22 171.37c2.71-.21 3.62-5.56 7.44-2.61-1.17 3.86-3.66 6.38-7.55 7.51-2.57-1.69-.04-3.26.11-4.89zm-90.99 95.77c-1.1 3.93-3.67 6.39-7.54 7.54-.39-5.42 2.15-7.91 7.54-7.54z\"/><path d=\"m315.2,262.31c1.65-.14,3.28-2.69,4.96-.06-.46,2.92-2.12,4.65-5.09,5.05-2.62-1.73-.03-3.33.13-4.99Z\"/></g><path d=\"M347.23 230.35l-2.6 2.55 2.6-2.55zm19.74-19.76l-2.65 2.66 2.65-2.66zm19.62-19.62l-2.6 2.61 2.6-2.61zm14.72-14.78l-2.48 2.52 2.48-2.52zm24.66-24.59l-2.54 2.54 2.54-2.54z\" class=\"K\"/><path d=\"M307.85 274.5c.1 1.86-.85 2.67-2.64 2.64l-.13-2.77 2.77.13z\" class=\"M\"/><path d=\"M485.06 92.49l-2.57 2.59 2.57-2.59z\" class=\"K\"/><path d=\"M305.39 276.96c.08 1.84-.77 2.75-2.64 2.64l-.13-2.77 2.77.13z\" class=\"M\"/><path d=\"M706.3 303.94l-4.78 5.08-2.55 2.51-2.47 2.44c-9.34-1.14-12.4 3.99-12.3 12.3h0l-2.44 2.51-2.44 2.43c-11.08-1.25-14.46 5.24-14.8 14.76-1.73 3.2-4.23 5.63-7.41 7.37-9.39.49-14.33 5.4-14.71 14.83l-4.98 4.85c-9.54.33-16.79 2.95-14.72 14.82l-4.96 4.88c-11.63-1.74-16.49 3.24-14.72 14.81l.02-.03-2.5 2.47.02-.01c-9.55.31-16.02 3.69-14.78 14.78l-2.43 2.43-2.48 2.49.02-.02c-15.34.91-17.01 2.59-17.24 17.25l-2.45 2.42c-11.22.29-16.99 6.01-17.22 17.26l.02-.03-2.49 2.48.02-.02c-11.99-2.19-17.01 2.63-14.8 14.72l-5.04 7.41.25-.08-2.61.06-10.24.17-8.04-7.98c3.74-11.54-2.89-12.7-11.69-11.68l-4.66-4.6c.12-11.81-5.72-17.66-17.54-17.52l-6.69-6.66c2.94-.85 4.49-2.82 4.74-5.85 9.5 5.68 19.56 10.06 25.56 20.77 6.61 11.8 26.19 15.15 30.84 6.19 3.51-6.76 6.73-12.74 15.26-13.9 1.93-.26 4.76-2.91 5.03-4.78 1.51-10.24 5.29-16.89 17.31-17.06 3.54-.05 4.3-6.29 4.48-10.53.2-4.78 2.49-8.55 7.6-7.15 9.73 2.68 11.59-2.91 11.96-10.29.34-6.82 1.94-11.74 10.28-8.59 4.99 1.88 6.65-.8 7.63-4.94 2-8.5 2.16-18.66 15.62-16.64 2.24.34 3.16-2.28 3.63-4.31 3.44-15.11 25.16-15.41 26.36-32.43.05-.65 1.98-1.63 3.07-1.68 7.89-.34 11.42-5.11 13.3-12.13 1.15-4.33 4.71-6.71 8.88-7.67 4.01-.92 6.9-3.05 7.9-6.87 1.81-6.95 5.7-11.16 12.74-13.4 5.33-1.69 8.63-9.57 4.55-11.14-11.39-4.41-19.07-10.88-22.83-22.36-.19-.58-2.31-.43-3.46-.82-2.33-.79-30.64-29.93-32.26-31.61-8.96-9.25-20.9-15.86-25.26-29.13-.13-.4-1.5-.49-2.3-.57-6.8-.67-9.74-4.66-10.88-11.19-.76-4.36-22.08-17.51-23.88-15.19-6.45 8.31-17.59 10.58-23.54 19.07-7.06 10.08-17.01 17.19-25.74 25.5l-50.92 49.68c-25.86 25.61-49.92 53.06-76.65 77.88-5.15 4.78-12.21 13.13-6.45 17.47 9.34 7.04 14.17 18.08 23.11 23.97 13 8.57 20.32 22.27 32.6 31.29 4.78 3.51 10.96 7.69 11.55 15.17-9.49 3.1-11.99-5.94-15.6-10.55-3.8-4.86-6.87-5.63-11.85-4.06l-7.21-7.01c.05-11.74-4.15-19.24-17.54-17.54l-2.15-2.13c-.52-10-1.94-19.1-15.78-15.73l-.78-.78c1.06-1.65 2-3.58-.14-4.77-.93-.52-2.65.39-4.02.65l-.13-.04c2.06-4.59-.82-8.8-1.19-13.19-.61-7.25 1.87-12.5 7.52-16.97 15.99-12.67 29.66-27.61 43.51-42.6 12.94-14 23.27-31.32 37.94-42.29 19.51-14.59 36.4-31.38 53.68-48.05 13.12-12.67 25.77-25.82 38.79-38.6 3.17-3.11 7.03-5.52 10.45-8.39 5.58-4.67 9.77-3.21 9.64 3.71-.16 8.53 3.67 9.71 10.97 10.53 5.23.59 12.52 2.59 9.51 11.86-1.68 5.18 1.48 7.44 6.68 7.3 7.89-.22 12.36 3.47 12.56 11.61.14 5.64 3.19 8.06 8.58 8.07.82 0 2.12-.18 2.37.23 7.36 12.07 21.46 18.17 27.95 30.51 2.51 4.77 3.43 8.53 9.47 8.72 6.83.21 10.32 4.17 10.65 10.95.28 5.87 2.28 8.55 9.19 7.97 8.72-.73 18.8 14.27 14.97 21.86-2.23 4.41-1.69 8.69-2.05 13.08zM503 103.72c-.85-3.69 1.71-6.95 4.33-10.06 1.55-1.84 3.49-3.84 6.26-2.33 2.94 1.59 3.22 4.13 2.51 7.33-7.31 33.18-29.3 53.04-59.32 65.64-4.01 1.68-8.88 4.74-10.92-2.11-1.67-5.62 1.61-7.85 7.09-8.7 5.89-.91 9.97-3.48 10.31-11.02.51-11.28 15.73-6.13 17.91-13.12 2.62-8.42 4.18-16.87 14.22-16.41 7.79.36 11.11.08 7.6-9.23z\" class=\"L\"/><g class=\"M\"><path d=\"M359.5 346.04c-19.29-15.26-36.46-32.64-51.82-51.83 3.81-2.32 4.86 1.67 6.48 3.25l41.15 41.1c1.87 1.92 6.12 3.18 4.19 7.48zM499.63 82.78c-.43-5.45 2.17-7.87 7.53-7.53-1.16 3.86-3.64 6.39-7.53 7.53z\"/><path d=\"M507 75.4c-.97-4.36.61-6.16 5.08-5.07-.5 2.89-2.06 4.71-5.08 5.07zM337.21 245.18l-.12-2.77 2.76.13c.05 1.81-.82 2.7-2.64 2.64zm17.22-17.23c-1.37-3.13-.49-4.01 2.64-2.64.05 1.81-.82 2.7-2.64 2.64z\"/><path d=\"M356.89 225.49l-.11-2.78 2.74.14c.05 1.81-.82 2.69-2.64 2.64z\"/><path d=\"M359.36 223.03l-.14-2.74 2.77.1c.05 1.81-.82 2.69-2.64 2.64zm17.22-17.22l-.12-2.77 2.76.14c.05 1.81-.83 2.69-2.64 2.64zm36.91-36.91l-.11-2.75 2.75.11c.05 1.81-.83 2.69-2.64 2.64zm22.14-22.14l-.12-2.76 2.76.12c.06 1.81-.82 2.69-2.64 2.64z\"/><path d=\"M438.09 144.3l-.12-2.75 2.76.11c.05 1.81-.82 2.69-2.64 2.64zm17.22-17.22l-.11-2.78 2.75.14c.05 1.81-.83 2.69-2.64 2.64zM475 107.39l-.12-2.77 2.76.14c.04 1.8-.82 2.7-2.64 2.64zm17.22-17.22l-.11-2.76 2.75.12c.06 1.82-.82 2.7-2.64 2.64z\"/><path d=\"M494.68 87.71l-.12-2.77 2.76.13c.04 1.8-.83 2.68-2.64 2.64zM307.83 294.35c-2.05.31-2.93-.56-2.61-2.62 2.76-1.01 3.63-.14 2.61 2.62z\"/><path d=\"M497.14 85.25l-.13-2.74 2.77.1c.04 1.8-.84 2.68-2.64 2.64zM637.5 808.4c2.72 2.01.42 3.59-.72 4.75l-58.64 58.64c-1.14 1.13-2.74 3.44-4.76.74 20.14-22.62 41.49-44.02 64.13-64.13z\"/><path d=\"M573.53 872.37c2.88 2.78-.2 4.16-1.56 5.54l-32.43 32.41c-1.38 1.35-2.75 4.45-5.53 1.58 11.93-14.42 25.12-27.58 39.52-39.52zm103.34-103.34c3.3 3.66-1 4.83-2.48 6.35-10.06 10.42-20.3 20.68-30.68 30.78-1.52 1.48-2.74 5.75-6.37 2.39 11.95-14.4 25.08-27.62 39.52-39.52zm-194.38-241l2.44-2.41c3.92-.47 4.51-7.53 9.93-5.01-10.37 13.59-23.27 24.71-35.5 36.49l-1.84-2.33 2.76-4.61c3.16-1.75 5.68-4.14 7.41-7.34 5.67-4.19 10.59-9.13 14.78-14.79zM305.23 710.19c-2.67-1.72-.13-3.34.11-5 7.35-5.77 13.82-12.42 19.68-19.69l2.45-2.41 8.05-6.7 2.14 2.07c-10.08 11.32-20.22 22.58-32.42 31.73zm78.85-83.73l2.43-2.43 8.04-6.69 2.17 2.08c-5.75 7.37-12.39 13.86-19.69 19.67l-2.28-1.93 9.34-10.7z\"/><path d=\"M403.75 606.77l2.44-2.44 5.78-4.36 2 2.3c-5.01 6.46-10.74 12.2-17.25 17.15l-2.17-2.08 9.2-10.57zm36.89-36.92l4.92-4.87 5.74-4.4 2.03 2.32-13.63 13.85-1.85-2.28 2.78-4.62zm-95.94 95.97l2.44-2.43 8.06-6.68 2.16 2.09c-4.12 5.74-9.12 10.58-14.76 14.8l-2.16-2.17 1.74-3.16.02-.02 2.5-2.43zm17.19-17.24l4.93-4.88 2.46-2.49 3.31-1.87 1.99 2.28-13.61 13.87-1.85-2.28 2.77-4.62zm329.82 108.24c-4.08 5.23-6.83 12.08-14.99 12.37 4.1-5.21 6.89-12.02 14.99-12.37z\"/><path d=\"M703.93 741.97c-.25 8.2-7.21 10.86-12.37 15 .32-8.14 7.14-10.91 12.37-15zM418.5 592c3.96-2.58 7.3-5.8 9.83-9.81l3.29-1.92 2.01 2.3-13.62 13.86-1.88-2.28a22.09 22.09 0 0 0 .35-2.16zm113.28 324.74c-1.88 5.02-6.56 7.57-9.96 11.25-1.39-7.92 3.38-10.39 9.96-11.25zm-34.6-398.44c.14-6.51 3.42-9.89 9.98-9.99-2.03 4.63-5.41 7.9-9.98 9.99zM342.6 673.59l-4.95 4.86-2.14-2.07 4.93-4.97 2.16 2.17zM459.37 557.1l-3.61 3.26-2.28-1.95 4.05-3.64 1.84 2.33zm-19.67 19.64l-3.6 3.32-2.3-1.97 4.05-3.63 1.85 2.28z\"/><path d=\"M420.02 596.44l-3.62 3.3-2.27-1.94 4.02-3.63 1.88 2.28zm-59.05 59.05l-3.62 3.3-2.16-2.09 3.93-3.5 1.85 2.28zm173.19 256.24c2.54 3.37-.09 4.22-2.52 5.17-2.56-3.38.07-4.23 2.52-5.17zm-39.47-390.97l-.15-2.79 2.79.15c-.03 1.73-.91 2.61-2.64 2.64zM377.02 639.09l-2.44 2.52-1.99-2.28 2.16-2.18 2.28 1.93z\"/><path d=\"M416.4 599.73l-2.44 2.53-2-2.29 2.16-2.18 2.27 1.94zm19.7-19.67l-2.46 2.51-2.01-2.29 2.17-2.18 2.3 1.97zm19.66-19.7l-2.43 2.53-2.03-2.32 2.18-2.16 2.28 1.95z\"/></g><path d=\"M318.21 378.76c1.09 3.36 3.94 8.31-.02 9.74-5.62 2.03-6.89-4.97-8.62-8.27-4.88-9.3-8.54-19.24-12.6-28.97-2.92-6.98.94-12.02 6.89-9.63 12.29 4.93 25.53 7.89 36.67 15.62 3.01 2.09 5.21 4.2 2.82 7.88-1.98 3.05-4.55 1.98-7.5 1.06-9.11-2.82-18.37 3.96-17.62 12.56zm-13.13-27.79c2.74 6.13 3.89 10.86 9.56 11.58 1.86.23 2.79-1.77 2.53-3.4-.85-5.45-5.33-6.41-12.09-8.18zM161.4 498.26c1.06 12 4.29 20.71 17.24 20.3 2.37-.07 3.41 1.97 3.09 4.33-.3 2.22-1.77 3.67-3.73 4.47-3.68 1.49-7.18-.29-10.39-1.17-3.42 3-.1 5.57-.21 8.2-.26 6.28-3.7 7.53-7.78 3.76-9.9-9.14-19.25-18.89-28.77-28.44-1.84-1.84-2.98-4.01-.83-6.42 2.07-2.31 4.25-1.88 6.39-.05.62.53 1.2 1.11 1.81 1.66 4.52 4.07 9.27 11.68 13.51 11.41 7.17-.46.83-10.89 5.98-14.94.62-.48 1.2-1.01 3.69-3.1z\" class=\"L\"/><path d=\"M101.01 481.38l-.1-2.77 2.74.13c.05 1.81-.82 2.69-2.63 2.63z\" class=\"M\"/><g class=\"N\"><path d=\"M325.02 685.5c-5.85 7.27-12.32 13.92-19.68 19.69-3.19-12.62 3.81-19.63 19.68-19.69zm78.73-78.73l-9.2 10.57-8.04 6.69c.55-10.94 3.41-19.57 17.24-17.27zm49.73-48.36l-2.18 2.16-5.74 4.4c-2.19-11.99 2.63-17.02 14.73-14.81l-2.76 4.61-4.05 3.64zm-78.73 78.75l-2.16 2.18-3.31 1.87c-1.77-11.64 3.22-16.51 14.8-14.75l-9.34 10.7zm-34.31 34.26l-4.93 4.97-8.05 6.7c-1.73-11.54 3.97-15.69 14.72-14.83l-1.74 3.16zm142.05-143.39c-4.2 5.66-9.12 10.6-14.78 14.79-1.73-11.58 4.04-15.68 14.78-14.79zM359.12 653.21l-3.93 3.5-8.06 6.68c.3-9.53 3.67-16.01 14.75-14.81l-2.77 4.62zm55.01-55.42l-2.16 2.18-5.78 4.36c1.55-6.66-.27-16.69 12.31-12.32a23.11 23.11 0 0 1-.35 2.16l-4.02 3.63zm19.67-19.7l-2.17 2.18-3.29 1.91c-1.63-9.83 2.47-13.95 12.31-12.35l-2.78 4.62-4.05 3.63zm-89.1 87.73l-2.5 2.43 2.5-2.43z\"/><path d=\"M369.28 641.21l-2.46 2.49 2.46-2.49z\"/></g><path d=\"M164.28 74.57c6.14-2.58 7.99.48 8.69 7.29.56 5.41 5.13 9.13 10.73 10.45 3.36.79 7.86-.58 8.18 5.02.15 2.62-.69 4.96-3.06 6.23-3.45 1.85-7.87 2.48-10.47 0-6.19-5.9-12.57-11.23-19.93-15.71-3.37-2.05-3.92-7.09-2.87-11.31 1.24-4.96 4.71-3.21 8.73-1.98zm15.54-8.69l7.36.02c2.1 7.07 6.16 12.37 14.16 11.36 6.51-.83 5.36-6.75 5.55-11.4h4.9c2.5 6.37 3.26 12.67-2.59 17.6-5.3 4.47-12.07 6.1-18.11 3.05-7.96-4.02-12.99-10.78-11.27-20.64zm-44.29 48.78c-.09-3.2-1.73-4.84-4.92-4.92-4.43-9.58-1.59-16.93 6.85-22.63 2.1-1.42 4.33-2.65 6.46-.58 2.13 2.08.92 4.33-.46 6.45-2.32 3.59-8.71 6.2-3.01 11.84v9.84h-4.92z\" class=\"L\"/><path d=\"M206.89 65.86c-.19 4.65.96 10.57-5.55 11.4-8 1.01-12.06-4.29-14.16-11.36l19.71-.04z\" class=\"K\"/><g class=\"M\"><path d=\"M738.31 710.21c-1.97-1.24-1.21-2.67-.05-3.8 15.59-15.24 29.84-31.87 46.87-45.63 2 1.2 1.28 2.67.12 3.8-15.6 15.26-29.9 31.86-46.94 45.64zm93.41-96.03c8.68-11.1 18.49-21.08 29.68-29.68-6.66 13.13-16.32 23.25-29.68 29.68z\"/><path d=\"M861.25 584.66c6.98-9.53 15.29-17.73 24.76-24.76-4.63 11.88-13.24 19.78-24.76 24.76zm-51.67 51.66c6.2-8.67 13.67-16.07 22.3-22.3-4.1 10.77-11.28 18.45-22.3 22.3zm78.73-78.73c4.56-7.02 10.37-12.81 17.38-17.38-2.46 9.12-8.21 14.97-17.38 17.38z\"/><path d=\"m792.36,653.55c4.51-7.07,10.41-12.76,17.38-17.38-2.59,9-8.09,15.08-17.38,17.38Z\"/><path d=\"M784.97 660.93c1.34-3.69 3.81-6.25 7.54-7.54.43 5.46-2.05 8.01-7.54 7.54zm100.88-100.85c.06-1.71.91-2.62 2.65-2.65l.14 2.8-2.8-.15z\"/></g><path d=\"M432.86 414.99c4.97-1.57 8.05-.79 11.85 4.06 3.61 4.61 6.1 13.65 15.6 10.55l4.92 7.38c-.25 3.03-1.8 5-4.74 5.85-9.77-8.72-19.28-17.7-27.62-27.84zm-24.75-24.55c13.39-1.7 17.58 5.8 17.54 17.54l-17.54-17.54zm-17.93-17.86c13.84-3.37 15.26 5.73 15.78 15.73l-15.78-15.73zm76.99 76.91c11.82-.14 17.65 5.71 17.54 17.52l-17.54-17.52zm22.2 22.12c8.8-1.02 15.43.14 11.69 11.68-4.58-3.21-8.51-7.07-11.69-11.68zm19.72 19.67l10.24-.17c-3.31 6.05-6.72 6.64-10.24.17zm-123.84-123.6c1.36-.26 3.09-1.17 4.02-.65 2.13 1.19 1.2 3.12.14 4.77l-4.16-4.12z\" class=\"K\"/><path d=\"M873.66 284.43a15.38 15.38 0 0 1 7.38-7.38c3.2-.08 4.84-1.72 4.92-4.92 6.39-13.85 18.98-21.98 29.53-31.99 3.58.03 7.16.08 7.38-4.92l2.46-2.46q17.22-7.74 17.22 12.23V455q0 16.75-16.53 13.02c-1.97-.44-3.97-.77-5.95-1.15l.07.06c-.99-8.78-2.65-16.71-13.52-18.87-4.03-.8-5.96-5.46-7.33-9.34-1.27-3.6-2.72-6.58-6.6-8.17-13.47-5.53-22.45-17.86-29.94-28.19-7.95-10.97-24.51-14.21-26.16-30-.06-.62-2.04-1.44-3.15-1.48-8.06-.25-10.78-6.32-13.78-12.24-1.61-3.17-3.04-6.01-6.95-7.89-12.91-6.21-18.26-21.32-31.32-27.67-.75-.37-.88-2.2-1.13-3.39-2.03-9.97-7.52-10.38-14.97-5.48-1.62-.15-3.08-2.83-4.87-.32l.15.15c.9-4.28-.32-6.44-5.07-5.08l.14.13c2.53-1.79-.11-3.25-.3-4.86 3.94-4.19 4.87-9.42 5.15-14.88v-14.76c5.18-4.74 11.5-1.5 17.22-2.46 5.64.92 3.26 9.86 9.84 9.84v7.38c.08 3.2 1.72 4.84 4.92 4.92v4.92c.56 5.47 3.33 10.12 6.29 14.39 10.89 15.68 35.32 14.36 42.92-2.09 1.06-1.99 2.89-2.41 4.92-2.46 6.87-1.33 10.97-5.43 12.3-12.3 1.37-3.27 3.83-4.91 7.38-4.92 4.7-.22 7.17-2.68 7.38-7.38z\" class=\"L\"/><path d=\"M748.61 267.64l2.41-2.53 3.91-3.5 15.78-16.16 3.92-3.51 13.36-13.64 2.42-2.52c6.46-5.02 12.24-10.71 17.26-17.17l2.41-2.53 3.92-3.5 15.77-16.17 3.91-3.53 3.49-3.77 2.77-1.23c5.88 1.49 9.95 3.55 1.98 8.22-2.18 1.27-4.09 2.52-5.16 4.84h0c-8.52 13.84-22.96 22.16-32.61 34.97-1.65 2.19-1.74 4.43-1.84 6.85h-2.46c-11 .71-14.58 11.76-21.73 17.4-8.76 6.91-19.86 13.15-25.02 24.42v4.92c-4.95 4.54-10.86 5.66-17.31 4.92-1.42-5 4.64-5.68 5.43-9.41l7.38-7.38z\" class=\"K\"/><path d=\"M886.36 166.25c-4.41.04-7.18-.51-7.57-4.28-.4-3.79-.41-8.83 3.77-9.27 8.24-.85 9.44-6.82 12.87-12.35 2.83-4.56 5.44-12.89 14.83-9.14 3.75 1.5 4.37-1.26 3.84-5-1.1-7.79 3.72-11.95 10.67-10.89 6.51 1 8.41 5.76 6.51 13.03-1.81 6.93-4.33 12.06-11.12 14.76-6.74 2.68-10.74 8.7-15.76 13.44-5.51 5.21-11.88 8.49-18.03 9.68zm-47.14 105.89c1.13 2.84 3.61 4.16 6.06 5.63 2.13 1.28 3.98 3.12 2.45 5.93-1.29 2.37-3.49 2.87-6.16 2.8-15.3-.41-18.32 3.29-14.67 17.61-3.13 5.68-7.85 3.39-12.3 2.46-.86-13.22-8.79-23.41-14.76-34.45-.39-3.58.78-6.78 2.46-9.84 13.79-2.32 23.99 8.86 36.9 9.84h.01z\" class=\"L\"/><path d=\"M839.21 272.13c-12.91-.98-23.11-12.16-36.9-9.84-3.14-4.8-1.2-7.94 3.69-9 9.75-2.13 15.78-7.98 19.22-17.09 1.92-5.09 4.98-6.86 10.48-4.04 5.18 2.66 6.73 5.9 3.37 10.65-7 9.89-1 19.56.15 29.32zm-39.36 0c5.97 11.03 13.91 21.22 14.76 34.45-4.1 5.33-8.2-.61-12.3 0v-2.46l-8.79-22.69c-2.22-5.94-.83-9.64 6.33-9.3z\" class=\"K\"/><path d=\"M802.31 304.12v2.46c.04 4.21 3.02 5.87 6.09 8.06 12.16 8.67 22.6 2.15 33.28-3.14-7.6 16.45-32.02 17.77-42.92 2.09-2.96-4.26-5.74-8.92-6.29-14.39l9.84 4.92zm-14.76-22.15c-6.58.02-4.2-8.92-9.84-9.84 1.31-6.84-6.86-19.56 6.75-18.77 12.47.72.35 11.62 2.87 17.67 1.31 3.14.23 7.26.23 10.94zm49.21-91.03h6.14c5.36.03 12.04-.19 12.79 6.29.7 6.09-5.69 9.55-10.7 9.84-6.57.38-8.28-5.36-8.22-11.22v-4.91h0zm-36.91 41.82h2.46c.8 0 1.67-.2 2.39.03 4.01 1.28 11.26-3.28 11.52 4.27.2 5.94-5.42 8.3-11.32 7.92-9.94-.63-5.76-7.16-5.05-12.23z\" class=\"L\"/><path d=\"M848.22 169.52l1.22-2.84 14.51-12.6c2.67 2.93 6.62 8.44 2.54 9.58-6.17 1.71-9.51 13.34-18.27 5.87zm25.86-27.37l2.5-2.44 7.08-5.31c4.96 5.55 6.99 10.23-2.95 12.43-4.88 1.08-8.45 6.28-14.26 4.79.09-.7.19-1.4.32-2.09l7.32-7.38zm31.99-31.98l2.42-2.51 7.04-5.17c2.31 8.2-4.95 12.08-8.44 17.37-2.67 4.05-3.81-2.32-6.24-2.67l5.21-7.02z\" class=\"K\"/><path d=\"m753.1,279.51v-4.92h7.38v14.76c-6.34-.37-4.66-6.76-7.38-9.84Z\" class=\"L\"/><path d=\"M920.47 97.58l2.54-2.55c2.19 1.49 5.46 1.68 6.35 5.68-4.1 1.93-6.42-.87-8.89-3.12zm-31.95 31.87c.06-.72.16-1.43.3-2.14l7.03-5.14c.48 5.37-1.98 7.78-7.33 7.28z\" class=\"K\"/><g class=\"L\"><path d=\"M792.47 294.28c-3.2-.08-4.84-1.72-4.92-4.92 3.2.08 4.84 1.72 4.92 4.92zm105.8-63.96c-.01 12.79-4.37 17.39-16.24 17.16-9.95-.2-20.54-10.89-20.62-20.81-.09-11.19 6.79-18.79 16.67-18.45 13.2.46 20.21 8.13 20.19 22.1zm-56.59 81.18c-10.68 5.29-21.11 11.8-33.28 3.14-3.07-2.19-6.05-3.85-6.09-8.06 4.1-.61 8.2 5.33 12.3 0 4.45.93 9.17 3.22 12.3-2.46 7.61 4.8 12.89.24 18.06-4.55 6.45-5.98 12.75-12.13 21.31-15.13v7.38c-3.55 0-6.01 1.65-7.38 4.92-6.87 1.33-10.97 5.43-12.3 12.3-2.03.05-3.86.47-4.92 2.46z\"/><path d=\"m866.28,291.81v-7.38h7.38c-.22,4.7-2.68,7.16-7.38,7.38Z\"/></g><g class=\"O\"><path d=\"M920.48 473.99c-4.12-.64-5.87-3.98-7.91-6.98l1.77-2.12 5.8 2.03-.07-.06c-1.06 2.44 2.9 4.6.4 7.13zm19.71 19.69c-1.91.14-2.8-.75-2.67-2.67 3.01-1.23 3.85-.29 2.67 2.67z\"/><path d=\"m937.73,491.23c-1.91.14-2.8-.76-2.67-2.67,2.97-1.19,3.86-.3,2.67,2.67Z\"/><path d=\"m935.27,488.77c-1.86.08-2.82-.74-2.67-2.67,2.98-1.19,3.9-.33,2.67,2.67Z\"/><path d=\"m932.81,486.3c-1.98.2-2.79-.76-2.67-2.66,3-1.23,3.89-.34,2.67,2.66Z\"/><path d=\"m930.35,483.84c-1.91.13-2.82-.73-2.66-2.67,3-1.23,3.87-.31,2.66,2.67Z\"/><path d=\"m927.89,481.38c-1.92.15-2.81-.75-2.67-2.67,2.99-1.21,3.87-.32,2.67,2.67Z\"/><path d=\"m925.43,478.92c-1.93.15-2.8-.76-2.67-2.67,2.95-1.17,3.85-.29,2.67,2.67Z\"/><path d=\"m922.97,476.46c-1.9.12-2.88-.68-2.66-2.67,2.95-1.17,3.85-.29,2.66,2.67Z\"/></g><path d=\"m930.1,170.8c-1.74.23-3.4-.03-3.69-2.03-.35-2.45,1.48-3.74,3.44-4.3,2-.58,4.4-.43,4.29,2.46-.08,2.18-1.86,3.44-4.04,3.87Z\" class=\"K\"/><path d=\"M922.87 235.22c-.22 5-3.8 4.96-7.38 4.92 1.37-3.27 3.83-4.92 7.38-4.92zm-36.91 36.91c-.08 3.2-1.72 4.84-4.92 4.92.08-3.2 1.72-4.84 4.92-4.92z\" class=\"L\"/><g class=\"M\"><path d=\"M561.21 449.29l2.45-2.42 8.04-6.69 2.17 2.08c-12.3 13.95-25.53 26.98-39.37 39.4l-2.16-2.16 9.19-10.52-.02.02 2.49-2.48-.02.03c6.44-5.05 12.2-10.79 17.22-17.26zM637.43 373l4.98-4.85 5.73-4.42 2.04 2.33-19.66 19.69-2.2-2.2 9.12-10.55zm19.68-19.68c3.18-1.74 5.68-4.17 7.41-7.37l5.82-4.39 1.98 2.29c-5 6.48-10.73 12.24-17.25 17.21l-2.35-1.95 4.39-5.79z\"/><path d=\"M583.37 427.15l2.43-2.43 3.29-1.91 2.04 2.31c-5.03 6.44-10.77 12.17-17.26 17.15l-2.17-2.08 9.2-10.56-.02.02 2.48-2.49zm34.39-34.46l4.96-4.88 5.6-4.27 2.2 2.2-13.67 13.88-1.84-2.33 2.75-4.61zm-6.96 12.73l-13.62 13.85-1.85-2.29 5.26-7.05-.02.01 2.5-2.47-.02.03 5.73-4.4 2.03 2.32zm-89.11 85.7l5.04-7.41 5.61-4.2 2.16 2.16c-4.15 3.32-5.21 10.81-12.81 9.46zm157.63-159.93l2.44-2.43 2.44-2.5 3.3-1.87 2.02 2.3c-2.63 2.92-5.15 5.95-7.93 8.72-1.23 1.23-3.21 3.32-4.63.8-.53-.93 1.5-3.3 2.36-5.01zm220.5 123.29l-7.07-6.99 2.06-2.45 8.61 9.13-3.6.31zm-58.8-58.72l-7.31-7.33 2.04-2.43 7.66 7.66-2.39 2.1zm-19.68-19.69l-7.31-7.33 2.01-2.4 7.66 7.66-2.36 2.07zm36.92 36.89l-7.32-7.33 1.99-2.38 7.63 7.69-2.31 2.02zm-76.28-76.26l-4.85-4.88 1.99-2.36 5.22 5.15-2.37 2.08zm-21.56-22.81c1.79-2.51 3.25.17 4.87.32l1.81 3.2-2.31 2.04c-2.22-1.26-4.64-2.35-4.37-5.56zm38.78 40.03l-4.87-4.85 2.02-2.4 5.17 5.21-2.32 2.04z\"/><path d=\"m755.49,308.96c4.75-1.37,5.97.8,5.07,5.08-3.23-.15-4.92-1.85-5.07-5.08Z\"/><path d=\"M755.33 304.23c.19 1.62 2.83 3.08.3 4.86-3.24.32-4.17-2.3-5.56-4.35l1.99-2.36 3.26 1.85zm-12.77-6.86l-4.82-4.96 2.15-2.21 5.07 5.05-2.41 2.12zm137.83 137.76l-4.84-4.89 2.01-2.31 5.21 5.11-2.37 2.09zm-283.22-15.85l-3.61 3.31-2.3-1.98 4.06-3.62 1.85 2.29zm19.67-19.64l-3.6 3.27-2.3-1.98 4.06-3.62 1.84 2.33zm53.5-58.07c1.22-1.29 2.64-4.08 4.19-2.64 2.47 2.3-.49 3.66-2.2 4.93l-1.98-2.29zm104.28-12.24l-2.42-2.48 2.16-2.19 2.46 2.46-2.19 2.21z\"/><path d=\"M777.13 331.82l-2.51-2.48 2.19-2.21 2.3 2.34-1.99 2.36zm7.34 7.35l-2.49-2.48 2.36-2.08 2.34 2.34-2.21 2.22z\"/><path d=\"M786.94 341.62l-2.48-2.45 2.21-2.22 2.45 2.47-2.19 2.2zm-14.74-14.76l-2.47-2.45 2.17-2.2 2.46 2.46-2.16 2.19z\"/><path d=\"M789.4 344.08l-2.46-2.46 2.19-2.2 2.46 2.46-2.18 2.2zm-97.43-19.92l-2.44 2.53-2.02-2.3 2.17-2.18 2.29 1.95z\"/><path d=\"M791.86 346.55l-2.46-2.47 2.18-2.2 2.46 2.46-2.19 2.2z\"/><path d=\"M794.34 349.06l-2.48-2.52 2.18-2.2 2.31 2.32-2.02 2.4zm-24.61-24.65l-2.46-2.46 2.17-2.2 2.46 2.46-2.17 2.2zm31.94 32l-2.47-2.49 2.32-2.04 2.36 2.32-2.21 2.21z\"/><path d=\"M767.26 321.95l-2.48-2.5 2.31-2.04 2.34 2.34-2.17 2.2zm36.92 36.88l-2.5-2.42 2.2-2.21 2.46 2.46-2.17 2.18z\"/><path d=\"M806.65 361.28l-2.47-2.45 2.16-2.18 2.46 2.46-2.16 2.17zm-151.58-.21l-2.48 2.48-2.13-2.13 2.26-2.3 2.35 1.95z\"/><path d=\"M809.09 363.76l-2.44-2.48 2.16-2.17 2.46 2.46-2.18 2.19zm-156.5-.22l-2.42 2.52-2.04-2.33 2.33-2.32 2.13 2.13z\"/><path d=\"M811.54 366.23l-2.46-2.47 2.18-2.19 2.47 2.45-2.18 2.2z\"/><path d=\"M814.03 368.74l-2.49-2.51 2.18-2.2 2.31 2.31-2.01 2.4zm-63.96-64l-2.48-2.49 2.16-2.19 2.31 2.32-1.99 2.36zm73.8 73.77l-2.53-2.44 2.36-2.07 2.33 2.33-2.17 2.18z\"/><path d=\"M826.33 380.97l-2.46-2.46 2.17-2.18 2.46 2.46-2.17 2.18z\"/><path d=\"M828.76 383.45l-2.43-2.48 2.16-2.18 2.46 2.46-2.19 2.2z\"/><path d=\"M831.2 385.94l-2.44-2.48 2.19-2.2 2.46 2.46-2.21 2.23z\"/><path d=\"M833.71 388.43l-2.51-2.49 2.21-2.22 2.34 2.29-2.04 2.43zm39.33 39.32l-2.45-2.46 2.19-2.22 2.46 2.46-2.2 2.21zm-29.49-29.55l-2.53-2.44 2.39-2.1 2.3 2.37-2.16 2.17zm-95.95-95.95l-2.47-2.46 2.18-2.19 2.44 2.45-2.16 2.19z\"/><path d=\"M846 400.66l-2.45-2.46 2.15-2.17 2.47 2.45-2.17 2.18z\"/><path d=\"M848.45 403.14l-2.45-2.48 2.17-2.18 2.46 2.46-2.18 2.2zm-235.21-.24l-2.45 2.52-2.03-2.31 2.17-2.19 2.3 1.98z\"/><path d=\"M850.95 405.63l-2.5-2.49 2.18-2.2 2.31 2.31-1.99 2.38zm9.78 9.83l-2.46-2.5 2.31-2.02 2.36 2.31-2.2 2.2z\"/><path d=\"M863.23 417.88l-2.5-2.42 2.2-2.2 2.47 2.45-2.16 2.18zM745.13 299.8l-2.56-2.42 2.41-2.12 2.34 2.35-2.18 2.19z\"/><path d=\"M865.68 420.35l-2.44-2.47 2.16-2.18 2.47 2.45-2.18 2.2z\"/><path d=\"M868.14 422.81l-2.46-2.46 2.18-2.2 2.46 2.46-2.18 2.2z\"/></g><g class=\"O\"><path d=\"M912.57 467.02l-2.45-2.52 1.9-1.93 2.31 2.33-1.77 2.12z\"/><path d=\"M910.13 464.5l-2.49-2.43 1.93-1.96 2.46 2.46-1.9 1.93z\"/><path d=\"M907.64 462.07l-2.46-2.46 1.94-1.97 2.46 2.46-1.93 1.96z\"/><path d=\"M905.17 459.61l-2.47-2.48 2.03-1.89 2.38 2.4-1.94 1.97z\"/><path d=\"M899.82 454.48l3.6-.31c.68.06 1.12.41 1.31 1.07l-2.03 1.89-2.88-2.66z\"/></g><g class=\"M\"><path d=\"M593.56 422.59l-2.43 2.53-2.04-2.31 2.17-2.2 2.3 1.98zm299.19 24.9l-2.47-2.5 2.15-2.19 2.38 2.25-2.06 2.45z\"/><path d=\"M890.28 444.98l-2.45-2.47 2.16-2.2 2.44 2.48-2.15 2.19zM870.6 425.3l-2.46-2.48 2.18-2.2 2.46 2.46-2.19 2.22z\"/><path d=\"M887.84 442.51l-2.46-2.46 2.16-2.2 2.46 2.46-2.16 2.2z\"/><path d=\"M885.38 440.05l-2.44-2.48 2.16-2.19 2.44 2.48-2.16 2.2z\"/><path d=\"M882.93 437.56l-2.55-2.44 2.37-2.09 2.34 2.33-2.16 2.19zm-7.39-7.33l-2.5-2.48 2.2-2.21 2.31 2.39-2.01 2.31z\"/></g><path d=\"M747.31 297.6l-2.34-2.35-5.07-5.05-4.11-5.77c6.45.74 12.36-.38 17.31-4.92 2.72 3.08 1.04 9.47 7.38 9.84-.28 5.46-1.22 10.69-5.15 14.88l-3.26-1.85-2.31-2.32-2.44-2.45z\" class=\"L\"/><g class=\"K\"><path d=\"M689.68 322.2l-2.17 2.18-3.3 1.87c-.11-8.31 2.96-13.44 12.3-12.3l-6.83 8.24zm9.3-10.68l2.55-2.51-2.55 2.51zM580.9 429.62l-9.2 10.56-8.04 6.69c.23-14.66 1.9-16.34 17.24-17.25zm-48.55 49.89l-5.61 4.2c-2.21-12.09 2.81-16.91 14.8-14.72l-9.19 10.52zm78.59-78.59l-2.17 2.19-5.73 4.4c-1.77-11.57 3.09-16.55 14.72-14.81l-2.75 4.61-4.06 3.62zm-49.73 48.37c-5.02 6.47-10.78 12.21-17.22 17.26.23-11.25 6-16.97 17.22-17.26zm30.05-28.68l-2.17 2.2-3.29 1.91c-1.24-11.09 5.23-14.48 14.78-14.78l-5.26 7.05-4.06 3.62zm37.05-37.06l-5.6 4.27c-2.07-11.87 5.17-14.48 14.72-14.82l-9.12 10.55zm22.15-22.14l-2.33 2.32-5.73 4.42c.38-9.43 5.31-14.34 14.71-14.83l-4.39 5.79-2.26 2.3z\"/><path d=\"M684.21 326.27l-2.44 2.5 2.44-2.5zm-140.2 140.26l-2.49 2.48 2.49-2.48zm39.36-39.38l-2.48 2.49 2.48-2.49zm19.69-19.67l-2.5 2.47 2.5-2.47z\"/></g><path d=\"m305.07,350.96c6.77,1.76,11.24,2.73,12.09,8.18.26,1.63-.68,3.63-2.53,3.4-5.67-.72-6.82-5.45-9.56-11.58Z\" class=\"N\"/><path d=\"M877.55 427.93l-2.31-2.39-2.46-2.46-2.46-2.46-2.46-2.46-2.47-2.46-2.47-2.45-2.36-2.32-7.63-7.69-2.31-2.31-2.46-2.46-2.47-2.45-2.3-2.37-7.66-7.66-2.34-2.29-2.46-2.46-2.46-2.46-2.46-2.46-2.33-2.33-7.66-7.66-2.31-2.31-2.47-2.45-2.46-2.46-2.46-2.46-2.46-2.46-2.36-2.32-5.17-5.21-2.31-2.32-2.46-2.46-2.46-2.46-2.45-2.47-2.34-2.34-5.22-5.15-2.3-2.34-2.46-2.46-2.46-2.46-2.46-2.46-2.34-2.34-1.81-3.2c7.45-4.9 12.95-4.49 14.97 5.48.24 1.19.37 3.02 1.13 3.39 13.06 6.35 18.41 21.46 31.32 27.67 3.91 1.88 5.34 4.72 6.95 7.89 3.01 5.91 5.72 11.98 13.78 12.24 1.11.03 3.09.86 3.15 1.48 1.65 15.78 18.21 19.02 26.16 30 7.48 10.33 16.46 22.66 29.94 28.19 3.88 1.59 5.33 4.58 6.6 8.17 1.37 3.89 3.3 8.54 7.33 9.34 10.87 2.16 12.53 10.09 13.52 18.87l-5.8-2.03-2.31-2.33-2.46-2.46-2.46-2.46-2.38-2.4c-.19-.66-.62-1.01-1.3-1.07l-8.61-9.13-2.38-2.25-2.44-2.48-2.46-2.46-2.44-2.48-2.34-2.33-5.21-5.11zM846.6 309.04c1.33-6.87 5.43-10.97 12.3-12.3-1.33 6.87-5.43 10.97-12.3 12.3z\" class=\"L\"/></g>";
        private double widthPx = 1000;
        private double heightPx = 1000;

        /// <summary>
        /// Keeps track of planets in a sign box so that stack nicely
        /// </summary>
        private Dictionary<HouseName, int> ChartOccupiedMarker { get; set; } =
            new Dictionary<HouseName, int>()
            {
                { HouseName.House1, 0 },
                {HouseName.House2, 0 },
                { HouseName.House3, 0 },
                { HouseName.House4, 0 },
                { HouseName.House5, 0 },
                { HouseName.House6, 0 },
                { HouseName.House7, 0 },
                { HouseName.House8, 0 },
                { HouseName.House9, 0 },
                { HouseName.House10, 0 },
                { HouseName.House11, 0 },
                { HouseName.House12, 0 },
            };

        private Dictionary<HouseName, dynamic> ChartSignCoordinates { get; set; } =
            new Dictionary<HouseName, dynamic>()
            {
                { HouseName.House1, new { xAxis = 475, yAxis = 150 } },
                { HouseName.House2, new { xAxis = 250, yAxis = 100 } },
                { HouseName.House3, new { xAxis = 100, yAxis = 200 } },
                { HouseName.House4, new { xAxis = 250, yAxis = 400 } },
                { HouseName.House5, new { xAxis = 100, yAxis = 620 } },
                { HouseName.House6, new { xAxis = 250, yAxis = 825 } },
                { HouseName.House7, new { xAxis = 475, yAxis = 600 } },
                { HouseName.House8, new { xAxis = 675, yAxis = 825 } },
                { HouseName.House9, new { xAxis = 840, yAxis = 620 } },
                { HouseName.House10, new { xAxis = 675, yAxis = 400 } },
                { HouseName.House11, new { xAxis = 840, yAxis = 200 } },
                { HouseName.House12, new { xAxis = 675, yAxis = 100 } },
            };



        public NorthChartFactory(Time time, ChartType chartType)
        {
            //save for later
            ChartType = chartType;
            Time = time;

            //generate SVG chart based on given data
            SVGChart = GenerateChart();
        }


        /// <summary>
        /// Sweet heart takes this away!
        /// Basically generating 1 frame
        /// </summary>
        private string GenerateChart()
        {
            //PART I : declare the components
            string svgHead = null;
            string svgTail = null;
            string border = null;
            string contentTail = null;
            string content = null;
            string Planets = null;
            string signRuler = null;
            string houseRuler = null;
            string zodiacRuler = null;
            string dateTimeLocation = null;
            string locationHeader = null;



            //PART II : fill the components in order
            GenerateComponents();



            //PART III : compile in right placement
            var final =
                $@" <!--MADE BY MACHINES FOR HUMAN EYES-->
                    {svgHead}
                        {StaticBackgroundLayer}
                        {Planets}
                    {svgTail}
                ";


            return final;




            //------------------------LOCALS NEEDED FOR REFS

            async void GenerateComponents()
            {
                //STEP 0: RESET
                foreach (var house in House.AllHouses) { ChartOccupiedMarker[house] = 0; }

                //STEP 1: USER INPUT > USABLE DATA
                var svgBackgroundColor = "#f0f2f5"; //not bleach white
                var randomId = Tools.GenerateId();

                Planets = GetPlanetsPositionLayer(this.Time);


                //note: if width & height not hard set, parent div clips it
                var svgTotalHeight = heightPx;
                var svgTotalWidth = widthPx;
                var svgStyle = $@"background:{svgBackgroundColor};";//end of style tag
                svgHead = $"<svg viewBox=\"0 0 {svgTotalWidth} {svgTotalHeight}\" width=\"{svgTotalWidth}px\" height=\"{svgTotalHeight}px\" style=\"{svgStyle}\" class=\"SkyChartHolder\" id=\"{randomId}\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">";//much needed for use tags to work

                svgTail = "</svg>";

            }

        }

        private string GetPlanetsPositionLayer(Time time)
        {
            var compiled = "";


            Dictionary<PlanetName, ZodiacSign> allPlanetsSigns = new Dictionary<PlanetName, ZodiacSign>();

            switch (this.ChartType)
            {
                case ChartType.Bhava:
                    allPlanetsSigns = Calculate.AllPlanetSignsBasedOnHouseLongitudes(time); break;
                case ChartType.RasiD1:
                    allPlanetsSigns = Calculate.AllPlanetZodiacSigns(time); break;
                case ChartType.HoraD2:
                    allPlanetsSigns = Calculate.AllPlanetHoraSign(time); break;
                case ChartType.DrekkanaD3:
                    allPlanetsSigns = Calculate.AllPlanetDrekkanaSign(time); break;
                case ChartType.ChaturthamshaD4:
                    allPlanetsSigns = Calculate.AllPlanetChaturthamsaSign(time); break;
                case ChartType.SaptamshaD7:
                    allPlanetsSigns = Calculate.AllPlanetSaptamshaSign(time); break;
                case ChartType.NavamshaD9:
                    allPlanetsSigns = Calculate.AllPlanetNavamshaSign(time); break;
                case ChartType.DashamamshaD10:
                    allPlanetsSigns = Calculate.AllPlanetDashamamshaSign(time); break;
                case ChartType.DwadashamshaD12:
                    allPlanetsSigns = Calculate.AllPlanetDwadashamshaSign(time); break;
                case ChartType.ShodashamshaD16:
                    allPlanetsSigns = Calculate.AllPlanetShodashamshaSign(time); break;
                case ChartType.VimshamshaD20:
                    allPlanetsSigns = Calculate.AllPlanetVimshamshaSign(time); break;
                case ChartType.ChaturvimshamshaD24:
                    allPlanetsSigns = Calculate.AllPlanetChaturvimshamshaSign(time); break;
                case ChartType.BhamshaD27:
                    allPlanetsSigns = Calculate.AllPlanetBhamshaSign(time); break;
                case ChartType.TrimshamshaD30:
                    allPlanetsSigns = Calculate.AllPlanetTrimshamshaSign(time); break;
                case ChartType.KhavedamshaD40:
                    allPlanetsSigns = Calculate.AllPlanetKhavedamshaSign(time); break;
                case ChartType.AkshavedamshaD45:
                    allPlanetsSigns = Calculate.AllPlanetAkshavedamshaSign(time); break;
                case ChartType.ShashtyamshaD60:
                    allPlanetsSigns = Calculate.AllPlanetShashtyamshaSign(time); break;
                default:
                    break;
            }



            foreach (var data in allPlanetsSigns)
            {
                var zodiacSign = data.Value;
                var coordinates = GetPositionForHouseBasedOnSign(zodiacSign);
                var xx = $"<text  transform=\"matrix(1 0 0 1 {coordinates.xAxis} {coordinates.yAxis})\" font-size=\"35\" fill=\"black\">{data.Key}</text>";
                compiled += xx;
            }

            var finalGroup = $@"<g id=""PlanetLayer"">{compiled}</g>";

            return finalGroup;
        }

        /// <summary>
        /// Based on chart type will get position of house based on rasi, hora, etc...
        /// </summary>
        private dynamic GetPositionForHouseBasedOnSign(ZodiacSign zodiacSign)
        {
            //get the house at given sign based on chart type
            Dictionary<HouseName, ZodiacSign> allHousesSigns = new Dictionary<HouseName, ZodiacSign>();

            switch (this.ChartType)
            {
                case ChartType.Bhava:
                case ChartType.RasiD1:
                    allHousesSigns = Calculate.AllHouseZodiacSigns(this.Time); break;
                case ChartType.HoraD2:
                    allHousesSigns = Calculate.AllHouseHoraSign(this.Time); break;
                case ChartType.DrekkanaD3:
                    allHousesSigns = Calculate.AllHouseDrekkanaSign(this.Time); break;
                case ChartType.ChaturthamshaD4:
                    allHousesSigns = Calculate.AllHouseChaturthamsaSign(this.Time); break;
                case ChartType.SaptamshaD7:
                    allHousesSigns = Calculate.AllHouseSaptamshaSign(this.Time); break;
                case ChartType.NavamshaD9:
                    allHousesSigns = Calculate.AllHouseNavamshaSign(this.Time); break;
                case ChartType.DashamamshaD10:
                    allHousesSigns = Calculate.AllHouseDashamamshaSign(this.Time); break;
                case ChartType.DwadashamshaD12:
                    allHousesSigns = Calculate.AllHouseDwadashamshaSign(this.Time); break;
                case ChartType.ShodashamshaD16:
                    allHousesSigns = Calculate.AllHouseShodashamshaSign(this.Time); break;
                case ChartType.VimshamshaD20:
                    allHousesSigns = Calculate.AllHouseVimshamshaSign(this.Time); break;
                case ChartType.ChaturvimshamshaD24:
                    allHousesSigns = Calculate.AllHouseChaturvimshamshaSign(this.Time); break;
                case ChartType.BhamshaD27:
                    allHousesSigns = Calculate.AllHouseBhamshaSign(this.Time); break;
                case ChartType.TrimshamshaD30:
                    allHousesSigns = Calculate.AllHouseTrimshamshaSign(this.Time); break;
                case ChartType.KhavedamshaD40:
                    allHousesSigns = Calculate.AllHouseKhavedamshaSign(this.Time); break;
                case ChartType.AkshavedamshaD45:
                    allHousesSigns = Calculate.AllHouseAkshavedamshaSign(this.Time); break;
                case ChartType.ShashtyamshaD60:
                    allHousesSigns = Calculate.AllHouseShashtyamshaSign(this.Time); break;
                default:
                    break;
            }

            //find the house based on given sign
            var house = allHousesSigns.First(data => data.Value.GetSignName() == zodiacSign.GetSignName()).Key;

            //using house get position in chart
            var positionData = GetPositionForHouse(house);

            return positionData;
        }

        /// <summary>
        /// Given a house name will return x & y for start of house
        /// </summary>
        private dynamic GetPositionForHouse(HouseName houseName)
        {
            var xAxis = 0;
            var yAxis = 0;

            //check if occupancy number
            var occupancy = ChartOccupiedMarker[houseName];
            var jumpCount = occupancy * 45;

            //increment for next check
            ChartOccupiedMarker[houseName]++;

            //get the coordinates
            xAxis = ChartSignCoordinates[houseName].xAxis;
            yAxis = ChartSignCoordinates[houseName].yAxis + jumpCount; //if any will go next row


            return new { xAxis = xAxis, yAxis = yAxis };
        }


    }

}
