﻿namespace VedAstro.Library;
/// <summary>
/// For use in websites
/// </summary>
public enum SimpleAyanamsa
{
    /// <summary>
    ///
    /// </summary>
    LahiriChitrapaksha = 1,

    /// <summary>
    /// Krishnamurti: This is another popular ayanamsa in Vedic astrology, especially among the followers of the Krishnamurti Paddhati (KP) system. It is based on the position of the star Ashwini at 0 degrees Aries, as proposed by K.S. Krishnamurti.
    /// It is also known as KP Ayanamsa, and it has been widely
    /// used for horary astrology and stellar astrology
    /// </summary>
    KrishnamurtiKP = 5,
    /// <summary>
    /// This is a well-known ayanamsa in Vedic astrology, especially among the followers of B.V. Raman. It is based on the position of the star Revati at 0 degrees Pisces, as suggested by B.V. Raman.
    /// It is also known as Revati Paksha Ayanamsa,
    /// and it has been used for natal astrology and mundane astrology
    /// </summary>
    Raman = 3,
    /// <summary>
    /// This is a prominent ayanamsa in Western sidereal astrology, especially among the followers of Cyril Fagan and Donald Bradley. It is based on the position of the star Aldebaran at 15 degrees Taurus, as advocated by Cyril Fagan.
    /// It is also known as Aldebaran 15 Tau Ayanamsa,
    /// and it has been used for tropical-sidereal conversion
    /// and zodiacal releasing.
    /// </summary>
    FaganBradley = 0,

    /// <summary>
    /// J2000: This is a standard ayanamsa in modern astronomy,
    /// especially for celestial coordinate systems. It is based on the position of the vernal equinox at 0 degrees Aries at noon on January 1st, 2000 (J2000 epoch).
    /// It is also known as J2000 Equinox Ayanamsa,
    /// and it has been used for astronomical calculations
    /// and observations.
    /// </summary>
    J2000 = 18,
    /// <summary>
    /// Yukteshwar: This is a spiritual ayanamsa in Vedic astrology, especially for
    /// Yogananda's teachings. It is based on the position of the star Dhanishta at 0 degrees Aquarius,
    /// as proposed by Sri Yukteshwar.
    /// It is also known as Dhanishta Paksha Ayanamsa,
    /// and it has been used for esoteric astrology and cosmic cycles.
    /// </summary>
    Yukteshwar = 7,

}