﻿namespace VedAstro.Library
{
    /// <summary>
    /// Names of the Vedic Lunar Months in order
    ///
    /// The Month11 take their names from the fact that on
    /// the full Moon day of each month, a particular constellation
    /// falls and the month is named after it. Thus in
    /// Chitram on the full Moon day we find the constellation Chitta.
    /// </summary>
    public enum LunarMonth
    {
        Empty = 0,
        /// <summary>
        /// Chitta, Chitram
        /// </summary>
        Chaitra,

        /// <summary>
        /// Visakha
        /// </summary>
        Vaisaakha,

        /// <summary>
        /// Jaista
        /// </summary>
        Jyeshtha,

        /// <summary>
        /// Poorvashadha
        /// </summary>
        Aashaadha,

        /// <summary>
        /// Sravana
        /// </summary>
        Sraavana,

        /// <summary>
        /// Poorvabhadra
        /// </summary>
        Bhaadrapada,

        /// <summary>
        /// Aswini
        /// </summary>
        Aaswayuja,

        /// <summary>
        /// Krithika
        /// </summary>
        Kaarteeka,

        /// <summary>
        /// Mrigasira
        /// </summary>
        Maargasira,

        /// <summary>
        /// Pooshiami
        /// </summary>
        Pushya,

        /// <summary>
        /// Makha
        /// </summary>
        Maagha,

        /// <summary>
        /// Phoobba
        /// </summary>
        Phaalguna,

        /// <summary>
        /// Chitta, Chitram
        /// </summary>
        ChaitraAdhika,

        /// <summary>
        /// Visakha
        /// </summary>
        VaisaakhaAdhika,

        /// <summary>
        /// Jaista
        /// </summary>
        JyeshthaAdhika,

        /// <summary>
        /// Poorvashadha
        /// </summary>
        AashaadhaAdhika,

        /// <summary>
        /// Sravana
        /// </summary>
        SraavanaAdhika,

        /// <summary>
        /// Poorvabhadra
        /// </summary>
        BhaadrapadaAdhika,

        /// <summary>
        /// Aswini
        /// </summary>
        AaswayujaAdhika,

        /// <summary>
        /// Krithika
        /// </summary>
        KaarteekaAdhika,

        /// <summary>
        /// Mrigasira
        /// </summary>
        MaargasiraAdhika,

        /// <summary>
        /// Pooshiami
        /// </summary>
        PushyaAdhika,

        /// <summary>
        /// Makha
        /// </summary>
        MaaghaAdhika,

        /// <summary>
        /// Phoobba
        /// </summary>
        PhaalgunaAdhika,


    }

}
